/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.internal.resource.transfer;

import java.io.IOException;
import java.net.URI;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicInteger;
import javax.annotation.Nullable;
import org.gradle.internal.resource.ReadableContent;
import org.gradle.internal.resource.metadata.ExternalResourceMetaData;
import org.gradle.internal.resource.transfer.ExternalResourceAccessor;
import org.gradle.internal.resource.transfer.ExternalResourceConnector;
import org.gradle.internal.resource.transfer.ExternalResourceLister;
import org.gradle.internal.resource.transfer.ExternalResourceReadResponse;
import org.gradle.internal.resource.transfer.ExternalResourceUploader;

public class DefaultExternalResourceConnector
implements ExternalResourceConnector {
    private static final String SYSPROP_KEY = "gradle.externalresources.recordstats";
    private static final ExternalResourceAccessStats.Mode STATS_MODE = ExternalResourceAccessStats.Mode.valueOf(System.getProperty("gradle.externalresources.recordstats", "none"));
    private static final ExternalResourceAccessStats STATS = STATS_MODE.create();
    private final ExternalResourceAccessor accessor;
    private final ExternalResourceLister lister;
    private final ExternalResourceUploader uploader;

    public DefaultExternalResourceConnector(ExternalResourceAccessor accessor, ExternalResourceLister lister, ExternalResourceUploader uploader) {
        this.accessor = accessor;
        this.lister = lister;
        this.uploader = uploader;
    }

    public static ExternalResourceAccessStats getStatistics() {
        return STATS;
    }

    @Override
    @Nullable
    public ExternalResourceReadResponse openResource(URI location, boolean revalidate) {
        STATS.resource(location);
        return this.accessor.openResource(location, revalidate);
    }

    @Override
    @Nullable
    public ExternalResourceMetaData getMetaData(URI location, boolean revalidate) {
        STATS.metadata(location);
        return this.accessor.getMetaData(location, revalidate);
    }

    @Override
    @Nullable
    public List<String> list(URI parent) {
        STATS.list(parent);
        return this.lister.list(parent);
    }

    @Override
    public void upload(ReadableContent resource, URI destination) throws IOException {
        STATS.upload(destination);
        this.uploader.upload(resource, destination);
    }

    private static class MemoizingStats
    extends CountingStats {
        private final Map<URI, Integer> resources = new HashMap<URI, Integer>();
        private final Map<URI, Integer> metadata = new HashMap<URI, Integer>();
        private final Map<URI, Integer> lists = new HashMap<URI, Integer>();
        private final Map<URI, Integer> uploads = new HashMap<URI, Integer>();

        private MemoizingStats() {
        }

        private synchronized void record(Map<URI, Integer> container, URI uri) {
            Integer count = container.get(uri);
            if (count == null) {
                container.put(uri, 1);
            } else {
                container.put(uri, count + 1);
            }
        }

        @Override
        public void list(URI parent) {
            this.record(this.lists, parent);
            super.list(parent);
        }

        @Override
        public void metadata(URI location) {
            this.record(this.metadata, location);
            super.metadata(location);
        }

        @Override
        public void resource(URI location) {
            this.record(this.resources, location);
            super.resource(location);
        }

        @Override
        public void upload(URI destination) {
            this.record(this.uploads, destination);
            super.upload(destination);
        }

        @Override
        public synchronized void reset() {
            super.reset();
            this.resources.clear();
            this.metadata.clear();
            this.lists.clear();
            this.uploads.clear();
        }

        @Override
        public String toString() {
            StringBuilder sb = new StringBuilder(super.toString());
            this.statsFor("fetched resources", this.resources, sb, 10);
            this.statsFor("fetched metadata", this.metadata, sb, 10);
            this.statsFor("lists queries", this.lists, sb, 10);
            this.statsFor("uploaded URIs", this.uploads, sb, 10);
            return sb.toString();
        }

        private void statsFor(String label, Map<URI, Integer> stats, StringBuilder sb, int max) {
            if (stats.isEmpty()) {
                return;
            }
            ArrayList<Map.Entry<URI, Integer>> entries = new ArrayList<Map.Entry<URI, Integer>>(stats.entrySet());
            Collections.sort(entries, new Comparator<Map.Entry<URI, Integer>>(){

                @Override
                public int compare(Map.Entry<URI, Integer> o1, Map.Entry<URI, Integer> o2) {
                    return o2.getValue() - o1.getValue();
                }
            });
            sb.append("Top ").append(max).append(" most ").append(label).append("\n");
            int cpt = 0;
            for (Map.Entry entry : entries) {
                sb.append("   ").append(entry.getKey()).append(" (").append(entry.getValue()).append(" times)\n");
                if (++cpt != max) continue;
                break;
            }
        }
    }

    private static class CountingStats
    implements ExternalResourceAccessStats {
        private final AtomicInteger resourceCount = new AtomicInteger();
        private final AtomicInteger metadataCount = new AtomicInteger();
        private final AtomicInteger listCount = new AtomicInteger();
        private final AtomicInteger uploadCount = new AtomicInteger();

        private CountingStats() {
        }

        @Override
        public void resource(URI location) {
            this.resourceCount.incrementAndGet();
        }

        @Override
        public void metadata(URI location) {
            this.metadataCount.incrementAndGet();
        }

        @Override
        public void list(URI parent) {
            this.listCount.incrementAndGet();
        }

        @Override
        public void upload(URI destination) {
            this.uploadCount.incrementAndGet();
        }

        @Override
        public synchronized void reset() {
            this.resourceCount.set(0);
            this.metadataCount.set(0);
            this.listCount.set(0);
            this.uploadCount.set(0);
        }

        public String toString() {
            StringBuilder sb = new StringBuilder("External resources connector statistics: \n");
            sb.append("   - Resources fetched : ").append(this.resourceCount.get()).append("\n");
            sb.append("   - Metadata fetched  : ").append(this.metadataCount.get()).append("\n");
            sb.append("   - Lists             : ").append(this.listCount.get()).append("\n");
            sb.append("   - Uploads           : ").append(this.uploadCount.get()).append("\n");
            return sb.toString();
        }
    }

    private static class NoOpStats
    implements ExternalResourceAccessStats {
        public static final NoOpStats INSTANCE = new NoOpStats();

        private NoOpStats() {
        }

        @Override
        public void resource(URI location) {
        }

        @Override
        public void metadata(URI location) {
        }

        @Override
        public void list(URI parent) {
        }

        @Override
        public void upload(URI destination) {
        }

        @Override
        public void reset() {
        }

        public String toString() {
            return "External resources access stats are not recorded. Run Gradle with -Dgradle.externalresources.recordstats=(count|trace) to record statistics";
        }
    }

    public static interface ExternalResourceAccessStats {
        public void resource(URI var1);

        public void metadata(URI var1);

        public void list(URI var1);

        public void upload(URI var1);

        public void reset();

        public static enum Mode {
            none,
            count,
            trace;


            public ExternalResourceAccessStats create() {
                switch (this) {
                    case none: {
                        return NoOpStats.INSTANCE;
                    }
                    case count: {
                        return new CountingStats();
                    }
                    case trace: {
                        return new MemoizingStats();
                    }
                }
                throw new UnsupportedOperationException();
            }
        }
    }
}

