/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.tooling.internal.provider;

import java.io.InputStream;
import java.util.concurrent.ExecutorService;
import java.util.function.Supplier;
import org.gradle.api.execution.internal.TaskInputsListener;
import org.gradle.api.execution.internal.TaskInputsListeners;
import org.gradle.api.internal.file.FileCollectionInternal;
import org.gradle.api.internal.file.FileSystemSubset;
import org.gradle.api.logging.LogLevel;
import org.gradle.deployment.internal.Deployment;
import org.gradle.deployment.internal.DeploymentInternal;
import org.gradle.deployment.internal.DeploymentRegistryInternal;
import org.gradle.execution.CancellableOperationManager;
import org.gradle.execution.DefaultCancellableOperationManager;
import org.gradle.execution.PassThruCancellableOperationManager;
import org.gradle.initialization.BuildCancellationToken;
import org.gradle.initialization.BuildRequestContext;
import org.gradle.initialization.ContinuousExecutionGate;
import org.gradle.initialization.DefaultContinuousExecutionGate;
import org.gradle.internal.buildevents.BuildStartedTime;
import org.gradle.internal.concurrent.ExecutorFactory;
import org.gradle.internal.event.ListenerManager;
import org.gradle.internal.filewatch.DefaultFileWatcherEventListener;
import org.gradle.internal.filewatch.FileSystemChangeWaiter;
import org.gradle.internal.filewatch.FileSystemChangeWaiterFactory;
import org.gradle.internal.filewatch.FileWatcherEventListener;
import org.gradle.internal.filewatch.PendingChangesListener;
import org.gradle.internal.filewatch.SingleFirePendingChangesListener;
import org.gradle.internal.invocation.BuildAction;
import org.gradle.internal.logging.text.StyledTextOutput;
import org.gradle.internal.logging.text.StyledTextOutputFactory;
import org.gradle.internal.os.OperatingSystem;
import org.gradle.internal.service.ServiceRegistry;
import org.gradle.internal.time.Clock;
import org.gradle.launcher.exec.BuildActionExecuter;
import org.gradle.launcher.exec.BuildActionParameters;
import org.gradle.launcher.exec.BuildActionResult;
import org.gradle.util.DisconnectableInputStream;

public class ContinuousBuildActionExecuter
implements BuildActionExecuter<BuildActionParameters> {
    private final BuildActionExecuter<BuildActionParameters> delegate;
    private final TaskInputsListeners inputsListeners;
    private final OperatingSystem operatingSystem;
    private final FileSystemChangeWaiterFactory changeWaiterFactory;
    private final ExecutorFactory executorFactory;
    private final StyledTextOutput logger;

    public ContinuousBuildActionExecuter(BuildActionExecuter<BuildActionParameters> delegate, FileSystemChangeWaiterFactory changeWaiterFactory, TaskInputsListeners inputsListeners, StyledTextOutputFactory styledTextOutputFactory, ExecutorFactory executorFactory) {
        this.delegate = delegate;
        this.inputsListeners = inputsListeners;
        this.operatingSystem = OperatingSystem.current();
        this.executorFactory = executorFactory;
        this.changeWaiterFactory = changeWaiterFactory;
        this.logger = styledTextOutputFactory.create(ContinuousBuildActionExecuter.class, LogLevel.QUIET);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public BuildActionResult execute(BuildAction action, BuildRequestContext requestContext, BuildActionParameters actionParameters, ServiceRegistry buildSessionScopeServices) {
        BuildCancellationToken cancellationToken = requestContext.getCancellationToken();
        if (actionParameters.isContinuous()) {
            DefaultContinuousExecutionGate alwaysOpenExecutionGate = new DefaultContinuousExecutionGate();
            CancellableOperationManager cancellableOperationManager = this.createCancellableOperationManager(requestContext, cancellationToken);
            return this.executeMultipleBuilds(action, requestContext, actionParameters, buildSessionScopeServices, cancellableOperationManager, (ContinuousExecutionGate)alwaysOpenExecutionGate);
        }
        try {
            BuildActionResult buildActionResult = this.delegate.execute(action, requestContext, actionParameters, buildSessionScopeServices);
            return buildActionResult;
        }
        finally {
            CancellableOperationManager cancellableOperationManager = this.createCancellableOperationManager(requestContext, cancellationToken);
            this.waitForDeployments(action, requestContext, actionParameters, buildSessionScopeServices, cancellableOperationManager);
        }
    }

    private CancellableOperationManager createCancellableOperationManager(BuildRequestContext requestContext, BuildCancellationToken cancellationToken) {
        PassThruCancellableOperationManager cancellableOperationManager;
        if (requestContext.isInteractive()) {
            if (!(System.in instanceof DisconnectableInputStream)) {
                System.setIn((InputStream)new DisconnectableInputStream(System.in));
            }
            DisconnectableInputStream inputStream = (DisconnectableInputStream)System.in;
            cancellableOperationManager = new DefaultCancellableOperationManager((ExecutorService)this.executorFactory.create("Cancel signal monitor"), inputStream, cancellationToken);
        } else {
            cancellableOperationManager = new PassThruCancellableOperationManager(cancellationToken);
        }
        return cancellableOperationManager;
    }

    private void waitForDeployments(BuildAction action, BuildRequestContext requestContext, BuildActionParameters actionParameters, ServiceRegistry buildSessionScopeServices, CancellableOperationManager cancellableOperationManager) {
        DeploymentRegistryInternal deploymentRegistry = buildSessionScopeServices.get(DeploymentRegistryInternal.class);
        if (!deploymentRegistry.getRunningDeployments().isEmpty()) {
            for (Deployment deployment : deploymentRegistry.getRunningDeployments()) {
                ((DeploymentInternal)deployment).outOfDate();
            }
            this.logger.println().println((Object)"Reloadable deployment detected. Entering continuous build.");
            this.resetBuildStartedTime(buildSessionScopeServices);
            ContinuousExecutionGate deploymentRequestExecutionGate = deploymentRegistry.getExecutionGate();
            this.executeMultipleBuilds(action, requestContext, actionParameters, buildSessionScopeServices, cancellableOperationManager, deploymentRequestExecutionGate);
        }
        cancellableOperationManager.closeInput();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private BuildActionResult executeMultipleBuilds(BuildAction action, BuildRequestContext requestContext, BuildActionParameters actionParameters, ServiceRegistry buildSessionScopeServices, CancellableOperationManager cancellableOperationManager, ContinuousExecutionGate continuousExecutionGate) {
        BuildActionResult lastResult;
        BuildCancellationToken cancellationToken = requestContext.getCancellationToken();
        while (true) {
            PendingChangesListener pendingChangesListener = (PendingChangesListener)buildSessionScopeServices.get(ListenerManager.class).getBroadcaster(PendingChangesListener.class);
            FileSystemChangeWaiter waiter = this.changeWaiterFactory.createChangeWaiter((PendingChangesListener)new SingleFirePendingChangesListener(pendingChangesListener), cancellationToken, continuousExecutionGate);
            try {
                lastResult = this.executeBuildAndAccumulateInputs(action, requestContext, actionParameters, waiter, buildSessionScopeServices);
                if (!waiter.isWatching()) {
                    this.logger.println().withStyle(StyledTextOutput.Style.Failure).println((Object)"Exiting continuous build as no executed tasks declared file system inputs.");
                    BuildActionResult buildActionResult = lastResult;
                    return buildActionResult;
                }
                cancellableOperationManager.monitorInput(operationToken -> {
                    DefaultFileWatcherEventListener reporter = new DefaultFileWatcherEventListener();
                    waiter.wait(() -> this.logger.println().println((Object)("Waiting for changes to input files of tasks..." + this.determineExitHint(requestContext))), (FileWatcherEventListener)reporter);
                    if (!operationToken.isCancellationRequested()) {
                        reporter.reportChanges(this.logger);
                    }
                });
            }
            finally {
                waiter.stop();
            }
            if (cancellationToken.isCancellationRequested()) break;
            this.logger.println((Object)"Change detected, executing build...").println();
            this.resetBuildStartedTime(buildSessionScopeServices);
        }
        this.logger.println((Object)"Build cancelled.");
        return lastResult;
    }

    private void resetBuildStartedTime(ServiceRegistry buildSessionScopeServices) {
        BuildStartedTime buildStartedTime = buildSessionScopeServices.get(BuildStartedTime.class);
        Clock clock = buildSessionScopeServices.get(Clock.class);
        buildStartedTime.reset(clock.getCurrentTime());
    }

    private String determineExitHint(BuildRequestContext requestContext) {
        if (requestContext.isInteractive()) {
            if (this.operatingSystem.isWindows()) {
                return " (ctrl-d then enter to exit)";
            }
            return " (ctrl-d to exit)";
        }
        return "";
    }

    private BuildActionResult executeBuildAndAccumulateInputs(BuildAction action, BuildRequestContext requestContext, BuildActionParameters actionParameters, FileSystemChangeWaiter waiter, ServiceRegistry buildSessionScopeServices) {
        return this.withTaskInputsListener((task, fileSystemInputs) -> waiter.watch(FileSystemSubset.of((FileCollectionInternal)fileSystemInputs)), () -> this.delegate.execute(action, requestContext, actionParameters, buildSessionScopeServices));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private <T> T withTaskInputsListener(TaskInputsListener listener, Supplier<T> supplier) {
        try {
            this.inputsListeners.addListener(listener);
            T t = supplier.get();
            return t;
        }
        finally {
            this.inputsListeners.removeListener(listener);
        }
    }
}

