/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.plugin.use.resolve.service.internal;

import com.google.common.base.Function;
import com.google.common.base.Joiner;
import com.google.common.collect.Iterables;
import java.io.File;
import org.gradle.api.internal.initialization.ClassLoaderScope;
import org.gradle.api.internal.plugins.DefaultPluginRegistry;
import org.gradle.api.internal.plugins.PluginImplementation;
import org.gradle.api.internal.plugins.PluginInspector;
import org.gradle.api.internal.plugins.PluginRegistry;
import org.gradle.internal.classpath.CachedClasspathTransformer;
import org.gradle.internal.classpath.ClassPath;
import org.gradle.plugin.management.internal.InvalidPluginRequestException;
import org.gradle.plugin.management.internal.PluginRequestInternal;
import org.gradle.plugin.use.PluginId;
import org.gradle.plugin.use.resolve.internal.PluginResolution;
import org.gradle.plugin.use.resolve.internal.PluginResolutionResult;
import org.gradle.plugin.use.resolve.internal.PluginResolveContext;
import org.gradle.plugin.use.resolve.internal.PluginResolver;

public class InjectedClasspathPluginResolver
implements PluginResolver {
    private final ClassPath injectedClasspath;
    private final PluginRegistry pluginRegistry;

    public InjectedClasspathPluginResolver(ClassLoaderScope parentScope, CachedClasspathTransformer classpathTransformer, PluginInspector pluginInspector, ClassPath injectedClasspath) {
        this.injectedClasspath = injectedClasspath;
        ClassPath cachedClassPath = classpathTransformer.transform(injectedClasspath, CachedClasspathTransformer.StandardTransform.BuildLogic);
        this.pluginRegistry = new DefaultPluginRegistry(pluginInspector, parentScope.createChild("injected-plugin").local(cachedClassPath).lock());
    }

    @Override
    public void resolve(PluginRequestInternal pluginRequest, PluginResolutionResult result) throws InvalidPluginRequestException {
        PluginImplementation plugin = this.pluginRegistry.lookup(pluginRequest.getId());
        if (plugin == null) {
            String classpathStr = Joiner.on((String)File.pathSeparator).join(Iterables.transform((Iterable)this.injectedClasspath.getAsFiles(), (Function)new Function<File, String>(){

                public String apply(File input) {
                    return input.getAbsolutePath();
                }
            }));
            result.notFound(this.getDescription(), "classpath: " + classpathStr);
        } else {
            result.found(this.getDescription(), new InjectedClasspathPluginResolution(plugin));
        }
    }

    public String getDescription() {
        return "Gradle TestKit";
    }

    public boolean isClasspathEmpty() {
        return this.injectedClasspath.isEmpty();
    }

    private static class InjectedClasspathPluginResolution
    implements PluginResolution {
        private final PluginImplementation<?> plugin;

        public InjectedClasspathPluginResolution(PluginImplementation<?> plugin) {
            this.plugin = plugin;
        }

        @Override
        public PluginId getPluginId() {
            return this.plugin.getPluginId();
        }

        public void execute(PluginResolveContext pluginResolveContext) {
            pluginResolveContext.addFromDifferentLoader(this.plugin);
        }
    }
}

