/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.tooling.internal.provider.runner;

import com.google.common.collect.Maps;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.gradle.api.internal.TaskInternal;
import org.gradle.api.internal.tasks.execution.ExecuteTaskBuildOperationDetails;
import org.gradle.api.internal.tasks.testing.TestDescriptorInternal;
import org.gradle.api.internal.tasks.testing.operations.ExecuteTestBuildOperationType;
import org.gradle.api.tasks.testing.Test;
import org.gradle.api.tasks.testing.TestResult;
import org.gradle.internal.build.event.BuildEventSubscriptions;
import org.gradle.internal.build.event.types.AbstractTestResult;
import org.gradle.internal.build.event.types.DefaultFailure;
import org.gradle.internal.build.event.types.DefaultTestDescriptor;
import org.gradle.internal.build.event.types.DefaultTestFailureResult;
import org.gradle.internal.build.event.types.DefaultTestFinishedProgressEvent;
import org.gradle.internal.build.event.types.DefaultTestSkippedResult;
import org.gradle.internal.build.event.types.DefaultTestStartedProgressEvent;
import org.gradle.internal.build.event.types.DefaultTestSuccessResult;
import org.gradle.internal.operations.BuildOperationDescriptor;
import org.gradle.internal.operations.BuildOperationListener;
import org.gradle.internal.operations.OperationFinishEvent;
import org.gradle.internal.operations.OperationIdentifier;
import org.gradle.internal.operations.OperationProgressEvent;
import org.gradle.internal.operations.OperationStartEvent;
import org.gradle.tooling.events.OperationType;
import org.gradle.tooling.internal.protocol.events.InternalOperationFinishedProgressEvent;
import org.gradle.tooling.internal.protocol.events.InternalOperationStartedProgressEvent;
import org.gradle.tooling.internal.provider.runner.ProgressEventConsumer;

class ClientForwardingTestOperationListener
implements BuildOperationListener {
    private final ProgressEventConsumer eventConsumer;
    private final BuildEventSubscriptions clientSubscriptions;
    private final Map<Object, String> runningTasks = Maps.newConcurrentMap();

    ClientForwardingTestOperationListener(ProgressEventConsumer eventConsumer, BuildEventSubscriptions clientSubscriptions) {
        this.eventConsumer = eventConsumer;
        this.clientSubscriptions = clientSubscriptions;
    }

    public void started(BuildOperationDescriptor buildOperation, OperationStartEvent startEvent) {
        Object details = buildOperation.getDetails();
        if (details instanceof ExecuteTaskBuildOperationDetails) {
            TaskInternal task = ((ExecuteTaskBuildOperationDetails)details).getTask();
            if (!(task instanceof Test)) {
                return;
            }
            this.runningTasks.put(buildOperation.getId(), task.getPath());
        } else if (details instanceof ExecuteTestBuildOperationType.Details) {
            ExecuteTestBuildOperationType.Details testOperationDetails = (ExecuteTestBuildOperationType.Details)details;
            TestDescriptorInternal testDescriptor = (TestDescriptorInternal)testOperationDetails.getTestDescriptor();
            this.eventConsumer.started((InternalOperationStartedProgressEvent)new DefaultTestStartedProgressEvent(testOperationDetails.getStartTime(), this.adapt(testDescriptor)));
        }
    }

    public void progress(OperationIdentifier buildOperationId, OperationProgressEvent progressEvent) {
    }

    public void finished(BuildOperationDescriptor buildOperation, OperationFinishEvent finishEvent) {
        if (buildOperation.getDetails() instanceof ExecuteTaskBuildOperationDetails) {
            this.runningTasks.remove(buildOperation.getId());
        } else if (finishEvent.getResult() instanceof ExecuteTestBuildOperationType.Result) {
            TestResult testResult = ((ExecuteTestBuildOperationType.Result)finishEvent.getResult()).getResult();
            TestDescriptorInternal testDescriptor = (TestDescriptorInternal)((ExecuteTestBuildOperationType.Details)buildOperation.getDetails()).getTestDescriptor();
            this.eventConsumer.finished((InternalOperationFinishedProgressEvent)new DefaultTestFinishedProgressEvent(testResult.getEndTime(), this.adapt(testDescriptor), ClientForwardingTestOperationListener.adapt(testResult)));
        }
    }

    private DefaultTestDescriptor adapt(TestDescriptorInternal testDescriptor) {
        return testDescriptor.isComposite() ? this.toTestDescriptorForSuite(testDescriptor) : this.toTestDescriptorForTest(testDescriptor);
    }

    private DefaultTestDescriptor toTestDescriptorForSuite(TestDescriptorInternal suite) {
        Object id = suite.getId();
        String name = suite.getName();
        String displayName = suite.toString();
        String testKind = "SUITE";
        String suiteName = suite.getName();
        String className = suite.getClassName();
        String methodName = null;
        Object parentId = this.getParentId(suite);
        String testTaskPath = this.getTaskPath(suite);
        return new DefaultTestDescriptor(id, name, displayName, testKind, suiteName, className, methodName, parentId, testTaskPath);
    }

    private DefaultTestDescriptor toTestDescriptorForTest(TestDescriptorInternal test) {
        Object id = test.getId();
        String name = test.getName();
        String displayName = test.toString();
        String testKind = "ATOMIC";
        String suiteName = null;
        String className = test.getClassName();
        String methodName = test.getName();
        Object parentId = this.getParentId(test);
        String taskPath = this.getTaskPath(test);
        return new DefaultTestDescriptor(id, name, displayName, testKind, suiteName, className, methodName, parentId, taskPath);
    }

    private String getTaskPath(TestDescriptorInternal givenDescriptor) {
        TestDescriptorInternal descriptor = givenDescriptor;
        while (descriptor.getOwnerBuildOperationId() == null && descriptor.getParent() != null) {
            descriptor = descriptor.getParent();
        }
        return this.runningTasks.get(descriptor.getOwnerBuildOperationId());
    }

    private Object getParentId(TestDescriptorInternal descriptor) {
        TestDescriptorInternal parent = descriptor.getParent();
        if (parent != null) {
            return parent.getId();
        }
        if (this.clientSubscriptions.isRequested(OperationType.TASK)) {
            return descriptor.getOwnerBuildOperationId();
        }
        return null;
    }

    private static AbstractTestResult adapt(TestResult result) {
        TestResult.ResultType resultType = result.getResultType();
        switch (resultType) {
            case SUCCESS: {
                return new DefaultTestSuccessResult(result.getStartTime(), result.getEndTime());
            }
            case SKIPPED: {
                return new DefaultTestSkippedResult(result.getStartTime(), result.getEndTime());
            }
            case FAILURE: {
                return new DefaultTestFailureResult(result.getStartTime(), result.getEndTime(), ClientForwardingTestOperationListener.convertExceptions(result.getExceptions()));
            }
        }
        throw new IllegalStateException("Unknown test result type: " + resultType);
    }

    private static List<DefaultFailure> convertExceptions(List<Throwable> exceptions) {
        ArrayList<DefaultFailure> failures = new ArrayList<DefaultFailure>(exceptions.size());
        for (Throwable exception : exceptions) {
            failures.add(DefaultFailure.fromThrowable((Throwable)exception));
        }
        return failures;
    }
}

