/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.internal.component.model;

import com.google.common.collect.ImmutableList;
import java.util.Collections;
import java.util.List;
import org.gradle.api.artifacts.ClientModule;
import org.gradle.api.artifacts.Dependency;
import org.gradle.internal.component.local.model.DslOriginDependencyMetadata;
import org.gradle.internal.component.model.ComponentOverrideMetadata;
import org.gradle.internal.component.model.DependencyMetadata;
import org.gradle.internal.component.model.IvyArtifactName;

public class DefaultComponentOverrideMetadata
implements ComponentOverrideMetadata {
    public static final ComponentOverrideMetadata EMPTY = new DefaultComponentOverrideMetadata(false, (IvyArtifactName)null, null);
    private final boolean changing;
    private final List<IvyArtifactName> artifacts;
    private final ClientModule clientModule;

    public static ComponentOverrideMetadata forDependency(boolean changing, IvyArtifactName mainArtifact, ClientModule clientModule) {
        if (!changing && mainArtifact == null && clientModule == null) {
            return EMPTY;
        }
        return new DefaultComponentOverrideMetadata(changing, mainArtifact, clientModule);
    }

    private DefaultComponentOverrideMetadata(boolean changing, IvyArtifactName artifact, ClientModule clientModule) {
        this(changing, (List<IvyArtifactName>)(artifact == null ? Collections.emptyList() : ImmutableList.of((Object)artifact)), clientModule);
    }

    private DefaultComponentOverrideMetadata(boolean changing, List<IvyArtifactName> artifacts, ClientModule clientModule) {
        this.changing = changing;
        this.artifacts = artifacts;
        this.clientModule = clientModule;
    }

    public static ClientModule extractClientModule(DependencyMetadata dependencyMetadata) {
        Dependency source;
        if (dependencyMetadata instanceof DslOriginDependencyMetadata && (source = ((DslOriginDependencyMetadata)dependencyMetadata).getSource()) instanceof ClientModule) {
            return (ClientModule)source;
        }
        return null;
    }

    @Override
    public ComponentOverrideMetadata withChanging() {
        return new DefaultComponentOverrideMetadata(true, this.artifacts, this.clientModule);
    }

    @Override
    public List<IvyArtifactName> getArtifacts() {
        return this.artifacts;
    }

    @Override
    public boolean isChanging() {
        return this.changing;
    }

    @Override
    public ClientModule getClientModule() {
        return this.clientModule;
    }
}

