/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.artifacts.ivyservice.resolveengine.graph.builder;

import com.google.common.collect.ArrayListMultimap;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Multimap;
import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.lang.StringUtils;
import org.gradle.api.Action;
import org.gradle.api.artifacts.ModuleIdentifier;
import org.gradle.api.artifacts.component.ComponentIdentifier;
import org.gradle.api.artifacts.component.ModuleComponentIdentifier;
import org.gradle.api.artifacts.component.ModuleComponentSelector;
import org.gradle.api.artifacts.result.ResolvedVariantResult;
import org.gradle.api.attributes.AttributeContainer;
import org.gradle.api.capabilities.Capability;
import org.gradle.api.internal.artifacts.DependencySubstitutionInternal;
import org.gradle.api.internal.artifacts.ResolvedConfigurationIdentifier;
import org.gradle.api.internal.artifacts.ivyservice.dependencysubstitution.DependencySubstitutionApplicator;
import org.gradle.api.internal.artifacts.ivyservice.resolveengine.excludes.ModuleExclusions;
import org.gradle.api.internal.artifacts.ivyservice.resolveengine.excludes.specs.ExcludeSpec;
import org.gradle.api.internal.artifacts.ivyservice.resolveengine.graph.DependencyGraphNode;
import org.gradle.api.internal.artifacts.ivyservice.resolveengine.graph.builder.ComponentState;
import org.gradle.api.internal.artifacts.ivyservice.resolveengine.graph.builder.DependencyGraphBuilder;
import org.gradle.api.internal.artifacts.ivyservice.resolveengine.graph.builder.DependencyState;
import org.gradle.api.internal.artifacts.ivyservice.resolveengine.graph.builder.EdgeState;
import org.gradle.api.internal.artifacts.ivyservice.resolveengine.graph.builder.LenientPlatformDependencyMetadata;
import org.gradle.api.internal.artifacts.ivyservice.resolveengine.graph.builder.LenientPlatformResolveMetadata;
import org.gradle.api.internal.artifacts.ivyservice.resolveengine.graph.builder.ModuleResolveState;
import org.gradle.api.internal.artifacts.ivyservice.resolveengine.graph.builder.PendingDependencies;
import org.gradle.api.internal.artifacts.ivyservice.resolveengine.graph.builder.PendingDependenciesVisitor;
import org.gradle.api.internal.artifacts.ivyservice.resolveengine.graph.builder.PotentialEdge;
import org.gradle.api.internal.artifacts.ivyservice.resolveengine.graph.builder.ResolveState;
import org.gradle.api.internal.artifacts.ivyservice.resolveengine.graph.builder.VirtualPlatformState;
import org.gradle.api.internal.artifacts.ivyservice.resolveengine.graph.conflicts.CapabilitiesConflictHandler;
import org.gradle.api.internal.artifacts.ivyservice.resolveengine.strict.StrictVersionConstraints;
import org.gradle.api.internal.artifacts.result.DefaultResolvedVariantResult;
import org.gradle.api.internal.attributes.ImmutableAttributes;
import org.gradle.api.internal.attributes.ImmutableAttributesFactory;
import org.gradle.internal.Describables;
import org.gradle.internal.DisplayName;
import org.gradle.internal.component.external.model.DefaultModuleComponentSelector;
import org.gradle.internal.component.external.model.ShadowedCapability;
import org.gradle.internal.component.external.model.VirtualComponentIdentifier;
import org.gradle.internal.component.local.model.LocalConfigurationMetadata;
import org.gradle.internal.component.local.model.LocalFileDependencyMetadata;
import org.gradle.internal.component.model.ComponentResolveMetadata;
import org.gradle.internal.component.model.ConfigurationMetadata;
import org.gradle.internal.component.model.DependencyMetadata;
import org.gradle.internal.component.model.ExcludeMetadata;
import org.gradle.internal.component.model.SelectedByVariantMatchingConfigurationMetadata;
import org.gradle.internal.resolve.ModuleVersionResolveException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class NodeState
implements DependencyGraphNode {
    private static final Logger LOGGER = LoggerFactory.getLogger(NodeState.class);
    private final Long resultId;
    private final ComponentState component;
    private final List<EdgeState> incomingEdges = Lists.newArrayList();
    private final List<EdgeState> outgoingEdges = Lists.newArrayList();
    private final ResolvedConfigurationIdentifier id;
    private final ConfigurationMetadata metaData;
    private final ResolveState resolveState;
    private final ModuleExclusions moduleExclusions;
    private final boolean isTransitive;
    private final boolean selectedByVariantAwareResolution;
    private final boolean dependenciesMayChange;
    private boolean doesNotHaveDependencies;
    ExcludeSpec previousTraversalExclusions;
    private List<EdgeState> virtualEdges;
    private boolean queued;
    private boolean evicted;
    private int transitiveEdgeCount;
    private Set<ModuleIdentifier> upcomingNoLongerPendingConstraints;
    private boolean virtualPlatformNeedsRefresh;
    private Set<EdgeState> edgesToRecompute;
    private Multimap<ModuleIdentifier, DependencyState> potentiallyActivatedConstraints;
    private Map<DependencyMetadata, DependencyState> dependencyStateCache = Maps.newHashMap();
    private Map<DependencyState, EdgeState> edgesCache = Maps.newHashMap();
    private List<DependencyState> cachedDependencyStates;
    private List<DependencyState> cachedFilteredDependencyStates;
    private ExcludeSpec cachedNodeExclusions;
    private int previousIncomingEdgeCount;
    private long previousIncomingHash;
    private long incomingHash;
    private ExcludeSpec cachedModuleResolutionFilter;
    private ResolvedVariantResult cachedVariantResult;
    private StrictVersionConstraints ancestorsStrictVersionConstraints;
    private StrictVersionConstraints ownStrictVersionConstraints;
    private List<EdgeState> endorsesStrictVersionsFrom;
    private boolean removingOutgoingEdges;

    public NodeState(Long resultId, ResolvedConfigurationIdentifier id, ComponentState component, ResolveState resolveState, ConfigurationMetadata md) {
        this.resultId = resultId;
        this.id = id;
        this.component = component;
        this.resolveState = resolveState;
        this.metaData = md;
        this.isTransitive = this.metaData.isTransitive();
        this.selectedByVariantAwareResolution = md instanceof SelectedByVariantMatchingConfigurationMetadata;
        this.moduleExclusions = resolveState == null ? null : resolveState.getModuleExclusions();
        this.dependenciesMayChange = component.getModule() != null && component.getModule().isVirtualPlatform();
        component.addConfiguration(this);
    }

    boolean enqueue() {
        if (this.queued) {
            return false;
        }
        this.queued = true;
        return true;
    }

    NodeState dequeue() {
        this.queued = false;
        return this;
    }

    @Override
    public ComponentState getComponent() {
        return this.component;
    }

    @Override
    public Long getNodeId() {
        return this.resultId;
    }

    @Override
    public boolean isRoot() {
        return false;
    }

    @Override
    public ResolvedConfigurationIdentifier getResolvedConfigurationId() {
        return this.id;
    }

    @Override
    public ComponentState getOwner() {
        return this.component;
    }

    public List<EdgeState> getIncomingEdges() {
        return this.incomingEdges;
    }

    public List<EdgeState> getOutgoingEdges() {
        return this.outgoingEdges;
    }

    @Override
    public ConfigurationMetadata getMetadata() {
        return this.metaData;
    }

    @Override
    public Set<? extends LocalFileDependencyMetadata> getOutgoingFileEdges() {
        if (this.metaData instanceof LocalConfigurationMetadata) {
            for (EdgeState incomingEdge : this.incomingEdges) {
                if (!incomingEdge.isTransitive()) continue;
                return ((LocalConfigurationMetadata)this.metaData).getFiles();
            }
        }
        return Collections.emptySet();
    }

    public String toString() {
        return String.format("%s(%s)", this.component, this.id.getConfiguration());
    }

    public String getSimpleName() {
        return this.component.getId().toString();
    }

    public String getNameWithVariant() {
        return this.component.getId() + " variant " + this.id.getConfiguration();
    }

    public boolean isTransitive() {
        return this.isTransitive;
    }

    public void visitOutgoingDependencies(Collection<EdgeState> discoveredEdges) {
        if (!this.component.isSelected()) {
            LOGGER.debug("version for {} is not selected. ignoring.", (Object)this);
            if (this.upcomingNoLongerPendingConstraints != null) {
                for (ModuleIdentifier identifier : this.upcomingNoLongerPendingConstraints) {
                    ModuleResolveState module = this.resolveState.getModule(identifier);
                    for (EdgeState unattachedDependency : module.getUnattachedDependencies()) {
                        if (unattachedDependency.getSelector().isResolved()) continue;
                        NodeState from = unattachedDependency.getFrom();
                        from.prepareToRecomputeEdge(unattachedDependency);
                    }
                }
                this.upcomingNoLongerPendingConstraints = null;
            }
            return;
        }
        if (this.transitiveEdgeCount == 0 && !this.isRoot()) {
            this.handleNonTransitiveNode(discoveredEdges);
            return;
        }
        ExcludeSpec resolutionFilter = this.computeModuleResolutionFilter(this.incomingEdges);
        if (!this.isVirtualPlatformNeedsRefresh() && this.excludesSameDependenciesAsPreviousTraversal(resolutionFilter)) {
            boolean newConstraints = this.handleNewConstraints(discoveredEdges);
            boolean edgesToRecompute = this.handleEdgesToRecompute(discoveredEdges);
            if (!newConstraints && !edgesToRecompute) {
                LOGGER.debug("Changed edges for {} selects same versions as previous traversal. ignoring", (Object)this);
            }
            this.previousTraversalExclusions = resolutionFilter;
            return;
        }
        if (this.previousTraversalExclusions != null) {
            this.removeOutgoingEdges();
            this.upcomingNoLongerPendingConstraints = null;
            this.edgesToRecompute = null;
            this.potentiallyActivatedConstraints = null;
            this.ownStrictVersionConstraints = null;
        }
        this.visitDependencies(resolutionFilter, discoveredEdges);
        this.visitOwners(discoveredEdges);
    }

    private boolean excludesSameDependenciesAsPreviousTraversal(ExcludeSpec newResolutionFilter) {
        List<DependencyState> oldStates = this.cachedFilteredDependencyStates;
        if (this.previousTraversalExclusions == null || oldStates == null) {
            return false;
        }
        if (this.previousTraversalExclusions.equals(newResolutionFilter)) {
            return true;
        }
        if (this.doesNotHaveDependencies && !this.dependenciesMayChange) {
            return true;
        }
        this.cachedFilteredDependencyStates = null;
        boolean sameDependencies = this.dependencies(newResolutionFilter).equals(oldStates);
        if (LOGGER.isDebugEnabled()) {
            if (sameDependencies) {
                LOGGER.debug("Filter {} excludes same dependencies as previous {}. Dependencies left = {}", new Object[]{newResolutionFilter, this.previousTraversalExclusions, oldStates});
            } else {
                LOGGER.debug("Filter {} doesn't exclude same dependencies as previous {}. Previous dependencies left = {} - New dependencies left = {}", new Object[]{newResolutionFilter, this.previousTraversalExclusions, oldStates, this.cachedFilteredDependencyStates});
            }
        }
        return sameDependencies;
    }

    private void prepareToRecomputeEdge(EdgeState edgeToRecompute) {
        if (this.edgesToRecompute == null) {
            this.edgesToRecompute = Sets.newLinkedHashSet();
        }
        this.edgesToRecompute.add(edgeToRecompute);
        this.resolveState.onMoreSelected(this);
    }

    private boolean handleEdgesToRecompute(Collection<EdgeState> discoveredEdges) {
        if (this.edgesToRecompute != null) {
            discoveredEdges.addAll(this.edgesToRecompute);
            this.edgesToRecompute = null;
            return true;
        }
        return false;
    }

    private boolean handleNewConstraints(Collection<EdgeState> discoveredEdges) {
        if (this.upcomingNoLongerPendingConstraints != null) {
            this.visitAdditionalConstraints(discoveredEdges);
            return true;
        }
        return false;
    }

    private boolean isVirtualPlatformNeedsRefresh() {
        return this.virtualPlatformNeedsRefresh;
    }

    private void handleNonTransitiveNode(Collection<EdgeState> discoveredEdges) {
        if (this.previousTraversalExclusions != null) {
            this.removeOutgoingEdges();
        }
        if (!this.incomingEdges.isEmpty()) {
            LOGGER.debug("{} has no transitive incoming edges. ignoring outgoing edges.", (Object)this);
            this.visitOwners(discoveredEdges);
        } else {
            LOGGER.debug("{} has no incoming edges. ignoring.", (Object)this);
        }
    }

    private DependencyState createDependencyState(DependencyMetadata md) {
        return new DependencyState(md, this.resolveState.getComponentSelectorConverter());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void visitDependencies(ExcludeSpec resolutionFilter, Collection<EdgeState> discoveredEdges) {
        PendingDependenciesVisitor pendingDepsVisitor = this.resolveState.newPendingDependenciesVisitor();
        Set<ModuleIdentifier> strictVersionsSet = null;
        boolean shouldComputeOwnStrictVersions = this.ownStrictVersionConstraints == null;
        try {
            this.collectAncestorsStrictVersions(this.incomingEdges);
            for (DependencyState dependencyState : this.dependencies(resolutionFilter)) {
                dependencyState = NodeState.maybeSubstitute(dependencyState, this.resolveState.getDependencySubstitutionApplicator());
                PendingDependenciesVisitor.PendingState pendingState = pendingDepsVisitor.maybeAddAsPendingDependency(this, dependencyState);
                if (dependencyState.getDependency().isConstraint()) {
                    this.registerActivatingConstraint(dependencyState);
                }
                if (!pendingState.isPending()) {
                    this.createAndLinkEdgeState(dependencyState, discoveredEdges, resolutionFilter, pendingState == PendingDependenciesVisitor.PendingState.NOT_PENDING_ACTIVATING);
                }
                if (!shouldComputeOwnStrictVersions) continue;
                strictVersionsSet = this.maybeCollectStrictVersions(strictVersionsSet, dependencyState);
            }
            this.previousTraversalExclusions = resolutionFilter;
        }
        finally {
            pendingDepsVisitor.complete();
            if (shouldComputeOwnStrictVersions) {
                this.storeOwnStrictVersions(strictVersionsSet);
            }
        }
    }

    private void registerActivatingConstraint(DependencyState dependencyState) {
        if (this.potentiallyActivatedConstraints == null) {
            this.potentiallyActivatedConstraints = ArrayListMultimap.create();
        }
        this.potentiallyActivatedConstraints.put((Object)dependencyState.getModuleIdentifier(), (Object)dependencyState);
    }

    private List<? extends DependencyMetadata> dependencies() {
        if (this.dependenciesMayChange) {
            this.cachedDependencyStates = null;
            this.cachedFilteredDependencyStates = null;
        }
        List<? extends DependencyMetadata> dependencies = this.metaData.getDependencies();
        this.doesNotHaveDependencies = dependencies.isEmpty();
        return dependencies;
    }

    private List<DependencyState> dependencies(ExcludeSpec spec) {
        List<? extends DependencyMetadata> dependencies = this.dependencies();
        if (this.cachedDependencyStates == null) {
            this.cachedDependencyStates = this.cacheDependencyStates(dependencies);
        }
        if (this.cachedFilteredDependencyStates == null) {
            this.cachedFilteredDependencyStates = this.cacheFilteredDependencyStates(spec, this.cachedDependencyStates);
        }
        return this.cachedFilteredDependencyStates;
    }

    private List<DependencyState> cacheFilteredDependencyStates(ExcludeSpec spec, List<DependencyState> from) {
        if (from.isEmpty()) {
            return from;
        }
        ArrayList tmp = Lists.newArrayListWithCapacity((int)from.size());
        for (DependencyState dependencyState : from) {
            if (this.isExcluded(spec, dependencyState)) continue;
            tmp.add(dependencyState);
        }
        return tmp;
    }

    private List<DependencyState> cacheDependencyStates(List<? extends DependencyMetadata> dependencies) {
        if (dependencies.isEmpty()) {
            return Collections.emptyList();
        }
        ArrayList tmp = Lists.newArrayListWithCapacity((int)dependencies.size());
        for (DependencyMetadata dependencyMetadata : dependencies) {
            tmp.add(this.cachedDependencyStateFor(dependencyMetadata));
        }
        return tmp;
    }

    private DependencyState cachedDependencyStateFor(DependencyMetadata md) {
        return this.dependencyStateCache.computeIfAbsent(md, this::createDependencyState);
    }

    private void createAndLinkEdgeState(DependencyState dependencyState, Collection<EdgeState> discoveredEdges, ExcludeSpec resolutionFilter, boolean deferSelection) {
        EdgeState dependencyEdge = this.edgesCache.computeIfAbsent(dependencyState, ds -> new EdgeState(this, (DependencyState)ds, resolutionFilter, this.resolveState));
        dependencyEdge.computeSelector();
        this.outgoingEdges.add(dependencyEdge);
        discoveredEdges.add(dependencyEdge);
        dependencyEdge.getSelector().use(deferSelection);
    }

    private void visitAdditionalConstraints(Collection<EdgeState> discoveredEdges) {
        if (this.potentiallyActivatedConstraints == null) {
            return;
        }
        for (ModuleIdentifier module : this.upcomingNoLongerPendingConstraints) {
            Collection dependencyStates = this.potentiallyActivatedConstraints.get((Object)module);
            if (dependencyStates.isEmpty()) continue;
            for (DependencyState dependencyState : dependencyStates) {
                dependencyState = NodeState.maybeSubstitute(dependencyState, this.resolveState.getDependencySubstitutionApplicator());
                this.createAndLinkEdgeState(dependencyState, discoveredEdges, this.previousTraversalExclusions, false);
            }
        }
        this.upcomingNoLongerPendingConstraints = null;
    }

    private void visitOwners(Collection<EdgeState> discoveredEdges) {
        ImmutableList<? extends VirtualComponentIdentifier> owners = this.component.getMetadata().getPlatformOwners();
        if (!owners.isEmpty()) {
            PendingDependenciesVisitor visitor = this.resolveState.newPendingDependenciesVisitor();
            for (VirtualComponentIdentifier owner : owners) {
                if (!(owner instanceof ModuleComponentIdentifier)) continue;
                ModuleComponentIdentifier platformId = (ModuleComponentIdentifier)owner;
                ModuleComponentSelector cs = DefaultModuleComponentSelector.newSelector(platformId.getModuleIdentifier(), platformId.getVersion());
                this.addPlatformEdges(discoveredEdges, platformId, cs);
                visitor.markNotPending(platformId.getModuleIdentifier());
            }
            visitor.complete();
        }
    }

    private void addPlatformEdges(Collection<EdgeState> discoveredEdges, ModuleComponentIdentifier platformComponentIdentifier, ModuleComponentSelector platformSelector) {
        PotentialEdge potentialEdge = PotentialEdge.of(this.resolveState, this, platformComponentIdentifier, platformSelector, (ComponentIdentifier)platformComponentIdentifier);
        ComponentResolveMetadata metadata = potentialEdge.metadata;
        VirtualPlatformState virtualPlatformState = null;
        if (metadata == null || metadata instanceof LenientPlatformResolveMetadata) {
            virtualPlatformState = potentialEdge.component.getModule().getPlatformState();
            virtualPlatformState.participatingModule(this.component.getModule());
        }
        if (metadata == null) {
            metadata = new LenientPlatformResolveMetadata(platformComponentIdentifier, potentialEdge.toModuleVersionId, virtualPlatformState, this, this.resolveState);
            potentialEdge.component.setMetadata(metadata);
            potentialEdge.component.getModule().maybeCreateVirtualMetadata(this.resolveState);
        }
        if (this.virtualEdges == null) {
            this.virtualEdges = Lists.newArrayList();
        }
        EdgeState edge = potentialEdge.edge;
        this.virtualEdges.add(edge);
        discoveredEdges.add(edge);
        edge.getSelector().use(false);
    }

    static DependencyState maybeSubstitute(DependencyState dependencyState, DependencySubstitutionApplicator dependencySubstitutionApplicator) {
        DependencySubstitutionApplicator.SubstitutionResult substitutionResult = dependencySubstitutionApplicator.apply(dependencyState.getDependency());
        if (substitutionResult.hasFailure()) {
            dependencyState.failure = new ModuleVersionResolveException(dependencyState.getRequested(), substitutionResult.getFailure());
            return dependencyState;
        }
        DependencySubstitutionInternal details = substitutionResult.getResult();
        if (details != null && details.isUpdated()) {
            return dependencyState.withTarget(details.getTarget(), details.getRuleDescriptors());
        }
        return dependencyState;
    }

    private boolean isExcluded(ExcludeSpec excludeSpec, DependencyState dependencyState) {
        DependencyMetadata dependency = dependencyState.getDependency();
        if (!this.resolveState.getEdgeFilter().isSatisfiedBy((Object)dependency)) {
            LOGGER.debug("{} is filtered.", (Object)dependency);
            return true;
        }
        if (excludeSpec == this.moduleExclusions.nothing()) {
            return false;
        }
        ModuleIdentifier targetModuleId = dependencyState.getModuleIdentifier();
        if (excludeSpec.excludes(targetModuleId)) {
            LOGGER.debug("{} is excluded from {} by {}.", new Object[]{targetModuleId, this, excludeSpec});
            return true;
        }
        return false;
    }

    void addIncomingEdge(EdgeState dependencyEdge) {
        if (!this.incomingEdges.contains(dependencyEdge)) {
            this.incomingEdges.add(dependencyEdge);
            this.incomingHash += (long)dependencyEdge.hashCode();
            this.resolveState.onMoreSelected(this);
            if (dependencyEdge.isTransitive()) {
                ++this.transitiveEdgeCount;
            }
        }
    }

    void removeIncomingEdge(EdgeState dependencyEdge) {
        if (this.incomingEdges.remove(dependencyEdge)) {
            this.incomingHash -= (long)dependencyEdge.hashCode();
            this.resolveState.onFewerSelected(this);
            if (dependencyEdge.isTransitive()) {
                --this.transitiveEdgeCount;
            }
        }
    }

    @Override
    public boolean isSelected() {
        return !this.incomingEdges.isEmpty();
    }

    public void evict() {
        this.evicted = true;
        this.restartIncomingEdges();
    }

    boolean shouldIncludedInGraphResult() {
        return this.isSelected() && !this.component.getModule().isVirtualPlatform();
    }

    private ExcludeSpec computeModuleResolutionFilter(List<EdgeState> incomingEdges) {
        ExcludeSpec nodeExclusions = this.computeNodeExclusions();
        if (incomingEdges.isEmpty()) {
            return nodeExclusions;
        }
        return this.computeExclusionFilter(incomingEdges, nodeExclusions);
    }

    private ExcludeSpec computeNodeExclusions() {
        if (this.cachedNodeExclusions == null) {
            this.cachedNodeExclusions = this.moduleExclusions.excludeAny((Collection<ExcludeMetadata>)this.metaData.getExcludes());
        }
        return this.cachedNodeExclusions;
    }

    private ExcludeSpec computeExclusionFilter(List<EdgeState> incomingEdges, ExcludeSpec nodeExclusions) {
        int incomingEdgeCount = incomingEdges.size();
        if (this.sameIncomingEdgesAsPreviousPass(incomingEdgeCount)) {
            return this.cachedModuleResolutionFilter;
        }
        if (incomingEdgeCount == 1) {
            return this.computeExclusionFilterSingleIncomingEdge(incomingEdges.get(0), nodeExclusions);
        }
        return this.computeModuleExclusionsManyEdges(incomingEdges, nodeExclusions, incomingEdgeCount);
    }

    private ExcludeSpec computeModuleExclusionsManyEdges(List<EdgeState> incomingEdges, ExcludeSpec nodeExclusions, int incomingEdgeCount) {
        ExcludeSpec nothing = this.moduleExclusions.nothing();
        ExcludeSpec edgeExclusions = null;
        HashSet excludedByBoth = null;
        Set<ExcludeSpec> excludedByEither = null;
        for (EdgeState dependencyEdge : incomingEdges) {
            if (dependencyEdge.isTransitive()) {
                if (edgeExclusions == nothing) continue;
                ExcludeSpec exclusions = dependencyEdge.getExclusions();
                if (edgeExclusions == null || exclusions == nothing) {
                    edgeExclusions = exclusions;
                } else if (exclusions != null && edgeExclusions != exclusions) {
                    if (excludedByBoth == null) {
                        excludedByBoth = Sets.newHashSetWithExpectedSize((int)incomingEdgeCount);
                    }
                    excludedByBoth.add(exclusions);
                }
                if (edgeExclusions != nothing) continue;
                excludedByBoth = null;
                continue;
            }
            if (!NodeState.isConstraint(dependencyEdge)) continue;
            excludedByEither = NodeState.collectEdgeConstraint(nodeExclusions, excludedByEither, dependencyEdge, nothing, incomingEdgeCount);
        }
        edgeExclusions = this.intersectEdgeExclusions(edgeExclusions, excludedByBoth);
        nodeExclusions = this.joinNodeExclusions(nodeExclusions, excludedByEither);
        return this.joinEdgeAndNodeExclusionsThenCacheResult(nodeExclusions, edgeExclusions, incomingEdgeCount);
    }

    private ExcludeSpec computeExclusionFilterSingleIncomingEdge(EdgeState dependencyEdge, ExcludeSpec nodeExclusions) {
        ExcludeSpec exclusions = null;
        if (dependencyEdge.isTransitive()) {
            exclusions = dependencyEdge.getExclusions();
        } else if (NodeState.isConstraint(dependencyEdge)) {
            exclusions = dependencyEdge.getEdgeExclusions();
        }
        if (exclusions == null) {
            exclusions = this.moduleExclusions.nothing();
        }
        return this.joinEdgeAndNodeExclusionsThenCacheResult(nodeExclusions, exclusions, 1);
    }

    private static boolean isConstraint(EdgeState dependencyEdge) {
        return dependencyEdge.getDependencyMetadata().isConstraint();
    }

    private ExcludeSpec joinEdgeAndNodeExclusionsThenCacheResult(ExcludeSpec nodeExclusions, ExcludeSpec edgeExclusions, int incomingEdgeCount) {
        ExcludeSpec result = this.moduleExclusions.excludeAny(edgeExclusions, nodeExclusions);
        this.previousIncomingEdgeCount = incomingEdgeCount;
        this.previousIncomingHash = this.incomingHash;
        this.cachedModuleResolutionFilter = result;
        return result;
    }

    private static Set<ExcludeSpec> collectEdgeConstraint(ExcludeSpec nodeExclusions, Set<ExcludeSpec> excludedByEither, EdgeState dependencyEdge, ExcludeSpec nothing, int incomingEdgeCount) {
        ExcludeSpec constraintExclusions = dependencyEdge.getEdgeExclusions();
        if (constraintExclusions != nothing && constraintExclusions != nodeExclusions) {
            if (excludedByEither == null) {
                excludedByEither = Sets.newHashSetWithExpectedSize((int)incomingEdgeCount);
            }
            excludedByEither.add(constraintExclusions);
        }
        return excludedByEither;
    }

    private ExcludeSpec joinNodeExclusions(ExcludeSpec nodeExclusions, Set<ExcludeSpec> excludedByEither) {
        if (excludedByEither != null && nodeExclusions != null) {
            excludedByEither.add(nodeExclusions);
            nodeExclusions = this.moduleExclusions.excludeAny(excludedByEither);
        }
        return nodeExclusions;
    }

    private ExcludeSpec intersectEdgeExclusions(ExcludeSpec edgeExclusions, Set<ExcludeSpec> excludedByBoth) {
        if (edgeExclusions == this.moduleExclusions.nothing()) {
            return edgeExclusions;
        }
        if (excludedByBoth != null) {
            if (edgeExclusions != null) {
                excludedByBoth.add(edgeExclusions);
            }
            edgeExclusions = this.moduleExclusions.excludeAll(excludedByBoth);
        }
        return edgeExclusions;
    }

    private void collectOwnStrictVersions() {
        List<DependencyState> dependencies = this.dependencies(this.computeModuleResolutionFilter(this.incomingEdges));
        Set<ModuleIdentifier> constraintsSet = null;
        for (DependencyState dependencyState : dependencies) {
            constraintsSet = this.maybeCollectStrictVersions(constraintsSet, dependencyState);
        }
        this.storeOwnStrictVersions(constraintsSet);
    }

    private Set<ModuleIdentifier> maybeCollectStrictVersions(Set<ModuleIdentifier> constraintsSet, DependencyState dependencyState) {
        ModuleComponentSelector selector;
        if (dependencyState.getDependency().getSelector() instanceof ModuleComponentSelector && !StringUtils.isEmpty((String)(selector = (ModuleComponentSelector)dependencyState.getDependency().getSelector()).getVersionConstraint().getStrictVersion())) {
            if (constraintsSet == null) {
                constraintsSet = Sets.newHashSet();
            }
            constraintsSet.add(selector.getModuleIdentifier());
        }
        return constraintsSet;
    }

    private void storeOwnStrictVersions(Set<ModuleIdentifier> constraintsSet) {
        this.ownStrictVersionConstraints = constraintsSet == null ? StrictVersionConstraints.EMPTY : StrictVersionConstraints.of((Set<ModuleIdentifier>)ImmutableSet.copyOf(constraintsSet));
    }

    private void collectAncestorsStrictVersions(List<EdgeState> incomingEdges) {
        if (incomingEdges.isEmpty()) {
            this.ancestorsStrictVersionConstraints = StrictVersionConstraints.EMPTY;
            return;
        }
        if (incomingEdges.size() == 1) {
            this.collectAncestorsStrictVersionsSingleEdge(incomingEdges);
            return;
        }
        this.collectAncestorsStrictVersionsMultiEdges(incomingEdges);
    }

    private void collectAncestorsStrictVersionsMultiEdges(List<EdgeState> incomingEdges) {
        StrictVersionConstraints constraints = null;
        for (EdgeState dependencyEdge : incomingEdges) {
            StrictVersionConstraints parentStrictVersionConstraints = NodeState.notNull(dependencyEdge.getFrom().ownStrictVersionConstraints);
            StrictVersionConstraints parentAncestorsStrictVersionConstraints = NodeState.notNull(dependencyEdge.getFrom().ancestorsStrictVersionConstraints);
            StrictVersionConstraints parentEndorsedStrictVersionConstraints = this.getEndorsedStrictVersions(dependencyEdge);
            if ((constraints = constraints == null ? parentStrictVersionConstraints.union(parentAncestorsStrictVersionConstraints).union(parentEndorsedStrictVersionConstraints) : constraints.intersect(parentStrictVersionConstraints.union(parentAncestorsStrictVersionConstraints).union(parentEndorsedStrictVersionConstraints))) != StrictVersionConstraints.EMPTY) continue;
            this.ancestorsStrictVersionConstraints = constraints;
            return;
        }
        this.ancestorsStrictVersionConstraints = constraints;
    }

    private void collectAncestorsStrictVersionsSingleEdge(List<EdgeState> incomingEdges) {
        EdgeState dependencyEdge = incomingEdges.get(0);
        StrictVersionConstraints parentStrictVersionConstraints = NodeState.notNull(dependencyEdge.getFrom().ownStrictVersionConstraints);
        StrictVersionConstraints parentAncestorsStrictVersionConstraints = NodeState.notNull(dependencyEdge.getFrom().ancestorsStrictVersionConstraints);
        StrictVersionConstraints parentEndorsedStrictVersionConstraints = this.getEndorsedStrictVersions(dependencyEdge);
        this.ancestorsStrictVersionConstraints = parentStrictVersionConstraints.union(parentAncestorsStrictVersionConstraints).union(parentEndorsedStrictVersionConstraints);
    }

    private static StrictVersionConstraints notNull(StrictVersionConstraints strictVersionConstraints) {
        return strictVersionConstraints == null ? StrictVersionConstraints.EMPTY : strictVersionConstraints;
    }

    private StrictVersionConstraints getEndorsedStrictVersions(EdgeState incomingEdge) {
        if (incomingEdge.getFrom().endorsesStrictVersionsFrom == null) {
            return StrictVersionConstraints.EMPTY;
        }
        boolean filterOwn = false;
        StrictVersionConstraints singleStrictVersionConstraints = StrictVersionConstraints.EMPTY;
        HashSet collectedConstraints = null;
        for (EdgeState edgeState : incomingEdge.getFrom().endorsesStrictVersionsFrom) {
            if (edgeState == incomingEdge) {
                filterOwn = true;
                continue;
            }
            ComponentState targetComponent = edgeState.getTargetComponent();
            if (targetComponent == null) continue;
            for (NodeState sourceNode : targetComponent.getNodes()) {
                if (sourceNode.ownStrictVersionConstraints == null) {
                    sourceNode.collectOwnStrictVersions();
                }
                if (singleStrictVersionConstraints.isEmpty()) {
                    singleStrictVersionConstraints = sourceNode.ownStrictVersionConstraints;
                    continue;
                }
                if (collectedConstraints == null) {
                    collectedConstraints = Sets.newHashSet();
                    collectedConstraints.addAll(singleStrictVersionConstraints.getModules());
                }
                collectedConstraints.addAll(sourceNode.ownStrictVersionConstraints.getModules());
            }
        }
        if (filterOwn) {
            HashSet resultSet = collectedConstraints != null ? collectedConstraints : singleStrictVersionConstraints.getModules();
            if (this.ownStrictVersionConstraints == null) {
                this.collectOwnStrictVersions();
            }
            for (ModuleIdentifier ownConstraint : this.ownStrictVersionConstraints.getModules()) {
                if (!resultSet.contains(ownConstraint)) continue;
                if (collectedConstraints == null) {
                    collectedConstraints = Sets.newHashSet();
                    collectedConstraints.addAll(singleStrictVersionConstraints.getModules());
                }
                collectedConstraints.remove(ownConstraint);
            }
        }
        if (collectedConstraints != null) {
            return StrictVersionConstraints.of(collectedConstraints);
        }
        return singleStrictVersionConstraints;
    }

    void collectEndorsedStrictVersions(List<EdgeState> dependencies) {
        if (this.endorsesStrictVersionsFrom != null) {
            this.endorsesStrictVersionsFrom.clear();
        }
        for (EdgeState edgeState : dependencies) {
            if (!DependencyGraphBuilder.ENDORSE_STRICT_VERSIONS_DEPENDENCY_SPEC.isSatisfiedBy((Object)edgeState)) continue;
            if (this.endorsesStrictVersionsFrom == null) {
                this.endorsesStrictVersionsFrom = Lists.newArrayList();
            }
            this.endorsesStrictVersionsFrom.add(edgeState);
        }
    }

    boolean versionProvidedByAncestors(DependencyState dependencyState) {
        return !dependencyState.isForced() && this.ancestorsStrictVersionConstraints != null && this.ancestorsStrictVersionConstraints.contains(dependencyState.getModuleIdentifier());
    }

    private boolean sameIncomingEdgesAsPreviousPass(int incomingEdgeCount) {
        return this.cachedModuleResolutionFilter != null && this.previousIncomingHash == this.incomingHash && this.previousIncomingEdgeCount == incomingEdgeCount;
    }

    private void removeOutgoingEdges() {
        boolean alreadyRemoving = this.removingOutgoingEdges;
        this.removingOutgoingEdges = true;
        if (!this.outgoingEdges.isEmpty() && !alreadyRemoving) {
            for (EdgeState outgoingDependency : this.outgoingEdges) {
                ComponentState targetComponent = outgoingDependency.getTargetComponent();
                if (targetComponent == this.component || targetComponent != null && targetComponent.getModule().isChangingSelection()) continue;
                outgoingDependency.cleanUpOnSourceChange(this);
            }
            this.outgoingEdges.clear();
        }
        if (this.virtualEdges != null) {
            for (EdgeState outgoingDependency : this.virtualEdges) {
                outgoingDependency.removeFromTargetConfigurations();
                outgoingDependency.getSelector().release();
            }
        }
        this.virtualEdges = null;
        this.previousTraversalExclusions = null;
        this.cachedFilteredDependencyStates = null;
        this.virtualPlatformNeedsRefresh = false;
        this.removingOutgoingEdges = alreadyRemoving;
    }

    public void restart(ComponentState selected) {
        if (this.component == selected) {
            if (!this.evicted) {
                this.resolveState.onMoreSelected(this);
            }
        } else if (!this.incomingEdges.isEmpty()) {
            this.restartIncomingEdges();
        }
    }

    private void restartIncomingEdges() {
        if (this.incomingEdges.size() == 1) {
            EdgeState singleEdge = this.incomingEdges.get(0);
            singleEdge.restart();
        } else {
            for (EdgeState dependency : new ArrayList<EdgeState>(this.incomingEdges)) {
                dependency.restart();
            }
        }
        this.clearIncomingEdges();
    }

    private void clearIncomingEdges() {
        this.incomingEdges.clear();
        this.incomingHash = 0L;
        this.transitiveEdgeCount = 0;
    }

    public void deselect() {
        this.removeOutgoingEdges();
        this.reselectEndorsingNode();
    }

    private void reselectEndorsingNode() {
        if (this.incomingEdges.size() == 1) {
            EdgeState singleEdge = this.incomingEdges.get(0);
            NodeState from = singleEdge.getFrom();
            if (singleEdge.getDependencyState().getDependency().isEndorsingStrictVersions()) {
                from.reselect();
            }
        } else {
            for (EdgeState incoming : Lists.newArrayList(this.incomingEdges)) {
                if (!incoming.getDependencyState().getDependency().isEndorsingStrictVersions()) continue;
                incoming.getFrom().reselect();
            }
        }
    }

    private void reselect() {
        this.resolveState.onMoreSelected(this);
        this.removeOutgoingEdges();
    }

    void prepareForConstraintNoLongerPending(ModuleIdentifier moduleIdentifier) {
        if (this.upcomingNoLongerPendingConstraints == null) {
            this.upcomingNoLongerPendingConstraints = Sets.newLinkedHashSet();
        }
        this.upcomingNoLongerPendingConstraints.add(moduleIdentifier);
        this.resolveState.onFewerSelected(this);
    }

    void markForVirtualPlatformRefresh() {
        assert (this.component.getModule().isVirtualPlatform());
        this.virtualPlatformNeedsRefresh = true;
        this.resolveState.onFewerSelected(this);
    }

    public ImmutableAttributesFactory getAttributesFactory() {
        return this.resolveState.getAttributesFactory();
    }

    public void clearConstraintEdges(PendingDependencies pendingDependencies, NodeState backToPendingSource) {
        if (this.incomingEdges.isEmpty()) {
            return;
        }
        ImmutableList remainingIncomingEdges = ImmutableList.copyOf(this.incomingEdges);
        this.clearIncomingEdges();
        for (EdgeState incomingEdge : remainingIncomingEdges) {
            assert (NodeState.isConstraint(incomingEdge));
            NodeState from = incomingEdge.getFrom();
            if (from != backToPendingSource) {
                incomingEdge.getSelector().release();
                from.removeOutgoingEdge(incomingEdge);
            }
            pendingDependencies.addNode(from);
        }
    }

    private void removeOutgoingEdge(EdgeState edge) {
        if (!this.removingOutgoingEdges) {
            this.outgoingEdges.remove(edge);
        }
    }

    void forEachCapability(CapabilitiesConflictHandler capabilitiesConflictHandler, Action<? super Capability> action) {
        List capabilities = this.metaData.getCapabilities().getCapabilities();
        if (capabilities.isEmpty() && (this.component.hasMoreThanOneSelectedNodeUsingVariantAwareResolution() || capabilitiesConflictHandler.hasSeenCapability(this.component.getImplicitCapability()))) {
            action.execute((Object)this.component.getImplicitCapability());
        } else if (!capabilities.isEmpty()) {
            for (Capability capability : capabilities) {
                action.execute((Object)capability);
            }
        }
    }

    public Capability findCapability(String group, String name) {
        Capability onComponent = this.component.findCapability(group, name);
        if (onComponent != null) {
            return onComponent;
        }
        List capabilities = this.metaData.getCapabilities().getCapabilities();
        if (!capabilities.isEmpty()) {
            for (Capability capability : capabilities) {
                if (!capability.getGroup().equals(group) || !capability.getName().equals(name)) continue;
                return capability;
            }
        }
        return null;
    }

    public boolean isAttachedToVirtualPlatform() {
        for (EdgeState incomingEdge : this.incomingEdges) {
            if (!(incomingEdge.getDependencyMetadata() instanceof LenientPlatformDependencyMetadata)) continue;
            return true;
        }
        return false;
    }

    boolean hasShadowedCapability() {
        for (Capability capability : this.metaData.getCapabilities().getCapabilities()) {
            if (!(capability instanceof ShadowedCapability)) continue;
            return true;
        }
        return false;
    }

    boolean isSelectedByVariantAwareResolution() {
        return this.selectedByVariantAwareResolution && this.isSelected();
    }

    void makePending(EdgeState edgeState) {
        this.outgoingEdges.remove(edgeState);
        edgeState.getSelector().release();
        this.registerActivatingConstraint(edgeState.getDependencyState());
    }

    ImmutableAttributes desugar(ImmutableAttributes attributes) {
        return this.resolveState.desugar(attributes);
    }

    @Override
    public ResolvedVariantResult getResolvedVariant() {
        if (this.cachedVariantResult != null) {
            return this.cachedVariantResult;
        }
        DisplayName name = Describables.of((Object)this.metaData.getName());
        List capabilities = this.metaData.getCapabilities().getCapabilities();
        ImmutableAttributes attributes = this.desugar(this.metaData.getAttributes());
        ImmutableList resolvedVariantCapabilities = capabilities.isEmpty() ? Collections.singletonList(this.component.getImplicitCapability()) : ImmutableList.copyOf((Collection)capabilities);
        this.cachedVariantResult = new DefaultResolvedVariantResult(name, (AttributeContainer)attributes, (List<Capability>)resolvedVariantCapabilities);
        return this.cachedVariantResult;
    }
}

