/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.com.intellij.diagnostic;

import java.io.IOException;
import java.io.StringWriter;
import java.io.Writer;
import java.lang.management.ManagementFactory;
import java.lang.management.ThreadInfo;
import java.lang.management.ThreadMXBean;
import java.util.Arrays;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ThreadDumper {
    @NotNull
    public static String dumpThreadsToString() {
        StringWriter writer = new StringWriter();
        ThreadDumper.dumpThreadsToFile(ManagementFactory.getThreadMXBean(), writer);
        String string = writer.toString();
        if (string == null) {
            ThreadDumper.$$$reportNull$$$0(0);
        }
        return string;
    }

    @Nullable
    private static StackTraceElement[] dumpThreadsToFile(@NotNull ThreadMXBean threadMXBean, @NotNull Writer f) {
        if (threadMXBean == null) {
            ThreadDumper.$$$reportNull$$$0(5);
        }
        if (f == null) {
            ThreadDumper.$$$reportNull$$$0(6);
        }
        StackTraceElement[] edtStack = null;
        boolean dumpSuccessful = false;
        try {
            ThreadInfo[] threads = ThreadDumper.sort(threadMXBean.dumpAllThreads(false, false));
            edtStack = ThreadDumper.dumpThreadInfos(threads, f);
            dumpSuccessful = true;
        }
        catch (Exception threads) {
            // empty catch block
        }
        if (!dumpSuccessful) {
            long[] threadIds = threadMXBean.getAllThreadIds();
            ThreadInfo[] threadInfo = ThreadDumper.sort(threadMXBean.getThreadInfo(threadIds, Integer.MAX_VALUE));
            edtStack = ThreadDumper.dumpThreadInfos(threadInfo, f);
        }
        return edtStack;
    }

    private static StackTraceElement[] dumpThreadInfos(@NotNull ThreadInfo[] threadInfo, @NotNull Writer f) {
        if (threadInfo == null) {
            ThreadDumper.$$$reportNull$$$0(7);
        }
        if (f == null) {
            ThreadDumper.$$$reportNull$$$0(8);
        }
        StackTraceElement[] edtStack = null;
        for (ThreadInfo info2 : threadInfo) {
            if (info2 == null) continue;
            if (info2.getThreadName().equals("AWT-EventQueue-1")) {
                edtStack = info2.getStackTrace();
            }
            ThreadDumper.dumpThreadInfo(info2, f);
        }
        return edtStack;
    }

    @NotNull
    private static ThreadInfo[] sort(@NotNull ThreadInfo[] threads) {
        if (threads == null) {
            ThreadDumper.$$$reportNull$$$0(9);
        }
        Arrays.sort(threads, (o1, o2) -> {
            boolean r2;
            boolean awt1 = o1.getThreadName().startsWith("AWT-EventQueue");
            boolean awt2 = o2.getThreadName().startsWith("AWT-EventQueue");
            if (awt1 && !awt2) {
                return -1;
            }
            if (awt2 && !awt1) {
                return 1;
            }
            boolean r1 = o1.getThreadState() == Thread.State.RUNNABLE;
            boolean bl = r2 = o2.getThreadState() == Thread.State.RUNNABLE;
            if (r1 && !r2) {
                return -1;
            }
            if (r2 && !r1) {
                return 1;
            }
            return 0;
        });
        if (threads == null) {
            ThreadDumper.$$$reportNull$$$0(10);
        }
        return threads;
    }

    private static void dumpThreadInfo(@NotNull ThreadInfo info2, @NotNull Writer f) {
        if (info2 == null) {
            ThreadDumper.$$$reportNull$$$0(11);
        }
        if (f == null) {
            ThreadDumper.$$$reportNull$$$0(12);
        }
        ThreadDumper.dumpCallStack(info2, f, info2.getStackTrace());
    }

    private static void dumpCallStack(@NotNull ThreadInfo info2, @NotNull Writer f, @NotNull StackTraceElement[] stackTraceElements) {
        if (info2 == null) {
            ThreadDumper.$$$reportNull$$$0(13);
        }
        if (f == null) {
            ThreadDumper.$$$reportNull$$$0(14);
        }
        if (stackTraceElements == null) {
            ThreadDumper.$$$reportNull$$$0(15);
        }
        try {
            StringBuilder sb = new StringBuilder("\"").append(info2.getThreadName()).append("\"");
            sb.append(" prio=0 tid=0x0 nid=0x0 ").append(ThreadDumper.getReadableState(info2.getThreadState())).append("\n");
            sb.append("     java.lang.Thread.State: ").append((Object)info2.getThreadState()).append("\n");
            if (info2.getLockName() != null) {
                sb.append(" on ").append(info2.getLockName());
            }
            if (info2.getLockOwnerName() != null) {
                sb.append(" owned by \"").append(info2.getLockOwnerName()).append("\" Id=").append(info2.getLockOwnerId());
            }
            if (info2.isSuspended()) {
                sb.append(" (suspended)");
            }
            if (info2.isInNative()) {
                sb.append(" (in native)");
            }
            f.write(sb + "\n");
            ThreadDumper.printStackTrace(f, stackTraceElements);
            f.write("\n");
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    private static void printStackTrace(@NotNull Writer f, @NotNull StackTraceElement[] stackTraceElements) {
        if (f == null) {
            ThreadDumper.$$$reportNull$$$0(19);
        }
        if (stackTraceElements == null) {
            ThreadDumper.$$$reportNull$$$0(20);
        }
        try {
            for (StackTraceElement element : stackTraceElements) {
                f.write("\tat " + element + "\n");
            }
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    private static String getReadableState(@NotNull Thread.State state2) {
        if (state2 == null) {
            ThreadDumper.$$$reportNull$$$0(23);
        }
        switch (state2) {
            case BLOCKED: {
                return "blocked";
            }
            case TIMED_WAITING: 
            case WAITING: {
                return "waiting on condition";
            }
            case RUNNABLE: {
                return "runnable";
            }
            case NEW: {
                return "new";
            }
            case TERMINATED: {
                return "terminated";
            }
        }
        return null;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 3: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 20: 
            case 21: 
            case 22: 
            case 23: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 3: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 20: 
            case 21: 
            case 22: 
            case 23: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/kotlin/com/intellij/diagnostic/ThreadDumper";
                break;
            }
            case 3: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "threadMXBean";
                break;
            }
            case 6: 
            case 8: 
            case 12: 
            case 14: 
            case 17: 
            case 19: {
                objectArray2 = objectArray3;
                objectArray3[0] = "f";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "threadInfo";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "threads";
                break;
            }
            case 11: 
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "info";
                break;
            }
            case 15: 
            case 18: 
            case 20: {
                objectArray2 = objectArray3;
                objectArray3[0] = "stackTraceElements";
                break;
            }
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "thread";
                break;
            }
            case 21: {
                objectArray2 = objectArray3;
                objectArray3[0] = "fullThreadDump";
                break;
            }
            case 22: {
                objectArray2 = objectArray3;
                objectArray3[0] = "exceptionType";
                break;
            }
            case 23: {
                objectArray2 = objectArray3;
                objectArray3[0] = "state";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "dumpThreadsToString";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "dumpEdtStackTrace";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getThreadInfos";
                break;
            }
            case 3: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 20: 
            case 21: 
            case 22: 
            case 23: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/kotlin/com/intellij/diagnostic/ThreadDumper";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getThreadDumpInfo";
                break;
            }
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "sort";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "getThreadDumpInfo";
                break;
            }
            case 5: 
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "dumpThreadsToFile";
                break;
            }
            case 7: 
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "dumpThreadInfos";
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "sort";
                break;
            }
            case 11: 
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "dumpThreadInfo";
                break;
            }
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 18: {
                objectArray = objectArray;
                objectArray[2] = "dumpCallStack";
                break;
            }
            case 19: 
            case 20: {
                objectArray = objectArray;
                objectArray[2] = "printStackTrace";
                break;
            }
            case 21: 
            case 22: {
                objectArray = objectArray;
                objectArray[2] = "getEdtStackForCrash";
                break;
            }
            case 23: {
                objectArray = objectArray;
                objectArray[2] = "getReadableState";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 3: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 20: 
            case 21: 
            case 22: 
            case 23: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

