/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.play.internal;

import org.gradle.platform.base.internal.PlatformRequirement;

public class PlayPlatformRequirement
implements PlatformRequirement {
    private final String platformName;
    private final String playVersion;
    private final String scalaVersion;
    private final String javaVersion;

    public PlayPlatformRequirement(String playVersion, String scalaVersion, String javaVersion) {
        this.playVersion = playVersion;
        this.scalaVersion = scalaVersion;
        this.javaVersion = javaVersion;
        this.platformName = this.createName(playVersion, scalaVersion, javaVersion);
    }

    public String getPlatformName() {
        return this.platformName;
    }

    String getPlayVersion() {
        return this.playVersion;
    }

    String getScalaVersion() {
        return this.scalaVersion;
    }

    String getJavaVersion() {
        return this.javaVersion;
    }

    private String createName(String playVersion, String scalaVersion, String javaVersion) {
        StringBuilder builder = new StringBuilder("play-");
        builder.append(playVersion);
        if (scalaVersion != null) {
            builder.append("-");
            builder.append(scalaVersion);
        }
        if (javaVersion != null) {
            builder.append("_");
            builder.append(javaVersion);
        }
        return builder.toString();
    }
}

