/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.workers.internal;

import org.gradle.initialization.ClassLoaderRegistry;
import org.gradle.internal.operations.BuildOperationExecutor;
import org.gradle.internal.operations.BuildOperationRef;
import org.gradle.internal.service.ServiceRegistry;
import org.gradle.workers.IsolationMode;
import org.gradle.workers.internal.AbstractWorker;
import org.gradle.workers.internal.ActionExecutionSpec;
import org.gradle.workers.internal.BuildOperationAwareWorker;
import org.gradle.workers.internal.DaemonForkOptions;
import org.gradle.workers.internal.DefaultWorkResult;
import org.gradle.workers.internal.IsolatedClassloaderWorker;
import org.gradle.workers.internal.WorkerFactory;

public class IsolatedClassloaderWorkerFactory
implements WorkerFactory {
    private final BuildOperationExecutor buildOperationExecutor;
    private final ServiceRegistry serviceRegistry;
    private final ClassLoaderRegistry classLoaderRegistry;

    public IsolatedClassloaderWorkerFactory(BuildOperationExecutor buildOperationExecutor, ServiceRegistry parent, ClassLoaderRegistry classLoaderRegistry) {
        this.buildOperationExecutor = buildOperationExecutor;
        this.serviceRegistry = parent;
        this.classLoaderRegistry = classLoaderRegistry;
    }

    @Override
    public BuildOperationAwareWorker getWorker(final DaemonForkOptions forkOptions) {
        return new AbstractWorker(this.buildOperationExecutor){

            @Override
            public DefaultWorkResult execute(ActionExecutionSpec spec, BuildOperationRef parentBuildOperation) {
                return this.executeWrappedInBuildOperation(spec, parentBuildOperation, new AbstractWorker.Work(){

                    @Override
                    public DefaultWorkResult execute(ActionExecutionSpec spec) {
                        ClassLoader workerInfrastructureClassloader = IsolatedClassloaderWorkerFactory.this.classLoaderRegistry.getPluginsClassLoader();
                        return new IsolatedClassloaderWorker(forkOptions.getClassLoaderStructure(), workerInfrastructureClassloader, IsolatedClassloaderWorkerFactory.this.serviceRegistry).execute(spec);
                    }
                });
            }
        };
    }

    @Override
    public IsolationMode getIsolationMode() {
        return IsolationMode.CLASSLOADER;
    }
}

