/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.tasks.testing.logging;

import java.util.regex.Pattern;
import org.gradle.api.specs.Spec;

public class GroovyStackTraceSpec
implements Spec<StackTraceElement> {
    private static final Pattern INTERNAL_CLASSES = Pattern.compile("org.codehaus.groovy.runtime\\..*|org.codehaus.groovy.reflection\\..*|org.codehaus.groovy\\..*MetaClass.*|groovy\\..*MetaClass.*|groovy.lang.MetaMethod|java.lang.reflect\\..*|sun.reflect\\..*|jdk.internal.reflect\\..*");

    public boolean isSatisfiedBy(StackTraceElement element) {
        return !this.isInternalClass(element) && !this.isGeneratedMethod(element);
    }

    private boolean isInternalClass(StackTraceElement element) {
        return INTERNAL_CLASSES.matcher(element.getClassName()).matches();
    }

    private boolean isGeneratedMethod(StackTraceElement element) {
        return element.getLineNumber() < 0;
    }
}

