/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.com.intellij.psi.impl;

import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.com.intellij.lang.java.lexer.JavaLexer;
import org.jetbrains.kotlin.com.intellij.openapi.project.Project;
import org.jetbrains.kotlin.com.intellij.openapi.roots.LanguageLevelProjectExtension;
import org.jetbrains.kotlin.com.intellij.openapi.util.text.StringUtil;
import org.jetbrains.kotlin.com.intellij.pom.java.LanguageLevel;
import org.jetbrains.kotlin.com.intellij.psi.PsiNameHelper;

public class PsiNameHelperImpl
extends PsiNameHelper {
    private final LanguageLevelProjectExtension myLanguageLevelExtension;

    public PsiNameHelperImpl(Project project) {
        this.myLanguageLevelExtension = LanguageLevelProjectExtension.getInstance(project);
    }

    @Override
    public boolean isIdentifier(@Nullable String text2) {
        return this.isIdentifier(text2, this.getLanguageLevel());
    }

    @NotNull
    protected LanguageLevel getLanguageLevel() {
        LanguageLevel languageLevel = this.myLanguageLevelExtension.getLanguageLevel();
        if (languageLevel == null) {
            PsiNameHelperImpl.$$$reportNull$$$0(0);
        }
        return languageLevel;
    }

    @Override
    public boolean isIdentifier(@Nullable String text2, @NotNull LanguageLevel languageLevel) {
        if (languageLevel == null) {
            PsiNameHelperImpl.$$$reportNull$$$0(1);
        }
        return text2 != null && StringUtil.isJavaIdentifier(text2) && !JavaLexer.isKeyword(text2, languageLevel);
    }

    @Override
    public boolean isKeyword(@Nullable String text2) {
        return text2 != null && JavaLexer.isKeyword(text2, this.getLanguageLevel());
    }

    @Override
    public boolean isQualifiedName(@Nullable String text2) {
        if (text2 == null) {
            return false;
        }
        int index2 = 0;
        while (true) {
            int index1;
            if ((index1 = text2.indexOf(46, index2)) < 0) {
                index1 = text2.length();
            }
            if (!this.isIdentifier(text2.substring(index2, index1))) {
                return false;
            }
            if (index1 == text2.length()) {
                return true;
            }
            index2 = index1 + 1;
        }
    }

    public static PsiNameHelper getInstance() {
        return new PsiNameHelperImpl(){

            @Override
            @NotNull
            protected LanguageLevel getLanguageLevel() {
                LanguageLevel languageLevel = LanguageLevel.HIGHEST;
                if (languageLevel == null) {
                    1.$$$reportNull$$$0(0);
                }
                return languageLevel;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/com/intellij/psi/impl/PsiNameHelperImpl$1", "getLanguageLevel"));
            }
        };
    }

    private PsiNameHelperImpl() {
        this.myLanguageLevelExtension = null;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 1: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 1: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/kotlin/com/intellij/psi/impl/PsiNameHelperImpl";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "languageLevel";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getLanguageLevel";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/kotlin/com/intellij/psi/impl/PsiNameHelperImpl";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "isIdentifier";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 1: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

