/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.artifacts.ivyservice.ivyresolve;

import java.io.File;
import java.math.BigInteger;
import java.util.Collection;
import java.util.Map;
import java.util.Set;
import org.gradle.api.Transformer;
import org.gradle.api.artifacts.ArtifactIdentifier;
import org.gradle.api.artifacts.ComponentMetadataSupplierDetails;
import org.gradle.api.artifacts.ModuleIdentifier;
import org.gradle.api.artifacts.ModuleVersionIdentifier;
import org.gradle.api.artifacts.component.ComponentArtifactIdentifier;
import org.gradle.api.artifacts.component.ModuleComponentIdentifier;
import org.gradle.api.artifacts.component.ModuleComponentSelector;
import org.gradle.api.internal.artifacts.ComponentMetadataProcessor;
import org.gradle.api.internal.artifacts.DefaultModuleVersionIdentifier;
import org.gradle.api.internal.artifacts.ImmutableModuleIdentifierFactory;
import org.gradle.api.internal.artifacts.configurations.dynamicversion.CachePolicy;
import org.gradle.api.internal.artifacts.ivyservice.ivyresolve.ModuleComponentRepository;
import org.gradle.api.internal.artifacts.ivyservice.ivyresolve.ModuleComponentRepositoryAccess;
import org.gradle.api.internal.artifacts.ivyservice.modulecache.ModuleMetadataCache;
import org.gradle.api.internal.artifacts.ivyservice.modulecache.ModuleRepositoryCaches;
import org.gradle.api.internal.artifacts.ivyservice.modulecache.artifacts.ArtifactAtRepositoryKey;
import org.gradle.api.internal.artifacts.ivyservice.modulecache.artifacts.CachedArtifact;
import org.gradle.api.internal.artifacts.ivyservice.modulecache.artifacts.CachedArtifacts;
import org.gradle.api.internal.artifacts.ivyservice.modulecache.artifacts.ModuleArtifactCache;
import org.gradle.api.internal.artifacts.ivyservice.modulecache.artifacts.ModuleArtifactsCache;
import org.gradle.api.internal.artifacts.ivyservice.modulecache.dynamicversions.ModuleVersionsCache;
import org.gradle.api.internal.artifacts.ivyservice.resolveengine.artifact.ResolvableArtifact;
import org.gradle.api.internal.artifacts.repositories.resolver.MetadataFetchingCost;
import org.gradle.api.internal.component.ArtifactType;
import org.gradle.internal.action.InstantiatingAction;
import org.gradle.internal.component.external.model.FixedComponentArtifacts;
import org.gradle.internal.component.external.model.ModuleComponentArtifactMetadata;
import org.gradle.internal.component.external.model.ModuleComponentResolveMetadata;
import org.gradle.internal.component.external.model.ModuleDependencyMetadata;
import org.gradle.internal.component.model.ComponentArtifactMetadata;
import org.gradle.internal.component.model.ComponentOverrideMetadata;
import org.gradle.internal.component.model.ComponentResolveMetadata;
import org.gradle.internal.component.model.ModuleSource;
import org.gradle.internal.resolve.ArtifactNotFoundException;
import org.gradle.internal.resolve.ArtifactResolveException;
import org.gradle.internal.resolve.result.BuildableArtifactResolveResult;
import org.gradle.internal.resolve.result.BuildableArtifactSetResolveResult;
import org.gradle.internal.resolve.result.BuildableComponentArtifactsResolveResult;
import org.gradle.internal.resolve.result.BuildableModuleComponentMetaDataResolveResult;
import org.gradle.internal.resolve.result.BuildableModuleVersionListingResolveResult;
import org.gradle.internal.resolve.result.DefaultBuildableArtifactSetResolveResult;
import org.gradle.util.BuildCommencedTimeProvider;
import org.gradle.util.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CachingModuleComponentRepository
implements ModuleComponentRepository {
    private static final Logger LOGGER = LoggerFactory.getLogger(CachingModuleComponentRepository.class);
    private final ModuleVersionsCache moduleVersionsCache;
    private final ModuleMetadataCache moduleMetadataCache;
    private final ModuleArtifactsCache moduleArtifactsCache;
    private final ModuleArtifactCache moduleArtifactCache;
    private final ModuleComponentRepository delegate;
    private final CachePolicy cachePolicy;
    private final BuildCommencedTimeProvider timeProvider;
    private final ComponentMetadataProcessor metadataProcessor;
    private final ImmutableModuleIdentifierFactory moduleIdentifierFactory;
    private LocateInCacheRepositoryAccess locateInCacheRepositoryAccess = new LocateInCacheRepositoryAccess();
    private ResolveAndCacheRepositoryAccess resolveAndCacheRepositoryAccess = new ResolveAndCacheRepositoryAccess();

    public CachingModuleComponentRepository(ModuleComponentRepository delegate, ModuleRepositoryCaches caches, CachePolicy cachePolicy, BuildCommencedTimeProvider timeProvider, ComponentMetadataProcessor metadataProcessor, ImmutableModuleIdentifierFactory moduleIdentifierFactory) {
        this.delegate = delegate;
        this.moduleMetadataCache = caches.moduleMetadataCache;
        this.moduleVersionsCache = caches.moduleVersionsCache;
        this.moduleArtifactsCache = caches.moduleArtifactsCache;
        this.moduleArtifactCache = caches.moduleArtifactCache;
        this.cachePolicy = cachePolicy;
        this.timeProvider = timeProvider;
        this.metadataProcessor = metadataProcessor;
        this.moduleIdentifierFactory = moduleIdentifierFactory;
    }

    @Override
    public String getId() {
        return this.delegate.getId();
    }

    @Override
    public String getName() {
        return this.delegate.getName();
    }

    public String toString() {
        return this.delegate.toString();
    }

    @Override
    public ModuleComponentRepositoryAccess getLocalAccess() {
        return this.locateInCacheRepositoryAccess;
    }

    @Override
    public ModuleComponentRepositoryAccess getRemoteAccess() {
        return this.resolveAndCacheRepositoryAccess;
    }

    @Override
    public Map<ComponentArtifactIdentifier, ResolvableArtifact> getArtifactCache() {
        throw new UnsupportedOperationException();
    }

    @Override
    public InstantiatingAction<ComponentMetadataSupplierDetails> getComponentMetadataSupplier() {
        return this.delegate.getComponentMetadataSupplier();
    }

    private ModuleIdentifier getCacheKey(ModuleComponentSelector requested) {
        return requested.getModuleIdentifier();
    }

    private String cacheKey(ArtifactType artifactType) {
        return "artifacts:" + artifactType.name();
    }

    private ArtifactAtRepositoryKey artifactCacheKey(ComponentArtifactIdentifier id) {
        return new ArtifactAtRepositoryKey(this.delegate.getId(), id);
    }

    static class CachingModuleSource
    implements ModuleSource {
        private final BigInteger descriptorHash;
        private final boolean changingModule;
        private final ModuleSource delegate;

        public CachingModuleSource(BigInteger descriptorHash, boolean changingModule, ModuleSource delegate) {
            this.delegate = delegate;
            this.descriptorHash = descriptorHash;
            this.changingModule = changingModule;
        }

        public String toString() {
            return "{descriptor: " + this.descriptorHash + ", changing: " + this.changingModule + ", source: " + this.delegate + "}";
        }

        public BigInteger getDescriptorHash() {
            return this.descriptorHash;
        }

        public boolean isChangingModule() {
            return this.changingModule;
        }

        public ModuleSource getDelegate() {
            return this.delegate;
        }
    }

    private class ResolveAndCacheRepositoryAccess
    implements ModuleComponentRepositoryAccess {
        private ResolveAndCacheRepositoryAccess() {
        }

        public String toString() {
            return "cache > " + CachingModuleComponentRepository.this.delegate.getRemoteAccess().toString();
        }

        @Override
        public void listModuleVersions(ModuleDependencyMetadata dependency, BuildableModuleVersionListingResolveResult result) {
            CachingModuleComponentRepository.this.delegate.getRemoteAccess().listModuleVersions(dependency, result);
            switch (result.getState()) {
                case Listed: {
                    ModuleIdentifier moduleId = CachingModuleComponentRepository.this.getCacheKey(dependency.getSelector());
                    Set<String> versionList = result.getVersions();
                    CachingModuleComponentRepository.this.moduleVersionsCache.cacheModuleVersionList(CachingModuleComponentRepository.this.delegate, moduleId, versionList);
                    break;
                }
                case Failed: {
                    break;
                }
                default: {
                    throw new IllegalStateException("Unexpected state on listModuleVersions: " + (Object)((Object)result.getState()));
                }
            }
        }

        @Override
        public void resolveComponentMetaData(ModuleComponentIdentifier moduleComponentIdentifier, ComponentOverrideMetadata requestMetaData, BuildableModuleComponentMetaDataResolveResult result) {
            ComponentOverrideMetadata forced = requestMetaData.withChanging();
            CachingModuleComponentRepository.this.delegate.getRemoteAccess().resolveComponentMetaData(moduleComponentIdentifier, forced, result);
            switch (result.getState()) {
                case Missing: {
                    CachingModuleComponentRepository.this.moduleMetadataCache.cacheMissing(CachingModuleComponentRepository.this.delegate, moduleComponentIdentifier);
                    break;
                }
                case Resolved: {
                    ModuleComponentResolveMetadata resolvedMetadata = result.getMetaData();
                    ModuleSource moduleSource = resolvedMetadata.getSource();
                    ModuleMetadataCache.CachedMetadata cachedMetadata = CachingModuleComponentRepository.this.moduleMetadataCache.cacheMetaData(CachingModuleComponentRepository.this.delegate, moduleComponentIdentifier, resolvedMetadata);
                    ModuleComponentResolveMetadata processedMetadata = CachingModuleComponentRepository.this.metadataProcessor.processMetadata(resolvedMetadata);
                    cachedMetadata.setProcessedMetadata(processedMetadata);
                    moduleSource = new CachingModuleSource(processedMetadata.getContentHash().asBigInteger(), requestMetaData.isChanging() || processedMetadata.isChanging(), moduleSource);
                    result.resolved(processedMetadata.withSource(moduleSource));
                    break;
                }
                case Failed: {
                    break;
                }
                default: {
                    throw new IllegalStateException("Unexpected resolve state: " + (Object)((Object)result.getState()));
                }
            }
        }

        @Override
        public void resolveArtifactsWithType(ComponentResolveMetadata component, ArtifactType artifactType, BuildableArtifactSetResolveResult result) {
            CachingModuleSource moduleSource = (CachingModuleSource)component.getSource();
            CachingModuleComponentRepository.this.delegate.getRemoteAccess().resolveArtifactsWithType(component.withSource(moduleSource.getDelegate()), artifactType, result);
            if (result.getFailure() == null) {
                CachingModuleComponentRepository.this.moduleArtifactsCache.cacheArtifacts(CachingModuleComponentRepository.this.delegate, component.getId(), CachingModuleComponentRepository.this.cacheKey(artifactType), moduleSource.getDescriptorHash(), (Collection)result.getResult());
            }
        }

        @Override
        public void resolveArtifacts(ComponentResolveMetadata component, BuildableComponentArtifactsResolveResult result) {
            CachingModuleSource moduleSource = (CachingModuleSource)component.getSource();
            CachingModuleComponentRepository.this.delegate.getRemoteAccess().resolveArtifacts(component.withSource(moduleSource.getDelegate()), result);
            if (result.getFailure() == null) {
                FixedComponentArtifacts artifacts = (FixedComponentArtifacts)result.getResult();
                CachingModuleComponentRepository.this.moduleArtifactsCache.cacheArtifacts(CachingModuleComponentRepository.this.delegate, component.getId(), "component:", moduleSource.getDescriptorHash(), artifacts.getArtifacts());
            }
        }

        @Override
        public void resolveArtifact(ComponentArtifactMetadata artifact, ModuleSource moduleSource, BuildableArtifactResolveResult result) {
            CachingModuleSource cachingModuleSource = (CachingModuleSource)moduleSource;
            CachingModuleComponentRepository.this.delegate.getRemoteAccess().resolveArtifact(artifact, cachingModuleSource.getDelegate(), result);
            LOGGER.debug("Downloaded artifact '{}' from resolver: {}", (Object)artifact, (Object)CachingModuleComponentRepository.this.delegate.getName());
            ArtifactResolveException failure = result.getFailure();
            if (failure == null) {
                CachingModuleComponentRepository.this.moduleArtifactCache.store(CachingModuleComponentRepository.this.artifactCacheKey(artifact.getId()), result.getResult(), cachingModuleSource.getDescriptorHash());
            } else if (failure instanceof ArtifactNotFoundException) {
                CachingModuleComponentRepository.this.moduleArtifactCache.storeMissing(CachingModuleComponentRepository.this.artifactCacheKey(artifact.getId()), result.getAttempted(), cachingModuleSource.getDescriptorHash());
            }
        }

        @Override
        public MetadataFetchingCost estimateMetadataFetchingCost(ModuleComponentIdentifier moduleComponentIdentifier) {
            return CachingModuleComponentRepository.this.delegate.getLocalAccess().estimateMetadataFetchingCost(moduleComponentIdentifier);
        }
    }

    private class LocateInCacheRepositoryAccess
    implements ModuleComponentRepositoryAccess {
        private LocateInCacheRepositoryAccess() {
        }

        public String toString() {
            return "cache lookup for " + CachingModuleComponentRepository.this.delegate.toString();
        }

        @Override
        public void listModuleVersions(ModuleDependencyMetadata dependency, BuildableModuleVersionListingResolveResult result) {
            CachingModuleComponentRepository.this.delegate.getLocalAccess().listModuleVersions(dependency, result);
            if (result.hasResult()) {
                return;
            }
            this.listModuleVersionsFromCache(dependency, result);
        }

        private void listModuleVersionsFromCache(ModuleDependencyMetadata dependency, BuildableModuleVersionListingResolveResult result) {
            ModuleComponentSelector requested = dependency.getSelector();
            final ModuleIdentifier moduleId = CachingModuleComponentRepository.this.getCacheKey(requested);
            ModuleVersionsCache.CachedModuleVersionList cachedModuleVersionList = CachingModuleComponentRepository.this.moduleVersionsCache.getCachedModuleResolution(CachingModuleComponentRepository.this.delegate, moduleId);
            if (cachedModuleVersionList != null) {
                Set<String> versionList = cachedModuleVersionList.getModuleVersions();
                Set versions = CollectionUtils.collect(versionList, (Transformer)new Transformer<ModuleVersionIdentifier, String>(){

                    public ModuleVersionIdentifier transform(String original) {
                        return DefaultModuleVersionIdentifier.newId(moduleId, original);
                    }
                });
                if (CachingModuleComponentRepository.this.cachePolicy.mustRefreshVersionList(moduleId, versions, cachedModuleVersionList.getAgeMillis())) {
                    LOGGER.debug("Version listing in dynamic revision cache is expired: will perform fresh resolve of '{}' in '{}'", (Object)requested, (Object)CachingModuleComponentRepository.this.delegate.getName());
                } else {
                    result.listed(versionList);
                    result.setAuthoritative(cachedModuleVersionList.getAgeMillis() == 0L);
                }
            }
        }

        @Override
        public void resolveComponentMetaData(ModuleComponentIdentifier moduleComponentIdentifier, ComponentOverrideMetadata requestMetaData, BuildableModuleComponentMetaDataResolveResult result) {
            CachingModuleComponentRepository.this.delegate.getLocalAccess().resolveComponentMetaData(moduleComponentIdentifier, requestMetaData, result);
            if (result.hasResult()) {
                return;
            }
            this.resolveComponentMetaDataFromCache(moduleComponentIdentifier, requestMetaData, result);
        }

        private void resolveComponentMetaDataFromCache(ModuleComponentIdentifier moduleComponentIdentifier, ComponentOverrideMetadata requestMetaData, BuildableModuleComponentMetaDataResolveResult result) {
            ModuleMetadataCache.CachedMetadata cachedMetadata = CachingModuleComponentRepository.this.moduleMetadataCache.getCachedModuleDescriptor(CachingModuleComponentRepository.this.delegate, moduleComponentIdentifier);
            if (cachedMetadata == null) {
                return;
            }
            if (cachedMetadata.isMissing()) {
                if (CachingModuleComponentRepository.this.cachePolicy.mustRefreshMissingModule(moduleComponentIdentifier, cachedMetadata.getAgeMillis())) {
                    LOGGER.debug("Cached meta-data for missing module is expired: will perform fresh resolve of '{}' in '{}'", (Object)moduleComponentIdentifier, (Object)CachingModuleComponentRepository.this.delegate.getName());
                    return;
                }
                LOGGER.debug("Detected non-existence of module '{}' in resolver cache '{}'", (Object)moduleComponentIdentifier, (Object)CachingModuleComponentRepository.this.delegate.getName());
                result.missing();
                result.setAuthoritative(cachedMetadata.getAgeMillis() == 0L);
                return;
            }
            ModuleComponentResolveMetadata metadata = this.getProcessedMetadata(cachedMetadata);
            if (requestMetaData.isChanging() || metadata.isChanging()) {
                if (CachingModuleComponentRepository.this.cachePolicy.mustRefreshChangingModule(moduleComponentIdentifier, cachedMetadata.getModuleVersion(), cachedMetadata.getAgeMillis())) {
                    LOGGER.debug("Cached meta-data for changing module is expired: will perform fresh resolve of '{}' in '{}'", (Object)moduleComponentIdentifier, (Object)CachingModuleComponentRepository.this.delegate.getName());
                    return;
                }
                LOGGER.debug("Found cached version of changing module '{}' in '{}'", (Object)moduleComponentIdentifier, (Object)CachingModuleComponentRepository.this.delegate.getName());
            } else if (CachingModuleComponentRepository.this.cachePolicy.mustRefreshModule(moduleComponentIdentifier, cachedMetadata.getModuleVersion(), cachedMetadata.getAgeMillis())) {
                LOGGER.debug("Cached meta-data for module must be refreshed: will perform fresh resolve of '{}' in '{}'", (Object)moduleComponentIdentifier, (Object)CachingModuleComponentRepository.this.delegate.getName());
                return;
            }
            LOGGER.debug("Using cached module metadata for module '{}' in '{}'", (Object)moduleComponentIdentifier, (Object)CachingModuleComponentRepository.this.delegate.getName());
            metadata = metadata.withSource(new CachingModuleSource(metadata.getContentHash().asBigInteger(), metadata.isChanging(), metadata.getSource()));
            result.resolved(metadata);
            result.setAuthoritative(cachedMetadata.getAgeMillis() == 0L);
        }

        private ModuleComponentResolveMetadata getProcessedMetadata(ModuleMetadataCache.CachedMetadata cachedMetadata) {
            ModuleComponentResolveMetadata metadata = cachedMetadata.getProcessedMetadata();
            if (metadata == null) {
                metadata = CachingModuleComponentRepository.this.metadataProcessor.processMetadata(cachedMetadata.getMetadata());
                cachedMetadata.setProcessedMetadata(metadata);
            }
            return metadata;
        }

        @Override
        public void resolveArtifactsWithType(ComponentResolveMetadata component, ArtifactType artifactType, BuildableArtifactSetResolveResult result) {
            CachingModuleSource cachedModuleSource = (CachingModuleSource)component.getSource();
            CachingModuleComponentRepository.this.delegate.getLocalAccess().resolveArtifactsWithType(component.withSource(cachedModuleSource.getDelegate()), artifactType, result);
            if (result.hasResult()) {
                return;
            }
            this.resolveModuleArtifactsFromCache(CachingModuleComponentRepository.this.cacheKey(artifactType), component, result, cachedModuleSource);
        }

        @Override
        public void resolveArtifacts(ComponentResolveMetadata component, BuildableComponentArtifactsResolveResult result) {
            CachingModuleSource cachedModuleSource = (CachingModuleSource)component.getSource();
            CachingModuleComponentRepository.this.delegate.getLocalAccess().resolveArtifacts(component.withSource(cachedModuleSource.getDelegate()), result);
            if (result.hasResult()) {
                return;
            }
            DefaultBuildableArtifactSetResolveResult artifactsResolveResult = new DefaultBuildableArtifactSetResolveResult();
            this.resolveModuleArtifactsFromCache("component:", component, artifactsResolveResult, cachedModuleSource);
            if (artifactsResolveResult.hasResult()) {
                result.resolved(new FixedComponentArtifacts((Iterable)artifactsResolveResult.getResult()));
            }
        }

        private void resolveModuleArtifactsFromCache(String contextId, ComponentResolveMetadata component, BuildableArtifactSetResolveResult result, CachingModuleSource cachedModuleSource) {
            CachedArtifacts cachedModuleArtifacts = CachingModuleComponentRepository.this.moduleArtifactsCache.getCachedArtifacts(CachingModuleComponentRepository.this.delegate, component.getId(), contextId);
            BigInteger moduleDescriptorHash = cachedModuleSource.getDescriptorHash();
            if (cachedModuleArtifacts != null) {
                if (!CachingModuleComponentRepository.this.cachePolicy.mustRefreshModuleArtifacts(component.getModuleVersionId(), null, cachedModuleArtifacts.getAgeMillis(), cachedModuleSource.isChangingModule(), moduleDescriptorHash.equals(cachedModuleArtifacts.getDescriptorHash()))) {
                    result.resolved(cachedModuleArtifacts.getArtifacts());
                    return;
                }
                LOGGER.debug("Artifact listing has expired: will perform fresh resolve of '{}' for '{}' in '{}'", new Object[]{contextId, component.getModuleVersionId(), CachingModuleComponentRepository.this.delegate.getName()});
            }
        }

        @Override
        public void resolveArtifact(ComponentArtifactMetadata artifact, ModuleSource moduleSource, BuildableArtifactResolveResult result) {
            CachingModuleSource cachedModuleSource = (CachingModuleSource)moduleSource;
            CachingModuleComponentRepository.this.delegate.getLocalAccess().resolveArtifact(artifact, cachedModuleSource.getDelegate(), result);
            if (result.hasResult()) {
                return;
            }
            this.resolveArtifactFromCache(artifact, cachedModuleSource, result);
        }

        @Override
        public MetadataFetchingCost estimateMetadataFetchingCost(ModuleComponentIdentifier moduleComponentIdentifier) {
            ModuleMetadataCache.CachedMetadata cachedMetadata = CachingModuleComponentRepository.this.moduleMetadataCache.getCachedModuleDescriptor(CachingModuleComponentRepository.this.delegate, moduleComponentIdentifier);
            if (cachedMetadata == null) {
                return this.estimateCostViaRemoteAccess(moduleComponentIdentifier);
            }
            if (cachedMetadata.isMissing()) {
                if (CachingModuleComponentRepository.this.cachePolicy.mustRefreshMissingModule(moduleComponentIdentifier, cachedMetadata.getAgeMillis())) {
                    return this.estimateCostViaRemoteAccess(moduleComponentIdentifier);
                }
                return MetadataFetchingCost.CHEAP;
            }
            ModuleComponentResolveMetadata metaData = this.getProcessedMetadata(cachedMetadata);
            if (metaData.isChanging() ? CachingModuleComponentRepository.this.cachePolicy.mustRefreshChangingModule(moduleComponentIdentifier, cachedMetadata.getModuleVersion(), cachedMetadata.getAgeMillis()) : CachingModuleComponentRepository.this.cachePolicy.mustRefreshModule(moduleComponentIdentifier, cachedMetadata.getModuleVersion(), cachedMetadata.getAgeMillis())) {
                return this.estimateCostViaRemoteAccess(moduleComponentIdentifier);
            }
            return MetadataFetchingCost.FAST;
        }

        private MetadataFetchingCost estimateCostViaRemoteAccess(ModuleComponentIdentifier moduleComponentIdentifier) {
            return CachingModuleComponentRepository.this.delegate.getRemoteAccess().estimateMetadataFetchingCost(moduleComponentIdentifier);
        }

        private void resolveArtifactFromCache(ComponentArtifactMetadata artifact, CachingModuleSource moduleSource, BuildableArtifactResolveResult result) {
            CachedArtifact cached = CachingModuleComponentRepository.this.moduleArtifactCache.lookup(CachingModuleComponentRepository.this.artifactCacheKey(artifact.getId()));
            BigInteger descriptorHash = moduleSource.getDescriptorHash();
            if (cached != null) {
                long age = CachingModuleComponentRepository.this.timeProvider.getCurrentTime() - cached.getCachedAt();
                boolean isChangingModule = moduleSource.isChangingModule();
                ArtifactIdentifier artifactIdentifier = ((ModuleComponentArtifactMetadata)artifact).toArtifactIdentifier();
                if (cached.isMissing()) {
                    if (!CachingModuleComponentRepository.this.cachePolicy.mustRefreshArtifact(artifactIdentifier, null, age, isChangingModule, descriptorHash.equals(cached.getDescriptorHash()))) {
                        LOGGER.debug("Detected non-existence of artifact '{}' in resolver cache", (Object)artifact);
                        for (String location : cached.attemptedLocations()) {
                            result.attempted(location);
                        }
                        result.notFound(artifact.getId());
                    }
                } else {
                    File cachedArtifactFile = cached.getCachedFile();
                    if (!CachingModuleComponentRepository.this.cachePolicy.mustRefreshArtifact(artifactIdentifier, cachedArtifactFile, age, isChangingModule, descriptorHash.equals(cached.getDescriptorHash()))) {
                        LOGGER.debug("Found artifact '{}' in resolver cache: {}", (Object)artifact, (Object)cachedArtifactFile);
                        result.resolved(cachedArtifactFile);
                    }
                }
            }
        }
    }
}

