/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.changedetection.state;

import org.gradle.api.internal.changedetection.state.AbstractNormalizedFileSnapshot;
import org.gradle.api.internal.changedetection.state.FileContentSnapshot;
import org.gradle.api.internal.changedetection.state.NormalizedFileSnapshot;

public class IndexedNormalizedFileSnapshot
extends AbstractNormalizedFileSnapshot {
    private final String absolutePath;
    private final int index;

    public IndexedNormalizedFileSnapshot(String absolutePath, int index, FileContentSnapshot snapshot) {
        super(snapshot);
        this.absolutePath = absolutePath;
        this.index = index;
    }

    public String getNormalizedPath() {
        return this.absolutePath.substring(this.index);
    }

    public String getAbsolutePath() {
        return this.absolutePath;
    }

    public int getIndex() {
        return this.index;
    }

    protected boolean hasSameNormalizedPathAs(AbstractNormalizedFileSnapshot other) {
        if (other instanceof IndexedNormalizedFileSnapshot) {
            int otherLength;
            IndexedNormalizedFileSnapshot that = (IndexedNormalizedFileSnapshot)other;
            int myLength = this.absolutePath.length() - this.index;
            if (myLength != (otherLength = that.absolutePath.length() - that.index)) {
                return false;
            }
            return this.absolutePath.regionMatches(this.index, that.absolutePath, that.index, myLength);
        }
        return super.hasSameNormalizedPathAs(other);
    }

    protected int hashNormalizedPath() {
        int h = 0;
        for (int i = this.index; i < this.absolutePath.length(); ++i) {
            h = 31 * h + this.absolutePath.charAt(i);
        }
        return h;
    }

    protected int compareNormalizedPathTo(NormalizedFileSnapshot other) {
        if (other instanceof IndexedNormalizedFileSnapshot) {
            IndexedNormalizedFileSnapshot that = (IndexedNormalizedFileSnapshot)other;
            int length1 = this.absolutePath.length() - this.index;
            int length2 = that.absolutePath.length() - that.index;
            int limit = Math.min(length1, length2);
            for (int pos = 0; pos < limit; ++pos) {
                char c2;
                char c1 = this.absolutePath.charAt(pos + this.index);
                if (c1 == (c2 = that.absolutePath.charAt(pos + that.index))) continue;
                return c1 - c2;
            }
            return length1 - length2;
        }
        return super.compareNormalizedPathTo(other);
    }
}

