/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.changedetection.state;

import java.io.File;
import java.util.Collection;
import java.util.Collections;
import java.util.Map;
import org.gradle.api.internal.changedetection.rules.FileChange;
import org.gradle.api.internal.changedetection.rules.TaskStateChangeVisitor;
import org.gradle.api.internal.changedetection.state.FileCollectionSnapshot;
import org.gradle.api.internal.changedetection.state.FileContentSnapshot;
import org.gradle.api.internal.changedetection.state.NormalizedFileSnapshot;
import org.gradle.caching.internal.BuildCacheHasher;
import org.gradle.internal.hash.HashCode;
import org.gradle.internal.hash.Hashing;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class EmptyFileCollectionSnapshot
implements FileCollectionSnapshot {
    public static final EmptyFileCollectionSnapshot INSTANCE = new EmptyFileCollectionSnapshot();
    private static final HashCode SIGNATURE = Hashing.md5().hashString((CharSequence)EmptyFileCollectionSnapshot.class.getName());

    private EmptyFileCollectionSnapshot() {
    }

    @Override
    public boolean visitChangesSince(FileCollectionSnapshot oldSnapshot, String title, boolean includeAdded, TaskStateChangeVisitor visitor) {
        for (Map.Entry<String, FileContentSnapshot> entry : oldSnapshot.getContentSnapshots().entrySet()) {
            if (visitor.visitChange(FileChange.removed(entry.getKey(), title, entry.getValue().getType()))) continue;
            return false;
        }
        return true;
    }

    @Override
    public HashCode getHash() {
        return SIGNATURE;
    }

    @Override
    public Collection<File> getElements() {
        return Collections.emptySet();
    }

    @Override
    public Map<String, NormalizedFileSnapshot> getSnapshots() {
        return Collections.emptyMap();
    }

    @Override
    public Map<String, FileContentSnapshot> getContentSnapshots() {
        return Collections.emptyMap();
    }

    @Override
    public void appendToHasher(BuildCacheHasher hasher) {
        hasher.putHash(SIGNATURE);
    }

    public String toString() {
        return "EMPTY";
    }
}

