/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.language.cpp.plugins;

import com.google.common.collect.ImmutableSet;
import java.io.File;
import java.util.Set;
import java.util.concurrent.Callable;
import javax.inject.Inject;
import org.gradle.api.Action;
import org.gradle.api.Incubating;
import org.gradle.api.Plugin;
import org.gradle.api.artifacts.Configuration;
import org.gradle.api.artifacts.ConfigurationContainer;
import org.gradle.api.artifacts.PublishArtifact;
import org.gradle.api.attributes.Usage;
import org.gradle.api.component.SoftwareComponent;
import org.gradle.api.internal.artifacts.publish.ArchivePublishArtifact;
import org.gradle.api.internal.file.FileOperations;
import org.gradle.api.internal.project.ProjectInternal;
import org.gradle.api.internal.tasks.TaskContainerInternal;
import org.gradle.api.model.ObjectFactory;
import org.gradle.api.plugins.AppliedPlugin;
import org.gradle.api.provider.Provider;
import org.gradle.api.provider.ProviderFactory;
import org.gradle.api.publish.PublishingExtension;
import org.gradle.api.publish.maven.MavenPublication;
import org.gradle.api.publish.maven.internal.publication.MavenPublicationInternal;
import org.gradle.api.tasks.TaskContainer;
import org.gradle.api.tasks.bundling.AbstractArchiveTask;
import org.gradle.api.tasks.bundling.Zip;
import org.gradle.language.cpp.CppBinary;
import org.gradle.language.cpp.CppLibrary;
import org.gradle.language.cpp.internal.DefaultCppLibrary;
import org.gradle.language.cpp.internal.MainLibraryVariant;
import org.gradle.language.cpp.internal.NativeVariant;
import org.gradle.language.cpp.plugins.CppBasePlugin;

@Incubating
public class CppLibraryPlugin
implements Plugin<ProjectInternal> {
    private final FileOperations fileOperations;

    @Inject
    public CppLibraryPlugin(FileOperations fileOperations) {
        this.fileOperations = fileOperations;
    }

    public void apply(ProjectInternal project) {
        project.getPluginManager().apply(CppBasePlugin.class);
        TaskContainerInternal tasks = project.getTasks();
        ConfigurationContainer configurations = project.getConfigurations();
        ObjectFactory objectFactory = project.getObjects();
        ProviderFactory providers = project.getProviders();
        final CppLibrary library = (CppLibrary)project.getExtensions().create(CppLibrary.class, "library", DefaultCppLibrary.class, new Object[]{"main", project.getLayout(), project.getObjects(), this.fileOperations, project.getConfigurations()});
        project.getComponents().add((Object)library);
        project.getComponents().add((Object)library.getDebugSharedLibrary());
        project.getComponents().add((Object)library.getReleaseSharedLibrary());
        library.getBaseName().set((Object)project.getName());
        tasks.getByName("assemble").dependsOn(new Object[]{library.getDevelopmentBinary().getRuntimeFile()});
        Usage apiUsage = (Usage)objectFactory.named(Usage.class, "cplusplus-api");
        Configuration apiElements = (Configuration)configurations.maybeCreate("cppApiElements");
        apiElements.extendsFrom(new Configuration[]{library.getApiDependencies()});
        apiElements.setCanBeResolved(false);
        apiElements.getAttributes().attribute(Usage.USAGE_ATTRIBUTE, (Object)apiUsage);
        Provider publicHeaders = providers.provider((Callable)new Callable<File>(){

            @Override
            public File call() throws Exception {
                Set files = library.getPublicHeaderDirs().getFiles();
                if (files.size() != 1) {
                    throw new UnsupportedOperationException(String.format("The C++ library plugin currently requires exactly one public header directory, however there are %d directories configured: %s", files.size(), files));
                }
                return (File)files.iterator().next();
            }
        });
        apiElements.getOutgoing().artifact((Object)publicHeaders);
        Configuration implementation = library.getImplementationDependencies();
        Usage linkUsage = (Usage)objectFactory.named(Usage.class, "native-link");
        Usage runtimeUsage = (Usage)objectFactory.named(Usage.class, "native-runtime");
        Configuration debugLinkElements = (Configuration)configurations.maybeCreate("debugLinkElements");
        debugLinkElements.extendsFrom(new Configuration[]{implementation});
        debugLinkElements.setCanBeResolved(false);
        debugLinkElements.getAttributes().attribute(Usage.USAGE_ATTRIBUTE, (Object)linkUsage);
        debugLinkElements.getAttributes().attribute(CppBinary.DEBUGGABLE_ATTRIBUTE, (Object)true);
        debugLinkElements.getOutgoing().artifact(library.getDebugSharedLibrary().getLinkFile());
        Configuration debugRuntimeElements = (Configuration)configurations.maybeCreate("debugRuntimeElements");
        debugRuntimeElements.extendsFrom(new Configuration[]{implementation});
        debugRuntimeElements.setCanBeResolved(false);
        debugRuntimeElements.getAttributes().attribute(Usage.USAGE_ATTRIBUTE, (Object)runtimeUsage);
        debugRuntimeElements.getAttributes().attribute(CppBinary.DEBUGGABLE_ATTRIBUTE, (Object)true);
        debugRuntimeElements.getOutgoing().artifact(library.getDebugSharedLibrary().getRuntimeFile());
        Configuration releaseLinkElements = (Configuration)configurations.maybeCreate("releaseLinkElements");
        releaseLinkElements.extendsFrom(new Configuration[]{implementation});
        releaseLinkElements.setCanBeResolved(false);
        releaseLinkElements.getAttributes().attribute(Usage.USAGE_ATTRIBUTE, (Object)linkUsage);
        releaseLinkElements.getAttributes().attribute(CppBinary.DEBUGGABLE_ATTRIBUTE, (Object)false);
        releaseLinkElements.getOutgoing().artifact(library.getReleaseSharedLibrary().getLinkFile());
        Configuration releaseRuntimeElements = (Configuration)configurations.maybeCreate("releaseRuntimeElements");
        releaseRuntimeElements.extendsFrom(new Configuration[]{implementation});
        releaseRuntimeElements.setCanBeResolved(false);
        releaseRuntimeElements.getAttributes().attribute(Usage.USAGE_ATTRIBUTE, (Object)runtimeUsage);
        releaseRuntimeElements.getAttributes().attribute(CppBinary.DEBUGGABLE_ATTRIBUTE, (Object)false);
        releaseRuntimeElements.getOutgoing().artifact(library.getReleaseSharedLibrary().getRuntimeFile());
        project.getPluginManager().withPlugin("maven-publish", (Action)new Action<AppliedPlugin>((TaskContainer)tasks, library, project, apiUsage, apiElements, linkUsage, debugLinkElements, runtimeUsage, debugRuntimeElements, releaseLinkElements, releaseRuntimeElements){
            final /* synthetic */ TaskContainer val$tasks;
            final /* synthetic */ CppLibrary val$library;
            final /* synthetic */ ProjectInternal val$project;
            final /* synthetic */ Usage val$apiUsage;
            final /* synthetic */ Configuration val$apiElements;
            final /* synthetic */ Usage val$linkUsage;
            final /* synthetic */ Configuration val$debugLinkElements;
            final /* synthetic */ Usage val$runtimeUsage;
            final /* synthetic */ Configuration val$debugRuntimeElements;
            final /* synthetic */ Configuration val$releaseLinkElements;
            final /* synthetic */ Configuration val$releaseRuntimeElements;
            {
                this.val$tasks = taskContainer;
                this.val$library = cppLibrary;
                this.val$project = projectInternal;
                this.val$apiUsage = usage;
                this.val$apiElements = configuration;
                this.val$linkUsage = usage2;
                this.val$debugLinkElements = configuration2;
                this.val$runtimeUsage = usage3;
                this.val$debugRuntimeElements = configuration3;
                this.val$releaseLinkElements = configuration4;
                this.val$releaseRuntimeElements = configuration5;
            }

            public void execute(AppliedPlugin appliedPlugin) {
                Zip headersZip = (Zip)this.val$tasks.create("cppHeaders", Zip.class);
                headersZip.from(new Object[]{this.val$library.getPublicHeaderFiles()});
                headersZip.setDestinationDir(new File(this.val$project.getBuildDir(), "headers"));
                headersZip.setClassifier("cpp-api-headers");
                headersZip.setArchiveName("cpp-api-headers.zip");
                final MainLibraryVariant mainVariant = new MainLibraryVariant("api", this.val$apiUsage, (Set<? extends PublishArtifact>)ImmutableSet.of((Object)new ArchivePublishArtifact((AbstractArchiveTask)headersZip)), this.val$apiElements);
                NativeVariant debugVariant = new NativeVariant("debug", this.val$linkUsage, this.val$debugLinkElements, this.val$runtimeUsage, this.val$debugRuntimeElements);
                mainVariant.addVariant((SoftwareComponent)debugVariant);
                NativeVariant releaseVariant = new NativeVariant("release", this.val$linkUsage, this.val$releaseLinkElements, this.val$runtimeUsage, this.val$releaseRuntimeElements);
                mainVariant.addVariant((SoftwareComponent)releaseVariant);
                this.val$project.getExtensions().configure(PublishingExtension.class, (Action)new Action<PublishingExtension>(){

                    public void execute(PublishingExtension extension) {
                        extension.getPublications().create("main", MavenPublication.class, (Action)new Action<MavenPublication>(){

                            public void execute(MavenPublication publication) {
                                publication.setGroupId(val$project.getGroup().toString());
                                publication.setArtifactId((String)val$library.getBaseName().get());
                                publication.setVersion(val$project.getVersion().toString());
                                publication.from((SoftwareComponent)mainVariant);
                                ((MavenPublicationInternal)publication).publishWithOriginalFileName();
                            }
                        });
                        for (final SoftwareComponent softwareComponent : mainVariant.getVariants()) {
                            extension.getPublications().create(softwareComponent.getName(), MavenPublication.class, (Action)new Action<MavenPublication>(){

                                public void execute(MavenPublication publication) {
                                    publication.setGroupId(val$project.getGroup().toString());
                                    publication.setArtifactId((String)val$library.getBaseName().get() + "_" + softwareComponent.getName());
                                    publication.setVersion(val$project.getVersion().toString());
                                    publication.from(softwareComponent);
                                    ((MavenPublicationInternal)publication).publishWithOriginalFileName();
                                }
                            });
                        }
                    }
                });
            }
        });
    }
}

