/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.nativeplatform.test.cpp.plugins;

import javax.inject.Inject;
import org.gradle.api.Action;
import org.gradle.api.Incubating;
import org.gradle.api.Plugin;
import org.gradle.api.artifacts.ConfigurationContainer;
import org.gradle.api.file.Directory;
import org.gradle.api.internal.file.FileOperations;
import org.gradle.api.internal.project.ProjectInternal;
import org.gradle.api.internal.tasks.TaskContainerInternal;
import org.gradle.api.model.ObjectFactory;
import org.gradle.api.tasks.TaskContainer;
import org.gradle.language.cpp.CppComponent;
import org.gradle.language.cpp.plugins.CppBasePlugin;
import org.gradle.language.cpp.plugins.CppExecutablePlugin;
import org.gradle.language.cpp.plugins.CppLibraryPlugin;
import org.gradle.nativeplatform.tasks.AbstractLinkTask;
import org.gradle.nativeplatform.tasks.InstallExecutable;
import org.gradle.nativeplatform.test.cpp.CppTestSuite;
import org.gradle.nativeplatform.test.cpp.internal.DefaultCppTestSuite;
import org.gradle.nativeplatform.test.tasks.RunTestExecutable;
import org.gradle.testing.base.plugins.TestingBasePlugin;

@Incubating
public class CppUnitTestPlugin
implements Plugin<ProjectInternal> {
    private final ObjectFactory objectFactory;
    private final FileOperations fileOperations;

    @Inject
    public CppUnitTestPlugin(FileOperations fileOperations, ObjectFactory objectFactory) {
        this.fileOperations = fileOperations;
        this.objectFactory = objectFactory;
    }

    public void apply(final ProjectInternal project) {
        project.getPluginManager().apply(CppBasePlugin.class);
        project.getPluginManager().apply(TestingBasePlugin.class);
        ConfigurationContainer configurations = project.getConfigurations();
        final CppTestSuite testComponent = (CppTestSuite)this.objectFactory.newInstance(DefaultCppTestSuite.class, new Object[]{"unitTest", project.getLayout(), this.objectFactory, this.fileOperations, configurations});
        project.getComponents().add((Object)testComponent);
        project.getComponents().add((Object)testComponent.getTestExecutable());
        project.getExtensions().add(CppTestSuite.class, "unitTest", (Object)testComponent);
        Action<Plugin<ProjectInternal>> projectConfiguration = new Action<Plugin<ProjectInternal>>(){

            public void execute(Plugin<ProjectInternal> plugin) {
                TaskContainerInternal tasks = project.getTasks();
                CppComponent mainComponent = (CppComponent)project.getComponents().withType(CppComponent.class).findByName("main");
                ((DefaultCppTestSuite)testComponent).getTestedComponent().set((Object)mainComponent);
                AbstractLinkTask linkTest = (AbstractLinkTask)tasks.withType(AbstractLinkTask.class).getByName("linkUnitTest");
                linkTest.source((Object)mainComponent.getDevelopmentBinary().getObjects());
                RunTestExecutable testTask = (RunTestExecutable)tasks.create("runUnitTest", RunTestExecutable.class, (Action)new Action<RunTestExecutable>((TaskContainer)tasks){
                    final /* synthetic */ TaskContainer val$tasks;
                    {
                        this.val$tasks = taskContainer;
                    }

                    public void execute(RunTestExecutable testTask) {
                        testTask.setGroup("verification");
                        testTask.setDescription("Executes C++ unit tests.");
                        InstallExecutable installTask = (InstallExecutable)this.val$tasks.getByName("installUnitTest");
                        testTask.setExecutable(installTask.getRunScript());
                        testTask.dependsOn(new Object[]{testComponent.getTestExecutable().getInstallDirectory()});
                        testTask.setOutputDir(((Directory)project.getLayout().getBuildDirectory().dir("test-results/unitTest").get()).getAsFile());
                    }
                });
                tasks.getByName("check").dependsOn(new Object[]{testTask});
            }
        };
        project.getPlugins().withType(CppLibraryPlugin.class, (Action)projectConfiguration);
        project.getPlugins().withType(CppExecutablePlugin.class, (Action)projectConfiguration);
    }
}

