/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.artifacts.vcs;

import java.io.File;
import java.util.Set;
import org.gradle.api.GradleException;
import org.gradle.api.artifacts.component.ComponentSelector;
import org.gradle.api.artifacts.component.ModuleComponentSelector;
import org.gradle.api.initialization.ConfigurableIncludedBuild;
import org.gradle.api.initialization.IncludedBuild;
import org.gradle.api.internal.artifacts.ivyservice.ivyresolve.ComponentResolvers;
import org.gradle.api.internal.artifacts.ivyservice.projectmodule.LocalComponentRegistry;
import org.gradle.api.internal.artifacts.ivyservice.projectmodule.ProjectDependencyResolver;
import org.gradle.composite.internal.IncludedBuildRegistry;
import org.gradle.initialization.NestedBuildFactory;
import org.gradle.internal.component.local.model.DefaultProjectComponentIdentifier;
import org.gradle.internal.component.local.model.DefaultProjectComponentSelector;
import org.gradle.internal.component.local.model.LocalComponentMetadata;
import org.gradle.internal.component.model.DependencyMetadata;
import org.gradle.internal.hash.HashUtil;
import org.gradle.internal.resolve.ModuleVersionResolveException;
import org.gradle.internal.resolve.resolver.ArtifactResolver;
import org.gradle.internal.resolve.resolver.ComponentMetaDataResolver;
import org.gradle.internal.resolve.resolver.DependencyToComponentIdResolver;
import org.gradle.internal.resolve.resolver.OriginArtifactSelector;
import org.gradle.internal.resolve.result.BuildableComponentIdResolveResult;
import org.gradle.internal.service.ServiceRegistry;
import org.gradle.vcs.VersionControlSpec;
import org.gradle.vcs.VersionControlSystem;
import org.gradle.vcs.VersionRef;
import org.gradle.vcs.internal.VcsMappingFactory;
import org.gradle.vcs.internal.VcsMappingInternal;
import org.gradle.vcs.internal.VcsMappingsInternal;
import org.gradle.vcs.internal.VersionControlSystemFactory;

public class VcsDependencyResolver
implements DependencyToComponentIdResolver,
ComponentResolvers {
    private final ProjectDependencyResolver projectDependencyResolver;
    private final ServiceRegistry serviceRegistry;
    private final LocalComponentRegistry localComponentRegistry;
    private final VcsMappingsInternal vcsMappingsInternal;
    private final VcsMappingFactory vcsMappingFactory;
    private final VersionControlSystemFactory versionControlSystemFactory;
    private final File baseWorkingDir;

    public VcsDependencyResolver(File projectCacheDir, ProjectDependencyResolver projectDependencyResolver, ServiceRegistry serviceRegistry, LocalComponentRegistry localComponentRegistry, VcsMappingsInternal vcsMappingsInternal, VcsMappingFactory vcsMappingFactory, VersionControlSystemFactory versionControlSystemFactory) {
        this.baseWorkingDir = new File(projectCacheDir, "vcsWorkingDirs");
        this.projectDependencyResolver = projectDependencyResolver;
        this.serviceRegistry = serviceRegistry;
        this.localComponentRegistry = localComponentRegistry;
        this.vcsMappingsInternal = vcsMappingsInternal;
        this.vcsMappingFactory = vcsMappingFactory;
        this.versionControlSystemFactory = versionControlSystemFactory;
    }

    @Override
    public void resolve(DependencyMetadata dependency, BuildableComponentIdResolveResult result) {
        VcsMappingInternal vcsMappingInternal = this.getVcsMapping(dependency);
        if (vcsMappingInternal != null) {
            this.vcsMappingsInternal.getVcsMappingRule().execute((Object)vcsMappingInternal);
            if (vcsMappingInternal.hasRepository()) {
                String projectPath;
                NestedBuildFactory nestedBuildFactory;
                VersionRef selectedVersion;
                VersionControlSystem versionControlSystem;
                VersionControlSpec spec = vcsMappingInternal.getRepository();
                File dependencyWorkingDir = this.populateWorkingDirectory(this.baseWorkingDir, spec, versionControlSystem = this.versionControlSystemFactory.create(spec), selectedVersion = this.selectVersionFromRepository(spec, versionControlSystem));
                if (!new File(dependencyWorkingDir, "settings.gradle").exists() && !new File(dependencyWorkingDir, "settings.gradle.kts").exists()) {
                    throw new GradleException(String.format("Included build from '%s' must contain a settings file.", spec.getDisplayName()));
                }
                IncludedBuildRegistry includedBuildRegistry = (IncludedBuildRegistry)this.serviceRegistry.get(IncludedBuildRegistry.class);
                ConfigurableIncludedBuild includedBuild = includedBuildRegistry.addImplicitBuild(dependencyWorkingDir, nestedBuildFactory = (NestedBuildFactory)this.serviceRegistry.get(NestedBuildFactory.class));
                LocalComponentMetadata componentMetaData = this.localComponentRegistry.getComponent(DefaultProjectComponentIdentifier.newProjectId((IncludedBuild)includedBuild, projectPath = ":"));
                if (componentMetaData == null) {
                    result.failed(new ModuleVersionResolveException((ComponentSelector)DefaultProjectComponentSelector.newSelector((IncludedBuild)includedBuild, projectPath), vcsMappingInternal + " could not be resolved into a usable project."));
                } else {
                    result.resolved(componentMetaData);
                }
                return;
            }
        }
        this.projectDependencyResolver.resolve(dependency, result);
    }

    private File populateWorkingDirectory(File baseWorkingDir, VersionControlSpec spec, VersionControlSystem versionControlSystem, VersionRef selectedVersion) {
        String repositoryId = HashUtil.createCompactMD5((String)spec.getUniqueId());
        File versionDirectory = new File(baseWorkingDir, repositoryId + "/" + selectedVersion.getCanonicalId());
        return versionControlSystem.populate(versionDirectory, selectedVersion, spec);
    }

    private VersionRef selectVersionFromRepository(VersionControlSpec spec, VersionControlSystem versionControlSystem) {
        Set versions = versionControlSystem.getAvailableVersions(spec);
        return (VersionRef)versions.iterator().next();
    }

    private VcsMappingInternal getVcsMapping(DependencyMetadata dependency) {
        if (this.vcsMappingsInternal.hasRules() && dependency.getSelector() instanceof ModuleComponentSelector && ((ModuleComponentSelector)dependency.getSelector()).getVersionConstraint().getPreferredVersion().equals("latest.integration")) {
            return this.vcsMappingFactory.create(dependency.getSelector());
        }
        return null;
    }

    @Override
    public DependencyToComponentIdResolver getComponentIdResolver() {
        return this;
    }

    @Override
    public ComponentMetaDataResolver getComponentResolver() {
        return this.projectDependencyResolver;
    }

    @Override
    public OriginArtifactSelector getArtifactSelector() {
        return this.projectDependencyResolver;
    }

    @Override
    public ArtifactResolver getArtifactResolver() {
        return this.projectDependencyResolver;
    }
}

