/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.artifacts.ivyservice.resolveengine.graph.builder;

import com.google.common.collect.Sets;
import java.util.Collections;
import java.util.Set;
import org.gradle.api.internal.artifacts.ivyservice.resolveengine.graph.builder.NodeState;

public class PendingOptionalDependencies {
    private boolean noLongerOptional;
    private final Set<NodeState> affectedComponents;

    public static PendingOptionalDependencies pending() {
        return new PendingOptionalDependencies(Sets.newLinkedHashSet(), false);
    }

    public static PendingOptionalDependencies notOptional() {
        return new PendingOptionalDependencies(Collections.<NodeState>emptySet(), true);
    }

    private PendingOptionalDependencies(Set<NodeState> nodeStates, boolean noLongerOptional) {
        this.affectedComponents = nodeStates;
        this.noLongerOptional = noLongerOptional;
    }

    void addNode(NodeState state) {
        if (this.noLongerOptional) {
            throw new IllegalStateException("Cannot add a pending node for a dependency which is not optional");
        }
        this.affectedComponents.add(state);
    }

    void turnIntoHardDependencies() {
        this.noLongerOptional = true;
        for (NodeState affectedComponent : this.affectedComponents) {
            affectedComponent.resetSelectionState();
        }
    }

    public boolean isPending() {
        return !this.noLongerOptional;
    }
}

