/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.artifacts.dependencies;

import com.google.common.base.Objects;
import groovy.lang.Closure;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import javax.annotation.Nullable;
import org.gradle.api.Action;
import org.gradle.api.artifacts.DependencyArtifact;
import org.gradle.api.artifacts.ExcludeRule;
import org.gradle.api.artifacts.ModuleDependency;
import org.gradle.api.internal.artifacts.DefaultExcludeRuleContainer;
import org.gradle.api.internal.artifacts.dependencies.AbstractDependency;
import org.gradle.api.internal.artifacts.dependencies.DefaultDependencyArtifact;
import org.gradle.internal.Actions;
import org.gradle.internal.ImmutableActionSet;
import org.gradle.util.ConfigureUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractModuleDependency
extends AbstractDependency
implements ModuleDependency {
    private DefaultExcludeRuleContainer excludeRuleContainer = new DefaultExcludeRuleContainer();
    private Set<DependencyArtifact> artifacts = new HashSet<DependencyArtifact>();
    private Action<? super ModuleDependency> onMutate = Actions.doNothing();
    @Nullable
    private String configuration;
    private boolean transitive = true;

    protected AbstractModuleDependency(@Nullable String configuration) {
        this.configuration = configuration;
    }

    public boolean isTransitive() {
        return this.transitive;
    }

    public ModuleDependency setTransitive(boolean transitive) {
        this.validateMutation(this.transitive, transitive);
        this.transitive = transitive;
        return this;
    }

    public String getTargetConfiguration() {
        return this.configuration;
    }

    public void setTargetConfiguration(@Nullable String configuration) {
        this.validateMutation(this.configuration, configuration);
        this.configuration = configuration;
    }

    public ModuleDependency exclude(Map<String, String> excludeProperties) {
        if (this.excludeRuleContainer.maybeAdd(excludeProperties)) {
            this.validateMutation();
        }
        return this;
    }

    public Set<ExcludeRule> getExcludeRules() {
        return this.excludeRuleContainer.getRules();
    }

    private void setExcludeRuleContainer(DefaultExcludeRuleContainer excludeRuleContainer) {
        this.excludeRuleContainer = excludeRuleContainer;
    }

    public Set<DependencyArtifact> getArtifacts() {
        return this.artifacts;
    }

    public void setArtifacts(Set<DependencyArtifact> artifacts) {
        this.artifacts = artifacts;
    }

    public AbstractModuleDependency addArtifact(DependencyArtifact artifact) {
        this.artifacts.add(artifact);
        return this;
    }

    public DependencyArtifact artifact(Closure configureClosure) {
        return this.artifact(ConfigureUtil.configureUsing(configureClosure));
    }

    public DependencyArtifact artifact(Action<? super DependencyArtifact> configureAction) {
        DefaultDependencyArtifact artifact = new DefaultDependencyArtifact();
        configureAction.execute((Object)artifact);
        this.artifacts.add(artifact);
        return artifact;
    }

    protected void copyTo(AbstractModuleDependency target) {
        super.copyTo(target);
        target.setArtifacts(new HashSet<DependencyArtifact>(this.getArtifacts()));
        target.setExcludeRuleContainer(new DefaultExcludeRuleContainer(this.getExcludeRules()));
        target.setTransitive(this.isTransitive());
    }

    protected boolean isKeyEquals(ModuleDependency dependencyRhs) {
        if (this.getGroup() != null ? !this.getGroup().equals(dependencyRhs.getGroup()) : dependencyRhs.getGroup() != null) {
            return false;
        }
        if (!this.getName().equals(dependencyRhs.getName())) {
            return false;
        }
        if (this.getTargetConfiguration() != null ? !this.getTargetConfiguration().equals(dependencyRhs.getTargetConfiguration()) : dependencyRhs.getTargetConfiguration() != null) {
            return false;
        }
        return !(this.getVersion() != null ? !this.getVersion().equals(dependencyRhs.getVersion()) : dependencyRhs.getVersion() != null);
    }

    protected boolean isCommonContentEquals(ModuleDependency dependencyRhs) {
        if (!this.isKeyEquals(dependencyRhs)) {
            return false;
        }
        if (this.isTransitive() != dependencyRhs.isTransitive()) {
            return false;
        }
        if (this.getArtifacts() != null ? !this.getArtifacts().equals(dependencyRhs.getArtifacts()) : dependencyRhs.getArtifacts() != null) {
            return false;
        }
        return !(this.getExcludeRules() != null ? !this.getExcludeRules().equals(dependencyRhs.getExcludeRules()) : dependencyRhs.getExcludeRules() != null);
    }

    public void addMutationValidator(Action<? super ModuleDependency> action) {
        this.onMutate = ImmutableActionSet.of((Action[])new Action[]{this.onMutate, action});
    }

    protected void validateMutation() {
        this.onMutate.execute((Object)this);
    }

    protected void validateMutation(Object currentValue, Object newValue) {
        if (!Objects.equal((Object)currentValue, (Object)newValue)) {
            this.validateMutation();
        }
    }
}

