/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.com.intellij.psi.util;

import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import javax.swing.Icon;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.com.intellij.lang.ASTNode;
import org.jetbrains.kotlin.com.intellij.lang.FileASTNode;
import org.jetbrains.kotlin.com.intellij.lang.Language;
import org.jetbrains.kotlin.com.intellij.navigation.ItemPresentation;
import org.jetbrains.kotlin.com.intellij.openapi.application.ReadAction;
import org.jetbrains.kotlin.com.intellij.openapi.diagnostic.Attachment;
import org.jetbrains.kotlin.com.intellij.openapi.diagnostic.Logger;
import org.jetbrains.kotlin.com.intellij.openapi.editor.Document;
import org.jetbrains.kotlin.com.intellij.openapi.fileEditor.FileDocumentManager;
import org.jetbrains.kotlin.com.intellij.openapi.fileTypes.FileType;
import org.jetbrains.kotlin.com.intellij.openapi.fileTypes.FileTypeRegistry;
import org.jetbrains.kotlin.com.intellij.openapi.project.Project;
import org.jetbrains.kotlin.com.intellij.openapi.roots.FileIndexFacade;
import org.jetbrains.kotlin.com.intellij.openapi.util.Comparing;
import org.jetbrains.kotlin.com.intellij.openapi.util.Key;
import org.jetbrains.kotlin.com.intellij.openapi.util.TextRange;
import org.jetbrains.kotlin.com.intellij.openapi.vfs.VirtualFile;
import org.jetbrains.kotlin.com.intellij.psi.FileViewProvider;
import org.jetbrains.kotlin.com.intellij.psi.PsiDirectory;
import org.jetbrains.kotlin.com.intellij.psi.PsiElement;
import org.jetbrains.kotlin.com.intellij.psi.PsiElementVisitor;
import org.jetbrains.kotlin.com.intellij.psi.PsiErrorElement;
import org.jetbrains.kotlin.com.intellij.psi.PsiFile;
import org.jetbrains.kotlin.com.intellij.psi.PsiFileSystemItem;
import org.jetbrains.kotlin.com.intellij.psi.PsiInvalidElementAccessException;
import org.jetbrains.kotlin.com.intellij.psi.PsiManager;
import org.jetbrains.kotlin.com.intellij.psi.PsiNamedElement;
import org.jetbrains.kotlin.com.intellij.psi.PsiReference;
import org.jetbrains.kotlin.com.intellij.psi.PsiWhiteSpace;
import org.jetbrains.kotlin.com.intellij.psi.ResolveState;
import org.jetbrains.kotlin.com.intellij.psi.StubBasedPsiElement;
import org.jetbrains.kotlin.com.intellij.psi.meta.PsiMetaData;
import org.jetbrains.kotlin.com.intellij.psi.meta.PsiMetaOwner;
import org.jetbrains.kotlin.com.intellij.psi.scope.PsiScopeProcessor;
import org.jetbrains.kotlin.com.intellij.psi.search.GlobalSearchScope;
import org.jetbrains.kotlin.com.intellij.psi.search.PsiElementProcessor;
import org.jetbrains.kotlin.com.intellij.psi.search.SearchScope;
import org.jetbrains.kotlin.com.intellij.psi.tree.IElementType;
import org.jetbrains.kotlin.com.intellij.psi.util.PsiTreeUtil;
import org.jetbrains.kotlin.com.intellij.testFramework.LightVirtualFile;
import org.jetbrains.kotlin.com.intellij.util.IncorrectOperationException;
import org.jetbrains.kotlin.com.intellij.util.TimeoutUtil;

public class PsiUtilCore {
    private static final Logger LOG = Logger.getInstance("#com.intellij.psi.util.PsiUtilCore");
    public static final PsiElement NULL_PSI_ELEMENT = new NullPsiElement();
    public static final PsiFile NULL_PSI_FILE = new NullPsiFile();

    @NotNull
    public static PsiElement[] toPsiElementArray(@NotNull Collection<? extends PsiElement> collection) {
        if (collection == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "collection", "org/jetbrains/kotlin/com/intellij/psi/util/PsiUtilCore", "toPsiElementArray"));
        }
        if (collection.isEmpty()) {
            if (PsiElement.EMPTY_ARRAY == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/com/intellij/psi/util/PsiUtilCore", "toPsiElementArray"));
            }
            return PsiElement.EMPTY_ARRAY;
        }
        PsiElement[] psiElementArray = collection.toArray(new PsiElement[collection.size()]);
        if (psiElementArray == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/com/intellij/psi/util/PsiUtilCore", "toPsiElementArray"));
        }
        return psiElementArray;
    }

    public static Language getNotAnyLanguage(ASTNode node) {
        if (node == null) {
            return Language.ANY;
        }
        Language lang = node.getElementType().getLanguage();
        return lang == Language.ANY ? PsiUtilCore.getNotAnyLanguage(node.getTreeParent()) : lang;
    }

    @Nullable
    public static VirtualFile getVirtualFile(@Nullable PsiElement element) {
        PsiFile originalFile;
        if (element == null) {
            return null;
        }
        if (element instanceof PsiFileSystemItem) {
            return element.isValid() ? ((PsiFileSystemItem)element).getVirtualFile() : null;
        }
        PsiFile containingFile = element.getContainingFile();
        if (containingFile == null || !containingFile.isValid()) {
            return null;
        }
        VirtualFile file = containingFile.getVirtualFile();
        if (file == null && (originalFile = containingFile.getOriginalFile()) != containingFile && originalFile.isValid()) {
            file = originalFile.getVirtualFile();
        }
        return file;
    }

    public static int compareElementsByPosition(PsiElement element1, PsiElement element2) {
        if (element1 != null && element2 != null) {
            PsiFile psiFile2;
            PsiFile psiFile1 = element1.getContainingFile();
            if (Comparing.equal(psiFile1, psiFile2 = element2.getContainingFile())) {
                TextRange textRange1 = element1.getTextRange();
                TextRange textRange2 = element2.getTextRange();
                if (textRange1 != null && textRange2 != null) {
                    return textRange1.getStartOffset() - textRange2.getStartOffset();
                }
            } else if (psiFile1 != null && psiFile2 != null) {
                String name1 = psiFile1.getName();
                String name2 = psiFile2.getName();
                return name1.compareToIgnoreCase(name2);
            }
        }
        return 0;
    }

    public static boolean hasErrorElementChild(@NotNull PsiElement element) {
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "org/jetbrains/kotlin/com/intellij/psi/util/PsiUtilCore", "hasErrorElementChild"));
        }
        for (PsiElement child = element.getFirstChild(); child != null; child = child.getNextSibling()) {
            if (!(child instanceof PsiErrorElement)) continue;
            return true;
        }
        return false;
    }

    @NotNull
    public static PsiElement getElementAtOffset(@NotNull PsiFile file, int offset2) {
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "org/jetbrains/kotlin/com/intellij/psi/util/PsiUtilCore", "getElementAtOffset"));
        }
        PsiElement elt = file.findElementAt(offset2);
        if (elt == null && offset2 > 0) {
            elt = file.findElementAt(offset2 - 1);
        }
        if (elt == null) {
            PsiFile psiFile = file;
            if (psiFile == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/com/intellij/psi/util/PsiUtilCore", "getElementAtOffset"));
            }
            return psiFile;
        }
        PsiElement psiElement = elt;
        if (psiElement == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/com/intellij/psi/util/PsiUtilCore", "getElementAtOffset"));
        }
        return psiElement;
    }

    @Nullable
    public static PsiFile getTemplateLanguageFile(@Nullable PsiElement element) {
        if (element == null) {
            return null;
        }
        PsiFile containingFile = element.getContainingFile();
        if (containingFile == null) {
            return null;
        }
        FileViewProvider viewProvider = containingFile.getViewProvider();
        return viewProvider.getPsi(viewProvider.getBaseLanguage());
    }

    @NotNull
    public static PsiFile[] toPsiFileArray(@NotNull Collection<? extends PsiFile> collection) {
        if (collection == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "collection", "org/jetbrains/kotlin/com/intellij/psi/util/PsiUtilCore", "toPsiFileArray"));
        }
        if (collection.isEmpty()) {
            if (PsiFile.EMPTY_ARRAY == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/com/intellij/psi/util/PsiUtilCore", "toPsiFileArray"));
            }
            return PsiFile.EMPTY_ARRAY;
        }
        PsiFile[] psiFileArray = collection.toArray(new PsiFile[collection.size()]);
        if (psiFileArray == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/com/intellij/psi/util/PsiUtilCore", "toPsiFileArray"));
        }
        return psiFileArray;
    }

    @NotNull
    public static <VF extends VirtualFile> List<PsiFile> toPsiFiles(@NotNull PsiManager psiManager, @NotNull Collection<VF> virtualFiles) {
        if (psiManager == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "psiManager", "org/jetbrains/kotlin/com/intellij/psi/util/PsiUtilCore", "toPsiFiles"));
        }
        if (virtualFiles == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "virtualFiles", "org/jetbrains/kotlin/com/intellij/psi/util/PsiUtilCore", "toPsiFiles"));
        }
        List<PsiFile> list2 = virtualFiles.stream().map(psiManager::findFile).filter(Objects::nonNull).collect(Collectors.toList());
        if (list2 == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/com/intellij/psi/util/PsiUtilCore", "toPsiFiles"));
        }
        return list2;
    }

    @Nullable
    public static String getName(PsiElement element) {
        PsiMetaData data2;
        String name = null;
        if (element instanceof PsiMetaOwner && (data2 = ((PsiMetaOwner)((Object)element)).getMetaData()) != null) {
            name = data2.getName(element);
        }
        if (name == null && element instanceof PsiNamedElement) {
            name = ((PsiNamedElement)element).getName();
        }
        return name;
    }

    public static String getQualifiedNameAfterRename(String qName, String newName2) {
        if (qName == null) {
            return newName2;
        }
        int index2 = qName.lastIndexOf(46);
        return index2 < 0 ? newName2 : qName.substring(0, index2 + 1) + newName2;
    }

    public static Language getDialect(@NotNull PsiElement element) {
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "org/jetbrains/kotlin/com/intellij/psi/util/PsiUtilCore", "getDialect"));
        }
        return PsiUtilCore.narrowLanguage(element.getLanguage(), element.getContainingFile().getLanguage());
    }

    protected static Language narrowLanguage(Language language, Language candidate) {
        if (candidate.isKindOf(language)) {
            return candidate;
        }
        return language;
    }

    public static void ensureValid(@NotNull PsiElement element) {
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "org/jetbrains/kotlin/com/intellij/psi/util/PsiUtilCore", "ensureValid"));
        }
        if (!element.isValid()) {
            TimeoutUtil.sleep(1L);
            if (element.isValid()) {
                LOG.error("PSI resurrected: " + element + " of " + element.getClass());
                return;
            }
            throw new PsiInvalidElementAccessException(element);
        }
    }

    @NotNull
    public static PsiFile getPsiFile(@NotNull Project project, @NotNull VirtualFile file) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "org/jetbrains/kotlin/com/intellij/psi/util/PsiUtilCore", "getPsiFile"));
        }
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "org/jetbrains/kotlin/com/intellij/psi/util/PsiUtilCore", "getPsiFile"));
        }
        PsiManager psiManager = PsiManager.getInstance(project);
        PsiFile psi = psiManager.findFile(file);
        if (psi != null) {
            PsiFile psiFile = psi;
            if (psiFile == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/com/intellij/psi/util/PsiUtilCore", "getPsiFile"));
            }
            return psiFile;
        }
        FileType fileType = file.getFileType();
        FileViewProvider viewProvider = psiManager.findViewProvider(file);
        Document document = FileDocumentManager.getInstance().getDocument(file);
        boolean ignored = !(file instanceof LightVirtualFile) && FileTypeRegistry.getInstance().isFileIgnored(file);
        VirtualFile vDir = file.getParent();
        PsiDirectory psiDir = vDir == null ? null : PsiManager.getInstance(project).findDirectory(vDir);
        FileIndexFacade indexFacade = FileIndexFacade.getInstance(project);
        StringBuilder sb = new StringBuilder();
        sb.append("valid=").append(file.isValid()).append(" isDirectory=").append(file.isDirectory()).append(" hasDocument=").append(document != null).append(" length=").append(file.getLength());
        sb.append("\nproject=").append(project.getName()).append(" default=").append(project.isDefault()).append(" open=").append(project.isOpen());
        sb.append("\nfileType=").append(fileType.getName()).append("/").append(fileType.getClass().getName());
        sb.append("\nisIgnored=").append(ignored);
        sb.append(" underIgnored=").append(indexFacade.isUnderIgnored(file));
        sb.append(" inLibrary=").append(indexFacade.isInLibrarySource(file) || indexFacade.isInLibraryClasses(file));
        sb.append(" parentDir=").append(vDir == null ? "no-vfs" : (vDir.isDirectory() ? "has-vfs-dir" : "has-vfs-file")).append("/").append(psiDir == null ? "no-psi" : "has-psi");
        sb.append("\nviewProvider=").append(viewProvider == null ? "null" : viewProvider.getClass().getName());
        if (viewProvider != null) {
            List<PsiFile> files2 = viewProvider.getAllFiles();
            sb.append(" language=").append(viewProvider.getBaseLanguage().getID());
            sb.append(" physical=").append(viewProvider.isPhysical());
            sb.append(" rootCount=").append(files2.size());
            for (PsiFile o : files2) {
                sb.append("\n  root=").append(o.getLanguage().getID()).append("/").append(o.getClass().getName());
            }
        }
        LOG.error("no PSI for file '" + file.getName() + "'", new Attachment(file.getPresentableUrl(), sb.toString()));
        throw new AssertionError();
    }

    @Nullable
    public static <T extends PsiElement> T getOriginalElement(@NotNull T psiElement, Class<? extends T> elementClass) {
        T parent2;
        if (psiElement == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "psiElement", "org/jetbrains/kotlin/com/intellij/psi/util/PsiUtilCore", "getOriginalElement"));
        }
        PsiFile psiFile = psiElement.getContainingFile();
        PsiFile originalFile = psiFile.getOriginalFile();
        if (originalFile == psiFile) {
            return psiElement;
        }
        TextRange range = psiElement.getTextRange();
        PsiElement element = originalFile.findElementAt(range.getStartOffset());
        int maxLength = range.getLength();
        T next = parent2 = PsiTreeUtil.getParentOfType(element, elementClass, false);
        while (next != null && next.getTextLength() <= maxLength) {
            parent2 = next;
            next = PsiTreeUtil.getParentOfType(next, elementClass, true);
        }
        return parent2;
    }

    @NotNull
    public static Language findLanguageFromElement(PsiElement elt) {
        PsiElement parent2;
        if (!(elt instanceof PsiFile) && elt.getFirstChild() == null && (parent2 = elt.getParent()) != null) {
            Language language = parent2.getLanguage();
            if (language == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/com/intellij/psi/util/PsiUtilCore", "findLanguageFromElement"));
            }
            return language;
        }
        Language language = elt.getLanguage();
        if (language == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/com/intellij/psi/util/PsiUtilCore", "findLanguageFromElement"));
        }
        return language;
    }

    @NotNull
    public static Language getLanguageAtOffset(@NotNull PsiFile file, int offset2) {
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "org/jetbrains/kotlin/com/intellij/psi/util/PsiUtilCore", "getLanguageAtOffset"));
        }
        PsiElement elt = file.findElementAt(offset2);
        if (elt == null) {
            Language language = file.getLanguage();
            if (language == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/com/intellij/psi/util/PsiUtilCore", "getLanguageAtOffset"));
            }
            return language;
        }
        if (elt instanceof PsiWhiteSpace) {
            int decremented;
            TextRange textRange = elt.getTextRange();
            if (!textRange.contains(offset2)) {
                LOG.error("PSI corrupted: in file " + file + " (" + file.getViewProvider().getVirtualFile() + ") offset=" + offset2 + " returned element " + elt + " with text range " + textRange);
            }
            if ((decremented = textRange.getStartOffset() - 1) >= 0) {
                Language language = PsiUtilCore.getLanguageAtOffset(file, decremented);
                if (language == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/com/intellij/psi/util/PsiUtilCore", "getLanguageAtOffset"));
                }
                return language;
            }
        }
        Language language = PsiUtilCore.findLanguageFromElement(elt);
        if (language == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/com/intellij/psi/util/PsiUtilCore", "getLanguageAtOffset"));
        }
        return language;
    }

    public static Project getProjectInReadAction(@NotNull PsiElement element) {
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "org/jetbrains/kotlin/com/intellij/psi/util/PsiUtilCore", "getProjectInReadAction"));
        }
        return ReadAction.compute(() -> {
            if (element == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "org/jetbrains/kotlin/com/intellij/psi/util/PsiUtilCore", "lambda$getProjectInReadAction$0"));
            }
            return element.getProject();
        });
    }

    @Contract(value="null -> null;!null -> !null")
    public static IElementType getElementType(@Nullable ASTNode node) {
        return node == null ? null : node.getElementType();
    }

    @Contract(value="null -> null")
    public static IElementType getElementType(@Nullable PsiElement element) {
        return element == null ? null : (element instanceof StubBasedPsiElement ? ((StubBasedPsiElement)element).getElementType() : PsiUtilCore.getElementType(element.getNode()));
    }

    private static class NullPsiFile
    extends NullPsiElement
    implements PsiFile {
        private NullPsiFile() {
        }

        @Override
        public FileASTNode getNode() {
            throw this.createException();
        }

        @Override
        public PsiDirectory getParent() {
            throw this.createException();
        }

        @Override
        public VirtualFile getVirtualFile() {
            throw this.createException();
        }

        @Override
        public PsiDirectory getContainingDirectory() {
            throw this.createException();
        }

        @Override
        public long getModificationStamp() {
            throw this.createException();
        }

        @Override
        @NotNull
        public PsiFile getOriginalFile() {
            throw this.createException();
        }

        @Override
        @NotNull
        public FileType getFileType() {
            throw this.createException();
        }

        @Override
        @NotNull
        public PsiFile[] getPsiRoots() {
            throw this.createException();
        }

        @Override
        @NotNull
        public FileViewProvider getViewProvider() {
            throw this.createException();
        }

        @Override
        public void subtreeChanged() {
            throw this.createException();
        }

        @Override
        public boolean isDirectory() {
            throw this.createException();
        }

        @Override
        @NotNull
        public String getName() {
            throw this.createException();
        }

        @Override
        public boolean processChildren(PsiElementProcessor<PsiFileSystemItem> processor) {
            throw this.createException();
        }

        @Nullable
        public ItemPresentation getPresentation() {
            throw this.createException();
        }

        @Override
        public void navigate(boolean requestFocus) {
            throw this.createException();
        }

        @Override
        public boolean canNavigate() {
            throw this.createException();
        }

        @Override
        public boolean canNavigateToSource() {
            throw this.createException();
        }

        @Override
        public void checkSetName(String name) throws IncorrectOperationException {
            throw this.createException();
        }

        @Override
        public PsiElement setName(@NonNls @NotNull String name) throws IncorrectOperationException {
            if (name == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "org/jetbrains/kotlin/com/intellij/psi/util/PsiUtilCore$NullPsiFile", "setName"));
            }
            throw this.createException();
        }

        @Override
        public String toString() {
            return "NULL_PSI_FILE";
        }
    }

    protected static class NullPsiElement
    implements PsiElement {
        protected NullPsiElement() {
        }

        @Override
        @NotNull
        public Project getProject() {
            throw this.createException();
        }

        @Override
        @NotNull
        public Language getLanguage() {
            throw this.createException();
        }

        @Override
        public PsiManager getManager() {
            throw this.createException();
        }

        @Override
        @NotNull
        public PsiElement[] getChildren() {
            throw this.createException();
        }

        @Override
        public PsiElement getParent() {
            throw this.createException();
        }

        @Override
        @Nullable
        public PsiElement getFirstChild() {
            throw this.createException();
        }

        @Override
        @Nullable
        public PsiElement getLastChild() {
            throw this.createException();
        }

        @Override
        @Nullable
        public PsiElement getNextSibling() {
            throw this.createException();
        }

        @Override
        @Nullable
        public PsiElement getPrevSibling() {
            throw this.createException();
        }

        @Override
        public PsiFile getContainingFile() {
            throw this.createException();
        }

        @Override
        public TextRange getTextRange() {
            throw this.createException();
        }

        @Override
        public int getStartOffsetInParent() {
            throw this.createException();
        }

        @Override
        public int getTextLength() {
            throw this.createException();
        }

        @Override
        public PsiElement findElementAt(int offset2) {
            throw this.createException();
        }

        @Override
        @Nullable
        public PsiReference findReferenceAt(int offset2) {
            throw this.createException();
        }

        @Override
        public int getTextOffset() {
            throw this.createException();
        }

        @Override
        public String getText() {
            throw this.createException();
        }

        @Override
        @NotNull
        public char[] textToCharArray() {
            throw this.createException();
        }

        @Override
        public PsiElement getNavigationElement() {
            throw this.createException();
        }

        @Override
        public PsiElement getOriginalElement() {
            throw this.createException();
        }

        @Override
        public boolean textMatches(@NotNull CharSequence text2) {
            if (text2 == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "text", "org/jetbrains/kotlin/com/intellij/psi/util/PsiUtilCore$NullPsiElement", "textMatches"));
            }
            throw this.createException();
        }

        @Override
        public boolean textMatches(@NotNull PsiElement element) {
            if (element == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "org/jetbrains/kotlin/com/intellij/psi/util/PsiUtilCore$NullPsiElement", "textMatches"));
            }
            throw this.createException();
        }

        @Override
        public boolean textContains(char c) {
            throw this.createException();
        }

        @Override
        public void accept(@NotNull PsiElementVisitor visitor2) {
            if (visitor2 == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "visitor", "org/jetbrains/kotlin/com/intellij/psi/util/PsiUtilCore$NullPsiElement", "accept"));
            }
            throw this.createException();
        }

        @Override
        public void acceptChildren(@NotNull PsiElementVisitor visitor2) {
            if (visitor2 == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "visitor", "org/jetbrains/kotlin/com/intellij/psi/util/PsiUtilCore$NullPsiElement", "acceptChildren"));
            }
            throw this.createException();
        }

        @Override
        public PsiElement copy() {
            throw this.createException();
        }

        @Override
        public PsiElement add(@NotNull PsiElement element) {
            if (element == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "org/jetbrains/kotlin/com/intellij/psi/util/PsiUtilCore$NullPsiElement", "add"));
            }
            throw this.createException();
        }

        @Override
        public PsiElement addBefore(@NotNull PsiElement element, PsiElement anchor2) {
            if (element == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "org/jetbrains/kotlin/com/intellij/psi/util/PsiUtilCore$NullPsiElement", "addBefore"));
            }
            throw this.createException();
        }

        @Override
        public PsiElement addAfter(@NotNull PsiElement element, PsiElement anchor2) {
            if (element == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "org/jetbrains/kotlin/com/intellij/psi/util/PsiUtilCore$NullPsiElement", "addAfter"));
            }
            throw this.createException();
        }

        @Override
        public void checkAdd(@NotNull PsiElement element) {
            if (element == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "org/jetbrains/kotlin/com/intellij/psi/util/PsiUtilCore$NullPsiElement", "checkAdd"));
            }
            throw this.createException();
        }

        @Override
        public PsiElement addRange(PsiElement first, PsiElement last) {
            throw this.createException();
        }

        @Override
        public PsiElement addRangeBefore(@NotNull PsiElement first, @NotNull PsiElement last, PsiElement anchor2) {
            if (first == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "first", "org/jetbrains/kotlin/com/intellij/psi/util/PsiUtilCore$NullPsiElement", "addRangeBefore"));
            }
            if (last == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "last", "org/jetbrains/kotlin/com/intellij/psi/util/PsiUtilCore$NullPsiElement", "addRangeBefore"));
            }
            throw this.createException();
        }

        @Override
        public PsiElement addRangeAfter(PsiElement first, PsiElement last, PsiElement anchor2) {
            throw this.createException();
        }

        @Override
        public void delete() {
            throw this.createException();
        }

        @Override
        public void checkDelete() {
            throw this.createException();
        }

        @Override
        public void deleteChildRange(PsiElement first, PsiElement last) {
            throw this.createException();
        }

        @Override
        public PsiElement replace(@NotNull PsiElement newElement) {
            if (newElement == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "newElement", "org/jetbrains/kotlin/com/intellij/psi/util/PsiUtilCore$NullPsiElement", "replace"));
            }
            throw this.createException();
        }

        @Override
        public boolean isValid() {
            throw this.createException();
        }

        @Override
        public boolean isWritable() {
            throw this.createException();
        }

        protected PsiInvalidElementAccessException createException() {
            return new PsiInvalidElementAccessException(this, this.toString(), null);
        }

        @Override
        @Nullable
        public PsiReference getReference() {
            throw this.createException();
        }

        @Override
        @NotNull
        public PsiReference[] getReferences() {
            throw this.createException();
        }

        @Override
        public <T> T getCopyableUserData(Key<T> key) {
            throw this.createException();
        }

        @Override
        public <T> void putCopyableUserData(Key<T> key, T value) {
            throw this.createException();
        }

        @Override
        public boolean processDeclarations(@NotNull PsiScopeProcessor processor, @NotNull ResolveState state2, PsiElement lastParent, @NotNull PsiElement place) {
            if (processor == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "processor", "org/jetbrains/kotlin/com/intellij/psi/util/PsiUtilCore$NullPsiElement", "processDeclarations"));
            }
            if (state2 == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "state", "org/jetbrains/kotlin/com/intellij/psi/util/PsiUtilCore$NullPsiElement", "processDeclarations"));
            }
            if (place == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "place", "org/jetbrains/kotlin/com/intellij/psi/util/PsiUtilCore$NullPsiElement", "processDeclarations"));
            }
            throw this.createException();
        }

        @Override
        public PsiElement getContext() {
            throw this.createException();
        }

        @Override
        public boolean isPhysical() {
            throw this.createException();
        }

        @Override
        @NotNull
        public GlobalSearchScope getResolveScope() {
            throw this.createException();
        }

        @Override
        @NotNull
        public SearchScope getUseScope() {
            throw this.createException();
        }

        @Override
        public ASTNode getNode() {
            throw this.createException();
        }

        @Override
        public <T> T getUserData(@NotNull Key<T> key) {
            if (key == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "key", "org/jetbrains/kotlin/com/intellij/psi/util/PsiUtilCore$NullPsiElement", "getUserData"));
            }
            throw this.createException();
        }

        @Override
        public <T> void putUserData(@NotNull Key<T> key, T value) {
            if (key == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "key", "org/jetbrains/kotlin/com/intellij/psi/util/PsiUtilCore$NullPsiElement", "putUserData"));
            }
            throw this.createException();
        }

        @Override
        public Icon getIcon(int flags) {
            throw this.createException();
        }

        @Override
        public boolean isEquivalentTo(PsiElement another) {
            return this == another;
        }

        @Override
        public String toString() {
            return "NULL_PSI_ELEMENT";
        }
    }
}

