/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.com.intellij.openapi.application.impl;

import java.awt.Color;
import java.awt.Rectangle;
import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Collections;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.List;
import java.util.TimeZone;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.com.intellij.ide.plugins.PluginManagerCore;
import org.jetbrains.kotlin.com.intellij.openapi.application.ApplicationNamesInfo;
import org.jetbrains.kotlin.com.intellij.openapi.application.PathManager;
import org.jetbrains.kotlin.com.intellij.openapi.application.ex.ApplicationInfoEx;
import org.jetbrains.kotlin.com.intellij.openapi.util.BuildNumber;
import org.jetbrains.kotlin.com.intellij.openapi.util.JDOMUtil;
import org.jetbrains.kotlin.com.intellij.openapi.util.SystemInfo;
import org.jetbrains.kotlin.com.intellij.openapi.util.SystemInfoRt;
import org.jetbrains.kotlin.com.intellij.openapi.util.registry.Registry;
import org.jetbrains.kotlin.com.intellij.openapi.util.text.StringUtil;
import org.jetbrains.kotlin.com.intellij.ui.JBColor;
import org.jetbrains.kotlin.com.intellij.util.ArrayUtil;
import org.jetbrains.kotlin.com.intellij.util.PlatformUtils;
import org.jetbrains.kotlin.com.intellij.util.SystemProperties;
import org.jetbrains.kotlin.com.intellij.util.containers.ContainerUtil;
import org.jetbrains.kotlin.com.intellij.util.ui.JBRectangle;
import org.jetbrains.kotlin.org.jdom.Document;
import org.jetbrains.kotlin.org.jdom.Element;

public class ApplicationInfoImpl
extends ApplicationInfoEx {
    private String myCodeName;
    private String myMajorVersion;
    private String myMinorVersion;
    private String myMicroVersion;
    private String myPatchVersion;
    private String myFullVersionFormat;
    private String myBuildNumber;
    private String myApiVersion;
    private String myCompanyName = "JetBrains s.r.o.";
    private String myShortCompanyName;
    private String myCompanyUrl = "https://www.jetbrains.com/";
    private Color myProgressColor;
    private Color myCopyrightForeground = JBColor.BLACK;
    private Color myAboutForeground = JBColor.BLACK;
    private Color myAboutLinkColor;
    private String myProgressTailIconName;
    private int myProgressHeight = 2;
    private int myProgressX = 1;
    private int myProgressY = 350;
    private int myLicenseOffsetY = Registry.is("ide.new.about") ? 85 : 30;
    private String mySplashImageUrl;
    private String myAboutImageUrl;
    private Color mySplashTextColor = new Color(0, 35, 135);
    private String myIconUrl = "/icon.png";
    private String mySmallIconUrl = "/icon_small.png";
    private String myBigIconUrl;
    private String myToolWindowIconUrl = "/toolwindows/toolWindowProject.png";
    private String myWelcomeScreenLogoUrl;
    private String myEditorBackgroundImageUrl;
    private Calendar myBuildDate;
    private Calendar myMajorReleaseBuildDate;
    private String myPackageCode;
    private boolean myShowLicensee = true;
    private String myCustomizeIDEWizardStepsProvider;
    private ApplicationInfoEx.UpdateUrls myUpdateUrls;
    private String myDocumentationUrl;
    private String mySupportUrl;
    private String myEAPFeedbackUrl;
    private String myReleaseFeedbackUrl;
    private String myPluginManagerUrl;
    private String myPluginsListUrl;
    private String myChannelsListUrl;
    private String myPluginsDownloadUrl;
    private String myBuiltinPluginsUrl;
    private String myWhatsNewUrl;
    private String myWinKeymapUrl;
    private String myMacKeymapUrl;
    private boolean myEAP;
    private boolean myHasHelp = true;
    private boolean myHasContextHelp = true;
    @Nullable
    private String myHelpFileName = "ideahelp.jar";
    @Nullable
    private String myHelpRootName = "idea";
    private String myWebHelpUrl = "https://www.jetbrains.com/idea/webhelp/";
    private List<Object> myPluginChooserPages = new ArrayList<Object>();
    private String[] myEssentialPluginsIds;
    private String myStatisticsSettingsUrl;
    private String myStatisticsServiceUrl;
    private String myStatisticsServiceKey;
    private String myThirdPartySoftwareUrl;
    private String myJetbrainsTvUrl;
    private String myEvalLicenseUrl = "https://www.jetbrains.com/store/license.html";
    private String myKeyConversionUrl = "https://www.jetbrains.com/shop/eform/keys-exchange";
    private String mySubscriptionFormId;
    private String mySubscriptionNewsKey;
    private String mySubscriptionNewsValue;
    private String mySubscriptionTipsKey;
    private boolean mySubscriptionTipsAvailable;
    private String mySubscriptionAdditionalFormData;
    private Rectangle myAboutLogoRect;
    private static ApplicationInfoImpl ourShadowInstance;
    private static volatile boolean myInStressTest;

    ApplicationInfoImpl() {
        String resource = "/idea/" + ApplicationNamesInfo.getComponentName() + ".xml";
        try {
            Document doc = JDOMUtil.loadDocument(ApplicationInfoImpl.class, resource);
            this.loadState(doc.getRootElement());
        }
        catch (Exception e) {
            throw new RuntimeException("Cannot load resource: " + resource, e);
        }
    }

    public BuildNumber getBuild() {
        return BuildNumber.fromString(this.myBuildNumber, ApplicationInfoImpl.getProductPrefix());
    }

    private static String getProductPrefix() {
        String prefix = null;
        if (PlatformUtils.isIdeaCommunity()) {
            prefix = "IC";
        } else if (PlatformUtils.isIdeaUltimate()) {
            prefix = "IU";
        }
        return prefix;
    }

    @NotNull
    public static ApplicationInfoEx getShadowInstance() {
        if (ourShadowInstance == null) {
            ourShadowInstance = new ApplicationInfoImpl();
        }
        ApplicationInfoImpl applicationInfoImpl = ourShadowInstance;
        if (applicationInfoImpl == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/com/intellij/openapi/application/impl/ApplicationInfoImpl", "getShadowInstance"));
        }
        return applicationInfoImpl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void loadState(Element parentNode) {
        Element subscriptionsElement;
        String url;
        Element licensingElement;
        String url2;
        Element evaluationElement;
        Element tvElement;
        Element keymapElement;
        Element pluginsElement;
        Element whatsnewElement;
        Element feedbackElement;
        Element supportElement;
        Element helpElement;
        Element editor;
        Element wizardSteps;
        Element welcomeScreen;
        Element showLicensee;
        Element packageElement;
        Element iconElement;
        Element aboutLogoElement;
        Element buildElement;
        Element companyElement;
        Element versionElement = ApplicationInfoImpl.getChild(parentNode, "version");
        if (versionElement != null) {
            this.myMajorVersion = versionElement.getAttributeValue("major");
            this.myMinorVersion = versionElement.getAttributeValue("minor");
            this.myMicroVersion = versionElement.getAttributeValue("micro");
            this.myPatchVersion = versionElement.getAttributeValue("patch");
            this.myFullVersionFormat = versionElement.getAttributeValue("full");
            this.myCodeName = versionElement.getAttributeValue("codename");
            this.myEAP = Boolean.parseBoolean(versionElement.getAttributeValue("eap"));
        }
        if ((companyElement = ApplicationInfoImpl.getChild(parentNode, "company")) != null) {
            this.myCompanyName = companyElement.getAttributeValue("name", this.myCompanyName);
            this.myShortCompanyName = companyElement.getAttributeValue("shortName", ApplicationInfoImpl.shortenCompanyName(this.myCompanyName));
            this.myCompanyUrl = companyElement.getAttributeValue("url", this.myCompanyUrl);
        }
        if ((buildElement = ApplicationInfoImpl.getChild(parentNode, "build")) != null) {
            String majorReleaseDateString;
            this.myBuildNumber = buildElement.getAttributeValue("number");
            this.myApiVersion = buildElement.getAttributeValue("apiVersion");
            ApplicationInfoImpl.setBuildNumber(this.myApiVersion, this.myBuildNumber);
            String dateString = buildElement.getAttributeValue("date");
            if (dateString.equals("__BUILD_DATE__")) {
                this.myBuildDate = new GregorianCalendar();
                try (JarFile bootJar2 = new JarFile(PathManager.getHomePath() + File.separator + "lib" + File.separator + "boot.jar");){
                    JarEntry jarEntry = bootJar2.entries().nextElement();
                    this.myBuildDate.setTime(new Date(jarEntry.getTime()));
                }
                catch (Exception bootJar2) {}
            } else {
                this.myBuildDate = ApplicationInfoImpl.parseDate(dateString);
            }
            if ((majorReleaseDateString = buildElement.getAttributeValue("majorReleaseDate")) != null) {
                this.myMajorReleaseBuildDate = ApplicationInfoImpl.parseDate(majorReleaseDateString);
            }
        }
        Thread currentThread = Thread.currentThread();
        currentThread.setName(currentThread.getName() + " " + this.myMajorVersion + "." + this.myMinorVersion + "#" + this.myBuildNumber + " " + ApplicationNamesInfo.getInstance().getProductName() + ", eap:" + this.myEAP + ", os:" + SystemInfoRt.OS_NAME + " " + SystemInfoRt.OS_VERSION + ", java-version:" + SystemProperties.getJavaVendor() + " " + SystemInfo.JAVA_RUNTIME_VERSION);
        Element logoElement = ApplicationInfoImpl.getChild(parentNode, "logo");
        if (logoElement != null) {
            this.mySplashImageUrl = logoElement.getAttributeValue("url");
            this.mySplashTextColor = ApplicationInfoImpl.parseColor(logoElement.getAttributeValue("textcolor"));
            String v = logoElement.getAttributeValue("progressColor");
            if (v != null) {
                this.myProgressColor = ApplicationInfoImpl.parseColor(v);
            }
            if ((v = logoElement.getAttributeValue("progressTailIcon")) != null) {
                this.myProgressTailIconName = v;
            }
            if ((v = logoElement.getAttributeValue("progressHeight")) != null) {
                this.myProgressHeight = Integer.parseInt(v);
            }
            if ((v = logoElement.getAttributeValue("progressX")) != null) {
                this.myProgressX = Integer.parseInt(v);
            }
            if ((v = logoElement.getAttributeValue("progressY")) != null) {
                this.myProgressY = Integer.parseInt(v);
            }
            if ((v = logoElement.getAttributeValue("licenseOffsetY")) != null) {
                this.myLicenseOffsetY = Integer.parseInt(v);
            }
        }
        if ((aboutLogoElement = ApplicationInfoImpl.getChild(parentNode, "about")) != null) {
            String c;
            this.myAboutImageUrl = aboutLogoElement.getAttributeValue("url");
            String v = aboutLogoElement.getAttributeValue("foreground");
            if (v != null) {
                this.myAboutForeground = ApplicationInfoImpl.parseColor(v);
            }
            if ((v = aboutLogoElement.getAttributeValue("copyrightForeground")) != null) {
                this.myCopyrightForeground = ApplicationInfoImpl.parseColor(v);
            }
            if ((c = aboutLogoElement.getAttributeValue("linkColor")) != null) {
                this.myAboutLinkColor = ApplicationInfoImpl.parseColor(c);
            }
            String logoX = aboutLogoElement.getAttributeValue("logoX");
            String logoY = aboutLogoElement.getAttributeValue("logoY");
            String logoW = aboutLogoElement.getAttributeValue("logoW");
            String logoH = aboutLogoElement.getAttributeValue("logoH");
            if (logoX != null && logoY != null && logoW != null && logoH != null) {
                try {
                    this.myAboutLogoRect = new JBRectangle(Integer.parseInt(logoX), Integer.parseInt(logoY), Integer.parseInt(logoW), Integer.parseInt(logoH));
                }
                catch (NumberFormatException numberFormatException) {
                    // empty catch block
                }
            }
        }
        if ((iconElement = ApplicationInfoImpl.getChild(parentNode, "icon")) != null) {
            this.myIconUrl = iconElement.getAttributeValue("size32");
            this.mySmallIconUrl = iconElement.getAttributeValue("size16");
            this.myBigIconUrl = iconElement.getAttributeValue("size128", (String)null);
            String toolWindowIcon = iconElement.getAttributeValue("size12");
            if (toolWindowIcon != null) {
                this.myToolWindowIconUrl = toolWindowIcon;
            }
        }
        if ((packageElement = ApplicationInfoImpl.getChild(parentNode, "package")) != null) {
            this.myPackageCode = packageElement.getAttributeValue("code");
        }
        if ((showLicensee = ApplicationInfoImpl.getChild(parentNode, "licensee")) != null) {
            this.myShowLicensee = Boolean.valueOf(showLicensee.getAttributeValue("show"));
        }
        if ((welcomeScreen = ApplicationInfoImpl.getChild(parentNode, "welcome-screen")) != null) {
            this.myWelcomeScreenLogoUrl = welcomeScreen.getAttributeValue("logo-url");
        }
        if ((wizardSteps = ApplicationInfoImpl.getChild(parentNode, "customize-ide-wizard")) != null) {
            this.myCustomizeIDEWizardStepsProvider = wizardSteps.getAttributeValue("provider");
        }
        if ((editor = ApplicationInfoImpl.getChild(parentNode, "editor")) != null) {
            this.myEditorBackgroundImageUrl = editor.getAttributeValue("background-url");
        }
        if ((helpElement = ApplicationInfoImpl.getChild(parentNode, "help")) != null) {
            String attValue;
            this.myHelpFileName = helpElement.getAttributeValue("file");
            this.myHelpRootName = helpElement.getAttributeValue("root");
            String webHelpUrl = helpElement.getAttributeValue("webhelp-url");
            if (webHelpUrl != null) {
                this.myWebHelpUrl = webHelpUrl;
            }
            this.myHasHelp = (attValue = helpElement.getAttributeValue("has-help")) == null || Boolean.parseBoolean(attValue);
            attValue = helpElement.getAttributeValue("has-context-help");
            this.myHasContextHelp = attValue == null || Boolean.parseBoolean(attValue);
        }
        Element updateUrls = ApplicationInfoImpl.getChild(parentNode, "update-urls");
        this.myUpdateUrls = new UpdateUrlsImpl(updateUrls);
        Element documentationElement = ApplicationInfoImpl.getChild(parentNode, "documentation");
        if (documentationElement != null) {
            this.myDocumentationUrl = documentationElement.getAttributeValue("url");
        }
        if ((supportElement = ApplicationInfoImpl.getChild(parentNode, "support")) != null) {
            this.mySupportUrl = supportElement.getAttributeValue("url");
        }
        if ((feedbackElement = ApplicationInfoImpl.getChild(parentNode, "feedback")) != null) {
            this.myEAPFeedbackUrl = feedbackElement.getAttributeValue("eap-url");
            this.myReleaseFeedbackUrl = feedbackElement.getAttributeValue("release-url");
        }
        if ((whatsnewElement = ApplicationInfoImpl.getChild(parentNode, "whatsnew")) != null) {
            this.myWhatsNewUrl = whatsnewElement.getAttributeValue("url");
        }
        if ((pluginsElement = ApplicationInfoImpl.getChild(parentNode, "plugins")) != null) {
            String url3 = pluginsElement.getAttributeValue("url");
            this.myPluginManagerUrl = url3 != null ? url3 : "http://plugins.jetbrains.com";
            boolean closed = StringUtil.endsWith(this.myPluginManagerUrl, "/");
            String listUrl = pluginsElement.getAttributeValue("list-url");
            this.myPluginsListUrl = listUrl != null ? listUrl : this.myPluginManagerUrl + (closed ? "" : "/") + "plugins/list/";
            String channelListUrl = pluginsElement.getAttributeValue("channel-list-url");
            this.myChannelsListUrl = channelListUrl != null ? channelListUrl : this.myPluginManagerUrl + (closed ? "" : "/") + "channels/list/";
            String downloadUrl = pluginsElement.getAttributeValue("download-url");
            String string = downloadUrl != null ? downloadUrl : (this.myPluginsDownloadUrl = this.myPluginManagerUrl + (closed ? "" : "/") + "pluginManager/");
            if (!this.getBuild().isSnapshot()) {
                this.myBuiltinPluginsUrl = pluginsElement.getAttributeValue("builtin-url");
            }
        } else {
            this.myPluginManagerUrl = "http://plugins.jetbrains.com";
            this.myPluginsListUrl = "http://plugins.jetbrains.com/plugins/list/";
            this.myChannelsListUrl = "http://plugins.jetbrains.com/channels/list/";
            this.myPluginsDownloadUrl = "http://plugins.jetbrains.com/pluginManager/";
        }
        String pluginsHost = System.getProperty("idea.plugins.host");
        if (pluginsHost != null) {
            this.myPluginsListUrl = this.myPluginsListUrl.replace("http://plugins.jetbrains.com", pluginsHost);
            this.myChannelsListUrl = this.myChannelsListUrl.replace("http://plugins.jetbrains.com", pluginsHost);
            this.myPluginsDownloadUrl = this.myPluginsDownloadUrl.replace("http://plugins.jetbrains.com", pluginsHost);
        }
        if ((keymapElement = ApplicationInfoImpl.getChild(parentNode, "keymap")) != null) {
            this.myWinKeymapUrl = keymapElement.getAttributeValue("win");
            this.myMacKeymapUrl = keymapElement.getAttributeValue("mac");
        }
        this.myPluginChooserPages = new ArrayList<Object>();
        for (Element child : ApplicationInfoImpl.getChildren(parentNode, "plugins-page")) {
            this.myPluginChooserPages.add(new PluginChooserPageImpl(child));
        }
        List<Element> essentialPluginsElements = ApplicationInfoImpl.getChildren(parentNode, "essential-plugin");
        List<String> essentialPluginsIds = ContainerUtil.mapNotNull(essentialPluginsElements, element -> {
            String id = element.getTextTrim();
            return StringUtil.isNotEmpty(id) ? id : null;
        });
        this.myEssentialPluginsIds = ArrayUtil.toStringArray(essentialPluginsIds);
        Element statisticsElement = ApplicationInfoImpl.getChild(parentNode, "statistics");
        if (statisticsElement != null) {
            this.myStatisticsSettingsUrl = statisticsElement.getAttributeValue("settings");
            this.myStatisticsServiceUrl = statisticsElement.getAttributeValue("service");
            this.myStatisticsServiceKey = statisticsElement.getAttributeValue("service-key");
        } else {
            this.myStatisticsSettingsUrl = "https://www.jetbrains.com/idea/statistics/stat-assistant.xml";
            this.myStatisticsServiceUrl = "https://www.jetbrains.com/idea/statistics/index.jsp";
            this.myStatisticsServiceKey = null;
        }
        Element thirdPartyElement = ApplicationInfoImpl.getChild(parentNode, "third-party");
        if (thirdPartyElement != null) {
            this.myThirdPartySoftwareUrl = thirdPartyElement.getAttributeValue("url");
        }
        if ((tvElement = ApplicationInfoImpl.getChild(parentNode, "jetbrains-tv")) != null) {
            this.myJetbrainsTvUrl = tvElement.getAttributeValue("url");
        }
        if ((evaluationElement = ApplicationInfoImpl.getChild(parentNode, "evaluation")) != null && (url2 = evaluationElement.getAttributeValue("license-url")) != null && !url2.isEmpty()) {
            this.myEvalLicenseUrl = url2.trim();
        }
        if ((licensingElement = ApplicationInfoImpl.getChild(parentNode, "licensing")) != null && (url = licensingElement.getAttributeValue("key-conversion-url")) != null && !url.isEmpty()) {
            this.myKeyConversionUrl = url.trim();
        }
        if ((subscriptionsElement = ApplicationInfoImpl.getChild(parentNode, "subscriptions")) != null) {
            this.mySubscriptionFormId = subscriptionsElement.getAttributeValue("formid");
            this.mySubscriptionNewsKey = subscriptionsElement.getAttributeValue("news-key");
            this.mySubscriptionNewsValue = subscriptionsElement.getAttributeValue("news-value", "yes");
            this.mySubscriptionTipsKey = subscriptionsElement.getAttributeValue("tips-key");
            this.mySubscriptionTipsAvailable = Boolean.parseBoolean(subscriptionsElement.getAttributeValue("tips-available"));
            this.mySubscriptionAdditionalFormData = subscriptionsElement.getAttributeValue("additional-form-data");
        }
    }

    @NotNull
    private static List<Element> getChildren(Element parentNode, String name) {
        List<Element> list2 = parentNode.getChildren(name, parentNode.getNamespace());
        if (list2 == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/com/intellij/openapi/application/impl/ApplicationInfoImpl", "getChildren"));
        }
        return list2;
    }

    private static Element getChild(Element parentNode, String version) {
        return parentNode.getChild(version, parentNode.getNamespace());
    }

    static String shortenCompanyName(String name) {
        return StringUtil.trimEnd(StringUtil.trimEnd(name, " s.r.o."), " Inc.");
    }

    private static void setBuildNumber(String apiVersion, String buildNumber) {
        PluginManagerCore.BUILD_NUMBER = apiVersion != null ? apiVersion : buildNumber;
    }

    private static GregorianCalendar parseDate(String dateString) {
        GregorianCalendar calendar = new GregorianCalendar(TimeZone.getTimeZone("UTC"));
        try {
            calendar.set(1, Integer.parseInt(dateString.substring(0, 4)));
            calendar.set(2, Integer.parseInt(dateString.substring(4, 6)) - 1);
            calendar.set(5, Integer.parseInt(dateString.substring(6, 8)));
            if (dateString.length() > 8) {
                calendar.set(11, Integer.parseInt(dateString.substring(8, 10)));
                calendar.set(12, Integer.parseInt(dateString.substring(10, 12)));
            } else {
                calendar.set(11, 0);
                calendar.set(12, 0);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return calendar;
    }

    private static Color parseColor(String colorString) {
        long rgb = Long.parseLong(colorString, 16);
        return new Color((int)rgb, rgb > 0xFFFFFFL);
    }

    public List<String> getEssentialPluginsIds() {
        return Collections.unmodifiableList(Arrays.asList(this.myEssentialPluginsIds));
    }

    public static boolean isInStressTest() {
        return myInStressTest;
    }

    private static class PluginChooserPageImpl {
        private final String myTitle;
        private final String myCategory;
        private final String myDependentPlugin;

        private PluginChooserPageImpl(Element e) {
            this.myTitle = e.getAttributeValue("title");
            this.myCategory = e.getAttributeValue("category");
            this.myDependentPlugin = e.getAttributeValue("depends");
        }
    }

    private static class UpdateUrlsImpl
    implements ApplicationInfoEx.UpdateUrls {
        private String myCheckingUrl;
        private String myPatchesUrl;

        private UpdateUrlsImpl(Element element) {
            if (element != null) {
                this.myCheckingUrl = element.getAttributeValue("check");
                this.myPatchesUrl = element.getAttributeValue("patches");
            }
        }
    }
}

