/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.nativeplatform.toolchain.internal;

import org.gradle.api.GradleException;
import org.gradle.internal.text.TreeFormatter;
import org.gradle.language.base.internal.compile.CompileSpec;
import org.gradle.language.base.internal.compile.Compiler;
import org.gradle.nativeplatform.platform.internal.OperatingSystemInternal;
import org.gradle.nativeplatform.toolchain.internal.PlatformToolProvider;
import org.gradle.platform.base.internal.toolchain.ToolSearchResult;
import org.gradle.util.TreeVisitor;

public class UnavailablePlatformToolProvider
implements PlatformToolProvider {
    private final ToolSearchResult failure;
    private final OperatingSystemInternal targetOperatingSystem;

    public UnavailablePlatformToolProvider(OperatingSystemInternal targetOperatingSystem, ToolSearchResult failure) {
        this.targetOperatingSystem = targetOperatingSystem;
        this.failure = failure;
    }

    public boolean isAvailable() {
        return false;
    }

    public void explain(TreeVisitor<? super String> visitor) {
        this.failure.explain(visitor);
    }

    private RuntimeException failure() {
        TreeFormatter formatter = new TreeFormatter();
        this.explain((TreeVisitor<? super String>)formatter);
        return new GradleException(formatter.toString());
    }

    @Override
    public String getObjectFileExtension() {
        throw this.failure();
    }

    @Override
    public String getExecutableName(String executablePath) {
        return this.targetOperatingSystem.getInternalOs().getExecutableName(executablePath);
    }

    @Override
    public String getSharedLibraryName(String libraryPath) {
        return this.targetOperatingSystem.getInternalOs().getSharedLibraryName(libraryPath);
    }

    @Override
    public boolean producesImportLibrary() {
        return this.targetOperatingSystem.getInternalOs().isWindows();
    }

    @Override
    public String getImportLibraryName(String libraryPath) {
        return this.getSharedLibraryLinkFileName(libraryPath);
    }

    @Override
    public String getSharedLibraryLinkFileName(String libraryPath) {
        return this.targetOperatingSystem.getInternalOs().getSharedLibraryName(libraryPath);
    }

    @Override
    public String getStaticLibraryName(String libraryPath) {
        return this.targetOperatingSystem.getInternalOs().getStaticLibraryName(libraryPath);
    }

    public <T> T get(Class<T> toolType) {
        throw new IllegalArgumentException(String.format("Don't know how to provide tool of type %s.", toolType.getSimpleName()));
    }

    public <T extends CompileSpec> Compiler<T> newCompiler(Class<T> specType) {
        throw this.failure();
    }
}

