/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.plugins.ide.internal.tooling.idea;

import java.io.File;
import java.io.Serializable;
import java.util.LinkedHashSet;
import java.util.Set;
import org.gradle.plugins.ide.internal.tooling.idea.DefaultIdeaSourceDirectory;

public class DefaultIdeaContentRoot
implements Serializable {
    File rootDirectory;
    Set<DefaultIdeaSourceDirectory> sourceDirectories = new LinkedHashSet<DefaultIdeaSourceDirectory>();
    Set<DefaultIdeaSourceDirectory> testDirectories = new LinkedHashSet<DefaultIdeaSourceDirectory>();
    Set<File> excludeDirectories = new LinkedHashSet<File>();

    public File getRootDirectory() {
        return this.rootDirectory;
    }

    public DefaultIdeaContentRoot setRootDirectory(File rootDirectory) {
        this.rootDirectory = rootDirectory;
        return this;
    }

    public Set<DefaultIdeaSourceDirectory> getSourceDirectories() {
        return this.sourceDirectories;
    }

    public DefaultIdeaContentRoot setSourceDirectories(Set<DefaultIdeaSourceDirectory> sourceDirectories) {
        this.sourceDirectories = sourceDirectories;
        return this;
    }

    public Set<DefaultIdeaSourceDirectory> getGeneratedSourceDirectories() {
        return this.generated(this.sourceDirectories);
    }

    private Set<DefaultIdeaSourceDirectory> generated(Set<DefaultIdeaSourceDirectory> directories) {
        LinkedHashSet<DefaultIdeaSourceDirectory> generated = new LinkedHashSet<DefaultIdeaSourceDirectory>();
        for (DefaultIdeaSourceDirectory sourceDirectory : directories) {
            if (!sourceDirectory.isGenerated()) continue;
            generated.add(sourceDirectory);
        }
        return generated;
    }

    public Set<DefaultIdeaSourceDirectory> getTestDirectories() {
        return this.testDirectories;
    }

    public DefaultIdeaContentRoot setTestDirectories(Set<DefaultIdeaSourceDirectory> testDirectories) {
        this.testDirectories = testDirectories;
        return this;
    }

    public Set<DefaultIdeaSourceDirectory> getGeneratedTestDirectories() {
        return this.generated(this.testDirectories);
    }

    public Set<File> getExcludeDirectories() {
        return this.excludeDirectories;
    }

    public DefaultIdeaContentRoot setExcludeDirectories(Set<File> excludeDirectories) {
        this.excludeDirectories = excludeDirectories;
        return this;
    }

    public String toString() {
        return "IdeaContentRoot{rootDirectory=" + this.rootDirectory + ", sourceDirectories count=" + this.sourceDirectories.size() + ", testDirectories count=" + this.testDirectories.size() + ", excludeDirectories count=" + this.excludeDirectories.size() + '}';
    }
}

