/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.workers.internal;

import java.util.ArrayList;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import org.gradle.api.Transformer;
import org.gradle.api.logging.LogLevel;
import org.gradle.api.logging.Logger;
import org.gradle.api.logging.Logging;
import org.gradle.api.specs.Spec;
import org.gradle.initialization.SessionLifecycleListener;
import org.gradle.internal.concurrent.CompositeStoppable;
import org.gradle.internal.concurrent.Stoppable;
import org.gradle.internal.event.ListenerManager;
import org.gradle.internal.logging.LoggingManagerInternal;
import org.gradle.internal.logging.events.LogLevelChangeEvent;
import org.gradle.internal.logging.events.OutputEvent;
import org.gradle.internal.logging.events.OutputEventListener;
import org.gradle.util.CollectionUtils;
import org.gradle.workers.internal.ActionExecutionSpec;
import org.gradle.workers.internal.DaemonForkOptions;
import org.gradle.workers.internal.KeepAliveMode;
import org.gradle.workers.internal.WorkerDaemonClient;
import org.gradle.workers.internal.WorkerDaemonStarter;
import org.gradle.workers.internal.WorkerProtocol;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class WorkerDaemonClientsManager
implements Stoppable {
    private static final Logger LOGGER = Logging.getLogger(WorkerDaemonClientsManager.class);
    private final Object lock = new Object();
    private final List<WorkerDaemonClient> allClients = new ArrayList<WorkerDaemonClient>();
    private final List<WorkerDaemonClient> idleClients = new ArrayList<WorkerDaemonClient>();
    private final WorkerDaemonStarter workerDaemonStarter;
    private final ListenerManager listenerManager;
    private final LoggingManagerInternal loggingManager;
    private final SessionLifecycleListener stopSessionScopeWorkers;
    private final OutputEventListener logLevelChangeEventListener;
    private LogLevel currentLogLevel;

    public WorkerDaemonClientsManager(WorkerDaemonStarter workerDaemonStarter, ListenerManager listenerManager, LoggingManagerInternal loggingManager) {
        this.workerDaemonStarter = workerDaemonStarter;
        this.listenerManager = listenerManager;
        this.loggingManager = loggingManager;
        this.stopSessionScopeWorkers = new StopSessionScopedWorkers();
        listenerManager.addListener((Object)this.stopSessionScopeWorkers);
        this.logLevelChangeEventListener = new LogLevelChangeEventListener();
        loggingManager.addOutputEventListener(this.logLevelChangeEventListener);
        this.currentLogLevel = loggingManager.getLevel();
    }

    public WorkerDaemonClient reserveIdleClient(DaemonForkOptions forkOptions) {
        return this.reserveIdleClient(forkOptions, this.idleClients);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    WorkerDaemonClient reserveIdleClient(DaemonForkOptions forkOptions, List<WorkerDaemonClient> clients) {
        Object object = this.lock;
        synchronized (object) {
            Iterator<WorkerDaemonClient> it = clients.iterator();
            while (it.hasNext()) {
                WorkerDaemonClient candidate = it.next();
                if (!candidate.isCompatibleWith(forkOptions)) continue;
                it.remove();
                if (candidate.getLogLevel() != this.currentLogLevel) {
                    LOGGER.info("Log level has changed, stopping idle worker daemon with out-of-date log level.");
                    candidate.stop();
                    continue;
                }
                return candidate;
            }
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public WorkerDaemonClient reserveNewClient(Class<? extends WorkerProtocol<ActionExecutionSpec>> workerProtocolImplementationClass, DaemonForkOptions forkOptions) {
        WorkerDaemonClient client = this.workerDaemonStarter.startDaemon(workerProtocolImplementationClass, forkOptions);
        Object object = this.lock;
        synchronized (object) {
            this.allClients.add(client);
        }
        return client;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void release(WorkerDaemonClient client) {
        Object object = this.lock;
        synchronized (object) {
            this.idleClients.add(client);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void stop() {
        Object object = this.lock;
        synchronized (object) {
            this.stopWorkers(this.allClients);
            this.allClients.clear();
            this.idleClients.clear();
            this.listenerManager.removeListener((Object)this.stopSessionScopeWorkers);
            this.loggingManager.removeOutputEventListener(this.logLevelChangeEventListener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void selectIdleClientsToStop(Transformer<List<WorkerDaemonClient>, List<WorkerDaemonClient>> selectionFunction) {
        Object object = this.lock;
        synchronized (object) {
            List sortedClients = CollectionUtils.sort(this.idleClients, (Comparator)new Comparator<WorkerDaemonClient>(){

                @Override
                public int compare(WorkerDaemonClient o1, WorkerDaemonClient o2) {
                    return new Integer(o1.getUses()).compareTo(o2.getUses());
                }
            });
            List clientsToStop = (List)selectionFunction.transform(new ArrayList(sortedClients));
            if (!clientsToStop.isEmpty()) {
                this.stopWorkers(clientsToStop);
            }
        }
    }

    private void stopWorkers(List<WorkerDaemonClient> clientsToStop) {
        if (clientsToStop.size() > 0) {
            LOGGER.debug("Stopping {} worker daemon(s).", (Object)clientsToStop.size());
            CompositeStoppable.stoppable(clientsToStop).stop();
            LOGGER.info("Stopped {} worker daemon(s).", (Object)clientsToStop.size());
            this.idleClients.removeAll(clientsToStop);
            this.allClients.removeAll(clientsToStop);
        }
    }

    private class LogLevelChangeEventListener
    implements OutputEventListener {
        private LogLevelChangeEventListener() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void onOutput(OutputEvent event) {
            if (event instanceof LogLevelChangeEvent) {
                LogLevelChangeEvent logLevelChangeEvent = (LogLevelChangeEvent)event;
                if (WorkerDaemonClientsManager.this.currentLogLevel != logLevelChangeEvent.getNewLogLevel()) {
                    Object object = WorkerDaemonClientsManager.this.lock;
                    synchronized (object) {
                        WorkerDaemonClientsManager.this.currentLogLevel = logLevelChangeEvent.getNewLogLevel();
                    }
                }
            }
        }
    }

    private class StopSessionScopedWorkers
    implements SessionLifecycleListener {
        private StopSessionScopedWorkers() {
        }

        public void afterStart() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void beforeComplete() {
            Object object = WorkerDaemonClientsManager.this.lock;
            synchronized (object) {
                List sessionScopedClients = CollectionUtils.filter((List)WorkerDaemonClientsManager.this.allClients, (Spec)new Spec<WorkerDaemonClient>(){

                    public boolean isSatisfiedBy(WorkerDaemonClient client) {
                        return client.getKeepAliveMode() == KeepAliveMode.SESSION;
                    }
                });
                WorkerDaemonClientsManager.this.stopWorkers(sessionScopedClients);
            }
        }
    }
}

