        LIST

;==========================================================================
;  MPASM PIC18LF24K50 processor include
; 
;  (c) Copyright 1999-2014 Microchip Technology, All rights reserved
;==========================================================================

        NOLIST

;==========================================================================
;  This header file defines configurations, registers, and other useful
;  bits of information for the PIC18LF24K50 microcontroller.  These names
;  are taken to match the data sheets as closely as possible.
;
;  Note that the processor must be selected before this file is included.
;  The processor may be selected the following ways:
;
;       1. Command line switch:
;               C:\MPASM MYFILE.ASM /PIC18LF24K50
;       2. LIST directive in the source file
;               LIST   P=PIC18LF24K50
;       3. Processor Type entry in the MPASM full-screen interface
;       4. Setting the processor in the MPLAB Project Dialog
;==========================================================================

;==========================================================================
;
;       Verify Processor
;
;==========================================================================
        IFNDEF __18LF24K50
           MESSG "Processor-header file mismatch.  Verify selected processor."
        ENDIF

;==========================================================================
;       18xxxx Family        EQUates
;==========================================================================
FSR0            EQU 0
FSR1            EQU 1
FSR2            EQU 2

FAST            EQU 1

W               EQU 0
A               EQU 0
ACCESS          EQU 0
BANKED          EQU 1
;==========================================================================

;==========================================================================
;       16Cxxx/17Cxxx Substitutions
;==========================================================================
  #define DDRA  TRISA      ; PIC17Cxxx SFR substitution
  #define DDRB  TRISB      ; PIC17Cxxx SFR substitution
  #define DDRC  TRISC      ; PIC17Cxxx SFR substitution
  #define DDRD  TRISD      ; PIC17Cxxx SFR substitution
  #define DDRE  TRISE      ; PIC17Cxxx SFR substitution

;==========================================================================
;
;       Register Definitions
;
;==========================================================================

;----- Register Files -----------------------------------------------------
SRCON1           EQU  H'0F57'
SRCON0           EQU  H'0F58'
CCPTMRS          EQU  H'0F59'
ANSELA           EQU  H'0F5B'
ANSELB           EQU  H'0F5C'
ANSELC           EQU  H'0F5D'
UCON             EQU  H'0F60'
USTAT            EQU  H'0F61'
UCFG             EQU  H'0F62'
UADDR            EQU  H'0F63'
UIE              EQU  H'0F64'
UIR              EQU  H'0F65'
UEIE             EQU  H'0F66'
UEIR             EQU  H'0F67'
UFRM             EQU  H'0F68'
UFRML            EQU  H'0F68'
UFRMH            EQU  H'0F69'
UEP0             EQU  H'0F6A'
UEP1             EQU  H'0F6B'
UEP2             EQU  H'0F6C'
UEP3             EQU  H'0F6D'
UEP4             EQU  H'0F6E'
UEP5             EQU  H'0F6F'
UEP6             EQU  H'0F70'
UEP7             EQU  H'0F71'
UEP8             EQU  H'0F72'
UEP9             EQU  H'0F73'
UEP10            EQU  H'0F74'
UEP11            EQU  H'0F75'
UEP12            EQU  H'0F76'
UEP13            EQU  H'0F77'
UEP14            EQU  H'0F78'
UEP15            EQU  H'0F79'
SLRCON           EQU  H'0F7A'
VREFCON2         EQU  H'0F7B'
VREFCON1         EQU  H'0F7C'
VREFCON0         EQU  H'0F7D'
PMD0             EQU  H'0F7E'
PMD1             EQU  H'0F7F'
PORTA            EQU  H'0F80'
PORTB            EQU  H'0F81'
PORTC            EQU  H'0F82'
PORTE            EQU  H'0F84'
WPUB             EQU  H'0F85'
IOCB             EQU  H'0F86'
IOCC             EQU  H'0F87'
CTMUICON         EQU  H'0F88'
LATA             EQU  H'0F89'
LATB             EQU  H'0F8A'
LATC             EQU  H'0F8B'
CTMUCON1         EQU  H'0F8E'
CTMUCONL         EQU  H'0F8E'
CTMUCON0         EQU  H'0F8F'
CTMUCONH         EQU  H'0F8F'
CCPR2            EQU  H'0F90'
CCPR2L           EQU  H'0F90'
CCPR2H           EQU  H'0F91'
DDRA             EQU  H'0F92'
TRISA            EQU  H'0F92'
DDRB             EQU  H'0F93'
TRISB            EQU  H'0F93'
DDRC             EQU  H'0F94'
TRISC            EQU  H'0F94'
CCP2CON          EQU  H'0F97'
ECCP2CON         EQU  H'0F97'
CM1CON0          EQU  H'0F98'
CM2CON0          EQU  H'0F99'
CM2CON1          EQU  H'0F9A'
OSCTUNE          EQU  H'0F9B'
HLVDCON          EQU  H'0F9C'
PIE1             EQU  H'0F9D'
PIR1             EQU  H'0F9E'
IPR1             EQU  H'0F9F'
PIE2             EQU  H'0FA0'
PIR2             EQU  H'0FA1'
IPR2             EQU  H'0FA2'
PIE3             EQU  H'0FA3'
PIR3             EQU  H'0FA4'
IPR3             EQU  H'0FA5'
EECON1           EQU  H'0FA6'
EECON2           EQU  H'0FA7'
EEDATA           EQU  H'0FA8'
EEADR            EQU  H'0FA9'
RCSTA            EQU  H'0FAB'
RCSTA1           EQU  H'0FAB'
TXSTA            EQU  H'0FAC'
TXSTA1           EQU  H'0FAC'
TXREG            EQU  H'0FAD'
TXREG1           EQU  H'0FAD'
RCREG            EQU  H'0FAE'
RCREG1           EQU  H'0FAE'
SPBRG            EQU  H'0FAF'
SPBRG1           EQU  H'0FAF'
SPBRGH           EQU  H'0FB0'
SPBRGH1          EQU  H'0FB0'
T3CON            EQU  H'0FB1'
TMR3             EQU  H'0FB2'
TMR3L            EQU  H'0FB2'
TMR3H            EQU  H'0FB3'
T3GCON           EQU  H'0FB4'
ACTCON           EQU  H'0FB5'
STCON            EQU  H'0FB5'
ECCP1AS          EQU  H'0FB6'
ECCP1DEL         EQU  H'0FB7'
PWM1CON          EQU  H'0FB7'
BAUDCON          EQU  H'0FB8'
BAUDCON1         EQU  H'0FB8'
PSTR1CON         EQU  H'0FB9'
T2CON            EQU  H'0FBA'
PR2              EQU  H'0FBB'
TMR2             EQU  H'0FBC'
CCP1CON          EQU  H'0FBD'
ECCP1CON         EQU  H'0FBD'
CCPR1            EQU  H'0FBE'
CCPR1L           EQU  H'0FBE'
CCPR1H           EQU  H'0FBF'
ADCON2           EQU  H'0FC0'
ADCON1           EQU  H'0FC1'
ADCON0           EQU  H'0FC2'
ADRESL           EQU  H'0FC3'
ADRESH           EQU  H'0FC4'
SSP1CON2         EQU  H'0FC5'
SSPCON2          EQU  H'0FC5'
SSP1CON1         EQU  H'0FC6'
SSPCON           EQU  H'0FC6'
SSPCON1          EQU  H'0FC6'
SSP1STAT         EQU  H'0FC7'
SSPSTAT          EQU  H'0FC7'
SSP1ADD          EQU  H'0FC8'
SSPADD           EQU  H'0FC8'
SSP1BUF          EQU  H'0FC9'
SSPBUF           EQU  H'0FC9'
SSP1MSK          EQU  H'0FCA'
SSPMSK           EQU  H'0FCA'
SSP1CON3         EQU  H'0FCB'
SSPCON3          EQU  H'0FCB'
T1GCON           EQU  H'0FCC'
T1CON            EQU  H'0FCD'
TMR1             EQU  H'0FCE'
TMR1L            EQU  H'0FCE'
TMR1H            EQU  H'0FCF'
RCON             EQU  H'0FD0'
WDTCON           EQU  H'0FD1'
OSCCON2          EQU  H'0FD2'
OSCCON           EQU  H'0FD3'
T0CON            EQU  H'0FD5'
TMR0             EQU  H'0FD6'
TMR0L            EQU  H'0FD6'
TMR0H            EQU  H'0FD7'
STATUS           EQU  H'0FD8'
FSR2L            EQU  H'0FD9'
FSR2H            EQU  H'0FDA'
PLUSW2           EQU  H'0FDB'
PREINC2          EQU  H'0FDC'
POSTDEC2         EQU  H'0FDD'
POSTINC2         EQU  H'0FDE'
INDF2            EQU  H'0FDF'
BSR              EQU  H'0FE0'
FSR1L            EQU  H'0FE1'
FSR1H            EQU  H'0FE2'
PLUSW1           EQU  H'0FE3'
PREINC1          EQU  H'0FE4'
POSTDEC1         EQU  H'0FE5'
POSTINC1         EQU  H'0FE6'
INDF1            EQU  H'0FE7'
WREG             EQU  H'0FE8'
FSR0L            EQU  H'0FE9'
FSR0H            EQU  H'0FEA'
PLUSW0           EQU  H'0FEB'
PREINC0          EQU  H'0FEC'
POSTDEC0         EQU  H'0FED'
POSTINC0         EQU  H'0FEE'
INDF0            EQU  H'0FEF'
INTCON3          EQU  H'0FF0'
INTCON2          EQU  H'0FF1'
INTCON           EQU  H'0FF2'
PROD             EQU  H'0FF3'
PRODL            EQU  H'0FF3'
PRODH            EQU  H'0FF4'
TABLAT           EQU  H'0FF5'
TBLPTR           EQU  H'0FF6'
TBLPTRL          EQU  H'0FF6'
TBLPTRH          EQU  H'0FF7'
TBLPTRU          EQU  H'0FF8'
PC               EQU  H'0FF9'
PCL              EQU  H'0FF9'
PCLATH           EQU  H'0FFA'
PCLATU           EQU  H'0FFB'
STKPTR           EQU  H'0FFC'
TOS              EQU  H'0FFD'
TOSL             EQU  H'0FFD'
TOSH             EQU  H'0FFE'
TOSU             EQU  H'0FFF'

;----- SRCON1 Bits -----------------------------------------------------
SRRC1E           EQU  H'0000'
SRRC2E           EQU  H'0001'
SRRCKE           EQU  H'0002'
SRRPE            EQU  H'0003'
SRSC1E           EQU  H'0004'
SRSC2E           EQU  H'0005'
SRSCKE           EQU  H'0006'
SRSPE            EQU  H'0007'


;----- SRCON0 Bits -----------------------------------------------------
SRPR             EQU  H'0000'
SRPS             EQU  H'0001'
SRNQEN           EQU  H'0002'
SRQEN            EQU  H'0003'
SRLEN            EQU  H'0007'

SRCLK0           EQU  H'0004'
SRCLK1           EQU  H'0005'
SRCLK2           EQU  H'0006'


;----- CCPTMRS Bits -----------------------------------------------------
C1TSEL           EQU  H'0000'
C2TSEL           EQU  H'0003'


;----- ANSELA Bits -----------------------------------------------------
ANSA0            EQU  H'0000'
ANSA1            EQU  H'0001'
ANSA2            EQU  H'0002'
ANSA3            EQU  H'0003'
ANSA5            EQU  H'0005'


;----- ANSELB Bits -----------------------------------------------------
ANSB0            EQU  H'0000'
ANSB1            EQU  H'0001'
ANSB2            EQU  H'0002'
ANSB3            EQU  H'0003'
ANSB4            EQU  H'0004'
ANSB5            EQU  H'0005'


;----- ANSELC Bits -----------------------------------------------------
ANSC2            EQU  H'0002'
ANSC6            EQU  H'0006'
ANSC7            EQU  H'0007'


;----- UCON Bits -----------------------------------------------------
SUSPND           EQU  H'0001'
RESUME           EQU  H'0002'
USBEN            EQU  H'0003'
PKTDIS           EQU  H'0004'
SE0              EQU  H'0005'
PPBRST           EQU  H'0006'


;----- USTAT Bits -----------------------------------------------------
PPBI             EQU  H'0001'
DIR              EQU  H'0002'

ENDP0            EQU  H'0003'
ENDP1            EQU  H'0004'
ENDP2            EQU  H'0005'
ENDP3            EQU  H'0006'


;----- UCFG Bits -----------------------------------------------------
FSEN             EQU  H'0002'
UTRDIS           EQU  H'0003'
UPUEN            EQU  H'0004'
UOEMON           EQU  H'0006'
UTEYE            EQU  H'0007'

PPB0             EQU  H'0000'
PPB1             EQU  H'0001'


;----- UADDR Bits -----------------------------------------------------
ADDR0            EQU  H'0000'
ADDR1            EQU  H'0001'
ADDR2            EQU  H'0002'
ADDR3            EQU  H'0003'
ADDR4            EQU  H'0004'
ADDR5            EQU  H'0005'
ADDR6            EQU  H'0006'


;----- UIE Bits -----------------------------------------------------
URSTIE           EQU  H'0000'
UERRIE           EQU  H'0001'
ACTVIE           EQU  H'0002'
TRNIE            EQU  H'0003'
IDLEIE           EQU  H'0004'
STALLIE          EQU  H'0005'
SOFIE            EQU  H'0006'


;----- UIR Bits -----------------------------------------------------
URSTIF           EQU  H'0000'
UERRIF           EQU  H'0001'
ACTVIF           EQU  H'0002'
TRNIF            EQU  H'0003'
IDLEIF           EQU  H'0004'
STALLIF          EQU  H'0005'
SOFIF            EQU  H'0006'


;----- UEIE Bits -----------------------------------------------------
PIDEE            EQU  H'0000'
CRC5EE           EQU  H'0001'
CRC16EE          EQU  H'0002'
DFN8EE           EQU  H'0003'
BTOEE            EQU  H'0004'
BTSEE            EQU  H'0007'


;----- UEIR Bits -----------------------------------------------------
PIDEF            EQU  H'0000'
CRC5EF           EQU  H'0001'
CRC16EF          EQU  H'0002'
DFN8EF           EQU  H'0003'
BTOEF            EQU  H'0004'
BTSEF            EQU  H'0007'


;----- UFRML Bits -----------------------------------------------------
FRM0             EQU  H'0000'
FRM1             EQU  H'0001'
FRM2             EQU  H'0002'
FRM3             EQU  H'0003'
FRM4             EQU  H'0004'
FRM5             EQU  H'0005'
FRM6             EQU  H'0006'
FRM7             EQU  H'0007'


;----- UFRMH Bits -----------------------------------------------------
FRM8             EQU  H'0000'
FRM9             EQU  H'0001'
FRM10            EQU  H'0002'


;----- UEP0 Bits -----------------------------------------------------
EPSTALL          EQU  H'0000'
EPINEN           EQU  H'0001'
EPOUTEN          EQU  H'0002'
EPCONDIS         EQU  H'0003'
EPHSHK           EQU  H'0004'


;----- UEP1 Bits -----------------------------------------------------
EPSTALL          EQU  H'0000'
EPINEN           EQU  H'0001'
EPOUTEN          EQU  H'0002'
EPCONDIS         EQU  H'0003'
EPHSHK           EQU  H'0004'


;----- UEP2 Bits -----------------------------------------------------
EPSTALL          EQU  H'0000'
EPINEN           EQU  H'0001'
EPOUTEN          EQU  H'0002'
EPCONDIS         EQU  H'0003'
EPHSHK           EQU  H'0004'


;----- UEP3 Bits -----------------------------------------------------
EPSTALL          EQU  H'0000'
EPINEN           EQU  H'0001'
EPOUTEN          EQU  H'0002'
EPCONDIS         EQU  H'0003'
EPHSHK           EQU  H'0004'


;----- UEP4 Bits -----------------------------------------------------
EPSTALL          EQU  H'0000'
EPINEN           EQU  H'0001'
EPOUTEN          EQU  H'0002'
EPCONDIS         EQU  H'0003'
EPHSHK           EQU  H'0004'


;----- UEP5 Bits -----------------------------------------------------
EPSTALL          EQU  H'0000'
EPINEN           EQU  H'0001'
EPOUTEN          EQU  H'0002'
EPCONDIS         EQU  H'0003'
EPHSHK           EQU  H'0004'


;----- UEP6 Bits -----------------------------------------------------
EPSTALL          EQU  H'0000'
EPINEN           EQU  H'0001'
EPOUTEN          EQU  H'0002'
EPCONDIS         EQU  H'0003'
EPHSHK           EQU  H'0004'


;----- UEP7 Bits -----------------------------------------------------
EPSTALL          EQU  H'0000'
EPINEN           EQU  H'0001'
EPOUTEN          EQU  H'0002'
EPCONDIS         EQU  H'0003'
EPHSHK           EQU  H'0004'


;----- UEP8 Bits -----------------------------------------------------
EPSTALL          EQU  H'0000'
EPINEN           EQU  H'0001'
EPOUTEN          EQU  H'0002'
EPCONDIS         EQU  H'0003'
EPHSHK           EQU  H'0004'


;----- UEP9 Bits -----------------------------------------------------
EPSTALL          EQU  H'0000'
EPINEN           EQU  H'0001'
EPOUTEN          EQU  H'0002'
EPCONDIS         EQU  H'0003'
EPHSHK           EQU  H'0004'


;----- UEP10 Bits -----------------------------------------------------
EPSTALL          EQU  H'0000'
EPINEN           EQU  H'0001'
EPOUTEN          EQU  H'0002'
EPCONDIS         EQU  H'0003'
EPHSHK           EQU  H'0004'


;----- UEP11 Bits -----------------------------------------------------
EPSTALL          EQU  H'0000'
EPINEN           EQU  H'0001'
EPOUTEN          EQU  H'0002'
EPCONDIS         EQU  H'0003'
EPHSHK           EQU  H'0004'


;----- UEP12 Bits -----------------------------------------------------
EPSTALL          EQU  H'0000'
EPINEN           EQU  H'0001'
EPOUTEN          EQU  H'0002'
EPCONDIS         EQU  H'0003'
EPHSHK           EQU  H'0004'


;----- UEP13 Bits -----------------------------------------------------
EPSTALL          EQU  H'0000'
EPINEN           EQU  H'0001'
EPOUTEN          EQU  H'0002'
EPCONDIS         EQU  H'0003'
EPHSHK           EQU  H'0004'


;----- UEP14 Bits -----------------------------------------------------
EPSTALL          EQU  H'0000'
EPINEN           EQU  H'0001'
EPOUTEN          EQU  H'0002'
EPCONDIS         EQU  H'0003'
EPHSHK           EQU  H'0004'


;----- UEP15 Bits -----------------------------------------------------
EPSTALL          EQU  H'0000'
EPINEN           EQU  H'0001'
EPOUTEN          EQU  H'0002'
EPCONDIS         EQU  H'0003'
EPHSHK           EQU  H'0004'


;----- SLRCON Bits -----------------------------------------------------
SLRA             EQU  H'0000'
SLRB             EQU  H'0001'
SLRC             EQU  H'0002'


;----- VREFCON2 Bits -----------------------------------------------------
DACR0            EQU  H'0000'
DACR1            EQU  H'0001'
DACR2            EQU  H'0002'
DACR3            EQU  H'0003'
DACR4            EQU  H'0004'


;----- VREFCON1 Bits -----------------------------------------------------
DACNSS           EQU  H'0000'
DACOE            EQU  H'0005'
DACLPS           EQU  H'0006'
DACEN            EQU  H'0007'

DACPSS0          EQU  H'0002'
DACPSS1          EQU  H'0003'


;----- VREFCON0 Bits -----------------------------------------------------
TSRNG            EQU  H'0002'
TSEN             EQU  H'0003'
FVRST            EQU  H'0006'
FVREN            EQU  H'0007'

FVRS0            EQU  H'0004'
FVRS1            EQU  H'0005'


;----- PMD0 Bits -----------------------------------------------------
TMR1MD           EQU  H'0000'
TMR2MD           EQU  H'0001'
TMR3MD           EQU  H'0002'
ACTMD            EQU  H'0004'
USBMD            EQU  H'0005'
UARTMD           EQU  H'0006'

STMD             EQU  H'0004'
UART1MD          EQU  H'0006'


;----- PMD1 Bits -----------------------------------------------------
CCP1MD           EQU  H'0000'
CCP2MD           EQU  H'0001'
ADCMD            EQU  H'0002'
CMP1MD           EQU  H'0003'
CMP2MD           EQU  H'0004'
CTMUMD           EQU  H'0005'
MSSPMD           EQU  H'0006'

SSP1MD           EQU  H'0006'

MSSP1MD          EQU  H'0006'


;----- PORTA Bits -----------------------------------------------------
RA0              EQU  H'0000'
RA1              EQU  H'0001'
RA2              EQU  H'0002'
RA3              EQU  H'0003'
RA4              EQU  H'0004'
RA5              EQU  H'0005'
RA6              EQU  H'0006'
RA7              EQU  H'0007'

AN0              EQU  H'0000'
AN1              EQU  H'0001'
AN2              EQU  H'0002'
AN3              EQU  H'0003'
T0CKI            EQU  H'0004'
AN4              EQU  H'0005'
OSC2             EQU  H'0006'

VREFM            EQU  H'0002'
VREFP            EQU  H'0003'
LVDIN            EQU  H'0005'

HLVDIN           EQU  H'0005'


;----- PORTB Bits -----------------------------------------------------
RB0              EQU  H'0000'
RB1              EQU  H'0001'
RB2              EQU  H'0002'
RB3              EQU  H'0003'
RB4              EQU  H'0004'
RB5              EQU  H'0005'
RB6              EQU  H'0006'
RB7              EQU  H'0007'

INT0             EQU  H'0000'
INT1             EQU  H'0001'
INT2             EQU  H'0002'
PGM              EQU  H'0005'
PGC              EQU  H'0006'
PGD              EQU  H'0007'


;----- PORTC Bits -----------------------------------------------------
RC0              EQU  H'0000'
RC1              EQU  H'0001'
RC2              EQU  H'0002'
RC4              EQU  H'0004'
RC5              EQU  H'0005'
RC6              EQU  H'0006'
RC7              EQU  H'0007'

T1OSO            EQU  H'0000'
T1OSI            EQU  H'0001'
CCP1             EQU  H'0002'
TX               EQU  H'0006'
RX               EQU  H'0007'

T13CKI           EQU  H'0000'
P1A              EQU  H'0002'
CK               EQU  H'0006'
; DT is a reserved word
; DT               EQU  H'0007'


;----- PORTE Bits -----------------------------------------------------
RE3              EQU  H'0003'


;----- WPUB Bits -----------------------------------------------------
WPUB0            EQU  H'0000'
WPUB1            EQU  H'0001'
WPUB2            EQU  H'0002'
WPUB3            EQU  H'0003'
WPUB4            EQU  H'0004'
WPUB5            EQU  H'0005'
WPUB6            EQU  H'0006'
WPUB7            EQU  H'0007'


;----- IOCB Bits -----------------------------------------------------
IOCB4            EQU  H'0004'
IOCB5            EQU  H'0005'
IOCB6            EQU  H'0006'
IOCB7            EQU  H'0007'


;----- IOCC Bits -----------------------------------------------------
IOCC0            EQU  H'0000'
IOCC1            EQU  H'0001'
IOCC2            EQU  H'0002'
IOCC4            EQU  H'0004'
IOCC5            EQU  H'0005'
IOCC6            EQU  H'0006'
IOCC7            EQU  H'0007'


;----- CTMUICON Bits -----------------------------------------------------
IRNG0            EQU  H'0000'
IRNG1            EQU  H'0001'
ITRIM0           EQU  H'0002'
ITRIM1           EQU  H'0003'
ITRIM2           EQU  H'0004'
ITRIM3           EQU  H'0005'
ITRIM4           EQU  H'0006'
ITRIM5           EQU  H'0007'


;----- LATA Bits -----------------------------------------------------
LATA0            EQU  H'0000'
LATA1            EQU  H'0001'
LATA2            EQU  H'0002'
LATA3            EQU  H'0003'
LATA4            EQU  H'0004'
LATA5            EQU  H'0005'
LATA6            EQU  H'0006'
LATA7            EQU  H'0007'


;----- LATB Bits -----------------------------------------------------
LATB0            EQU  H'0000'
LATB1            EQU  H'0001'
LATB2            EQU  H'0002'
LATB3            EQU  H'0003'
LATB4            EQU  H'0004'
LATB5            EQU  H'0005'
LATB6            EQU  H'0006'
LATB7            EQU  H'0007'


;----- LATC Bits -----------------------------------------------------
LATC0            EQU  H'0000'
LATC1            EQU  H'0001'
LATC2            EQU  H'0002'
LATC4            EQU  H'0004'
LATC5            EQU  H'0005'
LATC6            EQU  H'0006'
LATC7            EQU  H'0007'


;----- CTMUCON1 Bits -----------------------------------------------------
EDG1STAT         EQU  H'0000'
EDG2STAT         EQU  H'0001'
EDG1POL          EQU  H'0004'
EDG2POL          EQU  H'0007'

EDG1SEL0         EQU  H'0002'
EDG1SEL1         EQU  H'0003'
EDG2SEL0         EQU  H'0005'
EDG2SEL1         EQU  H'0006'


;----- CTMUCONL Bits -----------------------------------------------------
EDG1STAT         EQU  H'0000'
EDG2STAT         EQU  H'0001'
EDG1POL          EQU  H'0004'
EDG2POL          EQU  H'0007'

EDG1SEL0         EQU  H'0002'
EDG1SEL1         EQU  H'0003'
EDG2SEL0         EQU  H'0005'
EDG2SEL1         EQU  H'0006'


;----- CTMUCON0 Bits -----------------------------------------------------
CTTRIG           EQU  H'0000'
IDISSEN          EQU  H'0001'
EDGSEQEN         EQU  H'0002'
EDGEN            EQU  H'0003'
TGEN             EQU  H'0004'
CTMUSIDL         EQU  H'0005'
CTMUEN           EQU  H'0007'

TRIGEN           EQU  H'0000'
SIDL             EQU  H'0005'
ON               EQU  H'0007'


;----- CTMUCONH Bits -----------------------------------------------------
CTTRIG           EQU  H'0000'
IDISSEN          EQU  H'0001'
EDGSEQEN         EQU  H'0002'
EDGEN            EQU  H'0003'
TGEN             EQU  H'0004'
CTMUSIDL         EQU  H'0005'
CTMUEN           EQU  H'0007'

TRIGEN           EQU  H'0000'
SIDL             EQU  H'0005'
ON               EQU  H'0007'


;----- DDRA Bits -----------------------------------------------------
TRISA0           EQU  H'0000'
TRISA1           EQU  H'0001'
TRISA2           EQU  H'0002'
TRISA3           EQU  H'0003'
TRISA4           EQU  H'0004'
TRISA5           EQU  H'0005'
TRISA6           EQU  H'0006'
TRISA7           EQU  H'0007'

RA0              EQU  H'0000'
RA1              EQU  H'0001'
RA2              EQU  H'0002'
RA3              EQU  H'0003'
RA4              EQU  H'0004'
RA5              EQU  H'0005'
RA6              EQU  H'0006'


;----- TRISA Bits -----------------------------------------------------
TRISA0           EQU  H'0000'
TRISA1           EQU  H'0001'
TRISA2           EQU  H'0002'
TRISA3           EQU  H'0003'
TRISA4           EQU  H'0004'
TRISA5           EQU  H'0005'
TRISA6           EQU  H'0006'
TRISA7           EQU  H'0007'

RA0              EQU  H'0000'
RA1              EQU  H'0001'
RA2              EQU  H'0002'
RA3              EQU  H'0003'
RA4              EQU  H'0004'
RA5              EQU  H'0005'
RA6              EQU  H'0006'


;----- DDRB Bits -----------------------------------------------------
TRISB0           EQU  H'0000'
TRISB1           EQU  H'0001'
TRISB2           EQU  H'0002'
TRISB3           EQU  H'0003'
TRISB4           EQU  H'0004'
TRISB5           EQU  H'0005'
TRISB6           EQU  H'0006'
TRISB7           EQU  H'0007'

RB0              EQU  H'0000'
RB1              EQU  H'0001'
RB2              EQU  H'0002'
RB3              EQU  H'0003'
RB4              EQU  H'0004'
RB5              EQU  H'0005'
RB6              EQU  H'0006'
RB7              EQU  H'0007'


;----- TRISB Bits -----------------------------------------------------
TRISB0           EQU  H'0000'
TRISB1           EQU  H'0001'
TRISB2           EQU  H'0002'
TRISB3           EQU  H'0003'
TRISB4           EQU  H'0004'
TRISB5           EQU  H'0005'
TRISB6           EQU  H'0006'
TRISB7           EQU  H'0007'

RB0              EQU  H'0000'
RB1              EQU  H'0001'
RB2              EQU  H'0002'
RB3              EQU  H'0003'
RB4              EQU  H'0004'
RB5              EQU  H'0005'
RB6              EQU  H'0006'
RB7              EQU  H'0007'


;----- DDRC Bits -----------------------------------------------------
TRISC0           EQU  H'0000'
TRISC1           EQU  H'0001'
TRISC2           EQU  H'0002'
TRISC4           EQU  H'0004'
TRISC5           EQU  H'0005'
TRISC6           EQU  H'0006'
TRISC7           EQU  H'0007'

RC0              EQU  H'0000'
RC1              EQU  H'0001'
RC2              EQU  H'0002'
RC6              EQU  H'0006'
RC7              EQU  H'0007'


;----- TRISC Bits -----------------------------------------------------
TRISC0           EQU  H'0000'
TRISC1           EQU  H'0001'
TRISC2           EQU  H'0002'
TRISC4           EQU  H'0004'
TRISC5           EQU  H'0005'
TRISC6           EQU  H'0006'
TRISC7           EQU  H'0007'

RC0              EQU  H'0000'
RC1              EQU  H'0001'
RC2              EQU  H'0002'
RC6              EQU  H'0006'
RC7              EQU  H'0007'


;----- CCP2CON Bits -----------------------------------------------------
CCP2M0           EQU  H'0000'
CCP2M1           EQU  H'0001'
CCP2M2           EQU  H'0002'
CCP2M3           EQU  H'0003'
DC2B0            EQU  H'0004'
DC2B1            EQU  H'0005'

CCP2Y            EQU  H'0004'
CCP2X            EQU  H'0005'


;----- ECCP2CON Bits -----------------------------------------------------
CCP2M0           EQU  H'0000'
CCP2M1           EQU  H'0001'
CCP2M2           EQU  H'0002'
CCP2M3           EQU  H'0003'
DC2B0            EQU  H'0004'
DC2B1            EQU  H'0005'

CCP2Y            EQU  H'0004'
CCP2X            EQU  H'0005'


;----- CM1CON0 Bits -----------------------------------------------------
C1R              EQU  H'0002'
C1SP             EQU  H'0003'
C1POL            EQU  H'0004'
C1OE             EQU  H'0005'
C1OUT            EQU  H'0006'
C1ON             EQU  H'0007'

C1CH0            EQU  H'0000'
C1CH1            EQU  H'0001'
CREF             EQU  H'0002'
CPOL             EQU  H'0004'
COE              EQU  H'0005'
COUT1            EQU  H'0006'
CON              EQU  H'0007'


CCH0             EQU  H'0000'
CCH1             EQU  H'0001'


;----- CM2CON0 Bits -----------------------------------------------------
C2R              EQU  H'0002'
C2SP             EQU  H'0003'
C2POL            EQU  H'0004'
C2OE             EQU  H'0005'
C2OUT            EQU  H'0006'
C2ON             EQU  H'0007'

C2CH0            EQU  H'0000'
C2CH1            EQU  H'0001'
CREF             EQU  H'0002'
CPOL             EQU  H'0004'
COE              EQU  H'0005'
COUT2            EQU  H'0006'
CON              EQU  H'0007'


CCH0             EQU  H'0000'
CCH1             EQU  H'0001'


;----- CM2CON1 Bits -----------------------------------------------------
C2SYNC           EQU  H'0000'
C1SYNC           EQU  H'0001'
C2HYS            EQU  H'0002'
C1HYS            EQU  H'0003'
C2RSEL           EQU  H'0004'
C1RSEL           EQU  H'0005'
MC2OUT           EQU  H'0006'
MC1OUT           EQU  H'0007'


;----- OSCTUNE Bits -----------------------------------------------------
SPLLMULT         EQU  H'0007'

TUN0             EQU  H'0000'
TUN1             EQU  H'0001'
TUN2             EQU  H'0002'
TUN3             EQU  H'0003'
TUN4             EQU  H'0004'
TUN5             EQU  H'0005'
TUN6             EQU  H'0006'


;----- HLVDCON Bits -----------------------------------------------------
HLVDEN           EQU  H'0004'
IRVST            EQU  H'0005'
BGVST            EQU  H'0006'
VDIRMAG          EQU  H'0007'

HLVDL0           EQU  H'0000'
HLVDL1           EQU  H'0001'
HLVDL2           EQU  H'0002'
HLVDL3           EQU  H'0003'


;----- PIE1 Bits -----------------------------------------------------
TMR1IE           EQU  H'0000'
TMR2IE           EQU  H'0001'
CCP1IE           EQU  H'0002'
SSPIE            EQU  H'0003'
TXIE             EQU  H'0004'
RCIE             EQU  H'0005'
ADIE             EQU  H'0006'
ACTIE            EQU  H'0007'

SSP1IE           EQU  H'0003'
TX1IE            EQU  H'0004'
RC1IE            EQU  H'0005'
STIE             EQU  H'0007'


;----- PIR1 Bits -----------------------------------------------------
TMR1IF           EQU  H'0000'
TMR2IF           EQU  H'0001'
CCP1IF           EQU  H'0002'
SSPIF            EQU  H'0003'
TXIF             EQU  H'0004'
RCIF             EQU  H'0005'
ADIF             EQU  H'0006'
ACTIF            EQU  H'0007'

SSP1IF           EQU  H'0003'
TX1IF            EQU  H'0004'
RC1IF            EQU  H'0005'
STIF             EQU  H'0007'


;----- IPR1 Bits -----------------------------------------------------
TMR1IP           EQU  H'0000'
TMR2IP           EQU  H'0001'
CCP1IP           EQU  H'0002'
SSPIP            EQU  H'0003'
TXIP             EQU  H'0004'
RCIP             EQU  H'0005'
ADIP             EQU  H'0006'
ACTIP            EQU  H'0007'

SSP1IP           EQU  H'0003'
TX1IP            EQU  H'0004'
RC1IP            EQU  H'0005'
STIP             EQU  H'0007'


;----- PIE2 Bits -----------------------------------------------------
CCP2IE           EQU  H'0000'
TMR3IE           EQU  H'0001'
HLVDIE           EQU  H'0002'
BCLIE            EQU  H'0003'
EEIE             EQU  H'0004'
C2IE             EQU  H'0005'
C1IE             EQU  H'0006'
OSCFIE           EQU  H'0007'

LVDIE            EQU  H'0002'
BCL1IE           EQU  H'0003'
CM2IE            EQU  H'0005'
CM1IE            EQU  H'0006'


;----- PIR2 Bits -----------------------------------------------------
CCP2IF           EQU  H'0000'
TMR3IF           EQU  H'0001'
HLVDIF           EQU  H'0002'
BCLIF            EQU  H'0003'
EEIF             EQU  H'0004'
C2IF             EQU  H'0005'
C1IF             EQU  H'0006'
OSCFIF           EQU  H'0007'

LVDIF            EQU  H'0002'
BCL1IF           EQU  H'0003'
CM2IF            EQU  H'0005'
CM1IF            EQU  H'0006'


;----- IPR2 Bits -----------------------------------------------------
CCP2IP           EQU  H'0000'
TMR3IP           EQU  H'0001'
HLVDIP           EQU  H'0002'
BCLIP            EQU  H'0003'
EEIP             EQU  H'0004'
C2IP             EQU  H'0005'
C1IP             EQU  H'0006'
OSCFIP           EQU  H'0007'

LVDIP            EQU  H'0002'
BCL1IP           EQU  H'0003'
CM2IP            EQU  H'0005'
CM1IP            EQU  H'0006'


;----- PIE3 Bits -----------------------------------------------------
TMR1GIE          EQU  H'0000'
TMR3GIE          EQU  H'0001'
USBIE            EQU  H'0002'
CTMUIE           EQU  H'0003'


;----- PIR3 Bits -----------------------------------------------------
TMR1GIF          EQU  H'0000'
TMR3GIF          EQU  H'0001'
USBIF            EQU  H'0002'
CTMUIF           EQU  H'0003'


;----- IPR3 Bits -----------------------------------------------------
TMR1GIP          EQU  H'0000'
TMR3GIP          EQU  H'0001'
USBIP            EQU  H'0002'
CTMUIP           EQU  H'0003'


;----- EECON1 Bits -----------------------------------------------------
RD               EQU  H'0000'
WR               EQU  H'0001'
WREN             EQU  H'0002'
WRERR            EQU  H'0003'
FREE             EQU  H'0004'
CFGS             EQU  H'0006'
EEPGD            EQU  H'0007'


;----- RCSTA Bits -----------------------------------------------------
RX9D             EQU  H'0000'
OERR             EQU  H'0001'
FERR             EQU  H'0002'
ADDEN            EQU  H'0003'
CREN             EQU  H'0004'
SREN             EQU  H'0005'
RX9              EQU  H'0006'
SPEN             EQU  H'0007'

ADEN             EQU  H'0003'


;----- RCSTA1 Bits -----------------------------------------------------
RX9D             EQU  H'0000'
OERR             EQU  H'0001'
FERR             EQU  H'0002'
ADDEN            EQU  H'0003'
CREN             EQU  H'0004'
SREN             EQU  H'0005'
RX9              EQU  H'0006'
SPEN             EQU  H'0007'

ADEN             EQU  H'0003'


;----- TXSTA Bits -----------------------------------------------------
TX9D             EQU  H'0000'
TRMT             EQU  H'0001'
BRGH             EQU  H'0002'
SENDB            EQU  H'0003'
SYNC             EQU  H'0004'
TXEN             EQU  H'0005'
TX9              EQU  H'0006'
CSRC             EQU  H'0007'


;----- TXSTA1 Bits -----------------------------------------------------
TX9D             EQU  H'0000'
TRMT             EQU  H'0001'
BRGH             EQU  H'0002'
SENDB            EQU  H'0003'
SYNC             EQU  H'0004'
TXEN             EQU  H'0005'
TX9              EQU  H'0006'
CSRC             EQU  H'0007'


;----- SPBRG Bits -----------------------------------------------------
BRG0             EQU  H'0000'
BRG1             EQU  H'0001'
BRG2             EQU  H'0002'
BRG3             EQU  H'0003'
BRG4             EQU  H'0004'
BRG5             EQU  H'0005'
BRG6             EQU  H'0006'
BRG7             EQU  H'0007'


;----- SPBRG1 Bits -----------------------------------------------------
BRG0             EQU  H'0000'
BRG1             EQU  H'0001'
BRG2             EQU  H'0002'
BRG3             EQU  H'0003'
BRG4             EQU  H'0004'
BRG5             EQU  H'0005'
BRG6             EQU  H'0006'
BRG7             EQU  H'0007'


;----- SPBRGH Bits -----------------------------------------------------
BRG8             EQU  H'0000'
BRG9             EQU  H'0001'
BRG10            EQU  H'0002'
BRG11            EQU  H'0003'
BRG12            EQU  H'0004'
BRG13            EQU  H'0005'
BRG14            EQU  H'0006'
BRG15            EQU  H'0007'


;----- SPBRGH1 Bits -----------------------------------------------------
BRG8             EQU  H'0000'
BRG9             EQU  H'0001'
BRG10            EQU  H'0002'
BRG11            EQU  H'0003'
BRG12            EQU  H'0004'
BRG13            EQU  H'0005'
BRG14            EQU  H'0006'
BRG15            EQU  H'0007'


;----- T3CON Bits -----------------------------------------------------
TMR3ON           EQU  H'0000'
RD16             EQU  H'0001'
NOT_T3SYNC       EQU  H'0002'
SOSCEN           EQU  H'0003'

T3RD16           EQU  H'0001'
T3SYNC           EQU  H'0002'
T3SOSCEN         EQU  H'0003'
T3CKPS0          EQU  H'0004'
T3CKPS1          EQU  H'0005'
TMR3CS0          EQU  H'0006'
TMR3CS1          EQU  H'0007'

T3OSCEN          EQU  H'0003'


;----- T3GCON Bits -----------------------------------------------------
T3GVAL           EQU  H'0002'
T3GGO_NOT_T3DONE EQU  H'0003'
T3GSPM           EQU  H'0004'
T3GTM            EQU  H'0005'
T3GPOL           EQU  H'0006'
TMR3GE           EQU  H'0007'

T3GSS0           EQU  H'0000'
T3GSS1           EQU  H'0001'
T3GGO            EQU  H'0003'

NOT_T3DONE       EQU  H'0003'

T3DONE           EQU  H'0003'

T3GGO_NOT_DONE   EQU  H'0003'


;----- ACTCON Bits -----------------------------------------------------
ACTORS           EQU  H'0001'
ACTLOCK          EQU  H'0003'
ACTSRC           EQU  H'0004'
ACTUD            EQU  H'0006'
ACTEN            EQU  H'0007'

STOR             EQU  H'0001'
STLOCK           EQU  H'0003'
STSRC            EQU  H'0004'
STUD             EQU  H'0006'
STEN             EQU  H'0007'

ACTOR            EQU  H'0001'
ACTD             EQU  H'0006'
ACTSEL           EQU  H'0007'


;----- STCON Bits -----------------------------------------------------
ACTORS           EQU  H'0001'
ACTLOCK          EQU  H'0003'
ACTSRC           EQU  H'0004'
ACTUD            EQU  H'0006'
ACTEN            EQU  H'0007'

STOR             EQU  H'0001'
STLOCK           EQU  H'0003'
STSRC            EQU  H'0004'
STUD             EQU  H'0006'
STEN             EQU  H'0007'

ACTOR            EQU  H'0001'
ACTD             EQU  H'0006'
ACTSEL           EQU  H'0007'


;----- ECCP1AS Bits -----------------------------------------------------
ECCP1ASE         EQU  H'0007'

PSS1BD0          EQU  H'0000'
PSS1BD1          EQU  H'0001'
PSS1AC0          EQU  H'0002'
PSS1AC1          EQU  H'0003'
ECCP1AS0         EQU  H'0004'
ECCP1AS1         EQU  H'0005'
ECCP1AS2         EQU  H'0006'
CCP1ASE          EQU  H'0007'


PSSBD0           EQU  H'0000'
PSSBD1           EQU  H'0001'
PSSAC0           EQU  H'0002'
PSSAC1           EQU  H'0003'


;----- ECCP1DEL Bits -----------------------------------------------------
P1RSEN           EQU  H'0007'

PDC0             EQU  H'0000'
PDC1             EQU  H'0001'
PDC2             EQU  H'0002'
PDC3             EQU  H'0003'
PDC4             EQU  H'0004'
PDC5             EQU  H'0005'
PDC6             EQU  H'0006'
PR1SEN           EQU  H'0007'


;----- PWM1CON Bits -----------------------------------------------------
P1RSEN           EQU  H'0007'

PDC0             EQU  H'0000'
PDC1             EQU  H'0001'
PDC2             EQU  H'0002'
PDC3             EQU  H'0003'
PDC4             EQU  H'0004'
PDC5             EQU  H'0005'
PDC6             EQU  H'0006'
PR1SEN           EQU  H'0007'


;----- BAUDCON Bits -----------------------------------------------------
ABDEN            EQU  H'0000'
WUE              EQU  H'0001'
BRG16            EQU  H'0003'
TXCKP            EQU  H'0004'
RXDTP            EQU  H'0005'
RCIDL            EQU  H'0006'
ABDOVF           EQU  H'0007'

CKTXP            EQU  H'0004'
DTRXP            EQU  H'0005'

SCKP             EQU  H'0004'
RCMT             EQU  H'0006'


;----- BAUDCON1 Bits -----------------------------------------------------
ABDEN            EQU  H'0000'
WUE              EQU  H'0001'
BRG16            EQU  H'0003'
TXCKP            EQU  H'0004'
RXDTP            EQU  H'0005'
RCIDL            EQU  H'0006'
ABDOVF           EQU  H'0007'

CKTXP            EQU  H'0004'
DTRXP            EQU  H'0005'

SCKP             EQU  H'0004'
RCMT             EQU  H'0006'


;----- PSTR1CON Bits -----------------------------------------------------
STRA             EQU  H'0000'
STRB             EQU  H'0001'
STRC             EQU  H'0002'
STRD             EQU  H'0003'
STRSYNC          EQU  H'0004'

STR1A            EQU  H'0000'
STR1B            EQU  H'0001'
STR1C            EQU  H'0002'
STR1D            EQU  H'0003'
STR1SYNC         EQU  H'0004'


;----- T2CON Bits -----------------------------------------------------
TMR2ON           EQU  H'0002'

T2CKPS0          EQU  H'0000'
T2CKPS1          EQU  H'0001'
T2OUTPS0         EQU  H'0003'
T2OUTPS1         EQU  H'0004'
T2OUTPS2         EQU  H'0005'
T2OUTPS3         EQU  H'0006'


;----- CCP1CON Bits -----------------------------------------------------
CCP1M0           EQU  H'0000'
CCP1M1           EQU  H'0001'
CCP1M2           EQU  H'0002'
CCP1M3           EQU  H'0003'
DC1B0            EQU  H'0004'
DC1B1            EQU  H'0005'
P1M0             EQU  H'0006'
P1M1             EQU  H'0007'

CCP1Y            EQU  H'0004'
CCP1X            EQU  H'0005'


;----- ECCP1CON Bits -----------------------------------------------------
CCP1M0           EQU  H'0000'
CCP1M1           EQU  H'0001'
CCP1M2           EQU  H'0002'
CCP1M3           EQU  H'0003'
DC1B0            EQU  H'0004'
DC1B1            EQU  H'0005'
P1M0             EQU  H'0006'
P1M1             EQU  H'0007'

CCP1Y            EQU  H'0004'
CCP1X            EQU  H'0005'


;----- ADCON2 Bits -----------------------------------------------------
ADFM             EQU  H'0007'

ADCS0            EQU  H'0000'
ADCS1            EQU  H'0001'
ADCS2            EQU  H'0002'
ACQT0            EQU  H'0003'
ACQT1            EQU  H'0004'
ACQT2            EQU  H'0005'


;----- ADCON1 Bits -----------------------------------------------------
TRIGSEL          EQU  H'0007'

NVCFG0           EQU  H'0000'
NVCFG1           EQU  H'0001'
PVCFG0           EQU  H'0002'
PVCFG1           EQU  H'0003'


;----- ADCON0 Bits -----------------------------------------------------
ADON             EQU  H'0000'
GO_NOT_DONE      EQU  H'0001'

DONE             EQU  H'0001'

GO               EQU  H'0001'

NOT_DONE         EQU  H'0001'


;----- SSP1CON2 Bits -----------------------------------------------------
SEN              EQU  H'0000'
RSEN             EQU  H'0001'
PEN              EQU  H'0002'
RCEN             EQU  H'0003'
ACKEN            EQU  H'0004'
ACKDT            EQU  H'0005'
ACKSTAT          EQU  H'0006'
GCEN             EQU  H'0007'


;----- SSPCON2 Bits -----------------------------------------------------
SEN              EQU  H'0000'
RSEN             EQU  H'0001'
PEN              EQU  H'0002'
RCEN             EQU  H'0003'
ACKEN            EQU  H'0004'
ACKDT            EQU  H'0005'
ACKSTAT          EQU  H'0006'
GCEN             EQU  H'0007'


;----- SSP1CON1 Bits -----------------------------------------------------
CKP              EQU  H'0004'
SSPEN            EQU  H'0005'
SSPOV            EQU  H'0006'
WCOL             EQU  H'0007'

SSPM0            EQU  H'0000'
SSPM1            EQU  H'0001'
SSPM2            EQU  H'0002'
SSPM3            EQU  H'0003'


;----- SSPCON Bits -----------------------------------------------------
CKP              EQU  H'0004'
SSPEN            EQU  H'0005'
SSPOV            EQU  H'0006'
WCOL             EQU  H'0007'

SSPM0            EQU  H'0000'
SSPM1            EQU  H'0001'
SSPM2            EQU  H'0002'
SSPM3            EQU  H'0003'


;----- SSPCON1 Bits -----------------------------------------------------
CKP              EQU  H'0004'
SSPEN            EQU  H'0005'
SSPOV            EQU  H'0006'
WCOL             EQU  H'0007'

SSPM0            EQU  H'0000'
SSPM1            EQU  H'0001'
SSPM2            EQU  H'0002'
SSPM3            EQU  H'0003'


;----- SSP1STAT Bits -----------------------------------------------------
BF               EQU  H'0000'
UA               EQU  H'0001'
R_NOT_W          EQU  H'0002'
S                EQU  H'0003'
P                EQU  H'0004'
D_NOT_A          EQU  H'0005'
CKE              EQU  H'0006'
SMP              EQU  H'0007'


;----- SSPSTAT Bits -----------------------------------------------------
BF               EQU  H'0000'
UA               EQU  H'0001'
R_NOT_W          EQU  H'0002'
S                EQU  H'0003'
P                EQU  H'0004'
D_NOT_A          EQU  H'0005'
CKE              EQU  H'0006'
SMP              EQU  H'0007'


;----- SSP1ADD Bits -----------------------------------------------------
SSP1ADD0         EQU  H'0000'
SSP1ADD1         EQU  H'0001'
SSP1ADD2         EQU  H'0002'
SSP1ADD3         EQU  H'0003'
SSP1ADD4         EQU  H'0004'
SSP1ADD5         EQU  H'0005'
SSP1ADD6         EQU  H'0006'
SSP1ADD7         EQU  H'0007'


;----- SSPADD Bits -----------------------------------------------------
SSP1ADD0         EQU  H'0000'
SSP1ADD1         EQU  H'0001'
SSP1ADD2         EQU  H'0002'
SSP1ADD3         EQU  H'0003'
SSP1ADD4         EQU  H'0004'
SSP1ADD5         EQU  H'0005'
SSP1ADD6         EQU  H'0006'
SSP1ADD7         EQU  H'0007'


;----- SSP1MSK Bits -----------------------------------------------------
SSP1MSK0         EQU  H'0000'
SSP1MSK1         EQU  H'0001'
SSP1MSK2         EQU  H'0002'
SSP1MSK3         EQU  H'0003'
SSP1MSK4         EQU  H'0004'
SSP1MSK5         EQU  H'0005'
SSP1MSK6         EQU  H'0006'
SSP1MSK7         EQU  H'0007'


;----- SSPMSK Bits -----------------------------------------------------
SSP1MSK0         EQU  H'0000'
SSP1MSK1         EQU  H'0001'
SSP1MSK2         EQU  H'0002'
SSP1MSK3         EQU  H'0003'
SSP1MSK4         EQU  H'0004'
SSP1MSK5         EQU  H'0005'
SSP1MSK6         EQU  H'0006'
SSP1MSK7         EQU  H'0007'


;----- SSP1CON3 Bits -----------------------------------------------------
DHEN             EQU  H'0000'
AHEN             EQU  H'0001'
SBCDE            EQU  H'0002'
SDAHT            EQU  H'0003'
BOEN             EQU  H'0004'
SCIE             EQU  H'0005'
PCIE             EQU  H'0006'
ACKTIM           EQU  H'0007'


;----- SSPCON3 Bits -----------------------------------------------------
DHEN             EQU  H'0000'
AHEN             EQU  H'0001'
SBCDE            EQU  H'0002'
SDAHT            EQU  H'0003'
BOEN             EQU  H'0004'
SCIE             EQU  H'0005'
PCIE             EQU  H'0006'
ACKTIM           EQU  H'0007'


;----- T1GCON Bits -----------------------------------------------------
T1GVAL           EQU  H'0002'
T1GGO_NOT_T1DONE EQU  H'0003'
T1GSPM           EQU  H'0004'
T1GTM            EQU  H'0005'
T1GPOL           EQU  H'0006'
TMR1GE           EQU  H'0007'

T1GSS0           EQU  H'0000'
T1GSS1           EQU  H'0001'
T1GGO            EQU  H'0003'

NOT_T1DONE       EQU  H'0003'

T1DONE           EQU  H'0003'

T1GGO_NOT_DONE   EQU  H'0003'


;----- T1CON Bits -----------------------------------------------------
TMR1ON           EQU  H'0000'
RD16             EQU  H'0001'
NOT_T1SYNC       EQU  H'0002'
SOSCEN           EQU  H'0003'

T1RD16           EQU  H'0001'
T1SYNC           EQU  H'0002'
T1SOSCEN         EQU  H'0003'
T1CKPS0          EQU  H'0004'
T1CKPS1          EQU  H'0005'
TMR1CS0          EQU  H'0006'
TMR1CS1          EQU  H'0007'

T1OSCEN          EQU  H'0003'


;----- RCON Bits -----------------------------------------------------
NOT_BOR          EQU  H'0000'
NOT_POR          EQU  H'0001'
NOT_PD           EQU  H'0002'
NOT_TO           EQU  H'0003'
NOT_RI           EQU  H'0004'
SBOREN           EQU  H'0006'
IPEN             EQU  H'0007'

BOR              EQU  H'0000'
POR              EQU  H'0001'
PD               EQU  H'0002'
TO               EQU  H'0003'
RI               EQU  H'0004'


;----- WDTCON Bits -----------------------------------------------------
SWDTEN           EQU  H'0000'

SWDTE            EQU  H'0000'


;----- OSCCON2 Bits -----------------------------------------------------
LFIOFS           EQU  H'0000'
HFIOFR           EQU  H'0001'
PRISD            EQU  H'0002'
SOSCGO           EQU  H'0003'
PLLEN            EQU  H'0004'
INTSRC           EQU  H'0005'
SOSCRUN          EQU  H'0006'
PLLRDY           EQU  H'0007'


;----- OSCCON Bits -----------------------------------------------------
HFIOFS           EQU  H'0002'
OSTS             EQU  H'0003'
IDLEN            EQU  H'0007'

SCS0             EQU  H'0000'
SCS1             EQU  H'0001'
FLTS             EQU  H'0002'
IRCF0            EQU  H'0004'
IRCF1            EQU  H'0005'
IRCF2            EQU  H'0006'


;----- T0CON Bits -----------------------------------------------------
PSA              EQU  H'0003'
T0SE             EQU  H'0004'
T0CS             EQU  H'0005'
T08BIT           EQU  H'0006'
TMR0ON           EQU  H'0007'

T0PS0            EQU  H'0000'
T0PS1            EQU  H'0001'
T0PS2            EQU  H'0002'


;----- STATUS Bits -----------------------------------------------------
C                EQU  H'0000'
DC               EQU  H'0001'
Z                EQU  H'0002'
OV               EQU  H'0003'
N                EQU  H'0004'


;----- INTCON3 Bits -----------------------------------------------------
INT1IF           EQU  H'0000'
INT2IF           EQU  H'0001'
INT1IE           EQU  H'0003'
INT2IE           EQU  H'0004'
INT1IP           EQU  H'0006'
INT2IP           EQU  H'0007'

INT1F            EQU  H'0000'
INT2F            EQU  H'0001'
INT1E            EQU  H'0003'
INT2E            EQU  H'0004'
INT1P            EQU  H'0006'
INT2P            EQU  H'0007'


;----- INTCON2 Bits -----------------------------------------------------
IOCIP            EQU  H'0000'
TMR0IP           EQU  H'0002'
INTEDG2          EQU  H'0004'
INTEDG1          EQU  H'0005'
INTEDG0          EQU  H'0006'
NOT_RBPU         EQU  H'0007'

T0IP             EQU  H'0002'
RBPU             EQU  H'0007'


;----- INTCON Bits -----------------------------------------------------
IOCIF            EQU  H'0000'
INT0IF           EQU  H'0001'
TMR0IF           EQU  H'0002'
IOCIE            EQU  H'0003'
INT0IE           EQU  H'0004'
TMR0IE           EQU  H'0005'
PEIE_GIEL        EQU  H'0006'
GIE_GIEH         EQU  H'0007'

INT0F            EQU  H'0001'
T0IF             EQU  H'0002'
INT0E            EQU  H'0004'
T0IE             EQU  H'0005'
PEIE             EQU  H'0006'
GIE              EQU  H'0007'

GIEL             EQU  H'0006'
GIEH             EQU  H'0007'


;----- STKPTR Bits -----------------------------------------------------
STKUNF           EQU  H'0006'
STKFUL           EQU  H'0007'

SP0              EQU  H'0000'
SP1              EQU  H'0001'
SP2              EQU  H'0002'
SP3              EQU  H'0003'
SP4              EQU  H'0004'
STKOVF           EQU  H'0007'



;==========================================================================
;
;       RAM Definitions
;
;==========================================================================
       __MAXRAM  H'0FFF'
       __BADRAM  H'0800'-H'0F52'
       __BADRAM  H'0F53'-H'0F56'
       __BADRAM  H'0F5A'
       __BADRAM  H'0F5E'-H'0F5F'
       __BADRAM  H'0F83'
       __BADRAM  H'0F8C'-H'0F8D'
       __BADRAM  H'0F95'-H'0F96'
       __BADRAM  H'0FAA'
       __BADRAM  H'0FD4'

;==========================================================================
;
;   IMPORTANT: For the PIC18 devices, the __CONFIG directive has been
;              superseded by the CONFIG directive.  The following settings
;              are available for this device.
;
;   PLL Selection:
;     PLLSEL = PLL4X       4x clock multiplier
;     PLLSEL = PLL3X       3x clock multiplier
;
;   PLL Enable Configuration bit:
;     CFGPLLEN = OFF       PLL Disabled (firmware controlled)
;     CFGPLLEN = ON        PLL Enabled
;
;   CPU System Clock Postscaler:
;     CPUDIV = NOCLKDIV    CPU uses system clock (no divide)
;     CPUDIV = CLKDIV2     CPU uses system clock divided by 2
;     CPUDIV = CLKDIV3     CPU uses system clock divided by 3
;     CPUDIV = CLKDIV6     CPU uses system clock divided by 6
;
;   Low Speed USB mode with 48 MHz system clock:
;     LS48MHZ = SYS24X4    System clock at 24 MHz, USB clock divider is set to 4
;     LS48MHZ = SYS48X8    System clock at 48 MHz, USB clock divider is set to 8
;
;   Oscillator Selection:
;     FOSC = LP            LP oscillator
;     FOSC = XT            XT oscillator
;     FOSC = HSH           HS oscillator, high power 16MHz to 25MHz
;     FOSC = HSM           HS oscillator, medium power 4MHz to 16MHz
;     FOSC = ECHCLKO       EC oscillator, high power 16MHz to 48MHz, clock output on OSC2
;     FOSC = ECHIO         EC oscillator, high power 16MHz to 48MHz
;     FOSC = RCCLKO        External RC oscillator, clock output on OSC2
;     FOSC = RCIO          External RC oscillator
;     FOSC = INTOSCIO      Internal oscillator
;     FOSC = INTOSCCLKO    Internal oscillator, clock output on OSC2
;     FOSC = ECMCLKO       EC oscillator, medium power 4MHz to 16MHz, clock output on OSC2
;     FOSC = ECMIO         EC oscillator, medium power 4MHz to 16MHz
;     FOSC = ECLCLKO       EC oscillator, low power <4MHz, clock output on OSC2
;     FOSC = ECLIO         EC oscillator, low power <4MHz
;
;   Primary Oscillator Shutdown:
;     PCLKEN = OFF         Primary oscillator shutdown firmware controlled
;     PCLKEN = ON          Primary oscillator enabled
;
;   Fail-Safe Clock Monitor:
;     FCMEN = OFF          Fail-Safe Clock Monitor disabled
;     FCMEN = ON           Fail-Safe Clock Monitor enabled
;
;   Internal/External Oscillator Switchover:
;     IESO = OFF           Oscillator Switchover mode disabled
;     IESO = ON            Oscillator Switchover mode enabled
;
;   Power-up Timer Enable:
;     nPWRTEN = ON         Power up timer enabled
;     nPWRTEN = OFF        Power up timer disabled
;
;   Brown-out Reset Enable:
;     BOREN = OFF          BOR disabled in hardware (SBOREN is ignored)
;     BOREN = ON           BOR controlled by firmware (SBOREN is enabled)
;     BOREN = NOSLP        BOR enabled in hardware, disabled in Sleep mode (SBOREN is ignored)
;     BOREN = SBORDIS      BOR enabled in hardware (SBOREN is ignored)
;
;   Brown-out Reset Voltage:
;     BORV = 285           BOR set to 2.85V nominal
;     BORV = 250           BOR set to 2.5V nominal
;     BORV = 220           BOR set to 2.2V nominal
;     BORV = 190           BOR set to 1.9V nominal
;
;   Low-Power Brown-out Reset:
;     nLPBOR = ON          Low-Power Brown-out Reset enabled
;     nLPBOR = OFF         Low-Power Brown-out Reset disabled
;
;   Watchdog Timer Enable bits:
;     WDTEN = OFF          WDT disabled in hardware (SWDTEN ignored)
;     WDTEN = NOSLP        WDT enabled in hardware, disabled in Sleep mode (SWDTEN ignored)
;     WDTEN = SWON         WDT controlled by firmware (SWDTEN enabled)
;     WDTEN = ON           WDT enabled in hardware (SWDTEN ignored)
;
;   Watchdog Timer Postscaler:
;     WDTPS = 1            1:1
;     WDTPS = 2            1:2
;     WDTPS = 4            1:4
;     WDTPS = 8            1:8
;     WDTPS = 16           1:16
;     WDTPS = 32           1:32
;     WDTPS = 64           1:64
;     WDTPS = 128          1:128
;     WDTPS = 256          1:256
;     WDTPS = 512          1:512
;     WDTPS = 1024         1:1024
;     WDTPS = 2048         1:2048
;     WDTPS = 4096         1:4096
;     WDTPS = 8192         1:8192
;     WDTPS = 16384        1:16384
;     WDTPS = 32768        1:32768
;
;   CCP2 MUX bit:
;     CCP2MX = RB3         CCP2 input/output is multiplexed with RB3
;     CCP2MX = RC1         CCP2 input/output is multiplexed with RC1
;
;   PORTB A/D Enable bit:
;     PBADEN = OFF         PORTB<5:0> pins are configured as digital I/O on Reset
;     PBADEN = ON          PORTB<5:0> pins are configured as analog input channels on Reset
;
;   Timer3 Clock Input MUX bit:
;     T3CMX = RB5          T3CKI function is on RB5
;     T3CMX = RC0          T3CKI function is on RC0
;
;   SDO Output MUX bit:
;     SDOMX = RC7          SDO function is on RC7
;     SDOMX = RB3          SDO function is on RB3
;
;   Master Clear Reset Pin Enable:
;     MCLRE = OFF          RE3 input pin enabled; external MCLR disabled
;     MCLRE = ON           MCLR pin enabled; RE3 input disabled
;
;   Stack Full/Underflow Reset:
;     STVREN = OFF         Stack full/underflow will not cause Reset
;     STVREN = ON          Stack full/underflow will cause Reset
;
;   Single-Supply ICSP Enable bit:
;     LVP = OFF            Single-Supply ICSP disabled
;     LVP = ON             Single-Supply ICSP enabled if MCLRE is also 1
;
;   Dedicated In-Circuit Debug/Programming Port Enable:
;     ICPRT = OFF          ICPORT disabled
;
;   Extended Instruction Set Enable bit:
;     XINST = OFF          Instruction set extension and Indexed Addressing mode disabled
;     XINST = ON           Instruction set extension and Indexed Addressing mode enabled
;
;   Background Debugger Enable bit:
;     DEBUG = ON           Background debugger enabled, RB6 and RB7 are dedicated to In-Circuit Debug
;     DEBUG = OFF          Background debugger disabled, RB6 and RB7 configured as general purpose I/O pins
;
;   Block 0 Code Protect:
;     CP0 = ON             Block 0 is code-protected
;     CP0 = OFF            Block 0 is not code-protected
;
;   Block 1 Code Protect:
;     CP1 = ON             Block 1 is code-protected
;     CP1 = OFF            Block 1 is not code-protected
;
;   Boot Block Code Protect:
;     CPB = ON             Boot block is code-protected
;     CPB = OFF            Boot block is not code-protected
;
;   Data EEPROM Code Protect:
;     CPD = ON             Data EEPROM is code-protected
;     CPD = OFF            Data EEPROM is not code-protected
;
;   Block 0 Write Protect:
;     WRT0 = ON            Block 0 (0800-1FFFh) is write-protected
;     WRT0 = OFF           Block 0 (0800-1FFFh) is not write-protected
;
;   Block 1 Write Protect:
;     WRT1 = ON            Block 1 (2000-3FFFh) is write-protected
;     WRT1 = OFF           Block 1 (2000-3FFFh) is not write-protected
;
;   Configuration Registers Write Protect:
;     WRTC = ON            Configuration registers (300000-3000FFh) are write-protected
;     WRTC = OFF           Configuration registers (300000-3000FFh) are not write-protected
;
;   Boot Block Write Protect:
;     WRTB = ON            Boot block (0000-7FFh) is write-protected
;     WRTB = OFF           Boot block (0000-7FFh) is not write-protected
;
;   Data EEPROM Write Protect:
;     WRTD = ON            Data EEPROM is write-protected
;     WRTD = OFF           Data EEPROM is not write-protected
;
;   Block 0 Table Read Protect:
;     EBTR0 = ON           Block 0 is protected from table reads executed in other blocks
;     EBTR0 = OFF          Block 0 is not protected from table reads executed in other blocks
;
;   Block 1 Table Read Protect:
;     EBTR1 = ON           Block 1 is protected from table reads executed in other blocks
;     EBTR1 = OFF          Block 1 is not protected from table reads executed in other blocks
;
;   Boot Block Table Read Protect:
;     EBTRB = ON           Boot block is protected from table reads executed in other blocks
;     EBTRB = OFF          Boot block is not protected from table reads executed in other blocks
;
;==========================================================================
;==========================================================================
;
;       Configuration Bits
;
;   NAME            Address
;   CONFIG1L        300000h
;   CONFIG1H        300001h
;   CONFIG2L        300002h
;   CONFIG2H        300003h
;   CONFIG3H        300005h
;   CONFIG4L        300006h
;   CONFIG5L        300008h
;   CONFIG5H        300009h
;   CONFIG6L        30000Ah
;   CONFIG6H        30000Bh
;   CONFIG7L        30000Ch
;   CONFIG7H        30000Dh
;
;==========================================================================

; The following is an assignment of address values for all of the
; configuration registers for the purpose of table reads
_CONFIG1L        EQU  H'300000'
_CONFIG1H        EQU  H'300001'
_CONFIG2L        EQU  H'300002'
_CONFIG2H        EQU  H'300003'
_CONFIG3H        EQU  H'300005'
_CONFIG4L        EQU  H'300006'
_CONFIG5L        EQU  H'300008'
_CONFIG5H        EQU  H'300009'
_CONFIG6L        EQU  H'30000A'
_CONFIG6H        EQU  H'30000B'
_CONFIG7L        EQU  H'30000C'
_CONFIG7H        EQU  H'30000D'

;----- CONFIG1L Options --------------------------------------------------
_PLLSEL_PLL4X_1L     EQU  H'FE'    ; 4x clock multiplier
_PLLSEL_PLL3X_1L     EQU  H'FF'    ; 3x clock multiplier

_CFGPLLEN_OFF_1L     EQU  H'FD'    ; PLL Disabled (firmware controlled)
_CFGPLLEN_ON_1L      EQU  H'FF'    ; PLL Enabled

_CPUDIV_NOCLKDIV_1L  EQU  H'E7'    ; CPU uses system clock (no divide)
_CPUDIV_CLKDIV2_1L   EQU  H'EF'    ; CPU uses system clock divided by 2
_CPUDIV_CLKDIV3_1L   EQU  H'F7'    ; CPU uses system clock divided by 3
_CPUDIV_CLKDIV6_1L   EQU  H'FF'    ; CPU uses system clock divided by 6

_LS48MHZ_SYS24X4_1L  EQU  H'DF'    ; System clock at 24 MHz, USB clock divider is set to 4
_LS48MHZ_SYS48X8_1L  EQU  H'FF'    ; System clock at 48 MHz, USB clock divider is set to 8

;----- CONFIG1H Options --------------------------------------------------
_FOSC_LP_1H          EQU  H'F0'    ; LP oscillator
_FOSC_XT_1H          EQU  H'F1'    ; XT oscillator
_FOSC_HSH_1H         EQU  H'F2'    ; HS oscillator, high power 16MHz to 25MHz
_FOSC_HSM_1H         EQU  H'F3'    ; HS oscillator, medium power 4MHz to 16MHz
_FOSC_ECHCLKO_1H     EQU  H'F4'    ; EC oscillator, high power 16MHz to 48MHz, clock output on OSC2
_FOSC_ECHIO_1H       EQU  H'F5'    ; EC oscillator, high power 16MHz to 48MHz
_FOSC_RCCLKO_1H      EQU  H'F6'    ; External RC oscillator, clock output on OSC2
_FOSC_RCIO_1H        EQU  H'F7'    ; External RC oscillator
_FOSC_INTOSCIO_1H    EQU  H'F8'    ; Internal oscillator
_FOSC_INTOSCCLKO_1H  EQU  H'F9'    ; Internal oscillator, clock output on OSC2
_FOSC_ECMCLKO_1H     EQU  H'FA'    ; EC oscillator, medium power 4MHz to 16MHz, clock output on OSC2
_FOSC_ECMIO_1H       EQU  H'FB'    ; EC oscillator, medium power 4MHz to 16MHz
_FOSC_ECLCLKO_1H     EQU  H'FC'    ; EC oscillator, low power <4MHz, clock output on OSC2
_FOSC_ECLIO_1H       EQU  H'FD'    ; EC oscillator, low power <4MHz

_PCLKEN_OFF_1H       EQU  H'DF'    ; Primary oscillator shutdown firmware controlled
_PCLKEN_ON_1H        EQU  H'FF'    ; Primary oscillator enabled

_FCMEN_OFF_1H        EQU  H'BF'    ; Fail-Safe Clock Monitor disabled
_FCMEN_ON_1H         EQU  H'FF'    ; Fail-Safe Clock Monitor enabled

_IESO_OFF_1H         EQU  H'7F'    ; Oscillator Switchover mode disabled
_IESO_ON_1H          EQU  H'FF'    ; Oscillator Switchover mode enabled

;----- CONFIG2L Options --------------------------------------------------
_nPWRTEN_ON_2L       EQU  H'FE'    ; Power up timer enabled
_nPWRTEN_OFF_2L      EQU  H'FF'    ; Power up timer disabled

_BOREN_OFF_2L        EQU  H'F9'    ; BOR disabled in hardware (SBOREN is ignored)
_BOREN_ON_2L         EQU  H'FB'    ; BOR controlled by firmware (SBOREN is enabled)
_BOREN_NOSLP_2L      EQU  H'FD'    ; BOR enabled in hardware, disabled in Sleep mode (SBOREN is ignored)
_BOREN_SBORDIS_2L    EQU  H'FF'    ; BOR enabled in hardware (SBOREN is ignored)

_BORV_285_2L         EQU  H'E7'    ; BOR set to 2.85V nominal
_BORV_250_2L         EQU  H'EF'    ; BOR set to 2.5V nominal
_BORV_220_2L         EQU  H'F7'    ; BOR set to 2.2V nominal
_BORV_190_2L         EQU  H'FF'    ; BOR set to 1.9V nominal

_nLPBOR_ON_2L        EQU  H'BF'    ; Low-Power Brown-out Reset enabled
_nLPBOR_OFF_2L       EQU  H'FF'    ; Low-Power Brown-out Reset disabled

;----- CONFIG2H Options --------------------------------------------------
_WDTEN_OFF_2H        EQU  H'FC'    ; WDT disabled in hardware (SWDTEN ignored)
_WDTEN_NOSLP_2H      EQU  H'FD'    ; WDT enabled in hardware, disabled in Sleep mode (SWDTEN ignored)
_WDTEN_SWON_2H       EQU  H'FE'    ; WDT controlled by firmware (SWDTEN enabled)
_WDTEN_ON_2H         EQU  H'FF'    ; WDT enabled in hardware (SWDTEN ignored)

_WDTPS_1_2H          EQU  H'C3'    ; 1:1
_WDTPS_2_2H          EQU  H'C7'    ; 1:2
_WDTPS_4_2H          EQU  H'CB'    ; 1:4
_WDTPS_8_2H          EQU  H'CF'    ; 1:8
_WDTPS_16_2H         EQU  H'D3'    ; 1:16
_WDTPS_32_2H         EQU  H'D7'    ; 1:32
_WDTPS_64_2H         EQU  H'DB'    ; 1:64
_WDTPS_128_2H        EQU  H'DF'    ; 1:128
_WDTPS_256_2H        EQU  H'E3'    ; 1:256
_WDTPS_512_2H        EQU  H'E7'    ; 1:512
_WDTPS_1024_2H       EQU  H'EB'    ; 1:1024
_WDTPS_2048_2H       EQU  H'EF'    ; 1:2048
_WDTPS_4096_2H       EQU  H'F3'    ; 1:4096
_WDTPS_8192_2H       EQU  H'F7'    ; 1:8192
_WDTPS_16384_2H      EQU  H'FB'    ; 1:16384
_WDTPS_32768_2H      EQU  H'FF'    ; 1:32768

;----- CONFIG3H Options --------------------------------------------------
_CCP2MX_RB3_3H       EQU  H'FE'    ; CCP2 input/output is multiplexed with RB3
_CCP2MX_RC1_3H       EQU  H'FF'    ; CCP2 input/output is multiplexed with RC1

_PBADEN_OFF_3H       EQU  H'FD'    ; PORTB<5:0> pins are configured as digital I/O on Reset
_PBADEN_ON_3H        EQU  H'FF'    ; PORTB<5:0> pins are configured as analog input channels on Reset

_T3CMX_RB5_3H        EQU  H'EF'    ; T3CKI function is on RB5
_T3CMX_RC0_3H        EQU  H'FF'    ; T3CKI function is on RC0

_SDOMX_RC7_3H        EQU  H'BF'    ; SDO function is on RC7
_SDOMX_RB3_3H        EQU  H'FF'    ; SDO function is on RB3

_MCLRE_OFF_3H        EQU  H'7F'    ; RE3 input pin enabled; external MCLR disabled
_MCLRE_ON_3H         EQU  H'FF'    ; MCLR pin enabled; RE3 input disabled

;----- CONFIG4L Options --------------------------------------------------
_STVREN_OFF_4L       EQU  H'FE'    ; Stack full/underflow will not cause Reset
_STVREN_ON_4L        EQU  H'FF'    ; Stack full/underflow will cause Reset

_LVP_OFF_4L          EQU  H'FB'    ; Single-Supply ICSP disabled
_LVP_ON_4L           EQU  H'FF'    ; Single-Supply ICSP enabled if MCLRE is also 1

_ICPRT_OFF_4L        EQU  H'DF'    ; ICPORT disabled

_XINST_OFF_4L        EQU  H'BF'    ; Instruction set extension and Indexed Addressing mode disabled
_XINST_ON_4L         EQU  H'FF'    ; Instruction set extension and Indexed Addressing mode enabled

_DEBUG_ON_4L         EQU  H'7F'    ; Background debugger enabled, RB6 and RB7 are dedicated to In-Circuit Debug
_DEBUG_OFF_4L        EQU  H'FF'    ; Background debugger disabled, RB6 and RB7 configured as general purpose I/O pins

;----- CONFIG5L Options --------------------------------------------------
_CP0_ON_5L           EQU  H'FE'    ; Block 0 is code-protected
_CP0_OFF_5L          EQU  H'FF'    ; Block 0 is not code-protected

_CP1_ON_5L           EQU  H'FD'    ; Block 1 is code-protected
_CP1_OFF_5L          EQU  H'FF'    ; Block 1 is not code-protected

;----- CONFIG5H Options --------------------------------------------------
_CPB_ON_5H           EQU  H'BF'    ; Boot block is code-protected
_CPB_OFF_5H          EQU  H'FF'    ; Boot block is not code-protected

_CPD_ON_5H           EQU  H'7F'    ; Data EEPROM is code-protected
_CPD_OFF_5H          EQU  H'FF'    ; Data EEPROM is not code-protected

;----- CONFIG6L Options --------------------------------------------------
_WRT0_ON_6L          EQU  H'FE'    ; Block 0 (0800-1FFFh) is write-protected
_WRT0_OFF_6L         EQU  H'FF'    ; Block 0 (0800-1FFFh) is not write-protected

_WRT1_ON_6L          EQU  H'FD'    ; Block 1 (2000-3FFFh) is write-protected
_WRT1_OFF_6L         EQU  H'FF'    ; Block 1 (2000-3FFFh) is not write-protected

;----- CONFIG6H Options --------------------------------------------------
_WRTC_ON_6H          EQU  H'DF'    ; Configuration registers (300000-3000FFh) are write-protected
_WRTC_OFF_6H         EQU  H'FF'    ; Configuration registers (300000-3000FFh) are not write-protected

_WRTB_ON_6H          EQU  H'BF'    ; Boot block (0000-7FFh) is write-protected
_WRTB_OFF_6H         EQU  H'FF'    ; Boot block (0000-7FFh) is not write-protected

_WRTD_ON_6H          EQU  H'7F'    ; Data EEPROM is write-protected
_WRTD_OFF_6H         EQU  H'FF'    ; Data EEPROM is not write-protected

;----- CONFIG7L Options --------------------------------------------------
_EBTR0_ON_7L         EQU  H'FE'    ; Block 0 is protected from table reads executed in other blocks
_EBTR0_OFF_7L        EQU  H'FF'    ; Block 0 is not protected from table reads executed in other blocks

_EBTR1_ON_7L         EQU  H'FD'    ; Block 1 is protected from table reads executed in other blocks
_EBTR1_OFF_7L        EQU  H'FF'    ; Block 1 is not protected from table reads executed in other blocks

;----- CONFIG7H Options --------------------------------------------------
_EBTRB_ON_7H         EQU  H'BF'    ; Boot block is protected from table reads executed in other blocks
_EBTRB_OFF_7H        EQU  H'FF'    ; Boot block is not protected from table reads executed in other blocks


;----- DEVID Equates --------------------------------------------------
_DEVID1          EQU  H'3FFFFE'
_DEVID2          EQU  H'3FFFFF'

;----- IDLOC Equates --------------------------------------------------
_IDLOC0          EQU  H'200000'
_IDLOC1          EQU  H'200001'
_IDLOC2          EQU  H'200002'
_IDLOC3          EQU  H'200003'
_IDLOC4          EQU  H'200004'
_IDLOC5          EQU  H'200005'
_IDLOC6          EQU  H'200006'
_IDLOC7          EQU  H'200007'

        LIST
