"""Generated client library for cloudsecuritycompliance version v1."""
# NOTE: This file is autogenerated and should not be edited by hand.

from __future__ import absolute_import

from apitools.base.py import base_api
from googlecloudsdk.generated_clients.apis.cloudsecuritycompliance.v1 import cloudsecuritycompliance_v1_messages as messages


class CloudsecuritycomplianceV1(base_api.BaseApiClient):
  """Generated client library for service cloudsecuritycompliance version v1."""

  MESSAGES_MODULE = messages
  BASE_URL = 'https://cloudsecuritycompliance.googleapis.com/'
  MTLS_BASE_URL = 'https://cloudsecuritycompliance.mtls.googleapis.com/'

  _PACKAGE = 'cloudsecuritycompliance'
  _SCOPES = ['https://www.googleapis.com/auth/cloud-platform']
  _VERSION = 'v1'
  _CLIENT_ID = 'CLIENT_ID'
  _CLIENT_SECRET = 'CLIENT_SECRET'
  _USER_AGENT = 'google-cloud-sdk'
  _CLIENT_CLASS_NAME = 'CloudsecuritycomplianceV1'
  _URL_VERSION = 'v1'
  _API_KEY = None

  def __init__(self, url='', credentials=None,
               get_credentials=True, http=None, model=None,
               log_request=False, log_response=False,
               credentials_args=None, default_global_params=None,
               additional_http_headers=None, response_encoding=None):
    """Create a new cloudsecuritycompliance handle."""
    url = url or self.BASE_URL
    super(CloudsecuritycomplianceV1, self).__init__(
        url, credentials=credentials,
        get_credentials=get_credentials, http=http, model=model,
        log_request=log_request, log_response=log_response,
        credentials_args=credentials_args,
        default_global_params=default_global_params,
        additional_http_headers=additional_http_headers,
        response_encoding=response_encoding)
    self.folders_locations_cmEnrollment = self.FoldersLocationsCmEnrollmentService(self)
    self.folders_locations_findingSummaries = self.FoldersLocationsFindingSummariesService(self)
    self.folders_locations_frameworkAuditScopeReports = self.FoldersLocationsFrameworkAuditScopeReportsService(self)
    self.folders_locations_frameworkAudits = self.FoldersLocationsFrameworkAuditsService(self)
    self.folders_locations_frameworkComplianceReports_controlComplianceSummaries = self.FoldersLocationsFrameworkComplianceReportsControlComplianceSummariesService(self)
    self.folders_locations_frameworkComplianceReports = self.FoldersLocationsFrameworkComplianceReportsService(self)
    self.folders_locations_frameworkComplianceSummaries = self.FoldersLocationsFrameworkComplianceSummariesService(self)
    self.folders_locations_operationDetails = self.FoldersLocationsOperationDetailsService(self)
    self.folders_locations = self.FoldersLocationsService(self)
    self.folders = self.FoldersService(self)
    self.organizations_locations_cloudControlDeployments = self.OrganizationsLocationsCloudControlDeploymentsService(self)
    self.organizations_locations_cloudControls = self.OrganizationsLocationsCloudControlsService(self)
    self.organizations_locations_cmEnrollment = self.OrganizationsLocationsCmEnrollmentService(self)
    self.organizations_locations_findingSummaries = self.OrganizationsLocationsFindingSummariesService(self)
    self.organizations_locations_frameworkAuditScopeReports = self.OrganizationsLocationsFrameworkAuditScopeReportsService(self)
    self.organizations_locations_frameworkAudits = self.OrganizationsLocationsFrameworkAuditsService(self)
    self.organizations_locations_frameworkComplianceReports_controlComplianceSummaries = self.OrganizationsLocationsFrameworkComplianceReportsControlComplianceSummariesService(self)
    self.organizations_locations_frameworkComplianceReports = self.OrganizationsLocationsFrameworkComplianceReportsService(self)
    self.organizations_locations_frameworkComplianceSummaries = self.OrganizationsLocationsFrameworkComplianceSummariesService(self)
    self.organizations_locations_frameworkDeployments = self.OrganizationsLocationsFrameworkDeploymentsService(self)
    self.organizations_locations_frameworks = self.OrganizationsLocationsFrameworksService(self)
    self.organizations_locations_operationDetails = self.OrganizationsLocationsOperationDetailsService(self)
    self.organizations_locations_operations = self.OrganizationsLocationsOperationsService(self)
    self.organizations_locations = self.OrganizationsLocationsService(self)
    self.organizations = self.OrganizationsService(self)
    self.projects_locations_cmEnrollment = self.ProjectsLocationsCmEnrollmentService(self)
    self.projects_locations_findingSummaries = self.ProjectsLocationsFindingSummariesService(self)
    self.projects_locations_frameworkAuditScopeReports = self.ProjectsLocationsFrameworkAuditScopeReportsService(self)
    self.projects_locations_frameworkAudits = self.ProjectsLocationsFrameworkAuditsService(self)
    self.projects_locations_frameworkComplianceReports_controlComplianceSummaries = self.ProjectsLocationsFrameworkComplianceReportsControlComplianceSummariesService(self)
    self.projects_locations_frameworkComplianceReports = self.ProjectsLocationsFrameworkComplianceReportsService(self)
    self.projects_locations_frameworkComplianceSummaries = self.ProjectsLocationsFrameworkComplianceSummariesService(self)
    self.projects_locations_operationDetails = self.ProjectsLocationsOperationDetailsService(self)
    self.projects_locations = self.ProjectsLocationsService(self)
    self.projects = self.ProjectsService(self)

  class FoldersLocationsCmEnrollmentService(base_api.BaseApiService):
    """Service class for the folders_locations_cmEnrollment resource."""

    _NAME = 'folders_locations_cmEnrollment'

    def __init__(self, client):
      super(CloudsecuritycomplianceV1.FoldersLocationsCmEnrollmentService, self).__init__(client)
      self._upload_configs = {
          }

    def Calculate(self, request, global_params=None):
      r"""Calculates the effective Compliance Manager enrollment for a resource. An effective enrollment is either a direct enrollment of a resource (if it exists), or an enrollment of the closest parent of a resource that's enrolled in Compliance Manager.

      Args:
        request: (CloudsecuritycomplianceFoldersLocationsCmEnrollmentCalculateRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (CalculateEffectiveCmEnrollmentResponse) The response message.
      """
      config = self.GetMethodConfig('Calculate')
      return self._RunMethod(
          config, request, global_params=global_params)

    Calculate.method_config = lambda: base_api.ApiMethodInfo(
        flat_path='v1/folders/{foldersId}/locations/{locationsId}/cmEnrollment:calculate',
        http_method='GET',
        method_id='cloudsecuritycompliance.folders.locations.cmEnrollment.calculate',
        ordered_params=['name'],
        path_params=['name'],
        query_params=[],
        relative_path='v1/{+name}:calculate',
        request_field='',
        request_type_name='CloudsecuritycomplianceFoldersLocationsCmEnrollmentCalculateRequest',
        response_type_name='CalculateEffectiveCmEnrollmentResponse',
        supports_download=False,
    )

  class FoldersLocationsFindingSummariesService(base_api.BaseApiService):
    """Service class for the folders_locations_findingSummaries resource."""

    _NAME = 'folders_locations_findingSummaries'

    def __init__(self, client):
      super(CloudsecuritycomplianceV1.FoldersLocationsFindingSummariesService, self).__init__(client)
      self._upload_configs = {
          }

    def List(self, request, global_params=None):
      r"""Lists the finding summary by category for a given scope.

      Args:
        request: (CloudsecuritycomplianceFoldersLocationsFindingSummariesListRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (ListFindingSummariesResponse) The response message.
      """
      config = self.GetMethodConfig('List')
      return self._RunMethod(
          config, request, global_params=global_params)

    List.method_config = lambda: base_api.ApiMethodInfo(
        flat_path='v1/folders/{foldersId}/locations/{locationsId}/findingSummaries',
        http_method='GET',
        method_id='cloudsecuritycompliance.folders.locations.findingSummaries.list',
        ordered_params=['parent'],
        path_params=['parent'],
        query_params=['endTime', 'filter', 'pageSize', 'pageToken'],
        relative_path='v1/{+parent}/findingSummaries',
        request_field='',
        request_type_name='CloudsecuritycomplianceFoldersLocationsFindingSummariesListRequest',
        response_type_name='ListFindingSummariesResponse',
        supports_download=False,
    )

  class FoldersLocationsFrameworkAuditScopeReportsService(base_api.BaseApiService):
    """Service class for the folders_locations_frameworkAuditScopeReports resource."""

    _NAME = 'folders_locations_frameworkAuditScopeReports'

    def __init__(self, client):
      super(CloudsecuritycomplianceV1.FoldersLocationsFrameworkAuditScopeReportsService, self).__init__(client)
      self._upload_configs = {
          }

    def GenerateFrameworkAuditScopeReport(self, request, global_params=None):
      r"""Generates an audit scope report for a framework.

      Args:
        request: (CloudsecuritycomplianceFoldersLocationsFrameworkAuditScopeReportsGenerateFrameworkAuditScopeReportRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (GenerateFrameworkAuditScopeReportResponse) The response message.
      """
      config = self.GetMethodConfig('GenerateFrameworkAuditScopeReport')
      return self._RunMethod(
          config, request, global_params=global_params)

    GenerateFrameworkAuditScopeReport.method_config = lambda: base_api.ApiMethodInfo(
        flat_path='v1/folders/{foldersId}/locations/{locationsId}/frameworkAuditScopeReports:generateFrameworkAuditScopeReport',
        http_method='POST',
        method_id='cloudsecuritycompliance.folders.locations.frameworkAuditScopeReports.generateFrameworkAuditScopeReport',
        ordered_params=['scope'],
        path_params=['scope'],
        query_params=[],
        relative_path='v1/{+scope}/frameworkAuditScopeReports:generateFrameworkAuditScopeReport',
        request_field='generateFrameworkAuditScopeReportRequest',
        request_type_name='CloudsecuritycomplianceFoldersLocationsFrameworkAuditScopeReportsGenerateFrameworkAuditScopeReportRequest',
        response_type_name='GenerateFrameworkAuditScopeReportResponse',
        supports_download=False,
    )

  class FoldersLocationsFrameworkAuditsService(base_api.BaseApiService):
    """Service class for the folders_locations_frameworkAudits resource."""

    _NAME = 'folders_locations_frameworkAudits'

    def __init__(self, client):
      super(CloudsecuritycomplianceV1.FoldersLocationsFrameworkAuditsService, self).__init__(client)
      self._upload_configs = {
          }

    def Create(self, request, global_params=None):
      r"""Creates a framework audit.

      Args:
        request: (CloudsecuritycomplianceFoldersLocationsFrameworkAuditsCreateRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (Operation) The response message.
      """
      config = self.GetMethodConfig('Create')
      return self._RunMethod(
          config, request, global_params=global_params)

    Create.method_config = lambda: base_api.ApiMethodInfo(
        flat_path='v1/folders/{foldersId}/locations/{locationsId}/frameworkAudits',
        http_method='POST',
        method_id='cloudsecuritycompliance.folders.locations.frameworkAudits.create',
        ordered_params=['parent'],
        path_params=['parent'],
        query_params=['frameworkAuditId'],
        relative_path='v1/{+parent}/frameworkAudits',
        request_field='frameworkAudit',
        request_type_name='CloudsecuritycomplianceFoldersLocationsFrameworkAuditsCreateRequest',
        response_type_name='Operation',
        supports_download=False,
    )

    def Get(self, request, global_params=None):
      r"""Gets the details for a framework audit.

      Args:
        request: (CloudsecuritycomplianceFoldersLocationsFrameworkAuditsGetRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (FrameworkAudit) The response message.
      """
      config = self.GetMethodConfig('Get')
      return self._RunMethod(
          config, request, global_params=global_params)

    Get.method_config = lambda: base_api.ApiMethodInfo(
        flat_path='v1/folders/{foldersId}/locations/{locationsId}/frameworkAudits/{frameworkAuditsId}',
        http_method='GET',
        method_id='cloudsecuritycompliance.folders.locations.frameworkAudits.get',
        ordered_params=['name'],
        path_params=['name'],
        query_params=[],
        relative_path='v1/{+name}',
        request_field='',
        request_type_name='CloudsecuritycomplianceFoldersLocationsFrameworkAuditsGetRequest',
        response_type_name='FrameworkAudit',
        supports_download=False,
    )

    def List(self, request, global_params=None):
      r"""Lists the framework audits for a given organization, folder, or project.

      Args:
        request: (CloudsecuritycomplianceFoldersLocationsFrameworkAuditsListRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (ListFrameworkAuditsResponse) The response message.
      """
      config = self.GetMethodConfig('List')
      return self._RunMethod(
          config, request, global_params=global_params)

    List.method_config = lambda: base_api.ApiMethodInfo(
        flat_path='v1/folders/{foldersId}/locations/{locationsId}/frameworkAudits',
        http_method='GET',
        method_id='cloudsecuritycompliance.folders.locations.frameworkAudits.list',
        ordered_params=['parent'],
        path_params=['parent'],
        query_params=['filter', 'pageSize', 'pageToken'],
        relative_path='v1/{+parent}/frameworkAudits',
        request_field='',
        request_type_name='CloudsecuritycomplianceFoldersLocationsFrameworkAuditsListRequest',
        response_type_name='ListFrameworkAuditsResponse',
        supports_download=False,
    )

  class FoldersLocationsFrameworkComplianceReportsControlComplianceSummariesService(base_api.BaseApiService):
    """Service class for the folders_locations_frameworkComplianceReports_controlComplianceSummaries resource."""

    _NAME = 'folders_locations_frameworkComplianceReports_controlComplianceSummaries'

    def __init__(self, client):
      super(CloudsecuritycomplianceV1.FoldersLocationsFrameworkComplianceReportsControlComplianceSummariesService, self).__init__(client)
      self._upload_configs = {
          }

    def List(self, request, global_params=None):
      r"""Lists the control compliance summary for a given scope.

      Args:
        request: (CloudsecuritycomplianceFoldersLocationsFrameworkComplianceReportsControlComplianceSummariesListRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (ListControlComplianceSummariesResponse) The response message.
      """
      config = self.GetMethodConfig('List')
      return self._RunMethod(
          config, request, global_params=global_params)

    List.method_config = lambda: base_api.ApiMethodInfo(
        flat_path='v1/folders/{foldersId}/locations/{locationsId}/frameworkComplianceReports/{frameworkComplianceReportsId}/controlComplianceSummaries',
        http_method='GET',
        method_id='cloudsecuritycompliance.folders.locations.frameworkComplianceReports.controlComplianceSummaries.list',
        ordered_params=['parent'],
        path_params=['parent'],
        query_params=['endTime', 'filter', 'pageSize', 'pageToken'],
        relative_path='v1/{+parent}/controlComplianceSummaries',
        request_field='',
        request_type_name='CloudsecuritycomplianceFoldersLocationsFrameworkComplianceReportsControlComplianceSummariesListRequest',
        response_type_name='ListControlComplianceSummariesResponse',
        supports_download=False,
    )

  class FoldersLocationsFrameworkComplianceReportsService(base_api.BaseApiService):
    """Service class for the folders_locations_frameworkComplianceReports resource."""

    _NAME = 'folders_locations_frameworkComplianceReports'

    def __init__(self, client):
      super(CloudsecuritycomplianceV1.FoldersLocationsFrameworkComplianceReportsService, self).__init__(client)
      self._upload_configs = {
          }

    def Aggregate(self, request, global_params=None):
      r"""Gets the aggregated compliance report over time for a given scope.

      Args:
        request: (CloudsecuritycomplianceFoldersLocationsFrameworkComplianceReportsAggregateRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (AggregateFrameworkComplianceReportResponse) The response message.
      """
      config = self.GetMethodConfig('Aggregate')
      return self._RunMethod(
          config, request, global_params=global_params)

    Aggregate.method_config = lambda: base_api.ApiMethodInfo(
        flat_path='v1/folders/{foldersId}/locations/{locationsId}/frameworkComplianceReports/{frameworkComplianceReportsId}:aggregate',
        http_method='GET',
        method_id='cloudsecuritycompliance.folders.locations.frameworkComplianceReports.aggregate',
        ordered_params=['name'],
        path_params=['name'],
        query_params=['filter', 'interval_endTime', 'interval_startTime'],
        relative_path='v1/{+name}:aggregate',
        request_field='',
        request_type_name='CloudsecuritycomplianceFoldersLocationsFrameworkComplianceReportsAggregateRequest',
        response_type_name='AggregateFrameworkComplianceReportResponse',
        supports_download=False,
    )

    def Fetch(self, request, global_params=None):
      r"""Fetches the framework compliance report for a given scope.

      Args:
        request: (CloudsecuritycomplianceFoldersLocationsFrameworkComplianceReportsFetchRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (FrameworkComplianceReport) The response message.
      """
      config = self.GetMethodConfig('Fetch')
      return self._RunMethod(
          config, request, global_params=global_params)

    Fetch.method_config = lambda: base_api.ApiMethodInfo(
        flat_path='v1/folders/{foldersId}/locations/{locationsId}/frameworkComplianceReports/{frameworkComplianceReportsId}:fetch',
        http_method='GET',
        method_id='cloudsecuritycompliance.folders.locations.frameworkComplianceReports.fetch',
        ordered_params=['name'],
        path_params=['name'],
        query_params=['endTime', 'filter'],
        relative_path='v1/{+name}:fetch',
        request_field='',
        request_type_name='CloudsecuritycomplianceFoldersLocationsFrameworkComplianceReportsFetchRequest',
        response_type_name='FrameworkComplianceReport',
        supports_download=False,
    )

  class FoldersLocationsFrameworkComplianceSummariesService(base_api.BaseApiService):
    """Service class for the folders_locations_frameworkComplianceSummaries resource."""

    _NAME = 'folders_locations_frameworkComplianceSummaries'

    def __init__(self, client):
      super(CloudsecuritycomplianceV1.FoldersLocationsFrameworkComplianceSummariesService, self).__init__(client)
      self._upload_configs = {
          }

    def List(self, request, global_params=None):
      r"""Lists the framework compliance summary for a given scope.

      Args:
        request: (CloudsecuritycomplianceFoldersLocationsFrameworkComplianceSummariesListRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (ListFrameworkComplianceSummariesResponse) The response message.
      """
      config = self.GetMethodConfig('List')
      return self._RunMethod(
          config, request, global_params=global_params)

    List.method_config = lambda: base_api.ApiMethodInfo(
        flat_path='v1/folders/{foldersId}/locations/{locationsId}/frameworkComplianceSummaries',
        http_method='GET',
        method_id='cloudsecuritycompliance.folders.locations.frameworkComplianceSummaries.list',
        ordered_params=['parent'],
        path_params=['parent'],
        query_params=['filter', 'pageSize', 'pageToken', 'view'],
        relative_path='v1/{+parent}/frameworkComplianceSummaries',
        request_field='',
        request_type_name='CloudsecuritycomplianceFoldersLocationsFrameworkComplianceSummariesListRequest',
        response_type_name='ListFrameworkComplianceSummariesResponse',
        supports_download=False,
    )

  class FoldersLocationsOperationDetailsService(base_api.BaseApiService):
    """Service class for the folders_locations_operationDetails resource."""

    _NAME = 'folders_locations_operationDetails'

    def __init__(self, client):
      super(CloudsecuritycomplianceV1.FoldersLocationsOperationDetailsService, self).__init__(client)
      self._upload_configs = {
          }

    def Get(self, request, global_params=None):
      r"""Gets details for the generate audit report operation.

      Args:
        request: (CloudsecuritycomplianceFoldersLocationsOperationDetailsGetRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (Operation) The response message.
      """
      config = self.GetMethodConfig('Get')
      return self._RunMethod(
          config, request, global_params=global_params)

    Get.method_config = lambda: base_api.ApiMethodInfo(
        flat_path='v1/folders/{foldersId}/locations/{locationsId}/operationDetails/{operationDetailsId}',
        http_method='GET',
        method_id='cloudsecuritycompliance.folders.locations.operationDetails.get',
        ordered_params=['name'],
        path_params=['name'],
        query_params=[],
        relative_path='v1/{+name}',
        request_field='',
        request_type_name='CloudsecuritycomplianceFoldersLocationsOperationDetailsGetRequest',
        response_type_name='Operation',
        supports_download=False,
    )

  class FoldersLocationsService(base_api.BaseApiService):
    """Service class for the folders_locations resource."""

    _NAME = 'folders_locations'

    def __init__(self, client):
      super(CloudsecuritycomplianceV1.FoldersLocationsService, self).__init__(client)
      self._upload_configs = {
          }

    def UpdateCmEnrollment(self, request, global_params=None):
      r"""Updates the Compliance Manager enrollment for a resource to facilitate an audit. Use this method to enroll a resource in Compliance Manager or to create or update feature-specific configurations.

      Args:
        request: (CloudsecuritycomplianceFoldersLocationsUpdateCmEnrollmentRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (CmEnrollment) The response message.
      """
      config = self.GetMethodConfig('UpdateCmEnrollment')
      return self._RunMethod(
          config, request, global_params=global_params)

    UpdateCmEnrollment.method_config = lambda: base_api.ApiMethodInfo(
        flat_path='v1/folders/{foldersId}/locations/{locationsId}/cmEnrollment',
        http_method='PATCH',
        method_id='cloudsecuritycompliance.folders.locations.updateCmEnrollment',
        ordered_params=['name'],
        path_params=['name'],
        query_params=['updateMask'],
        relative_path='v1/{+name}',
        request_field='cmEnrollment',
        request_type_name='CloudsecuritycomplianceFoldersLocationsUpdateCmEnrollmentRequest',
        response_type_name='CmEnrollment',
        supports_download=False,
    )

  class FoldersService(base_api.BaseApiService):
    """Service class for the folders resource."""

    _NAME = 'folders'

    def __init__(self, client):
      super(CloudsecuritycomplianceV1.FoldersService, self).__init__(client)
      self._upload_configs = {
          }

  class OrganizationsLocationsCloudControlDeploymentsService(base_api.BaseApiService):
    """Service class for the organizations_locations_cloudControlDeployments resource."""

    _NAME = 'organizations_locations_cloudControlDeployments'

    def __init__(self, client):
      super(CloudsecuritycomplianceV1.OrganizationsLocationsCloudControlDeploymentsService, self).__init__(client)
      self._upload_configs = {
          }

    def Get(self, request, global_params=None):
      r"""Gets details about a cloud control deployment.

      Args:
        request: (CloudsecuritycomplianceOrganizationsLocationsCloudControlDeploymentsGetRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (CloudControlDeployment) The response message.
      """
      config = self.GetMethodConfig('Get')
      return self._RunMethod(
          config, request, global_params=global_params)

    Get.method_config = lambda: base_api.ApiMethodInfo(
        flat_path='v1/organizations/{organizationsId}/locations/{locationsId}/cloudControlDeployments/{cloudControlDeploymentsId}',
        http_method='GET',
        method_id='cloudsecuritycompliance.organizations.locations.cloudControlDeployments.get',
        ordered_params=['name'],
        path_params=['name'],
        query_params=[],
        relative_path='v1/{+name}',
        request_field='',
        request_type_name='CloudsecuritycomplianceOrganizationsLocationsCloudControlDeploymentsGetRequest',
        response_type_name='CloudControlDeployment',
        supports_download=False,
    )

    def List(self, request, global_params=None):
      r"""Lists the cloud conrol deployments in a given parent resource.

      Args:
        request: (CloudsecuritycomplianceOrganizationsLocationsCloudControlDeploymentsListRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (ListCloudControlDeploymentsResponse) The response message.
      """
      config = self.GetMethodConfig('List')
      return self._RunMethod(
          config, request, global_params=global_params)

    List.method_config = lambda: base_api.ApiMethodInfo(
        flat_path='v1/organizations/{organizationsId}/locations/{locationsId}/cloudControlDeployments',
        http_method='GET',
        method_id='cloudsecuritycompliance.organizations.locations.cloudControlDeployments.list',
        ordered_params=['parent'],
        path_params=['parent'],
        query_params=['filter', 'orderBy', 'pageSize', 'pageToken'],
        relative_path='v1/{+parent}/cloudControlDeployments',
        request_field='',
        request_type_name='CloudsecuritycomplianceOrganizationsLocationsCloudControlDeploymentsListRequest',
        response_type_name='ListCloudControlDeploymentsResponse',
        supports_download=False,
    )

  class OrganizationsLocationsCloudControlsService(base_api.BaseApiService):
    """Service class for the organizations_locations_cloudControls resource."""

    _NAME = 'organizations_locations_cloudControls'

    def __init__(self, client):
      super(CloudsecuritycomplianceV1.OrganizationsLocationsCloudControlsService, self).__init__(client)
      self._upload_configs = {
          }

    def Create(self, request, global_params=None):
      r"""Creates a custom cloud control in a given parent resource. You can't create built-in cloud controls because those are managed by Google.

      Args:
        request: (CloudsecuritycomplianceOrganizationsLocationsCloudControlsCreateRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (CloudControl) The response message.
      """
      config = self.GetMethodConfig('Create')
      return self._RunMethod(
          config, request, global_params=global_params)

    Create.method_config = lambda: base_api.ApiMethodInfo(
        flat_path='v1/organizations/{organizationsId}/locations/{locationsId}/cloudControls',
        http_method='POST',
        method_id='cloudsecuritycompliance.organizations.locations.cloudControls.create',
        ordered_params=['parent'],
        path_params=['parent'],
        query_params=['cloudControlId'],
        relative_path='v1/{+parent}/cloudControls',
        request_field='cloudControl',
        request_type_name='CloudsecuritycomplianceOrganizationsLocationsCloudControlsCreateRequest',
        response_type_name='CloudControl',
        supports_download=False,
    )

    def Delete(self, request, global_params=None):
      r"""Deletes a custom cloud control, including all its major and minor revisions. Consider the following: - You can't delete built-in cloud controls. You can only delete cloud controls with type `CUSTOM`. - You can't delete cloud controls if any of the versions are referenced by a framework. - You can't restore a deleted cloud control. This action is permanent.

      Args:
        request: (CloudsecuritycomplianceOrganizationsLocationsCloudControlsDeleteRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (Empty) The response message.
      """
      config = self.GetMethodConfig('Delete')
      return self._RunMethod(
          config, request, global_params=global_params)

    Delete.method_config = lambda: base_api.ApiMethodInfo(
        flat_path='v1/organizations/{organizationsId}/locations/{locationsId}/cloudControls/{cloudControlsId}',
        http_method='DELETE',
        method_id='cloudsecuritycompliance.organizations.locations.cloudControls.delete',
        ordered_params=['name'],
        path_params=['name'],
        query_params=[],
        relative_path='v1/{+name}',
        request_field='',
        request_type_name='CloudsecuritycomplianceOrganizationsLocationsCloudControlsDeleteRequest',
        response_type_name='Empty',
        supports_download=False,
    )

    def Get(self, request, global_params=None):
      r"""Gets details about a cloud control. This method retrieves the latest major version of a cloud control that you identify by name. By default, the latest major version of the cloud control is returned. To retrieve a specific major version, include `major_revision_id` in the request.

      Args:
        request: (CloudsecuritycomplianceOrganizationsLocationsCloudControlsGetRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (CloudControl) The response message.
      """
      config = self.GetMethodConfig('Get')
      return self._RunMethod(
          config, request, global_params=global_params)

    Get.method_config = lambda: base_api.ApiMethodInfo(
        flat_path='v1/organizations/{organizationsId}/locations/{locationsId}/cloudControls/{cloudControlsId}',
        http_method='GET',
        method_id='cloudsecuritycompliance.organizations.locations.cloudControls.get',
        ordered_params=['name'],
        path_params=['name'],
        query_params=['majorRevisionId'],
        relative_path='v1/{+name}',
        request_field='',
        request_type_name='CloudsecuritycomplianceOrganizationsLocationsCloudControlsGetRequest',
        response_type_name='CloudControl',
        supports_download=False,
    )

    def List(self, request, global_params=None):
      r"""Lists the cloud controls (both built-in and custom) that are available in a given parent resource. The latest major version of each cloud control is returned. This method supports pagination.

      Args:
        request: (CloudsecuritycomplianceOrganizationsLocationsCloudControlsListRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (ListCloudControlsResponse) The response message.
      """
      config = self.GetMethodConfig('List')
      return self._RunMethod(
          config, request, global_params=global_params)

    List.method_config = lambda: base_api.ApiMethodInfo(
        flat_path='v1/organizations/{organizationsId}/locations/{locationsId}/cloudControls',
        http_method='GET',
        method_id='cloudsecuritycompliance.organizations.locations.cloudControls.list',
        ordered_params=['parent'],
        path_params=['parent'],
        query_params=['pageSize', 'pageToken'],
        relative_path='v1/{+parent}/cloudControls',
        request_field='',
        request_type_name='CloudsecuritycomplianceOrganizationsLocationsCloudControlsListRequest',
        response_type_name='ListCloudControlsResponse',
        supports_download=False,
    )

    def Patch(self, request, global_params=None):
      r"""Updates a custom cloud control. This method allows for partial updates of a cloud control. Use the `update_mask` to specify which fields to update. Consider the following: - If you provide an `update_mask`, only the fields that are specified in the mask are updated. - If you don't provide an `update_mask`, all the fields that are present in the request's `cloud_control` body are used to overwrite the existing resource. You can only update cloud controls with the `CUSTOM` type. A successful update creates a new version of the cloud control.

      Args:
        request: (CloudsecuritycomplianceOrganizationsLocationsCloudControlsPatchRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (CloudControl) The response message.
      """
      config = self.GetMethodConfig('Patch')
      return self._RunMethod(
          config, request, global_params=global_params)

    Patch.method_config = lambda: base_api.ApiMethodInfo(
        flat_path='v1/organizations/{organizationsId}/locations/{locationsId}/cloudControls/{cloudControlsId}',
        http_method='PATCH',
        method_id='cloudsecuritycompliance.organizations.locations.cloudControls.patch',
        ordered_params=['name'],
        path_params=['name'],
        query_params=['updateMask'],
        relative_path='v1/{+name}',
        request_field='cloudControl',
        request_type_name='CloudsecuritycomplianceOrganizationsLocationsCloudControlsPatchRequest',
        response_type_name='CloudControl',
        supports_download=False,
    )

  class OrganizationsLocationsCmEnrollmentService(base_api.BaseApiService):
    """Service class for the organizations_locations_cmEnrollment resource."""

    _NAME = 'organizations_locations_cmEnrollment'

    def __init__(self, client):
      super(CloudsecuritycomplianceV1.OrganizationsLocationsCmEnrollmentService, self).__init__(client)
      self._upload_configs = {
          }

    def Calculate(self, request, global_params=None):
      r"""Calculates the effective Compliance Manager enrollment for a resource. An effective enrollment is either a direct enrollment of a resource (if it exists), or an enrollment of the closest parent of a resource that's enrolled in Compliance Manager.

      Args:
        request: (CloudsecuritycomplianceOrganizationsLocationsCmEnrollmentCalculateRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (CalculateEffectiveCmEnrollmentResponse) The response message.
      """
      config = self.GetMethodConfig('Calculate')
      return self._RunMethod(
          config, request, global_params=global_params)

    Calculate.method_config = lambda: base_api.ApiMethodInfo(
        flat_path='v1/organizations/{organizationsId}/locations/{locationsId}/cmEnrollment:calculate',
        http_method='GET',
        method_id='cloudsecuritycompliance.organizations.locations.cmEnrollment.calculate',
        ordered_params=['name'],
        path_params=['name'],
        query_params=[],
        relative_path='v1/{+name}:calculate',
        request_field='',
        request_type_name='CloudsecuritycomplianceOrganizationsLocationsCmEnrollmentCalculateRequest',
        response_type_name='CalculateEffectiveCmEnrollmentResponse',
        supports_download=False,
    )

  class OrganizationsLocationsFindingSummariesService(base_api.BaseApiService):
    """Service class for the organizations_locations_findingSummaries resource."""

    _NAME = 'organizations_locations_findingSummaries'

    def __init__(self, client):
      super(CloudsecuritycomplianceV1.OrganizationsLocationsFindingSummariesService, self).__init__(client)
      self._upload_configs = {
          }

    def List(self, request, global_params=None):
      r"""Lists the finding summary by category for a given scope.

      Args:
        request: (CloudsecuritycomplianceOrganizationsLocationsFindingSummariesListRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (ListFindingSummariesResponse) The response message.
      """
      config = self.GetMethodConfig('List')
      return self._RunMethod(
          config, request, global_params=global_params)

    List.method_config = lambda: base_api.ApiMethodInfo(
        flat_path='v1/organizations/{organizationsId}/locations/{locationsId}/findingSummaries',
        http_method='GET',
        method_id='cloudsecuritycompliance.organizations.locations.findingSummaries.list',
        ordered_params=['parent'],
        path_params=['parent'],
        query_params=['endTime', 'filter', 'pageSize', 'pageToken'],
        relative_path='v1/{+parent}/findingSummaries',
        request_field='',
        request_type_name='CloudsecuritycomplianceOrganizationsLocationsFindingSummariesListRequest',
        response_type_name='ListFindingSummariesResponse',
        supports_download=False,
    )

  class OrganizationsLocationsFrameworkAuditScopeReportsService(base_api.BaseApiService):
    """Service class for the organizations_locations_frameworkAuditScopeReports resource."""

    _NAME = 'organizations_locations_frameworkAuditScopeReports'

    def __init__(self, client):
      super(CloudsecuritycomplianceV1.OrganizationsLocationsFrameworkAuditScopeReportsService, self).__init__(client)
      self._upload_configs = {
          }

    def GenerateFrameworkAuditScopeReport(self, request, global_params=None):
      r"""Generates an audit scope report for a framework.

      Args:
        request: (CloudsecuritycomplianceOrganizationsLocationsFrameworkAuditScopeReportsGenerateFrameworkAuditScopeReportRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (GenerateFrameworkAuditScopeReportResponse) The response message.
      """
      config = self.GetMethodConfig('GenerateFrameworkAuditScopeReport')
      return self._RunMethod(
          config, request, global_params=global_params)

    GenerateFrameworkAuditScopeReport.method_config = lambda: base_api.ApiMethodInfo(
        flat_path='v1/organizations/{organizationsId}/locations/{locationsId}/frameworkAuditScopeReports:generateFrameworkAuditScopeReport',
        http_method='POST',
        method_id='cloudsecuritycompliance.organizations.locations.frameworkAuditScopeReports.generateFrameworkAuditScopeReport',
        ordered_params=['scope'],
        path_params=['scope'],
        query_params=[],
        relative_path='v1/{+scope}/frameworkAuditScopeReports:generateFrameworkAuditScopeReport',
        request_field='generateFrameworkAuditScopeReportRequest',
        request_type_name='CloudsecuritycomplianceOrganizationsLocationsFrameworkAuditScopeReportsGenerateFrameworkAuditScopeReportRequest',
        response_type_name='GenerateFrameworkAuditScopeReportResponse',
        supports_download=False,
    )

  class OrganizationsLocationsFrameworkAuditsService(base_api.BaseApiService):
    """Service class for the organizations_locations_frameworkAudits resource."""

    _NAME = 'organizations_locations_frameworkAudits'

    def __init__(self, client):
      super(CloudsecuritycomplianceV1.OrganizationsLocationsFrameworkAuditsService, self).__init__(client)
      self._upload_configs = {
          }

    def Create(self, request, global_params=None):
      r"""Creates a framework audit.

      Args:
        request: (CloudsecuritycomplianceOrganizationsLocationsFrameworkAuditsCreateRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (Operation) The response message.
      """
      config = self.GetMethodConfig('Create')
      return self._RunMethod(
          config, request, global_params=global_params)

    Create.method_config = lambda: base_api.ApiMethodInfo(
        flat_path='v1/organizations/{organizationsId}/locations/{locationsId}/frameworkAudits',
        http_method='POST',
        method_id='cloudsecuritycompliance.organizations.locations.frameworkAudits.create',
        ordered_params=['parent'],
        path_params=['parent'],
        query_params=['frameworkAuditId'],
        relative_path='v1/{+parent}/frameworkAudits',
        request_field='frameworkAudit',
        request_type_name='CloudsecuritycomplianceOrganizationsLocationsFrameworkAuditsCreateRequest',
        response_type_name='Operation',
        supports_download=False,
    )

    def Get(self, request, global_params=None):
      r"""Gets the details for a framework audit.

      Args:
        request: (CloudsecuritycomplianceOrganizationsLocationsFrameworkAuditsGetRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (FrameworkAudit) The response message.
      """
      config = self.GetMethodConfig('Get')
      return self._RunMethod(
          config, request, global_params=global_params)

    Get.method_config = lambda: base_api.ApiMethodInfo(
        flat_path='v1/organizations/{organizationsId}/locations/{locationsId}/frameworkAudits/{frameworkAuditsId}',
        http_method='GET',
        method_id='cloudsecuritycompliance.organizations.locations.frameworkAudits.get',
        ordered_params=['name'],
        path_params=['name'],
        query_params=[],
        relative_path='v1/{+name}',
        request_field='',
        request_type_name='CloudsecuritycomplianceOrganizationsLocationsFrameworkAuditsGetRequest',
        response_type_name='FrameworkAudit',
        supports_download=False,
    )

    def List(self, request, global_params=None):
      r"""Lists the framework audits for a given organization, folder, or project.

      Args:
        request: (CloudsecuritycomplianceOrganizationsLocationsFrameworkAuditsListRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (ListFrameworkAuditsResponse) The response message.
      """
      config = self.GetMethodConfig('List')
      return self._RunMethod(
          config, request, global_params=global_params)

    List.method_config = lambda: base_api.ApiMethodInfo(
        flat_path='v1/organizations/{organizationsId}/locations/{locationsId}/frameworkAudits',
        http_method='GET',
        method_id='cloudsecuritycompliance.organizations.locations.frameworkAudits.list',
        ordered_params=['parent'],
        path_params=['parent'],
        query_params=['filter', 'pageSize', 'pageToken'],
        relative_path='v1/{+parent}/frameworkAudits',
        request_field='',
        request_type_name='CloudsecuritycomplianceOrganizationsLocationsFrameworkAuditsListRequest',
        response_type_name='ListFrameworkAuditsResponse',
        supports_download=False,
    )

  class OrganizationsLocationsFrameworkComplianceReportsControlComplianceSummariesService(base_api.BaseApiService):
    """Service class for the organizations_locations_frameworkComplianceReports_controlComplianceSummaries resource."""

    _NAME = 'organizations_locations_frameworkComplianceReports_controlComplianceSummaries'

    def __init__(self, client):
      super(CloudsecuritycomplianceV1.OrganizationsLocationsFrameworkComplianceReportsControlComplianceSummariesService, self).__init__(client)
      self._upload_configs = {
          }

    def List(self, request, global_params=None):
      r"""Lists the control compliance summary for a given scope.

      Args:
        request: (CloudsecuritycomplianceOrganizationsLocationsFrameworkComplianceReportsControlComplianceSummariesListRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (ListControlComplianceSummariesResponse) The response message.
      """
      config = self.GetMethodConfig('List')
      return self._RunMethod(
          config, request, global_params=global_params)

    List.method_config = lambda: base_api.ApiMethodInfo(
        flat_path='v1/organizations/{organizationsId}/locations/{locationsId}/frameworkComplianceReports/{frameworkComplianceReportsId}/controlComplianceSummaries',
        http_method='GET',
        method_id='cloudsecuritycompliance.organizations.locations.frameworkComplianceReports.controlComplianceSummaries.list',
        ordered_params=['parent'],
        path_params=['parent'],
        query_params=['endTime', 'filter', 'pageSize', 'pageToken'],
        relative_path='v1/{+parent}/controlComplianceSummaries',
        request_field='',
        request_type_name='CloudsecuritycomplianceOrganizationsLocationsFrameworkComplianceReportsControlComplianceSummariesListRequest',
        response_type_name='ListControlComplianceSummariesResponse',
        supports_download=False,
    )

  class OrganizationsLocationsFrameworkComplianceReportsService(base_api.BaseApiService):
    """Service class for the organizations_locations_frameworkComplianceReports resource."""

    _NAME = 'organizations_locations_frameworkComplianceReports'

    def __init__(self, client):
      super(CloudsecuritycomplianceV1.OrganizationsLocationsFrameworkComplianceReportsService, self).__init__(client)
      self._upload_configs = {
          }

    def Aggregate(self, request, global_params=None):
      r"""Gets the aggregated compliance report over time for a given scope.

      Args:
        request: (CloudsecuritycomplianceOrganizationsLocationsFrameworkComplianceReportsAggregateRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (AggregateFrameworkComplianceReportResponse) The response message.
      """
      config = self.GetMethodConfig('Aggregate')
      return self._RunMethod(
          config, request, global_params=global_params)

    Aggregate.method_config = lambda: base_api.ApiMethodInfo(
        flat_path='v1/organizations/{organizationsId}/locations/{locationsId}/frameworkComplianceReports/{frameworkComplianceReportsId}:aggregate',
        http_method='GET',
        method_id='cloudsecuritycompliance.organizations.locations.frameworkComplianceReports.aggregate',
        ordered_params=['name'],
        path_params=['name'],
        query_params=['filter', 'interval_endTime', 'interval_startTime'],
        relative_path='v1/{+name}:aggregate',
        request_field='',
        request_type_name='CloudsecuritycomplianceOrganizationsLocationsFrameworkComplianceReportsAggregateRequest',
        response_type_name='AggregateFrameworkComplianceReportResponse',
        supports_download=False,
    )

    def Fetch(self, request, global_params=None):
      r"""Fetches the framework compliance report for a given scope.

      Args:
        request: (CloudsecuritycomplianceOrganizationsLocationsFrameworkComplianceReportsFetchRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (FrameworkComplianceReport) The response message.
      """
      config = self.GetMethodConfig('Fetch')
      return self._RunMethod(
          config, request, global_params=global_params)

    Fetch.method_config = lambda: base_api.ApiMethodInfo(
        flat_path='v1/organizations/{organizationsId}/locations/{locationsId}/frameworkComplianceReports/{frameworkComplianceReportsId}:fetch',
        http_method='GET',
        method_id='cloudsecuritycompliance.organizations.locations.frameworkComplianceReports.fetch',
        ordered_params=['name'],
        path_params=['name'],
        query_params=['endTime', 'filter'],
        relative_path='v1/{+name}:fetch',
        request_field='',
        request_type_name='CloudsecuritycomplianceOrganizationsLocationsFrameworkComplianceReportsFetchRequest',
        response_type_name='FrameworkComplianceReport',
        supports_download=False,
    )

  class OrganizationsLocationsFrameworkComplianceSummariesService(base_api.BaseApiService):
    """Service class for the organizations_locations_frameworkComplianceSummaries resource."""

    _NAME = 'organizations_locations_frameworkComplianceSummaries'

    def __init__(self, client):
      super(CloudsecuritycomplianceV1.OrganizationsLocationsFrameworkComplianceSummariesService, self).__init__(client)
      self._upload_configs = {
          }

    def List(self, request, global_params=None):
      r"""Lists the framework compliance summary for a given scope.

      Args:
        request: (CloudsecuritycomplianceOrganizationsLocationsFrameworkComplianceSummariesListRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (ListFrameworkComplianceSummariesResponse) The response message.
      """
      config = self.GetMethodConfig('List')
      return self._RunMethod(
          config, request, global_params=global_params)

    List.method_config = lambda: base_api.ApiMethodInfo(
        flat_path='v1/organizations/{organizationsId}/locations/{locationsId}/frameworkComplianceSummaries',
        http_method='GET',
        method_id='cloudsecuritycompliance.organizations.locations.frameworkComplianceSummaries.list',
        ordered_params=['parent'],
        path_params=['parent'],
        query_params=['filter', 'pageSize', 'pageToken', 'view'],
        relative_path='v1/{+parent}/frameworkComplianceSummaries',
        request_field='',
        request_type_name='CloudsecuritycomplianceOrganizationsLocationsFrameworkComplianceSummariesListRequest',
        response_type_name='ListFrameworkComplianceSummariesResponse',
        supports_download=False,
    )

  class OrganizationsLocationsFrameworkDeploymentsService(base_api.BaseApiService):
    """Service class for the organizations_locations_frameworkDeployments resource."""

    _NAME = 'organizations_locations_frameworkDeployments'

    def __init__(self, client):
      super(CloudsecuritycomplianceV1.OrganizationsLocationsFrameworkDeploymentsService, self).__init__(client)
      self._upload_configs = {
          }

    def Create(self, request, global_params=None):
      r"""Creates a framework deployment in a given parent resource. A framework deployment lets you assign a particular framework version to an organization, folder, or project so that you can control and monitor those resources using the framework's cloud controls.

      Args:
        request: (CloudsecuritycomplianceOrganizationsLocationsFrameworkDeploymentsCreateRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (Operation) The response message.
      """
      config = self.GetMethodConfig('Create')
      return self._RunMethod(
          config, request, global_params=global_params)

    Create.method_config = lambda: base_api.ApiMethodInfo(
        flat_path='v1/organizations/{organizationsId}/locations/{locationsId}/frameworkDeployments',
        http_method='POST',
        method_id='cloudsecuritycompliance.organizations.locations.frameworkDeployments.create',
        ordered_params=['parent'],
        path_params=['parent'],
        query_params=['frameworkDeploymentId'],
        relative_path='v1/{+parent}/frameworkDeployments',
        request_field='frameworkDeployment',
        request_type_name='CloudsecuritycomplianceOrganizationsLocationsFrameworkDeploymentsCreateRequest',
        response_type_name='Operation',
        supports_download=False,
    )

    def Delete(self, request, global_params=None):
      r"""Deletes a framework deployment.

      Args:
        request: (CloudsecuritycomplianceOrganizationsLocationsFrameworkDeploymentsDeleteRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (Operation) The response message.
      """
      config = self.GetMethodConfig('Delete')
      return self._RunMethod(
          config, request, global_params=global_params)

    Delete.method_config = lambda: base_api.ApiMethodInfo(
        flat_path='v1/organizations/{organizationsId}/locations/{locationsId}/frameworkDeployments/{frameworkDeploymentsId}',
        http_method='DELETE',
        method_id='cloudsecuritycompliance.organizations.locations.frameworkDeployments.delete',
        ordered_params=['name'],
        path_params=['name'],
        query_params=['etag'],
        relative_path='v1/{+name}',
        request_field='',
        request_type_name='CloudsecuritycomplianceOrganizationsLocationsFrameworkDeploymentsDeleteRequest',
        response_type_name='Operation',
        supports_download=False,
    )

    def Get(self, request, global_params=None):
      r"""Gets details about a framework deployment.

      Args:
        request: (CloudsecuritycomplianceOrganizationsLocationsFrameworkDeploymentsGetRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (FrameworkDeployment) The response message.
      """
      config = self.GetMethodConfig('Get')
      return self._RunMethod(
          config, request, global_params=global_params)

    Get.method_config = lambda: base_api.ApiMethodInfo(
        flat_path='v1/organizations/{organizationsId}/locations/{locationsId}/frameworkDeployments/{frameworkDeploymentsId}',
        http_method='GET',
        method_id='cloudsecuritycompliance.organizations.locations.frameworkDeployments.get',
        ordered_params=['name'],
        path_params=['name'],
        query_params=[],
        relative_path='v1/{+name}',
        request_field='',
        request_type_name='CloudsecuritycomplianceOrganizationsLocationsFrameworkDeploymentsGetRequest',
        response_type_name='FrameworkDeployment',
        supports_download=False,
    )

    def List(self, request, global_params=None):
      r"""Lists the framework deployments in a given parent resource.

      Args:
        request: (CloudsecuritycomplianceOrganizationsLocationsFrameworkDeploymentsListRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (ListFrameworkDeploymentsResponse) The response message.
      """
      config = self.GetMethodConfig('List')
      return self._RunMethod(
          config, request, global_params=global_params)

    List.method_config = lambda: base_api.ApiMethodInfo(
        flat_path='v1/organizations/{organizationsId}/locations/{locationsId}/frameworkDeployments',
        http_method='GET',
        method_id='cloudsecuritycompliance.organizations.locations.frameworkDeployments.list',
        ordered_params=['parent'],
        path_params=['parent'],
        query_params=['filter', 'orderBy', 'pageSize', 'pageToken'],
        relative_path='v1/{+parent}/frameworkDeployments',
        request_field='',
        request_type_name='CloudsecuritycomplianceOrganizationsLocationsFrameworkDeploymentsListRequest',
        response_type_name='ListFrameworkDeploymentsResponse',
        supports_download=False,
    )

  class OrganizationsLocationsFrameworksService(base_api.BaseApiService):
    """Service class for the organizations_locations_frameworks resource."""

    _NAME = 'organizations_locations_frameworks'

    def __init__(self, client):
      super(CloudsecuritycomplianceV1.OrganizationsLocationsFrameworksService, self).__init__(client)
      self._upload_configs = {
          }

    def Create(self, request, global_params=None):
      r"""Creates a custom framework in a given parent resource. You can't create built-in frameworks because those are managed by Google.

      Args:
        request: (CloudsecuritycomplianceOrganizationsLocationsFrameworksCreateRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (Framework) The response message.
      """
      config = self.GetMethodConfig('Create')
      return self._RunMethod(
          config, request, global_params=global_params)

    Create.method_config = lambda: base_api.ApiMethodInfo(
        flat_path='v1/organizations/{organizationsId}/locations/{locationsId}/frameworks',
        http_method='POST',
        method_id='cloudsecuritycompliance.organizations.locations.frameworks.create',
        ordered_params=['parent'],
        path_params=['parent'],
        query_params=['frameworkId'],
        relative_path='v1/{+parent}/frameworks',
        request_field='framework',
        request_type_name='CloudsecuritycomplianceOrganizationsLocationsFrameworksCreateRequest',
        response_type_name='Framework',
        supports_download=False,
    )

    def Delete(self, request, global_params=None):
      r"""Deletes a custom framework, including all its major and minor revisions. Consider the following: - You can't delete built-in frameworks. You can only delete frameworks with type `CUSTOM`. - You can't delete frameworks that are deployed to a resource. - You can't restore a deleted framework. This action is permanent.

      Args:
        request: (CloudsecuritycomplianceOrganizationsLocationsFrameworksDeleteRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (Empty) The response message.
      """
      config = self.GetMethodConfig('Delete')
      return self._RunMethod(
          config, request, global_params=global_params)

    Delete.method_config = lambda: base_api.ApiMethodInfo(
        flat_path='v1/organizations/{organizationsId}/locations/{locationsId}/frameworks/{frameworksId}',
        http_method='DELETE',
        method_id='cloudsecuritycompliance.organizations.locations.frameworks.delete',
        ordered_params=['name'],
        path_params=['name'],
        query_params=[],
        relative_path='v1/{+name}',
        request_field='',
        request_type_name='CloudsecuritycomplianceOrganizationsLocationsFrameworksDeleteRequest',
        response_type_name='Empty',
        supports_download=False,
    )

    def Get(self, request, global_params=None):
      r"""Gets details about a framework. This method retrieves the latest major version of the framework. To retrieve a specific major version, include `major_revision_id` in the request.

      Args:
        request: (CloudsecuritycomplianceOrganizationsLocationsFrameworksGetRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (Framework) The response message.
      """
      config = self.GetMethodConfig('Get')
      return self._RunMethod(
          config, request, global_params=global_params)

    Get.method_config = lambda: base_api.ApiMethodInfo(
        flat_path='v1/organizations/{organizationsId}/locations/{locationsId}/frameworks/{frameworksId}',
        http_method='GET',
        method_id='cloudsecuritycompliance.organizations.locations.frameworks.get',
        ordered_params=['name'],
        path_params=['name'],
        query_params=['majorRevisionId'],
        relative_path='v1/{+name}',
        request_field='',
        request_type_name='CloudsecuritycomplianceOrganizationsLocationsFrameworksGetRequest',
        response_type_name='Framework',
        supports_download=False,
    )

    def List(self, request, global_params=None):
      r"""Lists the frameworks (both built-in and custom) that are available within the parent resource. The latest major version of each framework is returned. This method supports pagination.

      Args:
        request: (CloudsecuritycomplianceOrganizationsLocationsFrameworksListRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (ListFrameworksResponse) The response message.
      """
      config = self.GetMethodConfig('List')
      return self._RunMethod(
          config, request, global_params=global_params)

    List.method_config = lambda: base_api.ApiMethodInfo(
        flat_path='v1/organizations/{organizationsId}/locations/{locationsId}/frameworks',
        http_method='GET',
        method_id='cloudsecuritycompliance.organizations.locations.frameworks.list',
        ordered_params=['parent'],
        path_params=['parent'],
        query_params=['pageSize', 'pageToken'],
        relative_path='v1/{+parent}/frameworks',
        request_field='',
        request_type_name='CloudsecuritycomplianceOrganizationsLocationsFrameworksListRequest',
        response_type_name='ListFrameworksResponse',
        supports_download=False,
    )

    def Patch(self, request, global_params=None):
      r"""Updates a custom framework. This method allows for partial updates of a framework. Use the `update_mask` to specify which fields to update. Consider the following: - If you provide an `update_mask`, only the fields that are specified in the mask are updated. - If you don't provide an `update_mask`, all the fields that are present in the request's `framework` body are used to overwrite the existing resource. You can only update frameworks with the `CUSTOM` type. A successful update creates a new version of the framework.

      Args:
        request: (CloudsecuritycomplianceOrganizationsLocationsFrameworksPatchRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (Framework) The response message.
      """
      config = self.GetMethodConfig('Patch')
      return self._RunMethod(
          config, request, global_params=global_params)

    Patch.method_config = lambda: base_api.ApiMethodInfo(
        flat_path='v1/organizations/{organizationsId}/locations/{locationsId}/frameworks/{frameworksId}',
        http_method='PATCH',
        method_id='cloudsecuritycompliance.organizations.locations.frameworks.patch',
        ordered_params=['name'],
        path_params=['name'],
        query_params=['majorRevisionId', 'updateMask'],
        relative_path='v1/{+name}',
        request_field='framework',
        request_type_name='CloudsecuritycomplianceOrganizationsLocationsFrameworksPatchRequest',
        response_type_name='Framework',
        supports_download=False,
    )

  class OrganizationsLocationsOperationDetailsService(base_api.BaseApiService):
    """Service class for the organizations_locations_operationDetails resource."""

    _NAME = 'organizations_locations_operationDetails'

    def __init__(self, client):
      super(CloudsecuritycomplianceV1.OrganizationsLocationsOperationDetailsService, self).__init__(client)
      self._upload_configs = {
          }

    def Get(self, request, global_params=None):
      r"""Gets details for the generate audit report operation.

      Args:
        request: (CloudsecuritycomplianceOrganizationsLocationsOperationDetailsGetRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (Operation) The response message.
      """
      config = self.GetMethodConfig('Get')
      return self._RunMethod(
          config, request, global_params=global_params)

    Get.method_config = lambda: base_api.ApiMethodInfo(
        flat_path='v1/organizations/{organizationsId}/locations/{locationsId}/operationDetails/{operationDetailsId}',
        http_method='GET',
        method_id='cloudsecuritycompliance.organizations.locations.operationDetails.get',
        ordered_params=['name'],
        path_params=['name'],
        query_params=[],
        relative_path='v1/{+name}',
        request_field='',
        request_type_name='CloudsecuritycomplianceOrganizationsLocationsOperationDetailsGetRequest',
        response_type_name='Operation',
        supports_download=False,
    )

  class OrganizationsLocationsOperationsService(base_api.BaseApiService):
    """Service class for the organizations_locations_operations resource."""

    _NAME = 'organizations_locations_operations'

    def __init__(self, client):
      super(CloudsecuritycomplianceV1.OrganizationsLocationsOperationsService, self).__init__(client)
      self._upload_configs = {
          }

    def Cancel(self, request, global_params=None):
      r"""Starts asynchronous cancellation on a long-running operation. The server makes a best effort to cancel the operation, but success is not guaranteed. If the server doesn't support this method, it returns `google.rpc.Code.UNIMPLEMENTED`. Clients can use Operations.GetOperation or other methods to check whether the cancellation succeeded or whether the operation completed despite cancellation. On successful cancellation, the operation is not deleted; instead, it becomes an operation with an Operation.error value with a google.rpc.Status.code of `1`, corresponding to `Code.CANCELLED`.

      Args:
        request: (CloudsecuritycomplianceOrganizationsLocationsOperationsCancelRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (Empty) The response message.
      """
      config = self.GetMethodConfig('Cancel')
      return self._RunMethod(
          config, request, global_params=global_params)

    Cancel.method_config = lambda: base_api.ApiMethodInfo(
        flat_path='v1/organizations/{organizationsId}/locations/{locationsId}/operations/{operationsId}:cancel',
        http_method='POST',
        method_id='cloudsecuritycompliance.organizations.locations.operations.cancel',
        ordered_params=['name'],
        path_params=['name'],
        query_params=[],
        relative_path='v1/{+name}:cancel',
        request_field='cancelOperationRequest',
        request_type_name='CloudsecuritycomplianceOrganizationsLocationsOperationsCancelRequest',
        response_type_name='Empty',
        supports_download=False,
    )

    def Delete(self, request, global_params=None):
      r"""Deletes a long-running operation. This method indicates that the client is no longer interested in the operation result. It does not cancel the operation. If the server doesn't support this method, it returns `google.rpc.Code.UNIMPLEMENTED`.

      Args:
        request: (CloudsecuritycomplianceOrganizationsLocationsOperationsDeleteRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (Empty) The response message.
      """
      config = self.GetMethodConfig('Delete')
      return self._RunMethod(
          config, request, global_params=global_params)

    Delete.method_config = lambda: base_api.ApiMethodInfo(
        flat_path='v1/organizations/{organizationsId}/locations/{locationsId}/operations/{operationsId}',
        http_method='DELETE',
        method_id='cloudsecuritycompliance.organizations.locations.operations.delete',
        ordered_params=['name'],
        path_params=['name'],
        query_params=[],
        relative_path='v1/{+name}',
        request_field='',
        request_type_name='CloudsecuritycomplianceOrganizationsLocationsOperationsDeleteRequest',
        response_type_name='Empty',
        supports_download=False,
    )

    def Get(self, request, global_params=None):
      r"""Gets the latest state of a long-running operation. Clients can use this method to poll the operation result at intervals as recommended by the API service.

      Args:
        request: (CloudsecuritycomplianceOrganizationsLocationsOperationsGetRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (Operation) The response message.
      """
      config = self.GetMethodConfig('Get')
      return self._RunMethod(
          config, request, global_params=global_params)

    Get.method_config = lambda: base_api.ApiMethodInfo(
        flat_path='v1/organizations/{organizationsId}/locations/{locationsId}/operations/{operationsId}',
        http_method='GET',
        method_id='cloudsecuritycompliance.organizations.locations.operations.get',
        ordered_params=['name'],
        path_params=['name'],
        query_params=[],
        relative_path='v1/{+name}',
        request_field='',
        request_type_name='CloudsecuritycomplianceOrganizationsLocationsOperationsGetRequest',
        response_type_name='Operation',
        supports_download=False,
    )

    def List(self, request, global_params=None):
      r"""Lists operations that match the specified filter in the request. If the server doesn't support this method, it returns `UNIMPLEMENTED`.

      Args:
        request: (CloudsecuritycomplianceOrganizationsLocationsOperationsListRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (ListOperationsResponse) The response message.
      """
      config = self.GetMethodConfig('List')
      return self._RunMethod(
          config, request, global_params=global_params)

    List.method_config = lambda: base_api.ApiMethodInfo(
        flat_path='v1/organizations/{organizationsId}/locations/{locationsId}/operations',
        http_method='GET',
        method_id='cloudsecuritycompliance.organizations.locations.operations.list',
        ordered_params=['name'],
        path_params=['name'],
        query_params=['filter', 'pageSize', 'pageToken', 'returnPartialSuccess'],
        relative_path='v1/{+name}/operations',
        request_field='',
        request_type_name='CloudsecuritycomplianceOrganizationsLocationsOperationsListRequest',
        response_type_name='ListOperationsResponse',
        supports_download=False,
    )

  class OrganizationsLocationsService(base_api.BaseApiService):
    """Service class for the organizations_locations resource."""

    _NAME = 'organizations_locations'

    def __init__(self, client):
      super(CloudsecuritycomplianceV1.OrganizationsLocationsService, self).__init__(client)
      self._upload_configs = {
          }

    def Get(self, request, global_params=None):
      r"""Gets information about a location.

      Args:
        request: (CloudsecuritycomplianceOrganizationsLocationsGetRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (Location) The response message.
      """
      config = self.GetMethodConfig('Get')
      return self._RunMethod(
          config, request, global_params=global_params)

    Get.method_config = lambda: base_api.ApiMethodInfo(
        flat_path='v1/organizations/{organizationsId}/locations/{locationsId}',
        http_method='GET',
        method_id='cloudsecuritycompliance.organizations.locations.get',
        ordered_params=['name'],
        path_params=['name'],
        query_params=[],
        relative_path='v1/{+name}',
        request_field='',
        request_type_name='CloudsecuritycomplianceOrganizationsLocationsGetRequest',
        response_type_name='Location',
        supports_download=False,
    )

    def List(self, request, global_params=None):
      r"""Lists information about the supported locations for this service.

      Args:
        request: (CloudsecuritycomplianceOrganizationsLocationsListRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (ListLocationsResponse) The response message.
      """
      config = self.GetMethodConfig('List')
      return self._RunMethod(
          config, request, global_params=global_params)

    List.method_config = lambda: base_api.ApiMethodInfo(
        flat_path='v1/organizations/{organizationsId}/locations',
        http_method='GET',
        method_id='cloudsecuritycompliance.organizations.locations.list',
        ordered_params=['name'],
        path_params=['name'],
        query_params=['extraLocationTypes', 'filter', 'pageSize', 'pageToken'],
        relative_path='v1/{+name}/locations',
        request_field='',
        request_type_name='CloudsecuritycomplianceOrganizationsLocationsListRequest',
        response_type_name='ListLocationsResponse',
        supports_download=False,
    )

    def UpdateCmEnrollment(self, request, global_params=None):
      r"""Updates the Compliance Manager enrollment for a resource to facilitate an audit. Use this method to enroll a resource in Compliance Manager or to create or update feature-specific configurations.

      Args:
        request: (CloudsecuritycomplianceOrganizationsLocationsUpdateCmEnrollmentRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (CmEnrollment) The response message.
      """
      config = self.GetMethodConfig('UpdateCmEnrollment')
      return self._RunMethod(
          config, request, global_params=global_params)

    UpdateCmEnrollment.method_config = lambda: base_api.ApiMethodInfo(
        flat_path='v1/organizations/{organizationsId}/locations/{locationsId}/cmEnrollment',
        http_method='PATCH',
        method_id='cloudsecuritycompliance.organizations.locations.updateCmEnrollment',
        ordered_params=['name'],
        path_params=['name'],
        query_params=['updateMask'],
        relative_path='v1/{+name}',
        request_field='cmEnrollment',
        request_type_name='CloudsecuritycomplianceOrganizationsLocationsUpdateCmEnrollmentRequest',
        response_type_name='CmEnrollment',
        supports_download=False,
    )

  class OrganizationsService(base_api.BaseApiService):
    """Service class for the organizations resource."""

    _NAME = 'organizations'

    def __init__(self, client):
      super(CloudsecuritycomplianceV1.OrganizationsService, self).__init__(client)
      self._upload_configs = {
          }

  class ProjectsLocationsCmEnrollmentService(base_api.BaseApiService):
    """Service class for the projects_locations_cmEnrollment resource."""

    _NAME = 'projects_locations_cmEnrollment'

    def __init__(self, client):
      super(CloudsecuritycomplianceV1.ProjectsLocationsCmEnrollmentService, self).__init__(client)
      self._upload_configs = {
          }

    def Calculate(self, request, global_params=None):
      r"""Calculates the effective Compliance Manager enrollment for a resource. An effective enrollment is either a direct enrollment of a resource (if it exists), or an enrollment of the closest parent of a resource that's enrolled in Compliance Manager.

      Args:
        request: (CloudsecuritycomplianceProjectsLocationsCmEnrollmentCalculateRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (CalculateEffectiveCmEnrollmentResponse) The response message.
      """
      config = self.GetMethodConfig('Calculate')
      return self._RunMethod(
          config, request, global_params=global_params)

    Calculate.method_config = lambda: base_api.ApiMethodInfo(
        flat_path='v1/projects/{projectsId}/locations/{locationsId}/cmEnrollment:calculate',
        http_method='GET',
        method_id='cloudsecuritycompliance.projects.locations.cmEnrollment.calculate',
        ordered_params=['name'],
        path_params=['name'],
        query_params=[],
        relative_path='v1/{+name}:calculate',
        request_field='',
        request_type_name='CloudsecuritycomplianceProjectsLocationsCmEnrollmentCalculateRequest',
        response_type_name='CalculateEffectiveCmEnrollmentResponse',
        supports_download=False,
    )

  class ProjectsLocationsFindingSummariesService(base_api.BaseApiService):
    """Service class for the projects_locations_findingSummaries resource."""

    _NAME = 'projects_locations_findingSummaries'

    def __init__(self, client):
      super(CloudsecuritycomplianceV1.ProjectsLocationsFindingSummariesService, self).__init__(client)
      self._upload_configs = {
          }

    def List(self, request, global_params=None):
      r"""Lists the finding summary by category for a given scope.

      Args:
        request: (CloudsecuritycomplianceProjectsLocationsFindingSummariesListRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (ListFindingSummariesResponse) The response message.
      """
      config = self.GetMethodConfig('List')
      return self._RunMethod(
          config, request, global_params=global_params)

    List.method_config = lambda: base_api.ApiMethodInfo(
        flat_path='v1/projects/{projectsId}/locations/{locationsId}/findingSummaries',
        http_method='GET',
        method_id='cloudsecuritycompliance.projects.locations.findingSummaries.list',
        ordered_params=['parent'],
        path_params=['parent'],
        query_params=['endTime', 'filter', 'pageSize', 'pageToken'],
        relative_path='v1/{+parent}/findingSummaries',
        request_field='',
        request_type_name='CloudsecuritycomplianceProjectsLocationsFindingSummariesListRequest',
        response_type_name='ListFindingSummariesResponse',
        supports_download=False,
    )

  class ProjectsLocationsFrameworkAuditScopeReportsService(base_api.BaseApiService):
    """Service class for the projects_locations_frameworkAuditScopeReports resource."""

    _NAME = 'projects_locations_frameworkAuditScopeReports'

    def __init__(self, client):
      super(CloudsecuritycomplianceV1.ProjectsLocationsFrameworkAuditScopeReportsService, self).__init__(client)
      self._upload_configs = {
          }

    def GenerateFrameworkAuditScopeReport(self, request, global_params=None):
      r"""Generates an audit scope report for a framework.

      Args:
        request: (CloudsecuritycomplianceProjectsLocationsFrameworkAuditScopeReportsGenerateFrameworkAuditScopeReportRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (GenerateFrameworkAuditScopeReportResponse) The response message.
      """
      config = self.GetMethodConfig('GenerateFrameworkAuditScopeReport')
      return self._RunMethod(
          config, request, global_params=global_params)

    GenerateFrameworkAuditScopeReport.method_config = lambda: base_api.ApiMethodInfo(
        flat_path='v1/projects/{projectsId}/locations/{locationsId}/frameworkAuditScopeReports:generateFrameworkAuditScopeReport',
        http_method='POST',
        method_id='cloudsecuritycompliance.projects.locations.frameworkAuditScopeReports.generateFrameworkAuditScopeReport',
        ordered_params=['scope'],
        path_params=['scope'],
        query_params=[],
        relative_path='v1/{+scope}/frameworkAuditScopeReports:generateFrameworkAuditScopeReport',
        request_field='generateFrameworkAuditScopeReportRequest',
        request_type_name='CloudsecuritycomplianceProjectsLocationsFrameworkAuditScopeReportsGenerateFrameworkAuditScopeReportRequest',
        response_type_name='GenerateFrameworkAuditScopeReportResponse',
        supports_download=False,
    )

  class ProjectsLocationsFrameworkAuditsService(base_api.BaseApiService):
    """Service class for the projects_locations_frameworkAudits resource."""

    _NAME = 'projects_locations_frameworkAudits'

    def __init__(self, client):
      super(CloudsecuritycomplianceV1.ProjectsLocationsFrameworkAuditsService, self).__init__(client)
      self._upload_configs = {
          }

    def Create(self, request, global_params=None):
      r"""Creates a framework audit.

      Args:
        request: (CloudsecuritycomplianceProjectsLocationsFrameworkAuditsCreateRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (Operation) The response message.
      """
      config = self.GetMethodConfig('Create')
      return self._RunMethod(
          config, request, global_params=global_params)

    Create.method_config = lambda: base_api.ApiMethodInfo(
        flat_path='v1/projects/{projectsId}/locations/{locationsId}/frameworkAudits',
        http_method='POST',
        method_id='cloudsecuritycompliance.projects.locations.frameworkAudits.create',
        ordered_params=['parent'],
        path_params=['parent'],
        query_params=['frameworkAuditId'],
        relative_path='v1/{+parent}/frameworkAudits',
        request_field='frameworkAudit',
        request_type_name='CloudsecuritycomplianceProjectsLocationsFrameworkAuditsCreateRequest',
        response_type_name='Operation',
        supports_download=False,
    )

    def Get(self, request, global_params=None):
      r"""Gets the details for a framework audit.

      Args:
        request: (CloudsecuritycomplianceProjectsLocationsFrameworkAuditsGetRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (FrameworkAudit) The response message.
      """
      config = self.GetMethodConfig('Get')
      return self._RunMethod(
          config, request, global_params=global_params)

    Get.method_config = lambda: base_api.ApiMethodInfo(
        flat_path='v1/projects/{projectsId}/locations/{locationsId}/frameworkAudits/{frameworkAuditsId}',
        http_method='GET',
        method_id='cloudsecuritycompliance.projects.locations.frameworkAudits.get',
        ordered_params=['name'],
        path_params=['name'],
        query_params=[],
        relative_path='v1/{+name}',
        request_field='',
        request_type_name='CloudsecuritycomplianceProjectsLocationsFrameworkAuditsGetRequest',
        response_type_name='FrameworkAudit',
        supports_download=False,
    )

    def List(self, request, global_params=None):
      r"""Lists the framework audits for a given organization, folder, or project.

      Args:
        request: (CloudsecuritycomplianceProjectsLocationsFrameworkAuditsListRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (ListFrameworkAuditsResponse) The response message.
      """
      config = self.GetMethodConfig('List')
      return self._RunMethod(
          config, request, global_params=global_params)

    List.method_config = lambda: base_api.ApiMethodInfo(
        flat_path='v1/projects/{projectsId}/locations/{locationsId}/frameworkAudits',
        http_method='GET',
        method_id='cloudsecuritycompliance.projects.locations.frameworkAudits.list',
        ordered_params=['parent'],
        path_params=['parent'],
        query_params=['filter', 'pageSize', 'pageToken'],
        relative_path='v1/{+parent}/frameworkAudits',
        request_field='',
        request_type_name='CloudsecuritycomplianceProjectsLocationsFrameworkAuditsListRequest',
        response_type_name='ListFrameworkAuditsResponse',
        supports_download=False,
    )

  class ProjectsLocationsFrameworkComplianceReportsControlComplianceSummariesService(base_api.BaseApiService):
    """Service class for the projects_locations_frameworkComplianceReports_controlComplianceSummaries resource."""

    _NAME = 'projects_locations_frameworkComplianceReports_controlComplianceSummaries'

    def __init__(self, client):
      super(CloudsecuritycomplianceV1.ProjectsLocationsFrameworkComplianceReportsControlComplianceSummariesService, self).__init__(client)
      self._upload_configs = {
          }

    def List(self, request, global_params=None):
      r"""Lists the control compliance summary for a given scope.

      Args:
        request: (CloudsecuritycomplianceProjectsLocationsFrameworkComplianceReportsControlComplianceSummariesListRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (ListControlComplianceSummariesResponse) The response message.
      """
      config = self.GetMethodConfig('List')
      return self._RunMethod(
          config, request, global_params=global_params)

    List.method_config = lambda: base_api.ApiMethodInfo(
        flat_path='v1/projects/{projectsId}/locations/{locationsId}/frameworkComplianceReports/{frameworkComplianceReportsId}/controlComplianceSummaries',
        http_method='GET',
        method_id='cloudsecuritycompliance.projects.locations.frameworkComplianceReports.controlComplianceSummaries.list',
        ordered_params=['parent'],
        path_params=['parent'],
        query_params=['endTime', 'filter', 'pageSize', 'pageToken'],
        relative_path='v1/{+parent}/controlComplianceSummaries',
        request_field='',
        request_type_name='CloudsecuritycomplianceProjectsLocationsFrameworkComplianceReportsControlComplianceSummariesListRequest',
        response_type_name='ListControlComplianceSummariesResponse',
        supports_download=False,
    )

  class ProjectsLocationsFrameworkComplianceReportsService(base_api.BaseApiService):
    """Service class for the projects_locations_frameworkComplianceReports resource."""

    _NAME = 'projects_locations_frameworkComplianceReports'

    def __init__(self, client):
      super(CloudsecuritycomplianceV1.ProjectsLocationsFrameworkComplianceReportsService, self).__init__(client)
      self._upload_configs = {
          }

    def Aggregate(self, request, global_params=None):
      r"""Gets the aggregated compliance report over time for a given scope.

      Args:
        request: (CloudsecuritycomplianceProjectsLocationsFrameworkComplianceReportsAggregateRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (AggregateFrameworkComplianceReportResponse) The response message.
      """
      config = self.GetMethodConfig('Aggregate')
      return self._RunMethod(
          config, request, global_params=global_params)

    Aggregate.method_config = lambda: base_api.ApiMethodInfo(
        flat_path='v1/projects/{projectsId}/locations/{locationsId}/frameworkComplianceReports/{frameworkComplianceReportsId}:aggregate',
        http_method='GET',
        method_id='cloudsecuritycompliance.projects.locations.frameworkComplianceReports.aggregate',
        ordered_params=['name'],
        path_params=['name'],
        query_params=['filter', 'interval_endTime', 'interval_startTime'],
        relative_path='v1/{+name}:aggregate',
        request_field='',
        request_type_name='CloudsecuritycomplianceProjectsLocationsFrameworkComplianceReportsAggregateRequest',
        response_type_name='AggregateFrameworkComplianceReportResponse',
        supports_download=False,
    )

    def Fetch(self, request, global_params=None):
      r"""Fetches the framework compliance report for a given scope.

      Args:
        request: (CloudsecuritycomplianceProjectsLocationsFrameworkComplianceReportsFetchRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (FrameworkComplianceReport) The response message.
      """
      config = self.GetMethodConfig('Fetch')
      return self._RunMethod(
          config, request, global_params=global_params)

    Fetch.method_config = lambda: base_api.ApiMethodInfo(
        flat_path='v1/projects/{projectsId}/locations/{locationsId}/frameworkComplianceReports/{frameworkComplianceReportsId}:fetch',
        http_method='GET',
        method_id='cloudsecuritycompliance.projects.locations.frameworkComplianceReports.fetch',
        ordered_params=['name'],
        path_params=['name'],
        query_params=['endTime', 'filter'],
        relative_path='v1/{+name}:fetch',
        request_field='',
        request_type_name='CloudsecuritycomplianceProjectsLocationsFrameworkComplianceReportsFetchRequest',
        response_type_name='FrameworkComplianceReport',
        supports_download=False,
    )

  class ProjectsLocationsFrameworkComplianceSummariesService(base_api.BaseApiService):
    """Service class for the projects_locations_frameworkComplianceSummaries resource."""

    _NAME = 'projects_locations_frameworkComplianceSummaries'

    def __init__(self, client):
      super(CloudsecuritycomplianceV1.ProjectsLocationsFrameworkComplianceSummariesService, self).__init__(client)
      self._upload_configs = {
          }

    def List(self, request, global_params=None):
      r"""Lists the framework compliance summary for a given scope.

      Args:
        request: (CloudsecuritycomplianceProjectsLocationsFrameworkComplianceSummariesListRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (ListFrameworkComplianceSummariesResponse) The response message.
      """
      config = self.GetMethodConfig('List')
      return self._RunMethod(
          config, request, global_params=global_params)

    List.method_config = lambda: base_api.ApiMethodInfo(
        flat_path='v1/projects/{projectsId}/locations/{locationsId}/frameworkComplianceSummaries',
        http_method='GET',
        method_id='cloudsecuritycompliance.projects.locations.frameworkComplianceSummaries.list',
        ordered_params=['parent'],
        path_params=['parent'],
        query_params=['filter', 'pageSize', 'pageToken', 'view'],
        relative_path='v1/{+parent}/frameworkComplianceSummaries',
        request_field='',
        request_type_name='CloudsecuritycomplianceProjectsLocationsFrameworkComplianceSummariesListRequest',
        response_type_name='ListFrameworkComplianceSummariesResponse',
        supports_download=False,
    )

  class ProjectsLocationsOperationDetailsService(base_api.BaseApiService):
    """Service class for the projects_locations_operationDetails resource."""

    _NAME = 'projects_locations_operationDetails'

    def __init__(self, client):
      super(CloudsecuritycomplianceV1.ProjectsLocationsOperationDetailsService, self).__init__(client)
      self._upload_configs = {
          }

    def Get(self, request, global_params=None):
      r"""Gets details for the generate audit report operation.

      Args:
        request: (CloudsecuritycomplianceProjectsLocationsOperationDetailsGetRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (Operation) The response message.
      """
      config = self.GetMethodConfig('Get')
      return self._RunMethod(
          config, request, global_params=global_params)

    Get.method_config = lambda: base_api.ApiMethodInfo(
        flat_path='v1/projects/{projectsId}/locations/{locationsId}/operationDetails/{operationDetailsId}',
        http_method='GET',
        method_id='cloudsecuritycompliance.projects.locations.operationDetails.get',
        ordered_params=['name'],
        path_params=['name'],
        query_params=[],
        relative_path='v1/{+name}',
        request_field='',
        request_type_name='CloudsecuritycomplianceProjectsLocationsOperationDetailsGetRequest',
        response_type_name='Operation',
        supports_download=False,
    )

  class ProjectsLocationsService(base_api.BaseApiService):
    """Service class for the projects_locations resource."""

    _NAME = 'projects_locations'

    def __init__(self, client):
      super(CloudsecuritycomplianceV1.ProjectsLocationsService, self).__init__(client)
      self._upload_configs = {
          }

    def UpdateCmEnrollment(self, request, global_params=None):
      r"""Updates the Compliance Manager enrollment for a resource to facilitate an audit. Use this method to enroll a resource in Compliance Manager or to create or update feature-specific configurations.

      Args:
        request: (CloudsecuritycomplianceProjectsLocationsUpdateCmEnrollmentRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (CmEnrollment) The response message.
      """
      config = self.GetMethodConfig('UpdateCmEnrollment')
      return self._RunMethod(
          config, request, global_params=global_params)

    UpdateCmEnrollment.method_config = lambda: base_api.ApiMethodInfo(
        flat_path='v1/projects/{projectsId}/locations/{locationsId}/cmEnrollment',
        http_method='PATCH',
        method_id='cloudsecuritycompliance.projects.locations.updateCmEnrollment',
        ordered_params=['name'],
        path_params=['name'],
        query_params=['updateMask'],
        relative_path='v1/{+name}',
        request_field='cmEnrollment',
        request_type_name='CloudsecuritycomplianceProjectsLocationsUpdateCmEnrollmentRequest',
        response_type_name='CmEnrollment',
        supports_download=False,
    )

  class ProjectsService(base_api.BaseApiService):
    """Service class for the projects resource."""

    _NAME = 'projects'

    def __init__(self, client):
      super(CloudsecuritycomplianceV1.ProjectsService, self).__init__(client)
      self._upload_configs = {
          }
