# -*- coding: utf-8 -*- #
# Copyright 2021 Google LLC. All Rights Reserved.
#
# Licensed under the Apache License, Version 2.0 (the "License");
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
#    http://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.
"""The command group for the schemas CLI."""

from __future__ import absolute_import
from __future__ import division
from __future__ import unicode_literals

from googlecloudsdk.calliope import base
from googlecloudsdk.command_lib.pubsub import flags


@base.ReleaseTracks(base.ReleaseTrack.GA)
class Schemas(base.Group):
  """Manage Pub/Sub schemas.

  The {command} group lets you create and manage Pub/Sub schemas. These
  schemas can be attached to topics to enable validation of published messages.
  Commands to validate schemas and messages against schemas are also available.
  """


@base.ReleaseTracks(base.ReleaseTrack.ALPHA, base.ReleaseTrack.BETA)
class SchemasBeta(Schemas):
  """Manage Pub/Sub schemas.

  The {command} group lets you create and manage Pub/Sub schemas. These
  schemas can be attached to topics to enable validation of published messages.
  Commands to validate schemas and messages against schemas are also available.
  """

  def Filter(self, context, args):
    flags.ValidateIsDefaultUniverse('schemas')
