"""Generated message classes for securityposture version v1alpha.

"""
# NOTE: This file is autogenerated and should not be edited by hand.

from __future__ import absolute_import

from apitools.base.protorpclite import messages as _messages
from apitools.base.py import encoding
from apitools.base.py import extra_types


package = 'securityposture'


class AssetDetails(_messages.Message):
  r"""A AssetDetails object.

  Fields:
    asset: JSON string representing CAI asset. Format/representation may
      change, thus clients should not depend.
    assetType: Type of asset. See CAI asset type for GCP assets:
      https://cloud.google.com/asset-inventory/docs/supported-asset-types.
  """

  asset = _messages.StringField(1)
  assetType = _messages.StringField(2)


class CancelOperationRequest(_messages.Message):
  r"""The request message for Operations.CancelOperation."""


class ComplianceStandard(_messages.Message):
  r"""Mapping for a Policy to standard and control.

  Fields:
    control: Optional. Control mapping provided by user for this Policy. e.g.:
      1.5.
    standard: Optional. The compliance standard that the Policy maps to, e.g.:
      CIS-2.0.
  """

  control = _messages.StringField(1)
  standard = _messages.StringField(2)


class Constraint(_messages.Message):
  r"""Representation of a Constraint.

  Fields:
    orgPolicyConstraint: Optional. Org Policy builtin constraint.
    orgPolicyConstraintCustom: Optional. Org Policy custom constraint.
    securityHealthAnalyticsCustomModule: Optional. SHA custom detector.
    securityHealthAnalyticsModule: Optional. SHA built-in detector.
  """

  orgPolicyConstraint = _messages.MessageField('OrgPolicyConstraint', 1)
  orgPolicyConstraintCustom = _messages.MessageField('OrgPolicyConstraintCustom', 2)
  securityHealthAnalyticsCustomModule = _messages.MessageField('SecurityHealthAnalyticsCustomModule', 3)
  securityHealthAnalyticsModule = _messages.MessageField('SecurityHealthAnalyticsModule', 4)


class CreateIaCValidationReportRequest(_messages.Message):
  r"""Request message for creating an IaC validation report.

  Fields:
    iac: Required. The infrastrucutre as code which is to be validated for
      generating report.
  """

  iac = _messages.MessageField('IaC', 1)


class CustomConfig(_messages.Message):
  r"""Defines the properties in a custom module configuration for Security
  Health Analytics. Use the custom module configuration to create custom
  detectors that generate custom findings for resources that you specify.

  Enums:
    SeverityValueValuesEnum: Required. The severity to assign to findings
      generated by the module.

  Fields:
    customOutput: Optional. Custom output properties.
    description: Optional. Text that describes the vulnerability or
      misconfiguration that the custom module detects. This explanation is
      returned with each finding instance to help investigators understand the
      detected issue. The text must be enclosed in quotation marks.
    predicate: Required. The CEL expression to evaluate to produce findings.
      When the expression evaluates to true against a resource, a finding is
      generated.
    recommendation: Optional. An explanation of the recommended steps that
      security teams can take to resolve the detected issue. This explanation
      is returned with each finding generated by this module in the
      `nextSteps` property of the finding JSON.
    resourceSelector: Required. The resource types that the custom module
      operates on. Each custom module can specify up to 5 resource types.
    severity: Required. The severity to assign to findings generated by the
      module.
  """

  class SeverityValueValuesEnum(_messages.Enum):
    r"""Required. The severity to assign to findings generated by the module.

    Values:
      SEVERITY_UNSPECIFIED: Unspecified severity.
      CRITICAL: Critical severity.
      HIGH: High severity.
      MEDIUM: Medium severity.
      LOW: Low severity.
    """
    SEVERITY_UNSPECIFIED = 0
    CRITICAL = 1
    HIGH = 2
    MEDIUM = 3
    LOW = 4

  customOutput = _messages.MessageField('CustomOutputSpec', 1)
  description = _messages.StringField(2)
  predicate = _messages.MessageField('Expr', 3)
  recommendation = _messages.StringField(4)
  resourceSelector = _messages.MessageField('ResourceSelector', 5)
  severity = _messages.EnumField('SeverityValueValuesEnum', 6)


class CustomOutputSpec(_messages.Message):
  r"""A set of optional name-value pairs that define custom source properties
  to return with each finding that is generated by the custom module. The
  custom source properties that are defined here are included in the finding
  JSON under `sourceProperties`.

  Fields:
    properties: Optional. A list of custom output properties to add to the
      finding.
  """

  properties = _messages.MessageField('Property', 1, repeated=True)


class Empty(_messages.Message):
  r"""A generic empty message that you can re-use to avoid defining duplicated
  empty messages in your APIs. A typical example is to use it as the request
  or the response type of an API method. For instance: service Foo { rpc
  Bar(google.protobuf.Empty) returns (google.protobuf.Empty); }
  """



class Expr(_messages.Message):
  r"""Represents a textual expression in the Common Expression Language (CEL)
  syntax. CEL is a C-like expression language. The syntax and semantics of CEL
  are documented at https://github.com/google/cel-spec. Example (Comparison):
  title: "Summary size limit" description: "Determines if a summary is less
  than 100 chars" expression: "document.summary.size() < 100" Example
  (Equality): title: "Requestor is owner" description: "Determines if
  requestor is the document owner" expression: "document.owner ==
  request.auth.claims.email" Example (Logic): title: "Public documents"
  description: "Determine whether the document should be publicly visible"
  expression: "document.type != 'private' && document.type != 'internal'"
  Example (Data Manipulation): title: "Notification string" description:
  "Create a notification string with a timestamp." expression: "'New message
  received at ' + string(document.create_time)" The exact variables and
  functions that may be referenced within an expression are determined by the
  service that evaluates it. See the service documentation for additional
  information.

  Fields:
    description: Optional. Description of the expression. This is a longer
      text which describes the expression, e.g. when hovered over it in a UI.
    expression: Textual representation of an expression in Common Expression
      Language syntax.
    location: Optional. String indicating the location of the expression for
      error reporting, e.g. a file name and a position in the file.
    title: Optional. Title for the expression, i.e. a short string describing
      its purpose. This can be used e.g. in UIs which allow to enter the
      expression.
  """

  description = _messages.StringField(1)
  expression = _messages.StringField(2)
  location = _messages.StringField(3)
  title = _messages.StringField(4)


class ExtractPostureRequest(_messages.Message):
  r"""Message for extracting existing policies on a workload as a Posture.

  Fields:
    postureId: Required. User provided identifier. It should be unique in
      scope of an Organization and location.
    workload: Required. Workload from which the policies are to be extracted,
      it should belong to the same organization defined in parent. The format
      of this value varies depending on the scope of the request: -
      `folder/folderNumber` - `project/projectNumber` -
      `organization/organizationNumber`
  """

  postureId = _messages.StringField(1)
  workload = _messages.StringField(2)


class GoogleCloudSecuritypostureV1alphaCustomConstraint(_messages.Message):
  r"""A custom constraint defined by customers which can *only* be applied to
  the given resource types and organization. By creating a custom constraint,
  customers can apply policies of this custom constraint. *Creating a custom
  constraint itself does NOT apply any policy enforcement*.

  Enums:
    ActionTypeValueValuesEnum: Allow or deny type.
    MethodTypesValueListEntryValuesEnum:

  Fields:
    actionType: Allow or deny type.
    condition: Org policy condition/expression. For example:
      `resource.instanceName.matches("[production|test]_.*_(\d)+")` or,
      `resource.management.auto_upgrade == true` The max length of the
      condition is 1000 characters.
    description: Detailed information about this custom policy constraint. The
      max length of the description is 2000 characters.
    displayName: One line display name for the UI. The max length of the
      display_name is 200 characters.
    methodTypes: All the operations being applied for this constraint.
    name: Immutable. Name of the constraint. This is unique within the
      organization. Format of the name should be * `organizations/{organizatio
      n_id}/customConstraints/{custom_constraint_id}` Example:
      `organizations/123/customConstraints/custom.createOnlyE2TypeVms` The max
      length is 62 characters and the min length is 1. Note that the prefix
      `organizations/{organization_id}/customConstraints/custom.` is not
      counted.
    resourceTypes: Immutable. The resource instance type on which this policy
      applies. Format will be of the form : `/` Example: *
      `compute.googleapis.com/Instance`.
    updateTime: Output only. The last time this custom constraint was updated.
      This represents the last time that the `CreateCustomConstraint` or
      `UpdateCustomConstraint` RPC was called
  """

  class ActionTypeValueValuesEnum(_messages.Enum):
    r"""Allow or deny type.

    Values:
      ACTION_TYPE_UNSPECIFIED: Unspecified. Results in an error.
      ALLOW: Allowed action type.
      DENY: Deny action type.
    """
    ACTION_TYPE_UNSPECIFIED = 0
    ALLOW = 1
    DENY = 2

  class MethodTypesValueListEntryValuesEnum(_messages.Enum):
    r"""MethodTypesValueListEntryValuesEnum enum type.

    Values:
      METHOD_TYPE_UNSPECIFIED: Unspecified. Results in an error.
      CREATE: Constraint applied when creating the resource.
      UPDATE: Constraint applied when updating the resource.
      DELETE: Constraint applied when deleting the resource. Not supported
        yet.
    """
    METHOD_TYPE_UNSPECIFIED = 0
    CREATE = 1
    UPDATE = 2
    DELETE = 3

  actionType = _messages.EnumField('ActionTypeValueValuesEnum', 1)
  condition = _messages.StringField(2)
  description = _messages.StringField(3)
  displayName = _messages.StringField(4)
  methodTypes = _messages.EnumField('MethodTypesValueListEntryValuesEnum', 5, repeated=True)
  name = _messages.StringField(6)
  resourceTypes = _messages.StringField(7, repeated=True)
  updateTime = _messages.StringField(8)


class GoogleCloudSecuritypostureV1alphaIaCValidationReportPolicyDetails(_messages.Message):
  r"""Details of policies unsupported by evaluation services during IAC
  validation.

  Enums:
    ConstraintTypeValueValuesEnum: Type of policy constraint.

  Fields:
    constraintType: Type of policy constraint.
    policyId: Policy id of unsupported policy.
  """

  class ConstraintTypeValueValuesEnum(_messages.Enum):
    r"""Type of policy constraint.

    Values:
      CONSTRAINT_TYPE_UNSPECIFIED: Unspecified constraint type.
      ORG_POLICY: Org policy canned constraint type.
      SECURITY_HEALTH_ANALYTICS_MODULE: SHA module canned constraint type.
      ORG_POLICY_CUSTOM: Custom org policy constraint type.
      SECURITY_HEALTH_ANALYTICS_CUSTOM_MODULE: Custom SHA constraint type.
    """
    CONSTRAINT_TYPE_UNSPECIFIED = 0
    ORG_POLICY = 1
    SECURITY_HEALTH_ANALYTICS_MODULE = 2
    ORG_POLICY_CUSTOM = 3
    SECURITY_HEALTH_ANALYTICS_CUSTOM_MODULE = 4

  constraintType = _messages.EnumField('ConstraintTypeValueValuesEnum', 1)
  policyId = _messages.StringField(2)


class GoogleCloudSecuritypostureV1alphaPolicyRule(_messages.Message):
  r"""A rule used to express this policy.

  Fields:
    allowAll: Setting this to true means that all values are allowed. This
      field can be set only in policies for list constraints.
    condition: A condition which determines whether this rule is used in the
      evaluation of the policy. When set, the `expression` field in the `Expr'
      must include from 1 to 10 subexpressions, joined by the "||" or "&&"
      operators. Each subexpression must be of the form
      "resource.matchTag('/tag_key_short_name, 'tag_value_short_name')". or
      "resource.matchTagId('tagKeys/key_id', 'tagValues/value_id')". where
      key_name and value_name are the resource names for Label Keys and
      Values. These names are available from the Tag Manager Service. An
      example expression is: "resource.matchTag('123456789/environment,
      'prod')". or "resource.matchTagId('tagKeys/123', 'tagValues/456')".
    denyAll: Setting this to true means that all values are denied. This field
      can be set only in policies for list constraints.
    enforce: If `true`, then the policy is enforced. If `false`, then any
      configuration is acceptable. This field can be set only in policies for
      boolean constraints.
    values: List of values to be used for this policy rule. This field can be
      set only in policies for list constraints.
  """

  allowAll = _messages.BooleanField(1)
  condition = _messages.MessageField('Expr', 2)
  denyAll = _messages.BooleanField(3)
  enforce = _messages.BooleanField(4)
  values = _messages.MessageField('GoogleCloudSecuritypostureV1alphaPolicyRuleStringValues', 5)


class GoogleCloudSecuritypostureV1alphaPolicyRuleStringValues(_messages.Message):
  r"""A message that holds specific allowed and denied values. This message
  can define specific values and subtrees of the Resource Manager resource
  hierarchy (`Organizations`, `Folders`, `Projects`) that are allowed or
  denied. This is achieved by using the `under:` and optional `is:` prefixes.
  The `under:` prefix is used to denote resource subtree values. The `is:`
  prefix is used to denote specific values, and is required only if the value
  contains a ":". Values prefixed with "is:" are treated the same as values
  with no prefix. Ancestry subtrees must be in one of the following formats: -
  `projects/` (for example, `projects/tokyo-rain-123`) - `folders/` (for
  example, `folders/1234`) - `organizations/` (for example,
  `organizations/1234`) The `supports_under` field of the associated
  `Constraint` defines whether ancestry prefixes can be used.

  Fields:
    allowedValues: List of values allowed at this resource.
    deniedValues: List of values denied at this resource.
  """

  allowedValues = _messages.StringField(1, repeated=True)
  deniedValues = _messages.StringField(2, repeated=True)


class GoogleCloudSecuritypostureV1alphaReport(_messages.Message):
  r"""========================== Reports ========================== Definition
  of the resource 'Report'.

  Fields:
    createTime: Output only. The timestamp when the report was created.
    iacValidationReport: A IaCValidationReport attribute.
    name: Required. The name of this Report resource, in the format of
      organizations/{organization}/locations/{location}/reports/{reportID}.
    updateTime: Output only. The timestamp when the report was updated.
  """

  createTime = _messages.StringField(1)
  iacValidationReport = _messages.MessageField('IaCValidationReport', 2)
  name = _messages.StringField(3)
  updateTime = _messages.StringField(4)


class IaC(_messages.Message):
  r"""Infrastrucutre as code representations.

  Fields:
    tfPlan: Optional. Terraform plan file in JSON format. See
      https://developer.hashicorp.com/terraform/internals/json-format for how
      to generate JSON representation of a terraform plan file.
  """

  tfPlan = _messages.BytesField(1)


class IaCValidationReport(_messages.Message):
  r"""Details of an IaC Validation report.

  Fields:
    note: A general-purpose note field for additional information about the
      report.
    skippedPolicies: List of policies unsupported by evaluation services
      during IAC validation.
    violations: List of violations found in the provided IaC.
  """

  note = _messages.StringField(1)
  skippedPolicies = _messages.MessageField('GoogleCloudSecuritypostureV1alphaIaCValidationReportPolicyDetails', 2, repeated=True)
  violations = _messages.MessageField('Violation', 3, repeated=True)


class ListLocationsResponse(_messages.Message):
  r"""The response message for Locations.ListLocations.

  Fields:
    locations: A list of locations that matches the specified filter in the
      request.
    nextPageToken: The standard List next-page token.
  """

  locations = _messages.MessageField('Location', 1, repeated=True)
  nextPageToken = _messages.StringField(2)


class ListOperationsResponse(_messages.Message):
  r"""The response message for Operations.ListOperations.

  Fields:
    nextPageToken: The standard List next-page token.
    operations: A list of operations that matches the specified filter in the
      request.
  """

  nextPageToken = _messages.StringField(1)
  operations = _messages.MessageField('Operation', 2, repeated=True)


class ListPostureDeploymentsResponse(_messages.Message):
  r"""Message for response to listing PostureDeployments.

  Fields:
    nextPageToken: A token identifying a page of results the server should
      return.
    postureDeployments: The list of PostureDeployment.
    unreachable: Locations that could not be reached.
  """

  nextPageToken = _messages.StringField(1)
  postureDeployments = _messages.MessageField('PostureDeployment', 2, repeated=True)
  unreachable = _messages.StringField(3, repeated=True)


class ListPostureRevisionsResponse(_messages.Message):
  r"""Message for response to listing PostureRevisions.

  Fields:
    nextPageToken: A token identifying a page of results the server should
      return.
    revisions: The list of Posture revisions.
  """

  nextPageToken = _messages.StringField(1)
  revisions = _messages.MessageField('Posture', 2, repeated=True)


class ListPostureTemplatesResponse(_messages.Message):
  r"""Message for response to listing PostureTemplates.

  Fields:
    nextPageToken: A token identifying a page of results the server should
      return.
    postureTemplates: The list of PostureTemplate.
  """

  nextPageToken = _messages.StringField(1)
  postureTemplates = _messages.MessageField('PostureTemplate', 2, repeated=True)


class ListPosturesResponse(_messages.Message):
  r"""Message for response to listing Postures.

  Fields:
    nextPageToken: A token identifying a page of results the server should
      return.
    postures: The list of Posture.
    unreachable: Unreachable resources.
  """

  nextPageToken = _messages.StringField(1)
  postures = _messages.MessageField('Posture', 2, repeated=True)
  unreachable = _messages.StringField(3, repeated=True)


class ListReportsResponse(_messages.Message):
  r"""Message for response to listing Report.

  Fields:
    nextPageToken: A token identifying a page of results the server should
      return.
    reports: The list of Reports.
    unreachable: Locations that could not be reached.
  """

  nextPageToken = _messages.StringField(1)
  reports = _messages.MessageField('GoogleCloudSecuritypostureV1alphaReport', 2, repeated=True)
  unreachable = _messages.StringField(3, repeated=True)


class Location(_messages.Message):
  r"""A resource that represents a Google Cloud location.

  Messages:
    LabelsValue: Cross-service attributes for the location. For example
      {"cloud.googleapis.com/region": "us-east1"}
    MetadataValue: Service-specific metadata. For example the available
      capacity at the given location.

  Fields:
    displayName: The friendly name for this location, typically a nearby city
      name. For example, "Tokyo".
    labels: Cross-service attributes for the location. For example
      {"cloud.googleapis.com/region": "us-east1"}
    locationId: The canonical id for this location. For example: `"us-east1"`.
    metadata: Service-specific metadata. For example the available capacity at
      the given location.
    name: Resource name for the location, which may vary between
      implementations. For example: `"projects/example-project/locations/us-
      east1"`
  """

  @encoding.MapUnrecognizedFields('additionalProperties')
  class LabelsValue(_messages.Message):
    r"""Cross-service attributes for the location. For example
    {"cloud.googleapis.com/region": "us-east1"}

    Messages:
      AdditionalProperty: An additional property for a LabelsValue object.

    Fields:
      additionalProperties: Additional properties of type LabelsValue
    """

    class AdditionalProperty(_messages.Message):
      r"""An additional property for a LabelsValue object.

      Fields:
        key: Name of the additional property.
        value: A string attribute.
      """

      key = _messages.StringField(1)
      value = _messages.StringField(2)

    additionalProperties = _messages.MessageField('AdditionalProperty', 1, repeated=True)

  @encoding.MapUnrecognizedFields('additionalProperties')
  class MetadataValue(_messages.Message):
    r"""Service-specific metadata. For example the available capacity at the
    given location.

    Messages:
      AdditionalProperty: An additional property for a MetadataValue object.

    Fields:
      additionalProperties: Properties of the object. Contains field @type
        with type URL.
    """

    class AdditionalProperty(_messages.Message):
      r"""An additional property for a MetadataValue object.

      Fields:
        key: Name of the additional property.
        value: A extra_types.JsonValue attribute.
      """

      key = _messages.StringField(1)
      value = _messages.MessageField('extra_types.JsonValue', 2)

    additionalProperties = _messages.MessageField('AdditionalProperty', 1, repeated=True)

  displayName = _messages.StringField(1)
  labels = _messages.MessageField('LabelsValue', 2)
  locationId = _messages.StringField(3)
  metadata = _messages.MessageField('MetadataValue', 4)
  name = _messages.StringField(5)


class Operation(_messages.Message):
  r"""This resource represents a long-running operation that is the result of
  a network API call.

  Messages:
    MetadataValue: Service-specific metadata associated with the operation. It
      typically contains progress information and common metadata such as
      create time. Some services might not provide such metadata. Any method
      that returns a long-running operation should document the metadata type,
      if any.
    ResponseValue: The normal, successful response of the operation. If the
      original method returns no data on success, such as `Delete`, the
      response is `google.protobuf.Empty`. If the original method is standard
      `Get`/`Create`/`Update`, the response should be the resource. For other
      methods, the response should have the type `XxxResponse`, where `Xxx` is
      the original method name. For example, if the original method name is
      `TakeSnapshot()`, the inferred response type is `TakeSnapshotResponse`.

  Fields:
    done: If the value is `false`, it means the operation is still in
      progress. If `true`, the operation is completed, and either `error` or
      `response` is available.
    error: The error result of the operation in case of failure or
      cancellation.
    metadata: Service-specific metadata associated with the operation. It
      typically contains progress information and common metadata such as
      create time. Some services might not provide such metadata. Any method
      that returns a long-running operation should document the metadata type,
      if any.
    name: The server-assigned name, which is only unique within the same
      service that originally returns it. If you use the default HTTP mapping,
      the `name` should be a resource name ending with
      `operations/{unique_id}`.
    response: The normal, successful response of the operation. If the
      original method returns no data on success, such as `Delete`, the
      response is `google.protobuf.Empty`. If the original method is standard
      `Get`/`Create`/`Update`, the response should be the resource. For other
      methods, the response should have the type `XxxResponse`, where `Xxx` is
      the original method name. For example, if the original method name is
      `TakeSnapshot()`, the inferred response type is `TakeSnapshotResponse`.
  """

  @encoding.MapUnrecognizedFields('additionalProperties')
  class MetadataValue(_messages.Message):
    r"""Service-specific metadata associated with the operation. It typically
    contains progress information and common metadata such as create time.
    Some services might not provide such metadata. Any method that returns a
    long-running operation should document the metadata type, if any.

    Messages:
      AdditionalProperty: An additional property for a MetadataValue object.

    Fields:
      additionalProperties: Properties of the object. Contains field @type
        with type URL.
    """

    class AdditionalProperty(_messages.Message):
      r"""An additional property for a MetadataValue object.

      Fields:
        key: Name of the additional property.
        value: A extra_types.JsonValue attribute.
      """

      key = _messages.StringField(1)
      value = _messages.MessageField('extra_types.JsonValue', 2)

    additionalProperties = _messages.MessageField('AdditionalProperty', 1, repeated=True)

  @encoding.MapUnrecognizedFields('additionalProperties')
  class ResponseValue(_messages.Message):
    r"""The normal, successful response of the operation. If the original
    method returns no data on success, such as `Delete`, the response is
    `google.protobuf.Empty`. If the original method is standard
    `Get`/`Create`/`Update`, the response should be the resource. For other
    methods, the response should have the type `XxxResponse`, where `Xxx` is
    the original method name. For example, if the original method name is
    `TakeSnapshot()`, the inferred response type is `TakeSnapshotResponse`.

    Messages:
      AdditionalProperty: An additional property for a ResponseValue object.

    Fields:
      additionalProperties: Properties of the object. Contains field @type
        with type URL.
    """

    class AdditionalProperty(_messages.Message):
      r"""An additional property for a ResponseValue object.

      Fields:
        key: Name of the additional property.
        value: A extra_types.JsonValue attribute.
      """

      key = _messages.StringField(1)
      value = _messages.MessageField('extra_types.JsonValue', 2)

    additionalProperties = _messages.MessageField('AdditionalProperty', 1, repeated=True)

  done = _messages.BooleanField(1)
  error = _messages.MessageField('Status', 2)
  metadata = _messages.MessageField('MetadataValue', 3)
  name = _messages.StringField(4)
  response = _messages.MessageField('ResponseValue', 5)


class OperationMetadata(_messages.Message):
  r"""Represents the metadata of the long-running operation.

  Fields:
    apiVersion: Output only. API version used to start the operation.
    createTime: Output only. The time the operation was created.
    endTime: Output only. The time the operation finished running.
    errorMessage: Output only. This is a output only optional field which will
      be filled only in cases where PostureDeployments enter failure states
      like UPDATE_FAILED or CREATE_FAILED or DELETE_FAILED.
    requestedCancellation: Output only. Identifies whether the user has
      requested cancellation of the operation. Operations that have been
      cancelled successfully have Operation.error value with a
      google.rpc.Status.code of 1, corresponding to `Code.CANCELLED`.
    statusMessage: Output only. Human-readable status of the operation, if
      any.
    target: Output only. Server-defined resource path for the target of the
      operation.
    verb: Output only. Name of the verb executed by the operation.
  """

  apiVersion = _messages.StringField(1)
  createTime = _messages.StringField(2)
  endTime = _messages.StringField(3)
  errorMessage = _messages.StringField(4)
  requestedCancellation = _messages.BooleanField(5)
  statusMessage = _messages.StringField(6)
  target = _messages.StringField(7)
  verb = _messages.StringField(8)


class OrgPolicyConstraint(_messages.Message):
  r"""Message for Org Policy Canned Constraint.

  Fields:
    cannedConstraintId: Required. Org Policy Canned Constraint id.
    policyRules: Required. Org PolicySpec rules.
  """

  cannedConstraintId = _messages.StringField(1)
  policyRules = _messages.MessageField('GoogleCloudSecuritypostureV1alphaPolicyRule', 2, repeated=True)


class OrgPolicyConstraintCustom(_messages.Message):
  r"""Message for Org Policy Custom Constraint.

  Fields:
    customConstraint: Required. Org Policy Custom Constraint.
    policyRules: Required. Org Policyspec rules.
  """

  customConstraint = _messages.MessageField('GoogleCloudSecuritypostureV1alphaCustomConstraint', 1)
  policyRules = _messages.MessageField('GoogleCloudSecuritypostureV1alphaPolicyRule', 2, repeated=True)


class Policy(_messages.Message):
  r"""Policy representation.

  Fields:
    complianceStandards: Optional. Contains list of mapping for a Policy to a
      standard and control.
    constraint: Required. Constraint details.
    description: Optional. Description of the Policy.
    policyId: Required. ID of the Policy that is user generated, immutable and
      unique within the scope of a policy set.
  """

  complianceStandards = _messages.MessageField('ComplianceStandard', 1, repeated=True)
  constraint = _messages.MessageField('Constraint', 2)
  description = _messages.StringField(3)
  policyId = _messages.StringField(4)


class PolicyDetails(_messages.Message):
  r"""A PolicyDetails object.

  Enums:
    ConstraintTypeValueValuesEnum: Type of policy constraint.

  Fields:
    complianceStandards: Compliance standards that the policy maps to. E.g.
      CIS-2.0 1.15
    constraint: JSON string representing policy constraint.
      Format/representation may change, thus clients should not depend.
    constraintType: Type of policy constraint.
    description: Description of the policy.
  """

  class ConstraintTypeValueValuesEnum(_messages.Enum):
    r"""Type of policy constraint.

    Values:
      CONSTRAINT_TYPE_UNSPECIFIED: <no description>
      SECURITY_HEALTH_ANALYTICS_CUSTOM_MODULE: <no description>
      ORG_POLICY_CUSTOM: <no description>
      SECURITY_HEALTH_ANALYTICS_MODULE: SHA module constraint type.
      ORG_POLICY: Org policy constraint type.
    """
    CONSTRAINT_TYPE_UNSPECIFIED = 0
    SECURITY_HEALTH_ANALYTICS_CUSTOM_MODULE = 1
    ORG_POLICY_CUSTOM = 2
    SECURITY_HEALTH_ANALYTICS_MODULE = 3
    ORG_POLICY = 4

  complianceStandards = _messages.StringField(1, repeated=True)
  constraint = _messages.StringField(2)
  constraintType = _messages.EnumField('ConstraintTypeValueValuesEnum', 3)
  description = _messages.StringField(4)


class PolicySet(_messages.Message):
  r"""PolicySet representation.

  Fields:
    description: Optional. Description of the Policy set.
    policies: Required. List of policies.
    policySetId: Required. ID of the Policy set.
  """

  description = _messages.StringField(1)
  policies = _messages.MessageField('Policy', 2, repeated=True)
  policySetId = _messages.StringField(3)


class Posture(_messages.Message):
  r"""========================== Postures ==========================
  Definition of a Posture.

  Enums:
    CategoriesValueListEntryValuesEnum:
    PostureTypeValueValuesEnum: Output only. The type of the posture.
    StateValueValuesEnum: Required. State of Posture resource.

  Messages:
    AnnotationsValue: Optional. User annotations. These attributes can only be
      set and used by the user, and not by Google Security Postures. .

  Fields:
    annotations: Optional. User annotations. These attributes can only be set
      and used by the user, and not by Google Security Postures. .
    categories: Output only. List of categories associated with a Posture.
      Based on it's associated policies the service defines the category,
      hence it is OUTPUT_ONLY field.
    createTime: Output only. The timestamp that the posture was created.
    description: Optional. User provided description of the posture.
    etag: Optional. An opaque tag indicating the current version of the
      Posture, used for concurrency control. When the `Posture` is returned
      from either a `GetPosture` or a `ListPostures` request, this `etag`
      indicates the version of the current `Posture` to use when executing a
      read-modify-write loop. When the `Posture` is used in a `UpdatePosture`
      method, use the `etag` value that was returned from a `GetPosture`
      request as part of a read-modify-write loop for concurrency control. Not
      setting the `etag` in a `UpdatePosture` request will result in an
      unconditional write of the `Posture`.
    name: Required. Identifier. The name of this Posture resource, in the
      format of
      organizations/{org_id}/locations/{location_id}/postures/{posture}.
    policySets: Required. List of Policy sets.
    postureType: Output only. The type of the posture.
    reconciling: Output only. Whether or not this Posture is in the process of
      being updated.
    revisionId: Output only. Immutable. The revision ID of the posture. The
      format is an 8-character hexadecimal string. https://google.aip.dev/162
    state: Required. State of Posture resource.
    updateTime: Output only. The timestamp that the posture was updated.
  """

  class CategoriesValueListEntryValuesEnum(_messages.Enum):
    r"""CategoriesValueListEntryValuesEnum enum type.

    Values:
      CATEGORY_UNSPECIFIED: Unspecified Category.
      AI: AI Category.
      AWS: Posture contains AWS policies.
      GCP: Posture contains GCP policies.
    """
    CATEGORY_UNSPECIFIED = 0
    AI = 1
    AWS = 2
    GCP = 3

  class PostureTypeValueValuesEnum(_messages.Enum):
    r"""Output only. The type of the posture.

    Values:
      POSTURE_TYPE_UNSPECIFIED: Unspecified Category.
      SECURITY: Security Posture.
      DATA_SECURITY: DataSecurity Posture
    """
    POSTURE_TYPE_UNSPECIFIED = 0
    SECURITY = 1
    DATA_SECURITY = 2

  class StateValueValuesEnum(_messages.Enum):
    r"""Required. State of Posture resource.

    Values:
      STATE_UNSPECIFIED: Unspecified operation state.
      DEPRECATED: The Posture is marked deprecated when it is not in use by
        the user.
      DRAFT: The Posture is created successfully but is not yet ready for
        usage.
      ACTIVE: The Posture state is active. Ready for use/deployments.
    """
    STATE_UNSPECIFIED = 0
    DEPRECATED = 1
    DRAFT = 2
    ACTIVE = 3

  @encoding.MapUnrecognizedFields('additionalProperties')
  class AnnotationsValue(_messages.Message):
    r"""Optional. User annotations. These attributes can only be set and used
    by the user, and not by Google Security Postures. .

    Messages:
      AdditionalProperty: An additional property for a AnnotationsValue
        object.

    Fields:
      additionalProperties: Additional properties of type AnnotationsValue
    """

    class AdditionalProperty(_messages.Message):
      r"""An additional property for a AnnotationsValue object.

      Fields:
        key: Name of the additional property.
        value: A string attribute.
      """

      key = _messages.StringField(1)
      value = _messages.StringField(2)

    additionalProperties = _messages.MessageField('AdditionalProperty', 1, repeated=True)

  annotations = _messages.MessageField('AnnotationsValue', 1)
  categories = _messages.EnumField('CategoriesValueListEntryValuesEnum', 2, repeated=True)
  createTime = _messages.StringField(3)
  description = _messages.StringField(4)
  etag = _messages.StringField(5)
  name = _messages.StringField(6)
  policySets = _messages.MessageField('PolicySet', 7, repeated=True)
  postureType = _messages.EnumField('PostureTypeValueValuesEnum', 8)
  reconciling = _messages.BooleanField(9)
  revisionId = _messages.StringField(10)
  state = _messages.EnumField('StateValueValuesEnum', 11)
  updateTime = _messages.StringField(12)


class PostureDeployment(_messages.Message):
  r"""========================== PostureDeployments ==========================
  Message describing PostureDeployment resource.

  Enums:
    CategoriesValueListEntryValuesEnum:
    PostureTypeValueValuesEnum: Output only. The type of the posture.
    StateValueValuesEnum: Output only. State of PostureDeployment resource.

  Messages:
    AnnotationsValue: Optional. User annotations. These attributes can only be
      set and used by the user, and not by Google Security Postures. .

  Fields:
    annotations: Optional. User annotations. These attributes can only be set
      and used by the user, and not by Google Security Postures. .
    categories: Output only. Categories are a function of policies present in
      a Posture Version associated with this PostureDeployment.
    createTime: Output only. The timestamp that the PostureDeployment was
      created.
    description: Optional. User provided description of the PostureDeployment.
    desiredPostureId: Output only. This is a output only optional field which
      will be filled in case where PostureDeployment state is UPDATE_FAILED or
      CREATE_FAILED or DELETE_FAILED. It denotes the desired Posture.
    desiredPostureRevisionId: Output only. Output only optional field which
      provides revision_id of the desired_posture_id.
    etag: Optional. An opaque tag indicating the current version of the
      PostureDeployment, used for concurrency control. When the
      `PostureDeployment` is returned from either a `GetPostureDeployment` or
      a `ListPostureDeployments` request, this `etag` indicates the version of
      the current `PostureDeployment` to use when executing a read-modify-
      write loop. When the `PostureDeployment` is used in a
      `UpdatePostureDeployment` method, use the `etag` value that was returned
      from a `GetPostureDeployment` request as part of a read-modify-write
      loop for concurrency control. Not setting the `etag` in a
      `UpdatePostureDeployment` request will result in an unconditional write
      of the `PostureDeployment`.
    failureMessage: Output only. This is a output only optional field which
      will be filled in case where PostureDeployment enters a failure state
      like UPDATE_FAILED or CREATE_FAILED or DELETE_FAILED.
    name: Required. The name of this PostureDeployment resource, in the format
      of organizations/{organization}/locations/{location_id}/postureDeploymen
      ts/{postureDeployment}.
    postureId: Required. Posture that needs to be deployed. Format:
      organizations/{org_id}/locations/{location_id}/postures/ Example:
      organizations/99/locations/global/postures/les-miserables.
    postureRevisionId: Required. Revision_id of the Posture that is to be
      deployed.
    postureType: Output only. The type of the posture.
    reconciling: Output only. Whether or not this Posture is in the process of
      being updated.
    state: Output only. State of PostureDeployment resource.
    targetResource: Required. Target resource where the Posture will be
      deployed. Currently supported resources are of types:
      projects/projectNumber, folders/folderNumber,
      organizations/organizationNumber.
    updateTime: Output only. The timestamp that the PostureDeployment was
      updated.
  """

  class CategoriesValueListEntryValuesEnum(_messages.Enum):
    r"""CategoriesValueListEntryValuesEnum enum type.

    Values:
      CATEGORY_UNSPECIFIED: Unspecified Category.
      AI: AI Category.
      AWS: Posture contains AWS policies.
      GCP: Posture contains GCP policies.
    """
    CATEGORY_UNSPECIFIED = 0
    AI = 1
    AWS = 2
    GCP = 3

  class PostureTypeValueValuesEnum(_messages.Enum):
    r"""Output only. The type of the posture.

    Values:
      POSTURE_TYPE_UNSPECIFIED: Unspecified Category.
      SECURITY: Security Posture.
      DATA_SECURITY: DataSecurity Posture
    """
    POSTURE_TYPE_UNSPECIFIED = 0
    SECURITY = 1
    DATA_SECURITY = 2

  class StateValueValuesEnum(_messages.Enum):
    r"""Output only. State of PostureDeployment resource.

    Values:
      STATE_UNSPECIFIED: Unspecified operation state.
      CREATING: The PostureDeployment is being created.
      DELETING: The PostureDeployment is being deleted.
      UPDATING: The PostureDeployment state is being updated.
      ACTIVE: The PostureDeployment state is active and in use.
      CREATE_FAILED: The PostureDeployment creation failed.
      UPDATE_FAILED: The PostureDeployment update failed.
      DELETE_FAILED: The PostureDeployment deletion failed.
    """
    STATE_UNSPECIFIED = 0
    CREATING = 1
    DELETING = 2
    UPDATING = 3
    ACTIVE = 4
    CREATE_FAILED = 5
    UPDATE_FAILED = 6
    DELETE_FAILED = 7

  @encoding.MapUnrecognizedFields('additionalProperties')
  class AnnotationsValue(_messages.Message):
    r"""Optional. User annotations. These attributes can only be set and used
    by the user, and not by Google Security Postures. .

    Messages:
      AdditionalProperty: An additional property for a AnnotationsValue
        object.

    Fields:
      additionalProperties: Additional properties of type AnnotationsValue
    """

    class AdditionalProperty(_messages.Message):
      r"""An additional property for a AnnotationsValue object.

      Fields:
        key: Name of the additional property.
        value: A string attribute.
      """

      key = _messages.StringField(1)
      value = _messages.StringField(2)

    additionalProperties = _messages.MessageField('AdditionalProperty', 1, repeated=True)

  annotations = _messages.MessageField('AnnotationsValue', 1)
  categories = _messages.EnumField('CategoriesValueListEntryValuesEnum', 2, repeated=True)
  createTime = _messages.StringField(3)
  description = _messages.StringField(4)
  desiredPostureId = _messages.StringField(5)
  desiredPostureRevisionId = _messages.StringField(6)
  etag = _messages.StringField(7)
  failureMessage = _messages.StringField(8)
  name = _messages.StringField(9)
  postureId = _messages.StringField(10)
  postureRevisionId = _messages.StringField(11)
  postureType = _messages.EnumField('PostureTypeValueValuesEnum', 12)
  reconciling = _messages.BooleanField(13)
  state = _messages.EnumField('StateValueValuesEnum', 14)
  targetResource = _messages.StringField(15)
  updateTime = _messages.StringField(16)


class PostureDetails(_messages.Message):
  r"""Details of a posture deployment.

  Fields:
    policySet: ID of the above posture's policy set to which this policy
      belongs.
    posture: Posture name in the format of organizations/{organization_id}/loc
      ations/{location_id}/postures/{postureID}.
    postureDeployment: Posture deployment name in one of the following formats
      organizations/{organization_id}/locations/{location_id}/postureDeploymen
      ts/{postureDeploymentID}
    postureDeploymentTargetResource: Target resource where the Posture is
      deployed. Can be one of: projects/projectNumber, folders/folderNumber,
      organizations/organizationNumber.
    postureRevisionId: Posture revision ID.
  """

  policySet = _messages.StringField(1)
  posture = _messages.StringField(2)
  postureDeployment = _messages.StringField(3)
  postureDeploymentTargetResource = _messages.StringField(4)
  postureRevisionId = _messages.StringField(5)


class PostureTemplate(_messages.Message):
  r"""========================== PostureTemplates ==========================
  Message describing PostureTemplate object.

  Enums:
    CategoriesValueListEntryValuesEnum:
    StateValueValuesEnum: Output only. State of PostureTemplate resource.

  Fields:
    categories: Output only. List of categories associated with a
      PostureTemplate. Based on it's associated policies we define the
      category, hence it is OUTPUT_ONLY field.
    description: Output only. Description of the Posture template.
    name: Output only. Identifier. The name of the Posture template will be of
      the format organizations/{organization}/locations/{location}/postureTemp
      lates/{postureTemplate}
    policySets: Output only. Policy_sets to be used by the user.
    revisionId: Output only. The revision_id of a PostureTemplate.
    state: Output only. State of PostureTemplate resource.
  """

  class CategoriesValueListEntryValuesEnum(_messages.Enum):
    r"""CategoriesValueListEntryValuesEnum enum type.

    Values:
      CATEGORY_UNSPECIFIED: Unspecified Category.
      AI: AI Category.
      AWS: Posture contains AWS policies.
      GCP: Posture contains GCP policies.
    """
    CATEGORY_UNSPECIFIED = 0
    AI = 1
    AWS = 2
    GCP = 3

  class StateValueValuesEnum(_messages.Enum):
    r"""Output only. State of PostureTemplate resource.

    Values:
      STATE_UNSPECIFIED: Unspecified state
      ACTIVE: If the Posture template is adhering to the latest controls and
        standards.
      DEPRECATED: If the Posture template controls and standards are outdated
        and not recommended for use.
    """
    STATE_UNSPECIFIED = 0
    ACTIVE = 1
    DEPRECATED = 2

  categories = _messages.EnumField('CategoriesValueListEntryValuesEnum', 1, repeated=True)
  description = _messages.StringField(2)
  name = _messages.StringField(3)
  policySets = _messages.MessageField('PolicySet', 4, repeated=True)
  revisionId = _messages.StringField(5)
  state = _messages.EnumField('StateValueValuesEnum', 6)


class Property(_messages.Message):
  r"""An individual name-value pair that defines a custom source property.

  Fields:
    name: Required. Name of the property for the custom output.
    valueExpression: Optional. The CEL expression for the custom output. A
      resource property can be specified to return the value of the property
      or a text string enclosed in quotation marks.
  """

  name = _messages.StringField(1)
  valueExpression = _messages.MessageField('Expr', 2)


class ResourceSelector(_messages.Message):
  r"""Resource for selecting resource type.

  Fields:
    resourceTypes: Required. The resource types to run the detector on.
  """

  resourceTypes = _messages.StringField(1, repeated=True)


class SecurityHealthAnalyticsCustomModule(_messages.Message):
  r"""Message for SHA Custom Module

  Enums:
    ModuleEnablementStateValueValuesEnum: The state of enablement for the
      module at its level of the resource hierarchy.

  Fields:
    config: Required. custom module details
    displayName: Optional. The display name of the Security Health Analytics
      custom module. This display name becomes the finding category for all
      findings that are returned by this custom module. The display name must
      be between 1 and 128 characters, start with a lowercase letter, and
      contain alphanumeric characters or underscores only.
    id: Output only. Immutable. The id of the custom module. The id is server-
      generated and is not user settable. It will be a numeric id containing
      1-20 digits.
    moduleEnablementState: The state of enablement for the module at its level
      of the resource hierarchy.
  """

  class ModuleEnablementStateValueValuesEnum(_messages.Enum):
    r"""The state of enablement for the module at its level of the resource
    hierarchy.

    Values:
      ENABLEMENT_STATE_UNSPECIFIED: Default value. This value is unused.
      ENABLED: State is enabled.
      DISABLED: State is disabled.
    """
    ENABLEMENT_STATE_UNSPECIFIED = 0
    ENABLED = 1
    DISABLED = 2

  config = _messages.MessageField('CustomConfig', 1)
  displayName = _messages.StringField(2)
  id = _messages.StringField(3)
  moduleEnablementState = _messages.EnumField('ModuleEnablementStateValueValuesEnum', 4)


class SecurityHealthAnalyticsModule(_messages.Message):
  r"""Message for Security Health Analytics built-in detector.

  Enums:
    ModuleEnablementStateValueValuesEnum: The state of enablement for the
      module at its level of the resource hierarchy.

  Fields:
    moduleEnablementState: The state of enablement for the module at its level
      of the resource hierarchy.
    moduleName: Required. The name of the module eg:
      BIGQUERY_TABLE_CMEK_DISABLED.
  """

  class ModuleEnablementStateValueValuesEnum(_messages.Enum):
    r"""The state of enablement for the module at its level of the resource
    hierarchy.

    Values:
      ENABLEMENT_STATE_UNSPECIFIED: Default value. This value is unused.
      ENABLED: State is enabled.
      DISABLED: State is disabled.
    """
    ENABLEMENT_STATE_UNSPECIFIED = 0
    ENABLED = 1
    DISABLED = 2

  moduleEnablementState = _messages.EnumField('ModuleEnablementStateValueValuesEnum', 1)
  moduleName = _messages.StringField(2)


class SecuritypostureOrganizationsLocationsGetRequest(_messages.Message):
  r"""A SecuritypostureOrganizationsLocationsGetRequest object.

  Fields:
    name: Resource name for the location.
  """

  name = _messages.StringField(1, required=True)


class SecuritypostureOrganizationsLocationsListRequest(_messages.Message):
  r"""A SecuritypostureOrganizationsLocationsListRequest object.

  Fields:
    filter: A filter to narrow down results to a preferred subset. The
      filtering language accepts strings like `"displayName=tokyo"`, and is
      documented in more detail in [AIP-160](https://google.aip.dev/160).
    includeUnrevealedLocations: If true, the returned list will include
      locations which are not yet revealed.
    name: The resource that owns the locations collection, if applicable.
    pageSize: The maximum number of results to return. If not set, the service
      selects a default.
    pageToken: A page token received from the `next_page_token` field in the
      response. Send that page token to receive the subsequent page.
  """

  filter = _messages.StringField(1)
  includeUnrevealedLocations = _messages.BooleanField(2)
  name = _messages.StringField(3, required=True)
  pageSize = _messages.IntegerField(4, variant=_messages.Variant.INT32)
  pageToken = _messages.StringField(5)


class SecuritypostureOrganizationsLocationsOperationsCancelRequest(_messages.Message):
  r"""A SecuritypostureOrganizationsLocationsOperationsCancelRequest object.

  Fields:
    cancelOperationRequest: A CancelOperationRequest resource to be passed as
      the request body.
    name: The name of the operation resource to be cancelled.
  """

  cancelOperationRequest = _messages.MessageField('CancelOperationRequest', 1)
  name = _messages.StringField(2, required=True)


class SecuritypostureOrganizationsLocationsOperationsDeleteRequest(_messages.Message):
  r"""A SecuritypostureOrganizationsLocationsOperationsDeleteRequest object.

  Fields:
    name: The name of the operation resource to be deleted.
  """

  name = _messages.StringField(1, required=True)


class SecuritypostureOrganizationsLocationsOperationsGetRequest(_messages.Message):
  r"""A SecuritypostureOrganizationsLocationsOperationsGetRequest object.

  Fields:
    name: The name of the operation resource.
  """

  name = _messages.StringField(1, required=True)


class SecuritypostureOrganizationsLocationsOperationsListRequest(_messages.Message):
  r"""A SecuritypostureOrganizationsLocationsOperationsListRequest object.

  Fields:
    filter: The standard list filter.
    name: The name of the operation's parent resource.
    pageSize: The standard list page size.
    pageToken: The standard list page token.
  """

  filter = _messages.StringField(1)
  name = _messages.StringField(2, required=True)
  pageSize = _messages.IntegerField(3, variant=_messages.Variant.INT32)
  pageToken = _messages.StringField(4)


class SecuritypostureOrganizationsLocationsPostureDeploymentsCreateRequest(_messages.Message):
  r"""A SecuritypostureOrganizationsLocationsPostureDeploymentsCreateRequest
  object.

  Fields:
    parent: Required. Value for parent. Format:
      organizations/{org_id}/locations/{location}
    postureDeployment: A PostureDeployment resource to be passed as the
      request body.
    postureDeploymentId: Required. User provided identifier. It should be
      unique in scope of an Organization and location.
  """

  parent = _messages.StringField(1, required=True)
  postureDeployment = _messages.MessageField('PostureDeployment', 2)
  postureDeploymentId = _messages.StringField(3)


class SecuritypostureOrganizationsLocationsPostureDeploymentsDeleteRequest(_messages.Message):
  r"""A SecuritypostureOrganizationsLocationsPostureDeploymentsDeleteRequest
  object.

  Fields:
    etag: Optional. Etag value of the PostureDeployment to be deleted.
    name: Required. Name of the resource.
  """

  etag = _messages.StringField(1)
  name = _messages.StringField(2, required=True)


class SecuritypostureOrganizationsLocationsPostureDeploymentsGetRequest(_messages.Message):
  r"""A SecuritypostureOrganizationsLocationsPostureDeploymentsGetRequest
  object.

  Fields:
    name: Required. Name of the resource.
  """

  name = _messages.StringField(1, required=True)


class SecuritypostureOrganizationsLocationsPostureDeploymentsListRequest(_messages.Message):
  r"""A SecuritypostureOrganizationsLocationsPostureDeploymentsListRequest
  object.

  Fields:
    filter: Optional. Filter to be applied on the resource, defined by EBNF
      grammar https://google.aip.dev/assets/misc/ebnf-filtering.txt.
    pageSize: Optional. Requested page size. Server may return fewer items
      than requested. If unspecified, server will pick an appropriate default.
    pageToken: Optional. A token identifying a page of results the server
      should return.
    parent: Required. Parent value for ListPostureDeploymentsRequest.
  """

  filter = _messages.StringField(1)
  pageSize = _messages.IntegerField(2, variant=_messages.Variant.INT32)
  pageToken = _messages.StringField(3)
  parent = _messages.StringField(4, required=True)


class SecuritypostureOrganizationsLocationsPostureDeploymentsPatchRequest(_messages.Message):
  r"""A SecuritypostureOrganizationsLocationsPostureDeploymentsPatchRequest
  object.

  Fields:
    name: Required. The name of this PostureDeployment resource, in the format
      of organizations/{organization}/locations/{location_id}/postureDeploymen
      ts/{postureDeployment}.
    postureDeployment: A PostureDeployment resource to be passed as the
      request body.
    updateMask: Required. Field mask is used to specify the fields to be
      overwritten in the PostureDeployment resource by the update. The fields
      specified in the update_mask are relative to the resource, not the full
      request. A field will be overwritten if it is in the mask. If the user
      does not provide a mask then all fields will be overwritten.
  """

  name = _messages.StringField(1, required=True)
  postureDeployment = _messages.MessageField('PostureDeployment', 2)
  updateMask = _messages.StringField(3)


class SecuritypostureOrganizationsLocationsPostureTemplatesGetRequest(_messages.Message):
  r"""A SecuritypostureOrganizationsLocationsPostureTemplatesGetRequest
  object.

  Fields:
    name: Required. Name of the resource.
    revisionId: Optional. Specific revision_id of a Posture Template.
      PostureTemplate revision_id which needs to be retrieved.
  """

  name = _messages.StringField(1, required=True)
  revisionId = _messages.StringField(2)


class SecuritypostureOrganizationsLocationsPostureTemplatesListRequest(_messages.Message):
  r"""A SecuritypostureOrganizationsLocationsPostureTemplatesListRequest
  object.

  Fields:
    filter: Optional. Filter to be applied on the resource, defined by EBNF
      grammar https://google.aip.dev/assets/misc/ebnf-filtering.txt.
    pageSize: Optional. Requested page size. Server may return fewer items
      than requested. If unspecified, server will pick an appropriate default.
    pageToken: Optional. A token identifying a page of results the server
      should return.
    parent: Required. Parent value for ListPostureTemplatesRequest.
  """

  filter = _messages.StringField(1)
  pageSize = _messages.IntegerField(2, variant=_messages.Variant.INT32)
  pageToken = _messages.StringField(3)
  parent = _messages.StringField(4, required=True)


class SecuritypostureOrganizationsLocationsPosturesCreateRequest(_messages.Message):
  r"""A SecuritypostureOrganizationsLocationsPosturesCreateRequest object.

  Fields:
    parent: Required. Value for parent.
    posture: A Posture resource to be passed as the request body.
    postureId: Required. User provided identifier. It should be unique in
      scope of an Organization and location.
  """

  parent = _messages.StringField(1, required=True)
  posture = _messages.MessageField('Posture', 2)
  postureId = _messages.StringField(3)


class SecuritypostureOrganizationsLocationsPosturesDeleteRequest(_messages.Message):
  r"""A SecuritypostureOrganizationsLocationsPosturesDeleteRequest object.

  Fields:
    etag: Optional. Etag value of the Posture to be deleted.
    name: Required. Name of the resource.
  """

  etag = _messages.StringField(1)
  name = _messages.StringField(2, required=True)


class SecuritypostureOrganizationsLocationsPosturesExtractRequest(_messages.Message):
  r"""A SecuritypostureOrganizationsLocationsPosturesExtractRequest object.

  Fields:
    extractPostureRequest: A ExtractPostureRequest resource to be passed as
      the request body.
    parent: Required. The parent resource name. The format of this value is as
      follows: `organizations/{organization}/locations/{location}`
  """

  extractPostureRequest = _messages.MessageField('ExtractPostureRequest', 1)
  parent = _messages.StringField(2, required=True)


class SecuritypostureOrganizationsLocationsPosturesGetRequest(_messages.Message):
  r"""A SecuritypostureOrganizationsLocationsPosturesGetRequest object.

  Fields:
    name: Required. Name of the resource.
    revisionId: Optional. Posture revision which needs to be retrieved.
  """

  name = _messages.StringField(1, required=True)
  revisionId = _messages.StringField(2)


class SecuritypostureOrganizationsLocationsPosturesListRequest(_messages.Message):
  r"""A SecuritypostureOrganizationsLocationsPosturesListRequest object.

  Fields:
    pageSize: Requested page size. Server may return fewer items than
      requested. If unspecified, server will pick an appropriate default.
    pageToken: A token identifying a page of results the server should return.
    parent: Required. Parent value for ListPosturesRequest.
  """

  pageSize = _messages.IntegerField(1, variant=_messages.Variant.INT32)
  pageToken = _messages.StringField(2)
  parent = _messages.StringField(3, required=True)


class SecuritypostureOrganizationsLocationsPosturesListRevisionsRequest(_messages.Message):
  r"""A SecuritypostureOrganizationsLocationsPosturesListRevisionsRequest
  object.

  Fields:
    name: Required. Name value for ListPostureRevisionsRequest.
    pageSize: Optional. Requested page size. Server may return fewer items
      than requested. If unspecified, server will pick 100 as default.
    pageToken: Optional. A token identifying a page of results the server
      should return.
  """

  name = _messages.StringField(1, required=True)
  pageSize = _messages.IntegerField(2, variant=_messages.Variant.INT32)
  pageToken = _messages.StringField(3)


class SecuritypostureOrganizationsLocationsPosturesPatchRequest(_messages.Message):
  r"""A SecuritypostureOrganizationsLocationsPosturesPatchRequest object.

  Fields:
    name: Required. Identifier. The name of this Posture resource, in the
      format of
      organizations/{org_id}/locations/{location_id}/postures/{posture}.
    posture: A Posture resource to be passed as the request body.
    revisionId: Required. Posture revision which needs to be updated.
    updateMask: Required. Field mask is used to specify the fields to be
      overwritten in the Posture resource by the update. The fields specified
      in the update_mask are relative to the resource, not the full request. A
      field will be overwritten if it is in the mask. If the user does not
      provide a mask then all fields will be overwritten.
  """

  name = _messages.StringField(1, required=True)
  posture = _messages.MessageField('Posture', 2)
  revisionId = _messages.StringField(3)
  updateMask = _messages.StringField(4)


class SecuritypostureOrganizationsLocationsReportsCreateIaCValidationReportRequest(_messages.Message):
  r"""A
  SecuritypostureOrganizationsLocationsReportsCreateIaCValidationReportRequest
  object.

  Fields:
    createIaCValidationReportRequest: A CreateIaCValidationReportRequest
      resource to be passed as the request body.
    parent: Required. The parent resource name. The format of this value is as
      follows: `organizations/{organization}/locations/{location}`
  """

  createIaCValidationReportRequest = _messages.MessageField('CreateIaCValidationReportRequest', 1)
  parent = _messages.StringField(2, required=True)


class SecuritypostureOrganizationsLocationsReportsGetRequest(_messages.Message):
  r"""A SecuritypostureOrganizationsLocationsReportsGetRequest object.

  Fields:
    name: Required. Name of the resource. The format of this value is as
      follows:
      `organizations/{organization}/locations/{location}/reports/{reportID}`
  """

  name = _messages.StringField(1, required=True)


class SecuritypostureOrganizationsLocationsReportsListRequest(_messages.Message):
  r"""A SecuritypostureOrganizationsLocationsReportsListRequest object.

  Fields:
    filter: Optional. Filter to be applied on the resource, defined by EBNF
      grammar https://google.aip.dev/assets/misc/ebnf-filtering.txt.
    pageSize: Optional. Requested page size. Server may return fewer items
      than requested. If unspecified, server will pick an appropriate default.
    pageToken: Optional. A token identifying a page of results the server
      should return.
    parent: Required. Parent value for ListReportsRequest. The format of this
      value is as follows: `organizations/{organization}/locations/{location}`
  """

  filter = _messages.StringField(1)
  pageSize = _messages.IntegerField(2, variant=_messages.Variant.INT32)
  pageToken = _messages.StringField(3)
  parent = _messages.StringField(4, required=True)


class StandardQueryParameters(_messages.Message):
  r"""Query parameters accepted by all methods.

  Enums:
    FXgafvValueValuesEnum: V1 error format.
    AltValueValuesEnum: Data format for response.

  Fields:
    f__xgafv: V1 error format.
    access_token: OAuth access token.
    alt: Data format for response.
    callback: JSONP
    fields: Selector specifying which fields to include in a partial response.
    key: API key. Your API key identifies your project and provides you with
      API access, quota, and reports. Required unless you provide an OAuth 2.0
      token.
    oauth_token: OAuth 2.0 token for the current user.
    prettyPrint: Returns response with indentations and line breaks.
    quotaUser: Available to use for quota purposes for server-side
      applications. Can be any arbitrary string assigned to a user, but should
      not exceed 40 characters.
    trace: A tracing token of the form "token:<tokenid>" to include in api
      requests.
    uploadType: Legacy upload protocol for media (e.g. "media", "multipart").
    upload_protocol: Upload protocol for media (e.g. "raw", "multipart").
  """

  class AltValueValuesEnum(_messages.Enum):
    r"""Data format for response.

    Values:
      json: Responses with Content-Type of application/json
      media: Media download with context-dependent Content-Type
      proto: Responses with Content-Type of application/x-protobuf
    """
    json = 0
    media = 1
    proto = 2

  class FXgafvValueValuesEnum(_messages.Enum):
    r"""V1 error format.

    Values:
      _1: v1 error format
      _2: v2 error format
    """
    _1 = 0
    _2 = 1

  f__xgafv = _messages.EnumField('FXgafvValueValuesEnum', 1)
  access_token = _messages.StringField(2)
  alt = _messages.EnumField('AltValueValuesEnum', 3, default='json')
  callback = _messages.StringField(4)
  fields = _messages.StringField(5)
  key = _messages.StringField(6)
  oauth_token = _messages.StringField(7)
  prettyPrint = _messages.BooleanField(8, default=True)
  quotaUser = _messages.StringField(9)
  trace = _messages.StringField(10)
  uploadType = _messages.StringField(11)
  upload_protocol = _messages.StringField(12)


class Status(_messages.Message):
  r"""The `Status` type defines a logical error model that is suitable for
  different programming environments, including REST APIs and RPC APIs. It is
  used by [gRPC](https://github.com/grpc). Each `Status` message contains
  three pieces of data: error code, error message, and error details. You can
  find out more about this error model and how to work with it in the [API
  Design Guide](https://cloud.google.com/apis/design/errors).

  Messages:
    DetailsValueListEntry: A DetailsValueListEntry object.

  Fields:
    code: The status code, which should be an enum value of google.rpc.Code.
    details: A list of messages that carry the error details. There is a
      common set of message types for APIs to use.
    message: A developer-facing error message, which should be in English. Any
      user-facing error message should be localized and sent in the
      google.rpc.Status.details field, or localized by the client.
  """

  @encoding.MapUnrecognizedFields('additionalProperties')
  class DetailsValueListEntry(_messages.Message):
    r"""A DetailsValueListEntry object.

    Messages:
      AdditionalProperty: An additional property for a DetailsValueListEntry
        object.

    Fields:
      additionalProperties: Properties of the object. Contains field @type
        with type URL.
    """

    class AdditionalProperty(_messages.Message):
      r"""An additional property for a DetailsValueListEntry object.

      Fields:
        key: Name of the additional property.
        value: A extra_types.JsonValue attribute.
      """

      key = _messages.StringField(1)
      value = _messages.MessageField('extra_types.JsonValue', 2)

    additionalProperties = _messages.MessageField('AdditionalProperty', 1, repeated=True)

  code = _messages.IntegerField(1, variant=_messages.Variant.INT32)
  details = _messages.MessageField('DetailsValueListEntry', 2, repeated=True)
  message = _messages.StringField(3)


class Violation(_messages.Message):
  r"""Details of violation.

  Enums:
    SeverityValueValuesEnum: Severity of the violation.

  Fields:
    assetId: Asset which violated some policy.
    nextSteps: Next steps or recommendations to act upon this violation.
    policyId: Policy which was violated by the asset.
    severity: Severity of the violation.
    violatedAsset: Details of the asset which got violated.
    violatedPolicy: Details of the policy which got violated.
    violatedPosture: Posture details if the violated policy belongs to a
      posture deployment.
  """

  class SeverityValueValuesEnum(_messages.Enum):
    r"""Severity of the violation.

    Values:
      SEVERITY_UNSPECIFIED: This is the default severity if the severity is
        unknown.
      CRITICAL: <no description>
      HIGH: <no description>
      MEDIUM: <no description>
      LOW: <no description>
    """
    SEVERITY_UNSPECIFIED = 0
    CRITICAL = 1
    HIGH = 2
    MEDIUM = 3
    LOW = 4

  assetId = _messages.StringField(1)
  nextSteps = _messages.StringField(2)
  policyId = _messages.StringField(3)
  severity = _messages.EnumField('SeverityValueValuesEnum', 4)
  violatedAsset = _messages.MessageField('AssetDetails', 5)
  violatedPolicy = _messages.MessageField('PolicyDetails', 6)
  violatedPosture = _messages.MessageField('PostureDetails', 7)


encoding.AddCustomJsonFieldMapping(
    StandardQueryParameters, 'f__xgafv', '$.xgafv')
encoding.AddCustomJsonEnumMapping(
    StandardQueryParameters.FXgafvValueValuesEnum, '_1', '1')
encoding.AddCustomJsonEnumMapping(
    StandardQueryParameters.FXgafvValueValuesEnum, '_2', '2')
