"""Generated message classes for iam version v3beta.

Manages identity and access control for Google Cloud resources, including the
creation of service accounts, which you can use to authenticate to Google and
make API calls. Enabling this API also enables the IAM Service Account
Credentials API (iamcredentials.googleapis.com). However, disabling this API
doesn't disable the IAM Service Account Credentials API.
"""
# NOTE: This file is autogenerated and should not be edited by hand.

from __future__ import absolute_import

from apitools.base.protorpclite import messages as _messages
from apitools.base.py import encoding
from apitools.base.py import extra_types


package = 'iam'


class GoogleCloudLocationListLocationsResponse(_messages.Message):
  r"""The response message for Locations.ListLocations.

  Fields:
    locations: A list of locations that matches the specified filter in the
      request.
    nextPageToken: The standard List next-page token.
  """

  locations = _messages.MessageField('GoogleCloudLocationLocation', 1, repeated=True)
  nextPageToken = _messages.StringField(2)


class GoogleCloudLocationLocation(_messages.Message):
  r"""A resource that represents a Google Cloud location.

  Messages:
    LabelsValue: Cross-service attributes for the location. For example
      {"cloud.googleapis.com/region": "us-east1"}
    MetadataValue: Service-specific metadata. For example the available
      capacity at the given location.

  Fields:
    displayName: The friendly name for this location, typically a nearby city
      name. For example, "Tokyo".
    labels: Cross-service attributes for the location. For example
      {"cloud.googleapis.com/region": "us-east1"}
    locationId: The canonical id for this location. For example: `"us-east1"`.
    metadata: Service-specific metadata. For example the available capacity at
      the given location.
    name: Resource name for the location, which may vary between
      implementations. For example: `"projects/example-project/locations/us-
      east1"`
  """

  @encoding.MapUnrecognizedFields('additionalProperties')
  class LabelsValue(_messages.Message):
    r"""Cross-service attributes for the location. For example
    {"cloud.googleapis.com/region": "us-east1"}

    Messages:
      AdditionalProperty: An additional property for a LabelsValue object.

    Fields:
      additionalProperties: Additional properties of type LabelsValue
    """

    class AdditionalProperty(_messages.Message):
      r"""An additional property for a LabelsValue object.

      Fields:
        key: Name of the additional property.
        value: A string attribute.
      """

      key = _messages.StringField(1)
      value = _messages.StringField(2)

    additionalProperties = _messages.MessageField('AdditionalProperty', 1, repeated=True)

  @encoding.MapUnrecognizedFields('additionalProperties')
  class MetadataValue(_messages.Message):
    r"""Service-specific metadata. For example the available capacity at the
    given location.

    Messages:
      AdditionalProperty: An additional property for a MetadataValue object.

    Fields:
      additionalProperties: Properties of the object. Contains field @type
        with type URL.
    """

    class AdditionalProperty(_messages.Message):
      r"""An additional property for a MetadataValue object.

      Fields:
        key: Name of the additional property.
        value: A extra_types.JsonValue attribute.
      """

      key = _messages.StringField(1)
      value = _messages.MessageField('extra_types.JsonValue', 2)

    additionalProperties = _messages.MessageField('AdditionalProperty', 1, repeated=True)

  displayName = _messages.StringField(1)
  labels = _messages.MessageField('LabelsValue', 2)
  locationId = _messages.StringField(3)
  metadata = _messages.MessageField('MetadataValue', 4)
  name = _messages.StringField(5)


class GoogleIamAdminV1AuditData(_messages.Message):
  r"""Audit log information specific to Cloud IAM admin APIs. This message is
  serialized as an `Any` type in the `ServiceData` message of an `AuditLog`
  message.

  Fields:
    permissionDelta: The permission_delta when when creating or updating a
      Role.
  """

  permissionDelta = _messages.MessageField('GoogleIamAdminV1AuditDataPermissionDelta', 1)


class GoogleIamAdminV1AuditDataPermissionDelta(_messages.Message):
  r"""A PermissionDelta message to record the added_permissions and
  removed_permissions inside a role.

  Fields:
    addedPermissions: Added permissions.
    removedPermissions: Removed permissions.
  """

  addedPermissions = _messages.StringField(1, repeated=True)
  removedPermissions = _messages.StringField(2, repeated=True)


class GoogleIamV3betaAccessBoundaryPolicy(_messages.Message):
  r"""Policy details for principal access boundary policy, a policy type that
  define access boundary for principal sets

  Fields:
    rules: Required. A list of rules that specify the behavior of the
      `Policy`. The list is limited to 5 rules.
    version: Optional. The type of versioning that will be enforced on the
      policy. If no version is specified, policies will default to use
      latest_version.
  """

  rules = _messages.MessageField('GoogleIamV3betaAccessBoundaryPolicyRule', 1, repeated=True)
  version = _messages.MessageField('GoogleIamV3betaAccessBoundaryPolicyEnforcementVersion', 2)


class GoogleIamV3betaAccessBoundaryPolicyEnforcementVersion(_messages.Message):
  r"""The different versions supported by principal authorization policy.

  Fields:
    latestVersion: Optional. The latest officially released version number.
      This will automatically increase in scope as more services are included
      in enforcemment.
    staticVersion: Optional. A specific version number. This will need to be
      manually updated to newer versions as they become available in order to
      keep maximum protection.
  """

  latestVersion = _messages.MessageField('GoogleIamV3betaAccessBoundaryPolicyEnforcementVersionLatestVersion', 1)
  staticVersion = _messages.MessageField('GoogleIamV3betaAccessBoundaryPolicyEnforcementVersionStaticVersion', 2)


class GoogleIamV3betaAccessBoundaryPolicyEnforcementVersionLatestVersion(_messages.Message):
  r"""The latest officially released version number. This will automatically
  increase in scope as more services are included in enforcemment.
  """



class GoogleIamV3betaAccessBoundaryPolicyEnforcementVersionStaticVersion(_messages.Message):
  r"""A specific version number. This will need to be manually updated to
  newer versions as they become available in order to keep maximum protection.

  Fields:
    enforcementVersion: Optional. Currently only a value of '1' is allowed.
  """

  enforcementVersion = _messages.IntegerField(1, variant=_messages.Variant.INT32)


class GoogleIamV3betaAccessBoundaryPolicyRule(_messages.Message):
  r"""Rule details inside a principal access boundary policy.

  Enums:
    ActionValueValuesEnum: Required. The action that all principals which are
      impacted by this policy can take on resources inside the boundary.

  Fields:
    action: Required. The action that all principals which are impacted by
      this policy can take on resources inside the boundary.
    description: Optional. A user-specified description of the rule. This
      value can be up to 256 characters.
    resources: Required. Cloud Resource Manager resource name. The resource
      and all the descendants are included. The list is limited to 10
      resources. This represents all the boundaries of the policy. The
      following resource names are supported: * Organization, such as
      "//cloudresourcemanager.googleapis.com/organizations/123". * Folder,
      such as "//cloudresourcemanager.googleapis.com/folders/123". * Project,
      such as "//cloudresourcemanager.googleapis.com/projects/123" or
      "//cloudresourcemanager.googleapis.com/projects/my-project-id".
  """

  class ActionValueValuesEnum(_messages.Enum):
    r"""Required. The action that all principals which are impacted by this
    policy can take on resources inside the boundary.

    Values:
      ACTION_UNSPECIFIED: Action unspecified; not a valid state.
      ALLOW: Allows all principals access to the resources in this rule.
    """
    ACTION_UNSPECIFIED = 0
    ALLOW = 1

  action = _messages.EnumField('ActionValueValuesEnum', 1)
  description = _messages.StringField(2)
  resources = _messages.StringField(3, repeated=True)


class GoogleIamV3betaListPoliciesResponse(_messages.Message):
  r"""Response message for ListPolicies method.

  Fields:
    nextPageToken: A token to retrieve next page of results.
    policies: The list of policies.
  """

  nextPageToken = _messages.StringField(1)
  policies = _messages.MessageField('GoogleIamV3betaV3Policy', 2, repeated=True)


class GoogleIamV3betaListPolicyBindingsResponse(_messages.Message):
  r"""Response message for ListPolicyBindings method.

  Fields:
    nextPageToken: Optional. A token, which can be sent as `page_token` to
      retrieve the next page. If this field is omitted, there are no
      subsequent pages.
    policyBindings: The policy bindings from the specified parent.
  """

  nextPageToken = _messages.StringField(1)
  policyBindings = _messages.MessageField('GoogleIamV3betaPolicyBinding', 2, repeated=True)


class GoogleIamV3betaListPrincipalAccessBoundaryPoliciesResponse(_messages.Message):
  r"""Response message for ListPrincipalAccessBoundaryPolicies rpc.

  Fields:
    nextPageToken: Optional. A token, which can be sent as `page_token` to
      retrieve the next page. If this field is omitted, there are no
      subsequent pages.
    principalAccessBoundaryPolicies: The principal access boundary policies
      from the specified parent.
  """

  nextPageToken = _messages.StringField(1)
  principalAccessBoundaryPolicies = _messages.MessageField('GoogleIamV3betaPrincipalAccessBoundaryPolicy', 2, repeated=True)


class GoogleIamV3betaPolicy(_messages.Message):
  r"""One of the policies supported by IAM V3

  Fields:
    principalAccessBoundaryPolicy: The principal access boundary kind policy
  """

  principalAccessBoundaryPolicy = _messages.MessageField('GoogleIamV3betaPrincipalAccessBoundaryPolicy', 1)


class GoogleIamV3betaPolicyBinding(_messages.Message):
  r"""IAM policy binding

  Enums:
    PolicyKindValueValuesEnum: Immutable. The kind of the policy to attach in
      this binding: + When the policy is empty, this field must be set. + When
      the policy is set, this field + can be left empty and will be set to the
      policy kind, or + must set to the input policy kind

  Messages:
    AnnotationsValue: Optional. User defined annotations. See
      https://google.aip.dev/148#annotations for more details such as format
      and size limitations

  Fields:
    annotations: Optional. User defined annotations. See
      https://google.aip.dev/148#annotations for more details such as format
      and size limitations
    condition: Optional. Condition can either be a principal condition or a
      resource condition. It depends on the type of target, the policy it is
      attached to, and/or the expression itself. When set, the `expression`
      field in the `Expr` must include from 1 to 10 subexpressions, joined by
      the "||"(Logical OR), "&&"(Logical AND) or "!"(Logical NOT) operators.
      Allowed operations for principal.type: - `principal.type == ` -
      `principal.type != ` - `principal.type in []` Allowed operations for
      principal.subject: - `principal.subject == ` - `principal.subject != ` -
      `principal.subject in []` - `principal.subject.startsWith()` -
      `principal.subject.endsWith()` Supported principal types are Workspace,
      Workforce Pool, Workload Pool and Service Account. Allowed string must
      be one of: - iam.googleapis.com/WorkspaceIdentity -
      iam.googleapis.com/WorkforcePoolIdentity -
      iam.googleapis.com/WorkloadPoolIdentity -
      iam.googleapis.com/ServiceAccount When the bound policy is a Principal
      Access Boundary policy, each subexpression must be of the form
      `principal.type == ` or `principal.subject == ''`. An example expression
      is: "principal.type == 'iam.googleapis.com/ServiceAccount'" or
      "principal.subject == 'bob@acme.com'".
    createTime: Output only. The time when the policy binding was created.
    displayName: Optional. The description of the policy binding. Must be less
      than or equal to 63 characters.
    etag: Optional. The etag for the policy binding. If this is provided on
      update, it must match the server's etag.
    name: Identifier. The resource name of the policy binding. The binding
      parent is the closest CRM resource (i.e., Project, Folder or
      Organization) to the binding target. Format: `projects/{project_id}/loca
      tions/{location}/policyBindings/{policy_binding_id}` `projects/{project_
      number}/locations/{location}/policyBindings/{policy_binding_id}` `folder
      s/{folder_id}/locations/{location}/policyBindings/{policy_binding_id}` `
      organizations/{organization_id}/locations/{location}/policyBindings/{pol
      icy_binding_id}`
    policy: Required. Immutable. The resource name of the policy to be bound.
      The binding parent and policy must belong to the same Organization (or
      Project).
    policyKind: Immutable. The kind of the policy to attach in this binding: +
      When the policy is empty, this field must be set. + When the policy is
      set, this field + can be left empty and will be set to the policy kind,
      or + must set to the input policy kind
    policyUid: Output only. The globally unique ID of the policy to be bound.
    target: Required. Immutable. Target is the full resource name of the
      resource to which the policy will be bound. Immutable once set.
    uid: Output only. The globally unique ID of the policy binding. Assigned
      when the policy binding is created.
    updateTime: Output only. The time when the policy binding was most
      recently updated.
  """

  class PolicyKindValueValuesEnum(_messages.Enum):
    r"""Immutable. The kind of the policy to attach in this binding: + When
    the policy is empty, this field must be set. + When the policy is set,
    this field + can be left empty and will be set to the policy kind, or +
    must set to the input policy kind

    Values:
      POLICY_KIND_UNSPECIFIED: Unspecified policy kind; Not a valid state
      PRINCIPAL_ACCESS_BOUNDARY: Principal access boundary policy kind
      ACCESS: Access policy kind
    """
    POLICY_KIND_UNSPECIFIED = 0
    PRINCIPAL_ACCESS_BOUNDARY = 1
    ACCESS = 2

  @encoding.MapUnrecognizedFields('additionalProperties')
  class AnnotationsValue(_messages.Message):
    r"""Optional. User defined annotations. See
    https://google.aip.dev/148#annotations for more details such as format and
    size limitations

    Messages:
      AdditionalProperty: An additional property for a AnnotationsValue
        object.

    Fields:
      additionalProperties: Additional properties of type AnnotationsValue
    """

    class AdditionalProperty(_messages.Message):
      r"""An additional property for a AnnotationsValue object.

      Fields:
        key: Name of the additional property.
        value: A string attribute.
      """

      key = _messages.StringField(1)
      value = _messages.StringField(2)

    additionalProperties = _messages.MessageField('AdditionalProperty', 1, repeated=True)

  annotations = _messages.MessageField('AnnotationsValue', 1)
  condition = _messages.MessageField('GoogleTypeExpr', 2)
  createTime = _messages.StringField(3)
  displayName = _messages.StringField(4)
  etag = _messages.StringField(5)
  name = _messages.StringField(6)
  policy = _messages.StringField(7)
  policyKind = _messages.EnumField('PolicyKindValueValuesEnum', 8)
  policyUid = _messages.StringField(9)
  target = _messages.MessageField('GoogleIamV3betaPolicyBindingTarget', 10)
  uid = _messages.StringField(11)
  updateTime = _messages.StringField(12)


class GoogleIamV3betaPolicyBindingTarget(_messages.Message):
  r"""Target is the full resource name of the resource to which the policy
  will be bound. Immutable once set.

  Fields:
    principalSet: Immutable. Full Resource Name used for principal access
      boundary policy bindings Examples: Organization:
      "//cloudresourcemanager.googleapis.com/organizations/ORGANIZATION_ID"
      Folder: "//cloudresourcemanager.googleapis.com/folders/FOLDER_ID"
      Project: "//cloudresourcemanager.googleapis.com/projects/PROJECT_NUMBER"
      "//cloudresourcemanager.googleapis.com/projects/PROJECT_ID" Workload
      Identity Pool: "//iam.googleapis.com/projects/PROJECT_NUMBER/locations/L
      OCATION/workloadIdentityPools/WORKLOAD_POOL_ID" Workforce Identity:
      "//iam.googleapis.com/locations/global/workforcePools/WORKFORCE_POOL_ID"
      Workspace Identity:
      "//iam.googleapis.com/locations/global/workspace/WORKSPACE_ID"
  """

  principalSet = _messages.StringField(1)


class GoogleIamV3betaPolicyInaccessible(_messages.Message):
  r"""A marker to indicate that the policy is inaccessible"""


class GoogleIamV3betaPrincipalAccessBoundaryPolicy(_messages.Message):
  r"""An IAM principal access boundary policy resource.

  Messages:
    AnnotationsValue: Optional. User defined annotations. See
      https://google.aip.dev/148#annotations for more details such as format
      and size limitations

  Fields:
    annotations: Optional. User defined annotations. See
      https://google.aip.dev/148#annotations for more details such as format
      and size limitations
    createTime: Output only. The time when the principal access boundary
      policy was created.
    details: Optional. The details for the principal access boundary policy.
    displayName: Optional. The description of the principal access boundary
      policy. Must be less than or equal to 63 characters.
    etag: Optional. The etag for the principal access boundary. If this is
      provided on update, it must match the server's etag.
    name: Identifier. The resource name of the principal access boundary
      policy. The following format is supported: `organizations/{organization_
      id}/locations/{location}/principalAccessBoundaryPolicies/{policy_id}`
    uid: Output only. The globally unique ID of the principal access boundary
      policy.
    updateTime: Output only. The time when the principal access boundary
      policy was most recently updated.
  """

  @encoding.MapUnrecognizedFields('additionalProperties')
  class AnnotationsValue(_messages.Message):
    r"""Optional. User defined annotations. See
    https://google.aip.dev/148#annotations for more details such as format and
    size limitations

    Messages:
      AdditionalProperty: An additional property for a AnnotationsValue
        object.

    Fields:
      additionalProperties: Additional properties of type AnnotationsValue
    """

    class AdditionalProperty(_messages.Message):
      r"""An additional property for a AnnotationsValue object.

      Fields:
        key: Name of the additional property.
        value: A string attribute.
      """

      key = _messages.StringField(1)
      value = _messages.StringField(2)

    additionalProperties = _messages.MessageField('AdditionalProperty', 1, repeated=True)

  annotations = _messages.MessageField('AnnotationsValue', 1)
  createTime = _messages.StringField(2)
  details = _messages.MessageField('GoogleIamV3betaPrincipalAccessBoundaryPolicyDetails', 3)
  displayName = _messages.StringField(4)
  etag = _messages.StringField(5)
  name = _messages.StringField(6)
  uid = _messages.StringField(7)
  updateTime = _messages.StringField(8)


class GoogleIamV3betaPrincipalAccessBoundaryPolicyDetails(_messages.Message):
  r"""Principal access boundary policy details

  Fields:
    enforcementVersion: Optional. The version number that indicates which GCP
      services are included in the enforcement (e.g. "latest", "1", ...). If
      empty, the PAB policy version will be set to the current latest version,
      and this version won't get updated when new versions are released.
    rules: Required. A list of principal access boundary policy rules.
  """

  enforcementVersion = _messages.StringField(1)
  rules = _messages.MessageField('GoogleIamV3betaPrincipalAccessBoundaryPolicyRule', 2, repeated=True)


class GoogleIamV3betaPrincipalAccessBoundaryPolicyRule(_messages.Message):
  r"""Principal access boundary policy rule that defines the resource
  boundary.

  Enums:
    EffectValueValuesEnum: Required. The access relationship of principals to
      the resources in this rule.

  Fields:
    description: Optional. The description of the principal access boundary
      policy rule. Must be less than or equal to 256 characters.
    effect: Required. The access relationship of principals to the resources
      in this rule.
    resources: Required. A list of Cloud Resource Manager resources. The
      resource and all the descendants are included. The following resource
      names are supported: * Organization, such as
      "//cloudresourcemanager.googleapis.com/organizations/123". * Folder,
      such as "//cloudresourcemanager.googleapis.com/folders/123". * Project,
      such as "//cloudresourcemanager.googleapis.com/projects/123" or
      "//cloudresourcemanager.googleapis.com/projects/my-project-id".
  """

  class EffectValueValuesEnum(_messages.Enum):
    r"""Required. The access relationship of principals to the resources in
    this rule.

    Values:
      EFFECT_UNSPECIFIED: Effect unspecified.
      ALLOW: Allows access to the resources in this rule.
    """
    EFFECT_UNSPECIFIED = 0
    ALLOW = 1

  description = _messages.StringField(1)
  effect = _messages.EnumField('EffectValueValuesEnum', 2)
  resources = _messages.StringField(3, repeated=True)


class GoogleIamV3betaSearchApplicablePoliciesResponse(_messages.Message):
  r"""Response message for SearchApplicablePolicies

  Fields:
    bindingsAndPolicies: A list of Bindings and the policies associated with
      those bindings The bindings will be ordered by enforcement point
      starting from the lowest at the target level and up the CRM hierarchy.
      No order is guaranteed for bindings for a given enforcement point.
    nextPageToken: The page token to use in a follow up
      SearchApplicablePolicies request
    responseComplete: Does the response contain the full list of all bindings
      and policies applicable or were some excluded due to lack of permissions
  """

  bindingsAndPolicies = _messages.MessageField('GoogleIamV3betaSearchApplicablePoliciesResponseBindingAndPolicy', 1, repeated=True)
  nextPageToken = _messages.StringField(2)
  responseComplete = _messages.BooleanField(3)


class GoogleIamV3betaSearchApplicablePoliciesResponseBindingAndPolicy(_messages.Message):
  r"""A pair of a binding and a policy referenced by that binding (if
  accessible)

  Fields:
    binding: A binding between a target and a policy
    policy: The policy associated with the above binding. Omitted if the
      policy cannot be retrieved due to lack of permissions
    policyInaccessible: Will be set if there was a permission error getting
      the policy (even though the binding was accessible).
  """

  binding = _messages.MessageField('GoogleIamV3betaPolicyBinding', 1)
  policy = _messages.MessageField('GoogleIamV3betaPolicy', 2)
  policyInaccessible = _messages.MessageField('GoogleIamV3betaPolicyInaccessible', 3)


class GoogleIamV3betaSearchPrincipalAccessBoundaryPolicyBindingsResponse(_messages.Message):
  r"""Response message for SearchPrincipalAccessBoundaryPolicyBindings rpc.

  Fields:
    nextPageToken: Optional. A token, which can be sent as `page_token` to
      retrieve the next page. If this field is omitted, there are no
      subsequent pages.
    policyBindings: The policy bindings that reference the specified policy.
  """

  nextPageToken = _messages.StringField(1)
  policyBindings = _messages.MessageField('GoogleIamV3betaPolicyBinding', 2, repeated=True)


class GoogleIamV3betaSearchTargetPolicyBindingsResponse(_messages.Message):
  r"""Response message for SearchTargetPolicyBindings method.

  Fields:
    nextPageToken: Optional. A token, which can be sent as `page_token` to
      retrieve the next page. If this field is omitted, there are no
      subsequent pages.
    policyBindings: The policy bindings bound to the specified target.
  """

  nextPageToken = _messages.StringField(1)
  policyBindings = _messages.MessageField('GoogleIamV3betaPolicyBinding', 2, repeated=True)


class GoogleIamV3betaV3Policy(_messages.Message):
  r"""IAM policy - This is the Policy Service which will not launch and has
  been replaced by the principal_access_boundary_policy proto instead. Next
  ID: 11

  Messages:
    AnnotationsValue: Optional. Unstructured key-value map to store and
      retrieve arbitrary metadata. Keys must be less than or equal to 63
      characters; values must be less than or equal to 255 characters.

  Fields:
    accessBoundaryPolicy: Optional. A policy type that binds to principals and
      principal sets.
    annotations: Optional. Unstructured key-value map to store and retrieve
      arbitrary metadata. Keys must be less than or equal to 63 characters;
      values must be less than or equal to 255 characters.
    createTime: Output only. The time when the `Policy` was created.
    deleteTime: Output only. The time when the `Policy` was deleted. Empty if
      the policy is not deleted.
    description: Optional. A user-specified opaque description of the
      `Policy`. Must be less than or equal to 255 characters.
    displayName: Optional. A user-specified opaque description of the
      `Policy`. Must be less than or equal to 63 characters.
    etag: Optional. An opaque tag indicating the current version of the
      `Policy`. This is a strong etag.
    name: The resource name of the `Policy`, which must be globally unique.
      The name needs to follow formats below. This field is output_only in a
      CreatePolicyRequest. Only `global` location is supported.
      `projects/{project_id}/locations/{location}/policies/{policy_id}`
      `projects/{project_number}/locations/{location}/policies/{policy_id}`
      `folders/{numeric_id}/locations/{location}/policies/{policy_id}`
      `organizations/{numeric_id}/locations/{location}/policies/{policy_id}`
    uid: Output only. The globally unique ID of the `Policy`. Assigned when
      the `Policy` is created.
    updateTime: Output only. The time when the `Policy` was last updated.
      During creation, this field will have the create_time value.
  """

  @encoding.MapUnrecognizedFields('additionalProperties')
  class AnnotationsValue(_messages.Message):
    r"""Optional. Unstructured key-value map to store and retrieve arbitrary
    metadata. Keys must be less than or equal to 63 characters; values must be
    less than or equal to 255 characters.

    Messages:
      AdditionalProperty: An additional property for a AnnotationsValue
        object.

    Fields:
      additionalProperties: Additional properties of type AnnotationsValue
    """

    class AdditionalProperty(_messages.Message):
      r"""An additional property for a AnnotationsValue object.

      Fields:
        key: Name of the additional property.
        value: A string attribute.
      """

      key = _messages.StringField(1)
      value = _messages.StringField(2)

    additionalProperties = _messages.MessageField('AdditionalProperty', 1, repeated=True)

  accessBoundaryPolicy = _messages.MessageField('GoogleIamV3betaAccessBoundaryPolicy', 1)
  annotations = _messages.MessageField('AnnotationsValue', 2)
  createTime = _messages.StringField(3)
  deleteTime = _messages.StringField(4)
  description = _messages.StringField(5)
  displayName = _messages.StringField(6)
  etag = _messages.StringField(7)
  name = _messages.StringField(8)
  uid = _messages.StringField(9)
  updateTime = _messages.StringField(10)


class GoogleLongrunningOperation(_messages.Message):
  r"""This resource represents a long-running operation that is the result of
  a network API call.

  Messages:
    MetadataValue: Service-specific metadata associated with the operation. It
      typically contains progress information and common metadata such as
      create time. Some services might not provide such metadata. Any method
      that returns a long-running operation should document the metadata type,
      if any.
    ResponseValue: The normal, successful response of the operation. If the
      original method returns no data on success, such as `Delete`, the
      response is `google.protobuf.Empty`. If the original method is standard
      `Get`/`Create`/`Update`, the response should be the resource. For other
      methods, the response should have the type `XxxResponse`, where `Xxx` is
      the original method name. For example, if the original method name is
      `TakeSnapshot()`, the inferred response type is `TakeSnapshotResponse`.

  Fields:
    done: If the value is `false`, it means the operation is still in
      progress. If `true`, the operation is completed, and either `error` or
      `response` is available.
    error: The error result of the operation in case of failure or
      cancellation.
    metadata: Service-specific metadata associated with the operation. It
      typically contains progress information and common metadata such as
      create time. Some services might not provide such metadata. Any method
      that returns a long-running operation should document the metadata type,
      if any.
    name: The server-assigned name, which is only unique within the same
      service that originally returns it. If you use the default HTTP mapping,
      the `name` should be a resource name ending with
      `operations/{unique_id}`.
    response: The normal, successful response of the operation. If the
      original method returns no data on success, such as `Delete`, the
      response is `google.protobuf.Empty`. If the original method is standard
      `Get`/`Create`/`Update`, the response should be the resource. For other
      methods, the response should have the type `XxxResponse`, where `Xxx` is
      the original method name. For example, if the original method name is
      `TakeSnapshot()`, the inferred response type is `TakeSnapshotResponse`.
  """

  @encoding.MapUnrecognizedFields('additionalProperties')
  class MetadataValue(_messages.Message):
    r"""Service-specific metadata associated with the operation. It typically
    contains progress information and common metadata such as create time.
    Some services might not provide such metadata. Any method that returns a
    long-running operation should document the metadata type, if any.

    Messages:
      AdditionalProperty: An additional property for a MetadataValue object.

    Fields:
      additionalProperties: Properties of the object. Contains field @type
        with type URL.
    """

    class AdditionalProperty(_messages.Message):
      r"""An additional property for a MetadataValue object.

      Fields:
        key: Name of the additional property.
        value: A extra_types.JsonValue attribute.
      """

      key = _messages.StringField(1)
      value = _messages.MessageField('extra_types.JsonValue', 2)

    additionalProperties = _messages.MessageField('AdditionalProperty', 1, repeated=True)

  @encoding.MapUnrecognizedFields('additionalProperties')
  class ResponseValue(_messages.Message):
    r"""The normal, successful response of the operation. If the original
    method returns no data on success, such as `Delete`, the response is
    `google.protobuf.Empty`. If the original method is standard
    `Get`/`Create`/`Update`, the response should be the resource. For other
    methods, the response should have the type `XxxResponse`, where `Xxx` is
    the original method name. For example, if the original method name is
    `TakeSnapshot()`, the inferred response type is `TakeSnapshotResponse`.

    Messages:
      AdditionalProperty: An additional property for a ResponseValue object.

    Fields:
      additionalProperties: Properties of the object. Contains field @type
        with type URL.
    """

    class AdditionalProperty(_messages.Message):
      r"""An additional property for a ResponseValue object.

      Fields:
        key: Name of the additional property.
        value: A extra_types.JsonValue attribute.
      """

      key = _messages.StringField(1)
      value = _messages.MessageField('extra_types.JsonValue', 2)

    additionalProperties = _messages.MessageField('AdditionalProperty', 1, repeated=True)

  done = _messages.BooleanField(1)
  error = _messages.MessageField('GoogleRpcStatus', 2)
  metadata = _messages.MessageField('MetadataValue', 3)
  name = _messages.StringField(4)
  response = _messages.MessageField('ResponseValue', 5)


class GoogleRpcStatus(_messages.Message):
  r"""The `Status` type defines a logical error model that is suitable for
  different programming environments, including REST APIs and RPC APIs. It is
  used by [gRPC](https://github.com/grpc). Each `Status` message contains
  three pieces of data: error code, error message, and error details. You can
  find out more about this error model and how to work with it in the [API
  Design Guide](https://cloud.google.com/apis/design/errors).

  Messages:
    DetailsValueListEntry: A DetailsValueListEntry object.

  Fields:
    code: The status code, which should be an enum value of google.rpc.Code.
    details: A list of messages that carry the error details. There is a
      common set of message types for APIs to use.
    message: A developer-facing error message, which should be in English. Any
      user-facing error message should be localized and sent in the
      google.rpc.Status.details field, or localized by the client.
  """

  @encoding.MapUnrecognizedFields('additionalProperties')
  class DetailsValueListEntry(_messages.Message):
    r"""A DetailsValueListEntry object.

    Messages:
      AdditionalProperty: An additional property for a DetailsValueListEntry
        object.

    Fields:
      additionalProperties: Properties of the object. Contains field @type
        with type URL.
    """

    class AdditionalProperty(_messages.Message):
      r"""An additional property for a DetailsValueListEntry object.

      Fields:
        key: Name of the additional property.
        value: A extra_types.JsonValue attribute.
      """

      key = _messages.StringField(1)
      value = _messages.MessageField('extra_types.JsonValue', 2)

    additionalProperties = _messages.MessageField('AdditionalProperty', 1, repeated=True)

  code = _messages.IntegerField(1, variant=_messages.Variant.INT32)
  details = _messages.MessageField('DetailsValueListEntry', 2, repeated=True)
  message = _messages.StringField(3)


class GoogleTypeExpr(_messages.Message):
  r"""Represents a textual expression in the Common Expression Language (CEL)
  syntax. CEL is a C-like expression language. The syntax and semantics of CEL
  are documented at https://github.com/google/cel-spec. Example (Comparison):
  title: "Summary size limit" description: "Determines if a summary is less
  than 100 chars" expression: "document.summary.size() < 100" Example
  (Equality): title: "Requestor is owner" description: "Determines if
  requestor is the document owner" expression: "document.owner ==
  request.auth.claims.email" Example (Logic): title: "Public documents"
  description: "Determine whether the document should be publicly visible"
  expression: "document.type != 'private' && document.type != 'internal'"
  Example (Data Manipulation): title: "Notification string" description:
  "Create a notification string with a timestamp." expression: "'New message
  received at ' + string(document.create_time)" The exact variables and
  functions that may be referenced within an expression are determined by the
  service that evaluates it. See the service documentation for additional
  information.

  Fields:
    description: Optional. Description of the expression. This is a longer
      text which describes the expression, e.g. when hovered over it in a UI.
    expression: Textual representation of an expression in Common Expression
      Language syntax.
    location: Optional. String indicating the location of the expression for
      error reporting, e.g. a file name and a position in the file.
    title: Optional. Title for the expression, i.e. a short string describing
      its purpose. This can be used e.g. in UIs which allow to enter the
      expression.
  """

  description = _messages.StringField(1)
  expression = _messages.StringField(2)
  location = _messages.StringField(3)
  title = _messages.StringField(4)


class IamFoldersLocationsGetRequest(_messages.Message):
  r"""A IamFoldersLocationsGetRequest object.

  Fields:
    name: Resource name for the location.
  """

  name = _messages.StringField(1, required=True)


class IamFoldersLocationsListLocationsRequest(_messages.Message):
  r"""A IamFoldersLocationsListLocationsRequest object.

  Fields:
    filter: A filter to narrow down results to a preferred subset. The
      filtering language accepts strings like `"displayName=tokyo"`, and is
      documented in more detail in [AIP-160](https://google.aip.dev/160).
    name: The resource that owns the locations collection, if applicable.
    pageSize: The maximum number of results to return. If not set, the service
      selects a default.
    pageToken: A page token received from the `next_page_token` field in the
      response. Send that page token to receive the subsequent page.
  """

  filter = _messages.StringField(1)
  name = _messages.StringField(2, required=True)
  pageSize = _messages.IntegerField(3, variant=_messages.Variant.INT32)
  pageToken = _messages.StringField(4)


class IamFoldersLocationsOperationsGetRequest(_messages.Message):
  r"""A IamFoldersLocationsOperationsGetRequest object.

  Fields:
    name: The name of the operation resource.
  """

  name = _messages.StringField(1, required=True)


class IamFoldersLocationsPoliciesCreateRequest(_messages.Message):
  r"""A IamFoldersLocationsPoliciesCreateRequest object.

  Fields:
    googleIamV3betaV3Policy: A GoogleIamV3betaV3Policy resource to be passed
      as the request body.
    parent: Required. The parent of the new Policy. The parent needs to follow
      formats below. `projects/{project_id}/locations/{location}`
      `projects/{project_number}/locations/{location}`
      `folders/{numeric_id}/locations/{location}`
      `organizations/{numeric_id}/locations/{location}` where the location is
      for the Policy.
    policyId: Required. The ID to use for this policy, which will become the
      final component of the policy's resource name. The ID must contain 3 to
      63 characters. It can contain lowercase letters and numbers, as well as
      dashes (`-`) and periods (`.`). The first character must be a lowercase
      letter.
    validateOnly: Optional. If set to true, the request is validated and the
      user is provided with expected result, but no actual change is made.
  """

  googleIamV3betaV3Policy = _messages.MessageField('GoogleIamV3betaV3Policy', 1)
  parent = _messages.StringField(2, required=True)
  policyId = _messages.StringField(3)
  validateOnly = _messages.BooleanField(4)


class IamFoldersLocationsPoliciesDeleteRequest(_messages.Message):
  r"""A IamFoldersLocationsPoliciesDeleteRequest object.

  Fields:
    etag: Optional. The expected etag of the policy to delete. If an `etag` is
      provided, the `etag` value must match the value that is stored in IAM.
      If the values don't match, the request fails with ABORTED status. If an
      `etag` is not provided, the policy will be deleted regardless of the
      existing policy data.
    force: Optional. If set to true, the request will force the deletion of
      the Policy even if there are PolicyBindings that refer to the Policy. If
      policy bindings are referenced by the policy, these bindings will have
      no effect in policy evaluation, and will be automatically deleted later.
    name: Required. The name of the policy to delete. The name needs to follow
      formats below.
      `projects/{project_id}/locations/{location}/policies/{policy_id}`
      `projects/{project_number}/locations/{location}/policies/{policy_id}`
      `folders/{numeric_id}/locations/{location}/policies/{policy_id}`
      `organizations/{numeric_id}/locations/{location}/policies/{policy_id}`
    validateOnly: Optional. If set to true, the request is validated and the
      user is provided with an expected result, but no actual change is made.
  """

  etag = _messages.StringField(1)
  force = _messages.BooleanField(2)
  name = _messages.StringField(3, required=True)
  validateOnly = _messages.BooleanField(4)


class IamFoldersLocationsPoliciesGetRequest(_messages.Message):
  r"""A IamFoldersLocationsPoliciesGetRequest object.

  Fields:
    name: Required. The resource name for the Policy to be retrieved. The name
      needs to follow formats below.
      `projects/{project_id}/locations/{location}/policies/{policy_id}`
      `projects/{project_number}/locations/{location}/policies/{policy_id}`
      `folders/{numeric_id}/locations/{location}/policies/{policy_id}`
      `organizations/{numeric_id}/locations/{location}/policies/{policy_id}`
  """

  name = _messages.StringField(1, required=True)


class IamFoldersLocationsPoliciesListRequest(_messages.Message):
  r"""A IamFoldersLocationsPoliciesListRequest object.

  Fields:
    pageSize: Optional. Requested page size. Server may return fewer policies
      than requested. If unspecified, server will pick an appropriate default.
    pageToken: Optional. A token identifying a page of results the server
      should return. returned from the previous call to `ListPolicies` method.
    parent: Required. Parent value for ListPoliciesRequest. The parent needs
      to follow formats below. `projects/{project_id}/locations/{location}`
      `projects/{project_number}/locations/{location}`
      `folders/{numeric_id}/locations/{location}`
      `organizations/{numeric_id}/locations/{location}`
  """

  pageSize = _messages.IntegerField(1, variant=_messages.Variant.INT32)
  pageToken = _messages.StringField(2)
  parent = _messages.StringField(3, required=True)


class IamFoldersLocationsPoliciesPatchRequest(_messages.Message):
  r"""A IamFoldersLocationsPoliciesPatchRequest object.

  Fields:
    googleIamV3betaV3Policy: A GoogleIamV3betaV3Policy resource to be passed
      as the request body.
    name: The resource name of the `Policy`, which must be globally unique.
      The name needs to follow formats below. This field is output_only in a
      CreatePolicyRequest. Only `global` location is supported.
      `projects/{project_id}/locations/{location}/policies/{policy_id}`
      `projects/{project_number}/locations/{location}/policies/{policy_id}`
      `folders/{numeric_id}/locations/{location}/policies/{policy_id}`
      `organizations/{numeric_id}/locations/{location}/policies/{policy_id}`
    updateMask: Optional. The fields to update.
    validateOnly: Optional. If set to true, the request is validated and the
      user is provided with expected result, but no actual change is made.
  """

  googleIamV3betaV3Policy = _messages.MessageField('GoogleIamV3betaV3Policy', 1)
  name = _messages.StringField(2, required=True)
  updateMask = _messages.StringField(3)
  validateOnly = _messages.BooleanField(4)


class IamFoldersLocationsPolicyBindingsCreateRequest(_messages.Message):
  r"""A IamFoldersLocationsPolicyBindingsCreateRequest object.

  Fields:
    googleIamV3betaPolicyBinding: A GoogleIamV3betaPolicyBinding resource to
      be passed as the request body.
    parent: Required. The parent resource where this policy binding will be
      created. The binding parent is the closest CRM resource (i.e., Project,
      Folder or Organization) to the binding target. Format:
      `projects/{project_id}/locations/{location}`
      `projects/{project_number}/locations/{location}`
      `folders/{folder_id}/locations/{location}`
      `organizations/{organization_id}/locations/{location}`
    policyBindingId: Required. The ID to use for the policy binding, which
      will become the final component of the policy binding's resource name.
      This value must start with a lowercase letter followed by up to 62
      lowercase letters, numbers, hyphens, or dots. Pattern, /a-z{2,62}/.
    validateOnly: Optional. If set, validate the request and preview the
      creation, but do not actually post it.
  """

  googleIamV3betaPolicyBinding = _messages.MessageField('GoogleIamV3betaPolicyBinding', 1)
  parent = _messages.StringField(2, required=True)
  policyBindingId = _messages.StringField(3)
  validateOnly = _messages.BooleanField(4)


class IamFoldersLocationsPolicyBindingsDeleteRequest(_messages.Message):
  r"""A IamFoldersLocationsPolicyBindingsDeleteRequest object.

  Fields:
    etag: Optional. The etag of the policy binding. If this is provided, it
      must match the server's etag.
    name: Required. The name of the policy binding to delete. Format: `project
      s/{project_id}/locations/{location}/policyBindings/{policy_binding_id}`
      `projects/{project_number}/locations/{location}/policyBindings/{policy_b
      inding_id}` `folders/{folder_id}/locations/{location}/policyBindings/{po
      licy_binding_id}` `organizations/{organization_id}/locations/{location}/
      policyBindings/{policy_binding_id}`
    validateOnly: Optional. If set, validate the request and preview the
      deletion, but do not actually post it.
  """

  etag = _messages.StringField(1)
  name = _messages.StringField(2, required=True)
  validateOnly = _messages.BooleanField(3)


class IamFoldersLocationsPolicyBindingsGetRequest(_messages.Message):
  r"""A IamFoldersLocationsPolicyBindingsGetRequest object.

  Fields:
    name: Required. The name of the policy binding to retrieve. Format: `proje
      cts/{project_id}/locations/{location}/policyBindings/{policy_binding_id}
      ` `projects/{project_number}/locations/{location}/policyBindings/{policy
      _binding_id}` `folders/{folder_id}/locations/{location}/policyBindings/{
      policy_binding_id}` `organizations/{organization_id}/locations/{location
      }/policyBindings/{policy_binding_id}`
  """

  name = _messages.StringField(1, required=True)


class IamFoldersLocationsPolicyBindingsListRequest(_messages.Message):
  r"""A IamFoldersLocationsPolicyBindingsListRequest object.

  Fields:
    filter: Optional. An expression for filtering the results of the request.
      Filter rules are case insensitive. Some eligible fields for filtering
      are: + `target` + `policy` Some examples of filter queries: | Query |
      Description | |------------------|--------------------------------------
      ---------------| | target:how* | The binding target's name starts with
      "how ". | | target:howl | The binding target's name is `howl`. | |
      policy:howl | The binding policy's name is 'howl'. |
    pageSize: Optional. The maximum number of policy bindings to return. The
      service may return fewer than this value. If unspecified, at most 50
      policy bindings will be returned. The maximum value is 1000; values
      above 1000 will be coerced to 1000.
    pageToken: Optional. A page token, received from a previous
      `ListPolicyBindings` call. Provide this to retrieve the subsequent page.
      When paginating, all other parameters provided to `ListPolicyBindings`
      must match the call that provided the page token.
    parent: Required. The parent resource, which owns the collection of policy
      bindings. Format: `projects/{project_id}/locations/{location}`
      `projects/{project_number}/locations/{location}`
      `folders/{folder_id}/locations/{location}`
      `organizations/{organization_id}/locations/{location}`
  """

  filter = _messages.StringField(1)
  pageSize = _messages.IntegerField(2, variant=_messages.Variant.INT32)
  pageToken = _messages.StringField(3)
  parent = _messages.StringField(4, required=True)


class IamFoldersLocationsPolicyBindingsPatchRequest(_messages.Message):
  r"""A IamFoldersLocationsPolicyBindingsPatchRequest object.

  Fields:
    googleIamV3betaPolicyBinding: A GoogleIamV3betaPolicyBinding resource to
      be passed as the request body.
    name: Identifier. The resource name of the policy binding. The binding
      parent is the closest CRM resource (i.e., Project, Folder or
      Organization) to the binding target. Format: `projects/{project_id}/loca
      tions/{location}/policyBindings/{policy_binding_id}` `projects/{project_
      number}/locations/{location}/policyBindings/{policy_binding_id}` `folder
      s/{folder_id}/locations/{location}/policyBindings/{policy_binding_id}` `
      organizations/{organization_id}/locations/{location}/policyBindings/{pol
      icy_binding_id}`
    updateMask: Optional. The list of fields to update
    validateOnly: Optional. If set, validate the request and preview the
      update, but do not actually post it.
  """

  googleIamV3betaPolicyBinding = _messages.MessageField('GoogleIamV3betaPolicyBinding', 1)
  name = _messages.StringField(2, required=True)
  updateMask = _messages.StringField(3)
  validateOnly = _messages.BooleanField(4)


class IamFoldersLocationsPolicyBindingsSearchTargetPolicyBindingsRequest(_messages.Message):
  r"""A IamFoldersLocationsPolicyBindingsSearchTargetPolicyBindingsRequest
  object.

  Fields:
    pageSize: Optional. The maximum number of policy bindings to return. The
      service may return fewer than this value. If unspecified, at most 50
      policy bindings will be returned. The maximum value is 1000; values
      above 1000 will be coerced to 1000.
    pageToken: Optional. A page token, received from a previous
      `SearchTargetPolicyBindingsRequest` call. Provide this to retrieve the
      subsequent page. When paginating, all other parameters provided to
      `SearchTargetPolicyBindingsRequest` must match the call that provided
      the page token.
    parent: Required. The parent resource where this search will be performed.
      This should be the nearest CRM resource to the target. Format:
      `projects/{project_id}/locations/{location}`
      `projects/{project_number}/locations/{location}`
      `folders/{folder_id}/locations/{location}`
      `organizations/{organization_id}/locations/{location}`
    target: Required. The target resource, which is bound to the policy in the
      binding. Format:
      `//iam.googleapis.com/locations/global/workforcePools/POOL_ID` `//iam.go
      ogleapis.com/projects/PROJECT_NUMBER/locations/global/workloadIdentityPo
      ols/POOL_ID`
      `//iam.googleapis.com/locations/global/workspace/WORKSPACE_ID`
      `//cloudresourcemanager.googleapis.com/projects/{project_number}`
      `//cloudresourcemanager.googleapis.com/folders/{folder_id}`
      `//cloudresourcemanager.googleapis.com/organizations/{organization_id}`
  """

  pageSize = _messages.IntegerField(1, variant=_messages.Variant.INT32)
  pageToken = _messages.StringField(2)
  parent = _messages.StringField(3, required=True)
  target = _messages.StringField(4)


class IamOrganizationsLocationsGetRequest(_messages.Message):
  r"""A IamOrganizationsLocationsGetRequest object.

  Fields:
    name: Resource name for the location.
  """

  name = _messages.StringField(1, required=True)


class IamOrganizationsLocationsListLocationsRequest(_messages.Message):
  r"""A IamOrganizationsLocationsListLocationsRequest object.

  Fields:
    filter: A filter to narrow down results to a preferred subset. The
      filtering language accepts strings like `"displayName=tokyo"`, and is
      documented in more detail in [AIP-160](https://google.aip.dev/160).
    name: The resource that owns the locations collection, if applicable.
    pageSize: The maximum number of results to return. If not set, the service
      selects a default.
    pageToken: A page token received from the `next_page_token` field in the
      response. Send that page token to receive the subsequent page.
  """

  filter = _messages.StringField(1)
  name = _messages.StringField(2, required=True)
  pageSize = _messages.IntegerField(3, variant=_messages.Variant.INT32)
  pageToken = _messages.StringField(4)


class IamOrganizationsLocationsOperationsGetRequest(_messages.Message):
  r"""A IamOrganizationsLocationsOperationsGetRequest object.

  Fields:
    name: The name of the operation resource.
  """

  name = _messages.StringField(1, required=True)


class IamOrganizationsLocationsPoliciesCreateRequest(_messages.Message):
  r"""A IamOrganizationsLocationsPoliciesCreateRequest object.

  Fields:
    googleIamV3betaV3Policy: A GoogleIamV3betaV3Policy resource to be passed
      as the request body.
    parent: Required. The parent of the new Policy. The parent needs to follow
      formats below. `projects/{project_id}/locations/{location}`
      `projects/{project_number}/locations/{location}`
      `folders/{numeric_id}/locations/{location}`
      `organizations/{numeric_id}/locations/{location}` where the location is
      for the Policy.
    policyId: Required. The ID to use for this policy, which will become the
      final component of the policy's resource name. The ID must contain 3 to
      63 characters. It can contain lowercase letters and numbers, as well as
      dashes (`-`) and periods (`.`). The first character must be a lowercase
      letter.
    validateOnly: Optional. If set to true, the request is validated and the
      user is provided with expected result, but no actual change is made.
  """

  googleIamV3betaV3Policy = _messages.MessageField('GoogleIamV3betaV3Policy', 1)
  parent = _messages.StringField(2, required=True)
  policyId = _messages.StringField(3)
  validateOnly = _messages.BooleanField(4)


class IamOrganizationsLocationsPoliciesDeleteRequest(_messages.Message):
  r"""A IamOrganizationsLocationsPoliciesDeleteRequest object.

  Fields:
    etag: Optional. The expected etag of the policy to delete. If an `etag` is
      provided, the `etag` value must match the value that is stored in IAM.
      If the values don't match, the request fails with ABORTED status. If an
      `etag` is not provided, the policy will be deleted regardless of the
      existing policy data.
    force: Optional. If set to true, the request will force the deletion of
      the Policy even if there are PolicyBindings that refer to the Policy. If
      policy bindings are referenced by the policy, these bindings will have
      no effect in policy evaluation, and will be automatically deleted later.
    name: Required. The name of the policy to delete. The name needs to follow
      formats below.
      `projects/{project_id}/locations/{location}/policies/{policy_id}`
      `projects/{project_number}/locations/{location}/policies/{policy_id}`
      `folders/{numeric_id}/locations/{location}/policies/{policy_id}`
      `organizations/{numeric_id}/locations/{location}/policies/{policy_id}`
    validateOnly: Optional. If set to true, the request is validated and the
      user is provided with an expected result, but no actual change is made.
  """

  etag = _messages.StringField(1)
  force = _messages.BooleanField(2)
  name = _messages.StringField(3, required=True)
  validateOnly = _messages.BooleanField(4)


class IamOrganizationsLocationsPoliciesGetRequest(_messages.Message):
  r"""A IamOrganizationsLocationsPoliciesGetRequest object.

  Fields:
    name: Required. The resource name for the Policy to be retrieved. The name
      needs to follow formats below.
      `projects/{project_id}/locations/{location}/policies/{policy_id}`
      `projects/{project_number}/locations/{location}/policies/{policy_id}`
      `folders/{numeric_id}/locations/{location}/policies/{policy_id}`
      `organizations/{numeric_id}/locations/{location}/policies/{policy_id}`
  """

  name = _messages.StringField(1, required=True)


class IamOrganizationsLocationsPoliciesListRequest(_messages.Message):
  r"""A IamOrganizationsLocationsPoliciesListRequest object.

  Fields:
    pageSize: Optional. Requested page size. Server may return fewer policies
      than requested. If unspecified, server will pick an appropriate default.
    pageToken: Optional. A token identifying a page of results the server
      should return. returned from the previous call to `ListPolicies` method.
    parent: Required. Parent value for ListPoliciesRequest. The parent needs
      to follow formats below. `projects/{project_id}/locations/{location}`
      `projects/{project_number}/locations/{location}`
      `folders/{numeric_id}/locations/{location}`
      `organizations/{numeric_id}/locations/{location}`
  """

  pageSize = _messages.IntegerField(1, variant=_messages.Variant.INT32)
  pageToken = _messages.StringField(2)
  parent = _messages.StringField(3, required=True)


class IamOrganizationsLocationsPoliciesPatchRequest(_messages.Message):
  r"""A IamOrganizationsLocationsPoliciesPatchRequest object.

  Fields:
    googleIamV3betaV3Policy: A GoogleIamV3betaV3Policy resource to be passed
      as the request body.
    name: The resource name of the `Policy`, which must be globally unique.
      The name needs to follow formats below. This field is output_only in a
      CreatePolicyRequest. Only `global` location is supported.
      `projects/{project_id}/locations/{location}/policies/{policy_id}`
      `projects/{project_number}/locations/{location}/policies/{policy_id}`
      `folders/{numeric_id}/locations/{location}/policies/{policy_id}`
      `organizations/{numeric_id}/locations/{location}/policies/{policy_id}`
    updateMask: Optional. The fields to update.
    validateOnly: Optional. If set to true, the request is validated and the
      user is provided with expected result, but no actual change is made.
  """

  googleIamV3betaV3Policy = _messages.MessageField('GoogleIamV3betaV3Policy', 1)
  name = _messages.StringField(2, required=True)
  updateMask = _messages.StringField(3)
  validateOnly = _messages.BooleanField(4)


class IamOrganizationsLocationsPolicyBindingsCreateRequest(_messages.Message):
  r"""A IamOrganizationsLocationsPolicyBindingsCreateRequest object.

  Fields:
    googleIamV3betaPolicyBinding: A GoogleIamV3betaPolicyBinding resource to
      be passed as the request body.
    parent: Required. The parent resource where this policy binding will be
      created. The binding parent is the closest CRM resource (i.e., Project,
      Folder or Organization) to the binding target. Format:
      `projects/{project_id}/locations/{location}`
      `projects/{project_number}/locations/{location}`
      `folders/{folder_id}/locations/{location}`
      `organizations/{organization_id}/locations/{location}`
    policyBindingId: Required. The ID to use for the policy binding, which
      will become the final component of the policy binding's resource name.
      This value must start with a lowercase letter followed by up to 62
      lowercase letters, numbers, hyphens, or dots. Pattern, /a-z{2,62}/.
    validateOnly: Optional. If set, validate the request and preview the
      creation, but do not actually post it.
  """

  googleIamV3betaPolicyBinding = _messages.MessageField('GoogleIamV3betaPolicyBinding', 1)
  parent = _messages.StringField(2, required=True)
  policyBindingId = _messages.StringField(3)
  validateOnly = _messages.BooleanField(4)


class IamOrganizationsLocationsPolicyBindingsDeleteRequest(_messages.Message):
  r"""A IamOrganizationsLocationsPolicyBindingsDeleteRequest object.

  Fields:
    etag: Optional. The etag of the policy binding. If this is provided, it
      must match the server's etag.
    name: Required. The name of the policy binding to delete. Format: `project
      s/{project_id}/locations/{location}/policyBindings/{policy_binding_id}`
      `projects/{project_number}/locations/{location}/policyBindings/{policy_b
      inding_id}` `folders/{folder_id}/locations/{location}/policyBindings/{po
      licy_binding_id}` `organizations/{organization_id}/locations/{location}/
      policyBindings/{policy_binding_id}`
    validateOnly: Optional. If set, validate the request and preview the
      deletion, but do not actually post it.
  """

  etag = _messages.StringField(1)
  name = _messages.StringField(2, required=True)
  validateOnly = _messages.BooleanField(3)


class IamOrganizationsLocationsPolicyBindingsGetRequest(_messages.Message):
  r"""A IamOrganizationsLocationsPolicyBindingsGetRequest object.

  Fields:
    name: Required. The name of the policy binding to retrieve. Format: `proje
      cts/{project_id}/locations/{location}/policyBindings/{policy_binding_id}
      ` `projects/{project_number}/locations/{location}/policyBindings/{policy
      _binding_id}` `folders/{folder_id}/locations/{location}/policyBindings/{
      policy_binding_id}` `organizations/{organization_id}/locations/{location
      }/policyBindings/{policy_binding_id}`
  """

  name = _messages.StringField(1, required=True)


class IamOrganizationsLocationsPolicyBindingsListRequest(_messages.Message):
  r"""A IamOrganizationsLocationsPolicyBindingsListRequest object.

  Fields:
    filter: Optional. An expression for filtering the results of the request.
      Filter rules are case insensitive. Some eligible fields for filtering
      are: + `target` + `policy` Some examples of filter queries: | Query |
      Description | |------------------|--------------------------------------
      ---------------| | target:how* | The binding target's name starts with
      "how ". | | target:howl | The binding target's name is `howl`. | |
      policy:howl | The binding policy's name is 'howl'. |
    pageSize: Optional. The maximum number of policy bindings to return. The
      service may return fewer than this value. If unspecified, at most 50
      policy bindings will be returned. The maximum value is 1000; values
      above 1000 will be coerced to 1000.
    pageToken: Optional. A page token, received from a previous
      `ListPolicyBindings` call. Provide this to retrieve the subsequent page.
      When paginating, all other parameters provided to `ListPolicyBindings`
      must match the call that provided the page token.
    parent: Required. The parent resource, which owns the collection of policy
      bindings. Format: `projects/{project_id}/locations/{location}`
      `projects/{project_number}/locations/{location}`
      `folders/{folder_id}/locations/{location}`
      `organizations/{organization_id}/locations/{location}`
  """

  filter = _messages.StringField(1)
  pageSize = _messages.IntegerField(2, variant=_messages.Variant.INT32)
  pageToken = _messages.StringField(3)
  parent = _messages.StringField(4, required=True)


class IamOrganizationsLocationsPolicyBindingsPatchRequest(_messages.Message):
  r"""A IamOrganizationsLocationsPolicyBindingsPatchRequest object.

  Fields:
    googleIamV3betaPolicyBinding: A GoogleIamV3betaPolicyBinding resource to
      be passed as the request body.
    name: Identifier. The resource name of the policy binding. The binding
      parent is the closest CRM resource (i.e., Project, Folder or
      Organization) to the binding target. Format: `projects/{project_id}/loca
      tions/{location}/policyBindings/{policy_binding_id}` `projects/{project_
      number}/locations/{location}/policyBindings/{policy_binding_id}` `folder
      s/{folder_id}/locations/{location}/policyBindings/{policy_binding_id}` `
      organizations/{organization_id}/locations/{location}/policyBindings/{pol
      icy_binding_id}`
    updateMask: Optional. The list of fields to update
    validateOnly: Optional. If set, validate the request and preview the
      update, but do not actually post it.
  """

  googleIamV3betaPolicyBinding = _messages.MessageField('GoogleIamV3betaPolicyBinding', 1)
  name = _messages.StringField(2, required=True)
  updateMask = _messages.StringField(3)
  validateOnly = _messages.BooleanField(4)


class IamOrganizationsLocationsPolicyBindingsSearchTargetPolicyBindingsRequest(_messages.Message):
  r"""A
  IamOrganizationsLocationsPolicyBindingsSearchTargetPolicyBindingsRequest
  object.

  Fields:
    pageSize: Optional. The maximum number of policy bindings to return. The
      service may return fewer than this value. If unspecified, at most 50
      policy bindings will be returned. The maximum value is 1000; values
      above 1000 will be coerced to 1000.
    pageToken: Optional. A page token, received from a previous
      `SearchTargetPolicyBindingsRequest` call. Provide this to retrieve the
      subsequent page. When paginating, all other parameters provided to
      `SearchTargetPolicyBindingsRequest` must match the call that provided
      the page token.
    parent: Required. The parent resource where this search will be performed.
      This should be the nearest CRM resource to the target. Format:
      `projects/{project_id}/locations/{location}`
      `projects/{project_number}/locations/{location}`
      `folders/{folder_id}/locations/{location}`
      `organizations/{organization_id}/locations/{location}`
    target: Required. The target resource, which is bound to the policy in the
      binding. Format:
      `//iam.googleapis.com/locations/global/workforcePools/POOL_ID` `//iam.go
      ogleapis.com/projects/PROJECT_NUMBER/locations/global/workloadIdentityPo
      ols/POOL_ID`
      `//iam.googleapis.com/locations/global/workspace/WORKSPACE_ID`
      `//cloudresourcemanager.googleapis.com/projects/{project_number}`
      `//cloudresourcemanager.googleapis.com/folders/{folder_id}`
      `//cloudresourcemanager.googleapis.com/organizations/{organization_id}`
  """

  pageSize = _messages.IntegerField(1, variant=_messages.Variant.INT32)
  pageToken = _messages.StringField(2)
  parent = _messages.StringField(3, required=True)
  target = _messages.StringField(4)


class IamOrganizationsLocationsPrincipalAccessBoundaryPoliciesCreateRequest(_messages.Message):
  r"""A IamOrganizationsLocationsPrincipalAccessBoundaryPoliciesCreateRequest
  object.

  Fields:
    googleIamV3betaPrincipalAccessBoundaryPolicy: A
      GoogleIamV3betaPrincipalAccessBoundaryPolicy resource to be passed as
      the request body.
    parent: Required. The parent resource where this principal access boundary
      policy will be created. Only organization is supported now. Format:
      `organizations/{organization_id}/locations/{location}`
    principalAccessBoundaryPolicyId: Required. The ID to use for the principal
      access boundary policy, which will become the final component of the
      principal access boundary policy's resource name. This value must start
      with a lowercase letter followed by up to 62 lowercase letters, numbers,
      hyphens, or dots. Pattern, /a-z{2,62}/.
    validateOnly: Optional. If set, validate the request and preview the
      creation, but do not actually post it.
  """

  googleIamV3betaPrincipalAccessBoundaryPolicy = _messages.MessageField('GoogleIamV3betaPrincipalAccessBoundaryPolicy', 1)
  parent = _messages.StringField(2, required=True)
  principalAccessBoundaryPolicyId = _messages.StringField(3)
  validateOnly = _messages.BooleanField(4)


class IamOrganizationsLocationsPrincipalAccessBoundaryPoliciesDeleteRequest(_messages.Message):
  r"""A IamOrganizationsLocationsPrincipalAccessBoundaryPoliciesDeleteRequest
  object.

  Fields:
    etag: Optional. The etag of the principal access boundary policy. If this
      is provided, it must match the server's etag.
    force: Optional. If set to true, the request will force the deletion of
      the Policy even if the Policy references PolicyBindings.
    name: Required. The name of the principal access boundary policy to
      delete. Format: `organizations/{organization_id}/locations/{location}/pr
      incipalAccessBoundaryPolicies/{principal_access_boundary_policy_id}`
    validateOnly: Optional. If set, validate the request and preview the
      deletion, but do not actually post it.
  """

  etag = _messages.StringField(1)
  force = _messages.BooleanField(2)
  name = _messages.StringField(3, required=True)
  validateOnly = _messages.BooleanField(4)


class IamOrganizationsLocationsPrincipalAccessBoundaryPoliciesGetRequest(_messages.Message):
  r"""A IamOrganizationsLocationsPrincipalAccessBoundaryPoliciesGetRequest
  object.

  Fields:
    name: Required. The name of the principal access boundary policy to
      retrieve. Format: `organizations/{organization_id}/locations/{location}/
      principalAccessBoundaryPolicies/{principal_access_boundary_policy_id}`
  """

  name = _messages.StringField(1, required=True)


class IamOrganizationsLocationsPrincipalAccessBoundaryPoliciesListRequest(_messages.Message):
  r"""A IamOrganizationsLocationsPrincipalAccessBoundaryPoliciesListRequest
  object.

  Fields:
    pageSize: Optional. The maximum number of principal access boundary
      policies to return. The service may return fewer than this value. If
      unspecified, at most 50 principal access boundary policies will be
      returned. The maximum value is 1000; values above 1000 will be coerced
      to 1000.
    pageToken: Optional. A page token, received from a previous
      `ListPrincipalAccessBoundaryPolicies` call. Provide this to retrieve the
      subsequent page. When paginating, all other parameters provided to
      `ListPrincipalAccessBoundaryPolicies` must match the call that provided
      the page token.
    parent: Required. The parent resource, which owns the collection of
      principal access boundary policies. Format:
      `organizations/{organization_id}/locations/{location}`
  """

  pageSize = _messages.IntegerField(1, variant=_messages.Variant.INT32)
  pageToken = _messages.StringField(2)
  parent = _messages.StringField(3, required=True)


class IamOrganizationsLocationsPrincipalAccessBoundaryPoliciesPatchRequest(_messages.Message):
  r"""A IamOrganizationsLocationsPrincipalAccessBoundaryPoliciesPatchRequest
  object.

  Fields:
    googleIamV3betaPrincipalAccessBoundaryPolicy: A
      GoogleIamV3betaPrincipalAccessBoundaryPolicy resource to be passed as
      the request body.
    name: Identifier. The resource name of the principal access boundary
      policy. The following format is supported: `organizations/{organization_
      id}/locations/{location}/principalAccessBoundaryPolicies/{policy_id}`
    updateMask: Optional. The list of fields to update
    validateOnly: Optional. If set, validate the request and preview the
      update, but do not actually post it.
  """

  googleIamV3betaPrincipalAccessBoundaryPolicy = _messages.MessageField('GoogleIamV3betaPrincipalAccessBoundaryPolicy', 1)
  name = _messages.StringField(2, required=True)
  updateMask = _messages.StringField(3)
  validateOnly = _messages.BooleanField(4)


class IamOrganizationsLocationsPrincipalAccessBoundaryPoliciesSearchPolicyBindingsRequest(_messages.Message):
  r"""A IamOrganizationsLocationsPrincipalAccessBoundaryPoliciesSearchPolicyBi
  ndingsRequest object.

  Fields:
    name: Required. The name of the principal access boundary policy. Format:
      `organizations/{organization_id}/locations/{location}/principalAccessBou
      ndaryPolicies/{principal_access_boundary_policy_id}`
    pageSize: Optional. The maximum number of policy bindings to return. The
      service may return fewer than this value. If unspecified, at most 50
      policy bindings will be returned. The maximum value is 1000; values
      above 1000 will be coerced to 1000.
    pageToken: Optional. A page token, received from a previous
      `SearchPrincipalAccessBoundaryPolicyBindingsRequest` call. Provide this
      to retrieve the subsequent page. When paginating, all other parameters
      provided to `SearchPrincipalAccessBoundaryPolicyBindingsRequest` must
      match the call that provided the page token.
  """

  name = _messages.StringField(1, required=True)
  pageSize = _messages.IntegerField(2, variant=_messages.Variant.INT32)
  pageToken = _messages.StringField(3)


class IamProjectsGetLocationsRequest(_messages.Message):
  r"""A IamProjectsGetLocationsRequest object.

  Fields:
    name: Resource name for the location.
  """

  name = _messages.StringField(1, required=True)


class IamProjectsLocationsListRequest(_messages.Message):
  r"""A IamProjectsLocationsListRequest object.

  Fields:
    filter: A filter to narrow down results to a preferred subset. The
      filtering language accepts strings like `"displayName=tokyo"`, and is
      documented in more detail in [AIP-160](https://google.aip.dev/160).
    name: The resource that owns the locations collection, if applicable.
    pageSize: The maximum number of results to return. If not set, the service
      selects a default.
    pageToken: A page token received from the `next_page_token` field in the
      response. Send that page token to receive the subsequent page.
  """

  filter = _messages.StringField(1)
  name = _messages.StringField(2, required=True)
  pageSize = _messages.IntegerField(3, variant=_messages.Variant.INT32)
  pageToken = _messages.StringField(4)


class IamProjectsLocationsOperationsGetRequest(_messages.Message):
  r"""A IamProjectsLocationsOperationsGetRequest object.

  Fields:
    name: The name of the operation resource.
  """

  name = _messages.StringField(1, required=True)


class IamProjectsLocationsPoliciesCreateRequest(_messages.Message):
  r"""A IamProjectsLocationsPoliciesCreateRequest object.

  Fields:
    googleIamV3betaV3Policy: A GoogleIamV3betaV3Policy resource to be passed
      as the request body.
    parent: Required. The parent of the new Policy. The parent needs to follow
      formats below. `projects/{project_id}/locations/{location}`
      `projects/{project_number}/locations/{location}`
      `folders/{numeric_id}/locations/{location}`
      `organizations/{numeric_id}/locations/{location}` where the location is
      for the Policy.
    policyId: Required. The ID to use for this policy, which will become the
      final component of the policy's resource name. The ID must contain 3 to
      63 characters. It can contain lowercase letters and numbers, as well as
      dashes (`-`) and periods (`.`). The first character must be a lowercase
      letter.
    validateOnly: Optional. If set to true, the request is validated and the
      user is provided with expected result, but no actual change is made.
  """

  googleIamV3betaV3Policy = _messages.MessageField('GoogleIamV3betaV3Policy', 1)
  parent = _messages.StringField(2, required=True)
  policyId = _messages.StringField(3)
  validateOnly = _messages.BooleanField(4)


class IamProjectsLocationsPoliciesDeleteRequest(_messages.Message):
  r"""A IamProjectsLocationsPoliciesDeleteRequest object.

  Fields:
    etag: Optional. The expected etag of the policy to delete. If an `etag` is
      provided, the `etag` value must match the value that is stored in IAM.
      If the values don't match, the request fails with ABORTED status. If an
      `etag` is not provided, the policy will be deleted regardless of the
      existing policy data.
    force: Optional. If set to true, the request will force the deletion of
      the Policy even if there are PolicyBindings that refer to the Policy. If
      policy bindings are referenced by the policy, these bindings will have
      no effect in policy evaluation, and will be automatically deleted later.
    name: Required. The name of the policy to delete. The name needs to follow
      formats below.
      `projects/{project_id}/locations/{location}/policies/{policy_id}`
      `projects/{project_number}/locations/{location}/policies/{policy_id}`
      `folders/{numeric_id}/locations/{location}/policies/{policy_id}`
      `organizations/{numeric_id}/locations/{location}/policies/{policy_id}`
    validateOnly: Optional. If set to true, the request is validated and the
      user is provided with an expected result, but no actual change is made.
  """

  etag = _messages.StringField(1)
  force = _messages.BooleanField(2)
  name = _messages.StringField(3, required=True)
  validateOnly = _messages.BooleanField(4)


class IamProjectsLocationsPoliciesGetRequest(_messages.Message):
  r"""A IamProjectsLocationsPoliciesGetRequest object.

  Fields:
    name: Required. The resource name for the Policy to be retrieved. The name
      needs to follow formats below.
      `projects/{project_id}/locations/{location}/policies/{policy_id}`
      `projects/{project_number}/locations/{location}/policies/{policy_id}`
      `folders/{numeric_id}/locations/{location}/policies/{policy_id}`
      `organizations/{numeric_id}/locations/{location}/policies/{policy_id}`
  """

  name = _messages.StringField(1, required=True)


class IamProjectsLocationsPoliciesListRequest(_messages.Message):
  r"""A IamProjectsLocationsPoliciesListRequest object.

  Fields:
    pageSize: Optional. Requested page size. Server may return fewer policies
      than requested. If unspecified, server will pick an appropriate default.
    pageToken: Optional. A token identifying a page of results the server
      should return. returned from the previous call to `ListPolicies` method.
    parent: Required. Parent value for ListPoliciesRequest. The parent needs
      to follow formats below. `projects/{project_id}/locations/{location}`
      `projects/{project_number}/locations/{location}`
      `folders/{numeric_id}/locations/{location}`
      `organizations/{numeric_id}/locations/{location}`
  """

  pageSize = _messages.IntegerField(1, variant=_messages.Variant.INT32)
  pageToken = _messages.StringField(2)
  parent = _messages.StringField(3, required=True)


class IamProjectsLocationsPoliciesPatchRequest(_messages.Message):
  r"""A IamProjectsLocationsPoliciesPatchRequest object.

  Fields:
    googleIamV3betaV3Policy: A GoogleIamV3betaV3Policy resource to be passed
      as the request body.
    name: The resource name of the `Policy`, which must be globally unique.
      The name needs to follow formats below. This field is output_only in a
      CreatePolicyRequest. Only `global` location is supported.
      `projects/{project_id}/locations/{location}/policies/{policy_id}`
      `projects/{project_number}/locations/{location}/policies/{policy_id}`
      `folders/{numeric_id}/locations/{location}/policies/{policy_id}`
      `organizations/{numeric_id}/locations/{location}/policies/{policy_id}`
    updateMask: Optional. The fields to update.
    validateOnly: Optional. If set to true, the request is validated and the
      user is provided with expected result, but no actual change is made.
  """

  googleIamV3betaV3Policy = _messages.MessageField('GoogleIamV3betaV3Policy', 1)
  name = _messages.StringField(2, required=True)
  updateMask = _messages.StringField(3)
  validateOnly = _messages.BooleanField(4)


class IamProjectsLocationsPolicyBindingsCreateRequest(_messages.Message):
  r"""A IamProjectsLocationsPolicyBindingsCreateRequest object.

  Fields:
    googleIamV3betaPolicyBinding: A GoogleIamV3betaPolicyBinding resource to
      be passed as the request body.
    parent: Required. The parent resource where this policy binding will be
      created. The binding parent is the closest CRM resource (i.e., Project,
      Folder or Organization) to the binding target. Format:
      `projects/{project_id}/locations/{location}`
      `projects/{project_number}/locations/{location}`
      `folders/{folder_id}/locations/{location}`
      `organizations/{organization_id}/locations/{location}`
    policyBindingId: Required. The ID to use for the policy binding, which
      will become the final component of the policy binding's resource name.
      This value must start with a lowercase letter followed by up to 62
      lowercase letters, numbers, hyphens, or dots. Pattern, /a-z{2,62}/.
    validateOnly: Optional. If set, validate the request and preview the
      creation, but do not actually post it.
  """

  googleIamV3betaPolicyBinding = _messages.MessageField('GoogleIamV3betaPolicyBinding', 1)
  parent = _messages.StringField(2, required=True)
  policyBindingId = _messages.StringField(3)
  validateOnly = _messages.BooleanField(4)


class IamProjectsLocationsPolicyBindingsDeleteRequest(_messages.Message):
  r"""A IamProjectsLocationsPolicyBindingsDeleteRequest object.

  Fields:
    etag: Optional. The etag of the policy binding. If this is provided, it
      must match the server's etag.
    name: Required. The name of the policy binding to delete. Format: `project
      s/{project_id}/locations/{location}/policyBindings/{policy_binding_id}`
      `projects/{project_number}/locations/{location}/policyBindings/{policy_b
      inding_id}` `folders/{folder_id}/locations/{location}/policyBindings/{po
      licy_binding_id}` `organizations/{organization_id}/locations/{location}/
      policyBindings/{policy_binding_id}`
    validateOnly: Optional. If set, validate the request and preview the
      deletion, but do not actually post it.
  """

  etag = _messages.StringField(1)
  name = _messages.StringField(2, required=True)
  validateOnly = _messages.BooleanField(3)


class IamProjectsLocationsPolicyBindingsGetRequest(_messages.Message):
  r"""A IamProjectsLocationsPolicyBindingsGetRequest object.

  Fields:
    name: Required. The name of the policy binding to retrieve. Format: `proje
      cts/{project_id}/locations/{location}/policyBindings/{policy_binding_id}
      ` `projects/{project_number}/locations/{location}/policyBindings/{policy
      _binding_id}` `folders/{folder_id}/locations/{location}/policyBindings/{
      policy_binding_id}` `organizations/{organization_id}/locations/{location
      }/policyBindings/{policy_binding_id}`
  """

  name = _messages.StringField(1, required=True)


class IamProjectsLocationsPolicyBindingsListRequest(_messages.Message):
  r"""A IamProjectsLocationsPolicyBindingsListRequest object.

  Fields:
    filter: Optional. An expression for filtering the results of the request.
      Filter rules are case insensitive. Some eligible fields for filtering
      are: + `target` + `policy` Some examples of filter queries: | Query |
      Description | |------------------|--------------------------------------
      ---------------| | target:how* | The binding target's name starts with
      "how ". | | target:howl | The binding target's name is `howl`. | |
      policy:howl | The binding policy's name is 'howl'. |
    pageSize: Optional. The maximum number of policy bindings to return. The
      service may return fewer than this value. If unspecified, at most 50
      policy bindings will be returned. The maximum value is 1000; values
      above 1000 will be coerced to 1000.
    pageToken: Optional. A page token, received from a previous
      `ListPolicyBindings` call. Provide this to retrieve the subsequent page.
      When paginating, all other parameters provided to `ListPolicyBindings`
      must match the call that provided the page token.
    parent: Required. The parent resource, which owns the collection of policy
      bindings. Format: `projects/{project_id}/locations/{location}`
      `projects/{project_number}/locations/{location}`
      `folders/{folder_id}/locations/{location}`
      `organizations/{organization_id}/locations/{location}`
  """

  filter = _messages.StringField(1)
  pageSize = _messages.IntegerField(2, variant=_messages.Variant.INT32)
  pageToken = _messages.StringField(3)
  parent = _messages.StringField(4, required=True)


class IamProjectsLocationsPolicyBindingsPatchRequest(_messages.Message):
  r"""A IamProjectsLocationsPolicyBindingsPatchRequest object.

  Fields:
    googleIamV3betaPolicyBinding: A GoogleIamV3betaPolicyBinding resource to
      be passed as the request body.
    name: Identifier. The resource name of the policy binding. The binding
      parent is the closest CRM resource (i.e., Project, Folder or
      Organization) to the binding target. Format: `projects/{project_id}/loca
      tions/{location}/policyBindings/{policy_binding_id}` `projects/{project_
      number}/locations/{location}/policyBindings/{policy_binding_id}` `folder
      s/{folder_id}/locations/{location}/policyBindings/{policy_binding_id}` `
      organizations/{organization_id}/locations/{location}/policyBindings/{pol
      icy_binding_id}`
    updateMask: Optional. The list of fields to update
    validateOnly: Optional. If set, validate the request and preview the
      update, but do not actually post it.
  """

  googleIamV3betaPolicyBinding = _messages.MessageField('GoogleIamV3betaPolicyBinding', 1)
  name = _messages.StringField(2, required=True)
  updateMask = _messages.StringField(3)
  validateOnly = _messages.BooleanField(4)


class IamProjectsLocationsPolicyBindingsSearchTargetPolicyBindingsRequest(_messages.Message):
  r"""A IamProjectsLocationsPolicyBindingsSearchTargetPolicyBindingsRequest
  object.

  Fields:
    pageSize: Optional. The maximum number of policy bindings to return. The
      service may return fewer than this value. If unspecified, at most 50
      policy bindings will be returned. The maximum value is 1000; values
      above 1000 will be coerced to 1000.
    pageToken: Optional. A page token, received from a previous
      `SearchTargetPolicyBindingsRequest` call. Provide this to retrieve the
      subsequent page. When paginating, all other parameters provided to
      `SearchTargetPolicyBindingsRequest` must match the call that provided
      the page token.
    parent: Required. The parent resource where this search will be performed.
      This should be the nearest CRM resource to the target. Format:
      `projects/{project_id}/locations/{location}`
      `projects/{project_number}/locations/{location}`
      `folders/{folder_id}/locations/{location}`
      `organizations/{organization_id}/locations/{location}`
    target: Required. The target resource, which is bound to the policy in the
      binding. Format:
      `//iam.googleapis.com/locations/global/workforcePools/POOL_ID` `//iam.go
      ogleapis.com/projects/PROJECT_NUMBER/locations/global/workloadIdentityPo
      ols/POOL_ID`
      `//iam.googleapis.com/locations/global/workspace/WORKSPACE_ID`
      `//cloudresourcemanager.googleapis.com/projects/{project_number}`
      `//cloudresourcemanager.googleapis.com/folders/{folder_id}`
      `//cloudresourcemanager.googleapis.com/organizations/{organization_id}`
  """

  pageSize = _messages.IntegerField(1, variant=_messages.Variant.INT32)
  pageToken = _messages.StringField(2)
  parent = _messages.StringField(3, required=True)
  target = _messages.StringField(4)


class IamSearchApplicablePoliciesSearchRequest(_messages.Message):
  r"""A IamSearchApplicablePoliciesSearchRequest object.

  Fields:
    filter: Optional. Filtering currently only supports the kind of policies
      to return, and must be in the format "kind:[policyKind1] OR
      kind:[policyKind2]". New policy kinds may be added in the future without
      notice. Example value: "kind:principalAccessBoundaryPolicies"
    pageSize: Optional. The limit of number of items (binding+policy pairs) to
      return. The default and maximum is 100 and values above 100 are
      truncated to 100.
    pageToken: Optional. A page token, received from a previous
      `SearchApplicablePolicies` call.
    targetQuery: Required. The target for which to list the policies and
      bindings for. Binding conditions will not be evaluated and all bindings
      that are bound to the target will be returned. All targets from the
      CreatePolicyBinding request are supported, as well as principals that
      are part of the principalSet. e.g.
      principalSet://iam.googleapis.com/projects/1234/*
      principal:alice@acme.com
  """

  filter = _messages.StringField(1)
  pageSize = _messages.IntegerField(2, variant=_messages.Variant.INT32)
  pageToken = _messages.StringField(3)
  targetQuery = _messages.StringField(4)


class StandardQueryParameters(_messages.Message):
  r"""Query parameters accepted by all methods.

  Enums:
    FXgafvValueValuesEnum: V1 error format.
    AltValueValuesEnum: Data format for response.

  Fields:
    f__xgafv: V1 error format.
    access_token: OAuth access token.
    alt: Data format for response.
    callback: JSONP
    fields: Selector specifying which fields to include in a partial response.
    key: API key. Your API key identifies your project and provides you with
      API access, quota, and reports. Required unless you provide an OAuth 2.0
      token.
    oauth_token: OAuth 2.0 token for the current user.
    prettyPrint: Returns response with indentations and line breaks.
    quotaUser: Available to use for quota purposes for server-side
      applications. Can be any arbitrary string assigned to a user, but should
      not exceed 40 characters.
    trace: A tracing token of the form "token:<tokenid>" to include in api
      requests.
    uploadType: Legacy upload protocol for media (e.g. "media", "multipart").
    upload_protocol: Upload protocol for media (e.g. "raw", "multipart").
  """

  class AltValueValuesEnum(_messages.Enum):
    r"""Data format for response.

    Values:
      json: Responses with Content-Type of application/json
      media: Media download with context-dependent Content-Type
      proto: Responses with Content-Type of application/x-protobuf
    """
    json = 0
    media = 1
    proto = 2

  class FXgafvValueValuesEnum(_messages.Enum):
    r"""V1 error format.

    Values:
      _1: v1 error format
      _2: v2 error format
    """
    _1 = 0
    _2 = 1

  f__xgafv = _messages.EnumField('FXgafvValueValuesEnum', 1)
  access_token = _messages.StringField(2)
  alt = _messages.EnumField('AltValueValuesEnum', 3, default='json')
  callback = _messages.StringField(4)
  fields = _messages.StringField(5)
  key = _messages.StringField(6)
  oauth_token = _messages.StringField(7)
  prettyPrint = _messages.BooleanField(8, default=True)
  quotaUser = _messages.StringField(9)
  trace = _messages.StringField(10)
  uploadType = _messages.StringField(11)
  upload_protocol = _messages.StringField(12)


encoding.AddCustomJsonFieldMapping(
    StandardQueryParameters, 'f__xgafv', '$.xgafv')
encoding.AddCustomJsonEnumMapping(
    StandardQueryParameters.FXgafvValueValuesEnum, '_1', '1')
encoding.AddCustomJsonEnumMapping(
    StandardQueryParameters.FXgafvValueValuesEnum, '_2', '2')
