"""Generated message classes for composerflex version v1alpha1.

Manages workflows on Google Cloud Platform using Apache Airflow. Composer Flex
additionally provides per-workflow security, auto-scaling, and native GCP
tooling for workflows and tasks.
"""
# NOTE: This file is autogenerated and should not be edited by hand.

from apitools.base.protorpclite import messages as _messages
from apitools.base.py import encoding
from apitools.base.py import extra_types


package = 'composerflex'


class AirflowDag(_messages.Message):
  r"""A specification of an Apache Airflow DAG.

  Fields:
    data: The contents of a Python module or ZIP archive that specifies an
      Airflow DAG.
  """

  data = _messages.BytesField(1)


class ComposerflexProjectsLocationsContextsCreateRequest(_messages.Message):
  r"""A ComposerflexProjectsLocationsContextsCreateRequest object.

  Fields:
    context: A Context resource to be passed as the request body.
    parent: Parent resource of the context to create. The parent must be of
      the form "projects/{projectId}/locations/{locationId}".
  """

  context = _messages.MessageField('Context', 1)
  parent = _messages.StringField(2, required=True)


class ComposerflexProjectsLocationsContextsDeleteRequest(_messages.Message):
  r"""A ComposerflexProjectsLocationsContextsDeleteRequest object.

  Fields:
    name: The resource name of the context to delete. Must be in the form
      "projects/{projectId}/locations/{locationId}/contexts/{contextId}."
  """

  name = _messages.StringField(1, required=True)


class ComposerflexProjectsLocationsContextsGetRequest(_messages.Message):
  r"""A ComposerflexProjectsLocationsContextsGetRequest object.

  Fields:
    name: The resource name of the context to retrieve. Must be in the form
      "projects/{projectId}/locations/{locationId}/contexts/{contextId}."
  """

  name = _messages.StringField(1, required=True)


class ComposerflexProjectsLocationsContextsListRequest(_messages.Message):
  r"""A ComposerflexProjectsLocationsContextsListRequest object.

  Fields:
    filter: Filter will remain internal until its future implementation.
    orderBy: Optional. Specifies the ordering of results following syntax at
      https://cloud.google.com/apis/design/design_patterns#sorting_order.
      Order by will remain internal until its future implementation.
    pageSize: The maximum number of contexts to return.
    pageToken: Optional. The next_page_token returned from a previous List
      request.
    parent: List contexts in the given parent resource. Parent must be in the
      form "projects/{projectId}/locations/{locationId}".
  """

  filter = _messages.StringField(1)
  orderBy = _messages.StringField(2)
  pageSize = _messages.IntegerField(3, variant=_messages.Variant.INT32)
  pageToken = _messages.StringField(4)
  parent = _messages.StringField(5, required=True)


class ComposerflexProjectsLocationsWorkflowsCreateRequest(_messages.Message):
  r"""A ComposerflexProjectsLocationsWorkflowsCreateRequest object.

  Fields:
    parent: Parent resource of the workflow to create. The parent must be of
      the form "projects/{projectId}/locations/{locationId}".
    workflow: A Workflow resource to be passed as the request body.
  """

  parent = _messages.StringField(1, required=True)
  workflow = _messages.MessageField('Workflow', 2)


class ComposerflexProjectsLocationsWorkflowsDeleteRequest(_messages.Message):
  r"""A ComposerflexProjectsLocationsWorkflowsDeleteRequest object.

  Fields:
    name: The resource name of the workflow to delete. Must be in the form
      "projects/{projectId}/locations/{locationId}/workflows/{workflowId}."
  """

  name = _messages.StringField(1, required=True)


class ComposerflexProjectsLocationsWorkflowsGetRequest(_messages.Message):
  r"""A ComposerflexProjectsLocationsWorkflowsGetRequest object.

  Fields:
    name: The resource name of the workflow to retrieve. Must be in the form
      "projects/{projectId}/locations/{locationId}/workflows/{workflowId}."
  """

  name = _messages.StringField(1, required=True)


class ComposerflexProjectsLocationsWorkflowsListRequest(_messages.Message):
  r"""A ComposerflexProjectsLocationsWorkflowsListRequest object.

  Fields:
    filter: Filter will remain internal until its future implementation.
    orderBy: Optional. Specifies the ordering of results following syntax at
      https://cloud.google.com/apis/design/design_patterns#sorting_order.
      Order by will remain internal until its future implementation.
    pageSize: The maximum number of workflows to return.
    pageToken: Optional. The next_page_token returned from a previous List
      request.
    parent: List workflows in the given parent resource. Parent must be in the
      form "projects/{projectId}/locations/{locationId}".
  """

  filter = _messages.StringField(1)
  orderBy = _messages.StringField(2)
  pageSize = _messages.IntegerField(3, variant=_messages.Variant.INT32)
  pageToken = _messages.StringField(4)
  parent = _messages.StringField(5, required=True)


class ComposerflexProjectsLocationsWorkflowsRunsGetRequest(_messages.Message):
  r"""A ComposerflexProjectsLocationsWorkflowsRunsGetRequest object.

  Fields:
    name: The resource name for the WorkflowRun in the form: "projects/{projec
      tId}/locations/{locationId}/workflows/{workflowId}/runs/{runId}".
  """

  name = _messages.StringField(1, required=True)


class ComposerflexProjectsLocationsWorkflowsRunsListRequest(_messages.Message):
  r"""A ComposerflexProjectsLocationsWorkflowsRunsListRequest object.

  Fields:
    filter: Filter will remain internal until its future implementation.
    orderBy: Optional. Specifies the ordering of results following syntax at
      https://cloud.google.com/apis/design/design_patterns#sorting_order.
      Order by will remain internal until its future implementation.
    pageSize: The maximum number of workflows to return.
    pageToken: Optional. The next_page_token returned from a previous List
      request.
    parent: The parent selector for the WorkflowRun. Supports parent in the
      form:
      "projects/{projectId}/locations/{locationId}/workflows/{workflowId}".
  """

  filter = _messages.StringField(1)
  orderBy = _messages.StringField(2)
  pageSize = _messages.IntegerField(3, variant=_messages.Variant.INT32)
  pageToken = _messages.StringField(4)
  parent = _messages.StringField(5, required=True)


class Connection(_messages.Message):
  r"""Represents an Airflow Connection. Usage of the fields within this
  message is described in Airflow documentation:
  https://airflow.apache.org/howto/connection/index.html#editing-a-connection-
  with-the-ui

  Enums:
    TypeValueValuesEnum: The type of connection specified. This refers to the
      service for which this connection is created.

  Fields:
    extra: The Airflow extra field for the connection.
    host: The target host for the service.
    id: The identifier for the connection.
    login: The username if the service requires authentication.
    password: Input only. Users can provide the password in plain-text. It
      will be used to set the password in Airflow, but will not be stored for
      retrieval on Google systems.
    port: The port for the service.
    schema: The Airflow schema field for the connection.
    type: The type of connection specified. This refers to the service for
      which this connection is created.
  """

  class TypeValueValuesEnum(_messages.Enum):
    r"""The type of connection specified. This refers to the service for which
    this connection is created.

    Values:
      TYPE_UNSPECIFIED: Unspecified connection type.
      DOCKER: Docker connection type.
      FILE: File connection type.
      FTP: FTP connection type.
      GOOGLE_CLOUD_PLATFORM: GCP connection type.
      HDFS: HDFS connection type.
      HTTP: HTTP connection type.
      HIVE_CLI: Hive CLI connection type.
      HIVE_METASTORE: Hive Metastore connection type.
      HIVE_SERVER_2: Hive server connection type.
      JDBC: JDBC connection type.
      JENKINS: Jenkins connection type.
      MYSQL: MySQL connection type.
      POSTGRES: Postgres connection type.
      ORACLE: Oracle connection type.
      VERTICA: Vertica connection type.
      PRESTO: Presto connection type.
      S3: Amazon S3 connection type.
      SAMBA: Samba connection type.
      SQLITE: SQLite connection type.
      SSH: SSH connection type.
      CLOUDANT: Cloudant connection type.
      MSSQL: MsSQL connection type.
      MESOS_FRAMEWORK_ID: Mesos Framework connection type.
      JIRA: Jira connection type.
      REDIS: Redis connection type.
      WASB: Wasb connection type.
      DATABRICKS: Databricks connection type.
      AWS: AWS connection type.
      EMR: EMR connection type.
      SNOWFLAKE: Snowflake connection type.
      SEGMENT: Segment connection type.
      AZURE_DATA_LAKE: Azure Data Lake connection type.
      CASSANDRA: Cassandra connection type.
    """
    TYPE_UNSPECIFIED = 0
    DOCKER = 1
    FILE = 2
    FTP = 3
    GOOGLE_CLOUD_PLATFORM = 4
    HDFS = 5
    HTTP = 6
    HIVE_CLI = 7
    HIVE_METASTORE = 8
    HIVE_SERVER_2 = 9
    JDBC = 10
    JENKINS = 11
    MYSQL = 12
    POSTGRES = 13
    ORACLE = 14
    VERTICA = 15
    PRESTO = 16
    S3 = 17
    SAMBA = 18
    SQLITE = 19
    SSH = 20
    CLOUDANT = 21
    MSSQL = 22
    MESOS_FRAMEWORK_ID = 23
    JIRA = 24
    REDIS = 25
    WASB = 26
    DATABRICKS = 27
    AWS = 28
    EMR = 29
    SNOWFLAKE = 30
    SEGMENT = 31
    AZURE_DATA_LAKE = 32
    CASSANDRA = 33

  extra = _messages.StringField(1)
  host = _messages.StringField(2)
  id = _messages.StringField(3)
  login = _messages.StringField(4)
  password = _messages.StringField(5)
  port = _messages.IntegerField(6, variant=_messages.Variant.INT32)
  schema = _messages.StringField(7)
  type = _messages.EnumField('TypeValueValuesEnum', 8)


class Context(_messages.Message):
  r"""A resource to hold configurations that are common across multiple
  workflows.

  Messages:
    AirflowConfigOverridesValue: Optional. A user defined mapping of key value
      pairs for Airflow Configurations.
    AirflowVariablesValue: Optional. Key value pairs to make available to a
      workflow. These are an application-level concept and are different from
      environment variables, which are a process-level concept.
    ConnectionsValue: Optional. A mapping from connection ID to Connections to
      make available to the workflow. Each map entry's key should match the
      `id` field of the  // value.
    EnvVariablesValue: Optional. Environment variables to provide to the
      processes executing the workflow.  Environment variable names must match
      the regular expression "a-zA-Z_*". They cannot specify Apache Airflow
      configuration overrides (they cannot match the regular expression
      `AIRFLOW__[A-Z0-9_]+__[A-Z0-9_]+`)
    LabelsValue: Optional. User-defined labels for this context. There can be
      no more than 64 labels entries. Entries of the labels map are UTF8
      strings that comply with the following restrictions:  * Keys must
      conform to regexp: \p{Ll}\p{Lo}{0,62} * Values must conform to regexp:
      [\p{Ll}\p{Lo}\p{N}_-]{0,63} * Both keys and values are additionally
      constrained to be <= 128 bytes in size.
    PoolsValue: Optional. A mapping from pool ID to Pools to make available to
      the workflow. Each map entry's key should match the `id` field of the
      value.

  Fields:
    airflowConfigOverrides: Optional. A user defined mapping of key value
      pairs for Airflow Configurations.
    airflowVariables: Optional. Key value pairs to make available to a
      workflow. These are an application-level concept and are different from
      environment variables, which are a process-level concept.
    connections: Optional. A mapping from connection ID to Connections to make
      available to the workflow. Each map entry's key should match the `id`
      field of the  // value.
    createTime: Output only. The time the context was created.
    envVariables: Optional. Environment variables to provide to the processes
      executing the workflow.  Environment variable names must match the
      regular expression "a-zA-Z_*". They cannot specify Apache Airflow
      configuration overrides (they cannot match the regular expression
      `AIRFLOW__[A-Z0-9_]+__[A-Z0-9_]+`)
    labels: Optional. User-defined labels for this context. There can be no
      more than 64 labels entries. Entries of the labels map are UTF8 strings
      that comply with the following restrictions:  * Keys must conform to
      regexp: \p{Ll}\p{Lo}{0,62} * Values must conform to regexp:
      [\p{Ll}\p{Lo}\p{N}_-]{0,63} * Both keys and values are additionally
      constrained to be <= 128 bytes in size.
    name: The resource name of the context, in the form:
      "projects/{projectId}/locations/{locationId}/contexts/{contextId}"
    pools: Optional. A mapping from pool ID to Pools to make available to the
      workflow. Each map entry's key should match the `id` field of the value.
    updateTime: Output only. The time the context was last updated.
  """

  @encoding.MapUnrecognizedFields('additionalProperties')
  class AirflowConfigOverridesValue(_messages.Message):
    r"""Optional. A user defined mapping of key value pairs for Airflow
    Configurations.

    Messages:
      AdditionalProperty: An additional property for a
        AirflowConfigOverridesValue object.

    Fields:
      additionalProperties: Additional properties of type
        AirflowConfigOverridesValue
    """

    class AdditionalProperty(_messages.Message):
      r"""An additional property for a AirflowConfigOverridesValue object.

      Fields:
        key: Name of the additional property.
        value: A string attribute.
      """

      key = _messages.StringField(1)
      value = _messages.StringField(2)

    additionalProperties = _messages.MessageField('AdditionalProperty', 1, repeated=True)

  @encoding.MapUnrecognizedFields('additionalProperties')
  class AirflowVariablesValue(_messages.Message):
    r"""Optional. Key value pairs to make available to a workflow. These are
    an application-level concept and are different from environment variables,
    which are a process-level concept.

    Messages:
      AdditionalProperty: An additional property for a AirflowVariablesValue
        object.

    Fields:
      additionalProperties: Additional properties of type
        AirflowVariablesValue
    """

    class AdditionalProperty(_messages.Message):
      r"""An additional property for a AirflowVariablesValue object.

      Fields:
        key: Name of the additional property.
        value: A string attribute.
      """

      key = _messages.StringField(1)
      value = _messages.StringField(2)

    additionalProperties = _messages.MessageField('AdditionalProperty', 1, repeated=True)

  @encoding.MapUnrecognizedFields('additionalProperties')
  class ConnectionsValue(_messages.Message):
    r"""Optional. A mapping from connection ID to Connections to make
    available to the workflow. Each map entry's key should match the `id`
    field of the  // value.

    Messages:
      AdditionalProperty: An additional property for a ConnectionsValue
        object.

    Fields:
      additionalProperties: Additional properties of type ConnectionsValue
    """

    class AdditionalProperty(_messages.Message):
      r"""An additional property for a ConnectionsValue object.

      Fields:
        key: Name of the additional property.
        value: A Connection attribute.
      """

      key = _messages.StringField(1)
      value = _messages.MessageField('Connection', 2)

    additionalProperties = _messages.MessageField('AdditionalProperty', 1, repeated=True)

  @encoding.MapUnrecognizedFields('additionalProperties')
  class EnvVariablesValue(_messages.Message):
    r"""Optional. Environment variables to provide to the processes executing
    the workflow.  Environment variable names must match the regular
    expression "a-zA-Z_*". They cannot specify Apache Airflow configuration
    overrides (they cannot match the regular expression
    `AIRFLOW__[A-Z0-9_]+__[A-Z0-9_]+`)

    Messages:
      AdditionalProperty: An additional property for a EnvVariablesValue
        object.

    Fields:
      additionalProperties: Additional properties of type EnvVariablesValue
    """

    class AdditionalProperty(_messages.Message):
      r"""An additional property for a EnvVariablesValue object.

      Fields:
        key: Name of the additional property.
        value: A string attribute.
      """

      key = _messages.StringField(1)
      value = _messages.StringField(2)

    additionalProperties = _messages.MessageField('AdditionalProperty', 1, repeated=True)

  @encoding.MapUnrecognizedFields('additionalProperties')
  class LabelsValue(_messages.Message):
    r"""Optional. User-defined labels for this context. There can be no more
    than 64 labels entries. Entries of the labels map are UTF8 strings that
    comply with the following restrictions:  * Keys must conform to regexp:
    \p{Ll}\p{Lo}{0,62} * Values must conform to regexp:
    [\p{Ll}\p{Lo}\p{N}_-]{0,63} * Both keys and values are additionally
    constrained to be <= 128 bytes in size.

    Messages:
      AdditionalProperty: An additional property for a LabelsValue object.

    Fields:
      additionalProperties: Additional properties of type LabelsValue
    """

    class AdditionalProperty(_messages.Message):
      r"""An additional property for a LabelsValue object.

      Fields:
        key: Name of the additional property.
        value: A string attribute.
      """

      key = _messages.StringField(1)
      value = _messages.StringField(2)

    additionalProperties = _messages.MessageField('AdditionalProperty', 1, repeated=True)

  @encoding.MapUnrecognizedFields('additionalProperties')
  class PoolsValue(_messages.Message):
    r"""Optional. A mapping from pool ID to Pools to make available to the
    workflow. Each map entry's key should match the `id` field of the value.

    Messages:
      AdditionalProperty: An additional property for a PoolsValue object.

    Fields:
      additionalProperties: Additional properties of type PoolsValue
    """

    class AdditionalProperty(_messages.Message):
      r"""An additional property for a PoolsValue object.

      Fields:
        key: Name of the additional property.
        value: A Pool attribute.
      """

      key = _messages.StringField(1)
      value = _messages.MessageField('Pool', 2)

    additionalProperties = _messages.MessageField('AdditionalProperty', 1, repeated=True)

  airflowConfigOverrides = _messages.MessageField('AirflowConfigOverridesValue', 1)
  airflowVariables = _messages.MessageField('AirflowVariablesValue', 2)
  connections = _messages.MessageField('ConnectionsValue', 3)
  createTime = _messages.StringField(4)
  envVariables = _messages.MessageField('EnvVariablesValue', 5)
  labels = _messages.MessageField('LabelsValue', 6)
  name = _messages.StringField(7)
  pools = _messages.MessageField('PoolsValue', 8)
  updateTime = _messages.StringField(9)


class ListContextsResponse(_messages.Message):
  r"""Response for a ListContextsRequest.

  Fields:
    contexts: The list of contexts returned.
    nextPageToken: The page token used to query for the next page if one
      exists.
  """

  contexts = _messages.MessageField('Context', 1, repeated=True)
  nextPageToken = _messages.StringField(2)


class ListWorkflowRunsResponse(_messages.Message):
  r"""Response for ListWorkflowRunsRequest.

  Fields:
    nextPageToken: The page token used to query for the next page if one
      exists.
    workflowRuns: The returned list of WorkflowRuns.
  """

  nextPageToken = _messages.StringField(1)
  workflowRuns = _messages.MessageField('WorkflowRun', 2, repeated=True)


class ListWorkflowsResponse(_messages.Message):
  r"""Response to ListWorkflowsRequest.

  Fields:
    nextPageToken: The page token used to query for the next page if one
      exists.
    workflows: The list of workflows returned.
  """

  nextPageToken = _messages.StringField(1)
  workflows = _messages.MessageField('Workflow', 2, repeated=True)


class Operation(_messages.Message):
  r"""This resource represents a long-running operation that is the result of
  a network API call.

  Messages:
    MetadataValue: Service-specific metadata associated with the operation.
      It typically contains progress information and common metadata such as
      create time. Some services might not provide such metadata.  Any method
      that returns a long-running operation should document the metadata type,
      if any.
    ResponseValue: The normal response of the operation in case of success.
      If the original method returns no data on success, such as `Delete`, the
      response is `google.protobuf.Empty`.  If the original method is standard
      `Get`/`Create`/`Update`, the response should be the resource.  For other
      methods, the response should have the type `XxxResponse`, where `Xxx` is
      the original method name.  For example, if the original method name is
      `TakeSnapshot()`, the inferred response type is `TakeSnapshotResponse`.

  Fields:
    done: If the value is `false`, it means the operation is still in
      progress. If `true`, the operation is completed, and either `error` or
      `response` is available.
    error: The error result of the operation in case of failure or
      cancellation.
    metadata: Service-specific metadata associated with the operation.  It
      typically contains progress information and common metadata such as
      create time. Some services might not provide such metadata.  Any method
      that returns a long-running operation should document the metadata type,
      if any.
    name: The server-assigned name, which is only unique within the same
      service that originally returns it. If you use the default HTTP mapping,
      the `name` should be a resource name ending with
      `operations/{unique_id}`.
    response: The normal response of the operation in case of success.  If the
      original method returns no data on success, such as `Delete`, the
      response is `google.protobuf.Empty`.  If the original method is standard
      `Get`/`Create`/`Update`, the response should be the resource.  For other
      methods, the response should have the type `XxxResponse`, where `Xxx` is
      the original method name.  For example, if the original method name is
      `TakeSnapshot()`, the inferred response type is `TakeSnapshotResponse`.
  """

  @encoding.MapUnrecognizedFields('additionalProperties')
  class MetadataValue(_messages.Message):
    r"""Service-specific metadata associated with the operation.  It typically
    contains progress information and common metadata such as create time.
    Some services might not provide such metadata.  Any method that returns a
    long-running operation should document the metadata type, if any.

    Messages:
      AdditionalProperty: An additional property for a MetadataValue object.

    Fields:
      additionalProperties: Properties of the object. Contains field @type
        with type URL.
    """

    class AdditionalProperty(_messages.Message):
      r"""An additional property for a MetadataValue object.

      Fields:
        key: Name of the additional property.
        value: A extra_types.JsonValue attribute.
      """

      key = _messages.StringField(1)
      value = _messages.MessageField('extra_types.JsonValue', 2)

    additionalProperties = _messages.MessageField('AdditionalProperty', 1, repeated=True)

  @encoding.MapUnrecognizedFields('additionalProperties')
  class ResponseValue(_messages.Message):
    r"""The normal response of the operation in case of success.  If the
    original method returns no data on success, such as `Delete`, the response
    is `google.protobuf.Empty`.  If the original method is standard
    `Get`/`Create`/`Update`, the response should be the resource.  For other
    methods, the response should have the type `XxxResponse`, where `Xxx` is
    the original method name.  For example, if the original method name is
    `TakeSnapshot()`, the inferred response type is `TakeSnapshotResponse`.

    Messages:
      AdditionalProperty: An additional property for a ResponseValue object.

    Fields:
      additionalProperties: Properties of the object. Contains field @type
        with type URL.
    """

    class AdditionalProperty(_messages.Message):
      r"""An additional property for a ResponseValue object.

      Fields:
        key: Name of the additional property.
        value: A extra_types.JsonValue attribute.
      """

      key = _messages.StringField(1)
      value = _messages.MessageField('extra_types.JsonValue', 2)

    additionalProperties = _messages.MessageField('AdditionalProperty', 1, repeated=True)

  done = _messages.BooleanField(1)
  error = _messages.MessageField('Status', 2)
  metadata = _messages.MessageField('MetadataValue', 3)
  name = _messages.StringField(4)
  response = _messages.MessageField('ResponseValue', 5)


class Pool(_messages.Message):
  r"""Represents an Airflow Pool.

  Fields:
    id: The identifier for the pool.
    slots: The number of slots available for the pool.
  """

  id = _messages.StringField(1)
  slots = _messages.IntegerField(2, variant=_messages.Variant.INT32)


class StandardQueryParameters(_messages.Message):
  r"""Query parameters accepted by all methods.

  Enums:
    FXgafvValueValuesEnum: V1 error format.
    AltValueValuesEnum: Data format for response.

  Fields:
    f__xgafv: V1 error format.
    access_token: OAuth access token.
    alt: Data format for response.
    callback: JSONP
    fields: Selector specifying which fields to include in a partial response.
    key: API key. Your API key identifies your project and provides you with
      API access, quota, and reports. Required unless you provide an OAuth 2.0
      token.
    oauth_token: OAuth 2.0 token for the current user.
    prettyPrint: Returns response with indentations and line breaks.
    quotaUser: Available to use for quota purposes for server-side
      applications. Can be any arbitrary string assigned to a user, but should
      not exceed 40 characters.
    trace: A tracing token of the form "token:<tokenid>" to include in api
      requests.
    uploadType: Legacy upload protocol for media (e.g. "media", "multipart").
    upload_protocol: Upload protocol for media (e.g. "raw", "multipart").
  """

  class AltValueValuesEnum(_messages.Enum):
    r"""Data format for response.

    Values:
      json: Responses with Content-Type of application/json
      media: Media download with context-dependent Content-Type
      proto: Responses with Content-Type of application/x-protobuf
    """
    json = 0
    media = 1
    proto = 2

  class FXgafvValueValuesEnum(_messages.Enum):
    r"""V1 error format.

    Values:
      _1: v1 error format
      _2: v2 error format
    """
    _1 = 0
    _2 = 1

  f__xgafv = _messages.EnumField('FXgafvValueValuesEnum', 1)
  access_token = _messages.StringField(2)
  alt = _messages.EnumField('AltValueValuesEnum', 3, default='json')
  callback = _messages.StringField(4)
  fields = _messages.StringField(5)
  key = _messages.StringField(6)
  oauth_token = _messages.StringField(7)
  prettyPrint = _messages.BooleanField(8, default=True)
  quotaUser = _messages.StringField(9)
  trace = _messages.StringField(10)
  uploadType = _messages.StringField(11)
  upload_protocol = _messages.StringField(12)


class Status(_messages.Message):
  r"""The `Status` type defines a logical error model that is suitable for
  different programming environments, including REST APIs and RPC APIs. It is
  used by [gRPC](https://github.com/grpc). Each `Status` message contains
  three pieces of data: error code, error message, and error details.  You can
  find out more about this error model and how to work with it in the [API
  Design Guide](https://cloud.google.com/apis/design/errors).

  Messages:
    DetailsValueListEntry: A DetailsValueListEntry object.

  Fields:
    code: The status code, which should be an enum value of google.rpc.Code.
    details: A list of messages that carry the error details.  There is a
      common set of message types for APIs to use.
    message: A developer-facing error message, which should be in English. Any
      user-facing error message should be localized and sent in the
      google.rpc.Status.details field, or localized by the client.
  """

  @encoding.MapUnrecognizedFields('additionalProperties')
  class DetailsValueListEntry(_messages.Message):
    r"""A DetailsValueListEntry object.

    Messages:
      AdditionalProperty: An additional property for a DetailsValueListEntry
        object.

    Fields:
      additionalProperties: Properties of the object. Contains field @type
        with type URL.
    """

    class AdditionalProperty(_messages.Message):
      r"""An additional property for a DetailsValueListEntry object.

      Fields:
        key: Name of the additional property.
        value: A extra_types.JsonValue attribute.
      """

      key = _messages.StringField(1)
      value = _messages.MessageField('extra_types.JsonValue', 2)

    additionalProperties = _messages.MessageField('AdditionalProperty', 1, repeated=True)

  code = _messages.IntegerField(1, variant=_messages.Variant.INT32)
  details = _messages.MessageField('DetailsValueListEntry', 2, repeated=True)
  message = _messages.StringField(3)


class Workflow(_messages.Message):
  r"""A Composer workflow resource.

  Enums:
    StateValueValuesEnum: Output only. The current state of the workflow.

  Messages:
    LabelsValue: Optional. User-defined labels for this workflow. Workflow
      runs instantiated from this workflow will inherit these labels. The
      labels map can contain no more than 64 entries. Entries of the labels
      map are UTF8 strings that comply with the following restrictions:  *
      Keys must conform to regexp: \p{Ll}\p{Lo}{0,62} * Values must conform to
      regexp:  [\p{Ll}\p{Lo}\p{N}_-]{0,63} * Both keys and values are
      additionally constrained to be <= 128 bytes in size.

  Fields:
    airflowDag: A representation of the workflow as Python source code
      defining an Airflow DAG.
    airflowVersion: The version of Airflow at which to run the DAG. For
      example, "1.10.0".
    composerVersion: Output only. The version of Composer that created this
      workflow.
    context: The context to use when executing this workflow. The context
      resides in the same project and location as this workflow. The context
      must be specified as the full resource name. The format is:
      projects/{projectId}/locations/{locationId}/contexts/{contextId}
    createTime: Output only. The time at which this workflow was created.
    labels: Optional. User-defined labels for this workflow. Workflow runs
      instantiated from this workflow will inherit these labels. The labels
      map can contain no more than 64 entries. Entries of the labels map are
      UTF8 strings that comply with the following restrictions:  * Keys must
      conform to regexp: \p{Ll}\p{Lo}{0,62} * Values must conform to regexp:
      [\p{Ll}\p{Lo}\p{N}_-]{0,63} * Both keys and values are additionally
      constrained to be <= 128 bytes in size.
    name: The resource name of the workflow, in the form:
      "projects/{projectId}/locations/{locationId}/workflows/{workflowId}"
    pythonVersion: The major version of Python used to run Apache Airflow
      processes. Can be set to '2' or '3'. If not specified, the default is
      '2'.
    state: Output only. The current state of the workflow.
    updateTime: Output only. The time at which this workflow was last updated.
  """

  class StateValueValuesEnum(_messages.Enum):
    r"""Output only. The current state of the workflow.

    Values:
      STATE_UNSPECIFIED: The state of the workflow is unknown.
      CREATING: The workflow is being created and cannot execute.
      ACTIVE: The workflow is available for execution.
      ERROR: The workflow is in an error state and cannot execute.
    """
    STATE_UNSPECIFIED = 0
    CREATING = 1
    ACTIVE = 2
    ERROR = 3

  @encoding.MapUnrecognizedFields('additionalProperties')
  class LabelsValue(_messages.Message):
    r"""Optional. User-defined labels for this workflow. Workflow runs
    instantiated from this workflow will inherit these labels. The labels map
    can contain no more than 64 entries. Entries of the labels map are UTF8
    strings that comply with the following restrictions:  * Keys must conform
    to regexp: \p{Ll}\p{Lo}{0,62} * Values must conform to regexp:
    [\p{Ll}\p{Lo}\p{N}_-]{0,63} * Both keys and values are additionally
    constrained to be <= 128 bytes in size.

    Messages:
      AdditionalProperty: An additional property for a LabelsValue object.

    Fields:
      additionalProperties: Additional properties of type LabelsValue
    """

    class AdditionalProperty(_messages.Message):
      r"""An additional property for a LabelsValue object.

      Fields:
        key: Name of the additional property.
        value: A string attribute.
      """

      key = _messages.StringField(1)
      value = _messages.StringField(2)

    additionalProperties = _messages.MessageField('AdditionalProperty', 1, repeated=True)

  airflowDag = _messages.MessageField('AirflowDag', 1)
  airflowVersion = _messages.StringField(2)
  composerVersion = _messages.StringField(3)
  context = _messages.StringField(4)
  createTime = _messages.StringField(5)
  labels = _messages.MessageField('LabelsValue', 6)
  name = _messages.StringField(7)
  pythonVersion = _messages.StringField(8)
  state = _messages.EnumField('StateValueValuesEnum', 9)
  updateTime = _messages.StringField(10)


class WorkflowRun(_messages.Message):
  r"""WorkflowRun represents a single execution of a Workflow.

  Enums:
    StateValueValuesEnum: Output only. The latest known state of the workflow
      run.

  Messages:
    LabelsValue: Optional. User-defined labels for this workflow run. The
      initial label entries for a workflow run are inherited from the workflow
      from which it was instantiated. There can be no more than 64 labels
      entries. Entries of the labels map are UTF8 strings that comply with the
      following restrictions:  * Keys must conform to regexp:
      \p{Ll}\p{Lo}{0,62} * Values must conform to regexp:
      [\p{Ll}\p{Lo}\p{N}_-]{0,63} * Both keys and values are additionally
      constrained to be <= 128 bytes in size.

  Fields:
    endTime: Output only. The end time of the workflow run.
    intervalStartTime: Output only. The start of the time interval
      corresponding to this workflow run. Only set for SCHEDULED runs. This
      value is analagous to the Apache Airflow notion of `execution_date`; it
      refers to the left boundary of the scheduling interval.
    labels: Optional. User-defined labels for this workflow run. The initial
      label entries for a workflow run are inherited from the workflow from
      which it was instantiated. There can be no more than 64 labels entries.
      Entries of the labels map are UTF8 strings that comply with the
      following restrictions:  * Keys must conform to regexp:
      \p{Ll}\p{Lo}{0,62} * Values must conform to regexp:
      [\p{Ll}\p{Lo}\p{N}_-]{0,63} * Both keys and values are additionally
      constrained to be <= 128 bytes in size.
    name: Output only. The resource name of the workflow run, in the form: "pr
      ojects/{projectId}/locations/{locationId}/workflows/{workflowId}/runs/{r
      unId}"
    startTime: Output only. The start time of the workflow run.
    state: Output only. The latest known state of the workflow run.
  """

  class StateValueValuesEnum(_messages.Enum):
    r"""Output only. The latest known state of the workflow run.

    Values:
      STATE_UNSPECIFIED: The state of the WorkflowRun is unknown.
      RUNNING: The WorkflowRun is currently running.
      SUCCESS: The WorkflowRun succeeded.
      FAILED: The WorkflowRun failed.
    """
    STATE_UNSPECIFIED = 0
    RUNNING = 1
    SUCCESS = 2
    FAILED = 3

  @encoding.MapUnrecognizedFields('additionalProperties')
  class LabelsValue(_messages.Message):
    r"""Optional. User-defined labels for this workflow run. The initial label
    entries for a workflow run are inherited from the workflow from which it
    was instantiated. There can be no more than 64 labels entries. Entries of
    the labels map are UTF8 strings that comply with the following
    restrictions:  * Keys must conform to regexp: \p{Ll}\p{Lo}{0,62} * Values
    must conform to regexp:  [\p{Ll}\p{Lo}\p{N}_-]{0,63} * Both keys and
    values are additionally constrained to be <= 128 bytes in size.

    Messages:
      AdditionalProperty: An additional property for a LabelsValue object.

    Fields:
      additionalProperties: Additional properties of type LabelsValue
    """

    class AdditionalProperty(_messages.Message):
      r"""An additional property for a LabelsValue object.

      Fields:
        key: Name of the additional property.
        value: A string attribute.
      """

      key = _messages.StringField(1)
      value = _messages.StringField(2)

    additionalProperties = _messages.MessageField('AdditionalProperty', 1, repeated=True)

  endTime = _messages.StringField(1)
  intervalStartTime = _messages.StringField(2)
  labels = _messages.MessageField('LabelsValue', 3)
  name = _messages.StringField(4)
  startTime = _messages.StringField(5)
  state = _messages.EnumField('StateValueValuesEnum', 6)


encoding.AddCustomJsonFieldMapping(
    StandardQueryParameters, 'f__xgafv', '$.xgafv')
encoding.AddCustomJsonEnumMapping(
    StandardQueryParameters.FXgafvValueValuesEnum, '_1', '1')
encoding.AddCustomJsonEnumMapping(
    StandardQueryParameters.FXgafvValueValuesEnum, '_2', '2')
