"""Generated message classes for dialogflow version v2.

Builds conversational interfaces (for example, chatbots, and voice-powered
apps and devices).
"""
# NOTE: This file is autogenerated and should not be edited by hand.

from apitools.base.protorpclite import messages as _messages
from apitools.base.py import encoding
from apitools.base.py import extra_types


package = 'dialogflow'


class DialogflowProjectsAgentEntityTypesBatchDeleteRequest(_messages.Message):
  r"""A DialogflowProjectsAgentEntityTypesBatchDeleteRequest object.

  Fields:
    googleCloudDialogflowV2BatchDeleteEntityTypesRequest: A
      GoogleCloudDialogflowV2BatchDeleteEntityTypesRequest resource to be
      passed as the request body.
    parent: Required. The name of the agent to delete all entities types for.
      Format: `projects/<Project ID>/agent`.
  """

  googleCloudDialogflowV2BatchDeleteEntityTypesRequest = _messages.MessageField('GoogleCloudDialogflowV2BatchDeleteEntityTypesRequest', 1)
  parent = _messages.StringField(2, required=True)


class DialogflowProjectsAgentEntityTypesBatchUpdateRequest(_messages.Message):
  r"""A DialogflowProjectsAgentEntityTypesBatchUpdateRequest object.

  Fields:
    googleCloudDialogflowV2BatchUpdateEntityTypesRequest: A
      GoogleCloudDialogflowV2BatchUpdateEntityTypesRequest resource to be
      passed as the request body.
    parent: Required. The name of the agent to update or create entity types
      in. Format: `projects/<Project ID>/agent`.
  """

  googleCloudDialogflowV2BatchUpdateEntityTypesRequest = _messages.MessageField('GoogleCloudDialogflowV2BatchUpdateEntityTypesRequest', 1)
  parent = _messages.StringField(2, required=True)


class DialogflowProjectsAgentEntityTypesCreateRequest(_messages.Message):
  r"""A DialogflowProjectsAgentEntityTypesCreateRequest object.

  Fields:
    googleCloudDialogflowV2EntityType: A GoogleCloudDialogflowV2EntityType
      resource to be passed as the request body.
    languageCode: Optional. The language of entity synonyms defined in
      `entity_type`. If not specified, the agent's default language is used.
      [Many
      languages](https://cloud.google.com/dialogflow/docs/reference/language)
      are supported. Note: languages must be enabled in the agent before they
      can be used.
    parent: Required. The agent to create a entity type for. Format:
      `projects/<Project ID>/agent`.
  """

  googleCloudDialogflowV2EntityType = _messages.MessageField('GoogleCloudDialogflowV2EntityType', 1)
  languageCode = _messages.StringField(2)
  parent = _messages.StringField(3, required=True)


class DialogflowProjectsAgentEntityTypesDeleteRequest(_messages.Message):
  r"""A DialogflowProjectsAgentEntityTypesDeleteRequest object.

  Fields:
    name: Required. The name of the entity type to delete. Format:
      `projects/<Project ID>/agent/entityTypes/<EntityType ID>`.
  """

  name = _messages.StringField(1, required=True)


class DialogflowProjectsAgentEntityTypesEntitiesBatchCreateRequest(_messages.Message):
  r"""A DialogflowProjectsAgentEntityTypesEntitiesBatchCreateRequest object.

  Fields:
    googleCloudDialogflowV2BatchCreateEntitiesRequest: A
      GoogleCloudDialogflowV2BatchCreateEntitiesRequest resource to be passed
      as the request body.
    parent: Required. The name of the entity type to create entities in.
      Format: `projects/<Project ID>/agent/entityTypes/<Entity Type ID>`.
  """

  googleCloudDialogflowV2BatchCreateEntitiesRequest = _messages.MessageField('GoogleCloudDialogflowV2BatchCreateEntitiesRequest', 1)
  parent = _messages.StringField(2, required=True)


class DialogflowProjectsAgentEntityTypesEntitiesBatchDeleteRequest(_messages.Message):
  r"""A DialogflowProjectsAgentEntityTypesEntitiesBatchDeleteRequest object.

  Fields:
    googleCloudDialogflowV2BatchDeleteEntitiesRequest: A
      GoogleCloudDialogflowV2BatchDeleteEntitiesRequest resource to be passed
      as the request body.
    parent: Required. The name of the entity type to delete entries for.
      Format: `projects/<Project ID>/agent/entityTypes/<Entity Type ID>`.
  """

  googleCloudDialogflowV2BatchDeleteEntitiesRequest = _messages.MessageField('GoogleCloudDialogflowV2BatchDeleteEntitiesRequest', 1)
  parent = _messages.StringField(2, required=True)


class DialogflowProjectsAgentEntityTypesEntitiesBatchUpdateRequest(_messages.Message):
  r"""A DialogflowProjectsAgentEntityTypesEntitiesBatchUpdateRequest object.

  Fields:
    googleCloudDialogflowV2BatchUpdateEntitiesRequest: A
      GoogleCloudDialogflowV2BatchUpdateEntitiesRequest resource to be passed
      as the request body.
    parent: Required. The name of the entity type to update or create entities
      in. Format: `projects/<Project ID>/agent/entityTypes/<Entity Type ID>`.
  """

  googleCloudDialogflowV2BatchUpdateEntitiesRequest = _messages.MessageField('GoogleCloudDialogflowV2BatchUpdateEntitiesRequest', 1)
  parent = _messages.StringField(2, required=True)


class DialogflowProjectsAgentEntityTypesGetRequest(_messages.Message):
  r"""A DialogflowProjectsAgentEntityTypesGetRequest object.

  Fields:
    languageCode: Optional. The language to retrieve entity synonyms for. If
      not specified, the agent's default language is used. [Many
      languages](https://cloud.google.com/dialogflow/docs/reference/language)
      are supported. Note: languages must be enabled in the agent before they
      can be used.
    name: Required. The name of the entity type. Format: `projects/<Project
      ID>/agent/entityTypes/<EntityType ID>`.
  """

  languageCode = _messages.StringField(1)
  name = _messages.StringField(2, required=True)


class DialogflowProjectsAgentEntityTypesListRequest(_messages.Message):
  r"""A DialogflowProjectsAgentEntityTypesListRequest object.

  Fields:
    languageCode: Optional. The language to list entity synonyms for. If not
      specified, the agent's default language is used. [Many
      languages](https://cloud.google.com/dialogflow/docs/reference/language)
      are supported. Note: languages must be enabled in the agent before they
      can be used.
    pageSize: Optional. The maximum number of items to return in a single
      page. By default 100 and at most 1000.
    pageToken: Optional. The next_page_token value returned from a previous
      list request.
    parent: Required. The agent to list all entity types from. Format:
      `projects/<Project ID>/agent`.
  """

  languageCode = _messages.StringField(1)
  pageSize = _messages.IntegerField(2, variant=_messages.Variant.INT32)
  pageToken = _messages.StringField(3)
  parent = _messages.StringField(4, required=True)


class DialogflowProjectsAgentEntityTypesPatchRequest(_messages.Message):
  r"""A DialogflowProjectsAgentEntityTypesPatchRequest object.

  Fields:
    googleCloudDialogflowV2EntityType: A GoogleCloudDialogflowV2EntityType
      resource to be passed as the request body.
    languageCode: Optional. The language of entity synonyms defined in
      `entity_type`. If not specified, the agent's default language is used.
      [Many
      languages](https://cloud.google.com/dialogflow/docs/reference/language)
      are supported. Note: languages must be enabled in the agent before they
      can be used.
    name: The unique identifier of the entity type. Required for
      EntityTypes.UpdateEntityType and EntityTypes.BatchUpdateEntityTypes
      methods. Format: `projects/<Project ID>/agent/entityTypes/<Entity Type
      ID>`.
    updateMask: Optional. The mask to control which fields get updated.
  """

  googleCloudDialogflowV2EntityType = _messages.MessageField('GoogleCloudDialogflowV2EntityType', 1)
  languageCode = _messages.StringField(2)
  name = _messages.StringField(3, required=True)
  updateMask = _messages.StringField(4)


class DialogflowProjectsAgentExportRequest(_messages.Message):
  r"""A DialogflowProjectsAgentExportRequest object.

  Fields:
    googleCloudDialogflowV2ExportAgentRequest: A
      GoogleCloudDialogflowV2ExportAgentRequest resource to be passed as the
      request body.
    parent: Required. The project that the agent to export is associated with.
      Format: `projects/<Project ID>`.
  """

  googleCloudDialogflowV2ExportAgentRequest = _messages.MessageField('GoogleCloudDialogflowV2ExportAgentRequest', 1)
  parent = _messages.StringField(2, required=True)


class DialogflowProjectsAgentImportRequest(_messages.Message):
  r"""A DialogflowProjectsAgentImportRequest object.

  Fields:
    googleCloudDialogflowV2ImportAgentRequest: A
      GoogleCloudDialogflowV2ImportAgentRequest resource to be passed as the
      request body.
    parent: Required. The project that the agent to import is associated with.
      Format: `projects/<Project ID>`.
  """

  googleCloudDialogflowV2ImportAgentRequest = _messages.MessageField('GoogleCloudDialogflowV2ImportAgentRequest', 1)
  parent = _messages.StringField(2, required=True)


class DialogflowProjectsAgentIntentsBatchDeleteRequest(_messages.Message):
  r"""A DialogflowProjectsAgentIntentsBatchDeleteRequest object.

  Fields:
    googleCloudDialogflowV2BatchDeleteIntentsRequest: A
      GoogleCloudDialogflowV2BatchDeleteIntentsRequest resource to be passed
      as the request body.
    parent: Required. The name of the agent to delete all entities types for.
      Format: `projects/<Project ID>/agent`.
  """

  googleCloudDialogflowV2BatchDeleteIntentsRequest = _messages.MessageField('GoogleCloudDialogflowV2BatchDeleteIntentsRequest', 1)
  parent = _messages.StringField(2, required=True)


class DialogflowProjectsAgentIntentsBatchUpdateRequest(_messages.Message):
  r"""A DialogflowProjectsAgentIntentsBatchUpdateRequest object.

  Fields:
    googleCloudDialogflowV2BatchUpdateIntentsRequest: A
      GoogleCloudDialogflowV2BatchUpdateIntentsRequest resource to be passed
      as the request body.
    parent: Required. The name of the agent to update or create intents in.
      Format: `projects/<Project ID>/agent`.
  """

  googleCloudDialogflowV2BatchUpdateIntentsRequest = _messages.MessageField('GoogleCloudDialogflowV2BatchUpdateIntentsRequest', 1)
  parent = _messages.StringField(2, required=True)


class DialogflowProjectsAgentIntentsCreateRequest(_messages.Message):
  r"""A DialogflowProjectsAgentIntentsCreateRequest object.

  Enums:
    IntentViewValueValuesEnum: Optional. The resource view to apply to the
      returned intent.

  Fields:
    googleCloudDialogflowV2Intent: A GoogleCloudDialogflowV2Intent resource to
      be passed as the request body.
    intentView: Optional. The resource view to apply to the returned intent.
    languageCode: Optional. The language of training phrases, parameters and
      rich messages defined in `intent`. If not specified, the agent's default
      language is used. [Many
      languages](https://cloud.google.com/dialogflow/docs/reference/language)
      are supported. Note: languages must be enabled in the agent before they
      can be used.
    parent: Required. The agent to create a intent for. Format:
      `projects/<Project ID>/agent`.
  """

  class IntentViewValueValuesEnum(_messages.Enum):
    r"""Optional. The resource view to apply to the returned intent.

    Values:
      INTENT_VIEW_UNSPECIFIED: <no description>
      INTENT_VIEW_FULL: <no description>
    """
    INTENT_VIEW_UNSPECIFIED = 0
    INTENT_VIEW_FULL = 1

  googleCloudDialogflowV2Intent = _messages.MessageField('GoogleCloudDialogflowV2Intent', 1)
  intentView = _messages.EnumField('IntentViewValueValuesEnum', 2)
  languageCode = _messages.StringField(3)
  parent = _messages.StringField(4, required=True)


class DialogflowProjectsAgentIntentsDeleteRequest(_messages.Message):
  r"""A DialogflowProjectsAgentIntentsDeleteRequest object.

  Fields:
    name: Required. The name of the intent to delete. If this intent has
      direct or indirect followup intents, we also delete them. Format:
      `projects/<Project ID>/agent/intents/<Intent ID>`.
  """

  name = _messages.StringField(1, required=True)


class DialogflowProjectsAgentIntentsGetRequest(_messages.Message):
  r"""A DialogflowProjectsAgentIntentsGetRequest object.

  Enums:
    IntentViewValueValuesEnum: Optional. The resource view to apply to the
      returned intent.

  Fields:
    intentView: Optional. The resource view to apply to the returned intent.
    languageCode: Optional. The language to retrieve training phrases,
      parameters and rich messages for. If not specified, the agent's default
      language is used. [Many
      languages](https://cloud.google.com/dialogflow/docs/reference/language)
      are supported. Note: languages must be enabled in the agent before they
      can be used.
    name: Required. The name of the intent. Format: `projects/<Project
      ID>/agent/intents/<Intent ID>`.
  """

  class IntentViewValueValuesEnum(_messages.Enum):
    r"""Optional. The resource view to apply to the returned intent.

    Values:
      INTENT_VIEW_UNSPECIFIED: <no description>
      INTENT_VIEW_FULL: <no description>
    """
    INTENT_VIEW_UNSPECIFIED = 0
    INTENT_VIEW_FULL = 1

  intentView = _messages.EnumField('IntentViewValueValuesEnum', 1)
  languageCode = _messages.StringField(2)
  name = _messages.StringField(3, required=True)


class DialogflowProjectsAgentIntentsListRequest(_messages.Message):
  r"""A DialogflowProjectsAgentIntentsListRequest object.

  Enums:
    IntentViewValueValuesEnum: Optional. The resource view to apply to the
      returned intent.

  Fields:
    intentView: Optional. The resource view to apply to the returned intent.
    languageCode: Optional. The language to list training phrases, parameters
      and rich messages for. If not specified, the agent's default language is
      used. [Many
      languages](https://cloud.google.com/dialogflow/docs/reference/language)
      are supported. Note: languages must be enabled in the agent before they
      can be used.
    pageSize: Optional. The maximum number of items to return in a single
      page. By default 100 and at most 1000.
    pageToken: Optional. The next_page_token value returned from a previous
      list request.
    parent: Required. The agent to list all intents from. Format:
      `projects/<Project ID>/agent`.
  """

  class IntentViewValueValuesEnum(_messages.Enum):
    r"""Optional. The resource view to apply to the returned intent.

    Values:
      INTENT_VIEW_UNSPECIFIED: <no description>
      INTENT_VIEW_FULL: <no description>
    """
    INTENT_VIEW_UNSPECIFIED = 0
    INTENT_VIEW_FULL = 1

  intentView = _messages.EnumField('IntentViewValueValuesEnum', 1)
  languageCode = _messages.StringField(2)
  pageSize = _messages.IntegerField(3, variant=_messages.Variant.INT32)
  pageToken = _messages.StringField(4)
  parent = _messages.StringField(5, required=True)


class DialogflowProjectsAgentIntentsPatchRequest(_messages.Message):
  r"""A DialogflowProjectsAgentIntentsPatchRequest object.

  Enums:
    IntentViewValueValuesEnum: Optional. The resource view to apply to the
      returned intent.

  Fields:
    googleCloudDialogflowV2Intent: A GoogleCloudDialogflowV2Intent resource to
      be passed as the request body.
    intentView: Optional. The resource view to apply to the returned intent.
    languageCode: Optional. The language of training phrases, parameters and
      rich messages defined in `intent`. If not specified, the agent's default
      language is used. [Many
      languages](https://cloud.google.com/dialogflow/docs/reference/language)
      are supported. Note: languages must be enabled in the agent before they
      can be used.
    name: The unique identifier of this intent. Required for
      Intents.UpdateIntent and Intents.BatchUpdateIntents methods. Format:
      `projects/<Project ID>/agent/intents/<Intent ID>`.
    updateMask: Optional. The mask to control which fields get updated.
  """

  class IntentViewValueValuesEnum(_messages.Enum):
    r"""Optional. The resource view to apply to the returned intent.

    Values:
      INTENT_VIEW_UNSPECIFIED: <no description>
      INTENT_VIEW_FULL: <no description>
    """
    INTENT_VIEW_UNSPECIFIED = 0
    INTENT_VIEW_FULL = 1

  googleCloudDialogflowV2Intent = _messages.MessageField('GoogleCloudDialogflowV2Intent', 1)
  intentView = _messages.EnumField('IntentViewValueValuesEnum', 2)
  languageCode = _messages.StringField(3)
  name = _messages.StringField(4, required=True)
  updateMask = _messages.StringField(5)


class DialogflowProjectsAgentRequest(_messages.Message):
  r"""A DialogflowProjectsAgentRequest object.

  Fields:
    googleCloudDialogflowV2Agent: A GoogleCloudDialogflowV2Agent resource to
      be passed as the request body.
    parent: Required. The project of this agent. Format: `projects/<Project
      ID>`.
    updateMask: Optional. The mask to control which fields get updated.
  """

  googleCloudDialogflowV2Agent = _messages.MessageField('GoogleCloudDialogflowV2Agent', 1)
  parent = _messages.StringField(2, required=True)
  updateMask = _messages.StringField(3)


class DialogflowProjectsAgentRestoreRequest(_messages.Message):
  r"""A DialogflowProjectsAgentRestoreRequest object.

  Fields:
    googleCloudDialogflowV2RestoreAgentRequest: A
      GoogleCloudDialogflowV2RestoreAgentRequest resource to be passed as the
      request body.
    parent: Required. The project that the agent to restore is associated
      with. Format: `projects/<Project ID>`.
  """

  googleCloudDialogflowV2RestoreAgentRequest = _messages.MessageField('GoogleCloudDialogflowV2RestoreAgentRequest', 1)
  parent = _messages.StringField(2, required=True)


class DialogflowProjectsAgentSearchRequest(_messages.Message):
  r"""A DialogflowProjectsAgentSearchRequest object.

  Fields:
    pageSize: Optional. The maximum number of items to return in a single
      page. By default 100 and at most 1000.
    pageToken: Optional. The next_page_token value returned from a previous
      list request.
    parent: Required. The project to list agents from. Format:
      `projects/<Project ID or '-'>`.
  """

  pageSize = _messages.IntegerField(1, variant=_messages.Variant.INT32)
  pageToken = _messages.StringField(2)
  parent = _messages.StringField(3, required=True)


class DialogflowProjectsAgentSessionsContextsCreateRequest(_messages.Message):
  r"""A DialogflowProjectsAgentSessionsContextsCreateRequest object.

  Fields:
    googleCloudDialogflowV2Context: A GoogleCloudDialogflowV2Context resource
      to be passed as the request body.
    parent: Required. The session to create a context for. Format:
      `projects/<Project ID>/agent/sessions/<Session ID>`.
  """

  googleCloudDialogflowV2Context = _messages.MessageField('GoogleCloudDialogflowV2Context', 1)
  parent = _messages.StringField(2, required=True)


class DialogflowProjectsAgentSessionsContextsDeleteRequest(_messages.Message):
  r"""A DialogflowProjectsAgentSessionsContextsDeleteRequest object.

  Fields:
    name: Required. The name of the context to delete. Format:
      `projects/<Project ID>/agent/sessions/<Session ID>/contexts/<Context
      ID>`.
  """

  name = _messages.StringField(1, required=True)


class DialogflowProjectsAgentSessionsContextsGetRequest(_messages.Message):
  r"""A DialogflowProjectsAgentSessionsContextsGetRequest object.

  Fields:
    name: Required. The name of the context. Format: `projects/<Project
      ID>/agent/sessions/<Session ID>/contexts/<Context ID>`.
  """

  name = _messages.StringField(1, required=True)


class DialogflowProjectsAgentSessionsContextsListRequest(_messages.Message):
  r"""A DialogflowProjectsAgentSessionsContextsListRequest object.

  Fields:
    pageSize: Optional. The maximum number of items to return in a single
      page. By default 100 and at most 1000.
    pageToken: Optional. The next_page_token value returned from a previous
      list request.
    parent: Required. The session to list all contexts from. Format:
      `projects/<Project ID>/agent/sessions/<Session ID>`.
  """

  pageSize = _messages.IntegerField(1, variant=_messages.Variant.INT32)
  pageToken = _messages.StringField(2)
  parent = _messages.StringField(3, required=True)


class DialogflowProjectsAgentSessionsContextsPatchRequest(_messages.Message):
  r"""A DialogflowProjectsAgentSessionsContextsPatchRequest object.

  Fields:
    googleCloudDialogflowV2Context: A GoogleCloudDialogflowV2Context resource
      to be passed as the request body.
    name: Required. The unique identifier of the context. Format:
      `projects/<Project ID>/agent/sessions/<Session ID>/contexts/<Context
      ID>`.  The `Context ID` is always converted to lowercase, may only
      contain characters in [a-zA-Z0-9_-%] and may be at most 250 bytes long.
    updateMask: Optional. The mask to control which fields get updated.
  """

  googleCloudDialogflowV2Context = _messages.MessageField('GoogleCloudDialogflowV2Context', 1)
  name = _messages.StringField(2, required=True)
  updateMask = _messages.StringField(3)


class DialogflowProjectsAgentSessionsDeleteContextsRequest(_messages.Message):
  r"""A DialogflowProjectsAgentSessionsDeleteContextsRequest object.

  Fields:
    parent: Required. The name of the session to delete all contexts from.
      Format: `projects/<Project ID>/agent/sessions/<Session ID>`.
  """

  parent = _messages.StringField(1, required=True)


class DialogflowProjectsAgentSessionsDetectIntentRequest(_messages.Message):
  r"""A DialogflowProjectsAgentSessionsDetectIntentRequest object.

  Fields:
    googleCloudDialogflowV2DetectIntentRequest: A
      GoogleCloudDialogflowV2DetectIntentRequest resource to be passed as the
      request body.
    session: Required. The name of the session this query is sent to. Format:
      `projects/<Project ID>/agent/sessions/<Session ID>`. It's up to the API
      caller to choose an appropriate session ID. It can be a random number or
      some type of user identifier (preferably hashed). The length of the
      session ID must not exceed 36 bytes.
  """

  googleCloudDialogflowV2DetectIntentRequest = _messages.MessageField('GoogleCloudDialogflowV2DetectIntentRequest', 1)
  session = _messages.StringField(2, required=True)


class DialogflowProjectsAgentSessionsEntityTypesCreateRequest(_messages.Message):
  r"""A DialogflowProjectsAgentSessionsEntityTypesCreateRequest object.

  Fields:
    googleCloudDialogflowV2SessionEntityType: A
      GoogleCloudDialogflowV2SessionEntityType resource to be passed as the
      request body.
    parent: Required. The session to create a session entity type for. Format:
      `projects/<Project ID>/agent/sessions/<Session ID>`.
  """

  googleCloudDialogflowV2SessionEntityType = _messages.MessageField('GoogleCloudDialogflowV2SessionEntityType', 1)
  parent = _messages.StringField(2, required=True)


class DialogflowProjectsAgentSessionsEntityTypesDeleteRequest(_messages.Message):
  r"""A DialogflowProjectsAgentSessionsEntityTypesDeleteRequest object.

  Fields:
    name: Required. The name of the entity type to delete. Format:
      `projects/<Project ID>/agent/sessions/<Session ID>/entityTypes/<Entity
      Type Display Name>`.
  """

  name = _messages.StringField(1, required=True)


class DialogflowProjectsAgentSessionsEntityTypesGetRequest(_messages.Message):
  r"""A DialogflowProjectsAgentSessionsEntityTypesGetRequest object.

  Fields:
    name: Required. The name of the session entity type. Format:
      `projects/<Project ID>/agent/sessions/<Session ID>/entityTypes/<Entity
      Type Display Name>`.
  """

  name = _messages.StringField(1, required=True)


class DialogflowProjectsAgentSessionsEntityTypesListRequest(_messages.Message):
  r"""A DialogflowProjectsAgentSessionsEntityTypesListRequest object.

  Fields:
    pageSize: Optional. The maximum number of items to return in a single
      page. By default 100 and at most 1000.
    pageToken: Optional. The next_page_token value returned from a previous
      list request.
    parent: Required. The session to list all session entity types from.
      Format: `projects/<Project ID>/agent/sessions/<Session ID>`.
  """

  pageSize = _messages.IntegerField(1, variant=_messages.Variant.INT32)
  pageToken = _messages.StringField(2)
  parent = _messages.StringField(3, required=True)


class DialogflowProjectsAgentSessionsEntityTypesPatchRequest(_messages.Message):
  r"""A DialogflowProjectsAgentSessionsEntityTypesPatchRequest object.

  Fields:
    googleCloudDialogflowV2SessionEntityType: A
      GoogleCloudDialogflowV2SessionEntityType resource to be passed as the
      request body.
    name: Required. The unique identifier of this session entity type. Format:
      `projects/<Project ID>/agent/sessions/<Session ID>/entityTypes/<Entity
      Type Display Name>`.  `<Entity Type Display Name>` must be the display
      name of an existing entity type in the same agent that will be
      overridden or supplemented.
    updateMask: Optional. The mask to control which fields get updated.
  """

  googleCloudDialogflowV2SessionEntityType = _messages.MessageField('GoogleCloudDialogflowV2SessionEntityType', 1)
  name = _messages.StringField(2, required=True)
  updateMask = _messages.StringField(3)


class DialogflowProjectsAgentTrainRequest(_messages.Message):
  r"""A DialogflowProjectsAgentTrainRequest object.

  Fields:
    googleCloudDialogflowV2TrainAgentRequest: A
      GoogleCloudDialogflowV2TrainAgentRequest resource to be passed as the
      request body.
    parent: Required. The project that the agent to train is associated with.
      Format: `projects/<Project ID>`.
  """

  googleCloudDialogflowV2TrainAgentRequest = _messages.MessageField('GoogleCloudDialogflowV2TrainAgentRequest', 1)
  parent = _messages.StringField(2, required=True)


class DialogflowProjectsDeleteAgentRequest(_messages.Message):
  r"""A DialogflowProjectsDeleteAgentRequest object.

  Fields:
    parent: Required. The project that the agent to delete is associated with.
      Format: `projects/<Project ID>`.
  """

  parent = _messages.StringField(1, required=True)


class DialogflowProjectsGetAgentRequest(_messages.Message):
  r"""A DialogflowProjectsGetAgentRequest object.

  Fields:
    parent: Required. The project that the agent to fetch is associated with.
      Format: `projects/<Project ID>`.
  """

  parent = _messages.StringField(1, required=True)


class DialogflowProjectsLocationsOperationsCancelRequest(_messages.Message):
  r"""A DialogflowProjectsLocationsOperationsCancelRequest object.

  Fields:
    name: The name of the operation resource to be cancelled.
  """

  name = _messages.StringField(1, required=True)


class DialogflowProjectsLocationsOperationsGetRequest(_messages.Message):
  r"""A DialogflowProjectsLocationsOperationsGetRequest object.

  Fields:
    name: The name of the operation resource.
  """

  name = _messages.StringField(1, required=True)


class DialogflowProjectsLocationsOperationsListRequest(_messages.Message):
  r"""A DialogflowProjectsLocationsOperationsListRequest object.

  Fields:
    filter: The standard list filter.
    name: The name of the operation's parent resource.
    pageSize: The standard list page size.
    pageToken: The standard list page token.
  """

  filter = _messages.StringField(1)
  name = _messages.StringField(2, required=True)
  pageSize = _messages.IntegerField(3, variant=_messages.Variant.INT32)
  pageToken = _messages.StringField(4)


class DialogflowProjectsOperationsCancelRequest(_messages.Message):
  r"""A DialogflowProjectsOperationsCancelRequest object.

  Fields:
    name: The name of the operation resource to be cancelled.
  """

  name = _messages.StringField(1, required=True)


class DialogflowProjectsOperationsGetRequest(_messages.Message):
  r"""A DialogflowProjectsOperationsGetRequest object.

  Fields:
    name: The name of the operation resource.
  """

  name = _messages.StringField(1, required=True)


class DialogflowProjectsOperationsListRequest(_messages.Message):
  r"""A DialogflowProjectsOperationsListRequest object.

  Fields:
    filter: The standard list filter.
    name: The name of the operation's parent resource.
    pageSize: The standard list page size.
    pageToken: The standard list page token.
  """

  filter = _messages.StringField(1)
  name = _messages.StringField(2, required=True)
  pageSize = _messages.IntegerField(3, variant=_messages.Variant.INT32)
  pageToken = _messages.StringField(4)


class GoogleCloudDialogflowV2Agent(_messages.Message):
  r"""Represents a conversational agent.

  Enums:
    ApiVersionValueValuesEnum: Optional. API version displayed in Dialogflow
      console. If not specified, V2 API is assumed. Clients are free to query
      different service endpoints for different API versions. However, bots
      connectors and webhook calls will follow the specified API version.
    MatchModeValueValuesEnum: Optional. Determines how intents are detected
      from user queries.
    TierValueValuesEnum: Optional. The agent tier. If not specified,
      TIER_STANDARD is assumed.

  Fields:
    apiVersion: Optional. API version displayed in Dialogflow console. If not
      specified, V2 API is assumed. Clients are free to query different
      service endpoints for different API versions. However, bots connectors
      and webhook calls will follow the specified API version.
    avatarUri: Optional. The URI of the agent's avatar. Avatars are used
      throughout the Dialogflow console and in the self-hosted [Web
      Demo](https://cloud.google.com/dialogflow/docs/integrations/web-demo)
      integration.
    classificationThreshold: Optional. To filter out false positive results
      and still get variety in matched natural language inputs for your agent,
      you can tune the machine learning classification threshold. If the
      returned score value is less than the threshold value, then a fallback
      intent will be triggered or, if there are no fallback intents defined,
      no intent will be triggered. The score values range from 0.0 (completely
      uncertain) to 1.0 (completely certain). If set to 0.0, the default of
      0.3 is used.
    defaultLanguageCode: Required. The default language of the agent as a
      language tag. See [Language
      Support](https://cloud.google.com/dialogflow/docs/reference/language)
      for a list of the currently supported language codes. This field cannot
      be set by the `Update` method.
    description: Optional. The description of this agent. The maximum length
      is 500 characters. If exceeded, the request is rejected.
    displayName: Required. The name of this agent.
    enableLogging: Optional. Determines whether this agent should log
      conversation queries.
    matchMode: Optional. Determines how intents are detected from user
      queries.
    parent: Required. The project of this agent. Format: `projects/<Project
      ID>`.
    supportedLanguageCodes: Optional. The list of all languages supported by
      this agent (except for the `default_language_code`).
    tier: Optional. The agent tier. If not specified, TIER_STANDARD is
      assumed.
    timeZone: Required. The time zone of this agent from the [time zone
      database](https://www.iana.org/time-zones), e.g., America/New_York,
      Europe/Paris.
  """

  class ApiVersionValueValuesEnum(_messages.Enum):
    r"""Optional. API version displayed in Dialogflow console. If not
    specified, V2 API is assumed. Clients are free to query different service
    endpoints for different API versions. However, bots connectors and webhook
    calls will follow the specified API version.

    Values:
      API_VERSION_UNSPECIFIED: Not specified.
      API_VERSION_V1: Legacy V1 API.
      API_VERSION_V2: V2 API.
      API_VERSION_V2_BETA_1: V2beta1 API.
    """
    API_VERSION_UNSPECIFIED = 0
    API_VERSION_V1 = 1
    API_VERSION_V2 = 2
    API_VERSION_V2_BETA_1 = 3

  class MatchModeValueValuesEnum(_messages.Enum):
    r"""Optional. Determines how intents are detected from user queries.

    Values:
      MATCH_MODE_UNSPECIFIED: Not specified.
      MATCH_MODE_HYBRID: Best for agents with a small number of examples in
        intents and/or wide use of templates syntax and composite entities.
      MATCH_MODE_ML_ONLY: Can be used for agents with a large number of
        examples in intents, especially the ones using @sys.any or very large
        developer entities.
    """
    MATCH_MODE_UNSPECIFIED = 0
    MATCH_MODE_HYBRID = 1
    MATCH_MODE_ML_ONLY = 2

  class TierValueValuesEnum(_messages.Enum):
    r"""Optional. The agent tier. If not specified, TIER_STANDARD is assumed.

    Values:
      TIER_UNSPECIFIED: Not specified. This value should never be used.
      TIER_STANDARD: Standard tier.
      TIER_ENTERPRISE: Enterprise tier (Essentials).
      TIER_ENTERPRISE_PLUS: Enterprise tier (Plus).
    """
    TIER_UNSPECIFIED = 0
    TIER_STANDARD = 1
    TIER_ENTERPRISE = 2
    TIER_ENTERPRISE_PLUS = 3

  apiVersion = _messages.EnumField('ApiVersionValueValuesEnum', 1)
  avatarUri = _messages.StringField(2)
  classificationThreshold = _messages.FloatField(3, variant=_messages.Variant.FLOAT)
  defaultLanguageCode = _messages.StringField(4)
  description = _messages.StringField(5)
  displayName = _messages.StringField(6)
  enableLogging = _messages.BooleanField(7)
  matchMode = _messages.EnumField('MatchModeValueValuesEnum', 8)
  parent = _messages.StringField(9)
  supportedLanguageCodes = _messages.StringField(10, repeated=True)
  tier = _messages.EnumField('TierValueValuesEnum', 11)
  timeZone = _messages.StringField(12)


class GoogleCloudDialogflowV2BatchCreateEntitiesRequest(_messages.Message):
  r"""The request message for EntityTypes.BatchCreateEntities.

  Fields:
    entities: Required. The entities to create.
    languageCode: Optional. The language of entity synonyms defined in
      `entities`. If not specified, the agent's default language is used.
      [Many
      languages](https://cloud.google.com/dialogflow/docs/reference/language)
      are supported. Note: languages must be enabled in the agent before they
      can be used.
  """

  entities = _messages.MessageField('GoogleCloudDialogflowV2EntityTypeEntity', 1, repeated=True)
  languageCode = _messages.StringField(2)


class GoogleCloudDialogflowV2BatchDeleteEntitiesRequest(_messages.Message):
  r"""The request message for EntityTypes.BatchDeleteEntities.

  Fields:
    entityValues: Required. The canonical `values` of the entities to delete.
      Note that these are not fully-qualified names, i.e. they don't start
      with `projects/<Project ID>`.
    languageCode: Optional. The language of entity synonyms defined in
      `entities`. If not specified, the agent's default language is used.
      [Many
      languages](https://cloud.google.com/dialogflow/docs/reference/language)
      are supported. Note: languages must be enabled in the agent before they
      can be used.
  """

  entityValues = _messages.StringField(1, repeated=True)
  languageCode = _messages.StringField(2)


class GoogleCloudDialogflowV2BatchDeleteEntityTypesRequest(_messages.Message):
  r"""The request message for EntityTypes.BatchDeleteEntityTypes.

  Fields:
    entityTypeNames: Required. The names entity types to delete. All names
      must point to the same agent as `parent`.
  """

  entityTypeNames = _messages.StringField(1, repeated=True)


class GoogleCloudDialogflowV2BatchDeleteIntentsRequest(_messages.Message):
  r"""The request message for Intents.BatchDeleteIntents.

  Fields:
    intents: Required. The collection of intents to delete. Only intent `name`
      must be filled in.
  """

  intents = _messages.MessageField('GoogleCloudDialogflowV2Intent', 1, repeated=True)


class GoogleCloudDialogflowV2BatchUpdateEntitiesRequest(_messages.Message):
  r"""The request message for EntityTypes.BatchUpdateEntities.

  Fields:
    entities: Required. The entities to update or create.
    languageCode: Optional. The language of entity synonyms defined in
      `entities`. If not specified, the agent's default language is used.
      [Many
      languages](https://cloud.google.com/dialogflow/docs/reference/language)
      are supported. Note: languages must be enabled in the agent before they
      can be used.
    updateMask: Optional. The mask to control which fields get updated.
  """

  entities = _messages.MessageField('GoogleCloudDialogflowV2EntityTypeEntity', 1, repeated=True)
  languageCode = _messages.StringField(2)
  updateMask = _messages.StringField(3)


class GoogleCloudDialogflowV2BatchUpdateEntityTypesRequest(_messages.Message):
  r"""The request message for EntityTypes.BatchUpdateEntityTypes.

  Fields:
    entityTypeBatchInline: The collection of entity types to update or create.
    entityTypeBatchUri: The URI to a Google Cloud Storage file containing
      entity types to update or create. The file format can either be a
      serialized proto (of EntityBatch type) or a JSON object. Note: The URI
      must start with "gs://".
    languageCode: Optional. The language of entity synonyms defined in
      `entity_types`. If not specified, the agent's default language is used.
      [Many
      languages](https://cloud.google.com/dialogflow/docs/reference/language)
      are supported. Note: languages must be enabled in the agent before they
      can be used.
    updateMask: Optional. The mask to control which fields get updated.
  """

  entityTypeBatchInline = _messages.MessageField('GoogleCloudDialogflowV2EntityTypeBatch', 1)
  entityTypeBatchUri = _messages.StringField(2)
  languageCode = _messages.StringField(3)
  updateMask = _messages.StringField(4)


class GoogleCloudDialogflowV2BatchUpdateEntityTypesResponse(_messages.Message):
  r"""The response message for EntityTypes.BatchUpdateEntityTypes.

  Fields:
    entityTypes: The collection of updated or created entity types.
  """

  entityTypes = _messages.MessageField('GoogleCloudDialogflowV2EntityType', 1, repeated=True)


class GoogleCloudDialogflowV2BatchUpdateIntentsRequest(_messages.Message):
  r"""The request message for Intents.BatchUpdateIntents.

  Enums:
    IntentViewValueValuesEnum: Optional. The resource view to apply to the
      returned intent.

  Fields:
    intentBatchInline: The collection of intents to update or create.
    intentBatchUri: The URI to a Google Cloud Storage file containing intents
      to update or create. The file format can either be a serialized proto
      (of IntentBatch type) or JSON object. Note: The URI must start with
      "gs://".
    intentView: Optional. The resource view to apply to the returned intent.
    languageCode: Optional. The language of training phrases, parameters and
      rich messages defined in `intents`. If not specified, the agent's
      default language is used. [Many
      languages](https://cloud.google.com/dialogflow/docs/reference/language)
      are supported. Note: languages must be enabled in the agent before they
      can be used.
    updateMask: Optional. The mask to control which fields get updated.
  """

  class IntentViewValueValuesEnum(_messages.Enum):
    r"""Optional. The resource view to apply to the returned intent.

    Values:
      INTENT_VIEW_UNSPECIFIED: Training phrases field is not populated in the
        response.
      INTENT_VIEW_FULL: All fields are populated.
    """
    INTENT_VIEW_UNSPECIFIED = 0
    INTENT_VIEW_FULL = 1

  intentBatchInline = _messages.MessageField('GoogleCloudDialogflowV2IntentBatch', 1)
  intentBatchUri = _messages.StringField(2)
  intentView = _messages.EnumField('IntentViewValueValuesEnum', 3)
  languageCode = _messages.StringField(4)
  updateMask = _messages.StringField(5)


class GoogleCloudDialogflowV2BatchUpdateIntentsResponse(_messages.Message):
  r"""The response message for Intents.BatchUpdateIntents.

  Fields:
    intents: The collection of updated or created intents.
  """

  intents = _messages.MessageField('GoogleCloudDialogflowV2Intent', 1, repeated=True)


class GoogleCloudDialogflowV2Context(_messages.Message):
  r"""Represents a context.

  Messages:
    ParametersValue: Optional. The collection of parameters associated with
      this context. Refer to [this
      doc](https://cloud.google.com/dialogflow/docs/intents-actions-
      parameters) for syntax.

  Fields:
    lifespanCount: Optional. The number of conversational query requests after
      which the context expires. If set to `0` (the default) the context
      expires immediately. Contexts expire automatically after 20 minutes if
      there are no matching queries.
    name: Required. The unique identifier of the context. Format:
      `projects/<Project ID>/agent/sessions/<Session ID>/contexts/<Context
      ID>`.  The `Context ID` is always converted to lowercase, may only
      contain characters in [a-zA-Z0-9_-%] and may be at most 250 bytes long.
    parameters: Optional. The collection of parameters associated with this
      context. Refer to [this doc](https://cloud.google.com/dialogflow/docs
      /intents-actions-parameters) for syntax.
  """

  @encoding.MapUnrecognizedFields('additionalProperties')
  class ParametersValue(_messages.Message):
    r"""Optional. The collection of parameters associated with this context.
    Refer to [this doc](https://cloud.google.com/dialogflow/docs/intents-
    actions-parameters) for syntax.

    Messages:
      AdditionalProperty: An additional property for a ParametersValue object.

    Fields:
      additionalProperties: Properties of the object.
    """

    class AdditionalProperty(_messages.Message):
      r"""An additional property for a ParametersValue object.

      Fields:
        key: Name of the additional property.
        value: A extra_types.JsonValue attribute.
      """

      key = _messages.StringField(1)
      value = _messages.MessageField('extra_types.JsonValue', 2)

    additionalProperties = _messages.MessageField('AdditionalProperty', 1, repeated=True)

  lifespanCount = _messages.IntegerField(1, variant=_messages.Variant.INT32)
  name = _messages.StringField(2)
  parameters = _messages.MessageField('ParametersValue', 3)


class GoogleCloudDialogflowV2DetectIntentRequest(_messages.Message):
  r"""The request to detect user's intent.

  Fields:
    inputAudio: Optional. The natural language speech audio to be processed.
      This field should be populated iff `query_input` is set to an input
      audio config. A single request can contain up to 1 minute of speech
      audio data.
    outputAudioConfig: Optional. Instructs the speech synthesizer how to
      generate the output audio. If this field is not set and agent-level
      speech synthesizer is not configured, no output audio is generated.
    queryInput: Required. The input specification. It can be set to:  1.  an
      audio config     which instructs the speech recognizer how to process
      the speech audio,  2.  a conversational query in the form of text, or
      3.  an event that specifies which intent to trigger.
    queryParams: Optional. The parameters of this query.
  """

  inputAudio = _messages.BytesField(1)
  outputAudioConfig = _messages.MessageField('GoogleCloudDialogflowV2OutputAudioConfig', 2)
  queryInput = _messages.MessageField('GoogleCloudDialogflowV2QueryInput', 3)
  queryParams = _messages.MessageField('GoogleCloudDialogflowV2QueryParameters', 4)


class GoogleCloudDialogflowV2DetectIntentResponse(_messages.Message):
  r"""The message returned from the DetectIntent method.

  Fields:
    outputAudio: The audio data bytes encoded as specified in the request.
      Note: The output audio is generated based on the values of default
      platform text responses found in the `query_result.fulfillment_messages`
      field. If multiple default text responses exist, they will be
      concatenated when generating audio. If no default platform text
      responses exist, the generated audio content will be empty.
    outputAudioConfig: The config used by the speech synthesizer to generate
      the output audio.
    queryResult: The selected results of the conversational query or event
      processing. See `alternative_query_results` for additional potential
      results.
    responseId: The unique identifier of the response. It can be used to
      locate a response in the training example set or for reporting issues.
    webhookStatus: Specifies the status of the webhook request.
  """

  outputAudio = _messages.BytesField(1)
  outputAudioConfig = _messages.MessageField('GoogleCloudDialogflowV2OutputAudioConfig', 2)
  queryResult = _messages.MessageField('GoogleCloudDialogflowV2QueryResult', 3)
  responseId = _messages.StringField(4)
  webhookStatus = _messages.MessageField('GoogleRpcStatus', 5)


class GoogleCloudDialogflowV2EntityType(_messages.Message):
  r"""Represents an entity type. Entity types serve as a tool for extracting
  parameter values from natural language queries.

  Enums:
    AutoExpansionModeValueValuesEnum: Optional. Indicates whether the entity
      type can be automatically expanded.
    KindValueValuesEnum: Required. Indicates the kind of entity type.

  Fields:
    autoExpansionMode: Optional. Indicates whether the entity type can be
      automatically expanded.
    displayName: Required. The name of the entity type.
    enableFuzzyExtraction: Optional. Enables fuzzy entity extraction during
      classification.
    entities: Optional. The collection of entity entries associated with the
      entity type.
    kind: Required. Indicates the kind of entity type.
    name: The unique identifier of the entity type. Required for
      EntityTypes.UpdateEntityType and EntityTypes.BatchUpdateEntityTypes
      methods. Format: `projects/<Project ID>/agent/entityTypes/<Entity Type
      ID>`.
  """

  class AutoExpansionModeValueValuesEnum(_messages.Enum):
    r"""Optional. Indicates whether the entity type can be automatically
    expanded.

    Values:
      AUTO_EXPANSION_MODE_UNSPECIFIED: Auto expansion disabled for the entity.
      AUTO_EXPANSION_MODE_DEFAULT: Allows an agent to recognize values that
        have not been explicitly listed in the entity.
    """
    AUTO_EXPANSION_MODE_UNSPECIFIED = 0
    AUTO_EXPANSION_MODE_DEFAULT = 1

  class KindValueValuesEnum(_messages.Enum):
    r"""Required. Indicates the kind of entity type.

    Values:
      KIND_UNSPECIFIED: Not specified. This value should be never used.
      KIND_MAP: Map entity types allow mapping of a group of synonyms to a
        canonical value.
      KIND_LIST: List entity types contain a set of entries that do not map to
        canonical values. However, list entity types can contain references to
        other entity types (with or without aliases).
      KIND_REGEXP: Regexp entity types allow to specify regular expressions in
        entries values.
    """
    KIND_UNSPECIFIED = 0
    KIND_MAP = 1
    KIND_LIST = 2
    KIND_REGEXP = 3

  autoExpansionMode = _messages.EnumField('AutoExpansionModeValueValuesEnum', 1)
  displayName = _messages.StringField(2)
  enableFuzzyExtraction = _messages.BooleanField(3)
  entities = _messages.MessageField('GoogleCloudDialogflowV2EntityTypeEntity', 4, repeated=True)
  kind = _messages.EnumField('KindValueValuesEnum', 5)
  name = _messages.StringField(6)


class GoogleCloudDialogflowV2EntityTypeBatch(_messages.Message):
  r"""This message is a wrapper around a collection of entity types.

  Fields:
    entityTypes: A collection of entity types.
  """

  entityTypes = _messages.MessageField('GoogleCloudDialogflowV2EntityType', 1, repeated=True)


class GoogleCloudDialogflowV2EntityTypeEntity(_messages.Message):
  r"""An **entity entry** for an associated entity type.

  Fields:
    synonyms: Required. A collection of value synonyms. For example, if the
      entity type is *vegetable*, and `value` is *scallions*, a synonym could
      be *green onions*.  For `KIND_LIST` entity types:  *   This collection
      must contain exactly one synonym equal to `value`.
    value: Required. The primary value associated with this entity entry. For
      example, if the entity type is *vegetable*, the value could be
      *scallions*.  For `KIND_MAP` entity types:  *   A canonical value to be
      used in place of synonyms.  For `KIND_LIST` entity types:  *   A string
      that can contain references to other entity types (with or     without
      aliases).
  """

  synonyms = _messages.StringField(1, repeated=True)
  value = _messages.StringField(2)


class GoogleCloudDialogflowV2EventInput(_messages.Message):
  r"""Events allow for matching intents by event name instead of the natural
  language input. For instance, input `<event: { name: "welcome_event",
  parameters: { name: "Sam" } }>` can trigger a personalized welcome response.
  The parameter `name` may be used by the agent in the response: `"Hello
  #welcome_event.name! What can I do for you today?"`.

  Messages:
    ParametersValue: Optional. The collection of parameters associated with
      the event.

  Fields:
    languageCode: Required. The language of this query. See [Language
      Support](https://cloud.google.com/dialogflow/docs/reference/language)
      for a list of the currently supported language codes. Note that queries
      in the same session do not necessarily need to specify the same
      language.
    name: Required. The unique identifier of the event.
    parameters: Optional. The collection of parameters associated with the
      event.
  """

  @encoding.MapUnrecognizedFields('additionalProperties')
  class ParametersValue(_messages.Message):
    r"""Optional. The collection of parameters associated with the event.

    Messages:
      AdditionalProperty: An additional property for a ParametersValue object.

    Fields:
      additionalProperties: Properties of the object.
    """

    class AdditionalProperty(_messages.Message):
      r"""An additional property for a ParametersValue object.

      Fields:
        key: Name of the additional property.
        value: A extra_types.JsonValue attribute.
      """

      key = _messages.StringField(1)
      value = _messages.MessageField('extra_types.JsonValue', 2)

    additionalProperties = _messages.MessageField('AdditionalProperty', 1, repeated=True)

  languageCode = _messages.StringField(1)
  name = _messages.StringField(2)
  parameters = _messages.MessageField('ParametersValue', 3)


class GoogleCloudDialogflowV2ExportAgentRequest(_messages.Message):
  r"""The request message for Agents.ExportAgent.

  Fields:
    agentUri: Optional. The [Google Cloud
      Storage](https://cloud.google.com/storage/docs/) URI to export the agent
      to. The format of this URI must be `gs://<bucket-name>/<object-name>`.
      If left unspecified, the serialized agent is returned inline.
  """

  agentUri = _messages.StringField(1)


class GoogleCloudDialogflowV2ExportAgentResponse(_messages.Message):
  r"""The response message for Agents.ExportAgent.

  Fields:
    agentContent: The exported agent.  Example for how to export an agent to a
      zip file via a command line: <pre>curl \   'https://dialogflow.googleapi
      s.com/v2/projects/&lt;project_id&gt;/agent:export'\   -X POST \   -H
      'Authorization: Bearer' \   $(gcloud auth application-default print-
      access-token) \   -H 'Accept: application/json'   --compressed \   |
      grep agentContent | sed -e 's/.*"agentContent": "\([^"]*\)".*/\1/' \   |
      base64 --decode > &lt;agent zip file&gt;</pre>
    agentUri: The URI to a file containing the exported agent. This field is
      populated only if `agent_uri` is specified in `ExportAgentRequest`.
  """

  agentContent = _messages.BytesField(1)
  agentUri = _messages.StringField(2)


class GoogleCloudDialogflowV2ImportAgentRequest(_messages.Message):
  r"""The request message for Agents.ImportAgent.

  Fields:
    agentContent: The agent to import.  Example for how to import an agent via
      the command line: <pre>curl \   'https://dialogflow.googleapis.com/v2/pr
      ojects/&lt;project_id&gt;/agent:import'\    -X POST \    -H
      'Authorization: Bearer'\    $(gcloud auth application-default print-
      access-token) \    -H 'Accept: application/json' \    -H 'Content-Type:
      application/json' \    --data-binary "{       'agentContent': '$(cat
      &lt;agent zip file&gt; | base64 -w 0)'    }"</pre>
    agentUri: The URI to a Google Cloud Storage file containing the agent to
      import. Note: The URI must start with "gs://".
  """

  agentContent = _messages.BytesField(1)
  agentUri = _messages.StringField(2)


class GoogleCloudDialogflowV2InputAudioConfig(_messages.Message):
  r"""Instructs the speech recognizer how to process the audio content.

  Enums:
    AudioEncodingValueValuesEnum: Required. Audio encoding of the audio
      content to process.
    ModelVariantValueValuesEnum: Optional. Which variant of the Speech model
      to use.

  Fields:
    audioEncoding: Required. Audio encoding of the audio content to process.
    languageCode: Required. The language of the supplied audio. Dialogflow
      does not do translations. See [Language
      Support](https://cloud.google.com/dialogflow/docs/reference/language)
      for a list of the currently supported language codes. Note that queries
      in the same session do not necessarily need to specify the same
      language.
    modelVariant: Optional. Which variant of the Speech model to use.
    phraseHints: Optional. A list of strings containing words and phrases that
      the speech recognizer should recognize with higher likelihood.  See [the
      Cloud Speech documentation](https://cloud.google.com/speech-to-
      text/docs/basics#phrase-hints) for more details.
    sampleRateHertz: Required. Sample rate (in Hertz) of the audio content
      sent in the query. Refer to [Cloud Speech API
      documentation](https://cloud.google.com/speech-to-text/docs/basics) for
      more details.
    singleUtterance: Optional. If `false` (default), recognition does not
      cease until the client closes the stream. If `true`, the recognizer will
      detect a single spoken utterance in input audio. Recognition ceases when
      it detects the audio's voice has stopped or paused. In this case, once a
      detected intent is received, the client should close the stream and
      start a new request with a new stream as needed. Note: This setting is
      relevant only for streaming methods. Note: When specified,
      InputAudioConfig.single_utterance takes precedence over
      StreamingDetectIntentRequest.single_utterance.
  """

  class AudioEncodingValueValuesEnum(_messages.Enum):
    r"""Required. Audio encoding of the audio content to process.

    Values:
      AUDIO_ENCODING_UNSPECIFIED: Not specified.
      AUDIO_ENCODING_LINEAR_16: Uncompressed 16-bit signed little-endian
        samples (Linear PCM).
      AUDIO_ENCODING_FLAC: [`FLAC`](https://xiph.org/flac/documentation.html)
        (Free Lossless Audio Codec) is the recommended encoding because it is
        lossless (therefore recognition is not compromised) and requires only
        about half the bandwidth of `LINEAR16`. `FLAC` stream encoding
        supports 16-bit and 24-bit samples, however, not all fields in
        `STREAMINFO` are supported.
      AUDIO_ENCODING_MULAW: 8-bit samples that compand 14-bit audio samples
        using G.711 PCMU/mu-law.
      AUDIO_ENCODING_AMR: Adaptive Multi-Rate Narrowband codec.
        `sample_rate_hertz` must be 8000.
      AUDIO_ENCODING_AMR_WB: Adaptive Multi-Rate Wideband codec.
        `sample_rate_hertz` must be 16000.
      AUDIO_ENCODING_OGG_OPUS: Opus encoded audio frames in Ogg container
        ([OggOpus](https://wiki.xiph.org/OggOpus)). `sample_rate_hertz` must
        be 16000.
      AUDIO_ENCODING_SPEEX_WITH_HEADER_BYTE: Although the use of lossy
        encodings is not recommended, if a very low bitrate encoding is
        required, `OGG_OPUS` is highly preferred over Speex encoding. The
        [Speex](https://speex.org/) encoding supported by Dialogflow API has a
        header byte in each block, as in MIME type `audio/x-speex-with-header-
        byte`. It is a variant of the RTP Speex encoding defined in [RFC
        5574](https://tools.ietf.org/html/rfc5574). The stream is a sequence
        of blocks, one block per RTP packet. Each block starts with a byte
        containing the length of the block, in bytes, followed by one or more
        frames of Speex data, padded to an integral number of bytes (octets)
        as specified in RFC 5574. In other words, each RTP header is replaced
        with a single byte containing the block length. Only Speex wideband is
        supported. `sample_rate_hertz` must be 16000.
    """
    AUDIO_ENCODING_UNSPECIFIED = 0
    AUDIO_ENCODING_LINEAR_16 = 1
    AUDIO_ENCODING_FLAC = 2
    AUDIO_ENCODING_MULAW = 3
    AUDIO_ENCODING_AMR = 4
    AUDIO_ENCODING_AMR_WB = 5
    AUDIO_ENCODING_OGG_OPUS = 6
    AUDIO_ENCODING_SPEEX_WITH_HEADER_BYTE = 7

  class ModelVariantValueValuesEnum(_messages.Enum):
    r"""Optional. Which variant of the Speech model to use.

    Values:
      SPEECH_MODEL_VARIANT_UNSPECIFIED: No model variant specified. In this
        case Dialogflow defaults to USE_BEST_AVAILABLE.
      USE_BEST_AVAILABLE: Use the best available variant of the Speech model
        that the caller is eligible for.  Please see the [Dialogflow
        docs](https://cloud.google.com/dialogflow/docs/data-logging) for how
        to make your project eligible for enhanced models.
      USE_STANDARD: Use standard model variant even if an enhanced model is
        available.  See the [Cloud Speech
        documentation](https://cloud.google.com/speech-to-text/docs/enhanced-
        models) for details about enhanced models.
      USE_ENHANCED: Use an enhanced model variant:  * If an enhanced variant
        does not exist for the given   model and request language, Dialogflow
        falls   back to the standard variant.    The [Cloud Speech
        documentation](https://cloud.google.com/speech-to-text/docs/enhanced-
        models)   describes which models have enhanced variants.  * If the API
        caller isn't eligible for enhanced models, Dialogflow returns   an
        error. Please see the [Dialogflow
        docs](https://cloud.google.com/dialogflow/docs/data-logging)   for how
        to make your project eligible.
    """
    SPEECH_MODEL_VARIANT_UNSPECIFIED = 0
    USE_BEST_AVAILABLE = 1
    USE_STANDARD = 2
    USE_ENHANCED = 3

  audioEncoding = _messages.EnumField('AudioEncodingValueValuesEnum', 1)
  languageCode = _messages.StringField(2)
  modelVariant = _messages.EnumField('ModelVariantValueValuesEnum', 3)
  phraseHints = _messages.StringField(4, repeated=True)
  sampleRateHertz = _messages.IntegerField(5, variant=_messages.Variant.INT32)
  singleUtterance = _messages.BooleanField(6)


class GoogleCloudDialogflowV2Intent(_messages.Message):
  r"""Represents an intent. Intents convert a number of user expressions or
  patterns into an action. An action is an extraction of a user command or
  sentence semantics.

  Enums:
    DefaultResponsePlatformsValueListEntryValuesEnum:
    WebhookStateValueValuesEnum: Optional. Indicates whether webhooks are
      enabled for the intent.

  Fields:
    action: Optional. The name of the action associated with the intent. Note:
      The action name must not contain whitespaces.
    defaultResponsePlatforms: Optional. The list of platforms for which the
      first responses will be copied from the messages in PLATFORM_UNSPECIFIED
      (i.e. default platform).
    displayName: Required. The name of this intent.
    events: Optional. The collection of event names that trigger the intent.
      If the collection of input contexts is not empty, all of the contexts
      must be present in the active user session for an event to trigger this
      intent.
    followupIntentInfo: Read-only. Information about all followup intents that
      have this intent as a direct or indirect parent. We populate this field
      only in the output.
    inputContextNames: Optional. The list of context names required for this
      intent to be triggered. Format: `projects/<Project
      ID>/agent/sessions/-/contexts/<Context ID>`.
    isFallback: Optional. Indicates whether this is a fallback intent.
    messages: Optional. The collection of rich messages corresponding to the
      `Response` field in the Dialogflow console.
    mlDisabled: Optional. Indicates whether Machine Learning is disabled for
      the intent. Note: If `ml_diabled` setting is set to true, then this
      intent is not taken into account during inference in `ML ONLY` match
      mode. Also, auto-markup in the UI is turned off.
    name: The unique identifier of this intent. Required for
      Intents.UpdateIntent and Intents.BatchUpdateIntents methods. Format:
      `projects/<Project ID>/agent/intents/<Intent ID>`.
    outputContexts: Optional. The collection of contexts that are activated
      when the intent is matched. Context messages in this collection should
      not set the parameters field. Setting the `lifespan_count` to 0 will
      reset the context when the intent is matched. Format: `projects/<Project
      ID>/agent/sessions/-/contexts/<Context ID>`.
    parameters: Optional. The collection of parameters associated with the
      intent.
    parentFollowupIntentName: Read-only after creation. The unique identifier
      of the parent intent in the chain of followup intents. You can set this
      field when creating an intent, for example with CreateIntent or
      BatchUpdateIntents, in order to make this intent a followup intent.  It
      identifies the parent followup intent. Format: `projects/<Project
      ID>/agent/intents/<Intent ID>`.
    priority: Optional. The priority of this intent. Higher numbers represent
      higher priorities. If this is zero or unspecified, we use the default
      priority 500000.  Negative numbers mean that the intent is disabled.
    resetContexts: Optional. Indicates whether to delete all contexts in the
      current session when this intent is matched.
    rootFollowupIntentName: Read-only. The unique identifier of the root
      intent in the chain of followup intents. It identifies the correct
      followup intents chain for this intent. We populate this field only in
      the output.  Format: `projects/<Project ID>/agent/intents/<Intent ID>`.
    trainingPhrases: Optional. The collection of examples that the agent is
      trained on.
    webhookState: Optional. Indicates whether webhooks are enabled for the
      intent.
  """

  class DefaultResponsePlatformsValueListEntryValuesEnum(_messages.Enum):
    r"""DefaultResponsePlatformsValueListEntryValuesEnum enum type.

    Values:
      PLATFORM_UNSPECIFIED: <no description>
      FACEBOOK: <no description>
      SLACK: <no description>
      TELEGRAM: <no description>
      KIK: <no description>
      SKYPE: <no description>
      LINE: <no description>
      VIBER: <no description>
      ACTIONS_ON_GOOGLE: <no description>
      GOOGLE_HANGOUTS: <no description>
    """
    PLATFORM_UNSPECIFIED = 0
    FACEBOOK = 1
    SLACK = 2
    TELEGRAM = 3
    KIK = 4
    SKYPE = 5
    LINE = 6
    VIBER = 7
    ACTIONS_ON_GOOGLE = 8
    GOOGLE_HANGOUTS = 9

  class WebhookStateValueValuesEnum(_messages.Enum):
    r"""Optional. Indicates whether webhooks are enabled for the intent.

    Values:
      WEBHOOK_STATE_UNSPECIFIED: Webhook is disabled in the agent and in the
        intent.
      WEBHOOK_STATE_ENABLED: Webhook is enabled in the agent and in the
        intent.
      WEBHOOK_STATE_ENABLED_FOR_SLOT_FILLING: Webhook is enabled in the agent
        and in the intent. Also, each slot filling prompt is forwarded to the
        webhook.
    """
    WEBHOOK_STATE_UNSPECIFIED = 0
    WEBHOOK_STATE_ENABLED = 1
    WEBHOOK_STATE_ENABLED_FOR_SLOT_FILLING = 2

  action = _messages.StringField(1)
  defaultResponsePlatforms = _messages.EnumField('DefaultResponsePlatformsValueListEntryValuesEnum', 2, repeated=True)
  displayName = _messages.StringField(3)
  events = _messages.StringField(4, repeated=True)
  followupIntentInfo = _messages.MessageField('GoogleCloudDialogflowV2IntentFollowupIntentInfo', 5, repeated=True)
  inputContextNames = _messages.StringField(6, repeated=True)
  isFallback = _messages.BooleanField(7)
  messages = _messages.MessageField('GoogleCloudDialogflowV2IntentMessage', 8, repeated=True)
  mlDisabled = _messages.BooleanField(9)
  name = _messages.StringField(10)
  outputContexts = _messages.MessageField('GoogleCloudDialogflowV2Context', 11, repeated=True)
  parameters = _messages.MessageField('GoogleCloudDialogflowV2IntentParameter', 12, repeated=True)
  parentFollowupIntentName = _messages.StringField(13)
  priority = _messages.IntegerField(14, variant=_messages.Variant.INT32)
  resetContexts = _messages.BooleanField(15)
  rootFollowupIntentName = _messages.StringField(16)
  trainingPhrases = _messages.MessageField('GoogleCloudDialogflowV2IntentTrainingPhrase', 17, repeated=True)
  webhookState = _messages.EnumField('WebhookStateValueValuesEnum', 18)


class GoogleCloudDialogflowV2IntentBatch(_messages.Message):
  r"""This message is a wrapper around a collection of intents.

  Fields:
    intents: A collection of intents.
  """

  intents = _messages.MessageField('GoogleCloudDialogflowV2Intent', 1, repeated=True)


class GoogleCloudDialogflowV2IntentFollowupIntentInfo(_messages.Message):
  r"""Represents a single followup intent in the chain.

  Fields:
    followupIntentName: The unique identifier of the followup intent. Format:
      `projects/<Project ID>/agent/intents/<Intent ID>`.
    parentFollowupIntentName: The unique identifier of the followup intent's
      parent. Format: `projects/<Project ID>/agent/intents/<Intent ID>`.
  """

  followupIntentName = _messages.StringField(1)
  parentFollowupIntentName = _messages.StringField(2)


class GoogleCloudDialogflowV2IntentMessage(_messages.Message):
  r"""Corresponds to the `Response` field in the Dialogflow console.

  Enums:
    PlatformValueValuesEnum: Optional. The platform that this message is
      intended for.

  Messages:
    PayloadValue: Returns a response containing a custom, platform-specific
      payload. See the Intent.Message.Platform type for a description of the
      structure that may be required for your platform.

  Fields:
    basicCard: The basic card response for Actions on Google.
    card: The card response.
    carouselSelect: The carousel card response for Actions on Google.
    image: The image response.
    linkOutSuggestion: The link out suggestion chip for Actions on Google.
    listSelect: The list card response for Actions on Google.
    payload: Returns a response containing a custom, platform-specific
      payload. See the Intent.Message.Platform type for a description of the
      structure that may be required for your platform.
    platform: Optional. The platform that this message is intended for.
    quickReplies: The quick replies response.
    simpleResponses: The voice and text-only responses for Actions on Google.
    suggestions: The suggestion chips for Actions on Google.
    text: The text response.
  """

  class PlatformValueValuesEnum(_messages.Enum):
    r"""Optional. The platform that this message is intended for.

    Values:
      PLATFORM_UNSPECIFIED: Not specified.
      FACEBOOK: Facebook.
      SLACK: Slack.
      TELEGRAM: Telegram.
      KIK: Kik.
      SKYPE: Skype.
      LINE: Line.
      VIBER: Viber.
      ACTIONS_ON_GOOGLE: Actions on Google. When using Actions on Google, you
        can choose one of the specific Intent.Message types that mention
        support for Actions on Google, or you can use the advanced
        Intent.Message.payload field. The payload field provides access to AoG
        features not available in the specific message types. If using the
        Intent.Message.payload field, it should have a structure similar to
        the JSON message shown here. For more information, see [Actions on
        Google Webhook
        Format](https://developers.google.com/actions/dialogflow/webhook)
        <pre>{   "expectUserResponse": true,   "isSsml": false,
        "noInputPrompts": [],   "richResponse": {     "items": [       {
        "simpleResponse": {           "displayText": "hi",
        "textToSpeech": "hello"         }       }     ],     "suggestions": [
        {         "title": "Say this"       },       {         "title": "or
        this"       }     ]   },   "systemIntent": {     "data": {
        "@type": "type.googleapis.com/google.actions.v2.OptionValueSpec",
        "listSelect": {         "items": [           {
        "optionInfo": {               "key": "key1",               "synonyms":
        [                 "key one"               ]             },
        "title": "must not be empty, but unique"           },           {
        "optionInfo": {               "key": "key2",               "synonyms":
        [                 "key two"               ]             },
        "title": "must not be empty, but unique"           }         ]       }
        },     "intent": "actions.intent.OPTION"   } }</pre>
      GOOGLE_HANGOUTS: Google Hangouts.
    """
    PLATFORM_UNSPECIFIED = 0
    FACEBOOK = 1
    SLACK = 2
    TELEGRAM = 3
    KIK = 4
    SKYPE = 5
    LINE = 6
    VIBER = 7
    ACTIONS_ON_GOOGLE = 8
    GOOGLE_HANGOUTS = 9

  @encoding.MapUnrecognizedFields('additionalProperties')
  class PayloadValue(_messages.Message):
    r"""Returns a response containing a custom, platform-specific payload. See
    the Intent.Message.Platform type for a description of the structure that
    may be required for your platform.

    Messages:
      AdditionalProperty: An additional property for a PayloadValue object.

    Fields:
      additionalProperties: Properties of the object.
    """

    class AdditionalProperty(_messages.Message):
      r"""An additional property for a PayloadValue object.

      Fields:
        key: Name of the additional property.
        value: A extra_types.JsonValue attribute.
      """

      key = _messages.StringField(1)
      value = _messages.MessageField('extra_types.JsonValue', 2)

    additionalProperties = _messages.MessageField('AdditionalProperty', 1, repeated=True)

  basicCard = _messages.MessageField('GoogleCloudDialogflowV2IntentMessageBasicCard', 1)
  card = _messages.MessageField('GoogleCloudDialogflowV2IntentMessageCard', 2)
  carouselSelect = _messages.MessageField('GoogleCloudDialogflowV2IntentMessageCarouselSelect', 3)
  image = _messages.MessageField('GoogleCloudDialogflowV2IntentMessageImage', 4)
  linkOutSuggestion = _messages.MessageField('GoogleCloudDialogflowV2IntentMessageLinkOutSuggestion', 5)
  listSelect = _messages.MessageField('GoogleCloudDialogflowV2IntentMessageListSelect', 6)
  payload = _messages.MessageField('PayloadValue', 7)
  platform = _messages.EnumField('PlatformValueValuesEnum', 8)
  quickReplies = _messages.MessageField('GoogleCloudDialogflowV2IntentMessageQuickReplies', 9)
  simpleResponses = _messages.MessageField('GoogleCloudDialogflowV2IntentMessageSimpleResponses', 10)
  suggestions = _messages.MessageField('GoogleCloudDialogflowV2IntentMessageSuggestions', 11)
  text = _messages.MessageField('GoogleCloudDialogflowV2IntentMessageText', 12)


class GoogleCloudDialogflowV2IntentMessageBasicCard(_messages.Message):
  r"""The basic card message. Useful for displaying information.

  Fields:
    buttons: Optional. The collection of card buttons.
    formattedText: Required, unless image is present. The body text of the
      card.
    image: Optional. The image for the card.
    subtitle: Optional. The subtitle of the card.
    title: Optional. The title of the card.
  """

  buttons = _messages.MessageField('GoogleCloudDialogflowV2IntentMessageBasicCardButton', 1, repeated=True)
  formattedText = _messages.StringField(2)
  image = _messages.MessageField('GoogleCloudDialogflowV2IntentMessageImage', 3)
  subtitle = _messages.StringField(4)
  title = _messages.StringField(5)


class GoogleCloudDialogflowV2IntentMessageBasicCardButton(_messages.Message):
  r"""The button object that appears at the bottom of a card.

  Fields:
    openUriAction: Required. Action to take when a user taps on the button.
    title: Required. The title of the button.
  """

  openUriAction = _messages.MessageField('GoogleCloudDialogflowV2IntentMessageBasicCardButtonOpenUriAction', 1)
  title = _messages.StringField(2)


class GoogleCloudDialogflowV2IntentMessageBasicCardButtonOpenUriAction(_messages.Message):
  r"""Opens the given URI.

  Fields:
    uri: Required. The HTTP or HTTPS scheme URI.
  """

  uri = _messages.StringField(1)


class GoogleCloudDialogflowV2IntentMessageCard(_messages.Message):
  r"""The card response message.

  Fields:
    buttons: Optional. The collection of card buttons.
    imageUri: Optional. The public URI to an image file for the card.
    subtitle: Optional. The subtitle of the card.
    title: Optional. The title of the card.
  """

  buttons = _messages.MessageField('GoogleCloudDialogflowV2IntentMessageCardButton', 1, repeated=True)
  imageUri = _messages.StringField(2)
  subtitle = _messages.StringField(3)
  title = _messages.StringField(4)


class GoogleCloudDialogflowV2IntentMessageCardButton(_messages.Message):
  r"""Optional. Contains information about a button.

  Fields:
    postback: Optional. The text to send back to the Dialogflow API or a URI
      to open.
    text: Optional. The text to show on the button.
  """

  postback = _messages.StringField(1)
  text = _messages.StringField(2)


class GoogleCloudDialogflowV2IntentMessageCarouselSelect(_messages.Message):
  r"""The card for presenting a carousel of options to select from.

  Fields:
    items: Required. Carousel items.
  """

  items = _messages.MessageField('GoogleCloudDialogflowV2IntentMessageCarouselSelectItem', 1, repeated=True)


class GoogleCloudDialogflowV2IntentMessageCarouselSelectItem(_messages.Message):
  r"""An item in the carousel.

  Fields:
    description: Optional. The body text of the card.
    image: Optional. The image to display.
    info: Required. Additional info about the option item.
    title: Required. Title of the carousel item.
  """

  description = _messages.StringField(1)
  image = _messages.MessageField('GoogleCloudDialogflowV2IntentMessageImage', 2)
  info = _messages.MessageField('GoogleCloudDialogflowV2IntentMessageSelectItemInfo', 3)
  title = _messages.StringField(4)


class GoogleCloudDialogflowV2IntentMessageImage(_messages.Message):
  r"""The image response message.

  Fields:
    accessibilityText: Optional. A text description of the image to be used
      for accessibility, e.g., screen readers.
    imageUri: Optional. The public URI to an image file.
  """

  accessibilityText = _messages.StringField(1)
  imageUri = _messages.StringField(2)


class GoogleCloudDialogflowV2IntentMessageLinkOutSuggestion(_messages.Message):
  r"""The suggestion chip message that allows the user to jump out to the app
  or website associated with this agent.

  Fields:
    destinationName: Required. The name of the app or site this chip is
      linking to.
    uri: Required. The URI of the app or site to open when the user taps the
      suggestion chip.
  """

  destinationName = _messages.StringField(1)
  uri = _messages.StringField(2)


class GoogleCloudDialogflowV2IntentMessageListSelect(_messages.Message):
  r"""The card for presenting a list of options to select from.

  Fields:
    items: Required. List items.
    title: Optional. The overall title of the list.
  """

  items = _messages.MessageField('GoogleCloudDialogflowV2IntentMessageListSelectItem', 1, repeated=True)
  title = _messages.StringField(2)


class GoogleCloudDialogflowV2IntentMessageListSelectItem(_messages.Message):
  r"""An item in the list.

  Fields:
    description: Optional. The main text describing the item.
    image: Optional. The image to display.
    info: Required. Additional information about this option.
    title: Required. The title of the list item.
  """

  description = _messages.StringField(1)
  image = _messages.MessageField('GoogleCloudDialogflowV2IntentMessageImage', 2)
  info = _messages.MessageField('GoogleCloudDialogflowV2IntentMessageSelectItemInfo', 3)
  title = _messages.StringField(4)


class GoogleCloudDialogflowV2IntentMessageQuickReplies(_messages.Message):
  r"""The quick replies response message.

  Fields:
    quickReplies: Optional. The collection of quick replies.
    title: Optional. The title of the collection of quick replies.
  """

  quickReplies = _messages.StringField(1, repeated=True)
  title = _messages.StringField(2)


class GoogleCloudDialogflowV2IntentMessageSelectItemInfo(_messages.Message):
  r"""Additional info about the select item for when it is triggered in a
  dialog.

  Fields:
    key: Required. A unique key that will be sent back to the agent if this
      response is given.
    synonyms: Optional. A list of synonyms that can also be used to trigger
      this item in dialog.
  """

  key = _messages.StringField(1)
  synonyms = _messages.StringField(2, repeated=True)


class GoogleCloudDialogflowV2IntentMessageSimpleResponse(_messages.Message):
  r"""The simple response message containing speech or text.

  Fields:
    displayText: Optional. The text to display.
    ssml: One of text_to_speech or ssml must be provided. Structured spoken
      response to the user in the SSML format. Mutually exclusive with
      text_to_speech.
    textToSpeech: One of text_to_speech or ssml must be provided. The plain
      text of the speech output. Mutually exclusive with ssml.
  """

  displayText = _messages.StringField(1)
  ssml = _messages.StringField(2)
  textToSpeech = _messages.StringField(3)


class GoogleCloudDialogflowV2IntentMessageSimpleResponses(_messages.Message):
  r"""The collection of simple response candidates. This message in
  `QueryResult.fulfillment_messages` and
  `WebhookResponse.fulfillment_messages` should contain only one
  `SimpleResponse`.

  Fields:
    simpleResponses: Required. The list of simple responses.
  """

  simpleResponses = _messages.MessageField('GoogleCloudDialogflowV2IntentMessageSimpleResponse', 1, repeated=True)


class GoogleCloudDialogflowV2IntentMessageSuggestion(_messages.Message):
  r"""The suggestion chip message that the user can tap to quickly post a
  reply to the conversation.

  Fields:
    title: Required. The text shown the in the suggestion chip.
  """

  title = _messages.StringField(1)


class GoogleCloudDialogflowV2IntentMessageSuggestions(_messages.Message):
  r"""The collection of suggestions.

  Fields:
    suggestions: Required. The list of suggested replies.
  """

  suggestions = _messages.MessageField('GoogleCloudDialogflowV2IntentMessageSuggestion', 1, repeated=True)


class GoogleCloudDialogflowV2IntentMessageText(_messages.Message):
  r"""The text response message.

  Fields:
    text: Optional. The collection of the agent's responses.
  """

  text = _messages.StringField(1, repeated=True)


class GoogleCloudDialogflowV2IntentParameter(_messages.Message):
  r"""Represents intent parameters.

  Fields:
    defaultValue: Optional. The default value to use when the `value` yields
      an empty result. Default values can be extracted from contexts by using
      the following syntax: `#context_name.parameter_name`.
    displayName: Required. The name of the parameter.
    entityTypeDisplayName: Optional. The name of the entity type, prefixed
      with `@`, that describes values of the parameter. If the parameter is
      required, this must be provided.
    isList: Optional. Indicates whether the parameter represents a list of
      values.
    mandatory: Optional. Indicates whether the parameter is required. That is,
      whether the intent cannot be completed without collecting the parameter
      value.
    name: The unique identifier of this parameter.
    prompts: Optional. The collection of prompts that the agent can present to
      the user in order to collect a value for the parameter.
    value: Optional. The definition of the parameter value. It can be: - a
      constant string, - a parameter value defined as `$parameter_name`, - an
      original parameter value defined as `$parameter_name.original`, - a
      parameter value from some context defined as
      `#context_name.parameter_name`.
  """

  defaultValue = _messages.StringField(1)
  displayName = _messages.StringField(2)
  entityTypeDisplayName = _messages.StringField(3)
  isList = _messages.BooleanField(4)
  mandatory = _messages.BooleanField(5)
  name = _messages.StringField(6)
  prompts = _messages.StringField(7, repeated=True)
  value = _messages.StringField(8)


class GoogleCloudDialogflowV2IntentTrainingPhrase(_messages.Message):
  r"""Represents an example that the agent is trained on.

  Enums:
    TypeValueValuesEnum: Required. The type of the training phrase.

  Fields:
    name: Output only. The unique identifier of this training phrase.
    parts: Required. The ordered list of training phrase parts. The parts are
      concatenated in order to form the training phrase.  Note: The API does
      not automatically annotate training phrases like the Dialogflow Console
      does.  Note: Do not forget to include whitespace at part boundaries, so
      the training phrase is well formatted when the parts are concatenated.
      If the training phrase does not need to be annotated with parameters,
      you just need a single part with only the Part.text field set.  If you
      want to annotate the training phrase, you must create multiple parts,
      where the fields of each part are populated in one of two ways:  -
      `Part.text` is set to a part of the phrase that has no parameters. -
      `Part.text` is set to a part of the phrase that you want to annotate,
      and the `entity_type`, `alias`, and `user_defined` fields are all
      set.
    timesAddedCount: Optional. Indicates how many times this example was added
      to the intent. Each time a developer adds an existing sample by editing
      an intent or training, this counter is increased.
    type: Required. The type of the training phrase.
  """

  class TypeValueValuesEnum(_messages.Enum):
    r"""Required. The type of the training phrase.

    Values:
      TYPE_UNSPECIFIED: Not specified. This value should never be used.
      EXAMPLE: Examples do not contain @-prefixed entity type names, but
        example parts can be annotated with entity types.
      TEMPLATE: Templates are not annotated with entity types, but they can
        contain @-prefixed entity type names as substrings. Template mode has
        been deprecated. Example mode is the only supported way to create new
        training phrases. If you have existing training phrases that you've
        created in template mode, those will continue to work.
    """
    TYPE_UNSPECIFIED = 0
    EXAMPLE = 1
    TEMPLATE = 2

  name = _messages.StringField(1)
  parts = _messages.MessageField('GoogleCloudDialogflowV2IntentTrainingPhrasePart', 2, repeated=True)
  timesAddedCount = _messages.IntegerField(3, variant=_messages.Variant.INT32)
  type = _messages.EnumField('TypeValueValuesEnum', 4)


class GoogleCloudDialogflowV2IntentTrainingPhrasePart(_messages.Message):
  r"""Represents a part of a training phrase.

  Fields:
    alias: Optional. The parameter name for the value extracted from the
      annotated part of the example. This field is required for annotated
      parts of the training phrase.
    entityType: Optional. The entity type name prefixed with `@`. This field
      is required for annotated parts of the training phrase.
    text: Required. The text for this part.
    userDefined: Optional. Indicates whether the text was manually annotated.
      This field is set to true when the Dialogflow Console is used to
      manually annotate the part. When creating an annotated part with the
      API, you must set this to true.
  """

  alias = _messages.StringField(1)
  entityType = _messages.StringField(2)
  text = _messages.StringField(3)
  userDefined = _messages.BooleanField(4)


class GoogleCloudDialogflowV2ListContextsResponse(_messages.Message):
  r"""The response message for Contexts.ListContexts.

  Fields:
    contexts: The list of contexts. There will be a maximum number of items
      returned based on the page_size field in the request.
    nextPageToken: Token to retrieve the next page of results, or empty if
      there are no more results in the list.
  """

  contexts = _messages.MessageField('GoogleCloudDialogflowV2Context', 1, repeated=True)
  nextPageToken = _messages.StringField(2)


class GoogleCloudDialogflowV2ListEntityTypesResponse(_messages.Message):
  r"""The response message for EntityTypes.ListEntityTypes.

  Fields:
    entityTypes: The list of agent entity types. There will be a maximum
      number of items returned based on the page_size field in the request.
    nextPageToken: Token to retrieve the next page of results, or empty if
      there are no more results in the list.
  """

  entityTypes = _messages.MessageField('GoogleCloudDialogflowV2EntityType', 1, repeated=True)
  nextPageToken = _messages.StringField(2)


class GoogleCloudDialogflowV2ListIntentsResponse(_messages.Message):
  r"""The response message for Intents.ListIntents.

  Fields:
    intents: The list of agent intents. There will be a maximum number of
      items returned based on the page_size field in the request.
    nextPageToken: Token to retrieve the next page of results, or empty if
      there are no more results in the list.
  """

  intents = _messages.MessageField('GoogleCloudDialogflowV2Intent', 1, repeated=True)
  nextPageToken = _messages.StringField(2)


class GoogleCloudDialogflowV2ListSessionEntityTypesResponse(_messages.Message):
  r"""The response message for SessionEntityTypes.ListSessionEntityTypes.

  Fields:
    nextPageToken: Token to retrieve the next page of results, or empty if
      there are no more results in the list.
    sessionEntityTypes: The list of session entity types. There will be a
      maximum number of items returned based on the page_size field in the
      request.
  """

  nextPageToken = _messages.StringField(1)
  sessionEntityTypes = _messages.MessageField('GoogleCloudDialogflowV2SessionEntityType', 2, repeated=True)


class GoogleCloudDialogflowV2OriginalDetectIntentRequest(_messages.Message):
  r"""Represents the contents of the original request that was passed to the
  `[Streaming]DetectIntent` call.

  Messages:
    PayloadValue: Optional. This field is set to the value of the
      `QueryParameters.payload` field passed in the request. Some integrations
      that query a Dialogflow agent may provide additional information in the
      payload.  In particular for the Telephony Gateway this field has the
      form: <pre>{  "telephony": {    "caller_id": "+18558363987"  } }</pre>
      Note: The caller ID field (`caller_id`) will be redacted for Standard
      Edition agents and populated with the caller ID in [E.164
      format](https://en.wikipedia.org/wiki/E.164) for Enterprise Edition
      agents.

  Fields:
    payload: Optional. This field is set to the value of the
      `QueryParameters.payload` field passed in the request. Some integrations
      that query a Dialogflow agent may provide additional information in the
      payload.  In particular for the Telephony Gateway this field has the
      form: <pre>{  "telephony": {    "caller_id": "+18558363987"  } }</pre>
      Note: The caller ID field (`caller_id`) will be redacted for Standard
      Edition agents and populated with the caller ID in [E.164
      format](https://en.wikipedia.org/wiki/E.164) for Enterprise Edition
      agents.
    source: The source of this request, e.g., `google`, `facebook`, `slack`.
      It is set by Dialogflow-owned servers.
    version: Optional. The version of the protocol used for this request. This
      field is AoG-specific.
  """

  @encoding.MapUnrecognizedFields('additionalProperties')
  class PayloadValue(_messages.Message):
    r"""Optional. This field is set to the value of the
    `QueryParameters.payload` field passed in the request. Some integrations
    that query a Dialogflow agent may provide additional information in the
    payload.  In particular for the Telephony Gateway this field has the form:
    <pre>{  "telephony": {    "caller_id": "+18558363987"  } }</pre> Note: The
    caller ID field (`caller_id`) will be redacted for Standard Edition agents
    and populated with the caller ID in [E.164
    format](https://en.wikipedia.org/wiki/E.164) for Enterprise Edition
    agents.

    Messages:
      AdditionalProperty: An additional property for a PayloadValue object.

    Fields:
      additionalProperties: Properties of the object.
    """

    class AdditionalProperty(_messages.Message):
      r"""An additional property for a PayloadValue object.

      Fields:
        key: Name of the additional property.
        value: A extra_types.JsonValue attribute.
      """

      key = _messages.StringField(1)
      value = _messages.MessageField('extra_types.JsonValue', 2)

    additionalProperties = _messages.MessageField('AdditionalProperty', 1, repeated=True)

  payload = _messages.MessageField('PayloadValue', 1)
  source = _messages.StringField(2)
  version = _messages.StringField(3)


class GoogleCloudDialogflowV2OutputAudioConfig(_messages.Message):
  r"""Instructs the speech synthesizer on how to generate the output audio
  content.

  Enums:
    AudioEncodingValueValuesEnum: Required. Audio encoding of the synthesized
      audio content.

  Fields:
    audioEncoding: Required. Audio encoding of the synthesized audio content.
    sampleRateHertz: Optional. The synthesis sample rate (in hertz) for this
      audio. If not provided, then the synthesizer will use the default sample
      rate based on the audio encoding. If this is different from the voice's
      natural sample rate, then the synthesizer will honor this request by
      converting to the desired sample rate (which might result in worse audio
      quality).
    synthesizeSpeechConfig: Optional. Configuration of how speech should be
      synthesized.
  """

  class AudioEncodingValueValuesEnum(_messages.Enum):
    r"""Required. Audio encoding of the synthesized audio content.

    Values:
      OUTPUT_AUDIO_ENCODING_UNSPECIFIED: Not specified.
      OUTPUT_AUDIO_ENCODING_LINEAR_16: Uncompressed 16-bit signed little-
        endian samples (Linear PCM). Audio content returned as LINEAR16 also
        contains a WAV header.
      OUTPUT_AUDIO_ENCODING_MP3: MP3 audio.
      OUTPUT_AUDIO_ENCODING_OGG_OPUS: Opus encoded audio wrapped in an ogg
        container. The result will be a file which can be played natively on
        Android, and in browsers (at least Chrome and Firefox). The quality of
        the encoding is considerably higher than MP3 while using approximately
        the same bitrate.
    """
    OUTPUT_AUDIO_ENCODING_UNSPECIFIED = 0
    OUTPUT_AUDIO_ENCODING_LINEAR_16 = 1
    OUTPUT_AUDIO_ENCODING_MP3 = 2
    OUTPUT_AUDIO_ENCODING_OGG_OPUS = 3

  audioEncoding = _messages.EnumField('AudioEncodingValueValuesEnum', 1)
  sampleRateHertz = _messages.IntegerField(2, variant=_messages.Variant.INT32)
  synthesizeSpeechConfig = _messages.MessageField('GoogleCloudDialogflowV2SynthesizeSpeechConfig', 3)


class GoogleCloudDialogflowV2QueryInput(_messages.Message):
  r"""Represents the query input. It can contain either:  1.  An audio config
  which     instructs the speech recognizer how to process the speech audio.
  2.  A conversational query in the form of text,.  3.  An event that
  specifies which intent to trigger.

  Fields:
    audioConfig: Instructs the speech recognizer how to process the speech
      audio.
    event: The event to be processed.
    text: The natural language text to be processed.
  """

  audioConfig = _messages.MessageField('GoogleCloudDialogflowV2InputAudioConfig', 1)
  event = _messages.MessageField('GoogleCloudDialogflowV2EventInput', 2)
  text = _messages.MessageField('GoogleCloudDialogflowV2TextInput', 3)


class GoogleCloudDialogflowV2QueryParameters(_messages.Message):
  r"""Represents the parameters of the conversational query.

  Messages:
    PayloadValue: Optional. This field can be used to pass custom data into
      the webhook associated with the agent. Arbitrary JSON objects are
      supported.

  Fields:
    contexts: Optional. The collection of contexts to be activated before this
      query is executed.
    geoLocation: Optional. The geo location of this conversational query.
    payload: Optional. This field can be used to pass custom data into the
      webhook associated with the agent. Arbitrary JSON objects are supported.
    resetContexts: Optional. Specifies whether to delete all contexts in the
      current session before the new ones are activated.
    sentimentAnalysisRequestConfig: Optional. Configures the type of sentiment
      analysis to perform. If not provided, sentiment analysis is not
      performed.
    sessionEntityTypes: Optional. Additional session entity types to replace
      or extend developer entity types with. The entity synonyms apply to all
      languages and persist for the session of this query.
    timeZone: Optional. The time zone of this conversational query from the
      [time zone database](https://www.iana.org/time-zones), e.g.,
      America/New_York, Europe/Paris. If not provided, the time zone specified
      in agent settings is used.
  """

  @encoding.MapUnrecognizedFields('additionalProperties')
  class PayloadValue(_messages.Message):
    r"""Optional. This field can be used to pass custom data into the webhook
    associated with the agent. Arbitrary JSON objects are supported.

    Messages:
      AdditionalProperty: An additional property for a PayloadValue object.

    Fields:
      additionalProperties: Properties of the object.
    """

    class AdditionalProperty(_messages.Message):
      r"""An additional property for a PayloadValue object.

      Fields:
        key: Name of the additional property.
        value: A extra_types.JsonValue attribute.
      """

      key = _messages.StringField(1)
      value = _messages.MessageField('extra_types.JsonValue', 2)

    additionalProperties = _messages.MessageField('AdditionalProperty', 1, repeated=True)

  contexts = _messages.MessageField('GoogleCloudDialogflowV2Context', 1, repeated=True)
  geoLocation = _messages.MessageField('GoogleTypeLatLng', 2)
  payload = _messages.MessageField('PayloadValue', 3)
  resetContexts = _messages.BooleanField(4)
  sentimentAnalysisRequestConfig = _messages.MessageField('GoogleCloudDialogflowV2SentimentAnalysisRequestConfig', 5)
  sessionEntityTypes = _messages.MessageField('GoogleCloudDialogflowV2SessionEntityType', 6, repeated=True)
  timeZone = _messages.StringField(7)


class GoogleCloudDialogflowV2QueryResult(_messages.Message):
  r"""Represents the result of conversational query or event processing.

  Messages:
    DiagnosticInfoValue: The free-form diagnostic info. For example, this
      field could contain webhook call latency. The string keys of the
      Struct's fields map can change without notice.
    ParametersValue: The collection of extracted parameters.
    WebhookPayloadValue: If the query was fulfilled by a webhook call, this
      field is set to the value of the `payload` field returned in the webhook
      response.

  Fields:
    action: The action name from the matched intent.
    allRequiredParamsPresent: This field is set to:  - `false` if the matched
      intent has required parameters and not all of    the required parameter
      values have been collected. - `true` if all required parameter values
      have been collected, or if the    matched intent doesn't contain any
      required parameters.
    diagnosticInfo: The free-form diagnostic info. For example, this field
      could contain webhook call latency. The string keys of the Struct's
      fields map can change without notice.
    fulfillmentMessages: The collection of rich messages to present to the
      user.
    fulfillmentText: The text to be pronounced to the user or shown on the
      screen. Note: This is a legacy field, `fulfillment_messages` should be
      preferred.
    intent: The intent that matched the conversational query. Some, not all
      fields are filled in this message, including but not limited to: `name`,
      `display_name`, `end_interaction` and `is_fallback`.
    intentDetectionConfidence: The intent detection confidence. Values range
      from 0.0 (completely uncertain) to 1.0 (completely certain). This value
      is for informational purpose only and is only used to help match the
      best intent within the classification threshold. This value may change
      for the same end-user expression at any time due to a model retraining
      or change in implementation. If there are `multiple knowledge_answers`
      messages, this value is set to the greatest
      `knowledgeAnswers.match_confidence` value in the list.
    languageCode: The language that was triggered during intent detection. See
      [Language
      Support](https://cloud.google.com/dialogflow/docs/reference/language)
      for a list of the currently supported language codes.
    outputContexts: The collection of output contexts. If applicable,
      `output_contexts.parameters` contains entries with name `<parameter
      name>.original` containing the original parameter values before the
      query.
    parameters: The collection of extracted parameters.
    queryText: The original conversational query text:  - If natural language
      text was provided as input, `query_text` contains   a copy of the input.
      - If natural language speech audio was provided as input, `query_text`
      contains the speech recognition result. If speech recognizer produced
      multiple alternatives, a particular one is picked. - If automatic spell
      correction is enabled, `query_text` will contain the   corrected user
      input.
    sentimentAnalysisResult: The sentiment analysis result, which depends on
      the `sentiment_analysis_request_config` specified in the request.
    speechRecognitionConfidence: The Speech recognition confidence between 0.0
      and 1.0. A higher number indicates an estimated greater likelihood that
      the recognized words are correct. The default of 0.0 is a sentinel value
      indicating that confidence was not set.  This field is not guaranteed to
      be accurate or set. In particular this field isn't set for
      StreamingDetectIntent since the streaming endpoint has separate
      confidence estimates per portion of the audio in
      StreamingRecognitionResult.
    webhookPayload: If the query was fulfilled by a webhook call, this field
      is set to the value of the `payload` field returned in the webhook
      response.
    webhookSource: If the query was fulfilled by a webhook call, this field is
      set to the value of the `source` field returned in the webhook response.
  """

  @encoding.MapUnrecognizedFields('additionalProperties')
  class DiagnosticInfoValue(_messages.Message):
    r"""The free-form diagnostic info. For example, this field could contain
    webhook call latency. The string keys of the Struct's fields map can
    change without notice.

    Messages:
      AdditionalProperty: An additional property for a DiagnosticInfoValue
        object.

    Fields:
      additionalProperties: Properties of the object.
    """

    class AdditionalProperty(_messages.Message):
      r"""An additional property for a DiagnosticInfoValue object.

      Fields:
        key: Name of the additional property.
        value: A extra_types.JsonValue attribute.
      """

      key = _messages.StringField(1)
      value = _messages.MessageField('extra_types.JsonValue', 2)

    additionalProperties = _messages.MessageField('AdditionalProperty', 1, repeated=True)

  @encoding.MapUnrecognizedFields('additionalProperties')
  class ParametersValue(_messages.Message):
    r"""The collection of extracted parameters.

    Messages:
      AdditionalProperty: An additional property for a ParametersValue object.

    Fields:
      additionalProperties: Properties of the object.
    """

    class AdditionalProperty(_messages.Message):
      r"""An additional property for a ParametersValue object.

      Fields:
        key: Name of the additional property.
        value: A extra_types.JsonValue attribute.
      """

      key = _messages.StringField(1)
      value = _messages.MessageField('extra_types.JsonValue', 2)

    additionalProperties = _messages.MessageField('AdditionalProperty', 1, repeated=True)

  @encoding.MapUnrecognizedFields('additionalProperties')
  class WebhookPayloadValue(_messages.Message):
    r"""If the query was fulfilled by a webhook call, this field is set to the
    value of the `payload` field returned in the webhook response.

    Messages:
      AdditionalProperty: An additional property for a WebhookPayloadValue
        object.

    Fields:
      additionalProperties: Properties of the object.
    """

    class AdditionalProperty(_messages.Message):
      r"""An additional property for a WebhookPayloadValue object.

      Fields:
        key: Name of the additional property.
        value: A extra_types.JsonValue attribute.
      """

      key = _messages.StringField(1)
      value = _messages.MessageField('extra_types.JsonValue', 2)

    additionalProperties = _messages.MessageField('AdditionalProperty', 1, repeated=True)

  action = _messages.StringField(1)
  allRequiredParamsPresent = _messages.BooleanField(2)
  diagnosticInfo = _messages.MessageField('DiagnosticInfoValue', 3)
  fulfillmentMessages = _messages.MessageField('GoogleCloudDialogflowV2IntentMessage', 4, repeated=True)
  fulfillmentText = _messages.StringField(5)
  intent = _messages.MessageField('GoogleCloudDialogflowV2Intent', 6)
  intentDetectionConfidence = _messages.FloatField(7, variant=_messages.Variant.FLOAT)
  languageCode = _messages.StringField(8)
  outputContexts = _messages.MessageField('GoogleCloudDialogflowV2Context', 9, repeated=True)
  parameters = _messages.MessageField('ParametersValue', 10)
  queryText = _messages.StringField(11)
  sentimentAnalysisResult = _messages.MessageField('GoogleCloudDialogflowV2SentimentAnalysisResult', 12)
  speechRecognitionConfidence = _messages.FloatField(13, variant=_messages.Variant.FLOAT)
  webhookPayload = _messages.MessageField('WebhookPayloadValue', 14)
  webhookSource = _messages.StringField(15)


class GoogleCloudDialogflowV2RestoreAgentRequest(_messages.Message):
  r"""The request message for Agents.RestoreAgent.

  Fields:
    agentContent: The agent to restore.  Example for how to restore an agent
      via the command line: <pre>curl \   'https://dialogflow.googleapis.com/v
      2/projects/&lt;project_id&gt;/agent:restore'\    -X POST \    -H
      'Authorization: Bearer' \    $(gcloud auth application-default print-
      access-token) \    -H 'Accept: application/json' \    -H 'Content-Type:
      application/json' \    --data-binary "{        'agentContent': '$(cat
      &lt;agent zip file&gt; | base64 -w 0)'    }"</pre>
    agentUri: The URI to a Google Cloud Storage file containing the agent to
      restore. Note: The URI must start with "gs://".
  """

  agentContent = _messages.BytesField(1)
  agentUri = _messages.StringField(2)


class GoogleCloudDialogflowV2SearchAgentsResponse(_messages.Message):
  r"""The response message for Agents.SearchAgents.

  Fields:
    agents: The list of agents. There will be a maximum number of items
      returned based on the page_size field in the request.
    nextPageToken: Token to retrieve the next page of results, or empty if
      there are no more results in the list.
  """

  agents = _messages.MessageField('GoogleCloudDialogflowV2Agent', 1, repeated=True)
  nextPageToken = _messages.StringField(2)


class GoogleCloudDialogflowV2Sentiment(_messages.Message):
  r"""The sentiment, such as positive/negative feeling or association, for a
  unit of analysis, such as the query text.

  Fields:
    magnitude: A non-negative number in the [0, +inf) range, which represents
      the absolute magnitude of sentiment, regardless of score (positive or
      negative).
    score: Sentiment score between -1.0 (negative sentiment) and 1.0 (positive
      sentiment).
  """

  magnitude = _messages.FloatField(1, variant=_messages.Variant.FLOAT)
  score = _messages.FloatField(2, variant=_messages.Variant.FLOAT)


class GoogleCloudDialogflowV2SentimentAnalysisRequestConfig(_messages.Message):
  r"""Configures the types of sentiment analysis to perform.

  Fields:
    analyzeQueryTextSentiment: Optional. Instructs the service to perform
      sentiment analysis on `query_text`. If not provided, sentiment analysis
      is not performed on `query_text`.
  """

  analyzeQueryTextSentiment = _messages.BooleanField(1)


class GoogleCloudDialogflowV2SentimentAnalysisResult(_messages.Message):
  r"""The result of sentiment analysis as configured by
  `sentiment_analysis_request_config`.

  Fields:
    queryTextSentiment: The sentiment analysis result for `query_text`.
  """

  queryTextSentiment = _messages.MessageField('GoogleCloudDialogflowV2Sentiment', 1)


class GoogleCloudDialogflowV2SessionEntityType(_messages.Message):
  r"""Represents a session entity type.  Extends or replaces a developer
  entity type at the user session level (we refer to the entity types defined
  at the agent level as "developer entity types").  Note: session entity types
  apply to all queries, regardless of the language.

  Enums:
    EntityOverrideModeValueValuesEnum: Required. Indicates whether the
      additional data should override or supplement the developer entity type
      definition.

  Fields:
    entities: Required. The collection of entities associated with this
      session entity type.
    entityOverrideMode: Required. Indicates whether the additional data should
      override or supplement the developer entity type definition.
    name: Required. The unique identifier of this session entity type. Format:
      `projects/<Project ID>/agent/sessions/<Session ID>/entityTypes/<Entity
      Type Display Name>`.  `<Entity Type Display Name>` must be the display
      name of an existing entity type in the same agent that will be
      overridden or supplemented.
  """

  class EntityOverrideModeValueValuesEnum(_messages.Enum):
    r"""Required. Indicates whether the additional data should override or
    supplement the developer entity type definition.

    Values:
      ENTITY_OVERRIDE_MODE_UNSPECIFIED: Not specified. This value should be
        never used.
      ENTITY_OVERRIDE_MODE_OVERRIDE: The collection of session entities
        overrides the collection of entities in the corresponding developer
        entity type.
      ENTITY_OVERRIDE_MODE_SUPPLEMENT: The collection of session entities
        extends the collection of entities in the corresponding developer
        entity type.  Note: Even in this override mode calls to
        `ListSessionEntityTypes`, `GetSessionEntityType`,
        `CreateSessionEntityType` and `UpdateSessionEntityType` only return
        the additional entities added in this session entity type. If you want
        to get the supplemented list, please call EntityTypes.GetEntityType on
        the developer entity type and merge.
    """
    ENTITY_OVERRIDE_MODE_UNSPECIFIED = 0
    ENTITY_OVERRIDE_MODE_OVERRIDE = 1
    ENTITY_OVERRIDE_MODE_SUPPLEMENT = 2

  entities = _messages.MessageField('GoogleCloudDialogflowV2EntityTypeEntity', 1, repeated=True)
  entityOverrideMode = _messages.EnumField('EntityOverrideModeValueValuesEnum', 2)
  name = _messages.StringField(3)


class GoogleCloudDialogflowV2SynthesizeSpeechConfig(_messages.Message):
  r"""Configuration of how speech should be synthesized.

  Fields:
    effectsProfileId: Optional. An identifier which selects 'audio effects'
      profiles that are applied on (post synthesized) text to speech. Effects
      are applied on top of each other in the order they are given.
    pitch: Optional. Speaking pitch, in the range [-20.0, 20.0]. 20 means
      increase 20 semitones from the original pitch. -20 means decrease 20
      semitones from the original pitch.
    speakingRate: Optional. Speaking rate/speed, in the range [0.25, 4.0]. 1.0
      is the normal native speed supported by the specific voice. 2.0 is twice
      as fast, and 0.5 is half as fast. If unset(0.0), defaults to the native
      1.0 speed. Any other values < 0.25 or > 4.0 will return an error.
    voice: Optional. The desired voice of the synthesized audio.
    volumeGainDb: Optional. Volume gain (in dB) of the normal native volume
      supported by the specific voice, in the range [-96.0, 16.0]. If unset,
      or set to a value of 0.0 (dB), will play at normal native signal
      amplitude. A value of -6.0 (dB) will play at approximately half the
      amplitude of the normal native signal amplitude. A value of +6.0 (dB)
      will play at approximately twice the amplitude of the normal native
      signal amplitude. We strongly recommend not to exceed +10 (dB) as
      there's usually no effective increase in loudness for any value greater
      than that.
  """

  effectsProfileId = _messages.StringField(1, repeated=True)
  pitch = _messages.FloatField(2)
  speakingRate = _messages.FloatField(3)
  voice = _messages.MessageField('GoogleCloudDialogflowV2VoiceSelectionParams', 4)
  volumeGainDb = _messages.FloatField(5)


class GoogleCloudDialogflowV2TextInput(_messages.Message):
  r"""Represents the natural language text to be processed.

  Fields:
    languageCode: Required. The language of this conversational query. See
      [Language
      Support](https://cloud.google.com/dialogflow/docs/reference/language)
      for a list of the currently supported language codes. Note that queries
      in the same session do not necessarily need to specify the same
      language.
    text: Required. The UTF-8 encoded natural language text to be processed.
      Text length must not exceed 256 characters.
  """

  languageCode = _messages.StringField(1)
  text = _messages.StringField(2)


class GoogleCloudDialogflowV2TrainAgentRequest(_messages.Message):
  r"""The request message for Agents.TrainAgent."""


class GoogleCloudDialogflowV2VoiceSelectionParams(_messages.Message):
  r"""Description of which voice to use for speech synthesis.

  Enums:
    SsmlGenderValueValuesEnum: Optional. The preferred gender of the voice. If
      not set, the service will choose a voice based on the other parameters
      such as language_code and name. Note that this is only a preference, not
      requirement. If a voice of the appropriate gender is not available, the
      synthesizer should substitute a voice with a different gender rather
      than failing the request.

  Fields:
    name: Optional. The name of the voice. If not set, the service will choose
      a voice based on the other parameters such as language_code and gender.
    ssmlGender: Optional. The preferred gender of the voice. If not set, the
      service will choose a voice based on the other parameters such as
      language_code and name. Note that this is only a preference, not
      requirement. If a voice of the appropriate gender is not available, the
      synthesizer should substitute a voice with a different gender rather
      than failing the request.
  """

  class SsmlGenderValueValuesEnum(_messages.Enum):
    r"""Optional. The preferred gender of the voice. If not set, the service
    will choose a voice based on the other parameters such as language_code
    and name. Note that this is only a preference, not requirement. If a voice
    of the appropriate gender is not available, the synthesizer should
    substitute a voice with a different gender rather than failing the
    request.

    Values:
      SSML_VOICE_GENDER_UNSPECIFIED: An unspecified gender, which means that
        the client doesn't care which gender the selected voice will have.
      SSML_VOICE_GENDER_MALE: A male voice.
      SSML_VOICE_GENDER_FEMALE: A female voice.
      SSML_VOICE_GENDER_NEUTRAL: A gender-neutral voice.
    """
    SSML_VOICE_GENDER_UNSPECIFIED = 0
    SSML_VOICE_GENDER_MALE = 1
    SSML_VOICE_GENDER_FEMALE = 2
    SSML_VOICE_GENDER_NEUTRAL = 3

  name = _messages.StringField(1)
  ssmlGender = _messages.EnumField('SsmlGenderValueValuesEnum', 2)


class GoogleCloudDialogflowV2WebhookRequest(_messages.Message):
  r"""The request message for a webhook call.

  Fields:
    originalDetectIntentRequest: Optional. The contents of the original
      request that was passed to `[Streaming]DetectIntent` call.
    queryResult: The result of the conversational query or event processing.
      Contains the same value as
      `[Streaming]DetectIntentResponse.query_result`.
    responseId: The unique identifier of the response. Contains the same value
      as `[Streaming]DetectIntentResponse.response_id`.
    session: The unique identifier of detectIntent request session. Can be
      used to identify end-user inside webhook implementation. Format:
      `projects/<Project ID>/agent/sessions/<Session ID>`, or
      `projects/<Project ID>/agent/environments/<Environment ID>/users/<User
      ID>/sessions/<Session ID>`.
  """

  originalDetectIntentRequest = _messages.MessageField('GoogleCloudDialogflowV2OriginalDetectIntentRequest', 1)
  queryResult = _messages.MessageField('GoogleCloudDialogflowV2QueryResult', 2)
  responseId = _messages.StringField(3)
  session = _messages.StringField(4)


class GoogleCloudDialogflowV2WebhookResponse(_messages.Message):
  r"""The response message for a webhook call.

  Messages:
    PayloadValue: Optional. This value is passed directly to
      `QueryResult.webhook_payload`. See the related
      `fulfillment_messages[i].payload field`, which may be used as an
      alternative to this field.  This field can be used for Actions on Google
      responses. It should have a structure similar to the JSON message shown
      here. For more information, see [Actions on Google Webhook
      Format](https://developers.google.com/actions/dialogflow/webhook) <pre>{
      "google": {     "expectUserResponse": true,     "richResponse": {
      "items": [         {           "simpleResponse": {
      "textToSpeech": "this is a simple response"           }         }
      ]     }   } }</pre>

  Fields:
    followupEventInput: Optional. Makes the platform immediately invoke
      another `DetectIntent` call internally with the specified event as
      input. When this field is set, Dialogflow ignores the
      `fulfillment_text`, `fulfillment_messages`, and `payload` fields.
    fulfillmentMessages: Optional. The collection of rich messages to present
      to the user. This value is passed directly to
      `QueryResult.fulfillment_messages`.
    fulfillmentText: Optional. The text to be shown on the screen. This value
      is passed directly to `QueryResult.fulfillment_text`.
    outputContexts: Optional. The collection of output contexts. This value is
      passed directly to `QueryResult.output_contexts`.
    payload: Optional. This value is passed directly to
      `QueryResult.webhook_payload`. See the related
      `fulfillment_messages[i].payload field`, which may be used as an
      alternative to this field.  This field can be used for Actions on Google
      responses. It should have a structure similar to the JSON message shown
      here. For more information, see [Actions on Google Webhook
      Format](https://developers.google.com/actions/dialogflow/webhook) <pre>{
      "google": {     "expectUserResponse": true,     "richResponse": {
      "items": [         {           "simpleResponse": {
      "textToSpeech": "this is a simple response"           }         }
      ]     }   } }</pre>
    source: Optional. This value is passed directly to
      `QueryResult.webhook_source`.
  """

  @encoding.MapUnrecognizedFields('additionalProperties')
  class PayloadValue(_messages.Message):
    r"""Optional. This value is passed directly to
    `QueryResult.webhook_payload`. See the related
    `fulfillment_messages[i].payload field`, which may be used as an
    alternative to this field.  This field can be used for Actions on Google
    responses. It should have a structure similar to the JSON message shown
    here. For more information, see [Actions on Google Webhook
    Format](https://developers.google.com/actions/dialogflow/webhook) <pre>{
    "google": {     "expectUserResponse": true,     "richResponse": {
    "items": [         {           "simpleResponse": {
    "textToSpeech": "this is a simple response"           }         }       ]
    }   } }</pre>

    Messages:
      AdditionalProperty: An additional property for a PayloadValue object.

    Fields:
      additionalProperties: Properties of the object.
    """

    class AdditionalProperty(_messages.Message):
      r"""An additional property for a PayloadValue object.

      Fields:
        key: Name of the additional property.
        value: A extra_types.JsonValue attribute.
      """

      key = _messages.StringField(1)
      value = _messages.MessageField('extra_types.JsonValue', 2)

    additionalProperties = _messages.MessageField('AdditionalProperty', 1, repeated=True)

  followupEventInput = _messages.MessageField('GoogleCloudDialogflowV2EventInput', 1)
  fulfillmentMessages = _messages.MessageField('GoogleCloudDialogflowV2IntentMessage', 2, repeated=True)
  fulfillmentText = _messages.StringField(3)
  outputContexts = _messages.MessageField('GoogleCloudDialogflowV2Context', 4, repeated=True)
  payload = _messages.MessageField('PayloadValue', 5)
  source = _messages.StringField(6)


class GoogleCloudDialogflowV2beta1AnnotatedConversationDataset(_messages.Message):
  r"""Represents an annotated conversation dataset. ConversationDataset can
  have multiple AnnotatedConversationDataset, each of them represents one
  result from one annotation task. AnnotatedConversationDataset can only be
  generated from annotation task, which will be triggered by
  LabelConversation.

  Fields:
    completedExampleCount: Output only. Number of examples that have
      annotations in the annotated conversation dataset.
    createTime: Output only. Creation time of this annotated conversation
      dataset.
    description: Optional. The description of the annotated conversation
      dataset. Maximum of 10000 bytes.
    displayName: Required. The display name of the annotated conversation
      dataset. It's specified when user starts an annotation task. Maximum of
      64 bytes.
    exampleCount: Output only. Number of examples in the annotated
      conversation dataset.
    name: Output only. AnnotatedConversationDataset resource name. Format:
      `projects/<Project ID>/conversationDatasets/<Conversation Dataset
      ID>/annotatedConversationDatasets/<Annotated Conversation Dataset ID>`
    questionTypeName: Output only. Question type name that identifies a
      labeling task. A question is a single task that a worker answers. A
      question type is set of related questions. Each question belongs to a
      particular question type. It can be used in CrowdCompute UI to filter
      and manage labeling tasks.
  """

  completedExampleCount = _messages.IntegerField(1)
  createTime = _messages.StringField(2)
  description = _messages.StringField(3)
  displayName = _messages.StringField(4)
  exampleCount = _messages.IntegerField(5)
  name = _messages.StringField(6)
  questionTypeName = _messages.StringField(7)


class GoogleCloudDialogflowV2beta1BatchUpdateEntityTypesResponse(_messages.Message):
  r"""The response message for EntityTypes.BatchUpdateEntityTypes.

  Fields:
    entityTypes: The collection of updated or created entity types.
  """

  entityTypes = _messages.MessageField('GoogleCloudDialogflowV2beta1EntityType', 1, repeated=True)


class GoogleCloudDialogflowV2beta1BatchUpdateIntentsResponse(_messages.Message):
  r"""The response message for Intents.BatchUpdateIntents.

  Fields:
    intents: The collection of updated or created intents.
  """

  intents = _messages.MessageField('GoogleCloudDialogflowV2beta1Intent', 1, repeated=True)


class GoogleCloudDialogflowV2beta1Context(_messages.Message):
  r"""Represents a context.

  Messages:
    ParametersValue: Optional. The collection of parameters associated with
      this context. Refer to [this
      doc](https://cloud.google.com/dialogflow/docs/intents-actions-
      parameters) for syntax.

  Fields:
    lifespanCount: Optional. The number of conversational query requests after
      which the context expires. If set to `0` (the default) the context
      expires immediately. Contexts expire automatically after 20 minutes if
      there are no matching queries.
    name: Required. The unique identifier of the context. Format:
      `projects/<Project ID>/agent/sessions/<Session ID>/contexts/<Context
      ID>`, or `projects/<Project ID>/agent/environments/<Environment
      ID>/users/<User ID>/sessions/<Session ID>/contexts/<Context ID>`.  The
      `Context ID` is always converted to lowercase, may only contain
      characters in a-zA-Z0-9_-% and may be at most 250 bytes long.  If
      `Environment ID` is not specified, we assume default 'draft'
      environment. If `User ID` is not specified, we assume default '-' user.
    parameters: Optional. The collection of parameters associated with this
      context. Refer to [this doc](https://cloud.google.com/dialogflow/docs
      /intents-actions-parameters) for syntax.
  """

  @encoding.MapUnrecognizedFields('additionalProperties')
  class ParametersValue(_messages.Message):
    r"""Optional. The collection of parameters associated with this context.
    Refer to [this doc](https://cloud.google.com/dialogflow/docs/intents-
    actions-parameters) for syntax.

    Messages:
      AdditionalProperty: An additional property for a ParametersValue object.

    Fields:
      additionalProperties: Properties of the object.
    """

    class AdditionalProperty(_messages.Message):
      r"""An additional property for a ParametersValue object.

      Fields:
        key: Name of the additional property.
        value: A extra_types.JsonValue attribute.
      """

      key = _messages.StringField(1)
      value = _messages.MessageField('extra_types.JsonValue', 2)

    additionalProperties = _messages.MessageField('AdditionalProperty', 1, repeated=True)

  lifespanCount = _messages.IntegerField(1, variant=_messages.Variant.INT32)
  name = _messages.StringField(2)
  parameters = _messages.MessageField('ParametersValue', 3)


class GoogleCloudDialogflowV2beta1EntityType(_messages.Message):
  r"""Represents an entity type. Entity types serve as a tool for extracting
  parameter values from natural language queries.

  Enums:
    AutoExpansionModeValueValuesEnum: Optional. Indicates whether the entity
      type can be automatically expanded.
    KindValueValuesEnum: Required. Indicates the kind of entity type.

  Fields:
    autoExpansionMode: Optional. Indicates whether the entity type can be
      automatically expanded.
    displayName: Required. The name of the entity type.
    enableFuzzyExtraction: Optional. Enables fuzzy entity extraction during
      classification.
    entities: Optional. The collection of entity entries associated with the
      entity type.
    kind: Required. Indicates the kind of entity type.
    name: The unique identifier of the entity type. Required for
      EntityTypes.UpdateEntityType and EntityTypes.BatchUpdateEntityTypes
      methods. Format: `projects/<Project ID>/agent/entityTypes/<Entity Type
      ID>`.
  """

  class AutoExpansionModeValueValuesEnum(_messages.Enum):
    r"""Optional. Indicates whether the entity type can be automatically
    expanded.

    Values:
      AUTO_EXPANSION_MODE_UNSPECIFIED: Auto expansion disabled for the entity.
      AUTO_EXPANSION_MODE_DEFAULT: Allows an agent to recognize values that
        have not been explicitly listed in the entity.
    """
    AUTO_EXPANSION_MODE_UNSPECIFIED = 0
    AUTO_EXPANSION_MODE_DEFAULT = 1

  class KindValueValuesEnum(_messages.Enum):
    r"""Required. Indicates the kind of entity type.

    Values:
      KIND_UNSPECIFIED: Not specified. This value should be never used.
      KIND_MAP: Map entity types allow mapping of a group of synonyms to a
        canonical value.
      KIND_LIST: List entity types contain a set of entries that do not map to
        canonical values. However, list entity types can contain references to
        other entity types (with or without aliases).
      KIND_REGEXP: Regexp entity types allow to specify regular expressions in
        entries values.
    """
    KIND_UNSPECIFIED = 0
    KIND_MAP = 1
    KIND_LIST = 2
    KIND_REGEXP = 3

  autoExpansionMode = _messages.EnumField('AutoExpansionModeValueValuesEnum', 1)
  displayName = _messages.StringField(2)
  enableFuzzyExtraction = _messages.BooleanField(3)
  entities = _messages.MessageField('GoogleCloudDialogflowV2beta1EntityTypeEntity', 4, repeated=True)
  kind = _messages.EnumField('KindValueValuesEnum', 5)
  name = _messages.StringField(6)


class GoogleCloudDialogflowV2beta1EntityTypeEntity(_messages.Message):
  r"""An **entity entry** for an associated entity type.

  Fields:
    synonyms: Required. A collection of value synonyms. For example, if the
      entity type is *vegetable*, and `value` is *scallions*, a synonym could
      be *green onions*.  For `KIND_LIST` entity types:  *   This collection
      must contain exactly one synonym equal to `value`.
    value: Required. The primary value associated with this entity entry. For
      example, if the entity type is *vegetable*, the value could be
      *scallions*.  For `KIND_MAP` entity types:  *   A canonical value to be
      used in place of synonyms.  For `KIND_LIST` entity types:  *   A string
      that can contain references to other entity types (with or     without
      aliases).
  """

  synonyms = _messages.StringField(1, repeated=True)
  value = _messages.StringField(2)


class GoogleCloudDialogflowV2beta1EventInput(_messages.Message):
  r"""Events allow for matching intents by event name instead of the natural
  language input. For instance, input `<event: { name: "welcome_event",
  parameters: { name: "Sam" } }>` can trigger a personalized welcome response.
  The parameter `name` may be used by the agent in the response: `"Hello
  #welcome_event.name! What can I do for you today?"`.

  Messages:
    ParametersValue: Optional. The collection of parameters associated with
      the event.

  Fields:
    languageCode: Required. The language of this query. See [Language
      Support](https://cloud.google.com/dialogflow/docs/reference/language)
      for a list of the currently supported language codes. Note that queries
      in the same session do not necessarily need to specify the same
      language.
    name: Required. The unique identifier of the event.
    parameters: Optional. The collection of parameters associated with the
      event.
  """

  @encoding.MapUnrecognizedFields('additionalProperties')
  class ParametersValue(_messages.Message):
    r"""Optional. The collection of parameters associated with the event.

    Messages:
      AdditionalProperty: An additional property for a ParametersValue object.

    Fields:
      additionalProperties: Properties of the object.
    """

    class AdditionalProperty(_messages.Message):
      r"""An additional property for a ParametersValue object.

      Fields:
        key: Name of the additional property.
        value: A extra_types.JsonValue attribute.
      """

      key = _messages.StringField(1)
      value = _messages.MessageField('extra_types.JsonValue', 2)

    additionalProperties = _messages.MessageField('AdditionalProperty', 1, repeated=True)

  languageCode = _messages.StringField(1)
  name = _messages.StringField(2)
  parameters = _messages.MessageField('ParametersValue', 3)


class GoogleCloudDialogflowV2beta1ExportAgentResponse(_messages.Message):
  r"""The response message for Agents.ExportAgent.

  Fields:
    agentContent: The exported agent.  Example for how to export an agent to a
      zip file via a command line: <pre>curl \   'https://dialogflow.googleapi
      s.com/v2beta1/projects/&lt;project_id&gt;/agent:export'\   -X POST \
      -H 'Authorization: Bearer' \   $(gcloud auth application-default print-
      access-token) \   -H 'Accept: application/json'   --compressed \   |
      grep agentContent | sed -e 's/.*"agentContent": "\([^"]*\)".*/\1/' \   |
      base64 --decode > &lt;agent zip file&gt;</pre>
    agentUri: The URI to a file containing the exported agent. This field is
      populated only if `agent_uri` is specified in `ExportAgentRequest`.
  """

  agentContent = _messages.BytesField(1)
  agentUri = _messages.StringField(2)


class GoogleCloudDialogflowV2beta1Intent(_messages.Message):
  r"""Represents an intent. Intents convert a number of user expressions or
  patterns into an action. An action is an extraction of a user command or
  sentence semantics.

  Enums:
    DefaultResponsePlatformsValueListEntryValuesEnum:
    WebhookStateValueValuesEnum: Optional. Indicates whether webhooks are
      enabled for the intent.

  Fields:
    action: Optional. The name of the action associated with the intent. Note:
      The action name must not contain whitespaces.
    defaultResponsePlatforms: Optional. The list of platforms for which the
      first responses will be copied from the messages in PLATFORM_UNSPECIFIED
      (i.e. default platform).
    displayName: Required. The name of this intent.
    endInteraction: Optional. Indicates that this intent ends an interaction.
      Some integrations (e.g., Actions on Google or Dialogflow phone gateway)
      use this information to close interaction with an end user. Default is
      false.
    events: Optional. The collection of event names that trigger the intent.
      If the collection of input contexts is not empty, all of the contexts
      must be present in the active user session for an event to trigger this
      intent.
    followupIntentInfo: Read-only. Information about all followup intents that
      have this intent as a direct or indirect parent. We populate this field
      only in the output.
    inputContextNames: Optional. The list of context names required for this
      intent to be triggered. Format: `projects/<Project
      ID>/agent/sessions/-/contexts/<Context ID>`.
    isFallback: Optional. Indicates whether this is a fallback intent.
    messages: Optional. The collection of rich messages corresponding to the
      `Response` field in the Dialogflow console.
    mlDisabled: Optional. Indicates whether Machine Learning is disabled for
      the intent. Note: If `ml_disabled` setting is set to true, then this
      intent is not taken into account during inference in `ML ONLY` match
      mode. Also, auto-markup in the UI is turned off.
    mlEnabled: Optional. Indicates whether Machine Learning is enabled for the
      intent. Note: If `ml_enabled` setting is set to false, then this intent
      is not taken into account during inference in `ML ONLY` match mode.
      Also, auto-markup in the UI is turned off. DEPRECATED! Please use
      `ml_disabled` field instead. NOTE: If both `ml_enabled` and
      `ml_disabled` are either not set or false, then the default value is
      determined as follows: - Before April 15th, 2018 the default is:
      ml_enabled = false / ml_disabled = true. - After April 15th, 2018 the
      default is:   ml_enabled = true / ml_disabled = false.
    name: The unique identifier of this intent. Required for
      Intents.UpdateIntent and Intents.BatchUpdateIntents methods. Format:
      `projects/<Project ID>/agent/intents/<Intent ID>`.
    outputContexts: Optional. The collection of contexts that are activated
      when the intent is matched. Context messages in this collection should
      not set the parameters field. Setting the `lifespan_count` to 0 will
      reset the context when the intent is matched. Format: `projects/<Project
      ID>/agent/sessions/-/contexts/<Context ID>`.
    parameters: Optional. The collection of parameters associated with the
      intent.
    parentFollowupIntentName: Read-only after creation. The unique identifier
      of the parent intent in the chain of followup intents. You can set this
      field when creating an intent, for example with CreateIntent or
      BatchUpdateIntents, in order to make this intent a followup intent.  It
      identifies the parent followup intent. Format: `projects/<Project
      ID>/agent/intents/<Intent ID>`.
    priority: Optional. The priority of this intent. Higher numbers represent
      higher priorities. If this is zero or unspecified, we use the default
      priority 500000.  Negative numbers mean that the intent is disabled.
    resetContexts: Optional. Indicates whether to delete all contexts in the
      current session when this intent is matched.
    rootFollowupIntentName: Read-only. The unique identifier of the root
      intent in the chain of followup intents. It identifies the correct
      followup intents chain for this intent. We populate this field only in
      the output.  Format: `projects/<Project ID>/agent/intents/<Intent ID>`.
    trainingPhrases: Optional. The collection of examples that the agent is
      trained on.
    webhookState: Optional. Indicates whether webhooks are enabled for the
      intent.
  """

  class DefaultResponsePlatformsValueListEntryValuesEnum(_messages.Enum):
    r"""DefaultResponsePlatformsValueListEntryValuesEnum enum type.

    Values:
      PLATFORM_UNSPECIFIED: <no description>
      FACEBOOK: <no description>
      SLACK: <no description>
      TELEGRAM: <no description>
      KIK: <no description>
      SKYPE: <no description>
      LINE: <no description>
      VIBER: <no description>
      ACTIONS_ON_GOOGLE: <no description>
      TELEPHONY: <no description>
      GOOGLE_HANGOUTS: <no description>
    """
    PLATFORM_UNSPECIFIED = 0
    FACEBOOK = 1
    SLACK = 2
    TELEGRAM = 3
    KIK = 4
    SKYPE = 5
    LINE = 6
    VIBER = 7
    ACTIONS_ON_GOOGLE = 8
    TELEPHONY = 9
    GOOGLE_HANGOUTS = 10

  class WebhookStateValueValuesEnum(_messages.Enum):
    r"""Optional. Indicates whether webhooks are enabled for the intent.

    Values:
      WEBHOOK_STATE_UNSPECIFIED: Webhook is disabled in the agent and in the
        intent.
      WEBHOOK_STATE_ENABLED: Webhook is enabled in the agent and in the
        intent.
      WEBHOOK_STATE_ENABLED_FOR_SLOT_FILLING: Webhook is enabled in the agent
        and in the intent. Also, each slot filling prompt is forwarded to the
        webhook.
    """
    WEBHOOK_STATE_UNSPECIFIED = 0
    WEBHOOK_STATE_ENABLED = 1
    WEBHOOK_STATE_ENABLED_FOR_SLOT_FILLING = 2

  action = _messages.StringField(1)
  defaultResponsePlatforms = _messages.EnumField('DefaultResponsePlatformsValueListEntryValuesEnum', 2, repeated=True)
  displayName = _messages.StringField(3)
  endInteraction = _messages.BooleanField(4)
  events = _messages.StringField(5, repeated=True)
  followupIntentInfo = _messages.MessageField('GoogleCloudDialogflowV2beta1IntentFollowupIntentInfo', 6, repeated=True)
  inputContextNames = _messages.StringField(7, repeated=True)
  isFallback = _messages.BooleanField(8)
  messages = _messages.MessageField('GoogleCloudDialogflowV2beta1IntentMessage', 9, repeated=True)
  mlDisabled = _messages.BooleanField(10)
  mlEnabled = _messages.BooleanField(11)
  name = _messages.StringField(12)
  outputContexts = _messages.MessageField('GoogleCloudDialogflowV2beta1Context', 13, repeated=True)
  parameters = _messages.MessageField('GoogleCloudDialogflowV2beta1IntentParameter', 14, repeated=True)
  parentFollowupIntentName = _messages.StringField(15)
  priority = _messages.IntegerField(16, variant=_messages.Variant.INT32)
  resetContexts = _messages.BooleanField(17)
  rootFollowupIntentName = _messages.StringField(18)
  trainingPhrases = _messages.MessageField('GoogleCloudDialogflowV2beta1IntentTrainingPhrase', 19, repeated=True)
  webhookState = _messages.EnumField('WebhookStateValueValuesEnum', 20)


class GoogleCloudDialogflowV2beta1IntentFollowupIntentInfo(_messages.Message):
  r"""Represents a single followup intent in the chain.

  Fields:
    followupIntentName: The unique identifier of the followup intent. Format:
      `projects/<Project ID>/agent/intents/<Intent ID>`.
    parentFollowupIntentName: The unique identifier of the followup intent's
      parent. Format: `projects/<Project ID>/agent/intents/<Intent ID>`.
  """

  followupIntentName = _messages.StringField(1)
  parentFollowupIntentName = _messages.StringField(2)


class GoogleCloudDialogflowV2beta1IntentMessage(_messages.Message):
  r"""Corresponds to the `Response` field in the Dialogflow console.

  Enums:
    PlatformValueValuesEnum: Optional. The platform that this message is
      intended for.

  Messages:
    PayloadValue: Returns a response containing a custom, platform-specific
      payload. See the Intent.Message.Platform type for a description of the
      structure that may be required for your platform.

  Fields:
    basicCard: Displays a basic card for Actions on Google.
    browseCarouselCard: Browse carousel card for Actions on Google.
    card: Displays a card.
    carouselSelect: Displays a carousel card for Actions on Google.
    image: Displays an image.
    linkOutSuggestion: Displays a link out suggestion chip for Actions on
      Google.
    listSelect: Displays a list card for Actions on Google.
    mediaContent: The media content card for Actions on Google.
    payload: Returns a response containing a custom, platform-specific
      payload. See the Intent.Message.Platform type for a description of the
      structure that may be required for your platform.
    platform: Optional. The platform that this message is intended for.
    quickReplies: Displays quick replies.
    rbmCarouselRichCard: Rich Business Messaging (RBM) carousel rich card
      response.
    rbmStandaloneRichCard: Standalone Rich Business Messaging (RBM) rich card
      response.
    rbmText: Rich Business Messaging (RBM) text response.  RBM allows
      businesses to send enriched and branded versions of SMS. See
      https://jibe.google.com/business-messaging.
    simpleResponses: Returns a voice or text-only response for Actions on
      Google.
    suggestions: Displays suggestion chips for Actions on Google.
    tableCard: Table card for Actions on Google.
    telephonyPlayAudio: Plays audio from a file in Telephony Gateway.
    telephonySynthesizeSpeech: Synthesizes speech in Telephony Gateway.
    telephonyTransferCall: Transfers the call in Telephony Gateway.
    text: Returns a text response.
  """

  class PlatformValueValuesEnum(_messages.Enum):
    r"""Optional. The platform that this message is intended for.

    Values:
      PLATFORM_UNSPECIFIED: Not specified.
      FACEBOOK: Facebook.
      SLACK: Slack.
      TELEGRAM: Telegram.
      KIK: Kik.
      SKYPE: Skype.
      LINE: Line.
      VIBER: Viber.
      ACTIONS_ON_GOOGLE: Actions on Google. When using Actions on Google, you
        can choose one of the specific Intent.Message types that mention
        support for Actions on Google, or you can use the advanced
        Intent.Message.payload field. The payload field provides access to AoG
        features not available in the specific message types. If using the
        Intent.Message.payload field, it should have a structure similar to
        the JSON message shown here. For more information, see [Actions on
        Google Webhook
        Format](https://developers.google.com/actions/dialogflow/webhook)
        <pre>{   "expectUserResponse": true,   "isSsml": false,
        "noInputPrompts": [],   "richResponse": {     "items": [       {
        "simpleResponse": {           "displayText": "hi",
        "textToSpeech": "hello"         }       }     ],     "suggestions": [
        {         "title": "Say this"       },       {         "title": "or
        this"       }     ]   },   "systemIntent": {     "data": {
        "@type": "type.googleapis.com/google.actions.v2.OptionValueSpec",
        "listSelect": {         "items": [           {
        "optionInfo": {               "key": "key1",               "synonyms":
        [                 "key one"               ]             },
        "title": "must not be empty, but unique"           },           {
        "optionInfo": {               "key": "key2",               "synonyms":
        [                 "key two"               ]             },
        "title": "must not be empty, but unique"           }         ]       }
        },     "intent": "actions.intent.OPTION"   } }</pre>
      TELEPHONY: Telephony Gateway.
      GOOGLE_HANGOUTS: Google Hangouts.
    """
    PLATFORM_UNSPECIFIED = 0
    FACEBOOK = 1
    SLACK = 2
    TELEGRAM = 3
    KIK = 4
    SKYPE = 5
    LINE = 6
    VIBER = 7
    ACTIONS_ON_GOOGLE = 8
    TELEPHONY = 9
    GOOGLE_HANGOUTS = 10

  @encoding.MapUnrecognizedFields('additionalProperties')
  class PayloadValue(_messages.Message):
    r"""Returns a response containing a custom, platform-specific payload. See
    the Intent.Message.Platform type for a description of the structure that
    may be required for your platform.

    Messages:
      AdditionalProperty: An additional property for a PayloadValue object.

    Fields:
      additionalProperties: Properties of the object.
    """

    class AdditionalProperty(_messages.Message):
      r"""An additional property for a PayloadValue object.

      Fields:
        key: Name of the additional property.
        value: A extra_types.JsonValue attribute.
      """

      key = _messages.StringField(1)
      value = _messages.MessageField('extra_types.JsonValue', 2)

    additionalProperties = _messages.MessageField('AdditionalProperty', 1, repeated=True)

  basicCard = _messages.MessageField('GoogleCloudDialogflowV2beta1IntentMessageBasicCard', 1)
  browseCarouselCard = _messages.MessageField('GoogleCloudDialogflowV2beta1IntentMessageBrowseCarouselCard', 2)
  card = _messages.MessageField('GoogleCloudDialogflowV2beta1IntentMessageCard', 3)
  carouselSelect = _messages.MessageField('GoogleCloudDialogflowV2beta1IntentMessageCarouselSelect', 4)
  image = _messages.MessageField('GoogleCloudDialogflowV2beta1IntentMessageImage', 5)
  linkOutSuggestion = _messages.MessageField('GoogleCloudDialogflowV2beta1IntentMessageLinkOutSuggestion', 6)
  listSelect = _messages.MessageField('GoogleCloudDialogflowV2beta1IntentMessageListSelect', 7)
  mediaContent = _messages.MessageField('GoogleCloudDialogflowV2beta1IntentMessageMediaContent', 8)
  payload = _messages.MessageField('PayloadValue', 9)
  platform = _messages.EnumField('PlatformValueValuesEnum', 10)
  quickReplies = _messages.MessageField('GoogleCloudDialogflowV2beta1IntentMessageQuickReplies', 11)
  rbmCarouselRichCard = _messages.MessageField('GoogleCloudDialogflowV2beta1IntentMessageRbmCarouselCard', 12)
  rbmStandaloneRichCard = _messages.MessageField('GoogleCloudDialogflowV2beta1IntentMessageRbmStandaloneCard', 13)
  rbmText = _messages.MessageField('GoogleCloudDialogflowV2beta1IntentMessageRbmText', 14)
  simpleResponses = _messages.MessageField('GoogleCloudDialogflowV2beta1IntentMessageSimpleResponses', 15)
  suggestions = _messages.MessageField('GoogleCloudDialogflowV2beta1IntentMessageSuggestions', 16)
  tableCard = _messages.MessageField('GoogleCloudDialogflowV2beta1IntentMessageTableCard', 17)
  telephonyPlayAudio = _messages.MessageField('GoogleCloudDialogflowV2beta1IntentMessageTelephonyPlayAudio', 18)
  telephonySynthesizeSpeech = _messages.MessageField('GoogleCloudDialogflowV2beta1IntentMessageTelephonySynthesizeSpeech', 19)
  telephonyTransferCall = _messages.MessageField('GoogleCloudDialogflowV2beta1IntentMessageTelephonyTransferCall', 20)
  text = _messages.MessageField('GoogleCloudDialogflowV2beta1IntentMessageText', 21)


class GoogleCloudDialogflowV2beta1IntentMessageBasicCard(_messages.Message):
  r"""The basic card message. Useful for displaying information.

  Fields:
    buttons: Optional. The collection of card buttons.
    formattedText: Required, unless image is present. The body text of the
      card.
    image: Optional. The image for the card.
    subtitle: Optional. The subtitle of the card.
    title: Optional. The title of the card.
  """

  buttons = _messages.MessageField('GoogleCloudDialogflowV2beta1IntentMessageBasicCardButton', 1, repeated=True)
  formattedText = _messages.StringField(2)
  image = _messages.MessageField('GoogleCloudDialogflowV2beta1IntentMessageImage', 3)
  subtitle = _messages.StringField(4)
  title = _messages.StringField(5)


class GoogleCloudDialogflowV2beta1IntentMessageBasicCardButton(_messages.Message):
  r"""The button object that appears at the bottom of a card.

  Fields:
    openUriAction: Required. Action to take when a user taps on the button.
    title: Required. The title of the button.
  """

  openUriAction = _messages.MessageField('GoogleCloudDialogflowV2beta1IntentMessageBasicCardButtonOpenUriAction', 1)
  title = _messages.StringField(2)


class GoogleCloudDialogflowV2beta1IntentMessageBasicCardButtonOpenUriAction(_messages.Message):
  r"""Opens the given URI.

  Fields:
    uri: Required. The HTTP or HTTPS scheme URI.
  """

  uri = _messages.StringField(1)


class GoogleCloudDialogflowV2beta1IntentMessageBrowseCarouselCard(_messages.Message):
  r"""Browse Carousel Card for Actions on Google.
  https://developers.google.com/actions/assistant/responses#browsing_carousel

  Enums:
    ImageDisplayOptionsValueValuesEnum: Optional. Settings for displaying the
      image. Applies to every image in items.

  Fields:
    imageDisplayOptions: Optional. Settings for displaying the image. Applies
      to every image in items.
    items: Required. List of items in the Browse Carousel Card. Minimum of two
      items, maximum of ten.
  """

  class ImageDisplayOptionsValueValuesEnum(_messages.Enum):
    r"""Optional. Settings for displaying the image. Applies to every image in
    items.

    Values:
      IMAGE_DISPLAY_OPTIONS_UNSPECIFIED: Fill the gaps between the image and
        the image container with gray bars.
      GRAY: Fill the gaps between the image and the image container with gray
        bars.
      WHITE: Fill the gaps between the image and the image container with
        white bars.
      CROPPED: Image is scaled such that the image width and height match or
        exceed the container dimensions. This may crop the top and bottom of
        the image if the scaled image height is greater than the container
        height, or crop the left and right of the image if the scaled image
        width is greater than the container width. This is similar to "Zoom
        Mode" on a widescreen TV when playing a 4:3 video.
      BLURRED_BACKGROUND: Pad the gaps between image and image frame with a
        blurred copy of the same image.
    """
    IMAGE_DISPLAY_OPTIONS_UNSPECIFIED = 0
    GRAY = 1
    WHITE = 2
    CROPPED = 3
    BLURRED_BACKGROUND = 4

  imageDisplayOptions = _messages.EnumField('ImageDisplayOptionsValueValuesEnum', 1)
  items = _messages.MessageField('GoogleCloudDialogflowV2beta1IntentMessageBrowseCarouselCardBrowseCarouselCardItem', 2, repeated=True)


class GoogleCloudDialogflowV2beta1IntentMessageBrowseCarouselCardBrowseCarouselCardItem(_messages.Message):
  r"""Browsing carousel tile

  Fields:
    description: Optional. Description of the carousel item. Maximum of four
      lines of text.
    footer: Optional. Text that appears at the bottom of the Browse Carousel
      Card. Maximum of one line of text.
    image: Optional. Hero image for the carousel item.
    openUriAction: Required. Action to present to the user.
    title: Required. Title of the carousel item. Maximum of two lines of text.
  """

  description = _messages.StringField(1)
  footer = _messages.StringField(2)
  image = _messages.MessageField('GoogleCloudDialogflowV2beta1IntentMessageImage', 3)
  openUriAction = _messages.MessageField('GoogleCloudDialogflowV2beta1IntentMessageBrowseCarouselCardBrowseCarouselCardItemOpenUrlAction', 4)
  title = _messages.StringField(5)


class GoogleCloudDialogflowV2beta1IntentMessageBrowseCarouselCardBrowseCarouselCardItemOpenUrlAction(_messages.Message):
  r"""Actions on Google action to open a given url.

  Enums:
    UrlTypeHintValueValuesEnum: Optional. Specifies the type of viewer that is
      used when opening the URL. Defaults to opening via web browser.

  Fields:
    url: Required. URL
    urlTypeHint: Optional. Specifies the type of viewer that is used when
      opening the URL. Defaults to opening via web browser.
  """

  class UrlTypeHintValueValuesEnum(_messages.Enum):
    r"""Optional. Specifies the type of viewer that is used when opening the
    URL. Defaults to opening via web browser.

    Values:
      URL_TYPE_HINT_UNSPECIFIED: Unspecified
      AMP_ACTION: Url would be an amp action
      AMP_CONTENT: URL that points directly to AMP content, or to a canonical
        URL which refers to AMP content via <link rel="amphtml">.
    """
    URL_TYPE_HINT_UNSPECIFIED = 0
    AMP_ACTION = 1
    AMP_CONTENT = 2

  url = _messages.StringField(1)
  urlTypeHint = _messages.EnumField('UrlTypeHintValueValuesEnum', 2)


class GoogleCloudDialogflowV2beta1IntentMessageCard(_messages.Message):
  r"""The card response message.

  Fields:
    buttons: Optional. The collection of card buttons.
    imageUri: Optional. The public URI to an image file for the card.
    subtitle: Optional. The subtitle of the card.
    title: Optional. The title of the card.
  """

  buttons = _messages.MessageField('GoogleCloudDialogflowV2beta1IntentMessageCardButton', 1, repeated=True)
  imageUri = _messages.StringField(2)
  subtitle = _messages.StringField(3)
  title = _messages.StringField(4)


class GoogleCloudDialogflowV2beta1IntentMessageCardButton(_messages.Message):
  r"""Optional. Contains information about a button.

  Fields:
    postback: Optional. The text to send back to the Dialogflow API or a URI
      to open.
    text: Optional. The text to show on the button.
  """

  postback = _messages.StringField(1)
  text = _messages.StringField(2)


class GoogleCloudDialogflowV2beta1IntentMessageCarouselSelect(_messages.Message):
  r"""The card for presenting a carousel of options to select from.

  Fields:
    items: Required. Carousel items.
  """

  items = _messages.MessageField('GoogleCloudDialogflowV2beta1IntentMessageCarouselSelectItem', 1, repeated=True)


class GoogleCloudDialogflowV2beta1IntentMessageCarouselSelectItem(_messages.Message):
  r"""An item in the carousel.

  Fields:
    description: Optional. The body text of the card.
    image: Optional. The image to display.
    info: Required. Additional info about the option item.
    title: Required. Title of the carousel item.
  """

  description = _messages.StringField(1)
  image = _messages.MessageField('GoogleCloudDialogflowV2beta1IntentMessageImage', 2)
  info = _messages.MessageField('GoogleCloudDialogflowV2beta1IntentMessageSelectItemInfo', 3)
  title = _messages.StringField(4)


class GoogleCloudDialogflowV2beta1IntentMessageColumnProperties(_messages.Message):
  r"""Column properties for TableCard.

  Enums:
    HorizontalAlignmentValueValuesEnum: Optional. Defines text alignment for
      all cells in this column.

  Fields:
    header: Required. Column heading.
    horizontalAlignment: Optional. Defines text alignment for all cells in
      this column.
  """

  class HorizontalAlignmentValueValuesEnum(_messages.Enum):
    r"""Optional. Defines text alignment for all cells in this column.

    Values:
      HORIZONTAL_ALIGNMENT_UNSPECIFIED: Text is aligned to the leading edge of
        the column.
      LEADING: Text is aligned to the leading edge of the column.
      CENTER: Text is centered in the column.
      TRAILING: Text is aligned to the trailing edge of the column.
    """
    HORIZONTAL_ALIGNMENT_UNSPECIFIED = 0
    LEADING = 1
    CENTER = 2
    TRAILING = 3

  header = _messages.StringField(1)
  horizontalAlignment = _messages.EnumField('HorizontalAlignmentValueValuesEnum', 2)


class GoogleCloudDialogflowV2beta1IntentMessageImage(_messages.Message):
  r"""The image response message.

  Fields:
    accessibilityText: A text description of the image to be used for
      accessibility, e.g., screen readers. Required if image_uri is set for
      CarouselSelect.
    imageUri: Optional. The public URI to an image file.
  """

  accessibilityText = _messages.StringField(1)
  imageUri = _messages.StringField(2)


class GoogleCloudDialogflowV2beta1IntentMessageLinkOutSuggestion(_messages.Message):
  r"""The suggestion chip message that allows the user to jump out to the app
  or website associated with this agent.

  Fields:
    destinationName: Required. The name of the app or site this chip is
      linking to.
    uri: Required. The URI of the app or site to open when the user taps the
      suggestion chip.
  """

  destinationName = _messages.StringField(1)
  uri = _messages.StringField(2)


class GoogleCloudDialogflowV2beta1IntentMessageListSelect(_messages.Message):
  r"""The card for presenting a list of options to select from.

  Fields:
    items: Required. List items.
    title: Optional. The overall title of the list.
  """

  items = _messages.MessageField('GoogleCloudDialogflowV2beta1IntentMessageListSelectItem', 1, repeated=True)
  title = _messages.StringField(2)


class GoogleCloudDialogflowV2beta1IntentMessageListSelectItem(_messages.Message):
  r"""An item in the list.

  Fields:
    description: Optional. The main text describing the item.
    image: Optional. The image to display.
    info: Required. Additional information about this option.
    title: Required. The title of the list item.
  """

  description = _messages.StringField(1)
  image = _messages.MessageField('GoogleCloudDialogflowV2beta1IntentMessageImage', 2)
  info = _messages.MessageField('GoogleCloudDialogflowV2beta1IntentMessageSelectItemInfo', 3)
  title = _messages.StringField(4)


class GoogleCloudDialogflowV2beta1IntentMessageMediaContent(_messages.Message):
  r"""The media content card for Actions on Google.

  Enums:
    MediaTypeValueValuesEnum: Optional. What type of media is the content (ie
      "audio").

  Fields:
    mediaObjects: Required. List of media objects.
    mediaType: Optional. What type of media is the content (ie "audio").
  """

  class MediaTypeValueValuesEnum(_messages.Enum):
    r"""Optional. What type of media is the content (ie "audio").

    Values:
      RESPONSE_MEDIA_TYPE_UNSPECIFIED: Unspecified.
      AUDIO: Response media type is audio.
    """
    RESPONSE_MEDIA_TYPE_UNSPECIFIED = 0
    AUDIO = 1

  mediaObjects = _messages.MessageField('GoogleCloudDialogflowV2beta1IntentMessageMediaContentResponseMediaObject', 1, repeated=True)
  mediaType = _messages.EnumField('MediaTypeValueValuesEnum', 2)


class GoogleCloudDialogflowV2beta1IntentMessageMediaContentResponseMediaObject(_messages.Message):
  r"""Response media object for media content card.

  Fields:
    contentUrl: Required. Url where the media is stored.
    description: Optional. Description of media card.
    icon: Optional. Icon to display above media content.
    largeImage: Optional. Image to display above media content.
    name: Required. Name of media card.
  """

  contentUrl = _messages.StringField(1)
  description = _messages.StringField(2)
  icon = _messages.MessageField('GoogleCloudDialogflowV2beta1IntentMessageImage', 3)
  largeImage = _messages.MessageField('GoogleCloudDialogflowV2beta1IntentMessageImage', 4)
  name = _messages.StringField(5)


class GoogleCloudDialogflowV2beta1IntentMessageQuickReplies(_messages.Message):
  r"""The quick replies response message.

  Fields:
    quickReplies: Optional. The collection of quick replies.
    title: Optional. The title of the collection of quick replies.
  """

  quickReplies = _messages.StringField(1, repeated=True)
  title = _messages.StringField(2)


class GoogleCloudDialogflowV2beta1IntentMessageRbmCardContent(_messages.Message):
  r"""Rich Business Messaging (RBM) Card content

  Fields:
    description: Optional. Description of the card (at most 2000 bytes).  At
      least one of the title, description or media must be set.
    media: Optional. However at least one of the title, description or media
      must be set. Media (image, GIF or a video) to include in the card.
    suggestions: Optional. List of suggestions to include in the card.
    title: Optional. Title of the card (at most 200 bytes).  At least one of
      the title, description or media must be set.
  """

  description = _messages.StringField(1)
  media = _messages.MessageField('GoogleCloudDialogflowV2beta1IntentMessageRbmCardContentRbmMedia', 2)
  suggestions = _messages.MessageField('GoogleCloudDialogflowV2beta1IntentMessageRbmSuggestion', 3, repeated=True)
  title = _messages.StringField(4)


class GoogleCloudDialogflowV2beta1IntentMessageRbmCardContentRbmMedia(_messages.Message):
  r"""Rich Business Messaging (RBM) Media displayed in Cards The following
  media-types are currently supported:  ## Image Types   image/jpeg
  image/jpg'  image/gif  image/png  ## Video Types   video/h263  video/m4v
  video/mp4  video/mpeg  video/mpeg4  video/webm

  Enums:
    HeightValueValuesEnum: Required for cards with vertical orientation. The
      height of the media within a rich card with a vertical layout.
      (https://goo.gl/NeFCjz). For a standalone card with horizontal layout,
      height is not customizable, and this field is ignored.

  Fields:
    fileUri: Required. Publicly reachable URI of the file. The RBM platform
      determines the MIME type of the file from the content-type field in the
      HTTP headers when the platform fetches the file. The content-type field
      must be present and accurate in the HTTP response from the URL.
    height: Required for cards with vertical orientation. The height of the
      media within a rich card with a vertical layout.
      (https://goo.gl/NeFCjz). For a standalone card with horizontal layout,
      height is not customizable, and this field is ignored.
    thumbnailUri: Optional. Publicly reachable URI of the thumbnail.If you
      don't provide a thumbnail URI, the RBM platform displays a blank
      placeholder thumbnail until the user's device downloads the file.
      Depending on the user's setting, the file may not download automatically
      and may require the user to tap a download button.
  """

  class HeightValueValuesEnum(_messages.Enum):
    r"""Required for cards with vertical orientation. The height of the media
    within a rich card with a vertical layout. (https://goo.gl/NeFCjz). For a
    standalone card with horizontal layout, height is not customizable, and
    this field is ignored.

    Values:
      HEIGHT_UNSPECIFIED: Not specified.
      SHORT: 112 DP.
      MEDIUM: 168 DP.
      TALL: 264 DP. Not available for rich card carousels when the card width
        is set to small.
    """
    HEIGHT_UNSPECIFIED = 0
    SHORT = 1
    MEDIUM = 2
    TALL = 3

  fileUri = _messages.StringField(1)
  height = _messages.EnumField('HeightValueValuesEnum', 2)
  thumbnailUri = _messages.StringField(3)


class GoogleCloudDialogflowV2beta1IntentMessageRbmCarouselCard(_messages.Message):
  r"""Carousel Rich Business Messaging (RBM) rich card.  Rich cards allow you
  to respond to users with more vivid content, e.g. with media and
  suggestions.  For more details about RBM rich cards, please see:
  https://developers.google.com/rcs-business-messaging/rbm/guides/build/send-
  messages#rich-cards. If you want to show a single card with more control
  over the layout, please use RbmStandaloneCard instead.

  Enums:
    CardWidthValueValuesEnum: Required. The width of the cards in the
      carousel.

  Fields:
    cardContents: Required. The cards in the carousel. A carousel must have at
      least 2 cards and at most 10.
    cardWidth: Required. The width of the cards in the carousel.
  """

  class CardWidthValueValuesEnum(_messages.Enum):
    r"""Required. The width of the cards in the carousel.

    Values:
      CARD_WIDTH_UNSPECIFIED: Not specified.
      SMALL: 120 DP. Note that tall media cannot be used.
      MEDIUM: 232 DP.
    """
    CARD_WIDTH_UNSPECIFIED = 0
    SMALL = 1
    MEDIUM = 2

  cardContents = _messages.MessageField('GoogleCloudDialogflowV2beta1IntentMessageRbmCardContent', 1, repeated=True)
  cardWidth = _messages.EnumField('CardWidthValueValuesEnum', 2)


class GoogleCloudDialogflowV2beta1IntentMessageRbmStandaloneCard(_messages.Message):
  r"""Standalone Rich Business Messaging (RBM) rich card.  Rich cards allow
  you to respond to users with more vivid content, e.g. with media and
  suggestions.  For more details about RBM rich cards, please see:
  https://developers.google.com/rcs-business-messaging/rbm/guides/build/send-
  messages#rich-cards. You can group multiple rich cards into one using
  RbmCarouselCard but carousel cards will give you less control over the card
  layout.

  Enums:
    CardOrientationValueValuesEnum: Required. Orientation of the card.
    ThumbnailImageAlignmentValueValuesEnum: Required if orientation is
      horizontal. Image preview alignment for standalone cards with horizontal
      layout.

  Fields:
    cardContent: Required. Card content.
    cardOrientation: Required. Orientation of the card.
    thumbnailImageAlignment: Required if orientation is horizontal. Image
      preview alignment for standalone cards with horizontal layout.
  """

  class CardOrientationValueValuesEnum(_messages.Enum):
    r"""Required. Orientation of the card.

    Values:
      CARD_ORIENTATION_UNSPECIFIED: Not specified.
      HORIZONTAL: Horizontal layout.
      VERTICAL: Vertical layout.
    """
    CARD_ORIENTATION_UNSPECIFIED = 0
    HORIZONTAL = 1
    VERTICAL = 2

  class ThumbnailImageAlignmentValueValuesEnum(_messages.Enum):
    r"""Required if orientation is horizontal. Image preview alignment for
    standalone cards with horizontal layout.

    Values:
      THUMBNAIL_IMAGE_ALIGNMENT_UNSPECIFIED: Not specified.
      LEFT: Thumbnail preview is left-aligned.
      RIGHT: Thumbnail preview is right-aligned.
    """
    THUMBNAIL_IMAGE_ALIGNMENT_UNSPECIFIED = 0
    LEFT = 1
    RIGHT = 2

  cardContent = _messages.MessageField('GoogleCloudDialogflowV2beta1IntentMessageRbmCardContent', 1)
  cardOrientation = _messages.EnumField('CardOrientationValueValuesEnum', 2)
  thumbnailImageAlignment = _messages.EnumField('ThumbnailImageAlignmentValueValuesEnum', 3)


class GoogleCloudDialogflowV2beta1IntentMessageRbmSuggestedAction(_messages.Message):
  r"""Rich Business Messaging (RBM) suggested client-side action that the user
  can choose from the card.

  Fields:
    dial: Suggested client side action: Dial a phone number
    openUrl: Suggested client side action: Open a URI on device
    postbackData: Opaque payload that the Dialogflow receives in a user event
      when the user taps the suggested action. This data will be also
      forwarded to webhook to allow performing custom business logic.
    shareLocation: Suggested client side action: Share user location
    text: Text to display alongside the action.
  """

  dial = _messages.MessageField('GoogleCloudDialogflowV2beta1IntentMessageRbmSuggestedActionRbmSuggestedActionDial', 1)
  openUrl = _messages.MessageField('GoogleCloudDialogflowV2beta1IntentMessageRbmSuggestedActionRbmSuggestedActionOpenUri', 2)
  postbackData = _messages.StringField(3)
  shareLocation = _messages.MessageField('GoogleCloudDialogflowV2beta1IntentMessageRbmSuggestedActionRbmSuggestedActionShareLocation', 4)
  text = _messages.StringField(5)


class GoogleCloudDialogflowV2beta1IntentMessageRbmSuggestedActionRbmSuggestedActionDial(_messages.Message):
  r"""Opens the user's default dialer app with the specified phone number but
  does not dial automatically (https://goo.gl/ergbB2).

  Fields:
    phoneNumber: Required. The phone number to fill in the default dialer app.
      This field should be in [E.164](https://en.wikipedia.org/wiki/E.164)
      format. An example of a correctly formatted phone number: +15556767888.
  """

  phoneNumber = _messages.StringField(1)


class GoogleCloudDialogflowV2beta1IntentMessageRbmSuggestedActionRbmSuggestedActionOpenUri(_messages.Message):
  r"""Opens the user's default web browser app to the specified uri
  (https://goo.gl/6GLJD2). If the user has an app installed that is registered
  as the default handler for the URL, then this app will be opened instead,
  and its icon will be used in the suggested action UI.

  Fields:
    uri: Required. The uri to open on the user device
  """

  uri = _messages.StringField(1)


class GoogleCloudDialogflowV2beta1IntentMessageRbmSuggestedActionRbmSuggestedActionShareLocation(_messages.Message):
  r"""Opens the device's location chooser so the user can pick a location to
  send back to the agent (https://goo.gl/GXotJW).
  """



class GoogleCloudDialogflowV2beta1IntentMessageRbmSuggestedReply(_messages.Message):
  r"""Rich Business Messaging (RBM) suggested reply that the user can click
  instead of typing in their own response.

  Fields:
    postbackData: Opaque payload that the Dialogflow receives in a user event
      when the user taps the suggested reply. This data will be also forwarded
      to webhook to allow performing custom business logic.
    text: Suggested reply text.
  """

  postbackData = _messages.StringField(1)
  text = _messages.StringField(2)


class GoogleCloudDialogflowV2beta1IntentMessageRbmSuggestion(_messages.Message):
  r"""Rich Business Messaging (RBM) suggestion. Suggestions allow user to
  easily select/click a predefined response or perform an action (like opening
  a web uri).

  Fields:
    action: Predefined client side actions that user can choose
    reply: Predefined replies for user to select instead of typing
  """

  action = _messages.MessageField('GoogleCloudDialogflowV2beta1IntentMessageRbmSuggestedAction', 1)
  reply = _messages.MessageField('GoogleCloudDialogflowV2beta1IntentMessageRbmSuggestedReply', 2)


class GoogleCloudDialogflowV2beta1IntentMessageRbmText(_messages.Message):
  r"""Rich Business Messaging (RBM) text response with suggestions.

  Fields:
    rbmSuggestion: Optional. One or more suggestions to show to the user.
    text: Required. Text sent and displayed to the user.
  """

  rbmSuggestion = _messages.MessageField('GoogleCloudDialogflowV2beta1IntentMessageRbmSuggestion', 1, repeated=True)
  text = _messages.StringField(2)


class GoogleCloudDialogflowV2beta1IntentMessageSelectItemInfo(_messages.Message):
  r"""Additional info about the select item for when it is triggered in a
  dialog.

  Fields:
    key: Required. A unique key that will be sent back to the agent if this
      response is given.
    synonyms: Optional. A list of synonyms that can also be used to trigger
      this item in dialog.
  """

  key = _messages.StringField(1)
  synonyms = _messages.StringField(2, repeated=True)


class GoogleCloudDialogflowV2beta1IntentMessageSimpleResponse(_messages.Message):
  r"""The simple response message containing speech or text.

  Fields:
    displayText: Optional. The text to display.
    ssml: One of text_to_speech or ssml must be provided. Structured spoken
      response to the user in the SSML format. Mutually exclusive with
      text_to_speech.
    textToSpeech: One of text_to_speech or ssml must be provided. The plain
      text of the speech output. Mutually exclusive with ssml.
  """

  displayText = _messages.StringField(1)
  ssml = _messages.StringField(2)
  textToSpeech = _messages.StringField(3)


class GoogleCloudDialogflowV2beta1IntentMessageSimpleResponses(_messages.Message):
  r"""The collection of simple response candidates. This message in
  `QueryResult.fulfillment_messages` and
  `WebhookResponse.fulfillment_messages` should contain only one
  `SimpleResponse`.

  Fields:
    simpleResponses: Required. The list of simple responses.
  """

  simpleResponses = _messages.MessageField('GoogleCloudDialogflowV2beta1IntentMessageSimpleResponse', 1, repeated=True)


class GoogleCloudDialogflowV2beta1IntentMessageSuggestion(_messages.Message):
  r"""The suggestion chip message that the user can tap to quickly post a
  reply to the conversation.

  Fields:
    title: Required. The text shown the in the suggestion chip.
  """

  title = _messages.StringField(1)


class GoogleCloudDialogflowV2beta1IntentMessageSuggestions(_messages.Message):
  r"""The collection of suggestions.

  Fields:
    suggestions: Required. The list of suggested replies.
  """

  suggestions = _messages.MessageField('GoogleCloudDialogflowV2beta1IntentMessageSuggestion', 1, repeated=True)


class GoogleCloudDialogflowV2beta1IntentMessageTableCard(_messages.Message):
  r"""Table card for Actions on Google.

  Fields:
    buttons: Optional. List of buttons for the card.
    columnProperties: Optional. Display properties for the columns in this
      table.
    image: Optional. Image which should be displayed on the card.
    rows: Optional. Rows in this table of data.
    subtitle: Optional. Subtitle to the title.
    title: Required. Title of the card.
  """

  buttons = _messages.MessageField('GoogleCloudDialogflowV2beta1IntentMessageBasicCardButton', 1, repeated=True)
  columnProperties = _messages.MessageField('GoogleCloudDialogflowV2beta1IntentMessageColumnProperties', 2, repeated=True)
  image = _messages.MessageField('GoogleCloudDialogflowV2beta1IntentMessageImage', 3)
  rows = _messages.MessageField('GoogleCloudDialogflowV2beta1IntentMessageTableCardRow', 4, repeated=True)
  subtitle = _messages.StringField(5)
  title = _messages.StringField(6)


class GoogleCloudDialogflowV2beta1IntentMessageTableCardCell(_messages.Message):
  r"""Cell of TableCardRow.

  Fields:
    text: Required. Text in this cell.
  """

  text = _messages.StringField(1)


class GoogleCloudDialogflowV2beta1IntentMessageTableCardRow(_messages.Message):
  r"""Row of TableCard.

  Fields:
    cells: Optional. List of cells that make up this row.
    dividerAfter: Optional. Whether to add a visual divider after this row.
  """

  cells = _messages.MessageField('GoogleCloudDialogflowV2beta1IntentMessageTableCardCell', 1, repeated=True)
  dividerAfter = _messages.BooleanField(2)


class GoogleCloudDialogflowV2beta1IntentMessageTelephonyPlayAudio(_messages.Message):
  r"""Plays audio from a file in Telephony Gateway.

  Fields:
    audioUri: Required. URI to a Google Cloud Storage object containing the
      audio to play, e.g., "gs://bucket/object". The object must contain a
      single channel (mono) of linear PCM audio (2 bytes / sample) at 8kHz.
      This object must be readable by the `service-<Project Number>@gcp-sa-
      dialogflow.iam.gserviceaccount.com` service account where <Project
      Number> is the number of the Telephony Gateway project (usually the same
      as the Dialogflow agent project). If the Google Cloud Storage bucket is
      in the Telephony Gateway project, this permission is added by default
      when enabling the Dialogflow V2 API.  For audio from other sources,
      consider using the `TelephonySynthesizeSpeech` message with SSML.
  """

  audioUri = _messages.StringField(1)


class GoogleCloudDialogflowV2beta1IntentMessageTelephonySynthesizeSpeech(_messages.Message):
  r"""Synthesizes speech and plays back the synthesized audio to the caller in
  Telephony Gateway.  Telephony Gateway takes the synthesizer settings from
  `DetectIntentResponse.output_audio_config` which can either be set at
  request-level or can come from the agent-level synthesizer config.

  Fields:
    ssml: The SSML to be synthesized. For more information, see
      [SSML](https://developers.google.com/actions/reference/ssml).
    text: The raw text to be synthesized.
  """

  ssml = _messages.StringField(1)
  text = _messages.StringField(2)


class GoogleCloudDialogflowV2beta1IntentMessageTelephonyTransferCall(_messages.Message):
  r"""Transfers the call in Telephony Gateway.

  Fields:
    phoneNumber: Required. The phone number to transfer the call to in [E.164
      format](https://en.wikipedia.org/wiki/E.164).  We currently only allow
      transferring to US numbers (+1xxxyyyzzzz).
  """

  phoneNumber = _messages.StringField(1)


class GoogleCloudDialogflowV2beta1IntentMessageText(_messages.Message):
  r"""The text response message.

  Fields:
    text: Optional. The collection of the agent's responses.
  """

  text = _messages.StringField(1, repeated=True)


class GoogleCloudDialogflowV2beta1IntentParameter(_messages.Message):
  r"""Represents intent parameters.

  Fields:
    defaultValue: Optional. The default value to use when the `value` yields
      an empty result. Default values can be extracted from contexts by using
      the following syntax: `#context_name.parameter_name`.
    displayName: Required. The name of the parameter.
    entityTypeDisplayName: Optional. The name of the entity type, prefixed
      with `@`, that describes values of the parameter. If the parameter is
      required, this must be provided.
    isList: Optional. Indicates whether the parameter represents a list of
      values.
    mandatory: Optional. Indicates whether the parameter is required. That is,
      whether the intent cannot be completed without collecting the parameter
      value.
    name: The unique identifier of this parameter.
    prompts: Optional. The collection of prompts that the agent can present to
      the user in order to collect a value for the parameter.
    value: Optional. The definition of the parameter value. It can be: - a
      constant string, - a parameter value defined as `$parameter_name`, - an
      original parameter value defined as `$parameter_name.original`, - a
      parameter value from some context defined as
      `#context_name.parameter_name`.
  """

  defaultValue = _messages.StringField(1)
  displayName = _messages.StringField(2)
  entityTypeDisplayName = _messages.StringField(3)
  isList = _messages.BooleanField(4)
  mandatory = _messages.BooleanField(5)
  name = _messages.StringField(6)
  prompts = _messages.StringField(7, repeated=True)
  value = _messages.StringField(8)


class GoogleCloudDialogflowV2beta1IntentTrainingPhrase(_messages.Message):
  r"""Represents an example that the agent is trained on.

  Enums:
    TypeValueValuesEnum: Required. The type of the training phrase.

  Fields:
    name: Output only. The unique identifier of this training phrase.
    parts: Required. The ordered list of training phrase parts. The parts are
      concatenated in order to form the training phrase.  Note: The API does
      not automatically annotate training phrases like the Dialogflow Console
      does.  Note: Do not forget to include whitespace at part boundaries, so
      the training phrase is well formatted when the parts are concatenated.
      If the training phrase does not need to be annotated with parameters,
      you just need a single part with only the Part.text field set.  If you
      want to annotate the training phrase, you must create multiple parts,
      where the fields of each part are populated in one of two ways:  -
      `Part.text` is set to a part of the phrase that has no parameters. -
      `Part.text` is set to a part of the phrase that you want to annotate,
      and the `entity_type`, `alias`, and `user_defined` fields are all
      set.
    timesAddedCount: Optional. Indicates how many times this example was added
      to the intent. Each time a developer adds an existing sample by editing
      an intent or training, this counter is increased.
    type: Required. The type of the training phrase.
  """

  class TypeValueValuesEnum(_messages.Enum):
    r"""Required. The type of the training phrase.

    Values:
      TYPE_UNSPECIFIED: Not specified. This value should never be used.
      EXAMPLE: Examples do not contain @-prefixed entity type names, but
        example parts can be annotated with entity types.
      TEMPLATE: Templates are not annotated with entity types, but they can
        contain @-prefixed entity type names as substrings. Template mode has
        been deprecated. Example mode is the only supported way to create new
        training phrases. If you have existing training phrases that you've
        created in template mode, those will continue to work.
    """
    TYPE_UNSPECIFIED = 0
    EXAMPLE = 1
    TEMPLATE = 2

  name = _messages.StringField(1)
  parts = _messages.MessageField('GoogleCloudDialogflowV2beta1IntentTrainingPhrasePart', 2, repeated=True)
  timesAddedCount = _messages.IntegerField(3, variant=_messages.Variant.INT32)
  type = _messages.EnumField('TypeValueValuesEnum', 4)


class GoogleCloudDialogflowV2beta1IntentTrainingPhrasePart(_messages.Message):
  r"""Represents a part of a training phrase.

  Fields:
    alias: Optional. The parameter name for the value extracted from the
      annotated part of the example. This field is required for annotated
      parts of the training phrase.
    entityType: Optional. The entity type name prefixed with `@`. This field
      is required for annotated parts of the training phrase.
    text: Required. The text for this part.
    userDefined: Optional. Indicates whether the text was manually annotated.
      This field is set to true when the Dialogflow Console is used to
      manually annotate the part. When creating an annotated part with the
      API, you must set this to true.
  """

  alias = _messages.StringField(1)
  entityType = _messages.StringField(2)
  text = _messages.StringField(3)
  userDefined = _messages.BooleanField(4)


class GoogleCloudDialogflowV2beta1KnowledgeAnswers(_messages.Message):
  r"""Represents the result of querying a Knowledge base.

  Fields:
    answers: A list of answers from Knowledge Connector.
  """

  answers = _messages.MessageField('GoogleCloudDialogflowV2beta1KnowledgeAnswersAnswer', 1, repeated=True)


class GoogleCloudDialogflowV2beta1KnowledgeAnswersAnswer(_messages.Message):
  r"""An answer from Knowledge Connector.

  Enums:
    MatchConfidenceLevelValueValuesEnum: The system's confidence level that
      this knowledge answer is a good match for this conversational query.
      NOTE: The confidence level for a given `<query, answer>` pair may change
      without notice, as it depends on models that are constantly being
      improved. However, it will change less frequently than the confidence
      score below, and should be preferred for referencing the quality of an
      answer.

  Fields:
    answer: The piece of text from the `source` knowledge base document that
      answers this conversational query.
    faqQuestion: The corresponding FAQ question if the answer was extracted
      from a FAQ Document, empty otherwise.
    matchConfidence: The system's confidence score that this Knowledge answer
      is a good match for this conversational query. The range is from 0.0
      (completely uncertain) to 1.0 (completely certain). Note: The confidence
      score is likely to vary somewhat (possibly even for identical requests),
      as the underlying model is under constant improvement. It may be
      deprecated in the future. We recommend using `match_confidence_level`
      which should be generally more stable.
    matchConfidenceLevel: The system's confidence level that this knowledge
      answer is a good match for this conversational query. NOTE: The
      confidence level for a given `<query, answer>` pair may change without
      notice, as it depends on models that are constantly being improved.
      However, it will change less frequently than the confidence score below,
      and should be preferred for referencing the quality of an answer.
    source: Indicates which Knowledge Document this answer was extracted from.
      Format: `projects/<Project ID>/knowledgeBases/<Knowledge Base
      ID>/documents/<Document ID>`.
  """

  class MatchConfidenceLevelValueValuesEnum(_messages.Enum):
    r"""The system's confidence level that this knowledge answer is a good
    match for this conversational query. NOTE: The confidence level for a
    given `<query, answer>` pair may change without notice, as it depends on
    models that are constantly being improved. However, it will change less
    frequently than the confidence score below, and should be preferred for
    referencing the quality of an answer.

    Values:
      MATCH_CONFIDENCE_LEVEL_UNSPECIFIED: Not specified.
      LOW: Indicates that the confidence is low.
      MEDIUM: Indicates our confidence is medium.
      HIGH: Indicates our confidence is high.
    """
    MATCH_CONFIDENCE_LEVEL_UNSPECIFIED = 0
    LOW = 1
    MEDIUM = 2
    HIGH = 3

  answer = _messages.StringField(1)
  faqQuestion = _messages.StringField(2)
  matchConfidence = _messages.FloatField(3, variant=_messages.Variant.FLOAT)
  matchConfidenceLevel = _messages.EnumField('MatchConfidenceLevelValueValuesEnum', 4)
  source = _messages.StringField(5)


class GoogleCloudDialogflowV2beta1KnowledgeOperationMetadata(_messages.Message):
  r"""Metadata in google::longrunning::Operation for Knowledge operations.

  Enums:
    StateValueValuesEnum: Required. The current state of this operation.

  Fields:
    state: Required. The current state of this operation.
  """

  class StateValueValuesEnum(_messages.Enum):
    r"""Required. The current state of this operation.

    Values:
      STATE_UNSPECIFIED: State unspecified.
      PENDING: The operation has been created.
      RUNNING: The operation is currently running.
      DONE: The operation is done, either cancelled or completed.
    """
    STATE_UNSPECIFIED = 0
    PENDING = 1
    RUNNING = 2
    DONE = 3

  state = _messages.EnumField('StateValueValuesEnum', 1)


class GoogleCloudDialogflowV2beta1LabelConversationResponse(_messages.Message):
  r"""The response for ConversationDatasets.LabelConversation

  Fields:
    annotatedConversationDataset: New annotated conversation dataset created
      by the labeling task.
  """

  annotatedConversationDataset = _messages.MessageField('GoogleCloudDialogflowV2beta1AnnotatedConversationDataset', 1)


class GoogleCloudDialogflowV2beta1OriginalDetectIntentRequest(_messages.Message):
  r"""Represents the contents of the original request that was passed to the
  `[Streaming]DetectIntent` call.

  Messages:
    PayloadValue: Optional. This field is set to the value of the
      `QueryParameters.payload` field passed in the request. Some integrations
      that query a Dialogflow agent may provide additional information in the
      payload.  In particular for the Telephony Gateway this field has the
      form: <pre>{  "telephony": {    "caller_id": "+18558363987"  } }</pre>
      Note: The caller ID field (`caller_id`) will be redacted for Standard
      Edition agents and populated with the caller ID in [E.164
      format](https://en.wikipedia.org/wiki/E.164) for Enterprise Edition
      agents.

  Fields:
    payload: Optional. This field is set to the value of the
      `QueryParameters.payload` field passed in the request. Some integrations
      that query a Dialogflow agent may provide additional information in the
      payload.  In particular for the Telephony Gateway this field has the
      form: <pre>{  "telephony": {    "caller_id": "+18558363987"  } }</pre>
      Note: The caller ID field (`caller_id`) will be redacted for Standard
      Edition agents and populated with the caller ID in [E.164
      format](https://en.wikipedia.org/wiki/E.164) for Enterprise Edition
      agents.
    source: The source of this request, e.g., `google`, `facebook`, `slack`.
      It is set by Dialogflow-owned servers.
    version: Optional. The version of the protocol used for this request. This
      field is AoG-specific.
  """

  @encoding.MapUnrecognizedFields('additionalProperties')
  class PayloadValue(_messages.Message):
    r"""Optional. This field is set to the value of the
    `QueryParameters.payload` field passed in the request. Some integrations
    that query a Dialogflow agent may provide additional information in the
    payload.  In particular for the Telephony Gateway this field has the form:
    <pre>{  "telephony": {    "caller_id": "+18558363987"  } }</pre> Note: The
    caller ID field (`caller_id`) will be redacted for Standard Edition agents
    and populated with the caller ID in [E.164
    format](https://en.wikipedia.org/wiki/E.164) for Enterprise Edition
    agents.

    Messages:
      AdditionalProperty: An additional property for a PayloadValue object.

    Fields:
      additionalProperties: Properties of the object.
    """

    class AdditionalProperty(_messages.Message):
      r"""An additional property for a PayloadValue object.

      Fields:
        key: Name of the additional property.
        value: A extra_types.JsonValue attribute.
      """

      key = _messages.StringField(1)
      value = _messages.MessageField('extra_types.JsonValue', 2)

    additionalProperties = _messages.MessageField('AdditionalProperty', 1, repeated=True)

  payload = _messages.MessageField('PayloadValue', 1)
  source = _messages.StringField(2)
  version = _messages.StringField(3)


class GoogleCloudDialogflowV2beta1QueryResult(_messages.Message):
  r"""Represents the result of conversational query or event processing.

  Messages:
    DiagnosticInfoValue: The free-form diagnostic info. For example, this
      field could contain webhook call latency. The string keys of the
      Struct's fields map can change without notice.
    ParametersValue: The collection of extracted parameters.
    WebhookPayloadValue: If the query was fulfilled by a webhook call, this
      field is set to the value of the `payload` field returned in the webhook
      response.

  Fields:
    action: The action name from the matched intent.
    allRequiredParamsPresent: This field is set to:  - `false` if the matched
      intent has required parameters and not all of    the required parameter
      values have been collected. - `true` if all required parameter values
      have been collected, or if the    matched intent doesn't contain any
      required parameters.
    diagnosticInfo: The free-form diagnostic info. For example, this field
      could contain webhook call latency. The string keys of the Struct's
      fields map can change without notice.
    fulfillmentMessages: The collection of rich messages to present to the
      user.
    fulfillmentText: The text to be pronounced to the user or shown on the
      screen. Note: This is a legacy field, `fulfillment_messages` should be
      preferred.
    intent: The intent that matched the conversational query. Some, not all
      fields are filled in this message, including but not limited to: `name`,
      `display_name`, `end_interaction` and `is_fallback`.
    intentDetectionConfidence: The intent detection confidence. Values range
      from 0.0 (completely uncertain) to 1.0 (completely certain). This value
      is for informational purpose only and is only used to help match the
      best intent within the classification threshold. This value may change
      for the same end-user expression at any time due to a model retraining
      or change in implementation. If there are `multiple knowledge_answers`
      messages, this value is set to the greatest
      `knowledgeAnswers.match_confidence` value in the list.
    knowledgeAnswers: The result from Knowledge Connector (if any), ordered by
      decreasing `KnowledgeAnswers.match_confidence`.
    languageCode: The language that was triggered during intent detection. See
      [Language
      Support](https://cloud.google.com/dialogflow/docs/reference/language)
      for a list of the currently supported language codes.
    outputContexts: The collection of output contexts. If applicable,
      `output_contexts.parameters` contains entries with name `<parameter
      name>.original` containing the original parameter values before the
      query.
    parameters: The collection of extracted parameters.
    queryText: The original conversational query text:  - If natural language
      text was provided as input, `query_text` contains   a copy of the input.
      - If natural language speech audio was provided as input, `query_text`
      contains the speech recognition result. If speech recognizer produced
      multiple alternatives, a particular one is picked. - If automatic spell
      correction is enabled, `query_text` will contain the   corrected user
      input.
    sentimentAnalysisResult: The sentiment analysis result, which depends on
      the `sentiment_analysis_request_config` specified in the request.
    speechRecognitionConfidence: The Speech recognition confidence between 0.0
      and 1.0. A higher number indicates an estimated greater likelihood that
      the recognized words are correct. The default of 0.0 is a sentinel value
      indicating that confidence was not set.  This field is not guaranteed to
      be accurate or set. In particular this field isn't set for
      StreamingDetectIntent since the streaming endpoint has separate
      confidence estimates per portion of the audio in
      StreamingRecognitionResult.
    webhookPayload: If the query was fulfilled by a webhook call, this field
      is set to the value of the `payload` field returned in the webhook
      response.
    webhookSource: If the query was fulfilled by a webhook call, this field is
      set to the value of the `source` field returned in the webhook response.
  """

  @encoding.MapUnrecognizedFields('additionalProperties')
  class DiagnosticInfoValue(_messages.Message):
    r"""The free-form diagnostic info. For example, this field could contain
    webhook call latency. The string keys of the Struct's fields map can
    change without notice.

    Messages:
      AdditionalProperty: An additional property for a DiagnosticInfoValue
        object.

    Fields:
      additionalProperties: Properties of the object.
    """

    class AdditionalProperty(_messages.Message):
      r"""An additional property for a DiagnosticInfoValue object.

      Fields:
        key: Name of the additional property.
        value: A extra_types.JsonValue attribute.
      """

      key = _messages.StringField(1)
      value = _messages.MessageField('extra_types.JsonValue', 2)

    additionalProperties = _messages.MessageField('AdditionalProperty', 1, repeated=True)

  @encoding.MapUnrecognizedFields('additionalProperties')
  class ParametersValue(_messages.Message):
    r"""The collection of extracted parameters.

    Messages:
      AdditionalProperty: An additional property for a ParametersValue object.

    Fields:
      additionalProperties: Properties of the object.
    """

    class AdditionalProperty(_messages.Message):
      r"""An additional property for a ParametersValue object.

      Fields:
        key: Name of the additional property.
        value: A extra_types.JsonValue attribute.
      """

      key = _messages.StringField(1)
      value = _messages.MessageField('extra_types.JsonValue', 2)

    additionalProperties = _messages.MessageField('AdditionalProperty', 1, repeated=True)

  @encoding.MapUnrecognizedFields('additionalProperties')
  class WebhookPayloadValue(_messages.Message):
    r"""If the query was fulfilled by a webhook call, this field is set to the
    value of the `payload` field returned in the webhook response.

    Messages:
      AdditionalProperty: An additional property for a WebhookPayloadValue
        object.

    Fields:
      additionalProperties: Properties of the object.
    """

    class AdditionalProperty(_messages.Message):
      r"""An additional property for a WebhookPayloadValue object.

      Fields:
        key: Name of the additional property.
        value: A extra_types.JsonValue attribute.
      """

      key = _messages.StringField(1)
      value = _messages.MessageField('extra_types.JsonValue', 2)

    additionalProperties = _messages.MessageField('AdditionalProperty', 1, repeated=True)

  action = _messages.StringField(1)
  allRequiredParamsPresent = _messages.BooleanField(2)
  diagnosticInfo = _messages.MessageField('DiagnosticInfoValue', 3)
  fulfillmentMessages = _messages.MessageField('GoogleCloudDialogflowV2beta1IntentMessage', 4, repeated=True)
  fulfillmentText = _messages.StringField(5)
  intent = _messages.MessageField('GoogleCloudDialogflowV2beta1Intent', 6)
  intentDetectionConfidence = _messages.FloatField(7, variant=_messages.Variant.FLOAT)
  knowledgeAnswers = _messages.MessageField('GoogleCloudDialogflowV2beta1KnowledgeAnswers', 8)
  languageCode = _messages.StringField(9)
  outputContexts = _messages.MessageField('GoogleCloudDialogflowV2beta1Context', 10, repeated=True)
  parameters = _messages.MessageField('ParametersValue', 11)
  queryText = _messages.StringField(12)
  sentimentAnalysisResult = _messages.MessageField('GoogleCloudDialogflowV2beta1SentimentAnalysisResult', 13)
  speechRecognitionConfidence = _messages.FloatField(14, variant=_messages.Variant.FLOAT)
  webhookPayload = _messages.MessageField('WebhookPayloadValue', 15)
  webhookSource = _messages.StringField(16)


class GoogleCloudDialogflowV2beta1Sentiment(_messages.Message):
  r"""The sentiment, such as positive/negative feeling or association, for a
  unit of analysis, such as the query text.

  Fields:
    magnitude: A non-negative number in the [0, +inf) range, which represents
      the absolute magnitude of sentiment, regardless of score (positive or
      negative).
    score: Sentiment score between -1.0 (negative sentiment) and 1.0 (positive
      sentiment).
  """

  magnitude = _messages.FloatField(1, variant=_messages.Variant.FLOAT)
  score = _messages.FloatField(2, variant=_messages.Variant.FLOAT)


class GoogleCloudDialogflowV2beta1SentimentAnalysisResult(_messages.Message):
  r"""The result of sentiment analysis as configured by
  `sentiment_analysis_request_config`.

  Fields:
    queryTextSentiment: The sentiment analysis result for `query_text`.
  """

  queryTextSentiment = _messages.MessageField('GoogleCloudDialogflowV2beta1Sentiment', 1)


class GoogleCloudDialogflowV2beta1WebhookRequest(_messages.Message):
  r"""The request message for a webhook call.

  Fields:
    alternativeQueryResults: Alternative query results from KnowledgeService.
    originalDetectIntentRequest: Optional. The contents of the original
      request that was passed to `[Streaming]DetectIntent` call.
    queryResult: The result of the conversational query or event processing.
      Contains the same value as
      `[Streaming]DetectIntentResponse.query_result`.
    responseId: The unique identifier of the response. Contains the same value
      as `[Streaming]DetectIntentResponse.response_id`.
    session: The unique identifier of detectIntent request session. Can be
      used to identify end-user inside webhook implementation. Format:
      `projects/<Project ID>/agent/sessions/<Session ID>`, or
      `projects/<Project ID>/agent/environments/<Environment ID>/users/<User
      ID>/sessions/<Session ID>`.
  """

  alternativeQueryResults = _messages.MessageField('GoogleCloudDialogflowV2beta1QueryResult', 1, repeated=True)
  originalDetectIntentRequest = _messages.MessageField('GoogleCloudDialogflowV2beta1OriginalDetectIntentRequest', 2)
  queryResult = _messages.MessageField('GoogleCloudDialogflowV2beta1QueryResult', 3)
  responseId = _messages.StringField(4)
  session = _messages.StringField(5)


class GoogleCloudDialogflowV2beta1WebhookResponse(_messages.Message):
  r"""The response message for a webhook call.

  Messages:
    PayloadValue: Optional. This value is passed directly to
      `QueryResult.webhook_payload`. See the related
      `fulfillment_messages[i].payload field`, which may be used as an
      alternative to this field.  This field can be used for Actions on Google
      responses. It should have a structure similar to the JSON message shown
      here. For more information, see [Actions on Google Webhook
      Format](https://developers.google.com/actions/dialogflow/webhook) <pre>{
      "google": {     "expectUserResponse": true,     "richResponse": {
      "items": [         {           "simpleResponse": {
      "textToSpeech": "this is a simple response"           }         }
      ]     }   } }</pre>

  Fields:
    endInteraction: Optional. Indicates that this intent ends an interaction.
      Some integrations (e.g., Actions on Google or Dialogflow phone gateway)
      use this information to close interaction with an end user. Default is
      false.
    followupEventInput: Optional. Makes the platform immediately invoke
      another `DetectIntent` call internally with the specified event as
      input. When this field is set, Dialogflow ignores the
      `fulfillment_text`, `fulfillment_messages`, and `payload` fields.
    fulfillmentMessages: Optional. The collection of rich messages to present
      to the user. This value is passed directly to
      `QueryResult.fulfillment_messages`.
    fulfillmentText: Optional. The text to be shown on the screen. This value
      is passed directly to `QueryResult.fulfillment_text`.
    outputContexts: Optional. The collection of output contexts. This value is
      passed directly to `QueryResult.output_contexts`.
    payload: Optional. This value is passed directly to
      `QueryResult.webhook_payload`. See the related
      `fulfillment_messages[i].payload field`, which may be used as an
      alternative to this field.  This field can be used for Actions on Google
      responses. It should have a structure similar to the JSON message shown
      here. For more information, see [Actions on Google Webhook
      Format](https://developers.google.com/actions/dialogflow/webhook) <pre>{
      "google": {     "expectUserResponse": true,     "richResponse": {
      "items": [         {           "simpleResponse": {
      "textToSpeech": "this is a simple response"           }         }
      ]     }   } }</pre>
    source: Optional. This value is passed directly to
      `QueryResult.webhook_source`.
  """

  @encoding.MapUnrecognizedFields('additionalProperties')
  class PayloadValue(_messages.Message):
    r"""Optional. This value is passed directly to
    `QueryResult.webhook_payload`. See the related
    `fulfillment_messages[i].payload field`, which may be used as an
    alternative to this field.  This field can be used for Actions on Google
    responses. It should have a structure similar to the JSON message shown
    here. For more information, see [Actions on Google Webhook
    Format](https://developers.google.com/actions/dialogflow/webhook) <pre>{
    "google": {     "expectUserResponse": true,     "richResponse": {
    "items": [         {           "simpleResponse": {
    "textToSpeech": "this is a simple response"           }         }       ]
    }   } }</pre>

    Messages:
      AdditionalProperty: An additional property for a PayloadValue object.

    Fields:
      additionalProperties: Properties of the object.
    """

    class AdditionalProperty(_messages.Message):
      r"""An additional property for a PayloadValue object.

      Fields:
        key: Name of the additional property.
        value: A extra_types.JsonValue attribute.
      """

      key = _messages.StringField(1)
      value = _messages.MessageField('extra_types.JsonValue', 2)

    additionalProperties = _messages.MessageField('AdditionalProperty', 1, repeated=True)

  endInteraction = _messages.BooleanField(1)
  followupEventInput = _messages.MessageField('GoogleCloudDialogflowV2beta1EventInput', 2)
  fulfillmentMessages = _messages.MessageField('GoogleCloudDialogflowV2beta1IntentMessage', 3, repeated=True)
  fulfillmentText = _messages.StringField(4)
  outputContexts = _messages.MessageField('GoogleCloudDialogflowV2beta1Context', 5, repeated=True)
  payload = _messages.MessageField('PayloadValue', 6)
  source = _messages.StringField(7)


class GoogleLongrunningListOperationsResponse(_messages.Message):
  r"""The response message for Operations.ListOperations.

  Fields:
    nextPageToken: The standard List next-page token.
    operations: A list of operations that matches the specified filter in the
      request.
  """

  nextPageToken = _messages.StringField(1)
  operations = _messages.MessageField('GoogleLongrunningOperation', 2, repeated=True)


class GoogleLongrunningOperation(_messages.Message):
  r"""This resource represents a long-running operation that is the result of
  a network API call.

  Messages:
    MetadataValue: Service-specific metadata associated with the operation.
      It typically contains progress information and common metadata such as
      create time. Some services might not provide such metadata.  Any method
      that returns a long-running operation should document the metadata type,
      if any.
    ResponseValue: The normal response of the operation in case of success.
      If the original method returns no data on success, such as `Delete`, the
      response is `google.protobuf.Empty`.  If the original method is standard
      `Get`/`Create`/`Update`, the response should be the resource.  For other
      methods, the response should have the type `XxxResponse`, where `Xxx` is
      the original method name.  For example, if the original method name is
      `TakeSnapshot()`, the inferred response type is `TakeSnapshotResponse`.

  Fields:
    done: If the value is `false`, it means the operation is still in
      progress. If `true`, the operation is completed, and either `error` or
      `response` is available.
    error: The error result of the operation in case of failure or
      cancellation.
    metadata: Service-specific metadata associated with the operation.  It
      typically contains progress information and common metadata such as
      create time. Some services might not provide such metadata.  Any method
      that returns a long-running operation should document the metadata type,
      if any.
    name: The server-assigned name, which is only unique within the same
      service that originally returns it. If you use the default HTTP mapping,
      the `name` should be a resource name ending with
      `operations/{unique_id}`.
    response: The normal response of the operation in case of success.  If the
      original method returns no data on success, such as `Delete`, the
      response is `google.protobuf.Empty`.  If the original method is standard
      `Get`/`Create`/`Update`, the response should be the resource.  For other
      methods, the response should have the type `XxxResponse`, where `Xxx` is
      the original method name.  For example, if the original method name is
      `TakeSnapshot()`, the inferred response type is `TakeSnapshotResponse`.
  """

  @encoding.MapUnrecognizedFields('additionalProperties')
  class MetadataValue(_messages.Message):
    r"""Service-specific metadata associated with the operation.  It typically
    contains progress information and common metadata such as create time.
    Some services might not provide such metadata.  Any method that returns a
    long-running operation should document the metadata type, if any.

    Messages:
      AdditionalProperty: An additional property for a MetadataValue object.

    Fields:
      additionalProperties: Properties of the object. Contains field @type
        with type URL.
    """

    class AdditionalProperty(_messages.Message):
      r"""An additional property for a MetadataValue object.

      Fields:
        key: Name of the additional property.
        value: A extra_types.JsonValue attribute.
      """

      key = _messages.StringField(1)
      value = _messages.MessageField('extra_types.JsonValue', 2)

    additionalProperties = _messages.MessageField('AdditionalProperty', 1, repeated=True)

  @encoding.MapUnrecognizedFields('additionalProperties')
  class ResponseValue(_messages.Message):
    r"""The normal response of the operation in case of success.  If the
    original method returns no data on success, such as `Delete`, the response
    is `google.protobuf.Empty`.  If the original method is standard
    `Get`/`Create`/`Update`, the response should be the resource.  For other
    methods, the response should have the type `XxxResponse`, where `Xxx` is
    the original method name.  For example, if the original method name is
    `TakeSnapshot()`, the inferred response type is `TakeSnapshotResponse`.

    Messages:
      AdditionalProperty: An additional property for a ResponseValue object.

    Fields:
      additionalProperties: Properties of the object. Contains field @type
        with type URL.
    """

    class AdditionalProperty(_messages.Message):
      r"""An additional property for a ResponseValue object.

      Fields:
        key: Name of the additional property.
        value: A extra_types.JsonValue attribute.
      """

      key = _messages.StringField(1)
      value = _messages.MessageField('extra_types.JsonValue', 2)

    additionalProperties = _messages.MessageField('AdditionalProperty', 1, repeated=True)

  done = _messages.BooleanField(1)
  error = _messages.MessageField('GoogleRpcStatus', 2)
  metadata = _messages.MessageField('MetadataValue', 3)
  name = _messages.StringField(4)
  response = _messages.MessageField('ResponseValue', 5)


class GoogleProtobufEmpty(_messages.Message):
  r"""A generic empty message that you can re-use to avoid defining duplicated
  empty messages in your APIs. A typical example is to use it as the request
  or the response type of an API method. For instance:      service Foo {
  rpc Bar(google.protobuf.Empty) returns (google.protobuf.Empty);     }  The
  JSON representation for `Empty` is empty JSON object `{}`.
  """



class GoogleRpcStatus(_messages.Message):
  r"""The `Status` type defines a logical error model that is suitable for
  different programming environments, including REST APIs and RPC APIs. It is
  used by [gRPC](https://github.com/grpc). Each `Status` message contains
  three pieces of data: error code, error message, and error details.  You can
  find out more about this error model and how to work with it in the [API
  Design Guide](https://cloud.google.com/apis/design/errors).

  Messages:
    DetailsValueListEntry: A DetailsValueListEntry object.

  Fields:
    code: The status code, which should be an enum value of google.rpc.Code.
    details: A list of messages that carry the error details.  There is a
      common set of message types for APIs to use.
    message: A developer-facing error message, which should be in English. Any
      user-facing error message should be localized and sent in the
      google.rpc.Status.details field, or localized by the client.
  """

  @encoding.MapUnrecognizedFields('additionalProperties')
  class DetailsValueListEntry(_messages.Message):
    r"""A DetailsValueListEntry object.

    Messages:
      AdditionalProperty: An additional property for a DetailsValueListEntry
        object.

    Fields:
      additionalProperties: Properties of the object. Contains field @type
        with type URL.
    """

    class AdditionalProperty(_messages.Message):
      r"""An additional property for a DetailsValueListEntry object.

      Fields:
        key: Name of the additional property.
        value: A extra_types.JsonValue attribute.
      """

      key = _messages.StringField(1)
      value = _messages.MessageField('extra_types.JsonValue', 2)

    additionalProperties = _messages.MessageField('AdditionalProperty', 1, repeated=True)

  code = _messages.IntegerField(1, variant=_messages.Variant.INT32)
  details = _messages.MessageField('DetailsValueListEntry', 2, repeated=True)
  message = _messages.StringField(3)


class GoogleTypeLatLng(_messages.Message):
  r"""An object representing a latitude/longitude pair. This is expressed as a
  pair of doubles representing degrees latitude and degrees longitude. Unless
  specified otherwise, this must conform to the <a
  href="http://www.unoosa.org/pdf/icg/2012/template/WGS_84.pdf">WGS84
  standard</a>. Values must be within normalized ranges.

  Fields:
    latitude: The latitude in degrees. It must be in the range [-90.0, +90.0].
    longitude: The longitude in degrees. It must be in the range [-180.0,
      +180.0].
  """

  latitude = _messages.FloatField(1)
  longitude = _messages.FloatField(2)


class StandardQueryParameters(_messages.Message):
  r"""Query parameters accepted by all methods.

  Enums:
    FXgafvValueValuesEnum: V1 error format.
    AltValueValuesEnum: Data format for response.

  Fields:
    f__xgafv: V1 error format.
    access_token: OAuth access token.
    alt: Data format for response.
    callback: JSONP
    fields: Selector specifying which fields to include in a partial response.
    key: API key. Your API key identifies your project and provides you with
      API access, quota, and reports. Required unless you provide an OAuth 2.0
      token.
    oauth_token: OAuth 2.0 token for the current user.
    prettyPrint: Returns response with indentations and line breaks.
    quotaUser: Available to use for quota purposes for server-side
      applications. Can be any arbitrary string assigned to a user, but should
      not exceed 40 characters.
    trace: A tracing token of the form "token:<tokenid>" to include in api
      requests.
    uploadType: Legacy upload protocol for media (e.g. "media", "multipart").
    upload_protocol: Upload protocol for media (e.g. "raw", "multipart").
  """

  class AltValueValuesEnum(_messages.Enum):
    r"""Data format for response.

    Values:
      json: Responses with Content-Type of application/json
      media: Media download with context-dependent Content-Type
      proto: Responses with Content-Type of application/x-protobuf
    """
    json = 0
    media = 1
    proto = 2

  class FXgafvValueValuesEnum(_messages.Enum):
    r"""V1 error format.

    Values:
      _1: v1 error format
      _2: v2 error format
    """
    _1 = 0
    _2 = 1

  f__xgafv = _messages.EnumField('FXgafvValueValuesEnum', 1)
  access_token = _messages.StringField(2)
  alt = _messages.EnumField('AltValueValuesEnum', 3, default=u'json')
  callback = _messages.StringField(4)
  fields = _messages.StringField(5)
  key = _messages.StringField(6)
  oauth_token = _messages.StringField(7)
  prettyPrint = _messages.BooleanField(8, default=True)
  quotaUser = _messages.StringField(9)
  trace = _messages.StringField(10)
  uploadType = _messages.StringField(11)
  upload_protocol = _messages.StringField(12)


encoding.AddCustomJsonFieldMapping(
    StandardQueryParameters, 'f__xgafv', '$.xgafv')
encoding.AddCustomJsonEnumMapping(
    StandardQueryParameters.FXgafvValueValuesEnum, '_1', '1')
encoding.AddCustomJsonEnumMapping(
    StandardQueryParameters.FXgafvValueValuesEnum, '_2', '2')
