"""Generated message classes for cloudkms version v1.

Manages keys and performs cryptographic operations in a central cloud service,
for direct use by other cloud resources and applications.
"""
# NOTE: This file is autogenerated and should not be edited by hand.

from apitools.base.protorpclite import messages as _messages
from apitools.base.py import encoding
from apitools.base.py import extra_types


package = 'cloudkms'


class AsymmetricDecryptRequest(_messages.Message):
  r"""Request message for KeyManagementService.AsymmetricDecrypt.

  Fields:
    ciphertext: Required. The data encrypted with the named CryptoKeyVersion's
      public key using OAEP.
  """

  ciphertext = _messages.BytesField(1)


class AsymmetricDecryptResponse(_messages.Message):
  r"""Response message for KeyManagementService.AsymmetricDecrypt.

  Fields:
    plaintext: The decrypted data originally encrypted with the matching
      public key.
  """

  plaintext = _messages.BytesField(1)


class AsymmetricSignRequest(_messages.Message):
  r"""Request message for KeyManagementService.AsymmetricSign.

  Fields:
    digest: Required. The digest of the data to sign. The digest must be
      produced with the same digest algorithm as specified by the key
      version's algorithm.
  """

  digest = _messages.MessageField('Digest', 1)


class AsymmetricSignResponse(_messages.Message):
  r"""Response message for KeyManagementService.AsymmetricSign.

  Fields:
    signature: The created signature.
  """

  signature = _messages.BytesField(1)


class AuditConfig(_messages.Message):
  r"""Specifies the audit configuration for a service. The configuration
  determines which permission types are logged, and what identities, if any,
  are exempted from logging. An AuditConfig must have one or more
  AuditLogConfigs.  If there are AuditConfigs for both `allServices` and a
  specific service, the union of the two AuditConfigs is used for that
  service: the log_types specified in each AuditConfig are enabled, and the
  exempted_members in each AuditLogConfig are exempted.  Example Policy with
  multiple AuditConfigs:      {       "audit_configs": [         {
  "service": "allServices"           "audit_log_configs": [             {
  "log_type": "DATA_READ",               "exempted_members": [
  "user:jose@example.com"               ]             },             {
  "log_type": "DATA_WRITE",             },             {
  "log_type": "ADMIN_READ",             }           ]         },         {
  "service": "sampleservice.googleapis.com"           "audit_log_configs": [
  {               "log_type": "DATA_READ",             },             {
  "log_type": "DATA_WRITE",               "exempted_members": [
  "user:aliya@example.com"               ]             }           ]         }
  ]     }  For sampleservice, this policy enables DATA_READ, DATA_WRITE and
  ADMIN_READ logging. It also exempts jose@example.com from DATA_READ logging,
  and aliya@example.com from DATA_WRITE logging.

  Fields:
    auditLogConfigs: The configuration for logging of each type of permission.
    service: Specifies a service that will be enabled for audit logging. For
      example, `storage.googleapis.com`, `cloudsql.googleapis.com`.
      `allServices` is a special value that covers all services.
  """

  auditLogConfigs = _messages.MessageField('AuditLogConfig', 1, repeated=True)
  service = _messages.StringField(2)


class AuditLogConfig(_messages.Message):
  r"""Provides the configuration for logging a type of permissions. Example:
  {       "audit_log_configs": [         {           "log_type": "DATA_READ",
  "exempted_members": [             "user:jose@example.com"           ]
  },         {           "log_type": "DATA_WRITE",         }       ]     }
  This enables 'DATA_READ' and 'DATA_WRITE' logging, while exempting
  jose@example.com from DATA_READ logging.

  Enums:
    LogTypeValueValuesEnum: The log type that this config enables.

  Fields:
    exemptedMembers: Specifies the identities that do not cause logging for
      this type of permission. Follows the same format of Binding.members.
    logType: The log type that this config enables.
  """

  class LogTypeValueValuesEnum(_messages.Enum):
    r"""The log type that this config enables.

    Values:
      LOG_TYPE_UNSPECIFIED: Default case. Should never be this.
      ADMIN_READ: Admin reads. Example: CloudIAM getIamPolicy
      DATA_WRITE: Data writes. Example: CloudSQL Users create
      DATA_READ: Data reads. Example: CloudSQL Users list
    """
    LOG_TYPE_UNSPECIFIED = 0
    ADMIN_READ = 1
    DATA_WRITE = 2
    DATA_READ = 3

  exemptedMembers = _messages.StringField(1, repeated=True)
  logType = _messages.EnumField('LogTypeValueValuesEnum', 2)


class Binding(_messages.Message):
  r"""Associates `members` with a `role`.

  Fields:
    condition: The condition that is associated with this binding. NOTE: An
      unsatisfied condition will not allow user access via current binding.
      Different bindings, including their conditions, are examined
      independently.
    members: Specifies the identities requesting access for a Cloud Platform
      resource. `members` can have the following values:  * `allUsers`: A
      special identifier that represents anyone who is    on the internet;
      with or without a Google account.  * `allAuthenticatedUsers`: A special
      identifier that represents anyone    who is authenticated with a Google
      account or a service account.  * `user:{emailid}`: An email address that
      represents a specific Google    account. For example,
      `alice@example.com` .   * `serviceAccount:{emailid}`: An email address
      that represents a service    account. For example, `my-other-
      app@appspot.gserviceaccount.com`.  * `group:{emailid}`: An email address
      that represents a Google group.    For example, `admins@example.com`.
      * `domain:{domain}`: The G Suite domain (primary) that represents all
      the    users of that domain. For example, `google.com` or `example.com`.
    role: Role that is assigned to `members`. For example, `roles/viewer`,
      `roles/editor`, or `roles/owner`.
  """

  condition = _messages.MessageField('Expr', 1)
  members = _messages.StringField(2, repeated=True)
  role = _messages.StringField(3)


class CloudkmsProjectsLocationsGetRequest(_messages.Message):
  r"""A CloudkmsProjectsLocationsGetRequest object.

  Fields:
    name: Resource name for the location.
  """

  name = _messages.StringField(1, required=True)


class CloudkmsProjectsLocationsKeyRingsCreateRequest(_messages.Message):
  r"""A CloudkmsProjectsLocationsKeyRingsCreateRequest object.

  Fields:
    keyRing: A KeyRing resource to be passed as the request body.
    keyRingId: Required. It must be unique within a location and match the
      regular expression `[a-zA-Z0-9_-]{1,63}`
    parent: Required. The resource name of the location associated with the
      KeyRings, in the format `projects/*/locations/*`.
  """

  keyRing = _messages.MessageField('KeyRing', 1)
  keyRingId = _messages.StringField(2)
  parent = _messages.StringField(3, required=True)


class CloudkmsProjectsLocationsKeyRingsCryptoKeysCreateRequest(_messages.Message):
  r"""A CloudkmsProjectsLocationsKeyRingsCryptoKeysCreateRequest object.

  Fields:
    cryptoKey: A CryptoKey resource to be passed as the request body.
    cryptoKeyId: Required. It must be unique within a KeyRing and match the
      regular expression `[a-zA-Z0-9_-]{1,63}`
    parent: Required. The name of the KeyRing associated with the CryptoKeys.
    skipInitialVersionCreation: If set to true, the request will create a
      CryptoKey without any CryptoKeyVersions. You must manually call
      CreateCryptoKeyVersion or ImportCryptoKeyVersion before you can use this
      CryptoKey.
  """

  cryptoKey = _messages.MessageField('CryptoKey', 1)
  cryptoKeyId = _messages.StringField(2)
  parent = _messages.StringField(3, required=True)
  skipInitialVersionCreation = _messages.BooleanField(4)


class CloudkmsProjectsLocationsKeyRingsCryptoKeysCryptoKeyVersionsAsymmetricDecryptRequest(_messages.Message):
  r"""A CloudkmsProjectsLocationsKeyRingsCryptoKeysCryptoKeyVersionsAsymmetric
  DecryptRequest object.

  Fields:
    asymmetricDecryptRequest: A AsymmetricDecryptRequest resource to be passed
      as the request body.
    name: Required. The resource name of the CryptoKeyVersion to use for
      decryption.
  """

  asymmetricDecryptRequest = _messages.MessageField('AsymmetricDecryptRequest', 1)
  name = _messages.StringField(2, required=True)


class CloudkmsProjectsLocationsKeyRingsCryptoKeysCryptoKeyVersionsAsymmetricSignRequest(_messages.Message):
  r"""A CloudkmsProjectsLocationsKeyRingsCryptoKeysCryptoKeyVersionsAsymmetric
  SignRequest object.

  Fields:
    asymmetricSignRequest: A AsymmetricSignRequest resource to be passed as
      the request body.
    name: Required. The resource name of the CryptoKeyVersion to use for
      signing.
  """

  asymmetricSignRequest = _messages.MessageField('AsymmetricSignRequest', 1)
  name = _messages.StringField(2, required=True)


class CloudkmsProjectsLocationsKeyRingsCryptoKeysCryptoKeyVersionsCreateRequest(_messages.Message):
  r"""A
  CloudkmsProjectsLocationsKeyRingsCryptoKeysCryptoKeyVersionsCreateRequest
  object.

  Fields:
    cryptoKeyVersion: A CryptoKeyVersion resource to be passed as the request
      body.
    parent: Required. The name of the CryptoKey associated with the
      CryptoKeyVersions.
  """

  cryptoKeyVersion = _messages.MessageField('CryptoKeyVersion', 1)
  parent = _messages.StringField(2, required=True)


class CloudkmsProjectsLocationsKeyRingsCryptoKeysCryptoKeyVersionsDestroyRequest(_messages.Message):
  r"""A
  CloudkmsProjectsLocationsKeyRingsCryptoKeysCryptoKeyVersionsDestroyRequest
  object.

  Fields:
    destroyCryptoKeyVersionRequest: A DestroyCryptoKeyVersionRequest resource
      to be passed as the request body.
    name: The resource name of the CryptoKeyVersion to destroy.
  """

  destroyCryptoKeyVersionRequest = _messages.MessageField('DestroyCryptoKeyVersionRequest', 1)
  name = _messages.StringField(2, required=True)


class CloudkmsProjectsLocationsKeyRingsCryptoKeysCryptoKeyVersionsGetPublicKeyRequest(_messages.Message):
  r"""A CloudkmsProjectsLocationsKeyRingsCryptoKeysCryptoKeyVersionsGetPublicK
  eyRequest object.

  Fields:
    name: The name of the CryptoKeyVersion public key to get.
  """

  name = _messages.StringField(1, required=True)


class CloudkmsProjectsLocationsKeyRingsCryptoKeysCryptoKeyVersionsGetRequest(_messages.Message):
  r"""A CloudkmsProjectsLocationsKeyRingsCryptoKeysCryptoKeyVersionsGetRequest
  object.

  Fields:
    name: The name of the CryptoKeyVersion to get.
  """

  name = _messages.StringField(1, required=True)


class CloudkmsProjectsLocationsKeyRingsCryptoKeysCryptoKeyVersionsImportRequest(_messages.Message):
  r"""A
  CloudkmsProjectsLocationsKeyRingsCryptoKeysCryptoKeyVersionsImportRequest
  object.

  Fields:
    importCryptoKeyVersionRequest: A ImportCryptoKeyVersionRequest resource to
      be passed as the request body.
    parent: Required. The name of the CryptoKey to be imported into.
  """

  importCryptoKeyVersionRequest = _messages.MessageField('ImportCryptoKeyVersionRequest', 1)
  parent = _messages.StringField(2, required=True)


class CloudkmsProjectsLocationsKeyRingsCryptoKeysCryptoKeyVersionsListRequest(_messages.Message):
  r"""A
  CloudkmsProjectsLocationsKeyRingsCryptoKeysCryptoKeyVersionsListRequest
  object.

  Enums:
    ViewValueValuesEnum: The fields to include in the response.

  Fields:
    filter: Optional. Only include resources that match the filter in the
      response. For more information, see [Sorting and filtering list
      results](https://cloud.google.com/kms/docs/sorting-and-filtering).
    orderBy: Optional. Specify how the results should be sorted. If not
      specified, the results will be sorted in the default order. For more
      information, see [Sorting and filtering list
      results](https://cloud.google.com/kms/docs/sorting-and-filtering).
    pageSize: Optional limit on the number of CryptoKeyVersions to include in
      the response. Further CryptoKeyVersions can subsequently be obtained by
      including the ListCryptoKeyVersionsResponse.next_page_token in a
      subsequent request. If unspecified, the server will pick an appropriate
      default.
    pageToken: Optional pagination token, returned earlier via
      ListCryptoKeyVersionsResponse.next_page_token.
    parent: Required. The resource name of the CryptoKey to list, in the
      format `projects/*/locations/*/keyRings/*/cryptoKeys/*`.
    view: The fields to include in the response.
  """

  class ViewValueValuesEnum(_messages.Enum):
    r"""The fields to include in the response.

    Values:
      CRYPTO_KEY_VERSION_VIEW_UNSPECIFIED: <no description>
      FULL: <no description>
    """
    CRYPTO_KEY_VERSION_VIEW_UNSPECIFIED = 0
    FULL = 1

  filter = _messages.StringField(1)
  orderBy = _messages.StringField(2)
  pageSize = _messages.IntegerField(3, variant=_messages.Variant.INT32)
  pageToken = _messages.StringField(4)
  parent = _messages.StringField(5, required=True)
  view = _messages.EnumField('ViewValueValuesEnum', 6)


class CloudkmsProjectsLocationsKeyRingsCryptoKeysCryptoKeyVersionsPatchRequest(_messages.Message):
  r"""A
  CloudkmsProjectsLocationsKeyRingsCryptoKeysCryptoKeyVersionsPatchRequest
  object.

  Fields:
    cryptoKeyVersion: A CryptoKeyVersion resource to be passed as the request
      body.
    name: Output only. The resource name for this CryptoKeyVersion in the
      format
      `projects/*/locations/*/keyRings/*/cryptoKeys/*/cryptoKeyVersions/*`.
    updateMask: Required list of fields to be updated in this request.
  """

  cryptoKeyVersion = _messages.MessageField('CryptoKeyVersion', 1)
  name = _messages.StringField(2, required=True)
  updateMask = _messages.StringField(3)


class CloudkmsProjectsLocationsKeyRingsCryptoKeysCryptoKeyVersionsRestoreRequest(_messages.Message):
  r"""A
  CloudkmsProjectsLocationsKeyRingsCryptoKeysCryptoKeyVersionsRestoreRequest
  object.

  Fields:
    name: The resource name of the CryptoKeyVersion to restore.
    restoreCryptoKeyVersionRequest: A RestoreCryptoKeyVersionRequest resource
      to be passed as the request body.
  """

  name = _messages.StringField(1, required=True)
  restoreCryptoKeyVersionRequest = _messages.MessageField('RestoreCryptoKeyVersionRequest', 2)


class CloudkmsProjectsLocationsKeyRingsCryptoKeysDecryptRequest(_messages.Message):
  r"""A CloudkmsProjectsLocationsKeyRingsCryptoKeysDecryptRequest object.

  Fields:
    decryptRequest: A DecryptRequest resource to be passed as the request
      body.
    name: Required. The resource name of the CryptoKey to use for decryption.
      The server will choose the appropriate version.
  """

  decryptRequest = _messages.MessageField('DecryptRequest', 1)
  name = _messages.StringField(2, required=True)


class CloudkmsProjectsLocationsKeyRingsCryptoKeysEncryptRequest(_messages.Message):
  r"""A CloudkmsProjectsLocationsKeyRingsCryptoKeysEncryptRequest object.

  Fields:
    encryptRequest: A EncryptRequest resource to be passed as the request
      body.
    name: Required. The resource name of the CryptoKey or CryptoKeyVersion to
      use for encryption.  If a CryptoKey is specified, the server will use
      its primary version.
  """

  encryptRequest = _messages.MessageField('EncryptRequest', 1)
  name = _messages.StringField(2, required=True)


class CloudkmsProjectsLocationsKeyRingsCryptoKeysGetIamPolicyRequest(_messages.Message):
  r"""A CloudkmsProjectsLocationsKeyRingsCryptoKeysGetIamPolicyRequest object.

  Fields:
    options_requestedPolicyVersion: Optional. The policy format version to be
      returned.  Valid values are 0, 1, and 3. Requests specifying an invalid
      value will be rejected.  Requests for policies with any conditional
      bindings must specify version 3. Policies without any conditional
      bindings may specify any valid value or leave the field unset.
    resource: REQUIRED: The resource for which the policy is being requested.
      See the operation documentation for the appropriate value for this
      field.
  """

  options_requestedPolicyVersion = _messages.IntegerField(1, variant=_messages.Variant.INT32)
  resource = _messages.StringField(2, required=True)


class CloudkmsProjectsLocationsKeyRingsCryptoKeysGetRequest(_messages.Message):
  r"""A CloudkmsProjectsLocationsKeyRingsCryptoKeysGetRequest object.

  Fields:
    name: The name of the CryptoKey to get.
  """

  name = _messages.StringField(1, required=True)


class CloudkmsProjectsLocationsKeyRingsCryptoKeysListRequest(_messages.Message):
  r"""A CloudkmsProjectsLocationsKeyRingsCryptoKeysListRequest object.

  Enums:
    VersionViewValueValuesEnum: The fields of the primary version to include
      in the response.

  Fields:
    filter: Optional. Only include resources that match the filter in the
      response. For more information, see [Sorting and filtering list
      results](https://cloud.google.com/kms/docs/sorting-and-filtering).
    orderBy: Optional. Specify how the results should be sorted. If not
      specified, the results will be sorted in the default order. For more
      information, see [Sorting and filtering list
      results](https://cloud.google.com/kms/docs/sorting-and-filtering).
    pageSize: Optional limit on the number of CryptoKeys to include in the
      response.  Further CryptoKeys can subsequently be obtained by including
      the ListCryptoKeysResponse.next_page_token in a subsequent request.  If
      unspecified, the server will pick an appropriate default.
    pageToken: Optional pagination token, returned earlier via
      ListCryptoKeysResponse.next_page_token.
    parent: Required. The resource name of the KeyRing to list, in the format
      `projects/*/locations/*/keyRings/*`.
    versionView: The fields of the primary version to include in the response.
  """

  class VersionViewValueValuesEnum(_messages.Enum):
    r"""The fields of the primary version to include in the response.

    Values:
      CRYPTO_KEY_VERSION_VIEW_UNSPECIFIED: <no description>
      FULL: <no description>
    """
    CRYPTO_KEY_VERSION_VIEW_UNSPECIFIED = 0
    FULL = 1

  filter = _messages.StringField(1)
  orderBy = _messages.StringField(2)
  pageSize = _messages.IntegerField(3, variant=_messages.Variant.INT32)
  pageToken = _messages.StringField(4)
  parent = _messages.StringField(5, required=True)
  versionView = _messages.EnumField('VersionViewValueValuesEnum', 6)


class CloudkmsProjectsLocationsKeyRingsCryptoKeysPatchRequest(_messages.Message):
  r"""A CloudkmsProjectsLocationsKeyRingsCryptoKeysPatchRequest object.

  Fields:
    cryptoKey: A CryptoKey resource to be passed as the request body.
    name: Output only. The resource name for this CryptoKey in the format
      `projects/*/locations/*/keyRings/*/cryptoKeys/*`.
    updateMask: Required list of fields to be updated in this request.
  """

  cryptoKey = _messages.MessageField('CryptoKey', 1)
  name = _messages.StringField(2, required=True)
  updateMask = _messages.StringField(3)


class CloudkmsProjectsLocationsKeyRingsCryptoKeysSetIamPolicyRequest(_messages.Message):
  r"""A CloudkmsProjectsLocationsKeyRingsCryptoKeysSetIamPolicyRequest object.

  Fields:
    resource: REQUIRED: The resource for which the policy is being specified.
      See the operation documentation for the appropriate value for this
      field.
    setIamPolicyRequest: A SetIamPolicyRequest resource to be passed as the
      request body.
  """

  resource = _messages.StringField(1, required=True)
  setIamPolicyRequest = _messages.MessageField('SetIamPolicyRequest', 2)


class CloudkmsProjectsLocationsKeyRingsCryptoKeysTestIamPermissionsRequest(_messages.Message):
  r"""A CloudkmsProjectsLocationsKeyRingsCryptoKeysTestIamPermissionsRequest
  object.

  Fields:
    resource: REQUIRED: The resource for which the policy detail is being
      requested. See the operation documentation for the appropriate value for
      this field.
    testIamPermissionsRequest: A TestIamPermissionsRequest resource to be
      passed as the request body.
  """

  resource = _messages.StringField(1, required=True)
  testIamPermissionsRequest = _messages.MessageField('TestIamPermissionsRequest', 2)


class CloudkmsProjectsLocationsKeyRingsCryptoKeysUpdatePrimaryVersionRequest(_messages.Message):
  r"""A CloudkmsProjectsLocationsKeyRingsCryptoKeysUpdatePrimaryVersionRequest
  object.

  Fields:
    name: The resource name of the CryptoKey to update.
    updateCryptoKeyPrimaryVersionRequest: A
      UpdateCryptoKeyPrimaryVersionRequest resource to be passed as the
      request body.
  """

  name = _messages.StringField(1, required=True)
  updateCryptoKeyPrimaryVersionRequest = _messages.MessageField('UpdateCryptoKeyPrimaryVersionRequest', 2)


class CloudkmsProjectsLocationsKeyRingsGetIamPolicyRequest(_messages.Message):
  r"""A CloudkmsProjectsLocationsKeyRingsGetIamPolicyRequest object.

  Fields:
    options_requestedPolicyVersion: Optional. The policy format version to be
      returned.  Valid values are 0, 1, and 3. Requests specifying an invalid
      value will be rejected.  Requests for policies with any conditional
      bindings must specify version 3. Policies without any conditional
      bindings may specify any valid value or leave the field unset.
    resource: REQUIRED: The resource for which the policy is being requested.
      See the operation documentation for the appropriate value for this
      field.
  """

  options_requestedPolicyVersion = _messages.IntegerField(1, variant=_messages.Variant.INT32)
  resource = _messages.StringField(2, required=True)


class CloudkmsProjectsLocationsKeyRingsGetRequest(_messages.Message):
  r"""A CloudkmsProjectsLocationsKeyRingsGetRequest object.

  Fields:
    name: The name of the KeyRing to get.
  """

  name = _messages.StringField(1, required=True)


class CloudkmsProjectsLocationsKeyRingsImportJobsCreateRequest(_messages.Message):
  r"""A CloudkmsProjectsLocationsKeyRingsImportJobsCreateRequest object.

  Fields:
    importJob: A ImportJob resource to be passed as the request body.
    importJobId: Required. It must be unique within a KeyRing and match the
      regular expression `[a-zA-Z0-9_-]{1,63}`
    parent: Required. The name of the KeyRing associated with the ImportJobs.
  """

  importJob = _messages.MessageField('ImportJob', 1)
  importJobId = _messages.StringField(2)
  parent = _messages.StringField(3, required=True)


class CloudkmsProjectsLocationsKeyRingsImportJobsGetIamPolicyRequest(_messages.Message):
  r"""A CloudkmsProjectsLocationsKeyRingsImportJobsGetIamPolicyRequest object.

  Fields:
    options_requestedPolicyVersion: Optional. The policy format version to be
      returned.  Valid values are 0, 1, and 3. Requests specifying an invalid
      value will be rejected.  Requests for policies with any conditional
      bindings must specify version 3. Policies without any conditional
      bindings may specify any valid value or leave the field unset.
    resource: REQUIRED: The resource for which the policy is being requested.
      See the operation documentation for the appropriate value for this
      field.
  """

  options_requestedPolicyVersion = _messages.IntegerField(1, variant=_messages.Variant.INT32)
  resource = _messages.StringField(2, required=True)


class CloudkmsProjectsLocationsKeyRingsImportJobsGetRequest(_messages.Message):
  r"""A CloudkmsProjectsLocationsKeyRingsImportJobsGetRequest object.

  Fields:
    name: The name of the ImportJob to get.
  """

  name = _messages.StringField(1, required=True)


class CloudkmsProjectsLocationsKeyRingsImportJobsListRequest(_messages.Message):
  r"""A CloudkmsProjectsLocationsKeyRingsImportJobsListRequest object.

  Fields:
    filter: Optional. Only include resources that match the filter in the
      response. For more information, see [Sorting and filtering list
      results](https://cloud.google.com/kms/docs/sorting-and-filtering).
    orderBy: Optional. Specify how the results should be sorted. If not
      specified, the results will be sorted in the default order. For more
      information, see [Sorting and filtering list
      results](https://cloud.google.com/kms/docs/sorting-and-filtering).
    pageSize: Optional limit on the number of ImportJobs to include in the
      response. Further ImportJobs can subsequently be obtained by including
      the ListImportJobsResponse.next_page_token in a subsequent request. If
      unspecified, the server will pick an appropriate default.
    pageToken: Optional pagination token, returned earlier via
      ListImportJobsResponse.next_page_token.
    parent: Required. The resource name of the KeyRing to list, in the format
      `projects/*/locations/*/keyRings/*`.
  """

  filter = _messages.StringField(1)
  orderBy = _messages.StringField(2)
  pageSize = _messages.IntegerField(3, variant=_messages.Variant.INT32)
  pageToken = _messages.StringField(4)
  parent = _messages.StringField(5, required=True)


class CloudkmsProjectsLocationsKeyRingsImportJobsSetIamPolicyRequest(_messages.Message):
  r"""A CloudkmsProjectsLocationsKeyRingsImportJobsSetIamPolicyRequest object.

  Fields:
    resource: REQUIRED: The resource for which the policy is being specified.
      See the operation documentation for the appropriate value for this
      field.
    setIamPolicyRequest: A SetIamPolicyRequest resource to be passed as the
      request body.
  """

  resource = _messages.StringField(1, required=True)
  setIamPolicyRequest = _messages.MessageField('SetIamPolicyRequest', 2)


class CloudkmsProjectsLocationsKeyRingsImportJobsTestIamPermissionsRequest(_messages.Message):
  r"""A CloudkmsProjectsLocationsKeyRingsImportJobsTestIamPermissionsRequest
  object.

  Fields:
    resource: REQUIRED: The resource for which the policy detail is being
      requested. See the operation documentation for the appropriate value for
      this field.
    testIamPermissionsRequest: A TestIamPermissionsRequest resource to be
      passed as the request body.
  """

  resource = _messages.StringField(1, required=True)
  testIamPermissionsRequest = _messages.MessageField('TestIamPermissionsRequest', 2)


class CloudkmsProjectsLocationsKeyRingsListRequest(_messages.Message):
  r"""A CloudkmsProjectsLocationsKeyRingsListRequest object.

  Fields:
    filter: Optional. Only include resources that match the filter in the
      response. For more information, see [Sorting and filtering list
      results](https://cloud.google.com/kms/docs/sorting-and-filtering).
    orderBy: Optional. Specify how the results should be sorted. If not
      specified, the results will be sorted in the default order.  For more
      information, see [Sorting and filtering list
      results](https://cloud.google.com/kms/docs/sorting-and-filtering).
    pageSize: Optional limit on the number of KeyRings to include in the
      response.  Further KeyRings can subsequently be obtained by including
      the ListKeyRingsResponse.next_page_token in a subsequent request.  If
      unspecified, the server will pick an appropriate default.
    pageToken: Optional pagination token, returned earlier via
      ListKeyRingsResponse.next_page_token.
    parent: Required. The resource name of the location associated with the
      KeyRings, in the format `projects/*/locations/*`.
  """

  filter = _messages.StringField(1)
  orderBy = _messages.StringField(2)
  pageSize = _messages.IntegerField(3, variant=_messages.Variant.INT32)
  pageToken = _messages.StringField(4)
  parent = _messages.StringField(5, required=True)


class CloudkmsProjectsLocationsKeyRingsSetIamPolicyRequest(_messages.Message):
  r"""A CloudkmsProjectsLocationsKeyRingsSetIamPolicyRequest object.

  Fields:
    resource: REQUIRED: The resource for which the policy is being specified.
      See the operation documentation for the appropriate value for this
      field.
    setIamPolicyRequest: A SetIamPolicyRequest resource to be passed as the
      request body.
  """

  resource = _messages.StringField(1, required=True)
  setIamPolicyRequest = _messages.MessageField('SetIamPolicyRequest', 2)


class CloudkmsProjectsLocationsKeyRingsTestIamPermissionsRequest(_messages.Message):
  r"""A CloudkmsProjectsLocationsKeyRingsTestIamPermissionsRequest object.

  Fields:
    resource: REQUIRED: The resource for which the policy detail is being
      requested. See the operation documentation for the appropriate value for
      this field.
    testIamPermissionsRequest: A TestIamPermissionsRequest resource to be
      passed as the request body.
  """

  resource = _messages.StringField(1, required=True)
  testIamPermissionsRequest = _messages.MessageField('TestIamPermissionsRequest', 2)


class CloudkmsProjectsLocationsListRequest(_messages.Message):
  r"""A CloudkmsProjectsLocationsListRequest object.

  Fields:
    filter: The standard list filter.
    name: The resource that owns the locations collection, if applicable.
    pageSize: The standard list page size.
    pageToken: The standard list page token.
  """

  filter = _messages.StringField(1)
  name = _messages.StringField(2, required=True)
  pageSize = _messages.IntegerField(3, variant=_messages.Variant.INT32)
  pageToken = _messages.StringField(4)


class CryptoKey(_messages.Message):
  r"""A CryptoKey represents a logical key that can be used for cryptographic
  operations.  A CryptoKey is made up of one or more versions, which represent
  the actual key material used in cryptographic operations.

  Enums:
    PurposeValueValuesEnum: The immutable purpose of this CryptoKey.

  Messages:
    LabelsValue: Labels with user-defined metadata. For more information, see
      [Labeling Keys](/kms/docs/labeling-keys).

  Fields:
    createTime: Output only. The time at which this CryptoKey was created.
    labels: Labels with user-defined metadata. For more information, see
      [Labeling Keys](/kms/docs/labeling-keys).
    name: Output only. The resource name for this CryptoKey in the format
      `projects/*/locations/*/keyRings/*/cryptoKeys/*`.
    nextRotationTime: At next_rotation_time, the Key Management Service will
      automatically:  1. Create a new version of this CryptoKey. 2. Mark the
      new version as primary.  Key rotations performed manually via
      CreateCryptoKeyVersion and UpdateCryptoKeyPrimaryVersion do not affect
      next_rotation_time.  Keys with purpose ENCRYPT_DECRYPT support automatic
      rotation. For other keys, this field must be omitted.
    primary: Output only. A copy of the "primary" CryptoKeyVersion that will
      be used by Encrypt when this CryptoKey is given in EncryptRequest.name.
      The CryptoKey's primary version can be updated via
      UpdateCryptoKeyPrimaryVersion.  All keys with purpose ENCRYPT_DECRYPT
      have a primary. For other keys, this field will be omitted.
    purpose: The immutable purpose of this CryptoKey.
    rotationPeriod: next_rotation_time will be advanced by this period when
      the service automatically rotates a key. Must be at least 24 hours and
      at most 876,000 hours.  If rotation_period is set, next_rotation_time
      must also be set.  Keys with purpose ENCRYPT_DECRYPT support automatic
      rotation. For other keys, this field must be omitted.
    versionTemplate: A template describing settings for new CryptoKeyVersion
      instances. The properties of new CryptoKeyVersion instances created by
      either CreateCryptoKeyVersion or auto-rotation are controlled by this
      template.
  """

  class PurposeValueValuesEnum(_messages.Enum):
    r"""The immutable purpose of this CryptoKey.

    Values:
      CRYPTO_KEY_PURPOSE_UNSPECIFIED: Not specified.
      ENCRYPT_DECRYPT: CryptoKeys with this purpose may be used with Encrypt
        and Decrypt.
      ASYMMETRIC_SIGN: CryptoKeys with this purpose may be used with
        AsymmetricSign and GetPublicKey.
      ASYMMETRIC_DECRYPT: CryptoKeys with this purpose may be used with
        AsymmetricDecrypt and GetPublicKey.
    """
    CRYPTO_KEY_PURPOSE_UNSPECIFIED = 0
    ENCRYPT_DECRYPT = 1
    ASYMMETRIC_SIGN = 2
    ASYMMETRIC_DECRYPT = 3

  @encoding.MapUnrecognizedFields('additionalProperties')
  class LabelsValue(_messages.Message):
    r"""Labels with user-defined metadata. For more information, see [Labeling
    Keys](/kms/docs/labeling-keys).

    Messages:
      AdditionalProperty: An additional property for a LabelsValue object.

    Fields:
      additionalProperties: Additional properties of type LabelsValue
    """

    class AdditionalProperty(_messages.Message):
      r"""An additional property for a LabelsValue object.

      Fields:
        key: Name of the additional property.
        value: A string attribute.
      """

      key = _messages.StringField(1)
      value = _messages.StringField(2)

    additionalProperties = _messages.MessageField('AdditionalProperty', 1, repeated=True)

  createTime = _messages.StringField(1)
  labels = _messages.MessageField('LabelsValue', 2)
  name = _messages.StringField(3)
  nextRotationTime = _messages.StringField(4)
  primary = _messages.MessageField('CryptoKeyVersion', 5)
  purpose = _messages.EnumField('PurposeValueValuesEnum', 6)
  rotationPeriod = _messages.StringField(7)
  versionTemplate = _messages.MessageField('CryptoKeyVersionTemplate', 8)


class CryptoKeyVersion(_messages.Message):
  r"""A CryptoKeyVersion represents an individual cryptographic key, and the
  associated key material.  An ENABLED version can be used for cryptographic
  operations.  For security reasons, the raw cryptographic key material
  represented by a CryptoKeyVersion can never be viewed or exported. It can
  only be used to encrypt, decrypt, or sign data when an authorized user or
  application invokes Cloud KMS.

  Enums:
    AlgorithmValueValuesEnum: Output only. The CryptoKeyVersionAlgorithm that
      this CryptoKeyVersion supports.
    ProtectionLevelValueValuesEnum: Output only. The ProtectionLevel
      describing how crypto operations are performed with this
      CryptoKeyVersion.
    StateValueValuesEnum: The current state of the CryptoKeyVersion.

  Fields:
    algorithm: Output only. The CryptoKeyVersionAlgorithm that this
      CryptoKeyVersion supports.
    attestation: Output only. Statement that was generated and signed by the
      HSM at key creation time. Use this statement to verify attributes of the
      key as stored on the HSM, independently of Google. Only provided for key
      versions with protection_level HSM.
    createTime: Output only. The time at which this CryptoKeyVersion was
      created.
    destroyEventTime: Output only. The time this CryptoKeyVersion's key
      material was destroyed. Only present if state is DESTROYED.
    destroyTime: Output only. The time this CryptoKeyVersion's key material is
      scheduled for destruction. Only present if state is DESTROY_SCHEDULED.
    generateTime: Output only. The time this CryptoKeyVersion's key material
      was generated.
    importFailureReason: Output only. The root cause of an import failure.
      Only present if state is IMPORT_FAILED.
    importJob: Output only. The name of the ImportJob used to import this
      CryptoKeyVersion. Only present if the underlying key material was
      imported.
    importTime: Output only. The time at which this CryptoKeyVersion's key
      material was imported.
    name: Output only. The resource name for this CryptoKeyVersion in the
      format
      `projects/*/locations/*/keyRings/*/cryptoKeys/*/cryptoKeyVersions/*`.
    protectionLevel: Output only. The ProtectionLevel describing how crypto
      operations are performed with this CryptoKeyVersion.
    state: The current state of the CryptoKeyVersion.
  """

  class AlgorithmValueValuesEnum(_messages.Enum):
    r"""Output only. The CryptoKeyVersionAlgorithm that this CryptoKeyVersion
    supports.

    Values:
      CRYPTO_KEY_VERSION_ALGORITHM_UNSPECIFIED: Not specified.
      GOOGLE_SYMMETRIC_ENCRYPTION: Creates symmetric encryption keys.
      RSA_SIGN_PSS_2048_SHA256: RSASSA-PSS 2048 bit key with a SHA256 digest.
      RSA_SIGN_PSS_3072_SHA256: RSASSA-PSS 3072 bit key with a SHA256 digest.
      RSA_SIGN_PSS_4096_SHA256: RSASSA-PSS 4096 bit key with a SHA256 digest.
      RSA_SIGN_PSS_4096_SHA512: RSASSA-PSS 4096 bit key with a SHA512 digest.
      RSA_SIGN_PKCS1_2048_SHA256: RSASSA-PKCS1-v1_5 with a 2048 bit key and a
        SHA256 digest.
      RSA_SIGN_PKCS1_3072_SHA256: RSASSA-PKCS1-v1_5 with a 3072 bit key and a
        SHA256 digest.
      RSA_SIGN_PKCS1_4096_SHA256: RSASSA-PKCS1-v1_5 with a 4096 bit key and a
        SHA256 digest.
      RSA_SIGN_PKCS1_4096_SHA512: RSASSA-PKCS1-v1_5 with a 4096 bit key and a
        SHA512 digest.
      RSA_DECRYPT_OAEP_2048_SHA256: RSAES-OAEP 2048 bit key with a SHA256
        digest.
      RSA_DECRYPT_OAEP_3072_SHA256: RSAES-OAEP 3072 bit key with a SHA256
        digest.
      RSA_DECRYPT_OAEP_4096_SHA256: RSAES-OAEP 4096 bit key with a SHA256
        digest.
      RSA_DECRYPT_OAEP_4096_SHA512: RSAES-OAEP 4096 bit key with a SHA512
        digest.
      EC_SIGN_P256_SHA256: ECDSA on the NIST P-256 curve with a SHA256 digest.
      EC_SIGN_P384_SHA384: ECDSA on the NIST P-384 curve with a SHA384 digest.
    """
    CRYPTO_KEY_VERSION_ALGORITHM_UNSPECIFIED = 0
    GOOGLE_SYMMETRIC_ENCRYPTION = 1
    RSA_SIGN_PSS_2048_SHA256 = 2
    RSA_SIGN_PSS_3072_SHA256 = 3
    RSA_SIGN_PSS_4096_SHA256 = 4
    RSA_SIGN_PSS_4096_SHA512 = 5
    RSA_SIGN_PKCS1_2048_SHA256 = 6
    RSA_SIGN_PKCS1_3072_SHA256 = 7
    RSA_SIGN_PKCS1_4096_SHA256 = 8
    RSA_SIGN_PKCS1_4096_SHA512 = 9
    RSA_DECRYPT_OAEP_2048_SHA256 = 10
    RSA_DECRYPT_OAEP_3072_SHA256 = 11
    RSA_DECRYPT_OAEP_4096_SHA256 = 12
    RSA_DECRYPT_OAEP_4096_SHA512 = 13
    EC_SIGN_P256_SHA256 = 14
    EC_SIGN_P384_SHA384 = 15

  class ProtectionLevelValueValuesEnum(_messages.Enum):
    r"""Output only. The ProtectionLevel describing how crypto operations are
    performed with this CryptoKeyVersion.

    Values:
      PROTECTION_LEVEL_UNSPECIFIED: Not specified.
      SOFTWARE: Crypto operations are performed in software.
      HSM: Crypto operations are performed in a Hardware Security Module.
    """
    PROTECTION_LEVEL_UNSPECIFIED = 0
    SOFTWARE = 1
    HSM = 2

  class StateValueValuesEnum(_messages.Enum):
    r"""The current state of the CryptoKeyVersion.

    Values:
      CRYPTO_KEY_VERSION_STATE_UNSPECIFIED: Not specified.
      PENDING_GENERATION: This version is still being generated. It may not be
        used, enabled, disabled, or destroyed yet. Cloud KMS will
        automatically mark this version ENABLED as soon as the version is
        ready.
      ENABLED: This version may be used for cryptographic operations.
      DISABLED: This version may not be used, but the key material is still
        available, and the version can be placed back into the ENABLED state.
      DESTROYED: This version is destroyed, and the key material is no longer
        stored. A version may not leave this state once entered.
      DESTROY_SCHEDULED: This version is scheduled for destruction, and will
        be destroyed soon. Call RestoreCryptoKeyVersion to put it back into
        the DISABLED state.
      PENDING_IMPORT: This version is still being imported. It may not be
        used, enabled, disabled, or destroyed yet. Cloud KMS will
        automatically mark this version ENABLED as soon as the version is
        ready.
      IMPORT_FAILED: This version was not imported successfully. It may not be
        used, enabled, disabled, or destroyed. The submitted key material has
        been discarded. Additional details can be found in
        CryptoKeyVersion.import_failure_reason.
    """
    CRYPTO_KEY_VERSION_STATE_UNSPECIFIED = 0
    PENDING_GENERATION = 1
    ENABLED = 2
    DISABLED = 3
    DESTROYED = 4
    DESTROY_SCHEDULED = 5
    PENDING_IMPORT = 6
    IMPORT_FAILED = 7

  algorithm = _messages.EnumField('AlgorithmValueValuesEnum', 1)
  attestation = _messages.MessageField('KeyOperationAttestation', 2)
  createTime = _messages.StringField(3)
  destroyEventTime = _messages.StringField(4)
  destroyTime = _messages.StringField(5)
  generateTime = _messages.StringField(6)
  importFailureReason = _messages.StringField(7)
  importJob = _messages.StringField(8)
  importTime = _messages.StringField(9)
  name = _messages.StringField(10)
  protectionLevel = _messages.EnumField('ProtectionLevelValueValuesEnum', 11)
  state = _messages.EnumField('StateValueValuesEnum', 12)


class CryptoKeyVersionTemplate(_messages.Message):
  r"""A CryptoKeyVersionTemplate specifies the properties to use when creating
  a new CryptoKeyVersion, either manually with CreateCryptoKeyVersion or
  automatically as a result of auto-rotation.

  Enums:
    AlgorithmValueValuesEnum: Required. Algorithm to use when creating a
      CryptoKeyVersion based on this template.  For backwards compatibility,
      GOOGLE_SYMMETRIC_ENCRYPTION is implied if both this field is omitted and
      CryptoKey.purpose is ENCRYPT_DECRYPT.
    ProtectionLevelValueValuesEnum: ProtectionLevel to use when creating a
      CryptoKeyVersion based on this template. Immutable. Defaults to
      SOFTWARE.

  Fields:
    algorithm: Required. Algorithm to use when creating a CryptoKeyVersion
      based on this template.  For backwards compatibility,
      GOOGLE_SYMMETRIC_ENCRYPTION is implied if both this field is omitted and
      CryptoKey.purpose is ENCRYPT_DECRYPT.
    protectionLevel: ProtectionLevel to use when creating a CryptoKeyVersion
      based on this template. Immutable. Defaults to SOFTWARE.
  """

  class AlgorithmValueValuesEnum(_messages.Enum):
    r"""Required. Algorithm to use when creating a CryptoKeyVersion based on
    this template.  For backwards compatibility, GOOGLE_SYMMETRIC_ENCRYPTION
    is implied if both this field is omitted and CryptoKey.purpose is
    ENCRYPT_DECRYPT.

    Values:
      CRYPTO_KEY_VERSION_ALGORITHM_UNSPECIFIED: Not specified.
      GOOGLE_SYMMETRIC_ENCRYPTION: Creates symmetric encryption keys.
      RSA_SIGN_PSS_2048_SHA256: RSASSA-PSS 2048 bit key with a SHA256 digest.
      RSA_SIGN_PSS_3072_SHA256: RSASSA-PSS 3072 bit key with a SHA256 digest.
      RSA_SIGN_PSS_4096_SHA256: RSASSA-PSS 4096 bit key with a SHA256 digest.
      RSA_SIGN_PSS_4096_SHA512: RSASSA-PSS 4096 bit key with a SHA512 digest.
      RSA_SIGN_PKCS1_2048_SHA256: RSASSA-PKCS1-v1_5 with a 2048 bit key and a
        SHA256 digest.
      RSA_SIGN_PKCS1_3072_SHA256: RSASSA-PKCS1-v1_5 with a 3072 bit key and a
        SHA256 digest.
      RSA_SIGN_PKCS1_4096_SHA256: RSASSA-PKCS1-v1_5 with a 4096 bit key and a
        SHA256 digest.
      RSA_SIGN_PKCS1_4096_SHA512: RSASSA-PKCS1-v1_5 with a 4096 bit key and a
        SHA512 digest.
      RSA_DECRYPT_OAEP_2048_SHA256: RSAES-OAEP 2048 bit key with a SHA256
        digest.
      RSA_DECRYPT_OAEP_3072_SHA256: RSAES-OAEP 3072 bit key with a SHA256
        digest.
      RSA_DECRYPT_OAEP_4096_SHA256: RSAES-OAEP 4096 bit key with a SHA256
        digest.
      RSA_DECRYPT_OAEP_4096_SHA512: RSAES-OAEP 4096 bit key with a SHA512
        digest.
      EC_SIGN_P256_SHA256: ECDSA on the NIST P-256 curve with a SHA256 digest.
      EC_SIGN_P384_SHA384: ECDSA on the NIST P-384 curve with a SHA384 digest.
    """
    CRYPTO_KEY_VERSION_ALGORITHM_UNSPECIFIED = 0
    GOOGLE_SYMMETRIC_ENCRYPTION = 1
    RSA_SIGN_PSS_2048_SHA256 = 2
    RSA_SIGN_PSS_3072_SHA256 = 3
    RSA_SIGN_PSS_4096_SHA256 = 4
    RSA_SIGN_PSS_4096_SHA512 = 5
    RSA_SIGN_PKCS1_2048_SHA256 = 6
    RSA_SIGN_PKCS1_3072_SHA256 = 7
    RSA_SIGN_PKCS1_4096_SHA256 = 8
    RSA_SIGN_PKCS1_4096_SHA512 = 9
    RSA_DECRYPT_OAEP_2048_SHA256 = 10
    RSA_DECRYPT_OAEP_3072_SHA256 = 11
    RSA_DECRYPT_OAEP_4096_SHA256 = 12
    RSA_DECRYPT_OAEP_4096_SHA512 = 13
    EC_SIGN_P256_SHA256 = 14
    EC_SIGN_P384_SHA384 = 15

  class ProtectionLevelValueValuesEnum(_messages.Enum):
    r"""ProtectionLevel to use when creating a CryptoKeyVersion based on this
    template. Immutable. Defaults to SOFTWARE.

    Values:
      PROTECTION_LEVEL_UNSPECIFIED: Not specified.
      SOFTWARE: Crypto operations are performed in software.
      HSM: Crypto operations are performed in a Hardware Security Module.
    """
    PROTECTION_LEVEL_UNSPECIFIED = 0
    SOFTWARE = 1
    HSM = 2

  algorithm = _messages.EnumField('AlgorithmValueValuesEnum', 1)
  protectionLevel = _messages.EnumField('ProtectionLevelValueValuesEnum', 2)


class DecryptRequest(_messages.Message):
  r"""Request message for KeyManagementService.Decrypt.

  Fields:
    additionalAuthenticatedData: Optional data that must match the data
      originally supplied in EncryptRequest.additional_authenticated_data.
    ciphertext: Required. The encrypted data originally returned in
      EncryptResponse.ciphertext.
  """

  additionalAuthenticatedData = _messages.BytesField(1)
  ciphertext = _messages.BytesField(2)


class DecryptResponse(_messages.Message):
  r"""Response message for KeyManagementService.Decrypt.

  Fields:
    plaintext: The decrypted data originally supplied in
      EncryptRequest.plaintext.
  """

  plaintext = _messages.BytesField(1)


class DestroyCryptoKeyVersionRequest(_messages.Message):
  r"""Request message for KeyManagementService.DestroyCryptoKeyVersion."""


class Digest(_messages.Message):
  r"""A Digest holds a cryptographic message digest.

  Fields:
    sha256: A message digest produced with the SHA-256 algorithm.
    sha384: A message digest produced with the SHA-384 algorithm.
    sha512: A message digest produced with the SHA-512 algorithm.
  """

  sha256 = _messages.BytesField(1)
  sha384 = _messages.BytesField(2)
  sha512 = _messages.BytesField(3)


class EncryptRequest(_messages.Message):
  r"""Request message for KeyManagementService.Encrypt.

  Fields:
    additionalAuthenticatedData: Optional data that, if specified, must also
      be provided during decryption through
      DecryptRequest.additional_authenticated_data.  The maximum size depends
      on the key version's protection_level. For SOFTWARE keys, the AAD must
      be no larger than 64KiB. For HSM keys, the combined length of the
      plaintext and additional_authenticated_data fields must be no larger
      than 8KiB.
    plaintext: Required. The data to encrypt. Must be no larger than 64KiB.
      The maximum size depends on the key version's protection_level. For
      SOFTWARE keys, the plaintext must be no larger than 64KiB. For HSM keys,
      the combined length of the plaintext and additional_authenticated_data
      fields must be no larger than 8KiB.
  """

  additionalAuthenticatedData = _messages.BytesField(1)
  plaintext = _messages.BytesField(2)


class EncryptResponse(_messages.Message):
  r"""Response message for KeyManagementService.Encrypt.

  Fields:
    ciphertext: The encrypted data.
    name: The resource name of the CryptoKeyVersion used in encryption. Check
      this field to verify that the intended resource was used for encryption.
  """

  ciphertext = _messages.BytesField(1)
  name = _messages.StringField(2)


class Expr(_messages.Message):
  r"""Represents an expression text. Example:      title: "User account
  presence"     description: "Determines whether the request has a user
  account"     expression: "size(request.user) > 0"

  Fields:
    description: An optional description of the expression. This is a longer
      text which describes the expression, e.g. when hovered over it in a UI.
    expression: Textual representation of an expression in Common Expression
      Language syntax.  The application context of the containing message
      determines which well-known feature set of CEL is supported.
    location: An optional string indicating the location of the expression for
      error reporting, e.g. a file name and a position in the file.
    title: An optional title for the expression, i.e. a short string
      describing its purpose. This can be used e.g. in UIs which allow to
      enter the expression.
  """

  description = _messages.StringField(1)
  expression = _messages.StringField(2)
  location = _messages.StringField(3)
  title = _messages.StringField(4)


class ImportCryptoKeyVersionRequest(_messages.Message):
  r"""Request message for KeyManagementService.ImportCryptoKeyVersion.

  Enums:
    AlgorithmValueValuesEnum: Required. The algorithm of the key being
      imported. This does not need to match the version_template of the
      CryptoKey this version imports into.

  Fields:
    algorithm: Required. The algorithm of the key being imported. This does
      not need to match the version_template of the CryptoKey this version
      imports into.
    importJob: Required. The name of the ImportJob that was used to wrap this
      key material.
    rsaAesWrappedKey: Wrapped key material produced with
      RSA_OAEP_3072_SHA1_AES_256 or RSA_OAEP_4096_SHA1_AES_256.  This field
      contains the concatenation of two wrapped keys: <ol>   <li>An ephemeral
      AES-256 wrapping key wrapped with the       public_key using RSAES-OAEP
      with SHA-1,       MGF1 with SHA-1, and an empty label.   </li>   <li>The
      key to be imported, wrapped with the ephemeral AES-256 key       using
      AES-KWP (RFC 5649).   </li> </ol>  This format is the same as the format
      produced by PKCS#11 mechanism CKM_RSA_AES_KEY_WRAP.
  """

  class AlgorithmValueValuesEnum(_messages.Enum):
    r"""Required. The algorithm of the key being imported. This does not need
    to match the version_template of the CryptoKey this version imports into.

    Values:
      CRYPTO_KEY_VERSION_ALGORITHM_UNSPECIFIED: Not specified.
      GOOGLE_SYMMETRIC_ENCRYPTION: Creates symmetric encryption keys.
      RSA_SIGN_PSS_2048_SHA256: RSASSA-PSS 2048 bit key with a SHA256 digest.
      RSA_SIGN_PSS_3072_SHA256: RSASSA-PSS 3072 bit key with a SHA256 digest.
      RSA_SIGN_PSS_4096_SHA256: RSASSA-PSS 4096 bit key with a SHA256 digest.
      RSA_SIGN_PSS_4096_SHA512: RSASSA-PSS 4096 bit key with a SHA512 digest.
      RSA_SIGN_PKCS1_2048_SHA256: RSASSA-PKCS1-v1_5 with a 2048 bit key and a
        SHA256 digest.
      RSA_SIGN_PKCS1_3072_SHA256: RSASSA-PKCS1-v1_5 with a 3072 bit key and a
        SHA256 digest.
      RSA_SIGN_PKCS1_4096_SHA256: RSASSA-PKCS1-v1_5 with a 4096 bit key and a
        SHA256 digest.
      RSA_SIGN_PKCS1_4096_SHA512: RSASSA-PKCS1-v1_5 with a 4096 bit key and a
        SHA512 digest.
      RSA_DECRYPT_OAEP_2048_SHA256: RSAES-OAEP 2048 bit key with a SHA256
        digest.
      RSA_DECRYPT_OAEP_3072_SHA256: RSAES-OAEP 3072 bit key with a SHA256
        digest.
      RSA_DECRYPT_OAEP_4096_SHA256: RSAES-OAEP 4096 bit key with a SHA256
        digest.
      RSA_DECRYPT_OAEP_4096_SHA512: RSAES-OAEP 4096 bit key with a SHA512
        digest.
      EC_SIGN_P256_SHA256: ECDSA on the NIST P-256 curve with a SHA256 digest.
      EC_SIGN_P384_SHA384: ECDSA on the NIST P-384 curve with a SHA384 digest.
    """
    CRYPTO_KEY_VERSION_ALGORITHM_UNSPECIFIED = 0
    GOOGLE_SYMMETRIC_ENCRYPTION = 1
    RSA_SIGN_PSS_2048_SHA256 = 2
    RSA_SIGN_PSS_3072_SHA256 = 3
    RSA_SIGN_PSS_4096_SHA256 = 4
    RSA_SIGN_PSS_4096_SHA512 = 5
    RSA_SIGN_PKCS1_2048_SHA256 = 6
    RSA_SIGN_PKCS1_3072_SHA256 = 7
    RSA_SIGN_PKCS1_4096_SHA256 = 8
    RSA_SIGN_PKCS1_4096_SHA512 = 9
    RSA_DECRYPT_OAEP_2048_SHA256 = 10
    RSA_DECRYPT_OAEP_3072_SHA256 = 11
    RSA_DECRYPT_OAEP_4096_SHA256 = 12
    RSA_DECRYPT_OAEP_4096_SHA512 = 13
    EC_SIGN_P256_SHA256 = 14
    EC_SIGN_P384_SHA384 = 15

  algorithm = _messages.EnumField('AlgorithmValueValuesEnum', 1)
  importJob = _messages.StringField(2)
  rsaAesWrappedKey = _messages.BytesField(3)


class ImportJob(_messages.Message):
  r"""An ImportJob can be used to create CryptoKeys and CryptoKeyVersions
  using pre-existing key material, generated outside of Cloud KMS.  When an
  ImportJob is created, Cloud KMS will generate a "wrapping key", which is a
  public/private key pair. You use the wrapping key to encrypt (also known as
  wrap) the pre-existing key material to protect it during the import process.
  The nature of the wrapping key depends on the choice of import_method. When
  the wrapping key generation is complete, the state will be set to ACTIVE and
  the public_key can be fetched. The fetched public key can then be used to
  wrap your pre-existing key material.  Once the key material is wrapped, it
  can be imported into a new CryptoKeyVersion in an existing CryptoKey by
  calling ImportCryptoKeyVersion. Multiple CryptoKeyVersions can be imported
  with a single ImportJob. Cloud KMS uses the private key portion of the
  wrapping key to unwrap the key material. Only Cloud KMS has access to the
  private key.  An ImportJob expires 3 days after it is created. Once expired,
  Cloud KMS will no longer be able to import or unwrap any key material that
  was wrapped with the ImportJob's public key.  For more information, see
  [Importing a key](https://cloud.google.com/kms/docs/importing-a-key).

  Enums:
    ImportMethodValueValuesEnum: Required and immutable. The wrapping method
      to be used for incoming key material.
    ProtectionLevelValueValuesEnum: Required and immutable. The protection
      level of the ImportJob. This must match the protection_level of the
      version_template on the CryptoKey you attempt to import into.
    StateValueValuesEnum: Output only. The current state of the ImportJob,
      indicating if it can be used.

  Fields:
    attestation: Output only. Statement that was generated and signed by the
      key creator (for example, an HSM) at key creation time. Use this
      statement to verify attributes of the key as stored on the HSM,
      independently of Google. Only present if the chosen ImportMethod is one
      with a protection level of HSM.
    createTime: Output only. The time at which this ImportJob was created.
    expireEventTime: Output only. The time this ImportJob expired. Only
      present if state is EXPIRED.
    expireTime: Output only. The time at which this ImportJob is scheduled for
      expiration and can no longer be used to import key material.
    generateTime: Output only. The time this ImportJob's key material was
      generated.
    importMethod: Required and immutable. The wrapping method to be used for
      incoming key material.
    name: Output only. The resource name for this ImportJob in the format
      `projects/*/locations/*/keyRings/*/importJobs/*`.
    protectionLevel: Required and immutable. The protection level of the
      ImportJob. This must match the protection_level of the version_template
      on the CryptoKey you attempt to import into.
    publicKey: Output only. The public key with which to wrap key material
      prior to import. Only returned if state is ACTIVE.
    state: Output only. The current state of the ImportJob, indicating if it
      can be used.
  """

  class ImportMethodValueValuesEnum(_messages.Enum):
    r"""Required and immutable. The wrapping method to be used for incoming
    key material.

    Values:
      IMPORT_METHOD_UNSPECIFIED: Not specified.
      RSA_OAEP_3072_SHA1_AES_256: This ImportMethod represents the
        CKM_RSA_AES_KEY_WRAP key wrapping scheme defined in the PKCS #11
        standard. In summary, this involves wrapping the raw key with an
        ephemeral AES key, and wrapping the ephemeral AES key with a 3072 bit
        RSA key. For more details, see [RSA AES key wrap
        mechanism](http://docs.oasis-open.org/pkcs11/pkcs11-curr/v2.40/cos01/p
        kcs11-curr-v2.40-cos01.html#_Toc408226908).
      RSA_OAEP_4096_SHA1_AES_256: This ImportMethod represents the
        CKM_RSA_AES_KEY_WRAP key wrapping scheme defined in the PKCS #11
        standard. In summary, this involves wrapping the raw key with an
        ephemeral AES key, and wrapping the ephemeral AES key with a 4096 bit
        RSA key. For more details, see [RSA AES key wrap
        mechanism](http://docs.oasis-open.org/pkcs11/pkcs11-curr/v2.40/cos01/p
        kcs11-curr-v2.40-cos01.html#_Toc408226908).
    """
    IMPORT_METHOD_UNSPECIFIED = 0
    RSA_OAEP_3072_SHA1_AES_256 = 1
    RSA_OAEP_4096_SHA1_AES_256 = 2

  class ProtectionLevelValueValuesEnum(_messages.Enum):
    r"""Required and immutable. The protection level of the ImportJob. This
    must match the protection_level of the version_template on the CryptoKey
    you attempt to import into.

    Values:
      PROTECTION_LEVEL_UNSPECIFIED: Not specified.
      SOFTWARE: Crypto operations are performed in software.
      HSM: Crypto operations are performed in a Hardware Security Module.
    """
    PROTECTION_LEVEL_UNSPECIFIED = 0
    SOFTWARE = 1
    HSM = 2

  class StateValueValuesEnum(_messages.Enum):
    r"""Output only. The current state of the ImportJob, indicating if it can
    be used.

    Values:
      IMPORT_JOB_STATE_UNSPECIFIED: Not specified.
      PENDING_GENERATION: The wrapping key for this job is still being
        generated. It may not be used. Cloud KMS will automatically mark this
        job as ACTIVE as soon as the wrapping key is generated.
      ACTIVE: This job may be used in CreateCryptoKey and
        CreateCryptoKeyVersion requests.
      EXPIRED: This job can no longer be used and may not leave this state
        once entered.
    """
    IMPORT_JOB_STATE_UNSPECIFIED = 0
    PENDING_GENERATION = 1
    ACTIVE = 2
    EXPIRED = 3

  attestation = _messages.MessageField('KeyOperationAttestation', 1)
  createTime = _messages.StringField(2)
  expireEventTime = _messages.StringField(3)
  expireTime = _messages.StringField(4)
  generateTime = _messages.StringField(5)
  importMethod = _messages.EnumField('ImportMethodValueValuesEnum', 6)
  name = _messages.StringField(7)
  protectionLevel = _messages.EnumField('ProtectionLevelValueValuesEnum', 8)
  publicKey = _messages.MessageField('WrappingPublicKey', 9)
  state = _messages.EnumField('StateValueValuesEnum', 10)


class KeyOperationAttestation(_messages.Message):
  r"""Contains an HSM-generated attestation about a key operation. For more
  information, see [Verifying attestations] (https://cloud.google.com/kms/docs
  /attest-key).

  Enums:
    FormatValueValuesEnum: Output only. The format of the attestation data.

  Fields:
    content: Output only. The attestation data provided by the HSM when the
      key operation was performed.
    format: Output only. The format of the attestation data.
  """

  class FormatValueValuesEnum(_messages.Enum):
    r"""Output only. The format of the attestation data.

    Values:
      ATTESTATION_FORMAT_UNSPECIFIED: Not specified.
      CAVIUM_V1_COMPRESSED: Cavium HSM attestation compressed with gzip. Note
        that this format is defined by Cavium and subject to change at any
        time.
      CAVIUM_V2_COMPRESSED: Cavium HSM attestation V2 compressed with gzip.
        This is a new format introduced in Cavium's version 3.2-08.
    """
    ATTESTATION_FORMAT_UNSPECIFIED = 0
    CAVIUM_V1_COMPRESSED = 1
    CAVIUM_V2_COMPRESSED = 2

  content = _messages.BytesField(1)
  format = _messages.EnumField('FormatValueValuesEnum', 2)


class KeyRing(_messages.Message):
  r"""A KeyRing is a toplevel logical grouping of CryptoKeys.

  Fields:
    createTime: Output only. The time at which this KeyRing was created.
    name: Output only. The resource name for the KeyRing in the format
      `projects/*/locations/*/keyRings/*`.
  """

  createTime = _messages.StringField(1)
  name = _messages.StringField(2)


class ListCryptoKeyVersionsResponse(_messages.Message):
  r"""Response message for KeyManagementService.ListCryptoKeyVersions.

  Fields:
    cryptoKeyVersions: The list of CryptoKeyVersions.
    nextPageToken: A token to retrieve next page of results. Pass this value
      in ListCryptoKeyVersionsRequest.page_token to retrieve the next page of
      results.
    totalSize: The total number of CryptoKeyVersions that matched the query.
  """

  cryptoKeyVersions = _messages.MessageField('CryptoKeyVersion', 1, repeated=True)
  nextPageToken = _messages.StringField(2)
  totalSize = _messages.IntegerField(3, variant=_messages.Variant.INT32)


class ListCryptoKeysResponse(_messages.Message):
  r"""Response message for KeyManagementService.ListCryptoKeys.

  Fields:
    cryptoKeys: The list of CryptoKeys.
    nextPageToken: A token to retrieve next page of results. Pass this value
      in ListCryptoKeysRequest.page_token to retrieve the next page of
      results.
    totalSize: The total number of CryptoKeys that matched the query.
  """

  cryptoKeys = _messages.MessageField('CryptoKey', 1, repeated=True)
  nextPageToken = _messages.StringField(2)
  totalSize = _messages.IntegerField(3, variant=_messages.Variant.INT32)


class ListImportJobsResponse(_messages.Message):
  r"""Response message for KeyManagementService.ListImportJobs.

  Fields:
    importJobs: The list of ImportJobs.
    nextPageToken: A token to retrieve next page of results. Pass this value
      in ListImportJobsRequest.page_token to retrieve the next page of
      results.
    totalSize: The total number of ImportJobs that matched the query.
  """

  importJobs = _messages.MessageField('ImportJob', 1, repeated=True)
  nextPageToken = _messages.StringField(2)
  totalSize = _messages.IntegerField(3, variant=_messages.Variant.INT32)


class ListKeyRingsResponse(_messages.Message):
  r"""Response message for KeyManagementService.ListKeyRings.

  Fields:
    keyRings: The list of KeyRings.
    nextPageToken: A token to retrieve next page of results. Pass this value
      in ListKeyRingsRequest.page_token to retrieve the next page of results.
    totalSize: The total number of KeyRings that matched the query.
  """

  keyRings = _messages.MessageField('KeyRing', 1, repeated=True)
  nextPageToken = _messages.StringField(2)
  totalSize = _messages.IntegerField(3, variant=_messages.Variant.INT32)


class ListLocationsResponse(_messages.Message):
  r"""The response message for Locations.ListLocations.

  Fields:
    locations: A list of locations that matches the specified filter in the
      request.
    nextPageToken: The standard List next-page token.
  """

  locations = _messages.MessageField('Location', 1, repeated=True)
  nextPageToken = _messages.StringField(2)


class Location(_messages.Message):
  r"""A resource that represents Google Cloud Platform location.

  Messages:
    LabelsValue: Cross-service attributes for the location. For example
      {"cloud.googleapis.com/region": "us-east1"}
    MetadataValue: Service-specific metadata. For example the available
      capacity at the given location.

  Fields:
    displayName: The friendly name for this location, typically a nearby city
      name. For example, "Tokyo".
    labels: Cross-service attributes for the location. For example
      {"cloud.googleapis.com/region": "us-east1"}
    locationId: The canonical id for this location. For example: `"us-east1"`.
    metadata: Service-specific metadata. For example the available capacity at
      the given location.
    name: Resource name for the location, which may vary between
      implementations. For example: `"projects/example-project/locations/us-
      east1"`
  """

  @encoding.MapUnrecognizedFields('additionalProperties')
  class LabelsValue(_messages.Message):
    r"""Cross-service attributes for the location. For example
    {"cloud.googleapis.com/region": "us-east1"}

    Messages:
      AdditionalProperty: An additional property for a LabelsValue object.

    Fields:
      additionalProperties: Additional properties of type LabelsValue
    """

    class AdditionalProperty(_messages.Message):
      r"""An additional property for a LabelsValue object.

      Fields:
        key: Name of the additional property.
        value: A string attribute.
      """

      key = _messages.StringField(1)
      value = _messages.StringField(2)

    additionalProperties = _messages.MessageField('AdditionalProperty', 1, repeated=True)

  @encoding.MapUnrecognizedFields('additionalProperties')
  class MetadataValue(_messages.Message):
    r"""Service-specific metadata. For example the available capacity at the
    given location.

    Messages:
      AdditionalProperty: An additional property for a MetadataValue object.

    Fields:
      additionalProperties: Properties of the object. Contains field @type
        with type URL.
    """

    class AdditionalProperty(_messages.Message):
      r"""An additional property for a MetadataValue object.

      Fields:
        key: Name of the additional property.
        value: A extra_types.JsonValue attribute.
      """

      key = _messages.StringField(1)
      value = _messages.MessageField('extra_types.JsonValue', 2)

    additionalProperties = _messages.MessageField('AdditionalProperty', 1, repeated=True)

  displayName = _messages.StringField(1)
  labels = _messages.MessageField('LabelsValue', 2)
  locationId = _messages.StringField(3)
  metadata = _messages.MessageField('MetadataValue', 4)
  name = _messages.StringField(5)


class LocationMetadata(_messages.Message):
  r"""Cloud KMS metadata for the given google.cloud.location.Location.

  Fields:
    hsmAvailable: Indicates whether CryptoKeys with protection_level HSM can
      be created in this location.
  """

  hsmAvailable = _messages.BooleanField(1)


class Policy(_messages.Message):
  r"""Defines an Identity and Access Management (IAM) policy. It is used to
  specify access control policies for Cloud Platform resources.   A `Policy`
  consists of a list of `bindings`. A `binding` binds a list of `members` to a
  `role`, where the members can be user accounts, Google groups, Google
  domains, and service accounts. A `role` is a named list of permissions
  defined by IAM.  **JSON Example**      {       "bindings": [         {
  "role": "roles/owner",           "members": [
  "user:mike@example.com",             "group:admins@example.com",
  "domain:google.com",             "serviceAccount:my-other-
  app@appspot.gserviceaccount.com"           ]         },         {
  "role": "roles/viewer",           "members": ["user:sean@example.com"]
  }       ]     }  **YAML Example**      bindings:     - members:       -
  user:mike@example.com       - group:admins@example.com       -
  domain:google.com       - serviceAccount:my-other-
  app@appspot.gserviceaccount.com       role: roles/owner     - members:
  - user:sean@example.com       role: roles/viewer   For a description of IAM
  and its features, see the [IAM developer's
  guide](https://cloud.google.com/iam/docs).

  Fields:
    auditConfigs: Specifies cloud audit logging configuration for this policy.
    bindings: Associates a list of `members` to a `role`. `bindings` with no
      members will result in an error.
    etag: `etag` is used for optimistic concurrency control as a way to help
      prevent simultaneous updates of a policy from overwriting each other. It
      is strongly suggested that systems make use of the `etag` in the read-
      modify-write cycle to perform policy updates in order to avoid race
      conditions: An `etag` is returned in the response to `getIamPolicy`, and
      systems are expected to put that etag in the request to `setIamPolicy`
      to ensure that their change will be applied to the same version of the
      policy.  If no `etag` is provided in the call to `setIamPolicy`, then
      the existing policy is overwritten.
    version: Specifies the format of the policy.  Valid values are 0, 1, and
      3. Requests specifying an invalid value will be rejected.  Policies with
      any conditional bindings must specify version 3. Policies without any
      conditional bindings may specify any valid value or leave the field
      unset.
  """

  auditConfigs = _messages.MessageField('AuditConfig', 1, repeated=True)
  bindings = _messages.MessageField('Binding', 2, repeated=True)
  etag = _messages.BytesField(3)
  version = _messages.IntegerField(4, variant=_messages.Variant.INT32)


class PublicKey(_messages.Message):
  r"""The public key for a given CryptoKeyVersion. Obtained via GetPublicKey.

  Enums:
    AlgorithmValueValuesEnum: The Algorithm associated with this key.

  Fields:
    algorithm: The Algorithm associated with this key.
    pem: The public key, encoded in PEM format. For more information, see the
      [RFC 7468](https://tools.ietf.org/html/rfc7468) sections for [General
      Considerations](https://tools.ietf.org/html/rfc7468#section-2) and
      [Textual Encoding of Subject Public Key Info]
      (https://tools.ietf.org/html/rfc7468#section-13).
  """

  class AlgorithmValueValuesEnum(_messages.Enum):
    r"""The Algorithm associated with this key.

    Values:
      CRYPTO_KEY_VERSION_ALGORITHM_UNSPECIFIED: Not specified.
      GOOGLE_SYMMETRIC_ENCRYPTION: Creates symmetric encryption keys.
      RSA_SIGN_PSS_2048_SHA256: RSASSA-PSS 2048 bit key with a SHA256 digest.
      RSA_SIGN_PSS_3072_SHA256: RSASSA-PSS 3072 bit key with a SHA256 digest.
      RSA_SIGN_PSS_4096_SHA256: RSASSA-PSS 4096 bit key with a SHA256 digest.
      RSA_SIGN_PSS_4096_SHA512: RSASSA-PSS 4096 bit key with a SHA512 digest.
      RSA_SIGN_PKCS1_2048_SHA256: RSASSA-PKCS1-v1_5 with a 2048 bit key and a
        SHA256 digest.
      RSA_SIGN_PKCS1_3072_SHA256: RSASSA-PKCS1-v1_5 with a 3072 bit key and a
        SHA256 digest.
      RSA_SIGN_PKCS1_4096_SHA256: RSASSA-PKCS1-v1_5 with a 4096 bit key and a
        SHA256 digest.
      RSA_SIGN_PKCS1_4096_SHA512: RSASSA-PKCS1-v1_5 with a 4096 bit key and a
        SHA512 digest.
      RSA_DECRYPT_OAEP_2048_SHA256: RSAES-OAEP 2048 bit key with a SHA256
        digest.
      RSA_DECRYPT_OAEP_3072_SHA256: RSAES-OAEP 3072 bit key with a SHA256
        digest.
      RSA_DECRYPT_OAEP_4096_SHA256: RSAES-OAEP 4096 bit key with a SHA256
        digest.
      RSA_DECRYPT_OAEP_4096_SHA512: RSAES-OAEP 4096 bit key with a SHA512
        digest.
      EC_SIGN_P256_SHA256: ECDSA on the NIST P-256 curve with a SHA256 digest.
      EC_SIGN_P384_SHA384: ECDSA on the NIST P-384 curve with a SHA384 digest.
    """
    CRYPTO_KEY_VERSION_ALGORITHM_UNSPECIFIED = 0
    GOOGLE_SYMMETRIC_ENCRYPTION = 1
    RSA_SIGN_PSS_2048_SHA256 = 2
    RSA_SIGN_PSS_3072_SHA256 = 3
    RSA_SIGN_PSS_4096_SHA256 = 4
    RSA_SIGN_PSS_4096_SHA512 = 5
    RSA_SIGN_PKCS1_2048_SHA256 = 6
    RSA_SIGN_PKCS1_3072_SHA256 = 7
    RSA_SIGN_PKCS1_4096_SHA256 = 8
    RSA_SIGN_PKCS1_4096_SHA512 = 9
    RSA_DECRYPT_OAEP_2048_SHA256 = 10
    RSA_DECRYPT_OAEP_3072_SHA256 = 11
    RSA_DECRYPT_OAEP_4096_SHA256 = 12
    RSA_DECRYPT_OAEP_4096_SHA512 = 13
    EC_SIGN_P256_SHA256 = 14
    EC_SIGN_P384_SHA384 = 15

  algorithm = _messages.EnumField('AlgorithmValueValuesEnum', 1)
  pem = _messages.StringField(2)


class RestoreCryptoKeyVersionRequest(_messages.Message):
  r"""Request message for KeyManagementService.RestoreCryptoKeyVersion."""


class SetIamPolicyRequest(_messages.Message):
  r"""Request message for `SetIamPolicy` method.

  Fields:
    policy: REQUIRED: The complete policy to be applied to the `resource`. The
      size of the policy is limited to a few 10s of KB. An empty policy is a
      valid policy but certain Cloud Platform services (such as Projects)
      might reject them.
    updateMask: OPTIONAL: A FieldMask specifying which fields of the policy to
      modify. Only the fields in the mask will be modified. If no mask is
      provided, the following default mask is used: paths: "bindings, etag"
      This field is only used by Cloud IAM.
  """

  policy = _messages.MessageField('Policy', 1)
  updateMask = _messages.StringField(2)


class StandardQueryParameters(_messages.Message):
  r"""Query parameters accepted by all methods.

  Enums:
    FXgafvValueValuesEnum: V1 error format.
    AltValueValuesEnum: Data format for response.

  Fields:
    f__xgafv: V1 error format.
    access_token: OAuth access token.
    alt: Data format for response.
    callback: JSONP
    fields: Selector specifying which fields to include in a partial response.
    key: API key. Your API key identifies your project and provides you with
      API access, quota, and reports. Required unless you provide an OAuth 2.0
      token.
    oauth_token: OAuth 2.0 token for the current user.
    prettyPrint: Returns response with indentations and line breaks.
    quotaUser: Available to use for quota purposes for server-side
      applications. Can be any arbitrary string assigned to a user, but should
      not exceed 40 characters.
    trace: A tracing token of the form "token:<tokenid>" to include in api
      requests.
    uploadType: Legacy upload protocol for media (e.g. "media", "multipart").
    upload_protocol: Upload protocol for media (e.g. "raw", "multipart").
  """

  class AltValueValuesEnum(_messages.Enum):
    r"""Data format for response.

    Values:
      json: Responses with Content-Type of application/json
      media: Media download with context-dependent Content-Type
      proto: Responses with Content-Type of application/x-protobuf
    """
    json = 0
    media = 1
    proto = 2

  class FXgafvValueValuesEnum(_messages.Enum):
    r"""V1 error format.

    Values:
      _1: v1 error format
      _2: v2 error format
    """
    _1 = 0
    _2 = 1

  f__xgafv = _messages.EnumField('FXgafvValueValuesEnum', 1)
  access_token = _messages.StringField(2)
  alt = _messages.EnumField('AltValueValuesEnum', 3, default=u'json')
  callback = _messages.StringField(4)
  fields = _messages.StringField(5)
  key = _messages.StringField(6)
  oauth_token = _messages.StringField(7)
  prettyPrint = _messages.BooleanField(8, default=True)
  quotaUser = _messages.StringField(9)
  trace = _messages.StringField(10)
  uploadType = _messages.StringField(11)
  upload_protocol = _messages.StringField(12)


class TestIamPermissionsRequest(_messages.Message):
  r"""Request message for `TestIamPermissions` method.

  Fields:
    permissions: The set of permissions to check for the `resource`.
      Permissions with wildcards (such as '*' or 'storage.*') are not allowed.
      For more information see [IAM
      Overview](https://cloud.google.com/iam/docs/overview#permissions).
  """

  permissions = _messages.StringField(1, repeated=True)


class TestIamPermissionsResponse(_messages.Message):
  r"""Response message for `TestIamPermissions` method.

  Fields:
    permissions: A subset of `TestPermissionsRequest.permissions` that the
      caller is allowed.
  """

  permissions = _messages.StringField(1, repeated=True)


class UpdateCryptoKeyPrimaryVersionRequest(_messages.Message):
  r"""Request message for KeyManagementService.UpdateCryptoKeyPrimaryVersion.

  Fields:
    cryptoKeyVersionId: The id of the child CryptoKeyVersion to use as
      primary.
  """

  cryptoKeyVersionId = _messages.StringField(1)


class WrappingPublicKey(_messages.Message):
  r"""The public key component of the wrapping key. For details of the type of
  key this public key corresponds to, see the ImportMethod.

  Fields:
    pem: The public key, encoded in PEM format. For more information, see the
      [RFC 7468](https://tools.ietf.org/html/rfc7468) sections for [General
      Considerations](https://tools.ietf.org/html/rfc7468#section-2) and
      [Textual Encoding of Subject Public Key Info]
      (https://tools.ietf.org/html/rfc7468#section-13).
  """

  pem = _messages.StringField(1)


encoding.AddCustomJsonFieldMapping(
    StandardQueryParameters, 'f__xgafv', '$.xgafv')
encoding.AddCustomJsonEnumMapping(
    StandardQueryParameters.FXgafvValueValuesEnum, '_1', '1')
encoding.AddCustomJsonEnumMapping(
    StandardQueryParameters.FXgafvValueValuesEnum, '_2', '2')
