"""Generated client library for securitycenter version v1beta1."""
# NOTE: This file is autogenerated and should not be edited by hand.
from apitools.base.py import base_api
from googlecloudsdk.third_party.apis.securitycenter.v1beta1 import securitycenter_v1beta1_messages as messages


class SecuritycenterV1beta1(base_api.BaseApiClient):
  """Generated client library for service securitycenter version v1beta1."""

  MESSAGES_MODULE = messages
  BASE_URL = u'https://securitycenter.googleapis.com/'

  _PACKAGE = u'securitycenter'
  _SCOPES = [u'https://www.googleapis.com/auth/cloud-platform']
  _VERSION = u'v1beta1'
  _CLIENT_ID = '1042881264118.apps.googleusercontent.com'
  _CLIENT_SECRET = 'x_Tw5K8nnjoRAqULM9PFAC2b'
  _USER_AGENT = 'x_Tw5K8nnjoRAqULM9PFAC2b'
  _CLIENT_CLASS_NAME = u'SecuritycenterV1beta1'
  _URL_VERSION = u'v1beta1'
  _API_KEY = None

  def __init__(self, url='', credentials=None,
               get_credentials=True, http=None, model=None,
               log_request=False, log_response=False,
               credentials_args=None, default_global_params=None,
               additional_http_headers=None, response_encoding=None):
    """Create a new securitycenter handle."""
    url = url or self.BASE_URL
    super(SecuritycenterV1beta1, self).__init__(
        url, credentials=credentials,
        get_credentials=get_credentials, http=http, model=model,
        log_request=log_request, log_response=log_response,
        credentials_args=credentials_args,
        default_global_params=default_global_params,
        additional_http_headers=additional_http_headers,
        response_encoding=response_encoding)
    self.organizations_assets = self.OrganizationsAssetsService(self)
    self.organizations_operations = self.OrganizationsOperationsService(self)
    self.organizations_sources_findings = self.OrganizationsSourcesFindingsService(self)
    self.organizations_sources = self.OrganizationsSourcesService(self)
    self.organizations = self.OrganizationsService(self)

  class OrganizationsAssetsService(base_api.BaseApiService):
    """Service class for the organizations_assets resource."""

    _NAME = u'organizations_assets'

    def __init__(self, client):
      super(SecuritycenterV1beta1.OrganizationsAssetsService, self).__init__(client)
      self._upload_configs = {
          }

    def Group(self, request, global_params=None):
      r"""Filters an organization's assets and  groups them by their specified.
properties.

      Args:
        request: (SecuritycenterOrganizationsAssetsGroupRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (GroupAssetsResponse) The response message.
      """
      config = self.GetMethodConfig('Group')
      return self._RunMethod(
          config, request, global_params=global_params)

    Group.method_config = lambda: base_api.ApiMethodInfo(
        flat_path=u'v1beta1/organizations/{organizationsId}/assets:group',
        http_method=u'POST',
        method_id=u'securitycenter.organizations.assets.group',
        ordered_params=[u'parent'],
        path_params=[u'parent'],
        query_params=[],
        relative_path=u'v1beta1/{+parent}/assets:group',
        request_field=u'groupAssetsRequest',
        request_type_name=u'SecuritycenterOrganizationsAssetsGroupRequest',
        response_type_name=u'GroupAssetsResponse',
        supports_download=False,
    )

    def List(self, request, global_params=None):
      r"""Lists an organization's assets.

      Args:
        request: (SecuritycenterOrganizationsAssetsListRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (ListAssetsResponse) The response message.
      """
      config = self.GetMethodConfig('List')
      return self._RunMethod(
          config, request, global_params=global_params)

    List.method_config = lambda: base_api.ApiMethodInfo(
        flat_path=u'v1beta1/organizations/{organizationsId}/assets',
        http_method=u'GET',
        method_id=u'securitycenter.organizations.assets.list',
        ordered_params=[u'parent'],
        path_params=[u'parent'],
        query_params=[u'compareDuration', u'fieldMask', u'filter', u'orderBy', u'pageSize', u'pageToken', u'readTime'],
        relative_path=u'v1beta1/{+parent}/assets',
        request_field='',
        request_type_name=u'SecuritycenterOrganizationsAssetsListRequest',
        response_type_name=u'ListAssetsResponse',
        supports_download=False,
    )

    def RunDiscovery(self, request, global_params=None):
      r"""Runs asset discovery. The discovery is tracked with a long-running.
operation.

This API can only be called with limited frequency for an organization. If
it is called too frequently the caller will receive a TOO_MANY_REQUESTS
error.

      Args:
        request: (SecuritycenterOrganizationsAssetsRunDiscoveryRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (Operation) The response message.
      """
      config = self.GetMethodConfig('RunDiscovery')
      return self._RunMethod(
          config, request, global_params=global_params)

    RunDiscovery.method_config = lambda: base_api.ApiMethodInfo(
        flat_path=u'v1beta1/organizations/{organizationsId}/assets:runDiscovery',
        http_method=u'POST',
        method_id=u'securitycenter.organizations.assets.runDiscovery',
        ordered_params=[u'parent'],
        path_params=[u'parent'],
        query_params=[],
        relative_path=u'v1beta1/{+parent}/assets:runDiscovery',
        request_field=u'runAssetDiscoveryRequest',
        request_type_name=u'SecuritycenterOrganizationsAssetsRunDiscoveryRequest',
        response_type_name=u'Operation',
        supports_download=False,
    )

    def UpdateSecurityMarks(self, request, global_params=None):
      r"""Updates security marks.

      Args:
        request: (SecuritycenterOrganizationsAssetsUpdateSecurityMarksRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (SecurityMarks) The response message.
      """
      config = self.GetMethodConfig('UpdateSecurityMarks')
      return self._RunMethod(
          config, request, global_params=global_params)

    UpdateSecurityMarks.method_config = lambda: base_api.ApiMethodInfo(
        flat_path=u'v1beta1/organizations/{organizationsId}/assets/{assetsId}/securityMarks',
        http_method=u'PATCH',
        method_id=u'securitycenter.organizations.assets.updateSecurityMarks',
        ordered_params=[u'name'],
        path_params=[u'name'],
        query_params=[u'startTime', u'updateMask'],
        relative_path=u'v1beta1/{+name}',
        request_field=u'securityMarks',
        request_type_name=u'SecuritycenterOrganizationsAssetsUpdateSecurityMarksRequest',
        response_type_name=u'SecurityMarks',
        supports_download=False,
    )

  class OrganizationsOperationsService(base_api.BaseApiService):
    """Service class for the organizations_operations resource."""

    _NAME = u'organizations_operations'

    def __init__(self, client):
      super(SecuritycenterV1beta1.OrganizationsOperationsService, self).__init__(client)
      self._upload_configs = {
          }

    def Cancel(self, request, global_params=None):
      r"""Starts asynchronous cancellation on a long-running operation.  The server.
makes a best effort to cancel the operation, but success is not
guaranteed.  If the server doesn't support this method, it returns
`google.rpc.Code.UNIMPLEMENTED`.  Clients can use
Operations.GetOperation or
other methods to check whether the cancellation succeeded or whether the
operation completed despite cancellation. On successful cancellation,
the operation is not deleted; instead, it becomes an operation with
an Operation.error value with a google.rpc.Status.code of 1,
corresponding to `Code.CANCELLED`.

      Args:
        request: (SecuritycenterOrganizationsOperationsCancelRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (Empty) The response message.
      """
      config = self.GetMethodConfig('Cancel')
      return self._RunMethod(
          config, request, global_params=global_params)

    Cancel.method_config = lambda: base_api.ApiMethodInfo(
        flat_path=u'v1beta1/organizations/{organizationsId}/operations/{operationsId}:cancel',
        http_method=u'POST',
        method_id=u'securitycenter.organizations.operations.cancel',
        ordered_params=[u'name'],
        path_params=[u'name'],
        query_params=[],
        relative_path=u'v1beta1/{+name}:cancel',
        request_field=u'cancelOperationRequest',
        request_type_name=u'SecuritycenterOrganizationsOperationsCancelRequest',
        response_type_name=u'Empty',
        supports_download=False,
    )

    def Delete(self, request, global_params=None):
      r"""Deletes a long-running operation. This method indicates that the client is.
no longer interested in the operation result. It does not cancel the
operation. If the server doesn't support this method, it returns
`google.rpc.Code.UNIMPLEMENTED`.

      Args:
        request: (SecuritycenterOrganizationsOperationsDeleteRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (Empty) The response message.
      """
      config = self.GetMethodConfig('Delete')
      return self._RunMethod(
          config, request, global_params=global_params)

    Delete.method_config = lambda: base_api.ApiMethodInfo(
        flat_path=u'v1beta1/organizations/{organizationsId}/operations/{operationsId}',
        http_method=u'DELETE',
        method_id=u'securitycenter.organizations.operations.delete',
        ordered_params=[u'name'],
        path_params=[u'name'],
        query_params=[],
        relative_path=u'v1beta1/{+name}',
        request_field='',
        request_type_name=u'SecuritycenterOrganizationsOperationsDeleteRequest',
        response_type_name=u'Empty',
        supports_download=False,
    )

    def Get(self, request, global_params=None):
      r"""Gets the latest state of a long-running operation.  Clients can use this.
method to poll the operation result at intervals as recommended by the API
service.

      Args:
        request: (SecuritycenterOrganizationsOperationsGetRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (Operation) The response message.
      """
      config = self.GetMethodConfig('Get')
      return self._RunMethod(
          config, request, global_params=global_params)

    Get.method_config = lambda: base_api.ApiMethodInfo(
        flat_path=u'v1beta1/organizations/{organizationsId}/operations/{operationsId}',
        http_method=u'GET',
        method_id=u'securitycenter.organizations.operations.get',
        ordered_params=[u'name'],
        path_params=[u'name'],
        query_params=[],
        relative_path=u'v1beta1/{+name}',
        request_field='',
        request_type_name=u'SecuritycenterOrganizationsOperationsGetRequest',
        response_type_name=u'Operation',
        supports_download=False,
    )

    def List(self, request, global_params=None):
      r"""Lists operations that match the specified filter in the request. If the.
server doesn't support this method, it returns `UNIMPLEMENTED`.

NOTE: the `name` binding allows API services to override the binding
to use different resource name schemes, such as `users/*/operations`. To
override the binding, API services can add a binding such as
`"/v1/{name=users/*}/operations"` to their service configuration.
For backwards compatibility, the default name includes the operations
collection id, however overriding users must ensure the name binding
is the parent resource, without the operations collection id.

      Args:
        request: (SecuritycenterOrganizationsOperationsListRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (ListOperationsResponse) The response message.
      """
      config = self.GetMethodConfig('List')
      return self._RunMethod(
          config, request, global_params=global_params)

    List.method_config = lambda: base_api.ApiMethodInfo(
        flat_path=u'v1beta1/organizations/{organizationsId}/operations',
        http_method=u'GET',
        method_id=u'securitycenter.organizations.operations.list',
        ordered_params=[u'name'],
        path_params=[u'name'],
        query_params=[u'filter', u'pageSize', u'pageToken'],
        relative_path=u'v1beta1/{+name}',
        request_field='',
        request_type_name=u'SecuritycenterOrganizationsOperationsListRequest',
        response_type_name=u'ListOperationsResponse',
        supports_download=False,
    )

  class OrganizationsSourcesFindingsService(base_api.BaseApiService):
    """Service class for the organizations_sources_findings resource."""

    _NAME = u'organizations_sources_findings'

    def __init__(self, client):
      super(SecuritycenterV1beta1.OrganizationsSourcesFindingsService, self).__init__(client)
      self._upload_configs = {
          }

    def Create(self, request, global_params=None):
      r"""Creates a finding. The corresponding source must exist for finding creation.
to succeed.

      Args:
        request: (SecuritycenterOrganizationsSourcesFindingsCreateRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (Finding) The response message.
      """
      config = self.GetMethodConfig('Create')
      return self._RunMethod(
          config, request, global_params=global_params)

    Create.method_config = lambda: base_api.ApiMethodInfo(
        flat_path=u'v1beta1/organizations/{organizationsId}/sources/{sourcesId}/findings',
        http_method=u'POST',
        method_id=u'securitycenter.organizations.sources.findings.create',
        ordered_params=[u'parent'],
        path_params=[u'parent'],
        query_params=[u'findingId'],
        relative_path=u'v1beta1/{+parent}/findings',
        request_field=u'finding',
        request_type_name=u'SecuritycenterOrganizationsSourcesFindingsCreateRequest',
        response_type_name=u'Finding',
        supports_download=False,
    )

    def Group(self, request, global_params=None):
      r"""Filters an organization or source's findings and  groups them by their.
specified properties.

To group across all sources provide a `-` as the source id.
Example: /v1beta1/organizations/123/sources/-/findings

      Args:
        request: (SecuritycenterOrganizationsSourcesFindingsGroupRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (GroupFindingsResponse) The response message.
      """
      config = self.GetMethodConfig('Group')
      return self._RunMethod(
          config, request, global_params=global_params)

    Group.method_config = lambda: base_api.ApiMethodInfo(
        flat_path=u'v1beta1/organizations/{organizationsId}/sources/{sourcesId}/findings:group',
        http_method=u'POST',
        method_id=u'securitycenter.organizations.sources.findings.group',
        ordered_params=[u'parent'],
        path_params=[u'parent'],
        query_params=[],
        relative_path=u'v1beta1/{+parent}/findings:group',
        request_field=u'groupFindingsRequest',
        request_type_name=u'SecuritycenterOrganizationsSourcesFindingsGroupRequest',
        response_type_name=u'GroupFindingsResponse',
        supports_download=False,
    )

    def List(self, request, global_params=None):
      r"""Lists an organization or source's findings.

To list across all sources provide a `-` as the source id.
Example: /v1beta1/organizations/123/sources/-/findings

      Args:
        request: (SecuritycenterOrganizationsSourcesFindingsListRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (ListFindingsResponse) The response message.
      """
      config = self.GetMethodConfig('List')
      return self._RunMethod(
          config, request, global_params=global_params)

    List.method_config = lambda: base_api.ApiMethodInfo(
        flat_path=u'v1beta1/organizations/{organizationsId}/sources/{sourcesId}/findings',
        http_method=u'GET',
        method_id=u'securitycenter.organizations.sources.findings.list',
        ordered_params=[u'parent'],
        path_params=[u'parent'],
        query_params=[u'fieldMask', u'filter', u'orderBy', u'pageSize', u'pageToken', u'readTime'],
        relative_path=u'v1beta1/{+parent}/findings',
        request_field='',
        request_type_name=u'SecuritycenterOrganizationsSourcesFindingsListRequest',
        response_type_name=u'ListFindingsResponse',
        supports_download=False,
    )

    def Patch(self, request, global_params=None):
      r"""Creates or updates a finding. The corresponding source must exist for a.
finding creation to succeed.

      Args:
        request: (SecuritycenterOrganizationsSourcesFindingsPatchRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (Finding) The response message.
      """
      config = self.GetMethodConfig('Patch')
      return self._RunMethod(
          config, request, global_params=global_params)

    Patch.method_config = lambda: base_api.ApiMethodInfo(
        flat_path=u'v1beta1/organizations/{organizationsId}/sources/{sourcesId}/findings/{findingsId}',
        http_method=u'PATCH',
        method_id=u'securitycenter.organizations.sources.findings.patch',
        ordered_params=[u'name'],
        path_params=[u'name'],
        query_params=[u'updateMask'],
        relative_path=u'v1beta1/{+name}',
        request_field=u'finding',
        request_type_name=u'SecuritycenterOrganizationsSourcesFindingsPatchRequest',
        response_type_name=u'Finding',
        supports_download=False,
    )

    def SetState(self, request, global_params=None):
      r"""Updates the state of a finding.

      Args:
        request: (SecuritycenterOrganizationsSourcesFindingsSetStateRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (Finding) The response message.
      """
      config = self.GetMethodConfig('SetState')
      return self._RunMethod(
          config, request, global_params=global_params)

    SetState.method_config = lambda: base_api.ApiMethodInfo(
        flat_path=u'v1beta1/organizations/{organizationsId}/sources/{sourcesId}/findings/{findingsId}:setState',
        http_method=u'POST',
        method_id=u'securitycenter.organizations.sources.findings.setState',
        ordered_params=[u'name'],
        path_params=[u'name'],
        query_params=[],
        relative_path=u'v1beta1/{+name}:setState',
        request_field=u'setFindingStateRequest',
        request_type_name=u'SecuritycenterOrganizationsSourcesFindingsSetStateRequest',
        response_type_name=u'Finding',
        supports_download=False,
    )

    def UpdateSecurityMarks(self, request, global_params=None):
      r"""Updates security marks.

      Args:
        request: (SecuritycenterOrganizationsSourcesFindingsUpdateSecurityMarksRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (SecurityMarks) The response message.
      """
      config = self.GetMethodConfig('UpdateSecurityMarks')
      return self._RunMethod(
          config, request, global_params=global_params)

    UpdateSecurityMarks.method_config = lambda: base_api.ApiMethodInfo(
        flat_path=u'v1beta1/organizations/{organizationsId}/sources/{sourcesId}/findings/{findingsId}/securityMarks',
        http_method=u'PATCH',
        method_id=u'securitycenter.organizations.sources.findings.updateSecurityMarks',
        ordered_params=[u'name'],
        path_params=[u'name'],
        query_params=[u'startTime', u'updateMask'],
        relative_path=u'v1beta1/{+name}',
        request_field=u'securityMarks',
        request_type_name=u'SecuritycenterOrganizationsSourcesFindingsUpdateSecurityMarksRequest',
        response_type_name=u'SecurityMarks',
        supports_download=False,
    )

  class OrganizationsSourcesService(base_api.BaseApiService):
    """Service class for the organizations_sources resource."""

    _NAME = u'organizations_sources'

    def __init__(self, client):
      super(SecuritycenterV1beta1.OrganizationsSourcesService, self).__init__(client)
      self._upload_configs = {
          }

    def Create(self, request, global_params=None):
      r"""Creates a source.

      Args:
        request: (SecuritycenterOrganizationsSourcesCreateRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (Source) The response message.
      """
      config = self.GetMethodConfig('Create')
      return self._RunMethod(
          config, request, global_params=global_params)

    Create.method_config = lambda: base_api.ApiMethodInfo(
        flat_path=u'v1beta1/organizations/{organizationsId}/sources',
        http_method=u'POST',
        method_id=u'securitycenter.organizations.sources.create',
        ordered_params=[u'parent'],
        path_params=[u'parent'],
        query_params=[],
        relative_path=u'v1beta1/{+parent}/sources',
        request_field=u'source',
        request_type_name=u'SecuritycenterOrganizationsSourcesCreateRequest',
        response_type_name=u'Source',
        supports_download=False,
    )

    def Get(self, request, global_params=None):
      r"""Gets a source.

      Args:
        request: (SecuritycenterOrganizationsSourcesGetRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (Source) The response message.
      """
      config = self.GetMethodConfig('Get')
      return self._RunMethod(
          config, request, global_params=global_params)

    Get.method_config = lambda: base_api.ApiMethodInfo(
        flat_path=u'v1beta1/organizations/{organizationsId}/sources/{sourcesId}',
        http_method=u'GET',
        method_id=u'securitycenter.organizations.sources.get',
        ordered_params=[u'name'],
        path_params=[u'name'],
        query_params=[],
        relative_path=u'v1beta1/{+name}',
        request_field='',
        request_type_name=u'SecuritycenterOrganizationsSourcesGetRequest',
        response_type_name=u'Source',
        supports_download=False,
    )

    def GetIamPolicy(self, request, global_params=None):
      r"""Gets the access control policy on the specified Source.

      Args:
        request: (SecuritycenterOrganizationsSourcesGetIamPolicyRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (Policy) The response message.
      """
      config = self.GetMethodConfig('GetIamPolicy')
      return self._RunMethod(
          config, request, global_params=global_params)

    GetIamPolicy.method_config = lambda: base_api.ApiMethodInfo(
        flat_path=u'v1beta1/organizations/{organizationsId}/sources/{sourcesId}:getIamPolicy',
        http_method=u'POST',
        method_id=u'securitycenter.organizations.sources.getIamPolicy',
        ordered_params=[u'resource'],
        path_params=[u'resource'],
        query_params=[],
        relative_path=u'v1beta1/{+resource}:getIamPolicy',
        request_field=u'getIamPolicyRequest',
        request_type_name=u'SecuritycenterOrganizationsSourcesGetIamPolicyRequest',
        response_type_name=u'Policy',
        supports_download=False,
    )

    def List(self, request, global_params=None):
      r"""Lists all sources belonging to an organization.

      Args:
        request: (SecuritycenterOrganizationsSourcesListRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (ListSourcesResponse) The response message.
      """
      config = self.GetMethodConfig('List')
      return self._RunMethod(
          config, request, global_params=global_params)

    List.method_config = lambda: base_api.ApiMethodInfo(
        flat_path=u'v1beta1/organizations/{organizationsId}/sources',
        http_method=u'GET',
        method_id=u'securitycenter.organizations.sources.list',
        ordered_params=[u'parent'],
        path_params=[u'parent'],
        query_params=[u'pageSize', u'pageToken'],
        relative_path=u'v1beta1/{+parent}/sources',
        request_field='',
        request_type_name=u'SecuritycenterOrganizationsSourcesListRequest',
        response_type_name=u'ListSourcesResponse',
        supports_download=False,
    )

    def Patch(self, request, global_params=None):
      r"""Updates a source.

      Args:
        request: (SecuritycenterOrganizationsSourcesPatchRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (Source) The response message.
      """
      config = self.GetMethodConfig('Patch')
      return self._RunMethod(
          config, request, global_params=global_params)

    Patch.method_config = lambda: base_api.ApiMethodInfo(
        flat_path=u'v1beta1/organizations/{organizationsId}/sources/{sourcesId}',
        http_method=u'PATCH',
        method_id=u'securitycenter.organizations.sources.patch',
        ordered_params=[u'name'],
        path_params=[u'name'],
        query_params=[u'updateMask'],
        relative_path=u'v1beta1/{+name}',
        request_field=u'source',
        request_type_name=u'SecuritycenterOrganizationsSourcesPatchRequest',
        response_type_name=u'Source',
        supports_download=False,
    )

    def SetIamPolicy(self, request, global_params=None):
      r"""Sets the access control policy on the specified Source.

      Args:
        request: (SecuritycenterOrganizationsSourcesSetIamPolicyRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (Policy) The response message.
      """
      config = self.GetMethodConfig('SetIamPolicy')
      return self._RunMethod(
          config, request, global_params=global_params)

    SetIamPolicy.method_config = lambda: base_api.ApiMethodInfo(
        flat_path=u'v1beta1/organizations/{organizationsId}/sources/{sourcesId}:setIamPolicy',
        http_method=u'POST',
        method_id=u'securitycenter.organizations.sources.setIamPolicy',
        ordered_params=[u'resource'],
        path_params=[u'resource'],
        query_params=[],
        relative_path=u'v1beta1/{+resource}:setIamPolicy',
        request_field=u'setIamPolicyRequest',
        request_type_name=u'SecuritycenterOrganizationsSourcesSetIamPolicyRequest',
        response_type_name=u'Policy',
        supports_download=False,
    )

    def TestIamPermissions(self, request, global_params=None):
      r"""Returns the permissions that a caller has on the specified source.

      Args:
        request: (SecuritycenterOrganizationsSourcesTestIamPermissionsRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (TestIamPermissionsResponse) The response message.
      """
      config = self.GetMethodConfig('TestIamPermissions')
      return self._RunMethod(
          config, request, global_params=global_params)

    TestIamPermissions.method_config = lambda: base_api.ApiMethodInfo(
        flat_path=u'v1beta1/organizations/{organizationsId}/sources/{sourcesId}:testIamPermissions',
        http_method=u'POST',
        method_id=u'securitycenter.organizations.sources.testIamPermissions',
        ordered_params=[u'resource'],
        path_params=[u'resource'],
        query_params=[],
        relative_path=u'v1beta1/{+resource}:testIamPermissions',
        request_field=u'testIamPermissionsRequest',
        request_type_name=u'SecuritycenterOrganizationsSourcesTestIamPermissionsRequest',
        response_type_name=u'TestIamPermissionsResponse',
        supports_download=False,
    )

  class OrganizationsService(base_api.BaseApiService):
    """Service class for the organizations resource."""

    _NAME = u'organizations'

    def __init__(self, client):
      super(SecuritycenterV1beta1.OrganizationsService, self).__init__(client)
      self._upload_configs = {
          }

    def GetOrganizationSettings(self, request, global_params=None):
      r"""Gets the settings for an organization.

      Args:
        request: (SecuritycenterOrganizationsGetOrganizationSettingsRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (OrganizationSettings) The response message.
      """
      config = self.GetMethodConfig('GetOrganizationSettings')
      return self._RunMethod(
          config, request, global_params=global_params)

    GetOrganizationSettings.method_config = lambda: base_api.ApiMethodInfo(
        flat_path=u'v1beta1/organizations/{organizationsId}/organizationSettings',
        http_method=u'GET',
        method_id=u'securitycenter.organizations.getOrganizationSettings',
        ordered_params=[u'name'],
        path_params=[u'name'],
        query_params=[],
        relative_path=u'v1beta1/{+name}',
        request_field='',
        request_type_name=u'SecuritycenterOrganizationsGetOrganizationSettingsRequest',
        response_type_name=u'OrganizationSettings',
        supports_download=False,
    )

    def UpdateOrganizationSettings(self, request, global_params=None):
      r"""Updates an organization's settings.

      Args:
        request: (SecuritycenterOrganizationsUpdateOrganizationSettingsRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (OrganizationSettings) The response message.
      """
      config = self.GetMethodConfig('UpdateOrganizationSettings')
      return self._RunMethod(
          config, request, global_params=global_params)

    UpdateOrganizationSettings.method_config = lambda: base_api.ApiMethodInfo(
        flat_path=u'v1beta1/organizations/{organizationsId}/organizationSettings',
        http_method=u'PATCH',
        method_id=u'securitycenter.organizations.updateOrganizationSettings',
        ordered_params=[u'name'],
        path_params=[u'name'],
        query_params=[u'updateMask'],
        relative_path=u'v1beta1/{+name}',
        request_field=u'organizationSettings',
        request_type_name=u'SecuritycenterOrganizationsUpdateOrganizationSettingsRequest',
        response_type_name=u'OrganizationSettings',
        supports_download=False,
    )
