package zio

import (
	"bytes"
	"runtime"
	"strings"
	"testing"

	"github.com/brimdata/zed"
	"github.com/brimdata/zed/zio/zsonio"
)

func TestPeeker(t *testing.T) {
	const input = `
{key:"key1",value:"value1"}
{key:"key2",value:"value2"}
{key:"key3",value:"value3"}
{key:"key4",value:"value4"}
{key:"key5",value:"value5"}
{key:"key6",value:"value6"}
`
	stream := zsonio.NewReader(zed.NewContext(), strings.NewReader(input))
	peeker := NewPeeker(stream)
	defer runtime.KeepAlive(peeker)
	rec1, err := peeker.Peek()
	if err != nil {
		t.Error(err)
	}
	arena := zed.NewArena()
	defer arena.Unref()
	rec1 = rec1.Copy(arena).Ptr()
	rec2, err := peeker.Peek()
	if err != nil {
		t.Error(err)
	}
	if !bytes.Equal(rec1.Bytes(), rec2.Bytes()) {
		t.Error("rec1 != rec2")
	}
	rec3, err := peeker.Read()
	if err != nil {
		t.Error(err)
	}
	rec3 = rec3.Copy(arena).Ptr()
	if !bytes.Equal(rec1.Bytes(), rec3.Bytes()) {
		t.Error("rec1 != rec3")
	}
	rec4, err := peeker.Peek()
	if err != nil {
		t.Error(err)
	}
	rec4 = rec4.Copy(arena).Ptr()
	if bytes.Equal(rec3.Bytes(), rec4.Bytes()) {
		t.Error("rec3 == rec4")
	}
	rec5, err := peeker.Read()
	if err != nil {
		t.Error(err)
	}
	if !bytes.Equal(rec4.Bytes(), rec5.Bytes()) {
		t.Error("rec4 != rec5")
	}
}
