package style

import "github.com/charmbracelet/lipgloss"

const (
	black     = lipgloss.Color("#000000")
	blue      = lipgloss.Color("6")
	greenblue = lipgloss.Color("#00A095")
	pink      = lipgloss.Color("#E760FC")
	darkred   = lipgloss.Color("#FF0000")
	darkgreen = lipgloss.Color("#00FF00")
	grey      = lipgloss.Color("#737373")
	red       = lipgloss.Color("#FF5353")
	yellow    = lipgloss.Color("#DBBD70")
)

var (
	Regular                       = lipgloss.NewStyle()
	Bold                          = Regular.Copy().Bold(true)
	Logo                          = Regular.Copy().Padding(0, 0).Foreground(yellow)
	ClusterUrl                    = Bold.Copy()
	KeyHelp                       = Regular.Copy().Padding(0, 1)
	KeyHelpKey                    = Regular.Copy().Foreground(blue).Bold(true)
	KeyHelpDescription            = Regular.Copy()
	Header                        = Regular.Copy().Padding(0, 1).Border(lipgloss.RoundedBorder(), true)
	FilterPrefix                  = Regular.Copy().Padding(0, 3).Border(lipgloss.NormalBorder(), true)
	FilterEditing                 = Regular.Copy().Foreground(black).Background(blue)
	FilterApplied                 = Regular.Copy().Foreground(black).Background(greenblue)
	JobRowPending                 = Regular.Copy().Foreground(yellow)
	JobRowDead                    = Regular.Copy().Foreground(red)
	StatBad                       = Regular.Copy().Foreground(black).Background(red)
	PseudoPrompt                  = Regular.Copy().Background(blue)
	Viewport                      = Regular.Copy()
	ViewportHeaderStyle           = Bold.Copy()
	ViewportSelectedRowStyle      = Regular.Copy().Foreground(black).Background(blue)
	ViewportHighlightStyle        = Regular.Copy().Foreground(black).Background(pink)
	ViewportSpecialHighlightStyle = Regular.Copy().Foreground(black).Background(yellow)
	ViewportFooterStyle           = Regular.Copy().Foreground(grey)
	SaveDialogPromptStyle         = Regular.Copy().Background(darkred).Foreground(black)
	SaveDialogPlaceholderStyle    = Regular.Copy().Background(darkred).Foreground(black)
	SaveDialogTextStyle           = Regular.Copy().Background(darkred).Foreground(black)
	StdOut                        = Regular.Copy().UnsetForeground()
	StdErr                        = Regular.Copy().Foreground(red)
	SuccessToast                  = Bold.Copy().PaddingLeft(1).Foreground(black).Background(darkgreen)
	ErrorToast                    = Bold.Copy().PaddingLeft(1).Foreground(black).Background(darkred)
)
