// Code generated by platformsh/generator/main.go
// DO NOT EDIT

/*
 * Copyright (c) 2021-present Fabien Potencier <fabien@symfony.com>
 *
 * This file is part of Symfony CLI project
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Affero General Public License as
 * published by the Free Software Foundation, either version 3 of the
 * License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
 * GNU Affero General Public License for more details.
 *
 * You should have received a copy of the GNU Affero General Public License
 * along with this program. If not, see <http://www.gnu.org/licenses/>.
 */

package platformsh

import (
	"github.com/symfony-cli/console"
)

var Commands = []*console.Command{
	{
		Category: "cloud",
		Name:     "_completion",
		Aliases:  []*console.Alias{
			{Name: "upsun:_completion", Hidden: true},
		},
		Usage:    "BASH completion hook.",
		Hidden:   console.Hide,
		Flags:    []console.Flag{
			&console.BoolFlag{Name: "generate-hook", Aliases: []string{"g"},},
			&console.BoolFlag{Name: "multiple", Aliases: []string{"m"},},
			&console.StringFlag{Name: "program", Aliases: []string{"p"},},
			&console.StringFlag{Name: "shell-type",},
		},
	},
	{
		Category: "cloud",
		Name:     "bot",
		Aliases:  []*console.Alias{
			{Name: "upsun:bot", Hidden: true},
		},
		Usage:    "The Platform.sh/Upsun Bot",
		Hidden:   console.Hide,
		Flags:    []console.Flag{
			&console.BoolFlag{Name: "parrot",},
			&console.BoolFlag{Name: "party",},
		},
	},
	{
		Category: "cloud",
		Name:     "clear-cache",
		Aliases:  []*console.Alias{
			{Name: "upsun:clear-cache", Hidden: true},
			{Name: "cloud:cc"},
			{Name: "upsun:cc", Hidden: true},
		},
		Usage:    "Clear the CLI cache",
	},
	{
		Category: "cloud",
		Name:     "docs",
		Aliases:  []*console.Alias{
			{Name: "upsun:docs", Hidden: true},
		},
		Usage:    "Open the online documentation",
		Flags:    []console.Flag{
			&console.StringFlag{Name: "browser",},
			&console.BoolFlag{Name: "pipe",},
		},
	},
	{
		Category: "cloud",
		Name:     "legacy-migrate",
		Aliases:  []*console.Alias{
			{Name: "upsun:legacy-migrate", Hidden: true},
		},
		Usage:    "Migrate from the legacy file structure",
		Hidden:   console.Hide,
		Flags:    []console.Flag{
			&console.BoolFlag{Name: "no-backup",},
		},
	},
	{
		Category: "cloud",
		Name:     "multi",
		Aliases:  []*console.Alias{
			{Name: "upsun:multi", Hidden: true},
		},
		Usage:    "Execute a command on multiple projects",
		Flags:    []console.Flag{
			&console.BoolFlag{Name: "continue",},
			&console.StringFlag{Name: "projects", Aliases: []string{"p"},},
			&console.BoolFlag{Name: "reverse",},
			&console.StringFlag{Name: "sort", DefaultValue: "title",},
		},
	},
	{
		Category: "cloud",
		Name:     "web",
		Aliases:  []*console.Alias{
			{Name: "upsun:web", Hidden: true},
		},
		Usage:    "Open the project in the Web Console",
		Flags:    []console.Flag{
			&console.StringFlag{Name: "browser",},
			&console.StringFlag{Name: "environment", Aliases: []string{"e"},},
			&console.BoolFlag{Name: "pipe",},
			&console.StringFlag{Name: "project", Aliases: []string{"p"},},
		},
	},
	{
		Category: "cloud",
		Name:     "welcome",
		Aliases:  []*console.Alias{
			{Name: "upsun:welcome", Hidden: true},
		},
		Usage:    "Welcome to Platform.sh/Upsun",
		Hidden:   console.Hide,
	},
	{
		Category: "cloud",
		Name:     "winky",
		Aliases:  []*console.Alias{
			{Name: "upsun:winky", Hidden: true},
		},
		Usage:    "",
		Hidden:   console.Hide,
	},
	{
		Category: "cloud:activity",
		Name:     "cancel",
		Aliases:  []*console.Alias{
			{Name: "activity:cancel", Hidden: true},
			{Name: "upsun:activity:cancel", Hidden: true},
		},
		Usage:    "Cancel an activity",
		Flags:    []console.Flag{
			&console.BoolFlag{Name: "all", Aliases: []string{"a"},},
			&console.StringFlag{Name: "environment", Aliases: []string{"e"},},
			&console.StringFlag{Name: "exclude-type", Aliases: []string{"x"},},
			&console.StringFlag{Name: "project", Aliases: []string{"p"},},
			&console.StringFlag{Name: "type", Aliases: []string{"t"},},
		},
	},
	{
		Category: "cloud:activity",
		Name:     "get",
		Aliases:  []*console.Alias{
			{Name: "activity:get", Hidden: true},
			{Name: "upsun:activity:get", Hidden: true},
		},
		Usage:    "View detailed information on a single activity",
		Flags:    []console.Flag{
			&console.BoolFlag{Name: "all", Aliases: []string{"a"},},
			&console.StringFlag{Name: "columns", Aliases: []string{"c"},},
			&console.StringFlag{Name: "date-fmt", DefaultValue: "c",},
			&console.StringFlag{Name: "environment", Aliases: []string{"e"},},
			&console.StringFlag{Name: "exclude-type", Aliases: []string{"x"},},
			&console.StringFlag{Name: "format", DefaultValue: "table",},
			&console.BoolFlag{Name: "incomplete", Aliases: []string{"i"},},
			&console.BoolFlag{Name: "no-header",},
			&console.StringFlag{Name: "project", Aliases: []string{"p"},},
			&console.StringFlag{Name: "property", Aliases: []string{"P"},},
			&console.StringFlag{Name: "result",},
			&console.StringFlag{Name: "state",},
			&console.StringFlag{Name: "type", Aliases: []string{"t"},},
		},
	},
	{
		Category: "cloud:activity",
		Name:     "list",
		Aliases:  []*console.Alias{
			{Name: "activity:list", Hidden: true},
			{Name: "upsun:activity:list", Hidden: true},
			{Name: "cloud:activities"},
			{Name: "upsun:activities", Hidden: true},
			{Name: "activities", Hidden: true},
			{Name: "cloud:act"},
			{Name: "upsun:act", Hidden: true},
			{Name: "act", Hidden: true},
		},
		Usage:    "Get a list of activities for an environment or project",
		Flags:    []console.Flag{
			&console.BoolFlag{Name: "all", Aliases: []string{"a"},},
			&console.StringFlag{Name: "columns", Aliases: []string{"c"},},
			&console.StringFlag{Name: "date-fmt", DefaultValue: "c",},
			&console.StringFlag{Name: "environment", Aliases: []string{"e"},},
			&console.StringFlag{Name: "exclude-type", Aliases: []string{"x"},},
			&console.StringFlag{Name: "format", DefaultValue: "table",},
			&console.BoolFlag{Name: "incomplete", Aliases: []string{"i"},},
			&console.StringFlag{Name: "limit",},
			&console.BoolFlag{Name: "no-header",},
			&console.StringFlag{Name: "project", Aliases: []string{"p"},},
			&console.StringFlag{Name: "result",},
			&console.StringFlag{Name: "start",},
			&console.StringFlag{Name: "state",},
			&console.StringFlag{Name: "type", Aliases: []string{"t"},},
		},
	},
	{
		Category: "cloud:activity",
		Name:     "log",
		Aliases:  []*console.Alias{
			{Name: "activity:log", Hidden: true},
			{Name: "upsun:activity:log", Hidden: true},
		},
		Usage:    "Display the log for an activity",
		Flags:    []console.Flag{
			&console.BoolFlag{Name: "all", Aliases: []string{"a"},},
			&console.StringFlag{Name: "date-fmt", DefaultValue: "c",},
			&console.StringFlag{Name: "environment", Aliases: []string{"e"},},
			&console.StringFlag{Name: "exclude-type", Aliases: []string{"x"},},
			&console.BoolFlag{Name: "incomplete", Aliases: []string{"i"},},
			&console.StringFlag{Name: "project", Aliases: []string{"p"},},
			&console.StringFlag{Name: "refresh",},
			&console.StringFlag{Name: "result",},
			&console.StringFlag{Name: "state",},
			&console.BoolFlag{Name: "timestamps", Aliases: []string{"t"},},
			&console.StringFlag{Name: "type",},
		},
	},
	{
		Category: "cloud:api",
		Name:     "curl",
		Aliases:  []*console.Alias{
			{Name: "api:curl", Hidden: true},
			{Name: "upsun:api:curl", Hidden: true},
		},
		Usage:    "Run an authenticated cURL request on the Platform.sh/Upsun API",
		Hidden:   console.Hide,
		Flags:    []console.Flag{
			&console.StringFlag{Name: "data", Aliases: []string{"d"},},
			&console.BoolFlag{Name: "disable-compression",},
			&console.BoolFlag{Name: "enable-glob",},
			&console.BoolFlag{Name: "fail", Aliases: []string{"f"},},
			&console.BoolFlag{Name: "head", Aliases: []string{"I"},},
			&console.StringFlag{Name: "header", Aliases: []string{"H"},},
			&console.BoolFlag{Name: "include", Aliases: []string{"i"},},
			&console.StringFlag{Name: "json",},
			&console.StringFlag{Name: "request", Aliases: []string{"X"},},
		},
	},
	{
		Category: "cloud:app",
		Name:     "config-get",
		Aliases:  []*console.Alias{
			{Name: "app:config-get", Hidden: true},
			{Name: "upsun:app:config-get", Hidden: true},
		},
		Usage:    "View the configuration of an app",
		Flags:    []console.Flag{
			&console.StringFlag{Name: "app", Aliases: []string{"A"},},
			&console.StringFlag{Name: "environment", Aliases: []string{"e"},},
			&console.StringFlag{Name: "identity-file", Aliases: []string{"i"},},
			&console.StringFlag{Name: "project", Aliases: []string{"p"},},
			&console.StringFlag{Name: "property", Aliases: []string{"P"},},
			&console.BoolFlag{Name: "refresh",},
		},
	},
	{
		Category: "cloud:app",
		Name:     "config-validate",
		Aliases:  []*console.Alias{
			{Name: "app:config-validate", Hidden: true},
			{Name: "upsun:app:config-validate", Hidden: true},
		},
		Usage:    "Validate the config files of a project",
	},
	{
		Category: "cloud:app",
		Name:     "list",
		Aliases:  []*console.Alias{
			{Name: "app:list", Hidden: true},
			{Name: "upsun:app:list", Hidden: true},
			{Name: "cloud:apps"},
			{Name: "upsun:apps", Hidden: true},
			{Name: "apps", Hidden: true},
		},
		Usage:    "List apps in the project",
		Flags:    []console.Flag{
			&console.StringFlag{Name: "columns", Aliases: []string{"c"},},
			&console.StringFlag{Name: "environment", Aliases: []string{"e"},},
			&console.StringFlag{Name: "format", DefaultValue: "table",},
			&console.BoolFlag{Name: "no-header",},
			&console.BoolFlag{Name: "pipe",},
			&console.StringFlag{Name: "project", Aliases: []string{"p"},},
			&console.BoolFlag{Name: "refresh",},
		},
	},
	{
		Category: "cloud:auth",
		Name:     "api-token-login",
		Aliases:  []*console.Alias{
			{Name: "auth:api-token-login", Hidden: true},
			{Name: "upsun:auth:api-token-login", Hidden: true},
		},
		Usage:    "Log in to Platform.sh/Upsun using an API token",
	},
	{
		Category: "cloud:auth",
		Name:     "browser-login",
		Aliases:  []*console.Alias{
			{Name: "auth:browser-login", Hidden: true},
			{Name: "upsun:auth:browser-login", Hidden: true},
			{Name: "cloud:login"},
			{Name: "upsun:login", Hidden: true},
			{Name: "login", Hidden: true},
		},
		Usage:    "Log in to Platform.sh/Upsun via a browser",
		Flags:    []console.Flag{
			&console.StringFlag{Name: "browser",},
			&console.BoolFlag{Name: "force", Aliases: []string{"f"},},
			&console.BoolFlag{Name: "pipe",},
		},
	},
	{
		Category: "cloud:auth",
		Name:     "info",
		Aliases:  []*console.Alias{
			{Name: "auth:info", Hidden: true},
			{Name: "upsun:auth:info", Hidden: true},
		},
		Usage:    "Display your account information",
		Flags:    []console.Flag{
			&console.StringFlag{Name: "columns", Aliases: []string{"c"},},
			&console.StringFlag{Name: "format", DefaultValue: "table",},
			&console.BoolFlag{Name: "no-auto-login",},
			&console.BoolFlag{Name: "no-header",},
			&console.StringFlag{Name: "property", Aliases: []string{"P"},},
			&console.BoolFlag{Name: "refresh",},
		},
	},
	{
		Category: "cloud:auth",
		Name:     "logout",
		Aliases:  []*console.Alias{
			{Name: "auth:logout", Hidden: true},
			{Name: "upsun:auth:logout", Hidden: true},
			{Name: "cloud:logout"},
			{Name: "upsun:logout", Hidden: true},
			{Name: "logout", Hidden: true},
		},
		Usage:    "Log out of Platform.sh/Upsun",
		Flags:    []console.Flag{
			&console.BoolFlag{Name: "all", Aliases: []string{"a"},},
			&console.BoolFlag{Name: "other",},
		},
	},
	{
		Category: "cloud:auth",
		Name:     "token",
		Aliases:  []*console.Alias{
			{Name: "auth:token", Hidden: true},
			{Name: "upsun:auth:token", Hidden: true},
		},
		Usage:    "Obtain an OAuth 2 access token for requests to Platform.sh/Upsun APIs",
		Hidden:   console.Hide,
		Flags:    []console.Flag{
			&console.BoolFlag{Name: "header", Aliases: []string{"H"},},
			&console.BoolFlag{Name: "no-warn", Aliases: []string{"W"},},
		},
	},
	{
		Category: "cloud:auth",
		Name:     "verify-phone-number",
		Aliases:  []*console.Alias{
			{Name: "auth:verify-phone-number", Hidden: true},
			{Name: "upsun:auth:verify-phone-number", Hidden: true},
		},
		Usage:    "Verify your phone number interactively",
	},
	{
		Category: "cloud:backup",
		Name:     "create",
		Aliases:  []*console.Alias{
			{Name: "backup:create", Hidden: true},
			{Name: "upsun:backup:create", Hidden: true},
			{Name: "cloud:backup"},
			{Name: "upsun:backup", Hidden: true},
			{Name: "backup", Hidden: true},
		},
		Usage:    "Make a backup of an environment",
		Flags:    []console.Flag{
			&console.StringFlag{Name: "environment", Aliases: []string{"e"},},
			&console.BoolFlag{Name: "live",},
			&console.BoolFlag{Name: "no-wait", Aliases: []string{"W"},},
			&console.StringFlag{Name: "project", Aliases: []string{"p"},},
			&console.BoolFlag{Name: "wait",},
		},
	},
	{
		Category: "cloud:backup",
		Name:     "delete",
		Aliases:  []*console.Alias{
			{Name: "backup:delete", Hidden: true},
			{Name: "upsun:backup:delete", Hidden: true},
		},
		Usage:    "Delete an environment backup",
		Flags:    []console.Flag{
			&console.StringFlag{Name: "environment", Aliases: []string{"e"},},
			&console.BoolFlag{Name: "no-wait", Aliases: []string{"W"},},
			&console.StringFlag{Name: "project", Aliases: []string{"p"},},
			&console.BoolFlag{Name: "wait",},
		},
	},
	{
		Category: "cloud:backup",
		Name:     "get",
		Aliases:  []*console.Alias{
			{Name: "backup:get", Hidden: true},
			{Name: "upsun:backup:get", Hidden: true},
		},
		Usage:    "View an environment backup",
		Flags:    []console.Flag{
			&console.StringFlag{Name: "date-fmt", DefaultValue: "c",},
			&console.StringFlag{Name: "environment", Aliases: []string{"e"},},
			&console.StringFlag{Name: "project", Aliases: []string{"p"},},
			&console.StringFlag{Name: "property", Aliases: []string{"P"},},
		},
	},
	{
		Category: "cloud:backup",
		Name:     "list",
		Aliases:  []*console.Alias{
			{Name: "backup:list", Hidden: true},
			{Name: "upsun:backup:list", Hidden: true},
			{Name: "cloud:backups"},
			{Name: "upsun:backups", Hidden: true},
			{Name: "backups", Hidden: true},
		},
		Usage:    "List available backups of an environment",
		Flags:    []console.Flag{
			&console.StringFlag{Name: "columns", Aliases: []string{"c"},},
			&console.StringFlag{Name: "date-fmt", DefaultValue: "c",},
			&console.StringFlag{Name: "environment", Aliases: []string{"e"},},
			&console.StringFlag{Name: "format", DefaultValue: "table",},
			&console.BoolFlag{Name: "no-header",},
			&console.StringFlag{Name: "project", Aliases: []string{"p"},},
		},
	},
	{
		Category: "cloud:backup",
		Name:     "restore",
		Aliases:  []*console.Alias{
			{Name: "backup:restore", Hidden: true},
			{Name: "upsun:backup:restore", Hidden: true},
		},
		Usage:    "Restore an environment backup",
		Flags:    []console.Flag{
			&console.StringFlag{Name: "branch-from",},
			&console.StringFlag{Name: "environment", Aliases: []string{"e"},},
			&console.BoolFlag{Name: "no-wait", Aliases: []string{"W"},},
			&console.StringFlag{Name: "project", Aliases: []string{"p"},},
			&console.StringFlag{Name: "target",},
			&console.BoolFlag{Name: "wait",},
		},
	},
	{
		Category: "cloud:blue-green",
		Name:     "conclude",
		Aliases:  []*console.Alias{
			{Name: "blue-green:conclude", Hidden: true},
			{Name: "upsun:blue-green:conclude", Hidden: true},
		},
		Usage:    " ALPHA  Conclude a blue/green deployment",
		Hidden:   console.Hide,
		Flags:    []console.Flag{
			&console.StringFlag{Name: "environment", Aliases: []string{"e"},},
			&console.StringFlag{Name: "project", Aliases: []string{"p"},},
		},
	},
	{
		Category: "cloud:blue-green",
		Name:     "deploy",
		Aliases:  []*console.Alias{
			{Name: "blue-green:deploy", Hidden: true},
			{Name: "upsun:blue-green:deploy", Hidden: true},
		},
		Usage:    " ALPHA  Perform a blue/green deployment",
		Hidden:   console.Hide,
		Flags:    []console.Flag{
			&console.StringFlag{Name: "environment", Aliases: []string{"e"},},
			&console.StringFlag{Name: "project", Aliases: []string{"p"},},
			&console.StringFlag{Name: "routing-percentage",},
		},
	},
	{
		Category: "cloud:blue-green",
		Name:     "enable",
		Aliases:  []*console.Alias{
			{Name: "blue-green:enable", Hidden: true},
			{Name: "upsun:blue-green:enable", Hidden: true},
		},
		Usage:    " ALPHA  Enable blue/green deployments",
		Hidden:   console.Hide,
		Flags:    []console.Flag{
			&console.StringFlag{Name: "environment", Aliases: []string{"e"},},
			&console.StringFlag{Name: "project", Aliases: []string{"p"},},
			&console.StringFlag{Name: "routing-percentage", Aliases: []string{"%"},},
		},
	},
	{
		Category: "cloud:certificate",
		Name:     "add",
		Aliases:  []*console.Alias{
			{Name: "certificate:add", Hidden: true},
			{Name: "upsun:certificate:add", Hidden: true},
		},
		Usage:    "Add an SSL certificate to the project",
		Flags:    []console.Flag{
			&console.StringFlag{Name: "cert",},
			&console.StringFlag{Name: "chain",},
			&console.StringFlag{Name: "key",},
			&console.BoolFlag{Name: "no-wait", Aliases: []string{"W"},},
			&console.StringFlag{Name: "project", Aliases: []string{"p"},},
			&console.BoolFlag{Name: "wait",},
		},
	},
	{
		Category: "cloud:certificate",
		Name:     "delete",
		Aliases:  []*console.Alias{
			{Name: "certificate:delete", Hidden: true},
			{Name: "upsun:certificate:delete", Hidden: true},
		},
		Usage:    "Delete a certificate from the project",
		Flags:    []console.Flag{
			&console.BoolFlag{Name: "no-wait", Aliases: []string{"W"},},
			&console.StringFlag{Name: "project", Aliases: []string{"p"},},
			&console.BoolFlag{Name: "wait",},
		},
	},
	{
		Category: "cloud:certificate",
		Name:     "get",
		Aliases:  []*console.Alias{
			{Name: "certificate:get", Hidden: true},
			{Name: "upsun:certificate:get", Hidden: true},
		},
		Usage:    "View a certificate",
		Flags:    []console.Flag{
			&console.StringFlag{Name: "date-fmt", DefaultValue: "c",},
			&console.StringFlag{Name: "project", Aliases: []string{"p"},},
			&console.StringFlag{Name: "property", Aliases: []string{"P"},},
		},
	},
	{
		Category: "cloud:certificate",
		Name:     "list",
		Aliases:  []*console.Alias{
			{Name: "certificate:list", Hidden: true},
			{Name: "upsun:certificate:list", Hidden: true},
			{Name: "cloud:certificates"},
			{Name: "upsun:certificates", Hidden: true},
			{Name: "certificates", Hidden: true},
			{Name: "cloud:certs"},
			{Name: "upsun:certs", Hidden: true},
			{Name: "certs", Hidden: true},
		},
		Usage:    "List project certificates",
		Flags:    []console.Flag{
			&console.StringFlag{Name: "columns", Aliases: []string{"c"},},
			&console.StringFlag{Name: "date-fmt", DefaultValue: "c",},
			&console.StringFlag{Name: "domain",},
			&console.StringFlag{Name: "exclude-domain",},
			&console.StringFlag{Name: "format", DefaultValue: "table",},
			&console.BoolFlag{Name: "ignore-expiry",},
			&console.StringFlag{Name: "issuer",},
			&console.BoolFlag{Name: "no-auto",},
			&console.BoolFlag{Name: "no-expired",},
			&console.BoolFlag{Name: "no-header",},
			&console.BoolFlag{Name: "only-auto",},
			&console.BoolFlag{Name: "only-expired",},
			&console.BoolFlag{Name: "pipe-domains",},
			&console.StringFlag{Name: "project", Aliases: []string{"p"},},
		},
	},
	{
		Category: "cloud:commit",
		Name:     "get",
		Aliases:  []*console.Alias{
			{Name: "commit:get", Hidden: true},
			{Name: "upsun:commit:get", Hidden: true},
		},
		Usage:    "Show commit details",
		Flags:    []console.Flag{
			&console.StringFlag{Name: "date-fmt", DefaultValue: "c",},
			&console.StringFlag{Name: "environment", Aliases: []string{"e"},},
			&console.StringFlag{Name: "project", Aliases: []string{"p"},},
			&console.StringFlag{Name: "property", Aliases: []string{"P"},},
		},
	},
	{
		Category: "cloud:commit",
		Name:     "list",
		Aliases:  []*console.Alias{
			{Name: "commit:list", Hidden: true},
			{Name: "upsun:commit:list", Hidden: true},
			{Name: "cloud:commits"},
			{Name: "upsun:commits", Hidden: true},
			{Name: "commits", Hidden: true},
		},
		Usage:    "List commits",
		Flags:    []console.Flag{
			&console.StringFlag{Name: "columns", Aliases: []string{"c"},},
			&console.StringFlag{Name: "date-fmt", DefaultValue: "c",},
			&console.StringFlag{Name: "environment", Aliases: []string{"e"},},
			&console.StringFlag{Name: "format", DefaultValue: "table",},
			&console.StringFlag{Name: "limit",},
			&console.BoolFlag{Name: "no-header",},
			&console.StringFlag{Name: "project", Aliases: []string{"p"},},
		},
	},
	{
		Category: "cloud:db",
		Name:     "dump",
		Aliases:  []*console.Alias{
			{Name: "db:dump", Hidden: true},
			{Name: "upsun:db:dump", Hidden: true},
		},
		Usage:    "Create a local dump of the remote database",
		Flags:    []console.Flag{
			&console.StringFlag{Name: "app", Aliases: []string{"A"},},
			&console.StringFlag{Name: "charset",},
			&console.StringFlag{Name: "directory", Aliases: []string{"d"},},
			&console.StringFlag{Name: "environment", Aliases: []string{"e"},},
			&console.StringFlag{Name: "exclude-table",},
			&console.StringFlag{Name: "file", Aliases: []string{"f"},},
			&console.BoolFlag{Name: "gzip", Aliases: []string{"z"},},
			&console.StringFlag{Name: "identity-file", Aliases: []string{"i"},},
			&console.StringFlag{Name: "project", Aliases: []string{"p"},},
			&console.StringFlag{Name: "relationship", Aliases: []string{"r"},},
			&console.StringFlag{Name: "schema",},
			&console.BoolFlag{Name: "schema-only",},
			&console.BoolFlag{Name: "stdout", Aliases: []string{"o"},},
			&console.StringFlag{Name: "table",},
			&console.BoolFlag{Name: "timestamp", Aliases: []string{"t"},},
		},
	},
	{
		Category: "cloud:db",
		Name:     "size",
		Aliases:  []*console.Alias{
			{Name: "db:size", Hidden: true},
			{Name: "upsun:db:size", Hidden: true},
		},
		Usage:    "Estimate the disk usage of a database",
		Flags:    []console.Flag{
			&console.StringFlag{Name: "app", Aliases: []string{"A"},},
			&console.BoolFlag{Name: "bytes", Aliases: []string{"B"},},
			&console.BoolFlag{Name: "cleanup", Aliases: []string{"C"},},
			&console.StringFlag{Name: "columns", Aliases: []string{"c"},},
			&console.StringFlag{Name: "environment", Aliases: []string{"e"},},
			&console.StringFlag{Name: "format", DefaultValue: "table",},
			&console.StringFlag{Name: "identity-file", Aliases: []string{"i"},},
			&console.BoolFlag{Name: "no-header",},
			&console.StringFlag{Name: "project", Aliases: []string{"p"},},
			&console.StringFlag{Name: "relationship", Aliases: []string{"r"},},
		},
	},
	{
		Category: "cloud:db",
		Name:     "sql",
		Aliases:  []*console.Alias{
			{Name: "db:sql", Hidden: true},
			{Name: "upsun:db:sql", Hidden: true},
			{Name: "cloud:sql"},
			{Name: "upsun:sql", Hidden: true},
			{Name: "sql", Hidden: true},
		},
		Usage:    "Run SQL on the remote database",
		Flags:    []console.Flag{
			&console.StringFlag{Name: "app", Aliases: []string{"A"},},
			&console.StringFlag{Name: "environment", Aliases: []string{"e"},},
			&console.StringFlag{Name: "identity-file", Aliases: []string{"i"},},
			&console.StringFlag{Name: "project", Aliases: []string{"p"},},
			&console.BoolFlag{Name: "raw",},
			&console.StringFlag{Name: "relationship", Aliases: []string{"r"},},
			&console.StringFlag{Name: "schema",},
		},
	},
	{
		Category: "cloud:domain",
		Name:     "add",
		Aliases:  []*console.Alias{
			{Name: "domain:add", Hidden: true},
			{Name: "upsun:domain:add", Hidden: true},
		},
		Usage:    "Add a new domain to the project",
		Flags:    []console.Flag{
			&console.StringFlag{Name: "attach",},
			&console.StringFlag{Name: "cert",},
			&console.StringFlag{Name: "chain",},
			&console.StringFlag{Name: "environment", Aliases: []string{"e"},},
			&console.StringFlag{Name: "key",},
			&console.BoolFlag{Name: "no-wait", Aliases: []string{"W"},},
			&console.StringFlag{Name: "project", Aliases: []string{"p"},},
			&console.BoolFlag{Name: "wait",},
		},
	},
	{
		Category: "cloud:domain",
		Name:     "delete",
		Aliases:  []*console.Alias{
			{Name: "domain:delete", Hidden: true},
			{Name: "upsun:domain:delete", Hidden: true},
		},
		Usage:    "Delete a domain from the project",
		Flags:    []console.Flag{
			&console.StringFlag{Name: "environment", Aliases: []string{"e"},},
			&console.BoolFlag{Name: "no-wait", Aliases: []string{"W"},},
			&console.StringFlag{Name: "project", Aliases: []string{"p"},},
			&console.BoolFlag{Name: "wait",},
		},
	},
	{
		Category: "cloud:domain",
		Name:     "get",
		Aliases:  []*console.Alias{
			{Name: "domain:get", Hidden: true},
			{Name: "upsun:domain:get", Hidden: true},
		},
		Usage:    "Show detailed information for a domain",
		Flags:    []console.Flag{
			&console.StringFlag{Name: "columns", Aliases: []string{"c"},},
			&console.StringFlag{Name: "date-fmt", DefaultValue: "c",},
			&console.StringFlag{Name: "environment", Aliases: []string{"e"},},
			&console.StringFlag{Name: "format", DefaultValue: "table",},
			&console.BoolFlag{Name: "no-header",},
			&console.StringFlag{Name: "project", Aliases: []string{"p"},},
			&console.StringFlag{Name: "property", Aliases: []string{"P"},},
		},
	},
	{
		Category: "cloud:domain",
		Name:     "list",
		Aliases:  []*console.Alias{
			{Name: "domain:list", Hidden: true},
			{Name: "upsun:domain:list", Hidden: true},
			{Name: "cloud:domains"},
			{Name: "upsun:domains", Hidden: true},
			{Name: "domains", Hidden: true},
		},
		Usage:    "Get a list of all domains",
		Flags:    []console.Flag{
			&console.StringFlag{Name: "columns", Aliases: []string{"c"},},
			&console.StringFlag{Name: "environment", Aliases: []string{"e"},},
			&console.StringFlag{Name: "format", DefaultValue: "table",},
			&console.BoolFlag{Name: "no-header",},
			&console.StringFlag{Name: "project", Aliases: []string{"p"},},
		},
	},
	{
		Category: "cloud:domain",
		Name:     "update",
		Aliases:  []*console.Alias{
			{Name: "domain:update", Hidden: true},
			{Name: "upsun:domain:update", Hidden: true},
		},
		Usage:    "Update a domain",
		Flags:    []console.Flag{
			&console.StringFlag{Name: "cert",},
			&console.StringFlag{Name: "chain",},
			&console.StringFlag{Name: "environment", Aliases: []string{"e"},},
			&console.StringFlag{Name: "key",},
			&console.BoolFlag{Name: "no-wait", Aliases: []string{"W"},},
			&console.StringFlag{Name: "project", Aliases: []string{"p"},},
			&console.BoolFlag{Name: "wait",},
		},
	},
	{
		Category: "cloud:environment",
		Name:     "activate",
		Aliases:  []*console.Alias{
			{Name: "environment:activate", Hidden: true},
			{Name: "upsun:environment:activate", Hidden: true},
		},
		Usage:    "Activate an environment",
		Flags:    []console.Flag{
			&console.StringFlag{Name: "environment", Aliases: []string{"e"},},
			&console.BoolFlag{Name: "no-wait", Aliases: []string{"W"},},
			&console.StringFlag{Name: "parent",},
			&console.StringFlag{Name: "project", Aliases: []string{"p"},},
			&console.BoolFlag{Name: "wait",},
		},
	},
	{
		Category: "cloud:environment",
		Name:     "branch",
		Aliases:  []*console.Alias{
			{Name: "environment:branch", Hidden: true},
			{Name: "upsun:environment:branch", Hidden: true},
			{Name: "cloud:branch"},
			{Name: "upsun:branch", Hidden: true},
			{Name: "branch", Hidden: true},
		},
		Usage:    "Branch an environment",
		Flags:    []console.Flag{
			&console.StringFlag{Name: "environment", Aliases: []string{"e"},},
			&console.BoolFlag{Name: "no-clone-parent",},
			&console.BoolFlag{Name: "no-wait", Aliases: []string{"W"},},
			&console.StringFlag{Name: "project", Aliases: []string{"p"},},
			&console.StringFlag{Name: "title",},
			&console.StringFlag{Name: "type",},
			&console.BoolFlag{Name: "wait",},
		},
	},
	{
		Category: "cloud:environment",
		Name:     "checkout",
		Aliases:  []*console.Alias{
			{Name: "environment:checkout", Hidden: true},
			{Name: "upsun:environment:checkout", Hidden: true},
			{Name: "cloud:checkout"},
			{Name: "upsun:checkout", Hidden: true},
			{Name: "checkout", Hidden: true},
		},
		Usage:    "Check out an environment",
		Flags:    []console.Flag{
			&console.StringFlag{Name: "identity-file", Aliases: []string{"i"},},
		},
	},
	{
		Category: "cloud:environment",
		Name:     "curl",
		Aliases:  []*console.Alias{
			{Name: "environment:curl", Hidden: true},
			{Name: "upsun:environment:curl", Hidden: true},
		},
		Usage:    "Run an authenticated cURL request on an environment's API",
		Hidden:   console.Hide,
		Flags:    []console.Flag{
			&console.StringFlag{Name: "data", Aliases: []string{"d"},},
			&console.BoolFlag{Name: "disable-compression",},
			&console.BoolFlag{Name: "enable-glob",},
			&console.StringFlag{Name: "environment", Aliases: []string{"e"},},
			&console.BoolFlag{Name: "fail", Aliases: []string{"f"},},
			&console.BoolFlag{Name: "head", Aliases: []string{"I"},},
			&console.StringFlag{Name: "header", Aliases: []string{"H"},},
			&console.BoolFlag{Name: "include", Aliases: []string{"i"},},
			&console.StringFlag{Name: "json",},
			&console.StringFlag{Name: "project", Aliases: []string{"p"},},
			&console.StringFlag{Name: "request", Aliases: []string{"X"},},
		},
	},
	{
		Category: "cloud:environment",
		Name:     "delete",
		Aliases:  []*console.Alias{
			{Name: "environment:delete", Hidden: true},
			{Name: "upsun:environment:delete", Hidden: true},
		},
		Usage:    "Delete one or more environments",
		Flags:    []console.Flag{
			&console.BoolFlag{Name: "allow-delete-parent",},
			&console.BoolFlag{Name: "delete-branch",},
			&console.StringFlag{Name: "environment", Aliases: []string{"e"},},
			&console.StringFlag{Name: "exclude",},
			&console.StringFlag{Name: "exclude-type",},
			&console.BoolFlag{Name: "inactive",},
			&console.BoolFlag{Name: "merged",},
			&console.BoolFlag{Name: "no-delete-branch",},
			&console.BoolFlag{Name: "no-wait", Aliases: []string{"W"},},
			&console.StringFlag{Name: "only-type", Aliases: []string{"t"},},
			&console.StringFlag{Name: "project", Aliases: []string{"p"},},
			&console.StringFlag{Name: "type",},
			&console.BoolFlag{Name: "wait",},
		},
	},
	{
		Category: "cloud:environment",
		Name:     "http-access",
		Aliases:  []*console.Alias{
			{Name: "environment:http-access", Hidden: true},
			{Name: "upsun:environment:http-access", Hidden: true},
			{Name: "cloud:httpaccess"},
			{Name: "upsun:httpaccess", Hidden: true},
			{Name: "httpaccess", Hidden: true},
		},
		Usage:    "Update HTTP access settings for an environment",
		Flags:    []console.Flag{
			&console.StringFlag{Name: "access",},
			&console.StringFlag{Name: "auth",},
			&console.StringFlag{Name: "enabled",},
			&console.StringFlag{Name: "environment", Aliases: []string{"e"},},
			&console.BoolFlag{Name: "no-wait", Aliases: []string{"W"},},
			&console.StringFlag{Name: "project", Aliases: []string{"p"},},
			&console.BoolFlag{Name: "wait",},
		},
	},
	{
		Category: "cloud:environment",
		Name:     "info",
		Aliases:  []*console.Alias{
			{Name: "environment:info", Hidden: true},
			{Name: "upsun:environment:info", Hidden: true},
		},
		Usage:    "Read or set properties for an environment",
		Flags:    []console.Flag{
			&console.StringFlag{Name: "columns", Aliases: []string{"c"},},
			&console.StringFlag{Name: "date-fmt", DefaultValue: "c",},
			&console.StringFlag{Name: "environment", Aliases: []string{"e"},},
			&console.StringFlag{Name: "format", DefaultValue: "table",},
			&console.BoolFlag{Name: "no-header",},
			&console.BoolFlag{Name: "no-wait", Aliases: []string{"W"},},
			&console.StringFlag{Name: "project", Aliases: []string{"p"},},
			&console.BoolFlag{Name: "refresh",},
			&console.BoolFlag{Name: "wait",},
		},
	},
	{
		Category: "cloud:environment",
		Name:     "init",
		Aliases:  []*console.Alias{
			{Name: "environment:init", Hidden: true},
			{Name: "upsun:environment:init", Hidden: true},
		},
		Usage:    "Initialize an environment from a public Git repository",
		Flags:    []console.Flag{
			&console.StringFlag{Name: "environment", Aliases: []string{"e"},},
			&console.BoolFlag{Name: "no-wait", Aliases: []string{"W"},},
			&console.StringFlag{Name: "profile",},
			&console.StringFlag{Name: "project", Aliases: []string{"p"},},
			&console.BoolFlag{Name: "wait",},
		},
	},
	{
		Category: "cloud:environment",
		Name:     "list",
		Aliases:  []*console.Alias{
			{Name: "environment:list", Hidden: true},
			{Name: "upsun:environment:list", Hidden: true},
			{Name: "cloud:environments"},
			{Name: "upsun:environments", Hidden: true},
			{Name: "environments", Hidden: true},
			{Name: "cloud:env"},
			{Name: "upsun:env", Hidden: true},
			{Name: "env", Hidden: true},
		},
		Usage:    "Get a list of environments",
		Flags:    []console.Flag{
			&console.StringFlag{Name: "columns", Aliases: []string{"c"},},
			&console.StringFlag{Name: "format", DefaultValue: "table",},
			&console.BoolFlag{Name: "no-header",},
			&console.BoolFlag{Name: "no-inactive", Aliases: []string{"I"},},
			&console.BoolFlag{Name: "pipe",},
			&console.StringFlag{Name: "project", Aliases: []string{"p"},},
			&console.StringFlag{Name: "refresh",},
			&console.BoolFlag{Name: "reverse",},
			&console.StringFlag{Name: "sort", DefaultValue: "title",},
			&console.StringFlag{Name: "type",},
		},
	},
	{
		Category: "cloud:environment",
		Name:     "logs",
		Aliases:  []*console.Alias{
			{Name: "environment:logs", Hidden: true},
			{Name: "upsun:environment:logs", Hidden: true},
			{Name: "cloud:log"},
			{Name: "upsun:log", Hidden: true},
			{Name: "log", Hidden: true},
		},
		Usage:    "Read an environment's logs",
		Flags:    []console.Flag{
			&console.StringFlag{Name: "app", Aliases: []string{"A"},},
			&console.StringFlag{Name: "environment", Aliases: []string{"e"},},
			&console.StringFlag{Name: "instance", Aliases: []string{"I"},},
			&console.StringFlag{Name: "lines",},
			&console.StringFlag{Name: "project", Aliases: []string{"p"},},
			&console.BoolFlag{Name: "tail",},
			&console.StringFlag{Name: "worker",},
		},
	},
	{
		Category: "cloud:environment",
		Name:     "merge",
		Aliases:  []*console.Alias{
			{Name: "environment:merge", Hidden: true},
			{Name: "upsun:environment:merge", Hidden: true},
			{Name: "cloud:merge"},
			{Name: "upsun:merge", Hidden: true},
			{Name: "merge", Hidden: true},
		},
		Usage:    "Merge an environment",
		Flags:    []console.Flag{
			&console.StringFlag{Name: "environment", Aliases: []string{"e"},},
			&console.BoolFlag{Name: "no-wait", Aliases: []string{"W"},},
			&console.StringFlag{Name: "project", Aliases: []string{"p"},},
			&console.BoolFlag{Name: "wait",},
		},
	},
	{
		Category: "cloud:environment",
		Name:     "pause",
		Aliases:  []*console.Alias{
			{Name: "environment:pause", Hidden: true},
			{Name: "upsun:environment:pause", Hidden: true},
		},
		Usage:    "Pause an environment",
		Flags:    []console.Flag{
			&console.StringFlag{Name: "environment", Aliases: []string{"e"},},
			&console.BoolFlag{Name: "no-wait", Aliases: []string{"W"},},
			&console.StringFlag{Name: "project", Aliases: []string{"p"},},
			&console.BoolFlag{Name: "wait",},
		},
	},
	{
		Category: "cloud:environment",
		Name:     "push",
		Aliases:  []*console.Alias{
			{Name: "environment:push", Hidden: true},
			{Name: "upsun:environment:push", Hidden: true},
			{Name: "cloud:push"},
			{Name: "upsun:push", Hidden: true},
			{Name: "push", Hidden: true},
			{Name: "deploy"},
			{Name: "cloud:deploy"},
			{Name: "upsun:deploy", Hidden: true},
		},
		Usage:    "Push code to an environment",
		Flags:    []console.Flag{
			&console.BoolFlag{Name: "activate",},
			&console.StringFlag{Name: "environment", Aliases: []string{"e"},},
			&console.BoolFlag{Name: "force", Aliases: []string{"f"},},
			&console.BoolFlag{Name: "force-with-lease",},
			&console.StringFlag{Name: "identity-file", Aliases: []string{"i"},},
			&console.BoolFlag{Name: "no-clone-parent",},
			&console.BoolFlag{Name: "no-wait", Aliases: []string{"W"},},
			&console.StringFlag{Name: "parent",},
			&console.StringFlag{Name: "project", Aliases: []string{"p"},},
			&console.BoolFlag{Name: "set-upstream", Aliases: []string{"u"},},
			&console.StringFlag{Name: "target",},
			&console.StringFlag{Name: "type",},
			&console.BoolFlag{Name: "wait",},
		},
	},
	{
		Category: "cloud:environment",
		Name:     "redeploy",
		Aliases:  []*console.Alias{
			{Name: "environment:redeploy", Hidden: true},
			{Name: "upsun:environment:redeploy", Hidden: true},
			{Name: "cloud:redeploy"},
			{Name: "upsun:redeploy", Hidden: true},
			{Name: "redeploy", Hidden: true},
		},
		Usage:    "Redeploy an environment",
		Flags:    []console.Flag{
			&console.StringFlag{Name: "environment", Aliases: []string{"e"},},
			&console.BoolFlag{Name: "no-wait", Aliases: []string{"W"},},
			&console.StringFlag{Name: "project", Aliases: []string{"p"},},
			&console.BoolFlag{Name: "wait",},
		},
	},
	{
		Category: "cloud:environment",
		Name:     "relationships",
		Aliases:  []*console.Alias{
			{Name: "environment:relationships", Hidden: true},
			{Name: "upsun:environment:relationships", Hidden: true},
			{Name: "cloud:relationships"},
			{Name: "upsun:relationships", Hidden: true},
			{Name: "relationships", Hidden: true},
			{Name: "cloud:rel"},
			{Name: "upsun:rel", Hidden: true},
			{Name: "rel", Hidden: true},
		},
		Usage:    "Show an environment's relationships",
		Flags:    []console.Flag{
			&console.StringFlag{Name: "app", Aliases: []string{"A"},},
			&console.StringFlag{Name: "environment", Aliases: []string{"e"},},
			&console.StringFlag{Name: "identity-file", Aliases: []string{"i"},},
			&console.StringFlag{Name: "project", Aliases: []string{"p"},},
			&console.StringFlag{Name: "property", Aliases: []string{"P"},},
			&console.BoolFlag{Name: "refresh",},
		},
	},
	{
		Category: "cloud:environment",
		Name:     "resume",
		Aliases:  []*console.Alias{
			{Name: "environment:resume", Hidden: true},
			{Name: "upsun:environment:resume", Hidden: true},
		},
		Usage:    "Resume a paused environment",
		Flags:    []console.Flag{
			&console.StringFlag{Name: "environment", Aliases: []string{"e"},},
			&console.BoolFlag{Name: "no-wait", Aliases: []string{"W"},},
			&console.StringFlag{Name: "project", Aliases: []string{"p"},},
			&console.BoolFlag{Name: "wait",},
		},
	},
	{
		Category: "cloud:environment",
		Name:     "scp",
		Aliases:  []*console.Alias{
			{Name: "environment:scp", Hidden: true},
			{Name: "upsun:environment:scp", Hidden: true},
			{Name: "cloud:scp"},
			{Name: "upsun:scp", Hidden: true},
			{Name: "scp", Hidden: true},
		},
		Usage:    "Copy files to and from an environment using scp",
		Flags:    []console.Flag{
			&console.StringFlag{Name: "app", Aliases: []string{"A"},},
			&console.StringFlag{Name: "environment", Aliases: []string{"e"},},
			&console.StringFlag{Name: "identity-file", Aliases: []string{"i"},},
			&console.StringFlag{Name: "instance", Aliases: []string{"I"},},
			&console.StringFlag{Name: "project", Aliases: []string{"p"},},
			&console.BoolFlag{Name: "recursive", Aliases: []string{"r"},},
			&console.StringFlag{Name: "worker",},
		},
	},
	{
		Category: "cloud:environment",
		Name:     "set-remote",
		Aliases:  []*console.Alias{
			{Name: "environment:set-remote", Hidden: true},
			{Name: "upsun:environment:set-remote", Hidden: true},
		},
		Usage:    "Set the remote environment to map to a branch",
		Hidden:   console.Hide,
	},
	{
		Category: "cloud:environment",
		Name:     "ssh",
		Aliases:  []*console.Alias{
			{Name: "environment:ssh", Hidden: true},
			{Name: "upsun:environment:ssh", Hidden: true},
			{Name: "cloud:ssh"},
			{Name: "upsun:ssh", Hidden: true},
			{Name: "ssh", Hidden: true},
		},
		Usage:    "SSH to the current environment",
		Flags:    []console.Flag{
			&console.BoolFlag{Name: "all",},
			&console.StringFlag{Name: "app", Aliases: []string{"A"},},
			&console.StringFlag{Name: "environment", Aliases: []string{"e"},},
			&console.StringFlag{Name: "identity-file", Aliases: []string{"i"},},
			&console.StringFlag{Name: "instance", Aliases: []string{"I"},},
			&console.BoolFlag{Name: "pipe",},
			&console.StringFlag{Name: "project", Aliases: []string{"p"},},
			&console.StringFlag{Name: "worker",},
		},
	},
	{
		Category: "cloud:environment",
		Name:     "synchronize",
		Aliases:  []*console.Alias{
			{Name: "environment:synchronize", Hidden: true},
			{Name: "upsun:environment:synchronize", Hidden: true},
			{Name: "cloud:sync"},
			{Name: "upsun:sync", Hidden: true},
			{Name: "sync", Hidden: true},
		},
		Usage:    "Synchronize an environment's code and/or data from its parent",
		Flags:    []console.Flag{
			&console.StringFlag{Name: "environment", Aliases: []string{"e"},},
			&console.BoolFlag{Name: "no-wait", Aliases: []string{"W"},},
			&console.StringFlag{Name: "project", Aliases: []string{"p"},},
			&console.BoolFlag{Name: "rebase",},
			&console.BoolFlag{Name: "wait",},
		},
	},
	{
		Category: "cloud:environment",
		Name:     "url",
		Aliases:  []*console.Alias{
			{Name: "environment:url", Hidden: true},
			{Name: "upsun:environment:url", Hidden: true},
			{Name: "cloud:url"},
			{Name: "upsun:url", Hidden: true},
			{Name: "url", Hidden: true},
		},
		Usage:    "Get the public URLs of an environment",
		Flags:    []console.Flag{
			&console.StringFlag{Name: "browser",},
			&console.StringFlag{Name: "environment", Aliases: []string{"e"},},
			&console.BoolFlag{Name: "pipe",},
			&console.BoolFlag{Name: "primary", Aliases: []string{"1"},},
			&console.StringFlag{Name: "project", Aliases: []string{"p"},},
		},
	},
	{
		Category: "cloud:environment",
		Name:     "xdebug",
		Aliases:  []*console.Alias{
			{Name: "environment:xdebug", Hidden: true},
			{Name: "upsun:environment:xdebug", Hidden: true},
			{Name: "cloud:xdebug"},
			{Name: "upsun:xdebug", Hidden: true},
			{Name: "xdebug", Hidden: true},
		},
		Usage:    "Open a tunnel to Xdebug on the environment",
		Flags:    []console.Flag{
			&console.StringFlag{Name: "app", Aliases: []string{"A"},},
			&console.StringFlag{Name: "environment", Aliases: []string{"e"},},
			&console.StringFlag{Name: "identity-file", Aliases: []string{"i"},},
			&console.StringFlag{Name: "instance", Aliases: []string{"I"},},
			&console.StringFlag{Name: "port",},
			&console.StringFlag{Name: "project", Aliases: []string{"p"},},
			&console.StringFlag{Name: "worker",},
		},
	},
	{
		Category: "cloud:integration",
		Name:     "activity:get",
		Aliases:  []*console.Alias{
			{Name: "integration:activity:get", Hidden: true},
			{Name: "upsun:integration:activity:get", Hidden: true},
		},
		Usage:    "View detailed information on a single integration activity",
		Flags:    []console.Flag{
			&console.StringFlag{Name: "columns", Aliases: []string{"c"},},
			&console.StringFlag{Name: "date-fmt", DefaultValue: "c",},
			&console.StringFlag{Name: "environment", Aliases: []string{"e"},},
			&console.StringFlag{Name: "format", DefaultValue: "table",},
			&console.BoolFlag{Name: "no-header",},
			&console.StringFlag{Name: "project", Aliases: []string{"p"},},
			&console.StringFlag{Name: "property", Aliases: []string{"P"},},
		},
	},
	{
		Category: "cloud:integration",
		Name:     "activity:list",
		Aliases:  []*console.Alias{
			{Name: "integration:activity:list", Hidden: true},
			{Name: "upsun:integration:activity:list", Hidden: true},
			{Name: "cloud:int:act"},
			{Name: "upsun:int:act", Hidden: true},
			{Name: "int:act", Hidden: true},
		},
		Usage:    "Get a list of activities for an integration",
		Flags:    []console.Flag{
			&console.StringFlag{Name: "columns", Aliases: []string{"c"},},
			&console.StringFlag{Name: "date-fmt", DefaultValue: "c",},
			&console.StringFlag{Name: "environment", Aliases: []string{"e"},},
			&console.StringFlag{Name: "exclude-type", Aliases: []string{"x"},},
			&console.StringFlag{Name: "format", DefaultValue: "table",},
			&console.BoolFlag{Name: "incomplete", Aliases: []string{"i"},},
			&console.StringFlag{Name: "limit",},
			&console.BoolFlag{Name: "no-header",},
			&console.StringFlag{Name: "project", Aliases: []string{"p"},},
			&console.StringFlag{Name: "result",},
			&console.StringFlag{Name: "start",},
			&console.StringFlag{Name: "state",},
			&console.StringFlag{Name: "type",},
		},
	},
	{
		Category: "cloud:integration",
		Name:     "activity:log",
		Aliases:  []*console.Alias{
			{Name: "integration:activity:log", Hidden: true},
			{Name: "upsun:integration:activity:log", Hidden: true},
		},
		Usage:    "Display the log for an integration activity",
		Flags:    []console.Flag{
			&console.StringFlag{Name: "date-fmt", DefaultValue: "c",},
			&console.StringFlag{Name: "environment", Aliases: []string{"e"},},
			&console.StringFlag{Name: "project", Aliases: []string{"p"},},
			&console.BoolFlag{Name: "timestamps", Aliases: []string{"t"},},
		},
	},
	{
		Category: "cloud:integration",
		Name:     "add",
		Aliases:  []*console.Alias{
			{Name: "integration:add", Hidden: true},
			{Name: "upsun:integration:add", Hidden: true},
		},
		Usage:    "Add an integration to the project",
		Flags:    []console.Flag{
			&console.StringFlag{Name: "auth-mode", DefaultValue: "prefix",},
			&console.StringFlag{Name: "auth-token",},
			&console.StringFlag{Name: "base-url",},
			&console.StringFlag{Name: "bitbucket-url",},
			&console.BoolFlag{Name: "build-draft-pull-requests", DefaultValue: true,},
			&console.BoolFlag{Name: "build-merge-requests", DefaultValue: true,},
			&console.BoolFlag{Name: "build-pull-requests", DefaultValue: true,},
			&console.BoolFlag{Name: "build-pull-requests-post-merge",},
			&console.BoolFlag{Name: "build-wip-merge-requests", DefaultValue: true,},
			&console.StringFlag{Name: "category",},
			&console.StringFlag{Name: "channel",},
			&console.StringFlag{Name: "environments",},
			&console.StringFlag{Name: "events",},
			&console.StringFlag{Name: "excluded-environments",},
			&console.StringFlag{Name: "facility",},
			&console.BoolFlag{Name: "fetch-branches", DefaultValue: true,},
			&console.StringFlag{Name: "file",},
			&console.StringFlag{Name: "from-address",},
			&console.StringFlag{Name: "header",},
			&console.StringFlag{Name: "index",},
			&console.StringFlag{Name: "key",},
			&console.StringFlag{Name: "license-key",},
			&console.BoolFlag{Name: "merge-requests-clone-parent-data", DefaultValue: true,},
			&console.StringFlag{Name: "message-format", DefaultValue: "rfc5424",},
			&console.BoolFlag{Name: "no-wait", Aliases: []string{"W"},},
			&console.StringFlag{Name: "project", Aliases: []string{"p"},},
			&console.StringFlag{Name: "protocol", DefaultValue: "tls",},
			&console.BoolFlag{Name: "prune-branches", DefaultValue: true,},
			&console.BoolFlag{Name: "pull-requests-clone-parent-data", DefaultValue: true,},
			&console.StringFlag{Name: "recipients",},
			&console.StringFlag{Name: "repository",},
			&console.StringFlag{Name: "resources-init", DefaultValue: "parent",},
			&console.BoolFlag{Name: "resync-pull-requests",},
			&console.StringFlag{Name: "routing-key",},
			&console.StringFlag{Name: "secret",},
			&console.StringFlag{Name: "server-project",},
			&console.StringFlag{Name: "shared-key",},
			&console.StringFlag{Name: "sourcetype",},
			&console.StringFlag{Name: "states",},
			&console.StringFlag{Name: "syslog-host",},
			&console.StringFlag{Name: "syslog-port",},
			&console.StringFlag{Name: "token",},
			&console.StringFlag{Name: "type",},
			&console.StringFlag{Name: "url",},
			&console.StringFlag{Name: "username",},
			&console.BoolFlag{Name: "verify-tls", DefaultValue: true,},
			&console.BoolFlag{Name: "wait",},
		},
	},
	{
		Category: "cloud:integration",
		Name:     "delete",
		Aliases:  []*console.Alias{
			{Name: "integration:delete", Hidden: true},
			{Name: "upsun:integration:delete", Hidden: true},
		},
		Usage:    "Delete an integration from a project",
		Flags:    []console.Flag{
			&console.BoolFlag{Name: "no-wait", Aliases: []string{"W"},},
			&console.StringFlag{Name: "project", Aliases: []string{"p"},},
			&console.BoolFlag{Name: "wait",},
		},
	},
	{
		Category: "cloud:integration",
		Name:     "get",
		Aliases:  []*console.Alias{
			{Name: "integration:get", Hidden: true},
			{Name: "upsun:integration:get", Hidden: true},
		},
		Usage:    "View details of an integration",
		Flags:    []console.Flag{
			&console.StringFlag{Name: "columns", Aliases: []string{"c"},},
			&console.StringFlag{Name: "format", DefaultValue: "table",},
			&console.BoolFlag{Name: "no-header",},
			&console.StringFlag{Name: "project", Aliases: []string{"p"},},
			&console.StringFlag{Name: "property", Aliases: []string{"P"},},
		},
	},
	{
		Category: "cloud:integration",
		Name:     "list",
		Aliases:  []*console.Alias{
			{Name: "integration:list", Hidden: true},
			{Name: "upsun:integration:list", Hidden: true},
			{Name: "cloud:integrations"},
			{Name: "upsun:integrations", Hidden: true},
			{Name: "integrations", Hidden: true},
		},
		Usage:    "View a list of project integration(s)",
		Flags:    []console.Flag{
			&console.StringFlag{Name: "columns", Aliases: []string{"c"},},
			&console.StringFlag{Name: "format", DefaultValue: "table",},
			&console.BoolFlag{Name: "no-header",},
			&console.StringFlag{Name: "project", Aliases: []string{"p"},},
		},
	},
	{
		Category: "cloud:integration",
		Name:     "update",
		Aliases:  []*console.Alias{
			{Name: "integration:update", Hidden: true},
			{Name: "upsun:integration:update", Hidden: true},
		},
		Usage:    "Update an integration",
		Flags:    []console.Flag{
			&console.StringFlag{Name: "auth-mode", DefaultValue: "prefix",},
			&console.StringFlag{Name: "auth-token",},
			&console.StringFlag{Name: "base-url",},
			&console.StringFlag{Name: "bitbucket-url",},
			&console.BoolFlag{Name: "build-draft-pull-requests", DefaultValue: true,},
			&console.BoolFlag{Name: "build-merge-requests", DefaultValue: true,},
			&console.BoolFlag{Name: "build-pull-requests", DefaultValue: true,},
			&console.BoolFlag{Name: "build-pull-requests-post-merge",},
			&console.BoolFlag{Name: "build-wip-merge-requests", DefaultValue: true,},
			&console.StringFlag{Name: "category",},
			&console.StringFlag{Name: "channel",},
			&console.StringFlag{Name: "environments",},
			&console.StringFlag{Name: "events",},
			&console.StringFlag{Name: "excluded-environments",},
			&console.StringFlag{Name: "facility",},
			&console.BoolFlag{Name: "fetch-branches", DefaultValue: true,},
			&console.StringFlag{Name: "file",},
			&console.StringFlag{Name: "from-address",},
			&console.StringFlag{Name: "header",},
			&console.StringFlag{Name: "index",},
			&console.StringFlag{Name: "key",},
			&console.StringFlag{Name: "license-key",},
			&console.BoolFlag{Name: "merge-requests-clone-parent-data", DefaultValue: true,},
			&console.StringFlag{Name: "message-format", DefaultValue: "rfc5424",},
			&console.BoolFlag{Name: "no-wait", Aliases: []string{"W"},},
			&console.StringFlag{Name: "project", Aliases: []string{"p"},},
			&console.StringFlag{Name: "protocol", DefaultValue: "tls",},
			&console.BoolFlag{Name: "prune-branches", DefaultValue: true,},
			&console.BoolFlag{Name: "pull-requests-clone-parent-data", DefaultValue: true,},
			&console.StringFlag{Name: "recipients",},
			&console.StringFlag{Name: "repository",},
			&console.StringFlag{Name: "resources-init", DefaultValue: "parent",},
			&console.BoolFlag{Name: "resync-pull-requests",},
			&console.StringFlag{Name: "routing-key",},
			&console.StringFlag{Name: "secret",},
			&console.StringFlag{Name: "server-project",},
			&console.StringFlag{Name: "shared-key",},
			&console.StringFlag{Name: "sourcetype",},
			&console.StringFlag{Name: "states",},
			&console.StringFlag{Name: "syslog-host",},
			&console.StringFlag{Name: "syslog-port",},
			&console.StringFlag{Name: "token",},
			&console.StringFlag{Name: "type",},
			&console.StringFlag{Name: "url",},
			&console.StringFlag{Name: "username",},
			&console.BoolFlag{Name: "verify-tls", DefaultValue: true,},
			&console.BoolFlag{Name: "wait",},
		},
	},
	{
		Category: "cloud:integration",
		Name:     "validate",
		Aliases:  []*console.Alias{
			{Name: "integration:validate", Hidden: true},
			{Name: "upsun:integration:validate", Hidden: true},
		},
		Usage:    "Validate an existing integration",
		Flags:    []console.Flag{
			&console.StringFlag{Name: "project", Aliases: []string{"p"},},
		},
	},
	{
		Category: "cloud:metrics",
		Name:     "all",
		Aliases:  []*console.Alias{
			{Name: "metrics:all", Hidden: true},
			{Name: "upsun:metrics:all", Hidden: true},
			{Name: "cloud:metrics"},
			{Name: "upsun:metrics", Hidden: true},
			{Name: "metrics", Hidden: true},
			{Name: "cloud:met"},
			{Name: "upsun:met", Hidden: true},
			{Name: "met", Hidden: true},
		},
		Usage:    " BETA  Show CPU, disk and memory metrics for an environment",
		Flags:    []console.Flag{
			&console.BoolFlag{Name: "bytes", Aliases: []string{"B"},},
			&console.StringFlag{Name: "columns", Aliases: []string{"c"},},
			&console.StringFlag{Name: "date-fmt", DefaultValue: "c",},
			&console.StringFlag{Name: "environment", Aliases: []string{"e"},},
			&console.StringFlag{Name: "format", DefaultValue: "table",},
			&console.StringFlag{Name: "interval", Aliases: []string{"i"},},
			&console.BoolFlag{Name: "latest", Aliases: []string{"1"},},
			&console.BoolFlag{Name: "no-header",},
			&console.StringFlag{Name: "project", Aliases: []string{"p"},},
			&console.StringFlag{Name: "range", Aliases: []string{"r"},},
			&console.StringFlag{Name: "service", Aliases: []string{"s"},},
			&console.StringFlag{Name: "to",},
			&console.StringFlag{Name: "type",},
		},
	},
	{
		Category: "cloud:metrics",
		Name:     "cpu",
		Aliases:  []*console.Alias{
			{Name: "metrics:cpu", Hidden: true},
			{Name: "upsun:metrics:cpu", Hidden: true},
			{Name: "cloud:cpu"},
			{Name: "upsun:cpu", Hidden: true},
			{Name: "cpu", Hidden: true},
		},
		Usage:    " BETA  Show CPU usage of an environment",
		Flags:    []console.Flag{
			&console.StringFlag{Name: "columns", Aliases: []string{"c"},},
			&console.StringFlag{Name: "date-fmt", DefaultValue: "c",},
			&console.StringFlag{Name: "environment", Aliases: []string{"e"},},
			&console.StringFlag{Name: "format", DefaultValue: "table",},
			&console.StringFlag{Name: "interval", Aliases: []string{"i"},},
			&console.BoolFlag{Name: "latest", Aliases: []string{"1"},},
			&console.BoolFlag{Name: "no-header",},
			&console.StringFlag{Name: "project", Aliases: []string{"p"},},
			&console.StringFlag{Name: "range", Aliases: []string{"r"},},
			&console.StringFlag{Name: "service", Aliases: []string{"s"},},
			&console.StringFlag{Name: "to",},
			&console.StringFlag{Name: "type",},
		},
	},
	{
		Category: "cloud:metrics",
		Name:     "curl",
		Aliases:  []*console.Alias{
			{Name: "metrics:curl", Hidden: true},
			{Name: "upsun:metrics:curl", Hidden: true},
		},
		Usage:    "Run an authenticated cURL request on an environment's metrics API",
		Hidden:   console.Hide,
		Flags:    []console.Flag{
			&console.StringFlag{Name: "data", Aliases: []string{"d"},},
			&console.BoolFlag{Name: "disable-compression",},
			&console.BoolFlag{Name: "enable-glob",},
			&console.StringFlag{Name: "environment", Aliases: []string{"e"},},
			&console.BoolFlag{Name: "fail", Aliases: []string{"f"},},
			&console.BoolFlag{Name: "head", Aliases: []string{"I"},},
			&console.StringFlag{Name: "header", Aliases: []string{"H"},},
			&console.BoolFlag{Name: "include", Aliases: []string{"i"},},
			&console.StringFlag{Name: "json",},
			&console.StringFlag{Name: "project", Aliases: []string{"p"},},
			&console.StringFlag{Name: "request", Aliases: []string{"X"},},
		},
	},
	{
		Category: "cloud:metrics",
		Name:     "disk-usage",
		Aliases:  []*console.Alias{
			{Name: "metrics:disk-usage", Hidden: true},
			{Name: "upsun:metrics:disk-usage", Hidden: true},
			{Name: "cloud:disk"},
			{Name: "upsun:disk", Hidden: true},
			{Name: "disk", Hidden: true},
		},
		Usage:    "Show disk usage of an environment",
		Flags:    []console.Flag{
			&console.BoolFlag{Name: "bytes", Aliases: []string{"B"},},
			&console.StringFlag{Name: "columns", Aliases: []string{"c"},},
			&console.StringFlag{Name: "date-fmt", DefaultValue: "c",},
			&console.StringFlag{Name: "environment", Aliases: []string{"e"},},
			&console.StringFlag{Name: "format", DefaultValue: "table",},
			&console.StringFlag{Name: "interval", Aliases: []string{"i"},},
			&console.BoolFlag{Name: "latest", Aliases: []string{"1"},},
			&console.BoolFlag{Name: "no-header",},
			&console.StringFlag{Name: "project", Aliases: []string{"p"},},
			&console.StringFlag{Name: "range", Aliases: []string{"r"},},
			&console.StringFlag{Name: "service", Aliases: []string{"s"},},
			&console.BoolFlag{Name: "tmp",},
			&console.StringFlag{Name: "to",},
			&console.StringFlag{Name: "type",},
		},
	},
	{
		Category: "cloud:metrics",
		Name:     "memory",
		Aliases:  []*console.Alias{
			{Name: "metrics:memory", Hidden: true},
			{Name: "upsun:metrics:memory", Hidden: true},
			{Name: "cloud:mem"},
			{Name: "upsun:mem", Hidden: true},
			{Name: "mem", Hidden: true},
			{Name: "cloud:memory"},
			{Name: "upsun:memory", Hidden: true},
			{Name: "memory", Hidden: true},
		},
		Usage:    " BETA  Show memory usage of an environment",
		Flags:    []console.Flag{
			&console.BoolFlag{Name: "bytes", Aliases: []string{"B"},},
			&console.StringFlag{Name: "columns", Aliases: []string{"c"},},
			&console.StringFlag{Name: "date-fmt", DefaultValue: "c",},
			&console.StringFlag{Name: "environment", Aliases: []string{"e"},},
			&console.StringFlag{Name: "format", DefaultValue: "table",},
			&console.StringFlag{Name: "interval", Aliases: []string{"i"},},
			&console.BoolFlag{Name: "latest", Aliases: []string{"1"},},
			&console.BoolFlag{Name: "no-header",},
			&console.StringFlag{Name: "project", Aliases: []string{"p"},},
			&console.StringFlag{Name: "range", Aliases: []string{"r"},},
			&console.StringFlag{Name: "service", Aliases: []string{"s"},},
			&console.StringFlag{Name: "to",},
			&console.StringFlag{Name: "type",},
		},
	},
	{
		Category: "cloud:mount",
		Name:     "download",
		Aliases:  []*console.Alias{
			{Name: "mount:download", Hidden: true},
			{Name: "upsun:mount:download", Hidden: true},
		},
		Usage:    "Download files from a mount, using rsync",
		Flags:    []console.Flag{
			&console.BoolFlag{Name: "all", Aliases: []string{"a"},},
			&console.StringFlag{Name: "app", Aliases: []string{"A"},},
			&console.BoolFlag{Name: "delete",},
			&console.StringFlag{Name: "environment", Aliases: []string{"e"},},
			&console.StringFlag{Name: "exclude",},
			&console.StringFlag{Name: "identity-file", Aliases: []string{"i"},},
			&console.StringFlag{Name: "include",},
			&console.StringFlag{Name: "instance", Aliases: []string{"I"},},
			&console.StringFlag{Name: "mount", Aliases: []string{"m"},},
			&console.StringFlag{Name: "project", Aliases: []string{"p"},},
			&console.BoolFlag{Name: "refresh",},
			&console.BoolFlag{Name: "source-path",},
			&console.StringFlag{Name: "target",},
			&console.StringFlag{Name: "worker",},
		},
	},
	{
		Category: "cloud:mount",
		Name:     "list",
		Aliases:  []*console.Alias{
			{Name: "mount:list", Hidden: true},
			{Name: "upsun:mount:list", Hidden: true},
			{Name: "cloud:mounts"},
			{Name: "upsun:mounts", Hidden: true},
			{Name: "mounts", Hidden: true},
		},
		Usage:    "Get a list of mounts",
		Flags:    []console.Flag{
			&console.StringFlag{Name: "app", Aliases: []string{"A"},},
			&console.StringFlag{Name: "columns", Aliases: []string{"c"},},
			&console.StringFlag{Name: "environment", Aliases: []string{"e"},},
			&console.StringFlag{Name: "format", DefaultValue: "table",},
			&console.StringFlag{Name: "instance", Aliases: []string{"I"},},
			&console.BoolFlag{Name: "no-header",},
			&console.BoolFlag{Name: "paths",},
			&console.StringFlag{Name: "project", Aliases: []string{"p"},},
			&console.BoolFlag{Name: "refresh",},
			&console.StringFlag{Name: "worker",},
		},
	},
	{
		Category: "cloud:mount",
		Name:     "size",
		Aliases:  []*console.Alias{
			{Name: "mount:size", Hidden: true},
			{Name: "upsun:mount:size", Hidden: true},
		},
		Usage:    "Check the disk usage of mounts",
		Flags:    []console.Flag{
			&console.StringFlag{Name: "app", Aliases: []string{"A"},},
			&console.BoolFlag{Name: "bytes", Aliases: []string{"B"},},
			&console.StringFlag{Name: "columns", Aliases: []string{"c"},},
			&console.StringFlag{Name: "environment", Aliases: []string{"e"},},
			&console.StringFlag{Name: "format", DefaultValue: "table",},
			&console.StringFlag{Name: "identity-file", Aliases: []string{"i"},},
			&console.StringFlag{Name: "instance", Aliases: []string{"I"},},
			&console.BoolFlag{Name: "no-header",},
			&console.StringFlag{Name: "project", Aliases: []string{"p"},},
			&console.BoolFlag{Name: "refresh",},
			&console.StringFlag{Name: "worker",},
		},
	},
	{
		Category: "cloud:mount",
		Name:     "upload",
		Aliases:  []*console.Alias{
			{Name: "mount:upload", Hidden: true},
			{Name: "upsun:mount:upload", Hidden: true},
		},
		Usage:    "Upload files to a mount, using rsync",
		Flags:    []console.Flag{
			&console.StringFlag{Name: "app", Aliases: []string{"A"},},
			&console.BoolFlag{Name: "delete",},
			&console.StringFlag{Name: "environment", Aliases: []string{"e"},},
			&console.StringFlag{Name: "exclude",},
			&console.StringFlag{Name: "identity-file", Aliases: []string{"i"},},
			&console.StringFlag{Name: "include",},
			&console.StringFlag{Name: "instance", Aliases: []string{"I"},},
			&console.StringFlag{Name: "mount", Aliases: []string{"m"},},
			&console.StringFlag{Name: "project", Aliases: []string{"p"},},
			&console.BoolFlag{Name: "refresh",},
			&console.StringFlag{Name: "source",},
			&console.StringFlag{Name: "worker",},
		},
	},
	{
		Category: "cloud:operation",
		Name:     "list",
		Aliases:  []*console.Alias{
			{Name: "operation:list", Hidden: true},
			{Name: "upsun:operation:list", Hidden: true},
			{Name: "cloud:ops"},
			{Name: "upsun:ops", Hidden: true},
			{Name: "ops", Hidden: true},
		},
		Usage:    " BETA  List runtime operations on an environment",
		Flags:    []console.Flag{
			&console.StringFlag{Name: "app", Aliases: []string{"A"},},
			&console.StringFlag{Name: "columns", Aliases: []string{"c"},},
			&console.StringFlag{Name: "environment", Aliases: []string{"e"},},
			&console.StringFlag{Name: "format", DefaultValue: "table",},
			&console.BoolFlag{Name: "full",},
			&console.BoolFlag{Name: "no-header",},
			&console.StringFlag{Name: "project", Aliases: []string{"p"},},
			&console.StringFlag{Name: "worker",},
		},
	},
	{
		Category: "cloud:operation",
		Name:     "run",
		Aliases:  []*console.Alias{
			{Name: "operation:run", Hidden: true},
			{Name: "upsun:operation:run", Hidden: true},
		},
		Usage:    " BETA  Run an operation on the environment",
		Flags:    []console.Flag{
			&console.StringFlag{Name: "app", Aliases: []string{"A"},},
			&console.StringFlag{Name: "environment", Aliases: []string{"e"},},
			&console.BoolFlag{Name: "no-wait", Aliases: []string{"W"},},
			&console.StringFlag{Name: "project", Aliases: []string{"p"},},
			&console.BoolFlag{Name: "wait",},
			&console.StringFlag{Name: "worker",},
		},
	},
	{
		Category: "cloud:organization",
		Name:     "billing:address",
		Aliases:  []*console.Alias{
			{Name: "organization:billing:address", Hidden: true},
			{Name: "upsun:organization:billing:address", Hidden: true},
		},
		Usage:    "View or change an organization's billing address",
		Flags:    []console.Flag{
			&console.StringFlag{Name: "columns", Aliases: []string{"c"},},
			&console.StringFlag{Name: "date-fmt", DefaultValue: "c",},
			&console.StringFlag{Name: "format", DefaultValue: "table",},
			&console.BoolFlag{Name: "no-header",},
			&console.StringFlag{Name: "org", Aliases: []string{"o"},},
			&console.StringFlag{Name: "project", Aliases: []string{"p"},},
		},
	},
	{
		Category: "cloud:organization",
		Name:     "billing:profile",
		Aliases:  []*console.Alias{
			{Name: "organization:billing:profile", Hidden: true},
			{Name: "upsun:organization:billing:profile", Hidden: true},
		},
		Usage:    "View or change an organization's billing profile",
		Flags:    []console.Flag{
			&console.StringFlag{Name: "columns", Aliases: []string{"c"},},
			&console.StringFlag{Name: "date-fmt", DefaultValue: "c",},
			&console.StringFlag{Name: "format", DefaultValue: "table",},
			&console.BoolFlag{Name: "no-header",},
			&console.StringFlag{Name: "org", Aliases: []string{"o"},},
			&console.StringFlag{Name: "project", Aliases: []string{"p"},},
		},
	},
	{
		Category: "cloud:organization",
		Name:     "create",
		Aliases:  []*console.Alias{
			{Name: "organization:create", Hidden: true},
			{Name: "upsun:organization:create", Hidden: true},
		},
		Usage:    "Create a new organization",
		Flags:    []console.Flag{
			&console.StringFlag{Name: "country",},
			&console.StringFlag{Name: "label",},
			&console.StringFlag{Name: "name",},
		},
	},
	{
		Category: "cloud:organization",
		Name:     "curl",
		Aliases:  []*console.Alias{
			{Name: "organization:curl", Hidden: true},
			{Name: "upsun:organization:curl", Hidden: true},
		},
		Usage:    "Run an authenticated cURL request on an organization's API",
		Hidden:   console.Hide,
		Flags:    []console.Flag{
			&console.StringFlag{Name: "data", Aliases: []string{"d"},},
			&console.BoolFlag{Name: "disable-compression",},
			&console.BoolFlag{Name: "enable-glob",},
			&console.BoolFlag{Name: "fail", Aliases: []string{"f"},},
			&console.BoolFlag{Name: "head", Aliases: []string{"I"},},
			&console.StringFlag{Name: "header", Aliases: []string{"H"},},
			&console.BoolFlag{Name: "include", Aliases: []string{"i"},},
			&console.StringFlag{Name: "json",},
			&console.StringFlag{Name: "org", Aliases: []string{"o"},},
			&console.StringFlag{Name: "project", Aliases: []string{"p"},},
			&console.StringFlag{Name: "request", Aliases: []string{"X"},},
		},
	},
	{
		Category: "cloud:organization",
		Name:     "delete",
		Aliases:  []*console.Alias{
			{Name: "organization:delete", Hidden: true},
			{Name: "upsun:organization:delete", Hidden: true},
		},
		Usage:    "Delete an organization",
		Flags:    []console.Flag{
			&console.StringFlag{Name: "org", Aliases: []string{"o"},},
			&console.StringFlag{Name: "project", Aliases: []string{"p"},},
		},
	},
	{
		Category: "cloud:organization",
		Name:     "info",
		Aliases:  []*console.Alias{
			{Name: "organization:info", Hidden: true},
			{Name: "upsun:organization:info", Hidden: true},
		},
		Usage:    "View or change organization details",
		Flags:    []console.Flag{
			&console.StringFlag{Name: "columns", Aliases: []string{"c"},},
			&console.StringFlag{Name: "date-fmt", DefaultValue: "c",},
			&console.StringFlag{Name: "format", DefaultValue: "table",},
			&console.BoolFlag{Name: "no-header",},
			&console.StringFlag{Name: "org", Aliases: []string{"o"},},
			&console.StringFlag{Name: "project", Aliases: []string{"p"},},
		},
	},
	{
		Category: "cloud:organization",
		Name:     "list",
		Aliases:  []*console.Alias{
			{Name: "organization:list", Hidden: true},
			{Name: "upsun:organization:list", Hidden: true},
			{Name: "cloud:orgs"},
			{Name: "upsun:orgs", Hidden: true},
			{Name: "orgs", Hidden: true},
			{Name: "cloud:organizations"},
			{Name: "upsun:organizations", Hidden: true},
			{Name: "organizations", Hidden: true},
		},
		Usage:    "List organizations",
		Flags:    []console.Flag{
			&console.StringFlag{Name: "columns", Aliases: []string{"c"},},
			&console.StringFlag{Name: "format", DefaultValue: "table",},
			&console.BoolFlag{Name: "my",},
			&console.BoolFlag{Name: "no-header",},
			&console.BoolFlag{Name: "reverse",},
			&console.StringFlag{Name: "sort",},
		},
	},
	{
		Category: "cloud:organization",
		Name:     "subscription:list",
		Aliases:  []*console.Alias{
			{Name: "organization:subscription:list", Hidden: true},
			{Name: "upsun:organization:subscription:list", Hidden: true},
			{Name: "cloud:org:subs"},
			{Name: "upsun:org:subs", Hidden: true},
			{Name: "org:subs", Hidden: true},
		},
		Usage:    "List subscriptions within an organization",
		Flags:    []console.Flag{
			&console.StringFlag{Name: "columns",},
			&console.StringFlag{Name: "count", Aliases: []string{"c"},},
			&console.StringFlag{Name: "format", DefaultValue: "table",},
			&console.BoolFlag{Name: "no-header",},
			&console.StringFlag{Name: "org", Aliases: []string{"o"},},
			&console.StringFlag{Name: "page",},
			&console.StringFlag{Name: "project", Aliases: []string{"p"},},
		},
	},
	{
		Category: "cloud:organization",
		Name:     "user:add",
		Aliases:  []*console.Alias{
			{Name: "organization:user:add", Hidden: true},
			{Name: "upsun:organization:user:add", Hidden: true},
		},
		Usage:    "Invite a user to an organization",
		Flags:    []console.Flag{
			&console.StringFlag{Name: "org", Aliases: []string{"o"},},
			&console.StringFlag{Name: "permission",},
			&console.StringFlag{Name: "project", Aliases: []string{"p"},},
		},
	},
	{
		Category: "cloud:organization",
		Name:     "user:delete",
		Aliases:  []*console.Alias{
			{Name: "organization:user:delete", Hidden: true},
			{Name: "upsun:organization:user:delete", Hidden: true},
		},
		Usage:    "Remove a user from an organization",
		Flags:    []console.Flag{
			&console.StringFlag{Name: "org", Aliases: []string{"o"},},
			&console.StringFlag{Name: "project", Aliases: []string{"p"},},
		},
	},
	{
		Category: "cloud:organization",
		Name:     "user:get",
		Aliases:  []*console.Alias{
			{Name: "organization:user:get", Hidden: true},
			{Name: "upsun:organization:user:get", Hidden: true},
		},
		Usage:    "View an organization user",
		Flags:    []console.Flag{
			&console.StringFlag{Name: "columns", Aliases: []string{"c"},},
			&console.StringFlag{Name: "date-fmt", DefaultValue: "c",},
			&console.StringFlag{Name: "format", DefaultValue: "table",},
			&console.BoolFlag{Name: "no-header",},
			&console.StringFlag{Name: "org", Aliases: []string{"o"},},
			&console.StringFlag{Name: "project", Aliases: []string{"p"},},
			&console.StringFlag{Name: "property", Aliases: []string{"P"},},
		},
	},
	{
		Category: "cloud:organization",
		Name:     "user:list",
		Aliases:  []*console.Alias{
			{Name: "organization:user:list", Hidden: true},
			{Name: "upsun:organization:user:list", Hidden: true},
			{Name: "cloud:org:users"},
			{Name: "upsun:org:users", Hidden: true},
			{Name: "org:users", Hidden: true},
		},
		Usage:    "List organization users",
		Flags:    []console.Flag{
			&console.StringFlag{Name: "columns", Aliases: []string{"c"},},
			&console.StringFlag{Name: "date-fmt", DefaultValue: "c",},
			&console.StringFlag{Name: "format", DefaultValue: "table",},
			&console.BoolFlag{Name: "no-header",},
			&console.StringFlag{Name: "org", Aliases: []string{"o"},},
			&console.StringFlag{Name: "project", Aliases: []string{"p"},},
		},
	},
	{
		Category: "cloud:organization",
		Name:     "user:projects",
		Aliases:  []*console.Alias{
			{Name: "organization:user:projects", Hidden: true},
			{Name: "upsun:organization:user:projects", Hidden: true},
			{Name: "cloud:oups"},
			{Name: "upsun:oups", Hidden: true},
			{Name: "oups", Hidden: true},
		},
		Usage:    "List the projects a user can access",
		Flags:    []console.Flag{
			&console.StringFlag{Name: "columns", Aliases: []string{"c"},},
			&console.StringFlag{Name: "date-fmt", DefaultValue: "c",},
			&console.StringFlag{Name: "format", DefaultValue: "table",},
			&console.BoolFlag{Name: "list-all",},
			&console.BoolFlag{Name: "no-header",},
			&console.StringFlag{Name: "org", Aliases: []string{"o"},},
			&console.StringFlag{Name: "project", Aliases: []string{"p"},},
			&console.BoolFlag{Name: "reverse",},
			&console.BoolFlag{Name: "sort-granted",},
		},
	},
	{
		Category: "cloud:organization",
		Name:     "user:update",
		Aliases:  []*console.Alias{
			{Name: "organization:user:update", Hidden: true},
			{Name: "upsun:organization:user:update", Hidden: true},
		},
		Usage:    "Update an organization user",
		Flags:    []console.Flag{
			&console.StringFlag{Name: "org", Aliases: []string{"o"},},
			&console.StringFlag{Name: "permission",},
			&console.StringFlag{Name: "project", Aliases: []string{"p"},},
		},
	},
	{
		Category: "cloud:project",
		Name:     "clear-build-cache",
		Aliases:  []*console.Alias{
			{Name: "project:clear-build-cache", Hidden: true},
			{Name: "upsun:project:clear-build-cache", Hidden: true},
		},
		Usage:    "Clear a project's build cache",
		Flags:    []console.Flag{
			&console.StringFlag{Name: "project", Aliases: []string{"p"},},
		},
	},
	{
		Category: "cloud:project",
		Name:     "create",
		Aliases:  []*console.Alias{
			{Name: "project:create", Hidden: true},
			{Name: "upsun:project:create", Hidden: true},
			{Name: "cloud:create"},
			{Name: "upsun:create", Hidden: true},
			{Name: "create", Hidden: true},
		},
		Usage:    "Create a new project",
		Flags:    []console.Flag{
			&console.StringFlag{Name: "default-branch", DefaultValue: "main",},
			&console.StringFlag{Name: "environments",},
			&console.BoolFlag{Name: "no-set-remote",},
			&console.StringFlag{Name: "org", Aliases: []string{"o"},},
			&console.StringFlag{Name: "plan",},
			&console.StringFlag{Name: "project", Aliases: []string{"p"},},
			&console.StringFlag{Name: "region",},
			&console.BoolFlag{Name: "set-remote",},
			&console.StringFlag{Name: "storage",},
			&console.StringFlag{Name: "title", DefaultValue: "Untitled Project",},
		},
	},
	{
		Category: "cloud:project",
		Name:     "curl",
		Aliases:  []*console.Alias{
			{Name: "project:curl", Hidden: true},
			{Name: "upsun:project:curl", Hidden: true},
		},
		Usage:    "Run an authenticated cURL request on a project's API",
		Hidden:   console.Hide,
		Flags:    []console.Flag{
			&console.StringFlag{Name: "data", Aliases: []string{"d"},},
			&console.BoolFlag{Name: "disable-compression",},
			&console.BoolFlag{Name: "enable-glob",},
			&console.BoolFlag{Name: "fail", Aliases: []string{"f"},},
			&console.BoolFlag{Name: "head", Aliases: []string{"I"},},
			&console.StringFlag{Name: "header", Aliases: []string{"H"},},
			&console.BoolFlag{Name: "include", Aliases: []string{"i"},},
			&console.StringFlag{Name: "json",},
			&console.StringFlag{Name: "project", Aliases: []string{"p"},},
			&console.StringFlag{Name: "request", Aliases: []string{"X"},},
		},
	},
	{
		Category: "cloud:project",
		Name:     "delete",
		Aliases:  []*console.Alias{
			{Name: "project:delete", Hidden: true},
			{Name: "upsun:project:delete", Hidden: true},
		},
		Usage:    "Delete a project",
		Flags:    []console.Flag{
			&console.StringFlag{Name: "project", Aliases: []string{"p"},},
		},
	},
	{
		Category: "cloud:project",
		Name:     "get",
		Aliases:  []*console.Alias{
			{Name: "project:get", Hidden: true},
			{Name: "upsun:project:get", Hidden: true},
			{Name: "cloud:get"},
			{Name: "upsun:get", Hidden: true},
			{Name: "get", Hidden: true},
		},
		Usage:    "Clone a project locally",
		Flags:    []console.Flag{
			&console.BoolFlag{Name: "build",},
			&console.StringFlag{Name: "depth",},
			&console.StringFlag{Name: "environment", Aliases: []string{"e"},},
			&console.StringFlag{Name: "identity-file", Aliases: []string{"i"},},
			&console.StringFlag{Name: "project", Aliases: []string{"p"},},
		},
	},
	{
		Category: "cloud:project",
		Name:     "info",
		Aliases:  []*console.Alias{
			{Name: "project:info", Hidden: true},
			{Name: "upsun:project:info", Hidden: true},
		},
		Usage:    "Read or set properties for a project",
		Flags:    []console.Flag{
			&console.StringFlag{Name: "columns", Aliases: []string{"c"},},
			&console.StringFlag{Name: "date-fmt", DefaultValue: "c",},
			&console.StringFlag{Name: "format", DefaultValue: "table",},
			&console.BoolFlag{Name: "no-header",},
			&console.BoolFlag{Name: "no-wait", Aliases: []string{"W"},},
			&console.StringFlag{Name: "project", Aliases: []string{"p"},},
			&console.BoolFlag{Name: "refresh",},
			&console.BoolFlag{Name: "wait",},
		},
	},
	{
		Category: "cloud:project",
		Name:     "list",
		Aliases:  []*console.Alias{
			{Name: "project:list", Hidden: true},
			{Name: "upsun:project:list", Hidden: true},
			{Name: "cloud:projects"},
			{Name: "upsun:projects", Hidden: true},
			{Name: "projects", Hidden: true},
			{Name: "cloud:pro"},
			{Name: "upsun:pro", Hidden: true},
			{Name: "pro", Hidden: true},
		},
		Usage:    "Get a list of all active projects",
		Flags:    []console.Flag{
			&console.StringFlag{Name: "columns",},
			&console.StringFlag{Name: "count", Aliases: []string{"c"},},
			&console.StringFlag{Name: "date-fmt", DefaultValue: "c",},
			&console.StringFlag{Name: "format", DefaultValue: "table",},
			&console.BoolFlag{Name: "my",},
			&console.BoolFlag{Name: "no-header",},
			&console.StringFlag{Name: "org", Aliases: []string{"o"},},
			&console.StringFlag{Name: "page",},
			&console.BoolFlag{Name: "pipe",},
			&console.StringFlag{Name: "refresh",},
			&console.StringFlag{Name: "region",},
			&console.BoolFlag{Name: "reverse",},
			&console.StringFlag{Name: "sort", DefaultValue: "title",},
			&console.StringFlag{Name: "title",},
		},
	},
	{
		Category: "cloud:project",
		Name:     "set-remote",
		Aliases:  []*console.Alias{
			{Name: "project:set-remote", Hidden: true},
			{Name: "upsun:project:set-remote", Hidden: true},
			{Name: "cloud:set-remote"},
			{Name: "upsun:set-remote", Hidden: true},
			{Name: "set-remote", Hidden: true},
		},
		Usage:    "Set the remote project for the current Git repository",
	},
	{
		Category: "cloud:repo",
		Name:     "cat",
		Aliases:  []*console.Alias{
			{Name: "repo:cat", Hidden: true},
			{Name: "upsun:repo:cat", Hidden: true},
		},
		Usage:    "Read a file in the project repository",
		Flags:    []console.Flag{
			&console.StringFlag{Name: "commit", Aliases: []string{"c"},},
			&console.StringFlag{Name: "environment", Aliases: []string{"e"},},
			&console.StringFlag{Name: "project", Aliases: []string{"p"},},
		},
	},
	{
		Category: "cloud:repo",
		Name:     "ls",
		Aliases:  []*console.Alias{
			{Name: "repo:ls", Hidden: true},
			{Name: "upsun:repo:ls", Hidden: true},
		},
		Usage:    "List files in the project repository",
		Flags:    []console.Flag{
			&console.StringFlag{Name: "commit", Aliases: []string{"c"},},
			&console.BoolFlag{Name: "directories", Aliases: []string{"d"},},
			&console.StringFlag{Name: "environment", Aliases: []string{"e"},},
			&console.BoolFlag{Name: "files", Aliases: []string{"f"},},
			&console.BoolFlag{Name: "git-style",},
			&console.StringFlag{Name: "project", Aliases: []string{"p"},},
		},
	},
	{
		Category: "cloud:repo",
		Name:     "read",
		Aliases:  []*console.Alias{
			{Name: "repo:read", Hidden: true},
			{Name: "upsun:repo:read", Hidden: true},
			{Name: "cloud:read"},
			{Name: "upsun:read", Hidden: true},
			{Name: "read", Hidden: true},
		},
		Usage:    "Read a directory or file in the project repository",
		Flags:    []console.Flag{
			&console.StringFlag{Name: "commit", Aliases: []string{"c"},},
			&console.StringFlag{Name: "environment", Aliases: []string{"e"},},
			&console.StringFlag{Name: "project", Aliases: []string{"p"},},
		},
	},
	{
		Category: "cloud:resources",
		Name:     "get",
		Aliases:  []*console.Alias{
			{Name: "resources:get", Hidden: true},
			{Name: "upsun:resources:get", Hidden: true},
			{Name: "cloud:resources"},
			{Name: "upsun:resources", Hidden: true},
			{Name: "resources", Hidden: true},
			{Name: "cloud:res"},
			{Name: "upsun:res", Hidden: true},
			{Name: "res", Hidden: true},
		},
		Usage:    "View the resources of apps and services on an environment",
		Hidden:   console.Hide,
		Flags:    []console.Flag{
			&console.StringFlag{Name: "app",},
			&console.StringFlag{Name: "columns", Aliases: []string{"c"},},
			&console.StringFlag{Name: "environment", Aliases: []string{"e"},},
			&console.StringFlag{Name: "format", DefaultValue: "table",},
			&console.BoolFlag{Name: "no-header",},
			&console.StringFlag{Name: "project", Aliases: []string{"p"},},
			&console.StringFlag{Name: "service", Aliases: []string{"s"},},
			&console.StringFlag{Name: "type",},
			&console.StringFlag{Name: "worker",},
		},
	},
	{
		Category: "cloud:resources",
		Name:     "set",
		Aliases:  []*console.Alias{
			{Name: "resources:set", Hidden: true},
			{Name: "upsun:resources:set", Hidden: true},
		},
		Usage:    "Set the resources of apps and services on an environment",
		Hidden:   console.Hide,
		Flags:    []console.Flag{
			&console.StringFlag{Name: "count", Aliases: []string{"C"},},
			&console.StringFlag{Name: "disk", Aliases: []string{"D"},},
			&console.BoolFlag{Name: "dry-run",},
			&console.StringFlag{Name: "environment", Aliases: []string{"e"},},
			&console.BoolFlag{Name: "force", Aliases: []string{"f"},},
			&console.BoolFlag{Name: "no-wait", Aliases: []string{"W"},},
			&console.StringFlag{Name: "project", Aliases: []string{"p"},},
			&console.StringFlag{Name: "size", Aliases: []string{"S"},},
			&console.BoolFlag{Name: "wait",},
		},
	},
	{
		Category: "cloud:resources",
		Name:     "size:list",
		Aliases:  []*console.Alias{
			{Name: "resources:size:list", Hidden: true},
			{Name: "upsun:resources:size:list", Hidden: true},
			{Name: "cloud:resources:sizes"},
			{Name: "upsun:resources:sizes", Hidden: true},
			{Name: "resources:sizes", Hidden: true},
		},
		Usage:    "List container profile sizes",
		Hidden:   console.Hide,
		Flags:    []console.Flag{
			&console.StringFlag{Name: "columns", Aliases: []string{"c"},},
			&console.StringFlag{Name: "environment", Aliases: []string{"e"},},
			&console.StringFlag{Name: "format", DefaultValue: "table",},
			&console.BoolFlag{Name: "no-header",},
			&console.StringFlag{Name: "profile",},
			&console.StringFlag{Name: "project", Aliases: []string{"p"},},
			&console.StringFlag{Name: "service", Aliases: []string{"s"},},
		},
	},
	{
		Category: "cloud:route",
		Name:     "get",
		Aliases:  []*console.Alias{
			{Name: "route:get", Hidden: true},
			{Name: "upsun:route:get", Hidden: true},
		},
		Usage:    "View detailed information about a route",
		Flags:    []console.Flag{
			&console.StringFlag{Name: "app", Aliases: []string{"A"},},
			&console.StringFlag{Name: "date-fmt", DefaultValue: "c",},
			&console.StringFlag{Name: "environment", Aliases: []string{"e"},},
			&console.StringFlag{Name: "id",},
			&console.StringFlag{Name: "identity-file", Aliases: []string{"i"},},
			&console.BoolFlag{Name: "primary", Aliases: []string{"1"},},
			&console.StringFlag{Name: "project", Aliases: []string{"p"},},
			&console.StringFlag{Name: "property", Aliases: []string{"P"},},
			&console.BoolFlag{Name: "refresh",},
		},
	},
	{
		Category: "cloud:route",
		Name:     "list",
		Aliases:  []*console.Alias{
			{Name: "route:list", Hidden: true},
			{Name: "upsun:route:list", Hidden: true},
			{Name: "cloud:routes"},
			{Name: "upsun:routes", Hidden: true},
			{Name: "routes", Hidden: true},
		},
		Usage:    "List all routes for an environment",
		Flags:    []console.Flag{
			&console.StringFlag{Name: "columns", Aliases: []string{"c"},},
			&console.StringFlag{Name: "environment", Aliases: []string{"e"},},
			&console.StringFlag{Name: "format", DefaultValue: "table",},
			&console.BoolFlag{Name: "no-header",},
			&console.StringFlag{Name: "project", Aliases: []string{"p"},},
			&console.BoolFlag{Name: "refresh",},
		},
	},
	{
		Category: "cloud:self",
		Name:     "config",
		Aliases:  []*console.Alias{
			{Name: "upsun:self:config", Hidden: true},
		},
		Usage:    "Read CLI config",
		Hidden:   console.Hide,
	},
	{
		Category: "cloud:service",
		Name:     "list",
		Aliases:  []*console.Alias{
			{Name: "service:list", Hidden: true},
			{Name: "upsun:service:list", Hidden: true},
			{Name: "cloud:services"},
			{Name: "upsun:services", Hidden: true},
			{Name: "services", Hidden: true},
		},
		Usage:    "List services in the project",
		Flags:    []console.Flag{
			&console.StringFlag{Name: "columns", Aliases: []string{"c"},},
			&console.StringFlag{Name: "environment", Aliases: []string{"e"},},
			&console.StringFlag{Name: "format", DefaultValue: "table",},
			&console.BoolFlag{Name: "no-header",},
			&console.BoolFlag{Name: "pipe",},
			&console.StringFlag{Name: "project", Aliases: []string{"p"},},
			&console.BoolFlag{Name: "refresh",},
		},
	},
	{
		Category: "cloud:service",
		Name:     "mongo:dump",
		Aliases:  []*console.Alias{
			{Name: "service:mongo:dump", Hidden: true},
			{Name: "upsun:service:mongo:dump", Hidden: true},
			{Name: "cloud:mongodump"},
			{Name: "upsun:mongodump", Hidden: true},
			{Name: "mongodump", Hidden: true},
		},
		Usage:    "Create a binary archive dump of data from MongoDB",
		Flags:    []console.Flag{
			&console.StringFlag{Name: "app", Aliases: []string{"A"},},
			&console.StringFlag{Name: "collection", Aliases: []string{"c"},},
			&console.StringFlag{Name: "environment", Aliases: []string{"e"},},
			&console.BoolFlag{Name: "gzip", Aliases: []string{"z"},},
			&console.StringFlag{Name: "identity-file", Aliases: []string{"i"},},
			&console.StringFlag{Name: "project", Aliases: []string{"p"},},
			&console.StringFlag{Name: "relationship", Aliases: []string{"r"},},
			&console.BoolFlag{Name: "stdout", Aliases: []string{"o"},},
		},
	},
	{
		Category: "cloud:service",
		Name:     "mongo:export",
		Aliases:  []*console.Alias{
			{Name: "service:mongo:export", Hidden: true},
			{Name: "upsun:service:mongo:export", Hidden: true},
			{Name: "cloud:mongoexport"},
			{Name: "upsun:mongoexport", Hidden: true},
			{Name: "mongoexport", Hidden: true},
		},
		Usage:    "Export data from MongoDB",
		Flags:    []console.Flag{
			&console.StringFlag{Name: "app", Aliases: []string{"A"},},
			&console.StringFlag{Name: "collection", Aliases: []string{"c"},},
			&console.StringFlag{Name: "environment", Aliases: []string{"e"},},
			&console.StringFlag{Name: "fields", Aliases: []string{"f"},},
			&console.StringFlag{Name: "identity-file", Aliases: []string{"i"},},
			&console.BoolFlag{Name: "jsonArray",},
			&console.StringFlag{Name: "project", Aliases: []string{"p"},},
			&console.StringFlag{Name: "relationship", Aliases: []string{"r"},},
			&console.StringFlag{Name: "type",},
		},
	},
	{
		Category: "cloud:service",
		Name:     "mongo:restore",
		Aliases:  []*console.Alias{
			{Name: "service:mongo:restore", Hidden: true},
			{Name: "upsun:service:mongo:restore", Hidden: true},
			{Name: "cloud:mongorestore"},
			{Name: "upsun:mongorestore", Hidden: true},
			{Name: "mongorestore", Hidden: true},
		},
		Usage:    "Restore a binary archive dump of data into MongoDB",
		Flags:    []console.Flag{
			&console.StringFlag{Name: "app", Aliases: []string{"A"},},
			&console.StringFlag{Name: "collection", Aliases: []string{"c"},},
			&console.StringFlag{Name: "environment", Aliases: []string{"e"},},
			&console.StringFlag{Name: "identity-file", Aliases: []string{"i"},},
			&console.StringFlag{Name: "project", Aliases: []string{"p"},},
			&console.StringFlag{Name: "relationship", Aliases: []string{"r"},},
		},
	},
	{
		Category: "cloud:service",
		Name:     "mongo:shell",
		Aliases:  []*console.Alias{
			{Name: "service:mongo:shell", Hidden: true},
			{Name: "upsun:service:mongo:shell", Hidden: true},
			{Name: "cloud:mongo"},
			{Name: "upsun:mongo", Hidden: true},
			{Name: "mongo", Hidden: true},
		},
		Usage:    "Use the MongoDB shell",
		Flags:    []console.Flag{
			&console.StringFlag{Name: "app", Aliases: []string{"A"},},
			&console.StringFlag{Name: "environment", Aliases: []string{"e"},},
			&console.StringFlag{Name: "eval",},
			&console.StringFlag{Name: "identity-file", Aliases: []string{"i"},},
			&console.StringFlag{Name: "project", Aliases: []string{"p"},},
			&console.StringFlag{Name: "relationship", Aliases: []string{"r"},},
		},
	},
	{
		Category: "cloud:service",
		Name:     "redis-cli",
		Aliases:  []*console.Alias{
			{Name: "service:redis-cli", Hidden: true},
			{Name: "upsun:service:redis-cli", Hidden: true},
			{Name: "cloud:redis"},
			{Name: "upsun:redis", Hidden: true},
			{Name: "redis", Hidden: true},
		},
		Usage:    "Access the Redis CLI",
		Flags:    []console.Flag{
			&console.StringFlag{Name: "app", Aliases: []string{"A"},},
			&console.StringFlag{Name: "environment", Aliases: []string{"e"},},
			&console.StringFlag{Name: "identity-file", Aliases: []string{"i"},},
			&console.StringFlag{Name: "project", Aliases: []string{"p"},},
			&console.StringFlag{Name: "relationship", Aliases: []string{"r"},},
		},
	},
	{
		Category: "cloud:session",
		Name:     "switch",
		Aliases:  []*console.Alias{
			{Name: "session:switch", Hidden: true},
			{Name: "upsun:session:switch", Hidden: true},
		},
		Usage:    " BETA  Switch between sessions",
		Hidden:   console.Hide,
	},
	{
		Category: "cloud:source-operation",
		Name:     "list",
		Aliases:  []*console.Alias{
			{Name: "source-operation:list", Hidden: true},
			{Name: "upsun:source-operation:list", Hidden: true},
			{Name: "cloud:source-ops"},
			{Name: "upsun:source-ops", Hidden: true},
			{Name: "source-ops", Hidden: true},
		},
		Usage:    "List source operations on an environment",
		Flags:    []console.Flag{
			&console.StringFlag{Name: "columns", Aliases: []string{"c"},},
			&console.StringFlag{Name: "environment", Aliases: []string{"e"},},
			&console.StringFlag{Name: "format", DefaultValue: "table",},
			&console.BoolFlag{Name: "full",},
			&console.BoolFlag{Name: "no-header",},
			&console.StringFlag{Name: "project", Aliases: []string{"p"},},
		},
	},
	{
		Category: "cloud:source-operation",
		Name:     "run",
		Aliases:  []*console.Alias{
			{Name: "source-operation:run", Hidden: true},
			{Name: "upsun:source-operation:run", Hidden: true},
		},
		Usage:    "Run a source operation",
		Flags:    []console.Flag{
			&console.StringFlag{Name: "environment", Aliases: []string{"e"},},
			&console.BoolFlag{Name: "no-wait", Aliases: []string{"W"},},
			&console.StringFlag{Name: "project", Aliases: []string{"p"},},
			&console.StringFlag{Name: "variable",},
			&console.BoolFlag{Name: "wait",},
		},
	},
	{
		Category: "cloud:ssh-cert",
		Name:     "info",
		Aliases:  []*console.Alias{
			{Name: "ssh-cert:info", Hidden: true},
			{Name: "upsun:ssh-cert:info", Hidden: true},
		},
		Usage:    "Display information about the current SSH certificate",
		Hidden:   console.Hide,
		Flags:    []console.Flag{
			&console.StringFlag{Name: "date-fmt", DefaultValue: "c",},
			&console.BoolFlag{Name: "no-refresh",},
			&console.StringFlag{Name: "property", Aliases: []string{"P"},},
		},
	},
	{
		Category: "cloud:ssh-cert",
		Name:     "load",
		Aliases:  []*console.Alias{
			{Name: "ssh-cert:load", Hidden: true},
			{Name: "upsun:ssh-cert:load", Hidden: true},
		},
		Usage:    "Generate an SSH certificate",
		Flags:    []console.Flag{
			&console.BoolFlag{Name: "new",},
			&console.BoolFlag{Name: "new-key",},
			&console.BoolFlag{Name: "refresh-only",},
		},
	},
	{
		Category: "cloud:ssh-key",
		Name:     "add",
		Aliases:  []*console.Alias{
			{Name: "ssh-key:add", Hidden: true},
			{Name: "upsun:ssh-key:add", Hidden: true},
		},
		Usage:    "Add a new SSH key",
		Flags:    []console.Flag{
			&console.StringFlag{Name: "name",},
		},
	},
	{
		Category: "cloud:ssh-key",
		Name:     "delete",
		Aliases:  []*console.Alias{
			{Name: "ssh-key:delete", Hidden: true},
			{Name: "upsun:ssh-key:delete", Hidden: true},
		},
		Usage:    "Delete an SSH key",
	},
	{
		Category: "cloud:ssh-key",
		Name:     "list",
		Aliases:  []*console.Alias{
			{Name: "ssh-key:list", Hidden: true},
			{Name: "upsun:ssh-key:list", Hidden: true},
			{Name: "cloud:ssh-keys"},
			{Name: "upsun:ssh-keys", Hidden: true},
			{Name: "ssh-keys", Hidden: true},
		},
		Usage:    "Get a list of SSH keys in your account",
		Flags:    []console.Flag{
			&console.StringFlag{Name: "columns", Aliases: []string{"c"},},
			&console.StringFlag{Name: "format", DefaultValue: "table",},
			&console.BoolFlag{Name: "no-header",},
		},
	},
	{
		Category: "cloud:subscription",
		Name:     "info",
		Aliases:  []*console.Alias{
			{Name: "subscription:info", Hidden: true},
			{Name: "upsun:subscription:info", Hidden: true},
		},
		Usage:    "Read or modify subscription properties",
		Flags:    []console.Flag{
			&console.StringFlag{Name: "columns", Aliases: []string{"c"},},
			&console.StringFlag{Name: "date-fmt", DefaultValue: "c",},
			&console.StringFlag{Name: "format", DefaultValue: "table",},
			&console.StringFlag{Name: "id", Aliases: []string{"s"},},
			&console.BoolFlag{Name: "no-header",},
			&console.StringFlag{Name: "project", Aliases: []string{"p"},},
		},
	},
	{
		Category: "cloud:tunnel",
		Name:     "close",
		Aliases:  []*console.Alias{
			{Name: "tunnel:close", Hidden: true},
			{Name: "upsun:tunnel:close", Hidden: true},
		},
		Usage:    "Close SSH tunnels",
		Flags:    []console.Flag{
			&console.BoolFlag{Name: "all", Aliases: []string{"a"},},
			&console.StringFlag{Name: "app", Aliases: []string{"A"},},
			&console.StringFlag{Name: "environment", Aliases: []string{"e"},},
			&console.StringFlag{Name: "project", Aliases: []string{"p"},},
		},
	},
	{
		Category: "cloud:tunnel",
		Name:     "info",
		Aliases:  []*console.Alias{
			{Name: "tunnel:info", Hidden: true},
			{Name: "upsun:tunnel:info", Hidden: true},
		},
		Usage:    "View relationship info for SSH tunnels",
		Flags:    []console.Flag{
			&console.StringFlag{Name: "app", Aliases: []string{"A"},},
			&console.BoolFlag{Name: "encode", Aliases: []string{"c"},},
			&console.StringFlag{Name: "environment", Aliases: []string{"e"},},
			&console.StringFlag{Name: "project", Aliases: []string{"p"},},
			&console.StringFlag{Name: "property", Aliases: []string{"P"},},
		},
	},
	{
		Category: "cloud:tunnel",
		Name:     "list",
		Aliases:  []*console.Alias{
			{Name: "tunnel:list", Hidden: true},
			{Name: "upsun:tunnel:list", Hidden: true},
			{Name: "cloud:tunnels"},
			{Name: "upsun:tunnels", Hidden: true},
			{Name: "tunnels", Hidden: true},
		},
		Usage:    "List SSH tunnels",
		Flags:    []console.Flag{
			&console.BoolFlag{Name: "all", Aliases: []string{"a"},},
			&console.StringFlag{Name: "app", Aliases: []string{"A"},},
			&console.StringFlag{Name: "columns", Aliases: []string{"c"},},
			&console.StringFlag{Name: "environment", Aliases: []string{"e"},},
			&console.StringFlag{Name: "format", DefaultValue: "table",},
			&console.BoolFlag{Name: "no-header",},
			&console.StringFlag{Name: "project", Aliases: []string{"p"},},
		},
	},
	{
		Category: "cloud:tunnel",
		Name:     "open",
		Aliases:  []*console.Alias{
			{Name: "tunnel:open", Hidden: true},
			{Name: "upsun:tunnel:open", Hidden: true},
		},
		Usage:    "Open SSH tunnels to an app's relationships",
		Flags:    []console.Flag{
			&console.StringFlag{Name: "app", Aliases: []string{"A"},},
			&console.StringFlag{Name: "environment", Aliases: []string{"e"},},
			&console.BoolFlag{Name: "gateway-ports", Aliases: []string{"g"},},
			&console.StringFlag{Name: "identity-file", Aliases: []string{"i"},},
			&console.StringFlag{Name: "project", Aliases: []string{"p"},},
		},
	},
	{
		Category: "cloud:tunnel",
		Name:     "single",
		Aliases:  []*console.Alias{
			{Name: "tunnel:single", Hidden: true},
			{Name: "upsun:tunnel:single", Hidden: true},
		},
		Usage:    "Open a single SSH tunnel to an app relationship",
		Flags:    []console.Flag{
			&console.StringFlag{Name: "app", Aliases: []string{"A"},},
			&console.StringFlag{Name: "environment", Aliases: []string{"e"},},
			&console.BoolFlag{Name: "gateway-ports", Aliases: []string{"g"},},
			&console.StringFlag{Name: "identity-file", Aliases: []string{"i"},},
			&console.StringFlag{Name: "port",},
			&console.StringFlag{Name: "project", Aliases: []string{"p"},},
			&console.StringFlag{Name: "relationship", Aliases: []string{"r"},},
		},
	},
	{
		Category: "cloud:user",
		Name:     "add",
		Aliases:  []*console.Alias{
			{Name: "user:add", Hidden: true},
			{Name: "upsun:user:add", Hidden: true},
		},
		Usage:    "Add a user to the project",
		Flags:    []console.Flag{
			&console.BoolFlag{Name: "force-invite",},
			&console.BoolFlag{Name: "no-wait", Aliases: []string{"W"},},
			&console.StringFlag{Name: "project", Aliases: []string{"p"},},
			&console.StringFlag{Name: "role", Aliases: []string{"r"},},
			&console.BoolFlag{Name: "wait",},
		},
	},
	{
		Category: "cloud:user",
		Name:     "delete",
		Aliases:  []*console.Alias{
			{Name: "user:delete", Hidden: true},
			{Name: "upsun:user:delete", Hidden: true},
		},
		Usage:    "Delete a user from the project",
		Flags:    []console.Flag{
			&console.BoolFlag{Name: "no-wait", Aliases: []string{"W"},},
			&console.StringFlag{Name: "project", Aliases: []string{"p"},},
			&console.BoolFlag{Name: "wait",},
		},
	},
	{
		Category: "cloud:user",
		Name:     "get",
		Aliases:  []*console.Alias{
			{Name: "user:get", Hidden: true},
			{Name: "upsun:user:get", Hidden: true},
		},
		Usage:    "View a user's role(s)",
		Flags:    []console.Flag{
			&console.StringFlag{Name: "environment", Aliases: []string{"e"},},
			&console.StringFlag{Name: "level", Aliases: []string{"l"},},
			&console.BoolFlag{Name: "no-wait", Aliases: []string{"W"},},
			&console.BoolFlag{Name: "pipe",},
			&console.StringFlag{Name: "project", Aliases: []string{"p"},},
			&console.StringFlag{Name: "role", Aliases: []string{"r"},},
			&console.BoolFlag{Name: "wait",},
		},
	},
	{
		Category: "cloud:user",
		Name:     "list",
		Aliases:  []*console.Alias{
			{Name: "user:list", Hidden: true},
			{Name: "upsun:user:list", Hidden: true},
			{Name: "cloud:users"},
			{Name: "upsun:users", Hidden: true},
			{Name: "users", Hidden: true},
		},
		Usage:    "List project users",
		Flags:    []console.Flag{
			&console.StringFlag{Name: "columns", Aliases: []string{"c"},},
			&console.StringFlag{Name: "format", DefaultValue: "table",},
			&console.BoolFlag{Name: "no-header",},
			&console.StringFlag{Name: "project", Aliases: []string{"p"},},
		},
	},
	{
		Category: "cloud:user",
		Name:     "update",
		Aliases:  []*console.Alias{
			{Name: "user:update", Hidden: true},
			{Name: "upsun:user:update", Hidden: true},
		},
		Usage:    "Update user role(s) on a project",
		Flags:    []console.Flag{
			&console.BoolFlag{Name: "no-wait", Aliases: []string{"W"},},
			&console.StringFlag{Name: "project", Aliases: []string{"p"},},
			&console.StringFlag{Name: "role", Aliases: []string{"r"},},
			&console.BoolFlag{Name: "wait",},
		},
	},
	{
		Category: "cloud:variable",
		Name:     "create",
		Aliases:  []*console.Alias{
			{Name: "variable:create", Hidden: true},
			{Name: "upsun:variable:create", Hidden: true},
		},
		Usage:    "Create a variable",
		Flags:    []console.Flag{
			&console.BoolFlag{Name: "enabled", DefaultValue: true,},
			&console.StringFlag{Name: "environment", Aliases: []string{"e"},},
			&console.BoolFlag{Name: "inheritable", DefaultValue: true,},
			&console.BoolFlag{Name: "json",},
			&console.StringFlag{Name: "level", Aliases: []string{"l"},},
			&console.StringFlag{Name: "name",},
			&console.BoolFlag{Name: "no-wait", Aliases: []string{"W"},},
			&console.StringFlag{Name: "prefix", DefaultValue: "none",},
			&console.StringFlag{Name: "project", Aliases: []string{"p"},},
			&console.BoolFlag{Name: "sensitive",},
			&console.BoolFlag{Name: "update", Aliases: []string{"u"},},
			&console.StringFlag{Name: "value",},
			&console.StringFlag{Name: "visible-build",},
			&console.BoolFlag{Name: "visible-runtime", DefaultValue: true,},
			&console.BoolFlag{Name: "wait",},
		},
	},
	{
		Category: "cloud:variable",
		Name:     "delete",
		Aliases:  []*console.Alias{
			{Name: "variable:delete", Hidden: true},
			{Name: "upsun:variable:delete", Hidden: true},
		},
		Usage:    "Delete a variable",
		Flags:    []console.Flag{
			&console.StringFlag{Name: "environment", Aliases: []string{"e"},},
			&console.StringFlag{Name: "level", Aliases: []string{"l"},},
			&console.BoolFlag{Name: "no-wait", Aliases: []string{"W"},},
			&console.StringFlag{Name: "project", Aliases: []string{"p"},},
			&console.BoolFlag{Name: "wait",},
		},
	},
	{
		Category: "cloud:variable",
		Name:     "get",
		Aliases:  []*console.Alias{
			{Name: "variable:get", Hidden: true},
			{Name: "upsun:variable:get", Hidden: true},
			{Name: "cloud:vget"},
			{Name: "upsun:vget", Hidden: true},
			{Name: "vget", Hidden: true},
		},
		Usage:    "View a variable",
		Flags:    []console.Flag{
			&console.StringFlag{Name: "columns", Aliases: []string{"c"},},
			&console.StringFlag{Name: "environment", Aliases: []string{"e"},},
			&console.StringFlag{Name: "format", DefaultValue: "table",},
			&console.StringFlag{Name: "level", Aliases: []string{"l"},},
			&console.BoolFlag{Name: "no-header",},
			&console.BoolFlag{Name: "pipe",},
			&console.StringFlag{Name: "project", Aliases: []string{"p"},},
			&console.StringFlag{Name: "property", Aliases: []string{"P"},},
		},
	},
	{
		Category: "cloud:variable",
		Name:     "list",
		Aliases:  []*console.Alias{
			{Name: "variable:list", Hidden: true},
			{Name: "upsun:variable:list", Hidden: true},
			{Name: "cloud:variables"},
			{Name: "upsun:variables", Hidden: true},
			{Name: "variables", Hidden: true},
			{Name: "cloud:var"},
			{Name: "upsun:var", Hidden: true},
			{Name: "var", Hidden: true},
		},
		Usage:    "List variables",
		Flags:    []console.Flag{
			&console.StringFlag{Name: "columns", Aliases: []string{"c"},},
			&console.StringFlag{Name: "environment", Aliases: []string{"e"},},
			&console.StringFlag{Name: "format", DefaultValue: "table",},
			&console.StringFlag{Name: "level", Aliases: []string{"l"},},
			&console.BoolFlag{Name: "no-header",},
			&console.StringFlag{Name: "project", Aliases: []string{"p"},},
		},
	},
	{
		Category: "cloud:variable",
		Name:     "update",
		Aliases:  []*console.Alias{
			{Name: "variable:update", Hidden: true},
			{Name: "upsun:variable:update", Hidden: true},
		},
		Usage:    "Update a variable",
		Flags:    []console.Flag{
			&console.BoolFlag{Name: "allow-no-change",},
			&console.BoolFlag{Name: "enabled", DefaultValue: true,},
			&console.StringFlag{Name: "environment", Aliases: []string{"e"},},
			&console.BoolFlag{Name: "inheritable", DefaultValue: true,},
			&console.BoolFlag{Name: "json",},
			&console.StringFlag{Name: "level", Aliases: []string{"l"},},
			&console.BoolFlag{Name: "no-wait", Aliases: []string{"W"},},
			&console.StringFlag{Name: "project", Aliases: []string{"p"},},
			&console.BoolFlag{Name: "sensitive",},
			&console.StringFlag{Name: "value",},
			&console.StringFlag{Name: "visible-build",},
			&console.BoolFlag{Name: "visible-runtime", DefaultValue: true,},
			&console.BoolFlag{Name: "wait",},
		},
	},
	{
		Category: "cloud:version",
		Name:     "list",
		Aliases:  []*console.Alias{
			{Name: "version:list", Hidden: true},
			{Name: "upsun:version:list", Hidden: true},
			{Name: "cloud:versions"},
			{Name: "upsun:versions", Hidden: true},
			{Name: "versions", Hidden: true},
		},
		Usage:    " ALPHA  List environment versions",
		Hidden:   console.Hide,
		Flags:    []console.Flag{
			&console.StringFlag{Name: "columns", Aliases: []string{"c"},},
			&console.StringFlag{Name: "environment", Aliases: []string{"e"},},
			&console.StringFlag{Name: "format", DefaultValue: "table",},
			&console.BoolFlag{Name: "no-header",},
			&console.StringFlag{Name: "project", Aliases: []string{"p"},},
		},
	},
	{
		Category: "cloud:worker",
		Name:     "list",
		Aliases:  []*console.Alias{
			{Name: "worker:list", Hidden: true},
			{Name: "upsun:worker:list", Hidden: true},
			{Name: "cloud:workers"},
			{Name: "upsun:workers", Hidden: true},
			{Name: "workers", Hidden: true},
		},
		Usage:    "Get a list of all deployed workers",
		Flags:    []console.Flag{
			&console.StringFlag{Name: "columns", Aliases: []string{"c"},},
			&console.StringFlag{Name: "environment", Aliases: []string{"e"},},
			&console.StringFlag{Name: "format", DefaultValue: "table",},
			&console.BoolFlag{Name: "no-header",},
			&console.BoolFlag{Name: "pipe",},
			&console.StringFlag{Name: "project", Aliases: []string{"p"},},
			&console.BoolFlag{Name: "refresh",},
		},
	},
}
