# Contributor Covenant Code of Conduct

## Our Pledge

In the interest of fostering an open and welcoming environment, we as
contributors and maintainers pledge to making participation in our project and
our community a harassment-free experience for everyone, regardless of age, body
size, disability, ethnicity, gender identity and expression, level of experience,
education, socio-economic status, nationality, personal appearance, race,
religion, or sexual identity and orientation.

## Our Standards

Examples of behavior that contributes to creating a positive environment
include:

* Using welcoming and inclusive language
* Being respectful of differing viewpoints and experiences
* Gracefully accepting constructive criticism
* Focusing on what is best for the community
* Showing empathy towards other community members
* Contribute in a positive and constructive way

Examples of unacceptable behavior by participants include:

* The use of sexualized language or imagery and unwelcome sexual attention or
  advances
* Trolling, insulting/derogatory comments, and personal or political attacks
* Public or private harassment
* Publishing others' private information, such as a physical or electronic
  address, without explicit permission
* Other conduct which could reasonably be considered inappropriate in a
  professional setting
  
## Our Community Guidelines
* Be clear and stay on topic. Communicating with strangers on the Internet can make it hard to convey or read tone, and sarcasm is frequently misunderstood. Try to use clear language, and think about how the other person will receive it.
* Don’t cross-post the same thing in multiple GitHub Discussion topics or multiple Slack channels. This can make it difficult for people answering your questions and creates "scrollback spam".
* Public discussion is preferred to private. Avoid using Slack DMs for questions, and instead share them in public Slack channels or GitHub Discussion threads. This allows a larger audience to both share their knowledge as well as learn from your question or issue. If you're having a problem, chances are someone else is having a similar problem. Learning in public is a community contribution.
* Minimize notifications to other community members. Avoid tagging other community members in Slack messages or Discussion threads, unless you are replying to something specific. Community members are here to help each other, but are not "on call" for support, and we expect everyone to try to minimize "notification fatigue". If your issue is time-sensitive or critical, use methods like support@pulumi.com instead.

## Our Responsibilities

Project maintainers are responsible for clarifying the standards of acceptable
behavior and are expected to take appropriate and fair corrective action in
response to any instances of unacceptable behavior.

Project maintainers have the right and responsibility to remove, edit, or
reject comments, commits, code, wiki edits, issues, GitHub Discussions posts, 
and other contributions that are not aligned to this Code of Conduct, or to ban 
temporarily or permanently any contributor for other behaviors that they deem 
inappropriate, threatening, offensive, or harmful.

## Scope

This Code of Conduct applies both within project spaces (including the Community Slack
and GitHub Discussions forums) and in public spaces when an individual is representing the 
project or its community. Examples of representing a project or community include 
using an official project e-mail address, posting via an official social media account, 
or acting as an appointed representative at an online or offline event. Representation 
of a project may be further defined and clarified by project maintainers.

## Enforcement

Instances of abusive, harassing, or otherwise unacceptable behavior may be
reported by contacting the project team at code-of-conduct@pulumi.com. All
complaints will be reviewed and investigated and will result in a response that
is deemed necessary and appropriate to the circumstances. The project team is
obligated to maintain confidentiality with regard to the reporter of an incident.
Further details of specific enforcement policies may be posted separately.

Project maintainers who do not follow or enforce the Code of Conduct in good
faith may face temporary or permanent repercussions as determined by other
members of the project's leadership.

## Attribution

This Code of Conduct is adapted from the [Contributor Covenant][homepage], version 1.4,
available at https://www.contributor-covenant.org/version/1/4/code-of-conduct.html

[homepage]: https://www.contributor-covenant.org
