# Copyright 2016-2021, Pulumi Corporation.
#
# Licensed under the Apache License, Version 2.0 (the "License");
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
#     http://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.

import enum
import threading
import typing
from concurrent import futures


class Compression(enum.IntEnum):
    NoCompression = ...
    Deflate = ...
    Gzip = ...


class StatusCode(enum.Enum):
    OK = ...
    CANCELLED = ...
    UNKNOWN = ...
    INVALID_ARGUMENT = ...
    DEADLINE_EXCEEDED = ...
    NOT_FOUND = ...
    ALREADY_EXISTS = ...
    PERMISSION_DENIED = ...
    UNAUTHENTICATED = ...
    RESOURCE_EXHAUSTED = ...
    FAILED_PRECONDITION = ...
    ABORTED = ...
    UNIMPLEMENTED = ...
    INTERNAL = ...
    UNAVAILABLE = ...
    DATA_LOSS = ...


class Channel:
    pass


class Server:
    def add_insecure_port(self, address: str) -> int: ...
    def start(self) -> None: ...
    def stop(self, grace: typing.Optional[float] = None) -> threading.Event: ...


class RpcError(Exception):
    def code(self) -> StatusCode: ...
    def details(self) -> str: ...



def insecure_channel(
    target: str,
    options: typing.Any = None,
    compression: typing.Optional[Compression] = None,
) -> Channel:
    ...


def server(thread_pool: futures.ThreadPoolExecutor, options: typing.Any) -> Server: ...
