
---
title: "SqlResourceSqlContainer"
title_tag: "azure-native.documentdb.SqlResourceSqlContainer"
meta_desc: "Documentation for the azure-native.documentdb.SqlResourceSqlContainer resource with examples, input properties, output properties, lookup functions, and supporting types."
layout: api
no_edit_this_page: true
---



<!-- WARNING: this file was generated by test. -->
<!-- Do not edit by hand unless you're certain you know what you are doing! -->

An Azure Cosmos DB container.
API Version: 2021-03-15.

{{% examples %}}

## Example Usage

{{< chooser language "typescript,python,go,csharp" / >}}


### CosmosDBSqlContainerCreateUpdate


{{< example csharp >}}

```csharp
using Pulumi;
using AzureNative = Pulumi.AzureNative;

class MyStack : Stack
{
    public MyStack()
    {
        var sqlResourceSqlContainer = new AzureNative.DocumentDB.SqlResourceSqlContainer("sqlResourceSqlContainer", new AzureNative.DocumentDB.SqlResourceSqlContainerArgs
        {
            AccountName = "ddb1",
            ContainerName = "containerName",
            DatabaseName = "databaseName",
            Location = "West US",
            Options = ,
            Resource = new AzureNative.DocumentDB.Inputs.SqlContainerResourceArgs
            {
                ConflictResolutionPolicy = new AzureNative.DocumentDB.Inputs.ConflictResolutionPolicyArgs
                {
                    ConflictResolutionPath = "/path",
                    Mode = "LastWriterWins",
                },
                DefaultTtl = 100,
                Id = "containerName",
                IndexingPolicy = new AzureNative.DocumentDB.Inputs.IndexingPolicyArgs
                {
                    Automatic = true,
                    ExcludedPaths = {},
                    IncludedPaths = 
                    {
                        new AzureNative.DocumentDB.Inputs.IncludedPathArgs
                        {
                            Indexes = 
                            {
                                new AzureNative.DocumentDB.Inputs.IndexesArgs
                                {
                                    DataType = "String",
                                    Kind = "Range",
                                    Precision = -1,
                                },
                                new AzureNative.DocumentDB.Inputs.IndexesArgs
                                {
                                    DataType = "Number",
                                    Kind = "Range",
                                    Precision = -1,
                                },
                            },
                            Path = "/*",
                        },
                    },
                    IndexingMode = "consistent",
                },
                PartitionKey = new AzureNative.DocumentDB.Inputs.ContainerPartitionKeyArgs
                {
                    Kind = "Hash",
                    Paths = 
                    {
                        "/AccountNumber",
                    },
                },
                UniqueKeyPolicy = new AzureNative.DocumentDB.Inputs.UniqueKeyPolicyArgs
                {
                    UniqueKeys = 
                    {
                        new AzureNative.DocumentDB.Inputs.UniqueKeyArgs
                        {
                            Paths = 
                            {
                                "/testPath",
                            },
                        },
                    },
                },
            },
            ResourceGroupName = "rg1",
            Tags = ,
        });
    }

}

```


{{< /example >}}


{{< example go >}}


```go
package main

import (
	documentdb "github.com/pulumi/pulumi-azure-native/sdk/go/azure/documentdb"
	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
)

func main() {
	pulumi.Run(func(ctx *pulumi.Context) error {
		_, err := documentdb.NewSqlResourceSqlContainer(ctx, "sqlResourceSqlContainer", &documentdb.SqlResourceSqlContainerArgs{
			AccountName:   pulumi.String("ddb1"),
			ContainerName: pulumi.String("containerName"),
			DatabaseName:  pulumi.String("databaseName"),
			Location:      pulumi.String("West US"),
			Options:       nil,
			Resource: &documentdb.SqlContainerResourceArgs{
				ConflictResolutionPolicy: &documentdb.ConflictResolutionPolicyArgs{
					ConflictResolutionPath: pulumi.String("/path"),
					Mode:                   pulumi.String("LastWriterWins"),
				},
				DefaultTtl: pulumi.Int(100),
				Id:         pulumi.String("containerName"),
				IndexingPolicy: &documentdb.IndexingPolicyArgs{
					Automatic:     pulumi.Bool(true),
					ExcludedPaths: documentdb.ExcludedPathArray{},
					IncludedPaths: documentdb.IncludedPathArray{
						&documentdb.IncludedPathArgs{
							Indexes: documentdb.IndexesArray{
								&documentdb.IndexesArgs{
									DataType:  pulumi.String("String"),
									Kind:      pulumi.String("Range"),
									Precision: -1,
								},
								&documentdb.IndexesArgs{
									DataType:  pulumi.String("Number"),
									Kind:      pulumi.String("Range"),
									Precision: -1,
								},
							},
							Path: pulumi.String("/*"),
						},
					},
					IndexingMode: pulumi.String("consistent"),
				},
				PartitionKey: &documentdb.ContainerPartitionKeyArgs{
					Kind: pulumi.String("Hash"),
					Paths: pulumi.StringArray{
						pulumi.String("/AccountNumber"),
					},
				},
				UniqueKeyPolicy: &documentdb.UniqueKeyPolicyArgs{
					UniqueKeys: documentdb.UniqueKeyArray{
						&documentdb.UniqueKeyArgs{
							Paths: pulumi.StringArray{
								pulumi.String("/testPath"),
							},
						},
					},
				},
			},
			ResourceGroupName: pulumi.String("rg1"),
			Tags:              nil,
		})
		if err != nil {
			return err
		}
		return nil
	})
}

```


{{< /example >}}


{{< example python >}}


```python
import pulumi
import pulumi_azure_native as azure_native

sql_resource_sql_container = azure_native.documentdb.SqlResourceSqlContainer("sqlResourceSqlContainer",
    account_name="ddb1",
    container_name="containerName",
    database_name="databaseName",
    location="West US",
    options=azure_native.documentdb.CreateUpdateOptionsArgs(),
    resource=azure_native.documentdb.SqlContainerResourceArgs(
        conflict_resolution_policy=azure_native.documentdb.ConflictResolutionPolicyArgs(
            conflict_resolution_path="/path",
            mode="LastWriterWins",
        ),
        default_ttl=100,
        id="containerName",
        indexing_policy=azure_native.documentdb.IndexingPolicyArgs(
            automatic=True,
            excluded_paths=[],
            included_paths=[azure_native.documentdb.IncludedPathArgs(
                indexes=[
                    azure_native.documentdb.IndexesArgs(
                        data_type="String",
                        kind="Range",
                        precision=-1,
                    ),
                    azure_native.documentdb.IndexesArgs(
                        data_type="Number",
                        kind="Range",
                        precision=-1,
                    ),
                ],
                path="/*",
            )],
            indexing_mode="consistent",
        ),
        partition_key=azure_native.documentdb.ContainerPartitionKeyArgs(
            kind="Hash",
            paths=["/AccountNumber"],
        ),
        unique_key_policy=azure_native.documentdb.UniqueKeyPolicyArgs(
            unique_keys=[azure_native.documentdb.UniqueKeyArgs(
                paths=["/testPath"],
            )],
        ),
    ),
    resource_group_name="rg1",
    tags={})

```


{{< /example >}}


{{< example typescript >}}


```typescript
import * as pulumi from "@pulumi/pulumi";
import * as azure_native from "@pulumi/azure-native";

const sqlResourceSqlContainer = new azure_native.documentdb.SqlResourceSqlContainer("sqlResourceSqlContainer", {
    accountName: "ddb1",
    containerName: "containerName",
    databaseName: "databaseName",
    location: "West US",
    options: {},
    resource: {
        conflictResolutionPolicy: {
            conflictResolutionPath: "/path",
            mode: "LastWriterWins",
        },
        defaultTtl: 100,
        id: "containerName",
        indexingPolicy: {
            automatic: true,
            excludedPaths: [],
            includedPaths: [{
                indexes: [
                    {
                        dataType: "String",
                        kind: "Range",
                        precision: -1,
                    },
                    {
                        dataType: "Number",
                        kind: "Range",
                        precision: -1,
                    },
                ],
                path: "/*",
            }],
            indexingMode: "consistent",
        },
        partitionKey: {
            kind: "Hash",
            paths: ["/AccountNumber"],
        },
        uniqueKeyPolicy: {
            uniqueKeys: [{
                paths: ["/testPath"],
            }],
        },
    },
    resourceGroupName: "rg1",
    tags: {},
});

```


{{< /example >}}





{{% /examples %}}




## Create a SqlResourceSqlContainer Resource {#create}
{{< chooser language "typescript,python,go,csharp" / >}}


{{% choosable language nodejs %}}
<div class="highlight"><pre class="chroma"><code class="language-typescript" data-lang="typescript"><span class="k">new </span><span class="nx">SqlResourceSqlContainer</span><span class="p">(</span><span class="nx">name</span><span class="p">:</span> <span class="nx">string</span><span class="p">,</span> <span class="nx">args</span><span class="p">?:</span> <span class="nx"><a href="#inputs">SqlResourceSqlContainerArgs</a></span><span class="p">,</span> <span class="nx">opts</span><span class="p">?:</span> <span class="nx"><a href="/docs/reference/pkg/nodejs/pulumi/pulumi/#CustomResourceOptions">CustomResourceOptions</a></span><span class="p">);</span></code></pre></div>
{{% /choosable %}}

{{% choosable language python %}}
<div class="highlight"><pre class="chroma"><code class="language-python" data-lang="python"><span class=nd>@overload</span>
<span class="k">def </span><span class="nx">SqlResourceSqlContainer</span><span class="p">(</span><span class="nx">resource_name</span><span class="p">:</span> <span class="nx">str</span><span class="p">,</span>
                            <span class="nx">opts</span><span class="p">:</span> <span class="nx"><a href="/docs/reference/pkg/python/pulumi/#pulumi.ResourceOptions">Optional[ResourceOptions]</a></span> = None<span class="p">)</span>
<span class=nd>@overload</span>
<span class="k">def </span><span class="nx">SqlResourceSqlContainer</span><span class="p">(</span><span class="nx">resource_name</span><span class="p">:</span> <span class="nx">str</span><span class="p">,</span>
                            <span class="nx">args</span><span class="p">:</span> <span class="nx"><a href="#inputs">Optional[SqlResourceSqlContainerArgs]</a></span> = None<span class="p">,</span>
                            <span class="nx">opts</span><span class="p">:</span> <span class="nx"><a href="/docs/reference/pkg/python/pulumi/#pulumi.ResourceOptions">Optional[ResourceOptions]</a></span> = None<span class="p">)</span></code></pre></div>
{{% /choosable %}}

{{% choosable language go %}}
<div class="highlight"><pre class="chroma"><code class="language-go" data-lang="go"><span class="k">func </span><span class="nx">NewSqlResourceSqlContainer</span><span class="p">(</span><span class="nx">ctx</span><span class="p"> *</span><span class="nx"><a href="https://pkg.go.dev/github.com/pulumi/pulumi/sdk/v3/go/pulumi?tab=doc#Context">Context</a></span><span class="p">,</span> <span class="nx">name</span><span class="p"> </span><span class="nx">string</span><span class="p">,</span> <span class="nx">args</span><span class="p"> *</span><span class="nx"><a href="#inputs">SqlResourceSqlContainerArgs</a></span><span class="p">,</span> <span class="nx">opts</span><span class="p"> ...</span><span class="nx"><a href="https://pkg.go.dev/github.com/pulumi/pulumi/sdk/v3/go/pulumi?tab=doc#ResourceOption">ResourceOption</a></span><span class="p">) (*<span class="nx">SqlResourceSqlContainer</span>, error)</span></code></pre></div>
{{% /choosable %}}

{{% choosable language csharp %}}
<div class="highlight"><pre class="chroma"><code class="language-csharp" data-lang="csharp"><span class="k">public </span><span class="nx">SqlResourceSqlContainer</span><span class="p">(</span><span class="nx">string</span><span class="p"> </span><span class="nx">name<span class="p">,</span> <span class="nx"><a href="#inputs">SqlResourceSqlContainerArgs</a></span><span class="p">? </span><span class="nx">args = null<span class="p">,</span> <span class="nx"><a href="/docs/reference/pkg/dotnet/Pulumi/Pulumi.CustomResourceOptions.html">CustomResourceOptions</a></span><span class="p">? </span><span class="nx">opts = null<span class="p">)</span></code></pre></div>
{{% /choosable %}}

{{% choosable language nodejs %}}

<dl class="resources-properties"><dt
        class="property-required" title="Required">
        <span>name</span>
        <span class="property-indicator"></span>
        <span class="property-type">string</span>
    </dt>
    <dd>The unique name of the resource.</dd><dt
        class="property-optional" title="Optional">
        <span>args</span>
        <span class="property-indicator"></span>
        <span class="property-type"><a href="#inputs">SqlResourceSqlContainerArgs</a></span>
    </dt>
    <dd>The arguments to resource properties.</dd><dt
        class="property-optional" title="Optional">
        <span>opts</span>
        <span class="property-indicator"></span>
        <span class="property-type"><a href="/docs/reference/pkg/nodejs/pulumi/pulumi/#CustomResourceOptions">CustomResourceOptions</a></span>
    </dt>
    <dd>Bag of options to control resource&#39;s behavior.</dd></dl>

{{% /choosable %}}

{{% choosable language python %}}

<dl class="resources-properties"><dt
        class="property-required" title="Required">
        <span>resource_name</span>
        <span class="property-indicator"></span>
        <span class="property-type">str</span>
    </dt>
    <dd>The unique name of the resource.</dd><dt
        class="property-optional" title="Optional">
        <span>args</span>
        <span class="property-indicator"></span>
        <span class="property-type"><a href="#inputs">SqlResourceSqlContainerArgs</a></span>
    </dt>
    <dd>The arguments to resource properties.</dd><dt
        class="property-optional" title="Optional">
        <span>opts</span>
        <span class="property-indicator"></span>
        <span class="property-type"><a href="/docs/reference/pkg/python/pulumi/#pulumi.ResourceOptions">ResourceOptions</a></span>
    </dt>
    <dd>Bag of options to control resource&#39;s behavior.</dd></dl>

{{% /choosable %}}

{{% choosable language go %}}

<dl class="resources-properties"><dt
        class="property-optional" title="Optional">
        <span>ctx</span>
        <span class="property-indicator"></span>
        <span class="property-type"><a href="https://pkg.go.dev/github.com/pulumi/pulumi/sdk/v3/go/pulumi?tab=doc#Context">Context</a></span>
    </dt>
    <dd>Context object for the current deployment.</dd><dt
        class="property-required" title="Required">
        <span>name</span>
        <span class="property-indicator"></span>
        <span class="property-type">string</span>
    </dt>
    <dd>The unique name of the resource.</dd><dt
        class="property-optional" title="Optional">
        <span>args</span>
        <span class="property-indicator"></span>
        <span class="property-type"><a href="#inputs">SqlResourceSqlContainerArgs</a></span>
    </dt>
    <dd>The arguments to resource properties.</dd><dt
        class="property-optional" title="Optional">
        <span>opts</span>
        <span class="property-indicator"></span>
        <span class="property-type"><a href="https://pkg.go.dev/github.com/pulumi/pulumi/sdk/v3/go/pulumi?tab=doc#ResourceOption">ResourceOption</a></span>
    </dt>
    <dd>Bag of options to control resource&#39;s behavior.</dd></dl>

{{% /choosable %}}

{{% choosable language csharp %}}

<dl class="resources-properties"><dt
        class="property-required" title="Required">
        <span>name</span>
        <span class="property-indicator"></span>
        <span class="property-type">string</span>
    </dt>
    <dd>The unique name of the resource.</dd><dt
        class="property-optional" title="Optional">
        <span>args</span>
        <span class="property-indicator"></span>
        <span class="property-type"><a href="#inputs">SqlResourceSqlContainerArgs</a></span>
    </dt>
    <dd>The arguments to resource properties.</dd><dt
        class="property-optional" title="Optional">
        <span>opts</span>
        <span class="property-indicator"></span>
        <span class="property-type"><a href="/docs/reference/pkg/dotnet/Pulumi/Pulumi.CustomResourceOptions.html">CustomResourceOptions</a></span>
    </dt>
    <dd>Bag of options to control resource&#39;s behavior.</dd></dl>

{{% /choosable %}}

## SqlResourceSqlContainer Resource Properties {#properties}

To learn more about resource properties and how to use them, see [Inputs and Outputs]({{< relref "/docs/intro/concepts/inputs-outputs" >}}) in the Architecture and Concepts docs.

### Inputs

The SqlResourceSqlContainer resource accepts the following [input]({{< relref "/docs/intro/concepts/inputs-outputs" >}}) properties:



{{% choosable language csharp %}}
<dl class="resources-properties"></dl>
{{% /choosable %}}

{{% choosable language go %}}
<dl class="resources-properties"></dl>
{{% /choosable %}}

{{% choosable language nodejs %}}
<dl class="resources-properties"></dl>
{{% /choosable %}}

{{% choosable language python %}}
<dl class="resources-properties"></dl>
{{% /choosable %}}


### Outputs

All [input](#inputs) properties are implicitly available as output properties. Additionally, the SqlResourceSqlContainer resource produces the following output properties:



{{% choosable language csharp %}}
<dl class="resources-properties"><dt class="property-"
            title="">
        <span id="id_csharp">
<a href="#id_csharp" style="color: inherit; text-decoration: inherit;">Id</a>
</span>
        <span class="property-indicator"></span>
        <span class="property-type">string</span>
    </dt>
    <dd>{{% md %}}The provider-assigned unique ID for this managed resource.{{% /md %}}</dd><dt class="property-"
            title="">
        <span id="resource_csharp">
<a href="#resource_csharp" style="color: inherit; text-decoration: inherit;">Resource</a>
</span>
        <span class="property-indicator"></span>
        <span class="property-type"><a href="#sqlcontainergetpropertiesresponseresource">Pulumi.<wbr>Azure<wbr>Native.<wbr>Document<wbr>DB.<wbr>Outputs.<wbr>Sql<wbr>Container<wbr>Get<wbr>Properties<wbr>Response<wbr>Resource</a></span>
    </dt>
    <dd>{{% md %}}{{% /md %}}</dd></dl>
{{% /choosable %}}

{{% choosable language go %}}
<dl class="resources-properties"><dt class="property-"
            title="">
        <span id="id_go">
<a href="#id_go" style="color: inherit; text-decoration: inherit;">Id</a>
</span>
        <span class="property-indicator"></span>
        <span class="property-type">string</span>
    </dt>
    <dd>{{% md %}}The provider-assigned unique ID for this managed resource.{{% /md %}}</dd><dt class="property-"
            title="">
        <span id="resource_go">
<a href="#resource_go" style="color: inherit; text-decoration: inherit;">Resource</a>
</span>
        <span class="property-indicator"></span>
        <span class="property-type"><a href="#sqlcontainergetpropertiesresponseresource">Sql<wbr>Container<wbr>Get<wbr>Properties<wbr>Response<wbr>Resource</a></span>
    </dt>
    <dd>{{% md %}}{{% /md %}}</dd></dl>
{{% /choosable %}}

{{% choosable language nodejs %}}
<dl class="resources-properties"><dt class="property-"
            title="">
        <span id="id_nodejs">
<a href="#id_nodejs" style="color: inherit; text-decoration: inherit;">id</a>
</span>
        <span class="property-indicator"></span>
        <span class="property-type">string</span>
    </dt>
    <dd>{{% md %}}The provider-assigned unique ID for this managed resource.{{% /md %}}</dd><dt class="property-"
            title="">
        <span id="resource_nodejs">
<a href="#resource_nodejs" style="color: inherit; text-decoration: inherit;">resource</a>
</span>
        <span class="property-indicator"></span>
        <span class="property-type"><a href="#sqlcontainergetpropertiesresponseresource">Sql<wbr>Container<wbr>Get<wbr>Properties<wbr>Response<wbr>Resource</a></span>
    </dt>
    <dd>{{% md %}}{{% /md %}}</dd></dl>
{{% /choosable %}}

{{% choosable language python %}}
<dl class="resources-properties"><dt class="property-"
            title="">
        <span id="id_python">
<a href="#id_python" style="color: inherit; text-decoration: inherit;">id</a>
</span>
        <span class="property-indicator"></span>
        <span class="property-type">str</span>
    </dt>
    <dd>{{% md %}}The provider-assigned unique ID for this managed resource.{{% /md %}}</dd><dt class="property-"
            title="">
        <span id="resource_python">
<a href="#resource_python" style="color: inherit; text-decoration: inherit;">resource</a>
</span>
        <span class="property-indicator"></span>
        <span class="property-type"><a href="#sqlcontainergetpropertiesresponseresource">Sql<wbr>Container<wbr>Get<wbr>Properties<wbr>Response<wbr>Resource</a></span>
    </dt>
    <dd>{{% md %}}{{% /md %}}</dd></dl>
{{% /choosable %}}







## Supporting Types



<h4 id="compositepathresponse">Composite<wbr>Path<wbr>Response</h4>

{{% choosable language csharp %}}
<dl class="resources-properties"><dt class="property-optional"
            title="Optional">
        <span id="order_csharp">
<a href="#order_csharp" style="color: inherit; text-decoration: inherit;">Order</a>
</span>
        <span class="property-indicator"></span>
        <span class="property-type">string</span>
    </dt>
    <dd>{{% md %}}Sort order for composite paths.{{% /md %}}</dd><dt class="property-optional"
            title="Optional">
        <span id="path_csharp">
<a href="#path_csharp" style="color: inherit; text-decoration: inherit;">Path</a>
</span>
        <span class="property-indicator"></span>
        <span class="property-type">string</span>
    </dt>
    <dd>{{% md %}}The path for which the indexing behavior applies to. Index paths typically start with root and end with wildcard (/path/*){{% /md %}}</dd></dl>
{{% /choosable %}}

{{% choosable language go %}}
<dl class="resources-properties"><dt class="property-optional"
            title="Optional">
        <span id="order_go">
<a href="#order_go" style="color: inherit; text-decoration: inherit;">Order</a>
</span>
        <span class="property-indicator"></span>
        <span class="property-type">string</span>
    </dt>
    <dd>{{% md %}}Sort order for composite paths.{{% /md %}}</dd><dt class="property-optional"
            title="Optional">
        <span id="path_go">
<a href="#path_go" style="color: inherit; text-decoration: inherit;">Path</a>
</span>
        <span class="property-indicator"></span>
        <span class="property-type">string</span>
    </dt>
    <dd>{{% md %}}The path for which the indexing behavior applies to. Index paths typically start with root and end with wildcard (/path/*){{% /md %}}</dd></dl>
{{% /choosable %}}

{{% choosable language nodejs %}}
<dl class="resources-properties"><dt class="property-optional"
            title="Optional">
        <span id="order_nodejs">
<a href="#order_nodejs" style="color: inherit; text-decoration: inherit;">order</a>
</span>
        <span class="property-indicator"></span>
        <span class="property-type">string</span>
    </dt>
    <dd>{{% md %}}Sort order for composite paths.{{% /md %}}</dd><dt class="property-optional"
            title="Optional">
        <span id="path_nodejs">
<a href="#path_nodejs" style="color: inherit; text-decoration: inherit;">path</a>
</span>
        <span class="property-indicator"></span>
        <span class="property-type">string</span>
    </dt>
    <dd>{{% md %}}The path for which the indexing behavior applies to. Index paths typically start with root and end with wildcard (/path/*){{% /md %}}</dd></dl>
{{% /choosable %}}

{{% choosable language python %}}
<dl class="resources-properties"><dt class="property-optional"
            title="Optional">
        <span id="order_python">
<a href="#order_python" style="color: inherit; text-decoration: inherit;">order</a>
</span>
        <span class="property-indicator"></span>
        <span class="property-type">str</span>
    </dt>
    <dd>{{% md %}}Sort order for composite paths.{{% /md %}}</dd><dt class="property-optional"
            title="Optional">
        <span id="path_python">
<a href="#path_python" style="color: inherit; text-decoration: inherit;">path</a>
</span>
        <span class="property-indicator"></span>
        <span class="property-type">str</span>
    </dt>
    <dd>{{% md %}}The path for which the indexing behavior applies to. Index paths typically start with root and end with wildcard (/path/*){{% /md %}}</dd></dl>
{{% /choosable %}}

<h4 id="indexingpolicyresponse">Indexing<wbr>Policy<wbr>Response</h4>

{{% choosable language csharp %}}
<dl class="resources-properties"><dt class="property-optional"
            title="Optional">
        <span id="compositeindexes_csharp">
<a href="#compositeindexes_csharp" style="color: inherit; text-decoration: inherit;">Composite<wbr>Indexes</a>
</span>
        <span class="property-indicator"></span>
        <span class="property-type"><a href="#compositepathresponse">List&lt;Immutable<wbr>Array&lt;Pulumi.<wbr>Azure<wbr>Native.<wbr>Document<wbr>DB.<wbr>Inputs.<wbr>Composite<wbr>Path<wbr>Response&gt;&gt;</a></span>
    </dt>
    <dd>{{% md %}}List of composite path list{{% /md %}}</dd></dl>
{{% /choosable %}}

{{% choosable language go %}}
<dl class="resources-properties"><dt class="property-optional"
            title="Optional">
        <span id="compositeindexes_go">
<a href="#compositeindexes_go" style="color: inherit; text-decoration: inherit;">Composite<wbr>Indexes</a>
</span>
        <span class="property-indicator"></span>
        <span class="property-type"><a href="#compositepathresponse">[][]Composite<wbr>Path<wbr>Response</a></span>
    </dt>
    <dd>{{% md %}}List of composite path list{{% /md %}}</dd></dl>
{{% /choosable %}}

{{% choosable language nodejs %}}
<dl class="resources-properties"><dt class="property-optional"
            title="Optional">
        <span id="compositeindexes_nodejs">
<a href="#compositeindexes_nodejs" style="color: inherit; text-decoration: inherit;">composite<wbr>Indexes</a>
</span>
        <span class="property-indicator"></span>
        <span class="property-type"><a href="#compositepathresponse">Composite<wbr>Path<wbr>Response[][]</a></span>
    </dt>
    <dd>{{% md %}}List of composite path list{{% /md %}}</dd></dl>
{{% /choosable %}}

{{% choosable language python %}}
<dl class="resources-properties"><dt class="property-optional"
            title="Optional">
        <span id="composite_indexes_python">
<a href="#composite_indexes_python" style="color: inherit; text-decoration: inherit;">composite_<wbr>indexes</a>
</span>
        <span class="property-indicator"></span>
        <span class="property-type"><a href="#compositepathresponse">Sequence[Sequence[Composite<wbr>Path<wbr>Response]]</a></span>
    </dt>
    <dd>{{% md %}}List of composite path list{{% /md %}}</dd></dl>
{{% /choosable %}}

<h4 id="sqlcontainergetpropertiesresponseresource">Sql<wbr>Container<wbr>Get<wbr>Properties<wbr>Response<wbr>Resource</h4>

{{% choosable language csharp %}}
<dl class="resources-properties"><dt class="property-optional"
            title="Optional">
        <span id="indexingpolicy_csharp">
<a href="#indexingpolicy_csharp" style="color: inherit; text-decoration: inherit;">Indexing<wbr>Policy</a>
</span>
        <span class="property-indicator"></span>
        <span class="property-type"><a href="#indexingpolicyresponse">Pulumi.<wbr>Azure<wbr>Native.<wbr>Document<wbr>DB.<wbr>Inputs.<wbr>Indexing<wbr>Policy<wbr>Response</a></span>
    </dt>
    <dd>{{% md %}}The configuration of the indexing policy. By default, the indexing is automatic for all document paths within the container{{% /md %}}</dd></dl>
{{% /choosable %}}

{{% choosable language go %}}
<dl class="resources-properties"><dt class="property-optional"
            title="Optional">
        <span id="indexingpolicy_go">
<a href="#indexingpolicy_go" style="color: inherit; text-decoration: inherit;">Indexing<wbr>Policy</a>
</span>
        <span class="property-indicator"></span>
        <span class="property-type"><a href="#indexingpolicyresponse">Indexing<wbr>Policy<wbr>Response</a></span>
    </dt>
    <dd>{{% md %}}The configuration of the indexing policy. By default, the indexing is automatic for all document paths within the container{{% /md %}}</dd></dl>
{{% /choosable %}}

{{% choosable language nodejs %}}
<dl class="resources-properties"><dt class="property-optional"
            title="Optional">
        <span id="indexingpolicy_nodejs">
<a href="#indexingpolicy_nodejs" style="color: inherit; text-decoration: inherit;">indexing<wbr>Policy</a>
</span>
        <span class="property-indicator"></span>
        <span class="property-type"><a href="#indexingpolicyresponse">Indexing<wbr>Policy<wbr>Response</a></span>
    </dt>
    <dd>{{% md %}}The configuration of the indexing policy. By default, the indexing is automatic for all document paths within the container{{% /md %}}</dd></dl>
{{% /choosable %}}

{{% choosable language python %}}
<dl class="resources-properties"><dt class="property-optional"
            title="Optional">
        <span id="indexing_policy_python">
<a href="#indexing_policy_python" style="color: inherit; text-decoration: inherit;">indexing_<wbr>policy</a>
</span>
        <span class="property-indicator"></span>
        <span class="property-type"><a href="#indexingpolicyresponse">Indexing<wbr>Policy<wbr>Response</a></span>
    </dt>
    <dd>{{% md %}}The configuration of the indexing policy. By default, the indexing is automatic for all document paths within the container{{% /md %}}</dd></dl>
{{% /choosable %}}
## Import


An existing resource can be imported using its type token, name, and identifier, e.g.

```sh
$ pulumi import azure-native:documentdb:SqlResourceSqlContainer containerName /subscriptions/subid/resourceGroups/rg1/providers/Microsoft.DocumentDB/databaseAccounts/ddb1/sqlDatabases/databaseName/sqlContainers/containerName 
```




<h2 id="package-details">Package Details</h2>
<dl class="package-details">
	<dt>Repository</dt>
	<dd><a href="https://github.com/pulumi/pulumi-azure-native">https://github.com/pulumi/pulumi-azure-native</a></dd>
	<dt>License</dt>
	<dd>Apache-2.0</dd>
</dl>

