// Copyright 2016-2018, Pulumi Corporation.
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//     http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

package deploy

import (
	"github.com/pulumi/pulumi/sdk/v2/go/common/resource/config"
	"github.com/pulumi/pulumi/sdk/v2/go/common/tokens"
)

// Target represents information about a deployment target.
type Target struct {
	Name      tokens.QName     // the target stack name.
	Config    config.Map       // optional configuration key/value pairs.
	Decrypter config.Decrypter // decrypter for secret configuration values.
	Snapshot  *Snapshot        // the last snapshot deployed to the target.
}

// GetPackageConfig returns the set of configuration parameters for the indicated package, if any.
func (t *Target) GetPackageConfig(pkg tokens.Package) (map[config.Key]string, error) {
	var result map[config.Key]string
	if t == nil {
		return result, nil
	}

	for k, c := range t.Config {
		if tokens.Package(k.Namespace()) != pkg {
			continue
		}
		v, err := c.Value(t.Decrypter)
		if err != nil {
			return nil, err
		}
		if result == nil {
			result = make(map[config.Key]string)
		}
		result[k] = v
	}
	return result, nil
}
