// @generated Code generated by ragel

// Copyright (c) 2021 Uber Technologies, Inc.
//
// Permission is hereby granted, free of charge, to any person obtaining a copy
// of this software and associated documentation files (the "Software"), to deal
// in the Software without restriction, including without limitation the rights
// to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
// copies of the Software, and to permit persons to whom the Software is
// furnished to do so, subject to the following conditions:
//
// The above copyright notice and this permission notice shall be included in
// all copies or substantial portions of the Software.
//
// THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
// IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
// FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
// AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
// LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
// OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN
// THE SOFTWARE.




package internal

import (
	"errors"
	"fmt"
	"strconv"

	"go.uber.org/thriftrw/ast"
)

const thrift_start int = 19
const thrift_first_final int = 19
const thrift_error int = 0

const thrift_en_main int = 19


type lexer struct {
	program *ast.Program

	line      int
	lineStart int

	docstringStart      int
	lastDocstring       string
	linesSinceDocstring int

	nodePositions NodePositions

	errors      []ParseError
	parseFailed bool

	// Ragel:
	p, pe, cs, ts, te, act int
	data                   []byte
}

func newLexer(data []byte) *lexer {
	lex := &lexer{
		line:          1,
		nodePositions: make(NodePositions, 0),
		parseFailed:   false,
		data:          data,
		p:             0,
		pe:            len(data),
	}

	{
		lex.cs = thrift_start
		lex.ts = 0
		lex.te = 0
		lex.act = 0
	}

	return lex
}

func (lex *lexer) Lex(out *yySymType) int {
	var (
		reservedKeyword string

		eof = lex.pe
		tok = 0
	)

	{
		if (lex.p) == (lex.pe) {
			goto _test_eof
		}
		switch lex.cs {
		case 19:
			goto st_case_19
		case 0:
			goto st_case_0
		case 1:
			goto st_case_1
		case 2:
			goto st_case_2
		case 20:
			goto st_case_20
		case 3:
			goto st_case_3
		case 4:
			goto st_case_4
		case 5:
			goto st_case_5
		case 21:
			goto st_case_21
		case 22:
			goto st_case_22
		case 6:
			goto st_case_6
		case 7:
			goto st_case_7
		case 23:
			goto st_case_23
		case 8:
			goto st_case_8
		case 9:
			goto st_case_9
		case 10:
			goto st_case_10
		case 11:
			goto st_case_11
		case 12:
			goto st_case_12
		case 13:
			goto st_case_13
		case 14:
			goto st_case_14
		case 24:
			goto st_case_24
		case 15:
			goto st_case_15
		case 16:
			goto st_case_16
		case 25:
			goto st_case_25
		case 17:
			goto st_case_17
		case 26:
			goto st_case_26
		case 27:
			goto st_case_27
		case 18:
			goto st_case_18
		case 28:
			goto st_case_28
		case 29:
			goto st_case_29
		case 30:
			goto st_case_30
		case 31:
			goto st_case_31
		case 32:
			goto st_case_32
		case 33:
			goto st_case_33
		case 34:
			goto st_case_34
		case 35:
			goto st_case_35
		case 36:
			goto st_case_36
		case 37:
			goto st_case_37
		case 38:
			goto st_case_38
		case 39:
			goto st_case_39
		case 40:
			goto st_case_40
		case 41:
			goto st_case_41
		case 42:
			goto st_case_42
		case 43:
			goto st_case_43
		case 44:
			goto st_case_44
		case 45:
			goto st_case_45
		case 46:
			goto st_case_46
		case 47:
			goto st_case_47
		case 48:
			goto st_case_48
		case 49:
			goto st_case_49
		case 50:
			goto st_case_50
		case 51:
			goto st_case_51
		case 52:
			goto st_case_52
		case 53:
			goto st_case_53
		case 54:
			goto st_case_54
		case 55:
			goto st_case_55
		case 56:
			goto st_case_56
		case 57:
			goto st_case_57
		case 58:
			goto st_case_58
		case 59:
			goto st_case_59
		case 60:
			goto st_case_60
		case 61:
			goto st_case_61
		case 62:
			goto st_case_62
		case 63:
			goto st_case_63
		case 64:
			goto st_case_64
		case 65:
			goto st_case_65
		case 66:
			goto st_case_66
		case 67:
			goto st_case_67
		case 68:
			goto st_case_68
		case 69:
			goto st_case_69
		case 70:
			goto st_case_70
		case 71:
			goto st_case_71
		case 72:
			goto st_case_72
		case 73:
			goto st_case_73
		case 74:
			goto st_case_74
		case 75:
			goto st_case_75
		case 76:
			goto st_case_76
		case 77:
			goto st_case_77
		case 78:
			goto st_case_78
		case 79:
			goto st_case_79
		case 80:
			goto st_case_80
		case 81:
			goto st_case_81
		case 82:
			goto st_case_82
		case 83:
			goto st_case_83
		case 84:
			goto st_case_84
		case 85:
			goto st_case_85
		case 86:
			goto st_case_86
		case 87:
			goto st_case_87
		case 88:
			goto st_case_88
		case 89:
			goto st_case_89
		case 90:
			goto st_case_90
		case 91:
			goto st_case_91
		case 92:
			goto st_case_92
		case 93:
			goto st_case_93
		case 94:
			goto st_case_94
		case 95:
			goto st_case_95
		case 96:
			goto st_case_96
		case 97:
			goto st_case_97
		case 98:
			goto st_case_98
		case 99:
			goto st_case_99
		case 100:
			goto st_case_100
		case 101:
			goto st_case_101
		case 102:
			goto st_case_102
		case 103:
			goto st_case_103
		case 104:
			goto st_case_104
		case 105:
			goto st_case_105
		case 106:
			goto st_case_106
		case 107:
			goto st_case_107
		case 108:
			goto st_case_108
		case 109:
			goto st_case_109
		case 110:
			goto st_case_110
		case 111:
			goto st_case_111
		case 112:
			goto st_case_112
		case 113:
			goto st_case_113
		case 114:
			goto st_case_114
		case 115:
			goto st_case_115
		case 116:
			goto st_case_116
		case 117:
			goto st_case_117
		case 118:
			goto st_case_118
		case 119:
			goto st_case_119
		case 120:
			goto st_case_120
		case 121:
			goto st_case_121
		case 122:
			goto st_case_122
		case 123:
			goto st_case_123
		case 124:
			goto st_case_124
		case 125:
			goto st_case_125
		case 126:
			goto st_case_126
		case 127:
			goto st_case_127
		case 128:
			goto st_case_128
		case 129:
			goto st_case_129
		case 130:
			goto st_case_130
		case 131:
			goto st_case_131
		case 132:
			goto st_case_132
		case 133:
			goto st_case_133
		case 134:
			goto st_case_134
		case 135:
			goto st_case_135
		case 136:
			goto st_case_136
		case 137:
			goto st_case_137
		case 138:
			goto st_case_138
		case 139:
			goto st_case_139
		case 140:
			goto st_case_140
		case 141:
			goto st_case_141
		case 142:
			goto st_case_142
		case 143:
			goto st_case_143
		case 144:
			goto st_case_144
		case 145:
			goto st_case_145
		case 146:
			goto st_case_146
		case 147:
			goto st_case_147
		case 148:
			goto st_case_148
		case 149:
			goto st_case_149
		case 150:
			goto st_case_150
		case 151:
			goto st_case_151
		case 152:
			goto st_case_152
		case 153:
			goto st_case_153
		case 154:
			goto st_case_154
		case 155:
			goto st_case_155
		case 156:
			goto st_case_156
		case 157:
			goto st_case_157
		case 158:
			goto st_case_158
		case 159:
			goto st_case_159
		case 160:
			goto st_case_160
		case 161:
			goto st_case_161
		case 162:
			goto st_case_162
		case 163:
			goto st_case_163
		case 164:
			goto st_case_164
		case 165:
			goto st_case_165
		case 166:
			goto st_case_166
		case 167:
			goto st_case_167
		case 168:
			goto st_case_168
		case 169:
			goto st_case_169
		case 170:
			goto st_case_170
		case 171:
			goto st_case_171
		case 172:
			goto st_case_172
		case 173:
			goto st_case_173
		case 174:
			goto st_case_174
		case 175:
			goto st_case_175
		case 176:
			goto st_case_176
		case 177:
			goto st_case_177
		case 178:
			goto st_case_178
		case 179:
			goto st_case_179
		case 180:
			goto st_case_180
		case 181:
			goto st_case_181
		case 182:
			goto st_case_182
		case 183:
			goto st_case_183
		case 184:
			goto st_case_184
		case 185:
			goto st_case_185
		case 186:
			goto st_case_186
		case 187:
			goto st_case_187
		case 188:
			goto st_case_188
		case 189:
			goto st_case_189
		case 190:
			goto st_case_190
		case 191:
			goto st_case_191
		case 192:
			goto st_case_192
		case 193:
			goto st_case_193
		case 194:
			goto st_case_194
		case 195:
			goto st_case_195
		case 196:
			goto st_case_196
		case 197:
			goto st_case_197
		case 198:
			goto st_case_198
		case 199:
			goto st_case_199
		case 200:
			goto st_case_200
		case 201:
			goto st_case_201
		case 202:
			goto st_case_202
		case 203:
			goto st_case_203
		case 204:
			goto st_case_204
		case 205:
			goto st_case_205
		case 206:
			goto st_case_206
		case 207:
			goto st_case_207
		case 208:
			goto st_case_208
		case 209:
			goto st_case_209
		case 210:
			goto st_case_210
		case 211:
			goto st_case_211
		case 212:
			goto st_case_212
		case 213:
			goto st_case_213
		case 214:
			goto st_case_214
		case 215:
			goto st_case_215
		case 216:
			goto st_case_216
		case 217:
			goto st_case_217
		case 218:
			goto st_case_218
		case 219:
			goto st_case_219
		case 220:
			goto st_case_220
		case 221:
			goto st_case_221
		case 222:
			goto st_case_222
		case 223:
			goto st_case_223
		case 224:
			goto st_case_224
		case 225:
			goto st_case_225
		case 226:
			goto st_case_226
		case 227:
			goto st_case_227
		case 228:
			goto st_case_228
		case 229:
			goto st_case_229
		case 230:
			goto st_case_230
		case 231:
			goto st_case_231
		case 232:
			goto st_case_232
		case 233:
			goto st_case_233
		case 234:
			goto st_case_234
		case 235:
			goto st_case_235
		case 236:
			goto st_case_236
		case 237:
			goto st_case_237
		case 238:
			goto st_case_238
		case 239:
			goto st_case_239
		case 240:
			goto st_case_240
		case 241:
			goto st_case_241
		case 242:
			goto st_case_242
		case 243:
			goto st_case_243
		case 244:
			goto st_case_244
		case 245:
			goto st_case_245
		case 246:
			goto st_case_246
		case 247:
			goto st_case_247
		case 248:
			goto st_case_248
		case 249:
			goto st_case_249
		case 250:
			goto st_case_250
		case 251:
			goto st_case_251
		case 252:
			goto st_case_252
		case 253:
			goto st_case_253
		case 254:
			goto st_case_254
		case 255:
			goto st_case_255
		case 256:
			goto st_case_256
		case 257:
			goto st_case_257
		case 258:
			goto st_case_258
		case 259:
			goto st_case_259
		case 260:
			goto st_case_260
		case 261:
			goto st_case_261
		case 262:
			goto st_case_262
		case 263:
			goto st_case_263
		case 264:
			goto st_case_264
		case 265:
			goto st_case_265
		case 266:
			goto st_case_266
		case 267:
			goto st_case_267
		case 268:
			goto st_case_268
		case 269:
			goto st_case_269
		case 270:
			goto st_case_270
		case 271:
			goto st_case_271
		case 272:
			goto st_case_272
		case 273:
			goto st_case_273
		case 274:
			goto st_case_274
		case 275:
			goto st_case_275
		case 276:
			goto st_case_276
		case 277:
			goto st_case_277
		case 278:
			goto st_case_278
		case 279:
			goto st_case_279
		case 280:
			goto st_case_280
		case 281:
			goto st_case_281
		case 282:
			goto st_case_282
		case 283:
			goto st_case_283
		case 284:
			goto st_case_284
		case 285:
			goto st_case_285
		case 286:
			goto st_case_286
		case 287:
			goto st_case_287
		case 288:
			goto st_case_288
		case 289:
			goto st_case_289
		case 290:
			goto st_case_290
		case 291:
			goto st_case_291
		case 292:
			goto st_case_292
		case 293:
			goto st_case_293
		case 294:
			goto st_case_294
		case 295:
			goto st_case_295
		case 296:
			goto st_case_296
		case 297:
			goto st_case_297
		case 298:
			goto st_case_298
		case 299:
			goto st_case_299
		case 300:
			goto st_case_300
		case 301:
			goto st_case_301
		case 302:
			goto st_case_302
		case 303:
			goto st_case_303
		case 304:
			goto st_case_304
		case 305:
			goto st_case_305
		case 306:
			goto st_case_306
		case 307:
			goto st_case_307
		case 308:
			goto st_case_308
		case 309:
			goto st_case_309
		case 310:
			goto st_case_310
		case 311:
			goto st_case_311
		case 312:
			goto st_case_312
		case 313:
			goto st_case_313
		case 314:
			goto st_case_314
		case 315:
			goto st_case_315
		case 316:
			goto st_case_316
		case 317:
			goto st_case_317
		case 318:
			goto st_case_318
		case 319:
			goto st_case_319
		case 320:
			goto st_case_320
		case 321:
			goto st_case_321
		case 322:
			goto st_case_322
		case 323:
			goto st_case_323
		case 324:
			goto st_case_324
		case 325:
			goto st_case_325
		case 326:
			goto st_case_326
		case 327:
			goto st_case_327
		case 328:
			goto st_case_328
		case 329:
			goto st_case_329
		case 330:
			goto st_case_330
		case 331:
			goto st_case_331
		case 332:
			goto st_case_332
		case 333:
			goto st_case_333
		case 334:
			goto st_case_334
		case 335:
			goto st_case_335
		case 336:
			goto st_case_336
		case 337:
			goto st_case_337
		case 338:
			goto st_case_338
		case 339:
			goto st_case_339
		case 340:
			goto st_case_340
		case 341:
			goto st_case_341
		case 342:
			goto st_case_342
		case 343:
			goto st_case_343
		case 344:
			goto st_case_344
		case 345:
			goto st_case_345
		case 346:
			goto st_case_346
		case 347:
			goto st_case_347
		case 348:
			goto st_case_348
		case 349:
			goto st_case_349
		case 350:
			goto st_case_350
		case 351:
			goto st_case_351
		case 352:
			goto st_case_352
		case 353:
			goto st_case_353
		case 354:
			goto st_case_354
		case 355:
			goto st_case_355
		case 356:
			goto st_case_356
		case 357:
			goto st_case_357
		case 358:
			goto st_case_358
		case 359:
			goto st_case_359
		case 360:
			goto st_case_360
		case 361:
			goto st_case_361
		case 362:
			goto st_case_362
		case 363:
			goto st_case_363
		case 364:
			goto st_case_364
		case 365:
			goto st_case_365
		case 366:
			goto st_case_366
		case 367:
			goto st_case_367
		case 368:
			goto st_case_368
		case 369:
			goto st_case_369
		case 370:
			goto st_case_370
		case 371:
			goto st_case_371
		case 372:
			goto st_case_372
		case 373:
			goto st_case_373
		case 374:
			goto st_case_374
		case 375:
			goto st_case_375
		case 376:
			goto st_case_376
		case 377:
			goto st_case_377
		case 378:
			goto st_case_378
		case 379:
			goto st_case_379
		case 380:
			goto st_case_380
		case 381:
			goto st_case_381
		case 382:
			goto st_case_382
		case 383:
			goto st_case_383
		case 384:
			goto st_case_384
		case 385:
			goto st_case_385
		case 386:
			goto st_case_386
		case 387:
			goto st_case_387
		case 388:
			goto st_case_388
		case 389:
			goto st_case_389
		case 390:
			goto st_case_390
		case 391:
			goto st_case_391
		case 392:
			goto st_case_392
		case 393:
			goto st_case_393
		case 394:
			goto st_case_394
		case 395:
			goto st_case_395
		case 396:
			goto st_case_396
		case 397:
			goto st_case_397
		case 398:
			goto st_case_398
		case 399:
			goto st_case_399
		case 400:
			goto st_case_400
		case 401:
			goto st_case_401
		case 402:
			goto st_case_402
		case 403:
			goto st_case_403
		case 404:
			goto st_case_404
		case 405:
			goto st_case_405
		case 406:
			goto st_case_406
		case 407:
			goto st_case_407
		case 408:
			goto st_case_408
		case 409:
			goto st_case_409
		case 410:
			goto st_case_410
		case 411:
			goto st_case_411
		case 412:
			goto st_case_412
		case 413:
			goto st_case_413
		case 414:
			goto st_case_414
		case 415:
			goto st_case_415
		}
		goto st_out
	tr2:
		lex.te = (lex.p) + 1
		{
			bs := lex.data[lex.ts:lex.te]

			var str string
			var err error
			if len(bs) > 0 && bs[0] == '\'' {
				str, err = UnquoteSingleQuoted(bs)
			} else {
				str, err = UnquoteDoubleQuoted(bs)
			}

			if err != nil {
				lex.AppendError(err)
			} else {
				out.str = str
				tok = LITERAL
			}

			{
				(lex.p)++
				lex.cs = 19
				goto _out
			}
		}
		goto st19
	tr7:
		switch lex.act {
		case 1:
			{
				(lex.p) = (lex.te) - 1
				tok = INCLUDE
				{
					(lex.p)++
					lex.cs = 19
					goto _out
				}
			}
		case 2:
			{
				(lex.p) = (lex.te) - 1
				tok = CPP_INCLUDE
				{
					(lex.p)++
					lex.cs = 19
					goto _out
				}
			}
		case 3:
			{
				(lex.p) = (lex.te) - 1
				tok = NAMESPACE
				{
					(lex.p)++
					lex.cs = 19
					goto _out
				}
			}
		case 4:
			{
				(lex.p) = (lex.te) - 1
				tok = VOID
				{
					(lex.p)++
					lex.cs = 19
					goto _out
				}
			}
		case 5:
			{
				(lex.p) = (lex.te) - 1
				tok = BOOL
				{
					(lex.p)++
					lex.cs = 19
					goto _out
				}
			}
		case 6:
			{
				(lex.p) = (lex.te) - 1
				tok = BYTE
				{
					(lex.p)++
					lex.cs = 19
					goto _out
				}
			}
		case 7:
			{
				(lex.p) = (lex.te) - 1
				tok = I8
				{
					(lex.p)++
					lex.cs = 19
					goto _out
				}
			}
		case 8:
			{
				(lex.p) = (lex.te) - 1
				tok = I16
				{
					(lex.p)++
					lex.cs = 19
					goto _out
				}
			}
		case 9:
			{
				(lex.p) = (lex.te) - 1
				tok = I32
				{
					(lex.p)++
					lex.cs = 19
					goto _out
				}
			}
		case 10:
			{
				(lex.p) = (lex.te) - 1
				tok = I64
				{
					(lex.p)++
					lex.cs = 19
					goto _out
				}
			}
		case 11:
			{
				(lex.p) = (lex.te) - 1
				tok = DOUBLE
				{
					(lex.p)++
					lex.cs = 19
					goto _out
				}
			}
		case 12:
			{
				(lex.p) = (lex.te) - 1
				tok = STRING
				{
					(lex.p)++
					lex.cs = 19
					goto _out
				}
			}
		case 13:
			{
				(lex.p) = (lex.te) - 1
				tok = BINARY
				{
					(lex.p)++
					lex.cs = 19
					goto _out
				}
			}
		case 14:
			{
				(lex.p) = (lex.te) - 1
				tok = MAP
				{
					(lex.p)++
					lex.cs = 19
					goto _out
				}
			}
		case 15:
			{
				(lex.p) = (lex.te) - 1
				tok = LIST
				{
					(lex.p)++
					lex.cs = 19
					goto _out
				}
			}
		case 16:
			{
				(lex.p) = (lex.te) - 1
				tok = SET
				{
					(lex.p)++
					lex.cs = 19
					goto _out
				}
			}
		case 17:
			{
				(lex.p) = (lex.te) - 1
				tok = ONEWAY
				{
					(lex.p)++
					lex.cs = 19
					goto _out
				}
			}
		case 18:
			{
				(lex.p) = (lex.te) - 1
				tok = TYPEDEF
				{
					(lex.p)++
					lex.cs = 19
					goto _out
				}
			}
		case 19:
			{
				(lex.p) = (lex.te) - 1
				tok = STRUCT
				{
					(lex.p)++
					lex.cs = 19
					goto _out
				}
			}
		case 20:
			{
				(lex.p) = (lex.te) - 1
				tok = UNION
				{
					(lex.p)++
					lex.cs = 19
					goto _out
				}
			}
		case 21:
			{
				(lex.p) = (lex.te) - 1
				tok = EXCEPTION
				{
					(lex.p)++
					lex.cs = 19
					goto _out
				}
			}
		case 22:
			{
				(lex.p) = (lex.te) - 1
				tok = EXTENDS
				{
					(lex.p)++
					lex.cs = 19
					goto _out
				}
			}
		case 23:
			{
				(lex.p) = (lex.te) - 1
				tok = THROWS
				{
					(lex.p)++
					lex.cs = 19
					goto _out
				}
			}
		case 24:
			{
				(lex.p) = (lex.te) - 1
				tok = SERVICE
				{
					(lex.p)++
					lex.cs = 19
					goto _out
				}
			}
		case 25:
			{
				(lex.p) = (lex.te) - 1
				tok = ENUM
				{
					(lex.p)++
					lex.cs = 19
					goto _out
				}
			}
		case 26:
			{
				(lex.p) = (lex.te) - 1
				tok = CONST
				{
					(lex.p)++
					lex.cs = 19
					goto _out
				}
			}
		case 27:
			{
				(lex.p) = (lex.te) - 1
				tok = REQUIRED
				{
					(lex.p)++
					lex.cs = 19
					goto _out
				}
			}
		case 28:
			{
				(lex.p) = (lex.te) - 1
				tok = OPTIONAL
				{
					(lex.p)++
					lex.cs = 19
					goto _out
				}
			}
		case 29:
			{
				(lex.p) = (lex.te) - 1
				tok = TRUE
				{
					(lex.p)++
					lex.cs = 19
					goto _out
				}
			}
		case 30:
			{
				(lex.p) = (lex.te) - 1
				tok = FALSE
				{
					(lex.p)++
					lex.cs = 19
					goto _out
				}
			}
		case 37:
			{
				(lex.p) = (lex.te) - 1

				str := string(lex.data[lex.ts:lex.te])
				base := 10
				if len(str) > 2 && str[0:2] == "0x" {
					// Hex constant
					base = 16
				}

				if i64, err := strconv.ParseInt(str, base, 64); err != nil {
					lex.AppendError(err)
				} else {
					out.i64 = i64
					tok = INTCONSTANT
				}
				{
					(lex.p)++
					lex.cs = 19
					goto _out
				}
			}
		case 38:
			{
				(lex.p) = (lex.te) - 1

				str := string(lex.data[lex.ts:lex.te])
				if dub, err := strconv.ParseFloat(str, 64); err != nil {
					lex.AppendError(err)
				} else {
					out.dub = dub
					tok = DUBCONSTANT
				}
				{
					(lex.p)++
					lex.cs = 19
					goto _out
				}
			}
		case 40:
			{
				(lex.p) = (lex.te) - 1

				lex.AppendError(fmt.Errorf("%q is a reserved keyword", reservedKeyword))
				{
					(lex.p)++
					lex.cs = 19
					goto _out
				}
			}
		case 41:
			{
				(lex.p) = (lex.te) - 1

				out.str = string(lex.data[lex.ts:lex.te])
				tok = IDENTIFIER
				{
					(lex.p)++
					lex.cs = 19
					goto _out
				}
			}
		}

		goto st19
	tr16:
		lex.te = (lex.p) + 1

		goto st19
	tr21:

		lex.lastDocstring = string(lex.data[lex.docstringStart : lex.p+1])
		lex.linesSinceDocstring = 0

		lex.te = (lex.p) + 1

		goto st19
	tr22:
		(lex.p) = (lex.te) - 1

		goto st19
	tr25:
		(lex.p) = (lex.te) - 1
		{
			str := string(lex.data[lex.ts:lex.te])
			base := 10
			if len(str) > 2 && str[0:2] == "0x" {
				// Hex constant
				base = 16
			}

			if i64, err := strconv.ParseInt(str, base, 64); err != nil {
				lex.AppendError(err)
			} else {
				out.i64 = i64
				tok = INTCONSTANT
			}
			{
				(lex.p)++
				lex.cs = 19
				goto _out
			}
		}
		goto st19
	tr28:
		lex.te = (lex.p) + 1

		goto st19
	tr29:

		lex.line++
		lex.lineStart = lex.p + 1
		lex.linesSinceDocstring++

		lex.te = (lex.p) + 1

		goto st19
	tr30:
		lex.te = (lex.p) + 1
		{
			tok = int(lex.data[lex.ts])
			{
				(lex.p)++
				lex.cs = 19
				goto _out
			}
		}
		goto st19
	tr58:
		lex.te = (lex.p)
		(lex.p)--

		goto st19
	tr59:
		lex.te = (lex.p)
		(lex.p)--
		{
			str := string(lex.data[lex.ts:lex.te])
			base := 10
			if len(str) > 2 && str[0:2] == "0x" {
				// Hex constant
				base = 16
			}

			if i64, err := strconv.ParseInt(str, base, 64); err != nil {
				lex.AppendError(err)
			} else {
				out.i64 = i64
				tok = INTCONSTANT
			}
			{
				(lex.p)++
				lex.cs = 19
				goto _out
			}
		}
		goto st19
	tr62:
		lex.te = (lex.p)
		(lex.p)--
		{
			str := string(lex.data[lex.ts:lex.te])
			if dub, err := strconv.ParseFloat(str, 64); err != nil {
				lex.AppendError(err)
			} else {
				out.dub = dub
				tok = DUBCONSTANT
			}
			{
				(lex.p)++
				lex.cs = 19
				goto _out
			}
		}
		goto st19
	tr63:
		lex.te = (lex.p)
		(lex.p)--

		goto st19
	tr65:
		lex.te = (lex.p)
		(lex.p)--
		{
			out.str = string(lex.data[lex.ts:lex.te])
			tok = IDENTIFIER
			{
				(lex.p)++
				lex.cs = 19
				goto _out
			}
		}
		goto st19
	tr71:
		lex.te = (lex.p)
		(lex.p)--
		{
			lex.AppendError(fmt.Errorf("%q is a reserved keyword", reservedKeyword))
			{
				(lex.p)++
				lex.cs = 19
				goto _out
			}
		}
		goto st19
	tr132:
		lex.te = (lex.p)
		(lex.p)--
		{
			tok = BINARY
			{
				(lex.p)++
				lex.cs = 19
				goto _out
			}
		}
		goto st19
	tr137:
		lex.te = (lex.p)
		(lex.p)--
		{
			tok = BOOL
			{
				(lex.p)++
				lex.cs = 19
				goto _out
			}
		}
		goto st19
	tr144:
		lex.te = (lex.p)
		(lex.p)--
		{
			tok = BYTE
			{
				(lex.p)++
				lex.cs = 19
				goto _out
			}
		}
		goto st19
	tr160:
		lex.te = (lex.p)
		(lex.p)--
		{
			tok = CONST
			{
				(lex.p)++
				lex.cs = 19
				goto _out
			}
		}
		goto st19
	tr174:
		lex.te = (lex.p)
		(lex.p)--
		{
			tok = CPP_INCLUDE
			{
				(lex.p)++
				lex.cs = 19
				goto _out
			}
		}
		goto st19
	tr192:
		lex.te = (lex.p)
		(lex.p)--
		{
			tok = DOUBLE
			{
				(lex.p)++
				lex.cs = 19
				goto _out
			}
		}
		goto st19
	tr221:
		lex.te = (lex.p)
		(lex.p)--
		{
			tok = ENUM
			{
				(lex.p)++
				lex.cs = 19
				goto _out
			}
		}
		goto st19
	tr232:
		lex.te = (lex.p)
		(lex.p)--
		{
			tok = EXCEPTION
			{
				(lex.p)++
				lex.cs = 19
				goto _out
			}
		}
		goto st19
	tr239:
		lex.te = (lex.p)
		(lex.p)--
		{
			tok = EXTENDS
			{
				(lex.p)++
				lex.cs = 19
				goto _out
			}
		}
		goto st19
	tr250:
		lex.te = (lex.p)
		(lex.p)--
		{
			tok = FALSE
			{
				(lex.p)++
				lex.cs = 19
				goto _out
			}
		}
		goto st19
	tr276:
		lex.te = (lex.p)
		(lex.p)--
		{
			tok = I16
			{
				(lex.p)++
				lex.cs = 19
				goto _out
			}
		}
		goto st19
	tr280:
		lex.te = (lex.p)
		(lex.p)--
		{
			tok = I32
			{
				(lex.p)++
				lex.cs = 19
				goto _out
			}
		}
		goto st19
	tr284:
		lex.te = (lex.p)
		(lex.p)--
		{
			tok = I64
			{
				(lex.p)++
				lex.cs = 19
				goto _out
			}
		}
		goto st19
	tr287:
		lex.te = (lex.p)
		(lex.p)--
		{
			tok = I8
			{
				(lex.p)++
				lex.cs = 19
				goto _out
			}
		}
		goto st19
	tr304:
		lex.te = (lex.p)
		(lex.p)--
		{
			tok = INCLUDE
			{
				(lex.p)++
				lex.cs = 19
				goto _out
			}
		}
		goto st19
	tr323:
		lex.te = (lex.p)
		(lex.p)--
		{
			tok = LIST
			{
				(lex.p)++
				lex.cs = 19
				goto _out
			}
		}
		goto st19
	tr329:
		lex.te = (lex.p)
		(lex.p)--
		{
			tok = MAP
			{
				(lex.p)++
				lex.cs = 19
				goto _out
			}
		}
		goto st19
	tr343:
		lex.te = (lex.p)
		(lex.p)--
		{
			tok = NAMESPACE
			{
				(lex.p)++
				lex.cs = 19
				goto _out
			}
		}
		goto st19
	tr353:
		lex.te = (lex.p)
		(lex.p)--
		{
			tok = ONEWAY
			{
				(lex.p)++
				lex.cs = 19
				goto _out
			}
		}
		goto st19
	tr362:
		lex.te = (lex.p)
		(lex.p)--
		{
			tok = OPTIONAL
			{
				(lex.p)++
				lex.cs = 19
				goto _out
			}
		}
		goto st19
	tr395:
		lex.te = (lex.p)
		(lex.p)--
		{
			tok = REQUIRED
			{
				(lex.p)++
				lex.cs = 19
				goto _out
			}
		}
		goto st19
	tr410:
		lex.te = (lex.p)
		(lex.p)--
		{
			tok = SERVICE
			{
				(lex.p)++
				lex.cs = 19
				goto _out
			}
		}
		goto st19
	tr413:
		lex.te = (lex.p)
		(lex.p)--
		{
			tok = SET
			{
				(lex.p)++
				lex.cs = 19
				goto _out
			}
		}
		goto st19
	tr422:
		lex.te = (lex.p)
		(lex.p)--
		{
			tok = STRING
			{
				(lex.p)++
				lex.cs = 19
				goto _out
			}
		}
		goto st19
	tr427:
		lex.te = (lex.p)
		(lex.p)--
		{
			tok = STRUCT
			{
				(lex.p)++
				lex.cs = 19
				goto _out
			}
		}
		goto st19
	tr444:
		lex.te = (lex.p)
		(lex.p)--
		{
			tok = THROWS
			{
				(lex.p)++
				lex.cs = 19
				goto _out
			}
		}
		goto st19
	tr454:
		lex.te = (lex.p)
		(lex.p)--
		{
			tok = TRUE
			{
				(lex.p)++
				lex.cs = 19
				goto _out
			}
		}
		goto st19
	tr462:
		lex.te = (lex.p)
		(lex.p)--
		{
			tok = TYPEDEF
			{
				(lex.p)++
				lex.cs = 19
				goto _out
			}
		}
		goto st19
	tr473:
		lex.te = (lex.p)
		(lex.p)--
		{
			tok = UNION
			{
				(lex.p)++
				lex.cs = 19
				goto _out
			}
		}
		goto st19
	tr485:
		lex.te = (lex.p)
		(lex.p)--
		{
			tok = VOID
			{
				(lex.p)++
				lex.cs = 19
				goto _out
			}
		}
		goto st19
	st19:
		lex.ts = 0

		if (lex.p)++; (lex.p) == (lex.pe) {
			goto _test_eof19
		}
	st_case_19:
		lex.ts = (lex.p)

		switch lex.data[(lex.p)] {
		case 9:
			goto tr28
		case 10:
			goto tr29
		case 13:
			goto tr28
		case 32:
			goto tr28
		case 34:
			goto st1
		case 35:
			goto st20
		case 39:
			goto st3
		case 43:
			goto st5
		case 45:
			goto st5
		case 47:
			goto st8
		case 48:
			goto tr33
		case 66:
			goto tr34
		case 69:
			goto tr35
		case 91:
			goto tr30
		case 93:
			goto tr30
		case 95:
			goto tr36
		case 97:
			goto tr37
		case 98:
			goto tr38
		case 99:
			goto tr39
		case 100:
			goto tr40
		case 101:
			goto tr41
		case 102:
			goto tr42
		case 103:
			goto tr43
		case 105:
			goto tr44
		case 108:
			goto tr45
		case 109:
			goto tr46
		case 110:
			goto tr47
		case 111:
			goto tr48
		case 112:
			goto tr49
		case 114:
			goto tr50
		case 115:
			goto tr51
		case 116:
			goto tr52
		case 117:
			goto tr53
		case 118:
			goto tr54
		case 119:
			goto tr55
		case 120:
			goto tr56
		case 121:
			goto tr57
		case 123:
			goto tr30
		case 125:
			goto tr30
		}
		switch {
		case lex.data[(lex.p)] < 58:
			switch {
			case lex.data[(lex.p)] > 44:
				if 49 <= lex.data[(lex.p)] && lex.data[(lex.p)] <= 57 {
					goto tr6
				}
			case lex.data[(lex.p)] >= 40:
				goto tr30
			}
		case lex.data[(lex.p)] > 62:
			switch {
			case lex.data[(lex.p)] > 90:
				if 104 <= lex.data[(lex.p)] && lex.data[(lex.p)] <= 122 {
					goto tr27
				}
			case lex.data[(lex.p)] >= 65:
				goto tr27
			}
		default:
			goto tr30
		}
		goto st0
	st_case_0:
	st0:
		lex.cs = 0
		goto _out
	st1:
		if (lex.p)++; (lex.p) == (lex.pe) {
			goto _test_eof1
		}
	st_case_1:
		switch lex.data[(lex.p)] {
		case 10:
			goto st0
		case 34:
			goto tr2
		case 92:
			goto st2
		}
		goto st1
	st2:
		if (lex.p)++; (lex.p) == (lex.pe) {
			goto _test_eof2
		}
	st_case_2:
		goto st1
	st20:
		if (lex.p)++; (lex.p) == (lex.pe) {
			goto _test_eof20
		}
	st_case_20:
		if lex.data[(lex.p)] == 10 {
			goto tr58
		}
		goto st20
	st3:
		if (lex.p)++; (lex.p) == (lex.pe) {
			goto _test_eof3
		}
	st_case_3:
		switch lex.data[(lex.p)] {
		case 10:
			goto st0
		case 39:
			goto tr2
		case 92:
			goto st4
		}
		goto st3
	st4:
		if (lex.p)++; (lex.p) == (lex.pe) {
			goto _test_eof4
		}
	st_case_4:
		goto st3
	st5:
		if (lex.p)++; (lex.p) == (lex.pe) {
			goto _test_eof5
		}
	st_case_5:
		if 48 <= lex.data[(lex.p)] && lex.data[(lex.p)] <= 57 {
			goto tr6
		}
		goto st0
	tr6:
		lex.te = (lex.p) + 1

		lex.act = 37
		goto st21
	st21:
		if (lex.p)++; (lex.p) == (lex.pe) {
			goto _test_eof21
		}
	st_case_21:
		switch lex.data[(lex.p)] {
		case 46:
			goto tr60
		case 69:
			goto st6
		case 101:
			goto st6
		}
		if 48 <= lex.data[(lex.p)] && lex.data[(lex.p)] <= 57 {
			goto tr6
		}
		goto tr59
	tr60:
		lex.te = (lex.p) + 1

		lex.act = 38
		goto st22
	st22:
		if (lex.p)++; (lex.p) == (lex.pe) {
			goto _test_eof22
		}
	st_case_22:
		switch lex.data[(lex.p)] {
		case 69:
			goto st6
		case 101:
			goto st6
		}
		if 48 <= lex.data[(lex.p)] && lex.data[(lex.p)] <= 57 {
			goto tr60
		}
		goto tr62
	st6:
		if (lex.p)++; (lex.p) == (lex.pe) {
			goto _test_eof6
		}
	st_case_6:
		switch lex.data[(lex.p)] {
		case 43:
			goto st7
		case 45:
			goto st7
		}
		if 48 <= lex.data[(lex.p)] && lex.data[(lex.p)] <= 57 {
			goto st23
		}
		goto tr7
	st7:
		if (lex.p)++; (lex.p) == (lex.pe) {
			goto _test_eof7
		}
	st_case_7:
		if 48 <= lex.data[(lex.p)] && lex.data[(lex.p)] <= 57 {
			goto st23
		}
		goto tr7
	st23:
		if (lex.p)++; (lex.p) == (lex.pe) {
			goto _test_eof23
		}
	st_case_23:
		if 48 <= lex.data[(lex.p)] && lex.data[(lex.p)] <= 57 {
			goto st23
		}
		goto tr62
	st8:
		if (lex.p)++; (lex.p) == (lex.pe) {
			goto _test_eof8
		}
	st_case_8:
		switch lex.data[(lex.p)] {
		case 42:
			goto st9
		case 47:
			goto st20
		}
		goto st0
	st9:
		if (lex.p)++; (lex.p) == (lex.pe) {
			goto _test_eof9
		}
	st_case_9:
		switch lex.data[(lex.p)] {
		case 10:
			goto tr13
		case 42:
			goto tr14
		}
		goto st10
	tr13:

		lex.line++
		lex.lineStart = lex.p + 1
		lex.linesSinceDocstring++

		goto st10
	st10:
		if (lex.p)++; (lex.p) == (lex.pe) {
			goto _test_eof10
		}
	st_case_10:
		switch lex.data[(lex.p)] {
		case 10:
			goto tr13
		case 42:
			goto st11
		}
		goto st10
	st11:
		if (lex.p)++; (lex.p) == (lex.pe) {
			goto _test_eof11
		}
	st_case_11:
		switch lex.data[(lex.p)] {
		case 10:
			goto tr13
		case 42:
			goto st11
		case 47:
			goto tr16
		}
		goto st10
	tr14:
		lex.docstringStart = lex.p - 2
		goto st12
	st12:
		if (lex.p)++; (lex.p) == (lex.pe) {
			goto _test_eof12
		}
	st_case_12:
		switch lex.data[(lex.p)] {
		case 10:
			goto tr18
		case 42:
			goto st14
		case 47:
			goto tr20
		}
		goto st13
	tr18:

		lex.line++
		lex.lineStart = lex.p + 1
		lex.linesSinceDocstring++

		goto st13
	st13:
		if (lex.p)++; (lex.p) == (lex.pe) {
			goto _test_eof13
		}
	st_case_13:
		switch lex.data[(lex.p)] {
		case 10:
			goto tr18
		case 42:
			goto st14
		}
		goto st13
	st14:
		if (lex.p)++; (lex.p) == (lex.pe) {
			goto _test_eof14
		}
	st_case_14:
		switch lex.data[(lex.p)] {
		case 10:
			goto tr18
		case 42:
			goto st14
		case 47:
			goto tr21
		}
		goto st13
	tr20:
		lex.te = (lex.p) + 1

		goto st24
	st24:
		if (lex.p)++; (lex.p) == (lex.pe) {
			goto _test_eof24
		}
	st_case_24:
		if lex.data[(lex.p)] == 42 {
			goto st16
		}
		goto st15
	st15:
		if (lex.p)++; (lex.p) == (lex.pe) {
			goto _test_eof15
		}
	st_case_15:
		if lex.data[(lex.p)] == 42 {
			goto st16
		}
		goto st15
	st16:
		if (lex.p)++; (lex.p) == (lex.pe) {
			goto _test_eof16
		}
	st_case_16:
		switch lex.data[(lex.p)] {
		case 42:
			goto st16
		case 47:
			goto tr21
		}
		goto st15
	tr33:
		lex.te = (lex.p) + 1

		lex.act = 37
		goto st25
	st25:
		if (lex.p)++; (lex.p) == (lex.pe) {
			goto _test_eof25
		}
	st_case_25:
		switch lex.data[(lex.p)] {
		case 46:
			goto tr60
		case 69:
			goto st6
		case 101:
			goto st6
		case 120:
			goto st17
		}
		if 48 <= lex.data[(lex.p)] && lex.data[(lex.p)] <= 57 {
			goto tr6
		}
		goto tr59
	st17:
		if (lex.p)++; (lex.p) == (lex.pe) {
			goto _test_eof17
		}
	st_case_17:
		switch {
		case lex.data[(lex.p)] < 65:
			if 48 <= lex.data[(lex.p)] && lex.data[(lex.p)] <= 57 {
				goto st26
			}
		case lex.data[(lex.p)] > 70:
			if 97 <= lex.data[(lex.p)] && lex.data[(lex.p)] <= 102 {
				goto st26
			}
		default:
			goto st26
		}
		goto tr25
	st26:
		if (lex.p)++; (lex.p) == (lex.pe) {
			goto _test_eof26
		}
	st_case_26:
		switch {
		case lex.data[(lex.p)] < 65:
			if 48 <= lex.data[(lex.p)] && lex.data[(lex.p)] <= 57 {
				goto st26
			}
		case lex.data[(lex.p)] > 70:
			if 97 <= lex.data[(lex.p)] && lex.data[(lex.p)] <= 102 {
				goto st26
			}
		default:
			goto st26
		}
		goto tr59
	tr27:
		lex.te = (lex.p) + 1

		lex.act = 41
		goto st27
	st27:
		if (lex.p)++; (lex.p) == (lex.pe) {
			goto _test_eof27
		}
	st_case_27:
		switch lex.data[(lex.p)] {
		case 46:
			goto st18
		case 95:
			goto tr27
		}
		switch {
		case lex.data[(lex.p)] < 65:
			if 48 <= lex.data[(lex.p)] && lex.data[(lex.p)] <= 57 {
				goto tr27
			}
		case lex.data[(lex.p)] > 90:
			if 97 <= lex.data[(lex.p)] && lex.data[(lex.p)] <= 122 {
				goto tr27
			}
		default:
			goto tr27
		}
		goto tr65
	st18:
		if (lex.p)++; (lex.p) == (lex.pe) {
			goto _test_eof18
		}
	st_case_18:
		if lex.data[(lex.p)] == 95 {
			goto tr27
		}
		switch {
		case lex.data[(lex.p)] < 65:
			if 48 <= lex.data[(lex.p)] && lex.data[(lex.p)] <= 57 {
				goto tr27
			}
		case lex.data[(lex.p)] > 90:
			if 97 <= lex.data[(lex.p)] && lex.data[(lex.p)] <= 122 {
				goto tr27
			}
		default:
			goto tr27
		}
		goto tr7
	tr34:
		lex.te = (lex.p) + 1

		lex.act = 41
		goto st28
	st28:
		if (lex.p)++; (lex.p) == (lex.pe) {
			goto _test_eof28
		}
	st_case_28:
		switch lex.data[(lex.p)] {
		case 46:
			goto st18
		case 69:
			goto tr67
		case 95:
			goto tr27
		}
		switch {
		case lex.data[(lex.p)] < 65:
			if 48 <= lex.data[(lex.p)] && lex.data[(lex.p)] <= 57 {
				goto tr27
			}
		case lex.data[(lex.p)] > 90:
			if 97 <= lex.data[(lex.p)] && lex.data[(lex.p)] <= 122 {
				goto tr27
			}
		default:
			goto tr27
		}
		goto tr65
	tr67:
		lex.te = (lex.p) + 1

		lex.act = 41
		goto st29
	st29:
		if (lex.p)++; (lex.p) == (lex.pe) {
			goto _test_eof29
		}
	st_case_29:
		switch lex.data[(lex.p)] {
		case 46:
			goto st18
		case 71:
			goto tr68
		case 95:
			goto tr27
		}
		switch {
		case lex.data[(lex.p)] < 65:
			if 48 <= lex.data[(lex.p)] && lex.data[(lex.p)] <= 57 {
				goto tr27
			}
		case lex.data[(lex.p)] > 90:
			if 97 <= lex.data[(lex.p)] && lex.data[(lex.p)] <= 122 {
				goto tr27
			}
		default:
			goto tr27
		}
		goto tr65
	tr68:
		lex.te = (lex.p) + 1

		lex.act = 41
		goto st30
	st30:
		if (lex.p)++; (lex.p) == (lex.pe) {
			goto _test_eof30
		}
	st_case_30:
		switch lex.data[(lex.p)] {
		case 46:
			goto st18
		case 73:
			goto tr69
		case 95:
			goto tr27
		}
		switch {
		case lex.data[(lex.p)] < 65:
			if 48 <= lex.data[(lex.p)] && lex.data[(lex.p)] <= 57 {
				goto tr27
			}
		case lex.data[(lex.p)] > 90:
			if 97 <= lex.data[(lex.p)] && lex.data[(lex.p)] <= 122 {
				goto tr27
			}
		default:
			goto tr27
		}
		goto tr65
	tr69:
		lex.te = (lex.p) + 1

		lex.act = 41
		goto st31
	st31:
		if (lex.p)++; (lex.p) == (lex.pe) {
			goto _test_eof31
		}
	st_case_31:
		switch lex.data[(lex.p)] {
		case 46:
			goto st18
		case 78:
			goto tr70
		case 95:
			goto tr27
		}
		switch {
		case lex.data[(lex.p)] < 65:
			if 48 <= lex.data[(lex.p)] && lex.data[(lex.p)] <= 57 {
				goto tr27
			}
		case lex.data[(lex.p)] > 90:
			if 97 <= lex.data[(lex.p)] && lex.data[(lex.p)] <= 122 {
				goto tr27
			}
		default:
			goto tr27
		}
		goto tr65
	tr70:
		lex.te = (lex.p) + 1

		reservedKeyword = string(lex.data[lex.ts:lex.te])
		lex.act = 40
		goto st32
	st32:
		if (lex.p)++; (lex.p) == (lex.pe) {
			goto _test_eof32
		}
	st_case_32:
		switch lex.data[(lex.p)] {
		case 9:
			goto st33
		case 10:
			goto tr73
		case 13:
			goto st33
		case 32:
			goto st33
		case 46:
			goto st18
		case 95:
			goto tr27
		}
		switch {
		case lex.data[(lex.p)] < 65:
			if 48 <= lex.data[(lex.p)] && lex.data[(lex.p)] <= 57 {
				goto tr27
			}
		case lex.data[(lex.p)] > 90:
			if 97 <= lex.data[(lex.p)] && lex.data[(lex.p)] <= 122 {
				goto tr27
			}
		default:
			goto tr27
		}
		goto tr71
	tr73:

		lex.line++
		lex.lineStart = lex.p + 1
		lex.linesSinceDocstring++

		goto st33
	st33:
		if (lex.p)++; (lex.p) == (lex.pe) {
			goto _test_eof33
		}
	st_case_33:
		switch lex.data[(lex.p)] {
		case 9:
			goto st33
		case 10:
			goto tr73
		case 13:
			goto st33
		case 32:
			goto st33
		}
		goto tr71
	tr35:
		lex.te = (lex.p) + 1

		lex.act = 41
		goto st34
	st34:
		if (lex.p)++; (lex.p) == (lex.pe) {
			goto _test_eof34
		}
	st_case_34:
		switch lex.data[(lex.p)] {
		case 46:
			goto st18
		case 78:
			goto tr74
		case 95:
			goto tr27
		}
		switch {
		case lex.data[(lex.p)] < 65:
			if 48 <= lex.data[(lex.p)] && lex.data[(lex.p)] <= 57 {
				goto tr27
			}
		case lex.data[(lex.p)] > 90:
			if 97 <= lex.data[(lex.p)] && lex.data[(lex.p)] <= 122 {
				goto tr27
			}
		default:
			goto tr27
		}
		goto tr65
	tr74:
		lex.te = (lex.p) + 1

		lex.act = 41
		goto st35
	st35:
		if (lex.p)++; (lex.p) == (lex.pe) {
			goto _test_eof35
		}
	st_case_35:
		switch lex.data[(lex.p)] {
		case 46:
			goto st18
		case 68:
			goto tr70
		case 95:
			goto tr27
		}
		switch {
		case lex.data[(lex.p)] < 65:
			if 48 <= lex.data[(lex.p)] && lex.data[(lex.p)] <= 57 {
				goto tr27
			}
		case lex.data[(lex.p)] > 90:
			if 97 <= lex.data[(lex.p)] && lex.data[(lex.p)] <= 122 {
				goto tr27
			}
		default:
			goto tr27
		}
		goto tr65
	tr36:
		lex.te = (lex.p) + 1

		lex.act = 41
		goto st36
	st36:
		if (lex.p)++; (lex.p) == (lex.pe) {
			goto _test_eof36
		}
	st_case_36:
		switch lex.data[(lex.p)] {
		case 46:
			goto st18
		case 95:
			goto tr75
		}
		switch {
		case lex.data[(lex.p)] < 65:
			if 48 <= lex.data[(lex.p)] && lex.data[(lex.p)] <= 57 {
				goto tr27
			}
		case lex.data[(lex.p)] > 90:
			if 97 <= lex.data[(lex.p)] && lex.data[(lex.p)] <= 122 {
				goto tr27
			}
		default:
			goto tr27
		}
		goto tr65
	tr75:
		lex.te = (lex.p) + 1

		lex.act = 41
		goto st37
	st37:
		if (lex.p)++; (lex.p) == (lex.pe) {
			goto _test_eof37
		}
	st_case_37:
		switch lex.data[(lex.p)] {
		case 46:
			goto st18
		case 67:
			goto tr76
		case 68:
			goto tr77
		case 70:
			goto tr78
		case 76:
			goto tr79
		case 77:
			goto tr80
		case 78:
			goto tr81
		case 95:
			goto tr27
		}
		switch {
		case lex.data[(lex.p)] < 65:
			if 48 <= lex.data[(lex.p)] && lex.data[(lex.p)] <= 57 {
				goto tr27
			}
		case lex.data[(lex.p)] > 90:
			if 97 <= lex.data[(lex.p)] && lex.data[(lex.p)] <= 122 {
				goto tr27
			}
		default:
			goto tr27
		}
		goto tr65
	tr76:
		lex.te = (lex.p) + 1

		lex.act = 41
		goto st38
	st38:
		if (lex.p)++; (lex.p) == (lex.pe) {
			goto _test_eof38
		}
	st_case_38:
		switch lex.data[(lex.p)] {
		case 46:
			goto st18
		case 76:
			goto tr82
		case 95:
			goto tr27
		}
		switch {
		case lex.data[(lex.p)] < 65:
			if 48 <= lex.data[(lex.p)] && lex.data[(lex.p)] <= 57 {
				goto tr27
			}
		case lex.data[(lex.p)] > 90:
			if 97 <= lex.data[(lex.p)] && lex.data[(lex.p)] <= 122 {
				goto tr27
			}
		default:
			goto tr27
		}
		goto tr65
	tr82:
		lex.te = (lex.p) + 1

		lex.act = 41
		goto st39
	st39:
		if (lex.p)++; (lex.p) == (lex.pe) {
			goto _test_eof39
		}
	st_case_39:
		switch lex.data[(lex.p)] {
		case 46:
			goto st18
		case 65:
			goto tr83
		case 95:
			goto tr27
		}
		switch {
		case lex.data[(lex.p)] < 66:
			if 48 <= lex.data[(lex.p)] && lex.data[(lex.p)] <= 57 {
				goto tr27
			}
		case lex.data[(lex.p)] > 90:
			if 97 <= lex.data[(lex.p)] && lex.data[(lex.p)] <= 122 {
				goto tr27
			}
		default:
			goto tr27
		}
		goto tr65
	tr83:
		lex.te = (lex.p) + 1

		lex.act = 41
		goto st40
	st40:
		if (lex.p)++; (lex.p) == (lex.pe) {
			goto _test_eof40
		}
	st_case_40:
		switch lex.data[(lex.p)] {
		case 46:
			goto st18
		case 83:
			goto tr84
		case 95:
			goto tr27
		}
		switch {
		case lex.data[(lex.p)] < 65:
			if 48 <= lex.data[(lex.p)] && lex.data[(lex.p)] <= 57 {
				goto tr27
			}
		case lex.data[(lex.p)] > 90:
			if 97 <= lex.data[(lex.p)] && lex.data[(lex.p)] <= 122 {
				goto tr27
			}
		default:
			goto tr27
		}
		goto tr65
	tr84:
		lex.te = (lex.p) + 1

		lex.act = 41
		goto st41
	st41:
		if (lex.p)++; (lex.p) == (lex.pe) {
			goto _test_eof41
		}
	st_case_41:
		switch lex.data[(lex.p)] {
		case 46:
			goto st18
		case 83:
			goto tr85
		case 95:
			goto tr27
		}
		switch {
		case lex.data[(lex.p)] < 65:
			if 48 <= lex.data[(lex.p)] && lex.data[(lex.p)] <= 57 {
				goto tr27
			}
		case lex.data[(lex.p)] > 90:
			if 97 <= lex.data[(lex.p)] && lex.data[(lex.p)] <= 122 {
				goto tr27
			}
		default:
			goto tr27
		}
		goto tr65
	tr85:
		lex.te = (lex.p) + 1

		lex.act = 41
		goto st42
	st42:
		if (lex.p)++; (lex.p) == (lex.pe) {
			goto _test_eof42
		}
	st_case_42:
		switch lex.data[(lex.p)] {
		case 46:
			goto st18
		case 95:
			goto tr86
		}
		switch {
		case lex.data[(lex.p)] < 65:
			if 48 <= lex.data[(lex.p)] && lex.data[(lex.p)] <= 57 {
				goto tr27
			}
		case lex.data[(lex.p)] > 90:
			if 97 <= lex.data[(lex.p)] && lex.data[(lex.p)] <= 122 {
				goto tr27
			}
		default:
			goto tr27
		}
		goto tr65
	tr86:
		lex.te = (lex.p) + 1

		lex.act = 41
		goto st43
	st43:
		if (lex.p)++; (lex.p) == (lex.pe) {
			goto _test_eof43
		}
	st_case_43:
		switch lex.data[(lex.p)] {
		case 46:
			goto st18
		case 95:
			goto tr70
		}
		switch {
		case lex.data[(lex.p)] < 65:
			if 48 <= lex.data[(lex.p)] && lex.data[(lex.p)] <= 57 {
				goto tr27
			}
		case lex.data[(lex.p)] > 90:
			if 97 <= lex.data[(lex.p)] && lex.data[(lex.p)] <= 122 {
				goto tr27
			}
		default:
			goto tr27
		}
		goto tr65
	tr77:
		lex.te = (lex.p) + 1

		lex.act = 41
		goto st44
	st44:
		if (lex.p)++; (lex.p) == (lex.pe) {
			goto _test_eof44
		}
	st_case_44:
		switch lex.data[(lex.p)] {
		case 46:
			goto st18
		case 73:
			goto tr87
		case 95:
			goto tr27
		}
		switch {
		case lex.data[(lex.p)] < 65:
			if 48 <= lex.data[(lex.p)] && lex.data[(lex.p)] <= 57 {
				goto tr27
			}
		case lex.data[(lex.p)] > 90:
			if 97 <= lex.data[(lex.p)] && lex.data[(lex.p)] <= 122 {
				goto tr27
			}
		default:
			goto tr27
		}
		goto tr65
	tr87:
		lex.te = (lex.p) + 1

		lex.act = 41
		goto st45
	st45:
		if (lex.p)++; (lex.p) == (lex.pe) {
			goto _test_eof45
		}
	st_case_45:
		switch lex.data[(lex.p)] {
		case 46:
			goto st18
		case 82:
			goto tr85
		case 95:
			goto tr27
		}
		switch {
		case lex.data[(lex.p)] < 65:
			if 48 <= lex.data[(lex.p)] && lex.data[(lex.p)] <= 57 {
				goto tr27
			}
		case lex.data[(lex.p)] > 90:
			if 97 <= lex.data[(lex.p)] && lex.data[(lex.p)] <= 122 {
				goto tr27
			}
		default:
			goto tr27
		}
		goto tr65
	tr78:
		lex.te = (lex.p) + 1

		lex.act = 41
		goto st46
	st46:
		if (lex.p)++; (lex.p) == (lex.pe) {
			goto _test_eof46
		}
	st_case_46:
		switch lex.data[(lex.p)] {
		case 46:
			goto st18
		case 73:
			goto tr88
		case 85:
			goto tr89
		case 95:
			goto tr27
		}
		switch {
		case lex.data[(lex.p)] < 65:
			if 48 <= lex.data[(lex.p)] && lex.data[(lex.p)] <= 57 {
				goto tr27
			}
		case lex.data[(lex.p)] > 90:
			if 97 <= lex.data[(lex.p)] && lex.data[(lex.p)] <= 122 {
				goto tr27
			}
		default:
			goto tr27
		}
		goto tr65
	tr88:
		lex.te = (lex.p) + 1

		lex.act = 41
		goto st47
	st47:
		if (lex.p)++; (lex.p) == (lex.pe) {
			goto _test_eof47
		}
	st_case_47:
		switch lex.data[(lex.p)] {
		case 46:
			goto st18
		case 76:
			goto tr90
		case 95:
			goto tr27
		}
		switch {
		case lex.data[(lex.p)] < 65:
			if 48 <= lex.data[(lex.p)] && lex.data[(lex.p)] <= 57 {
				goto tr27
			}
		case lex.data[(lex.p)] > 90:
			if 97 <= lex.data[(lex.p)] && lex.data[(lex.p)] <= 122 {
				goto tr27
			}
		default:
			goto tr27
		}
		goto tr65
	tr90:
		lex.te = (lex.p) + 1

		lex.act = 41
		goto st48
	st48:
		if (lex.p)++; (lex.p) == (lex.pe) {
			goto _test_eof48
		}
	st_case_48:
		switch lex.data[(lex.p)] {
		case 46:
			goto st18
		case 69:
			goto tr85
		case 95:
			goto tr27
		}
		switch {
		case lex.data[(lex.p)] < 65:
			if 48 <= lex.data[(lex.p)] && lex.data[(lex.p)] <= 57 {
				goto tr27
			}
		case lex.data[(lex.p)] > 90:
			if 97 <= lex.data[(lex.p)] && lex.data[(lex.p)] <= 122 {
				goto tr27
			}
		default:
			goto tr27
		}
		goto tr65
	tr89:
		lex.te = (lex.p) + 1

		lex.act = 41
		goto st49
	st49:
		if (lex.p)++; (lex.p) == (lex.pe) {
			goto _test_eof49
		}
	st_case_49:
		switch lex.data[(lex.p)] {
		case 46:
			goto st18
		case 78:
			goto tr91
		case 95:
			goto tr27
		}
		switch {
		case lex.data[(lex.p)] < 65:
			if 48 <= lex.data[(lex.p)] && lex.data[(lex.p)] <= 57 {
				goto tr27
			}
		case lex.data[(lex.p)] > 90:
			if 97 <= lex.data[(lex.p)] && lex.data[(lex.p)] <= 122 {
				goto tr27
			}
		default:
			goto tr27
		}
		goto tr65
	tr91:
		lex.te = (lex.p) + 1

		lex.act = 41
		goto st50
	st50:
		if (lex.p)++; (lex.p) == (lex.pe) {
			goto _test_eof50
		}
	st_case_50:
		switch lex.data[(lex.p)] {
		case 46:
			goto st18
		case 67:
			goto tr92
		case 95:
			goto tr27
		}
		switch {
		case lex.data[(lex.p)] < 65:
			if 48 <= lex.data[(lex.p)] && lex.data[(lex.p)] <= 57 {
				goto tr27
			}
		case lex.data[(lex.p)] > 90:
			if 97 <= lex.data[(lex.p)] && lex.data[(lex.p)] <= 122 {
				goto tr27
			}
		default:
			goto tr27
		}
		goto tr65
	tr92:
		lex.te = (lex.p) + 1

		lex.act = 41
		goto st51
	st51:
		if (lex.p)++; (lex.p) == (lex.pe) {
			goto _test_eof51
		}
	st_case_51:
		switch lex.data[(lex.p)] {
		case 46:
			goto st18
		case 84:
			goto tr93
		case 95:
			goto tr27
		}
		switch {
		case lex.data[(lex.p)] < 65:
			if 48 <= lex.data[(lex.p)] && lex.data[(lex.p)] <= 57 {
				goto tr27
			}
		case lex.data[(lex.p)] > 90:
			if 97 <= lex.data[(lex.p)] && lex.data[(lex.p)] <= 122 {
				goto tr27
			}
		default:
			goto tr27
		}
		goto tr65
	tr93:
		lex.te = (lex.p) + 1

		lex.act = 41
		goto st52
	st52:
		if (lex.p)++; (lex.p) == (lex.pe) {
			goto _test_eof52
		}
	st_case_52:
		switch lex.data[(lex.p)] {
		case 46:
			goto st18
		case 73:
			goto tr94
		case 95:
			goto tr27
		}
		switch {
		case lex.data[(lex.p)] < 65:
			if 48 <= lex.data[(lex.p)] && lex.data[(lex.p)] <= 57 {
				goto tr27
			}
		case lex.data[(lex.p)] > 90:
			if 97 <= lex.data[(lex.p)] && lex.data[(lex.p)] <= 122 {
				goto tr27
			}
		default:
			goto tr27
		}
		goto tr65
	tr94:
		lex.te = (lex.p) + 1

		lex.act = 41
		goto st53
	st53:
		if (lex.p)++; (lex.p) == (lex.pe) {
			goto _test_eof53
		}
	st_case_53:
		switch lex.data[(lex.p)] {
		case 46:
			goto st18
		case 79:
			goto tr95
		case 95:
			goto tr27
		}
		switch {
		case lex.data[(lex.p)] < 65:
			if 48 <= lex.data[(lex.p)] && lex.data[(lex.p)] <= 57 {
				goto tr27
			}
		case lex.data[(lex.p)] > 90:
			if 97 <= lex.data[(lex.p)] && lex.data[(lex.p)] <= 122 {
				goto tr27
			}
		default:
			goto tr27
		}
		goto tr65
	tr95:
		lex.te = (lex.p) + 1

		lex.act = 41
		goto st54
	st54:
		if (lex.p)++; (lex.p) == (lex.pe) {
			goto _test_eof54
		}
	st_case_54:
		switch lex.data[(lex.p)] {
		case 46:
			goto st18
		case 78:
			goto tr85
		case 95:
			goto tr27
		}
		switch {
		case lex.data[(lex.p)] < 65:
			if 48 <= lex.data[(lex.p)] && lex.data[(lex.p)] <= 57 {
				goto tr27
			}
		case lex.data[(lex.p)] > 90:
			if 97 <= lex.data[(lex.p)] && lex.data[(lex.p)] <= 122 {
				goto tr27
			}
		default:
			goto tr27
		}
		goto tr65
	tr79:
		lex.te = (lex.p) + 1

		lex.act = 41
		goto st55
	st55:
		if (lex.p)++; (lex.p) == (lex.pe) {
			goto _test_eof55
		}
	st_case_55:
		switch lex.data[(lex.p)] {
		case 46:
			goto st18
		case 73:
			goto tr96
		case 95:
			goto tr27
		}
		switch {
		case lex.data[(lex.p)] < 65:
			if 48 <= lex.data[(lex.p)] && lex.data[(lex.p)] <= 57 {
				goto tr27
			}
		case lex.data[(lex.p)] > 90:
			if 97 <= lex.data[(lex.p)] && lex.data[(lex.p)] <= 122 {
				goto tr27
			}
		default:
			goto tr27
		}
		goto tr65
	tr96:
		lex.te = (lex.p) + 1

		lex.act = 41
		goto st56
	st56:
		if (lex.p)++; (lex.p) == (lex.pe) {
			goto _test_eof56
		}
	st_case_56:
		switch lex.data[(lex.p)] {
		case 46:
			goto st18
		case 78:
			goto tr90
		case 95:
			goto tr27
		}
		switch {
		case lex.data[(lex.p)] < 65:
			if 48 <= lex.data[(lex.p)] && lex.data[(lex.p)] <= 57 {
				goto tr27
			}
		case lex.data[(lex.p)] > 90:
			if 97 <= lex.data[(lex.p)] && lex.data[(lex.p)] <= 122 {
				goto tr27
			}
		default:
			goto tr27
		}
		goto tr65
	tr80:
		lex.te = (lex.p) + 1

		lex.act = 41
		goto st57
	st57:
		if (lex.p)++; (lex.p) == (lex.pe) {
			goto _test_eof57
		}
	st_case_57:
		switch lex.data[(lex.p)] {
		case 46:
			goto st18
		case 69:
			goto tr97
		case 95:
			goto tr27
		}
		switch {
		case lex.data[(lex.p)] < 65:
			if 48 <= lex.data[(lex.p)] && lex.data[(lex.p)] <= 57 {
				goto tr27
			}
		case lex.data[(lex.p)] > 90:
			if 97 <= lex.data[(lex.p)] && lex.data[(lex.p)] <= 122 {
				goto tr27
			}
		default:
			goto tr27
		}
		goto tr65
	tr97:
		lex.te = (lex.p) + 1

		lex.act = 41
		goto st58
	st58:
		if (lex.p)++; (lex.p) == (lex.pe) {
			goto _test_eof58
		}
	st_case_58:
		switch lex.data[(lex.p)] {
		case 46:
			goto st18
		case 84:
			goto tr98
		case 95:
			goto tr27
		}
		switch {
		case lex.data[(lex.p)] < 65:
			if 48 <= lex.data[(lex.p)] && lex.data[(lex.p)] <= 57 {
				goto tr27
			}
		case lex.data[(lex.p)] > 90:
			if 97 <= lex.data[(lex.p)] && lex.data[(lex.p)] <= 122 {
				goto tr27
			}
		default:
			goto tr27
		}
		goto tr65
	tr98:
		lex.te = (lex.p) + 1

		lex.act = 41
		goto st59
	st59:
		if (lex.p)++; (lex.p) == (lex.pe) {
			goto _test_eof59
		}
	st_case_59:
		switch lex.data[(lex.p)] {
		case 46:
			goto st18
		case 72:
			goto tr99
		case 95:
			goto tr27
		}
		switch {
		case lex.data[(lex.p)] < 65:
			if 48 <= lex.data[(lex.p)] && lex.data[(lex.p)] <= 57 {
				goto tr27
			}
		case lex.data[(lex.p)] > 90:
			if 97 <= lex.data[(lex.p)] && lex.data[(lex.p)] <= 122 {
				goto tr27
			}
		default:
			goto tr27
		}
		goto tr65
	tr99:
		lex.te = (lex.p) + 1

		lex.act = 41
		goto st60
	st60:
		if (lex.p)++; (lex.p) == (lex.pe) {
			goto _test_eof60
		}
	st_case_60:
		switch lex.data[(lex.p)] {
		case 46:
			goto st18
		case 79:
			goto tr100
		case 95:
			goto tr27
		}
		switch {
		case lex.data[(lex.p)] < 65:
			if 48 <= lex.data[(lex.p)] && lex.data[(lex.p)] <= 57 {
				goto tr27
			}
		case lex.data[(lex.p)] > 90:
			if 97 <= lex.data[(lex.p)] && lex.data[(lex.p)] <= 122 {
				goto tr27
			}
		default:
			goto tr27
		}
		goto tr65
	tr100:
		lex.te = (lex.p) + 1

		lex.act = 41
		goto st61
	st61:
		if (lex.p)++; (lex.p) == (lex.pe) {
			goto _test_eof61
		}
	st_case_61:
		switch lex.data[(lex.p)] {
		case 46:
			goto st18
		case 68:
			goto tr85
		case 95:
			goto tr27
		}
		switch {
		case lex.data[(lex.p)] < 65:
			if 48 <= lex.data[(lex.p)] && lex.data[(lex.p)] <= 57 {
				goto tr27
			}
		case lex.data[(lex.p)] > 90:
			if 97 <= lex.data[(lex.p)] && lex.data[(lex.p)] <= 122 {
				goto tr27
			}
		default:
			goto tr27
		}
		goto tr65
	tr81:
		lex.te = (lex.p) + 1

		lex.act = 41
		goto st62
	st62:
		if (lex.p)++; (lex.p) == (lex.pe) {
			goto _test_eof62
		}
	st_case_62:
		switch lex.data[(lex.p)] {
		case 46:
			goto st18
		case 65:
			goto tr101
		case 95:
			goto tr27
		}
		switch {
		case lex.data[(lex.p)] < 66:
			if 48 <= lex.data[(lex.p)] && lex.data[(lex.p)] <= 57 {
				goto tr27
			}
		case lex.data[(lex.p)] > 90:
			if 97 <= lex.data[(lex.p)] && lex.data[(lex.p)] <= 122 {
				goto tr27
			}
		default:
			goto tr27
		}
		goto tr65
	tr101:
		lex.te = (lex.p) + 1

		lex.act = 41
		goto st63
	st63:
		if (lex.p)++; (lex.p) == (lex.pe) {
			goto _test_eof63
		}
	st_case_63:
		switch lex.data[(lex.p)] {
		case 46:
			goto st18
		case 77:
			goto tr102
		case 95:
			goto tr27
		}
		switch {
		case lex.data[(lex.p)] < 65:
			if 48 <= lex.data[(lex.p)] && lex.data[(lex.p)] <= 57 {
				goto tr27
			}
		case lex.data[(lex.p)] > 90:
			if 97 <= lex.data[(lex.p)] && lex.data[(lex.p)] <= 122 {
				goto tr27
			}
		default:
			goto tr27
		}
		goto tr65
	tr102:
		lex.te = (lex.p) + 1

		lex.act = 41
		goto st64
	st64:
		if (lex.p)++; (lex.p) == (lex.pe) {
			goto _test_eof64
		}
	st_case_64:
		switch lex.data[(lex.p)] {
		case 46:
			goto st18
		case 69:
			goto tr103
		case 95:
			goto tr27
		}
		switch {
		case lex.data[(lex.p)] < 65:
			if 48 <= lex.data[(lex.p)] && lex.data[(lex.p)] <= 57 {
				goto tr27
			}
		case lex.data[(lex.p)] > 90:
			if 97 <= lex.data[(lex.p)] && lex.data[(lex.p)] <= 122 {
				goto tr27
			}
		default:
			goto tr27
		}
		goto tr65
	tr103:
		lex.te = (lex.p) + 1

		lex.act = 41
		goto st65
	st65:
		if (lex.p)++; (lex.p) == (lex.pe) {
			goto _test_eof65
		}
	st_case_65:
		switch lex.data[(lex.p)] {
		case 46:
			goto st18
		case 83:
			goto tr104
		case 95:
			goto tr27
		}
		switch {
		case lex.data[(lex.p)] < 65:
			if 48 <= lex.data[(lex.p)] && lex.data[(lex.p)] <= 57 {
				goto tr27
			}
		case lex.data[(lex.p)] > 90:
			if 97 <= lex.data[(lex.p)] && lex.data[(lex.p)] <= 122 {
				goto tr27
			}
		default:
			goto tr27
		}
		goto tr65
	tr104:
		lex.te = (lex.p) + 1

		lex.act = 41
		goto st66
	st66:
		if (lex.p)++; (lex.p) == (lex.pe) {
			goto _test_eof66
		}
	st_case_66:
		switch lex.data[(lex.p)] {
		case 46:
			goto st18
		case 80:
			goto tr105
		case 95:
			goto tr27
		}
		switch {
		case lex.data[(lex.p)] < 65:
			if 48 <= lex.data[(lex.p)] && lex.data[(lex.p)] <= 57 {
				goto tr27
			}
		case lex.data[(lex.p)] > 90:
			if 97 <= lex.data[(lex.p)] && lex.data[(lex.p)] <= 122 {
				goto tr27
			}
		default:
			goto tr27
		}
		goto tr65
	tr105:
		lex.te = (lex.p) + 1

		lex.act = 41
		goto st67
	st67:
		if (lex.p)++; (lex.p) == (lex.pe) {
			goto _test_eof67
		}
	st_case_67:
		switch lex.data[(lex.p)] {
		case 46:
			goto st18
		case 65:
			goto tr106
		case 95:
			goto tr27
		}
		switch {
		case lex.data[(lex.p)] < 66:
			if 48 <= lex.data[(lex.p)] && lex.data[(lex.p)] <= 57 {
				goto tr27
			}
		case lex.data[(lex.p)] > 90:
			if 97 <= lex.data[(lex.p)] && lex.data[(lex.p)] <= 122 {
				goto tr27
			}
		default:
			goto tr27
		}
		goto tr65
	tr106:
		lex.te = (lex.p) + 1

		lex.act = 41
		goto st68
	st68:
		if (lex.p)++; (lex.p) == (lex.pe) {
			goto _test_eof68
		}
	st_case_68:
		switch lex.data[(lex.p)] {
		case 46:
			goto st18
		case 67:
			goto tr90
		case 95:
			goto tr27
		}
		switch {
		case lex.data[(lex.p)] < 65:
			if 48 <= lex.data[(lex.p)] && lex.data[(lex.p)] <= 57 {
				goto tr27
			}
		case lex.data[(lex.p)] > 90:
			if 97 <= lex.data[(lex.p)] && lex.data[(lex.p)] <= 122 {
				goto tr27
			}
		default:
			goto tr27
		}
		goto tr65
	tr37:
		lex.te = (lex.p) + 1

		lex.act = 41
		goto st69
	st69:
		if (lex.p)++; (lex.p) == (lex.pe) {
			goto _test_eof69
		}
	st_case_69:
		switch lex.data[(lex.p)] {
		case 46:
			goto st18
		case 95:
			goto tr27
		case 98:
			goto tr107
		case 108:
			goto tr108
		case 110:
			goto tr109
		case 114:
			goto tr110
		case 115:
			goto tr111
		}
		switch {
		case lex.data[(lex.p)] < 65:
			if 48 <= lex.data[(lex.p)] && lex.data[(lex.p)] <= 57 {
				goto tr27
			}
		case lex.data[(lex.p)] > 90:
			if 97 <= lex.data[(lex.p)] && lex.data[(lex.p)] <= 122 {
				goto tr27
			}
		default:
			goto tr27
		}
		goto tr65
	tr107:
		lex.te = (lex.p) + 1

		lex.act = 41
		goto st70
	st70:
		if (lex.p)++; (lex.p) == (lex.pe) {
			goto _test_eof70
		}
	st_case_70:
		switch lex.data[(lex.p)] {
		case 46:
			goto st18
		case 95:
			goto tr27
		case 115:
			goto tr112
		}
		switch {
		case lex.data[(lex.p)] < 65:
			if 48 <= lex.data[(lex.p)] && lex.data[(lex.p)] <= 57 {
				goto tr27
			}
		case lex.data[(lex.p)] > 90:
			if 97 <= lex.data[(lex.p)] && lex.data[(lex.p)] <= 122 {
				goto tr27
			}
		default:
			goto tr27
		}
		goto tr65
	tr112:
		lex.te = (lex.p) + 1

		lex.act = 41
		goto st71
	st71:
		if (lex.p)++; (lex.p) == (lex.pe) {
			goto _test_eof71
		}
	st_case_71:
		switch lex.data[(lex.p)] {
		case 46:
			goto st18
		case 95:
			goto tr27
		case 116:
			goto tr113
		}
		switch {
		case lex.data[(lex.p)] < 65:
			if 48 <= lex.data[(lex.p)] && lex.data[(lex.p)] <= 57 {
				goto tr27
			}
		case lex.data[(lex.p)] > 90:
			if 97 <= lex.data[(lex.p)] && lex.data[(lex.p)] <= 122 {
				goto tr27
			}
		default:
			goto tr27
		}
		goto tr65
	tr113:
		lex.te = (lex.p) + 1

		lex.act = 41
		goto st72
	st72:
		if (lex.p)++; (lex.p) == (lex.pe) {
			goto _test_eof72
		}
	st_case_72:
		switch lex.data[(lex.p)] {
		case 46:
			goto st18
		case 95:
			goto tr27
		case 114:
			goto tr114
		}
		switch {
		case lex.data[(lex.p)] < 65:
			if 48 <= lex.data[(lex.p)] && lex.data[(lex.p)] <= 57 {
				goto tr27
			}
		case lex.data[(lex.p)] > 90:
			if 97 <= lex.data[(lex.p)] && lex.data[(lex.p)] <= 122 {
				goto tr27
			}
		default:
			goto tr27
		}
		goto tr65
	tr114:
		lex.te = (lex.p) + 1

		lex.act = 41
		goto st73
	st73:
		if (lex.p)++; (lex.p) == (lex.pe) {
			goto _test_eof73
		}
	st_case_73:
		switch lex.data[(lex.p)] {
		case 46:
			goto st18
		case 95:
			goto tr27
		case 97:
			goto tr115
		}
		switch {
		case lex.data[(lex.p)] < 65:
			if 48 <= lex.data[(lex.p)] && lex.data[(lex.p)] <= 57 {
				goto tr27
			}
		case lex.data[(lex.p)] > 90:
			if 98 <= lex.data[(lex.p)] && lex.data[(lex.p)] <= 122 {
				goto tr27
			}
		default:
			goto tr27
		}
		goto tr65
	tr115:
		lex.te = (lex.p) + 1

		lex.act = 41
		goto st74
	st74:
		if (lex.p)++; (lex.p) == (lex.pe) {
			goto _test_eof74
		}
	st_case_74:
		switch lex.data[(lex.p)] {
		case 46:
			goto st18
		case 95:
			goto tr27
		case 99:
			goto tr116
		}
		switch {
		case lex.data[(lex.p)] < 65:
			if 48 <= lex.data[(lex.p)] && lex.data[(lex.p)] <= 57 {
				goto tr27
			}
		case lex.data[(lex.p)] > 90:
			if 97 <= lex.data[(lex.p)] && lex.data[(lex.p)] <= 122 {
				goto tr27
			}
		default:
			goto tr27
		}
		goto tr65
	tr116:
		lex.te = (lex.p) + 1

		lex.act = 41
		goto st75
	st75:
		if (lex.p)++; (lex.p) == (lex.pe) {
			goto _test_eof75
		}
	st_case_75:
		switch lex.data[(lex.p)] {
		case 46:
			goto st18
		case 95:
			goto tr27
		case 116:
			goto tr70
		}
		switch {
		case lex.data[(lex.p)] < 65:
			if 48 <= lex.data[(lex.p)] && lex.data[(lex.p)] <= 57 {
				goto tr27
			}
		case lex.data[(lex.p)] > 90:
			if 97 <= lex.data[(lex.p)] && lex.data[(lex.p)] <= 122 {
				goto tr27
			}
		default:
			goto tr27
		}
		goto tr65
	tr108:
		lex.te = (lex.p) + 1

		lex.act = 41
		goto st76
	st76:
		if (lex.p)++; (lex.p) == (lex.pe) {
			goto _test_eof76
		}
	st_case_76:
		switch lex.data[(lex.p)] {
		case 46:
			goto st18
		case 95:
			goto tr27
		case 105:
			goto tr117
		}
		switch {
		case lex.data[(lex.p)] < 65:
			if 48 <= lex.data[(lex.p)] && lex.data[(lex.p)] <= 57 {
				goto tr27
			}
		case lex.data[(lex.p)] > 90:
			if 97 <= lex.data[(lex.p)] && lex.data[(lex.p)] <= 122 {
				goto tr27
			}
		default:
			goto tr27
		}
		goto tr65
	tr117:
		lex.te = (lex.p) + 1

		lex.act = 41
		goto st77
	st77:
		if (lex.p)++; (lex.p) == (lex.pe) {
			goto _test_eof77
		}
	st_case_77:
		switch lex.data[(lex.p)] {
		case 46:
			goto st18
		case 95:
			goto tr27
		case 97:
			goto tr118
		}
		switch {
		case lex.data[(lex.p)] < 65:
			if 48 <= lex.data[(lex.p)] && lex.data[(lex.p)] <= 57 {
				goto tr27
			}
		case lex.data[(lex.p)] > 90:
			if 98 <= lex.data[(lex.p)] && lex.data[(lex.p)] <= 122 {
				goto tr27
			}
		default:
			goto tr27
		}
		goto tr65
	tr118:
		lex.te = (lex.p) + 1

		lex.act = 41
		goto st78
	st78:
		if (lex.p)++; (lex.p) == (lex.pe) {
			goto _test_eof78
		}
	st_case_78:
		switch lex.data[(lex.p)] {
		case 46:
			goto st18
		case 95:
			goto tr27
		case 115:
			goto tr70
		}
		switch {
		case lex.data[(lex.p)] < 65:
			if 48 <= lex.data[(lex.p)] && lex.data[(lex.p)] <= 57 {
				goto tr27
			}
		case lex.data[(lex.p)] > 90:
			if 97 <= lex.data[(lex.p)] && lex.data[(lex.p)] <= 122 {
				goto tr27
			}
		default:
			goto tr27
		}
		goto tr65
	tr109:
		lex.te = (lex.p) + 1

		lex.act = 41
		goto st79
	st79:
		if (lex.p)++; (lex.p) == (lex.pe) {
			goto _test_eof79
		}
	st_case_79:
		switch lex.data[(lex.p)] {
		case 46:
			goto st18
		case 95:
			goto tr27
		case 100:
			goto tr70
		}
		switch {
		case lex.data[(lex.p)] < 65:
			if 48 <= lex.data[(lex.p)] && lex.data[(lex.p)] <= 57 {
				goto tr27
			}
		case lex.data[(lex.p)] > 90:
			if 97 <= lex.data[(lex.p)] && lex.data[(lex.p)] <= 122 {
				goto tr27
			}
		default:
			goto tr27
		}
		goto tr65
	tr110:
		lex.te = (lex.p) + 1

		lex.act = 41
		goto st80
	st80:
		if (lex.p)++; (lex.p) == (lex.pe) {
			goto _test_eof80
		}
	st_case_80:
		switch lex.data[(lex.p)] {
		case 46:
			goto st18
		case 95:
			goto tr27
		case 103:
			goto tr118
		}
		switch {
		case lex.data[(lex.p)] < 65:
			if 48 <= lex.data[(lex.p)] && lex.data[(lex.p)] <= 57 {
				goto tr27
			}
		case lex.data[(lex.p)] > 90:
			if 97 <= lex.data[(lex.p)] && lex.data[(lex.p)] <= 122 {
				goto tr27
			}
		default:
			goto tr27
		}
		goto tr65
	tr111:
		lex.te = (lex.p) + 1

		reservedKeyword = string(lex.data[lex.ts:lex.te])
		lex.act = 40
		goto st81
	st81:
		if (lex.p)++; (lex.p) == (lex.pe) {
			goto _test_eof81
		}
	st_case_81:
		switch lex.data[(lex.p)] {
		case 9:
			goto st33
		case 10:
			goto tr73
		case 13:
			goto st33
		case 32:
			goto st33
		case 46:
			goto st18
		case 95:
			goto tr27
		case 115:
			goto tr119
		}
		switch {
		case lex.data[(lex.p)] < 65:
			if 48 <= lex.data[(lex.p)] && lex.data[(lex.p)] <= 57 {
				goto tr27
			}
		case lex.data[(lex.p)] > 90:
			if 97 <= lex.data[(lex.p)] && lex.data[(lex.p)] <= 122 {
				goto tr27
			}
		default:
			goto tr27
		}
		goto tr71
	tr119:
		lex.te = (lex.p) + 1

		lex.act = 41
		goto st82
	st82:
		if (lex.p)++; (lex.p) == (lex.pe) {
			goto _test_eof82
		}
	st_case_82:
		switch lex.data[(lex.p)] {
		case 46:
			goto st18
		case 95:
			goto tr27
		case 101:
			goto tr120
		}
		switch {
		case lex.data[(lex.p)] < 65:
			if 48 <= lex.data[(lex.p)] && lex.data[(lex.p)] <= 57 {
				goto tr27
			}
		case lex.data[(lex.p)] > 90:
			if 97 <= lex.data[(lex.p)] && lex.data[(lex.p)] <= 122 {
				goto tr27
			}
		default:
			goto tr27
		}
		goto tr65
	tr120:
		lex.te = (lex.p) + 1

		lex.act = 41
		goto st83
	st83:
		if (lex.p)++; (lex.p) == (lex.pe) {
			goto _test_eof83
		}
	st_case_83:
		switch lex.data[(lex.p)] {
		case 46:
			goto st18
		case 95:
			goto tr27
		case 114:
			goto tr116
		}
		switch {
		case lex.data[(lex.p)] < 65:
			if 48 <= lex.data[(lex.p)] && lex.data[(lex.p)] <= 57 {
				goto tr27
			}
		case lex.data[(lex.p)] > 90:
			if 97 <= lex.data[(lex.p)] && lex.data[(lex.p)] <= 122 {
				goto tr27
			}
		default:
			goto tr27
		}
		goto tr65
	tr38:
		lex.te = (lex.p) + 1

		lex.act = 41
		goto st84
	st84:
		if (lex.p)++; (lex.p) == (lex.pe) {
			goto _test_eof84
		}
	st_case_84:
		switch lex.data[(lex.p)] {
		case 46:
			goto st18
		case 95:
			goto tr27
		case 101:
			goto tr121
		case 105:
			goto tr122
		case 111:
			goto tr123
		case 114:
			goto tr124
		case 121:
			goto tr125
		}
		switch {
		case lex.data[(lex.p)] < 65:
			if 48 <= lex.data[(lex.p)] && lex.data[(lex.p)] <= 57 {
				goto tr27
			}
		case lex.data[(lex.p)] > 90:
			if 97 <= lex.data[(lex.p)] && lex.data[(lex.p)] <= 122 {
				goto tr27
			}
		default:
			goto tr27
		}
		goto tr65
	tr121:
		lex.te = (lex.p) + 1

		lex.act = 41
		goto st85
	st85:
		if (lex.p)++; (lex.p) == (lex.pe) {
			goto _test_eof85
		}
	st_case_85:
		switch lex.data[(lex.p)] {
		case 46:
			goto st18
		case 95:
			goto tr27
		case 103:
			goto tr126
		}
		switch {
		case lex.data[(lex.p)] < 65:
			if 48 <= lex.data[(lex.p)] && lex.data[(lex.p)] <= 57 {
				goto tr27
			}
		case lex.data[(lex.p)] > 90:
			if 97 <= lex.data[(lex.p)] && lex.data[(lex.p)] <= 122 {
				goto tr27
			}
		default:
			goto tr27
		}
		goto tr65
	tr126:
		lex.te = (lex.p) + 1

		lex.act = 41
		goto st86
	st86:
		if (lex.p)++; (lex.p) == (lex.pe) {
			goto _test_eof86
		}
	st_case_86:
		switch lex.data[(lex.p)] {
		case 46:
			goto st18
		case 95:
			goto tr27
		case 105:
			goto tr127
		}
		switch {
		case lex.data[(lex.p)] < 65:
			if 48 <= lex.data[(lex.p)] && lex.data[(lex.p)] <= 57 {
				goto tr27
			}
		case lex.data[(lex.p)] > 90:
			if 97 <= lex.data[(lex.p)] && lex.data[(lex.p)] <= 122 {
				goto tr27
			}
		default:
			goto tr27
		}
		goto tr65
	tr127:
		lex.te = (lex.p) + 1

		lex.act = 41
		goto st87
	st87:
		if (lex.p)++; (lex.p) == (lex.pe) {
			goto _test_eof87
		}
	st_case_87:
		switch lex.data[(lex.p)] {
		case 46:
			goto st18
		case 95:
			goto tr27
		case 110:
			goto tr70
		}
		switch {
		case lex.data[(lex.p)] < 65:
			if 48 <= lex.data[(lex.p)] && lex.data[(lex.p)] <= 57 {
				goto tr27
			}
		case lex.data[(lex.p)] > 90:
			if 97 <= lex.data[(lex.p)] && lex.data[(lex.p)] <= 122 {
				goto tr27
			}
		default:
			goto tr27
		}
		goto tr65
	tr122:
		lex.te = (lex.p) + 1

		lex.act = 41
		goto st88
	st88:
		if (lex.p)++; (lex.p) == (lex.pe) {
			goto _test_eof88
		}
	st_case_88:
		switch lex.data[(lex.p)] {
		case 46:
			goto st18
		case 95:
			goto tr27
		case 110:
			goto tr128
		}
		switch {
		case lex.data[(lex.p)] < 65:
			if 48 <= lex.data[(lex.p)] && lex.data[(lex.p)] <= 57 {
				goto tr27
			}
		case lex.data[(lex.p)] > 90:
			if 97 <= lex.data[(lex.p)] && lex.data[(lex.p)] <= 122 {
				goto tr27
			}
		default:
			goto tr27
		}
		goto tr65
	tr128:
		lex.te = (lex.p) + 1

		lex.act = 41
		goto st89
	st89:
		if (lex.p)++; (lex.p) == (lex.pe) {
			goto _test_eof89
		}
	st_case_89:
		switch lex.data[(lex.p)] {
		case 46:
			goto st18
		case 95:
			goto tr27
		case 97:
			goto tr129
		}
		switch {
		case lex.data[(lex.p)] < 65:
			if 48 <= lex.data[(lex.p)] && lex.data[(lex.p)] <= 57 {
				goto tr27
			}
		case lex.data[(lex.p)] > 90:
			if 98 <= lex.data[(lex.p)] && lex.data[(lex.p)] <= 122 {
				goto tr27
			}
		default:
			goto tr27
		}
		goto tr65
	tr129:
		lex.te = (lex.p) + 1

		lex.act = 41
		goto st90
	st90:
		if (lex.p)++; (lex.p) == (lex.pe) {
			goto _test_eof90
		}
	st_case_90:
		switch lex.data[(lex.p)] {
		case 46:
			goto st18
		case 95:
			goto tr27
		case 114:
			goto tr130
		}
		switch {
		case lex.data[(lex.p)] < 65:
			if 48 <= lex.data[(lex.p)] && lex.data[(lex.p)] <= 57 {
				goto tr27
			}
		case lex.data[(lex.p)] > 90:
			if 97 <= lex.data[(lex.p)] && lex.data[(lex.p)] <= 122 {
				goto tr27
			}
		default:
			goto tr27
		}
		goto tr65
	tr130:
		lex.te = (lex.p) + 1

		lex.act = 41
		goto st91
	st91:
		if (lex.p)++; (lex.p) == (lex.pe) {
			goto _test_eof91
		}
	st_case_91:
		switch lex.data[(lex.p)] {
		case 46:
			goto st18
		case 95:
			goto tr27
		case 121:
			goto tr131
		}
		switch {
		case lex.data[(lex.p)] < 65:
			if 48 <= lex.data[(lex.p)] && lex.data[(lex.p)] <= 57 {
				goto tr27
			}
		case lex.data[(lex.p)] > 90:
			if 97 <= lex.data[(lex.p)] && lex.data[(lex.p)] <= 122 {
				goto tr27
			}
		default:
			goto tr27
		}
		goto tr65
	tr131:
		lex.te = (lex.p) + 1

		lex.act = 13
		goto st92
	st92:
		if (lex.p)++; (lex.p) == (lex.pe) {
			goto _test_eof92
		}
	st_case_92:
		switch lex.data[(lex.p)] {
		case 9:
			goto st93
		case 10:
			goto tr134
		case 13:
			goto st93
		case 32:
			goto st93
		case 46:
			goto st18
		case 95:
			goto tr27
		}
		switch {
		case lex.data[(lex.p)] < 65:
			if 48 <= lex.data[(lex.p)] && lex.data[(lex.p)] <= 57 {
				goto tr27
			}
		case lex.data[(lex.p)] > 90:
			if 97 <= lex.data[(lex.p)] && lex.data[(lex.p)] <= 122 {
				goto tr27
			}
		default:
			goto tr27
		}
		goto tr132
	tr134:

		lex.line++
		lex.lineStart = lex.p + 1
		lex.linesSinceDocstring++

		goto st93
	st93:
		if (lex.p)++; (lex.p) == (lex.pe) {
			goto _test_eof93
		}
	st_case_93:
		switch lex.data[(lex.p)] {
		case 9:
			goto st93
		case 10:
			goto tr134
		case 13:
			goto st93
		case 32:
			goto st93
		}
		goto tr132
	tr123:
		lex.te = (lex.p) + 1

		lex.act = 41
		goto st94
	st94:
		if (lex.p)++; (lex.p) == (lex.pe) {
			goto _test_eof94
		}
	st_case_94:
		switch lex.data[(lex.p)] {
		case 46:
			goto st18
		case 95:
			goto tr27
		case 111:
			goto tr135
		}
		switch {
		case lex.data[(lex.p)] < 65:
			if 48 <= lex.data[(lex.p)] && lex.data[(lex.p)] <= 57 {
				goto tr27
			}
		case lex.data[(lex.p)] > 90:
			if 97 <= lex.data[(lex.p)] && lex.data[(lex.p)] <= 122 {
				goto tr27
			}
		default:
			goto tr27
		}
		goto tr65
	tr135:
		lex.te = (lex.p) + 1

		lex.act = 41
		goto st95
	st95:
		if (lex.p)++; (lex.p) == (lex.pe) {
			goto _test_eof95
		}
	st_case_95:
		switch lex.data[(lex.p)] {
		case 46:
			goto st18
		case 95:
			goto tr27
		case 108:
			goto tr136
		}
		switch {
		case lex.data[(lex.p)] < 65:
			if 48 <= lex.data[(lex.p)] && lex.data[(lex.p)] <= 57 {
				goto tr27
			}
		case lex.data[(lex.p)] > 90:
			if 97 <= lex.data[(lex.p)] && lex.data[(lex.p)] <= 122 {
				goto tr27
			}
		default:
			goto tr27
		}
		goto tr65
	tr136:
		lex.te = (lex.p) + 1

		lex.act = 5
		goto st96
	st96:
		if (lex.p)++; (lex.p) == (lex.pe) {
			goto _test_eof96
		}
	st_case_96:
		switch lex.data[(lex.p)] {
		case 9:
			goto st97
		case 10:
			goto tr139
		case 13:
			goto st97
		case 32:
			goto st97
		case 46:
			goto st18
		case 95:
			goto tr27
		}
		switch {
		case lex.data[(lex.p)] < 65:
			if 48 <= lex.data[(lex.p)] && lex.data[(lex.p)] <= 57 {
				goto tr27
			}
		case lex.data[(lex.p)] > 90:
			if 97 <= lex.data[(lex.p)] && lex.data[(lex.p)] <= 122 {
				goto tr27
			}
		default:
			goto tr27
		}
		goto tr137
	tr139:

		lex.line++
		lex.lineStart = lex.p + 1
		lex.linesSinceDocstring++

		goto st97
	st97:
		if (lex.p)++; (lex.p) == (lex.pe) {
			goto _test_eof97
		}
	st_case_97:
		switch lex.data[(lex.p)] {
		case 9:
			goto st97
		case 10:
			goto tr139
		case 13:
			goto st97
		case 32:
			goto st97
		}
		goto tr137
	tr124:
		lex.te = (lex.p) + 1

		lex.act = 41
		goto st98
	st98:
		if (lex.p)++; (lex.p) == (lex.pe) {
			goto _test_eof98
		}
	st_case_98:
		switch lex.data[(lex.p)] {
		case 46:
			goto st18
		case 95:
			goto tr27
		case 101:
			goto tr140
		}
		switch {
		case lex.data[(lex.p)] < 65:
			if 48 <= lex.data[(lex.p)] && lex.data[(lex.p)] <= 57 {
				goto tr27
			}
		case lex.data[(lex.p)] > 90:
			if 97 <= lex.data[(lex.p)] && lex.data[(lex.p)] <= 122 {
				goto tr27
			}
		default:
			goto tr27
		}
		goto tr65
	tr140:
		lex.te = (lex.p) + 1

		lex.act = 41
		goto st99
	st99:
		if (lex.p)++; (lex.p) == (lex.pe) {
			goto _test_eof99
		}
	st_case_99:
		switch lex.data[(lex.p)] {
		case 46:
			goto st18
		case 95:
			goto tr27
		case 97:
			goto tr141
		}
		switch {
		case lex.data[(lex.p)] < 65:
			if 48 <= lex.data[(lex.p)] && lex.data[(lex.p)] <= 57 {
				goto tr27
			}
		case lex.data[(lex.p)] > 90:
			if 98 <= lex.data[(lex.p)] && lex.data[(lex.p)] <= 122 {
				goto tr27
			}
		default:
			goto tr27
		}
		goto tr65
	tr141:
		lex.te = (lex.p) + 1

		lex.act = 41
		goto st100
	st100:
		if (lex.p)++; (lex.p) == (lex.pe) {
			goto _test_eof100
		}
	st_case_100:
		switch lex.data[(lex.p)] {
		case 46:
			goto st18
		case 95:
			goto tr27
		case 107:
			goto tr70
		}
		switch {
		case lex.data[(lex.p)] < 65:
			if 48 <= lex.data[(lex.p)] && lex.data[(lex.p)] <= 57 {
				goto tr27
			}
		case lex.data[(lex.p)] > 90:
			if 97 <= lex.data[(lex.p)] && lex.data[(lex.p)] <= 122 {
				goto tr27
			}
		default:
			goto tr27
		}
		goto tr65
	tr125:
		lex.te = (lex.p) + 1

		lex.act = 41
		goto st101
	st101:
		if (lex.p)++; (lex.p) == (lex.pe) {
			goto _test_eof101
		}
	st_case_101:
		switch lex.data[(lex.p)] {
		case 46:
			goto st18
		case 95:
			goto tr27
		case 116:
			goto tr142
		}
		switch {
		case lex.data[(lex.p)] < 65:
			if 48 <= lex.data[(lex.p)] && lex.data[(lex.p)] <= 57 {
				goto tr27
			}
		case lex.data[(lex.p)] > 90:
			if 97 <= lex.data[(lex.p)] && lex.data[(lex.p)] <= 122 {
				goto tr27
			}
		default:
			goto tr27
		}
		goto tr65
	tr142:
		lex.te = (lex.p) + 1

		lex.act = 41
		goto st102
	st102:
		if (lex.p)++; (lex.p) == (lex.pe) {
			goto _test_eof102
		}
	st_case_102:
		switch lex.data[(lex.p)] {
		case 46:
			goto st18
		case 95:
			goto tr27
		case 101:
			goto tr143
		}
		switch {
		case lex.data[(lex.p)] < 65:
			if 48 <= lex.data[(lex.p)] && lex.data[(lex.p)] <= 57 {
				goto tr27
			}
		case lex.data[(lex.p)] > 90:
			if 97 <= lex.data[(lex.p)] && lex.data[(lex.p)] <= 122 {
				goto tr27
			}
		default:
			goto tr27
		}
		goto tr65
	tr143:
		lex.te = (lex.p) + 1

		lex.act = 6
		goto st103
	st103:
		if (lex.p)++; (lex.p) == (lex.pe) {
			goto _test_eof103
		}
	st_case_103:
		switch lex.data[(lex.p)] {
		case 9:
			goto st104
		case 10:
			goto tr146
		case 13:
			goto st104
		case 32:
			goto st104
		case 46:
			goto st18
		case 95:
			goto tr27
		}
		switch {
		case lex.data[(lex.p)] < 65:
			if 48 <= lex.data[(lex.p)] && lex.data[(lex.p)] <= 57 {
				goto tr27
			}
		case lex.data[(lex.p)] > 90:
			if 97 <= lex.data[(lex.p)] && lex.data[(lex.p)] <= 122 {
				goto tr27
			}
		default:
			goto tr27
		}
		goto tr144
	tr146:

		lex.line++
		lex.lineStart = lex.p + 1
		lex.linesSinceDocstring++

		goto st104
	st104:
		if (lex.p)++; (lex.p) == (lex.pe) {
			goto _test_eof104
		}
	st_case_104:
		switch lex.data[(lex.p)] {
		case 9:
			goto st104
		case 10:
			goto tr146
		case 13:
			goto st104
		case 32:
			goto st104
		}
		goto tr144
	tr39:
		lex.te = (lex.p) + 1

		lex.act = 41
		goto st105
	st105:
		if (lex.p)++; (lex.p) == (lex.pe) {
			goto _test_eof105
		}
	st_case_105:
		switch lex.data[(lex.p)] {
		case 46:
			goto st18
		case 95:
			goto tr27
		case 97:
			goto tr147
		case 108:
			goto tr148
		case 111:
			goto tr149
		case 112:
			goto tr150
		}
		switch {
		case lex.data[(lex.p)] < 65:
			if 48 <= lex.data[(lex.p)] && lex.data[(lex.p)] <= 57 {
				goto tr27
			}
		case lex.data[(lex.p)] > 90:
			if 98 <= lex.data[(lex.p)] && lex.data[(lex.p)] <= 122 {
				goto tr27
			}
		default:
			goto tr27
		}
		goto tr65
	tr147:
		lex.te = (lex.p) + 1

		lex.act = 41
		goto st106
	st106:
		if (lex.p)++; (lex.p) == (lex.pe) {
			goto _test_eof106
		}
	st_case_106:
		switch lex.data[(lex.p)] {
		case 46:
			goto st18
		case 95:
			goto tr27
		case 115:
			goto tr151
		case 116:
			goto tr152
		}
		switch {
		case lex.data[(lex.p)] < 65:
			if 48 <= lex.data[(lex.p)] && lex.data[(lex.p)] <= 57 {
				goto tr27
			}
		case lex.data[(lex.p)] > 90:
			if 97 <= lex.data[(lex.p)] && lex.data[(lex.p)] <= 122 {
				goto tr27
			}
		default:
			goto tr27
		}
		goto tr65
	tr151:
		lex.te = (lex.p) + 1

		lex.act = 41
		goto st107
	st107:
		if (lex.p)++; (lex.p) == (lex.pe) {
			goto _test_eof107
		}
	st_case_107:
		switch lex.data[(lex.p)] {
		case 46:
			goto st18
		case 95:
			goto tr27
		case 101:
			goto tr70
		}
		switch {
		case lex.data[(lex.p)] < 65:
			if 48 <= lex.data[(lex.p)] && lex.data[(lex.p)] <= 57 {
				goto tr27
			}
		case lex.data[(lex.p)] > 90:
			if 97 <= lex.data[(lex.p)] && lex.data[(lex.p)] <= 122 {
				goto tr27
			}
		default:
			goto tr27
		}
		goto tr65
	tr152:
		lex.te = (lex.p) + 1

		lex.act = 41
		goto st108
	st108:
		if (lex.p)++; (lex.p) == (lex.pe) {
			goto _test_eof108
		}
	st_case_108:
		switch lex.data[(lex.p)] {
		case 46:
			goto st18
		case 95:
			goto tr27
		case 99:
			goto tr153
		}
		switch {
		case lex.data[(lex.p)] < 65:
			if 48 <= lex.data[(lex.p)] && lex.data[(lex.p)] <= 57 {
				goto tr27
			}
		case lex.data[(lex.p)] > 90:
			if 97 <= lex.data[(lex.p)] && lex.data[(lex.p)] <= 122 {
				goto tr27
			}
		default:
			goto tr27
		}
		goto tr65
	tr153:
		lex.te = (lex.p) + 1

		lex.act = 41
		goto st109
	st109:
		if (lex.p)++; (lex.p) == (lex.pe) {
			goto _test_eof109
		}
	st_case_109:
		switch lex.data[(lex.p)] {
		case 46:
			goto st18
		case 95:
			goto tr27
		case 104:
			goto tr70
		}
		switch {
		case lex.data[(lex.p)] < 65:
			if 48 <= lex.data[(lex.p)] && lex.data[(lex.p)] <= 57 {
				goto tr27
			}
		case lex.data[(lex.p)] > 90:
			if 97 <= lex.data[(lex.p)] && lex.data[(lex.p)] <= 122 {
				goto tr27
			}
		default:
			goto tr27
		}
		goto tr65
	tr148:
		lex.te = (lex.p) + 1

		lex.act = 41
		goto st110
	st110:
		if (lex.p)++; (lex.p) == (lex.pe) {
			goto _test_eof110
		}
	st_case_110:
		switch lex.data[(lex.p)] {
		case 46:
			goto st18
		case 95:
			goto tr27
		case 97:
			goto tr154
		case 111:
			goto tr155
		}
		switch {
		case lex.data[(lex.p)] < 65:
			if 48 <= lex.data[(lex.p)] && lex.data[(lex.p)] <= 57 {
				goto tr27
			}
		case lex.data[(lex.p)] > 90:
			if 98 <= lex.data[(lex.p)] && lex.data[(lex.p)] <= 122 {
				goto tr27
			}
		default:
			goto tr27
		}
		goto tr65
	tr154:
		lex.te = (lex.p) + 1

		lex.act = 41
		goto st111
	st111:
		if (lex.p)++; (lex.p) == (lex.pe) {
			goto _test_eof111
		}
	st_case_111:
		switch lex.data[(lex.p)] {
		case 46:
			goto st18
		case 95:
			goto tr27
		case 115:
			goto tr118
		}
		switch {
		case lex.data[(lex.p)] < 65:
			if 48 <= lex.data[(lex.p)] && lex.data[(lex.p)] <= 57 {
				goto tr27
			}
		case lex.data[(lex.p)] > 90:
			if 97 <= lex.data[(lex.p)] && lex.data[(lex.p)] <= 122 {
				goto tr27
			}
		default:
			goto tr27
		}
		goto tr65
	tr155:
		lex.te = (lex.p) + 1

		lex.act = 41
		goto st112
	st112:
		if (lex.p)++; (lex.p) == (lex.pe) {
			goto _test_eof112
		}
	st_case_112:
		switch lex.data[(lex.p)] {
		case 46:
			goto st18
		case 95:
			goto tr27
		case 110:
			goto tr151
		}
		switch {
		case lex.data[(lex.p)] < 65:
			if 48 <= lex.data[(lex.p)] && lex.data[(lex.p)] <= 57 {
				goto tr27
			}
		case lex.data[(lex.p)] > 90:
			if 97 <= lex.data[(lex.p)] && lex.data[(lex.p)] <= 122 {
				goto tr27
			}
		default:
			goto tr27
		}
		goto tr65
	tr149:
		lex.te = (lex.p) + 1

		lex.act = 41
		goto st113
	st113:
		if (lex.p)++; (lex.p) == (lex.pe) {
			goto _test_eof113
		}
	st_case_113:
		switch lex.data[(lex.p)] {
		case 46:
			goto st18
		case 95:
			goto tr27
		case 110:
			goto tr156
		}
		switch {
		case lex.data[(lex.p)] < 65:
			if 48 <= lex.data[(lex.p)] && lex.data[(lex.p)] <= 57 {
				goto tr27
			}
		case lex.data[(lex.p)] > 90:
			if 97 <= lex.data[(lex.p)] && lex.data[(lex.p)] <= 122 {
				goto tr27
			}
		default:
			goto tr27
		}
		goto tr65
	tr156:
		lex.te = (lex.p) + 1

		lex.act = 41
		goto st114
	st114:
		if (lex.p)++; (lex.p) == (lex.pe) {
			goto _test_eof114
		}
	st_case_114:
		switch lex.data[(lex.p)] {
		case 46:
			goto st18
		case 95:
			goto tr27
		case 115:
			goto tr157
		case 116:
			goto tr158
		}
		switch {
		case lex.data[(lex.p)] < 65:
			if 48 <= lex.data[(lex.p)] && lex.data[(lex.p)] <= 57 {
				goto tr27
			}
		case lex.data[(lex.p)] > 90:
			if 97 <= lex.data[(lex.p)] && lex.data[(lex.p)] <= 122 {
				goto tr27
			}
		default:
			goto tr27
		}
		goto tr65
	tr157:
		lex.te = (lex.p) + 1

		lex.act = 41
		goto st115
	st115:
		if (lex.p)++; (lex.p) == (lex.pe) {
			goto _test_eof115
		}
	st_case_115:
		switch lex.data[(lex.p)] {
		case 46:
			goto st18
		case 95:
			goto tr27
		case 116:
			goto tr159
		}
		switch {
		case lex.data[(lex.p)] < 65:
			if 48 <= lex.data[(lex.p)] && lex.data[(lex.p)] <= 57 {
				goto tr27
			}
		case lex.data[(lex.p)] > 90:
			if 97 <= lex.data[(lex.p)] && lex.data[(lex.p)] <= 122 {
				goto tr27
			}
		default:
			goto tr27
		}
		goto tr65
	tr159:
		lex.te = (lex.p) + 1

		lex.act = 26
		goto st116
	st116:
		if (lex.p)++; (lex.p) == (lex.pe) {
			goto _test_eof116
		}
	st_case_116:
		switch lex.data[(lex.p)] {
		case 9:
			goto st117
		case 10:
			goto tr162
		case 13:
			goto st117
		case 32:
			goto st117
		case 46:
			goto st18
		case 95:
			goto tr27
		}
		switch {
		case lex.data[(lex.p)] < 65:
			if 48 <= lex.data[(lex.p)] && lex.data[(lex.p)] <= 57 {
				goto tr27
			}
		case lex.data[(lex.p)] > 90:
			if 97 <= lex.data[(lex.p)] && lex.data[(lex.p)] <= 122 {
				goto tr27
			}
		default:
			goto tr27
		}
		goto tr160
	tr162:

		lex.line++
		lex.lineStart = lex.p + 1
		lex.linesSinceDocstring++

		goto st117
	st117:
		if (lex.p)++; (lex.p) == (lex.pe) {
			goto _test_eof117
		}
	st_case_117:
		switch lex.data[(lex.p)] {
		case 9:
			goto st117
		case 10:
			goto tr162
		case 13:
			goto st117
		case 32:
			goto st117
		}
		goto tr160
	tr158:
		lex.te = (lex.p) + 1

		lex.act = 41
		goto st118
	st118:
		if (lex.p)++; (lex.p) == (lex.pe) {
			goto _test_eof118
		}
	st_case_118:
		switch lex.data[(lex.p)] {
		case 46:
			goto st18
		case 95:
			goto tr27
		case 105:
			goto tr163
		}
		switch {
		case lex.data[(lex.p)] < 65:
			if 48 <= lex.data[(lex.p)] && lex.data[(lex.p)] <= 57 {
				goto tr27
			}
		case lex.data[(lex.p)] > 90:
			if 97 <= lex.data[(lex.p)] && lex.data[(lex.p)] <= 122 {
				goto tr27
			}
		default:
			goto tr27
		}
		goto tr65
	tr163:
		lex.te = (lex.p) + 1

		lex.act = 41
		goto st119
	st119:
		if (lex.p)++; (lex.p) == (lex.pe) {
			goto _test_eof119
		}
	st_case_119:
		switch lex.data[(lex.p)] {
		case 46:
			goto st18
		case 95:
			goto tr27
		case 110:
			goto tr164
		}
		switch {
		case lex.data[(lex.p)] < 65:
			if 48 <= lex.data[(lex.p)] && lex.data[(lex.p)] <= 57 {
				goto tr27
			}
		case lex.data[(lex.p)] > 90:
			if 97 <= lex.data[(lex.p)] && lex.data[(lex.p)] <= 122 {
				goto tr27
			}
		default:
			goto tr27
		}
		goto tr65
	tr164:
		lex.te = (lex.p) + 1

		lex.act = 41
		goto st120
	st120:
		if (lex.p)++; (lex.p) == (lex.pe) {
			goto _test_eof120
		}
	st_case_120:
		switch lex.data[(lex.p)] {
		case 46:
			goto st18
		case 95:
			goto tr27
		case 117:
			goto tr151
		}
		switch {
		case lex.data[(lex.p)] < 65:
			if 48 <= lex.data[(lex.p)] && lex.data[(lex.p)] <= 57 {
				goto tr27
			}
		case lex.data[(lex.p)] > 90:
			if 97 <= lex.data[(lex.p)] && lex.data[(lex.p)] <= 122 {
				goto tr27
			}
		default:
			goto tr27
		}
		goto tr65
	tr150:
		lex.te = (lex.p) + 1

		lex.act = 41
		goto st121
	st121:
		if (lex.p)++; (lex.p) == (lex.pe) {
			goto _test_eof121
		}
	st_case_121:
		switch lex.data[(lex.p)] {
		case 46:
			goto st18
		case 95:
			goto tr27
		case 112:
			goto tr165
		}
		switch {
		case lex.data[(lex.p)] < 65:
			if 48 <= lex.data[(lex.p)] && lex.data[(lex.p)] <= 57 {
				goto tr27
			}
		case lex.data[(lex.p)] > 90:
			if 97 <= lex.data[(lex.p)] && lex.data[(lex.p)] <= 122 {
				goto tr27
			}
		default:
			goto tr27
		}
		goto tr65
	tr165:
		lex.te = (lex.p) + 1

		lex.act = 41
		goto st122
	st122:
		if (lex.p)++; (lex.p) == (lex.pe) {
			goto _test_eof122
		}
	st_case_122:
		switch lex.data[(lex.p)] {
		case 46:
			goto st18
		case 95:
			goto tr166
		}
		switch {
		case lex.data[(lex.p)] < 65:
			if 48 <= lex.data[(lex.p)] && lex.data[(lex.p)] <= 57 {
				goto tr27
			}
		case lex.data[(lex.p)] > 90:
			if 97 <= lex.data[(lex.p)] && lex.data[(lex.p)] <= 122 {
				goto tr27
			}
		default:
			goto tr27
		}
		goto tr65
	tr166:
		lex.te = (lex.p) + 1

		lex.act = 41
		goto st123
	st123:
		if (lex.p)++; (lex.p) == (lex.pe) {
			goto _test_eof123
		}
	st_case_123:
		switch lex.data[(lex.p)] {
		case 46:
			goto st18
		case 95:
			goto tr27
		case 105:
			goto tr167
		}
		switch {
		case lex.data[(lex.p)] < 65:
			if 48 <= lex.data[(lex.p)] && lex.data[(lex.p)] <= 57 {
				goto tr27
			}
		case lex.data[(lex.p)] > 90:
			if 97 <= lex.data[(lex.p)] && lex.data[(lex.p)] <= 122 {
				goto tr27
			}
		default:
			goto tr27
		}
		goto tr65
	tr167:
		lex.te = (lex.p) + 1

		lex.act = 41
		goto st124
	st124:
		if (lex.p)++; (lex.p) == (lex.pe) {
			goto _test_eof124
		}
	st_case_124:
		switch lex.data[(lex.p)] {
		case 46:
			goto st18
		case 95:
			goto tr27
		case 110:
			goto tr168
		}
		switch {
		case lex.data[(lex.p)] < 65:
			if 48 <= lex.data[(lex.p)] && lex.data[(lex.p)] <= 57 {
				goto tr27
			}
		case lex.data[(lex.p)] > 90:
			if 97 <= lex.data[(lex.p)] && lex.data[(lex.p)] <= 122 {
				goto tr27
			}
		default:
			goto tr27
		}
		goto tr65
	tr168:
		lex.te = (lex.p) + 1

		lex.act = 41
		goto st125
	st125:
		if (lex.p)++; (lex.p) == (lex.pe) {
			goto _test_eof125
		}
	st_case_125:
		switch lex.data[(lex.p)] {
		case 46:
			goto st18
		case 95:
			goto tr27
		case 99:
			goto tr169
		}
		switch {
		case lex.data[(lex.p)] < 65:
			if 48 <= lex.data[(lex.p)] && lex.data[(lex.p)] <= 57 {
				goto tr27
			}
		case lex.data[(lex.p)] > 90:
			if 97 <= lex.data[(lex.p)] && lex.data[(lex.p)] <= 122 {
				goto tr27
			}
		default:
			goto tr27
		}
		goto tr65
	tr169:
		lex.te = (lex.p) + 1

		lex.act = 41
		goto st126
	st126:
		if (lex.p)++; (lex.p) == (lex.pe) {
			goto _test_eof126
		}
	st_case_126:
		switch lex.data[(lex.p)] {
		case 46:
			goto st18
		case 95:
			goto tr27
		case 108:
			goto tr170
		}
		switch {
		case lex.data[(lex.p)] < 65:
			if 48 <= lex.data[(lex.p)] && lex.data[(lex.p)] <= 57 {
				goto tr27
			}
		case lex.data[(lex.p)] > 90:
			if 97 <= lex.data[(lex.p)] && lex.data[(lex.p)] <= 122 {
				goto tr27
			}
		default:
			goto tr27
		}
		goto tr65
	tr170:
		lex.te = (lex.p) + 1

		lex.act = 41
		goto st127
	st127:
		if (lex.p)++; (lex.p) == (lex.pe) {
			goto _test_eof127
		}
	st_case_127:
		switch lex.data[(lex.p)] {
		case 46:
			goto st18
		case 95:
			goto tr27
		case 117:
			goto tr171
		}
		switch {
		case lex.data[(lex.p)] < 65:
			if 48 <= lex.data[(lex.p)] && lex.data[(lex.p)] <= 57 {
				goto tr27
			}
		case lex.data[(lex.p)] > 90:
			if 97 <= lex.data[(lex.p)] && lex.data[(lex.p)] <= 122 {
				goto tr27
			}
		default:
			goto tr27
		}
		goto tr65
	tr171:
		lex.te = (lex.p) + 1

		lex.act = 41
		goto st128
	st128:
		if (lex.p)++; (lex.p) == (lex.pe) {
			goto _test_eof128
		}
	st_case_128:
		switch lex.data[(lex.p)] {
		case 46:
			goto st18
		case 95:
			goto tr27
		case 100:
			goto tr172
		}
		switch {
		case lex.data[(lex.p)] < 65:
			if 48 <= lex.data[(lex.p)] && lex.data[(lex.p)] <= 57 {
				goto tr27
			}
		case lex.data[(lex.p)] > 90:
			if 97 <= lex.data[(lex.p)] && lex.data[(lex.p)] <= 122 {
				goto tr27
			}
		default:
			goto tr27
		}
		goto tr65
	tr172:
		lex.te = (lex.p) + 1

		lex.act = 41
		goto st129
	st129:
		if (lex.p)++; (lex.p) == (lex.pe) {
			goto _test_eof129
		}
	st_case_129:
		switch lex.data[(lex.p)] {
		case 46:
			goto st18
		case 95:
			goto tr27
		case 101:
			goto tr173
		}
		switch {
		case lex.data[(lex.p)] < 65:
			if 48 <= lex.data[(lex.p)] && lex.data[(lex.p)] <= 57 {
				goto tr27
			}
		case lex.data[(lex.p)] > 90:
			if 97 <= lex.data[(lex.p)] && lex.data[(lex.p)] <= 122 {
				goto tr27
			}
		default:
			goto tr27
		}
		goto tr65
	tr173:
		lex.te = (lex.p) + 1

		lex.act = 2
		goto st130
	st130:
		if (lex.p)++; (lex.p) == (lex.pe) {
			goto _test_eof130
		}
	st_case_130:
		switch lex.data[(lex.p)] {
		case 9:
			goto st131
		case 10:
			goto tr176
		case 13:
			goto st131
		case 32:
			goto st131
		case 46:
			goto st18
		case 95:
			goto tr27
		}
		switch {
		case lex.data[(lex.p)] < 65:
			if 48 <= lex.data[(lex.p)] && lex.data[(lex.p)] <= 57 {
				goto tr27
			}
		case lex.data[(lex.p)] > 90:
			if 97 <= lex.data[(lex.p)] && lex.data[(lex.p)] <= 122 {
				goto tr27
			}
		default:
			goto tr27
		}
		goto tr174
	tr176:

		lex.line++
		lex.lineStart = lex.p + 1
		lex.linesSinceDocstring++

		goto st131
	st131:
		if (lex.p)++; (lex.p) == (lex.pe) {
			goto _test_eof131
		}
	st_case_131:
		switch lex.data[(lex.p)] {
		case 9:
			goto st131
		case 10:
			goto tr176
		case 13:
			goto st131
		case 32:
			goto st131
		}
		goto tr174
	tr40:
		lex.te = (lex.p) + 1

		lex.act = 41
		goto st132
	st132:
		if (lex.p)++; (lex.p) == (lex.pe) {
			goto _test_eof132
		}
	st_case_132:
		switch lex.data[(lex.p)] {
		case 46:
			goto st18
		case 95:
			goto tr27
		case 101:
			goto tr177
		case 111:
			goto tr178
		case 121:
			goto tr179
		}
		switch {
		case lex.data[(lex.p)] < 65:
			if 48 <= lex.data[(lex.p)] && lex.data[(lex.p)] <= 57 {
				goto tr27
			}
		case lex.data[(lex.p)] > 90:
			if 97 <= lex.data[(lex.p)] && lex.data[(lex.p)] <= 122 {
				goto tr27
			}
		default:
			goto tr27
		}
		goto tr65
	tr177:
		lex.te = (lex.p) + 1

		lex.act = 41
		goto st133
	st133:
		if (lex.p)++; (lex.p) == (lex.pe) {
			goto _test_eof133
		}
	st_case_133:
		switch lex.data[(lex.p)] {
		case 46:
			goto st18
		case 95:
			goto tr27
		case 99:
			goto tr180
		case 102:
			goto tr181
		case 108:
			goto tr182
		}
		switch {
		case lex.data[(lex.p)] < 65:
			if 48 <= lex.data[(lex.p)] && lex.data[(lex.p)] <= 57 {
				goto tr27
			}
		case lex.data[(lex.p)] > 90:
			if 97 <= lex.data[(lex.p)] && lex.data[(lex.p)] <= 122 {
				goto tr27
			}
		default:
			goto tr27
		}
		goto tr65
	tr180:
		lex.te = (lex.p) + 1

		lex.act = 41
		goto st134
	st134:
		if (lex.p)++; (lex.p) == (lex.pe) {
			goto _test_eof134
		}
	st_case_134:
		switch lex.data[(lex.p)] {
		case 46:
			goto st18
		case 95:
			goto tr27
		case 108:
			goto tr183
		}
		switch {
		case lex.data[(lex.p)] < 65:
			if 48 <= lex.data[(lex.p)] && lex.data[(lex.p)] <= 57 {
				goto tr27
			}
		case lex.data[(lex.p)] > 90:
			if 97 <= lex.data[(lex.p)] && lex.data[(lex.p)] <= 122 {
				goto tr27
			}
		default:
			goto tr27
		}
		goto tr65
	tr183:
		lex.te = (lex.p) + 1

		lex.act = 41
		goto st135
	st135:
		if (lex.p)++; (lex.p) == (lex.pe) {
			goto _test_eof135
		}
	st_case_135:
		switch lex.data[(lex.p)] {
		case 46:
			goto st18
		case 95:
			goto tr27
		case 97:
			goto tr184
		}
		switch {
		case lex.data[(lex.p)] < 65:
			if 48 <= lex.data[(lex.p)] && lex.data[(lex.p)] <= 57 {
				goto tr27
			}
		case lex.data[(lex.p)] > 90:
			if 98 <= lex.data[(lex.p)] && lex.data[(lex.p)] <= 122 {
				goto tr27
			}
		default:
			goto tr27
		}
		goto tr65
	tr184:
		lex.te = (lex.p) + 1

		lex.act = 41
		goto st136
	st136:
		if (lex.p)++; (lex.p) == (lex.pe) {
			goto _test_eof136
		}
	st_case_136:
		switch lex.data[(lex.p)] {
		case 46:
			goto st18
		case 95:
			goto tr27
		case 114:
			goto tr151
		}
		switch {
		case lex.data[(lex.p)] < 65:
			if 48 <= lex.data[(lex.p)] && lex.data[(lex.p)] <= 57 {
				goto tr27
			}
		case lex.data[(lex.p)] > 90:
			if 97 <= lex.data[(lex.p)] && lex.data[(lex.p)] <= 122 {
				goto tr27
			}
		default:
			goto tr27
		}
		goto tr65
	tr181:
		lex.te = (lex.p) + 1

		reservedKeyword = string(lex.data[lex.ts:lex.te])
		lex.act = 40
		goto st137
	st137:
		if (lex.p)++; (lex.p) == (lex.pe) {
			goto _test_eof137
		}
	st_case_137:
		switch lex.data[(lex.p)] {
		case 9:
			goto st33
		case 10:
			goto tr73
		case 13:
			goto st33
		case 32:
			goto st33
		case 46:
			goto st18
		case 95:
			goto tr27
		case 97:
			goto tr185
		}
		switch {
		case lex.data[(lex.p)] < 65:
			if 48 <= lex.data[(lex.p)] && lex.data[(lex.p)] <= 57 {
				goto tr27
			}
		case lex.data[(lex.p)] > 90:
			if 98 <= lex.data[(lex.p)] && lex.data[(lex.p)] <= 122 {
				goto tr27
			}
		default:
			goto tr27
		}
		goto tr71
	tr185:
		lex.te = (lex.p) + 1

		lex.act = 41
		goto st138
	st138:
		if (lex.p)++; (lex.p) == (lex.pe) {
			goto _test_eof138
		}
	st_case_138:
		switch lex.data[(lex.p)] {
		case 46:
			goto st18
		case 95:
			goto tr27
		case 117:
			goto tr186
		}
		switch {
		case lex.data[(lex.p)] < 65:
			if 48 <= lex.data[(lex.p)] && lex.data[(lex.p)] <= 57 {
				goto tr27
			}
		case lex.data[(lex.p)] > 90:
			if 97 <= lex.data[(lex.p)] && lex.data[(lex.p)] <= 122 {
				goto tr27
			}
		default:
			goto tr27
		}
		goto tr65
	tr186:
		lex.te = (lex.p) + 1

		lex.act = 41
		goto st139
	st139:
		if (lex.p)++; (lex.p) == (lex.pe) {
			goto _test_eof139
		}
	st_case_139:
		switch lex.data[(lex.p)] {
		case 46:
			goto st18
		case 95:
			goto tr27
		case 108:
			goto tr116
		}
		switch {
		case lex.data[(lex.p)] < 65:
			if 48 <= lex.data[(lex.p)] && lex.data[(lex.p)] <= 57 {
				goto tr27
			}
		case lex.data[(lex.p)] > 90:
			if 97 <= lex.data[(lex.p)] && lex.data[(lex.p)] <= 122 {
				goto tr27
			}
		default:
			goto tr27
		}
		goto tr65
	tr182:
		lex.te = (lex.p) + 1

		reservedKeyword = string(lex.data[lex.ts:lex.te])
		lex.act = 40
		goto st140
	st140:
		if (lex.p)++; (lex.p) == (lex.pe) {
			goto _test_eof140
		}
	st_case_140:
		switch lex.data[(lex.p)] {
		case 9:
			goto st33
		case 10:
			goto tr73
		case 13:
			goto st33
		case 32:
			goto st33
		case 46:
			goto st18
		case 95:
			goto tr27
		case 101:
			goto tr187
		}
		switch {
		case lex.data[(lex.p)] < 65:
			if 48 <= lex.data[(lex.p)] && lex.data[(lex.p)] <= 57 {
				goto tr27
			}
		case lex.data[(lex.p)] > 90:
			if 97 <= lex.data[(lex.p)] && lex.data[(lex.p)] <= 122 {
				goto tr27
			}
		default:
			goto tr27
		}
		goto tr71
	tr187:
		lex.te = (lex.p) + 1

		lex.act = 41
		goto st141
	st141:
		if (lex.p)++; (lex.p) == (lex.pe) {
			goto _test_eof141
		}
	st_case_141:
		switch lex.data[(lex.p)] {
		case 46:
			goto st18
		case 95:
			goto tr27
		case 116:
			goto tr151
		}
		switch {
		case lex.data[(lex.p)] < 65:
			if 48 <= lex.data[(lex.p)] && lex.data[(lex.p)] <= 57 {
				goto tr27
			}
		case lex.data[(lex.p)] > 90:
			if 97 <= lex.data[(lex.p)] && lex.data[(lex.p)] <= 122 {
				goto tr27
			}
		default:
			goto tr27
		}
		goto tr65
	tr178:
		lex.te = (lex.p) + 1

		reservedKeyword = string(lex.data[lex.ts:lex.te])
		lex.act = 40
		goto st142
	st142:
		if (lex.p)++; (lex.p) == (lex.pe) {
			goto _test_eof142
		}
	st_case_142:
		switch lex.data[(lex.p)] {
		case 9:
			goto st33
		case 10:
			goto tr73
		case 13:
			goto st33
		case 32:
			goto st33
		case 46:
			goto st18
		case 95:
			goto tr27
		case 117:
			goto tr188
		}
		switch {
		case lex.data[(lex.p)] < 65:
			if 48 <= lex.data[(lex.p)] && lex.data[(lex.p)] <= 57 {
				goto tr27
			}
		case lex.data[(lex.p)] > 90:
			if 97 <= lex.data[(lex.p)] && lex.data[(lex.p)] <= 122 {
				goto tr27
			}
		default:
			goto tr27
		}
		goto tr71
	tr188:
		lex.te = (lex.p) + 1

		lex.act = 41
		goto st143
	st143:
		if (lex.p)++; (lex.p) == (lex.pe) {
			goto _test_eof143
		}
	st_case_143:
		switch lex.data[(lex.p)] {
		case 46:
			goto st18
		case 95:
			goto tr27
		case 98:
			goto tr189
		}
		switch {
		case lex.data[(lex.p)] < 65:
			if 48 <= lex.data[(lex.p)] && lex.data[(lex.p)] <= 57 {
				goto tr27
			}
		case lex.data[(lex.p)] > 90:
			if 97 <= lex.data[(lex.p)] && lex.data[(lex.p)] <= 122 {
				goto tr27
			}
		default:
			goto tr27
		}
		goto tr65
	tr189:
		lex.te = (lex.p) + 1

		lex.act = 41
		goto st144
	st144:
		if (lex.p)++; (lex.p) == (lex.pe) {
			goto _test_eof144
		}
	st_case_144:
		switch lex.data[(lex.p)] {
		case 46:
			goto st18
		case 95:
			goto tr27
		case 108:
			goto tr190
		}
		switch {
		case lex.data[(lex.p)] < 65:
			if 48 <= lex.data[(lex.p)] && lex.data[(lex.p)] <= 57 {
				goto tr27
			}
		case lex.data[(lex.p)] > 90:
			if 97 <= lex.data[(lex.p)] && lex.data[(lex.p)] <= 122 {
				goto tr27
			}
		default:
			goto tr27
		}
		goto tr65
	tr190:
		lex.te = (lex.p) + 1

		lex.act = 41
		goto st145
	st145:
		if (lex.p)++; (lex.p) == (lex.pe) {
			goto _test_eof145
		}
	st_case_145:
		switch lex.data[(lex.p)] {
		case 46:
			goto st18
		case 95:
			goto tr27
		case 101:
			goto tr191
		}
		switch {
		case lex.data[(lex.p)] < 65:
			if 48 <= lex.data[(lex.p)] && lex.data[(lex.p)] <= 57 {
				goto tr27
			}
		case lex.data[(lex.p)] > 90:
			if 97 <= lex.data[(lex.p)] && lex.data[(lex.p)] <= 122 {
				goto tr27
			}
		default:
			goto tr27
		}
		goto tr65
	tr191:
		lex.te = (lex.p) + 1

		lex.act = 11
		goto st146
	st146:
		if (lex.p)++; (lex.p) == (lex.pe) {
			goto _test_eof146
		}
	st_case_146:
		switch lex.data[(lex.p)] {
		case 9:
			goto st147
		case 10:
			goto tr194
		case 13:
			goto st147
		case 32:
			goto st147
		case 46:
			goto st18
		case 95:
			goto tr27
		}
		switch {
		case lex.data[(lex.p)] < 65:
			if 48 <= lex.data[(lex.p)] && lex.data[(lex.p)] <= 57 {
				goto tr27
			}
		case lex.data[(lex.p)] > 90:
			if 97 <= lex.data[(lex.p)] && lex.data[(lex.p)] <= 122 {
				goto tr27
			}
		default:
			goto tr27
		}
		goto tr192
	tr194:

		lex.line++
		lex.lineStart = lex.p + 1
		lex.linesSinceDocstring++

		goto st147
	st147:
		if (lex.p)++; (lex.p) == (lex.pe) {
			goto _test_eof147
		}
	st_case_147:
		switch lex.data[(lex.p)] {
		case 9:
			goto st147
		case 10:
			goto tr194
		case 13:
			goto st147
		case 32:
			goto st147
		}
		goto tr192
	tr179:
		lex.te = (lex.p) + 1

		lex.act = 41
		goto st148
	st148:
		if (lex.p)++; (lex.p) == (lex.pe) {
			goto _test_eof148
		}
	st_case_148:
		switch lex.data[(lex.p)] {
		case 46:
			goto st18
		case 95:
			goto tr27
		case 110:
			goto tr195
		}
		switch {
		case lex.data[(lex.p)] < 65:
			if 48 <= lex.data[(lex.p)] && lex.data[(lex.p)] <= 57 {
				goto tr27
			}
		case lex.data[(lex.p)] > 90:
			if 97 <= lex.data[(lex.p)] && lex.data[(lex.p)] <= 122 {
				goto tr27
			}
		default:
			goto tr27
		}
		goto tr65
	tr195:
		lex.te = (lex.p) + 1

		lex.act = 41
		goto st149
	st149:
		if (lex.p)++; (lex.p) == (lex.pe) {
			goto _test_eof149
		}
	st_case_149:
		switch lex.data[(lex.p)] {
		case 46:
			goto st18
		case 95:
			goto tr27
		case 97:
			goto tr196
		}
		switch {
		case lex.data[(lex.p)] < 65:
			if 48 <= lex.data[(lex.p)] && lex.data[(lex.p)] <= 57 {
				goto tr27
			}
		case lex.data[(lex.p)] > 90:
			if 98 <= lex.data[(lex.p)] && lex.data[(lex.p)] <= 122 {
				goto tr27
			}
		default:
			goto tr27
		}
		goto tr65
	tr196:
		lex.te = (lex.p) + 1

		lex.act = 41
		goto st150
	st150:
		if (lex.p)++; (lex.p) == (lex.pe) {
			goto _test_eof150
		}
	st_case_150:
		switch lex.data[(lex.p)] {
		case 46:
			goto st18
		case 95:
			goto tr27
		case 109:
			goto tr197
		}
		switch {
		case lex.data[(lex.p)] < 65:
			if 48 <= lex.data[(lex.p)] && lex.data[(lex.p)] <= 57 {
				goto tr27
			}
		case lex.data[(lex.p)] > 90:
			if 97 <= lex.data[(lex.p)] && lex.data[(lex.p)] <= 122 {
				goto tr27
			}
		default:
			goto tr27
		}
		goto tr65
	tr197:
		lex.te = (lex.p) + 1

		lex.act = 41
		goto st151
	st151:
		if (lex.p)++; (lex.p) == (lex.pe) {
			goto _test_eof151
		}
	st_case_151:
		switch lex.data[(lex.p)] {
		case 46:
			goto st18
		case 95:
			goto tr27
		case 105:
			goto tr198
		}
		switch {
		case lex.data[(lex.p)] < 65:
			if 48 <= lex.data[(lex.p)] && lex.data[(lex.p)] <= 57 {
				goto tr27
			}
		case lex.data[(lex.p)] > 90:
			if 97 <= lex.data[(lex.p)] && lex.data[(lex.p)] <= 122 {
				goto tr27
			}
		default:
			goto tr27
		}
		goto tr65
	tr198:
		lex.te = (lex.p) + 1

		lex.act = 41
		goto st152
	st152:
		if (lex.p)++; (lex.p) == (lex.pe) {
			goto _test_eof152
		}
	st_case_152:
		switch lex.data[(lex.p)] {
		case 46:
			goto st18
		case 95:
			goto tr27
		case 99:
			goto tr70
		}
		switch {
		case lex.data[(lex.p)] < 65:
			if 48 <= lex.data[(lex.p)] && lex.data[(lex.p)] <= 57 {
				goto tr27
			}
		case lex.data[(lex.p)] > 90:
			if 97 <= lex.data[(lex.p)] && lex.data[(lex.p)] <= 122 {
				goto tr27
			}
		default:
			goto tr27
		}
		goto tr65
	tr41:
		lex.te = (lex.p) + 1

		lex.act = 41
		goto st153
	st153:
		if (lex.p)++; (lex.p) == (lex.pe) {
			goto _test_eof153
		}
	st_case_153:
		switch lex.data[(lex.p)] {
		case 46:
			goto st18
		case 95:
			goto tr27
		case 108:
			goto tr199
		case 110:
			goto tr200
		case 120:
			goto tr201
		}
		switch {
		case lex.data[(lex.p)] < 65:
			if 48 <= lex.data[(lex.p)] && lex.data[(lex.p)] <= 57 {
				goto tr27
			}
		case lex.data[(lex.p)] > 90:
			if 97 <= lex.data[(lex.p)] && lex.data[(lex.p)] <= 122 {
				goto tr27
			}
		default:
			goto tr27
		}
		goto tr65
	tr199:
		lex.te = (lex.p) + 1

		lex.act = 41
		goto st154
	st154:
		if (lex.p)++; (lex.p) == (lex.pe) {
			goto _test_eof154
		}
	st_case_154:
		switch lex.data[(lex.p)] {
		case 46:
			goto st18
		case 95:
			goto tr27
		case 105:
			goto tr202
		case 115:
			goto tr203
		}
		switch {
		case lex.data[(lex.p)] < 65:
			if 48 <= lex.data[(lex.p)] && lex.data[(lex.p)] <= 57 {
				goto tr27
			}
		case lex.data[(lex.p)] > 90:
			if 97 <= lex.data[(lex.p)] && lex.data[(lex.p)] <= 122 {
				goto tr27
			}
		default:
			goto tr27
		}
		goto tr65
	tr202:
		lex.te = (lex.p) + 1

		lex.act = 41
		goto st155
	st155:
		if (lex.p)++; (lex.p) == (lex.pe) {
			goto _test_eof155
		}
	st_case_155:
		switch lex.data[(lex.p)] {
		case 46:
			goto st18
		case 95:
			goto tr27
		case 102:
			goto tr70
		}
		switch {
		case lex.data[(lex.p)] < 65:
			if 48 <= lex.data[(lex.p)] && lex.data[(lex.p)] <= 57 {
				goto tr27
			}
		case lex.data[(lex.p)] > 90:
			if 97 <= lex.data[(lex.p)] && lex.data[(lex.p)] <= 122 {
				goto tr27
			}
		default:
			goto tr27
		}
		goto tr65
	tr203:
		lex.te = (lex.p) + 1

		lex.act = 41
		goto st156
	st156:
		if (lex.p)++; (lex.p) == (lex.pe) {
			goto _test_eof156
		}
	st_case_156:
		switch lex.data[(lex.p)] {
		case 46:
			goto st18
		case 95:
			goto tr27
		case 101:
			goto tr204
		case 105:
			goto tr202
		}
		switch {
		case lex.data[(lex.p)] < 65:
			if 48 <= lex.data[(lex.p)] && lex.data[(lex.p)] <= 57 {
				goto tr27
			}
		case lex.data[(lex.p)] > 90:
			if 97 <= lex.data[(lex.p)] && lex.data[(lex.p)] <= 122 {
				goto tr27
			}
		default:
			goto tr27
		}
		goto tr65
	tr204:
		lex.te = (lex.p) + 1

		reservedKeyword = string(lex.data[lex.ts:lex.te])
		lex.act = 40
		goto st157
	st157:
		if (lex.p)++; (lex.p) == (lex.pe) {
			goto _test_eof157
		}
	st_case_157:
		switch lex.data[(lex.p)] {
		case 9:
			goto st33
		case 10:
			goto tr73
		case 13:
			goto st33
		case 32:
			goto st33
		case 46:
			goto st18
		case 95:
			goto tr27
		case 105:
			goto tr202
		}
		switch {
		case lex.data[(lex.p)] < 65:
			if 48 <= lex.data[(lex.p)] && lex.data[(lex.p)] <= 57 {
				goto tr27
			}
		case lex.data[(lex.p)] > 90:
			if 97 <= lex.data[(lex.p)] && lex.data[(lex.p)] <= 122 {
				goto tr27
			}
		default:
			goto tr27
		}
		goto tr71
	tr200:
		lex.te = (lex.p) + 1

		lex.act = 41
		goto st158
	st158:
		if (lex.p)++; (lex.p) == (lex.pe) {
			goto _test_eof158
		}
	st_case_158:
		switch lex.data[(lex.p)] {
		case 46:
			goto st18
		case 95:
			goto tr27
		case 100:
			goto tr205
		case 115:
			goto tr206
		case 117:
			goto tr207
		}
		switch {
		case lex.data[(lex.p)] < 65:
			if 48 <= lex.data[(lex.p)] && lex.data[(lex.p)] <= 57 {
				goto tr27
			}
		case lex.data[(lex.p)] > 90:
			if 97 <= lex.data[(lex.p)] && lex.data[(lex.p)] <= 122 {
				goto tr27
			}
		default:
			goto tr27
		}
		goto tr65
	tr205:
		lex.te = (lex.p) + 1

		reservedKeyword = string(lex.data[lex.ts:lex.te])
		lex.act = 40
		goto st159
	st159:
		if (lex.p)++; (lex.p) == (lex.pe) {
			goto _test_eof159
		}
	st_case_159:
		switch lex.data[(lex.p)] {
		case 9:
			goto st33
		case 10:
			goto tr73
		case 13:
			goto st33
		case 32:
			goto st33
		case 46:
			goto st18
		case 95:
			goto tr27
		case 100:
			goto tr208
		case 102:
			goto tr209
		case 105:
			goto tr202
		case 115:
			goto tr210
		case 119:
			goto tr211
		}
		switch {
		case lex.data[(lex.p)] < 65:
			if 48 <= lex.data[(lex.p)] && lex.data[(lex.p)] <= 57 {
				goto tr27
			}
		case lex.data[(lex.p)] > 90:
			if 97 <= lex.data[(lex.p)] && lex.data[(lex.p)] <= 122 {
				goto tr27
			}
		default:
			goto tr27
		}
		goto tr71
	tr208:
		lex.te = (lex.p) + 1

		lex.act = 41
		goto st160
	st160:
		if (lex.p)++; (lex.p) == (lex.pe) {
			goto _test_eof160
		}
	st_case_160:
		switch lex.data[(lex.p)] {
		case 46:
			goto st18
		case 95:
			goto tr27
		case 101:
			goto tr212
		}
		switch {
		case lex.data[(lex.p)] < 65:
			if 48 <= lex.data[(lex.p)] && lex.data[(lex.p)] <= 57 {
				goto tr27
			}
		case lex.data[(lex.p)] > 90:
			if 97 <= lex.data[(lex.p)] && lex.data[(lex.p)] <= 122 {
				goto tr27
			}
		default:
			goto tr27
		}
		goto tr65
	tr212:
		lex.te = (lex.p) + 1

		lex.act = 41
		goto st161
	st161:
		if (lex.p)++; (lex.p) == (lex.pe) {
			goto _test_eof161
		}
	st_case_161:
		switch lex.data[(lex.p)] {
		case 46:
			goto st18
		case 95:
			goto tr27
		case 99:
			goto tr180
		}
		switch {
		case lex.data[(lex.p)] < 65:
			if 48 <= lex.data[(lex.p)] && lex.data[(lex.p)] <= 57 {
				goto tr27
			}
		case lex.data[(lex.p)] > 90:
			if 97 <= lex.data[(lex.p)] && lex.data[(lex.p)] <= 122 {
				goto tr27
			}
		default:
			goto tr27
		}
		goto tr65
	tr209:
		lex.te = (lex.p) + 1

		lex.act = 41
		goto st162
	st162:
		if (lex.p)++; (lex.p) == (lex.pe) {
			goto _test_eof162
		}
	st_case_162:
		switch lex.data[(lex.p)] {
		case 46:
			goto st18
		case 95:
			goto tr27
		case 111:
			goto tr213
		}
		switch {
		case lex.data[(lex.p)] < 65:
			if 48 <= lex.data[(lex.p)] && lex.data[(lex.p)] <= 57 {
				goto tr27
			}
		case lex.data[(lex.p)] > 90:
			if 97 <= lex.data[(lex.p)] && lex.data[(lex.p)] <= 122 {
				goto tr27
			}
		default:
			goto tr27
		}
		goto tr65
	tr213:
		lex.te = (lex.p) + 1

		lex.act = 41
		goto st163
	st163:
		if (lex.p)++; (lex.p) == (lex.pe) {
			goto _test_eof163
		}
	st_case_163:
		switch lex.data[(lex.p)] {
		case 46:
			goto st18
		case 95:
			goto tr27
		case 114:
			goto tr214
		}
		switch {
		case lex.data[(lex.p)] < 65:
			if 48 <= lex.data[(lex.p)] && lex.data[(lex.p)] <= 57 {
				goto tr27
			}
		case lex.data[(lex.p)] > 90:
			if 97 <= lex.data[(lex.p)] && lex.data[(lex.p)] <= 122 {
				goto tr27
			}
		default:
			goto tr27
		}
		goto tr65
	tr214:
		lex.te = (lex.p) + 1

		reservedKeyword = string(lex.data[lex.ts:lex.te])
		lex.act = 40
		goto st164
	st164:
		if (lex.p)++; (lex.p) == (lex.pe) {
			goto _test_eof164
		}
	st_case_164:
		switch lex.data[(lex.p)] {
		case 9:
			goto st33
		case 10:
			goto tr73
		case 13:
			goto st33
		case 32:
			goto st33
		case 46:
			goto st18
		case 95:
			goto tr27
		case 101:
			goto tr215
		}
		switch {
		case lex.data[(lex.p)] < 65:
			if 48 <= lex.data[(lex.p)] && lex.data[(lex.p)] <= 57 {
				goto tr27
			}
		case lex.data[(lex.p)] > 90:
			if 97 <= lex.data[(lex.p)] && lex.data[(lex.p)] <= 122 {
				goto tr27
			}
		default:
			goto tr27
		}
		goto tr71
	tr215:
		lex.te = (lex.p) + 1

		lex.act = 41
		goto st165
	st165:
		if (lex.p)++; (lex.p) == (lex.pe) {
			goto _test_eof165
		}
	st_case_165:
		switch lex.data[(lex.p)] {
		case 46:
			goto st18
		case 95:
			goto tr27
		case 97:
			goto tr152
		}
		switch {
		case lex.data[(lex.p)] < 65:
			if 48 <= lex.data[(lex.p)] && lex.data[(lex.p)] <= 57 {
				goto tr27
			}
		case lex.data[(lex.p)] > 90:
			if 98 <= lex.data[(lex.p)] && lex.data[(lex.p)] <= 122 {
				goto tr27
			}
		default:
			goto tr27
		}
		goto tr65
	tr210:
		lex.te = (lex.p) + 1

		lex.act = 41
		goto st166
	st166:
		if (lex.p)++; (lex.p) == (lex.pe) {
			goto _test_eof166
		}
	st_case_166:
		switch lex.data[(lex.p)] {
		case 46:
			goto st18
		case 95:
			goto tr27
		case 119:
			goto tr216
		}
		switch {
		case lex.data[(lex.p)] < 65:
			if 48 <= lex.data[(lex.p)] && lex.data[(lex.p)] <= 57 {
				goto tr27
			}
		case lex.data[(lex.p)] > 90:
			if 97 <= lex.data[(lex.p)] && lex.data[(lex.p)] <= 122 {
				goto tr27
			}
		default:
			goto tr27
		}
		goto tr65
	tr216:
		lex.te = (lex.p) + 1

		lex.act = 41
		goto st167
	st167:
		if (lex.p)++; (lex.p) == (lex.pe) {
			goto _test_eof167
		}
	st_case_167:
		switch lex.data[(lex.p)] {
		case 46:
			goto st18
		case 95:
			goto tr27
		case 105:
			goto tr217
		}
		switch {
		case lex.data[(lex.p)] < 65:
			if 48 <= lex.data[(lex.p)] && lex.data[(lex.p)] <= 57 {
				goto tr27
			}
		case lex.data[(lex.p)] > 90:
			if 97 <= lex.data[(lex.p)] && lex.data[(lex.p)] <= 122 {
				goto tr27
			}
		default:
			goto tr27
		}
		goto tr65
	tr217:
		lex.te = (lex.p) + 1

		lex.act = 41
		goto st168
	st168:
		if (lex.p)++; (lex.p) == (lex.pe) {
			goto _test_eof168
		}
	st_case_168:
		switch lex.data[(lex.p)] {
		case 46:
			goto st18
		case 95:
			goto tr27
		case 116:
			goto tr152
		}
		switch {
		case lex.data[(lex.p)] < 65:
			if 48 <= lex.data[(lex.p)] && lex.data[(lex.p)] <= 57 {
				goto tr27
			}
		case lex.data[(lex.p)] > 90:
			if 97 <= lex.data[(lex.p)] && lex.data[(lex.p)] <= 122 {
				goto tr27
			}
		default:
			goto tr27
		}
		goto tr65
	tr211:
		lex.te = (lex.p) + 1

		lex.act = 41
		goto st169
	st169:
		if (lex.p)++; (lex.p) == (lex.pe) {
			goto _test_eof169
		}
	st_case_169:
		switch lex.data[(lex.p)] {
		case 46:
			goto st18
		case 95:
			goto tr27
		case 104:
			goto tr218
		}
		switch {
		case lex.data[(lex.p)] < 65:
			if 48 <= lex.data[(lex.p)] && lex.data[(lex.p)] <= 57 {
				goto tr27
			}
		case lex.data[(lex.p)] > 90:
			if 97 <= lex.data[(lex.p)] && lex.data[(lex.p)] <= 122 {
				goto tr27
			}
		default:
			goto tr27
		}
		goto tr65
	tr218:
		lex.te = (lex.p) + 1

		lex.act = 41
		goto st170
	st170:
		if (lex.p)++; (lex.p) == (lex.pe) {
			goto _test_eof170
		}
	st_case_170:
		switch lex.data[(lex.p)] {
		case 46:
			goto st18
		case 95:
			goto tr27
		case 105:
			goto tr219
		}
		switch {
		case lex.data[(lex.p)] < 65:
			if 48 <= lex.data[(lex.p)] && lex.data[(lex.p)] <= 57 {
				goto tr27
			}
		case lex.data[(lex.p)] > 90:
			if 97 <= lex.data[(lex.p)] && lex.data[(lex.p)] <= 122 {
				goto tr27
			}
		default:
			goto tr27
		}
		goto tr65
	tr219:
		lex.te = (lex.p) + 1

		lex.act = 41
		goto st171
	st171:
		if (lex.p)++; (lex.p) == (lex.pe) {
			goto _test_eof171
		}
	st_case_171:
		switch lex.data[(lex.p)] {
		case 46:
			goto st18
		case 95:
			goto tr27
		case 108:
			goto tr151
		}
		switch {
		case lex.data[(lex.p)] < 65:
			if 48 <= lex.data[(lex.p)] && lex.data[(lex.p)] <= 57 {
				goto tr27
			}
		case lex.data[(lex.p)] > 90:
			if 97 <= lex.data[(lex.p)] && lex.data[(lex.p)] <= 122 {
				goto tr27
			}
		default:
			goto tr27
		}
		goto tr65
	tr206:
		lex.te = (lex.p) + 1

		lex.act = 41
		goto st172
	st172:
		if (lex.p)++; (lex.p) == (lex.pe) {
			goto _test_eof172
		}
	st_case_172:
		switch lex.data[(lex.p)] {
		case 46:
			goto st18
		case 95:
			goto tr27
		case 117:
			goto tr184
		}
		switch {
		case lex.data[(lex.p)] < 65:
			if 48 <= lex.data[(lex.p)] && lex.data[(lex.p)] <= 57 {
				goto tr27
			}
		case lex.data[(lex.p)] > 90:
			if 97 <= lex.data[(lex.p)] && lex.data[(lex.p)] <= 122 {
				goto tr27
			}
		default:
			goto tr27
		}
		goto tr65
	tr207:
		lex.te = (lex.p) + 1

		lex.act = 41
		goto st173
	st173:
		if (lex.p)++; (lex.p) == (lex.pe) {
			goto _test_eof173
		}
	st_case_173:
		switch lex.data[(lex.p)] {
		case 46:
			goto st18
		case 95:
			goto tr27
		case 109:
			goto tr220
		}
		switch {
		case lex.data[(lex.p)] < 65:
			if 48 <= lex.data[(lex.p)] && lex.data[(lex.p)] <= 57 {
				goto tr27
			}
		case lex.data[(lex.p)] > 90:
			if 97 <= lex.data[(lex.p)] && lex.data[(lex.p)] <= 122 {
				goto tr27
			}
		default:
			goto tr27
		}
		goto tr65
	tr220:
		lex.te = (lex.p) + 1

		lex.act = 25
		goto st174
	st174:
		if (lex.p)++; (lex.p) == (lex.pe) {
			goto _test_eof174
		}
	st_case_174:
		switch lex.data[(lex.p)] {
		case 9:
			goto st175
		case 10:
			goto tr223
		case 13:
			goto st175
		case 32:
			goto st175
		case 46:
			goto st18
		case 95:
			goto tr27
		}
		switch {
		case lex.data[(lex.p)] < 65:
			if 48 <= lex.data[(lex.p)] && lex.data[(lex.p)] <= 57 {
				goto tr27
			}
		case lex.data[(lex.p)] > 90:
			if 97 <= lex.data[(lex.p)] && lex.data[(lex.p)] <= 122 {
				goto tr27
			}
		default:
			goto tr27
		}
		goto tr221
	tr223:

		lex.line++
		lex.lineStart = lex.p + 1
		lex.linesSinceDocstring++

		goto st175
	st175:
		if (lex.p)++; (lex.p) == (lex.pe) {
			goto _test_eof175
		}
	st_case_175:
		switch lex.data[(lex.p)] {
		case 9:
			goto st175
		case 10:
			goto tr223
		case 13:
			goto st175
		case 32:
			goto st175
		}
		goto tr221
	tr201:
		lex.te = (lex.p) + 1

		lex.act = 41
		goto st176
	st176:
		if (lex.p)++; (lex.p) == (lex.pe) {
			goto _test_eof176
		}
	st_case_176:
		switch lex.data[(lex.p)] {
		case 46:
			goto st18
		case 95:
			goto tr27
		case 99:
			goto tr224
		case 101:
			goto tr198
		case 116:
			goto tr225
		}
		switch {
		case lex.data[(lex.p)] < 65:
			if 48 <= lex.data[(lex.p)] && lex.data[(lex.p)] <= 57 {
				goto tr27
			}
		case lex.data[(lex.p)] > 90:
			if 97 <= lex.data[(lex.p)] && lex.data[(lex.p)] <= 122 {
				goto tr27
			}
		default:
			goto tr27
		}
		goto tr65
	tr224:
		lex.te = (lex.p) + 1

		lex.act = 41
		goto st177
	st177:
		if (lex.p)++; (lex.p) == (lex.pe) {
			goto _test_eof177
		}
	st_case_177:
		switch lex.data[(lex.p)] {
		case 46:
			goto st18
		case 95:
			goto tr27
		case 101:
			goto tr226
		}
		switch {
		case lex.data[(lex.p)] < 65:
			if 48 <= lex.data[(lex.p)] && lex.data[(lex.p)] <= 57 {
				goto tr27
			}
		case lex.data[(lex.p)] > 90:
			if 97 <= lex.data[(lex.p)] && lex.data[(lex.p)] <= 122 {
				goto tr27
			}
		default:
			goto tr27
		}
		goto tr65
	tr226:
		lex.te = (lex.p) + 1

		lex.act = 41
		goto st178
	st178:
		if (lex.p)++; (lex.p) == (lex.pe) {
			goto _test_eof178
		}
	st_case_178:
		switch lex.data[(lex.p)] {
		case 46:
			goto st18
		case 95:
			goto tr27
		case 112:
			goto tr227
		}
		switch {
		case lex.data[(lex.p)] < 65:
			if 48 <= lex.data[(lex.p)] && lex.data[(lex.p)] <= 57 {
				goto tr27
			}
		case lex.data[(lex.p)] > 90:
			if 97 <= lex.data[(lex.p)] && lex.data[(lex.p)] <= 122 {
				goto tr27
			}
		default:
			goto tr27
		}
		goto tr65
	tr227:
		lex.te = (lex.p) + 1

		lex.act = 41
		goto st179
	st179:
		if (lex.p)++; (lex.p) == (lex.pe) {
			goto _test_eof179
		}
	st_case_179:
		switch lex.data[(lex.p)] {
		case 46:
			goto st18
		case 95:
			goto tr27
		case 116:
			goto tr228
		}
		switch {
		case lex.data[(lex.p)] < 65:
			if 48 <= lex.data[(lex.p)] && lex.data[(lex.p)] <= 57 {
				goto tr27
			}
		case lex.data[(lex.p)] > 90:
			if 97 <= lex.data[(lex.p)] && lex.data[(lex.p)] <= 122 {
				goto tr27
			}
		default:
			goto tr27
		}
		goto tr65
	tr228:
		lex.te = (lex.p) + 1

		reservedKeyword = string(lex.data[lex.ts:lex.te])
		lex.act = 40
		goto st180
	st180:
		if (lex.p)++; (lex.p) == (lex.pe) {
			goto _test_eof180
		}
	st_case_180:
		switch lex.data[(lex.p)] {
		case 9:
			goto st33
		case 10:
			goto tr73
		case 13:
			goto st33
		case 32:
			goto st33
		case 46:
			goto st18
		case 95:
			goto tr27
		case 105:
			goto tr229
		}
		switch {
		case lex.data[(lex.p)] < 65:
			if 48 <= lex.data[(lex.p)] && lex.data[(lex.p)] <= 57 {
				goto tr27
			}
		case lex.data[(lex.p)] > 90:
			if 97 <= lex.data[(lex.p)] && lex.data[(lex.p)] <= 122 {
				goto tr27
			}
		default:
			goto tr27
		}
		goto tr71
	tr229:
		lex.te = (lex.p) + 1

		lex.act = 41
		goto st181
	st181:
		if (lex.p)++; (lex.p) == (lex.pe) {
			goto _test_eof181
		}
	st_case_181:
		switch lex.data[(lex.p)] {
		case 46:
			goto st18
		case 95:
			goto tr27
		case 111:
			goto tr230
		}
		switch {
		case lex.data[(lex.p)] < 65:
			if 48 <= lex.data[(lex.p)] && lex.data[(lex.p)] <= 57 {
				goto tr27
			}
		case lex.data[(lex.p)] > 90:
			if 97 <= lex.data[(lex.p)] && lex.data[(lex.p)] <= 122 {
				goto tr27
			}
		default:
			goto tr27
		}
		goto tr65
	tr230:
		lex.te = (lex.p) + 1

		lex.act = 41
		goto st182
	st182:
		if (lex.p)++; (lex.p) == (lex.pe) {
			goto _test_eof182
		}
	st_case_182:
		switch lex.data[(lex.p)] {
		case 46:
			goto st18
		case 95:
			goto tr27
		case 110:
			goto tr231
		}
		switch {
		case lex.data[(lex.p)] < 65:
			if 48 <= lex.data[(lex.p)] && lex.data[(lex.p)] <= 57 {
				goto tr27
			}
		case lex.data[(lex.p)] > 90:
			if 97 <= lex.data[(lex.p)] && lex.data[(lex.p)] <= 122 {
				goto tr27
			}
		default:
			goto tr27
		}
		goto tr65
	tr231:
		lex.te = (lex.p) + 1

		lex.act = 21
		goto st183
	st183:
		if (lex.p)++; (lex.p) == (lex.pe) {
			goto _test_eof183
		}
	st_case_183:
		switch lex.data[(lex.p)] {
		case 9:
			goto st184
		case 10:
			goto tr234
		case 13:
			goto st184
		case 32:
			goto st184
		case 46:
			goto st18
		case 95:
			goto tr27
		}
		switch {
		case lex.data[(lex.p)] < 65:
			if 48 <= lex.data[(lex.p)] && lex.data[(lex.p)] <= 57 {
				goto tr27
			}
		case lex.data[(lex.p)] > 90:
			if 97 <= lex.data[(lex.p)] && lex.data[(lex.p)] <= 122 {
				goto tr27
			}
		default:
			goto tr27
		}
		goto tr232
	tr234:

		lex.line++
		lex.lineStart = lex.p + 1
		lex.linesSinceDocstring++

		goto st184
	st184:
		if (lex.p)++; (lex.p) == (lex.pe) {
			goto _test_eof184
		}
	st_case_184:
		switch lex.data[(lex.p)] {
		case 9:
			goto st184
		case 10:
			goto tr234
		case 13:
			goto st184
		case 32:
			goto st184
		}
		goto tr232
	tr225:
		lex.te = (lex.p) + 1

		lex.act = 41
		goto st185
	st185:
		if (lex.p)++; (lex.p) == (lex.pe) {
			goto _test_eof185
		}
	st_case_185:
		switch lex.data[(lex.p)] {
		case 46:
			goto st18
		case 95:
			goto tr27
		case 101:
			goto tr235
		}
		switch {
		case lex.data[(lex.p)] < 65:
			if 48 <= lex.data[(lex.p)] && lex.data[(lex.p)] <= 57 {
				goto tr27
			}
		case lex.data[(lex.p)] > 90:
			if 97 <= lex.data[(lex.p)] && lex.data[(lex.p)] <= 122 {
				goto tr27
			}
		default:
			goto tr27
		}
		goto tr65
	tr235:
		lex.te = (lex.p) + 1

		lex.act = 41
		goto st186
	st186:
		if (lex.p)++; (lex.p) == (lex.pe) {
			goto _test_eof186
		}
	st_case_186:
		switch lex.data[(lex.p)] {
		case 46:
			goto st18
		case 95:
			goto tr27
		case 110:
			goto tr236
		}
		switch {
		case lex.data[(lex.p)] < 65:
			if 48 <= lex.data[(lex.p)] && lex.data[(lex.p)] <= 57 {
				goto tr27
			}
		case lex.data[(lex.p)] > 90:
			if 97 <= lex.data[(lex.p)] && lex.data[(lex.p)] <= 122 {
				goto tr27
			}
		default:
			goto tr27
		}
		goto tr65
	tr236:
		lex.te = (lex.p) + 1

		lex.act = 41
		goto st187
	st187:
		if (lex.p)++; (lex.p) == (lex.pe) {
			goto _test_eof187
		}
	st_case_187:
		switch lex.data[(lex.p)] {
		case 46:
			goto st18
		case 95:
			goto tr27
		case 100:
			goto tr237
		}
		switch {
		case lex.data[(lex.p)] < 65:
			if 48 <= lex.data[(lex.p)] && lex.data[(lex.p)] <= 57 {
				goto tr27
			}
		case lex.data[(lex.p)] > 90:
			if 97 <= lex.data[(lex.p)] && lex.data[(lex.p)] <= 122 {
				goto tr27
			}
		default:
			goto tr27
		}
		goto tr65
	tr237:
		lex.te = (lex.p) + 1

		lex.act = 41
		goto st188
	st188:
		if (lex.p)++; (lex.p) == (lex.pe) {
			goto _test_eof188
		}
	st_case_188:
		switch lex.data[(lex.p)] {
		case 46:
			goto st18
		case 95:
			goto tr27
		case 115:
			goto tr238
		}
		switch {
		case lex.data[(lex.p)] < 65:
			if 48 <= lex.data[(lex.p)] && lex.data[(lex.p)] <= 57 {
				goto tr27
			}
		case lex.data[(lex.p)] > 90:
			if 97 <= lex.data[(lex.p)] && lex.data[(lex.p)] <= 122 {
				goto tr27
			}
		default:
			goto tr27
		}
		goto tr65
	tr238:
		lex.te = (lex.p) + 1

		lex.act = 22
		goto st189
	st189:
		if (lex.p)++; (lex.p) == (lex.pe) {
			goto _test_eof189
		}
	st_case_189:
		switch lex.data[(lex.p)] {
		case 9:
			goto st190
		case 10:
			goto tr241
		case 13:
			goto st190
		case 32:
			goto st190
		case 46:
			goto st18
		case 95:
			goto tr27
		}
		switch {
		case lex.data[(lex.p)] < 65:
			if 48 <= lex.data[(lex.p)] && lex.data[(lex.p)] <= 57 {
				goto tr27
			}
		case lex.data[(lex.p)] > 90:
			if 97 <= lex.data[(lex.p)] && lex.data[(lex.p)] <= 122 {
				goto tr27
			}
		default:
			goto tr27
		}
		goto tr239
	tr241:

		lex.line++
		lex.lineStart = lex.p + 1
		lex.linesSinceDocstring++

		goto st190
	st190:
		if (lex.p)++; (lex.p) == (lex.pe) {
			goto _test_eof190
		}
	st_case_190:
		switch lex.data[(lex.p)] {
		case 9:
			goto st190
		case 10:
			goto tr241
		case 13:
			goto st190
		case 32:
			goto st190
		}
		goto tr239
	tr42:
		lex.te = (lex.p) + 1

		lex.act = 41
		goto st191
	st191:
		if (lex.p)++; (lex.p) == (lex.pe) {
			goto _test_eof191
		}
	st_case_191:
		switch lex.data[(lex.p)] {
		case 46:
			goto st18
		case 95:
			goto tr27
		case 97:
			goto tr242
		case 105:
			goto tr243
		case 108:
			goto tr244
		case 111:
			goto tr213
		case 114:
			goto tr245
		case 117:
			goto tr246
		}
		switch {
		case lex.data[(lex.p)] < 65:
			if 48 <= lex.data[(lex.p)] && lex.data[(lex.p)] <= 57 {
				goto tr27
			}
		case lex.data[(lex.p)] > 90:
			if 98 <= lex.data[(lex.p)] && lex.data[(lex.p)] <= 122 {
				goto tr27
			}
		default:
			goto tr27
		}
		goto tr65
	tr242:
		lex.te = (lex.p) + 1

		lex.act = 41
		goto st192
	st192:
		if (lex.p)++; (lex.p) == (lex.pe) {
			goto _test_eof192
		}
	st_case_192:
		switch lex.data[(lex.p)] {
		case 46:
			goto st18
		case 95:
			goto tr27
		case 108:
			goto tr247
		}
		switch {
		case lex.data[(lex.p)] < 65:
			if 48 <= lex.data[(lex.p)] && lex.data[(lex.p)] <= 57 {
				goto tr27
			}
		case lex.data[(lex.p)] > 90:
			if 97 <= lex.data[(lex.p)] && lex.data[(lex.p)] <= 122 {
				goto tr27
			}
		default:
			goto tr27
		}
		goto tr65
	tr247:
		lex.te = (lex.p) + 1

		lex.act = 41
		goto st193
	st193:
		if (lex.p)++; (lex.p) == (lex.pe) {
			goto _test_eof193
		}
	st_case_193:
		switch lex.data[(lex.p)] {
		case 46:
			goto st18
		case 95:
			goto tr27
		case 115:
			goto tr248
		}
		switch {
		case lex.data[(lex.p)] < 65:
			if 48 <= lex.data[(lex.p)] && lex.data[(lex.p)] <= 57 {
				goto tr27
			}
		case lex.data[(lex.p)] > 90:
			if 97 <= lex.data[(lex.p)] && lex.data[(lex.p)] <= 122 {
				goto tr27
			}
		default:
			goto tr27
		}
		goto tr65
	tr248:
		lex.te = (lex.p) + 1

		lex.act = 41
		goto st194
	st194:
		if (lex.p)++; (lex.p) == (lex.pe) {
			goto _test_eof194
		}
	st_case_194:
		switch lex.data[(lex.p)] {
		case 46:
			goto st18
		case 95:
			goto tr27
		case 101:
			goto tr249
		}
		switch {
		case lex.data[(lex.p)] < 65:
			if 48 <= lex.data[(lex.p)] && lex.data[(lex.p)] <= 57 {
				goto tr27
			}
		case lex.data[(lex.p)] > 90:
			if 97 <= lex.data[(lex.p)] && lex.data[(lex.p)] <= 122 {
				goto tr27
			}
		default:
			goto tr27
		}
		goto tr65
	tr249:
		lex.te = (lex.p) + 1

		lex.act = 30
		goto st195
	st195:
		if (lex.p)++; (lex.p) == (lex.pe) {
			goto _test_eof195
		}
	st_case_195:
		switch lex.data[(lex.p)] {
		case 9:
			goto st196
		case 10:
			goto tr252
		case 13:
			goto st196
		case 32:
			goto st196
		case 46:
			goto st18
		case 95:
			goto tr27
		}
		switch {
		case lex.data[(lex.p)] < 65:
			if 48 <= lex.data[(lex.p)] && lex.data[(lex.p)] <= 57 {
				goto tr27
			}
		case lex.data[(lex.p)] > 90:
			if 97 <= lex.data[(lex.p)] && lex.data[(lex.p)] <= 122 {
				goto tr27
			}
		default:
			goto tr27
		}
		goto tr250
	tr252:

		lex.line++
		lex.lineStart = lex.p + 1
		lex.linesSinceDocstring++

		goto st196
	st196:
		if (lex.p)++; (lex.p) == (lex.pe) {
			goto _test_eof196
		}
	st_case_196:
		switch lex.data[(lex.p)] {
		case 9:
			goto st196
		case 10:
			goto tr252
		case 13:
			goto st196
		case 32:
			goto st196
		}
		goto tr250
	tr243:
		lex.te = (lex.p) + 1

		lex.act = 41
		goto st197
	st197:
		if (lex.p)++; (lex.p) == (lex.pe) {
			goto _test_eof197
		}
	st_case_197:
		switch lex.data[(lex.p)] {
		case 46:
			goto st18
		case 95:
			goto tr27
		case 110:
			goto tr253
		}
		switch {
		case lex.data[(lex.p)] < 65:
			if 48 <= lex.data[(lex.p)] && lex.data[(lex.p)] <= 57 {
				goto tr27
			}
		case lex.data[(lex.p)] > 90:
			if 97 <= lex.data[(lex.p)] && lex.data[(lex.p)] <= 122 {
				goto tr27
			}
		default:
			goto tr27
		}
		goto tr65
	tr253:
		lex.te = (lex.p) + 1

		lex.act = 41
		goto st198
	st198:
		if (lex.p)++; (lex.p) == (lex.pe) {
			goto _test_eof198
		}
	st_case_198:
		switch lex.data[(lex.p)] {
		case 46:
			goto st18
		case 95:
			goto tr27
		case 97:
			goto tr254
		}
		switch {
		case lex.data[(lex.p)] < 65:
			if 48 <= lex.data[(lex.p)] && lex.data[(lex.p)] <= 57 {
				goto tr27
			}
		case lex.data[(lex.p)] > 90:
			if 98 <= lex.data[(lex.p)] && lex.data[(lex.p)] <= 122 {
				goto tr27
			}
		default:
			goto tr27
		}
		goto tr65
	tr254:
		lex.te = (lex.p) + 1

		lex.act = 41
		goto st199
	st199:
		if (lex.p)++; (lex.p) == (lex.pe) {
			goto _test_eof199
		}
	st_case_199:
		switch lex.data[(lex.p)] {
		case 46:
			goto st18
		case 95:
			goto tr27
		case 108:
			goto tr255
		}
		switch {
		case lex.data[(lex.p)] < 65:
			if 48 <= lex.data[(lex.p)] && lex.data[(lex.p)] <= 57 {
				goto tr27
			}
		case lex.data[(lex.p)] > 90:
			if 97 <= lex.data[(lex.p)] && lex.data[(lex.p)] <= 122 {
				goto tr27
			}
		default:
			goto tr27
		}
		goto tr65
	tr255:
		lex.te = (lex.p) + 1

		lex.act = 41
		goto st200
	st200:
		if (lex.p)++; (lex.p) == (lex.pe) {
			goto _test_eof200
		}
	st_case_200:
		switch lex.data[(lex.p)] {
		case 46:
			goto st18
		case 95:
			goto tr27
		case 108:
			goto tr256
		}
		switch {
		case lex.data[(lex.p)] < 65:
			if 48 <= lex.data[(lex.p)] && lex.data[(lex.p)] <= 57 {
				goto tr27
			}
		case lex.data[(lex.p)] > 90:
			if 97 <= lex.data[(lex.p)] && lex.data[(lex.p)] <= 122 {
				goto tr27
			}
		default:
			goto tr27
		}
		goto tr65
	tr256:
		lex.te = (lex.p) + 1

		lex.act = 41
		goto st201
	st201:
		if (lex.p)++; (lex.p) == (lex.pe) {
			goto _test_eof201
		}
	st_case_201:
		switch lex.data[(lex.p)] {
		case 46:
			goto st18
		case 95:
			goto tr27
		case 121:
			goto tr70
		}
		switch {
		case lex.data[(lex.p)] < 65:
			if 48 <= lex.data[(lex.p)] && lex.data[(lex.p)] <= 57 {
				goto tr27
			}
		case lex.data[(lex.p)] > 90:
			if 97 <= lex.data[(lex.p)] && lex.data[(lex.p)] <= 122 {
				goto tr27
			}
		default:
			goto tr27
		}
		goto tr65
	tr244:
		lex.te = (lex.p) + 1

		lex.act = 41
		goto st202
	st202:
		if (lex.p)++; (lex.p) == (lex.pe) {
			goto _test_eof202
		}
	st_case_202:
		switch lex.data[(lex.p)] {
		case 46:
			goto st18
		case 95:
			goto tr27
		case 111:
			goto tr257
		}
		switch {
		case lex.data[(lex.p)] < 65:
			if 48 <= lex.data[(lex.p)] && lex.data[(lex.p)] <= 57 {
				goto tr27
			}
		case lex.data[(lex.p)] > 90:
			if 97 <= lex.data[(lex.p)] && lex.data[(lex.p)] <= 122 {
				goto tr27
			}
		default:
			goto tr27
		}
		goto tr65
	tr257:
		lex.te = (lex.p) + 1

		lex.act = 41
		goto st203
	st203:
		if (lex.p)++; (lex.p) == (lex.pe) {
			goto _test_eof203
		}
	st_case_203:
		switch lex.data[(lex.p)] {
		case 46:
			goto st18
		case 95:
			goto tr27
		case 97:
			goto tr116
		}
		switch {
		case lex.data[(lex.p)] < 65:
			if 48 <= lex.data[(lex.p)] && lex.data[(lex.p)] <= 57 {
				goto tr27
			}
		case lex.data[(lex.p)] > 90:
			if 98 <= lex.data[(lex.p)] && lex.data[(lex.p)] <= 122 {
				goto tr27
			}
		default:
			goto tr27
		}
		goto tr65
	tr245:
		lex.te = (lex.p) + 1

		lex.act = 41
		goto st204
	st204:
		if (lex.p)++; (lex.p) == (lex.pe) {
			goto _test_eof204
		}
	st_case_204:
		switch lex.data[(lex.p)] {
		case 46:
			goto st18
		case 95:
			goto tr27
		case 111:
			goto tr258
		}
		switch {
		case lex.data[(lex.p)] < 65:
			if 48 <= lex.data[(lex.p)] && lex.data[(lex.p)] <= 57 {
				goto tr27
			}
		case lex.data[(lex.p)] > 90:
			if 97 <= lex.data[(lex.p)] && lex.data[(lex.p)] <= 122 {
				goto tr27
			}
		default:
			goto tr27
		}
		goto tr65
	tr258:
		lex.te = (lex.p) + 1

		lex.act = 41
		goto st205
	st205:
		if (lex.p)++; (lex.p) == (lex.pe) {
			goto _test_eof205
		}
	st_case_205:
		switch lex.data[(lex.p)] {
		case 46:
			goto st18
		case 95:
			goto tr27
		case 109:
			goto tr70
		}
		switch {
		case lex.data[(lex.p)] < 65:
			if 48 <= lex.data[(lex.p)] && lex.data[(lex.p)] <= 57 {
				goto tr27
			}
		case lex.data[(lex.p)] > 90:
			if 97 <= lex.data[(lex.p)] && lex.data[(lex.p)] <= 122 {
				goto tr27
			}
		default:
			goto tr27
		}
		goto tr65
	tr246:
		lex.te = (lex.p) + 1

		lex.act = 41
		goto st206
	st206:
		if (lex.p)++; (lex.p) == (lex.pe) {
			goto _test_eof206
		}
	st_case_206:
		switch lex.data[(lex.p)] {
		case 46:
			goto st18
		case 95:
			goto tr27
		case 110:
			goto tr259
		}
		switch {
		case lex.data[(lex.p)] < 65:
			if 48 <= lex.data[(lex.p)] && lex.data[(lex.p)] <= 57 {
				goto tr27
			}
		case lex.data[(lex.p)] > 90:
			if 97 <= lex.data[(lex.p)] && lex.data[(lex.p)] <= 122 {
				goto tr27
			}
		default:
			goto tr27
		}
		goto tr65
	tr259:
		lex.te = (lex.p) + 1

		lex.act = 41
		goto st207
	st207:
		if (lex.p)++; (lex.p) == (lex.pe) {
			goto _test_eof207
		}
	st_case_207:
		switch lex.data[(lex.p)] {
		case 46:
			goto st18
		case 95:
			goto tr27
		case 99:
			goto tr260
		}
		switch {
		case lex.data[(lex.p)] < 65:
			if 48 <= lex.data[(lex.p)] && lex.data[(lex.p)] <= 57 {
				goto tr27
			}
		case lex.data[(lex.p)] > 90:
			if 97 <= lex.data[(lex.p)] && lex.data[(lex.p)] <= 122 {
				goto tr27
			}
		default:
			goto tr27
		}
		goto tr65
	tr260:
		lex.te = (lex.p) + 1

		lex.act = 41
		goto st208
	st208:
		if (lex.p)++; (lex.p) == (lex.pe) {
			goto _test_eof208
		}
	st_case_208:
		switch lex.data[(lex.p)] {
		case 46:
			goto st18
		case 95:
			goto tr27
		case 116:
			goto tr261
		}
		switch {
		case lex.data[(lex.p)] < 65:
			if 48 <= lex.data[(lex.p)] && lex.data[(lex.p)] <= 57 {
				goto tr27
			}
		case lex.data[(lex.p)] > 90:
			if 97 <= lex.data[(lex.p)] && lex.data[(lex.p)] <= 122 {
				goto tr27
			}
		default:
			goto tr27
		}
		goto tr65
	tr261:
		lex.te = (lex.p) + 1

		lex.act = 41
		goto st209
	st209:
		if (lex.p)++; (lex.p) == (lex.pe) {
			goto _test_eof209
		}
	st_case_209:
		switch lex.data[(lex.p)] {
		case 46:
			goto st18
		case 95:
			goto tr27
		case 105:
			goto tr262
		}
		switch {
		case lex.data[(lex.p)] < 65:
			if 48 <= lex.data[(lex.p)] && lex.data[(lex.p)] <= 57 {
				goto tr27
			}
		case lex.data[(lex.p)] > 90:
			if 97 <= lex.data[(lex.p)] && lex.data[(lex.p)] <= 122 {
				goto tr27
			}
		default:
			goto tr27
		}
		goto tr65
	tr262:
		lex.te = (lex.p) + 1

		lex.act = 41
		goto st210
	st210:
		if (lex.p)++; (lex.p) == (lex.pe) {
			goto _test_eof210
		}
	st_case_210:
		switch lex.data[(lex.p)] {
		case 46:
			goto st18
		case 95:
			goto tr27
		case 111:
			goto tr127
		}
		switch {
		case lex.data[(lex.p)] < 65:
			if 48 <= lex.data[(lex.p)] && lex.data[(lex.p)] <= 57 {
				goto tr27
			}
		case lex.data[(lex.p)] > 90:
			if 97 <= lex.data[(lex.p)] && lex.data[(lex.p)] <= 122 {
				goto tr27
			}
		default:
			goto tr27
		}
		goto tr65
	tr43:
		lex.te = (lex.p) + 1

		lex.act = 41
		goto st211
	st211:
		if (lex.p)++; (lex.p) == (lex.pe) {
			goto _test_eof211
		}
	st_case_211:
		switch lex.data[(lex.p)] {
		case 46:
			goto st18
		case 95:
			goto tr27
		case 108:
			goto tr263
		case 111:
			goto tr264
		}
		switch {
		case lex.data[(lex.p)] < 65:
			if 48 <= lex.data[(lex.p)] && lex.data[(lex.p)] <= 57 {
				goto tr27
			}
		case lex.data[(lex.p)] > 90:
			if 97 <= lex.data[(lex.p)] && lex.data[(lex.p)] <= 122 {
				goto tr27
			}
		default:
			goto tr27
		}
		goto tr65
	tr263:
		lex.te = (lex.p) + 1

		lex.act = 41
		goto st212
	st212:
		if (lex.p)++; (lex.p) == (lex.pe) {
			goto _test_eof212
		}
	st_case_212:
		switch lex.data[(lex.p)] {
		case 46:
			goto st18
		case 95:
			goto tr27
		case 111:
			goto tr265
		}
		switch {
		case lex.data[(lex.p)] < 65:
			if 48 <= lex.data[(lex.p)] && lex.data[(lex.p)] <= 57 {
				goto tr27
			}
		case lex.data[(lex.p)] > 90:
			if 97 <= lex.data[(lex.p)] && lex.data[(lex.p)] <= 122 {
				goto tr27
			}
		default:
			goto tr27
		}
		goto tr65
	tr265:
		lex.te = (lex.p) + 1

		lex.act = 41
		goto st213
	st213:
		if (lex.p)++; (lex.p) == (lex.pe) {
			goto _test_eof213
		}
	st_case_213:
		switch lex.data[(lex.p)] {
		case 46:
			goto st18
		case 95:
			goto tr27
		case 98:
			goto tr266
		}
		switch {
		case lex.data[(lex.p)] < 65:
			if 48 <= lex.data[(lex.p)] && lex.data[(lex.p)] <= 57 {
				goto tr27
			}
		case lex.data[(lex.p)] > 90:
			if 97 <= lex.data[(lex.p)] && lex.data[(lex.p)] <= 122 {
				goto tr27
			}
		default:
			goto tr27
		}
		goto tr65
	tr266:
		lex.te = (lex.p) + 1

		lex.act = 41
		goto st214
	st214:
		if (lex.p)++; (lex.p) == (lex.pe) {
			goto _test_eof214
		}
	st_case_214:
		switch lex.data[(lex.p)] {
		case 46:
			goto st18
		case 95:
			goto tr27
		case 97:
			goto tr267
		}
		switch {
		case lex.data[(lex.p)] < 65:
			if 48 <= lex.data[(lex.p)] && lex.data[(lex.p)] <= 57 {
				goto tr27
			}
		case lex.data[(lex.p)] > 90:
			if 98 <= lex.data[(lex.p)] && lex.data[(lex.p)] <= 122 {
				goto tr27
			}
		default:
			goto tr27
		}
		goto tr65
	tr267:
		lex.te = (lex.p) + 1

		lex.act = 41
		goto st215
	st215:
		if (lex.p)++; (lex.p) == (lex.pe) {
			goto _test_eof215
		}
	st_case_215:
		switch lex.data[(lex.p)] {
		case 46:
			goto st18
		case 95:
			goto tr27
		case 108:
			goto tr70
		}
		switch {
		case lex.data[(lex.p)] < 65:
			if 48 <= lex.data[(lex.p)] && lex.data[(lex.p)] <= 57 {
				goto tr27
			}
		case lex.data[(lex.p)] > 90:
			if 97 <= lex.data[(lex.p)] && lex.data[(lex.p)] <= 122 {
				goto tr27
			}
		default:
			goto tr27
		}
		goto tr65
	tr264:
		lex.te = (lex.p) + 1

		lex.act = 41
		goto st216
	st216:
		if (lex.p)++; (lex.p) == (lex.pe) {
			goto _test_eof216
		}
	st_case_216:
		switch lex.data[(lex.p)] {
		case 46:
			goto st18
		case 95:
			goto tr27
		case 116:
			goto tr268
		}
		switch {
		case lex.data[(lex.p)] < 65:
			if 48 <= lex.data[(lex.p)] && lex.data[(lex.p)] <= 57 {
				goto tr27
			}
		case lex.data[(lex.p)] > 90:
			if 97 <= lex.data[(lex.p)] && lex.data[(lex.p)] <= 122 {
				goto tr27
			}
		default:
			goto tr27
		}
		goto tr65
	tr268:
		lex.te = (lex.p) + 1

		lex.act = 41
		goto st217
	st217:
		if (lex.p)++; (lex.p) == (lex.pe) {
			goto _test_eof217
		}
	st_case_217:
		switch lex.data[(lex.p)] {
		case 46:
			goto st18
		case 95:
			goto tr27
		case 111:
			goto tr70
		}
		switch {
		case lex.data[(lex.p)] < 65:
			if 48 <= lex.data[(lex.p)] && lex.data[(lex.p)] <= 57 {
				goto tr27
			}
		case lex.data[(lex.p)] > 90:
			if 97 <= lex.data[(lex.p)] && lex.data[(lex.p)] <= 122 {
				goto tr27
			}
		default:
			goto tr27
		}
		goto tr65
	tr44:
		lex.te = (lex.p) + 1

		lex.act = 41
		goto st218
	st218:
		if (lex.p)++; (lex.p) == (lex.pe) {
			goto _test_eof218
		}
	st_case_218:
		switch lex.data[(lex.p)] {
		case 46:
			goto st18
		case 49:
			goto tr269
		case 51:
			goto tr270
		case 54:
			goto tr271
		case 56:
			goto tr272
		case 95:
			goto tr27
		case 102:
			goto tr70
		case 109:
			goto tr273
		case 110:
			goto tr274
		case 115:
			goto tr70
		}
		switch {
		case lex.data[(lex.p)] < 65:
			if 48 <= lex.data[(lex.p)] && lex.data[(lex.p)] <= 57 {
				goto tr27
			}
		case lex.data[(lex.p)] > 90:
			if 97 <= lex.data[(lex.p)] && lex.data[(lex.p)] <= 122 {
				goto tr27
			}
		default:
			goto tr27
		}
		goto tr65
	tr269:
		lex.te = (lex.p) + 1

		lex.act = 41
		goto st219
	st219:
		if (lex.p)++; (lex.p) == (lex.pe) {
			goto _test_eof219
		}
	st_case_219:
		switch lex.data[(lex.p)] {
		case 46:
			goto st18
		case 54:
			goto tr275
		case 95:
			goto tr27
		}
		switch {
		case lex.data[(lex.p)] < 65:
			if 48 <= lex.data[(lex.p)] && lex.data[(lex.p)] <= 57 {
				goto tr27
			}
		case lex.data[(lex.p)] > 90:
			if 97 <= lex.data[(lex.p)] && lex.data[(lex.p)] <= 122 {
				goto tr27
			}
		default:
			goto tr27
		}
		goto tr65
	tr275:
		lex.te = (lex.p) + 1

		lex.act = 8
		goto st220
	st220:
		if (lex.p)++; (lex.p) == (lex.pe) {
			goto _test_eof220
		}
	st_case_220:
		switch lex.data[(lex.p)] {
		case 9:
			goto st221
		case 10:
			goto tr278
		case 13:
			goto st221
		case 32:
			goto st221
		case 46:
			goto st18
		case 95:
			goto tr27
		}
		switch {
		case lex.data[(lex.p)] < 65:
			if 48 <= lex.data[(lex.p)] && lex.data[(lex.p)] <= 57 {
				goto tr27
			}
		case lex.data[(lex.p)] > 90:
			if 97 <= lex.data[(lex.p)] && lex.data[(lex.p)] <= 122 {
				goto tr27
			}
		default:
			goto tr27
		}
		goto tr276
	tr278:

		lex.line++
		lex.lineStart = lex.p + 1
		lex.linesSinceDocstring++

		goto st221
	st221:
		if (lex.p)++; (lex.p) == (lex.pe) {
			goto _test_eof221
		}
	st_case_221:
		switch lex.data[(lex.p)] {
		case 9:
			goto st221
		case 10:
			goto tr278
		case 13:
			goto st221
		case 32:
			goto st221
		}
		goto tr276
	tr270:
		lex.te = (lex.p) + 1

		lex.act = 41
		goto st222
	st222:
		if (lex.p)++; (lex.p) == (lex.pe) {
			goto _test_eof222
		}
	st_case_222:
		switch lex.data[(lex.p)] {
		case 46:
			goto st18
		case 50:
			goto tr279
		case 95:
			goto tr27
		}
		switch {
		case lex.data[(lex.p)] < 65:
			if 48 <= lex.data[(lex.p)] && lex.data[(lex.p)] <= 57 {
				goto tr27
			}
		case lex.data[(lex.p)] > 90:
			if 97 <= lex.data[(lex.p)] && lex.data[(lex.p)] <= 122 {
				goto tr27
			}
		default:
			goto tr27
		}
		goto tr65
	tr279:
		lex.te = (lex.p) + 1

		lex.act = 9
		goto st223
	st223:
		if (lex.p)++; (lex.p) == (lex.pe) {
			goto _test_eof223
		}
	st_case_223:
		switch lex.data[(lex.p)] {
		case 9:
			goto st224
		case 10:
			goto tr282
		case 13:
			goto st224
		case 32:
			goto st224
		case 46:
			goto st18
		case 95:
			goto tr27
		}
		switch {
		case lex.data[(lex.p)] < 65:
			if 48 <= lex.data[(lex.p)] && lex.data[(lex.p)] <= 57 {
				goto tr27
			}
		case lex.data[(lex.p)] > 90:
			if 97 <= lex.data[(lex.p)] && lex.data[(lex.p)] <= 122 {
				goto tr27
			}
		default:
			goto tr27
		}
		goto tr280
	tr282:

		lex.line++
		lex.lineStart = lex.p + 1
		lex.linesSinceDocstring++

		goto st224
	st224:
		if (lex.p)++; (lex.p) == (lex.pe) {
			goto _test_eof224
		}
	st_case_224:
		switch lex.data[(lex.p)] {
		case 9:
			goto st224
		case 10:
			goto tr282
		case 13:
			goto st224
		case 32:
			goto st224
		}
		goto tr280
	tr271:
		lex.te = (lex.p) + 1

		lex.act = 41
		goto st225
	st225:
		if (lex.p)++; (lex.p) == (lex.pe) {
			goto _test_eof225
		}
	st_case_225:
		switch lex.data[(lex.p)] {
		case 46:
			goto st18
		case 52:
			goto tr283
		case 95:
			goto tr27
		}
		switch {
		case lex.data[(lex.p)] < 65:
			if 48 <= lex.data[(lex.p)] && lex.data[(lex.p)] <= 57 {
				goto tr27
			}
		case lex.data[(lex.p)] > 90:
			if 97 <= lex.data[(lex.p)] && lex.data[(lex.p)] <= 122 {
				goto tr27
			}
		default:
			goto tr27
		}
		goto tr65
	tr283:
		lex.te = (lex.p) + 1

		lex.act = 10
		goto st226
	st226:
		if (lex.p)++; (lex.p) == (lex.pe) {
			goto _test_eof226
		}
	st_case_226:
		switch lex.data[(lex.p)] {
		case 9:
			goto st227
		case 10:
			goto tr286
		case 13:
			goto st227
		case 32:
			goto st227
		case 46:
			goto st18
		case 95:
			goto tr27
		}
		switch {
		case lex.data[(lex.p)] < 65:
			if 48 <= lex.data[(lex.p)] && lex.data[(lex.p)] <= 57 {
				goto tr27
			}
		case lex.data[(lex.p)] > 90:
			if 97 <= lex.data[(lex.p)] && lex.data[(lex.p)] <= 122 {
				goto tr27
			}
		default:
			goto tr27
		}
		goto tr284
	tr286:

		lex.line++
		lex.lineStart = lex.p + 1
		lex.linesSinceDocstring++

		goto st227
	st227:
		if (lex.p)++; (lex.p) == (lex.pe) {
			goto _test_eof227
		}
	st_case_227:
		switch lex.data[(lex.p)] {
		case 9:
			goto st227
		case 10:
			goto tr286
		case 13:
			goto st227
		case 32:
			goto st227
		}
		goto tr284
	tr272:
		lex.te = (lex.p) + 1

		lex.act = 7
		goto st228
	st228:
		if (lex.p)++; (lex.p) == (lex.pe) {
			goto _test_eof228
		}
	st_case_228:
		switch lex.data[(lex.p)] {
		case 9:
			goto st229
		case 10:
			goto tr289
		case 13:
			goto st229
		case 32:
			goto st229
		case 46:
			goto st18
		case 95:
			goto tr27
		}
		switch {
		case lex.data[(lex.p)] < 65:
			if 48 <= lex.data[(lex.p)] && lex.data[(lex.p)] <= 57 {
				goto tr27
			}
		case lex.data[(lex.p)] > 90:
			if 97 <= lex.data[(lex.p)] && lex.data[(lex.p)] <= 122 {
				goto tr27
			}
		default:
			goto tr27
		}
		goto tr287
	tr289:

		lex.line++
		lex.lineStart = lex.p + 1
		lex.linesSinceDocstring++

		goto st229
	st229:
		if (lex.p)++; (lex.p) == (lex.pe) {
			goto _test_eof229
		}
	st_case_229:
		switch lex.data[(lex.p)] {
		case 9:
			goto st229
		case 10:
			goto tr289
		case 13:
			goto st229
		case 32:
			goto st229
		}
		goto tr287
	tr273:
		lex.te = (lex.p) + 1

		lex.act = 41
		goto st230
	st230:
		if (lex.p)++; (lex.p) == (lex.pe) {
			goto _test_eof230
		}
	st_case_230:
		switch lex.data[(lex.p)] {
		case 46:
			goto st18
		case 95:
			goto tr27
		case 112:
			goto tr290
		}
		switch {
		case lex.data[(lex.p)] < 65:
			if 48 <= lex.data[(lex.p)] && lex.data[(lex.p)] <= 57 {
				goto tr27
			}
		case lex.data[(lex.p)] > 90:
			if 97 <= lex.data[(lex.p)] && lex.data[(lex.p)] <= 122 {
				goto tr27
			}
		default:
			goto tr27
		}
		goto tr65
	tr290:
		lex.te = (lex.p) + 1

		lex.act = 41
		goto st231
	st231:
		if (lex.p)++; (lex.p) == (lex.pe) {
			goto _test_eof231
		}
	st_case_231:
		switch lex.data[(lex.p)] {
		case 46:
			goto st18
		case 95:
			goto tr27
		case 108:
			goto tr291
		case 111:
			goto tr120
		}
		switch {
		case lex.data[(lex.p)] < 65:
			if 48 <= lex.data[(lex.p)] && lex.data[(lex.p)] <= 57 {
				goto tr27
			}
		case lex.data[(lex.p)] > 90:
			if 97 <= lex.data[(lex.p)] && lex.data[(lex.p)] <= 122 {
				goto tr27
			}
		default:
			goto tr27
		}
		goto tr65
	tr291:
		lex.te = (lex.p) + 1

		lex.act = 41
		goto st232
	st232:
		if (lex.p)++; (lex.p) == (lex.pe) {
			goto _test_eof232
		}
	st_case_232:
		switch lex.data[(lex.p)] {
		case 46:
			goto st18
		case 95:
			goto tr27
		case 101:
			goto tr292
		}
		switch {
		case lex.data[(lex.p)] < 65:
			if 48 <= lex.data[(lex.p)] && lex.data[(lex.p)] <= 57 {
				goto tr27
			}
		case lex.data[(lex.p)] > 90:
			if 97 <= lex.data[(lex.p)] && lex.data[(lex.p)] <= 122 {
				goto tr27
			}
		default:
			goto tr27
		}
		goto tr65
	tr292:
		lex.te = (lex.p) + 1

		lex.act = 41
		goto st233
	st233:
		if (lex.p)++; (lex.p) == (lex.pe) {
			goto _test_eof233
		}
	st_case_233:
		switch lex.data[(lex.p)] {
		case 46:
			goto st18
		case 95:
			goto tr27
		case 109:
			goto tr293
		}
		switch {
		case lex.data[(lex.p)] < 65:
			if 48 <= lex.data[(lex.p)] && lex.data[(lex.p)] <= 57 {
				goto tr27
			}
		case lex.data[(lex.p)] > 90:
			if 97 <= lex.data[(lex.p)] && lex.data[(lex.p)] <= 122 {
				goto tr27
			}
		default:
			goto tr27
		}
		goto tr65
	tr293:
		lex.te = (lex.p) + 1

		lex.act = 41
		goto st234
	st234:
		if (lex.p)++; (lex.p) == (lex.pe) {
			goto _test_eof234
		}
	st_case_234:
		switch lex.data[(lex.p)] {
		case 46:
			goto st18
		case 95:
			goto tr27
		case 101:
			goto tr294
		}
		switch {
		case lex.data[(lex.p)] < 65:
			if 48 <= lex.data[(lex.p)] && lex.data[(lex.p)] <= 57 {
				goto tr27
			}
		case lex.data[(lex.p)] > 90:
			if 97 <= lex.data[(lex.p)] && lex.data[(lex.p)] <= 122 {
				goto tr27
			}
		default:
			goto tr27
		}
		goto tr65
	tr294:
		lex.te = (lex.p) + 1

		lex.act = 41
		goto st235
	st235:
		if (lex.p)++; (lex.p) == (lex.pe) {
			goto _test_eof235
		}
	st_case_235:
		switch lex.data[(lex.p)] {
		case 46:
			goto st18
		case 95:
			goto tr27
		case 110:
			goto tr295
		}
		switch {
		case lex.data[(lex.p)] < 65:
			if 48 <= lex.data[(lex.p)] && lex.data[(lex.p)] <= 57 {
				goto tr27
			}
		case lex.data[(lex.p)] > 90:
			if 97 <= lex.data[(lex.p)] && lex.data[(lex.p)] <= 122 {
				goto tr27
			}
		default:
			goto tr27
		}
		goto tr65
	tr295:
		lex.te = (lex.p) + 1

		lex.act = 41
		goto st236
	st236:
		if (lex.p)++; (lex.p) == (lex.pe) {
			goto _test_eof236
		}
	st_case_236:
		switch lex.data[(lex.p)] {
		case 46:
			goto st18
		case 95:
			goto tr27
		case 116:
			goto tr118
		}
		switch {
		case lex.data[(lex.p)] < 65:
			if 48 <= lex.data[(lex.p)] && lex.data[(lex.p)] <= 57 {
				goto tr27
			}
		case lex.data[(lex.p)] > 90:
			if 97 <= lex.data[(lex.p)] && lex.data[(lex.p)] <= 122 {
				goto tr27
			}
		default:
			goto tr27
		}
		goto tr65
	tr274:
		lex.te = (lex.p) + 1

		reservedKeyword = string(lex.data[lex.ts:lex.te])
		lex.act = 40
		goto st237
	st237:
		if (lex.p)++; (lex.p) == (lex.pe) {
			goto _test_eof237
		}
	st_case_237:
		switch lex.data[(lex.p)] {
		case 9:
			goto st33
		case 10:
			goto tr73
		case 13:
			goto st33
		case 32:
			goto st33
		case 46:
			goto st18
		case 95:
			goto tr27
		case 99:
			goto tr296
		case 108:
			goto tr297
		case 115:
			goto tr298
		case 116:
			goto tr299
		}
		switch {
		case lex.data[(lex.p)] < 65:
			if 48 <= lex.data[(lex.p)] && lex.data[(lex.p)] <= 57 {
				goto tr27
			}
		case lex.data[(lex.p)] > 90:
			if 97 <= lex.data[(lex.p)] && lex.data[(lex.p)] <= 122 {
				goto tr27
			}
		default:
			goto tr27
		}
		goto tr71
	tr296:
		lex.te = (lex.p) + 1

		lex.act = 41
		goto st238
	st238:
		if (lex.p)++; (lex.p) == (lex.pe) {
			goto _test_eof238
		}
	st_case_238:
		switch lex.data[(lex.p)] {
		case 46:
			goto st18
		case 95:
			goto tr27
		case 108:
			goto tr300
		}
		switch {
		case lex.data[(lex.p)] < 65:
			if 48 <= lex.data[(lex.p)] && lex.data[(lex.p)] <= 57 {
				goto tr27
			}
		case lex.data[(lex.p)] > 90:
			if 97 <= lex.data[(lex.p)] && lex.data[(lex.p)] <= 122 {
				goto tr27
			}
		default:
			goto tr27
		}
		goto tr65
	tr300:
		lex.te = (lex.p) + 1

		lex.act = 41
		goto st239
	st239:
		if (lex.p)++; (lex.p) == (lex.pe) {
			goto _test_eof239
		}
	st_case_239:
		switch lex.data[(lex.p)] {
		case 46:
			goto st18
		case 95:
			goto tr27
		case 117:
			goto tr301
		}
		switch {
		case lex.data[(lex.p)] < 65:
			if 48 <= lex.data[(lex.p)] && lex.data[(lex.p)] <= 57 {
				goto tr27
			}
		case lex.data[(lex.p)] > 90:
			if 97 <= lex.data[(lex.p)] && lex.data[(lex.p)] <= 122 {
				goto tr27
			}
		default:
			goto tr27
		}
		goto tr65
	tr301:
		lex.te = (lex.p) + 1

		lex.act = 41
		goto st240
	st240:
		if (lex.p)++; (lex.p) == (lex.pe) {
			goto _test_eof240
		}
	st_case_240:
		switch lex.data[(lex.p)] {
		case 46:
			goto st18
		case 95:
			goto tr27
		case 100:
			goto tr302
		}
		switch {
		case lex.data[(lex.p)] < 65:
			if 48 <= lex.data[(lex.p)] && lex.data[(lex.p)] <= 57 {
				goto tr27
			}
		case lex.data[(lex.p)] > 90:
			if 97 <= lex.data[(lex.p)] && lex.data[(lex.p)] <= 122 {
				goto tr27
			}
		default:
			goto tr27
		}
		goto tr65
	tr302:
		lex.te = (lex.p) + 1

		lex.act = 41
		goto st241
	st241:
		if (lex.p)++; (lex.p) == (lex.pe) {
			goto _test_eof241
		}
	st_case_241:
		switch lex.data[(lex.p)] {
		case 46:
			goto st18
		case 95:
			goto tr27
		case 101:
			goto tr303
		}
		switch {
		case lex.data[(lex.p)] < 65:
			if 48 <= lex.data[(lex.p)] && lex.data[(lex.p)] <= 57 {
				goto tr27
			}
		case lex.data[(lex.p)] > 90:
			if 97 <= lex.data[(lex.p)] && lex.data[(lex.p)] <= 122 {
				goto tr27
			}
		default:
			goto tr27
		}
		goto tr65
	tr303:
		lex.te = (lex.p) + 1

		lex.act = 1
		goto st242
	st242:
		if (lex.p)++; (lex.p) == (lex.pe) {
			goto _test_eof242
		}
	st_case_242:
		switch lex.data[(lex.p)] {
		case 9:
			goto st243
		case 10:
			goto tr306
		case 13:
			goto st243
		case 32:
			goto st243
		case 46:
			goto st18
		case 95:
			goto tr27
		}
		switch {
		case lex.data[(lex.p)] < 65:
			if 48 <= lex.data[(lex.p)] && lex.data[(lex.p)] <= 57 {
				goto tr27
			}
		case lex.data[(lex.p)] > 90:
			if 97 <= lex.data[(lex.p)] && lex.data[(lex.p)] <= 122 {
				goto tr27
			}
		default:
			goto tr27
		}
		goto tr304
	tr306:

		lex.line++
		lex.lineStart = lex.p + 1
		lex.linesSinceDocstring++

		goto st243
	st243:
		if (lex.p)++; (lex.p) == (lex.pe) {
			goto _test_eof243
		}
	st_case_243:
		switch lex.data[(lex.p)] {
		case 9:
			goto st243
		case 10:
			goto tr306
		case 13:
			goto st243
		case 32:
			goto st243
		}
		goto tr304
	tr297:
		lex.te = (lex.p) + 1

		lex.act = 41
		goto st244
	st244:
		if (lex.p)++; (lex.p) == (lex.pe) {
			goto _test_eof244
		}
	st_case_244:
		switch lex.data[(lex.p)] {
		case 46:
			goto st18
		case 95:
			goto tr27
		case 105:
			goto tr155
		}
		switch {
		case lex.data[(lex.p)] < 65:
			if 48 <= lex.data[(lex.p)] && lex.data[(lex.p)] <= 57 {
				goto tr27
			}
		case lex.data[(lex.p)] > 90:
			if 97 <= lex.data[(lex.p)] && lex.data[(lex.p)] <= 122 {
				goto tr27
			}
		default:
			goto tr27
		}
		goto tr65
	tr298:
		lex.te = (lex.p) + 1

		lex.act = 41
		goto st245
	st245:
		if (lex.p)++; (lex.p) == (lex.pe) {
			goto _test_eof245
		}
	st_case_245:
		switch lex.data[(lex.p)] {
		case 46:
			goto st18
		case 95:
			goto tr27
		case 116:
			goto tr307
		}
		switch {
		case lex.data[(lex.p)] < 65:
			if 48 <= lex.data[(lex.p)] && lex.data[(lex.p)] <= 57 {
				goto tr27
			}
		case lex.data[(lex.p)] > 90:
			if 97 <= lex.data[(lex.p)] && lex.data[(lex.p)] <= 122 {
				goto tr27
			}
		default:
			goto tr27
		}
		goto tr65
	tr307:
		lex.te = (lex.p) + 1

		lex.act = 41
		goto st246
	st246:
		if (lex.p)++; (lex.p) == (lex.pe) {
			goto _test_eof246
		}
	st_case_246:
		switch lex.data[(lex.p)] {
		case 46:
			goto st18
		case 95:
			goto tr27
		case 97:
			goto tr308
		}
		switch {
		case lex.data[(lex.p)] < 65:
			if 48 <= lex.data[(lex.p)] && lex.data[(lex.p)] <= 57 {
				goto tr27
			}
		case lex.data[(lex.p)] > 90:
			if 98 <= lex.data[(lex.p)] && lex.data[(lex.p)] <= 122 {
				goto tr27
			}
		default:
			goto tr27
		}
		goto tr65
	tr308:
		lex.te = (lex.p) + 1

		lex.act = 41
		goto st247
	st247:
		if (lex.p)++; (lex.p) == (lex.pe) {
			goto _test_eof247
		}
	st_case_247:
		switch lex.data[(lex.p)] {
		case 46:
			goto st18
		case 95:
			goto tr27
		case 110:
			goto tr309
		}
		switch {
		case lex.data[(lex.p)] < 65:
			if 48 <= lex.data[(lex.p)] && lex.data[(lex.p)] <= 57 {
				goto tr27
			}
		case lex.data[(lex.p)] > 90:
			if 97 <= lex.data[(lex.p)] && lex.data[(lex.p)] <= 122 {
				goto tr27
			}
		default:
			goto tr27
		}
		goto tr65
	tr309:
		lex.te = (lex.p) + 1

		lex.act = 41
		goto st248
	st248:
		if (lex.p)++; (lex.p) == (lex.pe) {
			goto _test_eof248
		}
	st_case_248:
		switch lex.data[(lex.p)] {
		case 46:
			goto st18
		case 95:
			goto tr27
		case 99:
			goto tr310
		}
		switch {
		case lex.data[(lex.p)] < 65:
			if 48 <= lex.data[(lex.p)] && lex.data[(lex.p)] <= 57 {
				goto tr27
			}
		case lex.data[(lex.p)] > 90:
			if 97 <= lex.data[(lex.p)] && lex.data[(lex.p)] <= 122 {
				goto tr27
			}
		default:
			goto tr27
		}
		goto tr65
	tr310:
		lex.te = (lex.p) + 1

		lex.act = 41
		goto st249
	st249:
		if (lex.p)++; (lex.p) == (lex.pe) {
			goto _test_eof249
		}
	st_case_249:
		switch lex.data[(lex.p)] {
		case 46:
			goto st18
		case 95:
			goto tr27
		case 101:
			goto tr311
		}
		switch {
		case lex.data[(lex.p)] < 65:
			if 48 <= lex.data[(lex.p)] && lex.data[(lex.p)] <= 57 {
				goto tr27
			}
		case lex.data[(lex.p)] > 90:
			if 97 <= lex.data[(lex.p)] && lex.data[(lex.p)] <= 122 {
				goto tr27
			}
		default:
			goto tr27
		}
		goto tr65
	tr311:
		lex.te = (lex.p) + 1

		lex.act = 41
		goto st250
	st250:
		if (lex.p)++; (lex.p) == (lex.pe) {
			goto _test_eof250
		}
	st_case_250:
		switch lex.data[(lex.p)] {
		case 46:
			goto st18
		case 95:
			goto tr27
		case 111:
			goto tr202
		}
		switch {
		case lex.data[(lex.p)] < 65:
			if 48 <= lex.data[(lex.p)] && lex.data[(lex.p)] <= 57 {
				goto tr27
			}
		case lex.data[(lex.p)] > 90:
			if 97 <= lex.data[(lex.p)] && lex.data[(lex.p)] <= 122 {
				goto tr27
			}
		default:
			goto tr27
		}
		goto tr65
	tr299:
		lex.te = (lex.p) + 1

		lex.act = 41
		goto st251
	st251:
		if (lex.p)++; (lex.p) == (lex.pe) {
			goto _test_eof251
		}
	st_case_251:
		switch lex.data[(lex.p)] {
		case 46:
			goto st18
		case 95:
			goto tr27
		case 101:
			goto tr312
		}
		switch {
		case lex.data[(lex.p)] < 65:
			if 48 <= lex.data[(lex.p)] && lex.data[(lex.p)] <= 57 {
				goto tr27
			}
		case lex.data[(lex.p)] > 90:
			if 97 <= lex.data[(lex.p)] && lex.data[(lex.p)] <= 122 {
				goto tr27
			}
		default:
			goto tr27
		}
		goto tr65
	tr312:
		lex.te = (lex.p) + 1

		lex.act = 41
		goto st252
	st252:
		if (lex.p)++; (lex.p) == (lex.pe) {
			goto _test_eof252
		}
	st_case_252:
		switch lex.data[(lex.p)] {
		case 46:
			goto st18
		case 95:
			goto tr27
		case 114:
			goto tr313
		}
		switch {
		case lex.data[(lex.p)] < 65:
			if 48 <= lex.data[(lex.p)] && lex.data[(lex.p)] <= 57 {
				goto tr27
			}
		case lex.data[(lex.p)] > 90:
			if 97 <= lex.data[(lex.p)] && lex.data[(lex.p)] <= 122 {
				goto tr27
			}
		default:
			goto tr27
		}
		goto tr65
	tr313:
		lex.te = (lex.p) + 1

		lex.act = 41
		goto st253
	st253:
		if (lex.p)++; (lex.p) == (lex.pe) {
			goto _test_eof253
		}
	st_case_253:
		switch lex.data[(lex.p)] {
		case 46:
			goto st18
		case 95:
			goto tr27
		case 102:
			goto tr314
		}
		switch {
		case lex.data[(lex.p)] < 65:
			if 48 <= lex.data[(lex.p)] && lex.data[(lex.p)] <= 57 {
				goto tr27
			}
		case lex.data[(lex.p)] > 90:
			if 97 <= lex.data[(lex.p)] && lex.data[(lex.p)] <= 122 {
				goto tr27
			}
		default:
			goto tr27
		}
		goto tr65
	tr314:
		lex.te = (lex.p) + 1

		lex.act = 41
		goto st254
	st254:
		if (lex.p)++; (lex.p) == (lex.pe) {
			goto _test_eof254
		}
	st_case_254:
		switch lex.data[(lex.p)] {
		case 46:
			goto st18
		case 95:
			goto tr27
		case 97:
			goto tr315
		}
		switch {
		case lex.data[(lex.p)] < 65:
			if 48 <= lex.data[(lex.p)] && lex.data[(lex.p)] <= 57 {
				goto tr27
			}
		case lex.data[(lex.p)] > 90:
			if 98 <= lex.data[(lex.p)] && lex.data[(lex.p)] <= 122 {
				goto tr27
			}
		default:
			goto tr27
		}
		goto tr65
	tr315:
		lex.te = (lex.p) + 1

		lex.act = 41
		goto st255
	st255:
		if (lex.p)++; (lex.p) == (lex.pe) {
			goto _test_eof255
		}
	st_case_255:
		switch lex.data[(lex.p)] {
		case 46:
			goto st18
		case 95:
			goto tr27
		case 99:
			goto tr151
		}
		switch {
		case lex.data[(lex.p)] < 65:
			if 48 <= lex.data[(lex.p)] && lex.data[(lex.p)] <= 57 {
				goto tr27
			}
		case lex.data[(lex.p)] > 90:
			if 97 <= lex.data[(lex.p)] && lex.data[(lex.p)] <= 122 {
				goto tr27
			}
		default:
			goto tr27
		}
		goto tr65
	tr45:
		lex.te = (lex.p) + 1

		lex.act = 41
		goto st256
	st256:
		if (lex.p)++; (lex.p) == (lex.pe) {
			goto _test_eof256
		}
	st_case_256:
		switch lex.data[(lex.p)] {
		case 46:
			goto st18
		case 95:
			goto tr27
		case 97:
			goto tr316
		case 105:
			goto tr317
		}
		switch {
		case lex.data[(lex.p)] < 65:
			if 48 <= lex.data[(lex.p)] && lex.data[(lex.p)] <= 57 {
				goto tr27
			}
		case lex.data[(lex.p)] > 90:
			if 98 <= lex.data[(lex.p)] && lex.data[(lex.p)] <= 122 {
				goto tr27
			}
		default:
			goto tr27
		}
		goto tr65
	tr316:
		lex.te = (lex.p) + 1

		lex.act = 41
		goto st257
	st257:
		if (lex.p)++; (lex.p) == (lex.pe) {
			goto _test_eof257
		}
	st_case_257:
		switch lex.data[(lex.p)] {
		case 46:
			goto st18
		case 95:
			goto tr27
		case 109:
			goto tr318
		}
		switch {
		case lex.data[(lex.p)] < 65:
			if 48 <= lex.data[(lex.p)] && lex.data[(lex.p)] <= 57 {
				goto tr27
			}
		case lex.data[(lex.p)] > 90:
			if 97 <= lex.data[(lex.p)] && lex.data[(lex.p)] <= 122 {
				goto tr27
			}
		default:
			goto tr27
		}
		goto tr65
	tr318:
		lex.te = (lex.p) + 1

		lex.act = 41
		goto st258
	st258:
		if (lex.p)++; (lex.p) == (lex.pe) {
			goto _test_eof258
		}
	st_case_258:
		switch lex.data[(lex.p)] {
		case 46:
			goto st18
		case 95:
			goto tr27
		case 98:
			goto tr319
		}
		switch {
		case lex.data[(lex.p)] < 65:
			if 48 <= lex.data[(lex.p)] && lex.data[(lex.p)] <= 57 {
				goto tr27
			}
		case lex.data[(lex.p)] > 90:
			if 97 <= lex.data[(lex.p)] && lex.data[(lex.p)] <= 122 {
				goto tr27
			}
		default:
			goto tr27
		}
		goto tr65
	tr319:
		lex.te = (lex.p) + 1

		lex.act = 41
		goto st259
	st259:
		if (lex.p)++; (lex.p) == (lex.pe) {
			goto _test_eof259
		}
	st_case_259:
		switch lex.data[(lex.p)] {
		case 46:
			goto st18
		case 95:
			goto tr27
		case 100:
			goto tr320
		}
		switch {
		case lex.data[(lex.p)] < 65:
			if 48 <= lex.data[(lex.p)] && lex.data[(lex.p)] <= 57 {
				goto tr27
			}
		case lex.data[(lex.p)] > 90:
			if 97 <= lex.data[(lex.p)] && lex.data[(lex.p)] <= 122 {
				goto tr27
			}
		default:
			goto tr27
		}
		goto tr65
	tr320:
		lex.te = (lex.p) + 1

		lex.act = 41
		goto st260
	st260:
		if (lex.p)++; (lex.p) == (lex.pe) {
			goto _test_eof260
		}
	st_case_260:
		switch lex.data[(lex.p)] {
		case 46:
			goto st18
		case 95:
			goto tr27
		case 97:
			goto tr70
		}
		switch {
		case lex.data[(lex.p)] < 65:
			if 48 <= lex.data[(lex.p)] && lex.data[(lex.p)] <= 57 {
				goto tr27
			}
		case lex.data[(lex.p)] > 90:
			if 98 <= lex.data[(lex.p)] && lex.data[(lex.p)] <= 122 {
				goto tr27
			}
		default:
			goto tr27
		}
		goto tr65
	tr317:
		lex.te = (lex.p) + 1

		lex.act = 41
		goto st261
	st261:
		if (lex.p)++; (lex.p) == (lex.pe) {
			goto _test_eof261
		}
	st_case_261:
		switch lex.data[(lex.p)] {
		case 46:
			goto st18
		case 95:
			goto tr27
		case 115:
			goto tr321
		}
		switch {
		case lex.data[(lex.p)] < 65:
			if 48 <= lex.data[(lex.p)] && lex.data[(lex.p)] <= 57 {
				goto tr27
			}
		case lex.data[(lex.p)] > 90:
			if 97 <= lex.data[(lex.p)] && lex.data[(lex.p)] <= 122 {
				goto tr27
			}
		default:
			goto tr27
		}
		goto tr65
	tr321:
		lex.te = (lex.p) + 1

		lex.act = 41
		goto st262
	st262:
		if (lex.p)++; (lex.p) == (lex.pe) {
			goto _test_eof262
		}
	st_case_262:
		switch lex.data[(lex.p)] {
		case 46:
			goto st18
		case 95:
			goto tr27
		case 116:
			goto tr322
		}
		switch {
		case lex.data[(lex.p)] < 65:
			if 48 <= lex.data[(lex.p)] && lex.data[(lex.p)] <= 57 {
				goto tr27
			}
		case lex.data[(lex.p)] > 90:
			if 97 <= lex.data[(lex.p)] && lex.data[(lex.p)] <= 122 {
				goto tr27
			}
		default:
			goto tr27
		}
		goto tr65
	tr322:
		lex.te = (lex.p) + 1

		lex.act = 15
		goto st263
	st263:
		if (lex.p)++; (lex.p) == (lex.pe) {
			goto _test_eof263
		}
	st_case_263:
		switch lex.data[(lex.p)] {
		case 9:
			goto st264
		case 10:
			goto tr325
		case 13:
			goto st264
		case 32:
			goto st264
		case 46:
			goto st18
		case 95:
			goto tr27
		}
		switch {
		case lex.data[(lex.p)] < 65:
			if 48 <= lex.data[(lex.p)] && lex.data[(lex.p)] <= 57 {
				goto tr27
			}
		case lex.data[(lex.p)] > 90:
			if 97 <= lex.data[(lex.p)] && lex.data[(lex.p)] <= 122 {
				goto tr27
			}
		default:
			goto tr27
		}
		goto tr323
	tr325:

		lex.line++
		lex.lineStart = lex.p + 1
		lex.linesSinceDocstring++

		goto st264
	st264:
		if (lex.p)++; (lex.p) == (lex.pe) {
			goto _test_eof264
		}
	st_case_264:
		switch lex.data[(lex.p)] {
		case 9:
			goto st264
		case 10:
			goto tr325
		case 13:
			goto st264
		case 32:
			goto st264
		}
		goto tr323
	tr46:
		lex.te = (lex.p) + 1

		lex.act = 41
		goto st265
	st265:
		if (lex.p)++; (lex.p) == (lex.pe) {
			goto _test_eof265
		}
	st_case_265:
		switch lex.data[(lex.p)] {
		case 46:
			goto st18
		case 95:
			goto tr27
		case 97:
			goto tr326
		case 111:
			goto tr327
		}
		switch {
		case lex.data[(lex.p)] < 65:
			if 48 <= lex.data[(lex.p)] && lex.data[(lex.p)] <= 57 {
				goto tr27
			}
		case lex.data[(lex.p)] > 90:
			if 98 <= lex.data[(lex.p)] && lex.data[(lex.p)] <= 122 {
				goto tr27
			}
		default:
			goto tr27
		}
		goto tr65
	tr326:
		lex.te = (lex.p) + 1

		lex.act = 41
		goto st266
	st266:
		if (lex.p)++; (lex.p) == (lex.pe) {
			goto _test_eof266
		}
	st_case_266:
		switch lex.data[(lex.p)] {
		case 46:
			goto st18
		case 95:
			goto tr27
		case 112:
			goto tr328
		}
		switch {
		case lex.data[(lex.p)] < 65:
			if 48 <= lex.data[(lex.p)] && lex.data[(lex.p)] <= 57 {
				goto tr27
			}
		case lex.data[(lex.p)] > 90:
			if 97 <= lex.data[(lex.p)] && lex.data[(lex.p)] <= 122 {
				goto tr27
			}
		default:
			goto tr27
		}
		goto tr65
	tr328:
		lex.te = (lex.p) + 1

		lex.act = 14
		goto st267
	st267:
		if (lex.p)++; (lex.p) == (lex.pe) {
			goto _test_eof267
		}
	st_case_267:
		switch lex.data[(lex.p)] {
		case 9:
			goto st268
		case 10:
			goto tr331
		case 13:
			goto st268
		case 32:
			goto st268
		case 46:
			goto st18
		case 95:
			goto tr27
		}
		switch {
		case lex.data[(lex.p)] < 65:
			if 48 <= lex.data[(lex.p)] && lex.data[(lex.p)] <= 57 {
				goto tr27
			}
		case lex.data[(lex.p)] > 90:
			if 97 <= lex.data[(lex.p)] && lex.data[(lex.p)] <= 122 {
				goto tr27
			}
		default:
			goto tr27
		}
		goto tr329
	tr331:

		lex.line++
		lex.lineStart = lex.p + 1
		lex.linesSinceDocstring++

		goto st268
	st268:
		if (lex.p)++; (lex.p) == (lex.pe) {
			goto _test_eof268
		}
	st_case_268:
		switch lex.data[(lex.p)] {
		case 9:
			goto st268
		case 10:
			goto tr331
		case 13:
			goto st268
		case 32:
			goto st268
		}
		goto tr329
	tr327:
		lex.te = (lex.p) + 1

		lex.act = 41
		goto st269
	st269:
		if (lex.p)++; (lex.p) == (lex.pe) {
			goto _test_eof269
		}
	st_case_269:
		switch lex.data[(lex.p)] {
		case 46:
			goto st18
		case 95:
			goto tr27
		case 100:
			goto tr332
		}
		switch {
		case lex.data[(lex.p)] < 65:
			if 48 <= lex.data[(lex.p)] && lex.data[(lex.p)] <= 57 {
				goto tr27
			}
		case lex.data[(lex.p)] > 90:
			if 97 <= lex.data[(lex.p)] && lex.data[(lex.p)] <= 122 {
				goto tr27
			}
		default:
			goto tr27
		}
		goto tr65
	tr332:
		lex.te = (lex.p) + 1

		lex.act = 41
		goto st270
	st270:
		if (lex.p)++; (lex.p) == (lex.pe) {
			goto _test_eof270
		}
	st_case_270:
		switch lex.data[(lex.p)] {
		case 46:
			goto st18
		case 95:
			goto tr27
		case 117:
			goto tr219
		}
		switch {
		case lex.data[(lex.p)] < 65:
			if 48 <= lex.data[(lex.p)] && lex.data[(lex.p)] <= 57 {
				goto tr27
			}
		case lex.data[(lex.p)] > 90:
			if 97 <= lex.data[(lex.p)] && lex.data[(lex.p)] <= 122 {
				goto tr27
			}
		default:
			goto tr27
		}
		goto tr65
	tr47:
		lex.te = (lex.p) + 1

		lex.act = 41
		goto st271
	st271:
		if (lex.p)++; (lex.p) == (lex.pe) {
			goto _test_eof271
		}
	st_case_271:
		switch lex.data[(lex.p)] {
		case 46:
			goto st18
		case 95:
			goto tr27
		case 97:
			goto tr333
		case 101:
			goto tr334
		case 105:
			goto tr267
		case 111:
			goto tr116
		}
		switch {
		case lex.data[(lex.p)] < 65:
			if 48 <= lex.data[(lex.p)] && lex.data[(lex.p)] <= 57 {
				goto tr27
			}
		case lex.data[(lex.p)] > 90:
			if 98 <= lex.data[(lex.p)] && lex.data[(lex.p)] <= 122 {
				goto tr27
			}
		default:
			goto tr27
		}
		goto tr65
	tr333:
		lex.te = (lex.p) + 1

		lex.act = 41
		goto st272
	st272:
		if (lex.p)++; (lex.p) == (lex.pe) {
			goto _test_eof272
		}
	st_case_272:
		switch lex.data[(lex.p)] {
		case 46:
			goto st18
		case 95:
			goto tr27
		case 109:
			goto tr335
		case 116:
			goto tr336
		}
		switch {
		case lex.data[(lex.p)] < 65:
			if 48 <= lex.data[(lex.p)] && lex.data[(lex.p)] <= 57 {
				goto tr27
			}
		case lex.data[(lex.p)] > 90:
			if 97 <= lex.data[(lex.p)] && lex.data[(lex.p)] <= 122 {
				goto tr27
			}
		default:
			goto tr27
		}
		goto tr65
	tr335:
		lex.te = (lex.p) + 1

		lex.act = 41
		goto st273
	st273:
		if (lex.p)++; (lex.p) == (lex.pe) {
			goto _test_eof273
		}
	st_case_273:
		switch lex.data[(lex.p)] {
		case 46:
			goto st18
		case 95:
			goto tr27
		case 101:
			goto tr337
		}
		switch {
		case lex.data[(lex.p)] < 65:
			if 48 <= lex.data[(lex.p)] && lex.data[(lex.p)] <= 57 {
				goto tr27
			}
		case lex.data[(lex.p)] > 90:
			if 97 <= lex.data[(lex.p)] && lex.data[(lex.p)] <= 122 {
				goto tr27
			}
		default:
			goto tr27
		}
		goto tr65
	tr337:
		lex.te = (lex.p) + 1

		lex.act = 41
		goto st274
	st274:
		if (lex.p)++; (lex.p) == (lex.pe) {
			goto _test_eof274
		}
	st_case_274:
		switch lex.data[(lex.p)] {
		case 46:
			goto st18
		case 95:
			goto tr27
		case 115:
			goto tr338
		}
		switch {
		case lex.data[(lex.p)] < 65:
			if 48 <= lex.data[(lex.p)] && lex.data[(lex.p)] <= 57 {
				goto tr27
			}
		case lex.data[(lex.p)] > 90:
			if 97 <= lex.data[(lex.p)] && lex.data[(lex.p)] <= 122 {
				goto tr27
			}
		default:
			goto tr27
		}
		goto tr65
	tr338:
		lex.te = (lex.p) + 1

		lex.act = 41
		goto st275
	st275:
		if (lex.p)++; (lex.p) == (lex.pe) {
			goto _test_eof275
		}
	st_case_275:
		switch lex.data[(lex.p)] {
		case 46:
			goto st18
		case 95:
			goto tr27
		case 112:
			goto tr339
		}
		switch {
		case lex.data[(lex.p)] < 65:
			if 48 <= lex.data[(lex.p)] && lex.data[(lex.p)] <= 57 {
				goto tr27
			}
		case lex.data[(lex.p)] > 90:
			if 97 <= lex.data[(lex.p)] && lex.data[(lex.p)] <= 122 {
				goto tr27
			}
		default:
			goto tr27
		}
		goto tr65
	tr339:
		lex.te = (lex.p) + 1

		lex.act = 41
		goto st276
	st276:
		if (lex.p)++; (lex.p) == (lex.pe) {
			goto _test_eof276
		}
	st_case_276:
		switch lex.data[(lex.p)] {
		case 46:
			goto st18
		case 95:
			goto tr27
		case 97:
			goto tr340
		}
		switch {
		case lex.data[(lex.p)] < 65:
			if 48 <= lex.data[(lex.p)] && lex.data[(lex.p)] <= 57 {
				goto tr27
			}
		case lex.data[(lex.p)] > 90:
			if 98 <= lex.data[(lex.p)] && lex.data[(lex.p)] <= 122 {
				goto tr27
			}
		default:
			goto tr27
		}
		goto tr65
	tr340:
		lex.te = (lex.p) + 1

		lex.act = 41
		goto st277
	st277:
		if (lex.p)++; (lex.p) == (lex.pe) {
			goto _test_eof277
		}
	st_case_277:
		switch lex.data[(lex.p)] {
		case 46:
			goto st18
		case 95:
			goto tr27
		case 99:
			goto tr341
		}
		switch {
		case lex.data[(lex.p)] < 65:
			if 48 <= lex.data[(lex.p)] && lex.data[(lex.p)] <= 57 {
				goto tr27
			}
		case lex.data[(lex.p)] > 90:
			if 97 <= lex.data[(lex.p)] && lex.data[(lex.p)] <= 122 {
				goto tr27
			}
		default:
			goto tr27
		}
		goto tr65
	tr341:
		lex.te = (lex.p) + 1

		lex.act = 41
		goto st278
	st278:
		if (lex.p)++; (lex.p) == (lex.pe) {
			goto _test_eof278
		}
	st_case_278:
		switch lex.data[(lex.p)] {
		case 46:
			goto st18
		case 95:
			goto tr27
		case 101:
			goto tr342
		}
		switch {
		case lex.data[(lex.p)] < 65:
			if 48 <= lex.data[(lex.p)] && lex.data[(lex.p)] <= 57 {
				goto tr27
			}
		case lex.data[(lex.p)] > 90:
			if 97 <= lex.data[(lex.p)] && lex.data[(lex.p)] <= 122 {
				goto tr27
			}
		default:
			goto tr27
		}
		goto tr65
	tr342:
		lex.te = (lex.p) + 1

		lex.act = 3
		goto st279
	st279:
		if (lex.p)++; (lex.p) == (lex.pe) {
			goto _test_eof279
		}
	st_case_279:
		switch lex.data[(lex.p)] {
		case 9:
			goto st280
		case 10:
			goto tr345
		case 13:
			goto st280
		case 32:
			goto st280
		case 46:
			goto st18
		case 95:
			goto tr27
		}
		switch {
		case lex.data[(lex.p)] < 65:
			if 48 <= lex.data[(lex.p)] && lex.data[(lex.p)] <= 57 {
				goto tr27
			}
		case lex.data[(lex.p)] > 90:
			if 97 <= lex.data[(lex.p)] && lex.data[(lex.p)] <= 122 {
				goto tr27
			}
		default:
			goto tr27
		}
		goto tr343
	tr345:

		lex.line++
		lex.lineStart = lex.p + 1
		lex.linesSinceDocstring++

		goto st280
	st280:
		if (lex.p)++; (lex.p) == (lex.pe) {
			goto _test_eof280
		}
	st_case_280:
		switch lex.data[(lex.p)] {
		case 9:
			goto st280
		case 10:
			goto tr345
		case 13:
			goto st280
		case 32:
			goto st280
		}
		goto tr343
	tr336:
		lex.te = (lex.p) + 1

		lex.act = 41
		goto st281
	st281:
		if (lex.p)++; (lex.p) == (lex.pe) {
			goto _test_eof281
		}
	st_case_281:
		switch lex.data[(lex.p)] {
		case 46:
			goto st18
		case 95:
			goto tr27
		case 105:
			goto tr346
		}
		switch {
		case lex.data[(lex.p)] < 65:
			if 48 <= lex.data[(lex.p)] && lex.data[(lex.p)] <= 57 {
				goto tr27
			}
		case lex.data[(lex.p)] > 90:
			if 97 <= lex.data[(lex.p)] && lex.data[(lex.p)] <= 122 {
				goto tr27
			}
		default:
			goto tr27
		}
		goto tr65
	tr346:
		lex.te = (lex.p) + 1

		lex.act = 41
		goto st282
	st282:
		if (lex.p)++; (lex.p) == (lex.pe) {
			goto _test_eof282
		}
	st_case_282:
		switch lex.data[(lex.p)] {
		case 46:
			goto st18
		case 95:
			goto tr27
		case 118:
			goto tr151
		}
		switch {
		case lex.data[(lex.p)] < 65:
			if 48 <= lex.data[(lex.p)] && lex.data[(lex.p)] <= 57 {
				goto tr27
			}
		case lex.data[(lex.p)] > 90:
			if 97 <= lex.data[(lex.p)] && lex.data[(lex.p)] <= 122 {
				goto tr27
			}
		default:
			goto tr27
		}
		goto tr65
	tr334:
		lex.te = (lex.p) + 1

		lex.act = 41
		goto st283
	st283:
		if (lex.p)++; (lex.p) == (lex.pe) {
			goto _test_eof283
		}
	st_case_283:
		switch lex.data[(lex.p)] {
		case 46:
			goto st18
		case 95:
			goto tr27
		case 119:
			goto tr70
		case 120:
			goto tr116
		}
		switch {
		case lex.data[(lex.p)] < 65:
			if 48 <= lex.data[(lex.p)] && lex.data[(lex.p)] <= 57 {
				goto tr27
			}
		case lex.data[(lex.p)] > 90:
			if 97 <= lex.data[(lex.p)] && lex.data[(lex.p)] <= 122 {
				goto tr27
			}
		default:
			goto tr27
		}
		goto tr65
	tr48:
		lex.te = (lex.p) + 1

		lex.act = 41
		goto st284
	st284:
		if (lex.p)++; (lex.p) == (lex.pe) {
			goto _test_eof284
		}
	st_case_284:
		switch lex.data[(lex.p)] {
		case 46:
			goto st18
		case 95:
			goto tr27
		case 110:
			goto tr347
		case 112:
			goto tr348
		case 114:
			goto tr70
		}
		switch {
		case lex.data[(lex.p)] < 65:
			if 48 <= lex.data[(lex.p)] && lex.data[(lex.p)] <= 57 {
				goto tr27
			}
		case lex.data[(lex.p)] > 90:
			if 97 <= lex.data[(lex.p)] && lex.data[(lex.p)] <= 122 {
				goto tr27
			}
		default:
			goto tr27
		}
		goto tr65
	tr347:
		lex.te = (lex.p) + 1

		lex.act = 41
		goto st285
	st285:
		if (lex.p)++; (lex.p) == (lex.pe) {
			goto _test_eof285
		}
	st_case_285:
		switch lex.data[(lex.p)] {
		case 46:
			goto st18
		case 95:
			goto tr27
		case 101:
			goto tr349
		}
		switch {
		case lex.data[(lex.p)] < 65:
			if 48 <= lex.data[(lex.p)] && lex.data[(lex.p)] <= 57 {
				goto tr27
			}
		case lex.data[(lex.p)] > 90:
			if 97 <= lex.data[(lex.p)] && lex.data[(lex.p)] <= 122 {
				goto tr27
			}
		default:
			goto tr27
		}
		goto tr65
	tr349:
		lex.te = (lex.p) + 1

		lex.act = 41
		goto st286
	st286:
		if (lex.p)++; (lex.p) == (lex.pe) {
			goto _test_eof286
		}
	st_case_286:
		switch lex.data[(lex.p)] {
		case 46:
			goto st18
		case 95:
			goto tr27
		case 119:
			goto tr350
		}
		switch {
		case lex.data[(lex.p)] < 65:
			if 48 <= lex.data[(lex.p)] && lex.data[(lex.p)] <= 57 {
				goto tr27
			}
		case lex.data[(lex.p)] > 90:
			if 97 <= lex.data[(lex.p)] && lex.data[(lex.p)] <= 122 {
				goto tr27
			}
		default:
			goto tr27
		}
		goto tr65
	tr350:
		lex.te = (lex.p) + 1

		lex.act = 41
		goto st287
	st287:
		if (lex.p)++; (lex.p) == (lex.pe) {
			goto _test_eof287
		}
	st_case_287:
		switch lex.data[(lex.p)] {
		case 46:
			goto st18
		case 95:
			goto tr27
		case 97:
			goto tr351
		}
		switch {
		case lex.data[(lex.p)] < 65:
			if 48 <= lex.data[(lex.p)] && lex.data[(lex.p)] <= 57 {
				goto tr27
			}
		case lex.data[(lex.p)] > 90:
			if 98 <= lex.data[(lex.p)] && lex.data[(lex.p)] <= 122 {
				goto tr27
			}
		default:
			goto tr27
		}
		goto tr65
	tr351:
		lex.te = (lex.p) + 1

		lex.act = 41
		goto st288
	st288:
		if (lex.p)++; (lex.p) == (lex.pe) {
			goto _test_eof288
		}
	st_case_288:
		switch lex.data[(lex.p)] {
		case 46:
			goto st18
		case 95:
			goto tr27
		case 121:
			goto tr352
		}
		switch {
		case lex.data[(lex.p)] < 65:
			if 48 <= lex.data[(lex.p)] && lex.data[(lex.p)] <= 57 {
				goto tr27
			}
		case lex.data[(lex.p)] > 90:
			if 97 <= lex.data[(lex.p)] && lex.data[(lex.p)] <= 122 {
				goto tr27
			}
		default:
			goto tr27
		}
		goto tr65
	tr352:
		lex.te = (lex.p) + 1

		lex.act = 17
		goto st289
	st289:
		if (lex.p)++; (lex.p) == (lex.pe) {
			goto _test_eof289
		}
	st_case_289:
		switch lex.data[(lex.p)] {
		case 9:
			goto st290
		case 10:
			goto tr355
		case 13:
			goto st290
		case 32:
			goto st290
		case 46:
			goto st18
		case 95:
			goto tr27
		}
		switch {
		case lex.data[(lex.p)] < 65:
			if 48 <= lex.data[(lex.p)] && lex.data[(lex.p)] <= 57 {
				goto tr27
			}
		case lex.data[(lex.p)] > 90:
			if 97 <= lex.data[(lex.p)] && lex.data[(lex.p)] <= 122 {
				goto tr27
			}
		default:
			goto tr27
		}
		goto tr353
	tr355:

		lex.line++
		lex.lineStart = lex.p + 1
		lex.linesSinceDocstring++

		goto st290
	st290:
		if (lex.p)++; (lex.p) == (lex.pe) {
			goto _test_eof290
		}
	st_case_290:
		switch lex.data[(lex.p)] {
		case 9:
			goto st290
		case 10:
			goto tr355
		case 13:
			goto st290
		case 32:
			goto st290
		}
		goto tr353
	tr348:
		lex.te = (lex.p) + 1

		lex.act = 41
		goto st291
	st291:
		if (lex.p)++; (lex.p) == (lex.pe) {
			goto _test_eof291
		}
	st_case_291:
		switch lex.data[(lex.p)] {
		case 46:
			goto st18
		case 95:
			goto tr27
		case 116:
			goto tr356
		}
		switch {
		case lex.data[(lex.p)] < 65:
			if 48 <= lex.data[(lex.p)] && lex.data[(lex.p)] <= 57 {
				goto tr27
			}
		case lex.data[(lex.p)] > 90:
			if 97 <= lex.data[(lex.p)] && lex.data[(lex.p)] <= 122 {
				goto tr27
			}
		default:
			goto tr27
		}
		goto tr65
	tr356:
		lex.te = (lex.p) + 1

		lex.act = 41
		goto st292
	st292:
		if (lex.p)++; (lex.p) == (lex.pe) {
			goto _test_eof292
		}
	st_case_292:
		switch lex.data[(lex.p)] {
		case 46:
			goto st18
		case 95:
			goto tr27
		case 105:
			goto tr357
		}
		switch {
		case lex.data[(lex.p)] < 65:
			if 48 <= lex.data[(lex.p)] && lex.data[(lex.p)] <= 57 {
				goto tr27
			}
		case lex.data[(lex.p)] > 90:
			if 97 <= lex.data[(lex.p)] && lex.data[(lex.p)] <= 122 {
				goto tr27
			}
		default:
			goto tr27
		}
		goto tr65
	tr357:
		lex.te = (lex.p) + 1

		lex.act = 41
		goto st293
	st293:
		if (lex.p)++; (lex.p) == (lex.pe) {
			goto _test_eof293
		}
	st_case_293:
		switch lex.data[(lex.p)] {
		case 46:
			goto st18
		case 95:
			goto tr27
		case 111:
			goto tr358
		}
		switch {
		case lex.data[(lex.p)] < 65:
			if 48 <= lex.data[(lex.p)] && lex.data[(lex.p)] <= 57 {
				goto tr27
			}
		case lex.data[(lex.p)] > 90:
			if 97 <= lex.data[(lex.p)] && lex.data[(lex.p)] <= 122 {
				goto tr27
			}
		default:
			goto tr27
		}
		goto tr65
	tr358:
		lex.te = (lex.p) + 1

		lex.act = 41
		goto st294
	st294:
		if (lex.p)++; (lex.p) == (lex.pe) {
			goto _test_eof294
		}
	st_case_294:
		switch lex.data[(lex.p)] {
		case 46:
			goto st18
		case 95:
			goto tr27
		case 110:
			goto tr359
		}
		switch {
		case lex.data[(lex.p)] < 65:
			if 48 <= lex.data[(lex.p)] && lex.data[(lex.p)] <= 57 {
				goto tr27
			}
		case lex.data[(lex.p)] > 90:
			if 97 <= lex.data[(lex.p)] && lex.data[(lex.p)] <= 122 {
				goto tr27
			}
		default:
			goto tr27
		}
		goto tr65
	tr359:
		lex.te = (lex.p) + 1

		lex.act = 41
		goto st295
	st295:
		if (lex.p)++; (lex.p) == (lex.pe) {
			goto _test_eof295
		}
	st_case_295:
		switch lex.data[(lex.p)] {
		case 46:
			goto st18
		case 95:
			goto tr27
		case 97:
			goto tr360
		}
		switch {
		case lex.data[(lex.p)] < 65:
			if 48 <= lex.data[(lex.p)] && lex.data[(lex.p)] <= 57 {
				goto tr27
			}
		case lex.data[(lex.p)] > 90:
			if 98 <= lex.data[(lex.p)] && lex.data[(lex.p)] <= 122 {
				goto tr27
			}
		default:
			goto tr27
		}
		goto tr65
	tr360:
		lex.te = (lex.p) + 1

		lex.act = 41
		goto st296
	st296:
		if (lex.p)++; (lex.p) == (lex.pe) {
			goto _test_eof296
		}
	st_case_296:
		switch lex.data[(lex.p)] {
		case 46:
			goto st18
		case 95:
			goto tr27
		case 108:
			goto tr361
		}
		switch {
		case lex.data[(lex.p)] < 65:
			if 48 <= lex.data[(lex.p)] && lex.data[(lex.p)] <= 57 {
				goto tr27
			}
		case lex.data[(lex.p)] > 90:
			if 97 <= lex.data[(lex.p)] && lex.data[(lex.p)] <= 122 {
				goto tr27
			}
		default:
			goto tr27
		}
		goto tr65
	tr361:
		lex.te = (lex.p) + 1

		lex.act = 28
		goto st297
	st297:
		if (lex.p)++; (lex.p) == (lex.pe) {
			goto _test_eof297
		}
	st_case_297:
		switch lex.data[(lex.p)] {
		case 9:
			goto st298
		case 10:
			goto tr364
		case 13:
			goto st298
		case 32:
			goto st298
		case 46:
			goto st18
		case 95:
			goto tr27
		}
		switch {
		case lex.data[(lex.p)] < 65:
			if 48 <= lex.data[(lex.p)] && lex.data[(lex.p)] <= 57 {
				goto tr27
			}
		case lex.data[(lex.p)] > 90:
			if 97 <= lex.data[(lex.p)] && lex.data[(lex.p)] <= 122 {
				goto tr27
			}
		default:
			goto tr27
		}
		goto tr362
	tr364:

		lex.line++
		lex.lineStart = lex.p + 1
		lex.linesSinceDocstring++

		goto st298
	st298:
		if (lex.p)++; (lex.p) == (lex.pe) {
			goto _test_eof298
		}
	st_case_298:
		switch lex.data[(lex.p)] {
		case 9:
			goto st298
		case 10:
			goto tr364
		case 13:
			goto st298
		case 32:
			goto st298
		}
		goto tr362
	tr49:
		lex.te = (lex.p) + 1

		lex.act = 41
		goto st299
	st299:
		if (lex.p)++; (lex.p) == (lex.pe) {
			goto _test_eof299
		}
	st_case_299:
		switch lex.data[(lex.p)] {
		case 46:
			goto st18
		case 95:
			goto tr27
		case 97:
			goto tr365
		case 114:
			goto tr366
		case 117:
			goto tr367
		}
		switch {
		case lex.data[(lex.p)] < 65:
			if 48 <= lex.data[(lex.p)] && lex.data[(lex.p)] <= 57 {
				goto tr27
			}
		case lex.data[(lex.p)] > 90:
			if 98 <= lex.data[(lex.p)] && lex.data[(lex.p)] <= 122 {
				goto tr27
			}
		default:
			goto tr27
		}
		goto tr65
	tr365:
		lex.te = (lex.p) + 1

		lex.act = 41
		goto st300
	st300:
		if (lex.p)++; (lex.p) == (lex.pe) {
			goto _test_eof300
		}
	st_case_300:
		switch lex.data[(lex.p)] {
		case 46:
			goto st18
		case 95:
			goto tr27
		case 99:
			goto tr368
		case 115:
			goto tr118
		}
		switch {
		case lex.data[(lex.p)] < 65:
			if 48 <= lex.data[(lex.p)] && lex.data[(lex.p)] <= 57 {
				goto tr27
			}
		case lex.data[(lex.p)] > 90:
			if 97 <= lex.data[(lex.p)] && lex.data[(lex.p)] <= 122 {
				goto tr27
			}
		default:
			goto tr27
		}
		goto tr65
	tr368:
		lex.te = (lex.p) + 1

		lex.act = 41
		goto st301
	st301:
		if (lex.p)++; (lex.p) == (lex.pe) {
			goto _test_eof301
		}
	st_case_301:
		switch lex.data[(lex.p)] {
		case 46:
			goto st18
		case 95:
			goto tr27
		case 107:
			goto tr369
		}
		switch {
		case lex.data[(lex.p)] < 65:
			if 48 <= lex.data[(lex.p)] && lex.data[(lex.p)] <= 57 {
				goto tr27
			}
		case lex.data[(lex.p)] > 90:
			if 97 <= lex.data[(lex.p)] && lex.data[(lex.p)] <= 122 {
				goto tr27
			}
		default:
			goto tr27
		}
		goto tr65
	tr369:
		lex.te = (lex.p) + 1

		lex.act = 41
		goto st302
	st302:
		if (lex.p)++; (lex.p) == (lex.pe) {
			goto _test_eof302
		}
	st_case_302:
		switch lex.data[(lex.p)] {
		case 46:
			goto st18
		case 95:
			goto tr27
		case 97:
			goto tr370
		}
		switch {
		case lex.data[(lex.p)] < 65:
			if 48 <= lex.data[(lex.p)] && lex.data[(lex.p)] <= 57 {
				goto tr27
			}
		case lex.data[(lex.p)] > 90:
			if 98 <= lex.data[(lex.p)] && lex.data[(lex.p)] <= 122 {
				goto tr27
			}
		default:
			goto tr27
		}
		goto tr65
	tr370:
		lex.te = (lex.p) + 1

		lex.act = 41
		goto st303
	st303:
		if (lex.p)++; (lex.p) == (lex.pe) {
			goto _test_eof303
		}
	st_case_303:
		switch lex.data[(lex.p)] {
		case 46:
			goto st18
		case 95:
			goto tr27
		case 103:
			goto tr151
		}
		switch {
		case lex.data[(lex.p)] < 65:
			if 48 <= lex.data[(lex.p)] && lex.data[(lex.p)] <= 57 {
				goto tr27
			}
		case lex.data[(lex.p)] > 90:
			if 97 <= lex.data[(lex.p)] && lex.data[(lex.p)] <= 122 {
				goto tr27
			}
		default:
			goto tr27
		}
		goto tr65
	tr366:
		lex.te = (lex.p) + 1

		lex.act = 41
		goto st304
	st304:
		if (lex.p)++; (lex.p) == (lex.pe) {
			goto _test_eof304
		}
	st_case_304:
		switch lex.data[(lex.p)] {
		case 46:
			goto st18
		case 95:
			goto tr27
		case 105:
			goto tr371
		case 111:
			goto tr372
		}
		switch {
		case lex.data[(lex.p)] < 65:
			if 48 <= lex.data[(lex.p)] && lex.data[(lex.p)] <= 57 {
				goto tr27
			}
		case lex.data[(lex.p)] > 90:
			if 97 <= lex.data[(lex.p)] && lex.data[(lex.p)] <= 122 {
				goto tr27
			}
		default:
			goto tr27
		}
		goto tr65
	tr371:
		lex.te = (lex.p) + 1

		lex.act = 41
		goto st305
	st305:
		if (lex.p)++; (lex.p) == (lex.pe) {
			goto _test_eof305
		}
	st_case_305:
		switch lex.data[(lex.p)] {
		case 46:
			goto st18
		case 95:
			goto tr27
		case 110:
			goto tr116
		case 118:
			goto tr373
		}
		switch {
		case lex.data[(lex.p)] < 65:
			if 48 <= lex.data[(lex.p)] && lex.data[(lex.p)] <= 57 {
				goto tr27
			}
		case lex.data[(lex.p)] > 90:
			if 97 <= lex.data[(lex.p)] && lex.data[(lex.p)] <= 122 {
				goto tr27
			}
		default:
			goto tr27
		}
		goto tr65
	tr373:
		lex.te = (lex.p) + 1

		lex.act = 41
		goto st306
	st306:
		if (lex.p)++; (lex.p) == (lex.pe) {
			goto _test_eof306
		}
	st_case_306:
		switch lex.data[(lex.p)] {
		case 46:
			goto st18
		case 95:
			goto tr27
		case 97:
			goto tr187
		}
		switch {
		case lex.data[(lex.p)] < 65:
			if 48 <= lex.data[(lex.p)] && lex.data[(lex.p)] <= 57 {
				goto tr27
			}
		case lex.data[(lex.p)] > 90:
			if 98 <= lex.data[(lex.p)] && lex.data[(lex.p)] <= 122 {
				goto tr27
			}
		default:
			goto tr27
		}
		goto tr65
	tr372:
		lex.te = (lex.p) + 1

		lex.act = 41
		goto st307
	st307:
		if (lex.p)++; (lex.p) == (lex.pe) {
			goto _test_eof307
		}
	st_case_307:
		switch lex.data[(lex.p)] {
		case 46:
			goto st18
		case 95:
			goto tr27
		case 116:
			goto tr374
		}
		switch {
		case lex.data[(lex.p)] < 65:
			if 48 <= lex.data[(lex.p)] && lex.data[(lex.p)] <= 57 {
				goto tr27
			}
		case lex.data[(lex.p)] > 90:
			if 97 <= lex.data[(lex.p)] && lex.data[(lex.p)] <= 122 {
				goto tr27
			}
		default:
			goto tr27
		}
		goto tr65
	tr374:
		lex.te = (lex.p) + 1

		lex.act = 41
		goto st308
	st308:
		if (lex.p)++; (lex.p) == (lex.pe) {
			goto _test_eof308
		}
	st_case_308:
		switch lex.data[(lex.p)] {
		case 46:
			goto st18
		case 95:
			goto tr27
		case 101:
			goto tr375
		}
		switch {
		case lex.data[(lex.p)] < 65:
			if 48 <= lex.data[(lex.p)] && lex.data[(lex.p)] <= 57 {
				goto tr27
			}
		case lex.data[(lex.p)] > 90:
			if 97 <= lex.data[(lex.p)] && lex.data[(lex.p)] <= 122 {
				goto tr27
			}
		default:
			goto tr27
		}
		goto tr65
	tr375:
		lex.te = (lex.p) + 1

		lex.act = 41
		goto st309
	st309:
		if (lex.p)++; (lex.p) == (lex.pe) {
			goto _test_eof309
		}
	st_case_309:
		switch lex.data[(lex.p)] {
		case 46:
			goto st18
		case 95:
			goto tr27
		case 99:
			goto tr376
		}
		switch {
		case lex.data[(lex.p)] < 65:
			if 48 <= lex.data[(lex.p)] && lex.data[(lex.p)] <= 57 {
				goto tr27
			}
		case lex.data[(lex.p)] > 90:
			if 97 <= lex.data[(lex.p)] && lex.data[(lex.p)] <= 122 {
				goto tr27
			}
		default:
			goto tr27
		}
		goto tr65
	tr376:
		lex.te = (lex.p) + 1

		lex.act = 41
		goto st310
	st310:
		if (lex.p)++; (lex.p) == (lex.pe) {
			goto _test_eof310
		}
	st_case_310:
		switch lex.data[(lex.p)] {
		case 46:
			goto st18
		case 95:
			goto tr27
		case 116:
			goto tr377
		}
		switch {
		case lex.data[(lex.p)] < 65:
			if 48 <= lex.data[(lex.p)] && lex.data[(lex.p)] <= 57 {
				goto tr27
			}
		case lex.data[(lex.p)] > 90:
			if 97 <= lex.data[(lex.p)] && lex.data[(lex.p)] <= 122 {
				goto tr27
			}
		default:
			goto tr27
		}
		goto tr65
	tr377:
		lex.te = (lex.p) + 1

		lex.act = 41
		goto st311
	st311:
		if (lex.p)++; (lex.p) == (lex.pe) {
			goto _test_eof311
		}
	st_case_311:
		switch lex.data[(lex.p)] {
		case 46:
			goto st18
		case 95:
			goto tr27
		case 101:
			goto tr109
		}
		switch {
		case lex.data[(lex.p)] < 65:
			if 48 <= lex.data[(lex.p)] && lex.data[(lex.p)] <= 57 {
				goto tr27
			}
		case lex.data[(lex.p)] > 90:
			if 97 <= lex.data[(lex.p)] && lex.data[(lex.p)] <= 122 {
				goto tr27
			}
		default:
			goto tr27
		}
		goto tr65
	tr367:
		lex.te = (lex.p) + 1

		lex.act = 41
		goto st312
	st312:
		if (lex.p)++; (lex.p) == (lex.pe) {
			goto _test_eof312
		}
	st_case_312:
		switch lex.data[(lex.p)] {
		case 46:
			goto st18
		case 95:
			goto tr27
		case 98:
			goto tr378
		}
		switch {
		case lex.data[(lex.p)] < 65:
			if 48 <= lex.data[(lex.p)] && lex.data[(lex.p)] <= 57 {
				goto tr27
			}
		case lex.data[(lex.p)] > 90:
			if 97 <= lex.data[(lex.p)] && lex.data[(lex.p)] <= 122 {
				goto tr27
			}
		default:
			goto tr27
		}
		goto tr65
	tr378:
		lex.te = (lex.p) + 1

		lex.act = 41
		goto st313
	st313:
		if (lex.p)++; (lex.p) == (lex.pe) {
			goto _test_eof313
		}
	st_case_313:
		switch lex.data[(lex.p)] {
		case 46:
			goto st18
		case 95:
			goto tr27
		case 108:
			goto tr197
		}
		switch {
		case lex.data[(lex.p)] < 65:
			if 48 <= lex.data[(lex.p)] && lex.data[(lex.p)] <= 57 {
				goto tr27
			}
		case lex.data[(lex.p)] > 90:
			if 97 <= lex.data[(lex.p)] && lex.data[(lex.p)] <= 122 {
				goto tr27
			}
		default:
			goto tr27
		}
		goto tr65
	tr50:
		lex.te = (lex.p) + 1

		lex.act = 41
		goto st314
	st314:
		if (lex.p)++; (lex.p) == (lex.pe) {
			goto _test_eof314
		}
	st_case_314:
		switch lex.data[(lex.p)] {
		case 46:
			goto st18
		case 95:
			goto tr27
		case 97:
			goto tr379
		case 101:
			goto tr380
		}
		switch {
		case lex.data[(lex.p)] < 65:
			if 48 <= lex.data[(lex.p)] && lex.data[(lex.p)] <= 57 {
				goto tr27
			}
		case lex.data[(lex.p)] > 90:
			if 98 <= lex.data[(lex.p)] && lex.data[(lex.p)] <= 122 {
				goto tr27
			}
		default:
			goto tr27
		}
		goto tr65
	tr379:
		lex.te = (lex.p) + 1

		lex.act = 41
		goto st315
	st315:
		if (lex.p)++; (lex.p) == (lex.pe) {
			goto _test_eof315
		}
	st_case_315:
		switch lex.data[(lex.p)] {
		case 46:
			goto st18
		case 95:
			goto tr27
		case 105:
			goto tr381
		}
		switch {
		case lex.data[(lex.p)] < 65:
			if 48 <= lex.data[(lex.p)] && lex.data[(lex.p)] <= 57 {
				goto tr27
			}
		case lex.data[(lex.p)] > 90:
			if 97 <= lex.data[(lex.p)] && lex.data[(lex.p)] <= 122 {
				goto tr27
			}
		default:
			goto tr27
		}
		goto tr65
	tr381:
		lex.te = (lex.p) + 1

		lex.act = 41
		goto st316
	st316:
		if (lex.p)++; (lex.p) == (lex.pe) {
			goto _test_eof316
		}
	st_case_316:
		switch lex.data[(lex.p)] {
		case 46:
			goto st18
		case 95:
			goto tr27
		case 115:
			goto tr151
		}
		switch {
		case lex.data[(lex.p)] < 65:
			if 48 <= lex.data[(lex.p)] && lex.data[(lex.p)] <= 57 {
				goto tr27
			}
		case lex.data[(lex.p)] > 90:
			if 97 <= lex.data[(lex.p)] && lex.data[(lex.p)] <= 122 {
				goto tr27
			}
		default:
			goto tr27
		}
		goto tr65
	tr380:
		lex.te = (lex.p) + 1

		lex.act = 41
		goto st317
	st317:
		if (lex.p)++; (lex.p) == (lex.pe) {
			goto _test_eof317
		}
	st_case_317:
		switch lex.data[(lex.p)] {
		case 46:
			goto st18
		case 95:
			goto tr27
		case 100:
			goto tr268
		case 103:
			goto tr382
		case 113:
			goto tr383
		case 115:
			goto tr384
		case 116:
			goto tr385
		}
		switch {
		case lex.data[(lex.p)] < 65:
			if 48 <= lex.data[(lex.p)] && lex.data[(lex.p)] <= 57 {
				goto tr27
			}
		case lex.data[(lex.p)] > 90:
			if 97 <= lex.data[(lex.p)] && lex.data[(lex.p)] <= 122 {
				goto tr27
			}
		default:
			goto tr27
		}
		goto tr65
	tr382:
		lex.te = (lex.p) + 1

		lex.act = 41
		goto st318
	st318:
		if (lex.p)++; (lex.p) == (lex.pe) {
			goto _test_eof318
		}
	st_case_318:
		switch lex.data[(lex.p)] {
		case 46:
			goto st18
		case 95:
			goto tr27
		case 105:
			goto tr386
		}
		switch {
		case lex.data[(lex.p)] < 65:
			if 48 <= lex.data[(lex.p)] && lex.data[(lex.p)] <= 57 {
				goto tr27
			}
		case lex.data[(lex.p)] > 90:
			if 97 <= lex.data[(lex.p)] && lex.data[(lex.p)] <= 122 {
				goto tr27
			}
		default:
			goto tr27
		}
		goto tr65
	tr386:
		lex.te = (lex.p) + 1

		lex.act = 41
		goto st319
	st319:
		if (lex.p)++; (lex.p) == (lex.pe) {
			goto _test_eof319
		}
	st_case_319:
		switch lex.data[(lex.p)] {
		case 46:
			goto st18
		case 95:
			goto tr27
		case 115:
			goto tr387
		}
		switch {
		case lex.data[(lex.p)] < 65:
			if 48 <= lex.data[(lex.p)] && lex.data[(lex.p)] <= 57 {
				goto tr27
			}
		case lex.data[(lex.p)] > 90:
			if 97 <= lex.data[(lex.p)] && lex.data[(lex.p)] <= 122 {
				goto tr27
			}
		default:
			goto tr27
		}
		goto tr65
	tr387:
		lex.te = (lex.p) + 1

		lex.act = 41
		goto st320
	st320:
		if (lex.p)++; (lex.p) == (lex.pe) {
			goto _test_eof320
		}
	st_case_320:
		switch lex.data[(lex.p)] {
		case 46:
			goto st18
		case 95:
			goto tr27
		case 116:
			goto tr388
		}
		switch {
		case lex.data[(lex.p)] < 65:
			if 48 <= lex.data[(lex.p)] && lex.data[(lex.p)] <= 57 {
				goto tr27
			}
		case lex.data[(lex.p)] > 90:
			if 97 <= lex.data[(lex.p)] && lex.data[(lex.p)] <= 122 {
				goto tr27
			}
		default:
			goto tr27
		}
		goto tr65
	tr388:
		lex.te = (lex.p) + 1

		lex.act = 41
		goto st321
	st321:
		if (lex.p)++; (lex.p) == (lex.pe) {
			goto _test_eof321
		}
	st_case_321:
		switch lex.data[(lex.p)] {
		case 46:
			goto st18
		case 95:
			goto tr27
		case 101:
			goto tr389
		}
		switch {
		case lex.data[(lex.p)] < 65:
			if 48 <= lex.data[(lex.p)] && lex.data[(lex.p)] <= 57 {
				goto tr27
			}
		case lex.data[(lex.p)] > 90:
			if 97 <= lex.data[(lex.p)] && lex.data[(lex.p)] <= 122 {
				goto tr27
			}
		default:
			goto tr27
		}
		goto tr65
	tr389:
		lex.te = (lex.p) + 1

		lex.act = 41
		goto st322
	st322:
		if (lex.p)++; (lex.p) == (lex.pe) {
			goto _test_eof322
		}
	st_case_322:
		switch lex.data[(lex.p)] {
		case 46:
			goto st18
		case 95:
			goto tr27
		case 114:
			goto tr70
		}
		switch {
		case lex.data[(lex.p)] < 65:
			if 48 <= lex.data[(lex.p)] && lex.data[(lex.p)] <= 57 {
				goto tr27
			}
		case lex.data[(lex.p)] > 90:
			if 97 <= lex.data[(lex.p)] && lex.data[(lex.p)] <= 122 {
				goto tr27
			}
		default:
			goto tr27
		}
		goto tr65
	tr383:
		lex.te = (lex.p) + 1

		lex.act = 41
		goto st323
	st323:
		if (lex.p)++; (lex.p) == (lex.pe) {
			goto _test_eof323
		}
	st_case_323:
		switch lex.data[(lex.p)] {
		case 46:
			goto st18
		case 95:
			goto tr27
		case 117:
			goto tr390
		}
		switch {
		case lex.data[(lex.p)] < 65:
			if 48 <= lex.data[(lex.p)] && lex.data[(lex.p)] <= 57 {
				goto tr27
			}
		case lex.data[(lex.p)] > 90:
			if 97 <= lex.data[(lex.p)] && lex.data[(lex.p)] <= 122 {
				goto tr27
			}
		default:
			goto tr27
		}
		goto tr65
	tr390:
		lex.te = (lex.p) + 1

		lex.act = 41
		goto st324
	st324:
		if (lex.p)++; (lex.p) == (lex.pe) {
			goto _test_eof324
		}
	st_case_324:
		switch lex.data[(lex.p)] {
		case 46:
			goto st18
		case 95:
			goto tr27
		case 105:
			goto tr391
		}
		switch {
		case lex.data[(lex.p)] < 65:
			if 48 <= lex.data[(lex.p)] && lex.data[(lex.p)] <= 57 {
				goto tr27
			}
		case lex.data[(lex.p)] > 90:
			if 97 <= lex.data[(lex.p)] && lex.data[(lex.p)] <= 122 {
				goto tr27
			}
		default:
			goto tr27
		}
		goto tr65
	tr391:
		lex.te = (lex.p) + 1

		lex.act = 41
		goto st325
	st325:
		if (lex.p)++; (lex.p) == (lex.pe) {
			goto _test_eof325
		}
	st_case_325:
		switch lex.data[(lex.p)] {
		case 46:
			goto st18
		case 95:
			goto tr27
		case 114:
			goto tr392
		}
		switch {
		case lex.data[(lex.p)] < 65:
			if 48 <= lex.data[(lex.p)] && lex.data[(lex.p)] <= 57 {
				goto tr27
			}
		case lex.data[(lex.p)] > 90:
			if 97 <= lex.data[(lex.p)] && lex.data[(lex.p)] <= 122 {
				goto tr27
			}
		default:
			goto tr27
		}
		goto tr65
	tr392:
		lex.te = (lex.p) + 1

		lex.act = 41
		goto st326
	st326:
		if (lex.p)++; (lex.p) == (lex.pe) {
			goto _test_eof326
		}
	st_case_326:
		switch lex.data[(lex.p)] {
		case 46:
			goto st18
		case 95:
			goto tr27
		case 101:
			goto tr393
		}
		switch {
		case lex.data[(lex.p)] < 65:
			if 48 <= lex.data[(lex.p)] && lex.data[(lex.p)] <= 57 {
				goto tr27
			}
		case lex.data[(lex.p)] > 90:
			if 97 <= lex.data[(lex.p)] && lex.data[(lex.p)] <= 122 {
				goto tr27
			}
		default:
			goto tr27
		}
		goto tr65
	tr393:
		lex.te = (lex.p) + 1

		lex.act = 41
		goto st327
	st327:
		if (lex.p)++; (lex.p) == (lex.pe) {
			goto _test_eof327
		}
	st_case_327:
		switch lex.data[(lex.p)] {
		case 46:
			goto st18
		case 95:
			goto tr27
		case 100:
			goto tr394
		}
		switch {
		case lex.data[(lex.p)] < 65:
			if 48 <= lex.data[(lex.p)] && lex.data[(lex.p)] <= 57 {
				goto tr27
			}
		case lex.data[(lex.p)] > 90:
			if 97 <= lex.data[(lex.p)] && lex.data[(lex.p)] <= 122 {
				goto tr27
			}
		default:
			goto tr27
		}
		goto tr65
	tr394:
		lex.te = (lex.p) + 1

		lex.act = 27
		goto st328
	st328:
		if (lex.p)++; (lex.p) == (lex.pe) {
			goto _test_eof328
		}
	st_case_328:
		switch lex.data[(lex.p)] {
		case 9:
			goto st329
		case 10:
			goto tr397
		case 13:
			goto st329
		case 32:
			goto st329
		case 46:
			goto st18
		case 95:
			goto tr27
		}
		switch {
		case lex.data[(lex.p)] < 65:
			if 48 <= lex.data[(lex.p)] && lex.data[(lex.p)] <= 57 {
				goto tr27
			}
		case lex.data[(lex.p)] > 90:
			if 97 <= lex.data[(lex.p)] && lex.data[(lex.p)] <= 122 {
				goto tr27
			}
		default:
			goto tr27
		}
		goto tr395
	tr397:

		lex.line++
		lex.lineStart = lex.p + 1
		lex.linesSinceDocstring++

		goto st329
	st329:
		if (lex.p)++; (lex.p) == (lex.pe) {
			goto _test_eof329
		}
	st_case_329:
		switch lex.data[(lex.p)] {
		case 9:
			goto st329
		case 10:
			goto tr397
		case 13:
			goto st329
		case 32:
			goto st329
		}
		goto tr395
	tr384:
		lex.te = (lex.p) + 1

		lex.act = 41
		goto st330
	st330:
		if (lex.p)++; (lex.p) == (lex.pe) {
			goto _test_eof330
		}
	st_case_330:
		switch lex.data[(lex.p)] {
		case 46:
			goto st18
		case 95:
			goto tr27
		case 99:
			goto tr164
		}
		switch {
		case lex.data[(lex.p)] < 65:
			if 48 <= lex.data[(lex.p)] && lex.data[(lex.p)] <= 57 {
				goto tr27
			}
		case lex.data[(lex.p)] > 90:
			if 97 <= lex.data[(lex.p)] && lex.data[(lex.p)] <= 122 {
				goto tr27
			}
		default:
			goto tr27
		}
		goto tr65
	tr385:
		lex.te = (lex.p) + 1

		lex.act = 41
		goto st331
	st331:
		if (lex.p)++; (lex.p) == (lex.pe) {
			goto _test_eof331
		}
	st_case_331:
		switch lex.data[(lex.p)] {
		case 46:
			goto st18
		case 95:
			goto tr27
		case 114:
			goto tr256
		case 117:
			goto tr398
		}
		switch {
		case lex.data[(lex.p)] < 65:
			if 48 <= lex.data[(lex.p)] && lex.data[(lex.p)] <= 57 {
				goto tr27
			}
		case lex.data[(lex.p)] > 90:
			if 97 <= lex.data[(lex.p)] && lex.data[(lex.p)] <= 122 {
				goto tr27
			}
		default:
			goto tr27
		}
		goto tr65
	tr398:
		lex.te = (lex.p) + 1

		lex.act = 41
		goto st332
	st332:
		if (lex.p)++; (lex.p) == (lex.pe) {
			goto _test_eof332
		}
	st_case_332:
		switch lex.data[(lex.p)] {
		case 46:
			goto st18
		case 95:
			goto tr27
		case 114:
			goto tr127
		}
		switch {
		case lex.data[(lex.p)] < 65:
			if 48 <= lex.data[(lex.p)] && lex.data[(lex.p)] <= 57 {
				goto tr27
			}
		case lex.data[(lex.p)] > 90:
			if 97 <= lex.data[(lex.p)] && lex.data[(lex.p)] <= 122 {
				goto tr27
			}
		default:
			goto tr27
		}
		goto tr65
	tr51:
		lex.te = (lex.p) + 1

		lex.act = 41
		goto st333
	st333:
		if (lex.p)++; (lex.p) == (lex.pe) {
			goto _test_eof333
		}
	st_case_333:
		switch lex.data[(lex.p)] {
		case 46:
			goto st18
		case 95:
			goto tr27
		case 101:
			goto tr399
		case 105:
			goto tr400
		case 116:
			goto tr401
		case 117:
			goto tr402
		case 119:
			goto tr216
		case 121:
			goto tr403
		}
		switch {
		case lex.data[(lex.p)] < 65:
			if 48 <= lex.data[(lex.p)] && lex.data[(lex.p)] <= 57 {
				goto tr27
			}
		case lex.data[(lex.p)] > 90:
			if 97 <= lex.data[(lex.p)] && lex.data[(lex.p)] <= 122 {
				goto tr27
			}
		default:
			goto tr27
		}
		goto tr65
	tr399:
		lex.te = (lex.p) + 1

		lex.act = 41
		goto st334
	st334:
		if (lex.p)++; (lex.p) == (lex.pe) {
			goto _test_eof334
		}
	st_case_334:
		switch lex.data[(lex.p)] {
		case 46:
			goto st18
		case 95:
			goto tr27
		case 108:
			goto tr202
		case 114:
			goto tr404
		case 116:
			goto tr405
		}
		switch {
		case lex.data[(lex.p)] < 65:
			if 48 <= lex.data[(lex.p)] && lex.data[(lex.p)] <= 57 {
				goto tr27
			}
		case lex.data[(lex.p)] > 90:
			if 97 <= lex.data[(lex.p)] && lex.data[(lex.p)] <= 122 {
				goto tr27
			}
		default:
			goto tr27
		}
		goto tr65
	tr404:
		lex.te = (lex.p) + 1

		lex.act = 41
		goto st335
	st335:
		if (lex.p)++; (lex.p) == (lex.pe) {
			goto _test_eof335
		}
	st_case_335:
		switch lex.data[(lex.p)] {
		case 46:
			goto st18
		case 95:
			goto tr27
		case 118:
			goto tr406
		}
		switch {
		case lex.data[(lex.p)] < 65:
			if 48 <= lex.data[(lex.p)] && lex.data[(lex.p)] <= 57 {
				goto tr27
			}
		case lex.data[(lex.p)] > 90:
			if 97 <= lex.data[(lex.p)] && lex.data[(lex.p)] <= 122 {
				goto tr27
			}
		default:
			goto tr27
		}
		goto tr65
	tr406:
		lex.te = (lex.p) + 1

		lex.act = 41
		goto st336
	st336:
		if (lex.p)++; (lex.p) == (lex.pe) {
			goto _test_eof336
		}
	st_case_336:
		switch lex.data[(lex.p)] {
		case 46:
			goto st18
		case 95:
			goto tr27
		case 105:
			goto tr407
		}
		switch {
		case lex.data[(lex.p)] < 65:
			if 48 <= lex.data[(lex.p)] && lex.data[(lex.p)] <= 57 {
				goto tr27
			}
		case lex.data[(lex.p)] > 90:
			if 97 <= lex.data[(lex.p)] && lex.data[(lex.p)] <= 122 {
				goto tr27
			}
		default:
			goto tr27
		}
		goto tr65
	tr407:
		lex.te = (lex.p) + 1

		lex.act = 41
		goto st337
	st337:
		if (lex.p)++; (lex.p) == (lex.pe) {
			goto _test_eof337
		}
	st_case_337:
		switch lex.data[(lex.p)] {
		case 46:
			goto st18
		case 95:
			goto tr27
		case 99:
			goto tr408
		}
		switch {
		case lex.data[(lex.p)] < 65:
			if 48 <= lex.data[(lex.p)] && lex.data[(lex.p)] <= 57 {
				goto tr27
			}
		case lex.data[(lex.p)] > 90:
			if 97 <= lex.data[(lex.p)] && lex.data[(lex.p)] <= 122 {
				goto tr27
			}
		default:
			goto tr27
		}
		goto tr65
	tr408:
		lex.te = (lex.p) + 1

		lex.act = 41
		goto st338
	st338:
		if (lex.p)++; (lex.p) == (lex.pe) {
			goto _test_eof338
		}
	st_case_338:
		switch lex.data[(lex.p)] {
		case 46:
			goto st18
		case 95:
			goto tr27
		case 101:
			goto tr409
		}
		switch {
		case lex.data[(lex.p)] < 65:
			if 48 <= lex.data[(lex.p)] && lex.data[(lex.p)] <= 57 {
				goto tr27
			}
		case lex.data[(lex.p)] > 90:
			if 97 <= lex.data[(lex.p)] && lex.data[(lex.p)] <= 122 {
				goto tr27
			}
		default:
			goto tr27
		}
		goto tr65
	tr409:
		lex.te = (lex.p) + 1

		lex.act = 24
		goto st339
	st339:
		if (lex.p)++; (lex.p) == (lex.pe) {
			goto _test_eof339
		}
	st_case_339:
		switch lex.data[(lex.p)] {
		case 9:
			goto st340
		case 10:
			goto tr412
		case 13:
			goto st340
		case 32:
			goto st340
		case 46:
			goto st18
		case 95:
			goto tr27
		}
		switch {
		case lex.data[(lex.p)] < 65:
			if 48 <= lex.data[(lex.p)] && lex.data[(lex.p)] <= 57 {
				goto tr27
			}
		case lex.data[(lex.p)] > 90:
			if 97 <= lex.data[(lex.p)] && lex.data[(lex.p)] <= 122 {
				goto tr27
			}
		default:
			goto tr27
		}
		goto tr410
	tr412:

		lex.line++
		lex.lineStart = lex.p + 1
		lex.linesSinceDocstring++

		goto st340
	st340:
		if (lex.p)++; (lex.p) == (lex.pe) {
			goto _test_eof340
		}
	st_case_340:
		switch lex.data[(lex.p)] {
		case 9:
			goto st340
		case 10:
			goto tr412
		case 13:
			goto st340
		case 32:
			goto st340
		}
		goto tr410
	tr405:
		lex.te = (lex.p) + 1

		lex.act = 16
		goto st341
	st341:
		if (lex.p)++; (lex.p) == (lex.pe) {
			goto _test_eof341
		}
	st_case_341:
		switch lex.data[(lex.p)] {
		case 9:
			goto st342
		case 10:
			goto tr415
		case 13:
			goto st342
		case 32:
			goto st342
		case 46:
			goto st18
		case 95:
			goto tr27
		}
		switch {
		case lex.data[(lex.p)] < 65:
			if 48 <= lex.data[(lex.p)] && lex.data[(lex.p)] <= 57 {
				goto tr27
			}
		case lex.data[(lex.p)] > 90:
			if 97 <= lex.data[(lex.p)] && lex.data[(lex.p)] <= 122 {
				goto tr27
			}
		default:
			goto tr27
		}
		goto tr413
	tr415:

		lex.line++
		lex.lineStart = lex.p + 1
		lex.linesSinceDocstring++

		goto st342
	st342:
		if (lex.p)++; (lex.p) == (lex.pe) {
			goto _test_eof342
		}
	st_case_342:
		switch lex.data[(lex.p)] {
		case 9:
			goto st342
		case 10:
			goto tr415
		case 13:
			goto st342
		case 32:
			goto st342
		}
		goto tr413
	tr400:
		lex.te = (lex.p) + 1

		lex.act = 41
		goto st343
	st343:
		if (lex.p)++; (lex.p) == (lex.pe) {
			goto _test_eof343
		}
	st_case_343:
		switch lex.data[(lex.p)] {
		case 46:
			goto st18
		case 95:
			goto tr27
		case 122:
			goto tr310
		}
		switch {
		case lex.data[(lex.p)] < 65:
			if 48 <= lex.data[(lex.p)] && lex.data[(lex.p)] <= 57 {
				goto tr27
			}
		case lex.data[(lex.p)] > 90:
			if 97 <= lex.data[(lex.p)] && lex.data[(lex.p)] <= 121 {
				goto tr27
			}
		default:
			goto tr27
		}
		goto tr65
	tr401:
		lex.te = (lex.p) + 1

		lex.act = 41
		goto st344
	st344:
		if (lex.p)++; (lex.p) == (lex.pe) {
			goto _test_eof344
		}
	st_case_344:
		switch lex.data[(lex.p)] {
		case 46:
			goto st18
		case 95:
			goto tr27
		case 97:
			goto tr416
		case 114:
			goto tr417
		}
		switch {
		case lex.data[(lex.p)] < 65:
			if 48 <= lex.data[(lex.p)] && lex.data[(lex.p)] <= 57 {
				goto tr27
			}
		case lex.data[(lex.p)] > 90:
			if 98 <= lex.data[(lex.p)] && lex.data[(lex.p)] <= 122 {
				goto tr27
			}
		default:
			goto tr27
		}
		goto tr65
	tr416:
		lex.te = (lex.p) + 1

		lex.act = 41
		goto st345
	st345:
		if (lex.p)++; (lex.p) == (lex.pe) {
			goto _test_eof345
		}
	st_case_345:
		switch lex.data[(lex.p)] {
		case 46:
			goto st18
		case 95:
			goto tr27
		case 116:
			goto tr197
		}
		switch {
		case lex.data[(lex.p)] < 65:
			if 48 <= lex.data[(lex.p)] && lex.data[(lex.p)] <= 57 {
				goto tr27
			}
		case lex.data[(lex.p)] > 90:
			if 97 <= lex.data[(lex.p)] && lex.data[(lex.p)] <= 122 {
				goto tr27
			}
		default:
			goto tr27
		}
		goto tr65
	tr417:
		lex.te = (lex.p) + 1

		lex.act = 41
		goto st346
	st346:
		if (lex.p)++; (lex.p) == (lex.pe) {
			goto _test_eof346
		}
	st_case_346:
		switch lex.data[(lex.p)] {
		case 46:
			goto st18
		case 95:
			goto tr27
		case 105:
			goto tr418
		case 117:
			goto tr419
		}
		switch {
		case lex.data[(lex.p)] < 65:
			if 48 <= lex.data[(lex.p)] && lex.data[(lex.p)] <= 57 {
				goto tr27
			}
		case lex.data[(lex.p)] > 90:
			if 97 <= lex.data[(lex.p)] && lex.data[(lex.p)] <= 122 {
				goto tr27
			}
		default:
			goto tr27
		}
		goto tr65
	tr418:
		lex.te = (lex.p) + 1

		lex.act = 41
		goto st347
	st347:
		if (lex.p)++; (lex.p) == (lex.pe) {
			goto _test_eof347
		}
	st_case_347:
		switch lex.data[(lex.p)] {
		case 46:
			goto st18
		case 95:
			goto tr27
		case 110:
			goto tr420
		}
		switch {
		case lex.data[(lex.p)] < 65:
			if 48 <= lex.data[(lex.p)] && lex.data[(lex.p)] <= 57 {
				goto tr27
			}
		case lex.data[(lex.p)] > 90:
			if 97 <= lex.data[(lex.p)] && lex.data[(lex.p)] <= 122 {
				goto tr27
			}
		default:
			goto tr27
		}
		goto tr65
	tr420:
		lex.te = (lex.p) + 1

		lex.act = 41
		goto st348
	st348:
		if (lex.p)++; (lex.p) == (lex.pe) {
			goto _test_eof348
		}
	st_case_348:
		switch lex.data[(lex.p)] {
		case 46:
			goto st18
		case 95:
			goto tr27
		case 103:
			goto tr421
		}
		switch {
		case lex.data[(lex.p)] < 65:
			if 48 <= lex.data[(lex.p)] && lex.data[(lex.p)] <= 57 {
				goto tr27
			}
		case lex.data[(lex.p)] > 90:
			if 97 <= lex.data[(lex.p)] && lex.data[(lex.p)] <= 122 {
				goto tr27
			}
		default:
			goto tr27
		}
		goto tr65
	tr421:
		lex.te = (lex.p) + 1

		lex.act = 12
		goto st349
	st349:
		if (lex.p)++; (lex.p) == (lex.pe) {
			goto _test_eof349
		}
	st_case_349:
		switch lex.data[(lex.p)] {
		case 9:
			goto st350
		case 10:
			goto tr424
		case 13:
			goto st350
		case 32:
			goto st350
		case 46:
			goto st18
		case 95:
			goto tr27
		}
		switch {
		case lex.data[(lex.p)] < 65:
			if 48 <= lex.data[(lex.p)] && lex.data[(lex.p)] <= 57 {
				goto tr27
			}
		case lex.data[(lex.p)] > 90:
			if 97 <= lex.data[(lex.p)] && lex.data[(lex.p)] <= 122 {
				goto tr27
			}
		default:
			goto tr27
		}
		goto tr422
	tr424:

		lex.line++
		lex.lineStart = lex.p + 1
		lex.linesSinceDocstring++

		goto st350
	st350:
		if (lex.p)++; (lex.p) == (lex.pe) {
			goto _test_eof350
		}
	st_case_350:
		switch lex.data[(lex.p)] {
		case 9:
			goto st350
		case 10:
			goto tr424
		case 13:
			goto st350
		case 32:
			goto st350
		}
		goto tr422
	tr419:
		lex.te = (lex.p) + 1

		lex.act = 41
		goto st351
	st351:
		if (lex.p)++; (lex.p) == (lex.pe) {
			goto _test_eof351
		}
	st_case_351:
		switch lex.data[(lex.p)] {
		case 46:
			goto st18
		case 95:
			goto tr27
		case 99:
			goto tr425
		}
		switch {
		case lex.data[(lex.p)] < 65:
			if 48 <= lex.data[(lex.p)] && lex.data[(lex.p)] <= 57 {
				goto tr27
			}
		case lex.data[(lex.p)] > 90:
			if 97 <= lex.data[(lex.p)] && lex.data[(lex.p)] <= 122 {
				goto tr27
			}
		default:
			goto tr27
		}
		goto tr65
	tr425:
		lex.te = (lex.p) + 1

		lex.act = 41
		goto st352
	st352:
		if (lex.p)++; (lex.p) == (lex.pe) {
			goto _test_eof352
		}
	st_case_352:
		switch lex.data[(lex.p)] {
		case 46:
			goto st18
		case 95:
			goto tr27
		case 116:
			goto tr426
		}
		switch {
		case lex.data[(lex.p)] < 65:
			if 48 <= lex.data[(lex.p)] && lex.data[(lex.p)] <= 57 {
				goto tr27
			}
		case lex.data[(lex.p)] > 90:
			if 97 <= lex.data[(lex.p)] && lex.data[(lex.p)] <= 122 {
				goto tr27
			}
		default:
			goto tr27
		}
		goto tr65
	tr426:
		lex.te = (lex.p) + 1

		lex.act = 19
		goto st353
	st353:
		if (lex.p)++; (lex.p) == (lex.pe) {
			goto _test_eof353
		}
	st_case_353:
		switch lex.data[(lex.p)] {
		case 9:
			goto st354
		case 10:
			goto tr429
		case 13:
			goto st354
		case 32:
			goto st354
		case 46:
			goto st18
		case 95:
			goto tr27
		}
		switch {
		case lex.data[(lex.p)] < 65:
			if 48 <= lex.data[(lex.p)] && lex.data[(lex.p)] <= 57 {
				goto tr27
			}
		case lex.data[(lex.p)] > 90:
			if 97 <= lex.data[(lex.p)] && lex.data[(lex.p)] <= 122 {
				goto tr27
			}
		default:
			goto tr27
		}
		goto tr427
	tr429:

		lex.line++
		lex.lineStart = lex.p + 1
		lex.linesSinceDocstring++

		goto st354
	st354:
		if (lex.p)++; (lex.p) == (lex.pe) {
			goto _test_eof354
		}
	st_case_354:
		switch lex.data[(lex.p)] {
		case 9:
			goto st354
		case 10:
			goto tr429
		case 13:
			goto st354
		case 32:
			goto st354
		}
		goto tr427
	tr402:
		lex.te = (lex.p) + 1

		lex.act = 41
		goto st355
	st355:
		if (lex.p)++; (lex.p) == (lex.pe) {
			goto _test_eof355
		}
	st_case_355:
		switch lex.data[(lex.p)] {
		case 46:
			goto st18
		case 95:
			goto tr27
		case 112:
			goto tr388
		}
		switch {
		case lex.data[(lex.p)] < 65:
			if 48 <= lex.data[(lex.p)] && lex.data[(lex.p)] <= 57 {
				goto tr27
			}
		case lex.data[(lex.p)] > 90:
			if 97 <= lex.data[(lex.p)] && lex.data[(lex.p)] <= 122 {
				goto tr27
			}
		default:
			goto tr27
		}
		goto tr65
	tr403:
		lex.te = (lex.p) + 1

		lex.act = 41
		goto st356
	st356:
		if (lex.p)++; (lex.p) == (lex.pe) {
			goto _test_eof356
		}
	st_case_356:
		switch lex.data[(lex.p)] {
		case 46:
			goto st18
		case 95:
			goto tr27
		case 110:
			goto tr430
		}
		switch {
		case lex.data[(lex.p)] < 65:
			if 48 <= lex.data[(lex.p)] && lex.data[(lex.p)] <= 57 {
				goto tr27
			}
		case lex.data[(lex.p)] > 90:
			if 97 <= lex.data[(lex.p)] && lex.data[(lex.p)] <= 122 {
				goto tr27
			}
		default:
			goto tr27
		}
		goto tr65
	tr430:
		lex.te = (lex.p) + 1

		lex.act = 41
		goto st357
	st357:
		if (lex.p)++; (lex.p) == (lex.pe) {
			goto _test_eof357
		}
	st_case_357:
		switch lex.data[(lex.p)] {
		case 46:
			goto st18
		case 95:
			goto tr27
		case 99:
			goto tr431
		}
		switch {
		case lex.data[(lex.p)] < 65:
			if 48 <= lex.data[(lex.p)] && lex.data[(lex.p)] <= 57 {
				goto tr27
			}
		case lex.data[(lex.p)] > 90:
			if 97 <= lex.data[(lex.p)] && lex.data[(lex.p)] <= 122 {
				goto tr27
			}
		default:
			goto tr27
		}
		goto tr65
	tr431:
		lex.te = (lex.p) + 1

		lex.act = 41
		goto st358
	st358:
		if (lex.p)++; (lex.p) == (lex.pe) {
			goto _test_eof358
		}
	st_case_358:
		switch lex.data[(lex.p)] {
		case 46:
			goto st18
		case 95:
			goto tr27
		case 104:
			goto tr432
		}
		switch {
		case lex.data[(lex.p)] < 65:
			if 48 <= lex.data[(lex.p)] && lex.data[(lex.p)] <= 57 {
				goto tr27
			}
		case lex.data[(lex.p)] > 90:
			if 97 <= lex.data[(lex.p)] && lex.data[(lex.p)] <= 122 {
				goto tr27
			}
		default:
			goto tr27
		}
		goto tr65
	tr432:
		lex.te = (lex.p) + 1

		lex.act = 41
		goto st359
	st359:
		if (lex.p)++; (lex.p) == (lex.pe) {
			goto _test_eof359
		}
	st_case_359:
		switch lex.data[(lex.p)] {
		case 46:
			goto st18
		case 95:
			goto tr27
		case 114:
			goto tr433
		}
		switch {
		case lex.data[(lex.p)] < 65:
			if 48 <= lex.data[(lex.p)] && lex.data[(lex.p)] <= 57 {
				goto tr27
			}
		case lex.data[(lex.p)] > 90:
			if 97 <= lex.data[(lex.p)] && lex.data[(lex.p)] <= 122 {
				goto tr27
			}
		default:
			goto tr27
		}
		goto tr65
	tr433:
		lex.te = (lex.p) + 1

		lex.act = 41
		goto st360
	st360:
		if (lex.p)++; (lex.p) == (lex.pe) {
			goto _test_eof360
		}
	st_case_360:
		switch lex.data[(lex.p)] {
		case 46:
			goto st18
		case 95:
			goto tr27
		case 111:
			goto tr434
		}
		switch {
		case lex.data[(lex.p)] < 65:
			if 48 <= lex.data[(lex.p)] && lex.data[(lex.p)] <= 57 {
				goto tr27
			}
		case lex.data[(lex.p)] > 90:
			if 97 <= lex.data[(lex.p)] && lex.data[(lex.p)] <= 122 {
				goto tr27
			}
		default:
			goto tr27
		}
		goto tr65
	tr434:
		lex.te = (lex.p) + 1

		lex.act = 41
		goto st361
	st361:
		if (lex.p)++; (lex.p) == (lex.pe) {
			goto _test_eof361
		}
	st_case_361:
		switch lex.data[(lex.p)] {
		case 46:
			goto st18
		case 95:
			goto tr27
		case 110:
			goto tr435
		}
		switch {
		case lex.data[(lex.p)] < 65:
			if 48 <= lex.data[(lex.p)] && lex.data[(lex.p)] <= 57 {
				goto tr27
			}
		case lex.data[(lex.p)] > 90:
			if 97 <= lex.data[(lex.p)] && lex.data[(lex.p)] <= 122 {
				goto tr27
			}
		default:
			goto tr27
		}
		goto tr65
	tr435:
		lex.te = (lex.p) + 1

		lex.act = 41
		goto st362
	st362:
		if (lex.p)++; (lex.p) == (lex.pe) {
			goto _test_eof362
		}
	st_case_362:
		switch lex.data[(lex.p)] {
		case 46:
			goto st18
		case 95:
			goto tr27
		case 105:
			goto tr436
		}
		switch {
		case lex.data[(lex.p)] < 65:
			if 48 <= lex.data[(lex.p)] && lex.data[(lex.p)] <= 57 {
				goto tr27
			}
		case lex.data[(lex.p)] > 90:
			if 97 <= lex.data[(lex.p)] && lex.data[(lex.p)] <= 122 {
				goto tr27
			}
		default:
			goto tr27
		}
		goto tr65
	tr436:
		lex.te = (lex.p) + 1

		lex.act = 41
		goto st363
	st363:
		if (lex.p)++; (lex.p) == (lex.pe) {
			goto _test_eof363
		}
	st_case_363:
		switch lex.data[(lex.p)] {
		case 46:
			goto st18
		case 95:
			goto tr27
		case 122:
			goto tr377
		}
		switch {
		case lex.data[(lex.p)] < 65:
			if 48 <= lex.data[(lex.p)] && lex.data[(lex.p)] <= 57 {
				goto tr27
			}
		case lex.data[(lex.p)] > 90:
			if 97 <= lex.data[(lex.p)] && lex.data[(lex.p)] <= 121 {
				goto tr27
			}
		default:
			goto tr27
		}
		goto tr65
	tr52:
		lex.te = (lex.p) + 1

		lex.act = 41
		goto st364
	st364:
		if (lex.p)++; (lex.p) == (lex.pe) {
			goto _test_eof364
		}
	st_case_364:
		switch lex.data[(lex.p)] {
		case 46:
			goto st18
		case 95:
			goto tr27
		case 104:
			goto tr437
		case 114:
			goto tr438
		case 121:
			goto tr439
		}
		switch {
		case lex.data[(lex.p)] < 65:
			if 48 <= lex.data[(lex.p)] && lex.data[(lex.p)] <= 57 {
				goto tr27
			}
		case lex.data[(lex.p)] > 90:
			if 97 <= lex.data[(lex.p)] && lex.data[(lex.p)] <= 122 {
				goto tr27
			}
		default:
			goto tr27
		}
		goto tr65
	tr437:
		lex.te = (lex.p) + 1

		lex.act = 41
		goto st365
	st365:
		if (lex.p)++; (lex.p) == (lex.pe) {
			goto _test_eof365
		}
	st_case_365:
		switch lex.data[(lex.p)] {
		case 46:
			goto st18
		case 95:
			goto tr27
		case 101:
			goto tr127
		case 105:
			goto tr118
		case 114:
			goto tr440
		}
		switch {
		case lex.data[(lex.p)] < 65:
			if 48 <= lex.data[(lex.p)] && lex.data[(lex.p)] <= 57 {
				goto tr27
			}
		case lex.data[(lex.p)] > 90:
			if 97 <= lex.data[(lex.p)] && lex.data[(lex.p)] <= 122 {
				goto tr27
			}
		default:
			goto tr27
		}
		goto tr65
	tr440:
		lex.te = (lex.p) + 1

		lex.act = 41
		goto st366
	st366:
		if (lex.p)++; (lex.p) == (lex.pe) {
			goto _test_eof366
		}
	st_case_366:
		switch lex.data[(lex.p)] {
		case 46:
			goto st18
		case 95:
			goto tr27
		case 111:
			goto tr441
		}
		switch {
		case lex.data[(lex.p)] < 65:
			if 48 <= lex.data[(lex.p)] && lex.data[(lex.p)] <= 57 {
				goto tr27
			}
		case lex.data[(lex.p)] > 90:
			if 97 <= lex.data[(lex.p)] && lex.data[(lex.p)] <= 122 {
				goto tr27
			}
		default:
			goto tr27
		}
		goto tr65
	tr441:
		lex.te = (lex.p) + 1

		lex.act = 41
		goto st367
	st367:
		if (lex.p)++; (lex.p) == (lex.pe) {
			goto _test_eof367
		}
	st_case_367:
		switch lex.data[(lex.p)] {
		case 46:
			goto st18
		case 95:
			goto tr27
		case 119:
			goto tr442
		}
		switch {
		case lex.data[(lex.p)] < 65:
			if 48 <= lex.data[(lex.p)] && lex.data[(lex.p)] <= 57 {
				goto tr27
			}
		case lex.data[(lex.p)] > 90:
			if 97 <= lex.data[(lex.p)] && lex.data[(lex.p)] <= 122 {
				goto tr27
			}
		default:
			goto tr27
		}
		goto tr65
	tr442:
		lex.te = (lex.p) + 1

		reservedKeyword = string(lex.data[lex.ts:lex.te])
		lex.act = 40
		goto st368
	st368:
		if (lex.p)++; (lex.p) == (lex.pe) {
			goto _test_eof368
		}
	st_case_368:
		switch lex.data[(lex.p)] {
		case 9:
			goto st33
		case 10:
			goto tr73
		case 13:
			goto st33
		case 32:
			goto st33
		case 46:
			goto st18
		case 95:
			goto tr27
		case 115:
			goto tr443
		}
		switch {
		case lex.data[(lex.p)] < 65:
			if 48 <= lex.data[(lex.p)] && lex.data[(lex.p)] <= 57 {
				goto tr27
			}
		case lex.data[(lex.p)] > 90:
			if 97 <= lex.data[(lex.p)] && lex.data[(lex.p)] <= 122 {
				goto tr27
			}
		default:
			goto tr27
		}
		goto tr71
	tr443:
		lex.te = (lex.p) + 1

		lex.act = 23
		goto st369
	st369:
		if (lex.p)++; (lex.p) == (lex.pe) {
			goto _test_eof369
		}
	st_case_369:
		switch lex.data[(lex.p)] {
		case 9:
			goto st370
		case 10:
			goto tr446
		case 13:
			goto st370
		case 32:
			goto st370
		case 46:
			goto st18
		case 95:
			goto tr27
		}
		switch {
		case lex.data[(lex.p)] < 65:
			if 48 <= lex.data[(lex.p)] && lex.data[(lex.p)] <= 57 {
				goto tr27
			}
		case lex.data[(lex.p)] > 90:
			if 97 <= lex.data[(lex.p)] && lex.data[(lex.p)] <= 122 {
				goto tr27
			}
		default:
			goto tr27
		}
		goto tr444
	tr446:

		lex.line++
		lex.lineStart = lex.p + 1
		lex.linesSinceDocstring++

		goto st370
	st370:
		if (lex.p)++; (lex.p) == (lex.pe) {
			goto _test_eof370
		}
	st_case_370:
		switch lex.data[(lex.p)] {
		case 9:
			goto st370
		case 10:
			goto tr446
		case 13:
			goto st370
		case 32:
			goto st370
		}
		goto tr444
	tr438:
		lex.te = (lex.p) + 1

		lex.act = 41
		goto st371
	st371:
		if (lex.p)++; (lex.p) == (lex.pe) {
			goto _test_eof371
		}
	st_case_371:
		switch lex.data[(lex.p)] {
		case 46:
			goto st18
		case 95:
			goto tr27
		case 97:
			goto tr447
		case 117:
			goto tr448
		case 121:
			goto tr70
		}
		switch {
		case lex.data[(lex.p)] < 65:
			if 48 <= lex.data[(lex.p)] && lex.data[(lex.p)] <= 57 {
				goto tr27
			}
		case lex.data[(lex.p)] > 90:
			if 98 <= lex.data[(lex.p)] && lex.data[(lex.p)] <= 122 {
				goto tr27
			}
		default:
			goto tr27
		}
		goto tr65
	tr447:
		lex.te = (lex.p) + 1

		lex.act = 41
		goto st372
	st372:
		if (lex.p)++; (lex.p) == (lex.pe) {
			goto _test_eof372
		}
	st_case_372:
		switch lex.data[(lex.p)] {
		case 46:
			goto st18
		case 95:
			goto tr27
		case 110:
			goto tr449
		}
		switch {
		case lex.data[(lex.p)] < 65:
			if 48 <= lex.data[(lex.p)] && lex.data[(lex.p)] <= 57 {
				goto tr27
			}
		case lex.data[(lex.p)] > 90:
			if 97 <= lex.data[(lex.p)] && lex.data[(lex.p)] <= 122 {
				goto tr27
			}
		default:
			goto tr27
		}
		goto tr65
	tr449:
		lex.te = (lex.p) + 1

		lex.act = 41
		goto st373
	st373:
		if (lex.p)++; (lex.p) == (lex.pe) {
			goto _test_eof373
		}
	st_case_373:
		switch lex.data[(lex.p)] {
		case 46:
			goto st18
		case 95:
			goto tr27
		case 115:
			goto tr450
		}
		switch {
		case lex.data[(lex.p)] < 65:
			if 48 <= lex.data[(lex.p)] && lex.data[(lex.p)] <= 57 {
				goto tr27
			}
		case lex.data[(lex.p)] > 90:
			if 97 <= lex.data[(lex.p)] && lex.data[(lex.p)] <= 122 {
				goto tr27
			}
		default:
			goto tr27
		}
		goto tr65
	tr450:
		lex.te = (lex.p) + 1

		lex.act = 41
		goto st374
	st374:
		if (lex.p)++; (lex.p) == (lex.pe) {
			goto _test_eof374
		}
	st_case_374:
		switch lex.data[(lex.p)] {
		case 46:
			goto st18
		case 95:
			goto tr27
		case 105:
			goto tr451
		}
		switch {
		case lex.data[(lex.p)] < 65:
			if 48 <= lex.data[(lex.p)] && lex.data[(lex.p)] <= 57 {
				goto tr27
			}
		case lex.data[(lex.p)] > 90:
			if 97 <= lex.data[(lex.p)] && lex.data[(lex.p)] <= 122 {
				goto tr27
			}
		default:
			goto tr27
		}
		goto tr65
	tr451:
		lex.te = (lex.p) + 1

		lex.act = 41
		goto st375
	st375:
		if (lex.p)++; (lex.p) == (lex.pe) {
			goto _test_eof375
		}
	st_case_375:
		switch lex.data[(lex.p)] {
		case 46:
			goto st18
		case 95:
			goto tr27
		case 101:
			goto tr452
		}
		switch {
		case lex.data[(lex.p)] < 65:
			if 48 <= lex.data[(lex.p)] && lex.data[(lex.p)] <= 57 {
				goto tr27
			}
		case lex.data[(lex.p)] > 90:
			if 97 <= lex.data[(lex.p)] && lex.data[(lex.p)] <= 122 {
				goto tr27
			}
		default:
			goto tr27
		}
		goto tr65
	tr452:
		lex.te = (lex.p) + 1

		lex.act = 41
		goto st376
	st376:
		if (lex.p)++; (lex.p) == (lex.pe) {
			goto _test_eof376
		}
	st_case_376:
		switch lex.data[(lex.p)] {
		case 46:
			goto st18
		case 95:
			goto tr27
		case 110:
			goto tr116
		}
		switch {
		case lex.data[(lex.p)] < 65:
			if 48 <= lex.data[(lex.p)] && lex.data[(lex.p)] <= 57 {
				goto tr27
			}
		case lex.data[(lex.p)] > 90:
			if 97 <= lex.data[(lex.p)] && lex.data[(lex.p)] <= 122 {
				goto tr27
			}
		default:
			goto tr27
		}
		goto tr65
	tr448:
		lex.te = (lex.p) + 1

		lex.act = 41
		goto st377
	st377:
		if (lex.p)++; (lex.p) == (lex.pe) {
			goto _test_eof377
		}
	st_case_377:
		switch lex.data[(lex.p)] {
		case 46:
			goto st18
		case 95:
			goto tr27
		case 101:
			goto tr453
		}
		switch {
		case lex.data[(lex.p)] < 65:
			if 48 <= lex.data[(lex.p)] && lex.data[(lex.p)] <= 57 {
				goto tr27
			}
		case lex.data[(lex.p)] > 90:
			if 97 <= lex.data[(lex.p)] && lex.data[(lex.p)] <= 122 {
				goto tr27
			}
		default:
			goto tr27
		}
		goto tr65
	tr453:
		lex.te = (lex.p) + 1

		lex.act = 29
		goto st378
	st378:
		if (lex.p)++; (lex.p) == (lex.pe) {
			goto _test_eof378
		}
	st_case_378:
		switch lex.data[(lex.p)] {
		case 9:
			goto st379
		case 10:
			goto tr456
		case 13:
			goto st379
		case 32:
			goto st379
		case 46:
			goto st18
		case 95:
			goto tr27
		}
		switch {
		case lex.data[(lex.p)] < 65:
			if 48 <= lex.data[(lex.p)] && lex.data[(lex.p)] <= 57 {
				goto tr27
			}
		case lex.data[(lex.p)] > 90:
			if 97 <= lex.data[(lex.p)] && lex.data[(lex.p)] <= 122 {
				goto tr27
			}
		default:
			goto tr27
		}
		goto tr454
	tr456:

		lex.line++
		lex.lineStart = lex.p + 1
		lex.linesSinceDocstring++

		goto st379
	st379:
		if (lex.p)++; (lex.p) == (lex.pe) {
			goto _test_eof379
		}
	st_case_379:
		switch lex.data[(lex.p)] {
		case 9:
			goto st379
		case 10:
			goto tr456
		case 13:
			goto st379
		case 32:
			goto st379
		}
		goto tr454
	tr439:
		lex.te = (lex.p) + 1

		lex.act = 41
		goto st380
	st380:
		if (lex.p)++; (lex.p) == (lex.pe) {
			goto _test_eof380
		}
	st_case_380:
		switch lex.data[(lex.p)] {
		case 46:
			goto st18
		case 95:
			goto tr27
		case 112:
			goto tr457
		}
		switch {
		case lex.data[(lex.p)] < 65:
			if 48 <= lex.data[(lex.p)] && lex.data[(lex.p)] <= 57 {
				goto tr27
			}
		case lex.data[(lex.p)] > 90:
			if 97 <= lex.data[(lex.p)] && lex.data[(lex.p)] <= 122 {
				goto tr27
			}
		default:
			goto tr27
		}
		goto tr65
	tr457:
		lex.te = (lex.p) + 1

		lex.act = 41
		goto st381
	st381:
		if (lex.p)++; (lex.p) == (lex.pe) {
			goto _test_eof381
		}
	st_case_381:
		switch lex.data[(lex.p)] {
		case 46:
			goto st18
		case 95:
			goto tr27
		case 101:
			goto tr458
		}
		switch {
		case lex.data[(lex.p)] < 65:
			if 48 <= lex.data[(lex.p)] && lex.data[(lex.p)] <= 57 {
				goto tr27
			}
		case lex.data[(lex.p)] > 90:
			if 97 <= lex.data[(lex.p)] && lex.data[(lex.p)] <= 122 {
				goto tr27
			}
		default:
			goto tr27
		}
		goto tr65
	tr458:
		lex.te = (lex.p) + 1

		lex.act = 41
		goto st382
	st382:
		if (lex.p)++; (lex.p) == (lex.pe) {
			goto _test_eof382
		}
	st_case_382:
		switch lex.data[(lex.p)] {
		case 46:
			goto st18
		case 95:
			goto tr27
		case 100:
			goto tr459
		}
		switch {
		case lex.data[(lex.p)] < 65:
			if 48 <= lex.data[(lex.p)] && lex.data[(lex.p)] <= 57 {
				goto tr27
			}
		case lex.data[(lex.p)] > 90:
			if 97 <= lex.data[(lex.p)] && lex.data[(lex.p)] <= 122 {
				goto tr27
			}
		default:
			goto tr27
		}
		goto tr65
	tr459:
		lex.te = (lex.p) + 1

		lex.act = 41
		goto st383
	st383:
		if (lex.p)++; (lex.p) == (lex.pe) {
			goto _test_eof383
		}
	st_case_383:
		switch lex.data[(lex.p)] {
		case 46:
			goto st18
		case 95:
			goto tr27
		case 101:
			goto tr460
		}
		switch {
		case lex.data[(lex.p)] < 65:
			if 48 <= lex.data[(lex.p)] && lex.data[(lex.p)] <= 57 {
				goto tr27
			}
		case lex.data[(lex.p)] > 90:
			if 97 <= lex.data[(lex.p)] && lex.data[(lex.p)] <= 122 {
				goto tr27
			}
		default:
			goto tr27
		}
		goto tr65
	tr460:
		lex.te = (lex.p) + 1

		lex.act = 41
		goto st384
	st384:
		if (lex.p)++; (lex.p) == (lex.pe) {
			goto _test_eof384
		}
	st_case_384:
		switch lex.data[(lex.p)] {
		case 46:
			goto st18
		case 95:
			goto tr27
		case 102:
			goto tr461
		}
		switch {
		case lex.data[(lex.p)] < 65:
			if 48 <= lex.data[(lex.p)] && lex.data[(lex.p)] <= 57 {
				goto tr27
			}
		case lex.data[(lex.p)] > 90:
			if 97 <= lex.data[(lex.p)] && lex.data[(lex.p)] <= 122 {
				goto tr27
			}
		default:
			goto tr27
		}
		goto tr65
	tr461:
		lex.te = (lex.p) + 1

		lex.act = 18
		goto st385
	st385:
		if (lex.p)++; (lex.p) == (lex.pe) {
			goto _test_eof385
		}
	st_case_385:
		switch lex.data[(lex.p)] {
		case 9:
			goto st386
		case 10:
			goto tr464
		case 13:
			goto st386
		case 32:
			goto st386
		case 46:
			goto st18
		case 95:
			goto tr27
		}
		switch {
		case lex.data[(lex.p)] < 65:
			if 48 <= lex.data[(lex.p)] && lex.data[(lex.p)] <= 57 {
				goto tr27
			}
		case lex.data[(lex.p)] > 90:
			if 97 <= lex.data[(lex.p)] && lex.data[(lex.p)] <= 122 {
				goto tr27
			}
		default:
			goto tr27
		}
		goto tr462
	tr464:

		lex.line++
		lex.lineStart = lex.p + 1
		lex.linesSinceDocstring++

		goto st386
	st386:
		if (lex.p)++; (lex.p) == (lex.pe) {
			goto _test_eof386
		}
	st_case_386:
		switch lex.data[(lex.p)] {
		case 9:
			goto st386
		case 10:
			goto tr464
		case 13:
			goto st386
		case 32:
			goto st386
		}
		goto tr462
	tr53:
		lex.te = (lex.p) + 1

		lex.act = 41
		goto st387
	st387:
		if (lex.p)++; (lex.p) == (lex.pe) {
			goto _test_eof387
		}
	st_case_387:
		switch lex.data[(lex.p)] {
		case 46:
			goto st18
		case 95:
			goto tr27
		case 110:
			goto tr465
		case 115:
			goto tr151
		}
		switch {
		case lex.data[(lex.p)] < 65:
			if 48 <= lex.data[(lex.p)] && lex.data[(lex.p)] <= 57 {
				goto tr27
			}
		case lex.data[(lex.p)] > 90:
			if 97 <= lex.data[(lex.p)] && lex.data[(lex.p)] <= 122 {
				goto tr27
			}
		default:
			goto tr27
		}
		goto tr65
	tr465:
		lex.te = (lex.p) + 1

		lex.act = 41
		goto st388
	st388:
		if (lex.p)++; (lex.p) == (lex.pe) {
			goto _test_eof388
		}
	st_case_388:
		switch lex.data[(lex.p)] {
		case 46:
			goto st18
		case 95:
			goto tr27
		case 100:
			goto tr466
		case 105:
			goto tr467
		case 108:
			goto tr468
		case 115:
			goto tr469
		case 116:
			goto tr470
		}
		switch {
		case lex.data[(lex.p)] < 65:
			if 48 <= lex.data[(lex.p)] && lex.data[(lex.p)] <= 57 {
				goto tr27
			}
		case lex.data[(lex.p)] > 90:
			if 97 <= lex.data[(lex.p)] && lex.data[(lex.p)] <= 122 {
				goto tr27
			}
		default:
			goto tr27
		}
		goto tr65
	tr466:
		lex.te = (lex.p) + 1

		lex.act = 41
		goto st389
	st389:
		if (lex.p)++; (lex.p) == (lex.pe) {
			goto _test_eof389
		}
	st_case_389:
		switch lex.data[(lex.p)] {
		case 46:
			goto st18
		case 95:
			goto tr27
		case 101:
			goto tr202
		}
		switch {
		case lex.data[(lex.p)] < 65:
			if 48 <= lex.data[(lex.p)] && lex.data[(lex.p)] <= 57 {
				goto tr27
			}
		case lex.data[(lex.p)] > 90:
			if 97 <= lex.data[(lex.p)] && lex.data[(lex.p)] <= 122 {
				goto tr27
			}
		default:
			goto tr27
		}
		goto tr65
	tr467:
		lex.te = (lex.p) + 1

		lex.act = 41
		goto st390
	st390:
		if (lex.p)++; (lex.p) == (lex.pe) {
			goto _test_eof390
		}
	st_case_390:
		switch lex.data[(lex.p)] {
		case 46:
			goto st18
		case 95:
			goto tr27
		case 111:
			goto tr471
		}
		switch {
		case lex.data[(lex.p)] < 65:
			if 48 <= lex.data[(lex.p)] && lex.data[(lex.p)] <= 57 {
				goto tr27
			}
		case lex.data[(lex.p)] > 90:
			if 97 <= lex.data[(lex.p)] && lex.data[(lex.p)] <= 122 {
				goto tr27
			}
		default:
			goto tr27
		}
		goto tr65
	tr471:
		lex.te = (lex.p) + 1

		lex.act = 41
		goto st391
	st391:
		if (lex.p)++; (lex.p) == (lex.pe) {
			goto _test_eof391
		}
	st_case_391:
		switch lex.data[(lex.p)] {
		case 46:
			goto st18
		case 95:
			goto tr27
		case 110:
			goto tr472
		}
		switch {
		case lex.data[(lex.p)] < 65:
			if 48 <= lex.data[(lex.p)] && lex.data[(lex.p)] <= 57 {
				goto tr27
			}
		case lex.data[(lex.p)] > 90:
			if 97 <= lex.data[(lex.p)] && lex.data[(lex.p)] <= 122 {
				goto tr27
			}
		default:
			goto tr27
		}
		goto tr65
	tr472:
		lex.te = (lex.p) + 1

		lex.act = 20
		goto st392
	st392:
		if (lex.p)++; (lex.p) == (lex.pe) {
			goto _test_eof392
		}
	st_case_392:
		switch lex.data[(lex.p)] {
		case 9:
			goto st393
		case 10:
			goto tr475
		case 13:
			goto st393
		case 32:
			goto st393
		case 46:
			goto st18
		case 95:
			goto tr27
		}
		switch {
		case lex.data[(lex.p)] < 65:
			if 48 <= lex.data[(lex.p)] && lex.data[(lex.p)] <= 57 {
				goto tr27
			}
		case lex.data[(lex.p)] > 90:
			if 97 <= lex.data[(lex.p)] && lex.data[(lex.p)] <= 122 {
				goto tr27
			}
		default:
			goto tr27
		}
		goto tr473
	tr475:

		lex.line++
		lex.lineStart = lex.p + 1
		lex.linesSinceDocstring++

		goto st393
	st393:
		if (lex.p)++; (lex.p) == (lex.pe) {
			goto _test_eof393
		}
	st_case_393:
		switch lex.data[(lex.p)] {
		case 9:
			goto st393
		case 10:
			goto tr475
		case 13:
			goto st393
		case 32:
			goto st393
		}
		goto tr473
	tr468:
		lex.te = (lex.p) + 1

		lex.act = 41
		goto st394
	st394:
		if (lex.p)++; (lex.p) == (lex.pe) {
			goto _test_eof394
		}
	st_case_394:
		switch lex.data[(lex.p)] {
		case 46:
			goto st18
		case 95:
			goto tr27
		case 101:
			goto tr154
		}
		switch {
		case lex.data[(lex.p)] < 65:
			if 48 <= lex.data[(lex.p)] && lex.data[(lex.p)] <= 57 {
				goto tr27
			}
		case lex.data[(lex.p)] > 90:
			if 97 <= lex.data[(lex.p)] && lex.data[(lex.p)] <= 122 {
				goto tr27
			}
		default:
			goto tr27
		}
		goto tr65
	tr469:
		lex.te = (lex.p) + 1

		lex.act = 41
		goto st395
	st395:
		if (lex.p)++; (lex.p) == (lex.pe) {
			goto _test_eof395
		}
	st_case_395:
		switch lex.data[(lex.p)] {
		case 46:
			goto st18
		case 95:
			goto tr27
		case 105:
			goto tr476
		}
		switch {
		case lex.data[(lex.p)] < 65:
			if 48 <= lex.data[(lex.p)] && lex.data[(lex.p)] <= 57 {
				goto tr27
			}
		case lex.data[(lex.p)] > 90:
			if 97 <= lex.data[(lex.p)] && lex.data[(lex.p)] <= 122 {
				goto tr27
			}
		default:
			goto tr27
		}
		goto tr65
	tr476:
		lex.te = (lex.p) + 1

		lex.act = 41
		goto st396
	st396:
		if (lex.p)++; (lex.p) == (lex.pe) {
			goto _test_eof396
		}
	st_case_396:
		switch lex.data[(lex.p)] {
		case 46:
			goto st18
		case 95:
			goto tr27
		case 103:
			goto tr477
		}
		switch {
		case lex.data[(lex.p)] < 65:
			if 48 <= lex.data[(lex.p)] && lex.data[(lex.p)] <= 57 {
				goto tr27
			}
		case lex.data[(lex.p)] > 90:
			if 97 <= lex.data[(lex.p)] && lex.data[(lex.p)] <= 122 {
				goto tr27
			}
		default:
			goto tr27
		}
		goto tr65
	tr477:
		lex.te = (lex.p) + 1

		lex.act = 41
		goto st397
	st397:
		if (lex.p)++; (lex.p) == (lex.pe) {
			goto _test_eof397
		}
	st_case_397:
		switch lex.data[(lex.p)] {
		case 46:
			goto st18
		case 95:
			goto tr27
		case 110:
			goto tr377
		}
		switch {
		case lex.data[(lex.p)] < 65:
			if 48 <= lex.data[(lex.p)] && lex.data[(lex.p)] <= 57 {
				goto tr27
			}
		case lex.data[(lex.p)] > 90:
			if 97 <= lex.data[(lex.p)] && lex.data[(lex.p)] <= 122 {
				goto tr27
			}
		default:
			goto tr27
		}
		goto tr65
	tr470:
		lex.te = (lex.p) + 1

		lex.act = 41
		goto st398
	st398:
		if (lex.p)++; (lex.p) == (lex.pe) {
			goto _test_eof398
		}
	st_case_398:
		switch lex.data[(lex.p)] {
		case 46:
			goto st18
		case 95:
			goto tr27
		case 105:
			goto tr267
		}
		switch {
		case lex.data[(lex.p)] < 65:
			if 48 <= lex.data[(lex.p)] && lex.data[(lex.p)] <= 57 {
				goto tr27
			}
		case lex.data[(lex.p)] > 90:
			if 97 <= lex.data[(lex.p)] && lex.data[(lex.p)] <= 122 {
				goto tr27
			}
		default:
			goto tr27
		}
		goto tr65
	tr54:
		lex.te = (lex.p) + 1

		lex.act = 41
		goto st399
	st399:
		if (lex.p)++; (lex.p) == (lex.pe) {
			goto _test_eof399
		}
	st_case_399:
		switch lex.data[(lex.p)] {
		case 46:
			goto st18
		case 95:
			goto tr27
		case 97:
			goto tr389
		case 105:
			goto tr478
		case 111:
			goto tr479
		}
		switch {
		case lex.data[(lex.p)] < 65:
			if 48 <= lex.data[(lex.p)] && lex.data[(lex.p)] <= 57 {
				goto tr27
			}
		case lex.data[(lex.p)] > 90:
			if 98 <= lex.data[(lex.p)] && lex.data[(lex.p)] <= 122 {
				goto tr27
			}
		default:
			goto tr27
		}
		goto tr65
	tr478:
		lex.te = (lex.p) + 1

		lex.act = 41
		goto st400
	st400:
		if (lex.p)++; (lex.p) == (lex.pe) {
			goto _test_eof400
		}
	st_case_400:
		switch lex.data[(lex.p)] {
		case 46:
			goto st18
		case 95:
			goto tr27
		case 114:
			goto tr480
		}
		switch {
		case lex.data[(lex.p)] < 65:
			if 48 <= lex.data[(lex.p)] && lex.data[(lex.p)] <= 57 {
				goto tr27
			}
		case lex.data[(lex.p)] > 90:
			if 97 <= lex.data[(lex.p)] && lex.data[(lex.p)] <= 122 {
				goto tr27
			}
		default:
			goto tr27
		}
		goto tr65
	tr480:
		lex.te = (lex.p) + 1

		lex.act = 41
		goto st401
	st401:
		if (lex.p)++; (lex.p) == (lex.pe) {
			goto _test_eof401
		}
	st_case_401:
		switch lex.data[(lex.p)] {
		case 46:
			goto st18
		case 95:
			goto tr27
		case 116:
			goto tr481
		}
		switch {
		case lex.data[(lex.p)] < 65:
			if 48 <= lex.data[(lex.p)] && lex.data[(lex.p)] <= 57 {
				goto tr27
			}
		case lex.data[(lex.p)] > 90:
			if 97 <= lex.data[(lex.p)] && lex.data[(lex.p)] <= 122 {
				goto tr27
			}
		default:
			goto tr27
		}
		goto tr65
	tr481:
		lex.te = (lex.p) + 1

		lex.act = 41
		goto st402
	st402:
		if (lex.p)++; (lex.p) == (lex.pe) {
			goto _test_eof402
		}
	st_case_402:
		switch lex.data[(lex.p)] {
		case 46:
			goto st18
		case 95:
			goto tr27
		case 117:
			goto tr266
		}
		switch {
		case lex.data[(lex.p)] < 65:
			if 48 <= lex.data[(lex.p)] && lex.data[(lex.p)] <= 57 {
				goto tr27
			}
		case lex.data[(lex.p)] > 90:
			if 97 <= lex.data[(lex.p)] && lex.data[(lex.p)] <= 122 {
				goto tr27
			}
		default:
			goto tr27
		}
		goto tr65
	tr479:
		lex.te = (lex.p) + 1

		lex.act = 41
		goto st403
	st403:
		if (lex.p)++; (lex.p) == (lex.pe) {
			goto _test_eof403
		}
	st_case_403:
		switch lex.data[(lex.p)] {
		case 46:
			goto st18
		case 95:
			goto tr27
		case 105:
			goto tr482
		case 108:
			goto tr483
		}
		switch {
		case lex.data[(lex.p)] < 65:
			if 48 <= lex.data[(lex.p)] && lex.data[(lex.p)] <= 57 {
				goto tr27
			}
		case lex.data[(lex.p)] > 90:
			if 97 <= lex.data[(lex.p)] && lex.data[(lex.p)] <= 122 {
				goto tr27
			}
		default:
			goto tr27
		}
		goto tr65
	tr482:
		lex.te = (lex.p) + 1

		lex.act = 41
		goto st404
	st404:
		if (lex.p)++; (lex.p) == (lex.pe) {
			goto _test_eof404
		}
	st_case_404:
		switch lex.data[(lex.p)] {
		case 46:
			goto st18
		case 95:
			goto tr27
		case 100:
			goto tr484
		}
		switch {
		case lex.data[(lex.p)] < 65:
			if 48 <= lex.data[(lex.p)] && lex.data[(lex.p)] <= 57 {
				goto tr27
			}
		case lex.data[(lex.p)] > 90:
			if 97 <= lex.data[(lex.p)] && lex.data[(lex.p)] <= 122 {
				goto tr27
			}
		default:
			goto tr27
		}
		goto tr65
	tr484:
		lex.te = (lex.p) + 1

		lex.act = 4
		goto st405
	st405:
		if (lex.p)++; (lex.p) == (lex.pe) {
			goto _test_eof405
		}
	st_case_405:
		switch lex.data[(lex.p)] {
		case 9:
			goto st406
		case 10:
			goto tr487
		case 13:
			goto st406
		case 32:
			goto st406
		case 46:
			goto st18
		case 95:
			goto tr27
		}
		switch {
		case lex.data[(lex.p)] < 65:
			if 48 <= lex.data[(lex.p)] && lex.data[(lex.p)] <= 57 {
				goto tr27
			}
		case lex.data[(lex.p)] > 90:
			if 97 <= lex.data[(lex.p)] && lex.data[(lex.p)] <= 122 {
				goto tr27
			}
		default:
			goto tr27
		}
		goto tr485
	tr487:

		lex.line++
		lex.lineStart = lex.p + 1
		lex.linesSinceDocstring++

		goto st406
	st406:
		if (lex.p)++; (lex.p) == (lex.pe) {
			goto _test_eof406
		}
	st_case_406:
		switch lex.data[(lex.p)] {
		case 9:
			goto st406
		case 10:
			goto tr487
		case 13:
			goto st406
		case 32:
			goto st406
		}
		goto tr485
	tr483:
		lex.te = (lex.p) + 1

		lex.act = 41
		goto st407
	st407:
		if (lex.p)++; (lex.p) == (lex.pe) {
			goto _test_eof407
		}
	st_case_407:
		switch lex.data[(lex.p)] {
		case 46:
			goto st18
		case 95:
			goto tr27
		case 97:
			goto tr488
		}
		switch {
		case lex.data[(lex.p)] < 65:
			if 48 <= lex.data[(lex.p)] && lex.data[(lex.p)] <= 57 {
				goto tr27
			}
		case lex.data[(lex.p)] > 90:
			if 98 <= lex.data[(lex.p)] && lex.data[(lex.p)] <= 122 {
				goto tr27
			}
		default:
			goto tr27
		}
		goto tr65
	tr488:
		lex.te = (lex.p) + 1

		lex.act = 41
		goto st408
	st408:
		if (lex.p)++; (lex.p) == (lex.pe) {
			goto _test_eof408
		}
	st_case_408:
		switch lex.data[(lex.p)] {
		case 46:
			goto st18
		case 95:
			goto tr27
		case 116:
			goto tr218
		}
		switch {
		case lex.data[(lex.p)] < 65:
			if 48 <= lex.data[(lex.p)] && lex.data[(lex.p)] <= 57 {
				goto tr27
			}
		case lex.data[(lex.p)] > 90:
			if 97 <= lex.data[(lex.p)] && lex.data[(lex.p)] <= 122 {
				goto tr27
			}
		default:
			goto tr27
		}
		goto tr65
	tr55:
		lex.te = (lex.p) + 1

		lex.act = 41
		goto st409
	st409:
		if (lex.p)++; (lex.p) == (lex.pe) {
			goto _test_eof409
		}
	st_case_409:
		switch lex.data[(lex.p)] {
		case 46:
			goto st18
		case 95:
			goto tr27
		case 104:
			goto tr489
		case 105:
			goto tr490
		}
		switch {
		case lex.data[(lex.p)] < 65:
			if 48 <= lex.data[(lex.p)] && lex.data[(lex.p)] <= 57 {
				goto tr27
			}
		case lex.data[(lex.p)] > 90:
			if 97 <= lex.data[(lex.p)] && lex.data[(lex.p)] <= 122 {
				goto tr27
			}
		default:
			goto tr27
		}
		goto tr65
	tr489:
		lex.te = (lex.p) + 1

		lex.act = 41
		goto st410
	st410:
		if (lex.p)++; (lex.p) == (lex.pe) {
			goto _test_eof410
		}
	st_case_410:
		switch lex.data[(lex.p)] {
		case 46:
			goto st18
		case 95:
			goto tr27
		case 101:
			goto tr127
		case 105:
			goto tr219
		}
		switch {
		case lex.data[(lex.p)] < 65:
			if 48 <= lex.data[(lex.p)] && lex.data[(lex.p)] <= 57 {
				goto tr27
			}
		case lex.data[(lex.p)] > 90:
			if 97 <= lex.data[(lex.p)] && lex.data[(lex.p)] <= 122 {
				goto tr27
			}
		default:
			goto tr27
		}
		goto tr65
	tr490:
		lex.te = (lex.p) + 1

		lex.act = 41
		goto st411
	st411:
		if (lex.p)++; (lex.p) == (lex.pe) {
			goto _test_eof411
		}
	st_case_411:
		switch lex.data[(lex.p)] {
		case 46:
			goto st18
		case 95:
			goto tr27
		case 116:
			goto tr153
		}
		switch {
		case lex.data[(lex.p)] < 65:
			if 48 <= lex.data[(lex.p)] && lex.data[(lex.p)] <= 57 {
				goto tr27
			}
		case lex.data[(lex.p)] > 90:
			if 97 <= lex.data[(lex.p)] && lex.data[(lex.p)] <= 122 {
				goto tr27
			}
		default:
			goto tr27
		}
		goto tr65
	tr56:
		lex.te = (lex.p) + 1

		lex.act = 41
		goto st412
	st412:
		if (lex.p)++; (lex.p) == (lex.pe) {
			goto _test_eof412
		}
	st_case_412:
		switch lex.data[(lex.p)] {
		case 46:
			goto st18
		case 95:
			goto tr27
		case 111:
			goto tr389
		}
		switch {
		case lex.data[(lex.p)] < 65:
			if 48 <= lex.data[(lex.p)] && lex.data[(lex.p)] <= 57 {
				goto tr27
			}
		case lex.data[(lex.p)] > 90:
			if 97 <= lex.data[(lex.p)] && lex.data[(lex.p)] <= 122 {
				goto tr27
			}
		default:
			goto tr27
		}
		goto tr65
	tr57:
		lex.te = (lex.p) + 1

		lex.act = 41
		goto st413
	st413:
		if (lex.p)++; (lex.p) == (lex.pe) {
			goto _test_eof413
		}
	st_case_413:
		switch lex.data[(lex.p)] {
		case 46:
			goto st18
		case 95:
			goto tr27
		case 105:
			goto tr491
		}
		switch {
		case lex.data[(lex.p)] < 65:
			if 48 <= lex.data[(lex.p)] && lex.data[(lex.p)] <= 57 {
				goto tr27
			}
		case lex.data[(lex.p)] > 90:
			if 97 <= lex.data[(lex.p)] && lex.data[(lex.p)] <= 122 {
				goto tr27
			}
		default:
			goto tr27
		}
		goto tr65
	tr491:
		lex.te = (lex.p) + 1

		lex.act = 41
		goto st414
	st414:
		if (lex.p)++; (lex.p) == (lex.pe) {
			goto _test_eof414
		}
	st_case_414:
		switch lex.data[(lex.p)] {
		case 46:
			goto st18
		case 95:
			goto tr27
		case 101:
			goto tr492
		}
		switch {
		case lex.data[(lex.p)] < 65:
			if 48 <= lex.data[(lex.p)] && lex.data[(lex.p)] <= 57 {
				goto tr27
			}
		case lex.data[(lex.p)] > 90:
			if 97 <= lex.data[(lex.p)] && lex.data[(lex.p)] <= 122 {
				goto tr27
			}
		default:
			goto tr27
		}
		goto tr65
	tr492:
		lex.te = (lex.p) + 1

		lex.act = 41
		goto st415
	st415:
		if (lex.p)++; (lex.p) == (lex.pe) {
			goto _test_eof415
		}
	st_case_415:
		switch lex.data[(lex.p)] {
		case 46:
			goto st18
		case 95:
			goto tr27
		case 108:
			goto tr109
		}
		switch {
		case lex.data[(lex.p)] < 65:
			if 48 <= lex.data[(lex.p)] && lex.data[(lex.p)] <= 57 {
				goto tr27
			}
		case lex.data[(lex.p)] > 90:
			if 97 <= lex.data[(lex.p)] && lex.data[(lex.p)] <= 122 {
				goto tr27
			}
		default:
			goto tr27
		}
		goto tr65
	st_out:
	_test_eof19:
		lex.cs = 19
		goto _test_eof
	_test_eof1:
		lex.cs = 1
		goto _test_eof
	_test_eof2:
		lex.cs = 2
		goto _test_eof
	_test_eof20:
		lex.cs = 20
		goto _test_eof
	_test_eof3:
		lex.cs = 3
		goto _test_eof
	_test_eof4:
		lex.cs = 4
		goto _test_eof
	_test_eof5:
		lex.cs = 5
		goto _test_eof
	_test_eof21:
		lex.cs = 21
		goto _test_eof
	_test_eof22:
		lex.cs = 22
		goto _test_eof
	_test_eof6:
		lex.cs = 6
		goto _test_eof
	_test_eof7:
		lex.cs = 7
		goto _test_eof
	_test_eof23:
		lex.cs = 23
		goto _test_eof
	_test_eof8:
		lex.cs = 8
		goto _test_eof
	_test_eof9:
		lex.cs = 9
		goto _test_eof
	_test_eof10:
		lex.cs = 10
		goto _test_eof
	_test_eof11:
		lex.cs = 11
		goto _test_eof
	_test_eof12:
		lex.cs = 12
		goto _test_eof
	_test_eof13:
		lex.cs = 13
		goto _test_eof
	_test_eof14:
		lex.cs = 14
		goto _test_eof
	_test_eof24:
		lex.cs = 24
		goto _test_eof
	_test_eof15:
		lex.cs = 15
		goto _test_eof
	_test_eof16:
		lex.cs = 16
		goto _test_eof
	_test_eof25:
		lex.cs = 25
		goto _test_eof
	_test_eof17:
		lex.cs = 17
		goto _test_eof
	_test_eof26:
		lex.cs = 26
		goto _test_eof
	_test_eof27:
		lex.cs = 27
		goto _test_eof
	_test_eof18:
		lex.cs = 18
		goto _test_eof
	_test_eof28:
		lex.cs = 28
		goto _test_eof
	_test_eof29:
		lex.cs = 29
		goto _test_eof
	_test_eof30:
		lex.cs = 30
		goto _test_eof
	_test_eof31:
		lex.cs = 31
		goto _test_eof
	_test_eof32:
		lex.cs = 32
		goto _test_eof
	_test_eof33:
		lex.cs = 33
		goto _test_eof
	_test_eof34:
		lex.cs = 34
		goto _test_eof
	_test_eof35:
		lex.cs = 35
		goto _test_eof
	_test_eof36:
		lex.cs = 36
		goto _test_eof
	_test_eof37:
		lex.cs = 37
		goto _test_eof
	_test_eof38:
		lex.cs = 38
		goto _test_eof
	_test_eof39:
		lex.cs = 39
		goto _test_eof
	_test_eof40:
		lex.cs = 40
		goto _test_eof
	_test_eof41:
		lex.cs = 41
		goto _test_eof
	_test_eof42:
		lex.cs = 42
		goto _test_eof
	_test_eof43:
		lex.cs = 43
		goto _test_eof
	_test_eof44:
		lex.cs = 44
		goto _test_eof
	_test_eof45:
		lex.cs = 45
		goto _test_eof
	_test_eof46:
		lex.cs = 46
		goto _test_eof
	_test_eof47:
		lex.cs = 47
		goto _test_eof
	_test_eof48:
		lex.cs = 48
		goto _test_eof
	_test_eof49:
		lex.cs = 49
		goto _test_eof
	_test_eof50:
		lex.cs = 50
		goto _test_eof
	_test_eof51:
		lex.cs = 51
		goto _test_eof
	_test_eof52:
		lex.cs = 52
		goto _test_eof
	_test_eof53:
		lex.cs = 53
		goto _test_eof
	_test_eof54:
		lex.cs = 54
		goto _test_eof
	_test_eof55:
		lex.cs = 55
		goto _test_eof
	_test_eof56:
		lex.cs = 56
		goto _test_eof
	_test_eof57:
		lex.cs = 57
		goto _test_eof
	_test_eof58:
		lex.cs = 58
		goto _test_eof
	_test_eof59:
		lex.cs = 59
		goto _test_eof
	_test_eof60:
		lex.cs = 60
		goto _test_eof
	_test_eof61:
		lex.cs = 61
		goto _test_eof
	_test_eof62:
		lex.cs = 62
		goto _test_eof
	_test_eof63:
		lex.cs = 63
		goto _test_eof
	_test_eof64:
		lex.cs = 64
		goto _test_eof
	_test_eof65:
		lex.cs = 65
		goto _test_eof
	_test_eof66:
		lex.cs = 66
		goto _test_eof
	_test_eof67:
		lex.cs = 67
		goto _test_eof
	_test_eof68:
		lex.cs = 68
		goto _test_eof
	_test_eof69:
		lex.cs = 69
		goto _test_eof
	_test_eof70:
		lex.cs = 70
		goto _test_eof
	_test_eof71:
		lex.cs = 71
		goto _test_eof
	_test_eof72:
		lex.cs = 72
		goto _test_eof
	_test_eof73:
		lex.cs = 73
		goto _test_eof
	_test_eof74:
		lex.cs = 74
		goto _test_eof
	_test_eof75:
		lex.cs = 75
		goto _test_eof
	_test_eof76:
		lex.cs = 76
		goto _test_eof
	_test_eof77:
		lex.cs = 77
		goto _test_eof
	_test_eof78:
		lex.cs = 78
		goto _test_eof
	_test_eof79:
		lex.cs = 79
		goto _test_eof
	_test_eof80:
		lex.cs = 80
		goto _test_eof
	_test_eof81:
		lex.cs = 81
		goto _test_eof
	_test_eof82:
		lex.cs = 82
		goto _test_eof
	_test_eof83:
		lex.cs = 83
		goto _test_eof
	_test_eof84:
		lex.cs = 84
		goto _test_eof
	_test_eof85:
		lex.cs = 85
		goto _test_eof
	_test_eof86:
		lex.cs = 86
		goto _test_eof
	_test_eof87:
		lex.cs = 87
		goto _test_eof
	_test_eof88:
		lex.cs = 88
		goto _test_eof
	_test_eof89:
		lex.cs = 89
		goto _test_eof
	_test_eof90:
		lex.cs = 90
		goto _test_eof
	_test_eof91:
		lex.cs = 91
		goto _test_eof
	_test_eof92:
		lex.cs = 92
		goto _test_eof
	_test_eof93:
		lex.cs = 93
		goto _test_eof
	_test_eof94:
		lex.cs = 94
		goto _test_eof
	_test_eof95:
		lex.cs = 95
		goto _test_eof
	_test_eof96:
		lex.cs = 96
		goto _test_eof
	_test_eof97:
		lex.cs = 97
		goto _test_eof
	_test_eof98:
		lex.cs = 98
		goto _test_eof
	_test_eof99:
		lex.cs = 99
		goto _test_eof
	_test_eof100:
		lex.cs = 100
		goto _test_eof
	_test_eof101:
		lex.cs = 101
		goto _test_eof
	_test_eof102:
		lex.cs = 102
		goto _test_eof
	_test_eof103:
		lex.cs = 103
		goto _test_eof
	_test_eof104:
		lex.cs = 104
		goto _test_eof
	_test_eof105:
		lex.cs = 105
		goto _test_eof
	_test_eof106:
		lex.cs = 106
		goto _test_eof
	_test_eof107:
		lex.cs = 107
		goto _test_eof
	_test_eof108:
		lex.cs = 108
		goto _test_eof
	_test_eof109:
		lex.cs = 109
		goto _test_eof
	_test_eof110:
		lex.cs = 110
		goto _test_eof
	_test_eof111:
		lex.cs = 111
		goto _test_eof
	_test_eof112:
		lex.cs = 112
		goto _test_eof
	_test_eof113:
		lex.cs = 113
		goto _test_eof
	_test_eof114:
		lex.cs = 114
		goto _test_eof
	_test_eof115:
		lex.cs = 115
		goto _test_eof
	_test_eof116:
		lex.cs = 116
		goto _test_eof
	_test_eof117:
		lex.cs = 117
		goto _test_eof
	_test_eof118:
		lex.cs = 118
		goto _test_eof
	_test_eof119:
		lex.cs = 119
		goto _test_eof
	_test_eof120:
		lex.cs = 120
		goto _test_eof
	_test_eof121:
		lex.cs = 121
		goto _test_eof
	_test_eof122:
		lex.cs = 122
		goto _test_eof
	_test_eof123:
		lex.cs = 123
		goto _test_eof
	_test_eof124:
		lex.cs = 124
		goto _test_eof
	_test_eof125:
		lex.cs = 125
		goto _test_eof
	_test_eof126:
		lex.cs = 126
		goto _test_eof
	_test_eof127:
		lex.cs = 127
		goto _test_eof
	_test_eof128:
		lex.cs = 128
		goto _test_eof
	_test_eof129:
		lex.cs = 129
		goto _test_eof
	_test_eof130:
		lex.cs = 130
		goto _test_eof
	_test_eof131:
		lex.cs = 131
		goto _test_eof
	_test_eof132:
		lex.cs = 132
		goto _test_eof
	_test_eof133:
		lex.cs = 133
		goto _test_eof
	_test_eof134:
		lex.cs = 134
		goto _test_eof
	_test_eof135:
		lex.cs = 135
		goto _test_eof
	_test_eof136:
		lex.cs = 136
		goto _test_eof
	_test_eof137:
		lex.cs = 137
		goto _test_eof
	_test_eof138:
		lex.cs = 138
		goto _test_eof
	_test_eof139:
		lex.cs = 139
		goto _test_eof
	_test_eof140:
		lex.cs = 140
		goto _test_eof
	_test_eof141:
		lex.cs = 141
		goto _test_eof
	_test_eof142:
		lex.cs = 142
		goto _test_eof
	_test_eof143:
		lex.cs = 143
		goto _test_eof
	_test_eof144:
		lex.cs = 144
		goto _test_eof
	_test_eof145:
		lex.cs = 145
		goto _test_eof
	_test_eof146:
		lex.cs = 146
		goto _test_eof
	_test_eof147:
		lex.cs = 147
		goto _test_eof
	_test_eof148:
		lex.cs = 148
		goto _test_eof
	_test_eof149:
		lex.cs = 149
		goto _test_eof
	_test_eof150:
		lex.cs = 150
		goto _test_eof
	_test_eof151:
		lex.cs = 151
		goto _test_eof
	_test_eof152:
		lex.cs = 152
		goto _test_eof
	_test_eof153:
		lex.cs = 153
		goto _test_eof
	_test_eof154:
		lex.cs = 154
		goto _test_eof
	_test_eof155:
		lex.cs = 155
		goto _test_eof
	_test_eof156:
		lex.cs = 156
		goto _test_eof
	_test_eof157:
		lex.cs = 157
		goto _test_eof
	_test_eof158:
		lex.cs = 158
		goto _test_eof
	_test_eof159:
		lex.cs = 159
		goto _test_eof
	_test_eof160:
		lex.cs = 160
		goto _test_eof
	_test_eof161:
		lex.cs = 161
		goto _test_eof
	_test_eof162:
		lex.cs = 162
		goto _test_eof
	_test_eof163:
		lex.cs = 163
		goto _test_eof
	_test_eof164:
		lex.cs = 164
		goto _test_eof
	_test_eof165:
		lex.cs = 165
		goto _test_eof
	_test_eof166:
		lex.cs = 166
		goto _test_eof
	_test_eof167:
		lex.cs = 167
		goto _test_eof
	_test_eof168:
		lex.cs = 168
		goto _test_eof
	_test_eof169:
		lex.cs = 169
		goto _test_eof
	_test_eof170:
		lex.cs = 170
		goto _test_eof
	_test_eof171:
		lex.cs = 171
		goto _test_eof
	_test_eof172:
		lex.cs = 172
		goto _test_eof
	_test_eof173:
		lex.cs = 173
		goto _test_eof
	_test_eof174:
		lex.cs = 174
		goto _test_eof
	_test_eof175:
		lex.cs = 175
		goto _test_eof
	_test_eof176:
		lex.cs = 176
		goto _test_eof
	_test_eof177:
		lex.cs = 177
		goto _test_eof
	_test_eof178:
		lex.cs = 178
		goto _test_eof
	_test_eof179:
		lex.cs = 179
		goto _test_eof
	_test_eof180:
		lex.cs = 180
		goto _test_eof
	_test_eof181:
		lex.cs = 181
		goto _test_eof
	_test_eof182:
		lex.cs = 182
		goto _test_eof
	_test_eof183:
		lex.cs = 183
		goto _test_eof
	_test_eof184:
		lex.cs = 184
		goto _test_eof
	_test_eof185:
		lex.cs = 185
		goto _test_eof
	_test_eof186:
		lex.cs = 186
		goto _test_eof
	_test_eof187:
		lex.cs = 187
		goto _test_eof
	_test_eof188:
		lex.cs = 188
		goto _test_eof
	_test_eof189:
		lex.cs = 189
		goto _test_eof
	_test_eof190:
		lex.cs = 190
		goto _test_eof
	_test_eof191:
		lex.cs = 191
		goto _test_eof
	_test_eof192:
		lex.cs = 192
		goto _test_eof
	_test_eof193:
		lex.cs = 193
		goto _test_eof
	_test_eof194:
		lex.cs = 194
		goto _test_eof
	_test_eof195:
		lex.cs = 195
		goto _test_eof
	_test_eof196:
		lex.cs = 196
		goto _test_eof
	_test_eof197:
		lex.cs = 197
		goto _test_eof
	_test_eof198:
		lex.cs = 198
		goto _test_eof
	_test_eof199:
		lex.cs = 199
		goto _test_eof
	_test_eof200:
		lex.cs = 200
		goto _test_eof
	_test_eof201:
		lex.cs = 201
		goto _test_eof
	_test_eof202:
		lex.cs = 202
		goto _test_eof
	_test_eof203:
		lex.cs = 203
		goto _test_eof
	_test_eof204:
		lex.cs = 204
		goto _test_eof
	_test_eof205:
		lex.cs = 205
		goto _test_eof
	_test_eof206:
		lex.cs = 206
		goto _test_eof
	_test_eof207:
		lex.cs = 207
		goto _test_eof
	_test_eof208:
		lex.cs = 208
		goto _test_eof
	_test_eof209:
		lex.cs = 209
		goto _test_eof
	_test_eof210:
		lex.cs = 210
		goto _test_eof
	_test_eof211:
		lex.cs = 211
		goto _test_eof
	_test_eof212:
		lex.cs = 212
		goto _test_eof
	_test_eof213:
		lex.cs = 213
		goto _test_eof
	_test_eof214:
		lex.cs = 214
		goto _test_eof
	_test_eof215:
		lex.cs = 215
		goto _test_eof
	_test_eof216:
		lex.cs = 216
		goto _test_eof
	_test_eof217:
		lex.cs = 217
		goto _test_eof
	_test_eof218:
		lex.cs = 218
		goto _test_eof
	_test_eof219:
		lex.cs = 219
		goto _test_eof
	_test_eof220:
		lex.cs = 220
		goto _test_eof
	_test_eof221:
		lex.cs = 221
		goto _test_eof
	_test_eof222:
		lex.cs = 222
		goto _test_eof
	_test_eof223:
		lex.cs = 223
		goto _test_eof
	_test_eof224:
		lex.cs = 224
		goto _test_eof
	_test_eof225:
		lex.cs = 225
		goto _test_eof
	_test_eof226:
		lex.cs = 226
		goto _test_eof
	_test_eof227:
		lex.cs = 227
		goto _test_eof
	_test_eof228:
		lex.cs = 228
		goto _test_eof
	_test_eof229:
		lex.cs = 229
		goto _test_eof
	_test_eof230:
		lex.cs = 230
		goto _test_eof
	_test_eof231:
		lex.cs = 231
		goto _test_eof
	_test_eof232:
		lex.cs = 232
		goto _test_eof
	_test_eof233:
		lex.cs = 233
		goto _test_eof
	_test_eof234:
		lex.cs = 234
		goto _test_eof
	_test_eof235:
		lex.cs = 235
		goto _test_eof
	_test_eof236:
		lex.cs = 236
		goto _test_eof
	_test_eof237:
		lex.cs = 237
		goto _test_eof
	_test_eof238:
		lex.cs = 238
		goto _test_eof
	_test_eof239:
		lex.cs = 239
		goto _test_eof
	_test_eof240:
		lex.cs = 240
		goto _test_eof
	_test_eof241:
		lex.cs = 241
		goto _test_eof
	_test_eof242:
		lex.cs = 242
		goto _test_eof
	_test_eof243:
		lex.cs = 243
		goto _test_eof
	_test_eof244:
		lex.cs = 244
		goto _test_eof
	_test_eof245:
		lex.cs = 245
		goto _test_eof
	_test_eof246:
		lex.cs = 246
		goto _test_eof
	_test_eof247:
		lex.cs = 247
		goto _test_eof
	_test_eof248:
		lex.cs = 248
		goto _test_eof
	_test_eof249:
		lex.cs = 249
		goto _test_eof
	_test_eof250:
		lex.cs = 250
		goto _test_eof
	_test_eof251:
		lex.cs = 251
		goto _test_eof
	_test_eof252:
		lex.cs = 252
		goto _test_eof
	_test_eof253:
		lex.cs = 253
		goto _test_eof
	_test_eof254:
		lex.cs = 254
		goto _test_eof
	_test_eof255:
		lex.cs = 255
		goto _test_eof
	_test_eof256:
		lex.cs = 256
		goto _test_eof
	_test_eof257:
		lex.cs = 257
		goto _test_eof
	_test_eof258:
		lex.cs = 258
		goto _test_eof
	_test_eof259:
		lex.cs = 259
		goto _test_eof
	_test_eof260:
		lex.cs = 260
		goto _test_eof
	_test_eof261:
		lex.cs = 261
		goto _test_eof
	_test_eof262:
		lex.cs = 262
		goto _test_eof
	_test_eof263:
		lex.cs = 263
		goto _test_eof
	_test_eof264:
		lex.cs = 264
		goto _test_eof
	_test_eof265:
		lex.cs = 265
		goto _test_eof
	_test_eof266:
		lex.cs = 266
		goto _test_eof
	_test_eof267:
		lex.cs = 267
		goto _test_eof
	_test_eof268:
		lex.cs = 268
		goto _test_eof
	_test_eof269:
		lex.cs = 269
		goto _test_eof
	_test_eof270:
		lex.cs = 270
		goto _test_eof
	_test_eof271:
		lex.cs = 271
		goto _test_eof
	_test_eof272:
		lex.cs = 272
		goto _test_eof
	_test_eof273:
		lex.cs = 273
		goto _test_eof
	_test_eof274:
		lex.cs = 274
		goto _test_eof
	_test_eof275:
		lex.cs = 275
		goto _test_eof
	_test_eof276:
		lex.cs = 276
		goto _test_eof
	_test_eof277:
		lex.cs = 277
		goto _test_eof
	_test_eof278:
		lex.cs = 278
		goto _test_eof
	_test_eof279:
		lex.cs = 279
		goto _test_eof
	_test_eof280:
		lex.cs = 280
		goto _test_eof
	_test_eof281:
		lex.cs = 281
		goto _test_eof
	_test_eof282:
		lex.cs = 282
		goto _test_eof
	_test_eof283:
		lex.cs = 283
		goto _test_eof
	_test_eof284:
		lex.cs = 284
		goto _test_eof
	_test_eof285:
		lex.cs = 285
		goto _test_eof
	_test_eof286:
		lex.cs = 286
		goto _test_eof
	_test_eof287:
		lex.cs = 287
		goto _test_eof
	_test_eof288:
		lex.cs = 288
		goto _test_eof
	_test_eof289:
		lex.cs = 289
		goto _test_eof
	_test_eof290:
		lex.cs = 290
		goto _test_eof
	_test_eof291:
		lex.cs = 291
		goto _test_eof
	_test_eof292:
		lex.cs = 292
		goto _test_eof
	_test_eof293:
		lex.cs = 293
		goto _test_eof
	_test_eof294:
		lex.cs = 294
		goto _test_eof
	_test_eof295:
		lex.cs = 295
		goto _test_eof
	_test_eof296:
		lex.cs = 296
		goto _test_eof
	_test_eof297:
		lex.cs = 297
		goto _test_eof
	_test_eof298:
		lex.cs = 298
		goto _test_eof
	_test_eof299:
		lex.cs = 299
		goto _test_eof
	_test_eof300:
		lex.cs = 300
		goto _test_eof
	_test_eof301:
		lex.cs = 301
		goto _test_eof
	_test_eof302:
		lex.cs = 302
		goto _test_eof
	_test_eof303:
		lex.cs = 303
		goto _test_eof
	_test_eof304:
		lex.cs = 304
		goto _test_eof
	_test_eof305:
		lex.cs = 305
		goto _test_eof
	_test_eof306:
		lex.cs = 306
		goto _test_eof
	_test_eof307:
		lex.cs = 307
		goto _test_eof
	_test_eof308:
		lex.cs = 308
		goto _test_eof
	_test_eof309:
		lex.cs = 309
		goto _test_eof
	_test_eof310:
		lex.cs = 310
		goto _test_eof
	_test_eof311:
		lex.cs = 311
		goto _test_eof
	_test_eof312:
		lex.cs = 312
		goto _test_eof
	_test_eof313:
		lex.cs = 313
		goto _test_eof
	_test_eof314:
		lex.cs = 314
		goto _test_eof
	_test_eof315:
		lex.cs = 315
		goto _test_eof
	_test_eof316:
		lex.cs = 316
		goto _test_eof
	_test_eof317:
		lex.cs = 317
		goto _test_eof
	_test_eof318:
		lex.cs = 318
		goto _test_eof
	_test_eof319:
		lex.cs = 319
		goto _test_eof
	_test_eof320:
		lex.cs = 320
		goto _test_eof
	_test_eof321:
		lex.cs = 321
		goto _test_eof
	_test_eof322:
		lex.cs = 322
		goto _test_eof
	_test_eof323:
		lex.cs = 323
		goto _test_eof
	_test_eof324:
		lex.cs = 324
		goto _test_eof
	_test_eof325:
		lex.cs = 325
		goto _test_eof
	_test_eof326:
		lex.cs = 326
		goto _test_eof
	_test_eof327:
		lex.cs = 327
		goto _test_eof
	_test_eof328:
		lex.cs = 328
		goto _test_eof
	_test_eof329:
		lex.cs = 329
		goto _test_eof
	_test_eof330:
		lex.cs = 330
		goto _test_eof
	_test_eof331:
		lex.cs = 331
		goto _test_eof
	_test_eof332:
		lex.cs = 332
		goto _test_eof
	_test_eof333:
		lex.cs = 333
		goto _test_eof
	_test_eof334:
		lex.cs = 334
		goto _test_eof
	_test_eof335:
		lex.cs = 335
		goto _test_eof
	_test_eof336:
		lex.cs = 336
		goto _test_eof
	_test_eof337:
		lex.cs = 337
		goto _test_eof
	_test_eof338:
		lex.cs = 338
		goto _test_eof
	_test_eof339:
		lex.cs = 339
		goto _test_eof
	_test_eof340:
		lex.cs = 340
		goto _test_eof
	_test_eof341:
		lex.cs = 341
		goto _test_eof
	_test_eof342:
		lex.cs = 342
		goto _test_eof
	_test_eof343:
		lex.cs = 343
		goto _test_eof
	_test_eof344:
		lex.cs = 344
		goto _test_eof
	_test_eof345:
		lex.cs = 345
		goto _test_eof
	_test_eof346:
		lex.cs = 346
		goto _test_eof
	_test_eof347:
		lex.cs = 347
		goto _test_eof
	_test_eof348:
		lex.cs = 348
		goto _test_eof
	_test_eof349:
		lex.cs = 349
		goto _test_eof
	_test_eof350:
		lex.cs = 350
		goto _test_eof
	_test_eof351:
		lex.cs = 351
		goto _test_eof
	_test_eof352:
		lex.cs = 352
		goto _test_eof
	_test_eof353:
		lex.cs = 353
		goto _test_eof
	_test_eof354:
		lex.cs = 354
		goto _test_eof
	_test_eof355:
		lex.cs = 355
		goto _test_eof
	_test_eof356:
		lex.cs = 356
		goto _test_eof
	_test_eof357:
		lex.cs = 357
		goto _test_eof
	_test_eof358:
		lex.cs = 358
		goto _test_eof
	_test_eof359:
		lex.cs = 359
		goto _test_eof
	_test_eof360:
		lex.cs = 360
		goto _test_eof
	_test_eof361:
		lex.cs = 361
		goto _test_eof
	_test_eof362:
		lex.cs = 362
		goto _test_eof
	_test_eof363:
		lex.cs = 363
		goto _test_eof
	_test_eof364:
		lex.cs = 364
		goto _test_eof
	_test_eof365:
		lex.cs = 365
		goto _test_eof
	_test_eof366:
		lex.cs = 366
		goto _test_eof
	_test_eof367:
		lex.cs = 367
		goto _test_eof
	_test_eof368:
		lex.cs = 368
		goto _test_eof
	_test_eof369:
		lex.cs = 369
		goto _test_eof
	_test_eof370:
		lex.cs = 370
		goto _test_eof
	_test_eof371:
		lex.cs = 371
		goto _test_eof
	_test_eof372:
		lex.cs = 372
		goto _test_eof
	_test_eof373:
		lex.cs = 373
		goto _test_eof
	_test_eof374:
		lex.cs = 374
		goto _test_eof
	_test_eof375:
		lex.cs = 375
		goto _test_eof
	_test_eof376:
		lex.cs = 376
		goto _test_eof
	_test_eof377:
		lex.cs = 377
		goto _test_eof
	_test_eof378:
		lex.cs = 378
		goto _test_eof
	_test_eof379:
		lex.cs = 379
		goto _test_eof
	_test_eof380:
		lex.cs = 380
		goto _test_eof
	_test_eof381:
		lex.cs = 381
		goto _test_eof
	_test_eof382:
		lex.cs = 382
		goto _test_eof
	_test_eof383:
		lex.cs = 383
		goto _test_eof
	_test_eof384:
		lex.cs = 384
		goto _test_eof
	_test_eof385:
		lex.cs = 385
		goto _test_eof
	_test_eof386:
		lex.cs = 386
		goto _test_eof
	_test_eof387:
		lex.cs = 387
		goto _test_eof
	_test_eof388:
		lex.cs = 388
		goto _test_eof
	_test_eof389:
		lex.cs = 389
		goto _test_eof
	_test_eof390:
		lex.cs = 390
		goto _test_eof
	_test_eof391:
		lex.cs = 391
		goto _test_eof
	_test_eof392:
		lex.cs = 392
		goto _test_eof
	_test_eof393:
		lex.cs = 393
		goto _test_eof
	_test_eof394:
		lex.cs = 394
		goto _test_eof
	_test_eof395:
		lex.cs = 395
		goto _test_eof
	_test_eof396:
		lex.cs = 396
		goto _test_eof
	_test_eof397:
		lex.cs = 397
		goto _test_eof
	_test_eof398:
		lex.cs = 398
		goto _test_eof
	_test_eof399:
		lex.cs = 399
		goto _test_eof
	_test_eof400:
		lex.cs = 400
		goto _test_eof
	_test_eof401:
		lex.cs = 401
		goto _test_eof
	_test_eof402:
		lex.cs = 402
		goto _test_eof
	_test_eof403:
		lex.cs = 403
		goto _test_eof
	_test_eof404:
		lex.cs = 404
		goto _test_eof
	_test_eof405:
		lex.cs = 405
		goto _test_eof
	_test_eof406:
		lex.cs = 406
		goto _test_eof
	_test_eof407:
		lex.cs = 407
		goto _test_eof
	_test_eof408:
		lex.cs = 408
		goto _test_eof
	_test_eof409:
		lex.cs = 409
		goto _test_eof
	_test_eof410:
		lex.cs = 410
		goto _test_eof
	_test_eof411:
		lex.cs = 411
		goto _test_eof
	_test_eof412:
		lex.cs = 412
		goto _test_eof
	_test_eof413:
		lex.cs = 413
		goto _test_eof
	_test_eof414:
		lex.cs = 414
		goto _test_eof
	_test_eof415:
		lex.cs = 415
		goto _test_eof

	_test_eof:
		{
		}
		if (lex.p) == eof {
			switch lex.cs {
			case 20:
				goto tr58
			case 21:
				goto tr59
			case 22:
				goto tr62
			case 6:
				goto tr7
			case 7:
				goto tr7
			case 23:
				goto tr62
			case 24:
				goto tr63
			case 15:
				goto tr22
			case 16:
				goto tr22
			case 25:
				goto tr59
			case 17:
				goto tr25
			case 26:
				goto tr59
			case 27:
				goto tr65
			case 18:
				goto tr7
			case 28:
				goto tr65
			case 29:
				goto tr65
			case 30:
				goto tr65
			case 31:
				goto tr65
			case 32:
				goto tr71
			case 33:
				goto tr71
			case 34:
				goto tr65
			case 35:
				goto tr65
			case 36:
				goto tr65
			case 37:
				goto tr65
			case 38:
				goto tr65
			case 39:
				goto tr65
			case 40:
				goto tr65
			case 41:
				goto tr65
			case 42:
				goto tr65
			case 43:
				goto tr65
			case 44:
				goto tr65
			case 45:
				goto tr65
			case 46:
				goto tr65
			case 47:
				goto tr65
			case 48:
				goto tr65
			case 49:
				goto tr65
			case 50:
				goto tr65
			case 51:
				goto tr65
			case 52:
				goto tr65
			case 53:
				goto tr65
			case 54:
				goto tr65
			case 55:
				goto tr65
			case 56:
				goto tr65
			case 57:
				goto tr65
			case 58:
				goto tr65
			case 59:
				goto tr65
			case 60:
				goto tr65
			case 61:
				goto tr65
			case 62:
				goto tr65
			case 63:
				goto tr65
			case 64:
				goto tr65
			case 65:
				goto tr65
			case 66:
				goto tr65
			case 67:
				goto tr65
			case 68:
				goto tr65
			case 69:
				goto tr65
			case 70:
				goto tr65
			case 71:
				goto tr65
			case 72:
				goto tr65
			case 73:
				goto tr65
			case 74:
				goto tr65
			case 75:
				goto tr65
			case 76:
				goto tr65
			case 77:
				goto tr65
			case 78:
				goto tr65
			case 79:
				goto tr65
			case 80:
				goto tr65
			case 81:
				goto tr71
			case 82:
				goto tr65
			case 83:
				goto tr65
			case 84:
				goto tr65
			case 85:
				goto tr65
			case 86:
				goto tr65
			case 87:
				goto tr65
			case 88:
				goto tr65
			case 89:
				goto tr65
			case 90:
				goto tr65
			case 91:
				goto tr65
			case 92:
				goto tr132
			case 93:
				goto tr132
			case 94:
				goto tr65
			case 95:
				goto tr65
			case 96:
				goto tr137
			case 97:
				goto tr137
			case 98:
				goto tr65
			case 99:
				goto tr65
			case 100:
				goto tr65
			case 101:
				goto tr65
			case 102:
				goto tr65
			case 103:
				goto tr144
			case 104:
				goto tr144
			case 105:
				goto tr65
			case 106:
				goto tr65
			case 107:
				goto tr65
			case 108:
				goto tr65
			case 109:
				goto tr65
			case 110:
				goto tr65
			case 111:
				goto tr65
			case 112:
				goto tr65
			case 113:
				goto tr65
			case 114:
				goto tr65
			case 115:
				goto tr65
			case 116:
				goto tr160
			case 117:
				goto tr160
			case 118:
				goto tr65
			case 119:
				goto tr65
			case 120:
				goto tr65
			case 121:
				goto tr65
			case 122:
				goto tr65
			case 123:
				goto tr65
			case 124:
				goto tr65
			case 125:
				goto tr65
			case 126:
				goto tr65
			case 127:
				goto tr65
			case 128:
				goto tr65
			case 129:
				goto tr65
			case 130:
				goto tr174
			case 131:
				goto tr174
			case 132:
				goto tr65
			case 133:
				goto tr65
			case 134:
				goto tr65
			case 135:
				goto tr65
			case 136:
				goto tr65
			case 137:
				goto tr71
			case 138:
				goto tr65
			case 139:
				goto tr65
			case 140:
				goto tr71
			case 141:
				goto tr65
			case 142:
				goto tr71
			case 143:
				goto tr65
			case 144:
				goto tr65
			case 145:
				goto tr65
			case 146:
				goto tr192
			case 147:
				goto tr192
			case 148:
				goto tr65
			case 149:
				goto tr65
			case 150:
				goto tr65
			case 151:
				goto tr65
			case 152:
				goto tr65
			case 153:
				goto tr65
			case 154:
				goto tr65
			case 155:
				goto tr65
			case 156:
				goto tr65
			case 157:
				goto tr71
			case 158:
				goto tr65
			case 159:
				goto tr71
			case 160:
				goto tr65
			case 161:
				goto tr65
			case 162:
				goto tr65
			case 163:
				goto tr65
			case 164:
				goto tr71
			case 165:
				goto tr65
			case 166:
				goto tr65
			case 167:
				goto tr65
			case 168:
				goto tr65
			case 169:
				goto tr65
			case 170:
				goto tr65
			case 171:
				goto tr65
			case 172:
				goto tr65
			case 173:
				goto tr65
			case 174:
				goto tr221
			case 175:
				goto tr221
			case 176:
				goto tr65
			case 177:
				goto tr65
			case 178:
				goto tr65
			case 179:
				goto tr65
			case 180:
				goto tr71
			case 181:
				goto tr65
			case 182:
				goto tr65
			case 183:
				goto tr232
			case 184:
				goto tr232
			case 185:
				goto tr65
			case 186:
				goto tr65
			case 187:
				goto tr65
			case 188:
				goto tr65
			case 189:
				goto tr239
			case 190:
				goto tr239
			case 191:
				goto tr65
			case 192:
				goto tr65
			case 193:
				goto tr65
			case 194:
				goto tr65
			case 195:
				goto tr250
			case 196:
				goto tr250
			case 197:
				goto tr65
			case 198:
				goto tr65
			case 199:
				goto tr65
			case 200:
				goto tr65
			case 201:
				goto tr65
			case 202:
				goto tr65
			case 203:
				goto tr65
			case 204:
				goto tr65
			case 205:
				goto tr65
			case 206:
				goto tr65
			case 207:
				goto tr65
			case 208:
				goto tr65
			case 209:
				goto tr65
			case 210:
				goto tr65
			case 211:
				goto tr65
			case 212:
				goto tr65
			case 213:
				goto tr65
			case 214:
				goto tr65
			case 215:
				goto tr65
			case 216:
				goto tr65
			case 217:
				goto tr65
			case 218:
				goto tr65
			case 219:
				goto tr65
			case 220:
				goto tr276
			case 221:
				goto tr276
			case 222:
				goto tr65
			case 223:
				goto tr280
			case 224:
				goto tr280
			case 225:
				goto tr65
			case 226:
				goto tr284
			case 227:
				goto tr284
			case 228:
				goto tr287
			case 229:
				goto tr287
			case 230:
				goto tr65
			case 231:
				goto tr65
			case 232:
				goto tr65
			case 233:
				goto tr65
			case 234:
				goto tr65
			case 235:
				goto tr65
			case 236:
				goto tr65
			case 237:
				goto tr71
			case 238:
				goto tr65
			case 239:
				goto tr65
			case 240:
				goto tr65
			case 241:
				goto tr65
			case 242:
				goto tr304
			case 243:
				goto tr304
			case 244:
				goto tr65
			case 245:
				goto tr65
			case 246:
				goto tr65
			case 247:
				goto tr65
			case 248:
				goto tr65
			case 249:
				goto tr65
			case 250:
				goto tr65
			case 251:
				goto tr65
			case 252:
				goto tr65
			case 253:
				goto tr65
			case 254:
				goto tr65
			case 255:
				goto tr65
			case 256:
				goto tr65
			case 257:
				goto tr65
			case 258:
				goto tr65
			case 259:
				goto tr65
			case 260:
				goto tr65
			case 261:
				goto tr65
			case 262:
				goto tr65
			case 263:
				goto tr323
			case 264:
				goto tr323
			case 265:
				goto tr65
			case 266:
				goto tr65
			case 267:
				goto tr329
			case 268:
				goto tr329
			case 269:
				goto tr65
			case 270:
				goto tr65
			case 271:
				goto tr65
			case 272:
				goto tr65
			case 273:
				goto tr65
			case 274:
				goto tr65
			case 275:
				goto tr65
			case 276:
				goto tr65
			case 277:
				goto tr65
			case 278:
				goto tr65
			case 279:
				goto tr343
			case 280:
				goto tr343
			case 281:
				goto tr65
			case 282:
				goto tr65
			case 283:
				goto tr65
			case 284:
				goto tr65
			case 285:
				goto tr65
			case 286:
				goto tr65
			case 287:
				goto tr65
			case 288:
				goto tr65
			case 289:
				goto tr353
			case 290:
				goto tr353
			case 291:
				goto tr65
			case 292:
				goto tr65
			case 293:
				goto tr65
			case 294:
				goto tr65
			case 295:
				goto tr65
			case 296:
				goto tr65
			case 297:
				goto tr362
			case 298:
				goto tr362
			case 299:
				goto tr65
			case 300:
				goto tr65
			case 301:
				goto tr65
			case 302:
				goto tr65
			case 303:
				goto tr65
			case 304:
				goto tr65
			case 305:
				goto tr65
			case 306:
				goto tr65
			case 307:
				goto tr65
			case 308:
				goto tr65
			case 309:
				goto tr65
			case 310:
				goto tr65
			case 311:
				goto tr65
			case 312:
				goto tr65
			case 313:
				goto tr65
			case 314:
				goto tr65
			case 315:
				goto tr65
			case 316:
				goto tr65
			case 317:
				goto tr65
			case 318:
				goto tr65
			case 319:
				goto tr65
			case 320:
				goto tr65
			case 321:
				goto tr65
			case 322:
				goto tr65
			case 323:
				goto tr65
			case 324:
				goto tr65
			case 325:
				goto tr65
			case 326:
				goto tr65
			case 327:
				goto tr65
			case 328:
				goto tr395
			case 329:
				goto tr395
			case 330:
				goto tr65
			case 331:
				goto tr65
			case 332:
				goto tr65
			case 333:
				goto tr65
			case 334:
				goto tr65
			case 335:
				goto tr65
			case 336:
				goto tr65
			case 337:
				goto tr65
			case 338:
				goto tr65
			case 339:
				goto tr410
			case 340:
				goto tr410
			case 341:
				goto tr413
			case 342:
				goto tr413
			case 343:
				goto tr65
			case 344:
				goto tr65
			case 345:
				goto tr65
			case 346:
				goto tr65
			case 347:
				goto tr65
			case 348:
				goto tr65
			case 349:
				goto tr422
			case 350:
				goto tr422
			case 351:
				goto tr65
			case 352:
				goto tr65
			case 353:
				goto tr427
			case 354:
				goto tr427
			case 355:
				goto tr65
			case 356:
				goto tr65
			case 357:
				goto tr65
			case 358:
				goto tr65
			case 359:
				goto tr65
			case 360:
				goto tr65
			case 361:
				goto tr65
			case 362:
				goto tr65
			case 363:
				goto tr65
			case 364:
				goto tr65
			case 365:
				goto tr65
			case 366:
				goto tr65
			case 367:
				goto tr65
			case 368:
				goto tr71
			case 369:
				goto tr444
			case 370:
				goto tr444
			case 371:
				goto tr65
			case 372:
				goto tr65
			case 373:
				goto tr65
			case 374:
				goto tr65
			case 375:
				goto tr65
			case 376:
				goto tr65
			case 377:
				goto tr65
			case 378:
				goto tr454
			case 379:
				goto tr454
			case 380:
				goto tr65
			case 381:
				goto tr65
			case 382:
				goto tr65
			case 383:
				goto tr65
			case 384:
				goto tr65
			case 385:
				goto tr462
			case 386:
				goto tr462
			case 387:
				goto tr65
			case 388:
				goto tr65
			case 389:
				goto tr65
			case 390:
				goto tr65
			case 391:
				goto tr65
			case 392:
				goto tr473
			case 393:
				goto tr473
			case 394:
				goto tr65
			case 395:
				goto tr65
			case 396:
				goto tr65
			case 397:
				goto tr65
			case 398:
				goto tr65
			case 399:
				goto tr65
			case 400:
				goto tr65
			case 401:
				goto tr65
			case 402:
				goto tr65
			case 403:
				goto tr65
			case 404:
				goto tr65
			case 405:
				goto tr485
			case 406:
				goto tr485
			case 407:
				goto tr65
			case 408:
				goto tr65
			case 409:
				goto tr65
			case 410:
				goto tr65
			case 411:
				goto tr65
			case 412:
				goto tr65
			case 413:
				goto tr65
			case 414:
				goto tr65
			case 415:
				goto tr65
			}
		}

	_out:
		{
		}
	}


	if lex.cs == thrift_error {
		lex.Error("unknown token")
	}
	return tok
}

func (lex *lexer) Error(e string) {
	lex.AppendError(errors.New(e))
}

func (lex *lexer) AppendError(err error) {
	lex.parseFailed = true
	lex.errors = append(lex.errors, ParseError{Pos: lex.Pos(), Err: err})
}

func (lex *lexer) Pos() ast.Position {
	return ast.Position{Line: lex.line, Column: lex.ts - lex.lineStart + 1}
}

func (lex *lexer) RecordPosition(n ast.Node, pos ast.Position) {
	lex.nodePositions[n] = pos
}

func (lex *lexer) LastDocstring() string {
	// If we've had more than one line since we recorded
	// the docstring, ignore it.
	if lex.linesSinceDocstring > 1 {
		return ""
	}

	s := lex.lastDocstring
	lex.lastDocstring = ""
	lex.linesSinceDocstring = 0
	return s
}
