// Code generated by client-gen. DO NOT EDIT.

package v1

import (
	"context"
	json "encoding/json"
	"fmt"
	"time"

	v1 "github.com/openshift/api/operator/v1"
	operatorv1 "github.com/openshift/client-go/operator/applyconfigurations/operator/v1"
	scheme "github.com/openshift/client-go/operator/clientset/versioned/scheme"
	metav1 "k8s.io/apimachinery/pkg/apis/meta/v1"
	types "k8s.io/apimachinery/pkg/types"
	watch "k8s.io/apimachinery/pkg/watch"
	rest "k8s.io/client-go/rest"
)

// EtcdsGetter has a method to return a EtcdInterface.
// A group's client should implement this interface.
type EtcdsGetter interface {
	Etcds() EtcdInterface
}

// EtcdInterface has methods to work with Etcd resources.
type EtcdInterface interface {
	Create(ctx context.Context, etcd *v1.Etcd, opts metav1.CreateOptions) (*v1.Etcd, error)
	Update(ctx context.Context, etcd *v1.Etcd, opts metav1.UpdateOptions) (*v1.Etcd, error)
	UpdateStatus(ctx context.Context, etcd *v1.Etcd, opts metav1.UpdateOptions) (*v1.Etcd, error)
	Delete(ctx context.Context, name string, opts metav1.DeleteOptions) error
	DeleteCollection(ctx context.Context, opts metav1.DeleteOptions, listOpts metav1.ListOptions) error
	Get(ctx context.Context, name string, opts metav1.GetOptions) (*v1.Etcd, error)
	List(ctx context.Context, opts metav1.ListOptions) (*v1.EtcdList, error)
	Watch(ctx context.Context, opts metav1.ListOptions) (watch.Interface, error)
	Patch(ctx context.Context, name string, pt types.PatchType, data []byte, opts metav1.PatchOptions, subresources ...string) (result *v1.Etcd, err error)
	Apply(ctx context.Context, etcd *operatorv1.EtcdApplyConfiguration, opts metav1.ApplyOptions) (result *v1.Etcd, err error)
	ApplyStatus(ctx context.Context, etcd *operatorv1.EtcdApplyConfiguration, opts metav1.ApplyOptions) (result *v1.Etcd, err error)
	EtcdExpansion
}

// etcds implements EtcdInterface
type etcds struct {
	client rest.Interface
}

// newEtcds returns a Etcds
func newEtcds(c *OperatorV1Client) *etcds {
	return &etcds{
		client: c.RESTClient(),
	}
}

// Get takes name of the etcd, and returns the corresponding etcd object, and an error if there is any.
func (c *etcds) Get(ctx context.Context, name string, options metav1.GetOptions) (result *v1.Etcd, err error) {
	result = &v1.Etcd{}
	err = c.client.Get().
		Resource("etcds").
		Name(name).
		VersionedParams(&options, scheme.ParameterCodec).
		Do(ctx).
		Into(result)
	return
}

// List takes label and field selectors, and returns the list of Etcds that match those selectors.
func (c *etcds) List(ctx context.Context, opts metav1.ListOptions) (result *v1.EtcdList, err error) {
	var timeout time.Duration
	if opts.TimeoutSeconds != nil {
		timeout = time.Duration(*opts.TimeoutSeconds) * time.Second
	}
	result = &v1.EtcdList{}
	err = c.client.Get().
		Resource("etcds").
		VersionedParams(&opts, scheme.ParameterCodec).
		Timeout(timeout).
		Do(ctx).
		Into(result)
	return
}

// Watch returns a watch.Interface that watches the requested etcds.
func (c *etcds) Watch(ctx context.Context, opts metav1.ListOptions) (watch.Interface, error) {
	var timeout time.Duration
	if opts.TimeoutSeconds != nil {
		timeout = time.Duration(*opts.TimeoutSeconds) * time.Second
	}
	opts.Watch = true
	return c.client.Get().
		Resource("etcds").
		VersionedParams(&opts, scheme.ParameterCodec).
		Timeout(timeout).
		Watch(ctx)
}

// Create takes the representation of a etcd and creates it.  Returns the server's representation of the etcd, and an error, if there is any.
func (c *etcds) Create(ctx context.Context, etcd *v1.Etcd, opts metav1.CreateOptions) (result *v1.Etcd, err error) {
	result = &v1.Etcd{}
	err = c.client.Post().
		Resource("etcds").
		VersionedParams(&opts, scheme.ParameterCodec).
		Body(etcd).
		Do(ctx).
		Into(result)
	return
}

// Update takes the representation of a etcd and updates it. Returns the server's representation of the etcd, and an error, if there is any.
func (c *etcds) Update(ctx context.Context, etcd *v1.Etcd, opts metav1.UpdateOptions) (result *v1.Etcd, err error) {
	result = &v1.Etcd{}
	err = c.client.Put().
		Resource("etcds").
		Name(etcd.Name).
		VersionedParams(&opts, scheme.ParameterCodec).
		Body(etcd).
		Do(ctx).
		Into(result)
	return
}

// UpdateStatus was generated because the type contains a Status member.
// Add a +genclient:noStatus comment above the type to avoid generating UpdateStatus().
func (c *etcds) UpdateStatus(ctx context.Context, etcd *v1.Etcd, opts metav1.UpdateOptions) (result *v1.Etcd, err error) {
	result = &v1.Etcd{}
	err = c.client.Put().
		Resource("etcds").
		Name(etcd.Name).
		SubResource("status").
		VersionedParams(&opts, scheme.ParameterCodec).
		Body(etcd).
		Do(ctx).
		Into(result)
	return
}

// Delete takes name of the etcd and deletes it. Returns an error if one occurs.
func (c *etcds) Delete(ctx context.Context, name string, opts metav1.DeleteOptions) error {
	return c.client.Delete().
		Resource("etcds").
		Name(name).
		Body(&opts).
		Do(ctx).
		Error()
}

// DeleteCollection deletes a collection of objects.
func (c *etcds) DeleteCollection(ctx context.Context, opts metav1.DeleteOptions, listOpts metav1.ListOptions) error {
	var timeout time.Duration
	if listOpts.TimeoutSeconds != nil {
		timeout = time.Duration(*listOpts.TimeoutSeconds) * time.Second
	}
	return c.client.Delete().
		Resource("etcds").
		VersionedParams(&listOpts, scheme.ParameterCodec).
		Timeout(timeout).
		Body(&opts).
		Do(ctx).
		Error()
}

// Patch applies the patch and returns the patched etcd.
func (c *etcds) Patch(ctx context.Context, name string, pt types.PatchType, data []byte, opts metav1.PatchOptions, subresources ...string) (result *v1.Etcd, err error) {
	result = &v1.Etcd{}
	err = c.client.Patch(pt).
		Resource("etcds").
		Name(name).
		SubResource(subresources...).
		VersionedParams(&opts, scheme.ParameterCodec).
		Body(data).
		Do(ctx).
		Into(result)
	return
}

// Apply takes the given apply declarative configuration, applies it and returns the applied etcd.
func (c *etcds) Apply(ctx context.Context, etcd *operatorv1.EtcdApplyConfiguration, opts metav1.ApplyOptions) (result *v1.Etcd, err error) {
	if etcd == nil {
		return nil, fmt.Errorf("etcd provided to Apply must not be nil")
	}
	patchOpts := opts.ToPatchOptions()
	data, err := json.Marshal(etcd)
	if err != nil {
		return nil, err
	}
	name := etcd.Name
	if name == nil {
		return nil, fmt.Errorf("etcd.Name must be provided to Apply")
	}
	result = &v1.Etcd{}
	err = c.client.Patch(types.ApplyPatchType).
		Resource("etcds").
		Name(*name).
		VersionedParams(&patchOpts, scheme.ParameterCodec).
		Body(data).
		Do(ctx).
		Into(result)
	return
}

// ApplyStatus was generated because the type contains a Status member.
// Add a +genclient:noStatus comment above the type to avoid generating ApplyStatus().
func (c *etcds) ApplyStatus(ctx context.Context, etcd *operatorv1.EtcdApplyConfiguration, opts metav1.ApplyOptions) (result *v1.Etcd, err error) {
	if etcd == nil {
		return nil, fmt.Errorf("etcd provided to Apply must not be nil")
	}
	patchOpts := opts.ToPatchOptions()
	data, err := json.Marshal(etcd)
	if err != nil {
		return nil, err
	}

	name := etcd.Name
	if name == nil {
		return nil, fmt.Errorf("etcd.Name must be provided to Apply")
	}

	result = &v1.Etcd{}
	err = c.client.Patch(types.ApplyPatchType).
		Resource("etcds").
		Name(*name).
		SubResource("status").
		VersionedParams(&patchOpts, scheme.ParameterCodec).
		Body(data).
		Do(ctx).
		Into(result)
	return
}
