// Code generated by applyconfiguration-gen. DO NOT EDIT.

package v1

import (
	apinetworkv1 "github.com/openshift/api/network/v1"
	internal "github.com/openshift/client-go/network/applyconfigurations/internal"
	metav1 "k8s.io/apimachinery/pkg/apis/meta/v1"
	types "k8s.io/apimachinery/pkg/types"
	managedfields "k8s.io/apimachinery/pkg/util/managedfields"
	v1 "k8s.io/client-go/applyconfigurations/meta/v1"
)

// ClusterNetworkApplyConfiguration represents an declarative configuration of the ClusterNetwork type for use
// with apply.
type ClusterNetworkApplyConfiguration struct {
	v1.TypeMetaApplyConfiguration    `json:",inline"`
	*v1.ObjectMetaApplyConfiguration `json:"metadata,omitempty"`
	Network                          *string                                 `json:"network,omitempty"`
	HostSubnetLength                 *uint32                                 `json:"hostsubnetlength,omitempty"`
	ServiceNetwork                   *string                                 `json:"serviceNetwork,omitempty"`
	PluginName                       *string                                 `json:"pluginName,omitempty"`
	ClusterNetworks                  []ClusterNetworkEntryApplyConfiguration `json:"clusterNetworks,omitempty"`
	VXLANPort                        *uint32                                 `json:"vxlanPort,omitempty"`
	MTU                              *uint32                                 `json:"mtu,omitempty"`
}

// ClusterNetwork constructs an declarative configuration of the ClusterNetwork type for use with
// apply.
func ClusterNetwork(name string) *ClusterNetworkApplyConfiguration {
	b := &ClusterNetworkApplyConfiguration{}
	b.WithName(name)
	b.WithKind("ClusterNetwork")
	b.WithAPIVersion("network.openshift.io/v1")
	return b
}

// ExtractClusterNetwork extracts the applied configuration owned by fieldManager from
// clusterNetwork. If no managedFields are found in clusterNetwork for fieldManager, a
// ClusterNetworkApplyConfiguration is returned with only the Name, Namespace (if applicable),
// APIVersion and Kind populated. It is possible that no managed fields were found for because other
// field managers have taken ownership of all the fields previously owned by fieldManager, or because
// the fieldManager never owned fields any fields.
// clusterNetwork must be a unmodified ClusterNetwork API object that was retrieved from the Kubernetes API.
// ExtractClusterNetwork provides a way to perform a extract/modify-in-place/apply workflow.
// Note that an extracted apply configuration will contain fewer fields than what the fieldManager previously
// applied if another fieldManager has updated or force applied any of the previously applied fields.
// Experimental!
func ExtractClusterNetwork(clusterNetwork *apinetworkv1.ClusterNetwork, fieldManager string) (*ClusterNetworkApplyConfiguration, error) {
	return extractClusterNetwork(clusterNetwork, fieldManager, "")
}

// ExtractClusterNetworkStatus is the same as ExtractClusterNetwork except
// that it extracts the status subresource applied configuration.
// Experimental!
func ExtractClusterNetworkStatus(clusterNetwork *apinetworkv1.ClusterNetwork, fieldManager string) (*ClusterNetworkApplyConfiguration, error) {
	return extractClusterNetwork(clusterNetwork, fieldManager, "status")
}

func extractClusterNetwork(clusterNetwork *apinetworkv1.ClusterNetwork, fieldManager string, subresource string) (*ClusterNetworkApplyConfiguration, error) {
	b := &ClusterNetworkApplyConfiguration{}
	err := managedfields.ExtractInto(clusterNetwork, internal.Parser().Type("com.github.openshift.api.network.v1.ClusterNetwork"), fieldManager, b, subresource)
	if err != nil {
		return nil, err
	}
	b.WithName(clusterNetwork.Name)

	b.WithKind("ClusterNetwork")
	b.WithAPIVersion("network.openshift.io/v1")
	return b, nil
}

// WithKind sets the Kind field in the declarative configuration to the given value
// and returns the receiver, so that objects can be built by chaining "With" function invocations.
// If called multiple times, the Kind field is set to the value of the last call.
func (b *ClusterNetworkApplyConfiguration) WithKind(value string) *ClusterNetworkApplyConfiguration {
	b.Kind = &value
	return b
}

// WithAPIVersion sets the APIVersion field in the declarative configuration to the given value
// and returns the receiver, so that objects can be built by chaining "With" function invocations.
// If called multiple times, the APIVersion field is set to the value of the last call.
func (b *ClusterNetworkApplyConfiguration) WithAPIVersion(value string) *ClusterNetworkApplyConfiguration {
	b.APIVersion = &value
	return b
}

// WithName sets the Name field in the declarative configuration to the given value
// and returns the receiver, so that objects can be built by chaining "With" function invocations.
// If called multiple times, the Name field is set to the value of the last call.
func (b *ClusterNetworkApplyConfiguration) WithName(value string) *ClusterNetworkApplyConfiguration {
	b.ensureObjectMetaApplyConfigurationExists()
	b.Name = &value
	return b
}

// WithGenerateName sets the GenerateName field in the declarative configuration to the given value
// and returns the receiver, so that objects can be built by chaining "With" function invocations.
// If called multiple times, the GenerateName field is set to the value of the last call.
func (b *ClusterNetworkApplyConfiguration) WithGenerateName(value string) *ClusterNetworkApplyConfiguration {
	b.ensureObjectMetaApplyConfigurationExists()
	b.GenerateName = &value
	return b
}

// WithNamespace sets the Namespace field in the declarative configuration to the given value
// and returns the receiver, so that objects can be built by chaining "With" function invocations.
// If called multiple times, the Namespace field is set to the value of the last call.
func (b *ClusterNetworkApplyConfiguration) WithNamespace(value string) *ClusterNetworkApplyConfiguration {
	b.ensureObjectMetaApplyConfigurationExists()
	b.Namespace = &value
	return b
}

// WithUID sets the UID field in the declarative configuration to the given value
// and returns the receiver, so that objects can be built by chaining "With" function invocations.
// If called multiple times, the UID field is set to the value of the last call.
func (b *ClusterNetworkApplyConfiguration) WithUID(value types.UID) *ClusterNetworkApplyConfiguration {
	b.ensureObjectMetaApplyConfigurationExists()
	b.UID = &value
	return b
}

// WithResourceVersion sets the ResourceVersion field in the declarative configuration to the given value
// and returns the receiver, so that objects can be built by chaining "With" function invocations.
// If called multiple times, the ResourceVersion field is set to the value of the last call.
func (b *ClusterNetworkApplyConfiguration) WithResourceVersion(value string) *ClusterNetworkApplyConfiguration {
	b.ensureObjectMetaApplyConfigurationExists()
	b.ResourceVersion = &value
	return b
}

// WithGeneration sets the Generation field in the declarative configuration to the given value
// and returns the receiver, so that objects can be built by chaining "With" function invocations.
// If called multiple times, the Generation field is set to the value of the last call.
func (b *ClusterNetworkApplyConfiguration) WithGeneration(value int64) *ClusterNetworkApplyConfiguration {
	b.ensureObjectMetaApplyConfigurationExists()
	b.Generation = &value
	return b
}

// WithCreationTimestamp sets the CreationTimestamp field in the declarative configuration to the given value
// and returns the receiver, so that objects can be built by chaining "With" function invocations.
// If called multiple times, the CreationTimestamp field is set to the value of the last call.
func (b *ClusterNetworkApplyConfiguration) WithCreationTimestamp(value metav1.Time) *ClusterNetworkApplyConfiguration {
	b.ensureObjectMetaApplyConfigurationExists()
	b.CreationTimestamp = &value
	return b
}

// WithDeletionTimestamp sets the DeletionTimestamp field in the declarative configuration to the given value
// and returns the receiver, so that objects can be built by chaining "With" function invocations.
// If called multiple times, the DeletionTimestamp field is set to the value of the last call.
func (b *ClusterNetworkApplyConfiguration) WithDeletionTimestamp(value metav1.Time) *ClusterNetworkApplyConfiguration {
	b.ensureObjectMetaApplyConfigurationExists()
	b.DeletionTimestamp = &value
	return b
}

// WithDeletionGracePeriodSeconds sets the DeletionGracePeriodSeconds field in the declarative configuration to the given value
// and returns the receiver, so that objects can be built by chaining "With" function invocations.
// If called multiple times, the DeletionGracePeriodSeconds field is set to the value of the last call.
func (b *ClusterNetworkApplyConfiguration) WithDeletionGracePeriodSeconds(value int64) *ClusterNetworkApplyConfiguration {
	b.ensureObjectMetaApplyConfigurationExists()
	b.DeletionGracePeriodSeconds = &value
	return b
}

// WithLabels puts the entries into the Labels field in the declarative configuration
// and returns the receiver, so that objects can be build by chaining "With" function invocations.
// If called multiple times, the entries provided by each call will be put on the Labels field,
// overwriting an existing map entries in Labels field with the same key.
func (b *ClusterNetworkApplyConfiguration) WithLabels(entries map[string]string) *ClusterNetworkApplyConfiguration {
	b.ensureObjectMetaApplyConfigurationExists()
	if b.Labels == nil && len(entries) > 0 {
		b.Labels = make(map[string]string, len(entries))
	}
	for k, v := range entries {
		b.Labels[k] = v
	}
	return b
}

// WithAnnotations puts the entries into the Annotations field in the declarative configuration
// and returns the receiver, so that objects can be build by chaining "With" function invocations.
// If called multiple times, the entries provided by each call will be put on the Annotations field,
// overwriting an existing map entries in Annotations field with the same key.
func (b *ClusterNetworkApplyConfiguration) WithAnnotations(entries map[string]string) *ClusterNetworkApplyConfiguration {
	b.ensureObjectMetaApplyConfigurationExists()
	if b.Annotations == nil && len(entries) > 0 {
		b.Annotations = make(map[string]string, len(entries))
	}
	for k, v := range entries {
		b.Annotations[k] = v
	}
	return b
}

// WithOwnerReferences adds the given value to the OwnerReferences field in the declarative configuration
// and returns the receiver, so that objects can be build by chaining "With" function invocations.
// If called multiple times, values provided by each call will be appended to the OwnerReferences field.
func (b *ClusterNetworkApplyConfiguration) WithOwnerReferences(values ...*v1.OwnerReferenceApplyConfiguration) *ClusterNetworkApplyConfiguration {
	b.ensureObjectMetaApplyConfigurationExists()
	for i := range values {
		if values[i] == nil {
			panic("nil value passed to WithOwnerReferences")
		}
		b.OwnerReferences = append(b.OwnerReferences, *values[i])
	}
	return b
}

// WithFinalizers adds the given value to the Finalizers field in the declarative configuration
// and returns the receiver, so that objects can be build by chaining "With" function invocations.
// If called multiple times, values provided by each call will be appended to the Finalizers field.
func (b *ClusterNetworkApplyConfiguration) WithFinalizers(values ...string) *ClusterNetworkApplyConfiguration {
	b.ensureObjectMetaApplyConfigurationExists()
	for i := range values {
		b.Finalizers = append(b.Finalizers, values[i])
	}
	return b
}

func (b *ClusterNetworkApplyConfiguration) ensureObjectMetaApplyConfigurationExists() {
	if b.ObjectMetaApplyConfiguration == nil {
		b.ObjectMetaApplyConfiguration = &v1.ObjectMetaApplyConfiguration{}
	}
}

// WithNetwork sets the Network field in the declarative configuration to the given value
// and returns the receiver, so that objects can be built by chaining "With" function invocations.
// If called multiple times, the Network field is set to the value of the last call.
func (b *ClusterNetworkApplyConfiguration) WithNetwork(value string) *ClusterNetworkApplyConfiguration {
	b.Network = &value
	return b
}

// WithHostSubnetLength sets the HostSubnetLength field in the declarative configuration to the given value
// and returns the receiver, so that objects can be built by chaining "With" function invocations.
// If called multiple times, the HostSubnetLength field is set to the value of the last call.
func (b *ClusterNetworkApplyConfiguration) WithHostSubnetLength(value uint32) *ClusterNetworkApplyConfiguration {
	b.HostSubnetLength = &value
	return b
}

// WithServiceNetwork sets the ServiceNetwork field in the declarative configuration to the given value
// and returns the receiver, so that objects can be built by chaining "With" function invocations.
// If called multiple times, the ServiceNetwork field is set to the value of the last call.
func (b *ClusterNetworkApplyConfiguration) WithServiceNetwork(value string) *ClusterNetworkApplyConfiguration {
	b.ServiceNetwork = &value
	return b
}

// WithPluginName sets the PluginName field in the declarative configuration to the given value
// and returns the receiver, so that objects can be built by chaining "With" function invocations.
// If called multiple times, the PluginName field is set to the value of the last call.
func (b *ClusterNetworkApplyConfiguration) WithPluginName(value string) *ClusterNetworkApplyConfiguration {
	b.PluginName = &value
	return b
}

// WithClusterNetworks adds the given value to the ClusterNetworks field in the declarative configuration
// and returns the receiver, so that objects can be build by chaining "With" function invocations.
// If called multiple times, values provided by each call will be appended to the ClusterNetworks field.
func (b *ClusterNetworkApplyConfiguration) WithClusterNetworks(values ...*ClusterNetworkEntryApplyConfiguration) *ClusterNetworkApplyConfiguration {
	for i := range values {
		if values[i] == nil {
			panic("nil value passed to WithClusterNetworks")
		}
		b.ClusterNetworks = append(b.ClusterNetworks, *values[i])
	}
	return b
}

// WithVXLANPort sets the VXLANPort field in the declarative configuration to the given value
// and returns the receiver, so that objects can be built by chaining "With" function invocations.
// If called multiple times, the VXLANPort field is set to the value of the last call.
func (b *ClusterNetworkApplyConfiguration) WithVXLANPort(value uint32) *ClusterNetworkApplyConfiguration {
	b.VXLANPort = &value
	return b
}

// WithMTU sets the MTU field in the declarative configuration to the given value
// and returns the receiver, so that objects can be built by chaining "With" function invocations.
// If called multiple times, the MTU field is set to the value of the last call.
func (b *ClusterNetworkApplyConfiguration) WithMTU(value uint32) *ClusterNetworkApplyConfiguration {
	b.MTU = &value
	return b
}
