// Code generated by client-gen. DO NOT EDIT.

package fake

import (
	"context"
	json "encoding/json"
	"fmt"

	v1 "github.com/openshift/api/config/v1"
	configv1 "github.com/openshift/client-go/config/applyconfigurations/config/v1"
	metav1 "k8s.io/apimachinery/pkg/apis/meta/v1"
	labels "k8s.io/apimachinery/pkg/labels"
	types "k8s.io/apimachinery/pkg/types"
	watch "k8s.io/apimachinery/pkg/watch"
	testing "k8s.io/client-go/testing"
)

// FakeOAuths implements OAuthInterface
type FakeOAuths struct {
	Fake *FakeConfigV1
}

var oauthsResource = v1.SchemeGroupVersion.WithResource("oauths")

var oauthsKind = v1.SchemeGroupVersion.WithKind("OAuth")

// Get takes name of the oAuth, and returns the corresponding oAuth object, and an error if there is any.
func (c *FakeOAuths) Get(ctx context.Context, name string, options metav1.GetOptions) (result *v1.OAuth, err error) {
	obj, err := c.Fake.
		Invokes(testing.NewRootGetAction(oauthsResource, name), &v1.OAuth{})
	if obj == nil {
		return nil, err
	}
	return obj.(*v1.OAuth), err
}

// List takes label and field selectors, and returns the list of OAuths that match those selectors.
func (c *FakeOAuths) List(ctx context.Context, opts metav1.ListOptions) (result *v1.OAuthList, err error) {
	obj, err := c.Fake.
		Invokes(testing.NewRootListAction(oauthsResource, oauthsKind, opts), &v1.OAuthList{})
	if obj == nil {
		return nil, err
	}

	label, _, _ := testing.ExtractFromListOptions(opts)
	if label == nil {
		label = labels.Everything()
	}
	list := &v1.OAuthList{ListMeta: obj.(*v1.OAuthList).ListMeta}
	for _, item := range obj.(*v1.OAuthList).Items {
		if label.Matches(labels.Set(item.Labels)) {
			list.Items = append(list.Items, item)
		}
	}
	return list, err
}

// Watch returns a watch.Interface that watches the requested oAuths.
func (c *FakeOAuths) Watch(ctx context.Context, opts metav1.ListOptions) (watch.Interface, error) {
	return c.Fake.
		InvokesWatch(testing.NewRootWatchAction(oauthsResource, opts))
}

// Create takes the representation of a oAuth and creates it.  Returns the server's representation of the oAuth, and an error, if there is any.
func (c *FakeOAuths) Create(ctx context.Context, oAuth *v1.OAuth, opts metav1.CreateOptions) (result *v1.OAuth, err error) {
	obj, err := c.Fake.
		Invokes(testing.NewRootCreateAction(oauthsResource, oAuth), &v1.OAuth{})
	if obj == nil {
		return nil, err
	}
	return obj.(*v1.OAuth), err
}

// Update takes the representation of a oAuth and updates it. Returns the server's representation of the oAuth, and an error, if there is any.
func (c *FakeOAuths) Update(ctx context.Context, oAuth *v1.OAuth, opts metav1.UpdateOptions) (result *v1.OAuth, err error) {
	obj, err := c.Fake.
		Invokes(testing.NewRootUpdateAction(oauthsResource, oAuth), &v1.OAuth{})
	if obj == nil {
		return nil, err
	}
	return obj.(*v1.OAuth), err
}

// UpdateStatus was generated because the type contains a Status member.
// Add a +genclient:noStatus comment above the type to avoid generating UpdateStatus().
func (c *FakeOAuths) UpdateStatus(ctx context.Context, oAuth *v1.OAuth, opts metav1.UpdateOptions) (*v1.OAuth, error) {
	obj, err := c.Fake.
		Invokes(testing.NewRootUpdateSubresourceAction(oauthsResource, "status", oAuth), &v1.OAuth{})
	if obj == nil {
		return nil, err
	}
	return obj.(*v1.OAuth), err
}

// Delete takes name of the oAuth and deletes it. Returns an error if one occurs.
func (c *FakeOAuths) Delete(ctx context.Context, name string, opts metav1.DeleteOptions) error {
	_, err := c.Fake.
		Invokes(testing.NewRootDeleteActionWithOptions(oauthsResource, name, opts), &v1.OAuth{})
	return err
}

// DeleteCollection deletes a collection of objects.
func (c *FakeOAuths) DeleteCollection(ctx context.Context, opts metav1.DeleteOptions, listOpts metav1.ListOptions) error {
	action := testing.NewRootDeleteCollectionAction(oauthsResource, listOpts)

	_, err := c.Fake.Invokes(action, &v1.OAuthList{})
	return err
}

// Patch applies the patch and returns the patched oAuth.
func (c *FakeOAuths) Patch(ctx context.Context, name string, pt types.PatchType, data []byte, opts metav1.PatchOptions, subresources ...string) (result *v1.OAuth, err error) {
	obj, err := c.Fake.
		Invokes(testing.NewRootPatchSubresourceAction(oauthsResource, name, pt, data, subresources...), &v1.OAuth{})
	if obj == nil {
		return nil, err
	}
	return obj.(*v1.OAuth), err
}

// Apply takes the given apply declarative configuration, applies it and returns the applied oAuth.
func (c *FakeOAuths) Apply(ctx context.Context, oAuth *configv1.OAuthApplyConfiguration, opts metav1.ApplyOptions) (result *v1.OAuth, err error) {
	if oAuth == nil {
		return nil, fmt.Errorf("oAuth provided to Apply must not be nil")
	}
	data, err := json.Marshal(oAuth)
	if err != nil {
		return nil, err
	}
	name := oAuth.Name
	if name == nil {
		return nil, fmt.Errorf("oAuth.Name must be provided to Apply")
	}
	obj, err := c.Fake.
		Invokes(testing.NewRootPatchSubresourceAction(oauthsResource, *name, types.ApplyPatchType, data), &v1.OAuth{})
	if obj == nil {
		return nil, err
	}
	return obj.(*v1.OAuth), err
}

// ApplyStatus was generated because the type contains a Status member.
// Add a +genclient:noStatus comment above the type to avoid generating ApplyStatus().
func (c *FakeOAuths) ApplyStatus(ctx context.Context, oAuth *configv1.OAuthApplyConfiguration, opts metav1.ApplyOptions) (result *v1.OAuth, err error) {
	if oAuth == nil {
		return nil, fmt.Errorf("oAuth provided to Apply must not be nil")
	}
	data, err := json.Marshal(oAuth)
	if err != nil {
		return nil, err
	}
	name := oAuth.Name
	if name == nil {
		return nil, fmt.Errorf("oAuth.Name must be provided to Apply")
	}
	obj, err := c.Fake.
		Invokes(testing.NewRootPatchSubresourceAction(oauthsResource, *name, types.ApplyPatchType, data, "status"), &v1.OAuth{})
	if obj == nil {
		return nil, err
	}
	return obj.(*v1.OAuth), err
}
