package mp4

import (
	"bytes"
	"io/ioutil"
	"testing"
)

func TestDecodEncodeFile(t *testing.T) {
	testFiles := []string{
		"1.m4s",
		"prog_8s.mp4",
	}
	for _, testFile := range testFiles {
		raw, err := ioutil.ReadFile("testdata/" + testFile)
		if err != nil {
			t.Error(err)
		}
		rawOut := make([]byte, 0, len(raw))
		outBuf := bytes.NewBuffer(rawOut)
		t.Run(testFile, func(t *testing.T) {
			buf := bytes.NewBuffer(raw)
			f, err := DecodeFile(buf)
			if err != nil {
				t.Error(err)
			}
			outBuf.Reset()
			f.FragEncMode = EncModeBoxTree
			err = f.Encode(outBuf)
			if err != nil {
				t.Error(err)
			}
			if !bytes.Equal(raw, outBuf.Bytes()) {
				t.Errorf("%s: generated bytes differ from input", testFile)
			}
		})
	}
}

func BenchmarkDecodeFile(b *testing.B) {
	testFiles := []string{
		"1.m4s",
		"prog_8s.mp4",
	}
	for _, testFile := range testFiles {
		raw, _ := ioutil.ReadFile("testdata/" + testFile)
		b.Run(testFile, func(b *testing.B) {
			for i := 0; i < b.N; i++ {
				buf := bytes.NewBuffer(raw)
				_, _ = DecodeFile(buf)
			}
		})
	}
}

func BenchmarkEncodeFile(b *testing.B) {
	testFiles := []string{
		"1.m4s",
		"prog_8s.mp4",
	}
	for _, testFile := range testFiles {
		raw, _ := ioutil.ReadFile("testdata/" + testFile)
		inBuf := bytes.NewBuffer(raw)
		decFile, _ := DecodeFile(inBuf)
		rawOut := make([]byte, 0, len(raw))
		outBuf := bytes.NewBuffer(rawOut)
		b.Run(testFile, func(b *testing.B) {
			for i := 0; i < b.N; i++ {
				outBuf.Reset()
				_ = decFile.Encode(outBuf)
			}
		})
	}
}
