//go:build integration
// +build integration

/*
Maddy Mail Server - Composable all-in-one email server.
Copyright © 2019-2020 Max Mazurov <fox.cpp@disroot.org>, Maddy Mail Server contributors

This program is free software: you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation, either version 3 of the License, or
(at your option) any later version.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with this program.  If not, see <https://www.gnu.org/licenses/>.
*/

package tests_test

import (
	"strconv"
	"testing"
	"time"

	"github.com/foxcpp/maddy/internal/testutils"
	"github.com/foxcpp/maddy/tests"
)

func TestIssue327(tt *testing.T) {
	tt.Parallel()
	t := tests.NewT(tt)
	t.DNS(nil)
	t.Port("smtp")
	tgtPort := t.Port("target")
	t.Config(`
		hostname mx.maddy.test
		tls off
		smtp tcp://127.0.0.1:{env:TEST_PORT_smtp} {
			deliver_to queue outbound_queue {
				target remote { } # it will fail
				autogenerated_msg_domain maddy.test
				bounce {
					check {
						spf
					}
					deliver_to lmtp tcp://127.0.0.1:{env:TEST_PORT_target}
				}
			}
		}`)
	t.Run(1)
	defer t.Close()

	be, s := testutils.SMTPServer(tt, "127.0.0.1:"+strconv.Itoa(int(tgtPort)))
	s.LMTP = true
	be.LMTPDataErr = []error{nil, nil}
	defer s.Close()

	c := t.Conn("smtp")
	defer c.Close()
	c.SMTPNegotation("client.maddy.test", nil, nil)
	c.Writeln("MAIL FROM:<from@maddy.test>")
	c.ExpectPattern("250 *")
	c.Writeln("RCPT TO:<to1@maddy.test>")
	c.ExpectPattern("250 *")
	c.Writeln("DATA")
	c.ExpectPattern("354 *")
	c.Writeln("From: <from@maddy.test>")
	c.Writeln("To: <to@maddy.test>")
	c.Writeln("Subject: Hello!")
	c.Writeln("")
	c.Writeln("Hello!")
	c.Writeln(".")
	c.ExpectPattern("250 2.0.0 OK: queued")
	c.Writeln("QUIT")
	c.ExpectPattern("221 *")

	for i := 0; i < 5; i++ {
		time.Sleep(1 * time.Second)
		if len(be.Messages) != 0 {
			break
		}
	}

	if len(be.Messages) != 1 {
		t.Fatal("No DSN sent?", len(be.Messages))
	}
}
