// log.testdata
// copyright (C) 2005  F. de Dinechin, Ch. Q. Lauter and V.Lefevre
// This file is part of crlibm and is distributed under the GNU Public Licence
// See file COPYING for details
// The following lines are either comments (beginning with a #)
// or give
//   1/ a rounding mode : RN|RU|RD|RZ (crlibm syntax) or  N|P|M|Z (libmcr syntax)
//   2/ The high and low hexadecimal halves of an input
//   3/ The high and low hexadecimal halves of the expected corresponding output
// Special cases
T(RN,                  0x0p+0,                    -inf,          0x0p+0, DIVBYZERO) // zero
T(RN,                 -0x0p+0,                    -inf,          0x0p+0, DIVBYZERO) // -zero
T(RU,                  0x0p+0,                    -inf,          0x0p+0, DIVBYZERO) // zero
T(RU,                 -0x0p+0,                    -inf,          0x0p+0, DIVBYZERO) // -zero
T(RD,                  0x0p+0,                    -inf,          0x0p+0, DIVBYZERO) // zero
T(RD,                 -0x0p+0,                    -inf,          0x0p+0, DIVBYZERO) // -zero
T(RZ,                  0x0p+0,                    -inf,          0x0p+0, DIVBYZERO) // zero
T(RZ,                 -0x0p+0,                    -inf,          0x0p+0, DIVBYZERO) // -zero
T(RN,               0x1p-1074,   -0x1.74385446d71c3p+9,    0x1.8e56ap-2, INEXACT) // smallest denorm positive
T(RN,              -0x1p-1074,                     nan,          0x0p+0, INVALID) // smallest denorm negative
T(RU,               0x1p-1074,   -0x1.74385446d71c3p+9,    0x1.8e56ap-2, INEXACT) // smallest denorm positive
T(RU,              -0x1p-1074,                     nan,          0x0p+0, INVALID) // smallest denorm negative
T(RD,               0x1p-1074,   -0x1.74385446d71c4p+9,   -0x1.38d4bp-1, INEXACT) // smallest denorm positive
T(RD,              -0x1p-1074,                     nan,          0x0p+0, INVALID) // smallest denorm negative
T(RZ,               0x1p-1074,   -0x1.74385446d71c3p+9,    0x1.8e56ap-2, INEXACT) // smallest denorm positive
T(RZ,              -0x1p-1074,                     nan,          0x0p+0, INVALID) // smallest denorm negative
T(RN,                     inf,                     inf,          0x0p+0, 0) // +inf
T(RN,                    -inf,                     nan,          0x0p+0, INVALID) // -inf
T(RU,                     inf,                     inf,          0x0p+0, 0) // +inf
T(RU,                    -inf,                     nan,          0x0p+0, INVALID) // -inf
T(RD,                     inf,                     inf,          0x0p+0, 0) // +inf
T(RD,                    -inf,                     nan,          0x0p+0, INVALID) // -inf
T(RZ,                     inf,                     inf,          0x0p+0, 0) // +inf
T(RZ,                    -inf,                     nan,          0x0p+0, INVALID) // -inf
T(RN,                     nan,                     nan,          0x0p+0, 0) // NaN
T(RU,                     nan,                     nan,          0x0p+0, 0) // NaN
T(RD,                     nan,                     nan,          0x0p+0, 0) // NaN
T(RZ,                     nan,                     nan,          0x0p+0, 0) // NaN
T(RN,                  0x1p+0,                  0x0p+0,          0x0p+0, 0) // one
T(RU,                  0x1p+0,                  0x0p+0,          0x0p+0, 0)
T(RD,                  0x1p+0,                  0x0p+0,          0x0p+0, 0)
T(RZ,                  0x1p+0,                  0x0p+0,          0x0p+0, 0)
// One in five of the very worst cases computed by Lefevre and Muller.
// Rounding these values requires evaluating the function to at least 2^(-100).
// These worst cases have been selected thanks to the filterlists 5 script
// If you want the full list please contact Jean-Michel Muller
T(RZ,    0x1.bdfbc244c2cfep+0,    0x1.1c36a38ab4c0ap-1, -0x1.149b28p-50, INEXACT) // 1.742122785365438186744313497911e+00
T(RN,    0x1.b9f1fa4587967p+0,    0x1.178e6d3ecaceap-1,          0x1p-1, INEXACT) // 1.726348535513887005876654257008e+00
T(RZ,    0x1.01f2ebd9637eap+2,    0x1.64d5380fe51dep+0, -0x1.62e236p-52, INEXACT) // 4.030451738637546910126729926560e+00
T(RN,    0x1.05eb7625384e6p+2,     0x1.68be647615f3p+0,         -0x1p-1, INEXACT) // 4.092496429774859834083144960459e+00
T(RZ,    0x1.ad1f307c316afp+1,    0x1.35af982f6e796p+0, -0x1.3d924cp-52, INEXACT) // 3.352514324799663381071468393202e+00
T(RN,    0x1.6de110c79fac5p+2,    0x1.be50c68dbf2e8p+0,         -0x1p-1, INEXACT) // 5.716861910767595311710920213955e+00
T(RN,    0x1.9e892bc616246p+2,    0x1.de475b4897288p+0,          0x1p-1, INEXACT) // 6.477122252887573594648529251572e+00
T(RZ,    0x1.cce0060a74e38p+2,    0x1.f9680d93348c1p+0, -0x1.9d4698p-52, INEXACT) // 7.201173315249938866600132314488e+00
T(RZ,    0x1.03870c921acb9p+3,    0x1.0beb951810e2bp+1, -0x1.3868f4p-52, INEXACT) // 8.110235486374550717414422251750e+00
T(RN,    0x1.11867637cbd03p+4,    0x1.6b5df7e3cd422p+1,          0x1p-1, INEXACT) // 1.709532758517617523352782882284e+01
T(RZ,    0x1.6a942e8e7679cp+4,    0x1.8f71907199198p+1, -0x1.357b56p-52, INEXACT) // 2.266117721223382375228538876399e+01
T(RN,    0x1.8b247b74ee4b5p+5,    0x1.f32cceeae323dp+1,          0x1p-1, INEXACT) // 4.939281360008445886933259316720e+01
T(RZ,    0x1.1c23f3bc09a76p+6,    0x1.10d7d8d3ce42cp+2,         -0x1p+0, INEXACT) // 7.103510946091577693550789263099e+01
T(RN,    0x1.bdd793fe7b41cp+7,    0x1.5a094d02db358p+2,         -0x1p-1, INEXACT) // 2.229210509801349644476431421936e+02
T(RZ,    0x1.ac50b409c8aeep+8,    0x1.83d4bcdebb3f3p+2,         -0x1p+0, INEXACT) // 4.283152471651982295952620916069e+02
T(RN,   0x1.0dfe7ad41fd87p+17,    0x1.7ac672a5cea6ep+3,          0x1p-1, INEXACT) // 1.382369595985228370409458875656e+05
T(RZ,   0x1.22306b68a614bp+22,    0x1.ebfcab6287493p+3,         -0x1p+0, INEXACT) // 4.754458852196048013865947723389e+06
T(RN,   0x1.30dafba546295p+24,    0x1.0cf68c5f1466dp+4,          0x1p-1, INEXACT) // 1.997900364560182765126228332520e+07
T(RN,    0x1.0bb1a825d53dp+30,    0x1.4d6ce1abf2cccp+4,          0x1p-1, INEXACT) // 1.122789897458240509033203125000e+09
T(RN,   0x1.33e19970f77b8p+33,    0x1.70ef2e31813d1p+4,          0x1p-1, INEXACT) // 1.033078038593345642089843750000e+10
T(RZ,   0x1.a8c02e974c315p+25,    0x1.1d5c2daebe367p+4,    -0x1.202p-60, INEXACT) // 5.567292518201271444559097290039e+07
T(RN,   0x1.73e874fe9220cp+25,    0x1.1b3c004006063p+4,         -0x1p-1, INEXACT) // 4.874672998883447051048278808594e+07
T(RN,   0x1.bc4dd1dc00b0fp+37,    0x1.a32a18700a585p+4,         -0x1p-1, INEXACT) // 2.385338848000863952636718750000e+11
T(RN,   0x1.bcc715a6c1dc8p+47,    0x1.090ae2604154fp+5,          0x1p-1, INEXACT) // 2.445191122372942500000000000000e+14
T(RN,   0x1.c76131364e7ebp+58,    0x1.463a593b928e7p+5,         -0x1p-1, INEXACT) // 5.127119135830166400000000000000e+17
T(RZ,   0x1.109d5d91037d9p+64,    0x1.6364f83b05572p+5,         -0x1p+0, INEXACT) // 1.964396002707017318400000000000e+19
T(RZ,   0x1.a97e7be23e65ap+90,    0x1.f7216c4b435c9p+5,  -0x1.ec768p-58, INEXACT) // 2.057563107060637919275384832000e+27
T(RN,   0x1.9b83394eee5e3p+81,    0x1.c4f4e85a701adp+5,          0x1p-1, INEXACT) // 3.886626554866153558114304000000e+24
T(RN,  0x1.04517520386e5p+137,    0x1.7be95c41da94ap+6,         -0x1p-1, INEXACT) // 1.771633820386861034876266359433e+41
T(RN,  0x1.20738f115065bp+148,    0x1.9ad20e18b3103p+6,         -0x1p-1, INEXACT) // 4.020425758407352332424907032761e+44
T(RN,  0x1.c35165a3660fbp+149,    0x1.9f623a0be684bp+6,          0x1p-1, INEXACT) // 1.258090845676367300551036533084e+45
T(RZ,  0x1.0bd73b73fc74cp+207,    0x1.1f0da93354197p+7,         -0x1p+0, INEXACT) // 2.152017462376579206251183125431e+62
T(RZ,  0x1.37e7ac4e7f9b3p+246,    0x1.556c678d5e975p+7,         -0x1p+0, INEXACT) // 1.377720964824664482963749825978e+74
T(RN,  0x1.b7f71a488641ap+340,    0x1.d86c518ceab6bp+7,          0x1p-1, INEXACT) // 3.849257202283993873346921882146e+102
T(RN,  0x1.49f24f35d3f37p+344,    0x1.dd648c587cb4fp+7,         -0x1p-1, INEXACT) // 4.618724912198040172360765091227e+103
T(RZ,  0x1.db9797d3d32e8p+415,    0x1.204684c1167e9p+8,   -0x1.6bc4p-61, INEXACT) // 1.571965181886189361545056053170e+125
T(RN,  0x1.6ab13075e3f2dp+457,    0x1.3d1ddc04ad601p+8,          0x1p-1, INEXACT) // 5.272373929833471134047051998241e+137
T(RN,  0x1.382c35530591fp+521,    0x1.6953fbc004beep+8,          0x1p-1, INEXACT) // 8.371102901169478769707544639120e+156
T(RN,  0x1.d4a93d69f93ebp+463,    0x1.41882720c76efp+8,          0x1p-1, INEXACT) // 4.360205199608654982781689672527e+139
T(RZ,  0x1.758247d0be2e1p+534,    0x1.7284b32a0d4b9p+8,         -0x1p+0, INEXACT) // 8.205001855507490349849897983744e+160
T(RN,  0x1.6b3d29c0f9e6ep+543,     0x1.78ba92cb3239p+8,         -0x1p-1, INEXACT) // 4.085451451341444578026962920645e+163
T(RN,  0x1.5b46700fda328p+678,    0x1.d6423c05cc7d6p+8,          0x1p-1, INEXACT) // 1.701260423947209564115417991829e+204
T(RZ,  0x1.2b67eff65dce8p+709,    0x1.eb9914d4ac1c8p+8,   -0x1.b8c8p-62, INEXACT) // 3.149832555079405488339917129684e+213
T(RN,  0x1.be87838f1a47cp+774,    0x1.0c86affa8af55p+9,          0x1p-1, INEXACT) // 1.733112241129305460689242039638e+233
T(RN,  0x1.31143c7c0b1e6p+962,    0x1.4d7dd253b66d7p+9,         -0x1p-1, INEXACT) // 4.645454875450314099508213998054e+289
T(RZ,    0x1.2062bf45679f6p-1,    -0x1.25e6b237c2d9p-1,  0x1.7c0c4cp-51, INEXACT) // 5.632533809874178398757749164361e-01
T(RN,    0x1.25fd45593f228p-1,   -0x1.1c0c45537d87ep-1,         -0x1p-1, INEXACT) // 5.741979285663250109905675344635e-01
T(RZ,    0x1.2ae27ea671361p-1,   -0x1.1397add4538acp-1,  0x1.d1272cp-51, INEXACT) // 5.837592676331092578223547207017e-01
T(RZ,    0x1.468e956d45383p-1,   -0x1.cc83748b7669dp-2,          0x1p+0, INEXACT) // 6.378065772902207219985371011717e-01
T(RZ,    0x1.507e542d9849dp-1,   -0x1.add1dce7cd5bcp-2,   0x1.dd046p-51, INEXACT) // 6.572138124139602632922674274596e-01
T(RN,    0x1.edeffbdb1a6e6p-1,   -0x1.2638cff387e06p-5,         -0x1p-1, INEXACT) // 9.647215561828630381313587349723e-01
T(RZ,    0x1.1538ea18a4585p+0,    0x1.46370d915991ap-4,         -0x1p+0, INEXACT) // 1.082899695411783769216640394006e+00
T(RZ,    0x1.47408cb9583cep+0,    0x1.f6e4c3ced7c71p-3,         -0x1p+0, INEXACT) // 1.278328700304189435854596013087e+00
T(RZ,    0x1.512b3126454f3p+0,    0x1.1a0408712e009p-2,         -0x1p+0, INEXACT) // 1.317065307467882417924442961521e+00
T(RN,    0x1.789e95b11578cp+0,    0x1.8b52c15ea9c23p-2,         -0x1p-1, INEXACT) // 1.471169810994498838851995969890e+00
T(RN,    0x1.b9f1fa4587967p+0,    0x1.178e6d3ecaceap-1,          0x1p-1, INEXACT) // 1.726348535513887005876654257008e+00
T(RZ,    0x1.0000000000002p+0,   0x1.ffffffffffffep-52, -0x1.555554p-51, INEXACT) // 1.000000000000000444089209850063e+00
// The following are one fifth of Sun's values distributed with libmcr 0.9,
// again using filterlists 5
T(RN,  0x1.c801ddf0ef4a3p-151,   -0x1.a05a00991e8a3p+6,  -0x1.ffa55ep-2, INEXACT)
T(RN,  0x1.74aabbb8a16e5p+789,    0x1.11a262919c079p+9,  -0x1.ff28eap-2, INEXACT)
T(RN,  0x1.ed4775529558dp-385,   -0x1.0a34ad213ccd1p+8,  -0x1.ff1978p-2, INEXACT)
T(RZ,  0x1.a712fbeade504p+211,    0x1.25834a278649cp+7, -0x1.b28588p-11, INEXACT)
T(RD,  0x1.a712fbeade504p+211,    0x1.25834a278649cp+7, -0x1.b28588p-11, INEXACT)
T(RU,  0x1.a712fbeade504p+211,    0x1.25834a278649dp+7,   0x1.ff935ep-1, INEXACT)
T(RZ,  0x1.c478ccc2014cep-178,   -0x1.eb3e1b073241fp+6,   0x1.ffab42p-1, INEXACT)
T(RU,  0x1.c478ccc2014cep-178,   -0x1.eb3e1b073241fp+6,   0x1.ffab42p-1, INEXACT)
T(RD,  0x1.c478ccc2014cep-178,    -0x1.eb3e1b073242p+6, -0x1.52f434p-11, INEXACT)
T(RN,  0x1.90ae90e99ad29p+129,    0x1.6774b64e32de6p+6,  -0x1.ffb28cp-2, INEXACT)
T(RN,  0x1.87d8123d3eb89p+722,    0x1.f4e0c1621958cp+8,  -0x1.ffa364p-2, INEXACT)
T(RN,  0x1.fffaef23f6059p+233,    0x1.44648ec0291adp+7,   -0x1.ffffep-2, INEXACT)
T(RZ,  0x1.f0ff0034baafap-576,   -0x1.8e96e1092c381p+8,   0x1.fff668p-1, INEXACT)
T(RU,  0x1.f0ff0034baafap-576,   -0x1.8e96e1092c381p+8,   0x1.fff668p-1, INEXACT)
T(RD,  0x1.f0ff0034baafap-576,   -0x1.8e96e1092c382p+8, -0x1.32e538p-14, INEXACT)
T(RZ,  0x1.ab0cf26400992p+417,    0x1.218dd9738cd1fp+8,  -0x1.fff2d2p-1, INEXACT)
T(RD,  0x1.ab0cf26400992p+417,    0x1.218dd9738cd1fp+8,  -0x1.fff2d2p-1, INEXACT)
T(RU,  0x1.ab0cf26400992p+417,     0x1.218dd9738cd2p+8,  0x1.a5b316p-14, INEXACT)
T(RZ,   0x1.73a22a6e16c6dp+60,    0x1.4fb1471f1f0b9p+5,  -0x1.fff9e2p-1, INEXACT)
T(RD,   0x1.73a22a6e16c6dp+60,    0x1.4fb1471f1f0b9p+5,  -0x1.fff9e2p-1, INEXACT)
T(RU,   0x1.73a22a6e16c6dp+60,    0x1.4fb1471f1f0bap+5,  0x1.87444ap-15, INEXACT)
T(RZ,  0x1.656269ed5a8cbp-530,   -0x1.6f08cc8b7e3f7p+8,   0x1.fffafep-1, INEXACT)
T(RU,  0x1.656269ed5a8cbp-530,   -0x1.6f08cc8b7e3f7p+8,   0x1.fffafep-1, INEXACT)
T(RD,  0x1.656269ed5a8cbp-530,   -0x1.6f08cc8b7e3f8p+8, -0x1.408788p-15, INEXACT)
T(RZ,  0x1.0fa1e33b84241p-184,   -0x1.fdeb531283c29p+6,   0x1.fff422p-1, INEXACT)
T(RU,  0x1.0fa1e33b84241p-184,   -0x1.fdeb531283c29p+6,   0x1.fff422p-1, INEXACT)
T(RD,  0x1.0fa1e33b84241p-184,   -0x1.fdeb531283c2ap+6, -0x1.7ba56cp-14, INEXACT)
T(RN,  0x1.eff4d3091605bp+291,    0x1.94bbf9c66a82bp+7,  -0x1.fff20ep-2, INEXACT)
T(RN,  0x1.3c365d3db4e96p+320,    0x1.bc09631ea7e67p+7,  -0x1.ffe606p-2, INEXACT)
T(RN,  0x1.ccce67200e6fdp-106,    -0x1.238b0f634482p+6,  -0x1.fffec2p-2, INEXACT)
T(RZ,   0x1.51905ad0269ap-613,   -0x1.a89f659ea81c3p+8,  0x1.00664cp-19, INEXACT)
T(RU,   0x1.51905ad0269ap-613,   -0x1.a89f659ea81c3p+8,  0x1.00664cp-19, INEXACT)
T(RD,   0x1.51905ad0269ap-613,   -0x1.a89f659ea81c4p+8,   -0x1.ffffcp-1, INEXACT)
T(RZ,  0x1.df3d14c7695cep+998,    0x1.5a31a6f2a8f79p+9, -0x1.d21874p-17, INEXACT)
T(RD,  0x1.df3d14c7695cep+998,    0x1.5a31a6f2a8f79p+9, -0x1.d21874p-17, INEXACT)
T(RU,  0x1.df3d14c7695cep+998,    0x1.5a31a6f2a8f7ap+9,   0x1.fffe2ep-1, INEXACT)
T(RN,  0x1.4d2ea2411d301p-516,   -0x1.656682cae5104p+8,  -0x1.fffe06p-2, INEXACT)
T(RZ,  0x1.9297df0276db8p-985,   -0x1.55260b6be9567p+9,  0x1.9ff55ap-18, INEXACT)
T(RU,  0x1.9297df0276db8p-985,   -0x1.55260b6be9567p+9,  0x1.9ff55ap-18, INEXACT)
T(RD,  0x1.9297df0276db8p-985,   -0x1.55260b6be9568p+9,   -0x1.ffff3p-1, INEXACT)
T(RN,   0x1.fc5da34559d7p+536,    0x1.7436816fd2512p+8,  -0x1.fffc68p-2, INEXACT)
T(RN,  0x1.8f2225b7a7f01p+692,     0x1.e01a1a853bbfp+8,  -0x1.ffffeap-2, INEXACT)
T(RN,   0x1.95340cb17408p-142,   -0x1.87dee9a288dd6p+6,  -0x1.ffff84p-2, INEXACT)
T(RZ,  0x1.a3a9b267d484fp-140,   -0x1.822f71650e3d6p+6,   0x1.ffffdap-1, INEXACT)
T(RU,  0x1.a3a9b267d484fp-140,   -0x1.822f71650e3d6p+6,   0x1.ffffdap-1, INEXACT)
T(RD,  0x1.a3a9b267d484fp-140,   -0x1.822f71650e3d7p+6, -0x1.2a6426p-20, INEXACT)
T(RN,   0x1.97912e7b6c53bp-50,   -0x1.1189e4c213767p+5,   -0x1.ffff9p-2, INEXACT)
T(RN,  0x1.c1689d1afe5bap+447,    0x1.3666489289951p+8,  -0x1.ffffccp-2, INEXACT)
T(RN,  0x1.7b3e9ce156956p+805,    0x1.173030a2ad8ddp+9,  -0x1.ffff88p-2, INEXACT)
T(RZ, 0x1.bac883973bd33p-1014,   -0x1.5f26d3c8c32dfp+9,  0x1.732c58p-23, INEXACT)
T(RU, 0x1.bac883973bd33p-1014,   -0x1.5f26d3c8c32dfp+9,  0x1.732c58p-23, INEXACT)
T(RD, 0x1.bac883973bd33p-1014,    -0x1.5f26d3c8c32ep+9,  -0x1.fffffap-1, INEXACT)
T(RN,  0x1.5584b1e4a15b2p-354,   -0x1.ea2bf832ecf53p+7,  -0x1.ffff8ap-2, INEXACT)
T(RN,   0x1.3ed1df999d2ap-619,   -0x1.acd6b22a8ffb2p+8,  -0x1.fffffep-2, INEXACT)
T(RN,  0x1.8180385e3411fp+266,    0x1.7192b239ed8d8p+7,   -0x1.fffffp-2, INEXACT)
T(RN,   0x1.db829630f76cep-84,   -0x1.ccd75a2ef71c7p+5,  -0x1.fffff2p-2, INEXACT)
T(RZ,  0x1.9cb08f2e629a5p+989,    0x1.5700029fafb6ep+9,         -0x1p+0, INEXACT)
T(RD,  0x1.9cb08f2e629a5p+989,    0x1.5700029fafb6ep+9,         -0x1p+0, INEXACT)
T(RU,  0x1.9cb08f2e629a5p+989,    0x1.5700029fafb6fp+9,  0x1.395be8p-31, INEXACT)
T(RZ,  0x1.fbf3b87a3fb02p+256,    0x1.644303b9c9481p+7,  -0x1.fffffep-1, INEXACT)
T(RD,  0x1.fbf3b87a3fb02p+256,    0x1.644303b9c9481p+7,  -0x1.fffffep-1, INEXACT)
T(RU,  0x1.fbf3b87a3fb02p+256,    0x1.644303b9c9482p+7,  0x1.763beap-24, INEXACT)
T(RZ,  0x1.ed42376f2c12cp-486,   -0x1.5036b34e6ea95p+8,   0x1.fffffcp-1, INEXACT)
T(RU,  0x1.ed42376f2c12cp-486,   -0x1.5036b34e6ea95p+8,   0x1.fffffcp-1, INEXACT)
T(RD,  0x1.ed42376f2c12cp-486,   -0x1.5036b34e6ea96p+8, -0x1.331d88p-23, INEXACT)
T(RN,  0x1.55148d7c2b924p+279,    0x1.83599a19b582cp+7,  -0x1.fffffap-2, INEXACT)
T(RZ,  0x1.c9273187a9e4fp+611,    0x1.a817bfa880fabp+8,         -0x1p+0, INEXACT)
T(RD,  0x1.c9273187a9e4fp+611,    0x1.a817bfa880fabp+8,         -0x1p+0, INEXACT)
T(RU,  0x1.c9273187a9e4fp+611,    0x1.a817bfa880facp+8,  0x1.c7b9c8p-26, INEXACT)
T(RN,  0x1.dd091b1909c9ep+551,    0x1.7e8be8160642cp+8,         -0x1p-1, INEXACT)
T(RZ,  0x1.884c0766ab85ap+672,    0x1.d238c46a70d1ep+8,         -0x1p+0, INEXACT)
T(RD,  0x1.884c0766ab85ap+672,    0x1.d238c46a70d1ep+8,         -0x1p+0, INEXACT)
T(RU,  0x1.884c0766ab85ap+672,    0x1.d238c46a70d1fp+8,  0x1.437084p-26, INEXACT)
T(RN,  0x1.b800a205f7372p-488,   -0x1.51b6d7338bbbcp+8,         -0x1p-1, INEXACT)
T(RN,  0x1.4c6b09e6a0165p-207,   -0x1.1e70c4a3edbbbp+7,         -0x1p-1, INEXACT)
T(RN,   0x1.f3fce664ce889p-69,   -0x1.794311eb95eecp+5,  -0x1.fffffep-2, INEXACT)
T(RN,  0x1.448e6bbf82fb2p-424,   -0x1.25a8393497ac3p+8,  -0x1.fffffep-2, INEXACT)
T(RN,  0x1.b7efd549e6839p+359,    0x1.f2c338a5f0ca8p+7,  -0x1.fffffep-2, INEXACT)
T(RN,   0x1.b3f415c812f1p+474,    0x1.491588febf34cp+8,         -0x1p-1, INEXACT)
T(RZ,  0x1.7e097af81e0d9p+160,    0x1.bd372ead1aad5p+6, -0x1.9fb4f8p-30, INEXACT)
T(RD,  0x1.7e097af81e0d9p+160,    0x1.bd372ead1aad5p+6, -0x1.9fb4f8p-30, INEXACT)
T(RU,  0x1.7e097af81e0d9p+160,    0x1.bd372ead1aad6p+6,          0x1p+0, INEXACT)
T(RZ,  0x1.9ad7f82bc157ap-633,   -0x1.b64a046d6e8bep+8,          0x1p+0, INEXACT)
T(RU,  0x1.9ad7f82bc157ap-633,   -0x1.b64a046d6e8bep+8,          0x1p+0, INEXACT)
T(RD,  0x1.9ad7f82bc157ap-633,   -0x1.b64a046d6e8bfp+8, -0x1.b84572p-29, INEXACT)
T(RZ,  0x1.b5ffc2106cd0bp+479,    0x1.4c8df6412b00bp+8, -0x1.86389ap-29, INEXACT)
T(RD,  0x1.b5ffc2106cd0bp+479,    0x1.4c8df6412b00bp+8, -0x1.86389ap-29, INEXACT)
T(RU,  0x1.b5ffc2106cd0bp+479,    0x1.4c8df6412b00cp+8,          0x1p+0, INEXACT)
T(RN,  0x1.1157f32defcc2p-545,   -0x1.79b31d02837eep+8,         -0x1p-1, INEXACT)
T(RN,   0x1.aad569a04ad5bp+96,    0x1.0c36a06501e68p+6,         -0x1p-1, INEXACT)
T(RN,  0x1.a4211cf9dee61p+555,    0x1.81312b86a14f2p+8,         -0x1p-1, INEXACT)
T(RN,    0x1.00368aaa85f8ep+0,   0x1.b426df9ca1013p-11,  -0x1.ebe4eep-4, INEXACT)
T(RN,    0x1.f798744fa0f13p-1,   -0x1.0f2ccdc3c4e83p-6,   0x1.c0f1a8p-2, INEXACT)
T(RN,    0x1.f928110873fc7p-1,    -0x1.b8efd1fd456cp-7,  -0x1.0bc46cp-3, INEXACT)
T(RN,    0x1.076d09bb5b24dp+0,    0x1.d47f35de63c04p-6,  -0x1.60de74p-3, INEXACT)
T(RN,    0x1.041a73ba062c6p+0,    0x1.0487d3b836a4bp-6,   0x1.db131cp-2, INEXACT)
T(RN,    0x1.04f5f052470afp+0,    0x1.3a72a28505a64p-6,  -0x1.368324p-2, INEXACT)
T(RN,     0x1.fa4e8e36b607p-1,   -0x1.6e66e9c396765p-7,  -0x1.a278e2p-5, INEXACT)
T(RN,    0x1.fb4c00d5724ebp-1,   -0x1.2e63e1d2800e8p-7,   0x1.998844p-2, INEXACT)
T(RN,    0x1.0462559177efcp+0,    0x1.163544f847164p-6,   0x1.c0cdf4p-2, INEXACT)
T(RN,    0x1.05a14dd1f7ccep+0,    0x1.646bc054d2d47p-6,  -0x1.59963ap-2, INEXACT)
T(RN,    0x1.fd6aa8e9ccb4ep-1,   -0x1.4b81d30de8235p-8,   0x1.e126e8p-5, INEXACT)
T(RN,  0x1.db684204681f6p+573,    0x1.8dcad6100a555p+8, -0x1.f60a64p-11, INEXACT)
T(RN,  0x1.5e0c977c87ae3p-371,   -0x1.00d83ec47557dp+8, -0x1.0ed086p-13, INEXACT)
T(RN,  0x1.513984cea4328p-526,   -0x1.6c51e15c97b73p+8, -0x1.5820f2p-10, INEXACT)
T(RN,   0x1.49c29b1a3bba6p-47,   -0x1.02990ba8e0062p+5,   0x1.7a0d88p-7, INEXACT)
T(RN,   0x1.3295d9ab6e73ep+46,     0x1.00854d68d011p+5,  -0x1.20e60cp-8, INEXACT)
T(RN,  0x1.e0b2544e8ec2fp+402,    0x1.1746752ca8d02p+8,  0x1.96c966p-16, INEXACT)
T(RN,  0x1.052d6e42dea43p-948,   -0x1.488ab04687769p+9, -0x1.d5609ap-11, INEXACT)
T(RN,  0x1.8ad934b838bdap+476,    0x1.4a5f12ed407a4p+8, -0x1.06c8bep-13, INEXACT)
T(RN,  0x1.51f4009a9eb0bp+693,    0x1.e0a0f42e73a08p+8,  0x1.3bb5d2p-11, INEXACT)
T(RN,  0x1.df4ab02657ff3p+956,    0x1.4ba34e9da778cp+9,  0x1.dff9e4p-13, INEXACT)
T(RN,    0x1.51cb453b9536cp+0,    0x1.1be9bff2e94bfp-2,   0x1.d1be8ep-2, INEXACT)
T(RN,    0x1.3b2c47bff8329p+0,     0x1.a9de9fec5df2p-3,   0x1.730bd6p-3, INEXACT)
T(RN,    0x1.5999999999988p+1,    0x1.fc8b7f138bdcfp-1,  -0x1.b84766p-2, INEXACT)
T(RN,    0x1.733333333332cp+1,    0x1.1090e2031520dp+0,   -0x1.f79a2p-2, INEXACT)
T(RN,    0x1.c991c9d8d3f35p+0,     0x1.29583c607422p-1,  -0x1.fce222p-2, INEXACT)
T(RN,    0x1.1a047ea61368cp+0,    0x1.8c75a5d5eff7ep-4,   0x1.f737fap-2, INEXACT)
T(RN,    0x1.4a99c2e198eaep+1,    0x1.e5d3b52dc43a6p-1,   0x1.faf348p-2, INEXACT)
T(RN,    0x1.298500441cd8ap+1,    0x1.afd8a10c3ca75p-1,  -0x1.fbb00cp-2, INEXACT)
T(RN,    0x1.5f3d8ea1b9c1fp+0,    0x1.43e278c92d76cp-2,  -0x1.f94de2p-2, INEXACT)
T(RN,    0x1.f4bf86cef7c76p+0,    0x1.5783976100c3fp-1,  -0x1.ff2398p-2, INEXACT)
T(RN,    0x1.fc755364e877ep+0,    0x1.5f565cd14f723p-1,   0x1.f9e848p-2, INEXACT)
T(RN,    0x1.fbef47c954579p+0,    0x1.5ecf5060c17afp-1,    0x1.fdd84p-2, INEXACT)
T(RN,    0x1.fb95fe5970697p+0,    0x1.5e754815b8309p-1,    0x1.fc18cp-2, INEXACT)
T(RN,    0x1.fae39a8cd2ffbp+0,     0x1.5dc1377fa594p-1,   0x1.fc27acp-2, INEXACT)
T(RN,    0x1.f73f1130b2e55p+0,    0x1.5a0fe06bc3e1ep-1,  -0x1.fe0cb6p-2, INEXACT)
T(RN,    0x1.f635dc746a6f5p+0,    0x1.5901c78aa7f74p-1,    0x1.fbb9fp-2, INEXACT)
T(RN,    0x1.f5b17683f042fp+0,    0x1.587abb1a1a037p-1,  -0x1.ff0d2cp-2, INEXACT)
T(RN,    0x1.f4511138f7c96p+0,    0x1.571299edf4c94p-1,   0x1.f90e74p-2, INEXACT)
T(RN,    0x1.f2c5c71b4822bp+0,    0x1.557d749c4aebep-1,    0x1.f712ap-2, INEXACT)
T(RN,    0x1.f1932c8a0af89p+0,    0x1.54425795aa5b1p-1,  -0x1.fc364cp-2, INEXACT)
T(RN,    0x1.f1676eff4d565p+0,    0x1.5415537025b29p-1,    0x1.f85a2p-2, INEXACT)
T(RN,    0x1.f0e44d6fcaf68p+0,    0x1.538e46ff97b71p-1,   0x1.f87a9ep-2, INEXACT)
T(RN,    0x1.f0b89f4466b62p+0,    0x1.536142da13167p-1,  -0x1.fe2f42p-2, INEXACT)
T(RN,    0x1.ef302c60122c8p+0,    0x1.51cc1d8869383p-1,   0x1.ff505cp-2, INEXACT)
T(RN,    0x1.eed9208a6a349p+0,    0x1.5172153d5fe9bp-1,  -0x1.ffc3cap-2, INEXACT)
T(RN,    0x1.ee56ab79bc896p+0,    0x1.50eb08ccd1f4dp-1,    -0x1.fdacp-2, INEXACT)
T(RN,    0x1.eb4abe17254dbp+0,    0x1.4dc0be297e36fp-1,   0x1.f7a554p-2, INEXACT)
T(RN,    0x1.e9c695500c235p+0,     0x1.4c2b98d7d458p-1,  -0x1.fa7ff4p-2, INEXACT)
T(RN,    0x1.e8ef7502e4d33p+0,    0x1.4b4a841c3d147p-1,  -0x1.fbd6e2p-2, INEXACT)
T(RN,    0x1.e899828ea79f9p+0,    0x1.4af07bd133c4dp-1,   0x1.fa99bap-2, INEXACT)
T(RN,    0x1.e8439f361928fp+0,    0x1.4a9673862a795p-1,   0x1.f98082p-2, INEXACT)
T(RN,    0x1.e6eca8b39bf1dp+0,    0x1.492e525a053f7p-1,    0x1.f97a6p-2, INEXACT)
T(RN,    0x1.e541474133961p+0,    0x1.476c28e2d6ba6p-1,  -0x1.f94b5cp-2, INEXACT)
T(RN,    0x1.e5169ef677544p+0,    0x1.473f24bd5200dp-1,  -0x1.f698c4p-2, INEXACT)
T(RN,    0x1.e2c2f407641c8p+0,    0x1.44c8eab010f0ep-1,  -0x1.f679c6p-2, INEXACT)
T(RN,    0x1.e0f0ef09931bbp+0,    0x1.42d9bd135dc4ap-1,   0x1.f74cf4p-2, INEXACT)
T(RN,    0x1.de4e38ea79231p+0,    0x1.40097abb1351cp-1,  -0x1.fcdad6p-2, INEXACT)
T(RN,     0x1.dc569dc8849dp+0,    0x1.3ded48f8db802p-1,   0x1.fc5174p-2, INEXACT)
T(RN,    0x1.d9ba5cb8936c8p+0,    0x1.3b1d06a0910dbp-1,   0x1.ff8b12p-2, INEXACT)
T(RN,    0x1.d913df23c9a61p+0,    0x1.3a68f60a7e73cp-1,  -0x1.fead96p-2, INEXACT)
T(RN,    0x1.d8ea48e3e7052p+0,    0x1.3a3bf1e4f9c96p-1,  -0x1.fe1db2p-2, INEXACT)
T(RN,    0x1.d79e1a6593cc1p+0,    0x1.38d3d0b8d4917p-1,  -0x1.f6544ap-2, INEXACT)
T(RN,    0x1.d6f85ab03654bp+0,    0x1.381fc022c1f9bp-1,   0x1.fc4e72p-2, INEXACT)
T(RN,    0x1.d6a590af015a8p+0,     0x1.37c5b7d7b8a9p-1,  -0x1.ff5fa2p-2, INEXACT)
T(RN,    0x1.d652d53b5e4abp+0,    0x1.376baf8caf5bbp-1,  -0x1.fc4244p-2, INEXACT)
T(RN,    0x1.d6297cf5d6ccap+0,    0x1.373eab672ab44p-1,  -0x1.fe93acp-2, INEXACT)
T(RN,    0x1.d5844034dc475p+0,    0x1.368a9ad1180fdp-1,  -0x1.f66e44p-2, INEXACT)
T(RN,     0x1.d55afa184d85p+0,    0x1.365d96ab93213p-1,  -0x1.f5f1dcp-2, INEXACT)
T(RN,    0x1.d463a193612a4p+0,    0x1.354f7dca7788ep-1,   0x1.fff366p-2, INEXACT)
T(RN,    0x1.d43a74d5fcb0fp+0,    0x1.352279a4f2e17p-1,    0x1.fe16cp-2, INEXACT)
T(RN,    0x1.d2f1911df81a8p+0,    0x1.33ba5878cda8ep-1,   0x1.f781e6p-2, INEXACT)
T(RN,    0x1.d2c884e8970d4p+0,    0x1.338d545348fdbp-1,   0x1.f88b66p-2, INEXACT)
T(RN,    0x1.d2767750c156bp+0,    0x1.33334c083fb3ap-1,   0x1.fa5d0ap-2, INEXACT)
T(RN,    0x1.d22478255ed8ep+0,    0x1.32d943bd3663ep-1,  -0x1.fcafdcp-2, INEXACT)
T(RN,    0x1.d1fb7df78df95p+0,    0x1.32ac3f97b1beep-1,   0x1.fdff1ap-2, INEXACT)
T(RN,    0x1.d157b942be4d3p+0,    0x1.31f82f019f0f8p-1,   0x1.f6138ep-2, INEXACT)
T(RN,    0x1.d105ec7efab1ep+0,    0x1.319e26b695d4ap-1,   0x1.f9a4aep-2, INEXACT)
T(RN,    0x1.d0dd0b81a6854p+0,    0x1.31712291112b7p-1,   0x1.fc41dep-2, INEXACT)
T(RN,    0x1.d0627e1816059p+0,    0x1.30ea16208338ap-1,   0x1.f6a7bcp-2, INEXACT)
T(RN,    0x1.cfbf492132aa3p+0,    0x1.3036058a709cap-1,   0x1.fb3992p-2, INEXACT)
T(RN,    0x1.cf9684da9c47dp+0,    0x1.30090164ebf3cp-1,   -0x1.fd606p-2, INEXACT)
T(RN,    0x1.cf6dc42972492p+0,    0x1.2fdbfd3f674a6p-1,  -0x1.fdafd6p-2, INEXACT)
T(RN,    0x1.cecae534b9b98p+0,    0x1.2f27eca954b36p-1,   0x1.f928f2p-2, INEXACT)
T(RN,    0x1.cdff9eff143bap+0,    0x1.2e46d7edbd6f4p-1,   0x1.f87032p-2, INEXACT)
T(RN,    0x1.cd85d2eff0c8fp+0,    0x1.2dbfcb7d2f79ap-1,   0x1.fe381ep-2, INEXACT)
T(RN,    0x1.cce39f77ab87cp+0,    0x1.2d0bbae71cd4bp-1,  -0x1.f67a94p-2, INEXACT)
T(RN,    0x1.cb9fe37710657p+0,    0x1.2ba399baf7a52p-1,  -0x1.fa4b44p-2, INEXACT)
T(RN,    0x1.cb777bf7616edp+0,       0x1.2b76959573p-1,   0x1.fd461ap-2, INEXACT)
T(RN,  0x1.f9dca0d04fe65p+996,    0x1.5987207493ea8p+9,   0x1.f62312p-2, INEXACT)
T(RN,  0x1.50cf8826aba27p+996,    0x1.5953105058c38p+9,   0x1.f6ebcap-2, INEXACT)
T(RN,  0x1.c081efb5dfff8p+995,    0x1.591f002c1d9c7p+9,   0x1.f5ff7ap-2, INEXACT)
T(RN,  0x1.d57e4ab403766p+992,    0x1.581aaf76f5d96p+9,   0x1.f6c096p-2, INEXACT)
T(RN,  0x1.221f448d79ef5p+988,    0x1.567a2e551ca15p+9,    0x1.f6812p-2, INEXACT)
T(RN,  0x1.8255ee0b6362ep+987,    0x1.56461e30e17a5p+9,   0x1.f69326p-2, INEXACT)
T(RN,  0x1.56887f51adefep+986,    0x1.55ddfde86b2c4p+9,   0x1.f6d926p-2, INEXACT)
T(RN,  0x1.270d29151ec94p+978,    0x1.53051bed2f0a1p+9,   0x1.f5fbc8p-2, INEXACT)
T(RN,  0x1.34db5f7b57033p+975,     0x1.5200cb380747p+9,   0x1.f6aefap-2, INEXACT)
T(RN,  0x1.434ef3b79f10ep+972,    0x1.50fc7a82df83fp+9,   0x1.f6df96p-2, INEXACT)
T(RN,  0x1.7db6f0f4dc53dp+970,    0x1.50604a162e0efp+9,    0x1.f635bp-2, INEXACT)
T(RN,  0x1.0a0b179934182p+967,    0x1.4f27e93ccb24dp+9,   0x1.f68e46p-2, INEXACT)
T(RN,  0x1.3a1ac0c71caa4p+965,    0x1.4e8bb8d019afdp+9,   0x1.f665a6p-2, INEXACT)
T(RN,  0x1.a24575980a2b5p+964,    0x1.4e57a8abde88dp+9,   0x1.f65c54p-2, INEXACT)
T(RN,  0x1.72d91747ec20bp+963,    0x1.4def8863683acp+9,   0x1.f6f898p-2, INEXACT)
T(RN,  0x1.684a6f1adf75bp+956,    0x1.4b7ec6b0a266ap+9,   0x1.f68702p-2, INEXACT)
T(RN,  0x1.dfc63d990ce83p+955,    0x1.4b4ab68c673fap+9,   0x1.f63a96p-2, INEXACT)
T(RN,  0x1.79261a44963c1p+953,    0x1.4a7a75fb7aa39p+9,    0x1.f66acp-2, INEXACT)
T(RN,  0x1.f6391e7feecb9p+952,    0x1.4a4665d73f7c9p+9,   0x1.f5ee02p-2, INEXACT)
T(RN,  0x1.06dc7299d6fd7p+950,    0x1.4942152217b98p+9,   0x1.f6f5a4p-2, INEXACT)
T(RN,  0x1.7f8e8515c16dep+943,    0x1.470563938d0c5p+9,    0x1.f6cbbp-2, INEXACT)
T(RN,  0x1.5411bf1bb3417p+942,    0x1.469d434b16be5p+9,    0x1.f641dp-2, INEXACT)
T(RN,  0x1.2d833306f8564p+941,    0x1.46352302a0705p+9,   0x1.f6bbdcp-2, INEXACT)
T(RN,  0x1.0b53c498fa2a3p+940,    0x1.45cd02ba2a224p+9,   0x1.f60dc8p-2, INEXACT)
T(RN,  0x1.59d8e2b623e44p+932,    0x1.432830e329272p+9,   0x1.f6fb1ep-2, INEXACT)
T(RN,  0x1.7af80a6331b75p+926,     0x1.411f8f78d9a1p+9,   0x1.f5d646p-2, INEXACT)
T(RN,  0x1.147d03c5ea152p+920,    0x1.3ee2ddea4ef3dp+9,   0x1.f6b2a4p-2, INEXACT)
T(RN,  0x1.009c4646872b2p+916,    0x1.3d766cecb0e2cp+9,    0x1.f6f14p-2, INEXACT)
T(RN,  0x1.55b5e0298f59ep+915,    0x1.3d425cc875bbcp+9,   0x1.f63dc4p-2, INEXACT)
T(RN,  0x1.9370e6b088657p+913,    0x1.3ca62c5bc446bp+9,   0x1.f6318cp-2, INEXACT)
T(RN,  0x1.65b2fbdef5ea4p+912,    0x1.3c3e0c134df8bp+9,   0x1.f6a448p-2, INEXACT)
T(RN,  0x1.766f9c087ddd9p+909,    0x1.3b39bb5e2635ap+9,   0x1.f62732p-2, INEXACT)
T(RN,  0x1.4bfb9112140afp+908,    0x1.3ad19b15afe79p+9,   0x1.f6c9fep-2, INEXACT)
T(RN,  0x1.2657bc2c4e479p+907,    0x1.3a697acd39999p+9,   0x1.f61516p-2, INEXACT)
T(RN,  0x1.04f86848915cbp+906,    0x1.3a015a84c34b8p+9,   0x1.f5d7c6p-2, INEXACT)
T(RN,  0x1.5b8427206608dp+905,    0x1.39cd4a6088248p+9,   0x1.f60018p-2, INEXACT)
T(RN,  0x1.9a4bad43b057cp+903,    0x1.393119f3d6af8p+9,   0x1.f65468p-2, INEXACT)
T(RN,  0x1.112e6306750b8p+903,    0x1.38fd09cf9b887p+9,   0x1.f732e4p-2, INEXACT)
T(RN,   0x1.519f886175a9p+898,    0x1.375c88adc2506p+9,    0x1.f61a3p-2, INEXACT)
T(RN,  0x1.096780efa0c32p+896,    0x1.368c481cd5b45p+9,   0x1.f63014p-2, INEXACT)
T(RN,  0x1.b4ca68d45e88ep+890,    0x1.34b7b6d6c1553p+9,   0x1.f64536p-2, INEXACT)
T(RN,  0x1.22d26f89e0c9fp+890,    0x1.3483a6b2862e3p+9,   0x1.f5df3cp-2, INEXACT)
T(RN,  0x1.834483f307ab7p+889,    0x1.344f968e4b073p+9,   0x1.f675fep-2, INEXACT)
T(RN,  0x1.de9f3ae720cb3p+884,    0x1.32af156c71cf1p+9,    0x1.f67cdp-2, INEXACT)
T(RN,  0x1.89d8f1d313f9ap+879,    0x1.30da84265d6ffp+9,   0x1.f5cce2p-2, INEXACT)
T(RN,  0x1.063ad0dbda3ddp+879,    0x1.30a674022248fp+9,   0x1.f62a3ap-2, INEXACT)
T(RN,  0x1.9c4690a61ec8ap+876,    0x1.2fd6337135acep+9,   0x1.f605b2p-2, INEXACT)
T(RN,  0x1.6d8838cd4d01dp+875,    0x1.2f6e1328bf5eep+9,   0x1.f6d45ap-2, INEXACT)
T(RN,  0x1.fd877d2109aa1p+871,    0x1.2e35b24f5c74dp+9,   0x1.f63d38p-2, INEXACT)
T(RN,  0x1.63204e557037dp+868,    0x1.2cfd5175f98acp+9,   0x1.f61632p-2, INEXACT)
T(RN,  0x1.a347c46192f21p+866,    0x1.2c6121094815bp+9,    0x1.f6181p-2, INEXACT)
T(RN,   0x1.ef062775792ep+864,    0x1.2bc4f09c96a0ap+9,    0x1.f6069p-2, INEXACT)
T(RN,  0x1.2439b93e6665bp+863,    0x1.2b28c02fe52bap+9,   0x1.f74fcap-2, INEXACT)
T(RN,  0x1.31e6161a82e47p+860,    0x1.2a246f7abd689p+9,   0x1.f75796p-2, INEXACT)
T(RN,  0x1.97582570c93bap+859,    0x1.29f05f5682418p+9,   0x1.f6ee82p-2, INEXACT)
T(RN,  0x1.e0ee87bca1757p+857,    0x1.29542ee9d0cc8p+9,    0x1.f6c04p-2, INEXACT)
T(RN,  0x1.40363b564e234p+857,    0x1.29201ec595a58p+9,   0x1.f61378p-2, INEXACT)
T(RN,  0x1.aa676faf88e02p+856,    0x1.28ec0ea15a7e7p+9,   0x1.f6761ep-2, INEXACT)
T(RN,  0x1.077ec7bea3154p+852,    0x1.274b8d7f81466p+9,   0x1.f6b6bcp-2, INEXACT)
T(RN,  0x1.5ee0e211f3232p+851,    0x1.27177d5b461f6p+9,   0x1.f6909cp-2, INEXACT)
T(RN,  0x1.d33d9b911d1ebp+850,    0x1.26e36d370af85p+9,   0x1.f62464p-2, INEXACT)
T(RN,  0x1.3718999082f83p+850,    0x1.26af5d12cfd15p+9,    0x1.f5ffcp-2, INEXACT)
T(RN,  0x1.9e43e6411737ap+849,    0x1.267b4cee94aa5p+9,   0x1.f6b03ap-2, INEXACT)
T(RN,   0x1.20bae849eafep+846,    0x1.2542ec1531c04p+9,   0x1.f65cc2p-2, INEXACT)
T(RN,  0x1.54e3c284058c6p+844,    0x1.24a6bba8804b3p+9,    0x1.f61fdp-2, INEXACT)
T(RN,  0x1.2e3d66c6d67bfp+843,    0x1.243e9b6009fd3p+9,   0x1.f6dfa2p-2, INEXACT)
T(RN,  0x1.8703b3c4b2fb5p+835,     0x1.2199c9890902p+9,   0x1.f5e566p-2, INEXACT)
T(RN,  0x1.e340af1375e7ep+830,    0x1.1ff948672fc9fp+9,   0x1.f5e462p-2, INEXACT)
T(RN,   0x1.ac7639a73da8p+829,    0x1.1f91281eb97bep+9,    0x1.f69afp-2, INEXACT)
T(RN,  0x1.7be213a45943bp+828,    0x1.1f2907d6432dep+9,   0x1.f616ccp-2, INEXACT)
T(RN,  0x1.f9dd39f81c95dp+827,    0x1.1ef4f7b20806ep+9,   0x1.f692a6p-2, INEXACT)
T(RN,    0x1.8da86da5d79p+825,    0x1.1e24b7211b6adp+9,    0x1.f6be6p-2, INEXACT)
T(RN,   0x1.b3bdd453d9adp+819,    0x1.1c1c15b6cbe4bp+9,   0x1.f6a0fap-2, INEXACT)
T(RN,  0x1.c82144f971305p+816,    0x1.1b17c501a421ap+9,   0x1.f6177ep-2, INEXACT)
T(RN,  0x1.f3d03b8d59052p+810,    0x1.190f2397549b8p+9,   0x1.f6c2d2p-2, INEXACT)
T(RN,  0x1.bb2518ca27496p+809,    0x1.18a7034ede4d7p+9,   0x1.f6a076p-2, INEXACT)
T(RN,  0x1.cfe13781c4374p+806,    0x1.17a2b299b68a6p+9,   0x1.f5f32ap-2, INEXACT)
T(RN,  0x1.34dbbcfde4b2dp+806,    0x1.176ea2757b636p+9,   0x1.f5f5fap-2, INEXACT)
T(RN,  0x1.d7c2df43401c5p+796,    0x1.142da031c8f33p+9,   0x1.f6982cp-2, INEXACT)
T(RN,  0x1.72d9878f37009p+794,    0x1.135d5fa0dc572p+9,   0x1.f5e5acp-2, INEXACT)
T(RN,  0x1.965dac2c71084p+788,     0x1.1154be368cd1p+9,   0x1.f5cbc6p-2, INEXACT)
T(RN,  0x1.0e9092d3633dep+788,     0x1.1120ae1251aap+9,   0x1.f6ed74p-2, INEXACT)
T(RN,  0x1.a9613e2bce4a1p+785,    0x1.10506d81650dfp+9,   0x1.f6635ap-2, INEXACT)
T(RN,  0x1.9d452b8bded33p+778,    0x1.0ddfabce9f39dp+9,   0x1.f6c91ap-2, INEXACT)
T(RN,  0x1.2d838e5047614p+772,    0x1.0ba2fa40148cap+9,   0x1.f70402p-2, INEXACT)
T(RN,  0x1.f037dc7ff61d4p+766,    0x1.09ce68fa002d9p+9,   0x1.f692c4p-2, INEXACT)
T(RN,  0x1.b7f5139bfc706p+765,    0x1.096648b189df8p+9,   0x1.f66ba6p-2, INEXACT)
T(RN,  0x1.24ee30c235adfp+765,    0x1.0932388d4eb88p+9,   0x1.f6c26ap-2, INEXACT)
T(RN,  0x1.03b7dabceea6cp+764,    0x1.08ca1844d86a8p+9,   0x1.f6755ep-2, INEXACT)
T(RN,  0x1.6a07f92945c58p+760,    0x1.0791b76b75806p+9,   0x1.f6bba2p-2, INEXACT)
T(RN,  0x1.29e84c4237eadp+755,    0x1.05bd262561215p+9,   0x1.f6a292p-2, INEXACT)
T(RN,  0x1.8cb3e9252fca5p+754,    0x1.0589160125fa4p+9,   0x1.f70768p-2, INEXACT)
T(RN,  0x1.d45e282e79962p+752,    0x1.04ece59474854p+9,   0x1.f63054p-2, INEXACT)
T(RN,  0x1.9f43bbb248756p+751,    0x1.0484c54bfe373p+9,   0x1.f63f48p-2, INEXACT)
T(RN,  0x1.702ea2c3c9178p+750,    0x1.041ca50387e93p+9,     0x1.f6b9p-2, INEXACT)
T(RN,  0x1.ea4867768827bp+749,    0x1.03e894df4cc23p+9,   0x1.f6aa4ep-2, INEXACT)
T(RN,  0x1.009c93f79df9ep+747,    0x1.02e4442a24ff2p+9,   0x1.f6bcd8p-2, INEXACT)
T(RN,  0x1.9a4c297c71992p+734,    0x1.fd3de2629597bp+8,   0x1.f7aa22p-2, INEXACT)
T(RN,  0x1.6bc73c09b5792p+733,    0x1.fc6da1d1a8fbap+8,   0x1.f7348ap-2, INEXACT)
T(RN,  0x1.e46b1f1e0ed8ep+732,    0x1.fc05818932adap+8,   0x1.f68136p-2, INEXACT)
T(RN,  0x1.15d2ec4f15a74p+724,    0x1.f5eb9d4a441b4p+8,   0x1.f96838p-2, INEXACT)
T(RN,  0x1.71f57f03a1618p+723,    0x1.f5837d01cdcd3p+8,   0x1.f6a392p-2, INEXACT)
T(RN,  0x1.b4caed12acb5bp+721,    0x1.f44b1c286ae32p+8,   0x1.f6585cp-2, INEXACT)
T(RN,  0x1.0dea346f44f48p+717,    0x1.f10a19e4b872fp+8,   0x1.f96912p-2, INEXACT)
T(RN,  0x1.676d517f75577p+716,    0x1.f0a1f99c4224ep+8,   0x1.f75d7cp-2, INEXACT)
T(RN,  0x1.de9fcbcfa6d43p+715,    0x1.f039d953cbd6ep+8,   0x1.f6444cp-2, INEXACT)
T(RN,  0x1.3eace96ec99b4p+715,    0x1.efd1b90b5588ep+8,   0x1.f5cdfcp-2, INEXACT)
T(RN,  0x1.063b20407a027p+710,    0x1.ec28967f2ccaap+8,   0x1.f93154p-2, INEXACT)
T(RN,  0x1.9c470d78577ddp+707,    0x1.ea88155d53928p+8,   0x1.f79bcep-2, INEXACT)
T(RN,  0x1.908a776e034dbp+700,    0x1.e5a691f7c7ea3p+8,    0x1.f7d67p-2, INEXACT)
T(RN,  0x1.3add1a981d058p+698,    0x1.e40610d5eeb22p+8,   0x1.f73c22p-2, INEXACT)
T(RN,  0x1.a3484352b525dp+697,    0x1.e39df08d78641p+8,   0x1.f6b03cp-2, INEXACT)
T(RN,  0x1.172a2721c0533p+697,    0x1.e335d04502161p+8,   0x1.f5d8d8p-2, INEXACT)
T(RN,  0x1.243a11b7e6b26p+694,    0x1.e12d2edab28ffp+8,    0x1.f8fe8p-2, INEXACT)
T(RN,  0x1.85236a232c27cp+693,    0x1.e0c50e923c41fp+8,   0x1.f6373ep-2, INEXACT)
T(RN,  0x1.40369c48f17fap+688,    0x1.dd1bec061383bp+8,   0x1.f841c2p-2, INEXACT)
T(RN,  0x1.aa67f0c8ce4a7p+687,    0x1.dcb3cbbd9d35bp+8,   0x1.f677aap-2, INEXACT)
T(RN,  0x1.be5b8ea3e418fp+684,    0x1.daab2a534daf9p+8,   0x1.f72dc6p-2, INEXACT)
T(RN,  0x1.45a762acd2adap+678,    0x1.d631c73638554p+8,   0x1.f8e25cp-2, INEXACT)
T(RN,  0x1.b1a69a5f3492fp+677,    0x1.d5c9a6edc2074p+8,   0x1.f5ce66p-2, INEXACT)
T(RN,  0x1.54e429b9561edp+675,    0x1.d42925cbe8cf2p+8,   0x1.f5ef4ep-2, INEXACT)
T(RN,  0x1.92794db4ab577p+673,    0x1.d2f0c4f285e51p+8,   0x1.f726e6p-2, INEXACT)
T(RN,  0x1.db2e717a4f09dp+671,     0x1.d1b8641922fbp+8,   0x1.f6fbc2p-2, INEXACT)
T(RN,  0x1.33605d2ad3b5ep+664,    0x1.cc6ec06b2104ap+8,   0x1.f77b46p-2, INEXACT)
T(RN,  0x1.a0442f21a0173p+653,    0x1.c51c7b52cf883p+8,   0x1.f5feaap-2, INEXACT)
T(RN,  0x1.dd797e2b19ce6p+644,    0x1.bf029713e0f5dp+8,    0x1.f705ap-2, INEXACT)
T(RN,  0x1.62465c22c0ad5p+628,    0x1.b39f0f26f06d2p+8,   0x1.f69776p-2, INEXACT)
T(RN,  0x1.d7c36e18041bap+627,    0x1.b336eede7a1f1p+8,   0x1.f6c1dcp-2, INEXACT)
T(RN,  0x1.58307c079e3b7p+621,    0x1.aebd8bc164c4dp+8,   0x1.f83226p-2, INEXACT)
T(RN,  0x1.684b494510e1cp+618,    0x1.acb4ea57153ebp+8,   0x1.f69244p-2, INEXACT)
T(RN,  0x1.d21edaf6f0c24p+610,    0x1.a76b46a913486p+8,   0x1.f79184p-2, INEXACT)
T(RN,  0x1.44df248ba09e6p+607,    0x1.a4fa84f64d743p+8,   0x1.f69782p-2, INEXACT)
T(RN,  0x1.7f8f6d5680fc7p+605,    0x1.a3c2241cea8a2p+8,   0x1.f67f98p-2, INEXACT)
T(RN,  0x1.da0a41c61a5cdp+600,    0x1.a08121d93819fp+8,    0x1.f7ad8p-2, INEXACT)
T(RN,  0x1.cc8b8f3b21ebbp+593,    0x1.9b9f9e73ac71ap+8,   0x1.f65ca2p-2, INEXACT)
T(RN,  0x1.29e8a6741bcf2p+586,    0x1.9655fac5aa7b5p+8,   0x1.f78b92p-2, INEXACT)
T(RN,  0x1.b2b268952e3afp+579,     0x1.91dc97a89521p+8,   0x1.f6023ep-2, INEXACT)
T(RN,  0x1.009ce1a8cc461p+578,    0x1.90a436cf3236fp+8,   0x1.f9642ep-2, INEXACT)
T(RN,  0x1.2ef8693e9c2fcp+576,    0x1.8f6bd5f5cf4cep+8,   0x1.f7a30cp-2, INEXACT)
T(RN,  0x1.65b3d4776b20dp+574,    0x1.8e33751c6c62dp+8,   0x1.f65868p-2, INEXACT)
T(RN,  0x1.26586e679d2fap+569,    0x1.8a8a529043a49p+8,   0x1.f874d4p-2, INEXACT)
T(RN,  0x1.cec486f06121fp+566,    0x1.88e9d16e6a6c7p+8,   0x1.f6e3c4p-2, INEXACT)
T(RN,  0x1.1df74ed35cc3dp+562,    0x1.85a8cf2ab7fc4p+8,   0x1.f7f5c4p-2, INEXACT)
T(RN,  0x1.2b58b17aad5b4p+559,    0x1.83a02dc068762p+8,   0x1.f859ccp-2, INEXACT)
T(RN,  0x1.4803c96b7d655p+553,    0x1.7f8eeaebc969ep+8,   0x1.f707e2p-2, INEXACT)
T(RN,  0x1.a85c2e5b69032p+545,    0x1.7a45473dc7739p+8,   0x1.f6974cp-2, INEXACT)
T(RN,  0x1.4417618b39124p+536,    0x1.73c342b662932p+8,   0x1.f6d5aep-2, INEXACT)
T(RN,  0x1.53417138e2a33p+533,     0x1.71baa14c130dp+8,   0x1.f6e668p-2, INEXACT)
T(RN,  0x1.2cca833180664p+532,    0x1.70ea60bb2670fp+8,   0x1.f6c54ap-2, INEXACT)
T(RN,  0x1.0ab0055191879p+531,    0x1.701a202a39d4fp+8,   0x1.f877aep-2, INEXACT)
T(RN,   0x1.6321255f0ce7p+530,    0x1.6fb1ffe1c386ep+8,   0x1.f7f732p-2, INEXACT)
T(RN,  0x1.d8e6c5bbcef34p+529,    0x1.6f49df994d38ep+8,   0x1.f7762ap-2, INEXACT)
T(RN,  0x1.3add79ec3b706p+529,    0x1.6ee1bf50d6eadp+8,   0x1.f85ed8p-2, INEXACT)
T(RN,  0x1.49990602f3d4cp+526,    0x1.6cd91de68764bp+8,    0x1.f6d97p-2, INEXACT)
T(RN,  0x1.6929ca1ec7483p+520,    0x1.68c7db11e8587p+8,    0x1.f6f4dp-2, INEXACT)
T(RN,  0x1.4036fd3bb22c6p+519,    0x1.67f79a80fbbc6p+8,   0x1.f755dep-2, INEXACT)
T(RN,  0x1.7a0fe8b38b855p+517,    0x1.66bf39a798d25p+8,   0x1.f620f6p-2, INEXACT)
T(RN,   0x1.9e44e11a185ap+511,    0x1.62adf6d2f9c61p+8,    0x1.f64dcp-2, INEXACT)
T(RN,  0x1.6f4cad54a35ebp+510,     0x1.61ddb6420d2ap+8,   0x1.f817dcp-2, INEXACT)
T(RN,  0x1.e91b82af1add6p+509,     0x1.617595f996dcp+8,   0x1.f5c564p-2, INEXACT)
T(RN,  0x1.5aaf498029f04p+496,    0x1.581aaf76f5d97p+8,   0x1.f5f35ap-2, INEXACT)
T(RN,  0x1.3360ba3aa1915p+495,    0x1.574a6ee6093d6p+8,   0x1.f6037ap-2, INEXACT)
T(RN,  0x1.6ae7fa8198c7cp+493,    0x1.56120e0ca6535p+8,   0x1.f61feep-2, INEXACT)
T(RN,  0x1.c0838715b20bbp+488,    0x1.52d10bc8f3e31p+8,    0x1.f7929p-2, INEXACT)
T(RN,   0x1.d57ff5237baep+485,    0x1.50c86a5ea45cfp+8,   0x1.f76534p-2, INEXACT)
T(RN,  0x1.15286b2442aeep+484,    0x1.4f9009854172ep+8,   0x1.f6f564p-2, INEXACT)
T(RN,  0x1.b3bedc2dfc2bcp+481,    0x1.4def8863683adp+8,    0x1.f7318p-2, INEXACT)
T(RN,  0x1.013b5af97bf28p+480,    0x1.4cb7278a0550bp+8,   0x1.f66a76p-2, INEXACT)
T(RN,  0x1.c822592c13242p+478,    0x1.4be6e6f918b4bp+8,   0x1.f6294cp-2, INEXACT)
T(RN,  0x1.cfe25065ba59fp+468,    0x1.44fcc2293d864p+8,   0x1.f76694p-2, INEXACT)
T(RN,  0x1.34dc780354f73p+468,    0x1.4494a1e0c7383p+8,   0x1.f7670cp-2, INEXACT)
T(RN,  0x1.4350195fe614fp+465,    0x1.428c007677b21p+8,   0x1.f67fc8p-2, INEXACT)
T(RN,  0x1.ae88931fa52cbp+464,    0x1.4223e02e01641p+8,    0x1.f5cb4p-2, INEXACT)
T(RN,  0x1.fc4f626c426d3p+462,     0x1.40eb7f549e7ap+8,   0x1.f6f068p-2, INEXACT)
T(RN,  0x1.5270d5fee3c69p+462,    0x1.40835f0c282bfp+8,   0x1.f829dep-2, INEXACT)
T(RN,  0x1.8f94a616b8feap+460,    0x1.3f4afe32c541ep+8,   0x1.f751d6p-2, INEXACT)
T(RN,  0x1.167ed351c956dp+457,    0x1.3cda3c7fff6dcp+8,   0x1.f76ed6p-2, INEXACT)
T(RN,  0x1.684bb65a5b10fp+449,    0x1.379098d1fd776p+8,    0x1.f81c3p-2, INEXACT)
T(RN,  0x1.dfc7f15f16aefp+448,    0x1.3728788987296p+8,   0x1.f5db8ap-2, INEXACT)
T(RN,  0x1.bd499efc8c885p+444,    0x1.344f968e4b073p+8,   0x1.f7ae38p-2, INEXACT)
T(RN,  0x1.d21f68168362fp+441,    0x1.3246f523fb811p+8,   0x1.f7a2d2p-2, INEXACT)
T(RN,  0x1.132a0d3eac3fbp+440,     0x1.310e944a9897p+8,   0x1.f6cd7ap-2, INEXACT)
T(RN,  0x1.da0ad14b7eabcp+431,    0x1.2b5cd0542052ap+8,   0x1.f7a4d4p-2, INEXACT)
T(RN,  0x1.24eee22298081p+427,    0x1.281bce106de27p+8,    0x1.f8cd9p-2, INEXACT)
T(RN,  0x1.59da1cd72e9b1p+425,    0x1.26e36d370af86p+8,   0x1.f61a2ep-2, INEXACT)
T(RN,  0x1.5fba67544b045p+415,    0x1.1ff948672fc9fp+8,   0x1.f7a12ap-2, INEXACT)
T(RN,  0x1.702f81b542884p+412,    0x1.1df0a6fce043dp+8,   0x1.f72ffep-2, INEXACT)
T(RN,  0x1.b2b2ec31348fbp+410,    0x1.1cb846237d59cp+8,   0x1.f785c6p-2, INEXACT)
T(RN,  0x1.216de6749c418p+410,    0x1.1c5025db070bbp+8,   0x1.f82078p-2, INEXACT)
T(RN,  0x1.2ef8c4f8e9cdep+407,    0x1.1a478470b7859p+8,   0x1.f7f002p-2, INEXACT)
T(RN,  0x1.ba15a7bcc406dp+400,    0x1.15ce2153a22b5p+8,   0x1.f76db2p-2, INEXACT)
T(RN,  0x1.5b8562c585d09p+398,    0x1.142da031c8f33p+8,   0x1.f7699ap-2, INEXACT)
T(RN,  0x1.cec5130c157c1p+397,    0x1.13c57fe952a53p+8,    0x1.f75e8p-2, INEXACT)
T(RN,  0x1.341e8d433e0b2p+397,    0x1.135d5fa0dc572p+8,   0x1.f858b4p-2, INEXACT)
T(RN,  0x1.e46c4471ced84p+394,    0x1.11bcde7f031f1p+8,   0x1.f7c80cp-2, INEXACT)
T(RN,  0x1.fb16d3d62bf05p+391,    0x1.0fb43d14b398fp+8,   0x1.f70584p-2, INEXACT)
T(RN,  0x1.eca7468ebba33p+384,    0x1.0ad2b9af27f0ap+8,   0x1.f6357ap-2, INEXACT)
T(RN,  0x1.b4cbf58fc0f6ap+383,    0x1.0a02791e3b549p+8,   0x1.f62a68p-2, INEXACT)
T(RN,  0x1.22d377b05bd23p+383,    0x1.099a58d5c5069p+8,   0x1.f8962ap-2, INEXACT)
T(RN,  0x1.01da36282b38dp+382,    0x1.08ca1844d86a8p+8,   0x1.f98c68p-2, INEXACT)
T(RN,  0x1.a85caed642435p+376,    0x1.0520f5b8afac4p+8,   0x1.f7bab2p-2, INEXACT)
T(RN,  0x1.bc37d0f595e46p+373,    0x1.0318544e60262p+8,   0x1.f7d76ep-2, INEXACT)
T(RN,  0x1.fd894bedbc4dbp+364,    0x1.f9fce01ee3278p+7,   0x1.f96946p-2, INEXACT)
T(RN,  0x1.5341d7ef8cad8p+364,    0x1.f92c9f8df68b8p+7,    0x1.fac56p-2, INEXACT)
T(RN,  0x1.0ab0560fb4832p+362,    0x1.f5eb9d4a441b4p+7,   0x1.f92ac4p-2, INEXACT)
T(RN,  0x1.d8e754e8f345cp+360,    0x1.f44b1c286ae33p+7,   0x1.f71162p-2, INEXACT)
T(RN,  0x1.9759976d409edp+352,    0x1.e8e7943b7a5a7p+7,   0x1.f5d0d2p-2, INEXACT)
T(RN,  0x1.40375e2e904c3p+350,    0x1.e5a691f7c7ea4p+7,    0x1.f8b69p-2, INEXACT)
T(RN,  0x1.077fb7130b2a8p+345,    0x1.de544cdf766ddp+7,   0x1.f6e878p-2, INEXACT)
T(RN,   0x1.e91c16c45328p+340,    0x1.d8a288e8fe297p+7,   0x1.f8ec18p-2, INEXACT)
T(RN,   0x1.45a827ddcd69p+340,    0x1.d7d24858118d6p+7,   0x1.f5d08ap-2, INEXACT)
T(RN,  0x1.b1a7a0f53f56ap+339,    0x1.d70207c724f16p+7,   0x1.f88928p-2, INEXACT)
T(RN,  0x1.20bbee89fbf4ep+339,    0x1.d631c73638555p+7,    0x1.fc004p-2, INEXACT)
T(RN,  0x1.927a4169d7252p+335,     0x1.d15043d0acadp+7,   0x1.f67836p-2, INEXACT)
T(RN,  0x1.0bf9cf34df17cp+335,    0x1.d080033fc010fp+7,   0x1.f83954p-2, INEXACT)
T(RN,  0x1.41c2f85a8eacdp+323,    0x1.c03af7ed43dffp+7,   0x1.f8ccd8p-2, INEXACT)
T(RN,  0x1.ac77bed1fc9eap+322,    0x1.bf6ab75c5743ep+7,    0x1.f95aep-2, INEXACT)
T(RN,  0x1.2aa0fae2ded37p+319,    0x1.ba8933f6cb9b9p+7,   0x1.fb91a4p-2, INEXACT)
T(RN,  0x1.60939df147ac6p+317,    0x1.b818724405c77p+7,   0x1.f98896p-2, INEXACT)
T(RN,  0x1.2220a3e802831p+312,     0x1.b0c62d2bb44bp+7,   0x1.f843aep-2, INEXACT)
T(RN,  0x1.946b7c32b4b27p+308,    0x1.abe4a9c628a2bp+7,   0x1.f6cac6p-2, INEXACT)
T(RN,  0x1.77582d916046fp+304,    0x1.a632e5cfb05e5p+7,   0x1.f8f636p-2, INEXACT)
T(RN,  0x1.34dcd586379aap+299,    0x1.9ee0a0b75ee1ep+7,   0x1.f984dcp-2, INEXACT)
T(RN,  0x1.11d810739d391p+298,    0x1.9d401f9585a9cp+7,   0x1.f822b6p-2, INEXACT)
T(RN,  0x1.1ea83f8a62906p+295,    0x1.992edcc0e69d8p+7,   0x1.f90ba2p-2, INEXACT)
T(RN,   0x1.7db8bf3bcc5ap+294,    0x1.985e9c2ffa017p+7,   0x1.f8bbb4p-2, INEXACT)
T(RN,  0x1.52713c7665609p+293,    0x1.96be1b0e20c96p+7,   0x1.f62f72p-2, INEXACT)
T(RN,  0x1.8f951f10fe954p+291,    0x1.944d595b5af53p+7,   0x1.f60568p-2, INEXACT)
T(RN,   0x1.d7c48bc20decp+289,    0x1.91dc97a895211p+7,    0x1.f9728p-2, INEXACT)
T(RN,  0x1.48cebe9c6ae0cp+286,    0x1.8cfb14430978cp+7,   0x1.fb9b54p-2, INEXACT)
T(RN,  0x1.58314c71ded1cp+283,    0x1.88e9d16e6a6c8p+7,   0x1.f8b166p-2, INEXACT)
T(RN,  0x1.312b12daf224ep+282,    0x1.8749504c91346p+7,   0x1.f91faep-2, INEXACT)
T(RN,   0x1.0e9188939bdbp+281,    0x1.85a8cf2ab7fc5p+7,   0x1.f88e5ep-2, INEXACT)
T(RN,  0x1.684c236fc662fp+280,    0x1.84d88e99cb604p+7,   0x1.f6ae56p-2, INEXACT)
T(RN,  0x1.a962c089ed8b2p+278,    0x1.8267cce7058c1p+7,   0x1.f5d6aep-2, INEXACT)
T(RN,  0x1.bd4a25cd6c9b4p+275,    0x1.7e568a12667fdp+7,    0x1.f7804p-2, INEXACT)
T(RN,  0x1.287b137512befp+275,    0x1.7d86498179e3dp+7,   0x1.f79aa2p-2, INEXACT)
T(RN,  0x1.132a608dcfb5fp+271,    0x1.77d4858b019f7p+7,    0x1.f760bp-2, INEXACT)
T(RN,  0x1.6e6b4292123cfp+270,    0x1.770444fa15036p+7,   0x1.fa75a2p-2, INEXACT)
T(RN,  0x1.17d7373d2cce2p+261,    0x1.6a003beb4b429p+7,   0x1.f6ecaap-2, INEXACT)
T(RN,  0x1.b7f6a337b0bb4p+258,    0x1.66bf39a798d26p+7,    0x1.f7445p-2, INEXACT)
T(RN,  0x1.e2193ebb2a7d8p+252,    0x1.5e9cb3fe5ab9ep+7,   0x1.f98916p-2, INEXACT)
T(RN,  0x1.40fd1eea069d1p+252,    0x1.5dcc736d6e1ddp+7,   0x1.fb51e6p-2, INEXACT)
T(RN,  0x1.5fbad1d1a9a94p+246,    0x1.55a9edc430055p+7,   0x1.fb45e8p-2, INEXACT)
T(RN,  0x1.b2b36fcd62b63p+241,    0x1.4f27e93ccb24fp+7,   0x1.f9f2a8p-2, INEXACT)
T(RN,  0x1.009d7d0b6f73dp+240,    0x1.4cb7278a0550cp+7,   0x1.fb77e8p-2, INEXACT)
T(RN,  0x1.2ef920b353492p+238,    0x1.4a4665d73f7cap+7,   0x1.f94096p-2, INEXACT)
T(RN,  0x1.0c9f4cf5c8738p+237,    0x1.48a5e4b566448p+7,    0x1.f6b97p-2, INEXACT)
T(RN,  0x1.dc5505eb44e78p+235,    0x1.470563938d0c6p+7,   0x1.f844d4p-2, INEXACT)
T(RN,  0x1.7cce074dc4fd1p+223,    0x1.35f017b0243f5p+7,   0x1.f75292p-2, INEXACT)
T(RN,  0x1.51a12142bbc6ep+222,    0x1.344f968e4b074p+7,   0x1.faaf18p-2, INEXACT)
T(RN,  0x1.c1990b2faddf6p+221,    0x1.337f55fd5e6b3p+7,   0x1.f636d8p-2, INEXACT)
T(RN,  0x1.0968c25ae563cp+220,    0x1.310e944a98971p+7,   0x1.fce1dap-2, INEXACT)
T(RN,  0x1.616d5ab2b406dp+219,     0x1.303e53b9abfbp+7,   0x1.f619bep-2, INEXACT)
T(RN,  0x1.71f6cf0b2f25fp+216,    0x1.2c2d10e50ceecp+7,   0x1.f9b018p-2, INEXACT)
T(RN,  0x1.0deb2998612bbp+210,    0x1.233a4aaae23a3p+7,   0x1.fd0092p-2, INEXACT)
T(RN,  0x1.9c4883efe4236p+200,    0x1.1636419c18796p+7,   0x1.f86b38p-2, INEXACT)
T(RN,  0x1.12812df029815p+200,    0x1.1566010b2bdd5p+7,   0x1.fc1c42p-2, INEXACT)
T(RN,  0x1.e6c34f4c72e01p+198,    0x1.13c57fe952a54p+7,   0x1.f6986ap-2, INEXACT)
T(RN,  0x1.1f5946bd0a68cp+197,    0x1.1154be368cd11p+7,   0x1.f7ae3ap-2, INEXACT)
T(RN,  0x1.7ea47bafd299fp+196,     0x1.10847da5a035p+7,   0x1.f712e6p-2, INEXACT)
T(RN,  0x1.2ccb3954654f5p+194,    0x1.0d437b61edc4dp+7,   0x1.f5d628p-2, INEXACT)
T(RN,  0x1.3ade3894cefe7p+191,    0x1.0932388d4eb89p+7,    0x1.f9764p-2, INEXACT)
T(RN,  0x1.cb7175aa7d6d1p+184,     0x1.003f72532404p+7,   0x1.f8469cp-2, INEXACT)
T(RN,  0x1.975a12c1b312fp+183,    0x1.fd3de2629597dp+6,   0x1.fbf92cp-2, INEXACT)
T(RN,  0x1.f771a75e90112p+178,     0x1.f039d953cbd7p+6,   0x1.fbf6bcp-2, INEXACT)
T(RN,  0x1.29322bb68635cp+177,    0x1.eb5855ee402ebp+6,   0x1.f73602p-2, INEXACT)
T(RN,  0x1.371a125199046p+174,    0x1.e335d04502163p+6,   0x1.f5d258p-2, INEXACT)
T(RN,  0x1.6f4d8bbd4a06ep+172,    0x1.de544cdf766dep+6,   0x1.fe7f44p-2, INEXACT)
T(RN,  0x1.45a88a7677928p+171,    0x1.db134a9bc3fdbp+6,   0x1.faf43ap-2, INEXACT)
T(RN,  0x1.20bc45f4e133dp+170,    0x1.d7d24858118d8p+6,   0x1.fec3a4p-2, INEXACT)
T(RN,  0x1.ffff64fca22cbp+168,    0x1.d49146145f1d5p+6,   0x1.fa6b22p-2, INEXACT)
T(RN,  0x1.a54fbf91c721cp+163,    0x1.c5ecbbe3bc246p+6,   0x1.fa2c2ep-2, INEXACT)
T(RN,  0x1.3361745a91c2cp+157,    0x1.b4072f6f66bb3p+6,   -0x1.fdba8p-2, INEXACT)
T(RN,  0x1.1087b2cff7acbp+156,     0x1.b0c62d2bb44bp+6,  -0x1.fe3de2p-2, INEXACT)
T(RN,  0x1.ac78408b3575ep+153,    0x1.aa4428a44f6aap+6,    0x1.fddf9p-2, INEXACT)
T(RN,  0x1.7be3dfb377504p+152,    0x1.a70326609cfa7p+6,   0x1.fc307ep-2, INEXACT)
T(RN,  0x1.c08496abb6546p+150,    0x1.a221a2fb11522p+6,   0x1.fc5efcp-2, INEXACT)
T(RN,  0x1.825836e33c3d5p+142,    0x1.8b5a93213040cp+6,   0x1.f5dfeap-2, INEXACT)
T(RN,  0x1.013bf6bc14df3p+142,    0x1.89ba11ff57089p+6,  -0x1.fa73cap-2, INEXACT)
T(RN,  0x1.a7583eeeaa2eap+136,    0x1.7b1587ceb40fcp+6,    0x1.fce5ep-2, INEXACT)
T(RN,  0x1.19de96f0acaf2p+136,    0x1.797506acdad7ap+6,   0x1.f73d2cp-2, INEXACT)
T(RN,  0x1.4cca290942b53p+134,    0x1.749383474f2f5p+6,   0x1.fe6fcap-2, INEXACT)
T(RN,   0x1.bb27317651afp+133,    0x1.72f3022575f74p+6,    0x1.fd795p-2, INEXACT)
T(RN,  0x1.4350dd25fef4cp+127,    0x1.610d75b1208e2p+6,    0x1.f5c5ep-2, INEXACT)
T(RN,  0x1.72db48adb65b3p+118,    0x1.48a5e4b566449p+6,   0x1.f85486p-2, INEXACT)
T(RN,  0x1.b5da39b1503c8p+116,    0x1.43c4614fda9c5p+6,   0x1.f95668p-2, INEXACT)
T(RN,  0x1.1b3ad13f8d6d6p+109,     0x1.2e9dd297d2c3p+6,   0x1.f75a0cp-2, INEXACT)
T(RN,  0x1.79285534301d9p+108,    0x1.2cfd5175f98aep+6,    0x1.f62ccp-2, INEXACT)
T(RN,   0x1.f63c16c69a46p+107,    0x1.2b5cd0542052cp+6,   0x1.fae572p-2, INEXACT)
T(RN,  0x1.06de0086946abp+105,    0x1.233a4aaae23a3p+6,  -0x1.fbbc58p-2, INEXACT)
T(RN,  0x1.365ac6dd031e8p+103,    0x1.1e58c7455691fp+6,   0x1.fa24fap-2, INEXACT)
T(RN,   0x1.fec491ef277e6p+97,    0x1.0fb43d14b3991p+6,    0x1.fa824p-2, INEXACT)
T(RN,   0x1.4a6559f8cab39p+90,    0x1.f51b5cb9577f8p+5,   0x1.f6241cp-2, INEXACT)
T(RN,   0x1.0fe01f0d78dfbp+85,    0x1.d7d24858118dbp+5,   0x1.f6934ep-2, INEXACT)
T(RN,   0x1.8cb5c992e72bcp+78,    0x1.b4072f6f66bb6p+5,  -0x1.f714eap-2, INEXACT)
T(RN,   0x1.0822c103f0f01p+78,    0x1.b0c62d2bb44a6p+5,  -0x1.f6165ep-2, INEXACT)
T(RN,   0x1.9f45b29ab6d07p+75,    0x1.a3c2241cea8a6p+5,  -0x1.fa15dcp-2, INEXACT)
T(RN,   0x1.147ea653b8cbfp+75,    0x1.a08121d9381a3p+5,  -0x1.fbc42ap-2, INEXACT)
T(RN,   0x1.009dcabce4524p+71,    0x1.89ba11ff5708ap+5,  -0x1.f61dbcp-2, INEXACT)
T(RN,   0x1.2ef97c6dd87cfp+69,    0x1.7ff70b343fb82p+5,  -0x1.fa7622p-2, INEXACT)
T(RN,   0x1.9373496d5c37dp+68,    0x1.7cb608f08d47fp+5,  -0x1.fc7bacp-2, INEXACT)
T(RN,   0x1.3d269ab5544efp+66,    0x1.6fb1ffe1c3872p+5,   0x1.fbc362p-2, INEXACT)
T(RN,   0x1.a653eeff3ecbap+65,     0x1.6c70fd9e1117p+5,   0x1.ff7a26p-2, INEXACT)
T(RN,   0x1.7671d2dcc1103p+64,    0x1.65eef916ac368p+5,   0x1.f9f934p-2, INEXACT)
T(RN,   0x1.f29f424d33a18p+63,    0x1.62adf6d2f9c66p+5,   0x1.f9c11ep-2, INEXACT)
T(RN,   0x1.113000929f0bdp+58,    0x1.4223e02e01642p+5,  -0x1.fa2fc2p-2, INEXACT)
T(RN,   0x1.7cce7a98c831fp+54,    0x1.2e9dd297d2c32p+5,     0x1.fb56p-2, INEXACT)
T(RN,   0x1.c199934ea0dc4p+52,    0x1.24dacbccbb729p+5,    0x1.fe1fep-2, INEXACT)
T(RN,   0x1.8e9fe44c1b162p+51,    0x1.1e58c74556922p+5,   0x1.fa6a04p-2, INEXACT)
T(RN,    0x1.d6a303e60b16p+49,    0x1.1495c07a3f418p+5,   0x1.fb7776p-2, INEXACT)
T(RN,   0x1.a146bbf136254p+48,    0x1.0e13bbf2da612p+5,   0x1.ff8226p-2, INEXACT)
T(RN,   0x1.22d427ca886c1p+45,    0x1.f51b5cb9577f8p+4,  -0x1.fdd3a2p-2, INEXACT)
T(RN,   0x1.8346ce340d9b1p+44,    0x1.ee995831f29f7p+4,   0x1.f6897ep-2, INEXACT)
T(RN,   0x1.575e1009c4831p+43,    0x1.e1954f2328de9p+4,   0x1.f7c0bcp-2, INEXACT)
T(RN,   0x1.dea20f7375462p+39,    0x1.ba8933f6cb9bep+4,   0x1.f8190ap-2, INEXACT)
T(RN,   0x1.1a8ca9384d196p+38,    0x1.a70326609cfafp+4,   0x1.f73f96p-2, INEXACT)
T(RN,   0x1.27c51f188a4a9p+35,    0x1.86790fbba498cp+4,   0x1.f5e83ap-2, INEXACT)
T(RN,   0x1.5d338c0362446p+33,    0x1.72f3022575f7bp+4,  -0x1.fd3bacp-2, INEXACT)
T(RN,   0x1.1281810c2c333p+31,    0x1.58eaf007e2762p+4,    0x1.fad8ep-2, INEXACT)
T(RN,    0x1.1f599dbc8f65p+28,    0x1.3860d962ea13ep+4,   0x1.f76ec2p-2, INEXACT)
T(RN,   0x1.7ea4ef89454cep+27,    0x1.31ded4db8533bp+4,   0x1.fe299cp-2, INEXACT)
T(RN,   0x1.0ab0f78c43e0ep+24,    0x1.0ad2b9af27f14p+4,   0x1.f7faaep-2, INEXACT)
T(RN,   0x1.172b793723716p+21,    0x1.d49146145f1e7p+3,   0x1.f9d036p-2, INEXACT)
T(RN,   0x1.73c04f691ddf9p+20,    0x1.c78d3d05955dap+3,   -0x1.ffa1cp-2, INEXACT)
T(RN,   0x1.b6e8a02a4593cp+18,     0x1.a08121d9381bp+3,  -0x1.f9f8b4p-2, INEXACT)
T(RN,   0x1.5906442dd36e2p+16,    0x1.6c70fd9e1117ep+3,   0x1.fd2b7cp-2, INEXACT)
T(RN,   0x1.692b12292204ep+13,    0x1.2b5cd0542053ep+3,  -0x1.f95a6cp-2, INEXACT)
T(RN,    0x1.807da9b033c7ep+0,     0x1.a08121d9383ep-2,  -0x1.f93492p-2, INEXACT)
T(RN,    0x1.5fb0534875325p-1,   -0x1.809785e428883p-2,  -0x1.c973b4p-2, INEXACT)
T(RN,    0x1.0c69e258f39c3p-1,   -0x1.4aa5b5a214058p-1,  -0x1.e412aep-2, INEXACT)
T(RN,    0x1.8298168a8a3d2p-1,   -0x1.1fb12ebb73ddfp-2,  -0x1.fe9cc2p-2, INEXACT)
T(RN,    0x1.69476d2e32228p-1,   -0x1.650ad1c282e85p-2,   0x1.f90b96p-2, INEXACT)
T(RN,    0x1.01807751abf0dp-1,   -0x1.5fe58072e6e42p-1,   -0x1.f8685p-2, INEXACT)
T(RN,    0x1.f0a3d70a3d6e9p-1,   -0x1.f30b2d00921cbp-6,  -0x1.f97118p-2, INEXACT)
T(RN,    0x1.f0786fa48bd9cp-1,   -0x1.f8a34d2505f81p-6,   0x1.f6123ep-2, INEXACT)
T(RN,    0x1.efcaf7f945cffp-1,   -0x1.0781e6db686f1p-5,   0x1.ff3c1cp-2, INEXACT)
T(RN,    0x1.eec736166e776p-1,   -0x1.184a4748c1567p-5,   0x1.fe11dcp-2, INEXACT)
T(RN,    0x1.ee9bf8586b872p-1,   -0x1.1b16575afa94cp-5,   0x1.f95802p-2, INEXACT)
T(RN,    0x1.ee1a55c9b5fcfp-1,   -0x1.237a8791a7093p-5,   0x1.f9bf54p-2, INEXACT)
T(RN,    0x1.ed98d5350eccap-1,   -0x1.2bdeb7c8536abp-5,  -0x1.f95912p-2, INEXACT)
T(RN,    0x1.ed4292587a4e6p-1,   -0x1.3176d7ecc6772p-5,  -0x1.f678eap-2, INEXACT)
T(RN,    0x1.ec151efa6db97p-1,   -0x1.450b486c58e35p-5,   0x1.f92792p-2, INEXACT)
T(RN,    0x1.ebea1d8be79d3p-1,   -0x1.47d7587e92304p-5,  -0x1.f832ecp-2, INEXACT)
T(RN,    0x1.ebbf1fdf8d142p-1,   -0x1.4aa36890cb906p-5,  -0x1.f65f2cp-2, INEXACT)
T(RN,    0x1.eb3e3d643a2ffp-1,    -0x1.530798c777f5p-5,  -0x1.ff97f8p-2, INEXACT)
T(RN,    0x1.eb134ebd45503p-1,   -0x1.55d3a8d9b23bdp-5,  -0x1.f6611ep-2, INEXACT)
T(RN,    0x1.e9e731290873bp-1,   -0x1.69681959439e4p-5,   0x1.f73a8ep-2, INEXACT)
T(RN,    0x1.e9bc607d22156p-1,   -0x1.6c34296b7ddbcp-5,   0x1.f64fc8p-2, INEXACT)
T(RN,    0x1.e8e6853bba80fp-1,   -0x1.7a3079c69c81bp-5,   -0x1.fa708p-2, INEXACT)
T(RN,    0x1.e86661b732b21p-1,   -0x1.8294a9fd48f88p-5,    0x1.f6bc7p-2, INEXACT)
T(RN,    0x1.e73be6b8c525ap-1,   -0x1.96291a7cdb274p-5,   0x1.f9c86ep-2, INEXACT)
T(RN,    0x1.e61222241ca7fp-1,   -0x1.a9bd8afc6d84bp-5,    0x1.fb1efp-2, INEXACT)
T(RN,    0x1.e4beb2914ef0ep-1,   -0x1.c01e0b8e391a8p-5,   0x1.f92526p-2, INEXACT)
T(RN,    0x1.e469fbbc8dd2fp-1,   -0x1.c5b62bb2ac187p-5,  -0x1.f7eddep-2, INEXACT)
T(RN,    0x1.e43fa5df966f8p-1,   -0x1.c8823bc4e62c7p-5,   0x1.f69724p-2, INEXACT)
T(RN,    0x1.e39673683fec8p-1,   -0x1.d3b27c0dcb89cp-5,   0x1.f6a4c6p-2, INEXACT)
T(RN,    0x1.e341f0592c2abp-1,   -0x1.d94a9c323e77cp-5,   0x1.ff50f8p-2, INEXACT)
T(RN,    0x1.e2c34773081bbp-1,   -0x1.e1aecc68ead64p-5,   0x1.fb5a62p-2, INEXACT)
T(RN,    0x1.e1c6593555ba7p-1,   -0x1.f2772cd643cf4p-5,   0x1.f64f48p-2, INEXACT)
T(RN,    0x1.e04bec3adfb9cp-1,   -0x1.05d1debd24647p-4,   0x1.fab772p-2, INEXACT)
T(RN,    0x1.dff7fc695c41ep-1,   -0x1.089deecf5ddbcp-4,    0x1.fd52bp-2, INEXACT)
T(RN,    0x1.dfa41b4310b23p-1,   -0x1.0b69fee1974adp-4,  -0x1.fa9456p-2, INEXACT)
T(RN,    0x1.df7a302f52c68p-1,   -0x1.0cd006eab40aep-4,   0x1.ff61a6p-2, INEXACT)
T(RN,    0x1.df5048c56c986p-1,   -0x1.0e360ef3d2427p-4,   0x1.f5fe7cp-2, INEXACT)
T(RN,    0x1.ded2a87f96bb9p-1,   -0x1.1268270f26f9bp-4,  -0x1.fe03d2p-2, INEXACT)
T(RN,    0x1.dc8a1a095f7f8p-1,   -0x1.25fc978eb93a4p-4,  -0x1.ff28fcp-2, INEXACT)
T(RN,    0x1.dac0c37bccf47p-1,   -0x1.355eeff2f55fep-4,   0x1.fca634p-2, INEXACT)
T(RN,    0x1.d9c8078e21b94p-1,   -0x1.3dc32029a1c22p-4,   0x1.f9ec6ap-2, INEXACT)
T(RN,    0x1.d99e9f93d33b7p-1,   -0x1.3f292832be80fp-4,  -0x1.fc3998p-2, INEXACT)
T(RN,    0x1.d87d2cfcc880dp-1,   -0x1.48f36072879a6p-4,   0x1.f90de4p-2, INEXACT)
T(RN,     0x1.d853e1ecb719p-1,   -0x1.4a59687ba453ap-4,   0x1.f7a57ep-2, INEXACT)
T(RN,    0x1.d7333976a28acp-1,   -0x1.5423a0bb6db75p-4,   0x1.f7fc74p-2, INEXACT)
T(RN,    0x1.d6b7b99445bfdp-1,   -0x1.5855b8d6c3bdbp-4,   0x1.ffcec8p-2, INEXACT)
T(RN,    0x1.d5ea2c5a57e74p-1,   -0x1.5f53e10453609p-4,  -0x1.fd6edep-2, INEXACT)
T(RN,    0x1.d3fe475687b19p-1,   -0x1.701c4171ac384p-4,   0x1.fec85ap-2, INEXACT)
T(RN,    0x1.d3d560dba545ap-1,   -0x1.7182497ac8eeap-4,   0x1.faab48p-2, INEXACT)
T(RN,    0x1.d309160d01264p-1,   -0x1.788071a858a46p-4,   0x1.ffa582p-2, INEXACT)
T(RN,    0x1.d2e044ffd8e83p-1,   -0x1.79e679b17552dp-4,    0x1.fa263p-2, INEXACT)
T(RN,     0x1.d265e73e4d9dp-1,   -0x1.7e1891cccb8f5p-4,  -0x1.f9e32ep-2, INEXACT)
T(RN,    0x1.d148de7aa30aap-1,   -0x1.87e2ca0c949dfp-4,   0x1.ffe762p-2, INEXACT)
T(RN,    0x1.d055187c36c47p-1,   -0x1.9046fa434102bp-4,  -0x1.fd00f6p-2, INEXACT)
T(RN,    0x1.cfb2db75cf023p-1,   -0x1.95df1a67bf775p-4,  -0x1.f5ceeep-2, INEXACT)
T(RN,     0x1.ce1e3abb29f1p-1,   -0x1.a3db6ac2d34a1p-4,  -0x1.fae90ap-2, INEXACT)
T(RN,    0x1.cd7cc3c51b12cp-1,   -0x1.a9738ae7467fbp-4,   0x1.f7753ep-2, INEXACT)
T(RN,    0x1.cc8afb1587d8dp-1,   -0x1.b1d7bb1df299cp-4,   0x1.f7e8a6p-2, INEXACT)
T(RN,    0x1.cc62bb4ae462ep-1,   -0x1.b33dc3270f732p-4,   0x1.fd8c1ep-2, INEXACT)
T(RN,     0x1.cc3a7f04c0eep-1,   -0x1.b4a3cb302df7ap-4,  -0x1.f64014p-2, INEXACT)
T(RN,    0x1.cc124642cf60cp-1,   -0x1.b609d33948d02p-4,  -0x1.f73312p-2, INEXACT)
T(RN,    0x1.cb71865ed2301p-1,   -0x1.bba1f35dbbd71p-4,   0x1.fe8cf6p-2, INEXACT)
T(RN,    0x1.cad0fea55bee5p-1,   -0x1.c13a13822ea94p-4,   0x1.f5eb98p-2, INEXACT)
T(RN,    0x1.ca80cfd27127ep-1,   -0x1.c40623946825ep-4,  -0x1.f8aad2p-2, INEXACT)
T(RN,    0x1.ca58bdaa5d53dp-1,   -0x1.c56c2b9d84e1ep-4,  -0x1.f8eb68p-2, INEXACT)
T(RN,    0x1.ca08a3db70e37p-1,   -0x1.c8383bafbe72ep-4,   -0x1.fe989p-2, INEXACT)
T(RN,    0x1.c9e09c33fb9f6p-1,   -0x1.c99e43b8db1b2p-4,  -0x1.f5dddap-2, INEXACT)
T(RN,    0x1.c9689a39f40b7p-1,   -0x1.cdd05bd431889p-4,    0x1.f8a86p-2, INEXACT)
T(RN,    0x1.c8510fe0b1358p-1,   -0x1.d79a9413fa691p-4,   0x1.f939d4p-2, INEXACT)
T(RN,    0x1.c8292ea3f9e1ep-1,    -0x1.d9009c1d1738p-4,   0x1.f5fb0cp-2, INEXACT)
T(RN,    0x1.c80150e37f47cp-1,   -0x1.da66a42633ec2p-4,  -0x1.fcd70cp-2, INEXACT)
T(RN,    0x1.c7d9769ef367fp-1,   -0x1.dbccac2f50b29p-4,  -0x1.f83da8p-2, INEXACT)
T(RN,    0x1.c73a305e00a27p-1,   -0x1.e164cc53c3fc5p-4,  -0x1.f69ea2p-2, INEXACT)
T(RN,    0x1.c5854de3da966p-1,   -0x1.f0c724b7ff9c6p-4,  -0x1.f735fep-2, INEXACT)
T(RN,    0x1.c3f98eca8cd1bp-1,   -0x1.fec375131eef6p-4,   -0x1.fea14p-2, INEXACT)
T(RN,    0x1.c3d20eb1ad1e9p-1,    -0x1.0014be8e1ddcp-3,   -0x1.fbc6dp-2, INEXACT)
T(RN,    0x1.c2968a1844fa4p-1,   -0x1.05acdeb290f7ap-3,  -0x1.f850aap-2, INEXACT)
T(RN,    0x1.c26f2906458a9p-1,    -0x1.065fe2b71f27p-3,  -0x1.fd1e94p-2, INEXACT)
T(RN,    0x1.c15be1d4753a7p-1,   -0x1.0b44fed703be8p-3,   -0x1.fa40bp-2, INEXACT)
T(RN,     0x1.c097a8492813p-1,   -0x1.0ec412edcb8edp-3,   0x1.fddd6cp-2, INEXACT)
T(RN,    0x1.c07073dd3213ep-1,    -0x1.0f7716f259e9p-3,   0x1.f6746ap-2, INEXACT)
T(RN,     0x1.bfd3c46db285p-1,   -0x1.124327049361fp-3,   0x1.f6c642p-2, INEXACT)
T(RN,    0x1.bfaca12069a61p-1,   -0x1.12f62b0921c2bp-3,  -0x1.fca0cap-2, INEXACT)
T(RN,    0x1.be7401bfff465p-1,     -0x1.188e4b2d94bp-3,  -0x1.f6ff68p-2, INEXACT)
T(RN,    0x1.be4cfd30b3057p-1,   -0x1.19414f3223106p-3,   0x1.f88e6ap-2, INEXACT)
T(RN,    0x1.be25fc0a5a3bfp-1,   -0x1.19f45336b1704p-3,  -0x1.fe65a6p-2, INEXACT)
T(RN,    0x1.bca0abd5adb93p-1,   -0x1.20f27b64411b4p-3,   0x1.fa525ep-2, INEXACT)
T(RN,    0x1.bbde8332ddf93p-1,   -0x1.24718f7b08ea7p-3,   0x1.f9c238p-2, INEXACT)
T(RN,    0x1.ba5b3022dc51dp-1,   -0x1.2b6fb7a898a3ap-3,   0x1.f6bf8ep-2, INEXACT)
T(RN,    0x1.ba0de1b7f302bp-1,   -0x1.2cd5bfb1b556bp-3,   0x1.ffa604p-2, INEXACT)
T(RN,    0x1.b99a056bae8e1p-1,   -0x1.2eeecbbf60721p-3,   0x1.fbafccp-2, INEXACT)
T(RN,    0x1.b8d92f0e807a1p-1,   -0x1.326ddfd6284b2p-3,  -0x1.fd677ep-2, INEXACT)
T(RN,    0x1.b8b2a7e4b4038p-1,   -0x1.3320e3dab6ac7p-3,   0x1.f61924p-2, INEXACT)
T(RN,    0x1.b7cbc395727bbp-1,   -0x1.3752fbf60ccfap-3,   -0x1.f88bcp-2, INEXACT)
T(RN,    0x1.b70bb713b3111p-1,   -0x1.3ad2100cd4d07p-3,  -0x1.f92f6ap-2, INEXACT)
T(RN,    0x1.b625b05b151dcp-1,   -0x1.3f0428282ae18p-3,   0x1.f8c932p-2, INEXACT)
T(RN,    0x1.b5b2da3444885p-1,   -0x1.411d3435d607fp-3,   0x1.ffd63cp-2, INEXACT)
T(RN,    0x1.b3e8ae4578f36p-1,   -0x1.4981646c8259fp-3,   0x1.fb1892p-2, INEXACT)
T(RN,    0x1.b2b84637658f7p-1,   -0x1.4f198490f5493p-3,   0x1.fb0406p-2, INEXACT)
T(RN,    0x1.b292482b08a33p-1,   -0x1.4fcc889583b68p-3,  -0x1.f83854p-2, INEXACT)
T(RN,    0x1.b0a58f479779bp-1,   -0x1.58e3bcd0be736p-3,   0x1.fa8b62p-2, INEXACT)
T(RN,    0x1.ae4a2086eb563p-1,   -0x1.6413fd19a44dfp-3,   0x1.fe038ep-2, INEXACT)
T(RN,    0x1.acad2ce06bb16p-1,    -0x1.6bc5294bc279p-3,  -0x1.f84c76p-2, INEXACT)
T(RN,    0x1.a9e789bb5689bp-1,   -0x1.790e75a2534acp-3,  -0x1.ff2e16p-2, INEXACT)
T(RN,    0x1.a804a47b41a36p-1,   -0x1.8225a9dd8e158p-3,  -0x1.fe3ffap-2, INEXACT)
T(RN,    0x1.a7707d6fdbc07p-1,   -0x1.84f1b9efc78e6p-3,   0x1.fb8fcap-2, INEXACT)
T(RN,    0x1.a74b7bc44db63p-1,   -0x1.85a4bdf455e97p-3,  -0x1.f6d1f2p-2, INEXACT)
T(RN,    0x1.a6dc8a2838c5bp-1,   -0x1.87bdca0201086p-3,  -0x1.fbf66ep-2, INEXACT)
T(RN,    0x1.a6b7956ac7bfep-1,   -0x1.8870ce068f5efp-3,  -0x1.fdb9e8p-2, INEXACT)
T(RN,    0x1.a648ca9242862p-1,   -0x1.8a89da143a79ap-3,  -0x1.f8dc92p-2, INEXACT)
T(RN,    0x1.a623e2be69f1ap-1,   -0x1.8b3cde18c8e05p-3,  -0x1.f9190cp-2, INEXACT)
T(RN,    0x1.a546b7790b094p-1,   -0x1.8f6ef6341f114p-3,  -0x1.fa0382p-2, INEXACT)
T(RN,    0x1.a4fd1824f4048p-1,   -0x1.90d4fe3d3bc9cp-3,  -0x1.fa0c64p-2, INEXACT)
T(RN,    0x1.a48ec145ed03fp-1,   -0x1.92ee0a4ae6de7p-3,    -0x1.fc02p-2, INEXACT)
T(RN,    0x1.a3b26a4272722p-1,   -0x1.972022663d165p-3,  -0x1.fea602p-2, INEXACT)
T(RN,    0x1.a369119643943p-1,   -0x1.98862a6f59ccep-3,   0x1.f74306p-2, INEXACT)
T(RN,    0x1.a31fc5bb7f9e5p-1,   -0x1.99ec32787687ap-3,  -0x1.f811b8p-2, INEXACT)
T(RN,    0x1.a2b1ebf71bca3p-1,   -0x1.9c053e8621a3ep-3,   0x1.fd037ep-2, INEXACT)
T(RN,    0x1.a08e5a694ab83p-1,   -0x1.a6827aca79846p-3,  -0x1.f62032p-2, INEXACT)
T(RN,     0x1.9f4727d88b36p-1,   -0x1.accd9ef37a77ap-3,  -0x1.fc8d48p-2, INEXACT)
T(RN,    0x1.9e91d030cee3bp-1,   -0x1.b04cb30a424c6p-3,  -0x1.f8770cp-2, INEXACT)
T(RN,     0x1.9e495ce8a765p-1,   -0x1.b1b2bb135f049p-3,   0x1.fc5c76p-2, INEXACT)
T(RN,    0x1.9d03f2b379e25p-1,    -0x1.b7fddf3c6056p-3,   0x1.f630bep-2, INEXACT)
T(RN,    0x1.9be38758e92adp-1,   -0x1.bd95ff60d3404p-3,  -0x1.f895f4p-2, INEXACT)
T(RN,    0x1.9bbf8819dee78p-1,   -0x1.be490365619dfp-3,    0x1.f9fa8p-2, INEXACT)
T(RN,     0x1.9ae7cea6b8f2p-1,   -0x1.c27b1b80b7e0cp-3,   0x1.fefeecp-2, INEXACT)
T(RN,    0x1.9a7c1c530ff09p-1,   -0x1.c494278e62f02p-3,  -0x1.f92316p-2, INEXACT)
T(RN,    0x1.9a345fca3a025p-1,   -0x1.c5fa2f977fb22p-3,  -0x1.fbdb2ep-2, INEXACT)
T(RN,    0x1.99a50c528a22ep-1,   -0x1.c8c63fa9bb0ccp-3,  -0x1.f64ae4p-2, INEXACT)
T(RN,    0x1.99813f486f8a7p-1,   -0x1.c97943ae483b3p-3,   0x1.f62b02p-2, INEXACT)
T(RN,    0x1.96db58cb423a4p-1,    -0x1.d6c29004d87fp-3,   0x1.f5ea52p-2, INEXACT)
T(RN,    0x1.96943e920eb89p-1,   -0x1.d828980df559cp-3,   0x1.f707a2p-2, INEXACT)
T(RN,    0x1.957851d9cfdf6p-1,   -0x1.ddc0b83268202p-3,   0x1.f699ecp-2, INEXACT)
T(RN,    0x1.94eaa5e075839p-1,   -0x1.e08cc844a1974p-3,  -0x1.fe954ep-2, INEXACT)
T(RN,    0x1.9292b268ba6b6p-1,   -0x1.ec700c9215d11p-3,   0x1.fc2c92p-2, INEXACT)
T(RN,    0x1.91e2e7074377dp-1,   -0x1.efef20a8ddbbap-3,  -0x1.fcb9c8p-2, INEXACT)
T(RN,    0x1.91567b99e7bb3p-1,   -0x1.f2bb30bb17275p-3,  -0x1.f9cbf4p-2, INEXACT)
T(RN,    0x1.90ed4b3b60863p-1,   -0x1.f4d43cc8c239dp-3,   0x1.fad9ecp-2, INEXACT)
T(RN,    0x1.903e37de496ecp-1,   -0x1.f85350df8a198p-3,  -0x1.fe11b8p-2, INEXACT)
T(RN,    0x1.8ff845895e1ddp-1,   -0x1.f9b958e8a6df8p-3,   0x1.fac446p-2, INEXACT)
T(RN,    0x1.8f499d2b28336p-1,   -0x1.fd386cff6ea0ep-3,   0x1.fa922ap-2, INEXACT)
T(RN,    0x1.8f03d59580bd8p-1,   -0x1.fe9e75088b59bp-3,   0x1.f6e03cp-2, INEXACT)
T(RN,    0x1.8ee0f65d80528p-1,   -0x1.ff51790d19cabp-3,   0x1.feecfep-2, INEXACT)
T(RN,    0x1.8ebe1a31b1dbap-1,   -0x1.00023e88d4103p-2,   0x1.f792f2p-2, INEXACT)
T(RN,    0x1.8d84e5a04bb78p-1,   -0x1.0327d09d54b81p-2,   0x1.fa2b46p-2, INEXACT)
T(RN,    0x1.8cb4a0a31a25cp-1,   -0x1.0540dcaaffd0cp-2,    0x1.fdf8dp-2, INEXACT)
T(RN,    0x1.8c6f4c9116405p-1,   -0x1.05f3e0af8e29dp-2,  -0x1.f8cb92p-2, INEXACT)
T(RN,    0x1.8c2a049cbafaap-1,   -0x1.06a6e4b41c8cdp-2,  -0x1.fa5424p-2, INEXACT)
T(RN,    0x1.8b9f99048686ap-1,   -0x1.080cecbd39586p-2,   0x1.f6508ep-2, INEXACT)
T(RN,    0x1.8b155dc990ebap-1,    -0x1.0972f4c65606p-2,   0x1.f80476p-2, INEXACT)
T(RN,     0x1.8a465f7b00acp-1,   -0x1.0b8c00d4011f9p-2,  -0x1.fc2842p-2, INEXACT)
T(RN,    0x1.88cbfc16eecfap-1,   -0x1.0f6496ed1025ep-2,   -0x1.fb44cp-2, INEXACT)
T(RN,    0x1.8730d0afd10eep-1,   -0x1.1396af0866548p-2,  -0x1.fdfd3cp-2, INEXACT)
T(RN,    0x1.86ca4927bbca1p-1,   -0x1.14a3350f3be49p-2,  -0x1.f9777ap-2, INEXACT)
T(RN,    0x1.86a821f377fc9p-1,   -0x1.14fcb711830d6p-2,  -0x1.f6b996p-2, INEXACT)
T(RN,     0x1.8685fdbb511ep-1,   -0x1.15563913ca401p-2,   0x1.fccfc6p-2, INEXACT)
T(RN,    0x1.850f3406917b4p-1,   -0x1.192ecf2cd9457p-2,   0x1.f5e5ccp-2, INEXACT)
T(RN,    0x1.848743ed6ff01p-1,    -0x1.1a94d735f5ffp-2,  -0x1.fa9c78p-2, INEXACT)
T(RN,    0x1.83ff8353821cap-1,   -0x1.1bfadf3f12b72p-2,  -0x1.fa4f8cp-2, INEXACT)
T(RN,    0x1.83dd9a96f4be3p-1,    -0x1.1c54614159e6p-2,  -0x1.f71d58p-2, INEXACT)
T(RN,    0x1.83561544b1dd4p-1,   -0x1.1dba694a76a1fp-2,   0x1.feaaeep-2, INEXACT)
T(RN,    0x1.815b8681d8004p-1,   -0x1.22f9076ca2663p-2,   -0x1.fb409p-2, INEXACT)
T(RN,    0x1.8091a0af8ab47p-1,   -0x1.2512137a4d842p-2,  -0x1.f6c72ap-2, INEXACT)
T(RN,    0x1.800b42403554cp-1,   -0x1.26781b836a56cp-2,  -0x1.f6976ep-2, INEXACT)
T(RN,    0x1.7ce8e352eb9b8p-1,   -0x1.2edc4bba16a53p-2,  -0x1.ff431cp-2, INEXACT)
T(RN,    0x1.7c850d9bfad19p-1,   -0x1.2fe8d1c0ec31bp-2,  -0x1.f87628p-2, INEXACT)
T(RN,    0x1.7c21520f9b9dcp-1,   -0x1.30f557c7c1b91p-2,   -0x1.fa32dp-2, INEXACT)
T(RN,    0x1.7b7b538e128d8p-1,    -0x1.32b4e1d325a6p-2,  -0x1.fdc45ep-2, INEXACT)
T(RN,    0x1.7b39020e37fd4p-1,   -0x1.3367e5d7b4084p-2,   0x1.f748aep-2, INEXACT)
T(RN,    0x1.7a51400684184p-1,   -0x1.35da73e7a64a8p-2,  -0x1.f6fd86p-2, INEXACT)
T(RN,    0x1.79cd10c3c1e45p-1,   -0x1.37407bf0c313ep-2,  -0x1.f82226p-2, INEXACT)
T(RN,    0x1.798b0a75319cbp-1,   -0x1.37f37ff5516bep-2,  -0x1.ff2ecap-2, INEXACT)
T(RN,    0x1.792816a1312e9p-1,   -0x1.390005fc270bep-2,   0x1.f9a96ep-2, INEXACT)
T(RN,    0x1.790720739bce2p-1,   -0x1.395987fe6e221p-2,    0x1.f68eap-2, INEXACT)
T(RN,    0x1.788364894f506p-1,    -0x1.3abf90078ae6p-2,  -0x1.f64626p-2, INEXACT)
T(RN,    0x1.784197d7dc066p-1,   -0x1.3b72940c193d4p-2,   -0x1.fb662p-2, INEXACT)
T(RN,    0x1.777c76ba2d3b2p-1,   -0x1.3d8ba019c463ep-2,  -0x1.f698fep-2, INEXACT)
T(RN,     0x1.775ba5ebe63fp-1,   -0x1.3de5221c0b8b7p-2,   0x1.faeb1ap-2, INEXACT)
T(RN,    0x1.765586a3725c7p-1,   -0x1.40b1322e44ffap-2,   0x1.fda63ap-2, INEXACT)
T(RN,    0x1.7634cf9bdb0dep-1,   -0x1.410ab4308c368p-2,  -0x1.f7132ep-2, INEXACT)
T(RN,    0x1.75f36a203bb1ep-1,   -0x1.41bdb8351a88bp-2,   -0x1.f6a1dp-2, INEXACT)
T(RN,    0x1.75d2bbabb3ad6p-1,   -0x1.42173a3761c83p-2,   0x1.f6352cp-2, INEXACT)
T(RN,    0x1.74ee46673faa8p-1,   -0x1.4489c84754067p-2,   0x1.fa9146p-2, INEXACT)
T(RN,    0x1.742ae3500b345p-1,   -0x1.46a2d454ff284p-2,   0x1.f6973cp-2, INEXACT)
T(RN,    0x1.73e9d90a8d13dp-1,   -0x1.4755d8598d78dp-2,   0x1.ffc5a8p-2, INEXACT)
T(RN,    0x1.726489d610c28p-1,   -0x1.4b87f074e3dcep-2,  -0x1.f659ccp-2, INEXACT)
T(RN,    0x1.720375c665c76p-1,   -0x1.4c94767bb93b9p-2,  -0x1.faef1cp-2, INEXACT)
T(RN,    0x1.71c2cbdf0a8f7p-1,   -0x1.4d477a8047e26p-2,   0x1.f6c6d4p-2, INEXACT)
T(RN,    0x1.70e0d22671caep-1,   -0x1.4fba089039de3p-2,   0x1.ff3612p-2, INEXACT)
T(RN,    0x1.701f8e9b15557p-1,   -0x1.51d3149de4f97p-2,   0x1.f6ad72p-2, INEXACT)
T(RN,    0x1.6f3e95192f8a6p-1,   -0x1.5445a2add7428p-2,  -0x1.f7f7c6p-2, INEXACT)
T(RN,    0x1.6dfe1f1519891p-1,   -0x1.57c4b6c49f1b5p-2,   -0x1.f65fcp-2, INEXACT)
T(RN,    0x1.6b8079025d83bp-1,   -0x1.5ec2def22ec32p-2,   0x1.fe4488p-2, INEXACT)
T(RN,    0x1.6b60b454b02bcp-1,   -0x1.5f1c60f475f2fp-2,  -0x1.f7bacap-2, INEXACT)
T(RN,    0x1.6a239e177ed1bp-1,   -0x1.629b750b3dc2ep-2,  -0x1.fe3112p-2, INEXACT)
T(RN,    0x1.69e4547a34453p-1,   -0x1.634e790fcc25cp-2,  -0x1.fc472ep-2, INEXACT)
T(RN,    0x1.68c811f911d7bp-1,   -0x1.66740b244cd22p-2,   0x1.fe1a0ap-2, INEXACT)
T(RN,    0x1.684a033cde073p-1,   -0x1.67da132d69832p-2,   0x1.fc1848p-2, INEXACT)
T(RN,    0x1.67cc208c1a968p-1,   -0x1.69401b3686507p-2,  -0x1.f62a24p-2, INEXACT)
T(RN,    0x1.676dd365c7a91p-1,   -0x1.6a4ca13d5bd33p-2,  -0x1.fb6354p-2, INEXACT)
T(RN,    0x1.672f0307cb1ccp-1,   -0x1.6affa541ea2dep-2,   0x1.f5e2f2p-2, INEXACT)
T(RN,    0x1.66f03da4046a6p-1,   -0x1.6bb2a946788acp-2,    0x1.f60d9p-2, INEXACT)
T(RN,    0x1.65b7071731816p-1,   -0x1.6f31bd5d405d9p-2,   0x1.fa7924p-2, INEXACT)
T(RN,    0x1.6597c3e218524p-1,   -0x1.6f8b3f5f87e6dp-2,  -0x1.f60f88p-2, INEXACT)
T(RN,     0x1.653a0aa67e25p-1,    -0x1.7097c5665d1bp-2,   0x1.f64696p-2, INEXACT)
T(RN,    0x1.64fb9ccf72519p-1,   -0x1.714ac96aeb847p-2,   0x1.f5f398p-2, INEXACT)
T(RN,    0x1.62aca86be19f4p-1,   -0x1.77ef6f9633f62p-2,   0x1.fe1f46p-2, INEXACT)
T(RN,    0x1.628da93d5c8a9p-1,   -0x1.7848f1987b2dfp-2,  -0x1.f6ef46p-2, INEXACT)
T(RN,    0x1.6230bbf1d49e4p-1,   -0x1.7955779f50b25p-2,  -0x1.fc26d4p-2, INEXACT)
T(RN,    0x1.61f2d5f27791ap-1,    -0x1.7a087ba3df0ep-2,  -0x1.fc70cep-2, INEXACT)
T(RN,    0x1.61772a659aed3p-1,   -0x1.7b6e83acfbce8p-2,   0x1.fcf3d6p-2, INEXACT)
T(RN,     0x1.615846436672p-1,   -0x1.7bc805af42fe5p-2,  -0x1.fc8aecp-2, INEXACT)
T(RN,    0x1.611a861817dddp-1,   -0x1.7c7b09b3fbb79p-2,  -0x1.f5c296p-2, INEXACT)
T(RN,    0x1.5f6b72a9d3093p-1,   -0x1.816025d3b5ee8p-2,  -0x1.f9e9d4p-2, INEXACT)
T(RN,    0x1.5e760adc6eb87p-1,   -0x1.842c35e5ef673p-2,  -0x1.fd2abep-2, INEXACT)
T(RN,    0x1.5e5769f1ee00dp-1,    -0x1.8485b7e836a4p-2,    -0x1.f6d3p-2, INEXACT)
T(RN,     0x1.5e1a30247688p-1,   -0x1.8538bbecc4eadp-2,  -0x1.fd7d1ep-2, INEXACT)
T(RN,    0x1.5dbe6d7f99f9cp-1,   -0x1.864541f39a88dp-2,  -0x1.ffabb8p-2, INEXACT)
T(RN,    0x1.5d25b3db7e423p-1,   -0x1.8804cbfefe685p-2,  -0x1.f8f1c4p-2, INEXACT)
T(RN,    0x1.5c13741701796p-1,   -0x1.8b2a5e137f096p-2,   -0x1.fe834p-2, INEXACT)
T(RN,    0x1.5bf508894bcafp-1,    -0x1.8b83e015c667p-2,   0x1.f5fc94p-2, INEXACT)
T(RN,     0x1.59789aa55baep-1,   -0x1.92db8a459d25bp-2,  -0x1.fb9722p-2, INEXACT)
T(RN,    0x1.58c39a90188b4p-1,   -0x1.94f49653482f3p-2,   0x1.fe158ap-2, INEXACT)
T(RN,    0x1.58875a48eb50dp-1,   -0x1.95a79a57d68f6p-2,   -0x1.f7e69p-2, INEXACT)
T(RN,    0x1.57f0e7a3fe18ep-1,   -0x1.976724633a8bfp-2,  -0x1.f5e922p-2, INEXACT)
T(RN,    0x1.57d2d899578a7p-1,   -0x1.97c0a66581b47p-2,   0x1.f62d6ap-2, INEXACT)
T(RN,    0x1.5796c265566ccp-1,   -0x1.9873aa6a10092p-2,  -0x1.ff1898p-2, INEXACT)
T(RN,    0x1.56e2bec32dd94p-1,   -0x1.9a8cb677bb269p-2,   0x1.ff0caap-2, INEXACT)
T(RN,    0x1.5688e0534c0dfp-1,   -0x1.9b993c7e90aebp-2,  -0x1.fa6cdap-2, INEXACT)
T(RN,    0x1.561131b6372c5p-1,   -0x1.9cff4487ad647p-2,  -0x1.f5d2acp-2, INEXACT)
T(RN,    0x1.55f34c9833105p-1,   -0x1.9d58c689f4a8cp-2,  -0x1.f7ca02p-2, INEXACT)
T(RN,    0x1.55d56a17073ecp-1,    -0x1.9db2488c3be4p-2,  -0x1.f6e038p-2, INEXACT)
T(RN,    0x1.552251e0f651cp-1,   -0x1.9fcb5499e6dabp-2,   -0x1.f7df7p-2, INEXACT)
T(RN,    0x1.54ab208b96a5cp-1,   -0x1.a1315ca3039b1p-2,   0x1.f654b6p-2, INEXACT)
T(RN,    0x1.5381db49f4d3ep-1,   -0x1.a4b070b9cb6eep-2,   0x1.f9b788p-2, INEXACT)
T(RN,    0x1.5328df891542dp-1,    -0x1.a5bcf6c0a0f9p-2,   0x1.fcc1dep-2, INEXACT)
T(RN,    0x1.52ed99fdcf506p-1,   -0x1.a66ffac52f5d3p-2,  -0x1.fd3342p-2, INEXACT)
T(RN,    0x1.5259996f00869p-1,   -0x1.a82f84d093468p-2,   0x1.fcad96p-2, INEXACT)
T(RN,    0x1.521e781ce130ap-1,   -0x1.a8e288d5219f6p-2,  -0x1.fb3902p-2, INEXACT)
T(RN,    0x1.51e3612029127p-1,   -0x1.a9958cd9b0078p-2,   0x1.f9eabcp-2, INEXACT)
T(RN,    0x1.50f76c5f3789bp-1,   -0x1.ac619cebe979bp-2,   -0x1.fb917p-2, INEXACT)
T(RN,    0x1.4feebdf5558d1p-1,    -0x1.af872f006a21p-2,   0x1.f828dap-2, INEXACT)
T(RN,    0x1.4fd1621744772p-1,   -0x1.afe0b102b1527p-2,  -0x1.f8d332p-2, INEXACT)
T(RN,    0x1.4f96b20d7598ep-1,   -0x1.b093b5073fb55p-2,   0x1.f6002ap-2, INEXACT)
T(RN,     0x1.4ec99aa404c5p-1,   -0x1.b3064317321ccp-2,  -0x1.f7e4ecp-2, INEXACT)
T(RN,    0x1.4cf6a905ede6fp-1,   -0x1.b89e633ba4e69p-2,  -0x1.f74378p-2, INEXACT)
T(RN,    0x1.4b2642ac8ccfap-1,   -0x1.be36836017da2p-2,  -0x1.fcfe6ap-2, INEXACT)
T(RN,    0x1.4b0951d1fbcd3p-1,   -0x1.be9005625f00ep-2,   0x1.f94904p-2, INEXACT)
T(RN,    0x1.4aec637eea1eep-1,   -0x1.bee98764a62edp-2,  -0x1.ffaca6p-2, INEXACT)
T(RN,    0x1.4a3f029d9283ap-1,   -0x1.c102937251584p-2,   0x1.fbd43ep-2, INEXACT)
T(RN,    0x1.49e874403a816p-1,   -0x1.c20f197926d61p-2,  -0x1.fdc088p-2, INEXACT)
T(RN,    0x1.49cb9f2bfd09dp-1,   -0x1.c2689b7b6e056p-2,   -0x1.fe0c3p-2, INEXACT)
T(RN,    0x1.4991fc927f82fp-1,   -0x1.c31b9f7ffc695p-2,  -0x1.f625fap-2, INEXACT)
T(RN,    0x1.49752f0ccebb1p-1,   -0x1.c37521824394ap-2,   -0x1.ff22bp-2, INEXACT)
T(RN,    0x1.491ed59550337p-1,   -0x1.c481a78919606p-2,    0x1.f62aep-2, INEXACT)
T(RN,    0x1.4902121ff11b6p-1,    -0x1.c4db298b604cp-2,   0x1.f80b4ap-2, INEXACT)
T(RN,    0x1.48e5512e19a0ap-1,   -0x1.c534ab8da77d9p-2,  -0x1.f9157cp-2, INEXACT)
T(RN,     0x1.47c651cd8ae1p-1,   -0x1.c8b3bfa46f581p-2,  -0x1.fa95e2p-2, INEXACT)
T(RN,    0x1.47a9ac740c643p-1,    -0x1.c90d41a6b69cp-2,   0x1.f5fd4cp-2, INEXACT)
T(RN,    0x1.468bc082762cap-1,   -0x1.cc8c55bd7e582p-2,  -0x1.fa1368p-2, INEXACT)
T(RN,    0x1.466f36a6d504fp-1,   -0x1.cce5d7bfc58cep-2,  -0x1.ff3956p-2, INEXACT)
T(RN,    0x1.4652af49b2da2p-1,   -0x1.cd3f59c20cc8dp-2,   0x1.f5db12p-2, INEXACT)
T(RN,    0x1.45fd2827187cep-1,   -0x1.ce4bdfc8e2402p-2,   0x1.f8bd76p-2, INEXACT)
T(RN,    0x1.45e0aac1c4759p-1,   -0x1.cea561cb29903p-2,  -0x1.f888d8p-2, INEXACT)
T(RN,     0x1.456ece105962p-1,   -0x1.d00b69d4462c6p-2,  -0x1.fe8eaap-2, INEXACT)
T(RN,    0x1.4535eea3bb4dbp-1,   -0x1.d0be6dd8d48abp-2,  -0x1.fbfb64p-2, INEXACT)
T(RN,    0x1.44c44d99fd46bp-1,   -0x1.d22475e1f145bp-2,    0x1.f63f1p-2, INEXACT)
T(RN,    0x1.44367c20f5636p-1,   -0x1.d3e3ffed5536ap-2,   0x1.f67222p-2, INEXACT)
T(RN,    0x1.43c5345825e49p-1,    -0x1.d54a07f671eep-2,   0x1.f87934p-2, INEXACT)
T(RN,    0x1.438c9f4c51b45p-1,   -0x1.d5fd0bfb00528p-2,  -0x1.fcafd8p-2, INEXACT)
T(RN,    0x1.43541423e6dd1p-1,   -0x1.d6b00fff8ebd8p-2,    0x1.f6f8bp-2, INEXACT)
T(RN,    0x1.41e57c2d1ca52p-1,   -0x1.db3baa1d2c13cp-2,   -0x1.f9958p-2, INEXACT)
T(RN,    0x1.4104b24b797dap-1,   -0x1.de07ba2f6585fp-2,   0x1.fe4446p-2, INEXACT)
T(RN,    0x1.40e8a41b15514p-1,   -0x1.de613c31acbe4p-2,     0x1.ff79p-2, INEXACT)
T(RN,    0x1.407883dc418f5p-1,   -0x1.dfc7443ac96dbp-2,   0x1.fe129cp-2, INEXACT)
T(RN,    0x1.405c81ec29b1ep-1,   -0x1.e020c63d1099fp-2,   0x1.fd9dcep-2, INEXACT)
T(RN,    0x1.3fb4a9ab15365p-1,   -0x1.e239d24abbbb1p-2,   0x1.fe43f6p-2, INEXACT)
T(RN,    0x1.3df6c11617c24p-1,   -0x1.e7d1f26f2ea53p-2,   0x1.fb2a26p-2, INEXACT)
T(RN,    0x1.3dbf2fd008d87p-1,   -0x1.e884f673bd0cdp-2,   0x1.f94fe2p-2, INEXACT)
T(RN,    0x1.3c1fa3572fa0ap-1,   -0x1.edc39495e8cc5p-2,   0x1.f84188p-2, INEXACT)
T(RN,     0x1.3bccc88cb6f8p-1,   -0x1.eed01a9cbe4edp-2,   0x1.fcea08p-2, INEXACT)
T(RN,    0x1.3af0408bee76bp-1,   -0x1.f19c2aaef7ca2p-2,   0x1.fb4e7cp-2, INEXACT)
T(RN,    0x1.39c200ea045f9p-1,   -0x1.f574c0c806cb4p-2,   0x1.fe5b06p-2, INEXACT)
T(RN,    0x1.3938fe20e1ce3p-1,   -0x1.f7344ad36ab81p-2,   -0x1.f6798p-2, INEXACT)
T(RN,    0x1.390240f8df581p-1,   -0x1.f7e74ed7f9189p-2,   0x1.fc8b4ep-2, INEXACT)
T(RN,    0x1.3842f6374dc56p-1,    -0x1.fa59dce7eb5cp-2,  -0x1.f83fe6p-2, INEXACT)
T(RN,    0x1.37d5db6ee4d1ep-1,   -0x1.fbbfe4f1081c6p-2,  -0x1.f71c1ep-2, INEXACT)
T(RN,    0x1.379f5c572aae9p-1,   -0x1.fc72e8f596a8fp-2,   0x1.f5d17ep-2, INEXACT)
T(RN,    0x1.356563a06e7b7p-1,   -0x1.01e54992b6abbp-1,  -0x1.f73cb8p-2, INEXACT)
T(RN,    0x1.35144c3adba6bp-1,   -0x1.026b8c96216e8p-1,   -0x1.f9622p-2, INEXACT)
T(RN,    0x1.348d54747be7bp-1,   -0x1.034b519bd3674p-1,   0x1.f88ff4p-2, INEXACT)
T(RN,    0x1.343c75afbbecbp-1,   -0x1.03d1949f3e2b5p-1,   0x1.fffbbap-2, INEXACT)
T(RN,    0x1.3406979e14deep-1,   -0x1.042b16a1855b5p-1,  -0x1.f6573cp-2, INEXACT)
T(RN,     0x1.3314a4b61f28p-1,   -0x1.05bddfabc5c92p-1,   0x1.f7223ap-2, INEXACT)
T(RN,    0x1.3273c1b98e66bp-1,   -0x1.06ca65b29b3d6p-1,  -0x1.fe2834p-2, INEXACT)
T(RN,    0x1.3258f96d43537p-1,   -0x1.06f726b3bed4bp-1,  -0x1.fe82b8p-2, INEXACT)
T(RN,    0x1.31d33307cece3p-1,   -0x1.07d6ebb970c77p-1,  -0x1.f8d522p-2, INEXACT)
T(RN,    0x1.31830b3d2f8abp-1,   -0x1.085d2ebcdb8d5p-1,   0x1.fcaff2p-2, INEXACT)
T(RN,    0x1.314da70cf8e7ep-1,   -0x1.08b6b0bf22bb9p-1,   0x1.f738b8p-2, INEXACT)
T(RN,    0x1.3078738a63bd4p-1,   -0x1.0a1cb8c83f806p-1,   -0x1.f5f87p-2, INEXACT)
T(RN,    0x1.305dd7941cc22p-1,   -0x1.0a4979c9630e9p-1,  -0x1.fb0d1ep-2, INEXACT)
T(RN,    0x1.2f6ec4792eaeep-1,   -0x1.0bdc42d3a361ep-1,  -0x1.ffe2bcp-2, INEXACT)
T(RN,    0x1.2f543fbb166fep-1,   -0x1.0c0903d4c6f96p-1,   0x1.fe6224p-2, INEXACT)
T(RN,    0x1.2e4b8fa464d7ap-1,   -0x1.0dc88de02ae58p-1,   0x1.f64adep-2, INEXACT)
T(RN,    0x1.2de1f0527c38bp-1,   -0x1.0e7b91e4b9427p-1,  -0x1.fd8f12p-2, INEXACT)
T(RN,    0x1.2dc78e42b21b1p-1,   -0x1.0ea852e5dcda4p-1,  -0x1.f7b988p-2, INEXACT)
T(RN,    0x1.2cc0385485e37p-1,   -0x1.1067dcf140c45p-1,   0x1.f97214p-2, INEXACT)
T(RN,    0x1.2bee32abf6e79p-1,   -0x1.11cde4fa5d82fp-1,   0x1.fd8c6ep-2, INEXACT)
T(RN,    0x1.2bd3fc48f283cp-1,   -0x1.11faa5fb811bcp-1,  -0x1.fcb7a6p-2, INEXACT)
T(RN,    0x1.2bb9c83062856p-1,   -0x1.122766fca4c61p-1,  -0x1.f60d52p-2, INEXACT)
T(RN,    0x1.2ae879cc3ff56p-1,   -0x1.138d6f05c16b7p-1,   -0x1.f6f5fp-2, INEXACT)
T(RN,    0x1.29e3a54e2208fp-1,   -0x1.154cf91125583p-1,  -0x1.fb616ep-2, INEXACT)
T(RN,    0x1.29c99c96402d6p-1,   -0x1.1579ba1248ed9p-1,  -0x1.f81a7ep-2, INEXACT)
T(RN,    0x1.297b9014971e4p-1,   -0x1.15fffd15b3b57p-1,  -0x1.ff0dc6p-2, INEXACT)
T(RN,    0x1.296190755ea73p-1,   -0x1.162cbe16d74cfp-1,  -0x1.f75546p-2, INEXACT)
T(RN,    0x1.2947931bd143bp-1,   -0x1.16597f17fb0fep-1,   0x1.f6caf4p-2, INEXACT)
T(RN,    0x1.292d9807bc6a9p-1,   -0x1.168640191e7a8p-1,   0x1.fad44cp-2, INEXACT)
T(RN,    0x1.29139f38ecfcap-1,   -0x1.16b3011a4212fp-1,  -0x1.ffe3e4p-2, INEXACT)
T(RN,    0x1.2877fa03a8c51p-1,   -0x1.17bf872117a9bp-1,  -0x1.f8d7a2p-2, INEXACT)
T(RN,    0x1.28442a686bf89p-1,   -0x1.181909235ed42p-1,   0x1.fa1a5cp-2, INEXACT)
T(RN,    0x1.27a8f1e4183dcp-1,   -0x1.19258f2a345c7p-1,   0x1.f6fb6cp-2, INEXACT)
T(RN,    0x1.26f44164cec67p-1,   -0x1.1a5ed6322d802p-1,   0x1.fe33d4p-2, INEXACT)
T(RN,    0x1.26c0b58bb0c3cp-1,   -0x1.1ab8583474b77p-1,   0x1.f98b64p-2, INEXACT)
T(RN,    0x1.267374a97b07fp-1,   -0x1.1b3e9b37df7f1p-1,   -0x1.fb106p-2, INEXACT)
T(RN,    0x1.263fff52b0711p-1,   -0x1.1b981d3a26a25p-1,   0x1.f61294p-2, INEXACT)
T(RN,    0x1.25f2e02c97d11p-1,   -0x1.1c1e603d91687p-1,   0x1.fb5d62p-2, INEXACT)
T(RN,    0x1.257283d595937p-1,   -0x1.1cfe25434362fp-1,  -0x1.fd5d4ep-2, INEXACT)
T(RN,     0x1.25259a8aa3b8p-1,   -0x1.1d846846ae269p-1,  -0x1.f8e434p-2, INEXACT)
T(RN,    0x1.22422ce83e40bp-1,   -0x1.22964567b6547p-1,  -0x1.f964dcp-2, INEXACT)
T(RN,    0x1.220f73228f12ep-1,   -0x1.22efc769fd80ep-1,   0x1.f9ff22p-2, INEXACT)
T(RN,    0x1.21dcc23a45c2fp-1,   -0x1.2349496c44ad8p-1,  -0x1.fdde5cp-2, INEXACT)
T(RN,    0x1.21c36d18ab5a6p-1,   -0x1.23760a6d68459p-1,   0x1.f8c448p-2, INEXACT)
T(RN,     0x1.21aa1a2dd5b5p-1,   -0x1.23a2cb6e8bddcp-1,   0x1.f6b382p-2, INEXACT)
T(RN,    0x1.2190c979934b2p-1,   -0x1.23cf8c6faf74cp-1,   0x1.fcd432p-2, INEXACT)
T(RN,    0x1.212b9cc66bdf8p-1,   -0x1.248290743dd0dp-1,  -0x1.faa5fcp-2, INEXACT)
T(RN,    0x1.20f913af44ee7p-1,   -0x1.24dc127684fedp-1,  -0x1.fd3a9ap-2, INEXACT)
T(RN,    0x1.202f479422745p-1,   -0x1.26421a7fa1c21p-1,   -0x1.f9a34p-2, INEXACT)
T(RN,    0x1.1fca966511d27p-1,     -0x1.26f51e84302p-1,   0x1.fdb6bcp-2, INEXACT)
T(RN,    0x1.1f660864968c7p-1,   -0x1.27a82288be77dp-1,  -0x1.f76324p-2, INEXACT)
T(RN,    0x1.1f4cea624e312p-1,   -0x1.27d4e389e20ddp-1,   0x1.fe0d96p-2, INEXACT)
T(RN,    0x1.1f019d8665b2bp-1,    -0x1.285b268d4cd4p-1,  -0x1.fea13ep-2, INEXACT)
T(RN,    0x1.1ee8884ac4bd6p-1,   -0x1.2887e78e706dcp-1,  -0x1.ff0998p-2, INEXACT)
T(RN,    0x1.1e6b3efe8eabcp-1,   -0x1.2967ac9422629p-1,   0x1.f8843ap-2, INEXACT)
T(RN,      0x1.1e5236e7295p-1,   -0x1.29946d9545fc4p-1,    0x1.fd7fdp-2, INEXACT)
T(RN,    0x1.1d8a44dd3a202p-1,   -0x1.2afa759e62f1cp-1,  -0x1.f5ce6ap-2, INEXACT)
T(RN,    0x1.1d3f6e1e22156p-1,    -0x1.2b80b8a1cd7bp-1,   0x1.fc89eep-2, INEXACT)
T(RN,    0x1.1d0d9484bc4c2p-1,   -0x1.2bda3aa414ab3p-1,   0x1.fb0ccep-2, INEXACT)
T(RN,    0x1.1cf4aafc77055p-1,   -0x1.2c06fba53843cp-1,  -0x1.fb0d2ep-2, INEXACT)
T(RN,    0x1.1cc2de73d411fp-1,   -0x1.2c607da77f721p-1,  -0x1.fd774ep-2, INEXACT)
T(RN,    0x1.1c46852e23a92p-1,   -0x1.2d4042ad31655p-1,    0x1.faa09p-2, INEXACT)
T(RN,    0x1.1b4e7571a3be5p-1,   -0x1.2effccb895512p-1,   -0x1.fa9cdp-2, INEXACT)
T(RN,    0x1.1b35b2fce113ep-1,   -0x1.2f2c8db9b8ee5p-1,   0x1.f5fdf2p-2, INEXACT)
T(RN,    0x1.1aa151aaa60d1p-1,    -0x1.303913c08e77p-1,  -0x1.f6ae1cp-2, INEXACT)
T(RN,    0x1.1a573e2b1a32ep-1,   -0x1.30bf56c3f93cdp-1,   0x1.fc52f4p-2, INEXACT)
T(RN,    0x1.1a25e69fa3148p-1,   -0x1.3118d8c64071ap-1,   -0x1.f8a41p-2, INEXACT)
T(RN,    0x1.19f497b3aa333p-1,   -0x1.31725ac88799ep-1,   0x1.fa7b1cp-2, INEXACT)
T(RN,    0x1.19c35165adb98p-1,   -0x1.31cbdccacecdcp-1,  -0x1.fdc7a4p-2, INEXACT)
T(RN,     0x1.19aab17975adp-1,   -0x1.31f89dcbf261cp-1,   -0x1.f67d9p-2, INEXACT)
T(RN,    0x1.1960de9da4469p-1,   -0x1.327ee0cf5d299p-1,  -0x1.fddebap-2, INEXACT)
T(RN,     0x1.186b560d040ep-1,   -0x1.343e6adac1146p-1,  -0x1.f9e1bep-2, INEXACT)
T(RN,    0x1.1852d430c0424p-1,   -0x1.346b2bdbe4ab7p-1,   0x1.fc453cp-2, INEXACT)
T(RN,    0x1.183a5478ca6ccp-1,   -0x1.3497ecdd08464p-1,   0x1.fd14b4p-2, INEXACT)
T(RN,    0x1.18095b7509076p-1,   -0x1.34f16edf4f715p-1,  -0x1.fc3e4cp-2, INEXACT)
T(RN,    0x1.17d86b0040af3p-1,   -0x1.354af0e196a15p-1,   0x1.ff3112p-2, INEXACT)
T(RN,    0x1.16521ac1bfa04p-1,   -0x1.381700f3d0155p-1,   0x1.fa5372p-2, INEXACT)
T(RN,    0x1.1621771089deep-1,   -0x1.387082f6174e3p-1,  -0x1.f6e3c6p-2, INEXACT)
T(RN,    0x1.14e61dffd9ddbp-1,   -0x1.3ab65004e5f75p-1,  -0x1.ff0534p-2, INEXACT)
T(RN,    0x1.14cdeae6af8f1p-1,   -0x1.3ae31106098d6p-1,  -0x1.fc8f82p-2, INEXACT)
T(RN,    0x1.149d8b0c6f10dp-1,   -0x1.3b3c930850bb1p-1,  -0x1.fb072ap-2, INEXACT)
T(RN,    0x1.14550b1e7b1a8p-1,   -0x1.3bc2d60bbb858p-1,  -0x1.f8d4a8p-2, INEXACT)
T(RN,    0x1.13ac2a7abbe57p-1,   -0x1.3cfc1d13b4f12p-1,   0x1.f64142p-2, INEXACT)
T(RN,    0x1.131bbc15de01fp-1,   -0x1.3e08a31a8a359p-1,   0x1.f9aa94p-2, INEXACT)
T(RN,    0x1.12bb9c89d126dp-1,   -0x1.3ebba71f1891ap-1,   0x1.f5ed84p-2, INEXACT)
T(RN,    0x1.12739aebccd9ap-1,   -0x1.3f41ea22835cdp-1,   0x1.ff2dacp-2, INEXACT)
T(RN,    0x1.125b9e93ad6afp-1,   -0x1.3f6eab23a6f44p-1,  -0x1.f8eeb4p-2, INEXACT)
T(RN,    0x1.109571819f2f5p-1,   -0x1.42c0fe394b2cbp-1,   0x1.fd689ep-2, INEXACT)
T(RN,    0x1.107d9ef37af72p-1,   -0x1.42edbf3a6ec69p-1,  -0x1.f83206p-2, INEXACT)
T(RN,    0x1.1065ce7a52975p-1,    -0x1.431a803b925fp-1,  -0x1.fbed06p-2, INEXACT)
T(RN,    0x1.0ea2e01d9d048p-1,   -0x1.466cd351369a8p-1,   0x1.f643b2p-2, INEXACT)
T(RN,    0x1.0e4450958105dp-1,   -0x1.471fd755c4f85p-1,  -0x1.f60828p-2, INEXACT)
T(RN,    0x1.0e2cb1dd83524p-1,   -0x1.474c9856e8912p-1,   0x1.f96888p-2, INEXACT)
T(RN,    0x1.0e151535f9b8bp-1,   -0x1.477959580c279p-1,  -0x1.f73fbcp-2, INEXACT)
T(RN,    0x1.0ce2dc3b41574p-1,   -0x1.49bf2666dada5p-1,  -0x1.fc4e04p-2, INEXACT)
T(RN,    0x1.0c2717117d6fbp-1,   -0x1.4b252e6ff7b0bp-1,   0x1.f65918p-2, INEXACT)
T(RN,    0x1.0bb1fe736ca26p-1,   -0x1.4c04f375a98a2p-1,  -0x1.fda1dcp-2, INEXACT)
T(RN,    0x1.0b833620474fap-1,   -0x1.4c5e7577f0bafp-1,   -0x1.fa3adp-2, INEXACT)
T(RN,    0x1.0a6b2fac25d39p-1,    -0x1.4e7781859bd3p-1,    0x1.fb49dp-2, INEXACT)
T(RN,    0x1.09c85e0473196p-1,   -0x1.4fb0c88d94f79p-1,    0x1.f8983p-2, INEXACT)
T(RN,    0x1.090ec3ab54c71p-1,   -0x1.5116d096b1b24p-1,  -0x1.fafe28p-2, INEXACT)
T(RN,    0x1.08b2271f1f182p-1,   -0x1.51c9d49b400f5p-1,   0x1.ff6392p-2, INEXACT)
T(RN,    0x1.089b050adac32p-1,   -0x1.51f6959c63a82p-1,  -0x1.feb19ap-2, INEXACT)
T(RN,    0x1.07cb2d397d76dp-1,   -0x1.53895ea6a4051p-1,  -0x1.f6c78ap-2, INEXACT)
T(RN,    0x1.06fbf8a9f02acp-1,   -0x1.551c27b0e44edp-1,  -0x1.fe78fep-2, INEXACT)
T(RN,    0x1.06e4fce12ae6ap-1,   -0x1.5548e8b207ea4p-1,   0x1.f782b2p-2, INEXACT)
T(RN,    0x1.05489f93fdafcp-1,   -0x1.586e7ac688946p-1,  -0x1.f7c4a2p-2, INEXACT)
T(RN,    0x1.04bfbb13d344dp-1,   -0x1.597b00cd5e1cbp-1,   0x1.fbbf84p-2, INEXACT)
T(RN,    0x1.03dc32e261b65p-1,   -0x1.5b3a8ad8c2096p-1,  -0x1.f794c6p-2, INEXACT)
T(RN,    0x1.022e05c0f7b28p-1,   -0x1.5e8cddee66449p-1,   0x1.fc68f4p-2, INEXACT)
T(RN,    0x1.011fc43dc6ffbp-1,   -0x1.60a5e9fc115dap-1,  -0x1.fd00b2p-2, INEXACT)
T(RN,    0x1.00af7c813c2dap-1,   -0x1.6185af01c3512p-1,  -0x1.f8995ep-2, INEXACT)
T(RN,    0x1.0082a0be4da65p-1,   -0x1.61df31040a891p-1,  -0x1.f62196p-2, INEXACT)
T(RN,    0x1.006c35cd834d4p-1,   -0x1.620bf2052e1e6p-1,  -0x1.f6e808p-2, INEXACT)
T(RN,    0x1.feec3d3ba469ap-2,   -0x1.63f83d11b5aaep-1,   0x1.f603eep-2, INEXACT)
T(RN,    0x1.fd2e6731d0b4fp-2,   -0x1.65b7c71d198b4p-1,   0x1.f7e4a4p-2, INEXACT)
T(RN,    0x1.fc23a1989ada7p-2,   -0x1.66c44d23ef136p-1,    0x1.f9713p-2, INEXACT)
T(RN,    0x1.fbf738ed0d514p-2,   -0x1.66f10e2512ab4p-1,    0x1.fb54dp-2, INEXACT)
T(RN,    0x1.fb1967c3fe7efp-2,   -0x1.67d0d32ac4a1fp-1,   0x1.fb5e36p-2, INEXACT)
T(RN,    0x1.fa3bf777b8433p-2,   -0x1.68b0983076938p-1,   0x1.fff424p-2, INEXACT)
T(RN,    0x1.f8ae5418f3c4fp-2,   -0x1.6a43613ab6e99p-1,  -0x1.fd0778p-2, INEXACT)
T(RN,     0x1.f69e0aa15f31p-2,   -0x1.6c5c6d4862004p-1,  -0x1.f7bac2p-2, INEXACT)
T(RN,    0x1.f6721d8043253p-2,   -0x1.6c892e4985972p-1,   -0x1.f96c7p-2, INEXACT)
T(RN,  0x1.02075a899e8cfp+998,    0x1.59e2675f4cde5p+9,   0x1.9ae16ep-2, INEXACT)
T(RN,  0x1.3f5aeaf7ecd9bp+944,    0x1.4746aa0f3a9b4p+9,   0x1.d5ecdp-12, INEXACT)
T(RN,  0x1.41e3227efaa4ep+942,    0x1.46963ac069566p+9, -0x1.48c382p-12, INEXACT)
T(RN,  0x1.44707dc0eb3cap+940,    0x1.45e5cb7198119p+9, -0x1.41eb28p-12, INEXACT)
T(RN,   0x1.56e15bcd3c0ep+926,    0x1.4112c049df2f9p+9,  0x1.778b52p-11, INEXACT)
T(RN,  0x1.61e2835a57c5bp+918,    0x1.3e51030e9a1c3p+9, -0x1.c3fb66p-13, INEXACT)
T(RN,  0x1.7023709a5d36ep+908,    0x1.3aded68483c3ep+9, -0x1.00968ep-11, INEXACT)
T(RN,  0x1.730eacef44594p+906,    0x1.3a2e6735b27f1p+9,  0x1.b055d2p-12, INEXACT)
T(RN,  0x1.7bf41e6b2f82bp+900,    0x1.381d19493eb08p+9, -0x1.dd18ccp-12, INEXACT)
T(RN,  0x1.85102a321303fp+894,    0x1.360bcb5ccae1fp+9,  0x1.3fefe6p-13, INEXACT)
T(RN,  0x1.8e641f66ae0c3p+888,    0x1.33fa7d7057136p+9,  0x1.0967d2p-12, INEXACT)
T(RN,  0x1.97f15534b74e5p+882,    0x1.31e92f83e344dp+9, -0x1.12fd42p-14, INEXACT)
T(RN,  0x1.a1b92b022e135p+876,    0x1.2fd7e1976f764p+9, -0x1.b9a5aep-14, INEXACT)
T(RN,  0x1.a5090caa467bep+874,    0x1.2f2772489e316p+9, -0x1.1909fap-11, INEXACT)
T(RN,  0x1.abbd08a1d9fddp+870,    0x1.2dc693aafba7bp+9,  0x1.b5a79cp-13, INEXACT)
T(RN,  0x1.b28c5650e3aafp+866,    0x1.2c65b50d591dfp+9, -0x1.3f233ap-12, INEXACT)
T(RN,  0x1.b5fe5e8700c07p+864,    0x1.2bb545be87d92p+9, -0x1.3b08dap-12, INEXACT)
T(RN,  0x1.cb3f61504372bp+852,     0x1.2792a9e5a03cp+9,  0x1.2cbbe2p-12, INEXACT)
T(RN,  0x1.d6421c204da8bp+846,    0x1.25815bf92c6d7p+9,   0x1.5b528p-14, INEXACT)
T(RN,  0x1.d9fca0043b227p+844,    0x1.24d0ecaa5b289p+9, -0x1.0994f6p-13, INEXACT)
T(RN,  0x1.0acc8213679cap+815,    0x1.1a7a670c181fcp+9, -0x1.ff7942p-12, INEXACT)
T(RN,  0x1.0cea0c45685b7p+813,    0x1.19c9f7bd46daep+9,  0x1.9eda3ap-12, INEXACT)
T(RN,  0x1.312270f5954c6p+781,    0x1.0ec302d0328d4p+9, -0x1.5a8ea2p-12, INEXACT)
T(RN,  0x1.3d6cb377fc421p+771,     0x1.0b50d6461c35p+9,  -0x1.18182p-12, INEXACT)
T(RN,  0x1.3ff0ffd9ca1dcp+769,    0x1.0aa066f74af02p+9,  0x1.71dc7ap-11, INEXACT)
T(RN,  0x1.427a680253805p+767,    0x1.09eff7a879ab4p+9, -0x1.5ec928p-14, INEXACT)
T(RN,  0x1.4508f65014225p+765,    0x1.093f8859a8667p+9, -0x1.64e6dep-11, INEXACT)
T(RN,  0x1.4a35af3e8f3e7p+761,    0x1.07dea9bc05dcbp+9, -0x1.5707b2p-14, INEXACT)
T(RN,  0x1.52206ab89e708p+755,    0x1.05cd5bcf920e2p+9,  0x1.76ee58p-11, INEXACT)
T(RN,  0x1.5a3bbdb2ebe8fp+749,    0x1.03bc0de31e3f9p+9, -0x1.29762cp-13, INEXACT)
T(RN,  0x1.6de9ba8a56087p+735,    0x1.fdd20576cabb3p+8,   0x1.20aeap-10, INEXACT)
T(RN,  0x1.70d0727d8c1c7p+733,    0x1.fc7126d928318p+8,  0x1.d03ef8p-12, INEXACT)
T(RN,  0x1.82b6125abd264p+721,    0x1.f42bef2758f74p+8,  0x1.d2dab4p-13, INEXACT)
T(RN,  0x1.88de29da3a9a1p+717,    0x1.f16a31ec13e3dp+8,  -0x1.1b67ap-10, INEXACT)
T(RN,  0x1.8f1f58ead0249p+713,    0x1.eea874b0ced07p+8,  0x1.19c16ep-11, INEXACT)
T(RN,  0x1.9249792e960e6p+711,    0x1.ed4796132c46bp+8,   0x1.0eee8p-12, INEXACT)
T(RN,  0x1.957a05d09236ep+709,     0x1.ebe6b77589bdp+8,  0x1.7fdb78p-13, INEXACT)
T(RN,  0x1.a5ceea755252cp+699,    0x1.e5025e615d0c7p+8,  0x1.62605ep-13, INEXACT)
T(RN,  0x1.a92716bd96bfap+697,    0x1.e3a17fc3ba82cp+8, -0x1.f35dacp-13, INEXACT)
T(RN,  0x1.afebda94fb769p+693,    0x1.e0dfc288756f5p+8,  0x1.9fd038p-13, INEXACT)
T(RN,  0x1.b3588dcedf144p+691,    0x1.df7ee3ead2e5ap+8,  0x1.149252p-12, INEXACT)
T(RN,  0x1.b6cc34883b69fp+689,    0x1.de1e054d305bfp+8,  0x1.c4475ap-12, INEXACT)
T(RN,  0x1.c4e16e46b2179p+681,    0x1.d89a8ad6a6351p+8,  0x1.df237ep-11, INEXACT)
T(RN,   0x1.de9f39bf1d57p+667,    0x1.cef4748734712p+8, -0x1.b4d134p-12, INEXACT)
T(RN,   0x1.0507c2f9cb3fp+646,    0x1.bfcae3c138866p+8,  0x1.cb6c3ap-10, INEXACT)
T(RN,  0x1.0f8b42a2e40ddp+636,    0x1.b8e68aad0bd5dp+8,  0x1.281a26p-11, INEXACT)
T(RN,  0x1.13ddf91b87405p+632,    0x1.b624cd71c6c26p+8, -0x1.7ea714p-10, INEXACT)
T(RN,   0x1.1cb88983d078p+624,    0x1.b0a152fb3c9b9p+8, -0x1.8ae7fcp-10, INEXACT)
T(RN,  0x1.1efa74586e727p+622,    0x1.af40745d9a11ep+8, -0x1.5ee0eap-10, INEXACT)
T(RN,  0x1.238c126bf3358p+618,    0x1.ac7eb72254fe7p+8,   0x1.92e96p-12, INEXACT)
T(RN,  0x1.2a898131f24dep+612,    0x1.a85c1b496d615p+8, -0x1.645608p-12, INEXACT)
T(RN,  0x1.31b1d6fe17b4ep+606,    0x1.a4397f7085c43p+8,  0x1.42d402p-12, INEXACT)
T(RN,  0x1.3e01e017c3d5dp+596,    0x1.9d55265c5913bp+8, -0x1.90df78p-10, INEXACT)
T(RN,  0x1.4836ab79a5d17p+588,    0x1.97d1abe5ceecdp+8, -0x1.296aaep-10, INEXACT)
T(RN,  0x1.556ee611fa309p+578,    0x1.90ed52d1a23c5p+8,  0x1.271188p-12, INEXACT)
T(RN,  0x1.5d9e8482a566ap+572,    0x1.8ccab6f8ba9f3p+8, -0x1.c29ce6p-12, INEXACT)
T(RN,  0x1.6bb37621ce2d2p+562,    0x1.85e65de48deeap+8,  0x1.1441bap-11, INEXACT)
T(RN,  0x1.717dc5aed943bp+558,    0x1.8324a0a948db3p+8,   0x1.0ec61p-10, INEXACT)
T(RN,  0x1.8cb5afdcd2286p+540,    0x1.76bccd1e9203dp+8,  0x1.342642p-11, INEXACT)
T(RN,  0x1.99711c98cbe57p+532,     0x1.713952a807ddp+8,   -0x1.0de7p-10, INEXACT)
T(RN,  0x1.a9eee3e1aed04p+522,    0x1.6a54f993db2c8p+8, -0x1.22c6bcp-10, INEXACT)
T(RN,  0x1.ccef6cc705159p+502,    0x1.5c8c476b81cb6p+8,  0x1.f99d06p-15, INEXACT)
T(RN,  0x1.df8027a769b3ep+492,    0x1.55a7ee57551aep+8,  0x1.7c4e06p-11, INEXACT)
T(RN,  0x1.05826eeea4a36p+471,    0x1.467e5d9159301p+8,  0x1.f9a28ep-12, INEXACT)
T(RN,  0x1.2665f1d07ec3cp+441,    0x1.31d15254d31e7p+8,  0x1.1eca14p-10, INEXACT)
T(RN,  0x1.2b15cd8262eccp+437,    0x1.2f0f95198e0b1p+8, -0x1.b48fa8p-11, INEXACT)
T(RN,  0x1.2d74e0561fb36p+435,    0x1.2daeb67beb815p+8, -0x1.43a82ep-11, INEXACT)
T(RN,  0x1.2fd8c361ce995p+433,    0x1.2c4dd7de48f7ap+8,  0x1.a87602p-11, INEXACT)
T(RN,  0x1.3241806a8dbc8p+431,    0x1.2aecf940a66dfp+8,   0x1.035e1p-15, INEXACT)
T(RN,   0x1.3c15be8febfap+423,    0x1.25697eca1c471p+8, -0x1.38b83ep-11, INEXACT)
T(RN,  0x1.463abe865a311p+415,    0x1.1fe6045392204p+8,  0x1.8b5f02p-10, INEXACT)
T(RN,  0x1.5b81773e4135ep+399,    0x1.14df0f667dd29p+8, -0x1.663cb2p-10, INEXACT)
T(RN,  0x1.6109c540194bfp+395,    0x1.121d522b38bf3p+8,  -0x1.0d395p-10, INEXACT)
T(RN,  0x1.63d65b2b67fd6p+393,    0x1.10bc738d96357p+8, -0x1.2d221cp-10, INEXACT)
T(RN,  0x1.8d701f183a268p+365,    0x1.fae08ddd655b2p+7, -0x1.853bccp-10, INEXACT)
T(RN,   0x1.93c3ee799fddp+361,    0x1.f55d1366db344p+7, -0x1.43d138p-12, INEXACT)
T(RN,  0x1.a0b95393e2eefp+353,    0x1.ea561e79c6e6ap+7, -0x1.482778p-11, INEXACT)
T(RN,  0x1.aab70eeb6a1e2p+347,    0x1.e210e6c7f7ac6p+7,  0x1.9b2e88p-10, INEXACT)
T(RN,  0x1.ae1930e137e5bp+345,    0x1.df4f298cb298fp+7, -0x1.ce9a8cp-10, INEXACT)
T(RN,  0x1.c2f81f6ab1f6cp+333,    0x1.cec4ba2914247p+7, -0x1.ed5e66p-10, INEXACT)
T(RN,  0x1.cdc80ad60c914p+327,    0x1.c67f827744ea3p+7, -0x1.1c11a6p-10, INEXACT)
T(RN,  0x1.fbaf71a535a34p+303,    0x1.a56aa3b008014p+7,  0x1.e6d196p-15, INEXACT)
T(RN,  0x1.ffb5ed6c1c5d9p+301,    0x1.a2a8e674c2eddp+7,  0x1.a0e816p-10, INEXACT)
T(RN,  0x1.01e24a6bc1c59p+300,    0x1.9fe729397dda6p+7, -0x1.2f445cp-10, INEXACT)
T(RN,  0x1.3540325c135c3p+254,    0x1.607f28e6491bdp+7,  0x1.a4b6fcp-11, INEXACT)
T(RN,  0x1.3caa4a0360074p+248,    0x1.5839f13479e1ap+7, -0x1.8f68f4p-10, INEXACT)
T(RN,  0x1.4441e39cd8431p+242,    0x1.4ff4b982aaa76p+7,  -0x1.8314ep-13, INEXACT)
T(RN,   0x1.4eaa08f0d9aap+234,    0x1.44edc4959659bp+7,   0x1.746594p-9, INEXACT)
T(RN,  0x1.5151535e0b73ap+232,    0x1.422c075a51464p+7, -0x1.62a7d4p-10, INEXACT)
T(RN,  0x1.6a2a819222826p+214,    0x1.295c6044e3979p+7,  0x1.7c1adep-11, INEXACT)
T(RN,  0x1.72d96094b73e9p+208,    0x1.21172893145d5p+7,  0x1.aeef5ap-10, INEXACT)
T(RN,  0x1.81c9395a9e81fp+198,    0x1.134e766abafc3p+7,  0x1.151c7ep-10, INEXACT)
T(RN,  0x1.84d847bd72bf3p+196,    0x1.108cb92f75e8dp+7,  0x1.5e5da6p-12, INEXACT)
T(RN,  0x1.9481ae8e27dc4p+186,    0x1.02c407071c87bp+7, -0x1.863d2cp-10, INEXACT)
T(RN,  0x1.9e346d501554dp+180,    0x1.f4fd9eaa9a9afp+6,   0x1.09168p-10, INEXACT)
T(RN,  0x1.c3cc0e7c6f2efp+158,    0x1.b8575b92aaefdp+6,  0x1.b83b98p-12, INEXACT)
T(RN,  0x1.cafd6a113f836p+154,    0x1.ad5066a596a22p+6,   0x1.1b1ca8p-8, INEXACT)
T(RN,  0x1.e14340c7df764p+142,    0x1.8c3b87de59b92p+6,   0x1.5c5dd2p-9, INEXACT)
T(RN,  0x1.e5141ad18e187p+140,    0x1.86b80d67cf925p+6,  -0x1.9f8eeap-9, INEXACT)
T(RN,  0x1.e8ecb3a38d49ap+138,    0x1.813492f1456b8p+6,   0x1.294298p-9, INEXACT)
T(RN,   0x1.025b7bd84164p+125,    0x1.5a9c39b37e5bbp+6,  -0x1.eaa3a6p-8, INEXACT)
T(RN,  0x1.133503842be5ep+109,     0x1.2e8065ff2d25p+6, -0x1.491a36p-11, INEXACT)
T(RN,  0x1.1796a7ec6793bp+105,    0x1.2379711218d76p+6,   0x1.781e3cp-8, INEXACT)
T(RN,   0x1.30f69cb05b278p+83,    0x1.cda65bf452587p+5,   0x1.854886p-7, INEXACT)
T(RN,   0x1.35d1879b7a932p+79,    0x1.b798721a29bd2p+5,   0x1.f1ebc8p-9, INEXACT)
T(RN,   0x1.4a0640ebcb737p+63,    0x1.5f60cab1874fdp+5,   -0x1.27672p-7, INEXACT)
T(RN,    0x1.4ca4206d4a8dp+61,    0x1.5459d5c473022p+5,  -0x1.822b44p-7, INEXACT)
T(RN,   0x1.6db52b59f6f48p+37,    0x1.a00cb54efebc6p+4,  -0x1.20f028p-8, INEXACT)
T(RN,   0x1.858f04c4872d5p+21,    0x1.df3accfb73c3ap+3,  -0x1.87934ap-7, INEXACT)
T(RN,   0x1.88a5bb7e29387p+19,     0x1.b31ef947228dp+3,  -0x1.fd1ec8p-6, INEXACT)
T(RN,    0x1.8bc2b72efe09p+17,    0x1.87032592d1565p+3,  0x1.7abd3ap-10, INEXACT)
T(RN,   0x1.920fb076e974ap+13,     0x1.2ecb7e2a2ee9p+3,   0x1.51d71ep-8, INEXACT)
T(RN,    0x1.987657a123465p+9,    0x1.ad27ad8318f77p+2,     0x1.392ap-4, INEXACT)
T(RN,   0x1.cbd51e15c5504p-21,    -0x1.bf0d90cf35b8p+3,  -0x1.bda474p-8, INEXACT)
T(RN,   0x1.cf7a788a2d166p-23,   -0x1.eb29648386eeap+3,  -0x1.5d2292p-7, INEXACT)
T(RN,   0x1.09098897b6434p-56,   -0x1.36409cdf3ae3fp+5,   0x1.23b2e2p-8, INEXACT)
T(RN,   0x1.0b237f6a08454p-58,   -0x1.414791cc4f319p+5,  -0x1.360c36p-8, INEXACT)
T(RN,   0x1.0d41ba2da102ap-60,   -0x1.4c4e86b9637f4p+5,   -0x1.bad27p-8, INEXACT)
T(RN,   0x1.15e5fad904351p-68,   -0x1.786a5a6db4b5ep+5,   -0x1.99f67p-8, INEXACT)
T(RN,   0x1.2805c41b783a5p-84,   -0x1.d0a201d657233p+5,   0x1.2e30bcp-8, INEXACT)
T(RN,   0x1.2f1eaad26c1abp-90,   -0x1.f1b6e09d940c3p+5,  -0x1.07072ep-8, INEXACT)
T(RN,   0x1.3185ee1fe0b58p-92,   -0x1.fcbdd58aa859dp+5,   0x1.cc0aa6p-9, INEXACT)
T(RN,  0x1.6e6108cd37217p-138,   -0x1.7d2eeb6bbdaa1p+6,   0x1.4bc6aap-8, INEXACT)
T(RN,  0x1.7436427e7bcd4p-142,   -0x1.8835e058d1f7bp+6,  -0x1.4cb22cp-9, INEXACT)
T(RN,  0x1.8334289d4c1acp-152,   -0x1.a3c744a984b9ep+6,  0x1.5bde0ep-10, INEXACT)
T(RN,  0x1.8c7cb43b118f2p-158,   -0x1.b451b40d232e5p+6,   0x1.1a526ap-8, INEXACT)
T(RN,  0x1.8fa17b2040a1dp-160,   -0x1.b9d52e83ad553p+6,  -0x1.15a072p-8, INEXACT)
T(RN,  0x1.9fba18d759649p-170,   -0x1.d56692d460175p+6,  -0x1.67d918p-9, INEXACT)
T(RN,   0x1.bad7111b9365p-186,    -0x1.00c1334458a7p+7, -0x1.22bc52p-12, INEXACT)
T(RN,  0x1.d054488f0b287p-198,   -0x1.114ba2a7f71b8p+7, -0x1.9cb6d8p-10, INEXACT)
T(RN,  0x1.d402c39d05a4cp-200,   -0x1.140d5fe33c2eep+7,  0x1.3d8672p-11, INEXACT)
T(RN,  0x1.fa7880f14750cp-220,   -0x1.2f9ec433eef11p+7, -0x1.e80048p-10, INEXACT)
T(RN,  0x1.1437eb5baee27p-241,   -0x1.4df1e5bfe6c6ap+7, -0x1.534a92p-12, INEXACT)
T(RN,   0x1.263ba855c174p-257,   -0x1.63ffcf9a0f61fp+7,   -0x1.01ef1p-9, INEXACT)
T(RN,  0x1.2890e1e532bcfp-259,   -0x1.66c18cd554756p+7,  0x1.f9f7ecp-10, INEXACT)
T(RN,  0x1.437b4ad68e7d3p-281,   -0x1.8514ae614c4afp+7,   0x1.52d5dcp-9, INEXACT)
T(RN,  0x1.4ddd10775c335p-289,   -0x1.901ba34e6098ap+7,  0x1.879b2ep-12, INEXACT)
T(RN,  0x1.589422bc5b104p-297,   -0x1.9b22983b74e64p+7,  -0x1.a140cp-11, INEXACT)
T(RN,  0x1.5b4f8ceb1a2a3p-299,   -0x1.9de45576b9f9bp+7,  0x1.cf5258p-11, INEXACT)
T(RN,   0x1.60d70f7d394dp-303,   -0x1.a367cfed44208p+7,  0x1.7efbf6p-10, INEXACT)
T(RN,  0x1.71f63e9ea3023p-315,    -0x1.b3f23f50e295p+7,  0x1.e2ca96p-10, INEXACT)
T(RN,  0x1.7ad4f6e63896cp-321,   -0x1.bc377702b1cf4p+7,    0x1.8522p-10, INEXACT)
T(RN,   0x1.80dcf16a2e15p-325,   -0x1.c1baf1793bf61p+7,   0x1.71fd5p-10, INEXACT)
T(RN,  0x1.a3cad8da3052ap-347,   -0x1.e00e130533cbap+7,  0x1.5bf338p-10, INEXACT)
T(RN,  0x1.addb697e7af6ep-353,   -0x1.e8534ab70305ep+7, -0x1.197916p-10, INEXACT)
T(RN,  0x1.c9e44c63c90ddp-369,   -0x1.fe6134912ba13p+7,  0x1.09ad64p-10, INEXACT)
T(RN,  0x1.e01c7eeb06d15p-381,   -0x1.0775d1fa650aep+8,  0x1.0c28b4p-11, INEXACT)
T(RN,  0x1.e3eb02aabe493p-383,   -0x1.08d6b09807949p+8,  0x1.c274f6p-11, INEXACT)
T(RN,  0x1.ef85290120d3ep-389,   -0x1.0cf94c70ef31bp+8, -0x1.25c32ap-11, INEXACT)
T(RN,  0x1.ff6c6d0707864p-397,   -0x1.127cc6e779588p+8, -0x1.952afap-11, INEXACT)
T(RN,  0x1.0e3f08f68a4fep-410,   -0x1.1c22dd36eb1c8p+8,   0x1.8e6f7p-10, INEXACT)
T(RN,  0x1.24745181b300bp-430,   -0x1.29eb8f5f447d9p+8,   -0x1.afd9p-10, INEXACT)
T(RN,  0x1.2b7751bdee58ap-436,   -0x1.2e0e2b382c1abp+8, -0x1.5c57b8p-10, INEXACT)
T(RN,  0x1.32a55b2d63513p-442,   -0x1.3230c71113b7dp+8, -0x1.4ff47cp-10, INEXACT)
T(RN,  0x1.4186b08cd894cp-454,   -0x1.3a75fec2e2f21p+8,  0x1.7dcb14p-11, INEXACT)
T(RN,  0x1.4e79f6d1a1e3ep-464,   -0x1.415a57d70fa29p+8, -0x1.0b1592p-14, INEXACT)
T(RN,  0x1.5936123339c12p-472,   -0x1.46ddd24d99c97p+8, -0x1.1bdffep-10, INEXACT)
T(RN,  0x1.6fb9b627bc43dp-488,   -0x1.51e4c73aae171p+8,  0x1.4be4c8p-10, INEXACT)
T(RN,  0x1.788ab4642e4d5p-494,   -0x1.5607631395b43p+8,  0x1.b46aaap-12, INEXACT)
T(RN,  0x1.8191cf6725ee3p-500,   -0x1.5a29feec7d515p+8,  0x1.7e0b32p-11, INEXACT)
T(RN,  0x1.84a06d4fc9256p-502,    -0x1.5b8add8a1fdbp+8,  0x1.c3d50cp-11, INEXACT)
T(RN,  0x1.8ad05350fe988p-506,   -0x1.5e4c9ac564ee7p+8,   0x1.47abap-12, INEXACT)
T(RN,  0x1.8df1b4b3d44e9p-508,   -0x1.5fad796307782p+8, -0x1.7cb3a4p-11, INEXACT)
T(RN,  0x1.a7e5c6533dbe3p-524,   -0x1.6ab46e501bc5dp+8,  0x1.f20318p-11, INEXACT)
T(RN,  0x1.ab42303f360a6p-526,   -0x1.6c154cedbe4f8p+8, -0x1.16934cp-13, INEXACT)
T(RN,  0x1.b8f89b5c0a5acp-534,   -0x1.7198c76448766p+8,  0x1.990664p-14, INEXACT)
T(RN,  0x1.d5bb0d93f609cp-550,    -0x1.7c9fbc515cc4p+8,  0x1.cc53bcp-14, INEXACT)
T(RN,  0x1.ec8651e5e969bp-562,   -0x1.84e4f4032bfe4p+8, -0x1.dc5664p-11, INEXACT)
T(RN,  0x1.f06e07e4a77a7p-564,    -0x1.8645d2a0ce88p+8,  -0x1.872f5p-12, INEXACT)
T(RN,  0x1.f45dab11d406fp-566,   -0x1.87a6b13e7111bp+8,  0x1.6d58a2p-11, INEXACT)
T(RN,  0x1.0c9cd107e5084p-583,   -0x1.940e84c927e91p+8, -0x1.b92d18p-11, INEXACT)
T(RN,  0x1.130d7bb985ffdp-589,   -0x1.983120a20f863p+8, -0x1.47bc98p-10, INEXACT)
T(RN,  0x1.2c040dd14d54cp-611,   -0x1.a75ab1680b70fp+8,  0x1.6026a2p-14, INEXACT)
T(RN,  0x1.2e65043d4899dp-613,   -0x1.a8bb9005adfabp+8,  0x1.2c746cp-10, INEXACT)
T(RN,  0x1.35a50719e867bp-619,   -0x1.acde2bde9597dp+8, -0x1.300be2p-10, INEXACT)
T(RN,   0x1.3a9306518055p-623,   -0x1.af9fe919daab3p+8,  -0x1.11e91p-10, INEXACT)
T(RN,  0x1.3d1189a066a7dp-625,   -0x1.b100c7b77d34fp+8,  0x1.849b74p-10, INEXACT)
T(RN,  0x1.3f951cf7cc09ep-627,   -0x1.b261a6551fbeap+8,  0x1.3f81f8p-10, INEXACT)
T(RN,  0x1.421dca9e5600fp-629,   -0x1.b3c284f2c2485p+8,   0x1.fe516p-11, INEXACT)
T(RN,  0x1.51bf4ed0d4201p-641,   -0x1.bc07bca491829p+8,  0x1.418f5ep-12, INEXACT)
T(RN,  0x1.59d84dc42bf62p-647,   -0x1.c02a587d791fbp+8,  0x1.23a306p-10, INEXACT)
T(RN,  0x1.7066865afd14ep-663,   -0x1.cb314d6a8d6d6p+8,  0x1.11f4aap-11, INEXACT)
T(RN,  0x1.7643fd25bb787p-667,   -0x1.cdf30aa5d280cp+8,  0x1.041112p-11, INEXACT)
T(RN,  0x1.8b89de73acd7dp-681,   -0x1.d79920f54444cp+8, -0x1.fc13bap-11, INEXACT)
T(RN,  0x1.9ebb7a6c98feep-693,    -0x1.dfde58a7137fp+8,  0x1.10a2c6p-10, INEXACT)
T(RN,  0x1.b9c7d79452b97p-709,   -0x1.eae54d9427ccap+8, -0x1.cfcd94p-11, INEXACT)
T(RN,  0x1.c0d0605f1f139p-713,   -0x1.eda70acf6ce01p+8,  0x1.749624p-12, INEXACT)
T(RN,  0x1.c45f5d603c97bp-715,   -0x1.ef07e96d0f69cp+8, -0x1.04274ap-10, INEXACT)
T(RN,  0x1.cb931154adf07p-719,   -0x1.f1c9a6a8547d3p+8,  0x1.3940cep-13, INEXACT)
T(RN,  0x1.d2e41f8954532p-723,   -0x1.f48b63e399909p+8,  0x1.02e35ep-10, INEXACT)
T(RN,  0x1.e1e02b2009695p-731,   -0x1.fa0ede5a23b77p+8,  0x1.ccffd2p-14, INEXACT)
T(RN,  0x1.e5b243aa344afp-733,   -0x1.fb6fbcf7c6412p+8,  -0x1.bbcaap-12, INEXACT)
T(RN,  0x1.f15754385035fp-739,   -0x1.ff9258d0adde4p+8, -0x1.2d339ap-12, INEXACT)
T(RN,  0x1.0d1b0d3096a4ap-758,   -0x1.06ad857c839fbp+9,  0x1.299b3ap-13, INEXACT)
T(RN,  0x1.17f1d0cbb4636p-768,   -0x1.0a1fb20699f7fp+9,  0x1.7b50b8p-11, INEXACT)
T(RN,  0x1.20ede190b298fp-776,   -0x1.0ce16f41df0b6p+9, -0x1.37cddep-13, INEXACT)
T(RN,  0x1.2338572778639p-778,   -0x1.0d91de90b0503p+9, -0x1.d8ac7cp-17, INEXACT)
T(RN,  0x1.2ef320a301235p-788,   -0x1.11040b1ac6a88p+9,  0x1.b0cbe2p-15, INEXACT)
T(RN,  0x1.3b26dc0798fe5p-798,   -0x1.147637a4dd00cp+9,   0x1.8f194p-12, INEXACT)
T(RN,  0x1.4d109587806e9p-812,   -0x1.194942cc95e2cp+9, -0x1.d56444p-15, INEXACT)
T(RN,  0x1.5a7ad592f527ep-822,    -0x1.1cbb6f56ac3bp+9, -0x1.990568p-15, INEXACT)
T(RN,  0x1.6599901a7d84bp-830,   -0x1.1f7d2c91f14e6p+9, -0x1.2a7414p-16, INEXACT)
T(RN,  0x1.686f685ed579cp-832,   -0x1.202d9be0c2934p+9,  0x1.f12fb8p-14, INEXACT)
T(RN,  0x1.7113a7c502944p-838,   -0x1.223ee9cd3661dp+9, -0x1.14d286p-12, INEXACT)
T(RN,  0x1.76f3e02d6ee14p-842,   -0x1.239fc86ad8eb8p+9,  0x1.435ba6p-12, INEXACT)
T(RN,  0x1.79ecf14f35678p-844,   -0x1.245037b9aa306p+9, -0x1.4c3f0cp-12, INEXACT)
T(RN,  0x1.8925c13cbbd72p-854,   -0x1.27c26443c088ap+9,  -0x1.755b6p-12, INEXACT)
T(RN,  0x1.9f7e61ea9a6c7p-868,   -0x1.2c956f6b796aap+9,  0x1.04963cp-13, INEXACT)
T(RN,   0x1.cc6b0bada78bp-894,   -0x1.358b166c19e9cp+9, -0x1.042a4cp-13, INEXACT)
T(RN,  0x1.d0119673cbb04p-896,   -0x1.363b85baeb2e9p+9, -0x1.0d6e5ep-11, INEXACT)
T(RN,  0x1.def671959794cp-904,    -0x1.38fd42f63042p+9,  0x1.71ea42p-16, INEXACT)
T(RN,  0x1.ee55abb22a532p-912,   -0x1.3bbf003175557p+9,  0x1.48d69ap-15, INEXACT)
T(RN,  0x1.f63465505280ep-916,   -0x1.3d1fdecf17df2p+9,  0x1.6fc8ccp-12, INEXACT)
T(RN,  0x1.fa2fc13a6dfcbp-918,    -0x1.3dd04e1de924p+9,   0x1.566f1p-12, INEXACT)
T(RN,  0x1.095ff2e41b54bp-929,   -0x1.41f2e9f6d0c12p+9,  0x1.ab88bep-17, INEXACT)
T(RN,  0x1.2d1e4c81849bbp-961,   -0x1.4cf9dee3e50ecp+9,  0x1.a6079cp-12, INEXACT)
T(RN,  0x1.34567a117b004p-967,   -0x1.4f0b2cd058dd5p+9,  0x1.2a2212p-11, INEXACT)
T(RN,  0x1.52fd0c9b83e7ep-991,   -0x1.5750648228179p+9,  0x1.f9751cp-12, INEXACT)
