---
title: "v3.0.0"
linkTitle: "v3.0.0"
date: 2019-07-03
description: >
  Kustomize v3.0.0
---

This release is basically [v2.1.0](v2.1.0.md),
with many post-v2.1.0 bugs fixed (in about 150
commits) and a `v3` in Go package paths.

[plugin]: /docs/plugins

The major version increment to `v3` puts a new
floor on a stable API for [plugin] developers
(both _Go_ plugin developers and _exec_ plugin
developers who happen to use Go).

### Why so soon after v2.1.0

[semantic versioning]: https://semver.org
[Go modules doc]: https://github.com/golang/go/wiki/Modules#releasing-modules-v2-or-higher
[versioning policy]: /kustomize/faq/versioningpolicy

We made a mistake - v2.1.0 should have been
v3.0.0.  Per the [Go modules doc] (which have
improved a great deal recently), a release that's
already tagged v2 or higher should increment the
major version when performing their first Go
module-based release.

This advice applies to kustomize, since it was
already at major version 2 when it began using Go
modules to state _its own_ dependencies in v2.1.0.

But the more important reason for `v3` is a change
to the kustomize [versioning policy], forced by
the introduction of plugins.

Historically, kustomize's [versioning policy]
didn't involve Go modules and addressed _only_ the
command line tool's behavior and the fields in a
kustomization file.  The underlying packages were
an implementation detail, not under semantic
versioning, because they weren't intended for
export (and should have all been under
`internal`).  Thus although the v2.1.0 CLI is
backward compatible with v2.0.3, the underlying
package APIs are not.

[minimal version selection]: https://research.swtch.com/vgo-mvs

With Go modules, the `go` tool must assume that Go
packages respect [semantic versioning], so it can
perform [minimal version selection].

With the introduction of alpha plugins, kustomize
sub-packages - in particular `loader` and
`resmap` - become part of an API formally exposed
to plugin authors, and so must be semantically
versioned.  This allows plugins defined in other
repositories to clarify that they depend on
kustomize v3.0.0, and not see confusing errors
arising from incompatibilities between v2.1.0 and
v2.0.3.  Hence, the jump to v3.

Aside - the set of kustomize packages outside
`internal` is too large, and over time, informed
by package use, this API surface must shrink.
Such shrinkage will trigger a major version
increment.
