# Changelog

## [v1.21.0](https://github.com/kubernetes/kompose/tree/v1.21.0) (2020-02-25)

[Full Changelog](https://github.com/kubernetes/kompose/compare/v1.20.0...v1.21.0)

**Closed issues:**

- Configs support [\#1229](https://github.com/kubernetes/kompose/issues/1229)
- start\_period causes FATA start\_period Additional property start\_period is not allowed [\#1224](https://github.com/kubernetes/kompose/issues/1224)
- doesn't work out of box with the tutorial on the website [\#1202](https://github.com/kubernetes/kompose/issues/1202)
- Helm lint throws errors on chart.yaml [\#1200](https://github.com/kubernetes/kompose/issues/1200)
- The same env\_file creates multiple ConfigMaps [\#1199](https://github.com/kubernetes/kompose/issues/1199)
- charts reporting errors generated by helm3 version installation [\#1194](https://github.com/kubernetes/kompose/issues/1194)
- How kompose.service.type: nodeport customizes the port of nodePort to 30000 [\#1191](https://github.com/kubernetes/kompose/issues/1191)
- Follow docker compose conventions for service fields merge [\#1186](https://github.com/kubernetes/kompose/issues/1186)
- Feature Request: Allow Different Tab Length Specification For `kompose convert` [\#1181](https://github.com/kubernetes/kompose/issues/1181)
- `kompose up` Does Not Work and Incorrect Deployment Created Via `kompose convert` [\#1180](https://github.com/kubernetes/kompose/issues/1180)
- Add "store-created-files" option for "kompose up". [\#1179](https://github.com/kubernetes/kompose/issues/1179)
- FATA Unable to load yaml/json file for version parsing: open docker-compose.yml: permission denied [\#1172](https://github.com/kubernetes/kompose/issues/1172)
- Just delete Windows from your installation guide... [\#1167](https://github.com/kubernetes/kompose/issues/1167)
- fabric8:deploy - unable to access cluster [\#1162](https://github.com/kubernetes/kompose/issues/1162)
- kompose env\_file superseding environment variables [\#1156](https://github.com/kubernetes/kompose/issues/1156)
- Kompose doesn't work with docker-compose v3.7 [\#1152](https://github.com/kubernetes/kompose/issues/1152)
- Error when targeting a different \(than 8080\) API port [\#1131](https://github.com/kubernetes/kompose/issues/1131)
- kompose up not working on windows? [\#1122](https://github.com/kubernetes/kompose/issues/1122)
- kompose fails to convert cpu resources from a second \(override\) docker-compose yaml file [\#1106](https://github.com/kubernetes/kompose/issues/1106)
- error decoding 'Ports': No port specified: ::\<empty\> [\#1104](https://github.com/kubernetes/kompose/issues/1104)
- 'expose' is not converted [\#1095](https://github.com/kubernetes/kompose/issues/1095)
- Volumes path with underline was converted into dash [\#1094](https://github.com/kubernetes/kompose/issues/1094)
- HostPath volumes incorrectly concatenate paths [\#1089](https://github.com/kubernetes/kompose/issues/1089)
- Environment variables of multiple docker-compose are not merged [\#1081](https://github.com/kubernetes/kompose/issues/1081)
- Duplicate container ports if different host ports point to same container port [\#1070](https://github.com/kubernetes/kompose/issues/1070)
- Convert mounted directories into configmaps [\#1060](https://github.com/kubernetes/kompose/issues/1060)
- Cannot kompose up [\#969](https://github.com/kubernetes/kompose/issues/969)
- Kompose doesn't find dockerfile with context . [\#944](https://github.com/kubernetes/kompose/issues/944)
- Local volumes \(from host\) via conversion [\#855](https://github.com/kubernetes/kompose/issues/855)
- Update development.md with relevant details regarding CI [\#748](https://github.com/kubernetes/kompose/issues/748)
- kompose logo [\#274](https://github.com/kubernetes/kompose/issues/274)

**Merged pull requests:**

- Support ingress path for kubernetes [\#1245](https://github.com/kubernetes/kompose/pull/1245) ([hangyan](https://github.com/hangyan))
- Support v2 restart unless-stopped [\#1244](https://github.com/kubernetes/kompose/pull/1244) ([hangyan](https://github.com/hangyan))
- Add flag to allow use define api server url [\#1243](https://github.com/kubernetes/kompose/pull/1243) ([hangyan](https://github.com/hangyan))
- Add MacPorts support to the documentation [\#1242](https://github.com/kubernetes/kompose/pull/1242) ([emcrisostomo](https://github.com/emcrisostomo))
- Fix some ci lint [\#1233](https://github.com/kubernetes/kompose/pull/1233) ([hangyan](https://github.com/hangyan))
- Deploy config [\#1232](https://github.com/kubernetes/kompose/pull/1232) ([hangyan](https://github.com/hangyan))
- Support deploy labels [\#1231](https://github.com/kubernetes/kompose/pull/1231) ([hangyan](https://github.com/hangyan))
- Support config short syntax and fix old bugs [\#1230](https://github.com/kubernetes/kompose/pull/1230) ([hangyan](https://github.com/hangyan))
- Refactor code [\#1228](https://github.com/kubernetes/kompose/pull/1228) ([hangyan](https://github.com/hangyan))
- Support port expose [\#1227](https://github.com/kubernetes/kompose/pull/1227) ([hangyan](https://github.com/hangyan))
- concat and merge service fields when merging compose files \(\#1186\) [\#1226](https://github.com/kubernetes/kompose/pull/1226) ([ChanderG](https://github.com/ChanderG))
- Update doc about push image [\#1225](https://github.com/kubernetes/kompose/pull/1225) ([hangyan](https://github.com/hangyan))
- Fix port duplicate in container spec [\#1223](https://github.com/kubernetes/kompose/pull/1223) ([hangyan](https://github.com/hangyan))
- Fix v3 hostpath path error [\#1222](https://github.com/kubernetes/kompose/pull/1222) ([hangyan](https://github.com/hangyan))
- Fix hostpath path translate error [\#1221](https://github.com/kubernetes/kompose/pull/1221) ([hangyan](https://github.com/hangyan))
- Add note adout windows [\#1220](https://github.com/kubernetes/kompose/pull/1220) ([hangyan](https://github.com/hangyan))
- Yaml indent [\#1219](https://github.com/kubernetes/kompose/pull/1219) ([hangyan](https://github.com/hangyan))
- Update dep [\#1218](https://github.com/kubernetes/kompose/pull/1218) ([hangyan](https://github.com/hangyan))
- Support use configmap as volume [\#1216](https://github.com/kubernetes/kompose/pull/1216) ([hangyan](https://github.com/hangyan))
- Fix configmap name case error [\#1215](https://github.com/kubernetes/kompose/pull/1215) ([hangyan](https://github.com/hangyan))
- Merge will include deploy resources [\#1214](https://github.com/kubernetes/kompose/pull/1214) ([hangyan](https://github.com/hangyan))
- Use service name when image name is empty when build [\#1213](https://github.com/kubernetes/kompose/pull/1213) ([hangyan](https://github.com/hangyan))
- Fix build [\#1212](https://github.com/kubernetes/kompose/pull/1212) ([hangyan](https://github.com/hangyan))
- Support assign nodeport port in labels [\#1210](https://github.com/kubernetes/kompose/pull/1210) ([hangyan](https://github.com/hangyan))
- Use new go version for build [\#1209](https://github.com/kubernetes/kompose/pull/1209) ([hangyan](https://github.com/hangyan))
- Add flag to support store manifest when kompose up [\#1208](https://github.com/kubernetes/kompose/pull/1208) ([hangyan](https://github.com/hangyan))
- Api version [\#1207](https://github.com/kubernetes/kompose/pull/1207) ([hangyan](https://github.com/hangyan))
- Remove duplicate of configmap [\#1206](https://github.com/kubernetes/kompose/pull/1206) ([hangyan](https://github.com/hangyan))
- Modify default kubernetes client's apiserver url [\#1204](https://github.com/kubernetes/kompose/pull/1204) ([hangyan](https://github.com/hangyan))
- fix golint error about comment on exported variable [\#1178](https://github.com/kubernetes/kompose/pull/1178) ([sivanzcw](https://github.com/sivanzcw))

## [v1.20.0](https://github.com/kubernetes/kompose/tree/v1.20.0) (2019-12-23)

[Full Changelog](https://github.com/kubernetes/kompose/compare/v1.19.0...v1.20.0)

**Closed issues:**

- Int Test Case correction for Network Translation Feature [\#1196](https://github.com/kubernetes/kompose/issues/1196)
- Proposal: Achieve Docker-Compose Network  functionality using NetworkPolicy in Kubernates [\#1188](https://github.com/kubernetes/kompose/issues/1188)
- Follow docker compose conventions for merging top level keys [\#1185](https://github.com/kubernetes/kompose/issues/1185)
- Convert Helm to Docker-compose [\#1183](https://github.com/kubernetes/kompose/issues/1183)
- Latest binary still not statically linked [\#1182](https://github.com/kubernetes/kompose/issues/1182)
- Clean up outside collaborators [\#1176](https://github.com/kubernetes/kompose/issues/1176)
- Provide checksum file for releases [\#1173](https://github.com/kubernetes/kompose/issues/1173)
- Could you please consider to provide the line number in the `WARN`? [\#1160](https://github.com/kubernetes/kompose/issues/1160)
- bug: docker configs object filepath error [\#1157](https://github.com/kubernetes/kompose/issues/1157)
- Support yaml anchors [\#1155](https://github.com/kubernetes/kompose/issues/1155)
- question: how does converting service discovery by hostname with docker-compose work? [\#1154](https://github.com/kubernetes/kompose/issues/1154)
- Label `kompose.service.type: loadbalancer` does not convert to type LoadBalancer [\#1150](https://github.com/kubernetes/kompose/issues/1150)
- Travis ci seems broken [\#1148](https://github.com/kubernetes/kompose/issues/1148)
- Unknown flag: from [\#1140](https://github.com/kubernetes/kompose/issues/1140)
- Support for ipv6 ports annotations [\#1136](https://github.com/kubernetes/kompose/issues/1136)
- add support for Alias [\#1134](https://github.com/kubernetes/kompose/issues/1134)
- Support for negated placement constraint docker-compose v3 [\#1132](https://github.com/kubernetes/kompose/issues/1132)
- panic: interface conversion: interface {} is nil, not map\[string\]interface {} [\#1129](https://github.com/kubernetes/kompose/issues/1129)
- Change Chart.yaml attribute version when converted to helm [\#1127](https://github.com/kubernetes/kompose/issues/1127)
- Add Support for docker-compose 3.4 [\#1125](https://github.com/kubernetes/kompose/issues/1125)
- Support kompose up build with no push [\#1105](https://github.com/kubernetes/kompose/issues/1105)
- Proposal: Use the docker-compose network as kubernetes namespace [\#1066](https://github.com/kubernetes/kompose/issues/1066)
- Support for secrets [\#296](https://github.com/kubernetes/kompose/issues/296)

**Merged pull requests:**

- Fix chart lint [\#1205](https://github.com/kubernetes/kompose/pull/1205) ([hangyan](https://github.com/hangyan))
- 1.20.0 Release [\#1203](https://github.com/kubernetes/kompose/pull/1203) ([cdrage](https://github.com/cdrage))
- fix tests related to secrets [\#1198](https://github.com/kubernetes/kompose/pull/1198) ([ChanderG](https://github.com/ChanderG))
- network int test fix [\#1197](https://github.com/kubernetes/kompose/pull/1197) ([mudverma](https://github.com/mudverma))
- Network Key Translation Feature and test cases [\#1195](https://github.com/kubernetes/kompose/pull/1195) ([mudverma](https://github.com/mudverma))
- Statically build binaries via make cross [\#1193](https://github.com/kubernetes/kompose/pull/1193) ([deviantony](https://github.com/deviantony))
- Merge top level non-service keys [\#1187](https://github.com/kubernetes/kompose/pull/1187) ([ChanderG](https://github.com/ChanderG))
- Update OWNERS [\#1177](https://github.com/kubernetes/kompose/pull/1177) ([cdrage](https://github.com/cdrage))
- Fix tests [\#1175](https://github.com/kubernetes/kompose/pull/1175) ([cdrage](https://github.com/cdrage))
- Copy the service labels also to Deployment Pod spec annotations [\#1166](https://github.com/kubernetes/kompose/pull/1166) ([alanjds](https://github.com/alanjds))
- Add support for file based secret [\#1159](https://github.com/kubernetes/kompose/pull/1159) ([jvitor83](https://github.com/jvitor83))
- Add node about endpoint\_mode in doc [\#1151](https://github.com/kubernetes/kompose/pull/1151) ([hangyan](https://github.com/hangyan))
- Add flag to turn off push image when kompose up [\#1147](https://github.com/kubernetes/kompose/pull/1147) ([hangyan](https://github.com/hangyan))

## [v1.19.0](https://github.com/kubernetes/kompose/tree/v1.19.0) (2019-10-16)

[Full Changelog](https://github.com/kubernetes/kompose/compare/v1.18.0...v1.19.0)

**Closed issues:**

- CLI usage message does not mention ability to set --out directory [\#1170](https://github.com/kubernetes/kompose/issues/1170)
- Dynamically linked release binaries [\#1168](https://github.com/kubernetes/kompose/issues/1168)
- Kompose not replacing environment variables from .env file [\#1164](https://github.com/kubernetes/kompose/issues/1164)
- kompose.image-pull-secret label not recognized by MicroK8s 1.14 [\#1146](https://github.com/kubernetes/kompose/issues/1146)
- redis-slave not found [\#1143](https://github.com/kubernetes/kompose/issues/1143)
- FATA Error while deploying application: deployments.extensions "cache" already exists [\#1138](https://github.com/kubernetes/kompose/issues/1138)
- `container\_name` was not converted to a valid identifier [\#1135](https://github.com/kubernetes/kompose/issues/1135)
- Upgrade Deployment and DaemonSet [\#1133](https://github.com/kubernetes/kompose/issues/1133)
- Error when i'm trying to convert my docker-compose [\#1130](https://github.com/kubernetes/kompose/issues/1130)
- Trivial converted service is not reachable [\#1128](https://github.com/kubernetes/kompose/issues/1128)
-  repository 'https://src.fedoraproject.org/cgit/rpms/kompose.git/' not found [\#1126](https://github.com/kubernetes/kompose/issues/1126)
- go get failed [\#1124](https://github.com/kubernetes/kompose/issues/1124)
- Fix dep [\#1119](https://github.com/kubernetes/kompose/issues/1119)
- "kompose up" won't push to Google on Windows Subsystem for Linux [\#1117](https://github.com/kubernetes/kompose/issues/1117)
- Drop master/slave terminology in the docs [\#1116](https://github.com/kubernetes/kompose/issues/1116)
- HostPath volumes File/Directory detection [\#1113](https://github.com/kubernetes/kompose/issues/1113)
- Placement tag inside deploy [\#1107](https://github.com/kubernetes/kompose/issues/1107)
- Names based on the helm chart name [\#1098](https://github.com/kubernetes/kompose/issues/1098)
- Issues with volume mounts in docker-compose.yml [\#1097](https://github.com/kubernetes/kompose/issues/1097)
- volumeMounts and subPath - how to convert named volumes [\#1096](https://github.com/kubernetes/kompose/issues/1096)
- How do I use a service account? [\#1088](https://github.com/kubernetes/kompose/issues/1088)
- Compose-on-kubernetes and kompose [\#1086](https://github.com/kubernetes/kompose/issues/1086)
- openshift route with edge termination [\#1085](https://github.com/kubernetes/kompose/issues/1085)
- Convert version 3.5 of Docker Compose is not supported [\#1058](https://github.com/kubernetes/kompose/issues/1058)
- Support for PVC Access Mode ReadWriteMany [\#1046](https://github.com/kubernetes/kompose/issues/1046)
- Add official docker image build [\#1045](https://github.com/kubernetes/kompose/issues/1045)
- Unable to push to Google Cloud [\#1043](https://github.com/kubernetes/kompose/issues/1043)
- Unable to kompose up my django container from windows or azure cloudshell. [\#966](https://github.com/kubernetes/kompose/issues/966)
- Kubernetes specific support in Compose [\#917](https://github.com/kubernetes/kompose/issues/917)
- Unable to push Docker image for service web: Unable to retrieve .docker/config.json authentication details.  [\#911](https://github.com/kubernetes/kompose/issues/911)
- Rework "unsupported keys" prompt [\#788](https://github.com/kubernetes/kompose/issues/788)

**Merged pull requests:**

- 1.19.0 Release [\#1174](https://github.com/kubernetes/kompose/pull/1174) ([cdrage](https://github.com/cdrage))
- Add note about output directories to convert --help [\#1171](https://github.com/kubernetes/kompose/pull/1171) ([cflee](https://github.com/cflee))
- Statically build binaries [\#1169](https://github.com/kubernetes/kompose/pull/1169) ([deviantony](https://github.com/deviantony))
- Snap [\#1153](https://github.com/kubernetes/kompose/pull/1153) ([mikeroyal](https://github.com/mikeroyal))
- Revert "Add node references" [\#1145](https://github.com/kubernetes/kompose/pull/1145) ([cdrage](https://github.com/cdrage))
- Fix container\_name set error [\#1141](https://github.com/kubernetes/kompose/pull/1141) ([hangyan](https://github.com/hangyan))
- Submodule with a 'go get'-friendly url [\#1139](https://github.com/kubernetes/kompose/pull/1139) ([irlevesque](https://github.com/irlevesque))
- Add node references [\#1123](https://github.com/kubernetes/kompose/pull/1123) ([cdrage](https://github.com/cdrage))
- Fix placement parser panic [\#1121](https://github.com/kubernetes/kompose/pull/1121) ([hangyan](https://github.com/hangyan))
- Update dep for compose 3.5+ [\#1120](https://github.com/kubernetes/kompose/pull/1120) ([hangyan](https://github.com/hangyan))
- Remove ROADMAP.md [\#1118](https://github.com/kubernetes/kompose/pull/1118) ([cdrage](https://github.com/cdrage))
- Update embargo doc link in SECURITY\_CONTACTS and change PST to PSC [\#1115](https://github.com/kubernetes/kompose/pull/1115) ([joelsmith](https://github.com/joelsmith))
- Fix function comments based on best practices from Effective Go [\#1112](https://github.com/kubernetes/kompose/pull/1112) ([CodeLingoTeam](https://github.com/CodeLingoTeam))
- Add Dockerfile [\#1101](https://github.com/kubernetes/kompose/pull/1101) ([spawnia](https://github.com/spawnia))

## [v1.18.0](https://github.com/kubernetes/kompose/tree/v1.18.0) (2019-03-01)

[Full Changelog](https://github.com/kubernetes/kompose/compare/v1.17.0...v1.18.0)

**Closed issues:**

- kompose up returning ErrImagePull while pulling from a private repo [\#1102](https://github.com/kubernetes/kompose/issues/1102)
- k.Transform failed archive/tar: write too long [\#1093](https://github.com/kubernetes/kompose/issues/1093)
- kompose up fails to parse yml that kompose convert generated [\#1082](https://github.com/kubernetes/kompose/issues/1082)
- Unable to load yaml/json file [\#1072](https://github.com/kubernetes/kompose/issues/1072)
- Command converted to Args [\#1067](https://github.com/kubernetes/kompose/issues/1067)
- Deploy to OSE with Self Signed Certificate [\#1065](https://github.com/kubernetes/kompose/issues/1065)
- ignore Docker Compose in conversion [\#1059](https://github.com/kubernetes/kompose/issues/1059)
- hostPort in deployment spec: is this supported? [\#1054](https://github.com/kubernetes/kompose/issues/1054)
- imagePullPolicy: is there way of specifying this [\#1052](https://github.com/kubernetes/kompose/issues/1052)
- Node Taints: is this supported. [\#1051](https://github.com/kubernetes/kompose/issues/1051)
- Multiple compose files seems to be broken [\#1048](https://github.com/kubernetes/kompose/issues/1048)
- Support for converting docker-compose.yml files using YAML Merge Key [\#1038](https://github.com/kubernetes/kompose/issues/1038)
- Support imagePullPolicy via label. [\#1036](https://github.com/kubernetes/kompose/issues/1036)
- Support HorizontalPodAutoscaler via label [\#1035](https://github.com/kubernetes/kompose/issues/1035)
- FATA services.xxx.ports.0 must be a string or number [\#986](https://github.com/kubernetes/kompose/issues/986)
- Add support for "scratch space" volumes [\#850](https://github.com/kubernetes/kompose/issues/850)
- Do not generate empty services [\#823](https://github.com/kubernetes/kompose/issues/823)
- Improve chart support / Helm testing [\#745](https://github.com/kubernetes/kompose/issues/745)
- using kompose as a library [\#464](https://github.com/kubernetes/kompose/issues/464)
- \[EPIC\] Use kubernetes/client-go [\#175](https://github.com/kubernetes/kompose/issues/175)

**Merged pull requests:**

- 1.18.0 Release [\#1108](https://github.com/kubernetes/kompose/pull/1108) ([cdrage](https://github.com/cdrage))
- Support multiple hostnames on expose label in service for Kubernetes [\#1092](https://github.com/kubernetes/kompose/pull/1092) ([huikaihoo](https://github.com/huikaihoo))
- Add kompose.image-pull-secret and kompose.image-pull-policy [\#1091](https://github.com/kubernetes/kompose/pull/1091) ([kiela](https://github.com/kiela))
- Update introduction.md [\#1090](https://github.com/kubernetes/kompose/pull/1090) ([hexmind](https://github.com/hexmind))
- Fix log output specific warning info [\#1084](https://github.com/kubernetes/kompose/pull/1084) ([gaozhenhai](https://github.com/gaozhenhai))
- Add label support to named volumes in docker compose v3 to Kubernetes [\#1083](https://github.com/kubernetes/kompose/pull/1083) ([huikaihoo](https://github.com/huikaihoo))
- Fix typo: generting -\> generating [\#1080](https://github.com/kubernetes/kompose/pull/1080) ([SataQiu](https://github.com/SataQiu))
- delete excess code [\#1079](https://github.com/kubernetes/kompose/pull/1079) ([xichengliudui](https://github.com/xichengliudui))
- Fix typos: accecpts -\> accepts [\#1077](https://github.com/kubernetes/kompose/pull/1077) ([mooncak](https://github.com/mooncak))

## [v1.17.0](https://github.com/kubernetes/kompose/tree/v1.17.0) (2018-11-05)

[Full Changelog](https://github.com/kubernetes/kompose/compare/v1.16.0...v1.17.0)

**Closed issues:**

- Use tide for PR merging [\#1069](https://github.com/kubernetes/kompose/issues/1069)
- kompose up - unmarshal errors when using docker compose version '3' [\#1064](https://github.com/kubernetes/kompose/issues/1064)
- dots get propagated into invalid names [\#1062](https://github.com/kubernetes/kompose/issues/1062)
- kompose webside is outdated [\#1057](https://github.com/kubernetes/kompose/issues/1057)
- read input from stdin does not work [\#1056](https://github.com/kubernetes/kompose/issues/1056)
- Installation Instructions for openSUSE/SLE [\#1049](https://github.com/kubernetes/kompose/issues/1049)
- getsockopt: connection refused when executing kompose up [\#1023](https://github.com/kubernetes/kompose/issues/1023)
- Support specifying nodePort via label [\#1022](https://github.com/kubernetes/kompose/issues/1022)
- Failing with my Node.js, RabbitMQ app [\#1019](https://github.com/kubernetes/kompose/issues/1019)
- Create a SECURITY\_CONTACTS file. [\#1015](https://github.com/kubernetes/kompose/issues/1015)
- Add support for Docker stack files [\#1014](https://github.com/kubernetes/kompose/issues/1014)
- multiple containers in a pod sharing volume [\#1012](https://github.com/kubernetes/kompose/issues/1012)
- Missing service metadata.labels mapping [\#1010](https://github.com/kubernetes/kompose/issues/1010)
- when to support this parameter build: args? [\#1004](https://github.com/kubernetes/kompose/issues/1004)
- Activate downward api [\#1002](https://github.com/kubernetes/kompose/issues/1002)
- Remove status field in the generated yaml [\#975](https://github.com/kubernetes/kompose/issues/975)
- Create Rolling updates using Kompose tool [\#965](https://github.com/kubernetes/kompose/issues/965)
- Support ubuntu's snap package format [\#964](https://github.com/kubernetes/kompose/issues/964)
- kompose up is not able to mount configmap volume [\#962](https://github.com/kubernetes/kompose/issues/962)
- How do I Specify the instance count via docker -compose file for Kompose [\#958](https://github.com/kubernetes/kompose/issues/958)
- Remove RC from supported workload [\#947](https://github.com/kubernetes/kompose/issues/947)
- Add HTTPS support for download URLs [\#945](https://github.com/kubernetes/kompose/issues/945)
- Coordinated efforts / centralized location for packages. [\#942](https://github.com/kubernetes/kompose/issues/942)
- docker-compose version 3.3 is not supported. [\#914](https://github.com/kubernetes/kompose/issues/914)
- extended env\_file capability to in-docker-compose.yml substitutions [\#909](https://github.com/kubernetes/kompose/issues/909)
- Allow specifying imagePullSecret [\#897](https://github.com/kubernetes/kompose/issues/897)
- Doesn't run on alpine? [\#890](https://github.com/kubernetes/kompose/issues/890)
- \[EPIC\] Improvements to volumes [\#884](https://github.com/kubernetes/kompose/issues/884)
- Refactor tests \(integration\) [\#877](https://github.com/kubernetes/kompose/issues/877)
- Not creation of `-service.yaml` when `restart` is present [\#851](https://github.com/kubernetes/kompose/issues/851)
- Update Kubernetes cluster tests with port testing [\#789](https://github.com/kubernetes/kompose/issues/789)
- Add testing documentation [\#781](https://github.com/kubernetes/kompose/issues/781)
- Update to annotations / cli tests + development document [\#770](https://github.com/kubernetes/kompose/issues/770)
- Adding compatibility matrix for different Kubernetes versions [\#726](https://github.com/kubernetes/kompose/issues/726)
- Add OpenShift specific examples for conversion [\#676](https://github.com/kubernetes/kompose/issues/676)
- Clean up and add current example files to integration tests. [\#675](https://github.com/kubernetes/kompose/issues/675)
- Add openshift tests for docker compose v3 [\#641](https://github.com/kubernetes/kompose/issues/641)
- duplicate info from multiple compose files not being overridden [\#624](https://github.com/kubernetes/kompose/issues/624)
- Add design decisions for contributors [\#607](https://github.com/kubernetes/kompose/issues/607)
- add tests when converting to separate files [\#129](https://github.com/kubernetes/kompose/issues/129)

**Merged pull requests:**

- 1.17.0 Release [\#1075](https://github.com/kubernetes/kompose/pull/1075) ([cdrage](https://github.com/cdrage))
- Bump Go versions [\#1073](https://github.com/kubernetes/kompose/pull/1073) ([HaraldNordgren](https://github.com/HaraldNordgren))
- Use OS provided temporary directory [\#1068](https://github.com/kubernetes/kompose/pull/1068) ([segrax](https://github.com/segrax))
- Propagate dots into valid service names [\#1063](https://github.com/kubernetes/kompose/pull/1063) ([rcmorano](https://github.com/rcmorano))
- Support read data from stdin [\#1061](https://github.com/kubernetes/kompose/pull/1061) ([hangyan](https://github.com/hangyan))
- Add support for Config, endpoint\_mode and 3.3 support [\#994](https://github.com/kubernetes/kompose/pull/994) ([xianlubird](https://github.com/xianlubird))

## [v1.16.0](https://github.com/kubernetes/kompose/tree/v1.16.0) (2018-07-24)

[Full Changelog](https://github.com/kubernetes/kompose/compare/v1.15.0...v1.16.0)

**Closed issues:**

- 'environment' with 'env-file' specified together for service in docker-compose.yml don't  work [\#1013](https://github.com/kubernetes/kompose/issues/1013)
- depends\_on with conditions [\#939](https://github.com/kubernetes/kompose/issues/939)
- kompose does not indicate key nor line number when printing error [\#915](https://github.com/kubernetes/kompose/issues/915)
- error with autogenerated cluster name [\#713](https://github.com/kubernetes/kompose/issues/713)
- kompose build fails: unable to create tarball [\#656](https://github.com/kubernetes/kompose/issues/656)
- Support for: top-level volumes. [\#447](https://github.com/kubernetes/kompose/issues/447)
- Validate/test artifacts generated by Kompose [\#133](https://github.com/kubernetes/kompose/issues/133)

**Merged pull requests:**

- 1.16.0 Release [\#1055](https://github.com/kubernetes/kompose/pull/1055) ([cdrage](https://github.com/cdrage))
- Add installation instructions for openSUSE/SLE [\#1050](https://github.com/kubernetes/kompose/pull/1050) ([suntorytimed](https://github.com/suntorytimed))
- Add surajnarwade in OWNER file [\#1047](https://github.com/kubernetes/kompose/pull/1047) ([surajnarwade](https://github.com/surajnarwade))
- Support node.labels at placement [\#1041](https://github.com/kubernetes/kompose/pull/1041) ([jvitor83](https://github.com/jvitor83))
- Fix environment with env\_file bug [\#1020](https://github.com/kubernetes/kompose/pull/1020) ([hangyan](https://github.com/hangyan))

## [v1.15.0](https://github.com/kubernetes/kompose/tree/v1.15.0) (2018-06-28)

[Full Changelog](https://github.com/kubernetes/kompose/compare/v1.14.0...v1.15.0)

**Closed issues:**

- Correct DL-link to latest kompose in installation guide [\#952](https://github.com/kubernetes/kompose/issues/952)
- Add development.md to site, refactor with `make vendor-update` [\#879](https://github.com/kubernetes/kompose/issues/879)
- update integration doc [\#857](https://github.com/kubernetes/kompose/issues/857)
- Enable kompose to generate configs per docker-compose service [\#657](https://github.com/kubernetes/kompose/issues/657)

**Merged pull requests:**

- 1.15.0 Release [\#1044](https://github.com/kubernetes/kompose/pull/1044) ([cdrage](https://github.com/cdrage))
- Typo fix: erroring -\> error [\#1032](https://github.com/kubernetes/kompose/pull/1032) ([mirake](https://github.com/mirake))
- Fix invalid port name with uppercase characters [\#1029](https://github.com/kubernetes/kompose/pull/1029) ([denverdino](https://github.com/denverdino))
- Typo fix in maven-example.md [\#1021](https://github.com/kubernetes/kompose/pull/1021) ([AdamDang](https://github.com/AdamDang))
- Kompose will read input from stdin [\#871](https://github.com/kubernetes/kompose/pull/871) ([surajnarwade](https://github.com/surajnarwade))

## [v1.14.0](https://github.com/kubernetes/kompose/tree/v1.14.0) (2018-06-04)

[Full Changelog](https://github.com/kubernetes/kompose/compare/v1.13.0...v1.14.0)

**Closed issues:**

- Add \(better\) documentation on adding tests [\#898](https://github.com/kubernetes/kompose/issues/898)
- `--deployment-config` flag is not necessary [\#803](https://github.com/kubernetes/kompose/issues/803)

**Merged pull requests:**

- 1.14.0 Release [\#1030](https://github.com/kubernetes/kompose/pull/1030) ([cdrage](https://github.com/cdrage))
- Typo fix: overwite -\> overwrite [\#1028](https://github.com/kubernetes/kompose/pull/1028) ([mirake](https://github.com/mirake))
- Typo fix in tests.sh: kubernets-\>kubernetes [\#1018](https://github.com/kubernetes/kompose/pull/1018) ([AdamDang](https://github.com/AdamDang))
- Update contact information for sebgoa [\#1017](https://github.com/kubernetes/kompose/pull/1017) ([cdrage](https://github.com/cdrage))
- Add security contacts [\#1016](https://github.com/kubernetes/kompose/pull/1016) ([cdrage](https://github.com/cdrage))
- Fix typo in integrations.md [\#1011](https://github.com/kubernetes/kompose/pull/1011) ([tongpu](https://github.com/tongpu))
- Fix golint warnings [\#1009](https://github.com/kubernetes/kompose/pull/1009) ([skyc024](https://github.com/skyc024))

## [v1.13.0](https://github.com/kubernetes/kompose/tree/v1.13.0) (2018-05-14)

[Full Changelog](https://github.com/kubernetes/kompose/compare/v1.12.0...v1.13.0)

**Closed issues:**

- Kubernetes multiple volumeMounts with subPath and 1 configmap volume - onle 1 volumeMount works [\#1005](https://github.com/kubernetes/kompose/issues/1005)
- Environment value merge failed with multiple docker-compose files [\#972](https://github.com/kubernetes/kompose/issues/972)
- Merge multiple docker-compose files [\#968](https://github.com/kubernetes/kompose/issues/968)
- Docker compose links section can't support [\#859](https://github.com/kubernetes/kompose/issues/859)

**Merged pull requests:**

- 1.13.0 Release [\#1006](https://github.com/kubernetes/kompose/pull/1006) ([cdrage](https://github.com/cdrage))
- Add label 'kompose.controller.type' set service convert controller type [\#1001](https://github.com/kubernetes/kompose/pull/1001) ([xianlubird](https://github.com/xianlubird))
- Add some deprecated info warning [\#1000](https://github.com/kubernetes/kompose/pull/1000) ([xianlubird](https://github.com/xianlubird))
- Support compose global deploy mode to daemonset [\#999](https://github.com/kubernetes/kompose/pull/999) ([xianlubird](https://github.com/xianlubird))
- Typo fix: wil-\>will [\#998](https://github.com/kubernetes/kompose/pull/998) ([AdamDang](https://github.com/AdamDang))
- Remove go1.6 support in ci [\#997](https://github.com/kubernetes/kompose/pull/997) ([hangyan](https://github.com/hangyan))
- Fix doc that we have support v3.1 & 3.2 [\#993](https://github.com/kubernetes/kompose/pull/993) ([xianlubird](https://github.com/xianlubird))
- Fix golint warnings [\#992](https://github.com/kubernetes/kompose/pull/992) ([xianlubird](https://github.com/xianlubird))
- Remove incorrect logging about headless service [\#991](https://github.com/kubernetes/kompose/pull/991) ([hangyan](https://github.com/hangyan))
- Fix missing attribute when convert with multiple docker-compose files [\#990](https://github.com/kubernetes/kompose/pull/990) ([xianlubird](https://github.com/xianlubird))
- Fix typo in conversion.md [\#989](https://github.com/kubernetes/kompose/pull/989) ([jonathanperret](https://github.com/jonathanperret))

## [v1.12.0](https://github.com/kubernetes/kompose/tree/v1.12.0) (2018-04-18)

[Full Changelog](https://github.com/kubernetes/kompose/compare/v1.11.0...v1.12.0)

**Closed issues:**

- Should we provide a go library to support the third-party integration ?  [\#982](https://github.com/kubernetes/kompose/issues/982)
- Minor typos in Makefile [\#971](https://github.com/kubernetes/kompose/issues/971)
- panic: runtime error: invalid memory address or nil pointer dereference [\#892](https://github.com/kubernetes/kompose/issues/892)
- kompose should read input from stdin [\#870](https://github.com/kubernetes/kompose/issues/870)
- panic: runtime error: invalid memory address or nil pointer dereference [\#853](https://github.com/kubernetes/kompose/issues/853)
- allow for setting size of persistent volume [\#235](https://github.com/kubernetes/kompose/issues/235)

**Merged pull requests:**

- 1.12.0 Release [\#988](https://github.com/kubernetes/kompose/pull/988) ([cdrage](https://github.com/cdrage))
- Typo fix [\#987](https://github.com/kubernetes/kompose/pull/987) ([jonyhy96](https://github.com/jonyhy96))
- Typo fix in conversion.md [\#985](https://github.com/kubernetes/kompose/pull/985) ([AdamDang](https://github.com/AdamDang))
- Fix some typo [\#983](https://github.com/kubernetes/kompose/pull/983) ([xianlubird](https://github.com/xianlubird))
- typo fix [\#981](https://github.com/kubernetes/kompose/pull/981) ([jonyhy96](https://github.com/jonyhy96))
- Add headless service type label [\#979](https://github.com/kubernetes/kompose/pull/979) ([hangyan](https://github.com/hangyan))
- Fix typos in comments [\#978](https://github.com/kubernetes/kompose/pull/978) ([hangyan](https://github.com/hangyan))
- Update dev doc about make gen-cmd [\#977](https://github.com/kubernetes/kompose/pull/977) ([hangyan](https://github.com/hangyan))
- Support hostname and domainname [\#976](https://github.com/kubernetes/kompose/pull/976) ([hangyan](https://github.com/hangyan))
- Fix typos in Makefile [\#974](https://github.com/kubernetes/kompose/pull/974) ([jaden-young](https://github.com/jaden-young))
- typo fix [\#973](https://github.com/kubernetes/kompose/pull/973) ([jonyhy96](https://github.com/jonyhy96))

## [v1.11.0](https://github.com/kubernetes/kompose/tree/v1.11.0) (2018-03-26)

[Full Changelog](https://github.com/kubernetes/kompose/compare/v1.10.0...v1.11.0)

**Closed issues:**

- Kompose fails on version 3 with deploy-resources-limits \(panic: runtime error: invalid memory address or nil pointer dereference\) [\#959](https://github.com/kubernetes/kompose/issues/959)
- Error transforming Kubernetes objects [\#876](https://github.com/kubernetes/kompose/issues/876)
- volumes long-syntax doesn't work [\#865](https://github.com/kubernetes/kompose/issues/865)
- unit test for annotation [\#753](https://github.com/kubernetes/kompose/issues/753)
- hostPath volumes? [\#109](https://github.com/kubernetes/kompose/issues/109)

**Merged pull requests:**

- 1.11.0 Release [\#970](https://github.com/kubernetes/kompose/pull/970) ([cdrage](https://github.com/cdrage))
- Fix golint warnings [\#967](https://github.com/kubernetes/kompose/pull/967) ([hangyan](https://github.com/hangyan))
- Add hangyan to OWNERS [\#963](https://github.com/kubernetes/kompose/pull/963) ([cdrage](https://github.com/cdrage))
- fix pod-controller relationship mistake [\#961](https://github.com/kubernetes/kompose/pull/961) ([jonyhy96](https://github.com/jonyhy96))
- Fix deploy resources parse error [\#960](https://github.com/kubernetes/kompose/pull/960) ([hangyan](https://github.com/hangyan))
- Support hostpath volume [\#957](https://github.com/kubernetes/kompose/pull/957) ([hangyan](https://github.com/hangyan))
- Refactor tests script to uses vars [\#956](https://github.com/kubernetes/kompose/pull/956) ([hangyan](https://github.com/hangyan))
- Add script for generating deb / rpm packages [\#955](https://github.com/kubernetes/kompose/pull/955) ([cdrage](https://github.com/cdrage))
- Add support for compose v3.2 [\#954](https://github.com/kubernetes/kompose/pull/954) ([hangyan](https://github.com/hangyan))
- Remove bintray instructions [\#953](https://github.com/kubernetes/kompose/pull/953) ([cdrage](https://github.com/cdrage))
- Support old restart policy in compose v3 [\#950](https://github.com/kubernetes/kompose/pull/950) ([hangyan](https://github.com/hangyan))
- Allow services to use same port with different protocols [\#907](https://github.com/kubernetes/kompose/pull/907) ([caglar10ur](https://github.com/caglar10ur))

## [v1.10.0](https://github.com/kubernetes/kompose/tree/v1.10.0) (2018-03-06)

[Full Changelog](https://github.com/kubernetes/kompose/compare/v1.9.0...v1.10.0)

**Closed issues:**

- Support for multi-port services [\#941](https://github.com/kubernetes/kompose/issues/941)
- panic: runtime error: invalid memory address or nil pointer dereference SIGSEGV related to Healthcheck [\#934](https://github.com/kubernetes/kompose/issues/934)
- Add FAQ [\#887](https://github.com/kubernetes/kompose/issues/887)
- Output option with convert -c fails. [\#886](https://github.com/kubernetes/kompose/issues/886)
- Add test cases / documentation for setting PVC volume size [\#872](https://github.com/kubernetes/kompose/issues/872)
- insufficient cpu [\#856](https://github.com/kubernetes/kompose/issues/856)
- old Kompose version in Fedora 26 [\#854](https://github.com/kubernetes/kompose/issues/854)
- Fabric8 CI not working [\#790](https://github.com/kubernetes/kompose/issues/790)
- remove dependency on docker daemon for building container images [\#696](https://github.com/kubernetes/kompose/issues/696)
- Add support for providing URL [\#605](https://github.com/kubernetes/kompose/issues/605)
- Blockers for running buildconfig tests on OpenShift [\#572](https://github.com/kubernetes/kompose/issues/572)
- git repo with detached head generates wrong `bc` [\#561](https://github.com/kubernetes/kompose/issues/561)
- move functional tests to golang [\#432](https://github.com/kubernetes/kompose/issues/432)
- Add support for s2i in buildconfigs for OpenShift [\#353](https://github.com/kubernetes/kompose/issues/353)
- kubernetes\_test.go and openshift\_test.go follow different patterns [\#346](https://github.com/kubernetes/kompose/issues/346)
- Get kompose in kubernetes repo [\#328](https://github.com/kubernetes/kompose/issues/328)
- Support converting OpenShift json \<-\> Kubernetes json/yaml [\#219](https://github.com/kubernetes/kompose/issues/219)
- RFE can we get Kompose to have a --redeploy option [\#147](https://github.com/kubernetes/kompose/issues/147)

**Merged pull requests:**

- 1.10.0 Release [\#951](https://github.com/kubernetes/kompose/pull/951) ([cdrage](https://github.com/cdrage))
- Fix broken links for volume long syntax in comments [\#949](https://github.com/kubernetes/kompose/pull/949) ([hangyan](https://github.com/hangyan))
- Refactor label names to const strings [\#948](https://github.com/kubernetes/kompose/pull/948) ([hangyan](https://github.com/hangyan))
- Fix image build path error [\#946](https://github.com/kubernetes/kompose/pull/946) ([hangyan](https://github.com/hangyan))
- Fix custom output and charts conflict error [\#938](https://github.com/kubernetes/kompose/pull/938) ([hangyan](https://github.com/hangyan))
- Variable name should not be the same as imported package name [\#937](https://github.com/kubernetes/kompose/pull/937) ([hangyan](https://github.com/hangyan))
- Fix healthcheck parser nil pointer error [\#936](https://github.com/kubernetes/kompose/pull/936) ([hangyan](https://github.com/hangyan))
- Add doc for volume size label [\#935](https://github.com/kubernetes/kompose/pull/935) ([hangyan](https://github.com/hangyan))
- Fixed typo [\#920](https://github.com/kubernetes/kompose/pull/920) ([pborreli](https://github.com/pborreli))

## [v1.9.0](https://github.com/kubernetes/kompose/tree/v1.9.0) (2018-02-13)

[Full Changelog](https://github.com/kubernetes/kompose/compare/v1.8.0...v1.9.0)

**Closed issues:**

- kompose.volume.size label is not working [\#927](https://github.com/kubernetes/kompose/issues/927)
- "panic: runtime error: invalid memory address or nil pointer dereference" when using environment unset variables [\#918](https://github.com/kubernetes/kompose/issues/918)
- \[doc\] more tutorial for gcloud? [\#833](https://github.com/kubernetes/kompose/issues/833)
- add support for `kompose update` [\#822](https://github.com/kubernetes/kompose/issues/822)
- Cannot locate specified Dockerfile: Dockerfile [\#809](https://github.com/kubernetes/kompose/issues/809)
- kompose passes a kubernetes deployment without image  [\#571](https://github.com/kubernetes/kompose/issues/571)
- Support for sysctls [\#441](https://github.com/kubernetes/kompose/issues/441)

**Merged pull requests:**

- 1.9.0 Release [\#943](https://github.com/kubernetes/kompose/pull/943) ([cdrage](https://github.com/cdrage))
- Refactor package app to use const rather than raw string [\#933](https://github.com/kubernetes/kompose/pull/933) ([hangyan](https://github.com/hangyan))
- Fix typos in Makefile [\#932](https://github.com/kubernetes/kompose/pull/932) ([hangyan](https://github.com/hangyan))
- Fix typo in function name [\#931](https://github.com/kubernetes/kompose/pull/931) ([hangyan](https://github.com/hangyan))
- Fix typos in doc [\#930](https://github.com/kubernetes/kompose/pull/930) ([hangyan](https://github.com/hangyan))
- Fix custom pvc size in v2 compose not working error [\#929](https://github.com/kubernetes/kompose/pull/929) ([hangyan](https://github.com/hangyan))
- Fix log format error [\#928](https://github.com/kubernetes/kompose/pull/928) ([hangyan](https://github.com/hangyan))
- Fix unset env bug for v3 compose [\#926](https://github.com/kubernetes/kompose/pull/926) ([hangyan](https://github.com/hangyan))
- Fix typo in cli help message [\#925](https://github.com/kubernetes/kompose/pull/925) ([hangyan](https://github.com/hangyan))
- Remove unneeded TODO comment [\#924](https://github.com/kubernetes/kompose/pull/924) ([hangyan](https://github.com/hangyan))
- fix a typo in development.md [\#923](https://github.com/kubernetes/kompose/pull/923) ([yank1](https://github.com/yank1))
- provide more details for building steps [\#921](https://github.com/kubernetes/kompose/pull/921) ([adolphlwq](https://github.com/adolphlwq))
- Update the README [\#919](https://github.com/kubernetes/kompose/pull/919) ([cdrage](https://github.com/cdrage))
- Push image without authentication [\#913](https://github.com/kubernetes/kompose/pull/913) ([coodix](https://github.com/coodix))

## [v1.8.0](https://github.com/kubernetes/kompose/tree/v1.8.0) (2018-01-24)

[Full Changelog](https://github.com/kubernetes/kompose/compare/v1.7.0...v1.8.0)

**Closed issues:**

- unable to push to private repo in hub.docker.com [\#910](https://github.com/kubernetes/kompose/issues/910)
- No proper link to Binary Installation method in README.md [\#902](https://github.com/kubernetes/kompose/issues/902)
- Kompose down doesn't remove configmaps [\#883](https://github.com/kubernetes/kompose/issues/883)

**Merged pull requests:**

- 1.8.0 Release [\#912](https://github.com/kubernetes/kompose/pull/912) ([cdrage](https://github.com/cdrage))
- Invalid quick start link [\#908](https://github.com/kubernetes/kompose/pull/908) ([a8uhnf](https://github.com/a8uhnf))
- Fix link to binary-installation method in README.md [\#903](https://github.com/kubernetes/kompose/pull/903) ([bhavin192](https://github.com/bhavin192))

## [v1.7.0](https://github.com/kubernetes/kompose/tree/v1.7.0) (2018-01-04)

[Full Changelog](https://github.com/kubernetes/kompose/compare/v1.6.0...v1.7.0)

**Closed issues:**

- Cannot run in gcloud environment with Kompose CLI [\#905](https://github.com/kubernetes/kompose/issues/905)
- docker config.json format [\#904](https://github.com/kubernetes/kompose/issues/904)
- Unable to push to \(private\) registry [\#893](https://github.com/kubernetes/kompose/issues/893)
- Bintray links broken in the README [\#889](https://github.com/kubernetes/kompose/issues/889)
- kompose build fails to read the context correctly [\#832](https://github.com/kubernetes/kompose/issues/832)
- Build errors with current OpenShift cluster tests [\#752](https://github.com/kubernetes/kompose/issues/752)
- kompose should give warning on providing blank environment variables [\#545](https://github.com/kubernetes/kompose/issues/545)
- Docker build fails:  Failed to push image: unauthized:authentication required [\#496](https://github.com/kubernetes/kompose/issues/496)
- wrong git revision number in version output [\#422](https://github.com/kubernetes/kompose/issues/422)
- publicly hosted API endpoint for kompose [\#419](https://github.com/kubernetes/kompose/issues/419)
- Improve logging messages in unit tests [\#351](https://github.com/kubernetes/kompose/issues/351)
- Improve coveralls.io reporting [\#330](https://github.com/kubernetes/kompose/issues/330)
- Investigate a preference file [\#39](https://github.com/kubernetes/kompose/issues/39)
- determine which containers should be in the same pod [\#14](https://github.com/kubernetes/kompose/issues/14)

**Merged pull requests:**

- 1.7.0 Release [\#906](https://github.com/kubernetes/kompose/pull/906) ([cdrage](https://github.com/cdrage))
- Convert registry to k8s.gcr.io [\#901](https://github.com/kubernetes/kompose/pull/901) ([thockin](https://github.com/thockin))
- Added Case for Config Map in kompose down [\#900](https://github.com/kubernetes/kompose/pull/900) ([piyush-garg](https://github.com/piyush-garg))
- Update code-of-conduct.md [\#899](https://github.com/kubernetes/kompose/pull/899) ([spiffxp](https://github.com/spiffxp))
- Add kompose.service.expose.tls-secret [\#896](https://github.com/kubernetes/kompose/pull/896) ([Code0x58](https://github.com/Code0x58))
- Fix pushing of image to a private repository [\#895](https://github.com/kubernetes/kompose/pull/895) ([Code0x58](https://github.com/Code0x58))
- Script for generating unit tests [\#805](https://github.com/kubernetes/kompose/pull/805) ([ashetty1](https://github.com/ashetty1))

## [v1.6.0](https://github.com/kubernetes/kompose/tree/v1.6.0) (2017-12-11)

[Full Changelog](https://github.com/kubernetes/kompose/compare/v1.5.0...v1.6.0)

**Closed issues:**

- conversion metrix doc is outdated [\#873](https://github.com/kubernetes/kompose/issues/873)
- Up and convert commands are not equal in features [\#798](https://github.com/kubernetes/kompose/issues/798)
- Improve user guide [\#776](https://github.com/kubernetes/kompose/issues/776)
- Tracking card for new `deploy` keys in v3 [\#644](https://github.com/kubernetes/kompose/issues/644)
- Add `build` key support for v3 of Docker Compose [\#636](https://github.com/kubernetes/kompose/issues/636)

**Merged pull requests:**

- 1.6.0 Release [\#891](https://github.com/kubernetes/kompose/pull/891) ([cdrage](https://github.com/cdrage))
- Fixed conversion matrix [\#885](https://github.com/kubernetes/kompose/pull/885) ([surajnarwade](https://github.com/surajnarwade))
- Test cross-compiling within travis [\#882](https://github.com/kubernetes/kompose/pull/882) ([cdrage](https://github.com/cdrage))
- Fix makefile [\#881](https://github.com/kubernetes/kompose/pull/881) ([cdrage](https://github.com/cdrage))
- Update vendoring / fix Windows builds [\#880](https://github.com/kubernetes/kompose/pull/880) ([cdrage](https://github.com/cdrage))
- n -\> ✓ for build v3 support [\#878](https://github.com/kubernetes/kompose/pull/878) ([cdrage](https://github.com/cdrage))
- Update conversion doc for env\_file [\#875](https://github.com/kubernetes/kompose/pull/875) ([cdrage](https://github.com/cdrage))
- Adding `--controller` flag in `up` & `down` [\#868](https://github.com/kubernetes/kompose/pull/868) ([surajnarwade](https://github.com/surajnarwade))
- Added support for build key in v3 [\#846](https://github.com/kubernetes/kompose/pull/846) ([surajnarwade](https://github.com/surajnarwade))
- Fixed kompose build failure [\#837](https://github.com/kubernetes/kompose/pull/837) ([surajnarwade](https://github.com/surajnarwade))

## [v1.5.0](https://github.com/kubernetes/kompose/tree/v1.5.0) (2017-11-21)

[Full Changelog](https://github.com/kubernetes/kompose/compare/v1.4.0...v1.5.0)

**Merged pull requests:**

- 1.5.0 Release [\#874](https://github.com/kubernetes/kompose/pull/874) ([cdrage](https://github.com/cdrage))
-  Set PVC volume size with kompose.volume.size [\#867](https://github.com/kubernetes/kompose/pull/867) ([abitrolly](https://github.com/abitrolly))
- architecture.md  Link sources [\#866](https://github.com/kubernetes/kompose/pull/866) ([abitrolly](https://github.com/abitrolly))
- Move version information to separate file [\#864](https://github.com/kubernetes/kompose/pull/864) ([cdrage](https://github.com/cdrage))
- Fix typo [\#863](https://github.com/kubernetes/kompose/pull/863) ([xianlubird](https://github.com/xianlubird))
- Ignore links attribute and print warning message [\#862](https://github.com/kubernetes/kompose/pull/862) ([xianlubird](https://github.com/xianlubird))
- Add TOC to documentation, add readme.md notice [\#861](https://github.com/kubernetes/kompose/pull/861) ([cdrage](https://github.com/cdrage))

## [v1.4.0](https://github.com/kubernetes/kompose/tree/v1.4.0) (2017-10-31)

[Full Changelog](https://github.com/kubernetes/kompose/compare/v1.3.0...v1.4.0)

**Closed issues:**

- Fix links in docs/README.md [\#845](https://github.com/kubernetes/kompose/issues/845)
- Link is broken for maven example [\#844](https://github.com/kubernetes/kompose/issues/844)
- Update --help page for convert to be the same as up [\#842](https://github.com/kubernetes/kompose/issues/842)
- Add documentation on Kompose integrations [\#732](https://github.com/kubernetes/kompose/issues/732)
- Convert docker-compose env files into configmaps [\#308](https://github.com/kubernetes/kompose/issues/308)
- Investigate how to use HCL/Nomad as input object [\#144](https://github.com/kubernetes/kompose/issues/144)

**Merged pull requests:**

- 1.4.0 Release [\#858](https://github.com/kubernetes/kompose/pull/858) ([cdrage](https://github.com/cdrage))
- Updated `--help` page for `kompose up` [\#852](https://github.com/kubernetes/kompose/pull/852) ([surajnarwade](https://github.com/surajnarwade))
- Fix Redirecting Error in README.md [\#849](https://github.com/kubernetes/kompose/pull/849) ([piyush-garg](https://github.com/piyush-garg))
- Redirects not working [\#848](https://github.com/kubernetes/kompose/pull/848) ([cdrage](https://github.com/cdrage))
- Fix Redirecting Error [\#847](https://github.com/kubernetes/kompose/pull/847) ([piyush-garg](https://github.com/piyush-garg))
- Added Fabric8 Maven Plugin in Integration [\#836](https://github.com/kubernetes/kompose/pull/836) ([piyush-garg](https://github.com/piyush-garg))
- Adding documentation for tests [\#819](https://github.com/kubernetes/kompose/pull/819) ([ashetty1](https://github.com/ashetty1))

## [v1.3.0](https://github.com/kubernetes/kompose/tree/v1.3.0) (2017-10-10)

[Full Changelog](https://github.com/kubernetes/kompose/compare/v1.2.0...v1.3.0)

**Closed issues:**

- `go vet` is failing locally [\#825](https://github.com/kubernetes/kompose/issues/825)
- `--volumes` is not validated  [\#814](https://github.com/kubernetes/kompose/issues/814)
- tmpfs with mode fails [\#807](https://github.com/kubernetes/kompose/issues/807)
- Add --controller [\#792](https://github.com/kubernetes/kompose/issues/792)

**Merged pull requests:**

- 1.3.0 Release [\#843](https://github.com/kubernetes/kompose/pull/843) ([cdrage](https://github.com/cdrage))
- Update version number in introduction.md [\#841](https://github.com/kubernetes/kompose/pull/841) ([cdrage](https://github.com/cdrage))
- Update getting started guide docs [\#840](https://github.com/kubernetes/kompose/pull/840) ([cdrage](https://github.com/cdrage))
- Fix the cpu limits and requests in generated deployment file [\#838](https://github.com/kubernetes/kompose/pull/838) ([denverdino](https://github.com/denverdino))
- Update vendoring for logrus and gojsonschema changes [\#835](https://github.com/kubernetes/kompose/pull/835) ([cdrage](https://github.com/cdrage))
- Add Getting Started guide, adds Minishift tutorial [\#834](https://github.com/kubernetes/kompose/pull/834) ([cdrage](https://github.com/cdrage))
- Updated vendoring [\#828](https://github.com/kubernetes/kompose/pull/828) ([surajnarwade](https://github.com/surajnarwade))
- Fixed `go vet` [\#827](https://github.com/kubernetes/kompose/pull/827) ([surajnarwade](https://github.com/surajnarwade))
- Added `--build-repo` in `kompose up` [\#824](https://github.com/kubernetes/kompose/pull/824) ([surajnarwade](https://github.com/surajnarwade))
- Adding  --build-branch to `kompose up` [\#820](https://github.com/kubernetes/kompose/pull/820) ([surajnarwade](https://github.com/surajnarwade))
- Fixed `--volumes` validation [\#817](https://github.com/kubernetes/kompose/pull/817) ([surajnarwade](https://github.com/surajnarwade))
- Fixed tmpfs with mode failure [\#816](https://github.com/kubernetes/kompose/pull/816) ([surajnarwade](https://github.com/surajnarwade))
- Fix reference to emptyDir in OpenShift test scripts [\#815](https://github.com/kubernetes/kompose/pull/815) ([ashetty1](https://github.com/ashetty1))
- Added feature for `placement` key in v3 [\#813](https://github.com/kubernetes/kompose/pull/813) ([surajnarwade](https://github.com/surajnarwade))
- Added `--controller` feature [\#810](https://github.com/kubernetes/kompose/pull/810) ([surajnarwade](https://github.com/surajnarwade))
- Add env\_file + ConfigMaps feature to Kompose [\#799](https://github.com/kubernetes/kompose/pull/799) ([cdrage](https://github.com/cdrage))

## [v1.2.0](https://github.com/kubernetes/kompose/tree/v1.2.0) (2017-09-18)

[Full Changelog](https://github.com/kubernetes/kompose/compare/v1.1.0...v1.2.0)

**Merged pull requests:**

- emptvols -\> volumes=yes [\#811](https://github.com/kubernetes/kompose/pull/811) ([ashetty1](https://github.com/ashetty1))
- Remove redundant strings.ToLower\(\) [\#808](https://github.com/kubernetes/kompose/pull/808) ([cdrage](https://github.com/cdrage))
- Add --volumes parameter, deprecate emptyvols [\#787](https://github.com/kubernetes/kompose/pull/787) ([cdrage](https://github.com/cdrage))

## [v1.1.0](https://github.com/kubernetes/kompose/tree/v1.1.0) (2017-08-30)

[Full Changelog](https://github.com/kubernetes/kompose/compare/v1.0.0...v1.1.0)

**Closed issues:**

- Kompose replicas option not working with v3 deploy? [\#801](https://github.com/kubernetes/kompose/issues/801)
- Functional test for examples Directory [\#793](https://github.com/kubernetes/kompose/issues/793)
- overlapped content on the conversion matrix documentation page [\#765](https://github.com/kubernetes/kompose/issues/765)
- get rid of the bundle tag in kobject [\#750](https://github.com/kubernetes/kompose/issues/750)
- When specifying a wrong parameter, --help is not complete [\#744](https://github.com/kubernetes/kompose/issues/744)
- Add support for cpus \(Version 3 Resources Key\) [\#730](https://github.com/kubernetes/kompose/issues/730)
- Deprecate Docker Compose Version 2.1, 2.2, and 3.3. Only support 1,2,3,4 \(future\). [\#725](https://github.com/kubernetes/kompose/issues/725)
- Error running kompose on counter v3 example file [\#721](https://github.com/kubernetes/kompose/issues/721)
- Change imports  for kompose packages to 'k8s.io/kompose" [\#719](https://github.com/kubernetes/kompose/issues/719)
- Distinguish / re-add ` $` to docs [\#718](https://github.com/kubernetes/kompose/issues/718)
- Docker build in kompose convert [\#691](https://github.com/kubernetes/kompose/issues/691)
- Move git functions in openshift.go into a separate package [\#640](https://github.com/kubernetes/kompose/issues/640)
- Save the cmd used to create config [\#639](https://github.com/kubernetes/kompose/issues/639)
- Unable to run `make test-openshift` [\#614](https://github.com/kubernetes/kompose/issues/614)
- Fatal error saying "/etc/nginx/certs": must be unique [\#544](https://github.com/kubernetes/kompose/issues/544)
- make flags global which are common [\#514](https://github.com/kubernetes/kompose/issues/514)
- Support for: userns\_mode [\#443](https://github.com/kubernetes/kompose/issues/443)
- Support for: isolation [\#438](https://github.com/kubernetes/kompose/issues/438)
- Support for: group\_add [\#437](https://github.com/kubernetes/kompose/issues/437)
- kompose binary per merge? \(add nightlies\) [\#355](https://github.com/kubernetes/kompose/issues/355)
- Add health checks [\#163](https://github.com/kubernetes/kompose/issues/163)
- Release process  [\#70](https://github.com/kubernetes/kompose/issues/70)

**Merged pull requests:**

- 1.1.0 Release [\#804](https://github.com/kubernetes/kompose/pull/804) ([cdrage](https://github.com/cdrage))
- Adding OpenShift tests for deploy keys [\#802](https://github.com/kubernetes/kompose/pull/802) ([ashetty1](https://github.com/ashetty1))
- Fixes output of help template [\#800](https://github.com/kubernetes/kompose/pull/800) ([cdrage](https://github.com/cdrage))
- Fix kompose docker container wrong href [\#797](https://github.com/kubernetes/kompose/pull/797) ([JadCham](https://github.com/JadCham))
- Update to lowercase in conversion.md [\#796](https://github.com/kubernetes/kompose/pull/796) ([cdrage](https://github.com/cdrage))
- Added functional test for docker compose files in Example directory [\#795](https://github.com/kubernetes/kompose/pull/795) ([surajnarwade](https://github.com/surajnarwade))
- changing the organisation from kubernetes-incubator to kubernetes [\#794](https://github.com/kubernetes/kompose/pull/794) ([rupalibehera](https://github.com/rupalibehera))
- Fix minor help output [\#786](https://github.com/kubernetes/kompose/pull/786) ([cdrage](https://github.com/cdrage))
- Add Bintray documentation to README and installation doc [\#785](https://github.com/kubernetes/kompose/pull/785) ([cdrage](https://github.com/cdrage))
- Fix minor typo in comment [\#784](https://github.com/kubernetes/kompose/pull/784) ([Rajadeepan](https://github.com/Rajadeepan))
- add correct secrets for bintray [\#783](https://github.com/kubernetes/kompose/pull/783) ([kadel](https://github.com/kadel))
- build and upload master builds to bintray [\#782](https://github.com/kubernetes/kompose/pull/782) ([kadel](https://github.com/kadel))
- Update the dev guide with CI details [\#780](https://github.com/kubernetes/kompose/pull/780) ([cdrage](https://github.com/cdrage))
- Update conversion matrix with windows notes [\#779](https://github.com/kubernetes/kompose/pull/779) ([cdrage](https://github.com/cdrage))
- Change directory for cluster tests [\#778](https://github.com/kubernetes/kompose/pull/778) ([cdrage](https://github.com/cdrage))
- Remove dab examples [\#777](https://github.com/kubernetes/kompose/pull/777) ([cdrage](https://github.com/cdrage))
- Adds a more "full" conversion document [\#775](https://github.com/kubernetes/kompose/pull/775) ([cdrage](https://github.com/cdrage))
- Add deploy: mode: global support [\#771](https://github.com/kubernetes/kompose/pull/771) ([cdrage](https://github.com/cdrage))
- Change bot message [\#769](https://github.com/kubernetes/kompose/pull/769) ([asifdxtreme](https://github.com/asifdxtreme))
- Fix minor typo [\#768](https://github.com/kubernetes/kompose/pull/768) ([asifdxtreme](https://github.com/asifdxtreme))
- Update Community Code of Conduct [\#764](https://github.com/kubernetes/kompose/pull/764) ([mbssaiakhil](https://github.com/mbssaiakhil))
- Go down to one ACK [\#762](https://github.com/kubernetes/kompose/pull/762) ([cdrage](https://github.com/cdrage))
- Rename test-ci to test-k8s [\#761](https://github.com/kubernetes/kompose/pull/761) ([cdrage](https://github.com/cdrage))
- Fix typo in Events Code of Conduct [\#760](https://github.com/kubernetes/kompose/pull/760) ([mbssaiakhil](https://github.com/mbssaiakhil))
- Adds healthcheck [\#759](https://github.com/kubernetes/kompose/pull/759) ([cdrage](https://github.com/cdrage))
- Update cluster tests, use local Kompose binary [\#757](https://github.com/kubernetes/kompose/pull/757) ([cdrage](https://github.com/cdrage))
- Temporarily remove buildconfig tests for OpenShift [\#754](https://github.com/kubernetes/kompose/pull/754) ([cdrage](https://github.com/cdrage))
- Gets rid of bundle tag [\#751](https://github.com/kubernetes/kompose/pull/751) ([cdrage](https://github.com/cdrage))
- Update docs to reflect conversion changes [\#749](https://github.com/kubernetes/kompose/pull/749) ([cdrage](https://github.com/cdrage))
- Exit 1 not Exit 0 [\#747](https://github.com/kubernetes/kompose/pull/747) ([cdrage](https://github.com/cdrage))
- Create docker client from environment variables [\#746](https://github.com/kubernetes/kompose/pull/746) ([rathko](https://github.com/rathko))
- Add Goreport badge [\#743](https://github.com/kubernetes/kompose/pull/743) ([asifdxtreme](https://github.com/asifdxtreme))
- Add author to Kompose UI [\#742](https://github.com/kubernetes/kompose/pull/742) ([JadCham](https://github.com/JadCham))
- Update installation instructions [\#741](https://github.com/kubernetes/kompose/pull/741) ([cdrage](https://github.com/cdrage))
- Update integrations links [\#740](https://github.com/kubernetes/kompose/pull/740) ([cdrage](https://github.com/cdrage))
-  Added support for `group\_add` key [\#739](https://github.com/kubernetes/kompose/pull/739) ([surajnarwade](https://github.com/surajnarwade))
- Add CPU limit, CPU Reservation and Memory Reservation [\#738](https://github.com/kubernetes/kompose/pull/738) ([cdrage](https://github.com/cdrage))
- Add integration doc [\#736](https://github.com/kubernetes/kompose/pull/736) ([cdrage](https://github.com/cdrage))
- Add Windows instructions to installation.md [\#735](https://github.com/kubernetes/kompose/pull/735) ([cdrage](https://github.com/cdrage))
- Added `saving command` to annotation feature [\#733](https://github.com/kubernetes/kompose/pull/733) ([surajnarwade](https://github.com/surajnarwade))
- Adds Kubernetes cluster tests [\#731](https://github.com/kubernetes/kompose/pull/731) ([cdrage](https://github.com/cdrage))
- Add gitlawr to mention bot blacklist [\#729](https://github.com/kubernetes/kompose/pull/729) ([cdrage](https://github.com/cdrage))
- Updates the conversion document to reflect changes [\#728](https://github.com/kubernetes/kompose/pull/728) ([cdrage](https://github.com/cdrage))
- Update release script with properly formatted table [\#724](https://github.com/kubernetes/kompose/pull/724) ([cdrage](https://github.com/cdrage))
- Fix OpenShift tests for build and push [\#665](https://github.com/kubernetes/kompose/pull/665) ([ashetty1](https://github.com/ashetty1))
- move git and related functions from openshift.go into a separate file [\#651](https://github.com/kubernetes/kompose/pull/651) ([procrypt](https://github.com/procrypt))
- OpenShift tests for docker compose v3 [\#642](https://github.com/kubernetes/kompose/pull/642) ([ashetty1](https://github.com/ashetty1))
- Handling Volume at early stage [\#626](https://github.com/kubernetes/kompose/pull/626) ([surajnarwade](https://github.com/surajnarwade))

## [v1.0.0](https://github.com/kubernetes/kompose/tree/v1.0.0) (2017-07-20)

[Full Changelog](https://github.com/kubernetes/kompose/compare/v0.7.0...v1.0.0)

**Closed issues:**

- adding timestamp in k8s artifacts [\#717](https://github.com/kubernetes/kompose/issues/717)
- Kompose  latest release version info from version file [\#712](https://github.com/kubernetes/kompose/issues/712)
- One Script to Run Them All [\#683](https://github.com/kubernetes/kompose/issues/683)
- setting environment variable PROVIDER no longer works [\#678](https://github.com/kubernetes/kompose/issues/678)
- kompose.service.type issues [\#673](https://github.com/kubernetes/kompose/issues/673)
- Add example integration tests [\#671](https://github.com/kubernetes/kompose/issues/671)
- make test failing again [\#659](https://github.com/kubernetes/kompose/issues/659)
- make test is failing [\#654](https://github.com/kubernetes/kompose/issues/654)
- Deprecation warnings are not showing [\#652](https://github.com/kubernetes/kompose/issues/652)
- v3 env substitution is not working [\#650](https://github.com/kubernetes/kompose/issues/650)
- Docker Build/Push documentation [\#647](https://github.com/kubernetes/kompose/issues/647)
- v3 Documentation [\#646](https://github.com/kubernetes/kompose/issues/646)
- Support  restart\_policy in v3 docker compose [\#643](https://github.com/kubernetes/kompose/issues/643)
- ports error on converting [\#633](https://github.com/kubernetes/kompose/issues/633)
- Fix EnvSort so that env variables are populated properly [\#627](https://github.com/kubernetes/kompose/issues/627)
- emptyvols option doesn't work for kompose convert/up [\#625](https://github.com/kubernetes/kompose/issues/625)
- configuration key 'build' contains an invalid type, it should be a string. [\#620](https://github.com/kubernetes/kompose/issues/620)
- Add support for 'pid' key [\#610](https://github.com/kubernetes/kompose/issues/610)
- Failing test should show diff [\#604](https://github.com/kubernetes/kompose/issues/604)
- environment variables are populated in random order in the created artifacts. [\#595](https://github.com/kubernetes/kompose/issues/595)
- `kompose convert` should validate dockerfilepath  [\#594](https://github.com/kubernetes/kompose/issues/594)
- Error with volume name with generated deployment file [\#584](https://github.com/kubernetes/kompose/issues/584)
- kompose.service.type label not working as expected [\#522](https://github.com/kubernetes/kompose/issues/522)
- Roadmap is out of date. [\#482](https://github.com/kubernetes/kompose/issues/482)
- Bug: Adding `networks:` to docker-compose.yaml file results in a runtime error [\#474](https://github.com/kubernetes/kompose/issues/474)
- Deprecating v1 and only supporting v2 and v3 [\#430](https://github.com/kubernetes/kompose/issues/430)
- Error to parse docker-compose v3 format [\#412](https://github.com/kubernetes/kompose/issues/412)
- Docker DAB support does not currently work \(still in experimental\) [\#390](https://github.com/kubernetes/kompose/issues/390)
- Tests before merge [\#349](https://github.com/kubernetes/kompose/issues/349)
- Functional tests for OpenShift down [\#323](https://github.com/kubernetes/kompose/issues/323)
- Interactive / work-through-each-step mode. [\#292](https://github.com/kubernetes/kompose/issues/292)
- Define build strategy with Kubernetes [\#97](https://github.com/kubernetes/kompose/issues/97)
- support PetSet [\#16](https://github.com/kubernetes/kompose/issues/16)

**Merged pull requests:**

- 1.0.0 Release [\#723](https://github.com/kubernetes/kompose/pull/723) ([cdrage](https://github.com/cdrage))
- Update the release script [\#722](https://github.com/kubernetes/kompose/pull/722) ([cdrage](https://github.com/cdrage))
- Adds clarification on commands [\#720](https://github.com/kubernetes/kompose/pull/720) ([cdrage](https://github.com/cdrage))
- Update doc script [\#716](https://github.com/kubernetes/kompose/pull/716) ([cdrage](https://github.com/cdrage))
- Ignore pinging dusty on PR's [\#715](https://github.com/kubernetes/kompose/pull/715) ([cdrage](https://github.com/cdrage))
- Moving version from variable to text file [\#714](https://github.com/kubernetes/kompose/pull/714) ([surajnarwade](https://github.com/surajnarwade))
- Make mention bot less aggresive [\#711](https://github.com/kubernetes/kompose/pull/711) ([cdrage](https://github.com/cdrage))
- Updated code with go lint result [\#710](https://github.com/kubernetes/kompose/pull/710) ([surajnarwade](https://github.com/surajnarwade))
- fix some typos to make goreport happy [\#709](https://github.com/kubernetes/kompose/pull/709) ([fate-grand-order](https://github.com/fate-grand-order))
- Conversion Reference -\> Conversion Matrix [\#708](https://github.com/kubernetes/kompose/pull/708) ([cdrage](https://github.com/cdrage))
- Added docker compose v3 example for counter [\#707](https://github.com/kubernetes/kompose/pull/707) ([surajnarwade](https://github.com/surajnarwade))
- Added Fedora 26 [\#706](https://github.com/kubernetes/kompose/pull/706) ([e-minguez](https://github.com/e-minguez))
- kubernetes-incubator -\> kubernetes [\#704](https://github.com/kubernetes/kompose/pull/704) ([cdrage](https://github.com/cdrage))
- Refactoring code as per gosimple check [\#703](https://github.com/kubernetes/kompose/pull/703) ([surajnarwade](https://github.com/surajnarwade))
- remove unused parameter from ValidateComposeFile\(\) [\#702](https://github.com/kubernetes/kompose/pull/702) ([concaf](https://github.com/concaf))
- Update mention bot configuration to avoid mentioning people twice [\#701](https://github.com/kubernetes/kompose/pull/701) ([cdrage](https://github.com/cdrage))
- Update mention bot config [\#700](https://github.com/kubernetes/kompose/pull/700) ([cdrage](https://github.com/cdrage))
- Fixed minor issue in kubernetes\_test.go [\#697](https://github.com/kubernetes/kompose/pull/697) ([surajnarwade](https://github.com/surajnarwade))
- Add mention bot [\#695](https://github.com/kubernetes/kompose/pull/695) ([cdrage](https://github.com/cdrage))
- Fix redirection site issues [\#694](https://github.com/kubernetes/kompose/pull/694) ([cdrage](https://github.com/cdrage))
- Update quickstart [\#692](https://github.com/kubernetes/kompose/pull/692) ([cdrage](https://github.com/cdrage))
- Setup -\> Installation + title updates [\#685](https://github.com/kubernetes/kompose/pull/685) ([cdrage](https://github.com/cdrage))
- Remove empty if branch [\#682](https://github.com/kubernetes/kompose/pull/682) ([surajnarwade](https://github.com/surajnarwade))
- Remove meeting from README + update [\#681](https://github.com/kubernetes/kompose/pull/681) ([cdrage](https://github.com/cdrage))
- Updated user-guide [\#680](https://github.com/kubernetes/kompose/pull/680) ([surajnarwade](https://github.com/surajnarwade))
- 2016 -\> 2017 for licensing [\#677](https://github.com/kubernetes/kompose/pull/677) ([cdrage](https://github.com/cdrage))
- Fixes kompose.service.type label issue [\#674](https://github.com/kubernetes/kompose/pull/674) ([surajnarwade](https://github.com/surajnarwade))
- Remove DAB from docs [\#672](https://github.com/kubernetes/kompose/pull/672) ([cdrage](https://github.com/cdrage))
- Add v3 example [\#670](https://github.com/kubernetes/kompose/pull/670) ([cdrage](https://github.com/cdrage))
- Adding Jenkinsfile for PR pipeline on Fabric8CD infrastructure [\#669](https://github.com/kubernetes/kompose/pull/669) ([rupalibehera](https://github.com/rupalibehera))
- Remove 'cdrage' username from example [\#668](https://github.com/kubernetes/kompose/pull/668) ([cdrage](https://github.com/cdrage))
- Change title to build and push images [\#667](https://github.com/kubernetes/kompose/pull/667) ([cdrage](https://github.com/cdrage))
- added support for `restart-policy` keys in v3 [\#666](https://github.com/kubernetes/kompose/pull/666) ([surajnarwade](https://github.com/surajnarwade))
- Added support for `replicas` keys in v3 [\#664](https://github.com/kubernetes/kompose/pull/664) ([surajnarwade](https://github.com/surajnarwade))
- Update vendoring for Cobra CLI fix [\#663](https://github.com/kubernetes/kompose/pull/663) ([cdrage](https://github.com/cdrage))
- Removing unused function taggedimage [\#662](https://github.com/kubernetes/kompose/pull/662) ([surajnarwade](https://github.com/surajnarwade))
- Fix vet issues with build/push code [\#660](https://github.com/kubernetes/kompose/pull/660) ([cdrage](https://github.com/cdrage))
- fix env substitution for docker compose v3 [\#658](https://github.com/kubernetes/kompose/pull/658) ([kadel](https://github.com/kadel))
- Changing printf verb in compose\_test.go [\#655](https://github.com/kubernetes/kompose/pull/655) ([procrypt](https://github.com/procrypt))
- Disable dab [\#653](https://github.com/kubernetes/kompose/pull/653) ([cdrage](https://github.com/cdrage))
- Updating Vendor [\#649](https://github.com/kubernetes/kompose/pull/649) ([surajnarwade](https://github.com/surajnarwade))
- Update documentation to reflect build/push and v3 changes [\#648](https://github.com/kubernetes/kompose/pull/648) ([cdrage](https://github.com/cdrage))
- Update ROADMAP [\#645](https://github.com/kubernetes/kompose/pull/645) ([cdrage](https://github.com/cdrage))
- Failing test will show diff [\#638](https://github.com/kubernetes/kompose/pull/638) ([surajnarwade](https://github.com/surajnarwade))
- Add documentation list [\#637](https://github.com/kubernetes/kompose/pull/637) ([cdrage](https://github.com/cdrage))
- Change output examples in docs to new format [\#635](https://github.com/kubernetes/kompose/pull/635) ([cdrage](https://github.com/cdrage))
- Update widgets \(add godoc\) as well as README [\#634](https://github.com/kubernetes/kompose/pull/634) ([cdrage](https://github.com/cdrage))
- Fix EnvSort struct [\#631](https://github.com/kubernetes/kompose/pull/631) ([procrypt](https://github.com/procrypt))
- Remove jekyll format from top of quickstart [\#630](https://github.com/kubernetes/kompose/pull/630) ([cdrage](https://github.com/cdrage))
- Fix adding Jekyll format to the top [\#629](https://github.com/kubernetes/kompose/pull/629) ([cdrage](https://github.com/cdrage))
- Update documentation to reflect quickstart [\#628](https://github.com/kubernetes/kompose/pull/628) ([cdrage](https://github.com/cdrage))
- Update README with only docker compose example [\#622](https://github.com/kubernetes/kompose/pull/622) ([cdrage](https://github.com/cdrage))
- add support for "pid" key [\#617](https://github.com/kubernetes/kompose/pull/617) ([gitlawr](https://github.com/gitlawr))
- Add provider to file output [\#616](https://github.com/kubernetes/kompose/pull/616) ([cdrage](https://github.com/cdrage))
- Remove version column from conversion document [\#615](https://github.com/kubernetes/kompose/pull/615) ([cdrage](https://github.com/cdrage))
- Validate dockerfilepath in buildconfig [\#609](https://github.com/kubernetes/kompose/pull/609) ([surajnarwade](https://github.com/surajnarwade))
- PVC name changes if volumes containes .\(dot\) in it [\#603](https://github.com/kubernetes/kompose/pull/603) ([procrypt](https://github.com/procrypt))
- Add v3 support of Docker Compose [\#600](https://github.com/kubernetes/kompose/pull/600) ([cdrage](https://github.com/cdrage))
- update generated artifacts for k8s and openshift so that env variables are loaded in a particular order [\#596](https://github.com/kubernetes/kompose/pull/596) ([procrypt](https://github.com/procrypt))
- Failing when port is specified with labels [\#590](https://github.com/kubernetes/kompose/pull/590) ([surajnarwade](https://github.com/surajnarwade))
- Adding tests for kompose-specific labels and buildconfig dockerfile construct [\#588](https://github.com/kubernetes/kompose/pull/588) ([ashetty1](https://github.com/ashetty1))
- Add build and push support [\#521](https://github.com/kubernetes/kompose/pull/521) ([cdrage](https://github.com/cdrage))

## [v0.7.0](https://github.com/kubernetes/kompose/tree/v0.7.0) (2017-05-25)

[Full Changelog](https://github.com/kubernetes/kompose/compare/v0.6.0...v0.7.0)

**Closed issues:**

- image tag name absent from generated imagestream config [\#611](https://github.com/kubernetes/kompose/issues/611)
- Volume mount on the host isn't supported  [\#599](https://github.com/kubernetes/kompose/issues/599)
- Is this a case of buildconfig contextDir being incorrectly set? [\#593](https://github.com/kubernetes/kompose/issues/593)
- Problems running tests with latest master? [\#591](https://github.com/kubernetes/kompose/issues/591)
- crashes on launch [\#589](https://github.com/kubernetes/kompose/issues/589)
- Unable to run tests [\#587](https://github.com/kubernetes/kompose/issues/587)
- Latest kompose fails on many build-config tests locally [\#585](https://github.com/kubernetes/kompose/issues/585)
- Fixture regarding build context fails each time [\#576](https://github.com/kubernetes/kompose/issues/576)
- 0.6.0 Release [\#574](https://github.com/kubernetes/kompose/issues/574)
- \[UX\] Sort output when doing kind: list and --stdout [\#554](https://github.com/kubernetes/kompose/issues/554)
- no commit hash in kompose 0.3.0 version information [\#487](https://github.com/kubernetes/kompose/issues/487)
- Inconsistency in build context [\#445](https://github.com/kubernetes/kompose/issues/445)
- Support for: stop\_grace\_period [\#440](https://github.com/kubernetes/kompose/issues/440)
- environment variables not being set in buildConfig [\#406](https://github.com/kubernetes/kompose/issues/406)
- kompose down with openshift doesn't delete  BuildConfig [\#382](https://github.com/kubernetes/kompose/issues/382)

**Merged pull requests:**

- 0.7.0 Release [\#619](https://github.com/kubernetes/kompose/pull/619) ([cdrage](https://github.com/cdrage))
- Update version number in setup.md file in release script [\#618](https://github.com/kubernetes/kompose/pull/618) ([cdrage](https://github.com/cdrage))
- Fix incorrect tag in BuildConfig. [\#613](https://github.com/kubernetes/kompose/pull/613) ([kadel](https://github.com/kadel))
- Update `kompose completion` [\#612](https://github.com/kubernetes/kompose/pull/612) ([cdrage](https://github.com/cdrage))
- Add support for stop\_grace\_period [\#608](https://github.com/kubernetes/kompose/pull/608) ([gitlawr](https://github.com/gitlawr))
- Replace underscores with dashes while rendering container names [\#606](https://github.com/kubernetes/kompose/pull/606) ([achanda](https://github.com/achanda))
- remove duplicate import with different name [\#602](https://github.com/kubernetes/kompose/pull/602) ([surajssd](https://github.com/surajssd))
- Updated Vendoring [\#601](https://github.com/kubernetes/kompose/pull/601) ([surajnarwade](https://github.com/surajnarwade))
- \<docs\> Update version number [\#597](https://github.com/kubernetes/kompose/pull/597) ([cdrage](https://github.com/cdrage))
- Use old git command [\#592](https://github.com/kubernetes/kompose/pull/592) ([cdrage](https://github.com/cdrage))
- Fix link to fedora setup in docs [\#586](https://github.com/kubernetes/kompose/pull/586) ([surajssd](https://github.com/surajssd))
- Release script binary upload bug [\#583](https://github.com/kubernetes/kompose/pull/583) ([cdrage](https://github.com/cdrage))
- Add io.kompose.service label to every object & use reaper to delete BuildConfig [\#578](https://github.com/kubernetes/kompose/pull/578) ([kadel](https://github.com/kadel))
- Fixes fixture test for build context [\#577](https://github.com/kubernetes/kompose/pull/577) ([surajnarwade](https://github.com/surajnarwade))
- sort output when creating kubernetes/openshift objects [\#565](https://github.com/kubernetes/kompose/pull/565) ([procrypt](https://github.com/procrypt))
- Adding kompose up/down tests for openshift [\#460](https://github.com/kubernetes/kompose/pull/460) ([ashetty1](https://github.com/ashetty1))
- Add build\_args support in buildconfig [\#424](https://github.com/kubernetes/kompose/pull/424) ([surajnarwade](https://github.com/surajnarwade))

## [v0.6.0](https://github.com/kubernetes/kompose/tree/v0.6.0) (2017-04-28)

[Full Changelog](https://github.com/kubernetes/kompose/compare/v0.5.0...v0.6.0)

**Closed issues:**

- Support for cap\_add,cap\_drop [\#575](https://github.com/kubernetes/kompose/issues/575)
- commenting test case temporarily  [\#564](https://github.com/kubernetes/kompose/issues/564)
- driver:local in prefixing volumes with current dir name [\#550](https://github.com/kubernetes/kompose/issues/550)
- update docs/conversion.md [\#548](https://github.com/kubernetes/kompose/issues/548)
- Kompose binary for ARM [\#541](https://github.com/kubernetes/kompose/issues/541)
- add documentation about renaming service [\#538](https://github.com/kubernetes/kompose/issues/538)
- Update roadmap wrt to k8s 1.7 release [\#537](https://github.com/kubernetes/kompose/issues/537)
- Unused functions in app.go and utils.go [\#534](https://github.com/kubernetes/kompose/issues/534)
- Timestamps are added again to compose. [\#530](https://github.com/kubernetes/kompose/issues/530)
- kompose down is not deleting ingress and route [\#510](https://github.com/kubernetes/kompose/issues/510)
- mongodb startup problem with simple dockerfile [\#489](https://github.com/kubernetes/kompose/issues/489)
- RFE: kompose up support specified namespace to deploy [\#473](https://github.com/kubernetes/kompose/issues/473)
- Wrong version, again [\#461](https://github.com/kubernetes/kompose/issues/461)
- Normalizing service name might break application [\#433](https://github.com/kubernetes/kompose/issues/433)
- Converting docker-compose file on mac: `panic: runtime error` [\#379](https://github.com/kubernetes/kompose/issues/379)
- Should we not generate PVC's by default? [\#376](https://github.com/kubernetes/kompose/issues/376)
- "Failed to unmarshal MaporSlice" attempt to convert Sentry quick start [\#357](https://github.com/kubernetes/kompose/issues/357)
- CPUSet is read and but do not map to k8s [\#272](https://github.com/kubernetes/kompose/issues/272)
- Support for cpu\_shares [\#267](https://github.com/kubernetes/kompose/issues/267)

**Merged pull requests:**

- 0.6.0 Release [\#582](https://github.com/kubernetes/kompose/pull/582) ([cdrage](https://github.com/cdrage))
- Update the release script again [\#581](https://github.com/kubernetes/kompose/pull/581) ([cdrage](https://github.com/cdrage))
- Add Support for cap\_add & cap\_drop [\#580](https://github.com/kubernetes/kompose/pull/580) ([gitlawr](https://github.com/gitlawr))
- Update PR for ROADMAP [\#579](https://github.com/kubernetes/kompose/pull/579) ([cdrage](https://github.com/cdrage))
- typo in nginx name. [\#570](https://github.com/kubernetes/kompose/pull/570) ([procrypt](https://github.com/procrypt))
- Add warning about change in the service name. [\#569](https://github.com/kubernetes/kompose/pull/569) ([procrypt](https://github.com/procrypt))
- fix output replication-controller and daemon-set [\#568](https://github.com/kubernetes/kompose/pull/568) ([nkysg](https://github.com/nkysg))
- Adds spacing to table [\#567](https://github.com/kubernetes/kompose/pull/567) ([cdrage](https://github.com/cdrage))
- Clarify tarball [\#559](https://github.com/kubernetes/kompose/pull/559) ([cdrage](https://github.com/cdrage))
- Add test dependencies [\#558](https://github.com/kubernetes/kompose/pull/558) ([cdrage](https://github.com/cdrage))
- fix driver:local in prefixing volumes with current dir name [\#557](https://github.com/kubernetes/kompose/pull/557) ([procrypt](https://github.com/procrypt))
- Update doc with better console output and add note on deployment config [\#556](https://github.com/kubernetes/kompose/pull/556) ([cdrage](https://github.com/cdrage))
- Updated conversion doc [\#553](https://github.com/kubernetes/kompose/pull/553) ([surajnarwade](https://github.com/surajnarwade))
- Fixes the headers of the docs [\#552](https://github.com/kubernetes/kompose/pull/552) ([cdrage](https://github.com/cdrage))
- Update document describing release process [\#551](https://github.com/kubernetes/kompose/pull/551) ([kadel](https://github.com/kadel))
- Update ROADMAP [\#549](https://github.com/kubernetes/kompose/pull/549) ([kadel](https://github.com/kadel))
- Support insecure registry and enhance parsing of image stream tag [\#547](https://github.com/kubernetes/kompose/pull/547) ([qujinping](https://github.com/qujinping))
- Add setup.md [\#546](https://github.com/kubernetes/kompose/pull/546) ([cdrage](https://github.com/cdrage))
- Moved cpu\_shares and cpuset to unsupported keys [\#543](https://github.com/kubernetes/kompose/pull/543) ([surajnarwade](https://github.com/surajnarwade))
- Removed unused functions [\#539](https://github.com/kubernetes/kompose/pull/539) ([surajnarwade](https://github.com/surajnarwade))
- new take on "Kompose will keep trying its job \#477" [\#536](https://github.com/kubernetes/kompose/pull/536) ([kadel](https://github.com/kadel))
- Only ignore the docker-compose yaml file in the root directory [\#533](https://github.com/kubernetes/kompose/pull/533) ([cdrage](https://github.com/cdrage))
- Move docker-compose.yml test file to tests [\#531](https://github.com/kubernetes/kompose/pull/531) ([cdrage](https://github.com/cdrage))
- Fix the examples [\#528](https://github.com/kubernetes/kompose/pull/528) ([cdrage](https://github.com/cdrage))
- Update contributing doc for reviewing, update owners file [\#527](https://github.com/kubernetes/kompose/pull/527) ([cdrage](https://github.com/cdrage))
- Remove unused parameters from Kompose down [\#523](https://github.com/kubernetes/kompose/pull/523) ([cdrage](https://github.com/cdrage))
- Added warning after PVC creation [\#519](https://github.com/kubernetes/kompose/pull/519) ([surajnarwade](https://github.com/surajnarwade))
- Added support for different namespaces [\#517](https://github.com/kubernetes/kompose/pull/517) ([procrypt](https://github.com/procrypt))
- add missing 'io.kompose.service' label to Route and Ingress [\#511](https://github.com/kubernetes/kompose/pull/511) ([kadel](https://github.com/kadel))
- Added consistency in build context [\#454](https://github.com/kubernetes/kompose/pull/454) ([surajnarwade](https://github.com/surajnarwade))

## [v0.5.0](https://github.com/kubernetes/kompose/tree/v0.5.0) (2017-04-04)

[Full Changelog](https://github.com/kubernetes/kompose/compare/v0.4.0...v0.5.0)

**Closed issues:**

- kompose fails to build on ppc64 and ppc64le arches due to old sys/unix vendor package [\#532](https://github.com/kubernetes/kompose/issues/532)
- unused global constants in convert.go [\#513](https://github.com/kubernetes/kompose/issues/513)
- `kompose up` fails with restart options on openshift [\#505](https://github.com/kubernetes/kompose/issues/505)
- 0.4.0 release [\#501](https://github.com/kubernetes/kompose/issues/501)
- remove extends from unsupported keys [\#493](https://github.com/kubernetes/kompose/issues/493)
- kompose should respect the dockerfile key in docker-compose.yml [\#486](https://github.com/kubernetes/kompose/issues/486)
- Add Fedora packaging data to Kompose repo [\#481](https://github.com/kubernetes/kompose/issues/481)
- extends is supported construct but conversion doc says opposite [\#475](https://github.com/kubernetes/kompose/issues/475)
- stripping kompose binary? [\#463](https://github.com/kubernetes/kompose/issues/463)
- test showing PASS, even if command not found [\#431](https://github.com/kubernetes/kompose/issues/431)
- underscores get propagated into invalid names [\#420](https://github.com/kubernetes/kompose/issues/420)
- Unsupported root level networks key despite no networks [\#365](https://github.com/kubernetes/kompose/issues/365)
- Make kompose keep trying its job [\#270](https://github.com/kubernetes/kompose/issues/270)
- Improving `down` to handle Volumes [\#255](https://github.com/kubernetes/kompose/issues/255)
- Add tests based on current issues [\#205](https://github.com/kubernetes/kompose/issues/205)
- We should have a table / document for docker-compose to k8s / openshift conversion   [\#82](https://github.com/kubernetes/kompose/issues/82)

**Merged pull requests:**

- 0.5.0 release [\#542](https://github.com/kubernetes/kompose/pull/542) ([cdrage](https://github.com/cdrage))
- Add ARM to make cross. [\#540](https://github.com/kubernetes/kompose/pull/540) ([cdrage](https://github.com/cdrage))
- Revert "Kompose will keep trying its job" [\#535](https://github.com/kubernetes/kompose/pull/535) ([cdrage](https://github.com/cdrage))
- Update vendoring + fix issue with timestamps being added to log [\#529](https://github.com/kubernetes/kompose/pull/529) ([cdrage](https://github.com/cdrage))
- Fixed functional tests [\#526](https://github.com/kubernetes/kompose/pull/526) ([surajnarwade](https://github.com/surajnarwade))
- Fix typo in tarball link in readme [\#525](https://github.com/kubernetes/kompose/pull/525) ([cdrage](https://github.com/cdrage))
- Fix typo in replicas and organize flags [\#524](https://github.com/kubernetes/kompose/pull/524) ([cdrage](https://github.com/cdrage))
- Removing unused variable from convert.go [\#520](https://github.com/kubernetes/kompose/pull/520) ([surajnarwade](https://github.com/surajnarwade))
- Ignore Docker Compose files in the root directory [\#516](https://github.com/kubernetes/kompose/pull/516) ([cdrage](https://github.com/cdrage))
- Fix the DAB spelling error [\#515](https://github.com/kubernetes/kompose/pull/515) ([cdrage](https://github.com/cdrage))
- Fixes image \(uses / to get the root dir\) [\#512](https://github.com/kubernetes/kompose/pull/512) ([cdrage](https://github.com/cdrage))
- Propagate underscore into valid name [\#509](https://github.com/kubernetes/kompose/pull/509) ([procrypt](https://github.com/procrypt))
- Update minor bug in syncing files [\#508](https://github.com/kubernetes/kompose/pull/508) ([cdrage](https://github.com/cdrage))
- Update the readme with tarball and installation instructions [\#507](https://github.com/kubernetes/kompose/pull/507) ([cdrage](https://github.com/cdrage))
- Removed Duplicate line\(build\) from compose.go [\#504](https://github.com/kubernetes/kompose/pull/504) ([surajnarwade](https://github.com/surajnarwade))
- Ignore the /bin folder [\#503](https://github.com/kubernetes/kompose/pull/503) ([cdrage](https://github.com/cdrage))
- Sync changes from master to gh-pages on each merge request [\#500](https://github.com/kubernetes/kompose/pull/500) ([cdrage](https://github.com/cdrage))
- Added dockerfile key support [\#499](https://github.com/kubernetes/kompose/pull/499) ([surajnarwade](https://github.com/surajnarwade))
- Add rpm packaging [\#495](https://github.com/kubernetes/kompose/pull/495) ([cdrage](https://github.com/cdrage))
- Remove extend from unused keys, add to conversion doc [\#494](https://github.com/kubernetes/kompose/pull/494) ([cdrage](https://github.com/cdrage))
- delete objects based on label [\#483](https://github.com/kubernetes/kompose/pull/483) ([procrypt](https://github.com/procrypt))
- Kompose will keep trying its job [\#477](https://github.com/kubernetes/kompose/pull/477) ([surajnarwade](https://github.com/surajnarwade))

## [v0.4.0](https://github.com/kubernetes/kompose/tree/v0.4.0) (2017-03-21)

[Full Changelog](https://github.com/kubernetes/kompose/compare/v0.3.0...v0.4.0)

**Closed issues:**

- Update unsupported keys in kompose.io user guide [\#479](https://github.com/kubernetes/kompose/issues/479)
- Adding `networks:` results in a panic [\#478](https://github.com/kubernetes/kompose/issues/478)
- `volumes\_from` is supported construct but conversion doc says opposite [\#476](https://github.com/kubernetes/kompose/issues/476)
- Panics parsing volume config [\#471](https://github.com/kubernetes/kompose/issues/471)
- Error with unsupported keys not showing up in warnings [\#456](https://github.com/kubernetes/kompose/issues/456)
- Separate key:"value" pairs in kobject.go [\#452](https://github.com/kubernetes/kompose/issues/452)
- Support for: volumes\_from [\#444](https://github.com/kubernetes/kompose/issues/444)
- Support for: ulimits [\#442](https://github.com/kubernetes/kompose/issues/442)
- Error / Support for: links [\#439](https://github.com/kubernetes/kompose/issues/439)
- Support for: tmpfs [\#436](https://github.com/kubernetes/kompose/issues/436)
- Add documentation for mem\_limit [\#435](https://github.com/kubernetes/kompose/issues/435)
- .env file is checked at current directory instead of target directory [\#426](https://github.com/kubernetes/kompose/issues/426)
- Unable to build from source [\#421](https://github.com/kubernetes/kompose/issues/421)
- Tagging for 0.2.1 release [\#400](https://github.com/kubernetes/kompose/issues/400)

**Merged pull requests:**

- 0.4.0 release [\#502](https://github.com/kubernetes/kompose/pull/502) ([cdrage](https://github.com/cdrage))
- do not fail if there is a golint violation [\#498](https://github.com/kubernetes/kompose/pull/498) ([kadel](https://github.com/kadel))
- travis-ci: send report to coveralls in after\_success section [\#497](https://github.com/kubernetes/kompose/pull/497) ([kadel](https://github.com/kadel))
- Add install instruction for MacOS X \(using brew\) [\#492](https://github.com/kubernetes/kompose/pull/492) ([kadel](https://github.com/kadel))
- Add that we support volumes\_from [\#491](https://github.com/kubernetes/kompose/pull/491) ([cdrage](https://github.com/cdrage))
- Update vendoring [\#490](https://github.com/kubernetes/kompose/pull/490) ([cdrage](https://github.com/cdrage))
- Add three-week cycle comment to README [\#488](https://github.com/kubernetes/kompose/pull/488) ([cdrage](https://github.com/cdrage))
- Update the link to the conversion doc [\#485](https://github.com/kubernetes/kompose/pull/485) ([cdrage](https://github.com/cdrage))
- Added support for tmpfs [\#484](https://github.com/kubernetes/kompose/pull/484) ([surajnarwade](https://github.com/surajnarwade))
- Add cap\_add and cap\_drop to unsupported keys [\#468](https://github.com/kubernetes/kompose/pull/468) ([kadel](https://github.com/kadel))
- Minor fix on user guide [\#466](https://github.com/kubernetes/kompose/pull/466) ([cdrage](https://github.com/cdrage))
- Update release script [\#465](https://github.com/kubernetes/kompose/pull/465) ([cdrage](https://github.com/cdrage))
- Improve error handling, fix \#416 [\#462](https://github.com/kubernetes/kompose/pull/462) ([concaf](https://github.com/concaf))
- unsupported keys [\#459](https://github.com/kubernetes/kompose/pull/459) ([procrypt](https://github.com/procrypt))
- Clean up logrus [\#455](https://github.com/kubernetes/kompose/pull/455) ([cdrage](https://github.com/cdrage))
- Update the README with -u in go get [\#453](https://github.com/kubernetes/kompose/pull/453) ([cdrage](https://github.com/cdrage))
- Update the release script again :\) [\#451](https://github.com/kubernetes/kompose/pull/451) ([cdrage](https://github.com/cdrage))
- Add conversion documentation [\#448](https://github.com/kubernetes/kompose/pull/448) ([cdrage](https://github.com/cdrage))

## [v0.3.0](https://github.com/kubernetes/kompose/tree/v0.3.0) (2017-02-24)

[Full Changelog](https://github.com/kubernetes/kompose/compare/v0.2.0...v0.3.0)

**Closed issues:**

- `make test-unit` does not run on uncomitted changes [\#427](https://github.com/kubernetes/kompose/issues/427)
- Improve error handling [\#416](https://github.com/kubernetes/kompose/issues/416)
- Wrong version \(0.1.2\) in "kompose versione" \(instead of 0.2.0\) [\#411](https://github.com/kubernetes/kompose/issues/411)
- Cannot unmarshal float environment values. [\#410](https://github.com/kubernetes/kompose/issues/410)
- unit tests for error out if controller object is specified with restart: on-failure. [\#404](https://github.com/kubernetes/kompose/issues/404)
- By default, remove protocol: TCP in conversion to artifacts [\#392](https://github.com/kubernetes/kompose/issues/392)
- Container Port and Node Port mapping default to open [\#391](https://github.com/kubernetes/kompose/issues/391)
- panic on using --build-branch and default docker-compose file given [\#369](https://github.com/kubernetes/kompose/issues/369)
- error should be displayed If controller object is specified  and `restart: on-failure`  [\#354](https://github.com/kubernetes/kompose/issues/354)
- add support for docker-compose.yaml besides docker-compose.yml [\#352](https://github.com/kubernetes/kompose/issues/352)
- Abstract out api.PodSpec in kubernetes.go [\#348](https://github.com/kubernetes/kompose/issues/348)
- Support for host:container:protocol [\#335](https://github.com/kubernetes/kompose/issues/335)
- Detecting exposed ports in images [\#146](https://github.com/kubernetes/kompose/issues/146)
- bash completion for kompose  [\#37](https://github.com/kubernetes/kompose/issues/37)

**Merged pull requests:**

- 0.3.0 Release [\#450](https://github.com/kubernetes/kompose/pull/450) ([cdrage](https://github.com/cdrage))
- Test with multiple go versions [\#449](https://github.com/kubernetes/kompose/pull/449) ([kadel](https://github.com/kadel))
- Abstract out api.pod spec [\#434](https://github.com/kubernetes/kompose/pull/434) ([procrypt](https://github.com/procrypt))
- normalize docker-compose service that has name with underscore [\#429](https://github.com/kubernetes/kompose/pull/429) ([surajssd](https://github.com/surajssd))
- removed unnecessary objects in compose.go [\#428](https://github.com/kubernetes/kompose/pull/428) ([surajssd](https://github.com/surajssd))
- Update vendoring [\#425](https://github.com/kubernetes/kompose/pull/425) ([cdrage](https://github.com/cdrage))
- fix passing gitcommit in version output [\#423](https://github.com/kubernetes/kompose/pull/423) ([kadel](https://github.com/kadel))
- Update Makefile - lazy set for PKGS variable [\#418](https://github.com/kubernetes/kompose/pull/418) ([kadel](https://github.com/kadel))
- Fix a small spelling error [\#415](https://github.com/kubernetes/kompose/pull/415) ([cdrage](https://github.com/cdrage))
- Adds mem\_limit support for conversion [\#414](https://github.com/kubernetes/kompose/pull/414) ([cdrage](https://github.com/cdrage))
- add BuildConfig support to kompose down [\#413](https://github.com/kubernetes/kompose/pull/413) ([procrypt](https://github.com/procrypt))
- Unit tests for error out if controller object is specified with restart: on-failure [\#405](https://github.com/kubernetes/kompose/pull/405) ([procrypt](https://github.com/procrypt))
- Update the README.md with new installation instructions [\#399](https://github.com/kubernetes/kompose/pull/399) ([cdrage](https://github.com/cdrage))
- Updates the cross compiling commands [\#397](https://github.com/kubernetes/kompose/pull/397) ([cdrage](https://github.com/cdrage))
- Update the release script [\#396](https://github.com/kubernetes/kompose/pull/396) ([cdrage](https://github.com/cdrage))
- Removes the TCP output on the Kubernetes / OpenShift artifacts [\#394](https://github.com/kubernetes/kompose/pull/394) ([cdrage](https://github.com/cdrage))
- Add support for host:port:port [\#393](https://github.com/kubernetes/kompose/pull/393) ([cdrage](https://github.com/cdrage))
- change strategy to recreate if volumes present, fix \#264 [\#378](https://github.com/kubernetes/kompose/pull/378) ([concaf](https://github.com/concaf))
- error out if controller object is specified with "restart: on-failure" [\#373](https://github.com/kubernetes/kompose/pull/373) ([procrypt](https://github.com/procrypt))
- added support for docker-compose.yaml besides docker-compose.yml [\#368](https://github.com/kubernetes/kompose/pull/368) ([procrypt](https://github.com/procrypt))

## [v0.2.0](https://github.com/kubernetes/kompose/tree/v0.2.0) (2017-01-27)

[Full Changelog](https://github.com/kubernetes/kompose/compare/v0.1.2...v0.2.0)

**Closed issues:**

- error: Could not unmarshal '\<nil\>' to type \<nil\> [\#388](https://github.com/kubernetes/kompose/issues/388)
- add support for mem\_limit in kompose [\#364](https://github.com/kubernetes/kompose/issues/364)
- cmd tests written after `convert::files\_exist` does not pass [\#361](https://github.com/kubernetes/kompose/issues/361)
- disable coveralls.io comments [\#358](https://github.com/kubernetes/kompose/issues/358)
- support for stdin\_open and tty keys [\#344](https://github.com/kubernetes/kompose/issues/344)
- fix unit tests that cause warnings [\#343](https://github.com/kubernetes/kompose/issues/343)
- kompose up/down not creating/deleting POD object generated with convert [\#342](https://github.com/kubernetes/kompose/issues/342)
- yml support [\#336](https://github.com/kubernetes/kompose/issues/336)
- Removing unconventional two letter flags + adding dashes in-between two letter words. [\#331](https://github.com/kubernetes/kompose/issues/331)
- Determine group membership [\#327](https://github.com/kubernetes/kompose/issues/327)
- kompose errors identifying string in docker-compose [\#320](https://github.com/kubernetes/kompose/issues/320)
- restart: Unsupported value: "OnFailure": supported values: Always  [\#318](https://github.com/kubernetes/kompose/issues/318)
- Update roadmap / split into ROADMAP.md with relevant information [\#315](https://github.com/kubernetes/kompose/issues/315)
- Replace godep with glide [\#314](https://github.com/kubernetes/kompose/issues/314)
- Unable to run cmd tests under Debian. [\#309](https://github.com/kubernetes/kompose/issues/309)
- Default to YAML output [\#306](https://github.com/kubernetes/kompose/issues/306)
- kompose 0.1.2 fails to parse key-only variables in environment section, does work with lists but generates invalid k8s resources [\#303](https://github.com/kubernetes/kompose/issues/303)
- When using `container\_name` in docker-compose problems with dc and imagestreams [\#301](https://github.com/kubernetes/kompose/issues/301)
- make `script/godep-restore.sh` more verbose [\#300](https://github.com/kubernetes/kompose/issues/300)
- no test/check for Godeps.json health [\#299](https://github.com/kubernetes/kompose/issues/299)
- `script/godep-restore.sh` is failing on master [\#298](https://github.com/kubernetes/kompose/issues/298)
- Stdout shouldn't output warning / logging messages. [\#295](https://github.com/kubernetes/kompose/issues/295)
- A better missing port warning message [\#291](https://github.com/kubernetes/kompose/issues/291)
- `--output`, or specify folder to output converted files to [\#288](https://github.com/kubernetes/kompose/issues/288)
- Add coveralls [\#281](https://github.com/kubernetes/kompose/issues/281)
- Support multiple compose files [\#275](https://github.com/kubernetes/kompose/issues/275)
- specifying service type right now is very docker-compose specific [\#273](https://github.com/kubernetes/kompose/issues/273)
- Tiny issue on kompose up --emptyvols displaying [\#268](https://github.com/kubernetes/kompose/issues/268)
- Update README  [\#265](https://github.com/kubernetes/kompose/issues/265)
- Change strategy for Deployments/DeployementConfigs [\#264](https://github.com/kubernetes/kompose/issues/264)
- Issues regarding CLI. Perhaps switching to Cobra? [\#253](https://github.com/kubernetes/kompose/issues/253)
- Track release goals with GitHub milestones [\#250](https://github.com/kubernetes/kompose/issues/250)
- Why do tests take so long to run? [\#247](https://github.com/kubernetes/kompose/issues/247)
- User directive from docker-compose is siletly ignored [\#244](https://github.com/kubernetes/kompose/issues/244)
- Add missing tests and documentations for "Service type" PR [\#242](https://github.com/kubernetes/kompose/issues/242)
- CLI exit code on error [\#239](https://github.com/kubernetes/kompose/issues/239)
- ReadWriteOnce set even when volume is "ro" [\#237](https://github.com/kubernetes/kompose/issues/237)
- Raw Pod output [\#234](https://github.com/kubernetes/kompose/issues/234)
- Invoking kompose --bundle X.dab convert --stdout will produce two differently ordered results [\#231](https://github.com/kubernetes/kompose/issues/231)
- Switch Copyright [\#223](https://github.com/kubernetes/kompose/issues/223)
- Add `go vet` [\#215](https://github.com/kubernetes/kompose/issues/215)
- being able to store artifacts separately in a specific directory [\#209](https://github.com/kubernetes/kompose/issues/209)
- kompose down for OpenShift [\#208](https://github.com/kubernetes/kompose/issues/208)
- establish release process - protect master branch [\#192](https://github.com/kubernetes/kompose/issues/192)
- Fixtures directory has README.md that are incomplete or inconsistent [\#177](https://github.com/kubernetes/kompose/issues/177)
- docker-compose :Z not supported in volume mounts [\#176](https://github.com/kubernetes/kompose/issues/176)
- Add tests converting dab files [\#167](https://github.com/kubernetes/kompose/issues/167)
- integration with minikube/minishift [\#156](https://github.com/kubernetes/kompose/issues/156)
- compose2kube [\#151](https://github.com/kubernetes/kompose/issues/151)
- Creating Routes for Services  [\#140](https://github.com/kubernetes/kompose/issues/140)
- Support BuildConfigs for openshift provider [\#96](https://github.com/kubernetes/kompose/issues/96)
- Image name not given still kompose does not errors out [\#92](https://github.com/kubernetes/kompose/issues/92)
- Validate input args  [\#87](https://github.com/kubernetes/kompose/issues/87)
- specify Deployment policy [\#17](https://github.com/kubernetes/kompose/issues/17)

**Merged pull requests:**

- 0.2.0 Release [\#395](https://github.com/kubernetes/kompose/pull/395) ([cdrage](https://github.com/cdrage))
- Update documentation removing \[0000\] timestamp outputs [\#389](https://github.com/kubernetes/kompose/pull/389) ([cdrage](https://github.com/cdrage))
- Ignores :z or :Z when passed in as a volume string [\#387](https://github.com/kubernetes/kompose/pull/387) ([cdrage](https://github.com/cdrage))
- Container for running tests and Makefile cleanup [\#385](https://github.com/kubernetes/kompose/pull/385) ([kadel](https://github.com/kadel))
- Update logging for logrus [\#383](https://github.com/kubernetes/kompose/pull/383) ([cdrage](https://github.com/cdrage))
- Fixed warnings related to user type in tests [\#380](https://github.com/kubernetes/kompose/pull/380) ([surajssd](https://github.com/surajssd))
- bump libcompose to v0.4.0 [\#377](https://github.com/kubernetes/kompose/pull/377) ([concaf](https://github.com/concaf))
- updated pods example in user guide [\#371](https://github.com/kubernetes/kompose/pull/371) ([surajssd](https://github.com/surajssd))
- Add bash auto completion support [\#370](https://github.com/kubernetes/kompose/pull/370) ([cdrage](https://github.com/cdrage))
- add deploy/undeploy pod only [\#363](https://github.com/kubernetes/kompose/pull/363) ([ngtuna](https://github.com/ngtuna))
- Fixing functional tests for checking generated artifacts [\#362](https://github.com/kubernetes/kompose/pull/362) ([surajssd](https://github.com/surajssd))
- Small simplification of kubernetes.PrintList [\#360](https://github.com/kubernetes/kompose/pull/360) ([kadel](https://github.com/kadel))
- update roadmap [\#359](https://github.com/kubernetes/kompose/pull/359) ([kadel](https://github.com/kadel))
- Update vendoring as well as libcompose [\#356](https://github.com/kubernetes/kompose/pull/356) ([cdrage](https://github.com/cdrage))
- add stdin\_open, tty support, add tests, fix \#344 [\#350](https://github.com/kubernetes/kompose/pull/350) ([concaf](https://github.com/concaf))
- Flag validation called on up and down [\#347](https://github.com/kubernetes/kompose/pull/347) ([surajssd](https://github.com/surajssd))
- updated dev docs with latest instructions [\#341](https://github.com/kubernetes/kompose/pull/341) ([surajssd](https://github.com/surajssd))
- update vendored dependencies [\#340](https://github.com/kubernetes/kompose/pull/340) ([surajssd](https://github.com/surajssd))
- make YAML the default kompose conversion  [\#339](https://github.com/kubernetes/kompose/pull/339) ([procrypt](https://github.com/procrypt))
- \#231 Invoking kompose --bundle X.dab convert --stdout will produce tw… [\#338](https://github.com/kubernetes/kompose/pull/338) ([cab105](https://github.com/cab105))
- implement storing to directory or file, add functional tests [\#337](https://github.com/kubernetes/kompose/pull/337) ([concaf](https://github.com/concaf))
- support for raw pod output without controller [\#334](https://github.com/kubernetes/kompose/pull/334) ([surajssd](https://github.com/surajssd))
- Fix container\_name incorrectly being generated [\#333](https://github.com/kubernetes/kompose/pull/333) ([cdrage](https://github.com/cdrage))
- Update RPM instalaion instructions in README.md [\#332](https://github.com/kubernetes/kompose/pull/332) ([kadel](https://github.com/kadel))
- Report code coverage to coveralls [\#329](https://github.com/kubernetes/kompose/pull/329) ([kadel](https://github.com/kadel))
- Add ROADMAP.md move current road map information [\#326](https://github.com/kubernetes/kompose/pull/326) ([cdrage](https://github.com/cdrage))
- Unsupported keys per provider [\#324](https://github.com/kubernetes/kompose/pull/324) ([rtnpro](https://github.com/rtnpro))
- Added installation instructions of rpm [\#322](https://github.com/kubernetes/kompose/pull/322) ([surajssd](https://github.com/surajssd))
- IntelliJ IDE .gitignore [\#321](https://github.com/kubernetes/kompose/pull/321) ([surajssd](https://github.com/surajssd))
- Switch from godep to glide [\#319](https://github.com/kubernetes/kompose/pull/319) ([kadel](https://github.com/kadel))
- support parse key-only environment variable [\#317](https://github.com/kubernetes/kompose/pull/317) ([ngtuna](https://github.com/ngtuna))
- Add release script [\#316](https://github.com/kubernetes/kompose/pull/316) ([cdrage](https://github.com/cdrage))
- added support for multiple-compose files [\#312](https://github.com/kubernetes/kompose/pull/312) ([procrypt](https://github.com/procrypt))
- add golint check to travis-ci [\#307](https://github.com/kubernetes/kompose/pull/307) ([kadel](https://github.com/kadel))
- Remove trailing slash [\#305](https://github.com/kubernetes/kompose/pull/305) ([cdrage](https://github.com/cdrage))
- Switch to spf13/cobra from urfave/cli [\#304](https://github.com/kubernetes/kompose/pull/304) ([cdrage](https://github.com/cdrage))
- Switch to 'make bin' instead of 'make binary' [\#302](https://github.com/kubernetes/kompose/pull/302) ([cdrage](https://github.com/cdrage))
- Added volume to mariadb in etherpad fixture [\#293](https://github.com/kubernetes/kompose/pull/293) ([surajssd](https://github.com/surajssd))
- Update .dsb to .dab [\#290](https://github.com/kubernetes/kompose/pull/290) ([cdrage](https://github.com/cdrage))
- Clean up the logging output for unknown provider [\#289](https://github.com/kubernetes/kompose/pull/289) ([cdrage](https://github.com/cdrage))
- Update TRAVIS CI to add coveralls [\#287](https://github.com/kubernetes/kompose/pull/287) ([cdrage](https://github.com/cdrage))
- Minor doc fix [\#286](https://github.com/kubernetes/kompose/pull/286) ([concaf](https://github.com/concaf))
- expose service to outside, fix \#140 [\#285](https://github.com/kubernetes/kompose/pull/285) ([concaf](https://github.com/concaf))
- Organize the README. [\#284](https://github.com/kubernetes/kompose/pull/284) ([cdrage](https://github.com/cdrage))
- Update README since Kompose is now Go gettable [\#282](https://github.com/kubernetes/kompose/pull/282) ([cdrage](https://github.com/cdrage))
- added support for OpenShift down [\#280](https://github.com/kubernetes/kompose/pull/280) ([procrypt](https://github.com/procrypt))
- Added flag definitions for kompose \#37 [\#279](https://github.com/kubernetes/kompose/pull/279) ([cab105](https://github.com/cab105))
- Generic service type handler for kompose [\#277](https://github.com/kubernetes/kompose/pull/277) ([surajssd](https://github.com/surajssd))
- Update docker-gitlab example [\#271](https://github.com/kubernetes/kompose/pull/271) ([ngtuna](https://github.com/ngtuna))
- correct display when using --emptyvols [\#269](https://github.com/kubernetes/kompose/pull/269) ([ngtuna](https://github.com/ngtuna))
- Update main.go path [\#266](https://github.com/kubernetes/kompose/pull/266) ([procrypt](https://github.com/procrypt))
- Fix license headers, This closes \#223 [\#262](https://github.com/kubernetes/kompose/pull/262) ([sebgoa](https://github.com/sebgoa))
- Modify command in initializing unit tests [\#261](https://github.com/kubernetes/kompose/pull/261) ([cdrage](https://github.com/cdrage))
- update CHANGELOG [\#260](https://github.com/kubernetes/kompose/pull/260) ([ngtuna](https://github.com/ngtuna))
- Add `go vet`,  and `gofmt` tests. [\#259](https://github.com/kubernetes/kompose/pull/259) ([kadel](https://github.com/kadel))
- CreatePVC: correct setting of read/only access [\#249](https://github.com/kubernetes/kompose/pull/249) ([dustymabe](https://github.com/dustymabe))
- Tests for CreateService and annotations [\#246](https://github.com/kubernetes/kompose/pull/246) ([cdrage](https://github.com/cdrage))
- Add support for user directive [\#245](https://github.com/kubernetes/kompose/pull/245) ([kadel](https://github.com/kadel))
- Generate buildconfig for Openshift [\#206](https://github.com/kubernetes/kompose/pull/206) ([rtnpro](https://github.com/rtnpro))
- Handle Headless Services when no ports are present [\#157](https://github.com/kubernetes/kompose/pull/157) ([sebgoa](https://github.com/sebgoa))

## [v0.1.2](https://github.com/kubernetes/kompose/tree/v0.1.2) (2016-10-31)

[Full Changelog](https://github.com/kubernetes/kompose/compare/v0.1.1...v0.1.2)

**Closed issues:**

- can't `make binary-cross` at HEAD [\#256](https://github.com/kubernetes/kompose/issues/256)
- reporting deployment when it should be deploymentConfig [\#251](https://github.com/kubernetes/kompose/issues/251)
- Remove experimental tag [\#228](https://github.com/kubernetes/kompose/issues/228)
- provide easy option for users in setup without PVs [\#226](https://github.com/kubernetes/kompose/issues/226)
- Switch slack channel to official kubernetes slack [\#222](https://github.com/kubernetes/kompose/issues/222)
- PVCs are not created when calling `kompose up` [\#218](https://github.com/kubernetes/kompose/issues/218)
- Make go get'able \(or at least go installable\) [\#216](https://github.com/kubernetes/kompose/issues/216)
- compose constructs we support are still there in unsupportedKey [\#207](https://github.com/kubernetes/kompose/issues/207)
- panic: runtime error: invalid memory address or nil pointer dereference [\#202](https://github.com/kubernetes/kompose/issues/202)
- wrong global --bundle/--dab input [\#198](https://github.com/kubernetes/kompose/issues/198)
- Parsing environment variables with `:` [\#196](https://github.com/kubernetes/kompose/issues/196)
- script/godep-restore.sh doesn't seem to work correctly [\#194](https://github.com/kubernetes/kompose/issues/194)
- error on extraneous/unexpected cli input [\#193](https://github.com/kubernetes/kompose/issues/193)
- Documentation site [\#185](https://github.com/kubernetes/kompose/issues/185)
- upgrade libcompose revision [\#174](https://github.com/kubernetes/kompose/issues/174)
- go panic when converting hygieia docker-compose [\#173](https://github.com/kubernetes/kompose/issues/173)
- time-out errors while deleting deployments on openshift [\#165](https://github.com/kubernetes/kompose/issues/165)
- RFE: choosing Service type [\#154](https://github.com/kubernetes/kompose/issues/154)
- Ignoring network definitions [\#149](https://github.com/kubernetes/kompose/issues/149)
- Add warnings/error for image not specified  [\#80](https://github.com/kubernetes/kompose/issues/80)
- \[Discuss\] Find a good way to vendoring dependencies [\#43](https://github.com/kubernetes/kompose/issues/43)
- new behavior of `kompose up` [\#40](https://github.com/kubernetes/kompose/issues/40)

**Merged pull requests:**

- v0.1.2 [\#258](https://github.com/kubernetes/kompose/pull/258) ([ngtuna](https://github.com/ngtuna))
- binary-cross build [\#257](https://github.com/kubernetes/kompose/pull/257) ([ngtuna](https://github.com/ngtuna))
- Match case with API objects when printing to terminal [\#254](https://github.com/kubernetes/kompose/pull/254) ([dustymabe](https://github.com/dustymabe))
- Add documentation on recent labels feature [\#252](https://github.com/kubernetes/kompose/pull/252) ([cdrage](https://github.com/cdrage))
- Adding support for choosing empty volumes [\#248](https://github.com/kubernetes/kompose/pull/248) ([dustymabe](https://github.com/dustymabe))
- Add VIM git ignore information [\#243](https://github.com/kubernetes/kompose/pull/243) ([cdrage](https://github.com/cdrage))
- Add tests converting dab files [\#241](https://github.com/kubernetes/kompose/pull/241) ([cab105](https://github.com/cab105))
- Make OpenShift inherit from Kubernetes [\#240](https://github.com/kubernetes/kompose/pull/240) ([dustymabe](https://github.com/dustymabe))
- update unsupported key list [\#230](https://github.com/kubernetes/kompose/pull/230) ([ngtuna](https://github.com/ngtuna))
- remove tag experimental [\#229](https://github.com/kubernetes/kompose/pull/229) ([ngtuna](https://github.com/ngtuna))
- make kompose go get-able [\#227](https://github.com/kubernetes/kompose/pull/227) ([ngtuna](https://github.com/ngtuna))
- readme: update slack info [\#225](https://github.com/kubernetes/kompose/pull/225) ([dustymabe](https://github.com/dustymabe))
- wrong global --bundle/--dab input \#198 [\#221](https://github.com/kubernetes/kompose/pull/221) ([cab105](https://github.com/cab105))
- kompose up/down create and delete pvc [\#220](https://github.com/kubernetes/kompose/pull/220) ([surajssd](https://github.com/surajssd))
- remove skippbox reference in usage [\#213](https://github.com/kubernetes/kompose/pull/213) ([sebgoa](https://github.com/sebgoa))
- Update imports to reflect move to kubernetes-incubator [\#212](https://github.com/kubernetes/kompose/pull/212) ([kadel](https://github.com/kadel))
- remove unknown args and added tests [\#211](https://github.com/kubernetes/kompose/pull/211) ([procrypt](https://github.com/procrypt))
- Meeting info to README.md [\#204](https://github.com/kubernetes/kompose/pull/204) ([surajssd](https://github.com/surajssd))
- Update to 0.1.1 in README [\#203](https://github.com/kubernetes/kompose/pull/203) ([cdrage](https://github.com/cdrage))
- update README with SIG-APPS and Champion [\#201](https://github.com/kubernetes/kompose/pull/201) ([sebgoa](https://github.com/sebgoa))
- Kompose up for OpenShift [\#200](https://github.com/kubernetes/kompose/pull/200) ([kadel](https://github.com/kadel))
- fix golang.org/x/net vendoring [\#199](https://github.com/kubernetes/kompose/pull/199) ([kadel](https://github.com/kadel))
- support both : and = as compose envvar separators [\#197](https://github.com/kubernetes/kompose/pull/197) ([ngtuna](https://github.com/ngtuna))
- upgrade libcompose [\#195](https://github.com/kubernetes/kompose/pull/195) ([ngtuna](https://github.com/ngtuna))
- support for volumes\_from docker-compose construct [\#190](https://github.com/kubernetes/kompose/pull/190) ([surajssd](https://github.com/surajssd))
- Configure service types [\#189](https://github.com/kubernetes/kompose/pull/189) ([procrypt](https://github.com/procrypt))

## [v0.1.1](https://github.com/kubernetes/kompose/tree/v0.1.1) (2016-10-06)

[Full Changelog](https://github.com/kubernetes/kompose/compare/v0.1.0...v0.1.1)

**Closed issues:**

- come up with a release schedule [\#187](https://github.com/kubernetes/kompose/issues/187)
- go 1.5 not building [\#181](https://github.com/kubernetes/kompose/issues/181)
- `--provider` flag for kompose [\#179](https://github.com/kubernetes/kompose/issues/179)
- kompose --version - print out dev tag  [\#170](https://github.com/kubernetes/kompose/issues/170)
- suggestion: let `-` denote stdout for -o option [\#169](https://github.com/kubernetes/kompose/issues/169)
- kompose up always deploys to default namespace [\#162](https://github.com/kubernetes/kompose/issues/162)
- Proposal: make --dab/--bundle global flag [\#161](https://github.com/kubernetes/kompose/issues/161)
- Support for "9995:9995/tcp" [\#158](https://github.com/kubernetes/kompose/issues/158)
- --file for all kinds of input [\#153](https://github.com/kubernetes/kompose/issues/153)
- `kompose up`  for OpenShift [\#152](https://github.com/kubernetes/kompose/issues/152)
- Persistent Volumes [\#150](https://github.com/kubernetes/kompose/issues/150)
- Generate ImageStream for every image in DeploymentConfig [\#145](https://github.com/kubernetes/kompose/issues/145)
- godep save ./... : cannot find package "k8s.io/kubernetes/pkg/apis/authentication.k8s.io" [\#117](https://github.com/kubernetes/kompose/issues/117)
- Add flags for sliencing warning and for treating warnings as error [\#100](https://github.com/kubernetes/kompose/issues/100)

**Merged pull requests:**

- Create PVC object for docker-compose volumes [\#186](https://github.com/kubernetes/kompose/pull/186) ([surajssd](https://github.com/surajssd))
- Update .dsb references to .dab [\#184](https://github.com/kubernetes/kompose/pull/184) ([cdrage](https://github.com/cdrage))
- Update README + Docker Compose Bundle references [\#183](https://github.com/kubernetes/kompose/pull/183) ([cdrage](https://github.com/cdrage))
- --provider global flag for kompose [\#182](https://github.com/kubernetes/kompose/pull/182) ([surajssd](https://github.com/surajssd))
- Changed version tag to reflect the tip of the branch [\#180](https://github.com/kubernetes/kompose/pull/180) ([cab105](https://github.com/cab105))
- Add .gitignore for Go files + compiled Kompose file [\#178](https://github.com/kubernetes/kompose/pull/178) ([cdrage](https://github.com/cdrage))
- support -o - to stdout [\#172](https://github.com/kubernetes/kompose/pull/172) ([ngtuna](https://github.com/ngtuna))
- remove executable perms from docs [\#171](https://github.com/kubernetes/kompose/pull/171) ([dustymabe](https://github.com/dustymabe))
- Make --dab/--bundle global flag [\#168](https://github.com/kubernetes/kompose/pull/168) ([kadel](https://github.com/kadel))
- Prepare up/down for other providers [\#166](https://github.com/kubernetes/kompose/pull/166) ([kadel](https://github.com/kadel))
- kompose up - Get namespace from kubeconfig [\#164](https://github.com/kubernetes/kompose/pull/164) ([kadel](https://github.com/kadel))
- OpenShift - generate DeploymentConfig with ImageStream [\#160](https://github.com/kubernetes/kompose/pull/160) ([kadel](https://github.com/kadel))
- Add port protocol handing for docker-compose. [\#159](https://github.com/kubernetes/kompose/pull/159) ([kadel](https://github.com/kadel))
- Added flag `--suppress-warnings`, `--verbose`, `--error-on-warning` global flags [\#111](https://github.com/kubernetes/kompose/pull/111) ([surajssd](https://github.com/surajssd))

## [v0.1.0](https://github.com/kubernetes/kompose/tree/v0.1.0) (2016-09-09)

[Full Changelog](https://github.com/kubernetes/kompose/compare/v0.0.1-beta.2...v0.1.0)

**Closed issues:**

- \[PROPOSAL\] Use -f as a global flag [\#138](https://github.com/kubernetes/kompose/issues/138)
- Should we use libcompose project.Context{} instead of docker.Context{}? [\#134](https://github.com/kubernetes/kompose/issues/134)
- services should be first in List  [\#130](https://github.com/kubernetes/kompose/issues/130)
- cmd tests are not working properly [\#125](https://github.com/kubernetes/kompose/issues/125)
- OpenShift conversoin - invalid DeploymentConfig [\#124](https://github.com/kubernetes/kompose/issues/124)
- Wrong output when port is missing [\#121](https://github.com/kubernetes/kompose/issues/121)
- Create a pod of containers sharing volume [\#116](https://github.com/kubernetes/kompose/issues/116)
- kompose convert panic on v1 compose file [\#102](https://github.com/kubernetes/kompose/issues/102)
- Release: kompose binary should be statically linked  [\#98](https://github.com/kubernetes/kompose/issues/98)
- Update libcompose to v0.3.0 [\#95](https://github.com/kubernetes/kompose/issues/95)
- Wrong warning about networks [\#88](https://github.com/kubernetes/kompose/issues/88)
- Problems of converting volumes [\#75](https://github.com/kubernetes/kompose/issues/75)
- `--stdout` output as `List` kind [\#73](https://github.com/kubernetes/kompose/issues/73)
- Print warning for unsupported fields in docker-compose format   [\#71](https://github.com/kubernetes/kompose/issues/71)
- Bug: incorrect version  [\#64](https://github.com/kubernetes/kompose/issues/64)
- panic: runtime error: invalid memory address or nil pointer dereference [\#59](https://github.com/kubernetes/kompose/issues/59)
- Breaking code in app.go to multiple packags [\#55](https://github.com/kubernetes/kompose/issues/55)
- Write an architecture document for kompose [\#45](https://github.com/kubernetes/kompose/issues/45)
- new behavior of `kompose delete` [\#41](https://github.com/kubernetes/kompose/issues/41)
- Add OpenShift support [\#36](https://github.com/kubernetes/kompose/issues/36)
- We don't have any tests [\#34](https://github.com/kubernetes/kompose/issues/34)

**Merged pull requests:**

- Update README.md [\#143](https://github.com/kubernetes/kompose/pull/143) ([luebken](https://github.com/luebken))
- Use libcompose project.Context{} instead of docker.Context{} [\#142](https://github.com/kubernetes/kompose/pull/142) ([ngtuna](https://github.com/ngtuna))
- update user guide: add `kompose up`, `kompose down` [\#141](https://github.com/kubernetes/kompose/pull/141) ([ngtuna](https://github.com/ngtuna))
- make --file as global flag [\#139](https://github.com/kubernetes/kompose/pull/139) ([ngtuna](https://github.com/ngtuna))
- improve messages of kompose up [\#136](https://github.com/kubernetes/kompose/pull/136) ([sebgoa](https://github.com/sebgoa))
- New guestbook example [\#135](https://github.com/kubernetes/kompose/pull/135) ([sebgoa](https://github.com/sebgoa))
- Moves examples to docs/user-guide and adds basic roadmap to main readme [\#132](https://github.com/kubernetes/kompose/pull/132) ([sebgoa](https://github.com/sebgoa))
- Add more owners [\#128](https://github.com/kubernetes/kompose/pull/128) ([janetkuo](https://github.com/janetkuo))
- docker-compose - Entrypoint support [\#127](https://github.com/kubernetes/kompose/pull/127) ([kadel](https://github.com/kadel))
- Fix conversion to OpenShift \(invalid DeploymentConfig\) [\#126](https://github.com/kubernetes/kompose/pull/126) ([kadel](https://github.com/kadel))
- clean code [\#123](https://github.com/kubernetes/kompose/pull/123) ([ngtuna](https://github.com/ngtuna))
- fix \#121: update all objects, even when port is missing [\#122](https://github.com/kubernetes/kompose/pull/122) ([ngtuna](https://github.com/ngtuna))
- Update architecture doc format [\#120](https://github.com/kubernetes/kompose/pull/120) ([janetkuo](https://github.com/janetkuo))
- Improve error message for invalid port [\#119](https://github.com/kubernetes/kompose/pull/119) ([janetkuo](https://github.com/janetkuo))
- Remove hostPath and print warnings [\#118](https://github.com/kubernetes/kompose/pull/118) ([janetkuo](https://github.com/janetkuo))
- Reuse creation of controller object code [\#115](https://github.com/kubernetes/kompose/pull/115) ([surajssd](https://github.com/surajssd))
- Removed unwanted svcnames list [\#114](https://github.com/kubernetes/kompose/pull/114) ([surajssd](https://github.com/surajssd))
- support kompose down subcommand [\#113](https://github.com/kubernetes/kompose/pull/113) ([ngtuna](https://github.com/ngtuna))
- update Libcompose to v0.3.0 [\#112](https://github.com/kubernetes/kompose/pull/112) ([kadel](https://github.com/kadel))
- Fix output comparison for cmd tests [\#110](https://github.com/kubernetes/kompose/pull/110) ([surajssd](https://github.com/surajssd))
- Create service function in kubernetes utils [\#108](https://github.com/kubernetes/kompose/pull/108) ([surajssd](https://github.com/surajssd))
- Abstracted port checking function [\#107](https://github.com/kubernetes/kompose/pull/107) ([surajssd](https://github.com/surajssd))
- Add more unit tests for Transform [\#106](https://github.com/kubernetes/kompose/pull/106) ([janetkuo](https://github.com/janetkuo))
- Support container name and args in kompose convert [\#105](https://github.com/kubernetes/kompose/pull/105) ([janetkuo](https://github.com/janetkuo))
- Add unit test for komposeConvert [\#104](https://github.com/kubernetes/kompose/pull/104) ([janetkuo](https://github.com/janetkuo))
- Update tests output files [\#101](https://github.com/kubernetes/kompose/pull/101) ([surajssd](https://github.com/surajssd))
- Build statically linked binaries in makefile; remove make clean [\#99](https://github.com/kubernetes/kompose/pull/99) ([janetkuo](https://github.com/janetkuo))
- Output List kind object when using stdout [\#94](https://github.com/kubernetes/kompose/pull/94) ([surajssd](https://github.com/surajssd))
- Run tests on travis-ci [\#93](https://github.com/kubernetes/kompose/pull/93) ([kadel](https://github.com/kadel))
- loader-transformer [\#91](https://github.com/kubernetes/kompose/pull/91) ([ngtuna](https://github.com/ngtuna))
- enhance warning: networks, network config, volume config. Fixes \#88, \#71 [\#90](https://github.com/kubernetes/kompose/pull/90) ([ngtuna](https://github.com/ngtuna))
- Functional Testing for kompose cmdline [\#89](https://github.com/kubernetes/kompose/pull/89) ([surajssd](https://github.com/surajssd))
- New behavior of kompose up [\#86](https://github.com/kubernetes/kompose/pull/86) ([ngtuna](https://github.com/ngtuna))

## [v0.0.1-beta.2](https://github.com/kubernetes/kompose/tree/v0.0.1-beta.2) (2016-08-04)

[Full Changelog](https://github.com/kubernetes/kompose/compare/v0.0.1-beta.1...v0.0.1-beta.2)

**Closed issues:**

- The example .dsb file doesn't work  [\#85](https://github.com/kubernetes/kompose/issues/85)
- docker-compose labels should be converted to k8s annotations instead of labels  [\#81](https://github.com/kubernetes/kompose/issues/81)
- Kompose help needs improvment [\#76](https://github.com/kubernetes/kompose/issues/76)
- Should we support converting to Replica Sets? [\#63](https://github.com/kubernetes/kompose/issues/63)
- `targetPort` is 0 in a converted service definition [\#60](https://github.com/kubernetes/kompose/issues/60)
- docker-compose service with no ports is mapped to k8s svc with no ports [\#58](https://github.com/kubernetes/kompose/issues/58)
- `depends\_on` is not supported [\#57](https://github.com/kubernetes/kompose/issues/57)
- Environment Variable substitution not working [\#56](https://github.com/kubernetes/kompose/issues/56)
- update README for bundles, compose v2 [\#54](https://github.com/kubernetes/kompose/issues/54)
- Consider changing `--from-bundles` \(bool\) to `--bundle-file` \(string\) [\#53](https://github.com/kubernetes/kompose/issues/53)
- Consider changing `--rc` flag to bool and adding `--replicas` [\#52](https://github.com/kubernetes/kompose/issues/52)
- Unable to go build  [\#49](https://github.com/kubernetes/kompose/issues/49)
- convert file fail [\#47](https://github.com/kubernetes/kompose/issues/47)
- \[Discuss\] Optimize convert function [\#44](https://github.com/kubernetes/kompose/issues/44)
- Default objects of `kompose convert` [\#38](https://github.com/kubernetes/kompose/issues/38)
- Idea: kompose up, ps, delete, scale redirect to kubectl  [\#27](https://github.com/kubernetes/kompose/issues/27)
- Print out warning for undefined fields [\#3](https://github.com/kubernetes/kompose/issues/3)

**Merged pull requests:**

- Converting compose labels to k8s annotations [\#84](https://github.com/kubernetes/kompose/pull/84) ([janetkuo](https://github.com/janetkuo))
- Clean up kompose help, remove support for unimplemented commands [\#83](https://github.com/kubernetes/kompose/pull/83) ([janetkuo](https://github.com/janetkuo))
- Enable warnings in stdout [\#79](https://github.com/kubernetes/kompose/pull/79) ([janetkuo](https://github.com/janetkuo))
- Convert volumes in \[name:\]\[host:\]container\[:access\_mode\] format [\#78](https://github.com/kubernetes/kompose/pull/78) ([janetkuo](https://github.com/janetkuo))
- Volumes default not read-only [\#77](https://github.com/kubernetes/kompose/pull/77) ([janetkuo](https://github.com/janetkuo))
- Correctly log error [\#74](https://github.com/kubernetes/kompose/pull/74) ([janetkuo](https://github.com/janetkuo))
- Remove the support for converting to Replica Sets [\#69](https://github.com/kubernetes/kompose/pull/69) ([janetkuo](https://github.com/janetkuo))
- Warning on missing port information and no service created [\#68](https://github.com/kubernetes/kompose/pull/68) ([surajssd](https://github.com/surajssd))
- Support for environment variables substitution [\#67](https://github.com/kubernetes/kompose/pull/67) ([surajssd](https://github.com/surajssd))
- Development Guide: use script/godep-restore.sh [\#66](https://github.com/kubernetes/kompose/pull/66) ([kadel](https://github.com/kadel))
- Allow --chart and --out to be specified together [\#65](https://github.com/kubernetes/kompose/pull/65) ([janetkuo](https://github.com/janetkuo))
- Add --replicas flag and changed --rc from string to bool [\#62](https://github.com/kubernetes/kompose/pull/62) ([janetkuo](https://github.com/janetkuo))
- Add --bundle,-dab flag for specifying dab file [\#61](https://github.com/kubernetes/kompose/pull/61) ([janetkuo](https://github.com/janetkuo))

## [v0.0.1-beta.1](https://github.com/kubernetes/kompose/tree/v0.0.1-beta.1) (2016-07-22)

[Full Changelog](https://github.com/kubernetes/kompose/compare/v0.0.1-alpha...v0.0.1-beta.1)

**Closed issues:**

- Default controller object is always generated. [\#33](https://github.com/kubernetes/kompose/issues/33)
- Generating both ReplicationControllers and Deployments [\#31](https://github.com/kubernetes/kompose/issues/31)
- Generating both ReplicationControllers and Deployments [\#30](https://github.com/kubernetes/kompose/issues/30)
- update OpenShift dependency  [\#29](https://github.com/kubernetes/kompose/issues/29)
- Bug: chart only expect .json files  [\#25](https://github.com/kubernetes/kompose/issues/25)
- Services only get created when there is a links key present [\#23](https://github.com/kubernetes/kompose/issues/23)
- Services should be created first [\#21](https://github.com/kubernetes/kompose/issues/21)
- Sometimes redundant services are printed/converted in `kompose convert` [\#20](https://github.com/kubernetes/kompose/issues/20)
- Redundant file creation message [\#18](https://github.com/kubernetes/kompose/issues/18)
- specify replica count [\#15](https://github.com/kubernetes/kompose/issues/15)
- Output for what happened after command execution [\#13](https://github.com/kubernetes/kompose/issues/13)
- Support k8s 1.3 [\#12](https://github.com/kubernetes/kompose/issues/12)
- Support compose v2..v3? versions [\#11](https://github.com/kubernetes/kompose/issues/11)
- Change template dir for Helm charts [\#10](https://github.com/kubernetes/kompose/issues/10)
- Document unsupported fileds [\#9](https://github.com/kubernetes/kompose/issues/9)
- if random docker-compose file is not present --file option does not work [\#8](https://github.com/kubernetes/kompose/issues/8)
- Decide status of skippbox/kompose [\#7](https://github.com/kubernetes/kompose/issues/7)
- travis build failed because "speter.net/go/exp/math/dec/inf" has been removed [\#6](https://github.com/kubernetes/kompose/issues/6)
- Support docker bundles format as input [\#4](https://github.com/kubernetes/kompose/issues/4)
- Support output to stdout to pipe to kubectl [\#2](https://github.com/kubernetes/kompose/issues/2)
- Support output in a single file [\#1](https://github.com/kubernetes/kompose/issues/1)

**Merged pull requests:**

- Fix some nits in README [\#51](https://github.com/kubernetes/kompose/pull/51) ([janetkuo](https://github.com/janetkuo))
- Add a bundle example file [\#50](https://github.com/kubernetes/kompose/pull/50) ([janetkuo](https://github.com/janetkuo))
- Fix failing windows build [\#48](https://github.com/kubernetes/kompose/pull/48) ([kadel](https://github.com/kadel))
- Inital support for Openshift. [\#46](https://github.com/kubernetes/kompose/pull/46) ([kadel](https://github.com/kadel))
- Refactor how we update controllers [\#42](https://github.com/kubernetes/kompose/pull/42) ([janetkuo](https://github.com/janetkuo))
- Generate only controllers set by flag [\#35](https://github.com/kubernetes/kompose/pull/35) ([kadel](https://github.com/kadel))
- Make deployment the default controller, create -rc for rc, and enable copying all types of controller to chart templates [\#32](https://github.com/kubernetes/kompose/pull/32) ([janetkuo](https://github.com/janetkuo))
- Validate flags when generating charts, and prints message for file created [\#28](https://github.com/kubernetes/kompose/pull/28) ([janetkuo](https://github.com/janetkuo))
- Support creating Charts when --yaml set [\#26](https://github.com/kubernetes/kompose/pull/26) ([janetkuo](https://github.com/janetkuo))
- Fix the 'failed to write to file' error when --out is set [\#24](https://github.com/kubernetes/kompose/pull/24) ([janetkuo](https://github.com/janetkuo))
- Allow multiple types of controllers be generated unless --out or --stdout is set [\#22](https://github.com/kubernetes/kompose/pull/22) ([janetkuo](https://github.com/janetkuo))
- Remove redundant file creation message, and always overwirte files when converting [\#19](https://github.com/kubernetes/kompose/pull/19) ([janetkuo](https://github.com/janetkuo))
- Support printing to stdout [\#5](https://github.com/kubernetes/kompose/pull/5) ([janetkuo](https://github.com/janetkuo))

## [v0.0.1-alpha](https://github.com/kubernetes/kompose/tree/v0.0.1-alpha) (2016-06-30)

[Full Changelog](https://github.com/kubernetes/kompose/compare/8cfb216d635a534c18ab4571ac6862cd44e6bfbf...v0.0.1-alpha)



\* *This Changelog was automatically generated by [github_changelog_generator](https://github.com/github-changelog-generator/github-changelog-generator)*
