// Code generated by protoc-gen-gogo. DO NOT EDIT.
// source: envoy/config/rbac/v2alpha/rbac.proto

/*
	Package v2alpha is a generated protocol buffer package.

	It is generated from these files:
		envoy/config/rbac/v2alpha/rbac.proto

	It has these top-level messages:
		RBAC
		Policy
		Permission
		Principal
*/
package v2alpha

import proto "github.com/gogo/protobuf/proto"
import fmt "fmt"
import math "math"
import _ "github.com/lyft/protoc-gen-validate/validate"
import envoy_api_v2_core1 "github.com/envoyproxy/go-control-plane/envoy/api/v2/core"
import envoy_api_v2_route "github.com/envoyproxy/go-control-plane/envoy/api/v2/route"
import envoy_type_matcher2 "github.com/envoyproxy/go-control-plane/envoy/type/matcher"

import io "io"

// Reference imports to suppress errors if they are not otherwise used.
var _ = proto.Marshal
var _ = fmt.Errorf
var _ = math.Inf

// This is a compile-time assertion to ensure that this generated file
// is compatible with the proto package it is being compiled against.
// A compilation error at this line likely means your copy of the
// proto package needs to be updated.
const _ = proto.GoGoProtoPackageIsVersion2 // please upgrade the proto package

// Should we do safe-list or block-list style access control?
type RBAC_Action int32

const (
	// The policies grant access to principals. The rest is denied. This is safe-list style
	// access control. This is the default type.
	RBAC_ALLOW RBAC_Action = 0
	// The policies deny access to principals. The rest is allowed. This is block-list style
	// access control.
	RBAC_DENY RBAC_Action = 1
)

var RBAC_Action_name = map[int32]string{
	0: "ALLOW",
	1: "DENY",
}
var RBAC_Action_value = map[string]int32{
	"ALLOW": 0,
	"DENY":  1,
}

func (x RBAC_Action) String() string {
	return proto.EnumName(RBAC_Action_name, int32(x))
}
func (RBAC_Action) EnumDescriptor() ([]byte, []int) { return fileDescriptorRbac, []int{0, 0} }

// Role Based Access Control (RBAC) provides service-level and method-level access control for a
// service. RBAC policies are additive. The policies are examined in order. A request is allowed
// once a matching policy is found (suppose the `action` is ALLOW).
//
// Here is an example of RBAC configuration. It has two policies:
//
// * Service account "cluster.local/ns/default/sa/admin" has full access to the service, and so
//   does "cluster.local/ns/default/sa/superuser".
//
// * Any user can read ("GET") the service at paths with prefix "/products", so long as the
//   destination port is either 80 or 443.
//
//  .. code-block:: yaml
//
//   action: ALLOW
//   policies:
//     "service-admin":
//       permissions:
//         - any: true
//       principals:
//         - authenticated: { name: "cluster.local/ns/default/sa/admin" }
//         - authenticated: { name: "cluster.local/ns/default/sa/superuser" }
//     "product-viewer":
//       permissions:
//           - and_rules:
//               rules:
//                 - header: { name: ":method", exact_match: "GET" }
//                 - header: { name: ":path", regex_match: "/products(/.*)?" }
//                 - or_rules:
//                     rules:
//                       - destination_port: 80
//                       - destination_port: 443
//       principals:
//         - any: true
//
type RBAC struct {
	// The action to take if a policy matches. The request is allowed if and only if:
	//
	//   * `action` is "ALLOWED" and at least one policy matches
	//   * `action` is "DENY" and none of the policies match
	Action RBAC_Action `protobuf:"varint,1,opt,name=action,proto3,enum=envoy.config.rbac.v2alpha.RBAC_Action" json:"action,omitempty"`
	// Maps from policy name to policy. A match occurs when at least one policy matches the request.
	Policies map[string]*Policy `protobuf:"bytes,2,rep,name=policies" json:"policies,omitempty" protobuf_key:"bytes,1,opt,name=key,proto3" protobuf_val:"bytes,2,opt,name=value"`
}

func (m *RBAC) Reset()                    { *m = RBAC{} }
func (m *RBAC) String() string            { return proto.CompactTextString(m) }
func (*RBAC) ProtoMessage()               {}
func (*RBAC) Descriptor() ([]byte, []int) { return fileDescriptorRbac, []int{0} }

func (m *RBAC) GetAction() RBAC_Action {
	if m != nil {
		return m.Action
	}
	return RBAC_ALLOW
}

func (m *RBAC) GetPolicies() map[string]*Policy {
	if m != nil {
		return m.Policies
	}
	return nil
}

// Policy specifies a role and the principals that are assigned/denied the role. A policy matches if
// and only if at least one of its permissions match the action taking place AND at least one of its
// principals match the downstream.
type Policy struct {
	// Required. The set of permissions that define a role. Each permission is matched with OR
	// semantics. To match all actions for this policy, a single Permission with the `any` field set
	// to true should be used.
	Permissions []*Permission `protobuf:"bytes,1,rep,name=permissions" json:"permissions,omitempty"`
	// Required. The set of principals that are assigned/denied the role based on “action”. Each
	// principal is matched with OR semantics. To match all downstreams for this policy, a single
	// Principal with the `any` field set to true should be used.
	Principals []*Principal `protobuf:"bytes,2,rep,name=principals" json:"principals,omitempty"`
}

func (m *Policy) Reset()                    { *m = Policy{} }
func (m *Policy) String() string            { return proto.CompactTextString(m) }
func (*Policy) ProtoMessage()               {}
func (*Policy) Descriptor() ([]byte, []int) { return fileDescriptorRbac, []int{1} }

func (m *Policy) GetPermissions() []*Permission {
	if m != nil {
		return m.Permissions
	}
	return nil
}

func (m *Policy) GetPrincipals() []*Principal {
	if m != nil {
		return m.Principals
	}
	return nil
}

// Permission defines an action (or actions) that a principal can take.
type Permission struct {
	// Types that are valid to be assigned to Rule:
	//	*Permission_AndRules
	//	*Permission_OrRules
	//	*Permission_Any
	//	*Permission_Header
	//	*Permission_DestinationIp
	//	*Permission_DestinationPort
	//	*Permission_Metadata
	//	*Permission_NotRule
	Rule isPermission_Rule `protobuf_oneof:"rule"`
}

func (m *Permission) Reset()                    { *m = Permission{} }
func (m *Permission) String() string            { return proto.CompactTextString(m) }
func (*Permission) ProtoMessage()               {}
func (*Permission) Descriptor() ([]byte, []int) { return fileDescriptorRbac, []int{2} }

type isPermission_Rule interface {
	isPermission_Rule()
	MarshalTo([]byte) (int, error)
	Size() int
}

type Permission_AndRules struct {
	AndRules *Permission_Set `protobuf:"bytes,1,opt,name=and_rules,json=andRules,oneof"`
}
type Permission_OrRules struct {
	OrRules *Permission_Set `protobuf:"bytes,2,opt,name=or_rules,json=orRules,oneof"`
}
type Permission_Any struct {
	Any bool `protobuf:"varint,3,opt,name=any,proto3,oneof"`
}
type Permission_Header struct {
	Header *envoy_api_v2_route.HeaderMatcher `protobuf:"bytes,4,opt,name=header,oneof"`
}
type Permission_DestinationIp struct {
	DestinationIp *envoy_api_v2_core1.CidrRange `protobuf:"bytes,5,opt,name=destination_ip,json=destinationIp,oneof"`
}
type Permission_DestinationPort struct {
	DestinationPort uint32 `protobuf:"varint,6,opt,name=destination_port,json=destinationPort,proto3,oneof"`
}
type Permission_Metadata struct {
	Metadata *envoy_type_matcher2.MetadataMatcher `protobuf:"bytes,7,opt,name=metadata,oneof"`
}
type Permission_NotRule struct {
	NotRule *Permission `protobuf:"bytes,8,opt,name=not_rule,json=notRule,oneof"`
}

func (*Permission_AndRules) isPermission_Rule()        {}
func (*Permission_OrRules) isPermission_Rule()         {}
func (*Permission_Any) isPermission_Rule()             {}
func (*Permission_Header) isPermission_Rule()          {}
func (*Permission_DestinationIp) isPermission_Rule()   {}
func (*Permission_DestinationPort) isPermission_Rule() {}
func (*Permission_Metadata) isPermission_Rule()        {}
func (*Permission_NotRule) isPermission_Rule()         {}

func (m *Permission) GetRule() isPermission_Rule {
	if m != nil {
		return m.Rule
	}
	return nil
}

func (m *Permission) GetAndRules() *Permission_Set {
	if x, ok := m.GetRule().(*Permission_AndRules); ok {
		return x.AndRules
	}
	return nil
}

func (m *Permission) GetOrRules() *Permission_Set {
	if x, ok := m.GetRule().(*Permission_OrRules); ok {
		return x.OrRules
	}
	return nil
}

func (m *Permission) GetAny() bool {
	if x, ok := m.GetRule().(*Permission_Any); ok {
		return x.Any
	}
	return false
}

func (m *Permission) GetHeader() *envoy_api_v2_route.HeaderMatcher {
	if x, ok := m.GetRule().(*Permission_Header); ok {
		return x.Header
	}
	return nil
}

func (m *Permission) GetDestinationIp() *envoy_api_v2_core1.CidrRange {
	if x, ok := m.GetRule().(*Permission_DestinationIp); ok {
		return x.DestinationIp
	}
	return nil
}

func (m *Permission) GetDestinationPort() uint32 {
	if x, ok := m.GetRule().(*Permission_DestinationPort); ok {
		return x.DestinationPort
	}
	return 0
}

func (m *Permission) GetMetadata() *envoy_type_matcher2.MetadataMatcher {
	if x, ok := m.GetRule().(*Permission_Metadata); ok {
		return x.Metadata
	}
	return nil
}

func (m *Permission) GetNotRule() *Permission {
	if x, ok := m.GetRule().(*Permission_NotRule); ok {
		return x.NotRule
	}
	return nil
}

// XXX_OneofFuncs is for the internal use of the proto package.
func (*Permission) XXX_OneofFuncs() (func(msg proto.Message, b *proto.Buffer) error, func(msg proto.Message, tag, wire int, b *proto.Buffer) (bool, error), func(msg proto.Message) (n int), []interface{}) {
	return _Permission_OneofMarshaler, _Permission_OneofUnmarshaler, _Permission_OneofSizer, []interface{}{
		(*Permission_AndRules)(nil),
		(*Permission_OrRules)(nil),
		(*Permission_Any)(nil),
		(*Permission_Header)(nil),
		(*Permission_DestinationIp)(nil),
		(*Permission_DestinationPort)(nil),
		(*Permission_Metadata)(nil),
		(*Permission_NotRule)(nil),
	}
}

func _Permission_OneofMarshaler(msg proto.Message, b *proto.Buffer) error {
	m := msg.(*Permission)
	// rule
	switch x := m.Rule.(type) {
	case *Permission_AndRules:
		_ = b.EncodeVarint(1<<3 | proto.WireBytes)
		if err := b.EncodeMessage(x.AndRules); err != nil {
			return err
		}
	case *Permission_OrRules:
		_ = b.EncodeVarint(2<<3 | proto.WireBytes)
		if err := b.EncodeMessage(x.OrRules); err != nil {
			return err
		}
	case *Permission_Any:
		t := uint64(0)
		if x.Any {
			t = 1
		}
		_ = b.EncodeVarint(3<<3 | proto.WireVarint)
		_ = b.EncodeVarint(t)
	case *Permission_Header:
		_ = b.EncodeVarint(4<<3 | proto.WireBytes)
		if err := b.EncodeMessage(x.Header); err != nil {
			return err
		}
	case *Permission_DestinationIp:
		_ = b.EncodeVarint(5<<3 | proto.WireBytes)
		if err := b.EncodeMessage(x.DestinationIp); err != nil {
			return err
		}
	case *Permission_DestinationPort:
		_ = b.EncodeVarint(6<<3 | proto.WireVarint)
		_ = b.EncodeVarint(uint64(x.DestinationPort))
	case *Permission_Metadata:
		_ = b.EncodeVarint(7<<3 | proto.WireBytes)
		if err := b.EncodeMessage(x.Metadata); err != nil {
			return err
		}
	case *Permission_NotRule:
		_ = b.EncodeVarint(8<<3 | proto.WireBytes)
		if err := b.EncodeMessage(x.NotRule); err != nil {
			return err
		}
	case nil:
	default:
		return fmt.Errorf("Permission.Rule has unexpected type %T", x)
	}
	return nil
}

func _Permission_OneofUnmarshaler(msg proto.Message, tag, wire int, b *proto.Buffer) (bool, error) {
	m := msg.(*Permission)
	switch tag {
	case 1: // rule.and_rules
		if wire != proto.WireBytes {
			return true, proto.ErrInternalBadWireType
		}
		msg := new(Permission_Set)
		err := b.DecodeMessage(msg)
		m.Rule = &Permission_AndRules{msg}
		return true, err
	case 2: // rule.or_rules
		if wire != proto.WireBytes {
			return true, proto.ErrInternalBadWireType
		}
		msg := new(Permission_Set)
		err := b.DecodeMessage(msg)
		m.Rule = &Permission_OrRules{msg}
		return true, err
	case 3: // rule.any
		if wire != proto.WireVarint {
			return true, proto.ErrInternalBadWireType
		}
		x, err := b.DecodeVarint()
		m.Rule = &Permission_Any{x != 0}
		return true, err
	case 4: // rule.header
		if wire != proto.WireBytes {
			return true, proto.ErrInternalBadWireType
		}
		msg := new(envoy_api_v2_route.HeaderMatcher)
		err := b.DecodeMessage(msg)
		m.Rule = &Permission_Header{msg}
		return true, err
	case 5: // rule.destination_ip
		if wire != proto.WireBytes {
			return true, proto.ErrInternalBadWireType
		}
		msg := new(envoy_api_v2_core1.CidrRange)
		err := b.DecodeMessage(msg)
		m.Rule = &Permission_DestinationIp{msg}
		return true, err
	case 6: // rule.destination_port
		if wire != proto.WireVarint {
			return true, proto.ErrInternalBadWireType
		}
		x, err := b.DecodeVarint()
		m.Rule = &Permission_DestinationPort{uint32(x)}
		return true, err
	case 7: // rule.metadata
		if wire != proto.WireBytes {
			return true, proto.ErrInternalBadWireType
		}
		msg := new(envoy_type_matcher2.MetadataMatcher)
		err := b.DecodeMessage(msg)
		m.Rule = &Permission_Metadata{msg}
		return true, err
	case 8: // rule.not_rule
		if wire != proto.WireBytes {
			return true, proto.ErrInternalBadWireType
		}
		msg := new(Permission)
		err := b.DecodeMessage(msg)
		m.Rule = &Permission_NotRule{msg}
		return true, err
	default:
		return false, nil
	}
}

func _Permission_OneofSizer(msg proto.Message) (n int) {
	m := msg.(*Permission)
	// rule
	switch x := m.Rule.(type) {
	case *Permission_AndRules:
		s := proto.Size(x.AndRules)
		n += proto.SizeVarint(1<<3 | proto.WireBytes)
		n += proto.SizeVarint(uint64(s))
		n += s
	case *Permission_OrRules:
		s := proto.Size(x.OrRules)
		n += proto.SizeVarint(2<<3 | proto.WireBytes)
		n += proto.SizeVarint(uint64(s))
		n += s
	case *Permission_Any:
		n += proto.SizeVarint(3<<3 | proto.WireVarint)
		n += 1
	case *Permission_Header:
		s := proto.Size(x.Header)
		n += proto.SizeVarint(4<<3 | proto.WireBytes)
		n += proto.SizeVarint(uint64(s))
		n += s
	case *Permission_DestinationIp:
		s := proto.Size(x.DestinationIp)
		n += proto.SizeVarint(5<<3 | proto.WireBytes)
		n += proto.SizeVarint(uint64(s))
		n += s
	case *Permission_DestinationPort:
		n += proto.SizeVarint(6<<3 | proto.WireVarint)
		n += proto.SizeVarint(uint64(x.DestinationPort))
	case *Permission_Metadata:
		s := proto.Size(x.Metadata)
		n += proto.SizeVarint(7<<3 | proto.WireBytes)
		n += proto.SizeVarint(uint64(s))
		n += s
	case *Permission_NotRule:
		s := proto.Size(x.NotRule)
		n += proto.SizeVarint(8<<3 | proto.WireBytes)
		n += proto.SizeVarint(uint64(s))
		n += s
	case nil:
	default:
		panic(fmt.Sprintf("proto: unexpected type %T in oneof", x))
	}
	return n
}

// Used in the `and_rules` and `or_rules` fields in the `rule` oneof. Depending on the context,
// each are applied with the associated behavior.
type Permission_Set struct {
	Rules []*Permission `protobuf:"bytes,1,rep,name=rules" json:"rules,omitempty"`
}

func (m *Permission_Set) Reset()                    { *m = Permission_Set{} }
func (m *Permission_Set) String() string            { return proto.CompactTextString(m) }
func (*Permission_Set) ProtoMessage()               {}
func (*Permission_Set) Descriptor() ([]byte, []int) { return fileDescriptorRbac, []int{2, 0} }

func (m *Permission_Set) GetRules() []*Permission {
	if m != nil {
		return m.Rules
	}
	return nil
}

// Principal defines an identity or a group of identities for a downstream subject.
type Principal struct {
	// Types that are valid to be assigned to Identifier:
	//	*Principal_AndIds
	//	*Principal_OrIds
	//	*Principal_Any
	//	*Principal_Authenticated_
	//	*Principal_SourceIp
	//	*Principal_Header
	//	*Principal_Metadata
	//	*Principal_NotId
	Identifier isPrincipal_Identifier `protobuf_oneof:"identifier"`
}

func (m *Principal) Reset()                    { *m = Principal{} }
func (m *Principal) String() string            { return proto.CompactTextString(m) }
func (*Principal) ProtoMessage()               {}
func (*Principal) Descriptor() ([]byte, []int) { return fileDescriptorRbac, []int{3} }

type isPrincipal_Identifier interface {
	isPrincipal_Identifier()
	MarshalTo([]byte) (int, error)
	Size() int
}

type Principal_AndIds struct {
	AndIds *Principal_Set `protobuf:"bytes,1,opt,name=and_ids,json=andIds,oneof"`
}
type Principal_OrIds struct {
	OrIds *Principal_Set `protobuf:"bytes,2,opt,name=or_ids,json=orIds,oneof"`
}
type Principal_Any struct {
	Any bool `protobuf:"varint,3,opt,name=any,proto3,oneof"`
}
type Principal_Authenticated_ struct {
	Authenticated *Principal_Authenticated `protobuf:"bytes,4,opt,name=authenticated,oneof"`
}
type Principal_SourceIp struct {
	SourceIp *envoy_api_v2_core1.CidrRange `protobuf:"bytes,5,opt,name=source_ip,json=sourceIp,oneof"`
}
type Principal_Header struct {
	Header *envoy_api_v2_route.HeaderMatcher `protobuf:"bytes,6,opt,name=header,oneof"`
}
type Principal_Metadata struct {
	Metadata *envoy_type_matcher2.MetadataMatcher `protobuf:"bytes,7,opt,name=metadata,oneof"`
}
type Principal_NotId struct {
	NotId *Principal `protobuf:"bytes,8,opt,name=not_id,json=notId,oneof"`
}

func (*Principal_AndIds) isPrincipal_Identifier()         {}
func (*Principal_OrIds) isPrincipal_Identifier()          {}
func (*Principal_Any) isPrincipal_Identifier()            {}
func (*Principal_Authenticated_) isPrincipal_Identifier() {}
func (*Principal_SourceIp) isPrincipal_Identifier()       {}
func (*Principal_Header) isPrincipal_Identifier()         {}
func (*Principal_Metadata) isPrincipal_Identifier()       {}
func (*Principal_NotId) isPrincipal_Identifier()          {}

func (m *Principal) GetIdentifier() isPrincipal_Identifier {
	if m != nil {
		return m.Identifier
	}
	return nil
}

func (m *Principal) GetAndIds() *Principal_Set {
	if x, ok := m.GetIdentifier().(*Principal_AndIds); ok {
		return x.AndIds
	}
	return nil
}

func (m *Principal) GetOrIds() *Principal_Set {
	if x, ok := m.GetIdentifier().(*Principal_OrIds); ok {
		return x.OrIds
	}
	return nil
}

func (m *Principal) GetAny() bool {
	if x, ok := m.GetIdentifier().(*Principal_Any); ok {
		return x.Any
	}
	return false
}

func (m *Principal) GetAuthenticated() *Principal_Authenticated {
	if x, ok := m.GetIdentifier().(*Principal_Authenticated_); ok {
		return x.Authenticated
	}
	return nil
}

func (m *Principal) GetSourceIp() *envoy_api_v2_core1.CidrRange {
	if x, ok := m.GetIdentifier().(*Principal_SourceIp); ok {
		return x.SourceIp
	}
	return nil
}

func (m *Principal) GetHeader() *envoy_api_v2_route.HeaderMatcher {
	if x, ok := m.GetIdentifier().(*Principal_Header); ok {
		return x.Header
	}
	return nil
}

func (m *Principal) GetMetadata() *envoy_type_matcher2.MetadataMatcher {
	if x, ok := m.GetIdentifier().(*Principal_Metadata); ok {
		return x.Metadata
	}
	return nil
}

func (m *Principal) GetNotId() *Principal {
	if x, ok := m.GetIdentifier().(*Principal_NotId); ok {
		return x.NotId
	}
	return nil
}

// XXX_OneofFuncs is for the internal use of the proto package.
func (*Principal) XXX_OneofFuncs() (func(msg proto.Message, b *proto.Buffer) error, func(msg proto.Message, tag, wire int, b *proto.Buffer) (bool, error), func(msg proto.Message) (n int), []interface{}) {
	return _Principal_OneofMarshaler, _Principal_OneofUnmarshaler, _Principal_OneofSizer, []interface{}{
		(*Principal_AndIds)(nil),
		(*Principal_OrIds)(nil),
		(*Principal_Any)(nil),
		(*Principal_Authenticated_)(nil),
		(*Principal_SourceIp)(nil),
		(*Principal_Header)(nil),
		(*Principal_Metadata)(nil),
		(*Principal_NotId)(nil),
	}
}

func _Principal_OneofMarshaler(msg proto.Message, b *proto.Buffer) error {
	m := msg.(*Principal)
	// identifier
	switch x := m.Identifier.(type) {
	case *Principal_AndIds:
		_ = b.EncodeVarint(1<<3 | proto.WireBytes)
		if err := b.EncodeMessage(x.AndIds); err != nil {
			return err
		}
	case *Principal_OrIds:
		_ = b.EncodeVarint(2<<3 | proto.WireBytes)
		if err := b.EncodeMessage(x.OrIds); err != nil {
			return err
		}
	case *Principal_Any:
		t := uint64(0)
		if x.Any {
			t = 1
		}
		_ = b.EncodeVarint(3<<3 | proto.WireVarint)
		_ = b.EncodeVarint(t)
	case *Principal_Authenticated_:
		_ = b.EncodeVarint(4<<3 | proto.WireBytes)
		if err := b.EncodeMessage(x.Authenticated); err != nil {
			return err
		}
	case *Principal_SourceIp:
		_ = b.EncodeVarint(5<<3 | proto.WireBytes)
		if err := b.EncodeMessage(x.SourceIp); err != nil {
			return err
		}
	case *Principal_Header:
		_ = b.EncodeVarint(6<<3 | proto.WireBytes)
		if err := b.EncodeMessage(x.Header); err != nil {
			return err
		}
	case *Principal_Metadata:
		_ = b.EncodeVarint(7<<3 | proto.WireBytes)
		if err := b.EncodeMessage(x.Metadata); err != nil {
			return err
		}
	case *Principal_NotId:
		_ = b.EncodeVarint(8<<3 | proto.WireBytes)
		if err := b.EncodeMessage(x.NotId); err != nil {
			return err
		}
	case nil:
	default:
		return fmt.Errorf("Principal.Identifier has unexpected type %T", x)
	}
	return nil
}

func _Principal_OneofUnmarshaler(msg proto.Message, tag, wire int, b *proto.Buffer) (bool, error) {
	m := msg.(*Principal)
	switch tag {
	case 1: // identifier.and_ids
		if wire != proto.WireBytes {
			return true, proto.ErrInternalBadWireType
		}
		msg := new(Principal_Set)
		err := b.DecodeMessage(msg)
		m.Identifier = &Principal_AndIds{msg}
		return true, err
	case 2: // identifier.or_ids
		if wire != proto.WireBytes {
			return true, proto.ErrInternalBadWireType
		}
		msg := new(Principal_Set)
		err := b.DecodeMessage(msg)
		m.Identifier = &Principal_OrIds{msg}
		return true, err
	case 3: // identifier.any
		if wire != proto.WireVarint {
			return true, proto.ErrInternalBadWireType
		}
		x, err := b.DecodeVarint()
		m.Identifier = &Principal_Any{x != 0}
		return true, err
	case 4: // identifier.authenticated
		if wire != proto.WireBytes {
			return true, proto.ErrInternalBadWireType
		}
		msg := new(Principal_Authenticated)
		err := b.DecodeMessage(msg)
		m.Identifier = &Principal_Authenticated_{msg}
		return true, err
	case 5: // identifier.source_ip
		if wire != proto.WireBytes {
			return true, proto.ErrInternalBadWireType
		}
		msg := new(envoy_api_v2_core1.CidrRange)
		err := b.DecodeMessage(msg)
		m.Identifier = &Principal_SourceIp{msg}
		return true, err
	case 6: // identifier.header
		if wire != proto.WireBytes {
			return true, proto.ErrInternalBadWireType
		}
		msg := new(envoy_api_v2_route.HeaderMatcher)
		err := b.DecodeMessage(msg)
		m.Identifier = &Principal_Header{msg}
		return true, err
	case 7: // identifier.metadata
		if wire != proto.WireBytes {
			return true, proto.ErrInternalBadWireType
		}
		msg := new(envoy_type_matcher2.MetadataMatcher)
		err := b.DecodeMessage(msg)
		m.Identifier = &Principal_Metadata{msg}
		return true, err
	case 8: // identifier.not_id
		if wire != proto.WireBytes {
			return true, proto.ErrInternalBadWireType
		}
		msg := new(Principal)
		err := b.DecodeMessage(msg)
		m.Identifier = &Principal_NotId{msg}
		return true, err
	default:
		return false, nil
	}
}

func _Principal_OneofSizer(msg proto.Message) (n int) {
	m := msg.(*Principal)
	// identifier
	switch x := m.Identifier.(type) {
	case *Principal_AndIds:
		s := proto.Size(x.AndIds)
		n += proto.SizeVarint(1<<3 | proto.WireBytes)
		n += proto.SizeVarint(uint64(s))
		n += s
	case *Principal_OrIds:
		s := proto.Size(x.OrIds)
		n += proto.SizeVarint(2<<3 | proto.WireBytes)
		n += proto.SizeVarint(uint64(s))
		n += s
	case *Principal_Any:
		n += proto.SizeVarint(3<<3 | proto.WireVarint)
		n += 1
	case *Principal_Authenticated_:
		s := proto.Size(x.Authenticated)
		n += proto.SizeVarint(4<<3 | proto.WireBytes)
		n += proto.SizeVarint(uint64(s))
		n += s
	case *Principal_SourceIp:
		s := proto.Size(x.SourceIp)
		n += proto.SizeVarint(5<<3 | proto.WireBytes)
		n += proto.SizeVarint(uint64(s))
		n += s
	case *Principal_Header:
		s := proto.Size(x.Header)
		n += proto.SizeVarint(6<<3 | proto.WireBytes)
		n += proto.SizeVarint(uint64(s))
		n += s
	case *Principal_Metadata:
		s := proto.Size(x.Metadata)
		n += proto.SizeVarint(7<<3 | proto.WireBytes)
		n += proto.SizeVarint(uint64(s))
		n += s
	case *Principal_NotId:
		s := proto.Size(x.NotId)
		n += proto.SizeVarint(8<<3 | proto.WireBytes)
		n += proto.SizeVarint(uint64(s))
		n += s
	case nil:
	default:
		panic(fmt.Sprintf("proto: unexpected type %T in oneof", x))
	}
	return n
}

// Used in the `and_ids` and `or_ids` fields in the `identifier` oneof. Depending on the context,
// each are applied with the associated behavior.
type Principal_Set struct {
	Ids []*Principal `protobuf:"bytes,1,rep,name=ids" json:"ids,omitempty"`
}

func (m *Principal_Set) Reset()                    { *m = Principal_Set{} }
func (m *Principal_Set) String() string            { return proto.CompactTextString(m) }
func (*Principal_Set) ProtoMessage()               {}
func (*Principal_Set) Descriptor() ([]byte, []int) { return fileDescriptorRbac, []int{3, 0} }

func (m *Principal_Set) GetIds() []*Principal {
	if m != nil {
		return m.Ids
	}
	return nil
}

// Authentication attributes for a downstream.
type Principal_Authenticated struct {
	// The name of the principal. If set, the URI SAN is used from the certificate, otherwise the
	// subject field is used. If unset, it applies to any user that is authenticated.
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
}

func (m *Principal_Authenticated) Reset()                    { *m = Principal_Authenticated{} }
func (m *Principal_Authenticated) String() string            { return proto.CompactTextString(m) }
func (*Principal_Authenticated) ProtoMessage()               {}
func (*Principal_Authenticated) Descriptor() ([]byte, []int) { return fileDescriptorRbac, []int{3, 1} }

func (m *Principal_Authenticated) GetName() string {
	if m != nil {
		return m.Name
	}
	return ""
}

func init() {
	proto.RegisterType((*RBAC)(nil), "envoy.config.rbac.v2alpha.RBAC")
	proto.RegisterType((*Policy)(nil), "envoy.config.rbac.v2alpha.Policy")
	proto.RegisterType((*Permission)(nil), "envoy.config.rbac.v2alpha.Permission")
	proto.RegisterType((*Permission_Set)(nil), "envoy.config.rbac.v2alpha.Permission.Set")
	proto.RegisterType((*Principal)(nil), "envoy.config.rbac.v2alpha.Principal")
	proto.RegisterType((*Principal_Set)(nil), "envoy.config.rbac.v2alpha.Principal.Set")
	proto.RegisterType((*Principal_Authenticated)(nil), "envoy.config.rbac.v2alpha.Principal.Authenticated")
	proto.RegisterEnum("envoy.config.rbac.v2alpha.RBAC_Action", RBAC_Action_name, RBAC_Action_value)
}
func (m *RBAC) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalTo(dAtA)
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *RBAC) MarshalTo(dAtA []byte) (int, error) {
	var i int
	_ = i
	var l int
	_ = l
	if m.Action != 0 {
		dAtA[i] = 0x8
		i++
		i = encodeVarintRbac(dAtA, i, uint64(m.Action))
	}
	if len(m.Policies) > 0 {
		for k, _ := range m.Policies {
			dAtA[i] = 0x12
			i++
			v := m.Policies[k]
			msgSize := 0
			if v != nil {
				msgSize = v.Size()
				msgSize += 1 + sovRbac(uint64(msgSize))
			}
			mapSize := 1 + len(k) + sovRbac(uint64(len(k))) + msgSize
			i = encodeVarintRbac(dAtA, i, uint64(mapSize))
			dAtA[i] = 0xa
			i++
			i = encodeVarintRbac(dAtA, i, uint64(len(k)))
			i += copy(dAtA[i:], k)
			if v != nil {
				dAtA[i] = 0x12
				i++
				i = encodeVarintRbac(dAtA, i, uint64(v.Size()))
				n1, err := v.MarshalTo(dAtA[i:])
				if err != nil {
					return 0, err
				}
				i += n1
			}
		}
	}
	return i, nil
}

func (m *Policy) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalTo(dAtA)
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *Policy) MarshalTo(dAtA []byte) (int, error) {
	var i int
	_ = i
	var l int
	_ = l
	if len(m.Permissions) > 0 {
		for _, msg := range m.Permissions {
			dAtA[i] = 0xa
			i++
			i = encodeVarintRbac(dAtA, i, uint64(msg.Size()))
			n, err := msg.MarshalTo(dAtA[i:])
			if err != nil {
				return 0, err
			}
			i += n
		}
	}
	if len(m.Principals) > 0 {
		for _, msg := range m.Principals {
			dAtA[i] = 0x12
			i++
			i = encodeVarintRbac(dAtA, i, uint64(msg.Size()))
			n, err := msg.MarshalTo(dAtA[i:])
			if err != nil {
				return 0, err
			}
			i += n
		}
	}
	return i, nil
}

func (m *Permission) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalTo(dAtA)
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *Permission) MarshalTo(dAtA []byte) (int, error) {
	var i int
	_ = i
	var l int
	_ = l
	if m.Rule != nil {
		nn2, err := m.Rule.MarshalTo(dAtA[i:])
		if err != nil {
			return 0, err
		}
		i += nn2
	}
	return i, nil
}

func (m *Permission_AndRules) MarshalTo(dAtA []byte) (int, error) {
	i := 0
	if m.AndRules != nil {
		dAtA[i] = 0xa
		i++
		i = encodeVarintRbac(dAtA, i, uint64(m.AndRules.Size()))
		n3, err := m.AndRules.MarshalTo(dAtA[i:])
		if err != nil {
			return 0, err
		}
		i += n3
	}
	return i, nil
}
func (m *Permission_OrRules) MarshalTo(dAtA []byte) (int, error) {
	i := 0
	if m.OrRules != nil {
		dAtA[i] = 0x12
		i++
		i = encodeVarintRbac(dAtA, i, uint64(m.OrRules.Size()))
		n4, err := m.OrRules.MarshalTo(dAtA[i:])
		if err != nil {
			return 0, err
		}
		i += n4
	}
	return i, nil
}
func (m *Permission_Any) MarshalTo(dAtA []byte) (int, error) {
	i := 0
	dAtA[i] = 0x18
	i++
	if m.Any {
		dAtA[i] = 1
	} else {
		dAtA[i] = 0
	}
	i++
	return i, nil
}
func (m *Permission_Header) MarshalTo(dAtA []byte) (int, error) {
	i := 0
	if m.Header != nil {
		dAtA[i] = 0x22
		i++
		i = encodeVarintRbac(dAtA, i, uint64(m.Header.Size()))
		n5, err := m.Header.MarshalTo(dAtA[i:])
		if err != nil {
			return 0, err
		}
		i += n5
	}
	return i, nil
}
func (m *Permission_DestinationIp) MarshalTo(dAtA []byte) (int, error) {
	i := 0
	if m.DestinationIp != nil {
		dAtA[i] = 0x2a
		i++
		i = encodeVarintRbac(dAtA, i, uint64(m.DestinationIp.Size()))
		n6, err := m.DestinationIp.MarshalTo(dAtA[i:])
		if err != nil {
			return 0, err
		}
		i += n6
	}
	return i, nil
}
func (m *Permission_DestinationPort) MarshalTo(dAtA []byte) (int, error) {
	i := 0
	dAtA[i] = 0x30
	i++
	i = encodeVarintRbac(dAtA, i, uint64(m.DestinationPort))
	return i, nil
}
func (m *Permission_Metadata) MarshalTo(dAtA []byte) (int, error) {
	i := 0
	if m.Metadata != nil {
		dAtA[i] = 0x3a
		i++
		i = encodeVarintRbac(dAtA, i, uint64(m.Metadata.Size()))
		n7, err := m.Metadata.MarshalTo(dAtA[i:])
		if err != nil {
			return 0, err
		}
		i += n7
	}
	return i, nil
}
func (m *Permission_NotRule) MarshalTo(dAtA []byte) (int, error) {
	i := 0
	if m.NotRule != nil {
		dAtA[i] = 0x42
		i++
		i = encodeVarintRbac(dAtA, i, uint64(m.NotRule.Size()))
		n8, err := m.NotRule.MarshalTo(dAtA[i:])
		if err != nil {
			return 0, err
		}
		i += n8
	}
	return i, nil
}
func (m *Permission_Set) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalTo(dAtA)
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *Permission_Set) MarshalTo(dAtA []byte) (int, error) {
	var i int
	_ = i
	var l int
	_ = l
	if len(m.Rules) > 0 {
		for _, msg := range m.Rules {
			dAtA[i] = 0xa
			i++
			i = encodeVarintRbac(dAtA, i, uint64(msg.Size()))
			n, err := msg.MarshalTo(dAtA[i:])
			if err != nil {
				return 0, err
			}
			i += n
		}
	}
	return i, nil
}

func (m *Principal) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalTo(dAtA)
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *Principal) MarshalTo(dAtA []byte) (int, error) {
	var i int
	_ = i
	var l int
	_ = l
	if m.Identifier != nil {
		nn9, err := m.Identifier.MarshalTo(dAtA[i:])
		if err != nil {
			return 0, err
		}
		i += nn9
	}
	return i, nil
}

func (m *Principal_AndIds) MarshalTo(dAtA []byte) (int, error) {
	i := 0
	if m.AndIds != nil {
		dAtA[i] = 0xa
		i++
		i = encodeVarintRbac(dAtA, i, uint64(m.AndIds.Size()))
		n10, err := m.AndIds.MarshalTo(dAtA[i:])
		if err != nil {
			return 0, err
		}
		i += n10
	}
	return i, nil
}
func (m *Principal_OrIds) MarshalTo(dAtA []byte) (int, error) {
	i := 0
	if m.OrIds != nil {
		dAtA[i] = 0x12
		i++
		i = encodeVarintRbac(dAtA, i, uint64(m.OrIds.Size()))
		n11, err := m.OrIds.MarshalTo(dAtA[i:])
		if err != nil {
			return 0, err
		}
		i += n11
	}
	return i, nil
}
func (m *Principal_Any) MarshalTo(dAtA []byte) (int, error) {
	i := 0
	dAtA[i] = 0x18
	i++
	if m.Any {
		dAtA[i] = 1
	} else {
		dAtA[i] = 0
	}
	i++
	return i, nil
}
func (m *Principal_Authenticated_) MarshalTo(dAtA []byte) (int, error) {
	i := 0
	if m.Authenticated != nil {
		dAtA[i] = 0x22
		i++
		i = encodeVarintRbac(dAtA, i, uint64(m.Authenticated.Size()))
		n12, err := m.Authenticated.MarshalTo(dAtA[i:])
		if err != nil {
			return 0, err
		}
		i += n12
	}
	return i, nil
}
func (m *Principal_SourceIp) MarshalTo(dAtA []byte) (int, error) {
	i := 0
	if m.SourceIp != nil {
		dAtA[i] = 0x2a
		i++
		i = encodeVarintRbac(dAtA, i, uint64(m.SourceIp.Size()))
		n13, err := m.SourceIp.MarshalTo(dAtA[i:])
		if err != nil {
			return 0, err
		}
		i += n13
	}
	return i, nil
}
func (m *Principal_Header) MarshalTo(dAtA []byte) (int, error) {
	i := 0
	if m.Header != nil {
		dAtA[i] = 0x32
		i++
		i = encodeVarintRbac(dAtA, i, uint64(m.Header.Size()))
		n14, err := m.Header.MarshalTo(dAtA[i:])
		if err != nil {
			return 0, err
		}
		i += n14
	}
	return i, nil
}
func (m *Principal_Metadata) MarshalTo(dAtA []byte) (int, error) {
	i := 0
	if m.Metadata != nil {
		dAtA[i] = 0x3a
		i++
		i = encodeVarintRbac(dAtA, i, uint64(m.Metadata.Size()))
		n15, err := m.Metadata.MarshalTo(dAtA[i:])
		if err != nil {
			return 0, err
		}
		i += n15
	}
	return i, nil
}
func (m *Principal_NotId) MarshalTo(dAtA []byte) (int, error) {
	i := 0
	if m.NotId != nil {
		dAtA[i] = 0x42
		i++
		i = encodeVarintRbac(dAtA, i, uint64(m.NotId.Size()))
		n16, err := m.NotId.MarshalTo(dAtA[i:])
		if err != nil {
			return 0, err
		}
		i += n16
	}
	return i, nil
}
func (m *Principal_Set) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalTo(dAtA)
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *Principal_Set) MarshalTo(dAtA []byte) (int, error) {
	var i int
	_ = i
	var l int
	_ = l
	if len(m.Ids) > 0 {
		for _, msg := range m.Ids {
			dAtA[i] = 0xa
			i++
			i = encodeVarintRbac(dAtA, i, uint64(msg.Size()))
			n, err := msg.MarshalTo(dAtA[i:])
			if err != nil {
				return 0, err
			}
			i += n
		}
	}
	return i, nil
}

func (m *Principal_Authenticated) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalTo(dAtA)
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *Principal_Authenticated) MarshalTo(dAtA []byte) (int, error) {
	var i int
	_ = i
	var l int
	_ = l
	if len(m.Name) > 0 {
		dAtA[i] = 0xa
		i++
		i = encodeVarintRbac(dAtA, i, uint64(len(m.Name)))
		i += copy(dAtA[i:], m.Name)
	}
	return i, nil
}

func encodeVarintRbac(dAtA []byte, offset int, v uint64) int {
	for v >= 1<<7 {
		dAtA[offset] = uint8(v&0x7f | 0x80)
		v >>= 7
		offset++
	}
	dAtA[offset] = uint8(v)
	return offset + 1
}
func (m *RBAC) Size() (n int) {
	var l int
	_ = l
	if m.Action != 0 {
		n += 1 + sovRbac(uint64(m.Action))
	}
	if len(m.Policies) > 0 {
		for k, v := range m.Policies {
			_ = k
			_ = v
			l = 0
			if v != nil {
				l = v.Size()
				l += 1 + sovRbac(uint64(l))
			}
			mapEntrySize := 1 + len(k) + sovRbac(uint64(len(k))) + l
			n += mapEntrySize + 1 + sovRbac(uint64(mapEntrySize))
		}
	}
	return n
}

func (m *Policy) Size() (n int) {
	var l int
	_ = l
	if len(m.Permissions) > 0 {
		for _, e := range m.Permissions {
			l = e.Size()
			n += 1 + l + sovRbac(uint64(l))
		}
	}
	if len(m.Principals) > 0 {
		for _, e := range m.Principals {
			l = e.Size()
			n += 1 + l + sovRbac(uint64(l))
		}
	}
	return n
}

func (m *Permission) Size() (n int) {
	var l int
	_ = l
	if m.Rule != nil {
		n += m.Rule.Size()
	}
	return n
}

func (m *Permission_AndRules) Size() (n int) {
	var l int
	_ = l
	if m.AndRules != nil {
		l = m.AndRules.Size()
		n += 1 + l + sovRbac(uint64(l))
	}
	return n
}
func (m *Permission_OrRules) Size() (n int) {
	var l int
	_ = l
	if m.OrRules != nil {
		l = m.OrRules.Size()
		n += 1 + l + sovRbac(uint64(l))
	}
	return n
}
func (m *Permission_Any) Size() (n int) {
	var l int
	_ = l
	n += 2
	return n
}
func (m *Permission_Header) Size() (n int) {
	var l int
	_ = l
	if m.Header != nil {
		l = m.Header.Size()
		n += 1 + l + sovRbac(uint64(l))
	}
	return n
}
func (m *Permission_DestinationIp) Size() (n int) {
	var l int
	_ = l
	if m.DestinationIp != nil {
		l = m.DestinationIp.Size()
		n += 1 + l + sovRbac(uint64(l))
	}
	return n
}
func (m *Permission_DestinationPort) Size() (n int) {
	var l int
	_ = l
	n += 1 + sovRbac(uint64(m.DestinationPort))
	return n
}
func (m *Permission_Metadata) Size() (n int) {
	var l int
	_ = l
	if m.Metadata != nil {
		l = m.Metadata.Size()
		n += 1 + l + sovRbac(uint64(l))
	}
	return n
}
func (m *Permission_NotRule) Size() (n int) {
	var l int
	_ = l
	if m.NotRule != nil {
		l = m.NotRule.Size()
		n += 1 + l + sovRbac(uint64(l))
	}
	return n
}
func (m *Permission_Set) Size() (n int) {
	var l int
	_ = l
	if len(m.Rules) > 0 {
		for _, e := range m.Rules {
			l = e.Size()
			n += 1 + l + sovRbac(uint64(l))
		}
	}
	return n
}

func (m *Principal) Size() (n int) {
	var l int
	_ = l
	if m.Identifier != nil {
		n += m.Identifier.Size()
	}
	return n
}

func (m *Principal_AndIds) Size() (n int) {
	var l int
	_ = l
	if m.AndIds != nil {
		l = m.AndIds.Size()
		n += 1 + l + sovRbac(uint64(l))
	}
	return n
}
func (m *Principal_OrIds) Size() (n int) {
	var l int
	_ = l
	if m.OrIds != nil {
		l = m.OrIds.Size()
		n += 1 + l + sovRbac(uint64(l))
	}
	return n
}
func (m *Principal_Any) Size() (n int) {
	var l int
	_ = l
	n += 2
	return n
}
func (m *Principal_Authenticated_) Size() (n int) {
	var l int
	_ = l
	if m.Authenticated != nil {
		l = m.Authenticated.Size()
		n += 1 + l + sovRbac(uint64(l))
	}
	return n
}
func (m *Principal_SourceIp) Size() (n int) {
	var l int
	_ = l
	if m.SourceIp != nil {
		l = m.SourceIp.Size()
		n += 1 + l + sovRbac(uint64(l))
	}
	return n
}
func (m *Principal_Header) Size() (n int) {
	var l int
	_ = l
	if m.Header != nil {
		l = m.Header.Size()
		n += 1 + l + sovRbac(uint64(l))
	}
	return n
}
func (m *Principal_Metadata) Size() (n int) {
	var l int
	_ = l
	if m.Metadata != nil {
		l = m.Metadata.Size()
		n += 1 + l + sovRbac(uint64(l))
	}
	return n
}
func (m *Principal_NotId) Size() (n int) {
	var l int
	_ = l
	if m.NotId != nil {
		l = m.NotId.Size()
		n += 1 + l + sovRbac(uint64(l))
	}
	return n
}
func (m *Principal_Set) Size() (n int) {
	var l int
	_ = l
	if len(m.Ids) > 0 {
		for _, e := range m.Ids {
			l = e.Size()
			n += 1 + l + sovRbac(uint64(l))
		}
	}
	return n
}

func (m *Principal_Authenticated) Size() (n int) {
	var l int
	_ = l
	l = len(m.Name)
	if l > 0 {
		n += 1 + l + sovRbac(uint64(l))
	}
	return n
}

func sovRbac(x uint64) (n int) {
	for {
		n++
		x >>= 7
		if x == 0 {
			break
		}
	}
	return n
}
func sozRbac(x uint64) (n int) {
	return sovRbac(uint64((x << 1) ^ uint64((int64(x) >> 63))))
}
func (m *RBAC) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowRbac
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= (uint64(b) & 0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: RBAC: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: RBAC: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field Action", wireType)
			}
			m.Action = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowRbac
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				m.Action |= (RBAC_Action(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		case 2:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Policies", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowRbac
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthRbac
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.Policies == nil {
				m.Policies = make(map[string]*Policy)
			}
			var mapkey string
			var mapvalue *Policy
			for iNdEx < postIndex {
				entryPreIndex := iNdEx
				var wire uint64
				for shift := uint(0); ; shift += 7 {
					if shift >= 64 {
						return ErrIntOverflowRbac
					}
					if iNdEx >= l {
						return io.ErrUnexpectedEOF
					}
					b := dAtA[iNdEx]
					iNdEx++
					wire |= (uint64(b) & 0x7F) << shift
					if b < 0x80 {
						break
					}
				}
				fieldNum := int32(wire >> 3)
				if fieldNum == 1 {
					var stringLenmapkey uint64
					for shift := uint(0); ; shift += 7 {
						if shift >= 64 {
							return ErrIntOverflowRbac
						}
						if iNdEx >= l {
							return io.ErrUnexpectedEOF
						}
						b := dAtA[iNdEx]
						iNdEx++
						stringLenmapkey |= (uint64(b) & 0x7F) << shift
						if b < 0x80 {
							break
						}
					}
					intStringLenmapkey := int(stringLenmapkey)
					if intStringLenmapkey < 0 {
						return ErrInvalidLengthRbac
					}
					postStringIndexmapkey := iNdEx + intStringLenmapkey
					if postStringIndexmapkey > l {
						return io.ErrUnexpectedEOF
					}
					mapkey = string(dAtA[iNdEx:postStringIndexmapkey])
					iNdEx = postStringIndexmapkey
				} else if fieldNum == 2 {
					var mapmsglen int
					for shift := uint(0); ; shift += 7 {
						if shift >= 64 {
							return ErrIntOverflowRbac
						}
						if iNdEx >= l {
							return io.ErrUnexpectedEOF
						}
						b := dAtA[iNdEx]
						iNdEx++
						mapmsglen |= (int(b) & 0x7F) << shift
						if b < 0x80 {
							break
						}
					}
					if mapmsglen < 0 {
						return ErrInvalidLengthRbac
					}
					postmsgIndex := iNdEx + mapmsglen
					if mapmsglen < 0 {
						return ErrInvalidLengthRbac
					}
					if postmsgIndex > l {
						return io.ErrUnexpectedEOF
					}
					mapvalue = &Policy{}
					if err := mapvalue.Unmarshal(dAtA[iNdEx:postmsgIndex]); err != nil {
						return err
					}
					iNdEx = postmsgIndex
				} else {
					iNdEx = entryPreIndex
					skippy, err := skipRbac(dAtA[iNdEx:])
					if err != nil {
						return err
					}
					if skippy < 0 {
						return ErrInvalidLengthRbac
					}
					if (iNdEx + skippy) > postIndex {
						return io.ErrUnexpectedEOF
					}
					iNdEx += skippy
				}
			}
			m.Policies[mapkey] = mapvalue
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipRbac(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthRbac
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *Policy) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowRbac
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= (uint64(b) & 0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: Policy: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: Policy: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Permissions", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowRbac
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthRbac
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Permissions = append(m.Permissions, &Permission{})
			if err := m.Permissions[len(m.Permissions)-1].Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 2:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Principals", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowRbac
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthRbac
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Principals = append(m.Principals, &Principal{})
			if err := m.Principals[len(m.Principals)-1].Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipRbac(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthRbac
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *Permission) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowRbac
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= (uint64(b) & 0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: Permission: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: Permission: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field AndRules", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowRbac
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthRbac
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			v := &Permission_Set{}
			if err := v.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			m.Rule = &Permission_AndRules{v}
			iNdEx = postIndex
		case 2:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field OrRules", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowRbac
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthRbac
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			v := &Permission_Set{}
			if err := v.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			m.Rule = &Permission_OrRules{v}
			iNdEx = postIndex
		case 3:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field Any", wireType)
			}
			var v int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowRbac
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				v |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			b := bool(v != 0)
			m.Rule = &Permission_Any{b}
		case 4:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Header", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowRbac
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthRbac
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			v := &envoy_api_v2_route.HeaderMatcher{}
			if err := v.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			m.Rule = &Permission_Header{v}
			iNdEx = postIndex
		case 5:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field DestinationIp", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowRbac
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthRbac
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			v := &envoy_api_v2_core1.CidrRange{}
			if err := v.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			m.Rule = &Permission_DestinationIp{v}
			iNdEx = postIndex
		case 6:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field DestinationPort", wireType)
			}
			var v uint32
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowRbac
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				v |= (uint32(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			m.Rule = &Permission_DestinationPort{v}
		case 7:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Metadata", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowRbac
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthRbac
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			v := &envoy_type_matcher2.MetadataMatcher{}
			if err := v.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			m.Rule = &Permission_Metadata{v}
			iNdEx = postIndex
		case 8:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field NotRule", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowRbac
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthRbac
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			v := &Permission{}
			if err := v.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			m.Rule = &Permission_NotRule{v}
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipRbac(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthRbac
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *Permission_Set) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowRbac
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= (uint64(b) & 0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: Set: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: Set: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Rules", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowRbac
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthRbac
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Rules = append(m.Rules, &Permission{})
			if err := m.Rules[len(m.Rules)-1].Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipRbac(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthRbac
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *Principal) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowRbac
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= (uint64(b) & 0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: Principal: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: Principal: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field AndIds", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowRbac
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthRbac
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			v := &Principal_Set{}
			if err := v.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			m.Identifier = &Principal_AndIds{v}
			iNdEx = postIndex
		case 2:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field OrIds", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowRbac
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthRbac
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			v := &Principal_Set{}
			if err := v.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			m.Identifier = &Principal_OrIds{v}
			iNdEx = postIndex
		case 3:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field Any", wireType)
			}
			var v int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowRbac
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				v |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			b := bool(v != 0)
			m.Identifier = &Principal_Any{b}
		case 4:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Authenticated", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowRbac
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthRbac
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			v := &Principal_Authenticated{}
			if err := v.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			m.Identifier = &Principal_Authenticated_{v}
			iNdEx = postIndex
		case 5:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field SourceIp", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowRbac
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthRbac
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			v := &envoy_api_v2_core1.CidrRange{}
			if err := v.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			m.Identifier = &Principal_SourceIp{v}
			iNdEx = postIndex
		case 6:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Header", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowRbac
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthRbac
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			v := &envoy_api_v2_route.HeaderMatcher{}
			if err := v.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			m.Identifier = &Principal_Header{v}
			iNdEx = postIndex
		case 7:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Metadata", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowRbac
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthRbac
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			v := &envoy_type_matcher2.MetadataMatcher{}
			if err := v.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			m.Identifier = &Principal_Metadata{v}
			iNdEx = postIndex
		case 8:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field NotId", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowRbac
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthRbac
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			v := &Principal{}
			if err := v.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			m.Identifier = &Principal_NotId{v}
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipRbac(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthRbac
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *Principal_Set) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowRbac
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= (uint64(b) & 0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: Set: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: Set: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Ids", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowRbac
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthRbac
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Ids = append(m.Ids, &Principal{})
			if err := m.Ids[len(m.Ids)-1].Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipRbac(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthRbac
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *Principal_Authenticated) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowRbac
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= (uint64(b) & 0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: Authenticated: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: Authenticated: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Name", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowRbac
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= (uint64(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthRbac
			}
			postIndex := iNdEx + intStringLen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Name = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipRbac(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthRbac
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func skipRbac(dAtA []byte) (n int, err error) {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return 0, ErrIntOverflowRbac
			}
			if iNdEx >= l {
				return 0, io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= (uint64(b) & 0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		wireType := int(wire & 0x7)
		switch wireType {
		case 0:
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return 0, ErrIntOverflowRbac
				}
				if iNdEx >= l {
					return 0, io.ErrUnexpectedEOF
				}
				iNdEx++
				if dAtA[iNdEx-1] < 0x80 {
					break
				}
			}
			return iNdEx, nil
		case 1:
			iNdEx += 8
			return iNdEx, nil
		case 2:
			var length int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return 0, ErrIntOverflowRbac
				}
				if iNdEx >= l {
					return 0, io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				length |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			iNdEx += length
			if length < 0 {
				return 0, ErrInvalidLengthRbac
			}
			return iNdEx, nil
		case 3:
			for {
				var innerWire uint64
				var start int = iNdEx
				for shift := uint(0); ; shift += 7 {
					if shift >= 64 {
						return 0, ErrIntOverflowRbac
					}
					if iNdEx >= l {
						return 0, io.ErrUnexpectedEOF
					}
					b := dAtA[iNdEx]
					iNdEx++
					innerWire |= (uint64(b) & 0x7F) << shift
					if b < 0x80 {
						break
					}
				}
				innerWireType := int(innerWire & 0x7)
				if innerWireType == 4 {
					break
				}
				next, err := skipRbac(dAtA[start:])
				if err != nil {
					return 0, err
				}
				iNdEx = start + next
			}
			return iNdEx, nil
		case 4:
			return iNdEx, nil
		case 5:
			iNdEx += 4
			return iNdEx, nil
		default:
			return 0, fmt.Errorf("proto: illegal wireType %d", wireType)
		}
	}
	panic("unreachable")
}

var (
	ErrInvalidLengthRbac = fmt.Errorf("proto: negative length found during unmarshaling")
	ErrIntOverflowRbac   = fmt.Errorf("proto: integer overflow")
)

func init() { proto.RegisterFile("envoy/config/rbac/v2alpha/rbac.proto", fileDescriptorRbac) }

var fileDescriptorRbac = []byte{
	// 783 bytes of a gzipped FileDescriptorProto
	0x1f, 0x8b, 0x08, 0x00, 0x00, 0x00, 0x00, 0x00, 0x02, 0xff, 0xac, 0x95, 0x4f, 0x8f, 0x1b, 0x35,
	0x18, 0xc6, 0xe3, 0x4c, 0x66, 0x76, 0xf2, 0x46, 0x29, 0x2b, 0x23, 0xc4, 0x10, 0xd1, 0x25, 0x4d,
	0x0b, 0x0a, 0x48, 0xcc, 0x48, 0xc3, 0x81, 0x8a, 0x0a, 0xa4, 0xcc, 0xb2, 0x90, 0x48, 0x6d, 0x59,
	0xcd, 0x1e, 0x10, 0x3d, 0x50, 0xb9, 0x63, 0xb7, 0x6b, 0xc8, 0xda, 0x23, 0x8f, 0x13, 0x29, 0x9f,
	0x02, 0xc4, 0x17, 0xe1, 0x8a, 0x38, 0xf5, 0xc8, 0x91, 0x8f, 0x00, 0x7b, 0xeb, 0xa7, 0x28, 0xf2,
	0x9f, 0x6c, 0x93, 0x03, 0xdb, 0xec, 0xaa, 0x97, 0xc8, 0x89, 0x9f, 0xe7, 0x79, 0xed, 0xd7, 0x3f,
	0x3b, 0x70, 0x87, 0x89, 0xa5, 0x5c, 0x65, 0x95, 0x14, 0x4f, 0xf9, 0xb3, 0x4c, 0x3d, 0x21, 0x55,
	0xb6, 0xcc, 0xc9, 0xbc, 0x3e, 0x25, 0xf6, 0x4b, 0x5a, 0x2b, 0xa9, 0x25, 0x7e, 0xcf, 0xaa, 0x52,
	0xa7, 0x4a, 0xed, 0x84, 0x57, 0x0d, 0xde, 0x5d, 0x92, 0x39, 0xa7, 0x44, 0xb3, 0x6c, 0x3d, 0x70,
	0x9e, 0xc1, 0x07, 0x2e, 0x99, 0xd4, 0x3c, 0x5b, 0xe6, 0x59, 0x25, 0x15, 0xcb, 0x08, 0xa5, 0x8a,
	0x35, 0x8d, 0x17, 0x1c, 0x6c, 0x09, 0x94, 0x5c, 0x68, 0xe6, 0x3e, 0xfd, 0xfc, 0x2d, 0x37, 0xaf,
	0x57, 0x35, 0xcb, 0xce, 0x88, 0xae, 0x4e, 0x99, 0xca, 0xce, 0x98, 0x26, 0x94, 0x68, 0xe2, 0x24,
	0xa3, 0x5f, 0xdb, 0xd0, 0x29, 0x8b, 0xc9, 0x21, 0xfe, 0x0a, 0x22, 0x52, 0x69, 0x2e, 0x45, 0x82,
	0x86, 0x68, 0x7c, 0x23, 0xff, 0x28, 0xfd, 0xdf, 0x15, 0xa7, 0xc6, 0x90, 0x4e, 0xac, 0xba, 0xf4,
	0x2e, 0x3c, 0x83, 0xb8, 0x96, 0x73, 0x5e, 0x71, 0xd6, 0x24, 0xed, 0x61, 0x30, 0xee, 0xe5, 0x9f,
	0xbe, 0x2e, 0xe1, 0xd8, 0xeb, 0x8f, 0x84, 0x56, 0xab, 0xf2, 0xc2, 0x3e, 0xf8, 0x11, 0xfa, 0x5b,
	0x53, 0x78, 0x1f, 0x82, 0x9f, 0xd9, 0xca, 0x2e, 0xac, 0x5b, 0x9a, 0x21, 0xfe, 0x1c, 0xc2, 0x25,
	0x99, 0x2f, 0x58, 0xd2, 0x1e, 0xa2, 0x71, 0x2f, 0xbf, 0x75, 0x49, 0x29, 0x1b, 0xb5, 0x2a, 0x9d,
	0xfe, 0x8b, 0xf6, 0x5d, 0x34, 0xba, 0x09, 0x91, 0x5b, 0x3c, 0xee, 0x42, 0x38, 0xb9, 0x7f, 0xff,
	0xbb, 0xef, 0xf7, 0x5b, 0x38, 0x86, 0xce, 0xd7, 0x47, 0x0f, 0x7f, 0xd8, 0x47, 0xa3, 0xdf, 0x11,
	0x44, 0xce, 0x84, 0x4f, 0xa0, 0x57, 0x33, 0x75, 0xc6, 0x9b, 0x86, 0x4b, 0xd1, 0x24, 0xc8, 0xee,
	0xeb, 0xc3, 0xcb, 0x8a, 0x5d, 0xa8, 0x0b, 0xf8, 0xf3, 0xc5, 0xf3, 0x20, 0xfc, 0x0d, 0xb5, 0x63,
	0x54, 0x6e, 0xa6, 0xe0, 0x63, 0x80, 0x5a, 0x71, 0x51, 0xf1, 0x9a, 0xcc, 0xd7, 0xbd, 0xba, 0x73,
	0x59, 0xe6, 0x5a, 0xbc, 0x15, 0xb9, 0x91, 0x31, 0xfa, 0xb7, 0x03, 0xf0, 0xaa, 0x32, 0x9e, 0x42,
	0x97, 0x08, 0xfa, 0x58, 0x2d, 0xe6, 0xac, 0xb1, 0x4d, 0xeb, 0xe5, 0x1f, 0xef, 0xb4, 0xe6, 0xf4,
	0x84, 0xe9, 0x69, 0xab, 0x8c, 0x89, 0xa0, 0xa5, 0x31, 0xe3, 0x6f, 0x20, 0x96, 0xca, 0x07, 0xb5,
	0xaf, 0x1e, 0xb4, 0x27, 0x95, 0xcb, 0xb9, 0x09, 0x01, 0x11, 0xab, 0x24, 0x18, 0xa2, 0x71, 0x5c,
	0x74, 0xcd, 0x2e, 0x3a, 0x3f, 0xb5, 0x63, 0x34, 0x6d, 0x95, 0xe6, 0x77, 0x7c, 0x0f, 0xa2, 0x53,
	0x46, 0x28, 0x53, 0x49, 0x67, 0xeb, 0x38, 0x49, 0xcd, 0xd3, 0x65, 0x9e, 0x3a, 0xa4, 0xa7, 0x56,
	0xf1, 0xc0, 0x61, 0x3c, 0x6d, 0x95, 0xde, 0x82, 0x8f, 0xe0, 0x06, 0x65, 0x8d, 0xe6, 0x82, 0x98,
	0x23, 0x7d, 0xcc, 0xeb, 0x24, 0xb4, 0x21, 0xef, 0x6f, 0x87, 0x98, 0xeb, 0x93, 0x1e, 0x72, 0xaa,
	0x4a, 0x22, 0x9e, 0xb1, 0x69, 0xab, 0xec, 0x6f, 0xb8, 0x66, 0x35, 0xbe, 0x0b, 0xfb, 0x9b, 0x31,
	0xb5, 0x54, 0x3a, 0x89, 0x86, 0x68, 0xdc, 0x2f, 0x7a, 0x66, 0xbd, 0xd1, 0x27, 0x9d, 0xe4, 0xe5,
	0xcb, 0x60, 0xda, 0x2a, 0xdf, 0xda, 0x90, 0x1d, 0x4b, 0xa5, 0xf1, 0x04, 0xe2, 0xf5, 0xa5, 0x4a,
	0xf6, 0x6c, 0xe9, 0xdb, 0xbe, 0xb4, 0xb9, 0x78, 0xa9, 0xbf, 0x78, 0xe9, 0x03, 0xaf, 0x79, 0xb5,
	0x83, 0x0b, 0x1b, 0x2e, 0x20, 0x16, 0x52, 0xdb, 0x46, 0x27, 0xb1, 0x8d, 0xd8, 0x0d, 0x32, 0xd3,
	0x63, 0x21, 0xb5, 0x69, 0xf2, 0xe0, 0x21, 0x04, 0x27, 0x4c, 0xe3, 0x6f, 0x21, 0x5c, 0x1f, 0xfc,
	0x35, 0x61, 0x75, 0xfe, 0xa2, 0x0f, 0x1d, 0x33, 0xc0, 0xe1, 0x1f, 0x2f, 0x9e, 0x07, 0x68, 0xf4,
	0x4b, 0x08, 0xdd, 0x0b, 0x12, 0xf1, 0x21, 0xec, 0x19, 0xc4, 0x38, 0x5d, 0x03, 0x36, 0xde, 0x05,
	0x60, 0x8f, 0x45, 0x44, 0x04, 0x9d, 0xd1, 0x06, 0x4f, 0x20, 0x92, 0xca, 0x66, 0xb4, 0xaf, 0x9c,
	0x11, 0x4a, 0x65, 0x22, 0x5e, 0x03, 0xd6, 0x23, 0xe8, 0x93, 0x85, 0x3e, 0x65, 0x42, 0xf3, 0x8a,
	0x68, 0x46, 0x3d, 0x5f, 0xf9, 0x4e, 0x85, 0x26, 0x9b, 0x4e, 0x03, 0xcc, 0x56, 0x14, 0xbe, 0x07,
	0xdd, 0x46, 0x2e, 0x54, 0xc5, 0x76, 0x47, 0x2e, 0x76, 0x86, 0x59, 0xbd, 0x41, 0x7c, 0x74, 0x75,
	0xe2, 0xdf, 0x00, 0x70, 0x5f, 0x42, 0x64, 0x80, 0xe3, 0xd4, 0xe3, 0xb6, 0xd3, 0xfb, 0x63, 0xda,
	0x2e, 0xa4, 0x9e, 0xd1, 0xc1, 0xcc, 0xb1, 0x56, 0x40, 0xe0, 0x08, 0xb8, 0xde, 0x13, 0x66, 0xcc,
	0x83, 0xdb, 0xd0, 0xdf, 0x6a, 0x34, 0xc6, 0xd0, 0x11, 0xe4, 0x8c, 0xf9, 0xd7, 0xde, 0x8e, 0x8b,
	0xb7, 0x01, 0x38, 0x35, 0x92, 0xa7, 0x9c, 0x29, 0x4f, 0x64, 0xf1, 0xce, 0x5f, 0xe7, 0x07, 0xe8,
	0xef, 0xf3, 0x03, 0xf4, 0xcf, 0xf9, 0x01, 0x7a, 0xb4, 0xe7, 0x6b, 0x3d, 0x89, 0xec, 0x1f, 0xdb,
	0x67, 0xff, 0x05, 0x00, 0x00, 0xff, 0xff, 0x50, 0xff, 0x2e, 0xf7, 0x98, 0x07, 0x00, 0x00,
}
